# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist, validator
from twitter_openapi_python_generated.models.callback import Callback
from twitter_openapi_python_generated.models.cta_client_event_info import CtaClientEventInfo
from twitter_openapi_python_generated.models.timeline_cover_behavior import TimelineCoverBehavior

class CoverCta(BaseModel):
    """
    CoverCta
    """
    text: Optional[StrictStr] = Field(None, alias="Text")
    button_style: Optional[StrictStr] = Field(None, alias="buttonStyle")
    callbacks: conlist(Callback) = Field(...)
    client_event_info: CtaClientEventInfo = Field(..., alias="clientEventInfo")
    cta_behavior: TimelineCoverBehavior = Field(..., alias="ctaBehavior")
    __properties = ["Text", "buttonStyle", "callbacks", "clientEventInfo", "ctaBehavior"]

    @validator('button_style')
    def button_style_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Primary'):
            raise ValueError("must be one of enum values ('Primary')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CoverCta:
        """Create an instance of CoverCta from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in callbacks (list)
        _items = []
        if self.callbacks:
            for _item in self.callbacks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['callbacks'] = _items
        # override the default output from pydantic by calling `to_dict()` of client_event_info
        if self.client_event_info:
            _dict['clientEventInfo'] = self.client_event_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cta_behavior
        if self.cta_behavior:
            _dict['ctaBehavior'] = self.cta_behavior.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CoverCta:
        """Create an instance of CoverCta from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CoverCta.parse_obj(obj)

        _obj = CoverCta.parse_obj({
            "text": obj.get("Text"),
            "button_style": obj.get("buttonStyle"),
            "callbacks": [Callback.from_dict(_item) for _item in obj.get("callbacks")] if obj.get("callbacks") is not None else None,
            "client_event_info": CtaClientEventInfo.from_dict(obj.get("clientEventInfo")) if obj.get("clientEventInfo") is not None else None,
            "cta_behavior": TimelineCoverBehavior.from_dict(obj.get("ctaBehavior")) if obj.get("ctaBehavior") is not None else None
        })
        return _obj


