# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['finary_assistant',
 'finary_assistant.copilot',
 'finary_assistant.fetch',
 'finary_assistant.portfolio',
 'finary_assistant.simulator']

package_data = \
{'': ['*']}

install_requires = \
['docopt==0.6.2', 'fuzzywuzzy==0.18.0', 'requests==2.28.2', 'rich==12.0.1']

setup_kwargs = {
    'name': 'finary-assistant',
    'version': '0.1.3',
    'description': 'A command line investment assistant to organize your portfolio and simulate its future to reach your life goals.',
    'long_description': '<h1 align="center">\n  <a href="https://github.com/MadeInPierre/finary_assistant">\n    <img src="https://github.com/MadeInPierre/finary_assistant/raw/main/doc/logo_assistant_transparent.png" width="400" />\n  </a>\n  <br>Finary Assistant<br>\n</h1>\n\n<div align="center">\n  <h4>\n    Minimalistic command-line tool to help you manage your investments\n  </h4>\n\n  <sub>Built with ❤︎ by\n  <a href="https://www.buymeacoffee.com/MadeInPierre">Pierre Laclau</a>\n  and <a href="https://github.com/MadeInPierre/finary_assistant/graphs/contributors">contributors</a>. \n  Logo generated by <a href="https://midjourney.com">Midjourney</a>.\n\n  [![PyPI version](https://badge.fury.io/py/finary-assistant.svg)](https://badge.fury.io/py/finary-assistant)\n\n  <br>\n</div>\n\nFinary Assistant is a command-line tool to organize your investments portfolio and get automated monthly investment recommendations based on your future life goals. \nThis tool synchronizes with your [Finary](https://finary.com/) account to show real-time investment values. \n\nDon\'t have Finary yet? You can sign up using my [referral link](https://finary.com/referral/f8d349c922d1e1c8f0d2) :sparkles: (or through the [default](https://finary.com/signup) page).\n\n<p align="center">\n  <img src="https://github.com/MadeInPierre/finary_assistant/raw/main/doc/screenshot.png" width="500" />\n</p>\n\n## ✨ Features\n\n1. **✅ Portfolio:** Organize your assets, set targets, and sync with your Finary account.\n2. **⏳ Analyzer:** Generate global statistics and graphs to understand each line and folder.\n3. **⏳ Simulator:** Define your life goals and events, simulate your portfolio\'s future.\n4. **⏳ Assistant:** Get monthly recommendations on where to invest next to meet your goals.\n5. **🙏 Extensions:** Make this tool work for other people\'s situations. Contributions needed!\n6. **🙏 Optional:** Nice but out-of-my-skills or time-consuming features. Any volunteers?\n\nYou can check the [current development status](./doc/TODO.md). Contributions are warmly welcome!\n\n## 🚀 Installation\n### Users\nIf you don\'t plan on touching the code, simply run (with python 3.8 and pip installed):\n```sh\npip install finary_assistant\n```\n\nAnd you\'re done! Now create your own copy of the [`demo.py`](./examples/demo.py) example anywhere. You can try to run the demo first to make sure everything works. Now go customize it for your own needs 🚀\n\n**Pro Tip:** _Why not setup a script to autorun this project in a new terminal at startup? Could be a nice view_ 🤭\n\n### Contributors\n1. Clone this repository using the `--recursive` option to include [`finary_api`](https://github.com/lasconic/finary):\n```sh\ngit clone --recursive https://github.com/MadeInPierre/finary_assistant.git\n# If you forgot --recursive: git submodule update --init --recursive\n```\n2. Install the project in editable mode:\n```sh\ncd finary_assistant && pip install -e .\n```\n3. Try the assistant with:\n```sh\npython examples/demo.py\n```\nIf you see a template portfolio tree and your investments detected from Finary, then welcome to the (small) team! 🎉 Now create your own copy of the demo file and go customize it for your own needs (the name `assistant_config` is recommended as it is ignored from git):\n```sh\ncp examples/demo.py assistant_config.py # <- Your own portfolio here\n```\n\n## ⚙️ Usage \nThe goal is to declare a tree structure of your entire portfolio investments independently from their host envelopes (e.g. PEA, AV, CTO, etc). Define your own asset-based global strategy without feeling constrainted by keeping similar assets in common envelopes. Once your entire portfolio strategy is defined here, find the best envelope for each line and add them to your Finary account (manual or automatic sync). Assistant will fetch each line and display your full portfolio with real-time amounts.\n\nTo create your portfolio, start with a `Portfolio` object which holds a nested list of `Line`, `Folder`, and `SharedFolder` objects:\n- `Line` represents each individual investment. Set the `key` parameter as the name shown in your Finary account if different from the display name.\n- `Folder` holds a group of lines or subfolders to create a structure.\n- `SharedFolder` accepts a `Bucket` object which groups multiple lines as a single object. You can reference the same bucket multiple times in the tree and set different `bucket_amount` for each shared folder. Each folder will only take the provided amount and let others use the rest.\n\nFinally, any object in the structure accepts an optional `Target`. See the implementation guidelines below.\n\n#### Example\n\nHere is an example of a portfolio structure:\n```python\n# Create a list of Lines that will be considered as a single Line.\nmy_bucket = Bucket([\n  Line(\'My Asset 1\', key=\'name_in_finary\'),\n  Line(\'My Asset 2\', key=\'name_in_finary\'),\n  # ...\n])\n\n# Define your entire portfolio structure\nportfolio = Portfolio(\'My Portfolio\', children=[\n  # Add a list of `Line`, `Folder`, and `SharedFolder` objects\n  Folder(\'Short term\', children=[\n    Line(\'My Asset 3\', key=\'name_in_finary\'),\n    SharedFolder(\'My Folder\', bucket=my_bucket, bucket_amount=1000),\n    # ...\n  ]),\n  Folder(\'Long term\', children=[\n    # Folders can be displayed as Expanded (default), Collapsed, or as a Line\n    Folder(\'Stocks\', display=FolderDisplay.COLLAPSED, children=[\n      SharedFolder(\'My Folder\', bucket=my_bucket), # display what\'s left in the bucket\n      # ...\n    ]),\n    # ...\n  ])\n])\n```\n\n#### Targets\nAny node in the tree accepts an optional `target` parameter. See the full list of available targets [here](./finary_assistant/portfolio/targets.py). Here is an example:\n\n```python\nFolder(\'Stocks\', target=TargetMin(2000, tolerance=500), children=[\n  Line(\'ETF World\', key=\'Amundi ETF ...\', target=TargetRatio(80, tolerance=5)), \n  # ... Other lines with the remaining 20% of the Stocks folder.\n])\n```\n\n## 👨\u200d💻 Contributions\nThis repository is at a very early stage. If you\'d like to contribute, please open an issue and ask me to write a detailed documentation! For new features or bug fixes, please fork the repository and use a feature branch. Please use the [conventional commits](https://www.conventionalcommits.org/en/v1.0.0/) guidelines for your commit messages. Pull requests, [issues](https://github.com/MadeInPierre/finary_assistant/issues/new) and [open discussions](https://github.com/MadeInPierre/finary_assistant/discussions/new) are warmly welcome!\n\nUnfortunately, I won\'t have time to make this tool work for everyone by default, but you are welcome to extend this project yourself (or [hire me](https://www.buymeacoffee.com/MadeInPierre/commissions) if you can\'t develop it yourself). Pull requests are welcome to create a useful tool for everyone!\n\n## 📄 License\nThis project is under the [GPLv3 License](./LICENSE) meaning anyone can use, share, extend, and contribute to this project as long as their changes are integrated to this repo or also published using GPLv3. Please contact me for any specific licensing requests.\n\n## 💌 Donations\n[<img align="right" src="https://www.mathisplumail.com/wp-content/uploads/2021/04/coffee.png" width="161" />](https://www.buymeacoffee.com/MadeInPierre)\nThis is a personal project I have fun with on my free time. If you found it useful and wish to support my work, you can [buy me a coffee](https://www.buymeacoffee.com/MadeInPierre)! It would give me the motivation to keep improving it further :smile: Thank you!\n\n<!-- Breaking: :boom:\n\nMinor: :sparkles::children_crossing::lipstick::iphone::egg::chart_with_upwards_trend:\n\nPatch: :ambulance::lock::bug::zap::goal_net::alien::wheelchair::speech_balloon::mag::apple::penguin::checkered_flag::robot::green_apple: -->\n',
    'author': 'MadeInPierre',
    'author_email': 'pielaclau@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
