"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatadogIntegrationAWS = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
// eslint-disable-next-line @typescript-eslint/no-require-imports
const camelcaseKeys = require("camelcase-keys");
/**
 * Datadog Integration 1.1.0.
 *
 * @stability stable
 */
class DatadogIntegrationAWS {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        const cfnProperties = camelcaseKeys(props, {
            deep: true,
            pascalCase: true,
        });
        // @ts-ignore
        delete Object.assign(cfnProperties, { AccountID: cfnProperties.AccountId }).AccountId;
        new core_1.CfnResource(scope, id, {
            type: 'Datadog::Integrations::AWS',
            properties: { ...cfnProperties },
        });
    }
}
exports.DatadogIntegrationAWS = DatadogIntegrationAWS;
_a = JSII_RTTI_SYMBOL_1;
DatadogIntegrationAWS[_a] = { fqn: "@nomadblacky/cdk-datadog-resources.DatadogIntegrationAWS", version: "0.2.42" };
//# sourceMappingURL=data:application/json;base64,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