# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from aliyunsdkcore.request import RpcRequest
from aliyunsdkconfig.endpoint import endpoint_data

class ListConfigRulesRequest(RpcRequest):

	def __init__(self):
		RpcRequest.__init__(self, 'Config', '2019-01-08', 'ListConfigRules')
		self.set_method('POST')

		if hasattr(self, "endpoint_map"):
			setattr(self, "endpoint_map", endpoint_data.getEndpointMap())
		if hasattr(self, "endpoint_regional"):
			setattr(self, "endpoint_regional", endpoint_data.getEndpointRegional())

	def get_MultiAccount(self): # Boolean
		return self.get_query_params().get('MultiAccount')

	def set_MultiAccount(self, MultiAccount):  # Boolean
		self.add_query_param('MultiAccount', MultiAccount)
	def get_ConfigRuleState(self): # String
		return self.get_query_params().get('ConfigRuleState')

	def set_ConfigRuleState(self, ConfigRuleState):  # String
		self.add_query_param('ConfigRuleState', ConfigRuleState)
	def get_PageNumber(self): # Integer
		return self.get_query_params().get('PageNumber')

	def set_PageNumber(self, PageNumber):  # Integer
		self.add_query_param('PageNumber', PageNumber)
	def get_PageSize(self): # Integer
		return self.get_query_params().get('PageSize')

	def set_PageSize(self, PageSize):  # Integer
		self.add_query_param('PageSize', PageSize)
	def get_CompliancePackId(self): # String
		return self.get_query_params().get('CompliancePackId')

	def set_CompliancePackId(self, CompliancePackId):  # String
		self.add_query_param('CompliancePackId', CompliancePackId)
	def get_ComplianceType(self): # String
		return self.get_query_params().get('ComplianceType')

	def set_ComplianceType(self, ComplianceType):  # String
		self.add_query_param('ComplianceType', ComplianceType)
	def get_RiskLevel(self): # Integer
		return self.get_query_params().get('RiskLevel')

	def set_RiskLevel(self, RiskLevel):  # Integer
		self.add_query_param('RiskLevel', RiskLevel)
	def get_ConfigRuleName(self): # String
		return self.get_query_params().get('ConfigRuleName')

	def set_ConfigRuleName(self, ConfigRuleName):  # String
		self.add_query_param('ConfigRuleName', ConfigRuleName)
	def get_MemberId(self): # Long
		return self.get_query_params().get('MemberId')

	def set_MemberId(self, MemberId):  # Long
		self.add_query_param('MemberId', MemberId)
