# coding: utf-8

"""
    Xero Payroll NZ

    This is the Xero Payroll API for orgs in the NZ region.  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""

"""
    OpenAPI spec version: 2.10.4
"""

import importlib
import re  # noqa: F401

from xero_python import exceptions
from xero_python.api_client import ApiClient, ModelFinder

try:
    from .exception_handler import translate_status_exception
except ImportError:
    translate_status_exception = exceptions.translate_status_exception


class empty:
    """ empty object to mark optional parameter not set """


class PayrollNzApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    base_url = "https://api.xero.com/payroll.xro/2.0"
    models_module = importlib.import_module("xero_python.payrollnz.models")

    def __init__(self, api_client=None, base_url=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.base_url = base_url or self.base_url

    def get_resource_url(self, resource_path):
        """
        Combine API base url with resource specific path
        :param str resource_path: API endpoint specific path
        :return: str full resource path
        """
        return self.base_url + resource_path

    def get_model_finder(self):
        return ModelFinder(self.models_module)

    def approve_timesheet(
        self,
        xero_tenant_id,
        timesheet_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Approves a timesheet  # noqa: E501
        OAuth2 scope: payroll.timesheets
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str timesheet_id: Identifier for the timesheet (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: TimesheetObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `approve_timesheet`"
            )
        # verify the required parameter 'timesheet_id' is set
        if timesheet_id is None:
            raise ValueError(
                "Missing the required parameter `timesheet_id` "
                "when calling `approve_timesheet`"
            )

        collection_formats = {}
        path_params = {
            "TimesheetID": timesheet_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Timesheets/{TimesheetID}/Approve")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="TimesheetObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "approve_timesheet")

    def create_deduction(
        self,
        xero_tenant_id,
        deduction,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Creates a new deduction for a specific employee  # noqa: E501
        OAuth2 scope: payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param Deduction deduction: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: DeductionObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_deduction`"
            )
        # verify the required parameter 'deduction' is set
        if deduction is None:
            raise ValueError(
                "Missing the required parameter `deduction` "
                "when calling `create_deduction`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = deduction
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Deductions")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="DeductionObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_deduction")

    def create_earnings_rate(
        self,
        xero_tenant_id,
        earnings_rate,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Creates a new earnings rate  # noqa: E501
        OAuth2 scope: payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param EarningsRate earnings_rate: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EarningsRateObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_earnings_rate`"
            )
        # verify the required parameter 'earnings_rate' is set
        if earnings_rate is None:
            raise ValueError(
                "Missing the required parameter `earnings_rate` "
                "when calling `create_earnings_rate`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = earnings_rate
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/EarningsRates")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EarningsRateObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_earnings_rate")

    def create_employee(
        self,
        xero_tenant_id,
        employee,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Creates an employees  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param Employee employee: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_employee`"
            )
        # verify the required parameter 'employee' is set
        if employee is None:
            raise ValueError(
                "Missing the required parameter `employee` "
                "when calling `create_employee`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = employee
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_employee")

    def create_employee_earnings_template(
        self,
        xero_tenant_id,
        employee_id,
        earnings_template,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Creates earnings template records for an employee  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param EarningsTemplate earnings_template: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EarningsTemplateObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_employee_earnings_template`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `create_employee_earnings_template`"
            )
        # verify the required parameter 'earnings_template' is set
        if earnings_template is None:
            raise ValueError(
                "Missing the required parameter `earnings_template` "
                "when calling `create_employee_earnings_template`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = earnings_template
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeID}/PayTemplates/earnings")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EarningsTemplateObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "create_employee_earnings_template"
            )

    def create_employee_leave(
        self,
        xero_tenant_id,
        employee_id,
        employee_leave,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Creates leave records for a specific employee  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param EmployeeLeave employee_leave: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeLeaveObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_employee_leave`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `create_employee_leave`"
            )
        # verify the required parameter 'employee_leave' is set
        if employee_leave is None:
            raise ValueError(
                "Missing the required parameter `employee_leave` "
                "when calling `create_employee_leave`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = employee_leave
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeID}/Leave")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeLeaveObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_employee_leave")

    def create_employee_leave_setup(
        self,
        xero_tenant_id,
        employee_id,
        employee_leave_setup,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Creates a leave set-up for a specific employee. This is required before viewing, configuring and requesting leave for an employee  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param EmployeeLeaveSetup employee_leave_setup: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeLeaveSetupObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_employee_leave_setup`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `create_employee_leave_setup`"
            )
        # verify the required parameter 'employee_leave_setup' is set
        if employee_leave_setup is None:
            raise ValueError(
                "Missing the required parameter `employee_leave_setup` "
                "when calling `create_employee_leave_setup`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = employee_leave_setup
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeID}/leaveSetup")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeLeaveSetupObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_employee_leave_setup")

    def create_employee_leave_type(
        self,
        xero_tenant_id,
        employee_id,
        employee_leave_type,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Creates leave type records for a specific employee  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param EmployeeLeaveType employee_leave_type: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeLeaveTypeObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_employee_leave_type`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `create_employee_leave_type`"
            )
        # verify the required parameter 'employee_leave_type' is set
        if employee_leave_type is None:
            raise ValueError(
                "Missing the required parameter `employee_leave_type` "
                "when calling `create_employee_leave_type`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = employee_leave_type
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeID}/LeaveTypes")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeLeaveTypeObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_employee_leave_type")

    def create_employee_opening_balances(
        self,
        xero_tenant_id,
        employee_id,
        employee_opening_balance,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Creates opening balances for a specific employee  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param list[EmployeeOpeningBalance] employee_opening_balance: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeOpeningBalancesObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_employee_opening_balances`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `create_employee_opening_balances`"
            )
        # verify the required parameter 'employee_opening_balance' is set
        if employee_opening_balance is None:
            raise ValueError(
                "Missing the required parameter `employee_opening_balance` "
                "when calling `create_employee_opening_balances`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = employee_opening_balance
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeID}/openingBalances")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeOpeningBalancesObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "create_employee_opening_balances"
            )

    def create_employee_payment_method(
        self,
        xero_tenant_id,
        employee_id,
        payment_method,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Creates a payment method for an employee  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param PaymentMethod payment_method: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: PaymentMethodObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_employee_payment_method`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `create_employee_payment_method`"
            )
        # verify the required parameter 'payment_method' is set
        if payment_method is None:
            raise ValueError(
                "Missing the required parameter `payment_method` "
                "when calling `create_employee_payment_method`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = payment_method
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeID}/PaymentMethods")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="PaymentMethodObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "create_employee_payment_method"
            )

    def create_employee_salary_and_wage(
        self,
        xero_tenant_id,
        employee_id,
        salary_and_wage,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Creates an employee salary and wage record  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param SalaryAndWage salary_and_wage: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: SalaryAndWageObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_employee_salary_and_wage`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `create_employee_salary_and_wage`"
            )
        # verify the required parameter 'salary_and_wage' is set
        if salary_and_wage is None:
            raise ValueError(
                "Missing the required parameter `salary_and_wage` "
                "when calling `create_employee_salary_and_wage`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = salary_and_wage
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeID}/SalaryAndWages")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="SalaryAndWageObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "create_employee_salary_and_wage"
            )

    def create_employment(
        self,
        xero_tenant_id,
        employee_id,
        employment,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Creates an employment detail for a specific employee  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param Employment employment: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmploymentObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_employment`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `create_employment`"
            )
        # verify the required parameter 'employment' is set
        if employment is None:
            raise ValueError(
                "Missing the required parameter `employment` "
                "when calling `create_employment`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = employment
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeID}/Employment")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmploymentObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_employment")

    def create_leave_type(
        self,
        xero_tenant_id,
        leave_type,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Creates a new leave type  # noqa: E501
        OAuth2 scope: payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param LeaveType leave_type: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: LeaveTypeObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_leave_type`"
            )
        # verify the required parameter 'leave_type' is set
        if leave_type is None:
            raise ValueError(
                "Missing the required parameter `leave_type` "
                "when calling `create_leave_type`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = leave_type
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/LeaveTypes")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="LeaveTypeObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_leave_type")

    def create_multiple_employee_earnings_template(
        self,
        xero_tenant_id,
        employee_id,
        earnings_template,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Creates multiple employee earnings template records for a specific employee  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param list[EarningsTemplate] earnings_template: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeEarningsTemplates
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_multiple_employee_earnings_template`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `create_multiple_employee_earnings_template`"
            )
        # verify the required parameter 'earnings_template' is set
        if earnings_template is None:
            raise ValueError(
                "Missing the required parameter `earnings_template` "
                "when calling `create_multiple_employee_earnings_template`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = earnings_template
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeID}/paytemplateearnings")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeEarningsTemplates",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "create_multiple_employee_earnings_template"
            )

    def create_pay_run(
        self,
        xero_tenant_id,
        pay_run,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Creates a pay run  # noqa: E501
        OAuth2 scope: payroll.payruns
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param PayRun pay_run: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: PayRunObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_pay_run`"
            )
        # verify the required parameter 'pay_run' is set
        if pay_run is None:
            raise ValueError(
                "Missing the required parameter `pay_run` "
                "when calling `create_pay_run`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = pay_run
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/PayRuns")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="PayRunObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_pay_run")

    def create_pay_run_calendar(
        self,
        xero_tenant_id,
        pay_run_calendar,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Creates a new payrun calendar  # noqa: E501
        OAuth2 scope: payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param PayRunCalendar pay_run_calendar: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: PayRunCalendarObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_pay_run_calendar`"
            )
        # verify the required parameter 'pay_run_calendar' is set
        if pay_run_calendar is None:
            raise ValueError(
                "Missing the required parameter `pay_run_calendar` "
                "when calling `create_pay_run_calendar`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = pay_run_calendar
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/PayRunCalendars")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="PayRunCalendarObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_pay_run_calendar")

    def create_reimbursement(
        self,
        xero_tenant_id,
        reimbursement,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Creates a new reimbursement  # noqa: E501
        OAuth2 scope: payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param Reimbursement reimbursement: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: ReimbursementObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_reimbursement`"
            )
        # verify the required parameter 'reimbursement' is set
        if reimbursement is None:
            raise ValueError(
                "Missing the required parameter `reimbursement` "
                "when calling `create_reimbursement`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = reimbursement
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Reimbursements")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="ReimbursementObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_reimbursement")

    def create_superannuation(
        self,
        xero_tenant_id,
        benefit,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Creates a new superannuation  # noqa: E501
        OAuth2 scope: payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param Benefit benefit: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: SuperannuationObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_superannuation`"
            )
        # verify the required parameter 'benefit' is set
        if benefit is None:
            raise ValueError(
                "Missing the required parameter `benefit` "
                "when calling `create_superannuation`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = benefit
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Superannuations")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="SuperannuationObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_superannuation")

    def create_timesheet(
        self,
        xero_tenant_id,
        timesheet,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Creates a new timesheet  # noqa: E501
        OAuth2 scope: payroll.timesheets
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param Timesheet timesheet: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: TimesheetObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_timesheet`"
            )
        # verify the required parameter 'timesheet' is set
        if timesheet is None:
            raise ValueError(
                "Missing the required parameter `timesheet` "
                "when calling `create_timesheet`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = timesheet
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Timesheets")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="TimesheetObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_timesheet")

    def create_timesheet_line(
        self,
        xero_tenant_id,
        timesheet_id,
        timesheet_line,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Create a new timesheet line for a specific time sheet  # noqa: E501
        OAuth2 scope: payroll.timesheets
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str timesheet_id: Identifier for the timesheet (required)
        :param TimesheetLine timesheet_line: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: TimesheetLineObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_timesheet_line`"
            )
        # verify the required parameter 'timesheet_id' is set
        if timesheet_id is None:
            raise ValueError(
                "Missing the required parameter `timesheet_id` "
                "when calling `create_timesheet_line`"
            )
        # verify the required parameter 'timesheet_line' is set
        if timesheet_line is None:
            raise ValueError(
                "Missing the required parameter `timesheet_line` "
                "when calling `create_timesheet_line`"
            )

        collection_formats = {}
        path_params = {
            "TimesheetID": timesheet_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = timesheet_line
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Timesheets/{TimesheetID}/Lines")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="TimesheetLineObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_timesheet_line")

    def delete_employee_earnings_template(
        self,
        xero_tenant_id,
        employee_id,
        pay_template_earning_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Deletes an employee's earnings template record  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param str pay_template_earning_id: Id for single pay template earnings object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EarningsTemplateObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `delete_employee_earnings_template`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `delete_employee_earnings_template`"
            )
        # verify the required parameter 'pay_template_earning_id' is set
        if pay_template_earning_id is None:
            raise ValueError(
                "Missing the required parameter `pay_template_earning_id` "
                "when calling `delete_employee_earnings_template`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
            "PayTemplateEarningID": pay_template_earning_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url(
            "/Employees/{EmployeeID}/PayTemplates/earnings/{PayTemplateEarningID}"
        )

        try:
            return self.api_client.call_api(
                url,
                "DELETE",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EarningsTemplateObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "delete_employee_earnings_template"
            )

    def delete_employee_leave(
        self,
        xero_tenant_id,
        employee_id,
        leave_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Deletes a leave record for a specific employee  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param str leave_id: Leave id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeLeaveObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `delete_employee_leave`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `delete_employee_leave`"
            )
        # verify the required parameter 'leave_id' is set
        if leave_id is None:
            raise ValueError(
                "Missing the required parameter `leave_id` "
                "when calling `delete_employee_leave`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
            "LeaveID": leave_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeID}/Leave/{LeaveID}")

        try:
            return self.api_client.call_api(
                url,
                "DELETE",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeLeaveObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "delete_employee_leave")

    def delete_employee_salary_and_wage(
        self,
        xero_tenant_id,
        employee_id,
        salary_and_wages_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Deletes an employee's salary and wages record  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param str salary_and_wages_id: Id for single salary and wages object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: SalaryAndWageObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `delete_employee_salary_and_wage`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `delete_employee_salary_and_wage`"
            )
        # verify the required parameter 'salary_and_wages_id' is set
        if salary_and_wages_id is None:
            raise ValueError(
                "Missing the required parameter `salary_and_wages_id` "
                "when calling `delete_employee_salary_and_wage`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
            "SalaryAndWagesID": salary_and_wages_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url(
            "/Employees/{EmployeeID}/SalaryAndWages/{SalaryAndWagesID}"
        )

        try:
            return self.api_client.call_api(
                url,
                "DELETE",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="SalaryAndWageObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "delete_employee_salary_and_wage"
            )

    def delete_timesheet(
        self,
        xero_tenant_id,
        timesheet_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Deletes a timesheet  # noqa: E501
        OAuth2 scope: payroll.timesheets
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str timesheet_id: Identifier for the timesheet (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: TimesheetLine
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `delete_timesheet`"
            )
        # verify the required parameter 'timesheet_id' is set
        if timesheet_id is None:
            raise ValueError(
                "Missing the required parameter `timesheet_id` "
                "when calling `delete_timesheet`"
            )

        collection_formats = {}
        path_params = {
            "TimesheetID": timesheet_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Timesheets/{TimesheetID}")

        try:
            return self.api_client.call_api(
                url,
                "DELETE",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="TimesheetLine",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "delete_timesheet")

    def delete_timesheet_line(
        self,
        xero_tenant_id,
        timesheet_id,
        timesheet_line_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Deletes a timesheet line for a specific timesheet  # noqa: E501
        OAuth2 scope: payroll.timesheets
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str timesheet_id: Identifier for the timesheet (required)
        :param str timesheet_line_id: Identifier for the timesheet line (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: TimesheetLine
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `delete_timesheet_line`"
            )
        # verify the required parameter 'timesheet_id' is set
        if timesheet_id is None:
            raise ValueError(
                "Missing the required parameter `timesheet_id` "
                "when calling `delete_timesheet_line`"
            )
        # verify the required parameter 'timesheet_line_id' is set
        if timesheet_line_id is None:
            raise ValueError(
                "Missing the required parameter `timesheet_line_id` "
                "when calling `delete_timesheet_line`"
            )

        collection_formats = {}
        path_params = {
            "TimesheetID": timesheet_id,
            "TimesheetLineID": timesheet_line_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Timesheets/{TimesheetID}/Lines/{TimesheetLineID}")

        try:
            return self.api_client.call_api(
                url,
                "DELETE",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="TimesheetLine",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "delete_timesheet_line")

    def get_deduction(
        self,
        xero_tenant_id,
        deduction_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves a single deduction by using a unique deduction ID  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str deduction_id: Identifier for the deduction (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: DeductionObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_deduction`"
            )
        # verify the required parameter 'deduction_id' is set
        if deduction_id is None:
            raise ValueError(
                "Missing the required parameter `deduction_id` "
                "when calling `get_deduction`"
            )

        collection_formats = {}
        path_params = {
            "deductionId": deduction_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Deductions/{deductionId}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="DeductionObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_deduction")

    def get_deductions(
        self,
        xero_tenant_id,
        page=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves deductions for a specific employee  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param int page: Page number which specifies the set of records to retrieve. By default the number of the records per set is 100.
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: Deductions
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_deductions`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        if page is not empty:
            query_params.append(("page", page))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Deductions")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="Deductions",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_deductions")

    def get_earnings_rate(
        self,
        xero_tenant_id,
        earnings_rate_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves a specific earnings rates by using a unique earnings rate id  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str earnings_rate_id: Identifier for the earnings rate (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EarningsRateObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_earnings_rate`"
            )
        # verify the required parameter 'earnings_rate_id' is set
        if earnings_rate_id is None:
            raise ValueError(
                "Missing the required parameter `earnings_rate_id` "
                "when calling `get_earnings_rate`"
            )

        collection_formats = {}
        path_params = {
            "EarningsRateID": earnings_rate_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/EarningsRates/{EarningsRateID}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EarningsRateObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_earnings_rate")

    def get_earnings_rates(
        self,
        xero_tenant_id,
        page=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves earnings rates  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param int page: Page number which specifies the set of records to retrieve. By default the number of the records per set is 100.
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EarningsRates
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_earnings_rates`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        if page is not empty:
            query_params.append(("page", page))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/EarningsRates")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EarningsRates",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_earnings_rates")

    def get_employee(
        self,
        xero_tenant_id,
        employee_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves an employees using a unique employee ID  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_employee`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeID}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_employee")

    def get_employee_leave_balances(
        self,
        xero_tenant_id,
        employee_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves leave balances for a specific employee  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeLeaveBalances
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee_leave_balances`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_employee_leave_balances`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeID}/LeaveBalances")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeLeaveBalances",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_employee_leave_balances")

    def get_employee_leave_periods(
        self,
        xero_tenant_id,
        employee_id,
        start_date=empty,
        end_date=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves leave periods for a specific employee  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param date start_date: Filter by start date
        :param date end_date: Filter by end date
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: LeavePeriods
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee_leave_periods`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_employee_leave_periods`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
        }

        query_params = []

        if start_date is not empty:
            query_params.append(("startDate", start_date))

        if end_date is not empty:
            query_params.append(("endDate", end_date))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeID}/LeavePeriods")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="LeavePeriods",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_employee_leave_periods")

    def get_employee_leave_types(
        self,
        xero_tenant_id,
        employee_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves leave types for a specific employee  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeLeaveTypes
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee_leave_types`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_employee_leave_types`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeID}/LeaveTypes")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeLeaveTypes",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_employee_leave_types")

    def get_employee_leaves(
        self,
        xero_tenant_id,
        employee_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves leave records for a specific employee  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeLeaves
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee_leaves`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_employee_leaves`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeID}/Leave")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeLeaves",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_employee_leaves")

    def get_employee_opening_balances(
        self,
        xero_tenant_id,
        employee_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves the opening balance for a specific employee  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeOpeningBalancesObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee_opening_balances`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_employee_opening_balances`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeID}/openingBalances")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeOpeningBalancesObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "get_employee_opening_balances"
            )

    def get_employee_pay_templates(
        self,
        xero_tenant_id,
        employee_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves pay templates for a specific employee  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeePayTemplates
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee_pay_templates`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_employee_pay_templates`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeID}/PayTemplates")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeePayTemplates",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_employee_pay_templates")

    def get_employee_payment_method(
        self,
        xero_tenant_id,
        employee_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves available payment methods for a specific employee  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: PaymentMethodObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee_payment_method`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_employee_payment_method`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeID}/PaymentMethods")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="PaymentMethodObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_employee_payment_method")

    def get_employee_salary_and_wage(
        self,
        xero_tenant_id,
        employee_id,
        salary_and_wages_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves an employee's salary and wages record by using a unique salary and wage ID  # noqa: E501
        OAuth2 scope: payroll.employees, payroll.employees.read
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param str salary_and_wages_id: Id for single pay template earnings object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: SalaryAndWages
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee_salary_and_wage`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_employee_salary_and_wage`"
            )
        # verify the required parameter 'salary_and_wages_id' is set
        if salary_and_wages_id is None:
            raise ValueError(
                "Missing the required parameter `salary_and_wages_id` "
                "when calling `get_employee_salary_and_wage`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
            "SalaryAndWagesID": salary_and_wages_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url(
            "/Employees/{EmployeeID}/SalaryAndWages/{SalaryAndWagesID}"
        )

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="SalaryAndWages",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "get_employee_salary_and_wage"
            )

    def get_employee_salary_and_wages(
        self,
        xero_tenant_id,
        employee_id,
        page=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves an employee's salary and wages  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param int page: Page number which specifies the set of records to retrieve. By default the number of the records per set is 100.
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: SalaryAndWages
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee_salary_and_wages`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_employee_salary_and_wages`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
        }

        query_params = []

        if page is not empty:
            query_params.append(("page", page))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeID}/SalaryAndWages")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="SalaryAndWages",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "get_employee_salary_and_wages"
            )

    def get_employee_tax(
        self,
        xero_tenant_id,
        employee_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves tax records for a specific employee  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeTaxObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee_tax`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_employee_tax`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeID}/Tax")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeTaxObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_employee_tax")

    def get_employees(
        self,
        xero_tenant_id,
        first_name=empty,
        last_name=empty,
        page=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves employees  # noqa: E501
        OAuth2 scope: payroll.employees.read
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str first_name: Filter by first name
        :param str last_name: Filter by last name
        :param int page: Page number which specifies the set of records to retrieve. By default the number of the records per set is 100.
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: Employees
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employees`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        if first_name is not empty:
            query_params.append(("firstName", first_name))

        if last_name is not empty:
            query_params.append(("lastName", last_name))

        if page is not empty:
            query_params.append(("page", page))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="Employees",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_employees")

    def get_leave_type(
        self,
        xero_tenant_id,
        leave_type_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves a specific leave type by using a unique leave type ID  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str leave_type_id: Identifier for the leave type (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: LeaveTypeObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_leave_type`"
            )
        # verify the required parameter 'leave_type_id' is set
        if leave_type_id is None:
            raise ValueError(
                "Missing the required parameter `leave_type_id` "
                "when calling `get_leave_type`"
            )

        collection_formats = {}
        path_params = {
            "LeaveTypeID": leave_type_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/LeaveTypes/{LeaveTypeID}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="LeaveTypeObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_leave_type")

    def get_leave_types(
        self,
        xero_tenant_id,
        page=empty,
        active_only=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves leave types  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param int page: Page number which specifies the set of records to retrieve. By default the number of the records per set is 100.
        :param bool active_only: Filters leave types by active status. By default the API returns all leave types.
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: LeaveTypes
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_leave_types`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        if page is not empty:
            query_params.append(("page", page))

        if active_only is not empty:
            query_params.append(("ActiveOnly", active_only))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/LeaveTypes")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="LeaveTypes",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_leave_types")

    def get_pay_run(
        self,
        xero_tenant_id,
        pay_run_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves a specific pay run by using a unique pay run ID  # noqa: E501
        OAuth2 scope: payroll.payruns.read, payroll.payruns
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str pay_run_id: Identifier for the pay run (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: PayRunObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_pay_run`"
            )
        # verify the required parameter 'pay_run_id' is set
        if pay_run_id is None:
            raise ValueError(
                "Missing the required parameter `pay_run_id` "
                "when calling `get_pay_run`"
            )

        collection_formats = {}
        path_params = {
            "PayRunID": pay_run_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/PayRuns/{PayRunID}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="PayRunObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_pay_run")

    def get_pay_run_calendar(
        self,
        xero_tenant_id,
        payroll_calendar_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves a specific payrun calendar by using a unique payroll calendar ID  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str payroll_calendar_id: Identifier for the payrun calendars (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: PayRunCalendarObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_pay_run_calendar`"
            )
        # verify the required parameter 'payroll_calendar_id' is set
        if payroll_calendar_id is None:
            raise ValueError(
                "Missing the required parameter `payroll_calendar_id` "
                "when calling `get_pay_run_calendar`"
            )

        collection_formats = {}
        path_params = {
            "PayrollCalendarID": payroll_calendar_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/PayRunCalendars/{PayrollCalendarID}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="PayRunCalendarObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_pay_run_calendar")

    def get_pay_run_calendars(
        self,
        xero_tenant_id,
        page=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves payrun calendars  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param int page: Page number which specifies the set of records to retrieve. By default the number of the records per set is 100.
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: PayRunCalendars
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_pay_run_calendars`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        if page is not empty:
            query_params.append(("page", page))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/PayRunCalendars")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="PayRunCalendars",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_pay_run_calendars")

    def get_pay_runs(
        self,
        xero_tenant_id,
        page=empty,
        status=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves pay runs  # noqa: E501
        OAuth2 scope: payroll.payruns.read, payroll.payruns
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param int page: Page number which specifies the set of records to retrieve. By default the number of the records per set is 100.
        :param str status: By default get payruns will return all the payruns for an organization. You can add GET https://api.xero.com/payroll.xro/2.0/payRuns?statu={PayRunStatus} to filter the payruns by status.
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: PayRuns
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_pay_runs`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        if page is not empty:
            query_params.append(("page", page))

        if status is not empty:
            query_params.append(("status", status))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/PayRuns")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="PayRuns",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_pay_runs")

    def get_pay_slip(
        self,
        xero_tenant_id,
        pay_slip_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves a specific payslip by a unique pay slip ID  # noqa: E501
        OAuth2 scope: payroll.payslip.read, payroll.payslip
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str pay_slip_id: Identifier for the payslip (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: PaySlipObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_pay_slip`"
            )
        # verify the required parameter 'pay_slip_id' is set
        if pay_slip_id is None:
            raise ValueError(
                "Missing the required parameter `pay_slip_id` "
                "when calling `get_pay_slip`"
            )

        collection_formats = {}
        path_params = {
            "PaySlipID": pay_slip_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/PaySlips/{PaySlipID}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="PaySlipObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_pay_slip")

    def get_pay_slips(
        self,
        xero_tenant_id,
        pay_run_id,
        page=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves payslips  # noqa: E501
        OAuth2 scope: payroll.payslip.read, payroll.payslip
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str pay_run_id: PayrunID which specifies the containing payrun of payslips to retrieve. By default, the API does not group payslips by payrun. (required)
        :param int page: Page number which specifies the set of records to retrieve. By default the number of the records per set is 100.
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: PaySlips
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_pay_slips`"
            )
        # verify the required parameter 'pay_run_id' is set
        if pay_run_id is None:
            raise ValueError(
                "Missing the required parameter `pay_run_id` "
                "when calling `get_pay_slips`"
            )

        collection_formats = {}
        path_params = {}

        query_params = [
            ("PayRunID", pay_run_id),
        ]

        if page is not empty:
            query_params.append(("page", page))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/PaySlips")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="PaySlips",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_pay_slips")

    def get_reimbursement(
        self,
        xero_tenant_id,
        reimbursement_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves a specific reimbursement by using a unique reimbursement ID  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str reimbursement_id: Identifier for the reimbursement (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: ReimbursementObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_reimbursement`"
            )
        # verify the required parameter 'reimbursement_id' is set
        if reimbursement_id is None:
            raise ValueError(
                "Missing the required parameter `reimbursement_id` "
                "when calling `get_reimbursement`"
            )

        collection_formats = {}
        path_params = {
            "ReimbursementID": reimbursement_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Reimbursements/{ReimbursementID}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="ReimbursementObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_reimbursement")

    def get_reimbursements(
        self,
        xero_tenant_id,
        page=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves reimbursements  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param int page: Page number which specifies the set of records to retrieve. By default the number of the records per set is 100.
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: Reimbursements
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_reimbursements`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        if page is not empty:
            query_params.append(("page", page))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Reimbursements")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="Reimbursements",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_reimbursements")

    def get_settings(
        self,
        xero_tenant_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves settings  # noqa: E501
        OAuth2 scope: payroll.settings.read, settings.payslip
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: Settings
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_settings`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Settings")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="Settings",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_settings")

    def get_statutory_deduction(
        self,
        xero_tenant_id,
        id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves a specific statutory deduction by using a unique statutory deductions id  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str id: Identifier for the statutory deduction (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: StatutoryDeductionObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_statutory_deduction`"
            )
        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError(
                "Missing the required parameter `id` "
                "when calling `get_statutory_deduction`"
            )

        collection_formats = {}
        path_params = {
            "id": id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/StatutoryDeductions/{id}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="StatutoryDeductionObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_statutory_deduction")

    def get_statutory_deductions(
        self,
        xero_tenant_id,
        page=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves statutory deductions  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param int page: Page number which specifies the set of records to retrieve. By default the number of the records per set is 100.
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: StatutoryDeductions
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_statutory_deductions`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        if page is not empty:
            query_params.append(("page", page))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/StatutoryDeductions")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="StatutoryDeductions",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_statutory_deductions")

    def get_superannuation(
        self,
        xero_tenant_id,
        superannuation_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves a specific superannuation using a unique superannuation ID  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str superannuation_id: Identifier for the superannuation (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: SuperannuationObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_superannuation`"
            )
        # verify the required parameter 'superannuation_id' is set
        if superannuation_id is None:
            raise ValueError(
                "Missing the required parameter `superannuation_id` "
                "when calling `get_superannuation`"
            )

        collection_formats = {}
        path_params = {
            "SuperannuationID": superannuation_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Superannuations/{SuperannuationID}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="SuperannuationObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_superannuation")

    def get_superannuations(
        self,
        xero_tenant_id,
        page=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves superannuations  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param int page: Page number which specifies the set of records to retrieve. By default the number of the records per set is 100.
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: Superannuations
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_superannuations`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        if page is not empty:
            query_params.append(("page", page))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Superannuations")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="Superannuations",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_superannuations")

    def get_timesheet(
        self,
        xero_tenant_id,
        timesheet_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves a specific timesheet by using a unique timesheet ID  # noqa: E501
        OAuth2 scope: payroll.timesheets.read, timesheets.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str timesheet_id: Identifier for the timesheet (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: TimesheetObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_timesheet`"
            )
        # verify the required parameter 'timesheet_id' is set
        if timesheet_id is None:
            raise ValueError(
                "Missing the required parameter `timesheet_id` "
                "when calling `get_timesheet`"
            )

        collection_formats = {}
        path_params = {
            "TimesheetID": timesheet_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Timesheets/{TimesheetID}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="TimesheetObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_timesheet")

    def get_timesheets(
        self,
        xero_tenant_id,
        page=empty,
        employee_id=empty,
        payroll_calendar_id=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves timesheets  # noqa: E501
        OAuth2 scope: payroll.timesheets.read, payroll.timesheets
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param int page: Page number which specifies the set of records to retrieve. By default the number of the records per set is 100.
        :param str employee_id: By default get Timesheets will return the timesheets for all employees in an organization. You can add GET https://…/timesheets?filter=employeeId=={EmployeeID} to get only the timesheets of a particular employee.
        :param str payroll_calendar_id: By default get Timesheets will return all the timesheets for an organization. You can add GET https://…/timesheets?filter=payrollCalendarId=={PayrollCalendarID} to filter the timesheets by payroll calendar id
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: Timesheets
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_timesheets`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        if page is not empty:
            query_params.append(("page", page))

        if employee_id is not empty:
            query_params.append(("employeeId", employee_id))

        if payroll_calendar_id is not empty:
            query_params.append(("payrollCalendarId", payroll_calendar_id))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Timesheets")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="Timesheets",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_timesheets")

    def get_tracking_categories(
        self,
        xero_tenant_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves tracking categories  # noqa: E501
        OAuth2 scope: payroll.settings.read, settings.payslip
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: TrackingCategories
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_tracking_categories`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Settings/TrackingCategories")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="TrackingCategories",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_tracking_categories")

    def revert_timesheet(
        self,
        xero_tenant_id,
        timesheet_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Reverts a timesheet to draft  # noqa: E501
        OAuth2 scope: payroll.timesheets
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str timesheet_id: Identifier for the timesheet (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: TimesheetObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `revert_timesheet`"
            )
        # verify the required parameter 'timesheet_id' is set
        if timesheet_id is None:
            raise ValueError(
                "Missing the required parameter `timesheet_id` "
                "when calling `revert_timesheet`"
            )

        collection_formats = {}
        path_params = {
            "TimesheetID": timesheet_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Timesheets/{TimesheetID}/RevertToDraft")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="TimesheetObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "revert_timesheet")

    def update_employee(
        self,
        xero_tenant_id,
        employee_id,
        employee,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Updates an existing employee  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param Employee employee: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `update_employee`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `update_employee`"
            )
        # verify the required parameter 'employee' is set
        if employee is None:
            raise ValueError(
                "Missing the required parameter `employee` "
                "when calling `update_employee`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = employee
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeID}")

        try:
            return self.api_client.call_api(
                url,
                "PUT",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "update_employee")

    def update_employee_earnings_template(
        self,
        xero_tenant_id,
        employee_id,
        pay_template_earning_id,
        earnings_template,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Updates an earnings template records for an employee  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param str pay_template_earning_id: Id for single pay template earnings object (required)
        :param EarningsTemplate earnings_template: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EarningsTemplateObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `update_employee_earnings_template`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `update_employee_earnings_template`"
            )
        # verify the required parameter 'pay_template_earning_id' is set
        if pay_template_earning_id is None:
            raise ValueError(
                "Missing the required parameter `pay_template_earning_id` "
                "when calling `update_employee_earnings_template`"
            )
        # verify the required parameter 'earnings_template' is set
        if earnings_template is None:
            raise ValueError(
                "Missing the required parameter `earnings_template` "
                "when calling `update_employee_earnings_template`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
            "PayTemplateEarningID": pay_template_earning_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = earnings_template
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url(
            "/Employees/{EmployeeID}/PayTemplates/earnings/{PayTemplateEarningID}"
        )

        try:
            return self.api_client.call_api(
                url,
                "PUT",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EarningsTemplateObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "update_employee_earnings_template"
            )

    def update_employee_leave(
        self,
        xero_tenant_id,
        employee_id,
        leave_id,
        employee_leave,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Updates leave records for a specific employee  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param str leave_id: Leave id for single object (required)
        :param EmployeeLeave employee_leave: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeLeaveObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `update_employee_leave`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `update_employee_leave`"
            )
        # verify the required parameter 'leave_id' is set
        if leave_id is None:
            raise ValueError(
                "Missing the required parameter `leave_id` "
                "when calling `update_employee_leave`"
            )
        # verify the required parameter 'employee_leave' is set
        if employee_leave is None:
            raise ValueError(
                "Missing the required parameter `employee_leave` "
                "when calling `update_employee_leave`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
            "LeaveID": leave_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = employee_leave
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeID}/Leave/{LeaveID}")

        try:
            return self.api_client.call_api(
                url,
                "PUT",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeLeaveObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "update_employee_leave")

    def update_employee_salary_and_wage(
        self,
        xero_tenant_id,
        employee_id,
        salary_and_wages_id,
        salary_and_wage,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Updates an employee's salary and wages record  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param str salary_and_wages_id: Id for single pay template earnings object (required)
        :param SalaryAndWage salary_and_wage: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: SalaryAndWageObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `update_employee_salary_and_wage`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `update_employee_salary_and_wage`"
            )
        # verify the required parameter 'salary_and_wages_id' is set
        if salary_and_wages_id is None:
            raise ValueError(
                "Missing the required parameter `salary_and_wages_id` "
                "when calling `update_employee_salary_and_wage`"
            )
        # verify the required parameter 'salary_and_wage' is set
        if salary_and_wage is None:
            raise ValueError(
                "Missing the required parameter `salary_and_wage` "
                "when calling `update_employee_salary_and_wage`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
            "SalaryAndWagesID": salary_and_wages_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = salary_and_wage
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url(
            "/Employees/{EmployeeID}/SalaryAndWages/{SalaryAndWagesID}"
        )

        try:
            return self.api_client.call_api(
                url,
                "PUT",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="SalaryAndWageObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "update_employee_salary_and_wage"
            )

    def update_employee_tax(
        self,
        xero_tenant_id,
        employee_id,
        employee_tax,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Updates the tax records for a specific employee  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param EmployeeTax employee_tax: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeTaxObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `update_employee_tax`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `update_employee_tax`"
            )
        # verify the required parameter 'employee_tax' is set
        if employee_tax is None:
            raise ValueError(
                "Missing the required parameter `employee_tax` "
                "when calling `update_employee_tax`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeID": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = employee_tax
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeID}/Tax")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeTaxObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "update_employee_tax")

    def update_pay_run(
        self,
        xero_tenant_id,
        pay_run_id,
        pay_run,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Updates a pay run  # noqa: E501
        OAuth2 scope: payroll.payruns
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str pay_run_id: Identifier for the pay run (required)
        :param PayRun pay_run: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: PayRunObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `update_pay_run`"
            )
        # verify the required parameter 'pay_run_id' is set
        if pay_run_id is None:
            raise ValueError(
                "Missing the required parameter `pay_run_id` "
                "when calling `update_pay_run`"
            )
        # verify the required parameter 'pay_run' is set
        if pay_run is None:
            raise ValueError(
                "Missing the required parameter `pay_run` "
                "when calling `update_pay_run`"
            )

        collection_formats = {}
        path_params = {
            "PayRunID": pay_run_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = pay_run
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/PayRuns/{PayRunID}")

        try:
            return self.api_client.call_api(
                url,
                "PUT",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="PayRunObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "update_pay_run")

    def update_pay_slip_line_items(
        self,
        xero_tenant_id,
        pay_slip_id,
        pay_slip,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Creates an employee pay slip  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str pay_slip_id: Identifier for the payslip (required)
        :param PaySlip pay_slip: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: PaySlipObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `update_pay_slip_line_items`"
            )
        # verify the required parameter 'pay_slip_id' is set
        if pay_slip_id is None:
            raise ValueError(
                "Missing the required parameter `pay_slip_id` "
                "when calling `update_pay_slip_line_items`"
            )
        # verify the required parameter 'pay_slip' is set
        if pay_slip is None:
            raise ValueError(
                "Missing the required parameter `pay_slip` "
                "when calling `update_pay_slip_line_items`"
            )

        collection_formats = {}
        path_params = {
            "PaySlipID": pay_slip_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = pay_slip
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/PaySlips/{PaySlipID}")

        try:
            return self.api_client.call_api(
                url,
                "PUT",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="PaySlipObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "update_pay_slip_line_items")

    def update_timesheet_line(
        self,
        xero_tenant_id,
        timesheet_id,
        timesheet_line_id,
        timesheet_line,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Updates a timesheet line for a specific timesheet  # noqa: E501
        OAuth2 scope: payroll.timesheets
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str timesheet_id: Identifier for the timesheet (required)
        :param str timesheet_line_id: Identifier for the timesheet line (required)
        :param TimesheetLine timesheet_line: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: TimesheetLineObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `update_timesheet_line`"
            )
        # verify the required parameter 'timesheet_id' is set
        if timesheet_id is None:
            raise ValueError(
                "Missing the required parameter `timesheet_id` "
                "when calling `update_timesheet_line`"
            )
        # verify the required parameter 'timesheet_line_id' is set
        if timesheet_line_id is None:
            raise ValueError(
                "Missing the required parameter `timesheet_line_id` "
                "when calling `update_timesheet_line`"
            )
        # verify the required parameter 'timesheet_line' is set
        if timesheet_line is None:
            raise ValueError(
                "Missing the required parameter `timesheet_line` "
                "when calling `update_timesheet_line`"
            )

        collection_formats = {}
        path_params = {
            "TimesheetID": timesheet_id,
            "TimesheetLineID": timesheet_line_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = timesheet_line
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Timesheets/{TimesheetID}/Lines/{TimesheetLineID}")

        try:
            return self.api_client.call_api(
                url,
                "PUT",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="TimesheetLineObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "update_timesheet_line")
