# Generated by Django 2.2.5 on 2020-10-08 17:21

from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Discount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100, verbose_name='عنوان کد تخفیف')),
                ('code', models.CharField(max_length=20, verbose_name='کد تخفیف')),
                ('type', models.CharField(choices=[('percent', 'درصدی'), ('fixed', 'مقدار ثابت')], default='percent', max_length=10, verbose_name='نوع تخفیف')),
                ('value', models.PositiveIntegerField(default=0, verbose_name='میزان تخفیف')),
                ('min_invoice_amount', models.IntegerField(default=10000, verbose_name='حداقل مبلغ فاکتور برای اعمال تخفیف')),
                ('max_amount', models.IntegerField(default=100000, help_text='در صورتی که میزان تخفیف بیش از این عدد شود، تنها این میزان اعمال خواهد شد.', verbose_name='حداکثر میزان تخفیف')),
                ('total_max_uses', models.IntegerField(default=50, verbose_name='حداکثر تعداد دفعاتی که این کد تخفیف قابل استفاده است.')),
                ('total_uses', models.IntegerField(default=0, verbose_name='تعداد دفعات استفاده شده')),
                ('start_date', models.DateTimeField(blank=True, help_text='در صورت خالی بودن زمان شروع حال در نظر گرفته می\u200cشود.', null=True, verbose_name='زمان شروع تخفیف')),
                ('expire_date', models.DateTimeField(blank=True, help_text='در صورتی که خالی تعریف شد، کد تخفیف منقضی نخواهد شد.', null=True, verbose_name='زمان پایان اعتبار کد تخفیف')),
                ('is_active', models.BooleanField(default=True, verbose_name='وضعیت فعال بودن کد تخفیف')),
                ('not_active_reason', models.CharField(blank=True, default='', max_length=100, verbose_name='علت غیرفعال بودن')),
                ('is_deleted', models.BooleanField(default=False, verbose_name='حذف شد')),
            ],
            options={
                'verbose_name': 'کد تخفیف',
                'db_table': 'discount',
            },
        ),
    ]
