# coding: utf-8

"""
    Engines API

    Allow clients to fetch Engines Analytics through APIs.  # noqa: E501

    The version of the OpenAPI document: 2
    Contact: analytics.api.support@factset.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from fds.analyticsapi.engines.configuration import Configuration


class VaultCalculationParameters(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'componentid': 'str',
        'account': 'VaultIdentifier',
        'dates': 'VaultDateParameters',
        'configid': 'str',
        'componentdetail': 'str'
    }

    attribute_map = {
        'componentid': 'componentid',
        'account': 'account',
        'dates': 'dates',
        'configid': 'configid',
        'componentdetail': 'componentdetail'
    }

    def __init__(self, componentid=None, account=None, dates=None, configid=None, componentdetail=None, local_vars_configuration=None):  # noqa: E501
        """VaultCalculationParameters - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._componentid = None
        self._account = None
        self._dates = None
        self._configid = None
        self._componentdetail = None
        self.discriminator = None

        self.componentid = componentid
        self.account = account
        if dates is not None:
            self.dates = dates
        self.configid = configid
        if componentdetail is not None:
            self.componentdetail = componentdetail

    @property
    def componentid(self):
        """Gets the componentid of this VaultCalculationParameters.  # noqa: E501

        The Vault component identifier to analyze.  # noqa: E501

        :return: The componentid of this VaultCalculationParameters.  # noqa: E501
        :rtype: str
        """
        return self._componentid

    @componentid.setter
    def componentid(self, componentid):
        """Sets the componentid of this VaultCalculationParameters.

        The Vault component identifier to analyze.  # noqa: E501

        :param componentid: The componentid of this VaultCalculationParameters.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and componentid is None:  # noqa: E501
            raise ValueError("Invalid value for `componentid`, must not be `None`")  # noqa: E501

        self._componentid = componentid

    @property
    def account(self):
        """Gets the account of this VaultCalculationParameters.  # noqa: E501


        :return: The account of this VaultCalculationParameters.  # noqa: E501
        :rtype: VaultIdentifier
        """
        return self._account

    @account.setter
    def account(self, account):
        """Sets the account of this VaultCalculationParameters.


        :param account: The account of this VaultCalculationParameters.  # noqa: E501
        :type: VaultIdentifier
        """
        if self.local_vars_configuration.client_side_validation and account is None:  # noqa: E501
            raise ValueError("Invalid value for `account`, must not be `None`")  # noqa: E501

        self._account = account

    @property
    def dates(self):
        """Gets the dates of this VaultCalculationParameters.  # noqa: E501


        :return: The dates of this VaultCalculationParameters.  # noqa: E501
        :rtype: VaultDateParameters
        """
        return self._dates

    @dates.setter
    def dates(self, dates):
        """Sets the dates of this VaultCalculationParameters.


        :param dates: The dates of this VaultCalculationParameters.  # noqa: E501
        :type: VaultDateParameters
        """

        self._dates = dates

    @property
    def configid(self):
        """Gets the configid of this VaultCalculationParameters.  # noqa: E501

        Vault Configuration identifier.  # noqa: E501

        :return: The configid of this VaultCalculationParameters.  # noqa: E501
        :rtype: str
        """
        return self._configid

    @configid.setter
    def configid(self, configid):
        """Sets the configid of this VaultCalculationParameters.

        Vault Configuration identifier.  # noqa: E501

        :param configid: The configid of this VaultCalculationParameters.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and configid is None:  # noqa: E501
            raise ValueError("Invalid value for `configid`, must not be `None`")  # noqa: E501

        self._configid = configid

    @property
    def componentdetail(self):
        """Gets the componentdetail of this VaultCalculationParameters.  # noqa: E501

        Component detail type for the Vault component. It can be GROUPS or TOTALS.  # noqa: E501

        :return: The componentdetail of this VaultCalculationParameters.  # noqa: E501
        :rtype: str
        """
        return self._componentdetail

    @componentdetail.setter
    def componentdetail(self, componentdetail):
        """Sets the componentdetail of this VaultCalculationParameters.

        Component detail type for the Vault component. It can be GROUPS or TOTALS.  # noqa: E501

        :param componentdetail: The componentdetail of this VaultCalculationParameters.  # noqa: E501
        :type: str
        """

        self._componentdetail = componentdetail

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VaultCalculationParameters):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VaultCalculationParameters):
            return True

        return self.to_dict() != other.to_dict()
