# coding: utf-8

"""
    Engines API

    Allow clients to fetch Engines Analytics through APIs.  # noqa: E501

    The version of the OpenAPI document: 2
    Contact: analytics.api.support@factset.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from fds.analyticsapi.engines.configuration import Configuration


class CalculationStatusSummary(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'status': 'str',
        'units': 'int',
        'request_time': 'datetime',
        'last_poll_time': 'datetime'
    }

    attribute_map = {
        'status': 'status',
        'units': 'units',
        'request_time': 'requestTime',
        'last_poll_time': 'lastPollTime'
    }

    def __init__(self, status=None, units=None, request_time=None, last_poll_time=None, local_vars_configuration=None):  # noqa: E501
        """CalculationStatusSummary - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._status = None
        self._units = None
        self._request_time = None
        self._last_poll_time = None
        self.discriminator = None

        if status is not None:
            self.status = status
        if units is not None:
            self.units = units
        if request_time is not None:
            self.request_time = request_time
        if last_poll_time is not None:
            self.last_poll_time = last_poll_time

    @property
    def status(self):
        """Gets the status of this CalculationStatusSummary.  # noqa: E501

        The status of the calculation.  # noqa: E501

        :return: The status of this CalculationStatusSummary.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this CalculationStatusSummary.

        The status of the calculation.  # noqa: E501

        :param status: The status of this CalculationStatusSummary.  # noqa: E501
        :type: str
        """
        allowed_values = ["Queued", "Executing", "Completed", "Cancelled"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def units(self):
        """Gets the units of this CalculationStatusSummary.  # noqa: E501

        Number of calculation units in batch.  # noqa: E501

        :return: The units of this CalculationStatusSummary.  # noqa: E501
        :rtype: int
        """
        return self._units

    @units.setter
    def units(self, units):
        """Sets the units of this CalculationStatusSummary.

        Number of calculation units in batch.  # noqa: E501

        :param units: The units of this CalculationStatusSummary.  # noqa: E501
        :type: int
        """

        self._units = units

    @property
    def request_time(self):
        """Gets the request_time of this CalculationStatusSummary.  # noqa: E501

        Request time of calculation.  # noqa: E501

        :return: The request_time of this CalculationStatusSummary.  # noqa: E501
        :rtype: datetime
        """
        return self._request_time

    @request_time.setter
    def request_time(self, request_time):
        """Sets the request_time of this CalculationStatusSummary.

        Request time of calculation.  # noqa: E501

        :param request_time: The request_time of this CalculationStatusSummary.  # noqa: E501
        :type: datetime
        """

        self._request_time = request_time

    @property
    def last_poll_time(self):
        """Gets the last_poll_time of this CalculationStatusSummary.  # noqa: E501

        Last poll time of calculation.  # noqa: E501

        :return: The last_poll_time of this CalculationStatusSummary.  # noqa: E501
        :rtype: datetime
        """
        return self._last_poll_time

    @last_poll_time.setter
    def last_poll_time(self, last_poll_time):
        """Sets the last_poll_time of this CalculationStatusSummary.

        Last poll time of calculation.  # noqa: E501

        :param last_poll_time: The last_poll_time of this CalculationStatusSummary.  # noqa: E501
        :type: datetime
        """

        self._last_poll_time = last_poll_time

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CalculationStatusSummary):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CalculationStatusSummary):
            return True

        return self.to_dict() != other.to_dict()
