# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'BotAdvancedRecognitionSetting',
    'BotAliasAudioLogDestination',
    'BotAliasAudioLogSetting',
    'BotAliasCloudWatchLogGroupLogDestination',
    'BotAliasCodeHookSpecification',
    'BotAliasConversationLogSettings',
    'BotAliasLambdaCodeHook',
    'BotAliasLocaleSettings',
    'BotAliasLocaleSettingsItem',
    'BotAliasS3BucketLogDestination',
    'BotAliasTag',
    'BotAliasTextLogDestination',
    'BotAliasTextLogSetting',
    'BotAudioLogDestination',
    'BotAudioLogSetting',
    'BotButton',
    'BotCloudWatchLogGroupLogDestination',
    'BotConversationLogSettings',
    'BotCustomPayload',
    'BotCustomVocabulary',
    'BotCustomVocabularyItem',
    'BotDialogCodeHookSetting',
    'BotExternalSourceSetting',
    'BotFulfillmentCodeHookSetting',
    'BotFulfillmentStartResponseSpecification',
    'BotFulfillmentUpdateResponseSpecification',
    'BotFulfillmentUpdatesSpecification',
    'BotGrammarSlotTypeSetting',
    'BotGrammarSlotTypeSource',
    'BotImageResponseCard',
    'BotInputContext',
    'BotIntent',
    'BotIntentClosingSetting',
    'BotIntentConfirmationSetting',
    'BotKendraConfiguration',
    'BotLocale',
    'BotMessage',
    'BotMessageGroup',
    'BotMultipleValuesSetting',
    'BotObfuscationSetting',
    'BotOutputContext',
    'BotPlainTextMessage',
    'BotPostFulfillmentStatusSpecification',
    'BotPromptSpecification',
    'BotResponseSpecification',
    'BotS3BucketLogDestination',
    'BotS3Location',
    'BotSSMLMessage',
    'BotSampleUtterance',
    'BotSampleValue',
    'BotSlot',
    'BotSlotDefaultValue',
    'BotSlotDefaultValueSpecification',
    'BotSlotPriority',
    'BotSlotType',
    'BotSlotTypeValue',
    'BotSlotValueElicitationSetting',
    'BotSlotValueRegexFilter',
    'BotSlotValueSelectionSetting',
    'BotStillWaitingResponseSpecification',
    'BotTag',
    'BotTestBotAliasSettings',
    'BotTestBotAliasSettingsSentimentAnalysisSettingsProperties',
    'BotTextLogDestination',
    'BotTextLogSetting',
    'BotVersionLocaleDetails',
    'BotVersionLocaleSpecification',
    'BotVoiceSettings',
    'BotWaitAndContinueSpecification',
    'DataPrivacyProperties',
    'ResourcePolicyPolicy',
    'SentimentAnalysisSettingsProperties',
]

@pulumi.output_type
class BotAdvancedRecognitionSetting(dict):
    """
    Provides settings that enable advanced recognition settings for slot values.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "audioRecognitionStrategy":
            suggest = "audio_recognition_strategy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotAdvancedRecognitionSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotAdvancedRecognitionSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotAdvancedRecognitionSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audio_recognition_strategy: Optional['BotAudioRecognitionStrategy'] = None):
        """
        Provides settings that enable advanced recognition settings for slot values.
        """
        if audio_recognition_strategy is not None:
            pulumi.set(__self__, "audio_recognition_strategy", audio_recognition_strategy)

    @property
    @pulumi.getter(name="audioRecognitionStrategy")
    def audio_recognition_strategy(self) -> Optional['BotAudioRecognitionStrategy']:
        return pulumi.get(self, "audio_recognition_strategy")


@pulumi.output_type
class BotAliasAudioLogDestination(dict):
    """
    The location of audio log files collected when conversation logging is enabled for a bot.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Bucket":
            suggest = "s3_bucket"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotAliasAudioLogDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotAliasAudioLogDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotAliasAudioLogDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_bucket: 'outputs.BotAliasS3BucketLogDestination'):
        """
        The location of audio log files collected when conversation logging is enabled for a bot.
        """
        pulumi.set(__self__, "s3_bucket", s3_bucket)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> 'outputs.BotAliasS3BucketLogDestination':
        return pulumi.get(self, "s3_bucket")


@pulumi.output_type
class BotAliasAudioLogSetting(dict):
    """
    Settings for logging audio of conversations between Amazon Lex and a user. You specify whether to log audio and the Amazon S3 bucket where the audio file is stored.
    """
    def __init__(__self__, *,
                 destination: 'outputs.BotAliasAudioLogDestination',
                 enabled: bool):
        """
        Settings for logging audio of conversations between Amazon Lex and a user. You specify whether to log audio and the Amazon S3 bucket where the audio file is stored.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.BotAliasAudioLogDestination':
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class BotAliasCloudWatchLogGroupLogDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatchLogGroupArn":
            suggest = "cloud_watch_log_group_arn"
        elif key == "logPrefix":
            suggest = "log_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotAliasCloudWatchLogGroupLogDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotAliasCloudWatchLogGroupLogDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotAliasCloudWatchLogGroupLogDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch_log_group_arn: str,
                 log_prefix: str):
        """
        :param str cloud_watch_log_group_arn: A string used to identify the groupArn for the Cloudwatch Log Group
        :param str log_prefix: A string containing the value for the Log Prefix
        """
        pulumi.set(__self__, "cloud_watch_log_group_arn", cloud_watch_log_group_arn)
        pulumi.set(__self__, "log_prefix", log_prefix)

    @property
    @pulumi.getter(name="cloudWatchLogGroupArn")
    def cloud_watch_log_group_arn(self) -> str:
        """
        A string used to identify the groupArn for the Cloudwatch Log Group
        """
        return pulumi.get(self, "cloud_watch_log_group_arn")

    @property
    @pulumi.getter(name="logPrefix")
    def log_prefix(self) -> str:
        """
        A string containing the value for the Log Prefix
        """
        return pulumi.get(self, "log_prefix")


@pulumi.output_type
class BotAliasCodeHookSpecification(dict):
    """
    Contains information about code hooks that Amazon Lex calls during a conversation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaCodeHook":
            suggest = "lambda_code_hook"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotAliasCodeHookSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotAliasCodeHookSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotAliasCodeHookSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_code_hook: 'outputs.BotAliasLambdaCodeHook'):
        """
        Contains information about code hooks that Amazon Lex calls during a conversation.
        """
        pulumi.set(__self__, "lambda_code_hook", lambda_code_hook)

    @property
    @pulumi.getter(name="lambdaCodeHook")
    def lambda_code_hook(self) -> 'outputs.BotAliasLambdaCodeHook':
        return pulumi.get(self, "lambda_code_hook")


@pulumi.output_type
class BotAliasConversationLogSettings(dict):
    """
    Contains information about code hooks that Amazon Lex calls during a conversation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "audioLogSettings":
            suggest = "audio_log_settings"
        elif key == "textLogSettings":
            suggest = "text_log_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotAliasConversationLogSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotAliasConversationLogSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotAliasConversationLogSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audio_log_settings: Optional[Sequence['outputs.BotAliasAudioLogSetting']] = None,
                 text_log_settings: Optional[Sequence['outputs.BotAliasTextLogSetting']] = None):
        """
        Contains information about code hooks that Amazon Lex calls during a conversation.
        """
        if audio_log_settings is not None:
            pulumi.set(__self__, "audio_log_settings", audio_log_settings)
        if text_log_settings is not None:
            pulumi.set(__self__, "text_log_settings", text_log_settings)

    @property
    @pulumi.getter(name="audioLogSettings")
    def audio_log_settings(self) -> Optional[Sequence['outputs.BotAliasAudioLogSetting']]:
        return pulumi.get(self, "audio_log_settings")

    @property
    @pulumi.getter(name="textLogSettings")
    def text_log_settings(self) -> Optional[Sequence['outputs.BotAliasTextLogSetting']]:
        return pulumi.get(self, "text_log_settings")


@pulumi.output_type
class BotAliasLambdaCodeHook(dict):
    """
    Contains information about code hooks that Amazon Lex calls during a conversation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "codeHookInterfaceVersion":
            suggest = "code_hook_interface_version"
        elif key == "lambdaArn":
            suggest = "lambda_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotAliasLambdaCodeHook. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotAliasLambdaCodeHook.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotAliasLambdaCodeHook.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code_hook_interface_version: str,
                 lambda_arn: str):
        """
        Contains information about code hooks that Amazon Lex calls during a conversation.
        :param str code_hook_interface_version: The version of the request-response that you want Amazon Lex to use to invoke your Lambda function.
        :param str lambda_arn: The Amazon Resource Name (ARN) of the Lambda function.
        """
        pulumi.set(__self__, "code_hook_interface_version", code_hook_interface_version)
        pulumi.set(__self__, "lambda_arn", lambda_arn)

    @property
    @pulumi.getter(name="codeHookInterfaceVersion")
    def code_hook_interface_version(self) -> str:
        """
        The version of the request-response that you want Amazon Lex to use to invoke your Lambda function.
        """
        return pulumi.get(self, "code_hook_interface_version")

    @property
    @pulumi.getter(name="lambdaArn")
    def lambda_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the Lambda function.
        """
        return pulumi.get(self, "lambda_arn")


@pulumi.output_type
class BotAliasLocaleSettings(dict):
    """
    You can use this parameter to specify a specific Lambda function to run different functions in different locales.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "codeHookSpecification":
            suggest = "code_hook_specification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotAliasLocaleSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotAliasLocaleSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotAliasLocaleSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 code_hook_specification: Optional['outputs.BotAliasCodeHookSpecification'] = None):
        """
        You can use this parameter to specify a specific Lambda function to run different functions in different locales.
        :param bool enabled: Whether the Lambda code hook is enabled
        """
        pulumi.set(__self__, "enabled", enabled)
        if code_hook_specification is not None:
            pulumi.set(__self__, "code_hook_specification", code_hook_specification)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether the Lambda code hook is enabled
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="codeHookSpecification")
    def code_hook_specification(self) -> Optional['outputs.BotAliasCodeHookSpecification']:
        return pulumi.get(self, "code_hook_specification")


@pulumi.output_type
class BotAliasLocaleSettingsItem(dict):
    """
    A locale setting in alias
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "botAliasLocaleSetting":
            suggest = "bot_alias_locale_setting"
        elif key == "localeId":
            suggest = "locale_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotAliasLocaleSettingsItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotAliasLocaleSettingsItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotAliasLocaleSettingsItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bot_alias_locale_setting: 'outputs.BotAliasLocaleSettings',
                 locale_id: str):
        """
        A locale setting in alias
        :param str locale_id: A string used to identify the locale
        """
        pulumi.set(__self__, "bot_alias_locale_setting", bot_alias_locale_setting)
        pulumi.set(__self__, "locale_id", locale_id)

    @property
    @pulumi.getter(name="botAliasLocaleSetting")
    def bot_alias_locale_setting(self) -> 'outputs.BotAliasLocaleSettings':
        return pulumi.get(self, "bot_alias_locale_setting")

    @property
    @pulumi.getter(name="localeId")
    def locale_id(self) -> str:
        """
        A string used to identify the locale
        """
        return pulumi.get(self, "locale_id")


@pulumi.output_type
class BotAliasS3BucketLogDestination(dict):
    """
    Specifies an Amazon S3 bucket for logging audio conversations
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logPrefix":
            suggest = "log_prefix"
        elif key == "s3BucketArn":
            suggest = "s3_bucket_arn"
        elif key == "kmsKeyArn":
            suggest = "kms_key_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotAliasS3BucketLogDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotAliasS3BucketLogDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotAliasS3BucketLogDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_prefix: str,
                 s3_bucket_arn: str,
                 kms_key_arn: Optional[str] = None):
        """
        Specifies an Amazon S3 bucket for logging audio conversations
        :param str log_prefix: The Amazon S3 key of the deployment package.
        :param str s3_bucket_arn: The Amazon Resource Name (ARN) of an Amazon S3 bucket where audio log files are stored.
        :param str kms_key_arn: The Amazon Resource Name (ARN) of an AWS Key Management Service (KMS) key for encrypting audio log files stored in an S3 bucket.
        """
        pulumi.set(__self__, "log_prefix", log_prefix)
        pulumi.set(__self__, "s3_bucket_arn", s3_bucket_arn)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter(name="logPrefix")
    def log_prefix(self) -> str:
        """
        The Amazon S3 key of the deployment package.
        """
        return pulumi.get(self, "log_prefix")

    @property
    @pulumi.getter(name="s3BucketArn")
    def s3_bucket_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of an Amazon S3 bucket where audio log files are stored.
        """
        return pulumi.get(self, "s3_bucket_arn")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of an AWS Key Management Service (KMS) key for encrypting audio log files stored in an S3 bucket.
        """
        return pulumi.get(self, "kms_key_arn")


@pulumi.output_type
class BotAliasTag(dict):
    """
    A label for tagging Lex resources
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        A label for tagging Lex resources
        :param str key: A string used to identify this tag
        :param str value: A string containing the value for the tag
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        A string used to identify this tag
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        A string containing the value for the tag
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class BotAliasTextLogDestination(dict):
    """
    Defines the Amazon CloudWatch Logs destination log group for conversation text logs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatch":
            suggest = "cloud_watch"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotAliasTextLogDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotAliasTextLogDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotAliasTextLogDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch: 'outputs.BotAliasCloudWatchLogGroupLogDestination'):
        """
        Defines the Amazon CloudWatch Logs destination log group for conversation text logs.
        """
        pulumi.set(__self__, "cloud_watch", cloud_watch)

    @property
    @pulumi.getter(name="cloudWatch")
    def cloud_watch(self) -> 'outputs.BotAliasCloudWatchLogGroupLogDestination':
        return pulumi.get(self, "cloud_watch")


@pulumi.output_type
class BotAliasTextLogSetting(dict):
    """
    Contains information about code hooks that Amazon Lex calls during a conversation.
    """
    def __init__(__self__, *,
                 destination: 'outputs.BotAliasTextLogDestination',
                 enabled: bool):
        """
        Contains information about code hooks that Amazon Lex calls during a conversation.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.BotAliasTextLogDestination':
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class BotAudioLogDestination(dict):
    """
    The location of audio log files collected when conversation logging is enabled for a bot.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Bucket":
            suggest = "s3_bucket"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotAudioLogDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotAudioLogDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotAudioLogDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_bucket: 'outputs.BotS3BucketLogDestination'):
        """
        The location of audio log files collected when conversation logging is enabled for a bot.
        """
        pulumi.set(__self__, "s3_bucket", s3_bucket)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> 'outputs.BotS3BucketLogDestination':
        return pulumi.get(self, "s3_bucket")


@pulumi.output_type
class BotAudioLogSetting(dict):
    """
    Settings for logging audio of conversations between Amazon Lex and a user. You specify whether to log audio and the Amazon S3 bucket where the audio file is stored.
    """
    def __init__(__self__, *,
                 destination: 'outputs.BotAudioLogDestination',
                 enabled: bool):
        """
        Settings for logging audio of conversations between Amazon Lex and a user. You specify whether to log audio and the Amazon S3 bucket where the audio file is stored.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.BotAudioLogDestination':
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class BotButton(dict):
    """
    A button to use on a response card used to gather slot values from a user.
    """
    def __init__(__self__, *,
                 text: str,
                 value: str):
        """
        A button to use on a response card used to gather slot values from a user.
        :param str text: The text that appears on the button.
        :param str value: The value returned to Amazon Lex when the user chooses this button.
        """
        pulumi.set(__self__, "text", text)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        The text that appears on the button.
        """
        return pulumi.get(self, "text")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value returned to Amazon Lex when the user chooses this button.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class BotCloudWatchLogGroupLogDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatchLogGroupArn":
            suggest = "cloud_watch_log_group_arn"
        elif key == "logPrefix":
            suggest = "log_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotCloudWatchLogGroupLogDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotCloudWatchLogGroupLogDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotCloudWatchLogGroupLogDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch_log_group_arn: str,
                 log_prefix: str):
        """
        :param str cloud_watch_log_group_arn: A string used to identify the groupArn for the Cloudwatch Log Group
        :param str log_prefix: A string containing the value for the Log Prefix
        """
        pulumi.set(__self__, "cloud_watch_log_group_arn", cloud_watch_log_group_arn)
        pulumi.set(__self__, "log_prefix", log_prefix)

    @property
    @pulumi.getter(name="cloudWatchLogGroupArn")
    def cloud_watch_log_group_arn(self) -> str:
        """
        A string used to identify the groupArn for the Cloudwatch Log Group
        """
        return pulumi.get(self, "cloud_watch_log_group_arn")

    @property
    @pulumi.getter(name="logPrefix")
    def log_prefix(self) -> str:
        """
        A string containing the value for the Log Prefix
        """
        return pulumi.get(self, "log_prefix")


@pulumi.output_type
class BotConversationLogSettings(dict):
    """
    Contains information about code hooks that Amazon Lex calls during a conversation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "audioLogSettings":
            suggest = "audio_log_settings"
        elif key == "textLogSettings":
            suggest = "text_log_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotConversationLogSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotConversationLogSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotConversationLogSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audio_log_settings: Optional[Sequence['outputs.BotAudioLogSetting']] = None,
                 text_log_settings: Optional[Sequence['outputs.BotTextLogSetting']] = None):
        """
        Contains information about code hooks that Amazon Lex calls during a conversation.
        """
        if audio_log_settings is not None:
            pulumi.set(__self__, "audio_log_settings", audio_log_settings)
        if text_log_settings is not None:
            pulumi.set(__self__, "text_log_settings", text_log_settings)

    @property
    @pulumi.getter(name="audioLogSettings")
    def audio_log_settings(self) -> Optional[Sequence['outputs.BotAudioLogSetting']]:
        return pulumi.get(self, "audio_log_settings")

    @property
    @pulumi.getter(name="textLogSettings")
    def text_log_settings(self) -> Optional[Sequence['outputs.BotTextLogSetting']]:
        return pulumi.get(self, "text_log_settings")


@pulumi.output_type
class BotCustomPayload(dict):
    """
    A message in a custom format defined by the client application.
    """
    def __init__(__self__, *,
                 value: str):
        """
        A message in a custom format defined by the client application.
        :param str value: The string that is sent to your application.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The string that is sent to your application.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class BotCustomVocabulary(dict):
    """
    A custom vocabulary is a list of specific phrases that you want Amazon Lex V2 to recognize in the audio input.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customVocabularyItems":
            suggest = "custom_vocabulary_items"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotCustomVocabulary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotCustomVocabulary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotCustomVocabulary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_vocabulary_items: Sequence['outputs.BotCustomVocabularyItem']):
        """
        A custom vocabulary is a list of specific phrases that you want Amazon Lex V2 to recognize in the audio input.
        """
        pulumi.set(__self__, "custom_vocabulary_items", custom_vocabulary_items)

    @property
    @pulumi.getter(name="customVocabularyItems")
    def custom_vocabulary_items(self) -> Sequence['outputs.BotCustomVocabularyItem']:
        return pulumi.get(self, "custom_vocabulary_items")


@pulumi.output_type
class BotCustomVocabularyItem(dict):
    """
    A custom vocabulary item that contains the phrase to recognize and a weight to give the boost.
    """
    def __init__(__self__, *,
                 phrase: str,
                 weight: Optional[int] = None):
        """
        A custom vocabulary item that contains the phrase to recognize and a weight to give the boost.
        :param str phrase: Phrase that should be recognized.
        :param int weight: The degree to which the phrase recognition is boosted.
        """
        pulumi.set(__self__, "phrase", phrase)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def phrase(self) -> str:
        """
        Phrase that should be recognized.
        """
        return pulumi.get(self, "phrase")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        The degree to which the phrase recognition is boosted.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class BotDialogCodeHookSetting(dict):
    """
    Settings that determine the Lambda function that Amazon Lex uses for processing user responses.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Settings that determine the Lambda function that Amazon Lex uses for processing user responses.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class BotExternalSourceSetting(dict):
    """
    Provides information about the external source of the slot type's definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "grammarSlotTypeSetting":
            suggest = "grammar_slot_type_setting"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotExternalSourceSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotExternalSourceSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotExternalSourceSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 grammar_slot_type_setting: Optional['outputs.BotGrammarSlotTypeSetting'] = None):
        """
        Provides information about the external source of the slot type's definition.
        """
        if grammar_slot_type_setting is not None:
            pulumi.set(__self__, "grammar_slot_type_setting", grammar_slot_type_setting)

    @property
    @pulumi.getter(name="grammarSlotTypeSetting")
    def grammar_slot_type_setting(self) -> Optional['outputs.BotGrammarSlotTypeSetting']:
        return pulumi.get(self, "grammar_slot_type_setting")


@pulumi.output_type
class BotFulfillmentCodeHookSetting(dict):
    """
    Settings that determine if a Lambda function should be invoked to fulfill a specific intent.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fulfillmentUpdatesSpecification":
            suggest = "fulfillment_updates_specification"
        elif key == "postFulfillmentStatusSpecification":
            suggest = "post_fulfillment_status_specification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotFulfillmentCodeHookSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotFulfillmentCodeHookSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotFulfillmentCodeHookSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 fulfillment_updates_specification: Optional['outputs.BotFulfillmentUpdatesSpecification'] = None,
                 post_fulfillment_status_specification: Optional['outputs.BotPostFulfillmentStatusSpecification'] = None):
        """
        Settings that determine if a Lambda function should be invoked to fulfill a specific intent.
        """
        pulumi.set(__self__, "enabled", enabled)
        if fulfillment_updates_specification is not None:
            pulumi.set(__self__, "fulfillment_updates_specification", fulfillment_updates_specification)
        if post_fulfillment_status_specification is not None:
            pulumi.set(__self__, "post_fulfillment_status_specification", post_fulfillment_status_specification)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="fulfillmentUpdatesSpecification")
    def fulfillment_updates_specification(self) -> Optional['outputs.BotFulfillmentUpdatesSpecification']:
        return pulumi.get(self, "fulfillment_updates_specification")

    @property
    @pulumi.getter(name="postFulfillmentStatusSpecification")
    def post_fulfillment_status_specification(self) -> Optional['outputs.BotPostFulfillmentStatusSpecification']:
        return pulumi.get(self, "post_fulfillment_status_specification")


@pulumi.output_type
class BotFulfillmentStartResponseSpecification(dict):
    """
    Provides settings for a message that is sent to the user when a fulfillment Lambda function starts running.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "delayInSeconds":
            suggest = "delay_in_seconds"
        elif key == "messageGroups":
            suggest = "message_groups"
        elif key == "allowInterrupt":
            suggest = "allow_interrupt"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotFulfillmentStartResponseSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotFulfillmentStartResponseSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotFulfillmentStartResponseSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delay_in_seconds: int,
                 message_groups: Sequence['outputs.BotMessageGroup'],
                 allow_interrupt: Optional[bool] = None):
        """
        Provides settings for a message that is sent to the user when a fulfillment Lambda function starts running.
        :param int delay_in_seconds: The delay between when the Lambda fulfillment function starts running and the start message is played. If the Lambda function returns before the delay is over, the start message isn't played.
        :param bool allow_interrupt: Determines whether the user can interrupt the start message while it is playing.
        """
        pulumi.set(__self__, "delay_in_seconds", delay_in_seconds)
        pulumi.set(__self__, "message_groups", message_groups)
        if allow_interrupt is not None:
            pulumi.set(__self__, "allow_interrupt", allow_interrupt)

    @property
    @pulumi.getter(name="delayInSeconds")
    def delay_in_seconds(self) -> int:
        """
        The delay between when the Lambda fulfillment function starts running and the start message is played. If the Lambda function returns before the delay is over, the start message isn't played.
        """
        return pulumi.get(self, "delay_in_seconds")

    @property
    @pulumi.getter(name="messageGroups")
    def message_groups(self) -> Sequence['outputs.BotMessageGroup']:
        return pulumi.get(self, "message_groups")

    @property
    @pulumi.getter(name="allowInterrupt")
    def allow_interrupt(self) -> Optional[bool]:
        """
        Determines whether the user can interrupt the start message while it is playing.
        """
        return pulumi.get(self, "allow_interrupt")


@pulumi.output_type
class BotFulfillmentUpdateResponseSpecification(dict):
    """
    Provides settings for a message that is sent periodically to the user while a fulfillment Lambda function is running.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "frequencyInSeconds":
            suggest = "frequency_in_seconds"
        elif key == "messageGroups":
            suggest = "message_groups"
        elif key == "allowInterrupt":
            suggest = "allow_interrupt"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotFulfillmentUpdateResponseSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotFulfillmentUpdateResponseSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotFulfillmentUpdateResponseSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 frequency_in_seconds: int,
                 message_groups: Sequence['outputs.BotMessageGroup'],
                 allow_interrupt: Optional[bool] = None):
        """
        Provides settings for a message that is sent periodically to the user while a fulfillment Lambda function is running.
        :param int frequency_in_seconds: The frequency that a message is sent to the user. When the period ends, Amazon Lex chooses a message from the message groups and plays it to the user. If the fulfillment Lambda returns before the first period ends, an update message is not played to the user.
        :param bool allow_interrupt: Determines whether the user can interrupt an update message while it is playing.
        """
        pulumi.set(__self__, "frequency_in_seconds", frequency_in_seconds)
        pulumi.set(__self__, "message_groups", message_groups)
        if allow_interrupt is not None:
            pulumi.set(__self__, "allow_interrupt", allow_interrupt)

    @property
    @pulumi.getter(name="frequencyInSeconds")
    def frequency_in_seconds(self) -> int:
        """
        The frequency that a message is sent to the user. When the period ends, Amazon Lex chooses a message from the message groups and plays it to the user. If the fulfillment Lambda returns before the first period ends, an update message is not played to the user.
        """
        return pulumi.get(self, "frequency_in_seconds")

    @property
    @pulumi.getter(name="messageGroups")
    def message_groups(self) -> Sequence['outputs.BotMessageGroup']:
        return pulumi.get(self, "message_groups")

    @property
    @pulumi.getter(name="allowInterrupt")
    def allow_interrupt(self) -> Optional[bool]:
        """
        Determines whether the user can interrupt an update message while it is playing.
        """
        return pulumi.get(self, "allow_interrupt")


@pulumi.output_type
class BotFulfillmentUpdatesSpecification(dict):
    """
    Provides information for updating the user on the progress of fulfilling an intent.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startResponse":
            suggest = "start_response"
        elif key == "timeoutInSeconds":
            suggest = "timeout_in_seconds"
        elif key == "updateResponse":
            suggest = "update_response"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotFulfillmentUpdatesSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotFulfillmentUpdatesSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotFulfillmentUpdatesSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active: bool,
                 start_response: Optional['outputs.BotFulfillmentStartResponseSpecification'] = None,
                 timeout_in_seconds: Optional[int] = None,
                 update_response: Optional['outputs.BotFulfillmentUpdateResponseSpecification'] = None):
        """
        Provides information for updating the user on the progress of fulfilling an intent.
        :param bool active: Determines whether fulfillment updates are sent to the user. When this field is true, updates are sent.
        :param int timeout_in_seconds: The length of time that the fulfillment Lambda function should run before it times out.
        """
        pulumi.set(__self__, "active", active)
        if start_response is not None:
            pulumi.set(__self__, "start_response", start_response)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if update_response is not None:
            pulumi.set(__self__, "update_response", update_response)

    @property
    @pulumi.getter
    def active(self) -> bool:
        """
        Determines whether fulfillment updates are sent to the user. When this field is true, updates are sent.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="startResponse")
    def start_response(self) -> Optional['outputs.BotFulfillmentStartResponseSpecification']:
        return pulumi.get(self, "start_response")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[int]:
        """
        The length of time that the fulfillment Lambda function should run before it times out.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @property
    @pulumi.getter(name="updateResponse")
    def update_response(self) -> Optional['outputs.BotFulfillmentUpdateResponseSpecification']:
        return pulumi.get(self, "update_response")


@pulumi.output_type
class BotGrammarSlotTypeSetting(dict):
    """
    Settings required for a slot type based on a grammar that you provide.
    """
    def __init__(__self__, *,
                 source: Optional['outputs.BotGrammarSlotTypeSource'] = None):
        """
        Settings required for a slot type based on a grammar that you provide.
        """
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def source(self) -> Optional['outputs.BotGrammarSlotTypeSource']:
        return pulumi.get(self, "source")


@pulumi.output_type
class BotGrammarSlotTypeSource(dict):
    """
    Describes the Amazon S3 bucket name and location for the grammar that is the source for the slot type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3BucketName":
            suggest = "s3_bucket_name"
        elif key == "s3ObjectKey":
            suggest = "s3_object_key"
        elif key == "kmsKeyArn":
            suggest = "kms_key_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotGrammarSlotTypeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotGrammarSlotTypeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotGrammarSlotTypeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_bucket_name: str,
                 s3_object_key: str,
                 kms_key_arn: Optional[str] = None):
        """
        Describes the Amazon S3 bucket name and location for the grammar that is the source for the slot type.
        :param str s3_bucket_name: The name of the S3 bucket that contains the grammar source.
        :param str s3_object_key: The path to the grammar in the S3 bucket.
        :param str kms_key_arn: The Amazon KMS key required to decrypt the contents of the grammar, if any.
        """
        pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        pulumi.set(__self__, "s3_object_key", s3_object_key)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> str:
        """
        The name of the S3 bucket that contains the grammar source.
        """
        return pulumi.get(self, "s3_bucket_name")

    @property
    @pulumi.getter(name="s3ObjectKey")
    def s3_object_key(self) -> str:
        """
        The path to the grammar in the S3 bucket.
        """
        return pulumi.get(self, "s3_object_key")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[str]:
        """
        The Amazon KMS key required to decrypt the contents of the grammar, if any.
        """
        return pulumi.get(self, "kms_key_arn")


@pulumi.output_type
class BotImageResponseCard(dict):
    """
    A message that defines a response card that the client application can show to the user.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageUrl":
            suggest = "image_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotImageResponseCard. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotImageResponseCard.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotImageResponseCard.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 title: str,
                 buttons: Optional[Sequence['outputs.BotButton']] = None,
                 image_url: Optional[str] = None,
                 subtitle: Optional[str] = None):
        """
        A message that defines a response card that the client application can show to the user.
        :param str title: The title to display on the response card.
        :param Sequence['BotButton'] buttons: A list of buttons that should be displayed on the response card.
        :param str image_url: The URL of an image to display on the response card.
        :param str subtitle: The subtitle to display on the response card.
        """
        pulumi.set(__self__, "title", title)
        if buttons is not None:
            pulumi.set(__self__, "buttons", buttons)
        if image_url is not None:
            pulumi.set(__self__, "image_url", image_url)
        if subtitle is not None:
            pulumi.set(__self__, "subtitle", subtitle)

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        The title to display on the response card.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def buttons(self) -> Optional[Sequence['outputs.BotButton']]:
        """
        A list of buttons that should be displayed on the response card.
        """
        return pulumi.get(self, "buttons")

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> Optional[str]:
        """
        The URL of an image to display on the response card.
        """
        return pulumi.get(self, "image_url")

    @property
    @pulumi.getter
    def subtitle(self) -> Optional[str]:
        """
        The subtitle to display on the response card.
        """
        return pulumi.get(self, "subtitle")


@pulumi.output_type
class BotInputContext(dict):
    """
    InputContext specified for the intent.
    """
    def __init__(__self__, *,
                 name: str):
        """
        InputContext specified for the intent.
        :param str name: The name of the context.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the context.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class BotIntent(dict):
    """
    An intent represents an action that the user wants to perform. You create a bot to support one or more related intents.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dialogCodeHook":
            suggest = "dialog_code_hook"
        elif key == "fulfillmentCodeHook":
            suggest = "fulfillment_code_hook"
        elif key == "inputContexts":
            suggest = "input_contexts"
        elif key == "intentClosingSetting":
            suggest = "intent_closing_setting"
        elif key == "intentConfirmationSetting":
            suggest = "intent_confirmation_setting"
        elif key == "kendraConfiguration":
            suggest = "kendra_configuration"
        elif key == "outputContexts":
            suggest = "output_contexts"
        elif key == "parentIntentSignature":
            suggest = "parent_intent_signature"
        elif key == "sampleUtterances":
            suggest = "sample_utterances"
        elif key == "slotPriorities":
            suggest = "slot_priorities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotIntent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotIntent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotIntent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 description: Optional[str] = None,
                 dialog_code_hook: Optional['outputs.BotDialogCodeHookSetting'] = None,
                 fulfillment_code_hook: Optional['outputs.BotFulfillmentCodeHookSetting'] = None,
                 input_contexts: Optional[Sequence['outputs.BotInputContext']] = None,
                 intent_closing_setting: Optional['outputs.BotIntentClosingSetting'] = None,
                 intent_confirmation_setting: Optional['outputs.BotIntentConfirmationSetting'] = None,
                 kendra_configuration: Optional['outputs.BotKendraConfiguration'] = None,
                 output_contexts: Optional[Sequence['outputs.BotOutputContext']] = None,
                 parent_intent_signature: Optional[str] = None,
                 sample_utterances: Optional[Sequence['outputs.BotSampleUtterance']] = None,
                 slot_priorities: Optional[Sequence['outputs.BotSlotPriority']] = None,
                 slots: Optional[Sequence['outputs.BotSlot']] = None):
        """
        An intent represents an action that the user wants to perform. You create a bot to support one or more related intents.
        :param Sequence['BotSlot'] slots: List of slots
        """
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dialog_code_hook is not None:
            pulumi.set(__self__, "dialog_code_hook", dialog_code_hook)
        if fulfillment_code_hook is not None:
            pulumi.set(__self__, "fulfillment_code_hook", fulfillment_code_hook)
        if input_contexts is not None:
            pulumi.set(__self__, "input_contexts", input_contexts)
        if intent_closing_setting is not None:
            pulumi.set(__self__, "intent_closing_setting", intent_closing_setting)
        if intent_confirmation_setting is not None:
            pulumi.set(__self__, "intent_confirmation_setting", intent_confirmation_setting)
        if kendra_configuration is not None:
            pulumi.set(__self__, "kendra_configuration", kendra_configuration)
        if output_contexts is not None:
            pulumi.set(__self__, "output_contexts", output_contexts)
        if parent_intent_signature is not None:
            pulumi.set(__self__, "parent_intent_signature", parent_intent_signature)
        if sample_utterances is not None:
            pulumi.set(__self__, "sample_utterances", sample_utterances)
        if slot_priorities is not None:
            pulumi.set(__self__, "slot_priorities", slot_priorities)
        if slots is not None:
            pulumi.set(__self__, "slots", slots)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dialogCodeHook")
    def dialog_code_hook(self) -> Optional['outputs.BotDialogCodeHookSetting']:
        return pulumi.get(self, "dialog_code_hook")

    @property
    @pulumi.getter(name="fulfillmentCodeHook")
    def fulfillment_code_hook(self) -> Optional['outputs.BotFulfillmentCodeHookSetting']:
        return pulumi.get(self, "fulfillment_code_hook")

    @property
    @pulumi.getter(name="inputContexts")
    def input_contexts(self) -> Optional[Sequence['outputs.BotInputContext']]:
        return pulumi.get(self, "input_contexts")

    @property
    @pulumi.getter(name="intentClosingSetting")
    def intent_closing_setting(self) -> Optional['outputs.BotIntentClosingSetting']:
        return pulumi.get(self, "intent_closing_setting")

    @property
    @pulumi.getter(name="intentConfirmationSetting")
    def intent_confirmation_setting(self) -> Optional['outputs.BotIntentConfirmationSetting']:
        return pulumi.get(self, "intent_confirmation_setting")

    @property
    @pulumi.getter(name="kendraConfiguration")
    def kendra_configuration(self) -> Optional['outputs.BotKendraConfiguration']:
        return pulumi.get(self, "kendra_configuration")

    @property
    @pulumi.getter(name="outputContexts")
    def output_contexts(self) -> Optional[Sequence['outputs.BotOutputContext']]:
        return pulumi.get(self, "output_contexts")

    @property
    @pulumi.getter(name="parentIntentSignature")
    def parent_intent_signature(self) -> Optional[str]:
        return pulumi.get(self, "parent_intent_signature")

    @property
    @pulumi.getter(name="sampleUtterances")
    def sample_utterances(self) -> Optional[Sequence['outputs.BotSampleUtterance']]:
        return pulumi.get(self, "sample_utterances")

    @property
    @pulumi.getter(name="slotPriorities")
    def slot_priorities(self) -> Optional[Sequence['outputs.BotSlotPriority']]:
        return pulumi.get(self, "slot_priorities")

    @property
    @pulumi.getter
    def slots(self) -> Optional[Sequence['outputs.BotSlot']]:
        """
        List of slots
        """
        return pulumi.get(self, "slots")


@pulumi.output_type
class BotIntentClosingSetting(dict):
    """
    Response that Amazon Lex sends to the user when the intent is closed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "closingResponse":
            suggest = "closing_response"
        elif key == "isActive":
            suggest = "is_active"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotIntentClosingSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotIntentClosingSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotIntentClosingSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 closing_response: 'outputs.BotResponseSpecification',
                 is_active: Optional[bool] = None):
        """
        Response that Amazon Lex sends to the user when the intent is closed.
        """
        pulumi.set(__self__, "closing_response", closing_response)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)

    @property
    @pulumi.getter(name="closingResponse")
    def closing_response(self) -> 'outputs.BotResponseSpecification':
        return pulumi.get(self, "closing_response")

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[bool]:
        return pulumi.get(self, "is_active")


@pulumi.output_type
class BotIntentConfirmationSetting(dict):
    """
    Prompts that Amazon Lex sends to the user to confirm the completion of an intent.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "declinationResponse":
            suggest = "declination_response"
        elif key == "promptSpecification":
            suggest = "prompt_specification"
        elif key == "isActive":
            suggest = "is_active"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotIntentConfirmationSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotIntentConfirmationSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotIntentConfirmationSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 declination_response: 'outputs.BotResponseSpecification',
                 prompt_specification: 'outputs.BotPromptSpecification',
                 is_active: Optional[bool] = None):
        """
        Prompts that Amazon Lex sends to the user to confirm the completion of an intent.
        """
        pulumi.set(__self__, "declination_response", declination_response)
        pulumi.set(__self__, "prompt_specification", prompt_specification)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)

    @property
    @pulumi.getter(name="declinationResponse")
    def declination_response(self) -> 'outputs.BotResponseSpecification':
        return pulumi.get(self, "declination_response")

    @property
    @pulumi.getter(name="promptSpecification")
    def prompt_specification(self) -> 'outputs.BotPromptSpecification':
        return pulumi.get(self, "prompt_specification")

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[bool]:
        return pulumi.get(self, "is_active")


@pulumi.output_type
class BotKendraConfiguration(dict):
    """
    Configuration for searching a Amazon Kendra index specified for the intent.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kendraIndex":
            suggest = "kendra_index"
        elif key == "queryFilterString":
            suggest = "query_filter_string"
        elif key == "queryFilterStringEnabled":
            suggest = "query_filter_string_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotKendraConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotKendraConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotKendraConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kendra_index: str,
                 query_filter_string: Optional[str] = None,
                 query_filter_string_enabled: Optional[bool] = None):
        """
        Configuration for searching a Amazon Kendra index specified for the intent.
        :param bool query_filter_string_enabled: Determines whether the AMAZON.KendraSearchIntent intent uses a custom query string to query the Amazon Kendra index.
        """
        pulumi.set(__self__, "kendra_index", kendra_index)
        if query_filter_string is not None:
            pulumi.set(__self__, "query_filter_string", query_filter_string)
        if query_filter_string_enabled is not None:
            pulumi.set(__self__, "query_filter_string_enabled", query_filter_string_enabled)

    @property
    @pulumi.getter(name="kendraIndex")
    def kendra_index(self) -> str:
        return pulumi.get(self, "kendra_index")

    @property
    @pulumi.getter(name="queryFilterString")
    def query_filter_string(self) -> Optional[str]:
        return pulumi.get(self, "query_filter_string")

    @property
    @pulumi.getter(name="queryFilterStringEnabled")
    def query_filter_string_enabled(self) -> Optional[bool]:
        """
        Determines whether the AMAZON.KendraSearchIntent intent uses a custom query string to query the Amazon Kendra index.
        """
        return pulumi.get(self, "query_filter_string_enabled")


@pulumi.output_type
class BotLocale(dict):
    """
    A locale in the bot, which contains the intents and slot types that the bot uses in conversations with users in the specified language and locale.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localeId":
            suggest = "locale_id"
        elif key == "nluConfidenceThreshold":
            suggest = "nlu_confidence_threshold"
        elif key == "customVocabulary":
            suggest = "custom_vocabulary"
        elif key == "slotTypes":
            suggest = "slot_types"
        elif key == "voiceSettings":
            suggest = "voice_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotLocale. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotLocale.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotLocale.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 locale_id: str,
                 nlu_confidence_threshold: float,
                 custom_vocabulary: Optional['outputs.BotCustomVocabulary'] = None,
                 description: Optional[str] = None,
                 intents: Optional[Sequence['outputs.BotIntent']] = None,
                 slot_types: Optional[Sequence['outputs.BotSlotType']] = None,
                 voice_settings: Optional['outputs.BotVoiceSettings'] = None):
        """
        A locale in the bot, which contains the intents and slot types that the bot uses in conversations with users in the specified language and locale.
        :param Sequence['BotIntent'] intents: List of intents
        :param Sequence['BotSlotType'] slot_types: List of SlotTypes
        """
        pulumi.set(__self__, "locale_id", locale_id)
        pulumi.set(__self__, "nlu_confidence_threshold", nlu_confidence_threshold)
        if custom_vocabulary is not None:
            pulumi.set(__self__, "custom_vocabulary", custom_vocabulary)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if intents is not None:
            pulumi.set(__self__, "intents", intents)
        if slot_types is not None:
            pulumi.set(__self__, "slot_types", slot_types)
        if voice_settings is not None:
            pulumi.set(__self__, "voice_settings", voice_settings)

    @property
    @pulumi.getter(name="localeId")
    def locale_id(self) -> str:
        return pulumi.get(self, "locale_id")

    @property
    @pulumi.getter(name="nluConfidenceThreshold")
    def nlu_confidence_threshold(self) -> float:
        return pulumi.get(self, "nlu_confidence_threshold")

    @property
    @pulumi.getter(name="customVocabulary")
    def custom_vocabulary(self) -> Optional['outputs.BotCustomVocabulary']:
        return pulumi.get(self, "custom_vocabulary")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def intents(self) -> Optional[Sequence['outputs.BotIntent']]:
        """
        List of intents
        """
        return pulumi.get(self, "intents")

    @property
    @pulumi.getter(name="slotTypes")
    def slot_types(self) -> Optional[Sequence['outputs.BotSlotType']]:
        """
        List of SlotTypes
        """
        return pulumi.get(self, "slot_types")

    @property
    @pulumi.getter(name="voiceSettings")
    def voice_settings(self) -> Optional['outputs.BotVoiceSettings']:
        return pulumi.get(self, "voice_settings")


@pulumi.output_type
class BotMessage(dict):
    """
    The primary message that Amazon Lex should send to the user.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customPayload":
            suggest = "custom_payload"
        elif key == "imageResponseCard":
            suggest = "image_response_card"
        elif key == "plainTextMessage":
            suggest = "plain_text_message"
        elif key == "sSMLMessage":
            suggest = "s_sml_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotMessage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotMessage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotMessage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_payload: Optional['outputs.BotCustomPayload'] = None,
                 image_response_card: Optional['outputs.BotImageResponseCard'] = None,
                 plain_text_message: Optional['outputs.BotPlainTextMessage'] = None,
                 s_sml_message: Optional['outputs.BotSSMLMessage'] = None):
        """
        The primary message that Amazon Lex should send to the user.
        """
        if custom_payload is not None:
            pulumi.set(__self__, "custom_payload", custom_payload)
        if image_response_card is not None:
            pulumi.set(__self__, "image_response_card", image_response_card)
        if plain_text_message is not None:
            pulumi.set(__self__, "plain_text_message", plain_text_message)
        if s_sml_message is not None:
            pulumi.set(__self__, "s_sml_message", s_sml_message)

    @property
    @pulumi.getter(name="customPayload")
    def custom_payload(self) -> Optional['outputs.BotCustomPayload']:
        return pulumi.get(self, "custom_payload")

    @property
    @pulumi.getter(name="imageResponseCard")
    def image_response_card(self) -> Optional['outputs.BotImageResponseCard']:
        return pulumi.get(self, "image_response_card")

    @property
    @pulumi.getter(name="plainTextMessage")
    def plain_text_message(self) -> Optional['outputs.BotPlainTextMessage']:
        return pulumi.get(self, "plain_text_message")

    @property
    @pulumi.getter(name="sSMLMessage")
    def s_sml_message(self) -> Optional['outputs.BotSSMLMessage']:
        return pulumi.get(self, "s_sml_message")


@pulumi.output_type
class BotMessageGroup(dict):
    """
    One or more messages that Amazon Lex can send to the user.
    """
    def __init__(__self__, *,
                 message: 'outputs.BotMessage',
                 variations: Optional[Sequence['outputs.BotMessage']] = None):
        """
        One or more messages that Amazon Lex can send to the user.
        :param Sequence['BotMessage'] variations: Message variations to send to the user.
        """
        pulumi.set(__self__, "message", message)
        if variations is not None:
            pulumi.set(__self__, "variations", variations)

    @property
    @pulumi.getter
    def message(self) -> 'outputs.BotMessage':
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def variations(self) -> Optional[Sequence['outputs.BotMessage']]:
        """
        Message variations to send to the user.
        """
        return pulumi.get(self, "variations")


@pulumi.output_type
class BotMultipleValuesSetting(dict):
    """
    Indicates whether a slot can return multiple values.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowMultipleValues":
            suggest = "allow_multiple_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotMultipleValuesSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotMultipleValuesSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotMultipleValuesSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_multiple_values: Optional[bool] = None):
        """
        Indicates whether a slot can return multiple values.
        """
        if allow_multiple_values is not None:
            pulumi.set(__self__, "allow_multiple_values", allow_multiple_values)

    @property
    @pulumi.getter(name="allowMultipleValues")
    def allow_multiple_values(self) -> Optional[bool]:
        return pulumi.get(self, "allow_multiple_values")


@pulumi.output_type
class BotObfuscationSetting(dict):
    """
    Determines whether Amazon Lex obscures slot values in conversation logs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "obfuscationSettingType":
            suggest = "obfuscation_setting_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotObfuscationSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotObfuscationSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotObfuscationSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 obfuscation_setting_type: 'BotObfuscationSettingObfuscationSettingType'):
        """
        Determines whether Amazon Lex obscures slot values in conversation logs.
        :param 'BotObfuscationSettingObfuscationSettingType' obfuscation_setting_type: Value that determines whether Amazon Lex obscures slot values in conversation logs. The default is to obscure the values.
        """
        pulumi.set(__self__, "obfuscation_setting_type", obfuscation_setting_type)

    @property
    @pulumi.getter(name="obfuscationSettingType")
    def obfuscation_setting_type(self) -> 'BotObfuscationSettingObfuscationSettingType':
        """
        Value that determines whether Amazon Lex obscures slot values in conversation logs. The default is to obscure the values.
        """
        return pulumi.get(self, "obfuscation_setting_type")


@pulumi.output_type
class BotOutputContext(dict):
    """
    A session context that is activated when an intent is fulfilled.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeToLiveInSeconds":
            suggest = "time_to_live_in_seconds"
        elif key == "turnsToLive":
            suggest = "turns_to_live"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotOutputContext. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotOutputContext.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotOutputContext.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 time_to_live_in_seconds: int,
                 turns_to_live: int):
        """
        A session context that is activated when an intent is fulfilled.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "time_to_live_in_seconds", time_to_live_in_seconds)
        pulumi.set(__self__, "turns_to_live", turns_to_live)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="timeToLiveInSeconds")
    def time_to_live_in_seconds(self) -> int:
        return pulumi.get(self, "time_to_live_in_seconds")

    @property
    @pulumi.getter(name="turnsToLive")
    def turns_to_live(self) -> int:
        return pulumi.get(self, "turns_to_live")


@pulumi.output_type
class BotPlainTextMessage(dict):
    """
    A message in plain text format.
    """
    def __init__(__self__, *,
                 value: str):
        """
        A message in plain text format.
        :param str value: The message to send to the user.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The message to send to the user.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class BotPostFulfillmentStatusSpecification(dict):
    """
    Provides information for updating the user on the progress of fulfilling an intent.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureResponse":
            suggest = "failure_response"
        elif key == "successResponse":
            suggest = "success_response"
        elif key == "timeoutResponse":
            suggest = "timeout_response"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotPostFulfillmentStatusSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotPostFulfillmentStatusSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotPostFulfillmentStatusSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_response: Optional['outputs.BotResponseSpecification'] = None,
                 success_response: Optional['outputs.BotResponseSpecification'] = None,
                 timeout_response: Optional['outputs.BotResponseSpecification'] = None):
        """
        Provides information for updating the user on the progress of fulfilling an intent.
        """
        if failure_response is not None:
            pulumi.set(__self__, "failure_response", failure_response)
        if success_response is not None:
            pulumi.set(__self__, "success_response", success_response)
        if timeout_response is not None:
            pulumi.set(__self__, "timeout_response", timeout_response)

    @property
    @pulumi.getter(name="failureResponse")
    def failure_response(self) -> Optional['outputs.BotResponseSpecification']:
        return pulumi.get(self, "failure_response")

    @property
    @pulumi.getter(name="successResponse")
    def success_response(self) -> Optional['outputs.BotResponseSpecification']:
        return pulumi.get(self, "success_response")

    @property
    @pulumi.getter(name="timeoutResponse")
    def timeout_response(self) -> Optional['outputs.BotResponseSpecification']:
        return pulumi.get(self, "timeout_response")


@pulumi.output_type
class BotPromptSpecification(dict):
    """
    Prompts the user to confirm the intent.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxRetries":
            suggest = "max_retries"
        elif key == "messageGroupsList":
            suggest = "message_groups_list"
        elif key == "allowInterrupt":
            suggest = "allow_interrupt"
        elif key == "messageSelectionStrategy":
            suggest = "message_selection_strategy"
        elif key == "promptAttemptsSpecification":
            suggest = "prompt_attempts_specification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotPromptSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotPromptSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotPromptSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_retries: int,
                 message_groups_list: Sequence['outputs.BotMessageGroup'],
                 allow_interrupt: Optional[bool] = None,
                 message_selection_strategy: Optional['BotMessageSelectionStrategy'] = None,
                 prompt_attempts_specification: Optional[Any] = None):
        """
        Prompts the user to confirm the intent.
        :param bool allow_interrupt: Indicates whether the user can interrupt a speech prompt from the bot.
        :param Any prompt_attempts_specification: Specifies the advanced settings on each attempt of the prompt.
        """
        pulumi.set(__self__, "max_retries", max_retries)
        pulumi.set(__self__, "message_groups_list", message_groups_list)
        if allow_interrupt is not None:
            pulumi.set(__self__, "allow_interrupt", allow_interrupt)
        if message_selection_strategy is not None:
            pulumi.set(__self__, "message_selection_strategy", message_selection_strategy)
        if prompt_attempts_specification is not None:
            pulumi.set(__self__, "prompt_attempts_specification", prompt_attempts_specification)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> int:
        return pulumi.get(self, "max_retries")

    @property
    @pulumi.getter(name="messageGroupsList")
    def message_groups_list(self) -> Sequence['outputs.BotMessageGroup']:
        return pulumi.get(self, "message_groups_list")

    @property
    @pulumi.getter(name="allowInterrupt")
    def allow_interrupt(self) -> Optional[bool]:
        """
        Indicates whether the user can interrupt a speech prompt from the bot.
        """
        return pulumi.get(self, "allow_interrupt")

    @property
    @pulumi.getter(name="messageSelectionStrategy")
    def message_selection_strategy(self) -> Optional['BotMessageSelectionStrategy']:
        return pulumi.get(self, "message_selection_strategy")

    @property
    @pulumi.getter(name="promptAttemptsSpecification")
    def prompt_attempts_specification(self) -> Optional[Any]:
        """
        Specifies the advanced settings on each attempt of the prompt.
        """
        return pulumi.get(self, "prompt_attempts_specification")


@pulumi.output_type
class BotResponseSpecification(dict):
    """
    A list of message groups that Amazon Lex uses to respond the user input.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageGroupsList":
            suggest = "message_groups_list"
        elif key == "allowInterrupt":
            suggest = "allow_interrupt"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotResponseSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotResponseSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotResponseSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_groups_list: Sequence['outputs.BotMessageGroup'],
                 allow_interrupt: Optional[bool] = None):
        """
        A list of message groups that Amazon Lex uses to respond the user input.
        :param bool allow_interrupt: Indicates whether the user can interrupt a speech prompt from the bot.
        """
        pulumi.set(__self__, "message_groups_list", message_groups_list)
        if allow_interrupt is not None:
            pulumi.set(__self__, "allow_interrupt", allow_interrupt)

    @property
    @pulumi.getter(name="messageGroupsList")
    def message_groups_list(self) -> Sequence['outputs.BotMessageGroup']:
        return pulumi.get(self, "message_groups_list")

    @property
    @pulumi.getter(name="allowInterrupt")
    def allow_interrupt(self) -> Optional[bool]:
        """
        Indicates whether the user can interrupt a speech prompt from the bot.
        """
        return pulumi.get(self, "allow_interrupt")


@pulumi.output_type
class BotS3BucketLogDestination(dict):
    """
    Specifies an Amazon S3 bucket for logging audio conversations
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logPrefix":
            suggest = "log_prefix"
        elif key == "s3BucketArn":
            suggest = "s3_bucket_arn"
        elif key == "kmsKeyArn":
            suggest = "kms_key_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotS3BucketLogDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotS3BucketLogDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotS3BucketLogDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_prefix: str,
                 s3_bucket_arn: str,
                 kms_key_arn: Optional[str] = None):
        """
        Specifies an Amazon S3 bucket for logging audio conversations
        :param str log_prefix: The Amazon S3 key of the deployment package.
        :param str s3_bucket_arn: The Amazon Resource Name (ARN) of an Amazon S3 bucket where audio log files are stored.
        :param str kms_key_arn: The Amazon Resource Name (ARN) of an AWS Key Management Service (KMS) key for encrypting audio log files stored in an S3 bucket.
        """
        pulumi.set(__self__, "log_prefix", log_prefix)
        pulumi.set(__self__, "s3_bucket_arn", s3_bucket_arn)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter(name="logPrefix")
    def log_prefix(self) -> str:
        """
        The Amazon S3 key of the deployment package.
        """
        return pulumi.get(self, "log_prefix")

    @property
    @pulumi.getter(name="s3BucketArn")
    def s3_bucket_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of an Amazon S3 bucket where audio log files are stored.
        """
        return pulumi.get(self, "s3_bucket_arn")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of an AWS Key Management Service (KMS) key for encrypting audio log files stored in an S3 bucket.
        """
        return pulumi.get(self, "kms_key_arn")


@pulumi.output_type
class BotS3Location(dict):
    """
    S3 location of bot definitions zip file, if it's not defined inline in CloudFormation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Bucket":
            suggest = "s3_bucket"
        elif key == "s3ObjectKey":
            suggest = "s3_object_key"
        elif key == "s3ObjectVersion":
            suggest = "s3_object_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotS3Location. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotS3Location.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotS3Location.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_bucket: str,
                 s3_object_key: str,
                 s3_object_version: Optional[str] = None):
        """
        S3 location of bot definitions zip file, if it's not defined inline in CloudFormation.
        :param str s3_bucket: An Amazon S3 bucket in the same AWS Region as your function. The bucket can be in a different AWS account.
        :param str s3_object_key: The Amazon S3 key of the deployment package.
        :param str s3_object_version: For versioned objects, the version of the deployment package object to use. If not specified, the current object version will be used.
        """
        pulumi.set(__self__, "s3_bucket", s3_bucket)
        pulumi.set(__self__, "s3_object_key", s3_object_key)
        if s3_object_version is not None:
            pulumi.set(__self__, "s3_object_version", s3_object_version)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> str:
        """
        An Amazon S3 bucket in the same AWS Region as your function. The bucket can be in a different AWS account.
        """
        return pulumi.get(self, "s3_bucket")

    @property
    @pulumi.getter(name="s3ObjectKey")
    def s3_object_key(self) -> str:
        """
        The Amazon S3 key of the deployment package.
        """
        return pulumi.get(self, "s3_object_key")

    @property
    @pulumi.getter(name="s3ObjectVersion")
    def s3_object_version(self) -> Optional[str]:
        """
        For versioned objects, the version of the deployment package object to use. If not specified, the current object version will be used.
        """
        return pulumi.get(self, "s3_object_version")


@pulumi.output_type
class BotSSMLMessage(dict):
    """
    A message in Speech Synthesis Markup Language (SSML).
    """
    def __init__(__self__, *,
                 value: str):
        """
        A message in Speech Synthesis Markup Language (SSML).
        :param str value: The SSML text that defines the prompt.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The SSML text that defines the prompt.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class BotSampleUtterance(dict):
    """
    A sample utterance that invokes an intent or respond to a slot elicitation prompt.
    """
    def __init__(__self__, *,
                 utterance: str):
        """
        A sample utterance that invokes an intent or respond to a slot elicitation prompt.
        """
        pulumi.set(__self__, "utterance", utterance)

    @property
    @pulumi.getter
    def utterance(self) -> str:
        return pulumi.get(self, "utterance")


@pulumi.output_type
class BotSampleValue(dict):
    """
    Defines one of the values for a slot type.
    """
    def __init__(__self__, *,
                 value: str):
        """
        Defines one of the values for a slot type.
        :param str value: The value that can be used for a slot type.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value that can be used for a slot type.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class BotSlot(dict):
    """
    A slot is a variable needed to fulfill an intent, where an intent can require zero or more slots.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "slotTypeName":
            suggest = "slot_type_name"
        elif key == "valueElicitationSetting":
            suggest = "value_elicitation_setting"
        elif key == "multipleValuesSetting":
            suggest = "multiple_values_setting"
        elif key == "obfuscationSetting":
            suggest = "obfuscation_setting"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotSlot. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotSlot.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotSlot.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 slot_type_name: str,
                 value_elicitation_setting: 'outputs.BotSlotValueElicitationSetting',
                 description: Optional[str] = None,
                 multiple_values_setting: Optional['outputs.BotMultipleValuesSetting'] = None,
                 obfuscation_setting: Optional['outputs.BotObfuscationSetting'] = None):
        """
        A slot is a variable needed to fulfill an intent, where an intent can require zero or more slots.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "slot_type_name", slot_type_name)
        pulumi.set(__self__, "value_elicitation_setting", value_elicitation_setting)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if multiple_values_setting is not None:
            pulumi.set(__self__, "multiple_values_setting", multiple_values_setting)
        if obfuscation_setting is not None:
            pulumi.set(__self__, "obfuscation_setting", obfuscation_setting)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="slotTypeName")
    def slot_type_name(self) -> str:
        return pulumi.get(self, "slot_type_name")

    @property
    @pulumi.getter(name="valueElicitationSetting")
    def value_elicitation_setting(self) -> 'outputs.BotSlotValueElicitationSetting':
        return pulumi.get(self, "value_elicitation_setting")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="multipleValuesSetting")
    def multiple_values_setting(self) -> Optional['outputs.BotMultipleValuesSetting']:
        return pulumi.get(self, "multiple_values_setting")

    @property
    @pulumi.getter(name="obfuscationSetting")
    def obfuscation_setting(self) -> Optional['outputs.BotObfuscationSetting']:
        return pulumi.get(self, "obfuscation_setting")


@pulumi.output_type
class BotSlotDefaultValue(dict):
    """
    The default value to use when a user doesn't provide a value for a slot.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotSlotDefaultValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotSlotDefaultValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotSlotDefaultValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_value: str):
        """
        The default value to use when a user doesn't provide a value for a slot.
        :param str default_value: The default value to use when a user doesn't provide a value for a slot.
        """
        pulumi.set(__self__, "default_value", default_value)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> str:
        """
        The default value to use when a user doesn't provide a value for a slot.
        """
        return pulumi.get(self, "default_value")


@pulumi.output_type
class BotSlotDefaultValueSpecification(dict):
    """
    A list of values that Amazon Lex should use as the default value for a slot.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValueList":
            suggest = "default_value_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotSlotDefaultValueSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotSlotDefaultValueSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotSlotDefaultValueSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_value_list: Sequence['outputs.BotSlotDefaultValue']):
        """
        A list of values that Amazon Lex should use as the default value for a slot.
        :param Sequence['BotSlotDefaultValue'] default_value_list: A list of slot default values
        """
        pulumi.set(__self__, "default_value_list", default_value_list)

    @property
    @pulumi.getter(name="defaultValueList")
    def default_value_list(self) -> Sequence['outputs.BotSlotDefaultValue']:
        """
        A list of slot default values
        """
        return pulumi.get(self, "default_value_list")


@pulumi.output_type
class BotSlotPriority(dict):
    """
    The priority that Amazon Lex should use when eliciting slot values from a user.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "slotName":
            suggest = "slot_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotSlotPriority. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotSlotPriority.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotSlotPriority.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 priority: int,
                 slot_name: str):
        """
        The priority that Amazon Lex should use when eliciting slot values from a user.
        :param str slot_name: The name of the slot.
        """
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "slot_name", slot_name)

    @property
    @pulumi.getter
    def priority(self) -> int:
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="slotName")
    def slot_name(self) -> str:
        """
        The name of the slot.
        """
        return pulumi.get(self, "slot_name")


@pulumi.output_type
class BotSlotType(dict):
    """
    A custom, extended built-in or a grammar slot type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalSourceSetting":
            suggest = "external_source_setting"
        elif key == "parentSlotTypeSignature":
            suggest = "parent_slot_type_signature"
        elif key == "slotTypeValues":
            suggest = "slot_type_values"
        elif key == "valueSelectionSetting":
            suggest = "value_selection_setting"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotSlotType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotSlotType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotSlotType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 description: Optional[str] = None,
                 external_source_setting: Optional['outputs.BotExternalSourceSetting'] = None,
                 parent_slot_type_signature: Optional[str] = None,
                 slot_type_values: Optional[Sequence['outputs.BotSlotTypeValue']] = None,
                 value_selection_setting: Optional['outputs.BotSlotValueSelectionSetting'] = None):
        """
        A custom, extended built-in or a grammar slot type.
        """
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_source_setting is not None:
            pulumi.set(__self__, "external_source_setting", external_source_setting)
        if parent_slot_type_signature is not None:
            pulumi.set(__self__, "parent_slot_type_signature", parent_slot_type_signature)
        if slot_type_values is not None:
            pulumi.set(__self__, "slot_type_values", slot_type_values)
        if value_selection_setting is not None:
            pulumi.set(__self__, "value_selection_setting", value_selection_setting)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="externalSourceSetting")
    def external_source_setting(self) -> Optional['outputs.BotExternalSourceSetting']:
        return pulumi.get(self, "external_source_setting")

    @property
    @pulumi.getter(name="parentSlotTypeSignature")
    def parent_slot_type_signature(self) -> Optional[str]:
        return pulumi.get(self, "parent_slot_type_signature")

    @property
    @pulumi.getter(name="slotTypeValues")
    def slot_type_values(self) -> Optional[Sequence['outputs.BotSlotTypeValue']]:
        return pulumi.get(self, "slot_type_values")

    @property
    @pulumi.getter(name="valueSelectionSetting")
    def value_selection_setting(self) -> Optional['outputs.BotSlotValueSelectionSetting']:
        return pulumi.get(self, "value_selection_setting")


@pulumi.output_type
class BotSlotTypeValue(dict):
    """
    Value that the slot type can take.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sampleValue":
            suggest = "sample_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotSlotTypeValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotSlotTypeValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotSlotTypeValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sample_value: 'outputs.BotSampleValue',
                 synonyms: Optional[Sequence['outputs.BotSampleValue']] = None):
        """
        Value that the slot type can take.
        """
        pulumi.set(__self__, "sample_value", sample_value)
        if synonyms is not None:
            pulumi.set(__self__, "synonyms", synonyms)

    @property
    @pulumi.getter(name="sampleValue")
    def sample_value(self) -> 'outputs.BotSampleValue':
        return pulumi.get(self, "sample_value")

    @property
    @pulumi.getter
    def synonyms(self) -> Optional[Sequence['outputs.BotSampleValue']]:
        return pulumi.get(self, "synonyms")


@pulumi.output_type
class BotSlotValueElicitationSetting(dict):
    """
    Settings that you can use for eliciting a slot value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "slotConstraint":
            suggest = "slot_constraint"
        elif key == "defaultValueSpecification":
            suggest = "default_value_specification"
        elif key == "promptSpecification":
            suggest = "prompt_specification"
        elif key == "sampleUtterances":
            suggest = "sample_utterances"
        elif key == "waitAndContinueSpecification":
            suggest = "wait_and_continue_specification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotSlotValueElicitationSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotSlotValueElicitationSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotSlotValueElicitationSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 slot_constraint: 'BotSlotConstraint',
                 default_value_specification: Optional['outputs.BotSlotDefaultValueSpecification'] = None,
                 prompt_specification: Optional['outputs.BotPromptSpecification'] = None,
                 sample_utterances: Optional[Sequence['outputs.BotSampleUtterance']] = None,
                 wait_and_continue_specification: Optional['outputs.BotWaitAndContinueSpecification'] = None):
        """
        Settings that you can use for eliciting a slot value.
        :param 'BotSlotConstraint' slot_constraint: Specifies whether the slot is required or optional.
        :param 'BotSlotDefaultValueSpecification' default_value_specification: A list of default values for a slot.
        :param 'BotPromptSpecification' prompt_specification: The prompt that Amazon Lex uses to elicit the slot value from the user.
        :param Sequence['BotSampleUtterance'] sample_utterances: If you know a specific pattern that users might respond to an Amazon Lex request for a slot value, you can provide those utterances to improve accuracy.
        :param 'BotWaitAndContinueSpecification' wait_and_continue_specification: Specifies the prompts that Amazon Lex uses while a bot is waiting for customer input.
        """
        pulumi.set(__self__, "slot_constraint", slot_constraint)
        if default_value_specification is not None:
            pulumi.set(__self__, "default_value_specification", default_value_specification)
        if prompt_specification is not None:
            pulumi.set(__self__, "prompt_specification", prompt_specification)
        if sample_utterances is not None:
            pulumi.set(__self__, "sample_utterances", sample_utterances)
        if wait_and_continue_specification is not None:
            pulumi.set(__self__, "wait_and_continue_specification", wait_and_continue_specification)

    @property
    @pulumi.getter(name="slotConstraint")
    def slot_constraint(self) -> 'BotSlotConstraint':
        """
        Specifies whether the slot is required or optional.
        """
        return pulumi.get(self, "slot_constraint")

    @property
    @pulumi.getter(name="defaultValueSpecification")
    def default_value_specification(self) -> Optional['outputs.BotSlotDefaultValueSpecification']:
        """
        A list of default values for a slot.
        """
        return pulumi.get(self, "default_value_specification")

    @property
    @pulumi.getter(name="promptSpecification")
    def prompt_specification(self) -> Optional['outputs.BotPromptSpecification']:
        """
        The prompt that Amazon Lex uses to elicit the slot value from the user.
        """
        return pulumi.get(self, "prompt_specification")

    @property
    @pulumi.getter(name="sampleUtterances")
    def sample_utterances(self) -> Optional[Sequence['outputs.BotSampleUtterance']]:
        """
        If you know a specific pattern that users might respond to an Amazon Lex request for a slot value, you can provide those utterances to improve accuracy.
        """
        return pulumi.get(self, "sample_utterances")

    @property
    @pulumi.getter(name="waitAndContinueSpecification")
    def wait_and_continue_specification(self) -> Optional['outputs.BotWaitAndContinueSpecification']:
        """
        Specifies the prompts that Amazon Lex uses while a bot is waiting for customer input.
        """
        return pulumi.get(self, "wait_and_continue_specification")


@pulumi.output_type
class BotSlotValueRegexFilter(dict):
    """
    A regular expression used to validate the value of a slot.
    """
    def __init__(__self__, *,
                 pattern: str):
        """
        A regular expression used to validate the value of a slot.
        :param str pattern: Regex pattern
        """
        pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter
    def pattern(self) -> str:
        """
        Regex pattern
        """
        return pulumi.get(self, "pattern")


@pulumi.output_type
class BotSlotValueSelectionSetting(dict):
    """
    Contains settings used by Amazon Lex to select a slot value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resolutionStrategy":
            suggest = "resolution_strategy"
        elif key == "advancedRecognitionSetting":
            suggest = "advanced_recognition_setting"
        elif key == "regexFilter":
            suggest = "regex_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotSlotValueSelectionSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotSlotValueSelectionSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotSlotValueSelectionSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resolution_strategy: 'BotSlotValueResolutionStrategy',
                 advanced_recognition_setting: Optional['outputs.BotAdvancedRecognitionSetting'] = None,
                 regex_filter: Optional['outputs.BotSlotValueRegexFilter'] = None):
        """
        Contains settings used by Amazon Lex to select a slot value.
        """
        pulumi.set(__self__, "resolution_strategy", resolution_strategy)
        if advanced_recognition_setting is not None:
            pulumi.set(__self__, "advanced_recognition_setting", advanced_recognition_setting)
        if regex_filter is not None:
            pulumi.set(__self__, "regex_filter", regex_filter)

    @property
    @pulumi.getter(name="resolutionStrategy")
    def resolution_strategy(self) -> 'BotSlotValueResolutionStrategy':
        return pulumi.get(self, "resolution_strategy")

    @property
    @pulumi.getter(name="advancedRecognitionSetting")
    def advanced_recognition_setting(self) -> Optional['outputs.BotAdvancedRecognitionSetting']:
        return pulumi.get(self, "advanced_recognition_setting")

    @property
    @pulumi.getter(name="regexFilter")
    def regex_filter(self) -> Optional['outputs.BotSlotValueRegexFilter']:
        return pulumi.get(self, "regex_filter")


@pulumi.output_type
class BotStillWaitingResponseSpecification(dict):
    """
    StillWaitingResponseSpecification.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "frequencyInSeconds":
            suggest = "frequency_in_seconds"
        elif key == "messageGroupsList":
            suggest = "message_groups_list"
        elif key == "timeoutInSeconds":
            suggest = "timeout_in_seconds"
        elif key == "allowInterrupt":
            suggest = "allow_interrupt"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotStillWaitingResponseSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotStillWaitingResponseSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotStillWaitingResponseSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 frequency_in_seconds: int,
                 message_groups_list: Sequence['outputs.BotMessageGroup'],
                 timeout_in_seconds: int,
                 allow_interrupt: Optional[bool] = None):
        """
        StillWaitingResponseSpecification.
        :param bool allow_interrupt: Indicates whether the user can interrupt a speech prompt from the bot.
        """
        pulumi.set(__self__, "frequency_in_seconds", frequency_in_seconds)
        pulumi.set(__self__, "message_groups_list", message_groups_list)
        pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if allow_interrupt is not None:
            pulumi.set(__self__, "allow_interrupt", allow_interrupt)

    @property
    @pulumi.getter(name="frequencyInSeconds")
    def frequency_in_seconds(self) -> int:
        return pulumi.get(self, "frequency_in_seconds")

    @property
    @pulumi.getter(name="messageGroupsList")
    def message_groups_list(self) -> Sequence['outputs.BotMessageGroup']:
        return pulumi.get(self, "message_groups_list")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> int:
        return pulumi.get(self, "timeout_in_seconds")

    @property
    @pulumi.getter(name="allowInterrupt")
    def allow_interrupt(self) -> Optional[bool]:
        """
        Indicates whether the user can interrupt a speech prompt from the bot.
        """
        return pulumi.get(self, "allow_interrupt")


@pulumi.output_type
class BotTag(dict):
    """
    A key-value pair for tagging Lex resources
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        A key-value pair for tagging Lex resources
        :param str key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        :param str value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class BotTestBotAliasSettings(dict):
    """
    Configuring the test bot alias settings for a given bot
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "botAliasLocaleSettings":
            suggest = "bot_alias_locale_settings"
        elif key == "conversationLogSettings":
            suggest = "conversation_log_settings"
        elif key == "sentimentAnalysisSettings":
            suggest = "sentiment_analysis_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotTestBotAliasSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotTestBotAliasSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotTestBotAliasSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bot_alias_locale_settings: Optional[Sequence['outputs.BotAliasLocaleSettingsItem']] = None,
                 conversation_log_settings: Optional['outputs.BotConversationLogSettings'] = None,
                 description: Optional[str] = None,
                 sentiment_analysis_settings: Optional['outputs.BotTestBotAliasSettingsSentimentAnalysisSettingsProperties'] = None):
        """
        Configuring the test bot alias settings for a given bot
        :param 'BotTestBotAliasSettingsSentimentAnalysisSettingsProperties' sentiment_analysis_settings: Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.
        """
        if bot_alias_locale_settings is not None:
            pulumi.set(__self__, "bot_alias_locale_settings", bot_alias_locale_settings)
        if conversation_log_settings is not None:
            pulumi.set(__self__, "conversation_log_settings", conversation_log_settings)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if sentiment_analysis_settings is not None:
            pulumi.set(__self__, "sentiment_analysis_settings", sentiment_analysis_settings)

    @property
    @pulumi.getter(name="botAliasLocaleSettings")
    def bot_alias_locale_settings(self) -> Optional[Sequence['outputs.BotAliasLocaleSettingsItem']]:
        return pulumi.get(self, "bot_alias_locale_settings")

    @property
    @pulumi.getter(name="conversationLogSettings")
    def conversation_log_settings(self) -> Optional['outputs.BotConversationLogSettings']:
        return pulumi.get(self, "conversation_log_settings")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="sentimentAnalysisSettings")
    def sentiment_analysis_settings(self) -> Optional['outputs.BotTestBotAliasSettingsSentimentAnalysisSettingsProperties']:
        """
        Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.
        """
        return pulumi.get(self, "sentiment_analysis_settings")


@pulumi.output_type
class BotTestBotAliasSettingsSentimentAnalysisSettingsProperties(dict):
    """
    Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detectSentiment":
            suggest = "detect_sentiment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotTestBotAliasSettingsSentimentAnalysisSettingsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotTestBotAliasSettingsSentimentAnalysisSettingsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotTestBotAliasSettingsSentimentAnalysisSettingsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 detect_sentiment: bool):
        """
        Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.
        :param bool detect_sentiment: Enable to call Amazon Comprehend for Sentiment natively within Lex
        """
        pulumi.set(__self__, "detect_sentiment", detect_sentiment)

    @property
    @pulumi.getter(name="detectSentiment")
    def detect_sentiment(self) -> bool:
        """
        Enable to call Amazon Comprehend for Sentiment natively within Lex
        """
        return pulumi.get(self, "detect_sentiment")


@pulumi.output_type
class BotTextLogDestination(dict):
    """
    Defines the Amazon CloudWatch Logs destination log group for conversation text logs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatch":
            suggest = "cloud_watch"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotTextLogDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotTextLogDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotTextLogDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch: 'outputs.BotCloudWatchLogGroupLogDestination'):
        """
        Defines the Amazon CloudWatch Logs destination log group for conversation text logs.
        """
        pulumi.set(__self__, "cloud_watch", cloud_watch)

    @property
    @pulumi.getter(name="cloudWatch")
    def cloud_watch(self) -> 'outputs.BotCloudWatchLogGroupLogDestination':
        return pulumi.get(self, "cloud_watch")


@pulumi.output_type
class BotTextLogSetting(dict):
    """
    Contains information about code hooks that Amazon Lex calls during a conversation.
    """
    def __init__(__self__, *,
                 destination: 'outputs.BotTextLogDestination',
                 enabled: bool):
        """
        Contains information about code hooks that Amazon Lex calls during a conversation.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.BotTextLogDestination':
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class BotVersionLocaleDetails(dict):
    """
    The version of a bot used for a bot locale.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceBotVersion":
            suggest = "source_bot_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotVersionLocaleDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotVersionLocaleDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotVersionLocaleDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_bot_version: str):
        """
        The version of a bot used for a bot locale.
        """
        pulumi.set(__self__, "source_bot_version", source_bot_version)

    @property
    @pulumi.getter(name="sourceBotVersion")
    def source_bot_version(self) -> str:
        return pulumi.get(self, "source_bot_version")


@pulumi.output_type
class BotVersionLocaleSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "botVersionLocaleDetails":
            suggest = "bot_version_locale_details"
        elif key == "localeId":
            suggest = "locale_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotVersionLocaleSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotVersionLocaleSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotVersionLocaleSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bot_version_locale_details: 'outputs.BotVersionLocaleDetails',
                 locale_id: str):
        pulumi.set(__self__, "bot_version_locale_details", bot_version_locale_details)
        pulumi.set(__self__, "locale_id", locale_id)

    @property
    @pulumi.getter(name="botVersionLocaleDetails")
    def bot_version_locale_details(self) -> 'outputs.BotVersionLocaleDetails':
        return pulumi.get(self, "bot_version_locale_details")

    @property
    @pulumi.getter(name="localeId")
    def locale_id(self) -> str:
        return pulumi.get(self, "locale_id")


@pulumi.output_type
class BotVoiceSettings(dict):
    """
    Settings for using an Amazon Polly voice to communicate with a user.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "voiceId":
            suggest = "voice_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotVoiceSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotVoiceSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotVoiceSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 voice_id: str,
                 engine: Optional['BotVoiceSettingsEngine'] = None):
        """
        Settings for using an Amazon Polly voice to communicate with a user.
        :param str voice_id: The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.
        :param 'BotVoiceSettingsEngine' engine: Indicates the type of Amazon Polly voice that Amazon Lex should use for voice interaction with the user. For more information, see the engine parameter of the SynthesizeSpeech operation in the Amazon Polly developer guide.
        """
        pulumi.set(__self__, "voice_id", voice_id)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)

    @property
    @pulumi.getter(name="voiceId")
    def voice_id(self) -> str:
        """
        The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.
        """
        return pulumi.get(self, "voice_id")

    @property
    @pulumi.getter
    def engine(self) -> Optional['BotVoiceSettingsEngine']:
        """
        Indicates the type of Amazon Polly voice that Amazon Lex should use for voice interaction with the user. For more information, see the engine parameter of the SynthesizeSpeech operation in the Amazon Polly developer guide.
        """
        return pulumi.get(self, "engine")


@pulumi.output_type
class BotWaitAndContinueSpecification(dict):
    """
    The prompts that Amazon Lex uses while a bot is waiting for customer input.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "continueResponse":
            suggest = "continue_response"
        elif key == "waitingResponse":
            suggest = "waiting_response"
        elif key == "isActive":
            suggest = "is_active"
        elif key == "stillWaitingResponse":
            suggest = "still_waiting_response"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotWaitAndContinueSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotWaitAndContinueSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotWaitAndContinueSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 continue_response: 'outputs.BotResponseSpecification',
                 waiting_response: 'outputs.BotResponseSpecification',
                 is_active: Optional[bool] = None,
                 still_waiting_response: Optional['outputs.BotStillWaitingResponseSpecification'] = None):
        """
        The prompts that Amazon Lex uses while a bot is waiting for customer input.
        :param 'BotResponseSpecification' continue_response: The response that Amazon Lex sends to indicate that the bot is ready to continue the conversation.
        :param 'BotResponseSpecification' waiting_response: The response that Amazon Lex sends to indicate that the bot is waiting for the conversation to continue.
        :param bool is_active: Specifies whether the bot will wait for a user to respond.
        :param 'BotStillWaitingResponseSpecification' still_waiting_response: The response that Amazon Lex sends periodically to the user to indicate that the bot is still waiting for input from the user.
        """
        pulumi.set(__self__, "continue_response", continue_response)
        pulumi.set(__self__, "waiting_response", waiting_response)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if still_waiting_response is not None:
            pulumi.set(__self__, "still_waiting_response", still_waiting_response)

    @property
    @pulumi.getter(name="continueResponse")
    def continue_response(self) -> 'outputs.BotResponseSpecification':
        """
        The response that Amazon Lex sends to indicate that the bot is ready to continue the conversation.
        """
        return pulumi.get(self, "continue_response")

    @property
    @pulumi.getter(name="waitingResponse")
    def waiting_response(self) -> 'outputs.BotResponseSpecification':
        """
        The response that Amazon Lex sends to indicate that the bot is waiting for the conversation to continue.
        """
        return pulumi.get(self, "waiting_response")

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[bool]:
        """
        Specifies whether the bot will wait for a user to respond.
        """
        return pulumi.get(self, "is_active")

    @property
    @pulumi.getter(name="stillWaitingResponse")
    def still_waiting_response(self) -> Optional['outputs.BotStillWaitingResponseSpecification']:
        """
        The response that Amazon Lex sends periodically to the user to indicate that the bot is still waiting for input from the user.
        """
        return pulumi.get(self, "still_waiting_response")


@pulumi.output_type
class DataPrivacyProperties(dict):
    """
    Data privacy setting of the Bot.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "childDirected":
            suggest = "child_directed"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataPrivacyProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataPrivacyProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataPrivacyProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 child_directed: bool):
        """
        Data privacy setting of the Bot.
        """
        pulumi.set(__self__, "child_directed", child_directed)

    @property
    @pulumi.getter(name="childDirected")
    def child_directed(self) -> bool:
        return pulumi.get(self, "child_directed")


@pulumi.output_type
class ResourcePolicyPolicy(dict):
    """
    A resource policy to add to the resource. The policy is a JSON structure following the IAM syntax that contains one or more statements that define the policy.
    """
    def __init__(__self__):
        """
        A resource policy to add to the resource. The policy is a JSON structure following the IAM syntax that contains one or more statements that define the policy.
        """
        pass


@pulumi.output_type
class SentimentAnalysisSettingsProperties(dict):
    """
    Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detectSentiment":
            suggest = "detect_sentiment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SentimentAnalysisSettingsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SentimentAnalysisSettingsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SentimentAnalysisSettingsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 detect_sentiment: bool):
        """
        Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.
        :param bool detect_sentiment: Enable to call Amazon Comprehend for Sentiment natively within Lex
        """
        pulumi.set(__self__, "detect_sentiment", detect_sentiment)

    @property
    @pulumi.getter(name="detectSentiment")
    def detect_sentiment(self) -> bool:
        """
        Enable to call Amazon Comprehend for Sentiment natively within Lex
        """
        return pulumi.get(self, "detect_sentiment")


