//ϵͳ
#ifdef WIN32
#include "pch.h"
#endif

#include "vnhft.h"
#include "pybind11/pybind11.h"
#include "hft/hft_trader_api.h"


using namespace pybind11;
using namespace HFT;



///-------------------------------------------------------------------------------------
///C++ SPIĻصʵ
///-------------------------------------------------------------------------------------

//APIļ̳ʵ
class TdApi : public TraderSpi
{
private:
	TraderApi* api;            //API
    bool active = false;       //״̬

public:
    TdApi()
    {
    };

    ~TdApi()
    {
        if (this->active)
        {
            this->exit();
        }
    };

    //-------------------------------------------------------------------------------------
    //APIص
    //-------------------------------------------------------------------------------------

	/**
	 * ӶϿʱص
	 */
	virtual void OnDisconnect();

	/**
	 * ϢصϵͳʱŻص
	 *
	 * @param error_info    Ϣ
	 * @param request_id    Ӧʱкţ󴥷Ĵ󣬴ֵֶΪ0
	 */
	virtual void OnError(ErrorInfo* error_info, int request_id = 0);

	/**
	 * ظ澯Ϣ֪ͨص
	 *
	 * @param risk_notify   ظ澯Ϣ
	 */
	virtual void OnRiskNotify(RiskNotify* risk_notify);

	/**
	 * ¼ɹʧʱص
	 *
	 * @param rsp           ¼ӦݣͻšͻɶϢ
	 * @param error_info    Ϣ
	 */
	virtual void OnLogin(LoginRsp* rsp, ErrorInfo* error_info);

	/**
	 * ɽرص
	 *
	 * @param trade_detail  صĳɽ
	 */
	virtual void OnTradeReport(TradeDetail* trade_detail);

	/**
	 * ״̬仯ص
	 *
	 * @param order_detail  صĶ
	 */
	virtual void OnOrderStatus(OrderDetail* order_detail);

	/**
	 * ίеӦ
	 *
	 * @param order_rsp     ίӦ
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 * @param is_last       ǷǱһӦ
	 */
	virtual void OnOrderRsp(OrderRsp* order_rsp, ErrorInfo* error_info,
		int request_id, bool is_last);

	/**
	 * Ӧ
	 *
	 * @param cancel_rsp    Ӧ
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 * @param is_last       ǷǱһӦ
	 */
	virtual void OnCancelRsp(CancelRsp* cancel_rsp, ErrorInfo* error_info,
		int request_id, bool is_last);

	/**
	 * ѯնӦһηһ
	 * QueryOrderQueryOrderByCodeQueryOrdersɴ˽ӿӦ
	 *
	 * @param order_detail  
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 * @param is_last       ǷǱһӦ
	 * @param pos_str       βѯһ¼Ķλһβѯ
	 */
	virtual void OnQueryOrderRsp(OrderDetail* order_detail,
		ErrorInfo* error_info, int request_id,
		bool is_last, const char* pos_str);

	/**
	 * ѯճɽӦһηһɽ
	 * QueryTradeByCodeQueryTradeByOrderIdQueryTradesQueryETFTradesɴ˽ӿӦ
	 *
	 * @param trade_detail  ɽ
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 * @param is_last       ǷǱһӦ
	 * @param pos_str       βѯһ¼Ķλһβѯ
	 */
	virtual void OnQueryTradeRsp(TradeDetail* trade_detail,
		ErrorInfo* error_info, int request_id,
		bool is_last, const char* pos_str);

	/**
	 * ѯճֲӦһηһֲ
	 * QueryPositionQueryPositionsɴ˽ӿӦ
	 *
	 * @param position_detail   ֲ
	 * @param error_info        ӦĴϢ
	 * @param request_id        Ӧʱк
	 * @param is_last           ǷһӦ
	 * @param pos_str           βѯһ¼Ķλһβѯ
	 */
	virtual void OnQueryPositionRsp(PositionDetail* position_detail,
		ErrorInfo* error_info, int request_id,
		bool is_last, const char* pos_str);

	/**
	 * ѯʽӦ
	 *
	 * @param cash_detail   ʽ
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 */
	virtual void OnQueryCashRsp(CashDetail* cash_detail, ErrorInfo* error_info,
		int request_id);

	/**
	 * 鼯нϵͳʽ
	 *
	 * @param avail_balance ʽ𣬵λ
	 * @param error_info    ӦĴϢ
	 * @param request_id    кţƥӦûԶ壬0
	 */
	virtual void OnQueryJZJYAvailFundRsp(int64_t avail_balance,
		ErrorInfo* error_info,
		int request_id);

	/**
	 * н׹̨ٹ̨֮ʽתת
	 *
	 * @param transfer_value    ת
	 * @param error_info        ӦĴϢ
	 * @param request_id        кţƥӦûԶ
	 */
	virtual void OnTransferFundInAndOutRsp(int64_t transfer_value,
		ErrorInfo* error_info,
		int request_id);

	/**
	 * ͬһʽ˺ţһ֮ʽת
	 *
	 * @param transfer_value    ת
	 * @param error_info        ӦĴϢ
	 * @param request_id        кţƥӦûԶ
	 */
	virtual void OnTransferFundBetweenSecuidRsp(int64_t transfer_value,
		ErrorInfo* error_info,
		int request_id);

	/**
	 * ѯETFϢӦÿηһETFϢ
	 *
	 * @param etf_detail    ETFϢ
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 * @param is_last       ǷǱһӦ
	 */
	virtual void OnQueryETFRsp(ETFDetail* etf_detail, ErrorInfo* error_info,
		int request_id, bool is_last);

	/**
	 * ѯһETFƱӵӦÿηETFһƱϢ
	 *
	 * @param etf_stock_detail      ETFһƱϢ
	 * @param error_info            ӦĴϢ
	 * @param request_id            Ӧʱк
	 * @param is_last               ǷǱһӦ
	 */
	virtual void OnQueryETFStockRsp(ETFStockDetail* etf_stock_detail,
		ErrorInfo* error_info, int request_id,
		bool is_last);

	/**
	 * ѯίص
	 *
	 * @param detail        ί
	 * @param error_info    ӦĴϢ
	 * @param request_id    кţƥӦûԶ壬0
	 */
	virtual void OnQueryMaxOrderQtyRsp(MaxOrderQtyDetail* detail,
		ErrorInfo* error_info, int request_id);

	/**
	 * ѯ¹ɿ깺ȵӦ
	 *
	 * @param detail        ¹ɿ깺
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 */
	virtual void OnQueryIPOMaxPurchaseRsp(IPOMaxPurchaseDetail* detail,
		ErrorInfo* error_info, int request_id,
		bool is_last);

	/**
	 * ѯ¹ɵӦ
	 *
	 * @param detail        ¹
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 */
	virtual void OnQueryIPOStockRsp(IPOStockDetail* detail,
		ErrorInfo* error_info, int request_id,
		bool is_last);

	/**
	 * ѯ¹ŵӦ
	 *
	 * @param detail        ¹
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 * @param is_last       ǷǱһӦ
	 * @param pos_str       βѯһ¼Ķλһβѯ
	 */
	virtual void OnQueryIPODistributionRsp(IPODistributionDetail* detail,
		ErrorInfo* error_info,
		int request_id, bool is_last,
		const char* pos_str);

	/**
	 * ѯ¹ǩӦ
	 *
	 * @param detail        ¹ǩ
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 * @param is_last       ǷǱһӦ
	 * @param pos_str       βѯһ¼Ķλһβѯ
	 */
	virtual void OnQueryIPOLotteryRsp(IPOLotteryDetail* detail,
		ErrorInfo* error_info, int request_id,
		bool is_last, const char* pos_str);

	/**
	* ѯ֤ȯϢӦ
	*
	* @param detail            ֤ȯϢ
	* @param error_info        ӦĴϢ
	* @param request_id        Ӧʱк
	* @param is_last           ǷһӦ
	*/
	virtual void OnQuerySecurityBaseInfoRsp(SecurityBaseInfo* detail, ErrorInfo* error_info,
		int request_id, bool is_last);

	/**
	 * ƷתתӦص
	 *
	 * @param rsp           ƷתתӦ
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 */
	virtual void OnCreditMortgageInOutRsp(CreditMortgageInOutRsp* rsp,
		ErrorInfo* error_info,
		int request_id);

	/**
	 * ȯȯӦص
	 *
	 * @param rsp           ȯȯӦ
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 */
	virtual void OnCreditStockBackRsp(CreditStockBackRsp* rsp,
		ErrorInfo* error_info, int request_id);

	/**
	 * ֱӻӦص
	 *
	 * @param rsp           ֱӻӦ
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 */
	virtual void OnCreditPayBackRsp(CreditPayBackRsp* rsp,
		ErrorInfo* error_info, int request_id);

	/**
	 * ָԼֱӻ
	 *
	 * @param rsp           Ϣ
	 * @param error_info    ӦĴϢ
	 * @param request_id    кţƥӦûԶ
	 */
	virtual void OnCreditPayBackByOrderRsp(CreditPayBackRsp* rsp,
		ErrorInfo* error_info,
		int request_id);

	/**
	 * ñȯӦص
	 *
	 * @param detail        ñȯ
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 * @param is_last       ǷǱһӦ
	 * @param pos_str       βѯһ¼Ķλһβѯ
	 */
	virtual void OnQueryCreditStockRsp(CreditStockDetail* detail,
		ErrorInfo* error_info, int request_id,
		bool is_last, const char* pos_str);

	/**
	 * ѯƷȯص
	 *
	 * @param detail        ƷȯϢ
	 * @param error_info    ӦĴϢ
	 * @param request_id    кţƥӦûԶ壬0
	 * @param is_last       ǷǱһӦ
	 * @param pos_str       βѯһ¼Ķλһβѯ
	 */
	virtual void OnQueryCreditMortgageHoldRsp(CreditMortgageHoldDetail* detail,
		ErrorInfo* error_info,
		int request_id, bool is_last,
		const char* pos_str);

	/**
	 * ʲѯӦص
	 *
	 * @param detail        ʲ
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 */
	virtual void OnQueryCreditAssetsRsp(CreditAssetsDetail* detail,
		ErrorInfo* error_info, int request_id);

	/**
	 * ѯʺԼӦص
	 *
	 * @param detail        ʺԼ
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 * @param is_last       ǷǱһӦ
	 * @param pos_str       βѯһ¼Ķλһβѯ
	 */
	virtual void OnQueryCreditFinanceRsp(CreditFinanceDetail* detail,
		ErrorInfo* error_info, int request_id,
		bool is_last, const char* pos_str);

	/**
	 * ѯȯԼӦص
	 *
	 * @param detail        ȯԼ
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 * @param is_last       ǷǱһӦ
	 * @param pos_str       βѯһ¼Ķλһβѯ
	 */
	virtual void OnQueryCreditShortsellRsp(CreditShortsellDetail* detail,
		ErrorInfo* error_info,
		int request_id, bool is_last,
		const char* pos_str);

	/**
	 * ѯɻʸծӦص
	 *
	 * @param detail        ɻ
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 */
	virtual void OnQueryCreditRepayAmountRsp(CreditRepayAmountDetail* detail,
		ErrorInfo* error_info,
		int request_id);

	/**
	 * ѯȯծӦص
	 *
	 * @param detail        ɻ
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 * @param is_last       ǷǱһӦ
	 * @param pos_str       βѯһ¼Ķλһβѯ
	 */
	virtual void OnQueryCreditRepayStockRsp(CreditRepayStockDetail* detail,
		ErrorInfo* error_info,
		int request_id, bool is_last,
		const char* pos_str);

	/**
	 * ѯȯָȯĿ
	 *
	 * @param rsp               ѯϢ
	 * @param error_info        ӦĴϢ
	 * @param request_id        кţƥӦûԶ
	 * @param is_last           ǷǱһӦ
	 */
	virtual void OnQueryCreditSecuritySellQtyRsp(CreditSecuritySellQtyRsp* rsp,
		ErrorInfo* error_info,
		int request_id, bool is_last);

	/**
	 * ѯ˻Ȩ޻ص
	 *
	 * @param market        г,"SZ SH",ԭص
	 * @param secuid_right  Ȩ,紴ҵ,ԭص
	 * @param error_info    ӦĴϢ
	 * @param sign_flag     ǩȨޱ־,trueȨ
	 * @param request_id    кţƥӦûԶ壬0
	 */
	virtual void OnQuerySecuidRightRsp(const char* market, int16_t secuid_right,
		ErrorInfo* error_info, bool sign_flag,
		int request_id);

	// ͨͨнӿ
	/**
	 * ѯͨοʵӦ
	 *
	 * @param detail        ͨο
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 * @param is_last       ǷǱһӦ
	 */
	virtual void OnQueryHKRateRsp(HKRateDetail* detail, ErrorInfo* error_info,
		int request_id, bool is_last);

	/**
	 * ѯͨȯӦ
	 *
	 * @param detail        ͨȯ
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 * @param is_last       ǷǱһӦ
	 */
	virtual void OnQueryHKStockRsp(HKStockDetail* detail, ErrorInfo* error_info,
		int request_id, bool is_last);

	/**
	 * ѯͨʽʲӦ
	 *
	 * @param detail        ͨʽʲ
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 */
	virtual void OnQueryHKFundRsp(HKFundDetail* detail, ErrorInfo* error_info,
		int request_id);

	/**
	 * ѯͨС۲Ӧ
	 *
	 * @param detail        ͨС۲
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 * @param is_last       ǷǱһӦ
	 */
	virtual void OnQueryHKMinPriceUnitRsp(HKMinPriceUnitDetail* detail,
		ErrorInfo* error_info, int request_id,
		bool is_last);

	/**
	 * ѯͨӦ
	 *
	 * @param detail        ͨ
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 * @param is_last       ǷǱһӦ
	 */
	virtual void OnQueryHKTradeCalendarRsp(HKTradeCalendarDetail* detail,
		ErrorInfo* error_info,
		int request_id, bool is_last);

	/**
	 * ѯȯϸӦ
	 *
	 * @param detail        ȯϸ
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 * @param is_last       ǷǱһӦ
	 */
	virtual void OnQueryLockSecurityDetailRsp(LockSecurityDetail* detail,
		ErrorInfo* error_info,
		int request_id, bool is_last);

	/**
	 * չӦ
	 *
	 * @param apply_sno     
	 * @param apply_date    
	 * @param error_info    ӦĴϢ
	 * @param request_id    кţƥӦûԶ壬0
	 */
	virtual void OnExtendLockSecurityRsp(int32_t apply_sno, int32_t apply_date,
		ErrorInfo* error_info,
		int request_id);

	/**
	 * ѯչӦ
	 *
	 * @param detail        չϸ
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 * @param is_last       ǷǱһӦ
	 */
	virtual void OnQueryLockSecurityExtensionRsp(
		LockSecurityExtensionDetail* detail, ErrorInfo* error_info,
		int request_id, bool is_last);

	/**
	 * ȯչӦ
	 *
	 * @param apply_date    ڣ20190415
	 * @param apply_sno     
	 * @param cancel_sno    
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
	 */
	virtual void OnCancelExtendLockSecurityRsp(int apply_date,
		const char* apply_sno,
		const char* cancel_sno,
		ErrorInfo* error_info,
		int request_id);

	/**
	 * ѯʽתˮӦ
	 *
	 * @param detail        ʽתϸ
	 * @param error_info    ӦĴϢ
	 * @param request_id    Ӧʱк
		 * @param is_last       ǷǱһӦ
		 */
	virtual void OnQueryTransferFundHistoryRsp(TransferFundDetail* detail,
		ErrorInfo* error_info,
		int request_id, bool is_last);



    //-------------------------------------------------------------------------------------
    //dataصֵ
    //errorصĴֵ
    //idid
    //lastǷΪ󷵻
    //i
    //-------------------------------------------------------------------------------------
	virtual void onDisconnect() {};

	virtual void onError(const dict &error, int request_id) {};

	virtual void onRiskNotify(const dict &data) {};

	virtual void onLogin(const dict &data, const dict &error) {};

	virtual void onTradeReport(const dict &data) {};

	virtual void onOrderStatus(const dict &data) {};

	virtual void onOrderRsp(const dict &data, const dict &error, int request_id, bool last) {};

	virtual void onCancelRsp(const dict &data, const dict &error, int request_id, bool last) {};

	virtual void onQueryOrderRsp(const dict &data, const dict &error, int request_id, bool last, string pos_str) {};

	virtual void onQueryTradeRsp(const dict &data, const dict &error, int request_id, bool last, string pos_str) {};

	virtual void onQueryPositionRsp(const dict &data, const dict &error, int request_id, bool last, string pos_str) {};

	virtual void onQueryCashRsp(const dict &data, const dict &error, int request_id) {};

	virtual void onQueryJZJYAvailFundRsp(int64_t avail_balance, const dict &error, int request_id) {};

	virtual void onTransferFundInAndOutRsp(int64_t transfer_value, const dict &error, int request_id) {};

	virtual void onTransferFundBetweenSecuidRsp(int64_t transfer_value, const dict &error, int request_id) {};

	virtual void onQueryETFRsp(const dict &data, const dict &error, int request_id, bool last) {};

	virtual void onQueryETFStockRsp(const dict &data, const dict &error, int request_id, bool last) {};

	virtual void onQueryMaxOrderQtyRsp(const dict &data, const dict &error, int request_id) {};

	virtual void onQueryIPOMaxPurchaseRsp(const dict &data, const dict &error, int request_id, bool last) {};

	virtual void onQueryIPOStockRsp(const dict &data, const dict &error, int request_id, bool last) {};

	virtual void onQueryIPODistributionRsp(const dict &data, const dict &error, int request_id, bool last, string pos_str) {};

	virtual void onQueryIPOLotteryRsp(const dict &data, const dict &error, int request_id, bool last, string pos_str) {};

	virtual void onQuerySecurityBaseInfoRsp(const dict &data, const dict &error, int request_id, bool last) {};

	virtual void onCreditMortgageInOutRsp(const dict &data, const dict &error, int request_id) {};

	virtual void onCreditStockBackRsp(const dict &data, const dict &error, int request_id) {};

	virtual void onCreditPayBackRsp(const dict &data, const dict &error, int request_id) {};

	virtual void onCreditPayBackByOrderRsp(const dict &data, const dict &error, int request_id) {};

	virtual void onQueryCreditStockRsp(const dict &data, const dict &error, int request_id, bool last, string pos_str) {};

	virtual void onQueryCreditMortgageHoldRsp(const dict &data, const dict &error, int request_id, bool last, string pos_str) {};

	virtual void onQueryCreditAssetsRsp(const dict &data, const dict &error, int request_id) {};

	virtual void onQueryCreditFinanceRsp(const dict &data, const dict &error, int request_id, bool last, string pos_str) {};

	virtual void onQueryCreditShortsellRsp(const dict &data, const dict &error, int request_id, bool last, string pos_str) {};

	virtual void onQueryCreditRepayAmountRsp(const dict &data, const dict &error, int request_id) {};

	virtual void onQueryCreditRepayStockRsp(const dict &data, const dict &error, int request_id, bool last, string pos_str) {};

	virtual void onQueryCreditSecuritySellQtyRsp(const dict &data, const dict &error, int request_id, bool last) {};

	virtual void onQuerySecuidRightRsp(string market, int secuid_right, const dict &error, bool last, int request_id) {};

	virtual void onQueryHKRateRsp(const dict &data, const dict &error, int request_id, bool last) {};

	virtual void onQueryHKStockRsp(const dict &data, const dict &error, int request_id, bool last) {};

	virtual void onQueryHKFundRsp(const dict &data, const dict &error, int request_id) {};

	virtual void onQueryHKMinPriceUnitRsp(const dict &data, const dict &error, int request_id, bool last) {};

	virtual void onQueryHKTradeCalendarRsp(const dict &data, const dict &error, int request_id, bool last) {};

	virtual void onQueryLockSecurityDetailRsp(const dict &data, const dict &error, int request_id, bool last) {};

	virtual void onExtendLockSecurityRsp(int apply_sno, int apply_date, const dict &error, int request_id) {};

	virtual void onQueryLockSecurityExtensionRsp(const dict &data, const dict &error, int request_id, bool last) {};

	virtual void onCancelExtendLockSecurityRsp(int apply_date, string apply_sno, string cancel_sno, const dict &error, int request_id) {};

	virtual void onQueryTransferFundHistoryRsp(const dict &data, const dict &error, int request_id, bool last) {};

    //-------------------------------------------------------------------------------------
    //req:ֵ
    //-------------------------------------------------------------------------------------
	void setLogConfig(string log_path);

    void createTraderApi();

    void release();

    int exit();

    string getApiVersion();

	int login(string svr_ip, int svr_port, const dict &req, string terminal_info);

	int getCounterType();

	pybind11::list getSecuidInfo();

	dict getApiLocalAddr();

	int order(const dict &req, int request_id);

	int batchOrder(const dict &req, int count, int request_id);

	int cancelOrder(const dict &req, int request_id);

	int batchCancelOrder(const dict &req, int count, int request_id);

	int queryOrder(string order_id, int request_id, string market);

	int queryOrderByCode(string symbol, int request_id);

	int queryOrders(string pos_str, int query_num, int request_id, int query_flag);

	int queryTradeByOrderId(string order_id, int request_id, string market);

	int queryTradeByCode(string symbol, int request_id);

	int queryTrades(string pos_str, int query_num, int request_id);

	int queryETFTrades(string pos_str, int query_num, int request_id, string market);

	int queryPosition(string symbol, int request_id);

	int queryPositions(string pos_str, int query_num, int request_id);

	int queryCash(int request_id);

	int queryJZJYAvailFund(int request_id);

	int transferFundInAndOut(int transfer_side, int transfer_value, int request_id, string market);

	int transferFundBetweenSecuid(string fund_out_market, string fund_in_market, int transfer_value, int request_id);

	int queryETFs(int request_id);

	int queryETFStocks(string first_symbol, int request_id);

	int queryMaxOrderQty(string symbol, int order_type, int side, int price, int request_id);

	int queryIPOMaxPurchase(int request_id);

	int queryIPOStock(int request_id, int query_flag);

	int queryIPODistribution(int start_date, int end_date, string pos_str, int query_num, int request_id);

	int queryIPOLottery(int start_date, int end_date, string pos_str, int query_num, int request_id);

	int querySecurityBaseInfo(int request_id, string symbol);

	int creditMortgageInOut(const dict &req, int request_id);

	int creditStockBack(const dict &req, int request_id);

	int creditPayBack(int back_amt, int request_id);

	int creditPayBackByOrder(string order_id, int order_date, int back_amt, int request_id);

	int queryCreditStock(string pos_str, int query_num, int request_id);

	int queryCreditMortgageHold(string pos_str, int query_num, int request_id);

	int queryCreditAssets(int request_id);

	int queryCreditFinance(string pos_str, int query_num, int request_id);

	int queryCreditShortsell(string pos_str, int query_num, int request_id);

	int queryCreditRepayAmount(int request_id);

	int queryCreditRepayStock(string market, string code, int request_id);

	int queryCreditSecuritySellQty(string market, string code, int request_id);

	int querySecuidRight(string market, int secuid_right, int request_id);

	int queryHKRate(string market, int request_id);

	int queryHKStock(string market, int request_id);

	int queryHKFund(int request_id);

	int queryHKMinPriceUnit(string market, int request_id);

	int queryHKTradeCalendar(int start_date, int end_date, int request_id);

	int queryLockSecurityDetail(int begin_date, int end_date, int request_id, string market, string code);

	int extendLockSecurity(const dict &req, int request_id);

	int queryLockSecurityExtension(int begin_date, int end_date, int request_id);

	int cancelExtendLockSecurity(int apply_date, string apply_sno, int request_id);

	int queryTransferFundHistory(int request_id);



};
