import * as codedeploy from '@aws-cdk/aws-codedeploy';
import * as codepipeline from '@aws-cdk/aws-codepipeline';
import { Action } from '../action';
import { Construct } from '@aws-cdk/core';
/**
 * Construction properties of the {@link CodeDeployServerDeployAction CodeDeploy server deploy CodePipeline Action}.
 *
 * @stability stable
 */
export interface CodeDeployServerDeployActionProps extends codepipeline.CommonAwsActionProps {
    /**
     * The source to use as input for deployment.
     *
     * @stability stable
     */
    readonly input: codepipeline.Artifact;
    /**
     * The CodeDeploy server Deployment Group to deploy to.
     *
     * @stability stable
     */
    readonly deploymentGroup: codedeploy.IServerDeploymentGroup;
}
/**
 * @stability stable
 */
export declare class CodeDeployServerDeployAction extends Action {
    private readonly deploymentGroup;
    /**
     * @stability stable
     */
    constructor(props: CodeDeployServerDeployActionProps);
    /**
     * The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     *
     * @stability stable
     */
    protected bound(_scope: Construct, _stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
