import * as codepipeline from '@aws-cdk/aws-codepipeline';
import { SecretValue } from '@aws-cdk/core';
import { Action } from '../action';
import { Construct } from '@aws-cdk/core';
/**
 * Construction properties of the {@link AlexaSkillDeployAction Alexa deploy Action}.
 *
 * @stability stable
 */
export interface AlexaSkillDeployActionProps extends codepipeline.CommonActionProps {
    /**
     * The client id of the developer console token.
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * The client secret of the developer console token.
     *
     * @stability stable
     */
    readonly clientSecret: SecretValue;
    /**
     * The refresh token of the developer console token.
     *
     * @stability stable
     */
    readonly refreshToken: SecretValue;
    /**
     * The Alexa skill id.
     *
     * @stability stable
     */
    readonly skillId: string;
    /**
     * The source artifact containing the voice model and skill manifest.
     *
     * @stability stable
     */
    readonly input: codepipeline.Artifact;
    /**
     * An optional artifact containing overrides for the skill manifest.
     *
     * @stability stable
     */
    readonly parameterOverridesArtifact?: codepipeline.Artifact;
}
/**
 * Deploys the skill to Alexa.
 *
 * @stability stable
 */
export declare class AlexaSkillDeployAction extends Action {
    private readonly props;
    /**
     * @stability stable
     */
    constructor(props: AlexaSkillDeployActionProps);
    /**
     * The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     *
     * @stability stable
     */
    protected bound(_scope: Construct, _stage: codepipeline.IStage, _options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
