"""
Wyckoff positions for space groups (reduced coordinate).
    space-group tag: [ (Wyckoff letter, positions, site-symmetry) ]
"""
_data_wyckoff_sg = {
    "C1^1": [("1a", "{[x,y,z]}", "1")],
    "Ci^1": [
        ("1a", "{[0,0,0]}", "-1"),
        ("1b", "{[0,0,1/2]}", "-1"),
        ("1c", "{[0,1/2,0]}", "-1"),
        ("1d", "{[1/2,0,0]}", "-1"),
        ("1e", "{[1/2,1/2,0]}", "-1"),
        ("1f", "{[1/2,0,1/2]}", "-1"),
        ("1g", "{[0,1/2,1/2]}", "-1"),
        ("1h", "{[1/2,1/2,1/2]}", "-1"),
        ("2i", "{[x,y,z],[-x,-y,-z]}", "1"),
    ],
    "C2^1": [
        ("1a", "{[0,y,0]}", "2"),
        ("1b", "{[0,y,1/2]}", "2"),
        ("1c", "{[1/2,y,0]}", "2"),
        ("1d", "{[1/2,y,1/2]}", "2"),
        ("2e", "{[x,y,z],[-x,y,-z]}", "1"),
    ],
    "C2^2": [("2a", "{[x,y,z],[-x,y+1/2,-z]}", "1")],
    "C2^3": [("2a", "{[0,y,0]}", "2"), ("2b", "{[0,y,1/2]}", "2"), ("4c", "{[x,y,z],[-x,y,-z]}", "1")],
    "Cs^1": [("1a", "{[x,0,z]}", "m"), ("1b", "{[x,1/2,z]}", "m"), ("2c", "{[x,y,z],[x,-y,z]}", "1")],
    "Cs^2": [("2a", "{[x,y,z],[x,-y,z+1/2]}", "1")],
    "Cs^3": [("2a", "{[x,0,z]}", "m"), ("4b", "{[x,y,z],[x,-y,z]}", "1")],
    "Cs^4": [("4a", "{[x,y,z],[x,-y,z+1/2]}", "1")],
    "C2h^1": [
        ("1a", "{[0,0,0]}", "2/m"),
        ("1b", "{[0,1/2,0]}", "2/m"),
        ("1c", "{[0,0,1/2]}", "2/m"),
        ("1d", "{[1/2,0,0]}", "2/m"),
        ("1e", "{[1/2,1/2,0]}", "2/m"),
        ("1f", "{[0,1/2,1/2]}", "2/m"),
        ("1g", "{[1/2,0,1/2]}", "2/m"),
        ("1h", "{[1/2,1/2,1/2]}", "2/m"),
        ("2i", "{[0,y,0],[0,-y,0]}", "2"),
        ("2j", "{[1/2,y,0],[1/2,-y,0]}", "2"),
        ("2k", "{[0,y,1/2],[0,-y,1/2]}", "2"),
        ("2l", "{[1/2,y,1/2],[1/2,-y,1/2]}", "2"),
        ("2m", "{[x,0,z],[-x,0,-z]}", "m"),
        ("2n", "{[x,1/2,z],[-x,1/2,-z]}", "m"),
        ("4o", "{[x,y,z],[-x,y,-z],[-x,-y,-z],[x,-y,z]}", "1"),
    ],
    "C2h^2": [
        ("2a", "{[0,0,0],[0,1/2,0]}", "-1"),
        ("2b", "{[1/2,0,0],[1/2,1/2,0]}", "-1"),
        ("2c", "{[0,0,1/2],[0,1/2,1/2]}", "-1"),
        ("2d", "{[1/2,0,1/2],[1/2,1/2,1/2]}", "-1"),
        ("2e", "{[x,1/4,z],[-x,3/4,-z]}", "m"),
        ("4f", "{[x,y,z],[-x,y+1/2,-z],[-x,-y,-z],[x,1/2-y,z]}", "1"),
    ],
    "C2h^3": [
        ("2a", "{[0,0,0]}", "2/m"),
        ("2b", "{[0,1/2,0]}", "2/m"),
        ("2c", "{[0,0,1/2]}", "2/m"),
        ("2d", "{[0,1/2,1/2]}", "2/m"),
        ("4e", "{[1/4,1/4,0],[3/4,1/4,0]}", "-1"),
        ("4f", "{[1/4,1/4,1/2],[3/4,1/4,1/2]}", "-1"),
        ("4g", "{[0,y,0],[0,-y,0]}", "2"),
        ("4h", "{[0,y,1/2],[0,-y,1/2]}", "2"),
        ("4i", "{[x,0,z],[-x,0,-z]}", "m"),
        ("8j", "{[x,y,z],[-x,y,-z],[-x,-y,-z],[x,-y,z]}", "1"),
    ],
    "C2h^4": [
        ("2a", "{[0,0,0],[0,0,1/2]}", "-1"),
        ("2b", "{[1/2,1/2,0],[1/2,1/2,1/2]}", "-1"),
        ("2c", "{[0,1/2,0],[0,1/2,1/2]}", "-1"),
        ("2d", "{[1/2,0,0],[1/2,0,1/2]}", "-1"),
        ("2e", "{[0,y,1/4],[0,-y,3/4]}", "2"),
        ("2f", "{[1/2,y,1/4],[1/2,-y,3/4]}", "2"),
        ("4g", "{[x,y,z],[-x,y,1/2-z],[-x,-y,-z],[x,-y,z+1/2]}", "1"),
    ],
    "C2h^5": [
        ("2a", "{[0,0,0],[0,1/2,1/2]}", "-1"),
        ("2b", "{[1/2,0,0],[1/2,1/2,1/2]}", "-1"),
        ("2c", "{[0,0,1/2],[0,1/2,0]}", "-1"),
        ("2d", "{[1/2,0,1/2],[1/2,1/2,0]}", "-1"),
        ("4e", "{[x,y,z],[-x,y+1/2,1/2-z],[-x,-y,-z],[x,1/2-y,z+1/2]}", "1"),
    ],
    "C2h^6": [
        ("4a", "{[0,0,0],[0,0,1/2]}", "-1"),
        ("4b", "{[0,1/2,0],[0,1/2,1/2]}", "-1"),
        ("4c", "{[1/4,1/4,0],[3/4,1/4,1/2]}", "-1"),
        ("4d", "{[1/4,1/4,1/2],[3/4,1/4,0]}", "-1"),
        ("4e", "{[0,y,1/4],[0,-y,3/4]}", "2"),
        ("8f", "{[x,y,z],[-x,y,1/2-z],[-x,-y,-z],[x,-y,z+1/2]}", "1"),
    ],
    "D2^1": [
        ("1a", "{[0,0,0]}", "222"),
        ("1b", "{[1/2,0,0]}", "222"),
        ("1c", "{[0,1/2,0]}", "222"),
        ("1d", "{[0,0,1/2]}", "222"),
        ("1e", "{[1/2,1/2,0]}", "222"),
        ("1f", "{[1/2,0,1/2]}", "222"),
        ("1g", "{[0,1/2,1/2]}", "222"),
        ("1h", "{[1/2,1/2,1/2]}", "222"),
        ("2i", "{[x,0,0],[-x,0,0]}", "2.."),
        ("2j", "{[x,0,1/2],[-x,0,1/2]}", "2.."),
        ("2k", "{[x,1/2,0],[-x,1/2,0]}", "2.."),
        ("2l", "{[x,1/2,1/2],[-x,1/2,1/2]}", "2.."),
        ("2m", "{[0,y,0],[0,-y,0]}", ".2."),
        ("2n", "{[0,y,1/2],[0,-y,1/2]}", ".2."),
        ("2o", "{[1/2,y,0],[1/2,-y,0]}", ".2."),
        ("2p", "{[1/2,y,1/2],[1/2,-y,1/2]}", ".2."),
        ("2q", "{[0,0,z],[0,0,-z]}", "..2"),
        ("2r", "{[1/2,0,z],[1/2,0,-z]}", "..2"),
        ("2s", "{[0,1/2,z],[0,1/2,-z]}", "..2"),
        ("2t", "{[1/2,1/2,z],[1/2,1/2,-z]}", "..2"),
        ("4u", "{[x,y,z],[-x,-y,z],[-x,y,-z],[x,-y,-z]}", "1"),
    ],
    "D2^2": [
        ("2a", "{[x,0,0],[-x,0,1/2]}", "2.."),
        ("2b", "{[x,1/2,0],[-x,1/2,1/2]}", "2.."),
        ("2c", "{[0,y,1/4],[0,-y,3/4]}", ".2."),
        ("2d", "{[1/2,y,1/4],[1/2,-y,3/4]}", ".2."),
        ("4e", "{[x,y,z],[-x,-y,z+1/2],[-x,y,1/2-z],[x,-y,-z]}", "1"),
    ],
    "D2^3": [
        ("2a", "{[0,0,z],[1/2,1/2,-z]}", "..2"),
        ("2b", "{[0,1/2,z],[1/2,0,-z]}", "..2"),
        ("4c", "{[x,y,z],[-x,-y,z],[1/2-x,y+1/2,-z],[x+1/2,1/2-y,-z]}", "1"),
    ],
    "D2^4": [("4a", "{[x,y,z],[1/2-x,-y,z+1/2],[-x,y+1/2,1/2-z],[x+1/2,1/2-y,-z]}", "1")],
    "D2^5": [
        ("4a", "{[x,0,0],[-x,0,1/2]}", "2.."),
        ("4b", "{[0,y,1/4],[0,-y,3/4]}", ".2."),
        ("8c", "{[x,y,z],[-x,-y,z+1/2],[-x,y,1/2-z],[x,-y,-z]}", "1"),
    ],
    "D2^6": [
        ("2a", "{[0,0,0]}", "222"),
        ("2b", "{[0,1/2,0]}", "222"),
        ("2c", "{[0,1/2,1/2]}", "222"),
        ("2d", "{[0,0,1/2]}", "222"),
        ("4e", "{[x,0,0],[-x,0,0]}", "2.."),
        ("4f", "{[x,0,1/2],[-x,0,1/2]}", "2.."),
        ("4g", "{[0,y,0],[0,-y,0]}", ".2."),
        ("4h", "{[0,y,1/2],[0,-y,1/2]}", ".2."),
        ("4i", "{[0,0,z],[0,0,-z]}", "..2"),
        ("4j", "{[0,1/2,z],[0,1/2,-z]}", "..2"),
        ("4k", "{[1/4,1/4,z],[3/4,1/4,-z]}", "..2"),
        ("8l", "{[x,y,z],[-x,-y,z],[-x,y,-z],[x,-y,-z]}", "1"),
    ],
    "D2^7": [
        ("4a", "{[0,0,0]}", "222"),
        ("4b", "{[1/2,1/2,1/2]}", "222"),
        ("4c", "{[1/4,1/4,1/4]}", "222"),
        ("4d", "{[3/4,3/4,3/4]}", "222"),
        ("8e", "{[x,0,0],[-x,0,0]}", "2.."),
        ("8f", "{[0,y,0],[0,-y,0]}", ".2."),
        ("8g", "{[0,0,z],[0,0,-z]}", "..2"),
        ("8h", "{[1/4,1/4,z],[1/4,1/4,1/2-z]}", "..2"),
        ("8i", "{[1/4,y,1/4],[1/4,1/2-y,1/4]}", ".2."),
        ("8j", "{[x,1/4,1/4],[1/2-x,1/4,1/4]}", "2.."),
        ("16k", "{[x,y,z],[-x,-y,z],[-x,y,-z],[x,-y,-z]}", "1"),
    ],
    "D2^8": [
        ("2a", "{[0,0,0]}", "222"),
        ("2b", "{[1/2,0,0]}", "222"),
        ("2c", "{[0,0,1/2]}", "222"),
        ("2d", "{[0,1/2,0]}", "222"),
        ("4e", "{[x,0,0],[-x,0,0]}", "2.."),
        ("4f", "{[x,0,1/2],[-x,0,1/2]}", "2.."),
        ("4g", "{[0,y,0],[0,-y,0]}", ".2."),
        ("4h", "{[1/2,y,0],[1/2,-y,0]}", ".2."),
        ("4i", "{[0,0,z],[0,0,-z]}", "..2"),
        ("4j", "{[0,1/2,z],[0,1/2,-z]}", "..2"),
        ("8k", "{[x,y,z],[-x,-y,z],[-x,y,-z],[x,-y,-z]}", "1"),
    ],
    "D2^9": [
        ("4a", "{[x,0,1/4],[-x,1/2,1/4]}", "2.."),
        ("4b", "{[1/4,y,0],[1/4,-y,1/2]}", ".2."),
        ("4c", "{[0,1/4,z],[1/2,1/4,-z]}", "..2"),
        ("8d", "{[x,y,z],[1/2-x,-y,z+1/2],[-x,y+1/2,1/2-z],[x+1/2,1/2-y,-z]}", "1"),
    ],
    "C2v^1": [
        ("1a", "{[0,0,z]}", "mm2"),
        ("1b", "{[0,1/2,z]}", "mm2"),
        ("1c", "{[1/2,0,z]}", "mm2"),
        ("1d", "{[1/2,1/2,z]}", "mm2"),
        ("2e", "{[x,0,z],[-x,0,z]}", ".m."),
        ("2f", "{[x,1/2,z],[-x,1/2,z]}", ".m."),
        ("2g", "{[0,y,z],[0,-y,z]}", "m.."),
        ("2h", "{[1/2,y,z],[1/2,-y,z]}", "m.."),
        ("4i", "{[x,y,z],[-x,-y,z],[x,-y,z],[-x,y,z]}", "1"),
    ],
    "C2v^2": [
        ("2a", "{[0,y,z],[0,-y,z+1/2]}", "m.."),
        ("2b", "{[1/2,y,z],[1/2,-y,z+1/2]}", "m.."),
        ("4c", "{[x,y,z],[-x,-y,z+1/2],[x,-y,z+1/2],[-x,y,z]}", "1"),
    ],
    "C2v^3": [
        ("2a", "{[0,0,z],[0,0,z+1/2]}", "..2"),
        ("2b", "{[0,1/2,z],[0,1/2,z+1/2]}", "..2"),
        ("2c", "{[1/2,0,z],[1/2,0,z+1/2]}", "..2"),
        ("2d", "{[1/2,1/2,z],[1/2,1/2,z+1/2]}", "..2"),
        ("4e", "{[x,y,z],[-x,-y,z],[x,-y,z+1/2],[-x,y,z+1/2]}", "1"),
    ],
    "C2v^4": [
        ("2a", "{[0,0,z],[1/2,0,z]}", "..2"),
        ("2b", "{[0,1/2,z],[1/2,1/2,z]}", "..2"),
        ("2c", "{[1/4,y,z],[3/4,-y,z]}", "m.."),
        ("4d", "{[x,y,z],[-x,-y,z],[x+1/2,-y,z],[1/2-x,y,z]}", "1"),
    ],
    "C2v^5": [("4a", "{[x,y,z],[-x,-y,z+1/2],[x+1/2,-y,z],[1/2-x,y,z+1/2]}", "1")],
    "C2v^6": [
        ("2a", "{[0,0,z],[0,1/2,z+1/2]}", "..2"),
        ("2b", "{[1/2,0,z],[1/2,1/2,z+1/2]}", "..2"),
        ("4c", "{[x,y,z],[-x,-y,z],[x,1/2-y,z+1/2],[-x,y+1/2,z+1/2]}", "1"),
    ],
    "C2v^7": [("2a", "{[0,y,z],[1/2,-y,z+1/2]}", "m.."), ("4b", "{[x,y,z],[1/2-x,-y,z+1/2],[x+1/2,-y,z+1/2],[-x,y,z]}", "1")],
    "C2v^8": [
        ("2a", "{[0,0,z],[1/2,1/2,z]}", "..2"),
        ("2b", "{[0,1/2,z],[1/2,0,z]}", "..2"),
        ("4c", "{[x,y,z],[-x,-y,z],[x+1/2,1/2-y,z],[1/2-x,y+1/2,z]}", "1"),
    ],
    "C2v^9": [("4a", "{[x,y,z],[-x,-y,z+1/2],[x+1/2,1/2-y,z],[1/2-x,y+1/2,z+1/2]}", "1")],
    "C2v^10": [
        ("2a", "{[0,0,z],[1/2,1/2,z+1/2]}", "..2"),
        ("2b", "{[0,1/2,z],[1/2,0,z+1/2]}", "..2"),
        ("4c", "{[x,y,z],[-x,-y,z],[x+1/2,1/2-y,z+1/2],[1/2-x,y+1/2,z+1/2]}", "1"),
    ],
    "C2v^11": [
        ("2a", "{[0,0,z]}", "mm2"),
        ("2b", "{[0,1/2,z]}", "mm2"),
        ("4c", "{[1/4,1/4,z],[3/4,1/4,z]}", "..2"),
        ("4d", "{[x,0,z],[-x,0,z]}", ".m."),
        ("4e", "{[0,y,z],[0,-y,z]}", "m.."),
        ("8f", "{[x,y,z],[-x,-y,z],[x,-y,z],[-x,y,z]}", "1"),
    ],
    "C2v^12": [("4a", "{[0,y,z],[0,-y,z+1/2]}", "m.."), ("8b", "{[x,y,z],[-x,-y,z+1/2],[x,-y,z+1/2],[-x,y,z]}", "1")],
    "C2v^13": [
        ("4a", "{[0,0,z],[0,0,z+1/2]}", "..2"),
        ("4b", "{[0,1/2,z],[0,1/2,z+1/2]}", "..2"),
        ("4c", "{[1/4,1/4,z],[3/4,1/4,z+1/2]}", "..2"),
        ("8d", "{[x,y,z],[-x,-y,z],[x,-y,z+1/2],[-x,y,z+1/2]}", "1"),
    ],
    "C2v^14": [
        ("2a", "{[0,0,z]}", "mm2"),
        ("2b", "{[1/2,0,z]}", "mm2"),
        ("4c", "{[x,0,z],[-x,0,z]}", ".m."),
        ("4d", "{[0,y,z],[0,-y,z]}", "m.."),
        ("4e", "{[1/2,y,z],[1/2,-y,z]}", "m.."),
        ("8f", "{[x,y,z],[-x,-y,z],[x,-y,z],[-x,y,z]}", "1"),
    ],
    "C2v^15": [
        ("4a", "{[0,0,z],[0,1/2,z]}", "..2"),
        ("4b", "{[1/2,0,z],[1/2,1/2,z]}", "..2"),
        ("4c", "{[x,1/4,z],[-x,3/4,z]}", ".m."),
        ("8d", "{[x,y,z],[-x,-y,z],[x,1/2-y,z],[-x,y+1/2,z]}", "1"),
    ],
    "C2v^16": [
        ("4a", "{[0,0,z],[1/2,0,z]}", "..2"),
        ("4b", "{[1/4,y,z],[3/4,-y,z]}", "m.."),
        ("8c", "{[x,y,z],[-x,-y,z],[x+1/2,-y,z],[1/2-x,y,z]}", "1"),
    ],
    "C2v^17": [("4a", "{[0,0,z],[1/2,1/2,z]}", "..2"), ("8b", "{[x,y,z],[-x,-y,z],[x+1/2,1/2-y,z],[1/2-x,y+1/2,z]}", "1")],
    "C2v^18": [
        ("4a", "{[0,0,z]}", "mm2"),
        ("8b", "{[1/4,1/4,z],[1/4,1/4,z+1/2]}", "..2"),
        ("8c", "{[0,y,z],[0,-y,z]}", "m.."),
        ("8d", "{[x,0,z],[-x,0,z]}", ".m."),
        ("16e", "{[x,y,z],[-x,-y,z],[x,-y,z],[-x,y,z]}", "1"),
    ],
    "C2v^19": [
        ("8a", "{[0,0,z],[1/4,1/4,z+1/4]}", "..2"),
        ("16b", "{[x,y,z],[-x,-y,z],[x+1/4,1/4-y,z+1/4],[1/4-x,y+1/4,z+1/4]}", "1"),
    ],
    "C2v^20": [
        ("2a", "{[0,0,z]}", "mm2"),
        ("2b", "{[0,1/2,z]}", "mm2"),
        ("4c", "{[x,0,z],[-x,0,z]}", ".m."),
        ("4d", "{[0,y,z],[0,-y,z]}", "m.."),
        ("8e", "{[x,y,z],[-x,-y,z],[x,-y,z],[-x,y,z]}", "1"),
    ],
    "C2v^21": [
        ("4a", "{[0,0,z],[0,0,z+1/2]}", "..2"),
        ("4b", "{[0,1/2,z],[1/2,0,z]}", "..2"),
        ("8c", "{[x,y,z],[-x,-y,z],[x+1/2,1/2-y,z],[1/2-x,y+1/2,z]}", "1"),
    ],
    "C2v^22": [
        ("4a", "{[0,0,z],[1/2,0,z]}", "..2"),
        ("4b", "{[1/4,y,z],[3/4,-y,z]}", "m.."),
        ("8c", "{[x,y,z],[-x,-y,z],[x+1/2,-y,z],[1/2-x,y,z]}", "1"),
    ],
    "D2h^1": [
        ("1a", "{[0,0,0]}", "mmm"),
        ("1b", "{[1/2,0,0]}", "mmm"),
        ("1c", "{[0,0,1/2]}", "mmm"),
        ("1d", "{[1/2,0,1/2]}", "mmm"),
        ("1e", "{[0,1/2,0]}", "mmm"),
        ("1f", "{[1/2,1/2,0]}", "mmm"),
        ("1g", "{[0,1/2,1/2]}", "mmm"),
        ("1h", "{[1/2,1/2,1/2]}", "mmm"),
        ("2i", "{[x,0,0],[-x,0,0]}", "2mm"),
        ("2j", "{[x,0,1/2],[-x,0,1/2]}", "2mm"),
        ("2k", "{[x,1/2,0],[-x,1/2,0]}", "2mm"),
        ("2l", "{[x,1/2,1/2],[-x,1/2,1/2]}", "2mm"),
        ("2m", "{[0,y,0],[0,-y,0]}", "m2m"),
        ("2n", "{[0,y,1/2],[0,-y,1/2]}", "m2m"),
        ("2o", "{[1/2,y,0],[1/2,-y,0]}", "m2m"),
        ("2p", "{[1/2,y,1/2],[1/2,-y,1/2]}", "m2m"),
        ("2q", "{[0,0,z],[0,0,-z]}", "mm2"),
        ("2r", "{[0,1/2,z],[0,1/2,-z]}", "mm2"),
        ("2s", "{[1/2,0,z],[1/2,0,-z]}", "mm2"),
        ("2t", "{[1/2,1/2,z],[1/2,1/2,-z]}", "mm2"),
        ("4u", "{[0,y,z],[0,-y,z],[0,y,-z],[0,-y,-z]}", "m.."),
        ("4v", "{[1/2,y,z],[1/2,-y,z],[1/2,y,-z],[1/2,-y,-z]}", "m.."),
        ("4w", "{[x,0,z],[-x,0,z],[-x,0,-z],[x,0,-z]}", ".m."),
        ("4x", "{[x,1/2,z],[-x,1/2,z],[-x,1/2,-z],[x,1/2,-z]}", ".m."),
        ("4y", "{[x,y,0],[-x,-y,0],[-x,y,0],[x,-y,0]}", "..m"),
        ("4z", "{[x,y,1/2],[-x,-y,1/2],[-x,y,1/2],[x,-y,1/2]}", "..m"),
        ("8A", "{[x,y,z],[-x,-y,z],[-x,y,-z],[x,-y,-z],[-x,-y,-z],[x,y,-z],[x,-y,z],[-x,y,z]}", "1"),
    ],
    "D2h^2": [
        ("2a", "{[1/4,1/4,1/4],[3/4,3/4,3/4]}", "222"),
        ("2b", "{[3/4,1/4,1/4],[1/4,3/4,3/4]}", "222"),
        ("2c", "{[1/4,1/4,3/4],[3/4,3/4,1/4]}", "222"),
        ("2d", "{[1/4,3/4,1/4],[3/4,1/4,3/4]}", "222"),
        ("4e", "{[1/2,1/2,1/2],[0,0,1/2],[0,1/2,0],[1/2,0,0]}", "-1"),
        ("4f", "{[0,0,0],[1/2,1/2,0],[1/2,0,1/2],[0,1/2,1/2]}", "-1"),
        ("4g", "{[x,1/4,1/4],[1/2-x,1/4,1/4],[-x,3/4,3/4],[x+1/2,3/4,3/4]}", "2.."),
        ("4h", "{[x,1/4,3/4],[1/2-x,1/4,3/4],[-x,3/4,1/4],[x+1/2,3/4,1/4]}", "2.."),
        ("4i", "{[1/4,y,1/4],[1/4,1/2-y,1/4],[3/4,-y,3/4],[3/4,y+1/2,3/4]}", ".2."),
        ("4j", "{[3/4,y,1/4],[3/4,1/2-y,1/4],[1/4,-y,3/4],[1/4,y+1/2,3/4]}", ".2."),
        ("4k", "{[1/4,1/4,z],[1/4,1/4,1/2-z],[3/4,3/4,-z],[3/4,3/4,z+1/2]}", "..2"),
        ("4l", "{[1/4,3/4,z],[1/4,3/4,1/2-z],[3/4,1/4,-z],[3/4,1/4,z+1/2]}", "..2"),
        (
            "8m",
            "{[x,y,z],[1/2-x,1/2-y,z],[1/2-x,y,1/2-z],[x,1/2-y,1/2-z],[-x,-y,-z],[x+1/2,y+1/2,-z],[x+1/2,-y,z+1/2],[-x,y+1/2,z+1/2]}",
            "1",
        ),
    ],
    "D2h^3": [
        ("2a", "{[0,0,0],[0,0,1/2]}", "2/m"),
        ("2b", "{[1/2,1/2,0],[1/2,1/2,1/2]}", "2/m"),
        ("2c", "{[0,1/2,0],[0,1/2,1/2]}", "2/m"),
        ("2d", "{[1/2,0,0],[1/2,0,1/2]}", "2/m"),
        ("2e", "{[0,0,1/4],[0,0,3/4]}", "222"),
        ("2f", "{[1/2,0,1/4],[1/2,0,3/4]}", "222"),
        ("2g", "{[0,1/2,1/4],[0,1/2,3/4]}", "222"),
        ("2h", "{[1/2,1/2,1/4],[1/2,1/2,3/4]}", "222"),
        ("4i", "{[x,0,1/4],[-x,0,1/4],[-x,0,3/4],[x,0,3/4]}", "2.."),
        ("4j", "{[x,1/2,1/4],[-x,1/2,1/4],[-x,1/2,3/4],[x,1/2,3/4]}", "2.."),
        ("4k", "{[0,y,1/4],[0,-y,1/4],[0,-y,3/4],[0,y,3/4]}", ".2."),
        ("4l", "{[1/2,y,1/4],[1/2,-y,1/4],[1/2,-y,3/4],[1/2,y,3/4]}", ".2."),
        ("4m", "{[0,0,z],[0,0,1/2-z],[0,0,-z],[0,0,z+1/2]}", "..2"),
        ("4n", "{[1/2,1/2,z],[1/2,1/2,1/2-z],[1/2,1/2,-z],[1/2,1/2,z+1/2]}", "..2"),
        ("4o", "{[0,1/2,z],[0,1/2,1/2-z],[0,1/2,-z],[0,1/2,z+1/2]}", "..2"),
        ("4p", "{[1/2,0,z],[1/2,0,1/2-z],[1/2,0,-z],[1/2,0,z+1/2]}", "..2"),
        ("4q", "{[x,y,0],[-x,-y,0],[-x,y,1/2],[x,-y,1/2]}", "..m"),
        ("8r", "{[x,y,z],[-x,-y,z],[-x,y,1/2-z],[x,-y,1/2-z],[-x,-y,-z],[x,y,-z],[x,-y,z+1/2],[-x,y,z+1/2]}", "1"),
    ],
    "D2h^4": [
        ("2a", "{[1/4,1/4,0],[3/4,3/4,0]}", "222"),
        ("2b", "{[3/4,1/4,0],[1/4,3/4,0]}", "222"),
        ("2c", "{[3/4,1/4,1/2],[1/4,3/4,1/2]}", "222"),
        ("2d", "{[1/4,1/4,1/2],[3/4,3/4,1/2]}", "222"),
        ("4e", "{[0,0,0],[1/2,1/2,0],[1/2,0,0],[0,1/2,0]}", "-1"),
        ("4f", "{[0,0,1/2],[1/2,1/2,1/2],[1/2,0,1/2],[0,1/2,1/2]}", "-1"),
        ("4g", "{[x,1/4,0],[1/2-x,1/4,0],[-x,3/4,0],[x+1/2,3/4,0]}", "2.."),
        ("4h", "{[x,1/4,1/2],[1/2-x,1/4,1/2],[-x,3/4,1/2],[x+1/2,3/4,1/2]}", "2.."),
        ("4i", "{[1/4,y,0],[1/4,1/2-y,0],[3/4,-y,0],[3/4,y+1/2,0]}", ".2."),
        ("4j", "{[1/4,y,1/2],[1/4,1/2-y,1/2],[3/4,-y,1/2],[3/4,y+1/2,1/2]}", ".2."),
        ("4k", "{[1/4,1/4,z],[1/4,1/4,-z],[3/4,3/4,-z],[3/4,3/4,z]}", "..2"),
        ("4l", "{[1/4,3/4,z],[1/4,3/4,-z],[3/4,1/4,-z],[3/4,1/4,z]}", "..2"),
        ("8m", "{[x,y,z],[1/2-x,1/2-y,z],[1/2-x,y,-z],[x,1/2-y,-z],[-x,-y,-z],[x+1/2,y+1/2,-z],[x+1/2,-y,z],[-x,y+1/2,z]}", "1"),
    ],
    "D2h^5": [
        ("2a", "{[0,0,0],[1/2,0,0]}", ".2/m."),
        ("2b", "{[0,1/2,0],[1/2,1/2,0]}", ".2/m."),
        ("2c", "{[0,0,1/2],[1/2,0,1/2]}", ".2/m."),
        ("2d", "{[0,1/2,1/2],[1/2,1/2,1/2]}", ".2/m."),
        ("2e", "{[1/4,0,z],[3/4,0,-z]}", "mm2"),
        ("2f", "{[1/4,1/2,z],[3/4,1/2,-z]}", "mm2"),
        ("4g", "{[0,y,0],[1/2,-y,0],[0,-y,0],[1/2,y,0]}", ".2."),
        ("4h", "{[0,y,1/2],[1/2,-y,1/2],[0,-y,1/2],[1/2,y,1/2]}", ".2."),
        ("4i", "{[x,0,z],[1/2-x,0,z],[-x,0,-z],[x+1/2,0,-z]}", ".m."),
        ("4j", "{[x,1/2,z],[1/2-x,1/2,z],[-x,1/2,-z],[x+1/2,1/2,-z]}", ".m."),
        ("4k", "{[1/4,y,z],[1/4,-y,z],[3/4,y,-z],[3/4,-y,-z]}", "m.."),
        ("8l", "{[x,y,z],[1/2-x,-y,z],[-x,y,-z],[x+1/2,-y,-z],[-x,-y,-z],[x+1/2,y,-z],[x,-y,z],[1/2-x,y,z]}", "1"),
    ],
    "D2h^6": [
        ("4a", "{[0,0,0],[1/2,0,0],[1/2,1/2,1/2],[0,1/2,1/2]}", "-1"),
        ("4b", "{[0,0,1/2],[1/2,0,1/2],[1/2,1/2,0],[0,1/2,0]}", "-1"),
        ("4c", "{[1/4,0,z],[1/4,1/2,1/2-z],[3/4,0,-z],[3/4,1/2,z+1/2]}", "..2"),
        ("4d", "{[x,1/4,1/4],[1/2-x,3/4,1/4],[-x,3/4,3/4],[x+1/2,1/4,3/4]}", "2.."),
        (
            "8e",
            "{[x,y,z],[1/2-x,-y,z],[1/2-x,y+1/2,1/2-z],[x,1/2-y,1/2-z],[-x,-y,-z],[x+1/2,y,-z],[x+1/2,1/2-y,z+1/2],[-x,y+1/2,z+1/2]}",
            "1",
        ),
    ],
    "D2h^7": [
        ("2a", "{[0,0,0],[1/2,0,1/2]}", "2/m.."),
        ("2b", "{[1/2,0,0],[0,0,1/2]}", "2/m.."),
        ("2c", "{[1/2,1/2,0],[0,1/2,1/2]}", "2/m.."),
        ("2d", "{[0,1/2,0],[1/2,1/2,1/2]}", "2/m.."),
        ("4e", "{[x,0,0],[1/2-x,0,1/2],[-x,0,0],[x+1/2,0,1/2]}", "2.."),
        ("4f", "{[x,1/2,0],[1/2-x,1/2,1/2],[-x,1/2,0],[x+1/2,1/2,1/2]}", "2.."),
        ("4g", "{[1/4,y,1/4],[1/4,-y,3/4],[3/4,-y,3/4],[3/4,y,1/4]}", ".2."),
        ("4h", "{[0,y,z],[1/2,-y,z+1/2],[1/2,y,1/2-z],[0,-y,-z]}", "m.."),
        ("8i", "{[x,y,z],[1/2-x,-y,z+1/2],[1/2-x,y,1/2-z],[x,-y,-z],[-x,-y,-z],[x+1/2,y,1/2-z],[x+1/2,-y,z+1/2],[-x,y,z]}", "1"),
    ],
    "D2h^8": [
        ("4a", "{[0,0,0],[1/2,0,0],[0,0,1/2],[1/2,0,1/2]}", "-1"),
        ("4b", "{[0,1/2,0],[1/2,1/2,0],[0,1/2,1/2],[1/2,1/2,1/2]}", "-1"),
        ("4c", "{[0,y,1/4],[1/2,-y,1/4],[0,-y,3/4],[1/2,y,3/4]}", ".2."),
        ("4d", "{[1/4,0,z],[3/4,0,1/2-z],[3/4,0,-z],[1/4,0,z+1/2]}", "..2"),
        ("4e", "{[1/4,1/2,z],[3/4,1/2,1/2-z],[3/4,1/2,-z],[1/4,1/2,z+1/2]}", "..2"),
        ("8f", "{[x,y,z],[1/2-x,-y,z],[-x,y,1/2-z],[x+1/2,-y,1/2-z],[-x,-y,-z],[x+1/2,y,-z],[x,-y,z+1/2],[1/2-x,y,z+1/2]}", "1"),
    ],
    "D2h^9": [
        ("2a", "{[0,0,0],[1/2,1/2,0]}", "..2/m"),
        ("2b", "{[0,0,1/2],[1/2,1/2,1/2]}", "..2/m"),
        ("2c", "{[0,1/2,0],[1/2,0,0]}", "..2/m"),
        ("2d", "{[0,1/2,1/2],[1/2,0,1/2]}", "..2/m"),
        ("4e", "{[0,0,z],[1/2,1/2,-z],[0,0,-z],[1/2,1/2,z]}", "..2"),
        ("4f", "{[0,1/2,z],[1/2,0,-z],[0,1/2,-z],[1/2,0,z]}", "..2"),
        ("4g", "{[x,y,0],[-x,-y,0],[1/2-x,y+1/2,0],[x+1/2,1/2-y,0]}", "..m"),
        ("4h", "{[x,y,1/2],[-x,-y,1/2],[1/2-x,y+1/2,1/2],[x+1/2,1/2-y,1/2]}", "..m"),
        ("8i", "{[x,y,z],[-x,-y,z],[1/2-x,y+1/2,-z],[x+1/2,1/2-y,-z],[-x,-y,-z],[x,y,-z],[x+1/2,1/2-y,z],[1/2-x,y+1/2,z]}", "1"),
    ],
    "D2h^10": [
        ("4a", "{[0,0,0],[1/2,1/2,0],[0,1/2,1/2],[1/2,0,1/2]}", "-1"),
        ("4b", "{[0,0,1/2],[1/2,1/2,1/2],[0,1/2,0],[1/2,0,0]}", "-1"),
        ("4c", "{[1/4,1/4,z],[3/4,3/4,1/2-z],[3/4,3/4,-z],[1/4,1/4,z+1/2]}", "..2"),
        ("4d", "{[1/4,3/4,z],[3/4,1/4,1/2-z],[3/4,1/4,-z],[1/4,3/4,z+1/2]}", "..2"),
        (
            "8e",
            "{[x,y,z],[1/2-x,1/2-y,z],[-x,y+1/2,1/2-z],[x+1/2,-y,1/2-z],[-x,-y,-z],[x+1/2,y+1/2,-z],[x,1/2-y,z+1/2],[1/2-x,y,z+1/2]}",
            "1",
        ),
    ],
    "D2h^11": [
        ("4a", "{[0,0,0],[0,0,1/2],[0,1/2,1/2],[0,1/2,0]}", "-1"),
        ("4b", "{[1/2,0,0],[1/2,0,1/2],[1/2,1/2,1/2],[1/2,1/2,0]}", "-1"),
        ("4c", "{[x,1/4,0],[-x,3/4,1/2],[-x,3/4,0],[x,1/4,1/2]}", "2.."),
        ("4d", "{[x,y,1/4],[-x,-y,3/4],[-x,y+1/2,1/4],[x,1/2-y,3/4]}", "..m"),
        ("8e", "{[x,y,z],[-x,-y,z+1/2],[-x,y+1/2,1/2-z],[x,1/2-y,-z],[-x,-y,-z],[x,y,1/2-z],[x,1/2-y,z+1/2],[-x,y+1/2,z]}", "1"),
    ],
    "D2h^12": [
        ("2a", "{[0,0,0],[1/2,1/2,1/2]}", "..2/m"),
        ("2b", "{[0,0,1/2],[1/2,1/2,0]}", "..2/m"),
        ("2c", "{[0,1/2,0],[1/2,0,1/2]}", "..2/m"),
        ("2d", "{[0,1/2,1/2],[1/2,0,0]}", "..2/m"),
        ("4e", "{[0,0,z],[1/2,1/2,1/2-z],[0,0,-z],[1/2,1/2,z+1/2]}", "..2"),
        ("4f", "{[0,1/2,z],[1/2,0,1/2-z],[0,1/2,-z],[1/2,0,z+1/2]}", "..2"),
        ("4g", "{[x,y,0],[-x,-y,0],[1/2-x,y+1/2,1/2],[x+1/2,1/2-y,1/2]}", "..m"),
        (
            "8h",
            "{[x,y,z],[-x,-y,z],[1/2-x,y+1/2,1/2-z],[x+1/2,1/2-y,1/2-z],[-x,-y,-z],[x,y,-z],[x+1/2,1/2-y,z+1/2],[1/2-x,y+1/2,z+1/2]}",
            "1",
        ),
    ],
    "D2h^13": [
        ("2a", "{[1/4,1/4,z],[3/4,3/4,-z]}", "mm2"),
        ("2b", "{[1/4,3/4,z],[3/4,1/4,-z]}", "mm2"),
        ("4c", "{[0,0,0],[1/2,1/2,0],[0,1/2,0],[1/2,0,0]}", "-1"),
        ("4d", "{[0,0,1/2],[1/2,1/2,1/2],[0,1/2,1/2],[1/2,0,1/2]}", "-1"),
        ("4e", "{[1/4,y,z],[1/4,1/2-y,z],[3/4,y+1/2,-z],[3/4,-y,-z]}", "m.."),
        ("4f", "{[x,1/4,z],[1/2-x,1/4,z],[-x,3/4,-z],[x+1/2,3/4,-z]}", ".m."),
        ("8g", "{[x,y,z],[1/2-x,1/2-y,z],[-x,y+1/2,-z],[x+1/2,-y,-z],[-x,-y,-z],[x+1/2,y+1/2,-z],[x,1/2-y,z],[1/2-x,y,z]}", "1"),
    ],
    "D2h^14": [
        ("4a", "{[0,0,0],[1/2,1/2,1/2],[0,0,1/2],[1/2,1/2,0]}", "-1"),
        ("4b", "{[0,1/2,0],[1/2,0,1/2],[0,1/2,1/2],[1/2,0,0]}", "-1"),
        ("4c", "{[0,y,1/4],[1/2,1/2-y,3/4],[0,-y,3/4],[1/2,y+1/2,1/4]}", ".2."),
        (
            "8d",
            "{[x,y,z],[1/2-x,1/2-y,z+1/2],[-x,y,1/2-z],[x+1/2,1/2-y,-z],[-x,-y,-z],[x+1/2,y+1/2,1/2-z],[x,-y,z+1/2],[1/2-x,y+1/2,z]}",
            "1",
        ),
    ],
    "D2h^15": [
        ("4a", "{[0,0,0],[1/2,0,1/2],[0,1/2,1/2],[1/2,1/2,0]}", "-1"),
        ("4b", "{[0,0,1/2],[1/2,0,0],[0,1/2,0],[1/2,1/2,1/2]}", "-1"),
        (
            "8c",
            "{[x,y,z],[1/2-x,-y,z+1/2],[-x,y+1/2,1/2-z],[x+1/2,1/2-y,-z],[-x,-y,-z],[x+1/2,y,1/2-z],[x,1/2-y,z+1/2],[1/2-x,y+1/2,z]}",
            "1",
        ),
    ],
    "D2h^16": [
        ("4a", "{[0,0,0],[1/2,0,1/2],[0,1/2,0],[1/2,1/2,1/2]}", "-1"),
        ("4b", "{[0,0,1/2],[1/2,0,0],[0,1/2,1/2],[1/2,1/2,0]}", "-1"),
        ("4c", "{[x,1/4,z],[1/2-x,3/4,z+1/2],[-x,3/4,-z],[x+1/2,1/4,1/2-z]}", ".m."),
        (
            "8d",
            "{[x,y,z],[1/2-x,-y,z+1/2],[-x,y+1/2,-z],[x+1/2,1/2-y,1/2-z],[-x,-y,-z],[x+1/2,y,1/2-z],[x,1/2-y,z],[1/2-x,y+1/2,z+1/2]}",
            "1",
        ),
    ],
    "D2h^17": [
        ("4a", "{[0,0,0],[0,0,1/2]}", "2/m.."),
        ("4b", "{[0,1/2,0],[0,1/2,1/2]}", "2/m.."),
        ("4c", "{[0,y,1/4],[0,-y,3/4]}", "m2m"),
        ("8d", "{[1/4,1/4,0],[1/4,1/4,1/2],[3/4,1/4,1/2],[3/4,1/4,0]}", "-1"),
        ("8e", "{[x,0,0],[-x,0,1/2],[-x,0,0],[x,0,1/2]}", "2.."),
        ("8f", "{[0,y,z],[0,-y,z+1/2],[0,y,1/2-z],[0,-y,-z]}", "m.."),
        ("8g", "{[x,y,1/4],[-x,-y,3/4],[-x,y,1/4],[x,-y,3/4]}", "..m"),
        ("16h", "{[x,y,z],[-x,-y,z+1/2],[-x,y,1/2-z],[x,-y,-z],[-x,-y,-z],[x,y,1/2-z],[x,-y,z+1/2],[-x,y,z]}", "1"),
    ],
    "D2h^18": [
        ("4a", "{[0,0,0],[0,1/2,1/2]}", "2/m.."),
        ("4b", "{[0,1/2,0],[0,0,1/2]}", "2/m.."),
        ("8c", "{[1/4,1/4,0],[3/4,1/4,1/2],[1/4,1/4,1/2],[3/4,1/4,0]}", "-1"),
        ("8d", "{[x,0,0],[-x,1/2,1/2],[-x,0,0],[x,1/2,1/2]}", "2.."),
        ("8e", "{[3/4,y+1/2,1/4],[3/4,1/2-y,3/4],[1/4,1/2-y,3/4],[1/4,y+1/2,1/4]}", ".2."),
        ("8f", "{[0,y,z],[0,1/2-y,z+1/2],[0,y+1/2,1/2-z],[0,-y,-z]}", "m.."),
        ("16g", "{[x,y,z],[-x,1/2-y,z+1/2],[-x,y+1/2,1/2-z],[x,-y,-z],[-x,-y,-z],[x,y+1/2,1/2-z],[x,1/2-y,z+1/2],[-x,y,z]}", "1"),
    ],
    "D2h^19": [
        ("2a", "{[0,0,0]}", "mmm"),
        ("2b", "{[0,1/2,0]}", "mmm"),
        ("2c", "{[0,1/2,1/2]}", "mmm"),
        ("2d", "{[0,0,1/2]}", "mmm"),
        ("4e", "{[1/4,1/4,0],[3/4,1/4,0]}", "..2/m"),
        ("4f", "{[1/4,1/4,1/2],[3/4,1/4,1/2]}", "..2/m"),
        ("4g", "{[x,0,0],[-x,0,0]}", "2mm"),
        ("4h", "{[x,0,1/2],[-x,0,1/2]}", "2mm"),
        ("4i", "{[0,y,0],[0,-y,0]}", "m2m"),
        ("4j", "{[0,y,1/2],[0,-y,1/2]}", "m2m"),
        ("4k", "{[0,0,z],[0,0,-z]}", "mm2"),
        ("4l", "{[0,1/2,z],[0,1/2,-z]}", "mm2"),
        ("8m", "{[1/4,1/4,z],[3/4,1/4,-z],[1/4,1/4,-z],[3/4,1/4,z]}", "..2"),
        ("8n", "{[0,y,z],[0,-y,z],[0,y,-z],[0,-y,-z]}", "m.."),
        ("8o", "{[x,0,z],[-x,0,z],[-x,0,-z],[x,0,-z]}", ".m."),
        ("8p", "{[x,y,0],[-x,-y,0],[-x,y,0],[x,-y,0]}", "..m"),
        ("8q", "{[x,y,1/2],[-x,-y,1/2],[-x,y,1/2],[x,-y,1/2]}", "..m"),
        ("16r", "{[x,y,z],[-x,-y,z],[-x,y,-z],[x,-y,-z],[-x,-y,-z],[x,y,-z],[x,-y,z],[-x,y,z]}", "1"),
    ],
    "D2h^20": [
        ("4a", "{[0,0,1/4],[0,0,3/4]}", "222"),
        ("4b", "{[0,1/2,1/4],[0,1/2,3/4]}", "222"),
        ("4c", "{[0,0,0],[0,0,1/2]}", "..2/m"),
        ("4d", "{[0,1/2,0],[0,1/2,1/2]}", "..2/m"),
        ("4e", "{[1/4,1/4,0],[3/4,1/4,1/2]}", "..2/m"),
        ("4f", "{[3/4,1/4,0],[1/4,1/4,1/2]}", "..2/m"),
        ("8g", "{[x,0,1/4],[-x,0,1/4],[-x,0,3/4],[x,0,3/4]}", "2.."),
        ("8h", "{[0,y,1/4],[0,-y,1/4],[0,-y,3/4],[0,y,3/4]}", ".2."),
        ("8i", "{[0,0,z],[0,0,1/2-z],[0,0,-z],[0,0,z+1/2]}", "..2"),
        ("8j", "{[0,1/2,z],[0,1/2,1/2-z],[0,1/2,-z],[0,1/2,z+1/2]}", "..2"),
        ("8k", "{[1/4,1/4,z],[3/4,1/4,1/2-z],[1/4,1/4,-z],[3/4,1/4,z+1/2]}", "..2"),
        ("8l", "{[x,y,0],[-x,-y,0],[-x,y,1/2],[x,-y,1/2]}", "..m"),
        ("16m", "{[x,y,z],[-x,-y,z],[-x,y,1/2-z],[x,-y,1/2-z],[-x,-y,-z],[x,y,-z],[x,-y,z+1/2],[-x,y,z+1/2]}", "1"),
    ],
    "D2h^21": [
        ("4a", "{[3/4,1/2,0],[1/4,1/2,0]}", "222"),
        ("4b", "{[3/4,1/2,1/2],[1/4,1/2,1/2]}", "222"),
        ("4c", "{[0,0,0],[0,1/2,0]}", "2/m.."),
        ("4d", "{[0,0,1/2],[0,1/2,1/2]}", "2/m.."),
        ("4e", "{[1/4,1/4,0],[3/4,1/4,0]}", ".2/m."),
        ("4f", "{[1/4,1/4,1/2],[3/4,1/4,1/2]}", ".2/m."),
        ("4g", "{[0,1/4,z],[0,3/4,-z]}", "mm2"),
        ("8h", "{[x,0,0],[-x,1/2,0],[-x,0,0],[x,1/2,0]}", "2.."),
        ("8i", "{[x,0,1/2],[-x,1/2,1/2],[-x,0,1/2],[x,1/2,1/2]}", "2.."),
        ("8j", "{[3/4,y+1/2,0],[3/4,1/2-y,0],[1/4,1/2-y,0],[1/4,y+1/2,0]}", ".2."),
        ("8k", "{[3/4,y+1/2,1/2],[3/4,1/2-y,1/2],[1/4,1/2-y,1/2],[1/4,y+1/2,1/2]}", ".2."),
        ("8l", "{[3/4,1/2,z],[3/4,1/2,-z],[1/4,1/2,-z],[1/4,1/2,z]}", "..2"),
        ("8m", "{[0,y,z],[0,1/2-y,z],[0,y+1/2,-z],[0,-y,-z]}", "m.."),
        ("8n", "{[x,1/4,z],[-x,1/4,z],[-x,3/4,-z],[x,3/4,-z]}", ".m."),
        ("16o", "{[x,y,z],[-x,1/2-y,z],[-x,y+1/2,-z],[x,-y,-z],[-x,-y,-z],[x,y+1/2,-z],[x,1/2-y,z],[-x,y,z]}", "1"),
    ],
    "D2h^22": [
        ("4a", "{[0,1/4,1/4],[0,3/4,3/4]}", "222"),
        ("4b", "{[0,1/4,3/4],[0,3/4,1/4]}", "222"),
        ("8c", "{[3/4,1/4,0],[1/4,1/4,0],[1/4,1/4,1/2],[3/4,1/4,1/2]}", "-1"),
        ("8d", "{[0,0,0],[0,1/2,0],[0,0,1/2],[0,1/2,1/2]}", "-1"),
        ("8e", "{[x,1/4,1/4],[-x,1/4,1/4],[-x,3/4,3/4],[x,3/4,3/4]}", "2.."),
        ("8f", "{[0,y,1/4],[0,1/2-y,1/4],[0,-y,3/4],[0,y+1/2,3/4]}", ".2."),
        ("8g", "{[0,1/4,z],[0,1/4,1/2-z],[0,3/4,-z],[0,3/4,z+1/2]}", "..2"),
        ("8h", "{[3/4,1/2,z],[1/4,1/2,1/2-z],[1/4,1/2,-z],[3/4,1/2,z+1/2]}", "..2"),
        ("16i", "{[x,y,z],[1/2-x,-y,z],[-x,y,1/2-z],[x+1/2,-y,1/2-z],[-x,-y,-z],[x+1/2,y,-z],[x,-y,z+1/2],[1/2-x,y,z+1/2]}", "1"),
    ],
    "D2h^23": [
        ("4a", "{[0,0,0]}", "mmm"),
        ("4b", "{[1/2,1/2,1/2]}", "mmm"),
        ("8c", "{[0,1/4,1/4],[1/2,1/4,1/4]}", "2/m.."),
        ("8d", "{[1/4,0,1/4],[1/4,1/2,1/4]}", ".2/m."),
        ("8e", "{[1/4,1/4,0],[1/4,1/4,1/2]}", "..2/m"),
        ("8f", "{[1/4,1/4,1/4],[3/4,3/4,3/4]}", "222"),
        ("8g", "{[x,0,0],[-x,0,0]}", "2mm"),
        ("8h", "{[0,y,0],[0,-y,0]}", "m2m"),
        ("8i", "{[0,0,z],[0,0,-z]}", "mm2"),
        ("16j", "{[1/4,1/4,z],[1/4,1/4,1/2-z],[1/4,1/4,-z],[1/4,1/4,z+1/2]}", "..2"),
        ("16k", "{[1/4,y,1/4],[1/4,1/2-y,1/4],[1/4,-y,1/4],[1/4,y+1/2,1/4]}", ".2."),
        ("16l", "{[x,1/4,1/4],[1/2-x,1/4,1/4],[-x,1/4,1/4],[x+1/2,1/4,1/4]}", "2.."),
        ("16m", "{[0,y,z],[0,-y,z],[0,y,-z],[0,-y,-z]}", "m.."),
        ("16n", "{[x,0,z],[-x,0,z],[-x,0,-z],[x,0,-z]}", ".m."),
        ("16o", "{[x,y,0],[-x,-y,0],[-x,y,0],[x,-y,0]}", "..m"),
        ("32p", "{[x,y,z],[-x,-y,z],[-x,y,-z],[x,-y,-z],[-x,-y,-z],[x,y,-z],[x,-y,z],[-x,y,z]}", "1"),
    ],
    "D2h^24": [
        ("8a", "{[1/8,1/8,1/8],[7/8,7/8,7/8]}", "222"),
        ("8b", "{[5/8,5/8,5/8],[3/8,3/8,3/8]}", "222"),
        ("16c", "{[0,0,0],[1/4,1/4,0],[1/4,0,1/4],[0,1/4,1/4]}", "-1"),
        ("16d", "{[1/2,1/2,1/2],[1/4,1/4,1/2],[1/4,1/2,1/4],[1/2,1/4,1/4]}", "-1"),
        ("16e", "{[x,1/8,1/8],[1/4-x,1/8,1/8],[-x,3/8,3/8],[x+3/4,3/8,3/8]}", "2.."),
        ("16f", "{[1/8,y,1/8],[1/8,1/4-y,1/8],[3/8,-y,3/8],[3/8,y+3/4,3/8]}", ".2."),
        ("16g", "{[1/8,1/8,z],[1/8,1/8,1/4-z],[3/8,3/8,-z],[3/8,3/8,z+3/4]}", "..2"),
        (
            "32h",
            "{[x,y,z],[3/4-x,3/4-y,z],[3/4-x,y,3/4-z],[x,3/4-y,3/4-z],[-x,-y,-z],[x+1/4,y+1/4,-z],[x+1/4,-y,z+1/4],[-x,y+1/4,z+1/4]}",
            "1",
        ),
    ],
    "D2h^25": [
        ("2a", "{[0,0,0]}", "mmm"),
        ("2b", "{[1/2,0,0]}", "mmm"),
        ("2c", "{[0,0,1/2]}", "mmm"),
        ("2d", "{[0,1/2,0]}", "mmm"),
        ("4e", "{[x,0,0],[-x,0,0]}", "2mm"),
        ("4f", "{[x,1/2,0],[-x,1/2,0]}", "2mm"),
        ("4g", "{[0,y,0],[0,-y,0]}", "m2m"),
        ("4h", "{[0,y,1/2],[0,-y,1/2]}", "m2m"),
        ("4i", "{[0,0,z],[0,0,-z]}", "mm2"),
        ("4j", "{[1/2,0,z],[1/2,0,-z]}", "mm2"),
        ("8k", "{[1/4,1/4,1/4],[1/4,1/4,3/4],[1/4,3/4,1/4],[3/4,1/4,1/4]}", "-1"),
        ("8l", "{[0,y,z],[0,-y,z],[0,y,-z],[0,-y,-z]}", "m.."),
        ("8m", "{[x,0,z],[-x,0,z],[-x,0,-z],[x,0,-z]}", ".m."),
        ("8n", "{[x,y,0],[-x,-y,0],[-x,y,0],[x,-y,0]}", "..m"),
        ("16o", "{[x,y,z],[-x,-y,z],[-x,y,-z],[x,-y,-z],[-x,-y,-z],[x,y,-z],[x,-y,z],[-x,y,z]}", "1"),
    ],
    "D2h^26": [
        ("4a", "{[0,0,1/4],[0,0,3/4]}", "222"),
        ("4b", "{[1/2,0,1/4],[0,1/2,1/4]}", "222"),
        ("4c", "{[0,0,0],[0,0,1/2]}", "..2/m"),
        ("4d", "{[1/2,0,0],[0,1/2,0]}", "..2/m"),
        ("8e", "{[1/4,1/4,1/4],[1/4,1/4,3/4],[3/4,1/4,1/4],[1/4,3/4,1/4]}", "-1"),
        ("8f", "{[x,0,1/4],[-x,0,1/4],[-x,0,3/4],[x,0,3/4]}", "2.."),
        ("8g", "{[0,y,1/4],[0,-y,1/4],[0,-y,3/4],[0,y,3/4]}", ".2."),
        ("8h", "{[0,0,z],[0,0,1/2-z],[0,0,-z],[0,0,z+1/2]}", "..2"),
        ("8i", "{[0,1/2,z],[1/2,0,-z],[0,1/2,-z],[1/2,0,z]}", "..2"),
        ("8j", "{[x,y,0],[-x,-y,0],[-x,y,1/2],[x,-y,1/2]}", "..m"),
        ("16k", "{[x,y,z],[-x,-y,z],[1/2-x,y+1/2,-z],[x+1/2,1/2-y,-z],[-x,-y,-z],[x,y,-z],[x+1/2,1/2-y,z],[1/2-x,y+1/2,z]}", "1"),
    ],
    "D2h^27": [
        ("8a", "{[0,0,0],[0,1/2,0],[1/2,0,0],[0,0,1/2]}", "-1"),
        ("8b", "{[1/4,1/4,1/4],[3/4,1/4,1/4],[1/4,1/4,3/4],[1/4,3/4,1/4]}", "-1"),
        ("8c", "{[x,0,1/4],[-x,1/2,1/4],[-x,0,3/4],[x+1/2,0,1/4]}", "2.."),
        ("8d", "{[1/4,y,0],[1/4,-y,1/2],[3/4,-y,0],[1/4,y+1/2,0]}", ".2."),
        ("8e", "{[0,1/4,z],[1/2,1/4,-z],[0,3/4,-z],[0,1/4,z+1/2]}", "..2"),
        (
            "16f",
            "{[x,y,z],[1/2-x,-y,z+1/2],[-x,y+1/2,1/2-z],[x+1/2,1/2-y,-z],[-x,-y,-z],[x+1/2,y,1/2-z],[x,1/2-y,z+1/2],[1/2-x,y+1/2,z]}",
            "1",
        ),
    ],
    "D2h^28": [
        ("4a", "{[0,0,0],[0,1/2,0]}", "2/m.."),
        ("4b", "{[0,0,1/2],[1/2,0,0]}", "2/m.."),
        ("4c", "{[1/4,1/4,1/4],[3/4,1/4,1/4]}", ".2/m."),
        ("4d", "{[1/4,1/4,3/4],[1/4,3/4,1/4]}", ".2/m."),
        ("4e", "{[0,1/4,z],[0,3/4,-z]}", "mm2"),
        ("8f", "{[x,0,0],[-x,1/2,0],[-x,0,0],[x,1/2,0]}", "2.."),
        ("8g", "{[1/4,y,1/4],[3/4,1/2-y,1/4],[1/4,1/2-y,1/4],[1/4,y+1/2,3/4]}", ".2."),
        ("8h", "{[0,y,z],[0,1/2-y,z],[0,y+1/2,-z],[0,-y,-z]}", "m.."),
        ("8i", "{[x,1/4,z],[-x,1/4,z],[-x,3/4,-z],[x,3/4,-z]}", ".m."),
        ("16j", "{[x,y,z],[-x,1/2-y,z],[-x,y+1/2,-z],[x,-y,-z],[-x,-y,-z],[x,y+1/2,-z],[x,1/2-y,z],[-x,y,z]}", "1"),
    ],
    "C4^1": [
        ("1a", "{[0,0,z]}", "4.."),
        ("1b", "{[1/2,1/2,z]}", "4.."),
        ("2c", "{[0,1/2,z],[1/2,0,z]}", "2.."),
        ("4d", "{[x,y,z],[-x,-y,z],[-y,x,z],[y,-x,z]}", "1"),
    ],
    "C4^2": [("4a", "{[x,y,z],[-x,-y,z+1/2],[-y,x,z+1/4],[y,-x,z+3/4]}", "1")],
    "C4^3": [
        ("2a", "{[0,0,z],[0,0,z+1/2]}", "2.."),
        ("2b", "{[1/2,1/2,z],[1/2,1/2,z+1/2]}", "2.."),
        ("2c", "{[0,1/2,z],[1/2,0,z+1/2]}", "2.."),
        ("4d", "{[x,y,z],[-x,-y,z],[-y,x,z+1/2],[y,-x,z+1/2]}", "1"),
    ],
    "C4^4": [("4a", "{[x,y,z],[-x,-y,z+1/2],[-y,x,z+3/4],[y,-x,z+1/4]}", "1")],
    "C4^5": [
        ("2a", "{[0,0,z]}", "4.."),
        ("4b", "{[0,1/2,z],[1/2,0,z]}", "2.."),
        ("8c", "{[x,y,z],[-x,-y,z],[-y,x,z],[y,-x,z]}", "1"),
    ],
    "C4^6": [
        ("4a", "{[0,0,z],[0,1/2,z+1/4]}", "2.."),
        ("8b", "{[x,y,z],[1/2-x,1/2-y,z+1/2],[-y,x+1/2,z+1/4],[y+1/2,-x,z+3/4]}", "1"),
    ],
    "S4^1": [
        ("1a", "{[0,0,0]}", "-4.."),
        ("1b", "{[0,0,1/2]}", "-4.."),
        ("1c", "{[1/2,1/2,0]}", "-4.."),
        ("1d", "{[1/2,1/2,1/2]}", "-4.."),
        ("2e", "{[0,0,z],[0,0,-z]}", "2.."),
        ("2f", "{[1/2,1/2,z],[1/2,1/2,-z]}", "2.."),
        ("2g", "{[0,1/2,z],[1/2,0,-z]}", "2.."),
        ("4h", "{[x,y,z],[-x,-y,z],[y,-x,-z],[-y,x,-z]}", "1"),
    ],
    "S4^2": [
        ("2a", "{[0,0,0]}", "-4.."),
        ("2b", "{[0,0,1/2]}", "-4.."),
        ("2c", "{[0,1/2,1/4]}", "-4.."),
        ("2d", "{[1/2,0,1/4]}", "-4.."),
        ("4e", "{[0,0,z],[0,0,-z]}", "2.."),
        ("4f", "{[0,1/2,z],[1/2,0,-z]}", "2.."),
        ("8g", "{[x,y,z],[-x,-y,z],[y,-x,-z],[-y,x,-z]}", "1"),
    ],
    "C4h^1": [
        ("1a", "{[0,0,0]}", "4/m.."),
        ("1b", "{[0,0,1/2]}", "4/m.."),
        ("1c", "{[1/2,1/2,0]}", "4/m.."),
        ("1d", "{[1/2,1/2,1/2]}", "4/m.."),
        ("2e", "{[0,1/2,0],[1/2,0,0]}", "2/m.."),
        ("2f", "{[0,1/2,1/2],[1/2,0,1/2]}", "2/m.."),
        ("2g", "{[0,0,z],[0,0,-z]}", "4.."),
        ("2h", "{[1/2,1/2,z],[1/2,1/2,-z]}", "4.."),
        ("4i", "{[0,1/2,z],[1/2,0,z],[0,1/2,-z],[1/2,0,-z]}", "2.."),
        ("4j", "{[x,y,0],[-x,-y,0],[-y,x,0],[y,-x,0]}", "m.."),
        ("4k", "{[x,y,1/2],[-x,-y,1/2],[-y,x,1/2],[y,-x,1/2]}", "m.."),
        ("8l", "{[x,y,z],[-x,-y,z],[-y,x,z],[y,-x,z],[-x,-y,-z],[x,y,-z],[y,-x,-z],[-y,x,-z]}", "1"),
    ],
    "C4h^2": [
        ("2a", "{[0,0,0],[0,0,1/2]}", "2/m.."),
        ("2b", "{[1/2,1/2,0],[1/2,1/2,1/2]}", "2/m.."),
        ("2c", "{[0,1/2,0],[1/2,0,1/2]}", "2/m.."),
        ("2d", "{[0,1/2,1/2],[1/2,0,0]}", "2/m.."),
        ("2e", "{[0,0,1/4],[0,0,3/4]}", "-4.."),
        ("2f", "{[1/2,1/2,1/4],[1/2,1/2,3/4]}", "-4.."),
        ("4g", "{[0,0,z],[0,0,z+1/2],[0,0,-z],[0,0,1/2-z]}", "2.."),
        ("4h", "{[1/2,1/2,z],[1/2,1/2,z+1/2],[1/2,1/2,-z],[1/2,1/2,1/2-z]}", "2.."),
        ("4i", "{[0,1/2,z],[1/2,0,z+1/2],[0,1/2,-z],[1/2,0,1/2-z]}", "2.."),
        ("4j", "{[x,y,0],[-x,-y,0],[-y,x,1/2],[y,-x,1/2]}", "m.."),
        ("8k", "{[x,y,z],[-x,-y,z],[-y,x,z+1/2],[y,-x,z+1/2],[-x,-y,-z],[x,y,-z],[y,-x,1/2-z],[-y,x,1/2-z]}", "1"),
    ],
    "C4h^3": [
        ("2a", "{[1/4,3/4,0],[3/4,1/4,0]}", "-4.."),
        ("2b", "{[1/4,3/4,1/2],[3/4,1/4,1/2]}", "-4.."),
        ("2c", "{[1/4,1/4,z],[3/4,3/4,-z]}", "4.."),
        ("4d", "{[0,0,0],[1/2,1/2,0],[1/2,0,0],[0,1/2,0]}", "-1"),
        ("4e", "{[0,0,1/2],[1/2,1/2,1/2],[1/2,0,1/2],[0,1/2,1/2]}", "-1"),
        ("4f", "{[1/4,3/4,z],[3/4,1/4,z],[3/4,1/4,-z],[1/4,3/4,-z]}", "2.."),
        ("8g", "{[x,y,z],[1/2-x,1/2-y,z],[1/2-y,x,z],[y,1/2-x,z],[-x,-y,-z],[x+1/2,y+1/2,-z],[y+1/2,-x,-z],[-y,x+1/2,-z]}", "1"),
    ],
    "C4h^4": [
        ("2a", "{[1/4,1/4,1/4],[3/4,3/4,3/4]}", "-4.."),
        ("2b", "{[1/4,1/4,3/4],[3/4,3/4,1/4]}", "-4.."),
        ("4c", "{[0,0,0],[1/2,1/2,0],[0,1/2,1/2],[1/2,0,1/2]}", "-1"),
        ("4d", "{[0,0,1/2],[1/2,1/2,1/2],[0,1/2,0],[1/2,0,0]}", "-1"),
        ("4e", "{[3/4,1/4,z],[3/4,1/4,z+1/2],[1/4,3/4,-z],[1/4,3/4,1/2-z]}", "2.."),
        ("4f", "{[1/4,1/4,z],[3/4,3/4,z+1/2],[3/4,3/4,-z],[1/4,1/4,1/2-z]}", "2.."),
        (
            "8g",
            "{[x,y,z],[1/2-x,1/2-y,z],[-y,x+1/2,z+1/2],[y+1/2,-x,z+1/2],[-x,-y,-z],[x+1/2,y+1/2,-z],[y,1/2-x,1/2-z],[1/2-y,x,1/2-z]}",
            "1",
        ),
    ],
    "C4h^5": [
        ("2a", "{[0,0,0]}", "4/m.."),
        ("2b", "{[0,0,1/2]}", "4/m.."),
        ("4c", "{[0,1/2,0],[1/2,0,0]}", "2/m.."),
        ("4d", "{[0,1/2,1/4],[1/2,0,1/4]}", "-4.."),
        ("4e", "{[0,0,z],[0,0,-z]}", "4.."),
        ("8f", "{[1/4,1/4,1/4],[1/4,1/4,3/4],[3/4,1/4,1/4],[1/4,3/4,1/4]}", "-1"),
        ("8g", "{[0,1/2,z],[1/2,0,z],[0,1/2,-z],[1/2,0,-z]}", "2.."),
        ("8h", "{[x,y,0],[-x,-y,0],[-y,x,0],[y,-x,0]}", "m.."),
        ("16i", "{[x,y,z],[-x,-y,z],[-y,x,z],[y,-x,z],[-x,-y,-z],[x,y,-z],[y,-x,-z],[-y,x,-z]}", "1"),
    ],
    "C4h^6": [
        ("4a", "{[0,1/4,1/8],[1/2,1/4,3/8]}", "-4.."),
        ("4b", "{[0,1/4,5/8],[1/2,1/4,7/8]}", "-4.."),
        ("8c", "{[0,0,0],[0,1/2,0],[3/4,1/4,1/4],[1/4,1/4,1/4]}", "-1"),
        ("8d", "{[0,0,1/2],[1/2,0,0],[1/4,3/4,1/4],[1/4,1/4,3/4]}", "-1"),
        ("8e", "{[0,1/4,z],[1/2,1/4,z+1/4],[0,3/4,-z],[0,1/4,1/4-z]}", "2.."),
        (
            "16f",
            "{[x,y,z],[1/2-x,-y,z+1/2],[3/4-y,x+1/4,z+1/4],[y+3/4,3/4-x,z+3/4],[-x,-y,-z],[x+1/2,y,1/2-z],[y+1/4,3/4-x,3/4-z],[1/4-y,x+1/4,1/4-z]}",
            "1",
        ),
    ],
    "D4^1": [
        ("1a", "{[0,0,0]}", "422"),
        ("1b", "{[0,0,1/2]}", "422"),
        ("1c", "{[1/2,1/2,0]}", "422"),
        ("1d", "{[1/2,1/2,1/2]}", "422"),
        ("2e", "{[1/2,0,0],[0,1/2,0]}", "222."),
        ("2f", "{[1/2,0,1/2],[0,1/2,1/2]}", "222."),
        ("2g", "{[0,0,z],[0,0,-z]}", "4.."),
        ("2h", "{[1/2,1/2,z],[1/2,1/2,-z]}", "4.."),
        ("4i", "{[0,1/2,z],[0,1/2,-z],[1/2,0,-z],[1/2,0,z]}", "2.."),
        ("4j", "{[x,x,0],[-x,-x,0],[x,-x,0],[-x,x,0]}", "..2"),
        ("4k", "{[x,x,1/2],[-x,-x,1/2],[x,-x,1/2],[-x,x,1/2]}", "..2"),
        ("4l", "{[x,0,0],[-x,0,0],[0,x,0],[0,-x,0]}", ".2."),
        ("4m", "{[x,1/2,1/2],[-x,1/2,1/2],[1/2,x,1/2],[1/2,-x,1/2]}", ".2."),
        ("4n", "{[x,0,1/2],[-x,0,1/2],[0,x,1/2],[0,-x,1/2]}", ".2."),
        ("4o", "{[x,1/2,0],[-x,1/2,0],[1/2,x,0],[1/2,-x,0]}", ".2."),
        ("8p", "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[y,x,-z],[-y,-x,-z],[-y,x,z],[y,-x,z]}", "1"),
    ],
    "D4^2": [
        ("2a", "{[0,0,0],[1/2,1/2,0]}", "2.22"),
        ("2b", "{[0,0,1/2],[1/2,1/2,1/2]}", "2.22"),
        ("2c", "{[0,1/2,z],[1/2,0,-z]}", "4.."),
        ("4d", "{[0,0,z],[1/2,1/2,-z],[0,0,-z],[1/2,1/2,z]}", "2.."),
        ("4e", "{[x,x,0],[-x,-x,0],[x+1/2,1/2-x,0],[1/2-x,x+1/2,0]}", "..2"),
        ("4f", "{[x,x,1/2],[-x,-x,1/2],[x+1/2,1/2-x,1/2],[1/2-x,x+1/2,1/2]}", "..2"),
        ("8g", "{[x,y,z],[-x,-y,z],[x+1/2,1/2-y,-z],[1/2-x,y+1/2,-z],[y,x,-z],[-y,-x,-z],[1/2-y,x+1/2,z],[y+1/2,1/2-x,z]}", "1"),
    ],
    "D4^3": [
        ("4a", "{[0,y,0],[0,-y,1/2],[y,0,3/4],[-y,0,1/4]}", ".2."),
        ("4b", "{[1/2,y,0],[1/2,-y,1/2],[y,1/2,3/4],[-y,1/2,1/4]}", ".2."),
        ("4c", "{[x,x,3/8],[-x,-x,7/8],[x,-x,1/8],[-x,x,5/8]}", "..2"),
        ("8d", "{[x,y,z],[-x,-y,z+1/2],[x,-y,1/2-z],[-x,y,-z],[y,x,3/4-z],[-y,-x,1/4-z],[-y,x,z+1/4],[y,-x,z+3/4]}", "1"),
    ],
    "D4^4": [
        ("4a", "{[x,x,0],[-x,-x,1/2],[x+1/2,1/2-x,3/4],[1/2-x,x+1/2,1/4]}", "..2"),
        (
            "8b",
            "{[x,y,z],[-x,-y,z+1/2],[x+1/2,1/2-y,3/4-z],[1/2-x,y+1/2,1/4-z],[y,x,-z],[-y,-x,1/2-z],[1/2-y,x+1/2,z+1/4],[y+1/2,1/2-x,z+3/4]}",
            "1",
        ),
    ],
    "D4^5": [
        ("2a", "{[0,0,0],[0,0,1/2]}", "222."),
        ("2b", "{[1/2,1/2,0],[1/2,1/2,1/2]}", "222."),
        ("2c", "{[0,1/2,0],[1/2,0,1/2]}", "222."),
        ("2d", "{[0,1/2,1/2],[1/2,0,0]}", "222."),
        ("2e", "{[0,0,1/4],[0,0,3/4]}", "2.22"),
        ("2f", "{[1/2,1/2,1/4],[1/2,1/2,3/4]}", "2.22"),
        ("4g", "{[0,0,z],[0,0,-z],[0,0,1/2-z],[0,0,z+1/2]}", "2.."),
        ("4h", "{[1/2,1/2,z],[1/2,1/2,-z],[1/2,1/2,1/2-z],[1/2,1/2,z+1/2]}", "2.."),
        ("4i", "{[0,1/2,z],[0,1/2,-z],[1/2,0,1/2-z],[1/2,0,z+1/2]}", "2.."),
        ("4j", "{[x,0,0],[-x,0,0],[0,x,1/2],[0,-x,1/2]}", ".2."),
        ("4k", "{[x,1/2,1/2],[-x,1/2,1/2],[1/2,x,0],[1/2,-x,0]}", ".2."),
        ("4l", "{[x,0,1/2],[-x,0,1/2],[0,x,0],[0,-x,0]}", ".2."),
        ("4m", "{[x,1/2,0],[-x,1/2,0],[1/2,x,1/2],[1/2,-x,1/2]}", ".2."),
        ("4n", "{[x,x,1/4],[-x,-x,1/4],[x,-x,3/4],[-x,x,3/4]}", "..2"),
        ("4o", "{[x,x,3/4],[-x,-x,3/4],[x,-x,1/4],[-x,x,1/4]}", "..2"),
        ("8p", "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[y,x,1/2-z],[-y,-x,1/2-z],[-y,x,z+1/2],[y,-x,z+1/2]}", "1"),
    ],
    "D4^6": [
        ("2a", "{[0,0,0],[1/2,1/2,1/2]}", "2.22"),
        ("2b", "{[0,0,1/2],[1/2,1/2,0]}", "2.22"),
        ("4c", "{[0,0,z],[1/2,1/2,1/2-z],[0,0,-z],[1/2,1/2,z+1/2]}", "2.."),
        ("4d", "{[0,1/2,z],[1/2,0,1/2-z],[1/2,0,-z],[0,1/2,z+1/2]}", "2.."),
        ("4e", "{[x,x,0],[-x,-x,0],[x+1/2,1/2-x,1/2],[1/2-x,x+1/2,1/2]}", "..2"),
        ("4f", "{[x,x,1/2],[-x,-x,1/2],[x+1/2,1/2-x,0],[1/2-x,x+1/2,0]}", "..2"),
        (
            "8g",
            "{[x,y,z],[-x,-y,z],[x+1/2,1/2-y,1/2-z],[1/2-x,y+1/2,1/2-z],[y,x,-z],[-y,-x,-z],[1/2-y,x+1/2,z+1/2],[y+1/2,1/2-x,z+1/2]}",
            "1",
        ),
    ],
    "D4^7": [
        ("4a", "{[0,y,0],[0,-y,1/2],[y,0,1/4],[-y,0,3/4]}", ".2."),
        ("4b", "{[1/2,y,0],[1/2,-y,1/2],[y,1/2,1/4],[-y,1/2,3/4]}", ".2."),
        ("4c", "{[x,x,5/8],[-x,-x,1/8],[x,-x,7/8],[-x,x,3/8]}", "..2"),
        ("8d", "{[x,y,z],[-x,-y,z+1/2],[x,-y,1/2-z],[-x,y,-z],[y,x,1/4-z],[-y,-x,3/4-z],[-y,x,z+3/4],[y,-x,z+1/4]}", "1"),
    ],
    "D4^8": [
        ("4a", "{[x,x,0],[-x,-x,1/2],[x+1/2,1/2-x,1/4],[1/2-x,x+1/2,3/4]}", "..2"),
        (
            "8b",
            "{[x,y,z],[-x,-y,z+1/2],[x+1/2,1/2-y,1/4-z],[1/2-x,y+1/2,3/4-z],[y,x,-z],[-y,-x,1/2-z],[1/2-y,x+1/2,z+3/4],[y+1/2,1/2-x,z+1/4]}",
            "1",
        ),
    ],
    "D4^9": [
        ("2a", "{[0,0,0]}", "422"),
        ("2b", "{[0,0,1/2]}", "422"),
        ("4c", "{[0,1/2,0],[1/2,0,0]}", "222."),
        ("4d", "{[0,1/2,1/4],[1/2,0,1/4]}", "2.22"),
        ("4e", "{[0,0,z],[0,0,-z]}", "4.."),
        ("8f", "{[0,1/2,z],[0,1/2,-z],[1/2,0,-z],[1/2,0,z]}", "2.."),
        ("8g", "{[x,x,0],[-x,-x,0],[x,-x,0],[-x,x,0]}", "..2"),
        ("8h", "{[x,0,0],[-x,0,0],[0,x,0],[0,-x,0]}", ".2."),
        ("8i", "{[x,0,1/2],[-x,0,1/2],[0,x,1/2],[0,-x,1/2]}", ".2."),
        ("8j", "{[x,x+1/2,1/4],[-x,1/2-x,1/4],[x+1/2,-x,1/4],[1/2-x,x,1/4]}", "..2"),
        ("16k", "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[y,x,-z],[-y,-x,-z],[-y,x,z],[y,-x,z]}", "1"),
    ],
    "D4^10": [
        ("4a", "{[0,0,0],[0,1/2,1/4]}", "2.22"),
        ("4b", "{[0,0,1/2],[1/2,0,1/4]}", "2.22"),
        ("8c", "{[0,0,z],[0,1/2,1/4-z],[0,0,-z],[0,1/2,z+1/4]}", "2.."),
        ("8d", "{[x,x,0],[-x,-x,0],[x,1/2-x,1/4],[-x,x+1/2,1/4]}", "..2"),
        ("8e", "{[-x,x,0],[x,-x,0],[-x,1/2-x,1/4],[x,x+1/2,1/4]}", "..2"),
        ("8f", "{[x,1/4,1/8],[-x,3/4,1/8],[3/4,x+1/2,3/8],[1/4,1/2-x,3/8]}", ".2."),
        (
            "16g",
            "{[x,y,z],[1/2-x,1/2-y,z+1/2],[x,1/2-y,1/4-z],[1/2-x,y,3/4-z],[y+1/2,x+1/2,1/2-z],[-y,-x,-z],[-y,x+1/2,z+1/4],[y+1/2,-x,z+3/4]}",
            "1",
        ),
    ],
    "C4v^1": [
        ("1a", "{[0,0,z]}", "4mm"),
        ("1b", "{[1/2,1/2,z]}", "4mm"),
        ("2c", "{[1/2,0,z],[0,1/2,z]}", "2mm."),
        ("4d", "{[x,x,z],[-x,-x,z],[-x,x,z],[x,-x,z]}", "..m"),
        ("4e", "{[x,0,z],[-x,0,z],[0,x,z],[0,-x,z]}", ".m."),
        ("4f", "{[x,1/2,z],[-x,1/2,z],[1/2,x,z],[1/2,-x,z]}", ".m."),
        ("8g", "{[x,y,z],[-x,-y,z],[-y,x,z],[y,-x,z],[-x,y,z],[x,-y,z],[-y,-x,z],[y,x,z]}", "1"),
    ],
    "C4v^2": [
        ("2a", "{[0,0,z],[1/2,1/2,z]}", "4.."),
        ("2b", "{[1/2,0,z],[0,1/2,z]}", "2.mm"),
        ("4c", "{[x,x+1/2,z],[-x,1/2-x,z],[1/2-x,x,z],[x+1/2,-x,z]}", "..m"),
        ("8d", "{[x,y,z],[-x,-y,z],[-y,x,z],[y,-x,z],[1/2-x,y+1/2,z],[x+1/2,1/2-y,z],[1/2-y,1/2-x,z],[y+1/2,x+1/2,z]}", "1"),
    ],
    "C4v^3": [
        ("2a", "{[0,0,z],[0,0,z+1/2]}", "2.mm"),
        ("2b", "{[1/2,1/2,z],[1/2,1/2,z+1/2]}", "2.mm"),
        ("4c", "{[0,1/2,z],[1/2,0,z+1/2],[0,1/2,z+1/2],[1/2,0,z]}", "2.."),
        ("4d", "{[x,x,z],[-x,-x,z],[-x,x,z+1/2],[x,-x,z+1/2]}", "..m"),
        ("8e", "{[x,y,z],[-x,-y,z],[-y,x,z+1/2],[y,-x,z+1/2],[-x,y,z+1/2],[x,-y,z+1/2],[-y,-x,z],[y,x,z]}", "1"),
    ],
    "C4v^4": [
        ("2a", "{[0,0,z],[1/2,1/2,z+1/2]}", "2.mm"),
        ("4b", "{[0,1/2,z],[0,1/2,z+1/2],[1/2,0,z+1/2],[1/2,0,z]}", "2.."),
        ("4c", "{[x,x,z],[-x,-x,z],[1/2-x,x+1/2,z+1/2],[x+1/2,1/2-x,z+1/2]}", "..m"),
        (
            "8d",
            "{[x,y,z],[-x,-y,z],[1/2-y,x+1/2,z+1/2],[y+1/2,1/2-x,z+1/2],[1/2-x,y+1/2,z+1/2],[x+1/2,1/2-y,z+1/2],[-y,-x,z],[y,x,z]}",
            "1",
        ),
    ],
    "C4v^5": [
        ("2a", "{[0,0,z],[0,0,z+1/2]}", "4.."),
        ("2b", "{[1/2,1/2,z],[1/2,1/2,z+1/2]}", "4.."),
        ("4c", "{[0,1/2,z],[1/2,0,z],[0,1/2,z+1/2],[1/2,0,z+1/2]}", "2.."),
        ("8d", "{[x,y,z],[-x,-y,z],[-y,x,z],[y,-x,z],[-x,y,z+1/2],[x,-y,z+1/2],[-y,-x,z+1/2],[y,x,z+1/2]}", "1"),
    ],
    "C4v^6": [
        ("2a", "{[0,0,z],[1/2,1/2,z+1/2]}", "4.."),
        ("4b", "{[0,1/2,z],[1/2,0,z],[1/2,0,z+1/2],[0,1/2,z+1/2]}", "2.."),
        (
            "8c",
            "{[x,y,z],[-x,-y,z],[-y,x,z],[y,-x,z],[1/2-x,y+1/2,z+1/2],[x+1/2,1/2-y,z+1/2],[1/2-y,1/2-x,z+1/2],[y+1/2,x+1/2,z+1/2]}",
            "1",
        ),
    ],
    "C4v^7": [
        ("2a", "{[0,0,z],[0,0,z+1/2]}", "2mm."),
        ("2b", "{[1/2,1/2,z],[1/2,1/2,z+1/2]}", "2mm."),
        ("2c", "{[0,1/2,z],[1/2,0,z+1/2]}", "2mm."),
        ("4d", "{[x,0,z],[-x,0,z],[0,x,z+1/2],[0,-x,z+1/2]}", ".m."),
        ("4e", "{[x,1/2,z],[-x,1/2,z],[1/2,x,z+1/2],[1/2,-x,z+1/2]}", ".m."),
        ("8f", "{[x,y,z],[-x,-y,z],[-y,x,z+1/2],[y,-x,z+1/2],[-x,y,z],[x,-y,z],[-y,-x,z+1/2],[y,x,z+1/2]}", "1"),
    ],
    "C4v^8": [
        ("4a", "{[0,0,z],[0,0,z+1/2],[1/2,1/2,z],[1/2,1/2,z+1/2]}", "2.."),
        ("4b", "{[0,1/2,z],[1/2,0,z+1/2],[1/2,0,z],[0,1/2,z+1/2]}", "2.."),
        (
            "8c",
            "{[x,y,z],[-x,-y,z],[-y,x,z+1/2],[y,-x,z+1/2],[1/2-x,y+1/2,z],[x+1/2,1/2-y,z],[1/2-y,1/2-x,z+1/2],[y+1/2,x+1/2,z+1/2]}",
            "1",
        ),
    ],
    "C4v^9": [
        ("2a", "{[0,0,z]}", "4mm"),
        ("4b", "{[0,1/2,z],[1/2,0,z]}", "2mm."),
        ("8c", "{[x,x,z],[-x,-x,z],[-x,x,z],[x,-x,z]}", "..m"),
        ("8d", "{[x,0,z],[-x,0,z],[0,x,z],[0,-x,z]}", ".m."),
        ("16e", "{[x,y,z],[-x,-y,z],[-y,x,z],[y,-x,z],[-x,y,z],[x,-y,z],[-y,-x,z],[y,x,z]}", "1"),
    ],
    "C4v^10": [
        ("4a", "{[0,0,z],[0,0,z+1/2]}", "4.."),
        ("4b", "{[1/2,0,z],[0,1/2,z]}", "2.mm"),
        ("8c", "{[x,x+1/2,z],[-x,1/2-x,z],[1/2-x,x,z],[x+1/2,-x,z]}", "..m"),
        ("16d", "{[x,y,z],[-x,-y,z],[-y,x,z],[y,-x,z],[-x,y,z+1/2],[x,-y,z+1/2],[-y,-x,z+1/2],[y,x,z+1/2]}", "1"),
    ],
    "C4v^11": [
        ("4a", "{[0,0,z],[0,1/2,z+1/4]}", "2mm."),
        ("8b", "{[0,y,z],[0,-y,z],[-y,1/2,z+1/4],[y,1/2,z+1/4]}", ".m."),
        (
            "16c",
            "{[x,y,z],[1/2-x,1/2-y,z+1/2],[-y,x+1/2,z+1/4],[y+1/2,-x,z+3/4],[1/2-x,y+1/2,z+1/2],[x,-y,z],[-y,1/2-x,z+1/4],[y+1/2,x,z+3/4]}",
            "1",
        ),
    ],
    "C4v^12": [
        ("8a", "{[0,0,z],[0,1/2,z+1/4],[0,0,z+1/2],[1/2,0,z+1/4]}", "2.."),
        (
            "16b",
            "{[x,y,z],[1/2-x,1/2-y,z+1/2],[-y,x+1/2,z+1/4],[y+1/2,-x,z+3/4],[1/2-x,y+1/2,z],[x,-y,z+1/2],[-y,1/2-x,z+3/4],[y+1/2,x,z+1/4]}",
            "1",
        ),
    ],
    "D2d^1": [
        ("1a", "{[0,0,0]}", "-42m"),
        ("1b", "{[1/2,1/2,1/2]}", "-42m"),
        ("1c", "{[0,0,1/2]}", "-42m"),
        ("1d", "{[1/2,1/2,0]}", "-42m"),
        ("2e", "{[1/2,0,0],[0,1/2,0]}", "222."),
        ("2f", "{[1/2,0,1/2],[0,1/2,1/2]}", "222."),
        ("2g", "{[0,0,z],[0,0,-z]}", "2.mm"),
        ("2h", "{[1/2,1/2,z],[1/2,1/2,-z]}", "2.mm"),
        ("4i", "{[x,0,0],[-x,0,0],[0,-x,0],[0,x,0]}", ".2."),
        ("4j", "{[x,1/2,1/2],[-x,1/2,1/2],[1/2,-x,1/2],[1/2,x,1/2]}", ".2."),
        ("4k", "{[x,0,1/2],[-x,0,1/2],[0,-x,1/2],[0,x,1/2]}", ".2."),
        ("4l", "{[x,1/2,0],[-x,1/2,0],[1/2,-x,0],[1/2,x,0]}", ".2."),
        ("4m", "{[0,1/2,z],[0,1/2,-z],[1/2,0,z],[1/2,0,-z]}", "2.."),
        ("4n", "{[x,x,z],[-x,-x,z],[x,-x,-z],[-x,x,-z]}", "..m"),
        ("8o", "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[-y,-x,z],[y,x,z],[y,-x,-z],[-y,x,-z]}", "1"),
    ],
    "D2d^2": [
        ("2a", "{[0,0,1/4],[0,0,3/4]}", "222."),
        ("2b", "{[1/2,0,1/4],[0,1/2,3/4]}", "222."),
        ("2c", "{[1/2,1/2,1/4],[1/2,1/2,3/4]}", "222."),
        ("2d", "{[0,1/2,1/4],[1/2,0,3/4]}", "222."),
        ("2e", "{[0,0,0],[0,0,1/2]}", "-4.."),
        ("2f", "{[1/2,1/2,0],[1/2,1/2,1/2]}", "-4.."),
        ("4g", "{[x,0,1/4],[-x,0,1/4],[0,-x,3/4],[0,x,3/4]}", ".2."),
        ("4h", "{[1/2,y,1/4],[1/2,-y,1/4],[-y,1/2,3/4],[y,1/2,3/4]}", ".2."),
        ("4i", "{[x,1/2,1/4],[-x,1/2,1/4],[1/2,-x,3/4],[1/2,x,3/4]}", ".2."),
        ("4j", "{[0,y,1/4],[0,-y,1/4],[-y,0,3/4],[y,0,3/4]}", ".2."),
        ("4k", "{[0,0,z],[0,0,1/2-z],[0,0,z+1/2],[0,0,-z]}", "2.."),
        ("4l", "{[1/2,1/2,z],[1/2,1/2,1/2-z],[1/2,1/2,z+1/2],[1/2,1/2,-z]}", "2.."),
        ("4m", "{[0,1/2,z],[0,1/2,1/2-z],[1/2,0,z+1/2],[1/2,0,-z]}", "2.."),
        ("8n", "{[x,y,z],[-x,-y,z],[x,-y,1/2-z],[-x,y,1/2-z],[-y,-x,z+1/2],[y,x,z+1/2],[y,-x,-z],[-y,x,-z]}", "1"),
    ],
    "D2d^3": [
        ("2a", "{[0,0,0],[1/2,1/2,0]}", "-4.."),
        ("2b", "{[0,0,1/2],[1/2,1/2,1/2]}", "-4.."),
        ("2c", "{[0,1/2,z],[1/2,0,-z]}", "2.mm"),
        ("4d", "{[0,0,z],[1/2,1/2,-z],[1/2,1/2,z],[0,0,-z]}", "2.."),
        ("4e", "{[x,x+1/2,z],[-x,1/2-x,z],[x+1/2,-x,-z],[1/2-x,x,-z]}", "..m"),
        ("8f", "{[x,y,z],[-x,-y,z],[x+1/2,1/2-y,-z],[1/2-x,y+1/2,-z],[1/2-y,1/2-x,z],[y+1/2,x+1/2,z],[y,-x,-z],[-y,x,-z]}", "1"),
    ],
    "D2d^4": [
        ("2a", "{[0,0,0],[1/2,1/2,1/2]}", "-4.."),
        ("2b", "{[0,0,1/2],[1/2,1/2,0]}", "-4.."),
        ("4c", "{[0,0,z],[1/2,1/2,1/2-z],[1/2,1/2,z+1/2],[0,0,-z]}", "2.."),
        ("4d", "{[0,1/2,z],[1/2,0,1/2-z],[0,1/2,z+1/2],[1/2,0,-z]}", "2.."),
        (
            "8e",
            "{[x,y,z],[-x,-y,z],[x+1/2,1/2-y,1/2-z],[1/2-x,y+1/2,1/2-z],[1/2-y,1/2-x,z+1/2],[y+1/2,x+1/2,z+1/2],[y,-x,-z],[-y,x,-z]}",
            "1",
        ),
    ],
    "D2d^5": [
        ("1a", "{[0,0,0]}", "-4m2"),
        ("1b", "{[1/2,1/2,0]}", "-4m2"),
        ("1c", "{[1/2,1/2,1/2]}", "-4m2"),
        ("1d", "{[0,0,1/2]}", "-4m2"),
        ("2e", "{[0,0,z],[0,0,-z]}", "2mm."),
        ("2f", "{[1/2,1/2,z],[1/2,1/2,-z]}", "2mm."),
        ("2g", "{[0,1/2,z],[1/2,0,-z]}", "2mm."),
        ("4h", "{[x,x,0],[-x,-x,0],[-x,x,0],[x,-x,0]}", "..2"),
        ("4i", "{[x,x,1/2],[-x,-x,1/2],[-x,x,1/2],[x,-x,1/2]}", "..2"),
        ("4j", "{[x,0,z],[-x,0,z],[0,x,-z],[0,-x,-z]}", ".m."),
        ("4k", "{[x,1/2,z],[-x,1/2,z],[1/2,x,-z],[1/2,-x,-z]}", ".m."),
        ("8l", "{[x,y,z],[-x,-y,z],[y,x,-z],[-y,-x,-z],[-x,y,z],[x,-y,z],[y,-x,-z],[-y,x,-z]}", "1"),
    ],
    "D2d^6": [
        ("2a", "{[0,0,1/4],[0,0,3/4]}", "2.22"),
        ("2b", "{[1/2,1/2,1/4],[1/2,1/2,3/4]}", "2.22"),
        ("2c", "{[0,0,0],[0,0,1/2]}", "-4.."),
        ("2d", "{[1/2,1/2,0],[1/2,1/2,1/2]}", "-4.."),
        ("4e", "{[x,x,1/4],[-x,-x,1/4],[-x,x,3/4],[x,-x,3/4]}", "..2"),
        ("4f", "{[x,x,3/4],[-x,-x,3/4],[-x,x,1/4],[x,-x,1/4]}", "..2"),
        ("4g", "{[0,0,z],[0,0,1/2-z],[0,0,z+1/2],[0,0,-z]}", "2.."),
        ("4h", "{[1/2,1/2,z],[1/2,1/2,1/2-z],[1/2,1/2,z+1/2],[1/2,1/2,-z]}", "2.."),
        ("4i", "{[0,1/2,z],[1/2,0,1/2-z],[0,1/2,z+1/2],[1/2,0,-z]}", "2.."),
        ("8j", "{[x,y,z],[-x,-y,z],[y,x,1/2-z],[-y,-x,1/2-z],[-x,y,z+1/2],[x,-y,z+1/2],[y,-x,-z],[-y,x,-z]}", "1"),
    ],
    "D2d^7": [
        ("2a", "{[0,0,0],[1/2,1/2,0]}", "-4.."),
        ("2b", "{[0,0,1/2],[1/2,1/2,1/2]}", "-4.."),
        ("2c", "{[0,1/2,0],[1/2,0,0]}", "2.22"),
        ("2d", "{[0,1/2,1/2],[1/2,0,1/2]}", "2.22"),
        ("4e", "{[0,0,z],[1/2,1/2,-z],[1/2,1/2,z],[0,0,-z]}", "2.."),
        ("4f", "{[0,1/2,z],[0,1/2,-z],[1/2,0,z],[1/2,0,-z]}", "2.."),
        ("4g", "{[x,x+1/2,0],[-x,1/2-x,0],[1/2-x,x,0],[x+1/2,-x,0]}", "..2"),
        ("4h", "{[x,x+1/2,1/2],[-x,1/2-x,1/2],[1/2-x,x,1/2],[x+1/2,-x,1/2]}", "..2"),
        ("8i", "{[x,y,z],[-x,-y,z],[y+1/2,x+1/2,-z],[1/2-y,1/2-x,-z],[1/2-x,y+1/2,z],[x+1/2,1/2-y,z],[y,-x,-z],[-y,x,-z]}", "1"),
    ],
    "D2d^8": [
        ("2a", "{[0,0,0],[1/2,1/2,1/2]}", "-4.."),
        ("2b", "{[0,0,1/2],[1/2,1/2,0]}", "-4.."),
        ("2c", "{[0,1/2,1/4],[1/2,0,3/4]}", "2.22"),
        ("2d", "{[0,1/2,3/4],[1/2,0,1/4]}", "2.22"),
        ("4e", "{[0,0,z],[1/2,1/2,1/2-z],[1/2,1/2,z+1/2],[0,0,-z]}", "2.."),
        ("4f", "{[x,x+1/2,1/4],[-x,1/2-x,1/4],[1/2-x,x,3/4],[x+1/2,-x,3/4]}", "..2"),
        ("4g", "{[x,x+1/2,1/4],[-x,1/2-x,1/4],[1/2-x,x,3/4],[x+1/2,-x,3/4]}", "..2"),
        ("4h", "{[0,1/2,z],[0,1/2,1/2-z],[1/2,0,z+1/2],[1/2,0,-z]}", "2.."),
        (
            "8i",
            "{[x,y,z],[-x,-y,z],[y+1/2,x+1/2,1/2-z],[1/2-y,1/2-x,1/2-z],[1/2-x,y+1/2,z+1/2],[x+1/2,1/2-y,z+1/2],[y,-x,-z],[-y,x,-z]}",
            "1",
        ),
    ],
    "D2d^9": [
        ("2a", "{[0,0,0]}", "-4m2"),
        ("2b", "{[0,0,1/2]}", "-4m2"),
        ("2c", "{[0,1/2,1/4]}", "-4m2"),
        ("2d", "{[1/2,0,1/4]}", "-4m2"),
        ("4e", "{[0,0,z],[0,0,-z]}", "2mm."),
        ("4f", "{[0,1/2,z],[1/2,0,-z]}", "2mm."),
        ("8g", "{[x,x,0],[-x,-x,0],[-x,x,0],[x,-x,0]}", "..2"),
        ("8h", "{[x,x+1/2,1/4],[-x,1/2-x,1/4],[-x,x+1/2,1/4],[x,1/2-x,1/4]}", "..2"),
        ("8i", "{[x,0,z],[-x,0,z],[0,x,-z],[0,-x,-z]}", ".m."),
        ("16j", "{[x,y,z],[-x,-y,z],[y,x,-z],[-y,-x,-z],[-x,y,z],[x,-y,z],[y,-x,-z],[-y,x,-z]}", "1"),
    ],
    "D2d^10": [
        ("4a", "{[0,0,1/4],[0,0,3/4]}", "2.22"),
        ("4b", "{[0,0,0],[0,0,1/2]}", "-4.."),
        ("4c", "{[0,1/2,1/4],[1/2,0,1/4]}", "-4.."),
        ("4d", "{[0,1/2,0],[1/2,0,0]}", "2.22"),
        ("8e", "{[x,x,1/4],[-x,-x,1/4],[-x,x,3/4],[x,-x,3/4]}", "..2"),
        ("8f", "{[0,0,z],[0,0,1/2-z],[0,0,z+1/2],[0,0,-z]}", "2.."),
        ("8g", "{[0,1/2,z],[0,1/2,-z],[1/2,0,z],[1/2,0,-z]}", "2.."),
        ("8h", "{[x,x+1/2,0],[-x,1/2-x,0],[1/2-x,x,0],[x+1/2,-x,0]}", "..2"),
        ("16i", "{[x,y,z],[-x,-y,z],[y,x,1/2-z],[-y,-x,1/2-z],[-x,y,z+1/2],[x,-y,z+1/2],[y,-x,-z],[-y,x,-z]}", "1"),
    ],
    "D2d^11": [
        ("2a", "{[0,0,0]}", "-42m"),
        ("2b", "{[0,0,1/2]}", "-42m"),
        ("4c", "{[0,1/2,0],[1/2,0,0]}", "222."),
        ("4d", "{[0,1/2,1/4],[1/2,0,1/4]}", "-4.."),
        ("4e", "{[0,0,z],[0,0,-z]}", "2.mm"),
        ("8f", "{[x,0,0],[-x,0,0],[0,-x,0],[0,x,0]}", ".2."),
        ("8g", "{[x,0,1/2],[-x,0,1/2],[0,-x,1/2],[0,x,1/2]}", ".2."),
        ("8h", "{[0,1/2,z],[0,1/2,-z],[1/2,0,z],[1/2,0,-z]}", "2.."),
        ("8i", "{[x,x,z],[-x,-x,z],[x,-x,-z],[-x,x,-z]}", "..m"),
        ("16j", "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[-y,-x,z],[y,x,z],[y,-x,-z],[-y,x,-z]}", "1"),
    ],
    "D2d^12": [
        ("4a", "{[0,0,0],[0,1/2,1/4]}", "-4.."),
        ("4b", "{[0,0,1/2],[1/2,0,1/4]}", "-4.."),
        ("8c", "{[0,0,z],[0,1/2,1/4-z],[0,1/2,z+1/4],[0,0,-z]}", "2.."),
        ("8d", "{[x,1/4,1/8],[-x,3/4,1/8],[3/4,1/2-x,3/8],[1/4,x+1/2,3/8]}", ".2."),
        ("16e", "{[x,y,z],[-x,-y,z],[x+1/2,-y,3/4-z],[1/2-x,y,3/4-z],[1/2-y,-x,z+3/4],[y+1/2,x,z+3/4],[y,-x,-z],[-y,x,-z]}", "1"),
    ],
    "D4h^1": [
        ("1a", "{[0,0,0]}", "4/mmm"),
        ("1b", "{[0,0,1/2]}", "4/mmm"),
        ("1c", "{[1/2,1/2,0]}", "4/mmm"),
        ("1d", "{[1/2,1/2,1/2]}", "4/mmm"),
        ("2e", "{[0,1/2,1/2],[1/2,0,1/2]}", "mmm."),
        ("2f", "{[0,1/2,0],[1/2,0,0]}", "mmm."),
        ("2g", "{[0,0,z],[0,0,-z]}", "4mm"),
        ("2h", "{[1/2,1/2,z],[1/2,1/2,-z]}", "4mm"),
        ("4i", "{[0,1/2,z],[0,1/2,-z],[1/2,0,-z],[1/2,0,z]}", "2mm."),
        ("4j", "{[x,x,0],[-x,-x,0],[x,-x,0],[-x,x,0]}", "m.2m"),
        ("4k", "{[x,x,1/2],[-x,-x,1/2],[x,-x,1/2],[-x,x,1/2]}", "m.2m"),
        ("4l", "{[x,0,0],[-x,0,0],[0,x,0],[0,-x,0]}", "m2m."),
        ("4m", "{[x,0,1/2],[-x,0,1/2],[0,x,1/2],[0,-x,1/2]}", "m2m."),
        ("4n", "{[x,1/2,0],[-x,1/2,0],[1/2,x,0],[1/2,-x,0]}", "m2m."),
        ("4o", "{[x,1/2,1/2],[-x,1/2,1/2],[1/2,x,1/2],[1/2,-x,1/2]}", "m2m."),
        ("8p", "{[x,y,0],[-x,-y,0],[x,-y,0],[-x,y,0],[y,x,0],[-y,-x,0],[-y,x,0],[y,-x,0]}", "m.."),
        ("8q", "{[x,y,1/2],[-x,-y,1/2],[x,-y,1/2],[-x,y,1/2],[y,x,1/2],[-y,-x,1/2],[-y,x,1/2],[y,-x,1/2]}", "m.."),
        ("8r", "{[x,x,z],[-x,-x,z],[x,-x,-z],[-x,x,-z],[x,x,-z],[-x,-x,-z],[-x,x,z],[x,-x,z]}", "..m"),
        ("8s", "{[x,0,z],[-x,0,z],[x,0,-z],[-x,0,-z],[0,x,-z],[0,-x,-z],[0,x,z],[0,-x,z]}", ".m."),
        ("8t", "{[x,1/2,z],[-x,1/2,z],[x,1/2,-z],[-x,1/2,-z],[1/2,x,-z],[1/2,-x,-z],[1/2,x,z],[1/2,-x,z]}", ".m."),
        (
            "16u",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[y,x,-z],[-y,-x,-z],[-y,x,z],[y,-x,z],[-x,-y,-z],[x,y,-z],[-x,y,z],[x,-y,z],[-y,-x,z],[y,x,z],[y,-x,-z],[-y,x,-z]}",
            "1",
        ),
    ],
    "D4h^2": [
        ("2a", "{[0,0,1/4],[0,0,3/4]}", "422"),
        ("2b", "{[0,0,0],[0,0,1/2]}", "4/m.."),
        ("2c", "{[1/2,1/2,1/4],[1/2,1/2,3/4]}", "422"),
        ("2d", "{[1/2,1/2,0],[1/2,1/2,1/2]}", "4/m.."),
        ("4e", "{[0,1/2,0],[0,1/2,1/2],[1/2,0,1/2],[1/2,0,0]}", "2/m.."),
        ("4f", "{[0,1/2,1/4],[1/2,0,1/4],[0,1/2,3/4],[1/2,0,3/4]}", "222."),
        ("4g", "{[0,0,z],[0,0,1/2-z],[0,0,-z],[0,0,z+1/2]}", "4.."),
        ("4h", "{[1/2,1/2,z],[1/2,1/2,1/2-z],[1/2,1/2,-z],[1/2,1/2,z+1/2]}", "4.."),
        ("8i", "{[0,1/2,z],[0,1/2,1/2-z],[1/2,0,1/2-z],[1/2,0,z],[0,1/2,-z],[0,1/2,z+1/2],[1/2,0,z+1/2],[1/2,0,-z]}", "2.."),
        ("8j", "{[x,x,1/4],[-x,-x,1/4],[x,-x,1/4],[-x,x,1/4],[-x,-x,3/4],[x,x,3/4],[-x,x,3/4],[x,-x,3/4]}", "..2"),
        ("8k", "{[x,0,1/4],[-x,0,1/4],[0,x,1/4],[0,-x,1/4],[-x,0,3/4],[x,0,3/4],[0,-x,3/4],[0,x,3/4]}", ".2."),
        ("8l", "{[x,1/2,1/4],[-x,1/2,1/4],[1/2,x,1/4],[1/2,-x,1/4],[-x,1/2,3/4],[x,1/2,3/4],[1/2,-x,3/4],[1/2,x,3/4]}", ".2."),
        ("8m", "{[x,y,0],[-x,-y,0],[x,-y,1/2],[-x,y,1/2],[y,x,1/2],[-y,-x,1/2],[-y,x,0],[y,-x,0]}", "m.."),
        (
            "16n",
            "{[x,y,z],[-x,-y,z],[x,-y,1/2-z],[-x,y,1/2-z],[y,x,1/2-z],[-y,-x,1/2-z],[-y,x,z],[y,-x,z],[-x,-y,-z],[x,y,-z],[-x,y,z+1/2],[x,-y,z+1/2],[-y,-x,z+1/2],[y,x,z+1/2],[y,-x,-z],[-y,x,-z]}",
            "1",
        ),
    ],
    "D4h^3": [
        ("2a", "{[1/4,1/4,0],[3/4,3/4,0]}", "422"),
        ("2b", "{[1/4,1/4,1/2],[3/4,3/4,1/2]}", "422"),
        ("2c", "{[3/4,1/4,0],[1/4,3/4,0]}", "-42m"),
        ("2d", "{[3/4,1/4,1/2],[1/4,3/4,1/2]}", "-42m"),
        ("4e", "{[0,0,0],[1/2,1/2,0],[0,1/2,0],[1/2,0,0]}", "..2/m"),
        ("4f", "{[0,0,1/2],[1/2,1/2,1/2],[0,1/2,1/2],[1/2,0,1/2]}", "..2/m"),
        ("4g", "{[1/4,1/4,z],[1/4,1/4,-z],[3/4,3/4,-z],[3/4,3/4,z]}", "4.."),
        ("4h", "{[3/4,1/4,z],[3/4,1/4,-z],[1/4,3/4,-z],[1/4,3/4,z]}", "2.mm"),
        ("8i", "{[x,x,0],[1/2-x,1/2-x,0],[x,1/2-x,0],[1/2-x,x,0],[-x,-x,0],[x+1/2,x+1/2,0],[-x,x+1/2,0],[x+1/2,-x,0]}", "..2"),
        (
            "8j",
            "{[x,x,1/2],[1/2-x,1/2-x,1/2],[x,1/2-x,1/2],[1/2-x,x,1/2],[-x,-x,1/2],[x+1/2,x+1/2,1/2],[-x,x+1/2,1/2],[x+1/2,-x,1/2]}",
            "..2",
        ),
        ("8k", "{[x,1/4,0],[1/2-x,1/4,0],[1/4,x,0],[1/4,1/2-x,0],[-x,3/4,0],[x+1/2,3/4,0],[3/4,-x,0],[3/4,x+1/2,0]}", ".2."),
        (
            "8l",
            "{[x,1/4,1/2],[1/2-x,1/4,1/2],[1/4,x,1/2],[1/4,1/2-x,1/2],[-x,3/4,1/2],[x+1/2,3/4,1/2],[3/4,-x,1/2],[3/4,x+1/2,1/2]}",
            ".2.",
        ),
        (
            "8m",
            "{[x,-x,z],[1/2-x,x+1/2,z],[x,x+1/2,-z],[1/2-x,-x,-z],[-x,x,-z],[x+1/2,1/2-x,-z],[x+1/2,x,z],[-x,1/2-x,z]}",
            "..m",
        ),
        (
            "16n",
            "{[x,y,z],[1/2-x,1/2-y,z],[x,1/2-y,-z],[1/2-x,y,-z],[y,x,-z],[1/2-y,1/2-x,-z],[1/2-y,x,z],[y,1/2-x,z],[-x,-y,-z],[x+1/2,y+1/2,-z],[-x,y+1/2,z],[x+1/2,-y,z],[-y,-x,z],[y+1/2,x+1/2,z],[y+1/2,-x,-z],[-y,x+1/2,-z]}",
            "1",
        ),
    ],
    "D4h^4": [
        ("2a", "{[1/4,1/4,1/4],[3/4,3/4,3/4]}", "422"),
        ("2b", "{[1/4,1/4,3/4],[3/4,3/4,1/4]}", "422"),
        ("4c", "{[1/4,3/4,3/4],[3/4,1/4,3/4],[3/4,1/4,1/4],[1/4,3/4,1/4]}", "222."),
        ("4d", "{[1/4,3/4,0],[1/4,3/4,1/2],[3/4,1/4,1/2],[3/4,1/4,0]}", "-4.."),
        ("4e", "{[1/4,1/4,z],[1/4,1/4,1/2-z],[3/4,3/4,-z],[3/4,3/4,z+1/2]}", "4.."),
        ("8f", "{[0,0,0],[1/2,1/2,0],[0,1/2,1/2],[1/2,0,1/2],[0,0,1/2],[1/2,1/2,1/2],[1/2,0,0],[0,1/2,0]}", "-1"),
        (
            "8g",
            "{[1/4,3/4,z],[1/4,3/4,1/2-z],[3/4,1/4,1/2-z],[3/4,1/4,z],[3/4,1/4,-z],[3/4,1/4,z+1/2],[1/4,3/4,z+1/2],[1/4,3/4,-z]}",
            "2..",
        ),
        (
            "8h",
            "{[x,x,1/4],[1/2-x,1/2-x,1/4],[x,1/2-x,1/4],[1/2-x,x,1/4],[-x,-x,3/4],[x+1/2,x+1/2,3/4],[-x,x+1/2,3/4],[x+1/2,-x,3/4]}",
            "..2",
        ),
        (
            "8i",
            "{[x,1/4,1/4],[1/2-x,1/4,1/4],[1/4,x,1/4],[1/4,1/2-x,1/4],[-x,3/4,3/4],[x+1/2,3/4,3/4],[3/4,-x,3/4],[3/4,x+1/2,3/4]}",
            ".2.",
        ),
        (
            "8j",
            "{[x,3/4,1/4],[1/2-x,3/4,1/4],[3/4,x,1/4],[3/4,1/2-x,1/4],[-x,1/4,3/4],[x+1/2,1/4,3/4],[1/4,-x,3/4],[1/4,x+1/2,3/4]}",
            ".2.",
        ),
        (
            "16k",
            "{[x,y,z],[1/2-x,1/2-y,z],[x,1/2-y,1/2-z],[1/2-x,y,1/2-z],[y,x,1/2-z],[1/2-y,1/2-x,1/2-z],[1/2-y,x,z],[y,1/2-x,z],[-x,-y,-z],[x+1/2,y+1/2,-z],[-x,y+1/2,z+1/2],[x+1/2,-y,z+1/2],[-y,-x,z+1/2],[y+1/2,x+1/2,z+1/2],[y+1/2,-x,-z],[-y,x+1/2,-z]}",
            "1",
        ),
    ],
    "D4h^5": [
        ("2a", "{[0,0,0],[1/2,1/2,0]}", "4/m.."),
        ("2b", "{[0,0,1/2],[1/2,1/2,1/2]}", "4/m.."),
        ("2c", "{[0,1/2,1/2],[1/2,0,1/2]}", "m.mm"),
        ("2d", "{[0,1/2,0],[1/2,0,0]}", "m.mm"),
        ("4e", "{[0,0,z],[1/2,1/2,-z],[0,0,-z],[1/2,1/2,z]}", "4.."),
        ("4f", "{[0,1/2,z],[1/2,0,-z],[0,1/2,-z],[1/2,0,z]}", "2.mm"),
        ("4g", "{[x,x+1/2,0],[-x,1/2-x,0],[x+1/2,-x,0],[1/2-x,x,0]}", "m.2m"),
        ("4h", "{[x,x+1/2,1/2],[-x,1/2-x,1/2],[x+1/2,-x,1/2],[1/2-x,x,1/2]}", "m.2m"),
        ("8i", "{[x,y,0],[-x,-y,0],[x+1/2,1/2-y,0],[1/2-x,y+1/2,0],[y+1/2,x+1/2,0],[1/2-y,1/2-x,0],[-y,x,0],[y,-x,0]}", "m.."),
        (
            "8j",
            "{[x,y,1/2],[-x,-y,1/2],[x+1/2,1/2-y,1/2],[1/2-x,y+1/2,1/2],[y+1/2,x+1/2,1/2],[1/2-y,1/2-x,1/2],[-y,x,1/2],[y,-x,1/2]}",
            "m..",
        ),
        (
            "8k",
            "{[x,x+1/2,z],[-x,1/2-x,z],[x+1/2,-x,-z],[1/2-x,x,-z],[x,x+1/2,-z],[-x,1/2-x,-z],[1/2-x,x,z],[x+1/2,-x,z]}",
            "..m",
        ),
        (
            "16l",
            "{[x,y,z],[-x,-y,z],[x+1/2,1/2-y,-z],[1/2-x,y+1/2,-z],[y+1/2,x+1/2,-z],[1/2-y,1/2-x,-z],[-y,x,z],[y,-x,z],[-x,-y,-z],[x,y,-z],[1/2-x,y+1/2,z],[x+1/2,1/2-y,z],[1/2-y,1/2-x,z],[y+1/2,x+1/2,z],[y,-x,-z],[-y,x,-z]}",
            "1",
        ),
    ],
    "D4h^6": [
        ("2a", "{[0,0,0],[1/2,1/2,1/2]}", "4/m.."),
        ("2b", "{[0,0,1/2],[1/2,1/2,0]}", "4/m.."),
        ("4c", "{[0,1/2,0],[1/2,0,1/2],[0,1/2,1/2],[1/2,0,0]}", "2/m.."),
        ("4d", "{[0,1/2,1/4],[1/2,0,1/4],[0,1/2,3/4],[1/2,0,3/4]}", "2.22"),
        ("4e", "{[0,0,z],[1/2,1/2,1/2-z],[0,0,-z],[1/2,1/2,z+1/2]}", "4.."),
        ("8f", "{[0,1/2,z],[1/2,0,1/2-z],[0,1/2,1/2-z],[1/2,0,z],[0,1/2,-z],[1/2,0,z+1/2],[0,1/2,z+1/2],[1/2,0,-z]}", "2.."),
        (
            "8g",
            "{[x,x+1/2,1/4],[-x,1/2-x,1/4],[x+1/2,-x,1/4],[1/2-x,x,1/4],[-x,1/2-x,3/4],[x,x+1/2,3/4],[1/2-x,x,3/4],[x+1/2,-x,3/4]}",
            "..2",
        ),
        (
            "8h",
            "{[x,y,0],[-x,-y,0],[x+1/2,1/2-y,1/2],[1/2-x,y+1/2,1/2],[y+1/2,x+1/2,1/2],[1/2-y,1/2-x,1/2],[-y,x,0],[y,-x,0]}",
            "m..",
        ),
        (
            "16i",
            "{[x,y,z],[-x,-y,z],[x+1/2,1/2-y,1/2-z],[1/2-x,y+1/2,1/2-z],[y+1/2,x+1/2,1/2-z],[1/2-y,1/2-x,1/2-z],[-y,x,z],[y,-x,z],[-x,-y,-z],[x,y,-z],[1/2-x,y+1/2,z+1/2],[x+1/2,1/2-y,z+1/2],[1/2-y,1/2-x,z+1/2],[y+1/2,x+1/2,z+1/2],[y,-x,-z],[-y,x,-z]}",
            "1",
        ),
    ],
    "D4h^7": [
        ("2a", "{[3/4,1/4,0],[1/4,3/4,0]}", "-4m2"),
        ("2b", "{[3/4,1/4,1/2],[1/4,3/4,1/2]}", "-4m2"),
        ("2c", "{[1/4,1/4,z],[3/4,3/4,-z]}", "4mm"),
        ("4d", "{[0,0,0],[1/2,1/2,0],[1/2,0,0],[0,1/2,0]}", "..2/m"),
        ("4e", "{[0,0,1/2],[1/2,1/2,1/2],[1/2,0,1/2],[0,1/2,1/2]}", "..2/m"),
        ("4f", "{[3/4,1/4,z],[1/4,3/4,-z],[3/4,1/4,-z],[1/4,3/4,z]}", "2mm."),
        ("8g", "{[x,-x,0],[1/2-x,x+1/2,0],[x+1/2,x,0],[-x,1/2-x,0],[-x,x,0],[x+1/2,1/2-x,0],[1/2-x,-x,0],[x,x+1/2,0]}", "..2"),
        (
            "8h",
            "{[x,-x,1/2],[1/2-x,x+1/2,1/2],[x+1/2,x,1/2],[-x,1/2-x,1/2],[-x,x,1/2],[x+1/2,1/2-x,1/2],[1/2-x,-x,1/2],[x,x+1/2,1/2]}",
            "..2",
        ),
        ("8i", "{[1/4,y,z],[1/4,1/2-y,z],[3/4,-y,-z],[3/4,y+1/2,-z],[y+1/2,3/4,-z],[-y,3/4,-z],[1/2-y,1/4,z],[y,1/4,z]}", ".m."),
        (
            "8j",
            "{[x,x,z],[1/2-x,1/2-x,z],[x+1/2,-x,-z],[-x,x+1/2,-z],[x+1/2,x+1/2,-z],[-x,-x,-z],[1/2-x,x,z],[x,1/2-x,z]}",
            "..m",
        ),
        (
            "16k",
            "{[x,y,z],[1/2-x,1/2-y,z],[x+1/2,-y,-z],[-x,y+1/2,-z],[y+1/2,x+1/2,-z],[-y,-x,-z],[1/2-y,x,z],[y,1/2-x,z],[-x,-y,-z],[x+1/2,y+1/2,-z],[1/2-x,y,z],[x,1/2-y,z],[1/2-y,1/2-x,z],[y,x,z],[y+1/2,-x,-z],[-y,x+1/2,-z]}",
            "1",
        ),
    ],
    "D4h^8": [
        ("4a", "{[3/4,1/4,1/4],[1/4,3/4,1/4],[1/4,3/4,3/4],[3/4,1/4,3/4]}", "2.22"),
        ("4b", "{[3/4,1/4,0],[1/4,3/4,1/2],[3/4,1/4,1/2],[1/4,3/4,0]}", "-4.."),
        ("4c", "{[1/4,1/4,z],[3/4,3/4,1/2-z],[3/4,3/4,-z],[1/4,1/4,z+1/2]}", "4.."),
        ("8d", "{[0,0,0],[1/2,1/2,0],[1/2,0,1/2],[0,1/2,1/2],[1/2,1/2,1/2],[0,0,1/2],[1/2,0,0],[0,1/2,0]}", "-1"),
        (
            "8e",
            "{[3/4,1/4,z],[1/4,3/4,1/2-z],[3/4,1/4,1/2-z],[1/4,3/4,z],[1/4,3/4,-z],[3/4,1/4,z+1/2],[1/4,3/4,z+1/2],[3/4,1/4,-z]}",
            "2..",
        ),
        (
            "8f",
            "{[x,-x,1/4],[1/2-x,x+1/2,1/4],[x+1/2,x,1/4],[-x,1/2-x,1/4],[-x,x,3/4],[x+1/2,1/2-x,3/4],[1/2-x,-x,3/4],[x,x+1/2,3/4]}",
            "..2",
        ),
        (
            "16g",
            "{[x,y,z],[1/2-x,1/2-y,z],[x+1/2,-y,1/2-z],[-x,y+1/2,1/2-z],[y+1/2,x+1/2,1/2-z],[-y,-x,1/2-z],[1/2-y,x,z],[y,1/2-x,z],[-x,-y,-z],[x+1/2,y+1/2,-z],[1/2-x,y,z+1/2],[x,1/2-y,z+1/2],[1/2-y,1/2-x,z+1/2],[y,x,z+1/2],[y+1/2,-x,-z],[-y,x+1/2,-z]}",
            "1",
        ),
    ],
    "D4h^9": [
        ("2a", "{[0,0,0],[0,0,1/2]}", "mmm."),
        ("2b", "{[1/2,1/2,0],[1/2,1/2,1/2]}", "mmm."),
        ("2c", "{[0,1/2,0],[1/2,0,1/2]}", "mmm."),
        ("2d", "{[0,1/2,1/2],[1/2,0,0]}", "mmm."),
        ("2e", "{[0,0,1/4],[0,0,3/4]}", "-4m2"),
        ("2f", "{[1/2,1/2,1/4],[1/2,1/2,3/4]}", "-4m2"),
        ("4g", "{[0,0,z],[0,0,-z],[0,0,1/2-z],[0,0,z+1/2]}", "2mm."),
        ("4h", "{[1/2,1/2,z],[1/2,1/2,-z],[1/2,1/2,1/2-z],[1/2,1/2,z+1/2]}", "2mm."),
        ("4i", "{[0,1/2,z],[0,1/2,-z],[1/2,0,1/2-z],[1/2,0,z+1/2]}", "2mm."),
        ("4j", "{[x,0,0],[-x,0,0],[0,x,1/2],[0,-x,1/2]}", "m2m."),
        ("4k", "{[x,1/2,1/2],[-x,1/2,1/2],[1/2,x,0],[1/2,-x,0]}", "m2m."),
        ("4l", "{[x,0,1/2],[-x,0,1/2],[0,x,0],[0,-x,0]}", "m2m."),
        ("4m", "{[x,1/2,0],[-x,1/2,0],[1/2,x,1/2],[1/2,-x,1/2]}", "m2m."),
        ("8n", "{[x,x,1/4],[-x,-x,1/4],[x,-x,3/4],[-x,x,3/4],[-x,-x,3/4],[x,x,3/4],[-x,x,1/4],[x,-x,1/4]}", "..2"),
        ("8o", "{[0,y,z],[0,-y,z],[0,-y,-z],[0,y,-z],[y,0,1/2-z],[-y,0,1/2-z],[-y,0,z+1/2],[y,0,z+1/2]}", ".m."),
        ("8p", "{[1/2,y,z],[1/2,-y,z],[1/2,-y,-z],[1/2,y,-z],[y,1/2,1/2-z],[-y,1/2,1/2-z],[-y,1/2,z+1/2],[y,1/2,z+1/2]}", ".m."),
        ("8q", "{[x,y,0],[-x,-y,0],[x,-y,0],[-x,y,0],[y,x,1/2],[-y,-x,1/2],[-y,x,1/2],[y,-x,1/2]}", "m.."),
        (
            "16r",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[y,x,1/2-z],[-y,-x,1/2-z],[-y,x,z+1/2],[y,-x,z+1/2],[-x,-y,-z],[x,y,-z],[-x,y,z],[x,-y,z],[-y,-x,z+1/2],[y,x,z+1/2],[y,-x,1/2-z],[-y,x,1/2-z]}",
            "1",
        ),
    ],
    "D4h^10": [
        ("2a", "{[0,0,0],[0,0,1/2]}", "m.mm"),
        ("2b", "{[0,0,1/4],[0,0,3/4]}", "-42m"),
        ("2c", "{[1/2,1/2,0],[1/2,1/2,1/2]}", "m.mm"),
        ("2d", "{[1/2,1/2,1/4],[1/2,1/2,3/4]}", "-42m"),
        ("4e", "{[0,1/2,1/4],[1/2,0,3/4],[0,1/2,3/4],[1/2,0,1/4]}", "222."),
        ("4f", "{[0,1/2,0],[0,1/2,1/2],[1/2,0,0],[1/2,0,1/2]}", "2/m.."),
        ("4g", "{[0,0,z],[0,0,1/2-z],[0,0,-z],[0,0,z+1/2]}", "2.mm"),
        ("4h", "{[1/2,1/2,z],[1/2,1/2,1/2-z],[1/2,1/2,-z],[1/2,1/2,z+1/2]}", "2.mm"),
        ("4i", "{[x,x,0],[-x,-x,0],[x,-x,1/2],[-x,x,1/2]}", "m.2m"),
        ("4j", "{[x,x,1/2],[-x,-x,1/2],[x,-x,0],[-x,x,0]}", "m.2m"),
        ("8k", "{[0,1/2,z],[0,1/2,1/2-z],[1/2,0,-z],[1/2,0,z+1/2],[0,1/2,-z],[0,1/2,z+1/2],[1/2,0,z],[1/2,0,1/2-z]}", "2.."),
        ("8l", "{[x,0,1/4],[-x,0,1/4],[0,x,3/4],[0,-x,3/4],[-x,0,3/4],[x,0,3/4],[0,-x,1/4],[0,x,1/4]}", ".2."),
        ("8m", "{[x,1/2,1/4],[-x,1/2,1/4],[1/2,x,3/4],[1/2,-x,3/4],[-x,1/2,3/4],[x,1/2,3/4],[1/2,-x,1/4],[1/2,x,1/4]}", ".2."),
        ("8n", "{[x,y,0],[-x,-y,0],[x,-y,1/2],[-x,y,1/2],[y,x,0],[-y,-x,0],[-y,x,1/2],[y,-x,1/2]}", "m.."),
        ("8o", "{[x,x,z],[-x,-x,z],[x,-x,1/2-z],[-x,x,1/2-z],[x,x,-z],[-x,-x,-z],[-x,x,z+1/2],[x,-x,z+1/2]}", "..m"),
        (
            "16p",
            "{[x,y,z],[-x,-y,z],[x,-y,1/2-z],[-x,y,1/2-z],[y,x,-z],[-y,-x,-z],[-y,x,z+1/2],[y,-x,z+1/2],[-x,-y,-z],[x,y,-z],[-x,y,z+1/2],[x,-y,z+1/2],[-y,-x,z],[y,x,z],[y,-x,1/2-z],[-y,x,1/2-z]}",
            "1",
        ),
    ],
    "D4h^11": [
        ("4a", "{[1/4,1/4,0],[1/4,1/4,1/2],[3/4,3/4,0],[3/4,3/4,1/2]}", "222."),
        ("4b", "{[3/4,1/4,0],[1/4,3/4,1/2],[1/4,3/4,0],[3/4,1/4,1/2]}", "222."),
        ("4c", "{[1/4,1/4,1/4],[1/4,1/4,3/4],[3/4,3/4,3/4],[3/4,3/4,1/4]}", "2.22"),
        ("4d", "{[3/4,1/4,3/4],[3/4,1/4,1/4],[1/4,3/4,3/4],[1/4,3/4,1/4]}", "-4.."),
        ("8e", "{[0,0,0],[1/2,1/2,0],[0,1/2,0],[1/2,0,0],[0,0,1/2],[1/2,1/2,1/2],[1/2,0,1/2],[0,1/2,1/2]}", "-1"),
        (
            "8f",
            "{[1/4,1/4,z],[1/4,1/4,-z],[1/4,1/4,1/2-z],[1/4,1/4,z+1/2],[3/4,3/4,-z],[3/4,3/4,z],[3/4,3/4,z+1/2],[3/4,3/4,1/2-z]}",
            "2..",
        ),
        (
            "8g",
            "{[3/4,1/4,z],[3/4,1/4,-z],[1/4,3/4,1/2-z],[1/4,3/4,z+1/2],[1/4,3/4,-z],[1/4,3/4,z],[3/4,1/4,z+1/2],[3/4,1/4,1/2-z]}",
            "2..",
        ),
        (
            "8h",
            "{[x,1/4,0],[1/2-x,1/4,0],[1/4,x,1/2],[1/4,1/2-x,1/2],[-x,3/4,0],[x+1/2,3/4,0],[3/4,-x,1/2],[3/4,x+1/2,1/2]}",
            ".2.",
        ),
        (
            "8i",
            "{[x,1/4,1/2],[1/2-x,1/4,1/2],[1/4,x,0],[1/4,1/2-x,0],[-x,3/4,1/2],[x+1/2,3/4,1/2],[3/4,-x,0],[3/4,x+1/2,0]}",
            ".2.",
        ),
        (
            "8j",
            "{[x,x,1/4],[1/2-x,1/2-x,1/4],[x,1/2-x,3/4],[1/2-x,x,3/4],[-x,-x,3/4],[x+1/2,x+1/2,3/4],[-x,x+1/2,1/4],[x+1/2,-x,1/4]}",
            "..2",
        ),
        (
            "16k",
            "{[x,y,z],[1/2-x,1/2-y,z],[x,1/2-y,-z],[1/2-x,y,-z],[y,x,1/2-z],[1/2-y,1/2-x,1/2-z],[1/2-y,x,z+1/2],[y,1/2-x,z+1/2],[-x,-y,-z],[x+1/2,y+1/2,-z],[-x,y+1/2,z],[x+1/2,-y,z],[-y,-x,z+1/2],[y+1/2,x+1/2,z+1/2],[y+1/2,-x,1/2-z],[-y,x+1/2,1/2-z]}",
            "1",
        ),
    ],
    "D4h^12": [
        ("2a", "{[1/4,3/4,1/4],[3/4,1/4,3/4]}", "-42m"),
        ("2b", "{[3/4,1/4,1/4],[1/4,3/4,3/4]}", "-42m"),
        ("4c", "{[1/4,1/4,1/4],[1/4,1/4,3/4],[3/4,3/4,3/4],[3/4,3/4,1/4]}", "222."),
        ("4d", "{[1/4,1/4,0],[1/4,1/4,1/2],[3/4,3/4,0],[3/4,3/4,1/2]}", "2.22"),
        ("4e", "{[0,0,1/2],[1/2,1/2,1/2],[0,1/2,0],[1/2,0,0]}", "..2/m"),
        ("4f", "{[0,0,0],[1/2,1/2,0],[0,1/2,1/2],[1/2,0,1/2]}", "..2/m"),
        ("4g", "{[3/4,1/4,z],[3/4,1/4,1/2-z],[1/4,3/4,-z],[1/4,3/4,z+1/2]}", "2.mm"),
        (
            "8h",
            "{[1/4,1/4,z],[1/4,1/4,1/2-z],[1/4,1/4,-z],[1/4,1/4,z+1/2],[3/4,3/4,-z],[3/4,3/4,z+1/2],[3/4,3/4,z],[3/4,3/4,1/2-z]}",
            "2..",
        ),
        (
            "8i",
            "{[x,1/4,3/4],[1/2-x,1/4,3/4],[1/4,x,1/4],[1/4,1/2-x,1/4],[-x,3/4,1/4],[x+1/2,3/4,1/4],[3/4,-x,3/4],[3/4,x+1/2,3/4]}",
            ".2.",
        ),
        (
            "8j",
            "{[x,1/4,1/4],[1/2-x,1/4,1/4],[1/4,x,3/4],[1/4,1/2-x,3/4],[-x,3/4,3/4],[x+1/2,3/4,3/4],[3/4,-x,1/4],[3/4,x+1/2,1/4]}",
            ".2.",
        ),
        (
            "8k",
            "{[x,x,0],[1/2-x,1/2-x,0],[x,1/2-x,1/2],[1/2-x,x,1/2],[-x,-x,0],[x+1/2,x+1/2,0],[-x,x+1/2,1/2],[x+1/2,-x,1/2]}",
            "..2",
        ),
        (
            "8l",
            "{[x,x,1/2],[1/2-x,1/2-x,1/2],[x,1/2-x,0],[1/2-x,x,0],[-x,-x,1/2],[x+1/2,x+1/2,1/2],[-x,x+1/2,0],[x+1/2,-x,0]}",
            "..2",
        ),
        (
            "8m",
            "{[x,-x,z],[1/2-x,x+1/2,z],[x,x+1/2,1/2-z],[1/2-x,-x,1/2-z],[-x,x,-z],[x+1/2,1/2-x,-z],[x+1/2,x,z+1/2],[-x,1/2-x,z+1/2]}",
            "..m",
        ),
        (
            "16n",
            "{[x,y,z],[1/2-x,1/2-y,z],[x,1/2-y,1/2-z],[1/2-x,y,1/2-z],[y,x,-z],[1/2-y,1/2-x,-z],[1/2-y,x,z+1/2],[y,1/2-x,z+1/2],[-x,-y,-z],[x+1/2,y+1/2,-z],[-x,y+1/2,z+1/2],[x+1/2,-y,z+1/2],[-y,-x,z],[y+1/2,x+1/2,z],[y+1/2,-x,1/2-z],[-y,x+1/2,1/2-z]}",
            "1",
        ),
    ],
    "D4h^13": [
        ("4a", "{[0,0,0],[1/2,1/2,0],[1/2,1/2,1/2],[0,0,1/2]}", "2/m.."),
        ("4b", "{[0,0,1/4],[1/2,1/2,3/4],[1/2,1/2,1/4],[0,0,3/4]}", "-4.."),
        ("4c", "{[0,1/2,0],[1/2,0,0],[0,1/2,1/2],[1/2,0,1/2]}", "2/m.."),
        ("4d", "{[0,1/2,1/4],[1/2,0,3/4],[0,1/2,3/4],[1/2,0,1/4]}", "2.22"),
        ("8e", "{[0,0,z],[1/2,1/2,-z],[1/2,1/2,1/2-z],[0,0,z+1/2],[0,0,-z],[1/2,1/2,z],[1/2,1/2,z+1/2],[0,0,1/2-z]}", "2.."),
        ("8f", "{[0,1/2,z],[1/2,0,-z],[0,1/2,1/2-z],[1/2,0,z+1/2],[0,1/2,-z],[1/2,0,z],[0,1/2,z+1/2],[1/2,0,1/2-z]}", "2.."),
        (
            "8g",
            "{[x,x+1/2,1/4],[-x,1/2-x,1/4],[x+1/2,-x,3/4],[1/2-x,x,3/4],[-x,1/2-x,3/4],[x,x+1/2,3/4],[1/2-x,x,1/4],[x+1/2,-x,1/4]}",
            "..2",
        ),
        (
            "8h",
            "{[x,y,0],[-x,-y,0],[x+1/2,1/2-y,0],[1/2-x,y+1/2,0],[y+1/2,x+1/2,1/2],[1/2-y,1/2-x,1/2],[-y,x,1/2],[y,-x,1/2]}",
            "m..",
        ),
        (
            "16i",
            "{[x,y,z],[-x,-y,z],[x+1/2,1/2-y,-z],[1/2-x,y+1/2,-z],[y+1/2,x+1/2,1/2-z],[1/2-y,1/2-x,1/2-z],[-y,x,z+1/2],[y,-x,z+1/2],[-x,-y,-z],[x,y,-z],[1/2-x,y+1/2,z],[x+1/2,1/2-y,z],[1/2-y,1/2-x,z+1/2],[y+1/2,x+1/2,z+1/2],[y,-x,1/2-z],[-y,x,1/2-z]}",
            "1",
        ),
    ],
    "D4h^14": [
        ("2a", "{[0,0,0],[1/2,1/2,1/2]}", "m.mm"),
        ("2b", "{[0,0,1/2],[1/2,1/2,0]}", "m.mm"),
        ("4c", "{[0,1/2,0],[1/2,0,1/2],[1/2,0,0],[0,1/2,1/2]}", "2/m.."),
        ("4d", "{[0,1/2,1/4],[1/2,0,1/4],[1/2,0,3/4],[0,1/2,3/4]}", "-4.."),
        ("4e", "{[0,0,z],[1/2,1/2,1/2-z],[0,0,-z],[1/2,1/2,z+1/2]}", "2.mm"),
        ("4f", "{[x,x,0],[-x,-x,0],[x+1/2,1/2-x,1/2],[1/2-x,x+1/2,1/2]}", "m.2m"),
        ("4g", "{[x,-x,0],[-x,x,0],[x+1/2,x+1/2,1/2],[1/2-x,1/2-x,1/2]}", "m.2m"),
        ("8h", "{[0,1/2,z],[1/2,0,1/2-z],[1/2,0,-z],[0,1/2,z+1/2],[0,1/2,-z],[1/2,0,z+1/2],[1/2,0,z],[0,1/2,1/2-z]}", "2.."),
        (
            "8i",
            "{[x,y,0],[-x,-y,0],[x+1/2,1/2-y,1/2],[1/2-x,y+1/2,1/2],[y,x,0],[-y,-x,0],[1/2-y,x+1/2,1/2],[y+1/2,1/2-x,1/2]}",
            "m..",
        ),
        (
            "8j",
            "{[x,x,z],[-x,-x,z],[x+1/2,1/2-x,1/2-z],[1/2-x,x+1/2,1/2-z],[x,x,-z],[-x,-x,-z],[1/2-x,x+1/2,z+1/2],[x+1/2,1/2-x,z+1/2]}",
            "..m",
        ),
        (
            "16k",
            "{[x,y,z],[-x,-y,z],[x+1/2,1/2-y,1/2-z],[1/2-x,y+1/2,1/2-z],[y,x,-z],[-y,-x,-z],[1/2-y,x+1/2,z+1/2],[y+1/2,1/2-x,z+1/2],[-x,-y,-z],[x,y,-z],[1/2-x,y+1/2,z+1/2],[x+1/2,1/2-y,z+1/2],[-y,-x,z],[y,x,z],[y+1/2,1/2-x,1/2-z],[1/2-y,x+1/2,1/2-z]}",
            "1",
        ),
    ],
    "D4h^15": [
        ("2a", "{[3/4,1/4,3/4],[1/4,3/4,1/4]}", "-4m2"),
        ("2b", "{[3/4,1/4,1/4],[1/4,3/4,3/4]}", "-4m2"),
        ("4c", "{[3/4,1/4,z],[1/4,3/4,-z],[3/4,1/4,1/2-z],[1/4,3/4,z+1/2]}", "2mm."),
        ("4d", "{[1/4,1/4,z],[3/4,3/4,-z],[3/4,3/4,1/2-z],[1/4,1/4,z+1/2]}", "2mm."),
        ("8e", "{[0,0,0],[1/2,1/2,0],[1/2,0,0],[0,1/2,0],[1/2,1/2,1/2],[0,0,1/2],[1/2,0,1/2],[0,1/2,1/2]}", "-1"),
        (
            "8f",
            "{[x,-x,1/4],[1/2-x,x+1/2,1/4],[x+1/2,x,3/4],[-x,1/2-x,3/4],[-x,x,3/4],[x+1/2,1/2-x,3/4],[1/2-x,-x,1/4],[x,x+1/2,1/4]}",
            "..2",
        ),
        (
            "8g",
            "{[1/4,y,z],[1/4,1/2-y,z],[3/4,-y,-z],[3/4,y+1/2,-z],[y+1/2,3/4,1/2-z],[-y,3/4,1/2-z],[1/2-y,1/4,z+1/2],[y,1/4,z+1/2]}",
            ".m.",
        ),
        (
            "16h",
            "{[x,y,z],[1/2-x,1/2-y,z],[x+1/2,-y,-z],[-x,y+1/2,-z],[y+1/2,x+1/2,1/2-z],[-y,-x,1/2-z],[1/2-y,x,z+1/2],[y,1/2-x,z+1/2],[-x,-y,-z],[x+1/2,y+1/2,-z],[1/2-x,y,z],[x,1/2-y,z],[1/2-y,1/2-x,z+1/2],[y,x,z+1/2],[y+1/2,-x,1/2-z],[-y,x+1/2,1/2-z]}",
            "1",
        ),
    ],
    "D4h^16": [
        ("4a", "{[3/4,1/4,0],[1/4,3/4,1/2],[1/4,3/4,0],[3/4,1/4,1/2]}", "2.22"),
        ("4b", "{[3/4,1/4,3/4],[1/4,3/4,3/4],[3/4,1/4,1/4],[1/4,3/4,1/4]}", "-4.."),
        ("4c", "{[0,0,1/2],[1/2,1/2,1/2],[1/2,0,0],[0,1/2,0]}", "..2/m"),
        ("4d", "{[0,0,0],[1/2,1/2,0],[1/2,0,1/2],[0,1/2,1/2]}", "..2/m"),
        ("4e", "{[1/4,1/4,z],[3/4,3/4,1/2-z],[3/4,3/4,-z],[1/4,1/4,z+1/2]}", "2.mm"),
        (
            "8f",
            "{[3/4,1/4,z],[1/4,3/4,1/2-z],[3/4,1/4,-z],[1/4,3/4,z+1/2],[1/4,3/4,-z],[3/4,1/4,z+1/2],[1/4,3/4,z],[3/4,1/4,1/2-z]}",
            "2..",
        ),
        (
            "8g",
            "{[x,-x,1/2],[1/2-x,x+1/2,1/2],[x+1/2,x,0],[-x,1/2-x,0],[-x,x,1/2],[x+1/2,1/2-x,1/2],[1/2-x,-x,0],[x,x+1/2,0]}",
            "..2",
        ),
        (
            "8h",
            "{[x,-x,0],[1/2-x,x+1/2,0],[x+1/2,x,1/2],[-x,1/2-x,1/2],[-x,x,0],[x+1/2,1/2-x,0],[1/2-x,-x,1/2],[x,x+1/2,1/2]}",
            "..2",
        ),
        (
            "8i",
            "{[x,x,z],[1/2-x,1/2-x,z],[x+1/2,-x,1/2-z],[-x,x+1/2,1/2-z],[x+1/2,x+1/2,-z],[-x,-x,-z],[1/2-x,x,z+1/2],[x,1/2-x,z+1/2]}",
            "..m",
        ),
        (
            "16j",
            "{[x,y,z],[1/2-x,1/2-y,z],[x+1/2,-y,1/2-z],[-x,y+1/2,1/2-z],[y+1/2,x+1/2,-z],[-y,-x,-z],[1/2-y,x,z+1/2],[y,1/2-x,z+1/2],[-x,-y,-z],[x+1/2,y+1/2,-z],[1/2-x,y,z+1/2],[x,1/2-y,z+1/2],[1/2-y,1/2-x,z],[y,x,z],[y+1/2,-x,1/2-z],[-y,x+1/2,1/2-z]}",
            "1",
        ),
    ],
    "D4h^17": [
        ("2a", "{[0,0,0]}", "4/mmm"),
        ("2b", "{[0,0,1/2]}", "4/mmm"),
        ("4c", "{[0,1/2,0],[1/2,0,0]}", "mmm."),
        ("4d", "{[0,1/2,1/4],[1/2,0,1/4]}", "-4m2"),
        ("4e", "{[0,0,z],[0,0,-z]}", "4mm"),
        ("8f", "{[1/4,1/4,1/4],[1/4,1/4,3/4],[3/4,1/4,1/4],[1/4,3/4,1/4]}", "..2/m"),
        ("8g", "{[0,1/2,z],[0,1/2,-z],[1/2,0,-z],[1/2,0,z]}", "2mm."),
        ("8h", "{[x,x,0],[-x,-x,0],[x,-x,0],[-x,x,0]}", "m.2m"),
        ("8i", "{[x,0,0],[-x,0,0],[0,x,0],[0,-x,0]}", "m2m."),
        ("8j", "{[x,1/2,0],[-x,1/2,0],[1/2,x,0],[1/2,-x,0]}", "m2m."),
        (
            "16k",
            "{[x,x+1/2,1/4],[-x,1/2-x,1/4],[x+1/2,-x,1/4],[1/2-x,x,1/4],[1/2-x,-x,1/4],[x+1/2,x,1/4],[-x,x+1/2,1/4],[x,1/2-x,1/4]}",
            "..2",
        ),
        ("16l", "{[x,y,0],[-x,-y,0],[x,-y,0],[-x,y,0],[y,x,0],[-y,-x,0],[-y,x,0],[y,-x,0]}", "m.."),
        ("16m", "{[x,x,z],[-x,-x,z],[x,-x,-z],[-x,x,-z],[x,x,-z],[-x,-x,-z],[-x,x,z],[x,-x,z]}", "..m"),
        ("16n", "{[0,y,z],[0,-y,z],[0,-y,-z],[0,y,-z],[y,0,-z],[-y,0,-z],[-y,0,z],[y,0,z]}", ".m."),
        (
            "32o",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[y,x,-z],[-y,-x,-z],[-y,x,z],[y,-x,z],[-x,-y,-z],[x,y,-z],[-x,y,z],[x,-y,z],[-y,-x,z],[y,x,z],[y,-x,-z],[-y,x,-z]}",
            "1",
        ),
    ],
    "D4h^18": [
        ("4a", "{[0,0,1/4],[0,0,3/4]}", "422"),
        ("4b", "{[0,1/2,1/4],[1/2,0,1/4]}", "-42m"),
        ("4c", "{[0,0,0],[0,0,1/2]}", "4/m.."),
        ("4d", "{[0,1/2,0],[1/2,0,0]}", "m.mm"),
        ("8e", "{[1/4,1/4,1/4],[1/4,1/4,3/4],[1/4,3/4,1/4],[3/4,1/4,1/4]}", "..2/m"),
        ("8f", "{[0,0,z],[0,0,1/2-z],[0,0,-z],[0,0,z+1/2]}", "4.."),
        ("8g", "{[0,1/2,z],[1/2,0,-z],[0,1/2,-z],[1/2,0,z]}", "2.mm"),
        ("8h", "{[x,x+1/2,0],[-x,1/2-x,0],[x+1/2,-x,0],[1/2-x,x,0]}", "m.2m"),
        ("16i", "{[x,x,1/4],[-x,-x,1/4],[x,-x,1/4],[-x,x,1/4],[-x,-x,3/4],[x,x,3/4],[-x,x,3/4],[x,-x,3/4]}", "..2"),
        ("16j", "{[x,0,1/4],[-x,0,1/4],[0,x,1/4],[0,-x,1/4],[-x,0,3/4],[x,0,3/4],[0,-x,3/4],[0,x,3/4]}", ".2."),
        ("16k", "{[x,y,0],[-x,-y,0],[x,-y,1/2],[-x,y,1/2],[y,x,1/2],[-y,-x,1/2],[-y,x,0],[y,-x,0]}", "m.."),
        (
            "16l",
            "{[x,x+1/2,z],[-x,1/2-x,z],[x+1/2,-x,-z],[1/2-x,x,-z],[x,x+1/2,-z],[-x,1/2-x,-z],[1/2-x,x,z],[x+1/2,-x,z]}",
            "..m",
        ),
        (
            "32m",
            "{[x,y,z],[-x,-y,z],[x,-y,1/2-z],[-x,y,1/2-z],[y,x,1/2-z],[-y,-x,1/2-z],[-y,x,z],[y,-x,z],[-x,-y,-z],[x,y,-z],[-x,y,z+1/2],[x,-y,z+1/2],[-y,-x,z+1/2],[y,x,z+1/2],[y,-x,-z],[-y,x,-z]}",
            "1",
        ),
    ],
    "D4h^19": [
        ("4a", "{[0,3/4,1/8],[1/2,3/4,3/8]}", "-4m2"),
        ("4b", "{[0,1/4,3/8],[1/2,1/4,1/8]}", "-4m2"),
        ("8c", "{[0,0,0],[0,1/2,0],[1/4,3/4,1/4],[1/4,1/4,3/4]}", ".2/m."),
        ("8d", "{[0,0,1/2],[1/2,0,0],[3/4,1/4,1/4],[1/4,1/4,1/4]}", ".2/m."),
        ("8e", "{[0,1/4,z],[0,3/4,-z],[1/2,3/4,1/4-z],[1/2,1/4,z+3/4]}", "2mm."),
        ("16f", "{[x,0,0],[-x,1/2,0],[1/4,x+3/4,1/4],[1/4,1/4-x,3/4],[-x,0,0],[x,1/2,0],[1/4,3/4-x,1/4],[1/4,x+1/4,3/4]}", ".2."),
        (
            "16g",
            "{[x+1/2,x+3/4,3/8],[1/2-x,3/4-x,3/8],[x,3/4-x,1/8],[-x,x+3/4,1/8],[-x,3/4-x,1/8],[x,x+3/4,1/8],[1/2-x,x+3/4,3/8],[x+1/2,3/4-x,3/8]}",
            "..2",
        ),
        (
            "16h",
            "{[0,y,z],[0,1/2-y,z],[0,-y,-z],[0,y+1/2,-z],[y+1/4,3/4,1/4-z],[1/4-y,1/4,3/4-z],[1/4-y,3/4,z+1/4],[y+1/4,1/4,z+3/4]}",
            ".m.",
        ),
        (
            "32i",
            "{[x,y,z],[1/2-x,-y,z+1/2],[x,-y,-z],[1/2-x,y,1/2-z],[y+1/4,x+3/4,1/4-z],[1/4-y,1/4-x,3/4-z],[1/4-y,x+3/4,z+1/4],[y+1/4,1/4-x,z+3/4],[-x,-y,-z],[x+1/2,y,1/2-z],[-x,y,z],[x+1/2,-y,z+1/2],[3/4-y,1/4-x,z+3/4],[y+3/4,x+3/4,z+1/4],[y+3/4,1/4-x,3/4-z],[3/4-y,x+3/4,1/4-z]}",
            "1",
        ),
    ],
    "D4h^20": [
        ("8a", "{[0,1/4,3/8],[0,3/4,1/8],[1/2,3/4,3/8],[1/2,1/4,1/8]}", "-4.."),
        ("8b", "{[0,1/4,1/8],[1/2,1/4,7/8],[1/2,1/4,3/8],[0,1/4,5/8]}", "2.22"),
        ("16c", "{[0,0,0],[0,1/2,0],[0,0,1/2],[1/2,0,0],[3/4,1/4,1/4],[1/4,1/4,1/4],[1/4,3/4,1/4],[1/4,1/4,3/4]}", "-1"),
        (
            "16d",
            "{[0,1/4,z],[1/2,1/4,-z],[0,1/4,1/4-z],[1/2,1/4,z+3/4],[0,3/4,-z],[0,1/4,z+1/2],[1/2,1/4,z+1/4],[1/2,3/4,1/4-z]}",
            "2..",
        ),
        (
            "16e",
            "{[x,0,1/4],[-x,1/2,1/4],[1/4,x+3/4,1/2],[1/4,1/4-x,0],[-x,0,3/4],[x+1/2,0,1/4],[3/4,1/4-x,1/2],[1/4,x+1/4,1/2]}",
            ".2.",
        ),
        (
            "16f",
            "{[x,x+1/4,1/8],[-x,1/4-x,1/8],[x+1/2,1/4-x,7/8],[1/2-x,x+1/4,7/8],[1/2-x,1/4-x,3/8],[x+1/2,x+1/4,3/8],[-x,x+1/4,5/8],[x,1/4-x,5/8]}",
            "..2",
        ),
        (
            "32g",
            "{[x,y,z],[1/2-x,-y,z+1/2],[x,-y,1/2-z],[1/2-x,y,-z],[y+1/4,x+3/4,3/4-z],[1/4-y,1/4-x,1/4-z],[1/4-y,x+3/4,z+1/4],[y+1/4,1/4-x,z+3/4],[-x,-y,-z],[x+1/2,y,1/2-z],[-x,y,z+1/2],[x+1/2,-y,z],[3/4-y,1/4-x,z+1/4],[y+3/4,x+3/4,z+3/4],[y+3/4,1/4-x,3/4-z],[3/4-y,x+3/4,1/4-z]}",
            "1",
        ),
    ],
    "C3^1": [
        ("1a", "{[0,0,z]}", "3.."),
        ("1b", "{[1/3,2/3,z]}", "3.."),
        ("1c", "{[2/3,1/3,z]}", "3.."),
        ("3d", "{[x,y,z],[-y,x-y,z],[-x+y,-x,z]}", "1"),
    ],
    "C3^2": [("3a", "{[x,y,z],[-y,x-y,z+1/3],[-x+y,-x,z+2/3]}", "1")],
    "C3^3": [("3a", "{[x,y,z],[-y,x-y,z+2/3],[-x+y,-x,z+1/3]}", "1")],
    "C3^4": [("3a", "{[0,0,z]}", "3."), ("9b", "{[x,y,z],[-y,x-y,z],[-x+y,-x,z]}", "1")],
    "C3i^1": [
        ("1a", "{[0,0,0]}", "-3.."),
        ("1b", "{[0,0,1/2]}", "-3.."),
        ("2c", "{[0,0,z],[0,0,-z]}", "3.."),
        ("2d", "{[1/3,2/3,z],[2/3,1/3,-z]}", "3.."),
        ("3e", "{[1/2,0,0],[0,1/2,0],[1/2,1/2,0]}", "-1"),
        ("3f", "{[1/2,0,1/2],[0,1/2,1/2],[1/2,1/2,1/2]}", "-1"),
        ("6g", "{[x,y,z],[-y,x-y,z],[-x+y,-x,z],[-x,-y,-z],[y,-x+y,-z],[x-y,x,-z]}", "1"),
    ],
    "C3i^2": [
        ("3a", "{[0,0,0]}", "-3."),
        ("3b", "{[0,0,1/2]}", "-3."),
        ("6c", "{[0,0,z],[0,0,-z]}", "3."),
        ("9d", "{[5/6,2/3,1/6],[1/3,1/6,1/6],[5/6,1/6,1/6]}", "-1"),
        ("9e", "{[1/6,1/3,1/3],[2/3,5/6,1/3],[1/6,5/6,1/3]}", "-1"),
        ("18f", "{[x,y,z],[-y,x-y,z],[-x+y,-x,z],[-x,-y,-z],[y,-x+y,-z],[x-y,x,-z]}", "1"),
    ],
    "D3^1": [
        ("1a", "{[0,0,0]}", "3.2"),
        ("1b", "{[0,0,1/2]}", "3.2"),
        ("1c", "{[1/3,2/3,0]}", "3.2"),
        ("1d", "{[1/3,2/3,1/2]}", "3.2"),
        ("1e", "{[2/3,1/3,0]}", "3.2"),
        ("1f", "{[2/3,1/3,1/2]}", "3.2"),
        ("2g", "{[0,0,z],[0,0,-z]}", "3.."),
        ("2h", "{[1/3,2/3,z],[1/3,2/3,-z]}", "3.."),
        ("2i", "{[2/3,1/3,z],[2/3,1/3,-z]}", "3.."),
        ("3j", "{[x,-x,0],[-2*x,-x,0],[x,2*x,0]}", "..2"),
        ("3k", "{[x,-x,1/2],[-2*x,-x,1/2],[x,2*x,1/2]}", "..2"),
        ("6l", "{[x,y,z],[-x+y,y,-z],[x,x-y,-z],[-y,-x,-z],[-y,x-y,z],[-x+y,-x,z]}", "1"),
    ],
    "D3^2": [
        ("1a", "{[0,0,0]}", "32."),
        ("1b", "{[0,0,1/2]}", "32."),
        ("2c", "{[0,0,z],[0,0,-z]}", "3.."),
        ("2d", "{[1/3,2/3,z],[2/3,1/3,-z]}", "3.."),
        ("3e", "{[x,0,0],[-x,-x,0],[0,x,0]}", ".2."),
        ("3f", "{[x,0,1/2],[-x,-x,1/2],[0,x,1/2]}", ".2."),
        ("6g", "{[x,y,z],[x-y,-y,-z],[-x,-x+y,-z],[y,x,-z],[-y,x-y,z],[-x+y,-x,z]}", "1"),
    ],
    "D3^3": [
        ("3a", "{[x,-x,1/3],[-2*x,-x,0],[x,2*x,2/3]}", "..2"),
        ("3b", "{[x,-x,5/6],[-2*x,-x,1/2],[x,2*x,1/6]}", "..2"),
        ("6c", "{[x,y,z],[-x+y,y,1/3-z],[x,x-y,-z],[-y,-x,2/3-z],[-y,x-y,z+1/3],[-x+y,-x,z+2/3]}", "1"),
    ],
    "D3^4": [
        ("3a", "{[x,0,1/3],[-x,-x,0],[0,x,2/3]}", ".2."),
        ("3b", "{[x,0,5/6],[-x,-x,1/2],[0,x,1/6]}", ".2."),
        ("6c", "{[x,y,z],[x-y,-y,2/3-z],[-x,-x+y,1/3-z],[y,x,-z],[-y,x-y,z+1/3],[-x+y,-x,z+2/3]}", "1"),
    ],
    "D3^5": [
        ("3a", "{[x,-x,2/3],[-2*x,-x,0],[x,2*x,1/3]}", "..2"),
        ("3b", "{[x,-x,1/6],[-2*x,-x,1/2],[x,2*x,5/6]}", "..2"),
        ("6c", "{[x,y,z],[-x+y,y,2/3-z],[x,x-y,-z],[-y,-x,1/3-z],[-y,x-y,z+2/3],[-x+y,-x,z+1/3]}", "1"),
    ],
    "D3^6": [
        ("3a", "{[x,0,2/3],[-x,-x,0],[0,x,1/3]}", ".2."),
        ("3b", "{[x,0,1/6],[-x,-x,1/2],[0,x,5/6]}", ".2."),
        ("6c", "{[x,y,z],[x-y,-y,1/3-z],[-x,-x+y,2/3-z],[y,x,-z],[-y,x-y,z+2/3],[-x+y,-x,z+1/3]}", "1"),
    ],
    "D3^7": [
        ("3a", "{[0,0,0]}", "32"),
        ("3b", "{[0,0,1/2]}", "32"),
        ("6c", "{[0,0,z],[0,0,-z]}", "3."),
        ("9d", "{[x,0,0],[-x,-x,0],[0,x,0]}", ".2"),
        ("9e", "{[x,0,1/2],[-x,-x,1/2],[0,x,1/2]}", ".2"),
        ("18f", "{[x,y,z],[x-y,-y,-z],[-x,-x+y,-z],[y,x,-z],[-y,x-y,z],[-x+y,-x,z]}", "1"),
    ],
    "C3v^1": [
        ("1a", "{[0,0,z]}", "3m."),
        ("1b", "{[1/3,2/3,z]}", "3m."),
        ("1c", "{[2/3,1/3,z]}", "3m."),
        ("3d", "{[x,-x,z],[x,2*x,z],[-2*x,-x,z]}", ".m."),
        ("6e", "{[x,y,z],[-y,x-y,z],[-x+y,-x,z],[-x+y,y,z],[x,x-y,z],[-y,-x,z]}", "1"),
    ],
    "C3v^2": [
        ("1a", "{[0,0,z]}", "3.m"),
        ("2b", "{[1/3,2/3,z],[2/3,1/3,z]}", "3.."),
        ("3c", "{[x,0,z],[0,x,z],[-x,-x,z]}", "..m"),
        ("6d", "{[x,y,z],[-y,x-y,z],[-x+y,-x,z],[x-y,-y,z],[-x,-x+y,z],[y,x,z]}", "1"),
    ],
    "C3v^3": [
        ("2a", "{[0,0,z],[0,0,z+1/2]}", "3.."),
        ("2b", "{[1/3,2/3,z],[1/3,2/3,z+1/2]}", "3.."),
        ("2c", "{[2/3,1/3,z],[2/3,1/3,z+1/2]}", "3.."),
        ("6d", "{[x,y,z],[-y,x-y,z],[-x+y,-x,z],[-x+y,y,z+1/2],[x,x-y,z+1/2],[-y,-x,z+1/2]}", "1"),
    ],
    "C3v^4": [
        ("2a", "{[0,0,z],[0,0,z+1/2]}", "3.."),
        ("2b", "{[1/3,2/3,z],[2/3,1/3,z+1/2]}", "3.."),
        ("6c", "{[x,y,z],[-y,x-y,z],[-x+y,-x,z],[x-y,-y,z+1/2],[-x,-x+y,z+1/2],[y,x,z+1/2]}", "1"),
    ],
    "C3v^5": [
        ("3a", "{[0,0,z]}", "3m"),
        ("9b", "{[x,-x,z],[x,2*x,z],[-2*x,-x,z]}", ".m"),
        ("18c", "{[x,y,z],[-y,x-y,z],[-x+y,-x,z],[-x+y,y,z],[x,x-y,z],[-y,-x,z]}", "1"),
    ],
    "C3v^6": [
        ("6a", "{[0,0,z],[0,0,z+1/2]}", "3."),
        ("18b", "{[x,y,z],[-y,x-y,z],[-x+y,-x,z],[-x+y,y,z+1/2],[x,x-y,z+1/2],[-y,-x,z+1/2]}", "1"),
    ],
    "D3d^1": [
        ("1a", "{[0,0,0]}", "-3.m"),
        ("1b", "{[0,0,1/2]}", "-3.m"),
        ("2c", "{[1/3,2/3,0],[2/3,1/3,0]}", "3.2"),
        ("2d", "{[1/3,2/3,1/2],[2/3,1/3,1/2]}", "3.2"),
        ("2e", "{[0,0,z],[0,0,-z]}", "3.m"),
        ("3f", "{[1/2,0,0],[1/2,1/2,0],[0,1/2,0]}", "..2/m"),
        ("3g", "{[1/2,0,1/2],[1/2,1/2,1/2],[0,1/2,1/2]}", "..2/m"),
        ("4h", "{[1/3,2/3,z],[1/3,2/3,-z],[2/3,1/3,-z],[2/3,1/3,z]}", "3.."),
        ("6i", "{[x,-x,0],[-2*x,-x,0],[x,2*x,0],[-x,x,0],[2*x,x,0],[-x,-2*x,0]}", "..2"),
        ("6j", "{[x,-x,1/2],[-2*x,-x,1/2],[x,2*x,1/2],[-x,x,1/2],[2*x,x,1/2],[-x,-2*x,1/2]}", "..2"),
        ("6k", "{[x,0,z],[-x,0,-z],[x,x,-z],[0,-x,-z],[0,x,z],[-x,-x,z]}", "..m"),
        (
            "12l",
            "{[x,y,z],[-x+y,y,-z],[x,x-y,-z],[-y,-x,-z],[-y,x-y,z],[-x+y,-x,z],[-x,-y,-z],[x-y,-y,z],[-x,-x+y,z],[y,x,z],[y,-x+y,-z],[x-y,x,-z]}",
            "1",
        ),
    ],
    "D3d^2": [
        ("2a", "{[0,0,1/4],[0,0,3/4]}", "3.2"),
        ("2b", "{[0,0,0],[0,0,1/2]}", "-3.."),
        ("2c", "{[1/3,2/3,1/4],[2/3,1/3,3/4]}", "3.2"),
        ("2d", "{[2/3,1/3,1/4],[1/3,2/3,3/4]}", "3.2"),
        ("4e", "{[0,0,z],[0,0,1/2-z],[0,0,-z],[0,0,z+1/2]}", "3.."),
        ("4f", "{[1/3,2/3,z],[1/3,2/3,1/2-z],[2/3,1/3,-z],[2/3,1/3,z+1/2]}", "3.."),
        ("6g", "{[1/2,0,0],[1/2,0,1/2],[1/2,1/2,1/2],[0,1/2,1/2],[0,1/2,0],[1/2,1/2,0]}", "-1"),
        ("6h", "{[x,-x,1/4],[-2*x,-x,1/4],[x,2*x,1/4],[-x,x,3/4],[2*x,x,3/4],[-x,-2*x,3/4]}", "..2"),
        (
            "12i",
            "{[x,y,z],[-x+y,y,1/2-z],[x,x-y,1/2-z],[-y,-x,1/2-z],[-y,x-y,z],[-x+y,-x,z],[-x,-y,-z],[x-y,-y,z+1/2],[-x,-x+y,z+1/2],[y,x,z+1/2],[y,-x+y,-z],[x-y,x,-z]}",
            "1",
        ),
    ],
    "D3d^3": [
        ("1a", "{[0,0,0]}", "-3m."),
        ("1b", "{[0,0,1/2]}", "-3m."),
        ("2c", "{[0,0,z],[0,0,-z]}", "3m."),
        ("2d", "{[1/3,2/3,z],[2/3,1/3,-z]}", "3m."),
        ("3e", "{[1/2,0,0],[1/2,1/2,0],[0,1/2,0]}", ".2/m."),
        ("3f", "{[1/2,0,1/2],[1/2,1/2,1/2],[0,1/2,1/2]}", ".2/m."),
        ("6g", "{[x,0,0],[-x,-x,0],[0,x,0],[-x,0,0],[x,x,0],[0,-x,0]}", ".2."),
        ("6h", "{[x,0,1/2],[-x,-x,1/2],[0,x,1/2],[-x,0,1/2],[x,x,1/2],[0,-x,1/2]}", ".2."),
        ("6i", "{[x,-x,z],[2*x,x,-z],[-x,-2*x,-z],[-x,x,-z],[x,2*x,z],[-2*x,-x,z]}", ".m."),
        (
            "12j",
            "{[x,y,z],[x-y,-y,-z],[-x,-x+y,-z],[y,x,-z],[-y,x-y,z],[-x+y,-x,z],[-x,-y,-z],[-x+y,y,z],[x,x-y,z],[-y,-x,z],[y,-x+y,-z],[x-y,x,-z]}",
            "1",
        ),
    ],
    "D3d^4": [
        ("2a", "{[0,0,1/4],[0,0,3/4]}", "32."),
        ("2b", "{[0,0,0],[0,0,1/2]}", "-3.."),
        ("4c", "{[0,0,z],[0,0,1/2-z],[0,0,-z],[0,0,z+1/2]}", "3.."),
        ("4d", "{[1/3,2/3,z],[2/3,1/3,1/2-z],[2/3,1/3,-z],[1/3,2/3,z+1/2]}", "3.."),
        ("6e", "{[1/2,0,0],[1/2,0,1/2],[1/2,1/2,1/2],[0,1/2,1/2],[0,1/2,0],[1/2,1/2,0]}", "-1"),
        ("6f", "{[x,0,1/4],[-x,-x,1/4],[0,x,1/4],[-x,0,3/4],[x,x,3/4],[0,-x,3/4]}", ".2."),
        (
            "12g",
            "{[x,y,z],[x-y,-y,1/2-z],[-x,-x+y,1/2-z],[y,x,1/2-z],[-y,x-y,z],[-x+y,-x,z],[-x,-y,-z],[-x+y,y,z+1/2],[x,x-y,z+1/2],[-y,-x,z+1/2],[y,-x+y,-z],[x-y,x,-z]}",
            "1",
        ),
    ],
    "D3d^5": [
        ("3a", "{[0,0,0]}", "-3m"),
        ("3b", "{[0,0,1/2]}", "-3m"),
        ("6c", "{[0,0,z],[0,0,-z]}", "3m"),
        ("9d", "{[5/6,2/3,1/6],[5/6,1/6,1/6],[1/3,1/6,1/6]}", ".2/m"),
        ("9e", "{[1/6,1/3,1/3],[1/6,5/6,1/3],[2/3,5/6,1/3]}", ".2/m"),
        ("18f", "{[x,0,0],[-x,-x,0],[0,x,0],[-x,0,0],[x,x,0],[0,-x,0]}", ".2"),
        ("18g", "{[x,0,1/2],[-x,-x,1/2],[0,x,1/2],[-x,0,1/2],[x,x,1/2],[0,-x,1/2]}", ".2"),
        ("18h", "{[x,-x,z],[2*x,x,-z],[-x,-2*x,-z],[-x,x,-z],[x,2*x,z],[-2*x,-x,z]}", ".m"),
        (
            "36i",
            "{[x,y,z],[x-y,-y,-z],[-x,-x+y,-z],[y,x,-z],[-y,x-y,z],[-x+y,-x,z],[-x,-y,-z],[-x+y,y,z],[x,x-y,z],[-y,-x,z],[y,-x+y,-z],[x-y,x,-z]}",
            "1",
        ),
    ],
    "D3d^6": [
        ("6a", "{[0,0,1/4],[0,0,3/4]}", "32"),
        ("6b", "{[0,0,0],[0,0,1/2]}", "-3."),
        ("12c", "{[0,0,z],[0,0,1/2-z],[0,0,-z],[0,0,z+1/2]}", "3."),
        ("18d", "{[1/6,1/3,1/3],[5/6,2/3,1/6],[5/6,1/6,1/6],[1/3,1/6,1/6],[2/3,5/6,1/3],[1/6,5/6,1/3]}", "-1"),
        ("18e", "{[x,0,1/4],[-x,-x,1/4],[0,x,1/4],[-x,0,3/4],[x,x,3/4],[0,-x,3/4]}", ".2"),
        (
            "36f",
            "{[x,y,z],[x-y,-y,1/2-z],[-x,-x+y,1/2-z],[y,x,1/2-z],[-y,x-y,z],[-x+y,-x,z],[-x,-y,-z],[-x+y,y,z+1/2],[x,x-y,z+1/2],[-y,-x,z+1/2],[y,-x+y,-z],[x-y,x,-z]}",
            "1",
        ),
    ],
    "C6^1": [
        ("1a", "{[0,0,z]}", "6.."),
        ("2b", "{[1/3,2/3,z],[2/3,1/3,z]}", "3.."),
        ("3c", "{[1/2,0,z],[0,1/2,z],[1/2,1/2,z]}", "2.."),
        ("6d", "{[x,y,z],[-x,-y,z],[-y,x-y,z],[-x+y,-x,z],[x-y,x,z],[y,-x+y,z]}", "1"),
    ],
    "C6^2": [("6a", "{[x,y,z],[-x,-y,z+1/2],[-y,x-y,z+1/3],[-x+y,-x,z+2/3],[x-y,x,z+1/6],[y,-x+y,z+5/6]}", "1")],
    "C6^3": [("6a", "{[x,y,z],[-x,-y,z+1/2],[-y,x-y,z+2/3],[-x+y,-x,z+1/3],[x-y,x,z+5/6],[y,-x+y,z+1/6]}", "1")],
    "C6^4": [
        ("3a", "{[0,0,z],[0,0,z+2/3],[0,0,z+1/3]}", "2.."),
        ("3b", "{[1/2,1/2,z],[1/2,0,z+2/3],[0,1/2,z+1/3]}", "2.."),
        ("6c", "{[x,y,z],[-x,-y,z],[-y,x-y,z+2/3],[-x+y,-x,z+1/3],[x-y,x,z+1/3],[y,-x+y,z+2/3]}", "1"),
    ],
    "C6^5": [
        ("3a", "{[0,0,z],[0,0,z+1/3],[0,0,z+2/3]}", "2.."),
        ("3b", "{[1/2,1/2,z],[1/2,0,z+1/3],[0,1/2,z+2/3]}", "2.."),
        ("6c", "{[x,y,z],[-x,-y,z],[-y,x-y,z+1/3],[-x+y,-x,z+2/3],[x-y,x,z+2/3],[y,-x+y,z+1/3]}", "1"),
    ],
    "C6^6": [
        ("2a", "{[0,0,z],[0,0,z+1/2]}", "3.."),
        ("2b", "{[1/3,2/3,z],[2/3,1/3,z+1/2]}", "3.."),
        ("6c", "{[x,y,z],[-x,-y,z+1/2],[-y,x-y,z],[-x+y,-x,z],[x-y,x,z+1/2],[y,-x+y,z+1/2]}", "1"),
    ],
    "C3h^1": [
        ("1a", "{[0,0,0]}", "-6.."),
        ("1b", "{[0,0,1/2]}", "-6.."),
        ("1c", "{[1/3,2/3,0]}", "-6.."),
        ("1d", "{[1/3,2/3,1/2]}", "-6.."),
        ("1e", "{[2/3,1/3,0]}", "-6.."),
        ("1f", "{[2/3,1/3,1/2]}", "-6.."),
        ("2g", "{[0,0,z],[0,0,-z]}", "3.."),
        ("2h", "{[1/3,2/3,z],[1/3,2/3,-z]}", "3.."),
        ("2i", "{[2/3,1/3,z],[2/3,1/3,-z]}", "3.."),
        ("3j", "{[x,y,0],[-y,x-y,0],[-x+y,-x,0]}", "m.."),
        ("3k", "{[x,y,1/2],[-y,x-y,1/2],[-x+y,-x,1/2]}", "m.."),
        ("6l", "{[x,y,z],[-y,x-y,z],[-x+y,-x,z],[x,y,-z],[-x+y,-x,-z],[-y,x-y,-z]}", "1"),
    ],
    "C6h^1": [
        ("1a", "{[0,0,0]}", "6/m.."),
        ("1b", "{[0,0,1/2]}", "6/m.."),
        ("2c", "{[1/3,2/3,0],[2/3,1/3,0]}", "-6.."),
        ("2d", "{[1/3,2/3,1/2],[2/3,1/3,1/2]}", "-6.."),
        ("2e", "{[0,0,z],[0,0,-z]}", "6.."),
        ("3f", "{[1/2,0,0],[0,1/2,0],[1/2,1/2,0]}", "2/m.."),
        ("3g", "{[1/2,0,1/2],[0,1/2,1/2],[1/2,1/2,1/2]}", "2/m.."),
        ("4h", "{[1/3,2/3,z],[2/3,1/3,z],[2/3,1/3,-z],[1/3,2/3,-z]}", "3.."),
        ("6i", "{[1/2,0,z],[0,1/2,z],[1/2,1/2,z],[1/2,0,-z],[0,1/2,-z],[1/2,1/2,-z]}", "2.."),
        ("6j", "{[x,y,0],[-x,-y,0],[-y,x-y,0],[-x+y,-x,0],[x-y,x,0],[y,-x+y,0]}", "m.."),
        ("6k", "{[x,y,1/2],[-x,-y,1/2],[-y,x-y,1/2],[-x+y,-x,1/2],[x-y,x,1/2],[y,-x+y,1/2]}", "m.."),
        (
            "12l",
            "{[x,y,z],[-x,-y,z],[-y,x-y,z],[-x+y,-x,z],[x-y,x,z],[y,-x+y,z],[-x,-y,-z],[x,y,-z],[y,-x+y,-z],[x-y,x,-z],[-x+y,-x,-z],[-y,x-y,-z]}",
            "1",
        ),
    ],
    "C6h^2": [
        ("2a", "{[0,0,1/4],[0,0,3/4]}", "-6.."),
        ("2b", "{[0,0,0],[0,0,1/2]}", "-3.."),
        ("2c", "{[1/3,2/3,1/4],[2/3,1/3,3/4]}", "-6.."),
        ("2d", "{[2/3,1/3,1/4],[1/3,2/3,3/4]}", "-6.."),
        ("4e", "{[0,0,z],[0,0,z+1/2],[0,0,-z],[0,0,1/2-z]}", "3.."),
        ("4f", "{[1/3,2/3,z],[2/3,1/3,z+1/2],[2/3,1/3,-z],[1/3,2/3,1/2-z]}", "3.."),
        ("6g", "{[1/2,0,0],[1/2,0,1/2],[0,1/2,0],[1/2,1/2,0],[1/2,1/2,1/2],[0,1/2,1/2]}", "-1"),
        ("6h", "{[x,y,1/4],[-x,-y,3/4],[-y,x-y,1/4],[-x+y,-x,1/4],[x-y,x,3/4],[y,-x+y,3/4]}", "m.."),
        (
            "12i",
            "{[x,y,z],[-x,-y,z+1/2],[-y,x-y,z],[-x+y,-x,z],[x-y,x,z+1/2],[y,-x+y,z+1/2],[-x,-y,-z],[x,y,1/2-z],[y,-x+y,-z],[x-y,x,-z],[-x+y,-x,1/2-z],[-y,x-y,1/2-z]}",
            "1",
        ),
    ],
    "D6^1": [
        ("1a", "{[0,0,0]}", "622"),
        ("1b", "{[0,0,1/2]}", "622"),
        ("2c", "{[1/3,2/3,0],[2/3,1/3,0]}", "3.2"),
        ("2d", "{[1/3,2/3,1/2],[2/3,1/3,1/2]}", "3.2"),
        ("2e", "{[0,0,z],[0,0,-z]}", "6.."),
        ("3f", "{[1/2,0,0],[1/2,1/2,0],[0,1/2,0]}", "222"),
        ("3g", "{[1/2,0,1/2],[1/2,1/2,1/2],[0,1/2,1/2]}", "222"),
        ("4h", "{[1/3,2/3,z],[2/3,1/3,z],[2/3,1/3,-z],[1/3,2/3,-z]}", "3.."),
        ("6i", "{[1/2,0,z],[1/2,0,-z],[1/2,1/2,-z],[0,1/2,-z],[0,1/2,z],[1/2,1/2,z]}", "2.."),
        ("6j", "{[x,0,0],[-x,0,0],[-x,-x,0],[0,x,0],[x,x,0],[0,-x,0]}", ".2."),
        ("6k", "{[x,0,1/2],[-x,0,1/2],[-x,-x,1/2],[0,x,1/2],[x,x,1/2],[0,-x,1/2]}", ".2."),
        ("6l", "{[x,-x,0],[-x,x,0],[2*x,x,0],[-x,-2*x,0],[-2*x,-x,0],[x,2*x,0]}", "..2"),
        ("6m", "{[x,-x,1/2],[-x,x,1/2],[2*x,x,1/2],[-x,-2*x,1/2],[-2*x,-x,1/2],[x,2*x,1/2]}", "..2"),
        (
            "12n",
            "{[x,y,z],[-x,-y,z],[x-y,-y,-z],[-x,-x+y,-z],[y,x,-z],[-x+y,y,-z],[x,x-y,-z],[-y,-x,-z],[-y,x-y,z],[-x+y,-x,z],[x-y,x,z],[y,-x+y,z]}",
            "1",
        ),
    ],
    "D6^2": [
        ("6a", "{[x,0,0],[-x,0,1/2],[-x,-x,2/3],[0,x,1/3],[x,x,1/6],[0,-x,5/6]}", ".2."),
        ("6b", "{[x,2*x,1/4],[-x,-2*x,3/4],[-x,x,5/12],[2*x,x,1/12],[x,-x,11/12],[-2*x,-x,7/12]}", "..2"),
        (
            "12c",
            "{[x,y,z],[-x,-y,z+1/2],[x-y,-y,-z],[-x,-x+y,2/3-z],[y,x,1/3-z],[-x+y,y,1/2-z],[x,x-y,1/6-z],[-y,-x,5/6-z],[-y,x-y,z+1/3],[-x+y,-x,z+2/3],[x-y,x,z+1/6],[y,-x+y,z+5/6]}",
            "1",
        ),
    ],
    "D6^3": [
        ("6a", "{[x,0,0],[-x,0,1/2],[-x,-x,1/3],[0,x,2/3],[x,x,5/6],[0,-x,1/6]}", ".2."),
        ("6b", "{[x,2*x,3/4],[-x,-2*x,1/4],[-x,x,7/12],[2*x,x,11/12],[x,-x,1/12],[-2*x,-x,5/12]}", "..2"),
        (
            "12c",
            "{[x,y,z],[-x,-y,z+1/2],[x-y,-y,-z],[-x,-x+y,1/3-z],[y,x,2/3-z],[-x+y,y,1/2-z],[x,x-y,5/6-z],[-y,-x,1/6-z],[-y,x-y,z+2/3],[-x+y,-x,z+1/3],[x-y,x,z+5/6],[y,-x+y,z+1/6]}",
            "1",
        ),
    ],
    "D6^4": [
        ("3a", "{[0,0,0],[0,0,1/3],[0,0,2/3]}", "222"),
        ("3b", "{[0,0,1/2],[0,0,5/6],[0,0,1/6]}", "222"),
        ("3c", "{[1/2,0,0],[1/2,1/2,1/3],[0,1/2,2/3]}", "222"),
        ("3d", "{[1/2,0,1/2],[1/2,1/2,5/6],[0,1/2,1/6]}", "222"),
        ("6e", "{[0,0,z],[0,0,-z],[0,0,1/3-z],[0,0,2/3-z],[0,0,z+2/3],[0,0,z+1/3]}", "2.."),
        ("6f", "{[1/2,0,z],[1/2,0,-z],[1/2,1/2,1/3-z],[0,1/2,2/3-z],[0,1/2,z+2/3],[1/2,1/2,z+1/3]}", "2.."),
        ("6g", "{[x,0,0],[-x,0,0],[-x,-x,1/3],[0,x,2/3],[x,x,1/3],[0,-x,2/3]}", ".2."),
        ("6h", "{[x,0,1/2],[-x,0,1/2],[-x,-x,5/6],[0,x,1/6],[x,x,5/6],[0,-x,1/6]}", ".2."),
        ("6i", "{[x,2*x,0],[-x,-2*x,0],[-x,x,1/3],[2*x,x,2/3],[x,-x,1/3],[-2*x,-x,2/3]}", "..2"),
        ("6j", "{[x,2*x,1/2],[-x,-2*x,1/2],[-x,x,5/6],[2*x,x,1/6],[x,-x,5/6],[-2*x,-x,1/6]}", "..2"),
        (
            "12k",
            "{[x,y,z],[-x,-y,z],[x-y,-y,-z],[-x,-x+y,1/3-z],[y,x,2/3-z],[-x+y,y,-z],[x,x-y,1/3-z],[-y,-x,2/3-z],[-y,x-y,z+2/3],[-x+y,-x,z+1/3],[x-y,x,z+1/3],[y,-x+y,z+2/3]}",
            "1",
        ),
    ],
    "D6^5": [
        ("3a", "{[0,0,0],[0,0,2/3],[0,0,1/3]}", "222"),
        ("3b", "{[0,0,1/2],[0,0,1/6],[0,0,5/6]}", "222"),
        ("3c", "{[1/2,0,0],[1/2,1/2,2/3],[0,1/2,1/3]}", "222"),
        ("3d", "{[1/2,0,1/2],[1/2,1/2,1/6],[0,1/2,5/6]}", "222"),
        ("6e", "{[0,0,z],[0,0,-z],[0,0,2/3-z],[0,0,1/3-z],[0,0,z+1/3],[0,0,z+2/3]}", "2.."),
        ("6f", "{[1/2,0,z],[1/2,0,-z],[1/2,1/2,2/3-z],[0,1/2,1/3-z],[0,1/2,z+1/3],[1/2,1/2,z+2/3]}", "2.."),
        ("6g", "{[x,0,0],[-x,0,0],[-x,-x,2/3],[0,x,1/3],[x,x,2/3],[0,-x,1/3]}", ".2."),
        ("6h", "{[x,0,1/2],[-x,0,1/2],[-x,-x,1/6],[0,x,5/6],[x,x,1/6],[0,-x,5/6]}", ".2."),
        ("6i", "{[x,2*x,0],[-x,-2*x,0],[-x,x,2/3],[2*x,x,1/3],[x,-x,2/3],[-2*x,-x,1/3]}", "..2"),
        ("6j", "{[x,2*x,1/2],[-x,-2*x,1/2],[-x,x,1/6],[2*x,x,5/6],[x,-x,1/6],[-2*x,-x,5/6]}", "..2"),
        (
            "12k",
            "{[x,y,z],[-x,-y,z],[x-y,-y,-z],[-x,-x+y,2/3-z],[y,x,1/3-z],[-x+y,y,-z],[x,x-y,2/3-z],[-y,-x,1/3-z],[-y,x-y,z+1/3],[-x+y,-x,z+2/3],[x-y,x,z+2/3],[y,-x+y,z+1/3]}",
            "1",
        ),
    ],
    "D6^6": [
        ("2a", "{[0,0,0],[0,0,1/2]}", "32."),
        ("2b", "{[0,0,1/4],[0,0,3/4]}", "3.2"),
        ("2c", "{[1/3,2/3,1/4],[2/3,1/3,3/4]}", "3.2"),
        ("2d", "{[1/3,2/3,3/4],[2/3,1/3,1/4]}", "3.2"),
        ("4e", "{[0,0,z],[0,0,z+1/2],[0,0,-z],[0,0,1/2-z]}", "3.."),
        ("4f", "{[1/3,2/3,z],[2/3,1/3,z+1/2],[2/3,1/3,-z],[1/3,2/3,1/2-z]}", "3.."),
        ("6g", "{[x,0,0],[-x,0,1/2],[-x,-x,0],[0,x,0],[x,x,1/2],[0,-x,1/2]}", ".2."),
        ("6h", "{[x,2*x,1/4],[-x,-2*x,3/4],[-x,x,3/4],[2*x,x,3/4],[x,-x,1/4],[-2*x,-x,1/4]}", "..2"),
        (
            "12i",
            "{[x,y,z],[-x,-y,z+1/2],[x-y,-y,-z],[-x,-x+y,-z],[y,x,-z],[-x+y,y,1/2-z],[x,x-y,1/2-z],[-y,-x,1/2-z],[-y,x-y,z],[-x+y,-x,z],[x-y,x,z+1/2],[y,-x+y,z+1/2]}",
            "1",
        ),
    ],
    "C6v^1": [
        ("1a", "{[0,0,z]}", "6mm"),
        ("2b", "{[1/3,2/3,z],[2/3,1/3,z]}", "3m."),
        ("3c", "{[1/2,0,z],[0,1/2,z],[1/2,1/2,z]}", "2mm"),
        ("6d", "{[x,0,z],[-x,0,z],[0,x,z],[-x,-x,z],[x,x,z],[0,-x,z]}", "..m"),
        ("6e", "{[x,-x,z],[-x,x,z],[x,2*x,z],[-2*x,-x,z],[2*x,x,z],[-x,-2*x,z]}", ".m."),
        (
            "12f",
            "{[x,y,z],[-x,-y,z],[-y,x-y,z],[-x+y,-x,z],[x-y,x,z],[y,-x+y,z],[-x+y,y,z],[x,x-y,z],[-y,-x,z],[x-y,-y,z],[-x,-x+y,z],[y,x,z]}",
            "1",
        ),
    ],
    "C6v^2": [
        ("2a", "{[0,0,z],[0,0,z+1/2]}", "6.."),
        ("4b", "{[1/3,2/3,z],[2/3,1/3,z],[1/3,2/3,z+1/2],[2/3,1/3,z+1/2]}", "3.."),
        ("6c", "{[1/2,0,z],[0,1/2,z],[1/2,1/2,z],[1/2,0,z+1/2],[1/2,1/2,z+1/2],[0,1/2,z+1/2]}", "2.."),
        (
            "12d",
            "{[x,y,z],[-x,-y,z],[-y,x-y,z],[-x+y,-x,z],[x-y,x,z],[y,-x+y,z],[-x+y,y,z+1/2],[x,x-y,z+1/2],[-y,-x,z+1/2],[x-y,-y,z+1/2],[-x,-x+y,z+1/2],[y,x,z+1/2]}",
            "1",
        ),
    ],
    "C6v^3": [
        ("2a", "{[0,0,z],[0,0,z+1/2]}", "3.m"),
        ("4b", "{[1/3,2/3,z],[2/3,1/3,z+1/2],[1/3,2/3,z+1/2],[2/3,1/3,z]}", "3.."),
        ("6c", "{[x,0,z],[-x,0,z+1/2],[0,x,z],[-x,-x,z],[x,x,z+1/2],[0,-x,z+1/2]}", "..m"),
        (
            "12d",
            "{[x,y,z],[-x,-y,z+1/2],[-y,x-y,z],[-x+y,-x,z],[x-y,x,z+1/2],[y,-x+y,z+1/2],[-x+y,y,z+1/2],[x,x-y,z+1/2],[-y,-x,z+1/2],[x-y,-y,z],[-x,-x+y,z],[y,x,z]}",
            "1",
        ),
    ],
    "C6v^4": [
        ("2a", "{[0,0,z],[0,0,z+1/2]}", "3m."),
        ("2b", "{[1/3,2/3,z],[2/3,1/3,z+1/2]}", "3m."),
        ("6c", "{[x,-x,z],[-x,x,z+1/2],[x,2*x,z],[-2*x,-x,z],[2*x,x,z+1/2],[-x,-2*x,z+1/2]}", ".m."),
        (
            "12d",
            "{[x,y,z],[-x,-y,z+1/2],[-y,x-y,z],[-x+y,-x,z],[x-y,x,z+1/2],[y,-x+y,z+1/2],[-x+y,y,z],[x,x-y,z],[-y,-x,z],[x-y,-y,z+1/2],[-x,-x+y,z+1/2],[y,x,z+1/2]}",
            "1",
        ),
    ],
    "D3h^1": [
        ("1a", "{[0,0,0]}", "-6m2"),
        ("1b", "{[0,0,1/2]}", "-6m2"),
        ("1c", "{[1/3,2/3,0]}", "-6m2"),
        ("1d", "{[1/3,2/3,1/2]}", "-6m2"),
        ("1e", "{[2/3,1/3,0]}", "-6m2"),
        ("1f", "{[2/3,1/3,1/2]}", "-6m2"),
        ("2g", "{[0,0,z],[0,0,-z]}", "3m."),
        ("2h", "{[1/3,2/3,z],[1/3,2/3,-z]}", "3m."),
        ("2i", "{[2/3,1/3,z],[2/3,1/3,-z]}", "3m."),
        ("3j", "{[x,-x,0],[-2*x,-x,0],[x,2*x,0]}", "mm2"),
        ("3k", "{[x,-x,1/2],[-2*x,-x,1/2],[x,2*x,1/2]}", "mm2"),
        ("6l", "{[x,y,0],[-x+y,y,0],[x,x-y,0],[-y,-x,0],[-y,x-y,0],[-x+y,-x,0]}", "m.."),
        ("6m", "{[x,y,1/2],[-x+y,y,1/2],[x,x-y,1/2],[-y,-x,1/2],[-y,x-y,1/2],[-x+y,-x,1/2]}", "m.."),
        ("6n", "{[x,-x,z],[-2*x,-x,-z],[x,2*x,-z],[x,-x,-z],[x,2*x,z],[-2*x,-x,z]}", ".m."),
        (
            "12o",
            "{[x,y,z],[-x+y,y,-z],[x,x-y,-z],[-y,-x,-z],[-y,x-y,z],[-x+y,-x,z],[-x+y,y,z],[x,x-y,z],[-y,-x,z],[x,y,-z],[-x+y,-x,-z],[-y,x-y,-z]}",
            "1",
        ),
    ],
    "D3h^2": [
        ("2a", "{[0,0,0],[0,0,1/2]}", "3.2"),
        ("2b", "{[0,0,1/4],[0,0,3/4]}", "-6.."),
        ("2c", "{[1/3,2/3,0],[1/3,2/3,1/2]}", "3.2"),
        ("2d", "{[1/3,2/3,1/4],[1/3,2/3,3/4]}", "-6.."),
        ("2e", "{[2/3,1/3,0],[2/3,1/3,1/2]}", "3.2"),
        ("2f", "{[2/3,1/3,1/4],[2/3,1/3,3/4]}", "-6.."),
        ("4g", "{[0,0,z],[0,0,-z],[0,0,z+1/2],[0,0,1/2-z]}", "3.."),
        ("4h", "{[1/3,2/3,z],[1/3,2/3,-z],[1/3,2/3,z+1/2],[1/3,2/3,1/2-z]}", "3.."),
        ("4i", "{[2/3,1/3,z],[2/3,1/3,-z],[2/3,1/3,z+1/2],[2/3,1/3,1/2-z]}", "3.."),
        ("6j", "{[x,-x,0],[-2*x,-x,0],[x,2*x,0],[-2*x,-x,1/2],[x,2*x,1/2],[x,-x,1/2]}", "..2"),
        ("6k", "{[x,y,1/4],[-x+y,y,3/4],[x,x-y,3/4],[-y,-x,3/4],[-y,x-y,1/4],[-x+y,-x,1/4]}", "m.."),
        (
            "12l",
            "{[x,y,z],[-x+y,y,-z],[x,x-y,-z],[-y,-x,-z],[-y,x-y,z],[-x+y,-x,z],[-x+y,y,z+1/2],[x,x-y,z+1/2],[-y,-x,z+1/2],[x,y,1/2-z],[-x+y,-x,1/2-z],[-y,x-y,1/2-z]}",
            "1",
        ),
    ],
    "D3h^3": [
        ("1a", "{[0,0,0]}", "-62m"),
        ("1b", "{[0,0,1/2]}", "-62m"),
        ("2c", "{[1/3,2/3,0],[2/3,1/3,0]}", "-6.."),
        ("2d", "{[1/3,2/3,1/2],[2/3,1/3,1/2]}", "-6.."),
        ("2e", "{[0,0,z],[0,0,-z]}", "3.m"),
        ("3f", "{[x,0,0],[-x,-x,0],[0,x,0]}", "m2m"),
        ("3g", "{[x,0,1/2],[-x,-x,1/2],[0,x,1/2]}", "m2m"),
        ("4h", "{[1/3,2/3,z],[2/3,1/3,-z],[1/3,2/3,-z],[2/3,1/3,z]}", "3.."),
        ("6i", "{[x,0,z],[x,0,-z],[-x,-x,-z],[0,x,-z],[0,x,z],[-x,-x,z]}", "..m"),
        ("6j", "{[x,y,0],[x-y,-y,0],[-x,-x+y,0],[y,x,0],[-y,x-y,0],[-x+y,-x,0]}", "m.."),
        ("6k", "{[x,y,1/2],[x-y,-y,1/2],[-x,-x+y,1/2],[y,x,1/2],[-y,x-y,1/2],[-x+y,-x,1/2]}", "m.."),
        (
            "12l",
            "{[x,y,z],[x-y,-y,-z],[-x,-x+y,-z],[y,x,-z],[-y,x-y,z],[-x+y,-x,z],[x,y,-z],[x-y,-y,z],[-x,-x+y,z],[y,x,z],[-x+y,-x,-z],[-y,x-y,-z]}",
            "1",
        ),
    ],
    "D3h^4": [
        ("2a", "{[0,0,0],[0,0,1/2]}", "32."),
        ("2b", "{[0,0,1/4],[0,0,3/4]}", "-6.."),
        ("2c", "{[1/3,2/3,1/4],[2/3,1/3,3/4]}", "-6.."),
        ("2d", "{[2/3,1/3,1/4],[1/3,2/3,3/4]}", "-6.."),
        ("4e", "{[0,0,z],[0,0,-z],[0,0,1/2-z],[0,0,z+1/2]}", "3.."),
        ("4f", "{[1/3,2/3,z],[2/3,1/3,-z],[1/3,2/3,1/2-z],[2/3,1/3,z+1/2]}", "3.."),
        ("6g", "{[x,0,0],[-x,-x,0],[0,x,0],[x,0,1/2],[-x,-x,1/2],[0,x,1/2]}", ".2."),
        ("6h", "{[x,y,1/4],[x-y,-y,3/4],[-x,-x+y,3/4],[y,x,3/4],[-y,x-y,1/4],[-x+y,-x,1/4]}", "m.."),
        (
            "12i",
            "{[x,y,z],[x-y,-y,-z],[-x,-x+y,-z],[y,x,-z],[-y,x-y,z],[-x+y,-x,z],[x,y,1/2-z],[x-y,-y,z+1/2],[-x,-x+y,z+1/2],[y,x,z+1/2],[-x+y,-x,1/2-z],[-y,x-y,1/2-z]}",
            "1",
        ),
    ],
    "D6h^1": [
        ("1a", "{[0,0,0]}", "6/mmm"),
        ("1b", "{[0,0,1/2]}", "6/mmm"),
        ("2c", "{[1/3,2/3,0],[2/3,1/3,0]}", "-6m2"),
        ("2d", "{[1/3,2/3,1/2],[2/3,1/3,1/2]}", "-6m2"),
        ("2e", "{[0,0,z],[0,0,-z]}", "6mm"),
        ("3f", "{[1/2,0,0],[1/2,1/2,0],[0,1/2,0]}", "mmm"),
        ("3g", "{[1/2,0,1/2],[1/2,1/2,1/2],[0,1/2,1/2]}", "mmm"),
        ("4h", "{[1/3,2/3,z],[2/3,1/3,z],[2/3,1/3,-z],[1/3,2/3,-z]}", "3m."),
        ("6i", "{[1/2,0,z],[1/2,0,-z],[1/2,1/2,-z],[0,1/2,-z],[0,1/2,z],[1/2,1/2,z]}", "2mm"),
        ("6j", "{[x,0,0],[-x,0,0],[-x,-x,0],[0,x,0],[x,x,0],[0,-x,0]}", "m2m"),
        ("6k", "{[x,0,1/2],[-x,0,1/2],[-x,-x,1/2],[0,x,1/2],[x,x,1/2],[0,-x,1/2]}", "m2m"),
        ("6l", "{[x,2*x,0],[-x,-2*x,0],[-x,x,0],[2*x,x,0],[x,-x,0],[-2*x,-x,0]}", "mm2"),
        ("6m", "{[x,2*x,1/2],[-x,-2*x,1/2],[-x,x,1/2],[2*x,x,1/2],[x,-x,1/2],[-2*x,-x,1/2]}", "mm2"),
        (
            "12n",
            "{[x,0,z],[-x,0,z],[x,0,-z],[-x,-x,-z],[0,x,-z],[-x,0,-z],[x,x,-z],[0,-x,-z],[0,x,z],[-x,-x,z],[x,x,z],[0,-x,z]}",
            "..m",
        ),
        (
            "12o",
            "{[x,2*x,z],[-x,-2*x,z],[-x,-2*x,-z],[-x,x,-z],[2*x,x,-z],[x,2*x,-z],[x,-x,-z],[-2*x,-x,-z],[-2*x,-x,z],[x,-x,z],[-x,x,z],[2*x,x,z]}",
            ".m.",
        ),
        (
            "12p",
            "{[x,y,0],[-x,-y,0],[x-y,-y,0],[-x,-x+y,0],[y,x,0],[-x+y,y,0],[x,x-y,0],[-y,-x,0],[-y,x-y,0],[-x+y,-x,0],[x-y,x,0],[y,-x+y,0]}",
            "m..",
        ),
        (
            "12q",
            "{[x,y,1/2],[-x,-y,1/2],[x-y,-y,1/2],[-x,-x+y,1/2],[y,x,1/2],[-x+y,y,1/2],[x,x-y,1/2],[-y,-x,1/2],[-y,x-y,1/2],[-x+y,-x,1/2],[x-y,x,1/2],[y,-x+y,1/2]}",
            "m..",
        ),
        (
            "24r",
            "{[x,y,z],[-x,-y,z],[x-y,-y,-z],[-x,-x+y,-z],[y,x,-z],[-x+y,y,-z],[x,x-y,-z],[-y,-x,-z],[-y,x-y,z],[-x+y,-x,z],[x-y,x,z],[y,-x+y,z],[-x,-y,-z],[-x+y,y,z],[x,x-y,z],[-y,-x,z],[x,y,-z],[x-y,-y,z],[-x,-x+y,z],[y,x,z],[y,-x+y,-z],[x-y,x,-z],[-x+y,-x,-z],[-y,x-y,-z]}",
            "1",
        ),
    ],
    "D6h^2": [
        ("2a", "{[0,0,1/4],[0,0,3/4]}", "622"),
        ("2b", "{[0,0,0],[0,0,1/2]}", "6/m.."),
        ("4c", "{[1/3,2/3,1/4],[2/3,1/3,1/4],[2/3,1/3,3/4],[1/3,2/3,3/4]}", "3.2"),
        ("4d", "{[1/3,2/3,0],[2/3,1/3,0],[2/3,1/3,1/2],[1/3,2/3,1/2]}", "-6.."),
        ("4e", "{[0,0,z],[0,0,1/2-z],[0,0,-z],[0,0,z+1/2]}", "6.."),
        ("6f", "{[1/2,0,1/4],[1/2,1/2,1/4],[0,1/2,1/4],[1/2,0,3/4],[1/2,1/2,3/4],[0,1/2,3/4]}", "222"),
        ("6g", "{[1/2,0,0],[1/2,0,1/2],[1/2,1/2,1/2],[0,1/2,1/2],[0,1/2,0],[1/2,1/2,0]}", "2/m.."),
        (
            "8h",
            "{[1/3,2/3,z],[2/3,1/3,z],[2/3,1/3,1/2-z],[1/3,2/3,1/2-z],[2/3,1/3,-z],[1/3,2/3,z+1/2],[1/3,2/3,-z],[2/3,1/3,z+1/2]}",
            "3..",
        ),
        (
            "12i",
            "{[1/2,0,z],[1/2,0,1/2-z],[1/2,1/2,1/2-z],[0,1/2,1/2-z],[0,1/2,z],[1/2,1/2,z],[1/2,0,-z],[1/2,0,z+1/2],[1/2,1/2,z+1/2],[0,1/2,z+1/2],[0,1/2,-z],[1/2,1/2,-z]}",
            "2..",
        ),
        (
            "12j",
            "{[x,0,1/4],[-x,0,1/4],[-x,-x,1/4],[0,x,1/4],[x,x,1/4],[0,-x,1/4],[-x,0,3/4],[x,x,3/4],[0,-x,3/4],[x,0,3/4],[-x,-x,3/4],[0,x,3/4]}",
            ".2.",
        ),
        (
            "12k",
            "{[x,2*x,1/4],[-x,-2*x,1/4],[-x,x,1/4],[2*x,x,1/4],[x,-x,1/4],[-2*x,-x,1/4],[-x,-2*x,3/4],[x,2*x,3/4],[x,-x,3/4],[-2*x,-x,3/4],[-x,x,3/4],[2*x,x,3/4]}",
            "..2",
        ),
        (
            "12l",
            "{[x,y,0],[-x,-y,0],[x-y,-y,1/2],[-x,-x+y,1/2],[y,x,1/2],[-x+y,y,1/2],[x,x-y,1/2],[-y,-x,1/2],[-y,x-y,0],[-x+y,-x,0],[x-y,x,0],[y,-x+y,0]}",
            "m..",
        ),
        (
            "24m",
            "{[x,y,z],[-x,-y,z],[x-y,-y,1/2-z],[-x,-x+y,1/2-z],[y,x,1/2-z],[-x+y,y,1/2-z],[x,x-y,1/2-z],[-y,-x,1/2-z],[-y,x-y,z],[-x+y,-x,z],[x-y,x,z],[y,-x+y,z],[-x,-y,-z],[-x+y,y,z+1/2],[x,x-y,z+1/2],[-y,-x,z+1/2],[x,y,-z],[x-y,-y,z+1/2],[-x,-x+y,z+1/2],[y,x,z+1/2],[y,-x+y,-z],[x-y,x,-z],[-x+y,-x,-z],[-y,x-y,-z]}",
            "1",
        ),
    ],
    "D6h^3": [
        ("2a", "{[0,0,1/4],[0,0,3/4]}", "-62m"),
        ("2b", "{[0,0,0],[0,0,1/2]}", "-3.m"),
        ("4c", "{[1/3,2/3,1/4],[2/3,1/3,3/4],[2/3,1/3,1/4],[1/3,2/3,3/4]}", "-6.."),
        ("4d", "{[1/3,2/3,0],[2/3,1/3,1/2],[2/3,1/3,0],[1/3,2/3,1/2]}", "3.2"),
        ("4e", "{[0,0,z],[0,0,z+1/2],[0,0,1/2-z],[0,0,-z]}", "3.m"),
        ("6f", "{[1/2,0,0],[1/2,0,1/2],[1/2,1/2,1/2],[0,1/2,1/2],[1/2,1/2,0],[0,1/2,0]}", "..2/m"),
        ("6g", "{[x,0,1/4],[-x,0,3/4],[-x,-x,1/4],[0,x,1/4],[x,x,3/4],[0,-x,3/4]}", "m2m"),
        (
            "8h",
            "{[1/3,2/3,z],[2/3,1/3,z+1/2],[2/3,1/3,1/2-z],[1/3,2/3,-z],[2/3,1/3,-z],[1/3,2/3,z+1/2],[1/3,2/3,1/2-z],[2/3,1/3,z]}",
            "3..",
        ),
        (
            "12i",
            "{[x,2*x,0],[-x,-2*x,1/2],[-x,x,1/2],[2*x,x,1/2],[x,-x,0],[-2*x,-x,0],[-x,-2*x,0],[x,2*x,1/2],[x,-x,1/2],[-2*x,-x,1/2],[-x,x,0],[2*x,x,0]}",
            "..2",
        ),
        (
            "12j",
            "{[x,y,1/4],[-x,-y,3/4],[x-y,-y,1/4],[-x,-x+y,1/4],[y,x,1/4],[-x+y,y,3/4],[x,x-y,3/4],[-y,-x,3/4],[-y,x-y,1/4],[-x+y,-x,1/4],[x-y,x,3/4],[y,-x+y,3/4]}",
            "m..",
        ),
        (
            "12k",
            "{[x,0,z],[-x,0,z+1/2],[x,0,1/2-z],[-x,-x,1/2-z],[0,x,1/2-z],[-x,0,-z],[x,x,-z],[0,-x,-z],[0,x,z],[-x,-x,z],[x,x,z+1/2],[0,-x,z+1/2]}",
            "..m",
        ),
        (
            "24l",
            "{[x,y,z],[-x,-y,z+1/2],[x-y,-y,1/2-z],[-x,-x+y,1/2-z],[y,x,1/2-z],[-x+y,y,-z],[x,x-y,-z],[-y,-x,-z],[-y,x-y,z],[-x+y,-x,z],[x-y,x,z+1/2],[y,-x+y,z+1/2],[-x,-y,-z],[-x+y,y,z+1/2],[x,x-y,z+1/2],[-y,-x,z+1/2],[x,y,1/2-z],[x-y,-y,z],[-x,-x+y,z],[y,x,z],[y,-x+y,-z],[x-y,x,-z],[-x+y,-x,1/2-z],[-y,x-y,1/2-z]}",
            "1",
        ),
    ],
    "D6h^4": [
        ("2a", "{[0,0,0],[0,0,1/2]}", "-3m."),
        ("2b", "{[0,0,1/4],[0,0,3/4]}", "-6m2"),
        ("2c", "{[1/3,2/3,1/4],[2/3,1/3,3/4]}", "-6m2"),
        ("2d", "{[1/3,2/3,3/4],[2/3,1/3,1/4]}", "-6m2"),
        ("4e", "{[0,0,z],[0,0,z+1/2],[0,0,-z],[0,0,1/2-z]}", "3m."),
        ("4f", "{[1/3,2/3,z],[2/3,1/3,z+1/2],[2/3,1/3,-z],[1/3,2/3,1/2-z]}", "3m."),
        ("6g", "{[1/2,0,0],[1/2,0,1/2],[1/2,1/2,0],[0,1/2,0],[1/2,1/2,1/2],[0,1/2,1/2]}", ".2/m."),
        ("6h", "{[x,2*x,1/4],[-x,-2*x,3/4],[-x,x,3/4],[2*x,x,3/4],[x,-x,1/4],[-2*x,-x,1/4]}", "mm2"),
        (
            "12i",
            "{[x,0,0],[-x,0,1/2],[-x,-x,0],[0,x,0],[x,x,1/2],[0,-x,1/2],[-x,0,0],[x,x,0],[0,-x,0],[x,0,1/2],[-x,-x,1/2],[0,x,1/2]}",
            ".2.",
        ),
        (
            "12j",
            "{[x,y,1/4],[-x,-y,3/4],[x-y,-y,3/4],[-x,-x+y,3/4],[y,x,3/4],[-x+y,y,1/4],[x,x-y,1/4],[-y,-x,1/4],[-y,x-y,1/4],[-x+y,-x,1/4],[x-y,x,3/4],[y,-x+y,3/4]}",
            "m..",
        ),
        (
            "12k",
            "{[x,2*x,z],[-x,-2*x,z+1/2],[-x,-2*x,-z],[-x,x,-z],[2*x,x,-z],[x,2*x,1/2-z],[x,-x,1/2-z],[-2*x,-x,1/2-z],[-2*x,-x,z],[x,-x,z],[-x,x,z+1/2],[2*x,x,z+1/2]}",
            ".m.",
        ),
        (
            "24l",
            "{[x,y,z],[-x,-y,z+1/2],[x-y,-y,-z],[-x,-x+y,-z],[y,x,-z],[-x+y,y,1/2-z],[x,x-y,1/2-z],[-y,-x,1/2-z],[-y,x-y,z],[-x+y,-x,z],[x-y,x,z+1/2],[y,-x+y,z+1/2],[-x,-y,-z],[-x+y,y,z],[x,x-y,z],[-y,-x,z],[x,y,1/2-z],[x-y,-y,z+1/2],[-x,-x+y,z+1/2],[y,x,z+1/2],[y,-x+y,-z],[x-y,x,-z],[-x+y,-x,1/2-z],[-y,x-y,1/2-z]}",
            "1",
        ),
    ],
    "T^1": [
        ("1a", "{[0,0,0]}", "23."),
        ("1b", "{[1/2,1/2,1/2]}", "23."),
        ("3c", "{[0,1/2,1/2],[1/2,0,1/2],[1/2,1/2,0]}", "222.."),
        ("3d", "{[1/2,0,0],[0,1/2,0],[0,0,1/2]}", "222.."),
        ("4e", "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x]}", ".3."),
        ("6f", "{[x,0,0],[-x,0,0],[0,x,0],[0,-x,0],[0,0,x],[0,0,-x]}", "2.."),
        ("6g", "{[x,0,1/2],[-x,0,1/2],[1/2,x,0],[1/2,-x,0],[0,1/2,x],[0,1/2,-x]}", "2.."),
        ("6h", "{[x,1/2,0],[-x,1/2,0],[0,x,1/2],[0,-x,1/2],[1/2,0,x],[1/2,0,-x]}", "2.."),
        ("6i", "{[x,1/2,1/2],[-x,1/2,1/2],[1/2,x,1/2],[1/2,-x,1/2],[1/2,1/2,x],[1/2,1/2,-x]}", "2.."),
        (
            "12j",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x]}",
            "1",
        ),
    ],
    "T^2": [
        ("4a", "{[0,0,0]}", "23."),
        ("4b", "{[1/2,1/2,1/2]}", "23."),
        ("4c", "{[1/4,1/4,1/4]}", "23."),
        ("4d", "{[3/4,3/4,3/4]}", "23."),
        ("16e", "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x]}", ".3."),
        ("24f", "{[x,0,0],[-x,0,0],[0,x,0],[0,-x,0],[0,0,x],[0,0,-x]}", "2.."),
        ("24g", "{[x,1/4,1/4],[1/2-x,1/4,1/4],[1/4,x,1/4],[1/4,1/2-x,1/4],[1/4,1/4,x],[1/4,1/4,1/2-x]}", "2.."),
        (
            "48h",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x]}",
            "1",
        ),
    ],
    "T^3": [
        ("2a", "{[0,0,0]}", "23."),
        ("6b", "{[1/2,0,0],[0,1/2,0],[0,0,1/2]}", "222.."),
        ("8c", "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x]}", ".3."),
        ("12d", "{[x,0,0],[-x,0,0],[0,x,0],[0,-x,0],[0,0,x],[0,0,-x]}", "2.."),
        ("12e", "{[x,1/2,0],[-x,1/2,0],[0,x,1/2],[0,-x,1/2],[1/2,0,x],[1/2,0,-x]}", "2.."),
        (
            "24f",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x]}",
            "1",
        ),
    ],
    "T^4": [
        ("4a", "{[x,x,x],[1/2-x,-x,x+1/2],[x+1/2,1/2-x,-x],[-x,x+1/2,1/2-x]}", ".3."),
        (
            "12b",
            "{[x,y,z],[1/2-x,-y,z+1/2],[x+1/2,1/2-y,-z],[-x,y+1/2,1/2-z],[z,x,y],[1/2-z,-x,y+1/2],[z+1/2,1/2-x,-y],[-z,x+1/2,1/2-y],[y,z,x],[-y,z+1/2,1/2-x],[1/2-y,-z,x+1/2],[y+1/2,1/2-z,-x]}",
            "1",
        ),
    ],
    "T^5": [
        ("8a", "{[x,x,x],[-x,1/2-x,x],[x,-x,1/2-x],[1/2-x,x,-x]}", ".3."),
        ("12b", "{[x,0,1/4],[-x,1/2,1/4],[1/4,x,0],[1/4,-x,1/2],[0,1/4,x],[1/2,1/4,-x]}", "2.."),
        (
            "24c",
            "{[x,y,z],[1/2-x,-y,z+1/2],[x+1/2,1/2-y,-z],[-x,y+1/2,1/2-z],[z,x,y],[1/2-z,-x,y+1/2],[z+1/2,1/2-x,-y],[-z,x+1/2,1/2-y],[y,z,x],[-y,z+1/2,1/2-x],[1/2-y,-z,x+1/2],[y+1/2,1/2-z,-x]}",
            "1",
        ),
    ],
    "Th^1": [
        ("1a", "{[0,0,0]}", "m-3."),
        ("1b", "{[1/2,1/2,1/2]}", "m-3."),
        ("3c", "{[0,1/2,1/2],[1/2,0,1/2],[1/2,1/2,0]}", "mmm.."),
        ("3d", "{[1/2,0,0],[0,1/2,0],[0,0,1/2]}", "mmm.."),
        ("6e", "{[x,0,0],[-x,0,0],[0,x,0],[0,-x,0],[0,0,x],[0,0,-x]}", "mm2.."),
        ("6f", "{[x,0,1/2],[-x,0,1/2],[1/2,x,0],[1/2,-x,0],[0,1/2,x],[0,1/2,-x]}", "mm2.."),
        ("6g", "{[x,1/2,0],[-x,1/2,0],[0,x,1/2],[0,-x,1/2],[1/2,0,x],[1/2,0,-x]}", "mm2.."),
        ("6h", "{[x,1/2,1/2],[-x,1/2,1/2],[1/2,x,1/2],[1/2,-x,1/2],[1/2,1/2,x],[1/2,1/2,-x]}", "mm2.."),
        ("8i", "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x],[-x,-x,-x],[x,x,-x],[-x,x,x],[x,-x,x]}", ".3."),
        (
            "12j",
            "{[0,y,z],[0,-y,z],[0,-y,-z],[0,y,-z],[z,0,y],[-z,0,y],[z,0,-y],[-z,0,-y],[y,z,0],[-y,z,0],[-y,-z,0],[y,-z,0]}",
            "m..",
        ),
        (
            "12k",
            "{[1/2,y,z],[1/2,-y,z],[1/2,-y,-z],[1/2,y,-z],[z,1/2,y],[-z,1/2,y],[z,1/2,-y],[-z,1/2,-y],[y,z,1/2],[-y,z,1/2],[-y,-z,1/2],[y,-z,1/2]}",
            "m..",
        ),
        (
            "24l",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x],[-x,-y,-z],[x,y,-z],[-x,y,z],[x,-y,z],[-z,-x,-y],[z,x,-y],[-z,x,y],[z,-x,y],[-y,-z,-x],[y,-z,x],[y,z,-x],[-y,z,x]}",
            "1",
        ),
    ],
    "Th^2": [
        ("2a", "{[1/4,1/4,1/4],[3/4,3/4,3/4]}", "23."),
        ("4b", "{[0,0,0],[1/2,1/2,0],[0,1/2,1/2],[1/2,0,1/2]}", ".-3."),
        ("4c", "{[1/2,1/2,1/2],[0,0,1/2],[1/2,0,0],[0,1/2,0]}", ".-3."),
        ("6d", "{[1/4,3/4,3/4],[3/4,1/4,3/4],[3/4,3/4,1/4],[3/4,1/4,1/4],[1/4,3/4,1/4],[1/4,1/4,3/4]}", "222.."),
        (
            "8e",
            "{[x,x,x],[1/2-x,1/2-x,x],[x,1/2-x,1/2-x],[1/2-x,x,1/2-x],[-x,-x,-x],[x+1/2,x+1/2,-x],[-x,x+1/2,x+1/2],[x+1/2,-x,x+1/2]}",
            ".3.",
        ),
        (
            "12f",
            "{[x,1/4,1/4],[1/2-x,1/4,1/4],[1/4,x,1/4],[1/4,1/2-x,1/4],[1/4,1/4,x],[1/4,1/4,1/2-x],[-x,3/4,3/4],[x+1/2,3/4,3/4],[3/4,-x,3/4],[3/4,x+1/2,3/4],[3/4,3/4,-x],[3/4,3/4,x+1/2]}",
            "2..",
        ),
        (
            "12g",
            "{[x,3/4,1/4],[1/2-x,3/4,1/4],[1/4,x,3/4],[1/4,1/2-x,3/4],[3/4,1/4,x],[3/4,1/4,1/2-x],[-x,1/4,3/4],[x+1/2,1/4,3/4],[3/4,-x,1/4],[3/4,x+1/2,1/4],[1/4,3/4,-x],[1/4,3/4,x+1/2]}",
            "2..",
        ),
        (
            "24h",
            "{[x,y,z],[1/2-x,1/2-y,z],[x,1/2-y,1/2-z],[1/2-x,y,1/2-z],[z,x,y],[1/2-z,1/2-x,y],[z,1/2-x,1/2-y],[1/2-z,x,1/2-y],[y,z,x],[1/2-y,z,1/2-x],[1/2-y,1/2-z,x],[y,1/2-z,1/2-x],[-x,-y,-z],[x+1/2,y+1/2,-z],[-x,y+1/2,z+1/2],[x+1/2,-y,z+1/2],[-z,-x,-y],[z+1/2,x+1/2,-y],[-z,x+1/2,y+1/2],[z+1/2,-x,y+1/2],[-y,-z,-x],[y+1/2,-z,x+1/2],[y+1/2,z+1/2,-x],[-y,z+1/2,x+1/2]}",
            "1",
        ),
    ],
    "Th^3": [
        ("4a", "{[0,0,0]}", "m-3."),
        ("4b", "{[1/2,1/2,1/2]}", "m-3."),
        ("8c", "{[1/4,1/4,1/4],[3/4,3/4,3/4]}", "23."),
        ("24d", "{[0,1/4,1/4],[1/2,1/4,1/4],[1/4,0,1/4],[1/4,1/2,1/4],[1/4,1/4,0],[1/4,1/4,1/2]}", "2/m.."),
        ("24e", "{[x,0,0],[-x,0,0],[0,x,0],[0,-x,0],[0,0,x],[0,0,-x]}", "mm2.."),
        ("32f", "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x],[-x,-x,-x],[x,x,-x],[-x,x,x],[x,-x,x]}", ".3."),
        (
            "48g",
            "{[x,1/4,1/4],[1/2-x,1/4,1/4],[1/4,x,1/4],[1/4,1/2-x,1/4],[1/4,1/4,x],[1/4,1/4,1/2-x],[-x,1/4,1/4],[x+1/2,1/4,1/4],[1/4,-x,1/4],[1/4,x+1/2,1/4],[1/4,1/4,-x],[1/4,1/4,x+1/2]}",
            "2..",
        ),
        (
            "48h",
            "{[0,y,z],[0,-y,z],[0,-y,-z],[0,y,-z],[z,0,y],[-z,0,y],[z,0,-y],[-z,0,-y],[y,z,0],[-y,z,0],[-y,-z,0],[y,-z,0]}",
            "m..",
        ),
        (
            "96i",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x],[-x,-y,-z],[x,y,-z],[-x,y,z],[x,-y,z],[-z,-x,-y],[z,x,-y],[-z,x,y],[z,-x,y],[-y,-z,-x],[y,-z,x],[y,z,-x],[-y,z,x]}",
            "1",
        ),
    ],
    "Th^4": [
        ("8a", "{[1/8,1/8,1/8],[7/8,7/8,7/8]}", "23."),
        ("8b", "{[5/8,5/8,5/8],[3/8,3/8,3/8]}", "23."),
        ("16c", "{[0,0,0],[1/4,1/4,0],[0,1/4,1/4],[1/4,0,1/4]}", ".-3."),
        ("16d", "{[1/2,1/2,1/2],[1/4,1/4,1/2],[1/2,1/4,1/4],[1/4,1/2,1/4]}", ".-3."),
        (
            "32e",
            "{[x,x,x],[1/4-x,1/4-x,x],[x,1/4-x,1/4-x],[1/4-x,x,1/4-x],[-x,-x,-x],[x+1/4,x+1/4,-x],[-x,x+1/4,x+1/4],[x+1/4,-x,x+1/4]}",
            ".3.",
        ),
        (
            "48f",
            "{[x,1/8,1/8],[1/4-x,1/8,1/8],[1/8,x,1/8],[1/8,1/4-x,1/8],[1/8,1/8,x],[1/8,1/8,1/4-x],[-x,3/8,3/8],[x+3/4,3/8,3/8],[3/8,-x,3/8],[3/8,x+3/4,3/8],[3/8,3/8,-x],[3/8,3/8,x+3/4]}",
            "2..",
        ),
        (
            "96g",
            "{[x,y,z],[3/4-x,3/4-y,z],[x,3/4-y,3/4-z],[3/4-x,y,3/4-z],[z,x,y],[3/4-z,3/4-x,y],[z,3/4-x,3/4-y],[3/4-z,x,3/4-y],[y,z,x],[3/4-y,z,3/4-x],[3/4-y,3/4-z,x],[y,3/4-z,3/4-x],[-x,-y,-z],[x+1/4,y+1/4,-z],[-x,y+1/4,z+1/4],[x+1/4,-y,z+1/4],[-z,-x,-y],[z+1/4,x+1/4,-y],[-z,x+1/4,y+1/4],[z+1/4,-x,y+1/4],[-y,-z,-x],[y+1/4,-z,x+1/4],[y+1/4,z+1/4,-x],[-y,z+1/4,x+1/4]}",
            "1",
        ),
    ],
    "Th^5": [
        ("2a", "{[0,0,0]}", "m-3."),
        ("6b", "{[1/2,0,0],[0,1/2,0],[0,0,1/2]}", "mmm.."),
        ("8c", "{[1/4,1/4,1/4],[1/4,1/4,3/4],[3/4,1/4,1/4],[1/4,3/4,1/4]}", ".-3."),
        ("12d", "{[x,0,0],[-x,0,0],[0,x,0],[0,-x,0],[0,0,x],[0,0,-x]}", "mm2.."),
        ("12e", "{[x,0,1/2],[-x,0,1/2],[1/2,x,0],[1/2,-x,0],[0,1/2,x],[0,1/2,-x]}", "mm2.."),
        ("16f", "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x],[-x,-x,-x],[x,x,-x],[-x,x,x],[x,-x,x]}", ".3."),
        (
            "24g",
            "{[0,y,z],[0,-y,z],[0,-y,-z],[0,y,-z],[z,0,y],[-z,0,y],[z,0,-y],[-z,0,-y],[y,z,0],[-y,z,0],[-y,-z,0],[y,-z,0]}",
            "m..",
        ),
        (
            "48h",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x],[-x,-y,-z],[x,y,-z],[-x,y,z],[x,-y,z],[-z,-x,-y],[z,x,-y],[-z,x,y],[z,-x,y],[-y,-z,-x],[y,-z,x],[y,z,-x],[-y,z,x]}",
            "1",
        ),
    ],
    "Th^6": [
        ("4a", "{[0,0,0],[1/2,0,1/2],[1/2,1/2,0],[0,1/2,1/2]}", ".-3."),
        ("4b", "{[1/2,1/2,1/2],[0,1/2,0],[0,0,1/2],[1/2,0,0]}", ".-3."),
        (
            "8c",
            "{[x,x,x],[1/2-x,-x,x+1/2],[x+1/2,1/2-x,-x],[-x,x+1/2,1/2-x],[-x,-x,-x],[x+1/2,x,1/2-x],[1/2-x,x+1/2,x],[x,1/2-x,x+1/2]}",
            ".3.",
        ),
        (
            "24d",
            "{[x,y,z],[1/2-x,-y,z+1/2],[x+1/2,1/2-y,-z],[-x,y+1/2,1/2-z],[z,x,y],[1/2-z,-x,y+1/2],[z+1/2,1/2-x,-y],[-z,x+1/2,1/2-y],[y,z,x],[-y,z+1/2,1/2-x],[1/2-y,-z,x+1/2],[y+1/2,1/2-z,-x],[-x,-y,-z],[x+1/2,y,1/2-z],[1/2-x,y+1/2,z],[x,1/2-y,z+1/2],[-z,-x,-y],[z+1/2,x,1/2-y],[1/2-z,x+1/2,y],[z,1/2-x,y+1/2],[-y,-z,-x],[y,1/2-z,x+1/2],[y+1/2,z,1/2-x],[1/2-y,z+1/2,x]}",
            "1",
        ),
    ],
    "Th^7": [
        ("8a", "{[0,0,0],[0,1/2,0],[0,0,1/2],[1/2,0,0]}", ".-3."),
        ("8b", "{[1/4,1/4,1/4],[3/4,1/4,1/4],[1/4,3/4,1/4],[1/4,1/4,3/4]}", ".-3."),
        ("16c", "{[x,x,x],[-x,1/2-x,x],[x,-x,1/2-x],[1/2-x,x,-x],[-x,-x,-x],[x,x+1/2,-x],[-x,x,x+1/2],[x+1/2,-x,x]}", ".3."),
        (
            "24d",
            "{[x,0,1/4],[-x,1/2,1/4],[1/4,x,0],[1/4,-x,1/2],[0,1/4,x],[1/2,1/4,-x],[-x,0,3/4],[x+1/2,0,1/4],[3/4,-x,0],[1/4,x+1/2,0],[0,3/4,-x],[0,1/4,x+1/2]}",
            "2..",
        ),
        (
            "48e",
            "{[x,y,z],[1/2-x,-y,z+1/2],[x+1/2,1/2-y,-z],[-x,y+1/2,1/2-z],[z,x,y],[1/2-z,-x,y+1/2],[z+1/2,1/2-x,-y],[-z,x+1/2,1/2-y],[y,z,x],[-y,z+1/2,1/2-x],[1/2-y,-z,x+1/2],[y+1/2,1/2-z,-x],[-x,-y,-z],[x+1/2,y,1/2-z],[1/2-x,y+1/2,z],[x,1/2-y,z+1/2],[-z,-x,-y],[z+1/2,x,1/2-y],[1/2-z,x+1/2,y],[z,1/2-x,y+1/2],[-y,-z,-x],[y,1/2-z,x+1/2],[y+1/2,z,1/2-x],[1/2-y,z+1/2,x]}",
            "1",
        ),
    ],
    "O^1": [
        ("1a", "{[0,0,0]}", "432"),
        ("1b", "{[1/2,1/2,1/2]}", "432"),
        ("3c", "{[0,1/2,1/2],[1/2,0,1/2],[1/2,1/2,0]}", "42.2"),
        ("3d", "{[1/2,0,0],[0,1/2,0],[0,0,1/2]}", "42.2"),
        ("6e", "{[x,0,0],[-x,0,0],[0,x,0],[0,0,x],[0,-x,0],[0,0,-x]}", "4.."),
        ("6f", "{[x,1/2,1/2],[-x,1/2,1/2],[1/2,x,1/2],[1/2,1/2,x],[1/2,-x,1/2],[1/2,1/2,-x]}", "4.."),
        ("8g", "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x],[x,x,-x],[x,-x,x],[-x,x,x],[-x,-x,-x]}", ".3."),
        (
            "12h",
            "{[x,1/2,0],[-x,1/2,0],[1/2,x,0],[0,1/2,x],[-x,0,1/2],[1/2,-x,0],[0,1/2,-x],[0,x,1/2],[0,-x,1/2],[1/2,0,x],[1/2,0,-x],[x,0,1/2]}",
            "2..",
        ),
        (
            "12i",
            "{[0,y,y],[0,-y,y],[0,-y,-y],[0,y,-y],[y,0,-y],[y,-y,0],[-y,0,-y],[-y,-y,0],[y,0,y],[-y,0,y],[y,y,0],[-y,y,0]}",
            "..2",
        ),
        (
            "12j",
            "{[1/2,y,y],[1/2,-y,y],[1/2,-y,-y],[1/2,y,-y],[y,1/2,-y],[y,-y,1/2],[-y,1/2,-y],[-y,-y,1/2],[y,1/2,y],[-y,1/2,y],[y,y,1/2],[-y,y,1/2]}",
            "..2",
        ),
        (
            "24k",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[y,x,-z],[z,-y,x],[-x,z,y],[-y,-x,-z],[-z,-y,-x],[-x,-z,-y],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x],[-y,x,z],[x,-z,y],[z,y,-x],[y,-x,z],[x,z,-y],[-z,y,x]}",
            "1",
        ),
    ],
    "O^2": [
        ("2a", "{[0,0,0],[1/2,1/2,1/2]}", "23."),
        ("4b", "{[1/4,1/4,1/4],[3/4,3/4,1/4],[1/4,3/4,3/4],[3/4,1/4,3/4]}", ".32"),
        ("4c", "{[3/4,3/4,3/4],[1/4,1/4,3/4],[3/4,1/4,1/4],[1/4,3/4,1/4]}", ".32"),
        ("6d", "{[0,1/2,1/2],[0,1/2,0],[0,0,1/2],[1/2,0,0],[1/2,0,1/2],[1/2,1/2,0]}", "222.."),
        ("6e", "{[1/4,0,1/2],[3/4,0,1/2],[1/2,3/4,0],[0,1/2,3/4],[1/2,1/4,0],[0,1/2,1/4]}", "2.22"),
        ("6f", "{[1/4,1/2,0],[3/4,1/2,0],[0,3/4,1/2],[1/2,0,3/4],[0,1/4,1/2],[1/2,0,1/4]}", "2.22"),
        (
            "8g",
            "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x],[x+1/2,x+1/2,1/2-x],[x+1/2,1/2-x,x+1/2],[1/2-x,x+1/2,x+1/2],[1/2-x,1/2-x,1/2-x]}",
            ".3.",
        ),
        (
            "12h",
            "{[x,0,0],[-x,0,0],[1/2,x+1/2,1/2],[1/2,1/2,x+1/2],[1/2-x,1/2,1/2],[1/2,1/2-x,1/2],[1/2,1/2,1/2-x],[0,x,0],[0,-x,0],[0,0,x],[0,0,-x],[x+1/2,1/2,1/2]}",
            "2..",
        ),
        (
            "12i",
            "{[x,0,1/2],[-x,0,1/2],[1/2,x+1/2,0],[0,1/2,x+1/2],[1/2-x,0,1/2],[1/2,1/2-x,0],[0,1/2,1/2-x],[1/2,x,0],[1/2,-x,0],[0,1/2,x],[0,1/2,-x],[x+1/2,0,1/2]}",
            "2..",
        ),
        (
            "12j",
            "{[x,1/2,0],[-x,1/2,0],[0,x+1/2,1/2],[1/2,0,x+1/2],[1/2-x,1/2,0],[0,1/2-x,1/2],[1/2,0,1/2-x],[0,x,1/2],[0,-x,1/2],[1/2,0,x],[1/2,0,-x],[x+1/2,1/2,0]}",
            "2..",
        ),
        (
            "12k",
            "{[1/4,y,1/2-y],[3/4,-y,1/2-y],[1/4,-y,y+1/2],[3/4,y,y+1/2],[y+1/2,3/4,y],[-y,1/2-y,3/4],[1/2-y,1/4,y],[y,1/2-y,1/4],[1/2-y,3/4,-y],[y+1/2,1/4,-y],[-y,y+1/2,1/4],[y,y+1/2,3/4]}",
            "..2",
        ),
        (
            "12l",
            "{[1/4,y,y+1/2],[3/4,-y,y+1/2],[1/4,-y,1/2-y],[3/4,y,1/2-y],[y+1/2,3/4,-y],[y,1/2-y,3/4],[1/2-y,1/4,-y],[-y,1/2-y,1/4],[y+1/2,1/4,y],[1/2-y,3/4,y],[y,y+1/2,1/4],[-y,y+1/2,3/4]}",
            "..2",
        ),
        (
            "24m",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[y+1/2,x+1/2,1/2-z],[z+1/2,1/2-y,x+1/2],[1/2-x,z+1/2,y+1/2],[1/2-y,1/2-x,1/2-z],[1/2-z,1/2-y,1/2-x],[1/2-x,1/2-z,1/2-y],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x],[1/2-y,x+1/2,z+1/2],[x+1/2,1/2-z,y+1/2],[z+1/2,y+1/2,1/2-x],[y+1/2,1/2-x,z+1/2],[x+1/2,z+1/2,1/2-y],[1/2-z,y+1/2,x+1/2]}",
            "1",
        ),
    ],
    "O^3": [
        ("4a", "{[0,0,0]}", "432"),
        ("4b", "{[1/2,1/2,1/2]}", "432"),
        ("8c", "{[1/4,1/4,1/4],[3/4,3/4,3/4]}", "23."),
        ("24d", "{[0,1/4,1/4],[1/2,1/4,1/4],[1/4,1/2,1/4],[1/4,1/4,1/2],[1/4,0,1/4],[1/4,1/4,0]}", "2.22"),
        ("24e", "{[x,0,0],[-x,0,0],[0,x,0],[0,0,x],[0,-x,0],[0,0,-x]}", "4.."),
        ("32f", "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x],[x,x,-x],[x,-x,x],[-x,x,x],[-x,-x,-x]}", ".3."),
        (
            "48g",
            "{[0,y,y],[0,-y,y],[0,-y,-y],[0,y,-y],[y,0,-y],[y,-y,0],[-y,0,-y],[-y,-y,0],[y,0,y],[-y,0,y],[y,y,0],[-y,y,0]}",
            "..2",
        ),
        (
            "48h",
            "{[1/2,y+1/2,y+1/2],[1/2,1/2-y,y+1/2],[1/2,1/2-y,1/2-y],[1/2,y+1/2,1/2-y],[y+1/2,1/2,1/2-y],[y+1/2,1/2-y,1/2],[1/2-y,1/2,1/2-y],[1/2-y,1/2-y,1/2],[y+1/2,1/2,y+1/2],[1/2-y,1/2,y+1/2],[y+1/2,y+1/2,1/2],[1/2-y,y+1/2,1/2]}",
            "..2",
        ),
        (
            "48i",
            "{[x,1/4,1/4],[1/2-x,1/4,1/4],[1/4,x+1/2,1/4],[1/4,1/4,x+1/2],[-x,1/4,1/4],[1/4,-x,1/4],[1/4,1/4,-x],[1/4,x,1/4],[1/4,1/2-x,1/4],[1/4,1/4,x],[1/4,1/4,1/2-x],[x+1/2,1/4,1/4]}",
            "2..",
        ),
        (
            "96j",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[y,x,-z],[z,-y,x],[-x,z,y],[-y,-x,-z],[-z,-y,-x],[-x,-z,-y],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x],[-y,x,z],[x,-z,y],[z,y,-x],[y,-x,z],[x,z,-y],[-z,y,x]}",
            "1",
        ),
    ],
    "O^4": [
        ("8a", "{[0,0,0],[1/4,1/4,1/4]}", "23."),
        ("8b", "{[1/2,1/2,1/2],[3/4,3/4,3/4]}", "23."),
        ("16c", "{[1/8,1/8,1/8],[3/8,3/8,1/8],[1/8,3/8,3/8],[3/8,1/8,3/8]}", ".32"),
        ("16d", "{[5/8,5/8,5/8],[3/8,3/8,5/8],[5/8,3/8,3/8],[3/8,5/8,3/8]}", ".32"),
        (
            "32e",
            "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x],[x+1/4,x+1/4,1/4-x],[x+1/4,1/4-x,x+1/4],[1/4-x,x+1/4,x+1/4],[1/4-x,1/4-x,1/4-x]}",
            ".3.",
        ),
        (
            "48f",
            "{[x,0,0],[-x,0,0],[1/4,x+1/4,1/4],[1/4,1/4,x+1/4],[1/4-x,1/4,1/4],[1/4,1/4-x,1/4],[1/4,1/4,1/4-x],[0,x,0],[0,-x,0],[0,0,x],[0,0,-x],[x+1/4,1/4,1/4]}",
            "2..",
        ),
        (
            "48g",
            "{[5/8,y+1/2,1/4-y],[3/8,1/2-y,1/4-y],[5/8,1/2-y,y+3/4],[3/8,y+1/2,y+3/4],[y+3/4,3/8,y+1/2],[1/2-y,1/4-y,3/8],[1/4-y,5/8,y+1/2],[y+1/2,1/4-y,5/8],[1/4-y,3/8,1/2-y],[y+3/4,5/8,1/2-y],[1/2-y,y+3/4,5/8],[y+1/2,y+3/4,3/8]}",
            "..2",
        ),
        (
            "96h",
            "{[x,y,z],[-x,1/2-y,z+1/2],[x+1/2,-y,1/2-z],[1/2-x,y+1/2,-z],[y+3/4,x+1/4,3/4-z],[z+1/4,3/4-y,x+3/4],[3/4-x,z+3/4,y+1/4],[1/4-y,1/4-x,1/4-z],[1/4-z,1/4-y,1/4-x],[1/4-x,1/4-z,1/4-y],[z,x,y],[-z,1/2-x,y+1/2],[z+1/2,-x,1/2-y],[1/2-z,x+1/2,-y],[y,z,x],[1/2-y,z+1/2,-x],[-y,1/2-z,x+1/2],[y+1/2,-z,1/2-x],[3/4-y,x+3/4,z+1/4],[x+1/4,3/4-z,y+3/4],[z+3/4,y+1/4,3/4-x],[y+1/4,3/4-x,z+3/4],[x+3/4,z+1/4,3/4-y],[3/4-z,y+3/4,x+1/4]}",
            "1",
        ),
    ],
    "O^5": [
        ("2a", "{[0,0,0]}", "432"),
        ("6b", "{[1/2,0,0],[0,1/2,0],[0,0,1/2]}", "42.2"),
        ("8c", "{[1/4,1/4,1/4],[1/4,1/4,3/4],[3/4,1/4,1/4],[1/4,3/4,1/4]}", ".32"),
        ("12d", "{[1/4,1/2,0],[1/4,0,1/2],[1/2,1/4,0],[0,1/2,1/4],[0,1/4,1/2],[1/2,0,1/4]}", "2.22"),
        ("12e", "{[x,0,0],[-x,0,0],[0,x,0],[0,0,x],[0,-x,0],[0,0,-x]}", "4.."),
        ("16f", "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x],[x,x,-x],[x,-x,x],[-x,x,x],[-x,-x,-x]}", ".3."),
        (
            "24g",
            "{[x,1/2,0],[-x,1/2,0],[1/2,x,0],[0,1/2,x],[-x,0,1/2],[1/2,-x,0],[0,1/2,-x],[0,x,1/2],[0,-x,1/2],[1/2,0,x],[1/2,0,-x],[x,0,1/2]}",
            "2..",
        ),
        (
            "24h",
            "{[0,y,y],[0,-y,y],[0,-y,-y],[0,y,-y],[y,0,-y],[y,-y,0],[-y,0,-y],[-y,-y,0],[y,0,y],[-y,0,y],[y,y,0],[-y,y,0]}",
            "..2",
        ),
        (
            "24i",
            "{[1/4,y,1/2-y],[1/4,1/2-y,-y],[1/4,-y,y+1/2],[1/4,y+1/2,y],[y,1/4,y+1/2],[1/2-y,-y,1/4],[1/2-y,1/4,y],[y,1/2-y,1/4],[-y,1/4,1/2-y],[y+1/2,1/4,-y],[-y,y+1/2,1/4],[y+1/2,y,1/4]}",
            "..2",
        ),
        (
            "48j",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[y,x,-z],[z,-y,x],[-x,z,y],[-y,-x,-z],[-z,-y,-x],[-x,-z,-y],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x],[-y,x,z],[x,-z,y],[z,y,-x],[y,-x,z],[x,z,-y],[-z,y,x]}",
            "1",
        ),
    ],
    "O^6": [
        ("4a", "{[1/8,1/8,1/8],[3/8,7/8,5/8],[5/8,3/8,7/8],[7/8,5/8,3/8]}", ".32"),
        ("4b", "{[5/8,5/8,5/8],[7/8,3/8,1/8],[1/8,7/8,3/8],[3/8,1/8,7/8]}", ".32"),
        (
            "8c",
            "{[x,x,x],[1/2-x,-x,x+1/2],[x+1/2,1/2-x,-x],[-x,x+1/2,1/2-x],[x+1/4,x+3/4,3/4-x],[x+3/4,3/4-x,x+1/4],[3/4-x,x+1/4,x+3/4],[1/4-x,1/4-x,1/4-x]}",
            ".3.",
        ),
        (
            "12d",
            "{[1/8,y,1/4-y],[3/8,-y,3/4-y],[5/8,1/2-y,y+3/4],[7/8,y+1/2,y+1/4],[y+1/4,7/8,y+1/2],[-y,3/4-y,3/8],[1/4-y,1/8,y],[y,1/4-y,1/8],[3/4-y,3/8,-y],[y+3/4,5/8,1/2-y],[1/2-y,y+3/4,5/8],[y+1/2,y+1/4,7/8]}",
            "..2",
        ),
        (
            "24e",
            "{[x,y,z],[1/2-x,-y,z+1/2],[x+1/2,1/2-y,-z],[-x,y+1/2,1/2-z],[y+1/4,x+3/4,3/4-z],[z+3/4,3/4-y,x+1/4],[3/4-x,z+1/4,y+3/4],[1/4-y,1/4-x,1/4-z],[1/4-z,1/4-y,1/4-x],[1/4-x,1/4-z,1/4-y],[z,x,y],[1/2-z,-x,y+1/2],[z+1/2,1/2-x,-y],[-z,x+1/2,1/2-y],[y,z,x],[-y,z+1/2,1/2-x],[1/2-y,-z,x+1/2],[y+1/2,1/2-z,-x],[3/4-y,x+1/4,z+3/4],[x+3/4,3/4-z,y+1/4],[z+1/4,y+3/4,3/4-x],[y+3/4,3/4-x,z+1/4],[x+1/4,z+3/4,3/4-y],[3/4-z,y+1/4,x+3/4]}",
            "1",
        ),
    ],
    "O^7": [
        ("4a", "{[3/8,3/8,3/8],[1/8,5/8,7/8],[7/8,1/8,5/8],[5/8,7/8,1/8]}", ".32"),
        ("4b", "{[7/8,7/8,7/8],[5/8,1/8,3/8],[3/8,5/8,1/8],[1/8,3/8,5/8]}", ".32"),
        (
            "8c",
            "{[x,x,x],[1/2-x,-x,x+1/2],[x+1/2,1/2-x,-x],[-x,x+1/2,1/2-x],[x+3/4,x+1/4,1/4-x],[x+1/4,1/4-x,x+3/4],[1/4-x,x+3/4,x+1/4],[3/4-x,3/4-x,3/4-x]}",
            ".3.",
        ),
        (
            "12d",
            "{[1/8,y,y+1/4],[3/8,-y,y+3/4],[5/8,1/2-y,3/4-y],[7/8,y+1/2,1/4-y],[y+3/4,3/8,-y],[y+1/2,1/4-y,7/8],[3/4-y,5/8,1/2-y],[1/2-y,3/4-y,5/8],[y+1/4,1/8,y],[1/4-y,7/8,y+1/2],[y,y+1/4,1/8],[-y,y+3/4,3/8]}",
            "..2",
        ),
        (
            "24e",
            "{[x,y,z],[1/2-x,-y,z+1/2],[x+1/2,1/2-y,-z],[-x,y+1/2,1/2-z],[y+3/4,x+1/4,1/4-z],[z+1/4,1/4-y,x+3/4],[1/4-x,z+3/4,y+1/4],[3/4-y,3/4-x,3/4-z],[3/4-z,3/4-y,3/4-x],[3/4-x,3/4-z,3/4-y],[z,x,y],[1/2-z,-x,y+1/2],[z+1/2,1/2-x,-y],[-z,x+1/2,1/2-y],[y,z,x],[-y,z+1/2,1/2-x],[1/2-y,-z,x+1/2],[y+1/2,1/2-z,-x],[1/4-y,x+3/4,z+1/4],[x+1/4,1/4-z,y+3/4],[z+3/4,y+1/4,1/4-x],[y+1/4,1/4-x,z+3/4],[x+3/4,z+1/4,1/4-y],[1/4-z,y+3/4,x+1/4]}",
            "1",
        ),
    ],
    "O^8": [
        ("8a", "{[1/8,1/8,1/8],[7/8,3/8,1/8],[1/8,7/8,3/8],[3/8,1/8,7/8]}", ".32"),
        ("8b", "{[3/8,3/8,3/8],[1/8,5/8,7/8],[7/8,1/8,5/8],[5/8,7/8,1/8]}", ".32"),
        ("12c", "{[1/8,0,1/4],[7/8,1/2,1/4],[1/4,7/8,1/2],[1/2,1/4,7/8],[1/4,1/8,0],[0,1/4,1/8]}", "2.22"),
        ("12d", "{[5/8,0,1/4],[3/8,1/2,1/4],[1/4,3/8,1/2],[1/2,1/4,3/8],[1/4,5/8,0],[0,1/4,5/8]}", "2.22"),
        (
            "16e",
            "{[x,x,x],[-x,1/2-x,x],[x,-x,1/2-x],[1/2-x,x,-x],[x+3/4,x+1/4,1/4-x],[x+1/4,1/4-x,x+3/4],[1/4-x,x+3/4,x+1/4],[1/4-x,1/4-x,1/4-x]}",
            ".3.",
        ),
        (
            "24f",
            "{[x,0,1/4],[-x,1/2,1/4],[1/4,x+3/4,1/2],[1/2,1/4,x+3/4],[1/4-x,0,1/4],[1/4,1/4-x,0],[0,1/4,1/4-x],[1/4,x,0],[1/4,-x,1/2],[0,1/4,x],[1/2,1/4,-x],[x+3/4,1/2,1/4]}",
            "2..",
        ),
        (
            "24g",
            "{[1/8,y,y+1/4],[7/8,1/2-y,y+1/4],[1/8,-y,1/4-y],[7/8,y+1/2,1/4-y],[y+1/4,7/8,1/2-y],[y+1/2,1/4-y,7/8],[1/4-y,1/8,-y],[-y,1/4-y,1/8],[y+1/4,1/8,y],[1/4-y,7/8,y+1/2],[y,y+1/4,1/8],[1/2-y,y+1/4,7/8]}",
            "..2",
        ),
        (
            "24h",
            "{[1/8,y,1/4-y],[7/8,1/2-y,1/4-y],[1/8,-y,y+1/4],[7/8,y+1/2,y+1/4],[y+1/4,7/8,y+1/2],[1/2-y,1/4-y,7/8],[1/4-y,1/8,y],[y,1/4-y,1/8],[1/4-y,7/8,1/2-y],[y+1/4,1/8,-y],[-y,y+1/4,1/8],[y+1/2,y+1/4,7/8]}",
            "..2",
        ),
        (
            "48i",
            "{[x,y,z],[1/2-x,-y,z+1/2],[x+1/2,1/2-y,-z],[-x,y+1/2,1/2-z],[y+3/4,x+1/4,1/4-z],[z+1/4,1/4-y,x+3/4],[1/4-x,z+3/4,y+1/4],[3/4-y,3/4-x,3/4-z],[3/4-z,3/4-y,3/4-x],[3/4-x,3/4-z,3/4-y],[z,x,y],[1/2-z,-x,y+1/2],[z+1/2,1/2-x,-y],[-z,x+1/2,1/2-y],[y,z,x],[-y,z+1/2,1/2-x],[1/2-y,-z,x+1/2],[y+1/2,1/2-z,-x],[1/4-y,x+3/4,z+1/4],[x+1/4,1/4-z,y+3/4],[z+3/4,y+1/4,1/4-x],[y+1/4,1/4-x,z+3/4],[x+3/4,z+1/4,1/4-y],[1/4-z,y+3/4,x+1/4]}",
            "1",
        ),
    ],
    "Td^1": [
        ("1a", "{[0,0,0]}", "-43m"),
        ("1b", "{[1/2,1/2,1/2]}", "-43m"),
        ("3c", "{[0,1/2,1/2],[1/2,0,1/2],[1/2,1/2,0]}", "-42.m"),
        ("3d", "{[1/2,0,0],[0,1/2,0],[0,0,1/2]}", "-42.m"),
        ("4e", "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x]}", ".3m"),
        ("6f", "{[x,0,0],[-x,0,0],[0,x,0],[0,-x,0],[0,0,x],[0,0,-x]}", "2.mm"),
        ("6g", "{[x,1/2,1/2],[-x,1/2,1/2],[1/2,x,1/2],[1/2,-x,1/2],[1/2,1/2,x],[1/2,1/2,-x]}", "2.mm"),
        (
            "12h",
            "{[x,1/2,0],[-x,1/2,0],[0,x,1/2],[0,-x,1/2],[1/2,0,x],[1/2,0,-x],[1/2,-x,0],[0,1/2,-x],[x,0,1/2],[1/2,x,0],[0,1/2,x],[-x,0,1/2]}",
            "2..",
        ),
        (
            "12i",
            "{[x,x,z],[-x,-x,z],[x,-x,-z],[-x,x,-z],[z,x,x],[-z,-x,x],[z,-x,-x],[-z,x,-x],[x,z,x],[-x,z,-x],[-x,-z,x],[x,-z,-x]}",
            "..m",
        ),
        (
            "24j",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x],[-y,-x,z],[-z,y,-x],[x,-z,-y],[y,x,z],[z,y,x],[x,z,y],[y,-x,-z],[-x,z,-y],[-z,-y,x],[-y,x,-z],[-x,-z,y],[z,-y,-x]}",
            "1",
        ),
    ],
    "Td^2": [
        ("4a", "{[0,0,0]}", "-43m"),
        ("4b", "{[1/2,1/2,1/2]}", "-43m"),
        ("4c", "{[1/4,1/4,1/4]}", "-43m"),
        ("4d", "{[3/4,3/4,3/4]}", "-43m"),
        ("16e", "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x]}", ".3m"),
        ("24f", "{[x,0,0],[-x,0,0],[0,x,0],[0,-x,0],[0,0,x],[0,0,-x]}", "2.mm"),
        ("24g", "{[x,1/4,1/4],[1/2-x,1/4,1/4],[1/4,x,1/4],[1/4,1/2-x,1/4],[1/4,1/4,x],[1/4,1/4,1/2-x]}", "2.mm"),
        (
            "48h",
            "{[x,x,z],[-x,-x,z],[x,-x,-z],[-x,x,-z],[z,x,x],[-z,-x,x],[z,-x,-x],[-z,x,-x],[x,z,x],[-x,z,-x],[-x,-z,x],[x,-z,-x]}",
            "..m",
        ),
        (
            "96i",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x],[-y,-x,z],[-z,y,-x],[x,-z,-y],[y,x,z],[z,y,x],[x,z,y],[y,-x,-z],[-x,z,-y],[-z,-y,x],[-y,x,-z],[-x,-z,y],[z,-y,-x]}",
            "1",
        ),
    ],
    "Td^3": [
        ("2a", "{[0,0,0]}", "-43m"),
        ("6b", "{[1/2,0,0],[0,1/2,0],[0,0,1/2]}", "-42.m"),
        ("8c", "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x]}", ".3m"),
        ("12d", "{[1/4,1/2,0],[1/4,0,1/2],[0,1/4,1/2],[1/2,1/4,0],[1/2,0,1/4],[0,1/2,1/4]}", "-4.."),
        ("12e", "{[x,0,0],[-x,0,0],[0,x,0],[0,-x,0],[0,0,x],[0,0,-x]}", "2.mm"),
        (
            "24f",
            "{[x,1/2,0],[-x,1/2,0],[0,x,1/2],[0,-x,1/2],[1/2,0,x],[1/2,0,-x],[1/2,-x,0],[0,1/2,-x],[x,0,1/2],[1/2,x,0],[0,1/2,x],[-x,0,1/2]}",
            "2..",
        ),
        (
            "24g",
            "{[x,x,z],[-x,-x,z],[x,-x,-z],[-x,x,-z],[z,x,x],[-z,-x,x],[z,-x,-x],[-z,x,-x],[x,z,x],[-x,z,-x],[-x,-z,x],[x,-z,-x]}",
            "..m",
        ),
        (
            "48h",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x],[-y,-x,z],[-z,y,-x],[x,-z,-y],[y,x,z],[z,y,x],[x,z,y],[y,-x,-z],[-x,z,-y],[-z,-y,x],[-y,x,-z],[-x,-z,y],[z,-y,-x]}",
            "1",
        ),
    ],
    "Td^4": [
        ("2a", "{[0,0,0],[1/2,1/2,1/2]}", "23."),
        ("6b", "{[0,1/2,1/2],[1/2,0,1/2],[1/2,1/2,0],[0,1/2,0],[0,0,1/2],[1/2,0,0]}", "222.."),
        ("6c", "{[1/4,1/2,0],[3/4,1/2,0],[0,1/4,1/2],[0,3/4,1/2],[1/2,0,1/4],[1/2,0,3/4]}", "-4.."),
        ("6d", "{[1/4,0,1/2],[3/4,0,1/2],[1/2,1/4,0],[1/2,3/4,0],[0,1/2,1/4],[0,1/2,3/4]}", "-4.."),
        (
            "8e",
            "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x],[1/2-x,1/2-x,x+1/2],[1/2-x,x+1/2,1/2-x],[x+1/2,1/2-x,1/2-x],[x+1/2,x+1/2,x+1/2]}",
            ".3.",
        ),
        (
            "12f",
            "{[x,0,0],[-x,0,0],[0,x,0],[0,-x,0],[0,0,x],[0,0,-x],[1/2,1/2-x,1/2],[1/2,1/2,1/2-x],[x+1/2,1/2,1/2],[1/2,x+1/2,1/2],[1/2,1/2,x+1/2],[1/2-x,1/2,1/2]}",
            "2..",
        ),
        (
            "12g",
            "{[x,1/2,0],[-x,1/2,0],[0,x,1/2],[0,-x,1/2],[1/2,0,x],[1/2,0,-x],[0,1/2-x,1/2],[1/2,0,1/2-x],[x+1/2,1/2,0],[0,x+1/2,1/2],[1/2,0,x+1/2],[1/2-x,1/2,0]}",
            "2..",
        ),
        (
            "12h",
            "{[x,0,1/2],[-x,0,1/2],[1/2,x,0],[1/2,-x,0],[0,1/2,x],[0,1/2,-x],[1/2,1/2-x,0],[0,1/2,1/2-x],[x+1/2,0,1/2],[1/2,x+1/2,0],[0,1/2,x+1/2],[1/2-x,0,1/2]}",
            "2..",
        ),
        (
            "24i",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x],[1/2-y,1/2-x,z+1/2],[1/2-z,y+1/2,1/2-x],[x+1/2,1/2-z,1/2-y],[y+1/2,x+1/2,z+1/2],[z+1/2,y+1/2,x+1/2],[x+1/2,z+1/2,y+1/2],[y+1/2,1/2-x,1/2-z],[1/2-x,z+1/2,1/2-y],[1/2-z,1/2-y,x+1/2],[1/2-y,x+1/2,1/2-z],[1/2-x,1/2-z,y+1/2],[z+1/2,1/2-y,1/2-x]}",
            "1",
        ),
    ],
    "Td^5": [
        ("8a", "{[0,0,0],[1/2,1/2,1/2]}", "23."),
        ("8b", "{[1/4,1/4,1/4],[3/4,3/4,3/4]}", "23."),
        ("24c", "{[0,1/4,1/4],[1/2,1/4,1/4],[1/4,0,1/4],[1/4,1/2,1/4],[1/4,1/4,0],[1/4,1/4,1/2]}", "-4.."),
        ("24d", "{[1/4,1/2,1/2],[3/4,1/2,1/2],[1/2,1/4,1/2],[1/2,3/4,1/2],[1/2,1/2,1/4],[1/2,1/2,3/4]}", "-4.."),
        (
            "32e",
            "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x],[1/2-x,1/2-x,x+1/2],[1/2-x,x+1/2,1/2-x],[x+1/2,1/2-x,1/2-x],[x+1/2,x+1/2,x+1/2]}",
            ".3.",
        ),
        (
            "48f",
            "{[x,0,0],[-x,0,0],[0,x,0],[0,-x,0],[0,0,x],[0,0,-x],[1/2,1/2-x,1/2],[1/2,1/2,1/2-x],[x+1/2,1/2,1/2],[1/2,x+1/2,1/2],[1/2,1/2,x+1/2],[1/2-x,1/2,1/2]}",
            "2..",
        ),
        (
            "48g",
            "{[x,1/4,1/4],[1/2-x,1/4,1/4],[1/4,x,1/4],[1/4,1/2-x,1/4],[1/4,1/4,x],[1/4,1/4,1/2-x],[1/4,-x,1/4],[1/4,1/4,-x],[x+1/2,1/4,1/4],[1/4,x+1/2,1/4],[1/4,1/4,x+1/2],[-x,1/4,1/4]}",
            "2..",
        ),
        (
            "96h",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x],[1/2-y,1/2-x,z+1/2],[1/2-z,y+1/2,1/2-x],[x+1/2,1/2-z,1/2-y],[y+1/2,x+1/2,z+1/2],[z+1/2,y+1/2,x+1/2],[x+1/2,z+1/2,y+1/2],[y+1/2,1/2-x,1/2-z],[1/2-x,z+1/2,1/2-y],[1/2-z,1/2-y,x+1/2],[1/2-y,x+1/2,1/2-z],[1/2-x,1/2-z,y+1/2],[z+1/2,1/2-y,1/2-x]}",
            "1",
        ),
    ],
    "Td^6": [
        ("12a", "{[3/8,0,1/4],[1/8,0,3/4],[1/4,3/8,0],[3/4,1/8,0],[0,1/4,3/8],[0,3/4,1/8]}", "-4.."),
        ("12b", "{[3/8,1/2,3/4],[1/8,1/2,1/4],[3/4,3/8,1/2],[1/4,1/8,1/2],[1/2,3/4,3/8],[1/2,1/4,1/8]}", "-4.."),
        (
            "16c",
            "{[x,x,x],[-x,1/2-x,x],[x,-x,1/2-x],[1/2-x,x,-x],[3/4-x,1/4-x,x+1/4],[1/4-x,x+1/4,3/4-x],[x+1/4,3/4-x,1/4-x],[x+1/4,x+1/4,x+1/4]}",
            ".3.",
        ),
        (
            "24d",
            "{[x,0,1/4],[-x,1/2,1/4],[1/4,x,0],[1/4,-x,1/2],[0,1/4,x],[1/2,1/4,-x],[3/4,1/4-x,1/2],[1/2,3/4,1/4-x],[x+1/4,1/2,1/4],[1/4,x+1/4,1/2],[1/2,1/4,x+1/4],[1/4-x,1/2,3/4]}",
            "2..",
        ),
        (
            "48e",
            "{[x,y,z],[1/2-x,-y,z+1/2],[x+1/2,1/2-y,-z],[-x,y+1/2,1/2-z],[z,x,y],[1/2-z,-x,y+1/2],[z+1/2,1/2-x,-y],[-z,x+1/2,1/2-y],[y,z,x],[-y,z+1/2,1/2-x],[1/2-y,-z,x+1/2],[y+1/2,1/2-z,-x],[1/4-y,3/4-x,z+3/4],[3/4-z,y+3/4,1/4-x],[x+3/4,1/4-z,3/4-y],[y+1/4,x+1/4,z+1/4],[z+1/4,y+1/4,x+1/4],[x+1/4,z+1/4,y+1/4],[y+3/4,1/4-x,3/4-z],[3/4-x,z+3/4,1/4-y],[1/4-z,3/4-y,x+3/4],[3/4-y,x+3/4,1/4-z],[1/4-x,3/4-z,y+3/4],[z+3/4,1/4-y,3/4-x]}",
            "1",
        ),
    ],
    "Oh^1": [
        ("1a", "{[0,0,0]}", "m-3m"),
        ("1b", "{[1/2,1/2,1/2]}", "m-3m"),
        ("3c", "{[0,1/2,1/2],[1/2,0,1/2],[1/2,1/2,0]}", "4/mm.m"),
        ("3d", "{[1/2,0,0],[0,1/2,0],[0,0,1/2]}", "4/mm.m"),
        ("6e", "{[x,0,0],[-x,0,0],[0,x,0],[0,0,x],[0,-x,0],[0,0,-x]}", "4m.m"),
        ("6f", "{[x,1/2,1/2],[-x,1/2,1/2],[1/2,x,1/2],[1/2,1/2,x],[1/2,-x,1/2],[1/2,1/2,-x]}", "4m.m"),
        ("8g", "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x],[x,x,-x],[x,-x,x],[-x,x,x],[-x,-x,-x]}", ".3m"),
        (
            "12h",
            "{[x,1/2,0],[-x,1/2,0],[1/2,x,0],[0,1/2,x],[-x,0,1/2],[1/2,-x,0],[0,1/2,-x],[0,x,1/2],[0,-x,1/2],[1/2,0,x],[1/2,0,-x],[x,0,1/2]}",
            "mm2..",
        ),
        (
            "12i",
            "{[0,y,y],[0,-y,y],[0,-y,-y],[0,y,-y],[y,0,-y],[y,-y,0],[-y,0,-y],[-y,-y,0],[y,0,y],[-y,0,y],[y,y,0],[-y,y,0]}",
            "m.m2",
        ),
        (
            "12j",
            "{[1/2,y,y],[1/2,-y,y],[1/2,-y,-y],[1/2,y,-y],[y,1/2,-y],[y,-y,1/2],[-y,1/2,-y],[-y,-y,1/2],[y,1/2,y],[-y,1/2,y],[y,y,1/2],[-y,y,1/2]}",
            "m.m2",
        ),
        (
            "24k",
            "{[0,y,z],[0,-y,z],[0,-y,-z],[0,y,-z],[y,0,-z],[z,-y,0],[0,z,y],[-y,0,-z],[-z,-y,0],[0,-z,-y],[z,0,y],[-z,0,y],[z,0,-y],[-z,0,-y],[y,z,0],[-y,z,0],[-y,-z,0],[y,-z,0],[-y,0,z],[0,-z,y],[z,y,0],[y,0,z],[0,z,-y],[-z,y,0]}",
            "m..",
        ),
        (
            "24l",
            "{[1/2,y,z],[1/2,-y,z],[1/2,-y,-z],[1/2,y,-z],[y,1/2,-z],[z,-y,1/2],[1/2,z,y],[-y,1/2,-z],[-z,-y,1/2],[1/2,-z,-y],[z,1/2,y],[-z,1/2,y],[z,1/2,-y],[-z,1/2,-y],[y,z,1/2],[-y,z,1/2],[-y,-z,1/2],[y,-z,1/2],[-y,1/2,z],[1/2,-z,y],[z,y,1/2],[y,1/2,z],[1/2,z,-y],[-z,y,1/2]}",
            "m..",
        ),
        (
            "24m",
            "{[x,x,z],[-x,-x,z],[x,-x,-z],[-x,x,-z],[x,x,-z],[z,-x,x],[-x,z,x],[-x,-x,-z],[-z,-x,-x],[-x,-z,-x],[z,x,x],[-z,-x,x],[z,-x,-x],[-z,x,-x],[x,z,x],[-x,z,-x],[-x,-z,x],[x,-z,-x],[-x,x,z],[x,-z,x],[z,x,-x],[x,-x,z],[x,z,-x],[-z,x,x]}",
            "..m",
        ),
        (
            "48n",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[y,x,-z],[z,-y,x],[-x,z,y],[-y,-x,-z],[-z,-y,-x],[-x,-z,-y],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x],[-y,x,z],[x,-z,y],[z,y,-x],[y,-x,z],[x,z,-y],[-z,y,x],[-x,-y,-z],[x,y,-z],[-x,y,z],[x,-y,z],[-y,-x,z],[-z,y,-x],[x,-z,-y],[y,x,z],[z,y,x],[x,z,y],[-z,-x,-y],[z,x,-y],[-z,x,y],[z,-x,y],[-y,-z,-x],[y,-z,x],[y,z,-x],[-y,z,x],[y,-x,-z],[-x,z,-y],[-z,-y,x],[-y,x,-z],[-x,-z,y],[z,-y,-x]}",
            "1",
        ),
    ],
    "Oh^2": [
        ("2a", "{[1/4,1/4,1/4],[3/4,3/4,3/4]}", "432"),
        ("6b", "{[3/4,1/4,1/4],[1/4,3/4,1/4],[1/4,1/4,3/4],[1/4,3/4,3/4],[3/4,1/4,3/4],[3/4,3/4,1/4]}", "42.2"),
        ("8c", "{[0,0,0],[1/2,1/2,0],[0,1/2,1/2],[1/2,0,1/2],[0,0,1/2],[0,1/2,0],[1/2,0,0],[1/2,1/2,1/2]}", ".-3."),
        (
            "12d",
            "{[0,3/4,1/4],[1/2,3/4,1/4],[3/4,0,1/4],[1/4,3/4,0],[1/2,1/4,3/4],[3/4,1/2,1/4],[1/4,3/4,1/2],[1/4,0,3/4],[1/4,1/2,3/4],[3/4,1/4,0],[3/4,1/4,1/2],[0,1/4,3/4]}",
            "-4..",
        ),
        (
            "12e",
            "{[x,1/4,1/4],[1/2-x,1/4,1/4],[1/4,x,1/4],[1/4,1/4,x],[1/4,1/2-x,1/4],[1/4,1/4,1/2-x],[-x,3/4,3/4],[x+1/2,3/4,3/4],[3/4,-x,3/4],[3/4,3/4,-x],[3/4,x+1/2,3/4],[3/4,3/4,x+1/2]}",
            "4..",
        ),
        (
            "16f",
            "{[x,x,x],[1/2-x,1/2-x,x],[x,1/2-x,1/2-x],[1/2-x,x,1/2-x],[x,x,1/2-x],[x,1/2-x,x],[1/2-x,x,x],[1/2-x,1/2-x,1/2-x],[-x,-x,-x],[x+1/2,x+1/2,-x],[-x,x+1/2,x+1/2],[x+1/2,-x,x+1/2],[-x,-x,x+1/2],[-x,x+1/2,-x],[x+1/2,-x,-x],[x+1/2,x+1/2,x+1/2]}",
            ".3.",
        ),
        (
            "24g",
            "{[x,3/4,1/4],[1/2-x,3/4,1/4],[3/4,x,1/4],[1/4,3/4,x],[1/2-x,1/4,3/4],[3/4,1/2-x,1/4],[1/4,3/4,1/2-x],[1/4,x,3/4],[1/4,1/2-x,3/4],[3/4,1/4,x],[3/4,1/4,1/2-x],[x,1/4,3/4],[-x,1/4,3/4],[x+1/2,1/4,3/4],[1/4,-x,3/4],[3/4,1/4,-x],[x+1/2,3/4,1/4],[1/4,x+1/2,3/4],[3/4,1/4,x+1/2],[3/4,-x,1/4],[3/4,x+1/2,1/4],[1/4,3/4,-x],[1/4,3/4,x+1/2],[-x,3/4,1/4]}",
            "2..",
        ),
        (
            "24h",
            "{[1/4,y,y],[1/4,1/2-y,y],[1/4,1/2-y,1/2-y],[1/4,y,1/2-y],[y,1/4,1/2-y],[y,1/2-y,1/4],[1/2-y,1/4,1/2-y],[1/2-y,1/2-y,1/4],[y,1/4,y],[1/2-y,1/4,y],[y,y,1/4],[1/2-y,y,1/4],[3/4,-y,-y],[3/4,y+1/2,-y],[3/4,y+1/2,y+1/2],[3/4,-y,y+1/2],[-y,3/4,y+1/2],[-y,y+1/2,3/4],[y+1/2,3/4,y+1/2],[y+1/2,y+1/2,3/4],[-y,3/4,-y],[y+1/2,3/4,-y],[-y,-y,3/4],[y+1/2,-y,3/4]}",
            "..2",
        ),
        (
            "48i",
            "{[x,y,z],[1/2-x,1/2-y,z],[x,1/2-y,1/2-z],[1/2-x,y,1/2-z],[y,x,1/2-z],[z,1/2-y,x],[1/2-x,z,y],[1/2-y,1/2-x,1/2-z],[1/2-z,1/2-y,1/2-x],[1/2-x,1/2-z,1/2-y],[z,x,y],[1/2-z,1/2-x,y],[z,1/2-x,1/2-y],[1/2-z,x,1/2-y],[y,z,x],[1/2-y,z,1/2-x],[1/2-y,1/2-z,x],[y,1/2-z,1/2-x],[1/2-y,x,z],[x,1/2-z,y],[z,y,1/2-x],[y,1/2-x,z],[x,z,1/2-y],[1/2-z,y,x],[-x,-y,-z],[x+1/2,y+1/2,-z],[-x,y+1/2,z+1/2],[x+1/2,-y,z+1/2],[-y,-x,z+1/2],[-z,y+1/2,-x],[x+1/2,-z,-y],[y+1/2,x+1/2,z+1/2],[z+1/2,y+1/2,x+1/2],[x+1/2,z+1/2,y+1/2],[-z,-x,-y],[z+1/2,x+1/2,-y],[-z,x+1/2,y+1/2],[z+1/2,-x,y+1/2],[-y,-z,-x],[y+1/2,-z,x+1/2],[y+1/2,z+1/2,-x],[-y,z+1/2,x+1/2],[y+1/2,-x,-z],[-x,z+1/2,-y],[-z,-y,x+1/2],[-y,x+1/2,-z],[-x,-z,y+1/2],[z+1/2,-y,-x]}",
            "1",
        ),
    ],
    "Oh^3": [
        ("2a", "{[0,0,0],[1/2,1/2,1/2]}", "m-3."),
        ("6b", "{[0,1/2,1/2],[0,1/2,0],[0,0,1/2],[1/2,0,0],[1/2,0,1/2],[1/2,1/2,0]}", "mmm.."),
        ("6c", "{[1/4,0,1/2],[3/4,0,1/2],[1/2,3/4,0],[0,1/2,3/4],[1/2,1/4,0],[0,1/2,1/4]}", "-4m.2"),
        ("6d", "{[1/4,1/2,0],[3/4,1/2,0],[0,3/4,1/2],[1/2,0,3/4],[0,1/4,1/2],[1/2,0,1/4]}", "-4m.2"),
        (
            "8e",
            "{[1/4,1/4,1/4],[3/4,3/4,1/4],[1/4,3/4,3/4],[3/4,1/4,3/4],[3/4,3/4,3/4],[1/4,1/4,3/4],[3/4,1/4,1/4],[1/4,3/4,1/4]}",
            ".32",
        ),
        (
            "12f",
            "{[x,0,0],[-x,0,0],[1/2,x+1/2,1/2],[1/2,1/2,x+1/2],[1/2-x,1/2,1/2],[1/2,1/2-x,1/2],[1/2,1/2,1/2-x],[0,x,0],[0,-x,0],[0,0,x],[0,0,-x],[x+1/2,1/2,1/2]}",
            "mm2..",
        ),
        (
            "12g",
            "{[x,0,1/2],[-x,0,1/2],[1/2,x+1/2,0],[0,1/2,x+1/2],[1/2-x,0,1/2],[1/2,1/2-x,0],[0,1/2,1/2-x],[1/2,x,0],[1/2,-x,0],[0,1/2,x],[0,1/2,-x],[x+1/2,0,1/2]}",
            "mm2..",
        ),
        (
            "12h",
            "{[x,1/2,0],[-x,1/2,0],[0,x+1/2,1/2],[1/2,0,x+1/2],[1/2-x,1/2,0],[0,1/2-x,1/2],[1/2,0,1/2-x],[0,x,1/2],[0,-x,1/2],[1/2,0,x],[1/2,0,-x],[x+1/2,1/2,0]}",
            "mm2..",
        ),
        (
            "16i",
            "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x],[x+1/2,x+1/2,1/2-x],[x+1/2,1/2-x,x+1/2],[1/2-x,x+1/2,x+1/2],[1/2-x,1/2-x,1/2-x],[-x,-x,-x],[x,x,-x],[-x,x,x],[x,-x,x],[1/2-x,1/2-x,x+1/2],[1/2-x,x+1/2,1/2-x],[x+1/2,1/2-x,1/2-x],[x+1/2,x+1/2,x+1/2]}",
            ".3.",
        ),
        (
            "24j",
            "{[1/4,y,y+1/2],[3/4,-y,y+1/2],[1/4,-y,1/2-y],[3/4,y,1/2-y],[y+1/2,3/4,-y],[y,1/2-y,3/4],[1/2-y,1/4,-y],[-y,1/2-y,1/4],[y+1/2,1/4,y],[1/2-y,3/4,y],[y,y+1/2,1/4],[-y,y+1/2,3/4],[3/4,-y,1/2-y],[1/4,y,1/2-y],[3/4,y,y+1/2],[1/4,-y,y+1/2],[1/2-y,1/4,y],[-y,y+1/2,1/4],[y+1/2,3/4,y],[y,y+1/2,3/4],[1/2-y,3/4,-y],[y+1/2,1/4,-y],[-y,1/2-y,3/4],[y,1/2-y,1/4]}",
            "..2",
        ),
        (
            "24k",
            "{[0,y,z],[0,-y,z],[0,-y,-z],[0,y,-z],[y+1/2,1/2,1/2-z],[z+1/2,1/2-y,1/2],[1/2,z+1/2,y+1/2],[1/2-y,1/2,1/2-z],[1/2-z,1/2-y,1/2],[1/2,1/2-z,1/2-y],[z,0,y],[-z,0,y],[z,0,-y],[-z,0,-y],[y,z,0],[-y,z,0],[-y,-z,0],[y,-z,0],[1/2-y,1/2,z+1/2],[1/2,1/2-z,y+1/2],[z+1/2,y+1/2,1/2],[y+1/2,1/2,z+1/2],[1/2,z+1/2,1/2-y],[1/2-z,y+1/2,1/2]}",
            "m..",
        ),
        (
            "48l",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[y+1/2,x+1/2,1/2-z],[z+1/2,1/2-y,x+1/2],[1/2-x,z+1/2,y+1/2],[1/2-y,1/2-x,1/2-z],[1/2-z,1/2-y,1/2-x],[1/2-x,1/2-z,1/2-y],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x],[1/2-y,x+1/2,z+1/2],[x+1/2,1/2-z,y+1/2],[z+1/2,y+1/2,1/2-x],[y+1/2,1/2-x,z+1/2],[x+1/2,z+1/2,1/2-y],[1/2-z,y+1/2,x+1/2],[-x,-y,-z],[x,y,-z],[-x,y,z],[x,-y,z],[1/2-y,1/2-x,z+1/2],[1/2-z,y+1/2,1/2-x],[x+1/2,1/2-z,1/2-y],[y+1/2,x+1/2,z+1/2],[z+1/2,y+1/2,x+1/2],[x+1/2,z+1/2,y+1/2],[-z,-x,-y],[z,x,-y],[-z,x,y],[z,-x,y],[-y,-z,-x],[y,-z,x],[y,z,-x],[-y,z,x],[y+1/2,1/2-x,1/2-z],[1/2-x,z+1/2,1/2-y],[1/2-z,1/2-y,x+1/2],[1/2-y,x+1/2,1/2-z],[1/2-x,1/2-z,y+1/2],[z+1/2,1/2-y,1/2-x]}",
            "1",
        ),
    ],
    "Oh^4": [
        ("2a", "{[1/4,1/4,1/4],[3/4,3/4,3/4]}", "-43m"),
        ("4b", "{[0,0,0],[1/2,1/2,0],[0,1/2,1/2],[1/2,0,1/2]}", ".-3m"),
        ("4c", "{[1/2,1/2,1/2],[0,0,1/2],[1/2,0,0],[0,1/2,0]}", ".-3m"),
        ("6d", "{[1/4,3/4,3/4],[1/4,3/4,1/4],[1/4,1/4,3/4],[3/4,1/4,1/4],[3/4,1/4,3/4],[3/4,3/4,1/4]}", "-42.m"),
        (
            "8e",
            "{[x,x,x],[1/2-x,1/2-x,x],[x,1/2-x,1/2-x],[1/2-x,x,1/2-x],[x+1/2,x+1/2,-x],[x+1/2,-x,x+1/2],[-x,x+1/2,x+1/2],[-x,-x,-x]}",
            ".3m",
        ),
        (
            "12f",
            "{[1/2,1/4,3/4],[0,1/4,3/4],[3/4,0,1/4],[1/4,3/4,0],[3/4,1/2,1/4],[1/4,3/4,1/2],[1/2,3/4,1/4],[0,3/4,1/4],[1/4,0,3/4],[3/4,1/4,0],[1/4,1/2,3/4],[3/4,1/4,1/2]}",
            "2.22",
        ),
        (
            "12g",
            "{[x,1/4,1/4],[1/2-x,1/4,1/4],[3/4,x+1/2,3/4],[3/4,3/4,x+1/2],[-x,3/4,3/4],[3/4,-x,3/4],[3/4,3/4,-x],[1/4,x,1/4],[1/4,1/2-x,1/4],[1/4,1/4,x],[1/4,1/4,1/2-x],[x+1/2,3/4,3/4]}",
            "2.mm",
        ),
        (
            "24h",
            "{[x,1/4,3/4],[1/2-x,1/4,3/4],[3/4,x+1/2,1/4],[1/4,3/4,x+1/2],[-x,1/4,3/4],[3/4,-x,1/4],[1/4,3/4,-x],[3/4,x,1/4],[3/4,1/2-x,1/4],[1/4,3/4,x],[1/4,3/4,1/2-x],[x+1/2,1/4,3/4],[-x,3/4,1/4],[x+1/2,3/4,1/4],[1/4,1/2-x,3/4],[3/4,1/4,1/2-x],[x,3/4,1/4],[1/4,x,3/4],[3/4,1/4,x],[1/4,-x,3/4],[1/4,x+1/2,3/4],[3/4,1/4,-x],[3/4,1/4,x+1/2],[1/2-x,3/4,1/4]}",
            "2..",
        ),
        (
            "24i",
            "{[1/2,y,y+1/2],[0,1/2-y,y+1/2],[1/2,1/2-y,-y],[0,y,-y],[y+1/2,0,1/2-y],[y,-y,0],[-y,1/2,1/2-y],[1/2-y,-y,1/2],[y+1/2,1/2,y],[-y,0,y],[y,y+1/2,1/2],[1/2-y,y+1/2,0],[1/2,-y,1/2-y],[0,y+1/2,1/2-y],[1/2,y+1/2,y],[0,-y,y],[1/2-y,0,y+1/2],[-y,y,0],[y,1/2,y+1/2],[y+1/2,y,1/2],[1/2-y,1/2,-y],[y,0,-y],[-y,1/2-y,1/2],[y+1/2,1/2-y,0]}",
            "..2",
        ),
        (
            "24j",
            "{[1/2,y,-y],[0,1/2-y,-y],[1/2,1/2-y,y+1/2],[0,y,y+1/2],[y+1/2,0,y],[1/2-y,-y,0],[-y,1/2,y],[y,-y,1/2],[-y,0,1/2-y],[y+1/2,1/2,1/2-y],[1/2-y,y+1/2,1/2],[y,y+1/2,0],[1/2,-y,y],[0,y+1/2,y],[1/2,y+1/2,1/2-y],[0,-y,1/2-y],[1/2-y,0,-y],[y+1/2,y,0],[y,1/2,-y],[-y,y,1/2],[y,0,y+1/2],[1/2-y,1/2,y+1/2],[y+1/2,1/2-y,1/2],[-y,1/2-y,0]}",
            "..2",
        ),
        (
            "24k",
            "{[x,x,z],[1/2-x,1/2-x,z],[x,1/2-x,1/2-z],[1/2-x,x,1/2-z],[x+1/2,x+1/2,-z],[z+1/2,-x,x+1/2],[-x,z+1/2,x+1/2],[-x,-x,-z],[-z,-x,-x],[-x,-z,-x],[z,x,x],[1/2-z,1/2-x,x],[z,1/2-x,1/2-x],[1/2-z,x,1/2-x],[x,z,x],[1/2-x,z,1/2-x],[1/2-x,1/2-z,x],[x,1/2-z,1/2-x],[-x,x+1/2,z+1/2],[x+1/2,-z,x+1/2],[z+1/2,x+1/2,-x],[x+1/2,-x,z+1/2],[x+1/2,z+1/2,-x],[-z,x+1/2,x+1/2]}",
            "..m",
        ),
        (
            "48l",
            "{[x,y,z],[1/2-x,1/2-y,z],[x,1/2-y,1/2-z],[1/2-x,y,1/2-z],[y+1/2,x+1/2,-z],[z+1/2,-y,x+1/2],[-x,z+1/2,y+1/2],[-y,-x,-z],[-z,-y,-x],[-x,-z,-y],[z,x,y],[1/2-z,1/2-x,y],[z,1/2-x,1/2-y],[1/2-z,x,1/2-y],[y,z,x],[1/2-y,z,1/2-x],[1/2-y,1/2-z,x],[y,1/2-z,1/2-x],[-y,x+1/2,z+1/2],[x+1/2,-z,y+1/2],[z+1/2,y+1/2,-x],[y+1/2,-x,z+1/2],[x+1/2,z+1/2,-y],[-z,y+1/2,x+1/2],[-x,-y,-z],[x+1/2,y+1/2,-z],[-x,y+1/2,z+1/2],[x+1/2,-y,z+1/2],[1/2-y,1/2-x,z],[1/2-z,y,1/2-x],[x,1/2-z,1/2-y],[y,x,z],[z,y,x],[x,z,y],[-z,-x,-y],[z+1/2,x+1/2,-y],[-z,x+1/2,y+1/2],[z+1/2,-x,y+1/2],[-y,-z,-x],[y+1/2,-z,x+1/2],[y+1/2,z+1/2,-x],[-y,z+1/2,x+1/2],[y,1/2-x,1/2-z],[1/2-x,z,1/2-y],[1/2-z,1/2-y,x],[1/2-y,x,1/2-z],[1/2-x,1/2-z,y],[z,1/2-y,1/2-x]}",
            "1",
        ),
    ],
    "Oh^5": [
        ("4a", "{[0,0,0]}", "m-3m"),
        ("4b", "{[1/2,1/2,1/2]}", "m-3m"),
        ("8c", "{[1/4,1/4,1/4],[3/4,3/4,3/4]}", "-43m"),
        ("24d", "{[0,1/4,1/4],[1/2,1/4,1/4],[1/4,1/2,1/4],[1/4,1/4,1/2],[1/4,0,1/4],[1/4,1/4,0]}", "m.mm"),
        ("24e", "{[x,0,0],[-x,0,0],[0,x,0],[0,0,x],[0,-x,0],[0,0,-x]}", "4m.m"),
        ("32f", "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x],[x,x,-x],[x,-x,x],[-x,x,x],[-x,-x,-x]}", ".3m"),
        (
            "48g",
            "{[x,1/4,1/4],[1/2-x,1/4,1/4],[1/4,x+1/2,1/4],[1/4,1/4,x+1/2],[-x,1/4,1/4],[1/4,-x,1/4],[1/4,1/4,-x],[1/4,x,1/4],[1/4,1/2-x,1/4],[1/4,1/4,x],[1/4,1/4,1/2-x],[x+1/2,1/4,1/4]}",
            "2.mm",
        ),
        (
            "48h",
            "{[0,y,y],[0,-y,y],[0,-y,-y],[0,y,-y],[y,0,-y],[y,-y,0],[-y,0,-y],[-y,-y,0],[y,0,y],[-y,0,y],[y,y,0],[-y,y,0]}",
            "m.m2",
        ),
        (
            "48i",
            "{[1/2,y+1/2,y+1/2],[1/2,1/2-y,y+1/2],[1/2,1/2-y,1/2-y],[1/2,y+1/2,1/2-y],[y+1/2,1/2,1/2-y],[y+1/2,1/2-y,1/2],[1/2-y,1/2,1/2-y],[1/2-y,1/2-y,1/2],[y+1/2,1/2,y+1/2],[1/2-y,1/2,y+1/2],[y+1/2,y+1/2,1/2],[1/2-y,y+1/2,1/2]}",
            "m.m2",
        ),
        (
            "96j",
            "{[0,y,z],[0,-y,z],[0,-y,-z],[0,y,-z],[y,0,-z],[z,-y,0],[0,z,y],[-y,0,-z],[-z,-y,0],[0,-z,-y],[z,0,y],[-z,0,y],[z,0,-y],[-z,0,-y],[y,z,0],[-y,z,0],[-y,-z,0],[y,-z,0],[-y,0,z],[0,-z,y],[z,y,0],[y,0,z],[0,z,-y],[-z,y,0]}",
            "m..",
        ),
        (
            "96k",
            "{[x,x,z],[-x,-x,z],[x,-x,-z],[-x,x,-z],[x,x,-z],[z,-x,x],[-x,z,x],[-x,-x,-z],[-z,-x,-x],[-x,-z,-x],[z,x,x],[-z,-x,x],[z,-x,-x],[-z,x,-x],[x,z,x],[-x,z,-x],[-x,-z,x],[x,-z,-x],[-x,x,z],[x,-z,x],[z,x,-x],[x,-x,z],[x,z,-x],[-z,x,x]}",
            "..m",
        ),
        (
            "192l",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[y,x,-z],[z,-y,x],[-x,z,y],[-y,-x,-z],[-z,-y,-x],[-x,-z,-y],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x],[-y,x,z],[x,-z,y],[z,y,-x],[y,-x,z],[x,z,-y],[-z,y,x],[-x,-y,-z],[x,y,-z],[-x,y,z],[x,-y,z],[-y,-x,z],[-z,y,-x],[x,-z,-y],[y,x,z],[z,y,x],[x,z,y],[-z,-x,-y],[z,x,-y],[-z,x,y],[z,-x,y],[-y,-z,-x],[y,-z,x],[y,z,-x],[-y,z,x],[y,-x,-z],[-x,z,-y],[-z,-y,x],[-y,x,-z],[-x,-z,y],[z,-y,-x]}",
            "1",
        ),
    ],
    "Oh^6": [
        ("8a", "{[1/4,1/4,1/4],[3/4,3/4,3/4]}", "432"),
        ("8b", "{[0,0,0],[1/2,1/2,1/2]}", "m-3."),
        ("24c", "{[1/4,1/2,1/2],[3/4,1/2,1/2],[1/2,3/4,1/2],[1/2,1/2,3/4],[1/2,1/4,1/2],[1/2,1/2,1/4]}", "-4m.2"),
        ("24d", "{[0,1/4,1/4],[1/2,1/4,1/4],[1/4,0,1/4],[1/4,1/4,0],[1/4,1/2,1/4],[1/4,1/4,1/2]}", "4/m.."),
        (
            "48e",
            "{[x,0,0],[-x,0,0],[1/2,x+1/2,1/2],[1/2,1/2,x+1/2],[1/2-x,1/2,1/2],[1/2,1/2-x,1/2],[1/2,1/2,1/2-x],[0,x,0],[0,-x,0],[0,0,x],[0,0,-x],[x+1/2,1/2,1/2]}",
            "mm2..",
        ),
        (
            "48f",
            "{[x,1/4,1/4],[1/2-x,1/4,1/4],[1/4,x,1/4],[1/4,1/4,x],[1/4,1/2-x,1/4],[1/4,1/4,1/2-x],[-x,1/4,1/4],[x+1/2,1/4,1/4],[1/4,-x,1/4],[1/4,1/4,-x],[1/4,x+1/2,1/4],[1/4,1/4,x+1/2]}",
            "4..",
        ),
        (
            "64g",
            "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x],[x+1/2,x+1/2,1/2-x],[x+1/2,1/2-x,x+1/2],[1/2-x,x+1/2,x+1/2],[1/2-x,1/2-x,1/2-x],[-x,-x,-x],[x,x,-x],[-x,x,x],[x,-x,x],[1/2-x,1/2-x,x+1/2],[1/2-x,x+1/2,1/2-x],[x+1/2,1/2-x,1/2-x],[x+1/2,x+1/2,x+1/2]}",
            ".3.",
        ),
        (
            "96h",
            "{[1/4,y+1/2,y+1/2],[3/4,1/2-y,y+1/2],[1/4,1/2-y,1/2-y],[3/4,y+1/2,1/2-y],[y+1/2,3/4,1/2-y],[y+1/2,1/2-y,3/4],[1/2-y,1/4,1/2-y],[1/2-y,1/2-y,1/4],[y+1/2,1/4,y+1/2],[1/2-y,3/4,y+1/2],[y+1/2,y+1/2,1/4],[1/2-y,y+1/2,3/4],[3/4,1/2-y,1/2-y],[1/4,y+1/2,1/2-y],[3/4,y+1/2,y+1/2],[1/4,1/2-y,y+1/2],[1/2-y,1/4,y+1/2],[1/2-y,y+1/2,1/4],[y+1/2,3/4,y+1/2],[y+1/2,y+1/2,3/4],[1/2-y,3/4,1/2-y],[y+1/2,1/4,1/2-y],[1/2-y,1/2-y,3/4],[y+1/2,1/2-y,1/4]}",
            "..2",
        ),
        (
            "96i",
            "{[0,y,z],[0,-y,z],[0,-y,-z],[0,y,-z],[y+1/2,1/2,1/2-z],[z+1/2,1/2-y,1/2],[1/2,z+1/2,y+1/2],[1/2-y,1/2,1/2-z],[1/2-z,1/2-y,1/2],[1/2,1/2-z,1/2-y],[z,0,y],[-z,0,y],[z,0,-y],[-z,0,-y],[y,z,0],[-y,z,0],[-y,-z,0],[y,-z,0],[1/2-y,1/2,z+1/2],[1/2,1/2-z,y+1/2],[z+1/2,y+1/2,1/2],[y+1/2,1/2,z+1/2],[1/2,z+1/2,1/2-y],[1/2-z,y+1/2,1/2]}",
            "m..",
        ),
        (
            "192j",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[y+1/2,x+1/2,1/2-z],[z+1/2,1/2-y,x+1/2],[1/2-x,z+1/2,y+1/2],[1/2-y,1/2-x,1/2-z],[1/2-z,1/2-y,1/2-x],[1/2-x,1/2-z,1/2-y],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x],[1/2-y,x+1/2,z+1/2],[x+1/2,1/2-z,y+1/2],[z+1/2,y+1/2,1/2-x],[y+1/2,1/2-x,z+1/2],[x+1/2,z+1/2,1/2-y],[1/2-z,y+1/2,x+1/2],[-x,-y,-z],[x,y,-z],[-x,y,z],[x,-y,z],[1/2-y,1/2-x,z+1/2],[1/2-z,y+1/2,1/2-x],[x+1/2,1/2-z,1/2-y],[y+1/2,x+1/2,z+1/2],[z+1/2,y+1/2,x+1/2],[x+1/2,z+1/2,y+1/2],[-z,-x,-y],[z,x,-y],[-z,x,y],[z,-x,y],[-y,-z,-x],[y,-z,x],[y,z,-x],[-y,z,x],[y+1/2,1/2-x,1/2-z],[1/2-x,z+1/2,1/2-y],[1/2-z,1/2-y,x+1/2],[1/2-y,x+1/2,1/2-z],[1/2-x,1/2-z,y+1/2],[z+1/2,1/2-y,1/2-x]}",
            "1",
        ),
    ],
    "Oh^7": [
        ("8a", "{[1/8,1/8,1/8],[7/8,7/8,7/8]}", "-43m"),
        ("8b", "{[3/8,3/8,3/8],[5/8,5/8,5/8]}", "-43m"),
        ("16c", "{[0,0,0],[1/4,1/4,0],[0,1/4,1/4],[1/4,0,1/4]}", ".-3m"),
        ("16d", "{[1/2,1/2,1/2],[1/4,1/4,1/2],[1/2,1/4,1/4],[1/4,1/2,1/4]}", ".-3m"),
        (
            "32e",
            "{[x,x,x],[1/4-x,1/4-x,x],[x,1/4-x,1/4-x],[1/4-x,x,1/4-x],[x+1/4,x+1/4,-x],[x+1/4,-x,x+1/4],[-x,x+1/4,x+1/4],[-x,-x,-x]}",
            ".3m",
        ),
        (
            "48f",
            "{[x,1/8,1/8],[1/4-x,1/8,1/8],[3/8,x+3/4,3/8],[3/8,3/8,x+3/4],[-x,3/8,3/8],[3/8,-x,3/8],[3/8,3/8,-x],[1/8,x,1/8],[1/8,1/4-x,1/8],[1/8,1/8,x],[1/8,1/8,1/4-x],[x+3/4,3/8,3/8]}",
            "2.mm",
        ),
        (
            "96g",
            "{[x,x,z],[1/4-x,1/4-x,z],[x,1/4-x,1/4-z],[1/4-x,x,1/4-z],[x+1/4,x+1/4,-z],[z+1/4,-x,x+1/4],[-x,z+1/4,x+1/4],[-x,-x,-z],[-z,-x,-x],[-x,-z,-x],[z,x,x],[1/4-z,1/4-x,x],[z,1/4-x,1/4-x],[1/4-z,x,1/4-x],[x,z,x],[1/4-x,z,1/4-x],[1/4-x,1/4-z,x],[x,1/4-z,1/4-x],[-x,x+1/4,z+1/4],[x+1/4,-z,x+1/4],[z+1/4,x+1/4,-x],[x+1/4,-x,z+1/4],[x+1/4,z+1/4,-x],[-z,x+1/4,x+1/4]}",
            "..m",
        ),
        (
            "96h",
            "{[0,y,-y],[1/4,1/4-y,-y],[0,1/4-y,y+1/4],[1/4,y,y+1/4],[y+1/4,1/4,y],[1/4-y,-y,1/4],[-y,0,y],[y,-y,0],[-y,1/4,1/4-y],[y+1/4,0,1/4-y],[1/4-y,y+1/4,0],[y,y+1/4,1/4],[0,-y,y],[1/4,y+1/4,y],[0,y+1/4,1/4-y],[1/4,-y,1/4-y],[1/4-y,1/4,-y],[y+1/4,y,1/4],[y,0,-y],[-y,y,0],[y,1/4,y+1/4],[1/4-y,0,y+1/4],[y+1/4,1/4-y,0],[-y,1/4-y,1/4]}",
            "..2",
        ),
        (
            "192i",
            "{[x,y,z],[3/4-x,1/4-y,z+1/2],[x+1/2,3/4-y,1/4-z],[1/4-x,y+1/2,3/4-z],[y+3/4,x+1/4,1/2-z],[z+1/4,1/2-y,x+3/4],[1/2-x,z+3/4,y+1/4],[-y,-x,-z],[-z,-y,-x],[-x,-z,-y],[z,x,y],[3/4-z,1/4-x,y+1/2],[z+1/2,3/4-x,1/4-y],[1/4-z,x+1/2,3/4-y],[y,z,x],[1/4-y,z+1/2,3/4-x],[3/4-y,1/4-z,x+1/2],[y+1/2,3/4-z,1/4-x],[1/2-y,x+3/4,z+1/4],[x+1/4,1/2-z,y+3/4],[z+3/4,y+1/4,1/2-x],[y+1/4,1/2-x,z+3/4],[x+3/4,z+1/4,1/2-y],[1/2-z,y+3/4,x+1/4],[-x,-y,-z],[x+1/4,y+3/4,1/2-z],[1/2-x,y+1/4,z+3/4],[x+3/4,1/2-y,z+1/4],[1/4-y,3/4-x,z+1/2],[3/4-z,y+1/2,1/4-x],[x+1/2,1/4-z,3/4-y],[y,x,z],[z,y,x],[x,z,y],[-z,-x,-y],[z+1/4,x+3/4,1/2-y],[1/2-z,x+1/4,y+3/4],[z+3/4,1/2-x,y+1/4],[-y,-z,-x],[y+3/4,1/2-z,x+1/4],[y+1/4,z+3/4,1/2-x],[1/2-y,z+1/4,x+3/4],[y+1/2,1/4-x,3/4-z],[3/4-x,z+1/2,1/4-y],[1/4-z,3/4-y,x+1/2],[3/4-y,x+1/2,1/4-z],[1/4-x,3/4-z,y+1/2],[z+1/2,1/4-y,3/4-x]}",
            "1",
        ),
    ],
    "Oh^8": [
        ("16a", "{[1/8,1/8,1/8],[3/8,3/8,3/8],[7/8,7/8,7/8],[5/8,5/8,5/8]}", "23."),
        (
            "32b",
            "{[1/4,1/4,1/4],[1/2,1/2,1/4],[1/4,1/2,1/2],[1/2,1/4,1/2],[3/4,3/4,3/4],[1/2,1/2,3/4],[3/4,1/2,1/2],[1/2,3/4,1/2]}",
            ".32",
        ),
        ("32c", "{[0,0,0],[1/4,1/4,0],[0,1/4,1/4],[1/4,0,1/4],[1/4,1/4,1/2],[1/4,1/2,1/4],[1/2,1/4,1/4],[1/2,1/2,1/2]}", ""),
        (
            "48d",
            "{[7/8,5/8,5/8],[3/8,5/8,5/8],[3/8,1/8,3/8],[3/8,3/8,1/8],[5/8,3/8,3/8],[3/8,5/8,3/8],[3/8,3/8,5/8],[5/8,7/8,5/8],[5/8,3/8,5/8],[5/8,5/8,7/8],[5/8,5/8,3/8],[1/8,3/8,3/8]}",
            ".-3.",
        ),
        (
            "64e",
            "{[x,x,x],[1/4-x,1/4-x,x],[x,1/4-x,1/4-x],[1/4-x,x,1/4-x],[x+1/4,x+1/4,1/2-x],[x+1/4,1/2-x,x+1/4],[1/2-x,x+1/4,x+1/4],[1/2-x,1/2-x,1/2-x],[-x,-x,-x],[x+1/4,x+1/4,-x],[-x,x+1/4,x+1/4],[x+1/4,-x,x+1/4],[1/4-x,1/4-x,x+1/2],[1/4-x,x+1/2,1/4-x],[x+1/2,1/4-x,1/4-x],[x+1/2,x+1/2,x+1/2]}",
            ".3.",
        ),
        (
            "96f",
            "{[x,1/8,1/8],[1/4-x,1/8,1/8],[3/8,x+1/4,3/8],[3/8,3/8,x+1/4],[1/2-x,3/8,3/8],[3/8,1/2-x,3/8],[3/8,3/8,1/2-x],[1/8,x,1/8],[1/8,1/4-x,1/8],[1/8,1/8,x],[1/8,1/8,1/4-x],[x+1/4,3/8,3/8],[-x,3/8,3/8],[x+3/4,3/8,3/8],[5/8,3/4-x,5/8],[5/8,5/8,3/4-x],[x+1/2,5/8,5/8],[5/8,x+1/2,5/8],[5/8,5/8,x+1/2],[3/8,-x,3/8],[3/8,x+3/4,3/8],[3/8,3/8,-x],[3/8,3/8,x+3/4],[3/4-x,5/8,5/8]}",
            "2..",
        ),
        (
            "96g",
            "{[1/4,y+1/2,1/2-y],[1/2,1/4-y,1/2-y],[1/4,1/4-y,y+1/4],[1/2,y+1/2,y+1/4],[y+1/4,1/2,y+1/2],[1/4-y,1/2-y,1/2],[1/2-y,1/4,y+1/2],[y+1/2,1/2-y,1/4],[1/2-y,1/2,1/4-y],[y+1/4,1/4,1/4-y],[1/4-y,y+1/4,1/4],[y+1/2,y+1/4,1/2],[3/4,1/2-y,y+1/2],[1/2,y+3/4,y+1/2],[3/4,y+3/4,3/4-y],[1/2,1/2-y,3/4-y],[3/4-y,1/2,1/2-y],[y+3/4,y+1/2,1/2],[y+1/2,3/4,1/2-y],[1/2-y,y+1/2,3/4],[y+1/2,1/2,y+3/4],[3/4-y,3/4,y+3/4],[y+3/4,3/4-y,3/4],[1/2-y,3/4-y,1/2]}",
            "..2",
        ),
        (
            "192h",
            "{[x,y,z],[1/4-x,3/4-y,z+1/2],[x+1/2,1/4-y,3/4-z],[3/4-x,y+1/2,1/4-z],[y+3/4,x+1/4,-z],[z+1/4,-y,x+3/4],[-x,z+3/4,y+1/4],[1/2-y,1/2-x,1/2-z],[1/2-z,1/2-y,1/2-x],[1/2-x,1/2-z,1/2-y],[z,x,y],[1/4-z,3/4-x,y+1/2],[z+1/2,1/4-x,3/4-y],[3/4-z,x+1/2,1/4-y],[y,z,x],[3/4-y,z+1/2,1/4-x],[1/4-y,3/4-z,x+1/2],[y+1/2,1/4-z,3/4-x],[-y,x+3/4,z+1/4],[x+1/4,-z,y+3/4],[z+3/4,y+1/4,-x],[y+1/4,-x,z+3/4],[x+3/4,z+1/4,-y],[-z,y+3/4,x+1/4],[-x,-y,-z],[x+3/4,y+1/4,1/2-z],[1/2-x,y+3/4,z+1/4],[x+1/4,1/2-y,z+3/4],[1/4-y,3/4-x,z],[3/4-z,y,1/4-x],[x,1/4-z,3/4-y],[y+1/2,x+1/2,z+1/2],[z+1/2,y+1/2,x+1/2],[x+1/2,z+1/2,y+1/2],[-z,-x,-y],[z+3/4,x+1/4,1/2-y],[1/2-z,x+3/4,y+1/4],[z+1/4,1/2-x,y+3/4],[-y,-z,-x],[y+1/4,1/2-z,x+3/4],[y+3/4,z+1/4,1/2-x],[1/2-y,z+3/4,x+1/4],[y,1/4-x,3/4-z],[3/4-x,z,1/4-y],[1/4-z,3/4-y,x],[3/4-y,x,1/4-z],[1/4-x,3/4-z,y],[z,1/4-y,3/4-x]}",
            "1",
        ),
    ],
    "Oh^9": [
        ("2a", "{[0,0,0]}", "m-3m"),
        ("6b", "{[1/2,0,0],[0,1/2,0],[0,0,1/2]}", "4/mm.m"),
        ("8c", "{[1/4,1/4,1/4],[1/4,1/4,3/4],[3/4,1/4,1/4],[1/4,3/4,1/4]}", ".-3m"),
        ("12d", "{[1/4,0,1/2],[1/4,1/2,0],[0,1/4,1/2],[1/2,0,1/4],[1/2,1/4,0],[0,1/2,1/4]}", "-4m.2"),
        ("12e", "{[x,0,0],[-x,0,0],[0,x,0],[0,0,x],[0,-x,0],[0,0,-x]}", "4m.m"),
        ("16f", "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x],[x,x,-x],[x,-x,x],[-x,x,x],[-x,-x,-x]}", ".3m"),
        (
            "24g",
            "{[x,0,1/2],[-x,0,1/2],[0,x,1/2],[1/2,0,x],[-x,1/2,0],[0,-x,1/2],[1/2,0,-x],[1/2,x,0],[1/2,-x,0],[0,1/2,x],[0,1/2,-x],[x,1/2,0]}",
            "mm2..",
        ),
        (
            "24h",
            "{[0,y,y],[0,-y,y],[0,-y,-y],[0,y,-y],[y,0,-y],[y,-y,0],[-y,0,-y],[-y,-y,0],[y,0,y],[-y,0,y],[y,y,0],[-y,y,0]}",
            "m.m2",
        ),
        (
            "48i",
            "{[1/4,y,1/2-y],[1/4,1/2-y,-y],[1/4,-y,y+1/2],[1/4,y+1/2,y],[y,1/4,y+1/2],[1/2-y,-y,1/4],[1/2-y,1/4,y],[y,1/2-y,1/4],[-y,1/4,1/2-y],[y+1/2,1/4,-y],[-y,y+1/2,1/4],[y+1/2,y,1/4],[1/4,1/2-y,y],[1/4,y,y+1/2],[1/4,y+1/2,-y],[1/4,-y,1/2-y],[1/2-y,1/4,-y],[y,y+1/2,1/4],[y,1/4,1/2-y],[1/2-y,y,1/4],[y+1/2,1/4,y],[-y,1/4,y+1/2],[y+1/2,-y,1/4],[-y,1/2-y,1/4]}",
            "..2",
        ),
        (
            "48j",
            "{[0,y,z],[0,-y,z],[0,-y,-z],[0,y,-z],[y,0,-z],[z,-y,0],[0,z,y],[-y,0,-z],[-z,-y,0],[0,-z,-y],[z,0,y],[-z,0,y],[z,0,-y],[-z,0,-y],[y,z,0],[-y,z,0],[-y,-z,0],[y,-z,0],[-y,0,z],[0,-z,y],[z,y,0],[y,0,z],[0,z,-y],[-z,y,0]}",
            "m..",
        ),
        (
            "48k",
            "{[x,x,z],[-x,-x,z],[x,-x,-z],[-x,x,-z],[x,x,-z],[z,-x,x],[-x,z,x],[-x,-x,-z],[-z,-x,-x],[-x,-z,-x],[z,x,x],[-z,-x,x],[z,-x,-x],[-z,x,-x],[x,z,x],[-x,z,-x],[-x,-z,x],[x,-z,-x],[-x,x,z],[x,-z,x],[z,x,-x],[x,-x,z],[x,z,-x],[-z,x,x]}",
            "..m",
        ),
        (
            "96l",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[y,x,-z],[z,-y,x],[-x,z,y],[-y,-x,-z],[-z,-y,-x],[-x,-z,-y],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x],[-y,x,z],[x,-z,y],[z,y,-x],[y,-x,z],[x,z,-y],[-z,y,x],[-x,-y,-z],[x,y,-z],[-x,y,z],[x,-y,z],[-y,-x,z],[-z,y,-x],[x,-z,-y],[y,x,z],[z,y,x],[x,z,y],[-z,-x,-y],[z,x,-y],[-z,x,y],[z,-x,y],[-y,-z,-x],[y,-z,x],[y,z,-x],[-y,z,x],[y,-x,-z],[-x,z,-y],[-z,-y,x],[-y,x,-z],[-x,-z,y],[z,-y,-x]}",
            "1",
        ),
    ],
    "Oh^10": [
        ("16a", "{[0,0,0],[0,1/2,0],[0,0,1/2],[1/2,0,0],[3/4,1/4,1/4],[1/4,1/4,3/4],[1/4,3/4,1/4],[1/4,1/4,1/4]}", ".-3."),
        (
            "16b",
            "{[1/8,1/8,1/8],[7/8,3/8,1/8],[1/8,7/8,3/8],[3/8,1/8,7/8],[3/8,3/8,3/8],[1/8,5/8,7/8],[7/8,1/8,5/8],[5/8,7/8,1/8]}",
            ".32",
        ),
        (
            "24c",
            "{[1/8,0,1/4],[7/8,1/2,1/4],[1/4,7/8,1/2],[1/2,1/4,7/8],[1/4,1/8,0],[0,1/4,1/8],[3/8,1/2,1/4],[5/8,0,1/4],[1/4,5/8,0],[0,1/4,5/8],[1/4,3/8,1/2],[1/2,1/4,3/8]}",
            "2.22",
        ),
        (
            "24d",
            "{[3/8,0,1/4],[1/8,0,3/4],[1/4,1/8,1/2],[1/2,1/4,1/8],[3/8,1/2,3/4],[3/4,3/8,1/2],[1/2,3/4,3/8],[1/4,3/8,0],[3/4,1/8,0],[0,1/4,3/8],[0,3/4,1/8],[1/8,1/2,1/4]}",
            "-4..",
        ),
        (
            "32e",
            "{[x,x,x],[-x,1/2-x,x],[x,-x,1/2-x],[1/2-x,x,-x],[x+3/4,x+1/4,1/4-x],[x+1/4,1/4-x,x+3/4],[1/4-x,x+3/4,x+1/4],[1/4-x,1/4-x,1/4-x],[-x,-x,-x],[x,x+1/2,-x],[-x,x,x+1/2],[x+1/2,-x,x],[3/4-x,1/4-x,x+1/4],[1/4-x,x+1/4,3/4-x],[x+1/4,3/4-x,1/4-x],[x+1/4,x+1/4,x+1/4]}",
            ".3.",
        ),
        (
            "48f",
            "{[x,0,1/4],[-x,1/2,1/4],[1/4,x+3/4,1/2],[1/2,1/4,x+3/4],[1/4-x,0,1/4],[1/4,1/4-x,0],[0,1/4,1/4-x],[1/4,x,0],[1/4,-x,1/2],[0,1/4,x],[1/2,1/4,-x],[x+3/4,1/2,1/4],[-x,0,3/4],[x+1/2,0,1/4],[3/4,1/4-x,1/2],[1/2,3/4,1/4-x],[x+1/4,1/2,1/4],[1/4,x+1/4,1/2],[1/2,1/4,x+1/4],[3/4,-x,0],[1/4,x+1/2,0],[0,3/4,-x],[0,1/4,x+1/2],[1/4-x,1/2,3/4]}",
            "2..",
        ),
        (
            "48g",
            "{[1/8,y,1/4-y],[7/8,1/2-y,1/4-y],[1/8,-y,y+1/4],[7/8,y+1/2,y+1/4],[y+1/4,7/8,y+1/2],[1/2-y,1/4-y,7/8],[1/4-y,1/8,y],[y,1/4-y,1/8],[1/4-y,7/8,1/2-y],[y+1/4,1/8,-y],[-y,y+1/4,1/8],[y+1/2,y+1/4,7/8],[3/8,1/2-y,y+1/4],[5/8,y,y+1/4],[3/8,y+1/2,1/4-y],[5/8,-y,1/4-y],[1/4-y,5/8,-y],[y,y+1/4,5/8],[y+1/4,3/8,1/2-y],[1/2-y,y+1/4,3/8],[y+1/4,5/8,y],[1/4-y,3/8,y+1/2],[y+1/2,1/4-y,3/8],[-y,1/4-y,5/8]}",
            "..2",
        ),
        (
            "96h",
            "{[x,y,z],[1/2-x,-y,z+1/2],[x+1/2,1/2-y,-z],[-x,y+1/2,1/2-z],[y+3/4,x+1/4,1/4-z],[z+1/4,1/4-y,x+3/4],[1/4-x,z+3/4,y+1/4],[3/4-y,3/4-x,3/4-z],[3/4-z,3/4-y,3/4-x],[3/4-x,3/4-z,3/4-y],[z,x,y],[1/2-z,-x,y+1/2],[z+1/2,1/2-x,-y],[-z,x+1/2,1/2-y],[y,z,x],[-y,z+1/2,1/2-x],[1/2-y,-z,x+1/2],[y+1/2,1/2-z,-x],[1/4-y,x+3/4,z+1/4],[x+1/4,1/4-z,y+3/4],[z+3/4,y+1/4,1/4-x],[y+1/4,1/4-x,z+3/4],[x+3/4,z+1/4,1/4-y],[1/4-z,y+3/4,x+1/4],[-x,-y,-z],[x+1/2,y,1/2-z],[1/2-x,y+1/2,z],[x,1/2-y,z+1/2],[1/4-y,3/4-x,z+3/4],[3/4-z,y+3/4,1/4-x],[x+3/4,1/4-z,3/4-y],[y+1/4,x+1/4,z+1/4],[z+1/4,y+1/4,x+1/4],[x+1/4,z+1/4,y+1/4],[-z,-x,-y],[z+1/2,x,1/2-y],[1/2-z,x+1/2,y],[z,1/2-x,y+1/2],[-y,-z,-x],[y,1/2-z,x+1/2],[y+1/2,z,1/2-x],[1/2-y,z+1/2,x],[y+3/4,1/4-x,3/4-z],[3/4-x,z+3/4,1/4-y],[1/4-z,3/4-y,x+3/4],[3/4-y,x+3/4,1/4-z],[1/4-x,3/4-z,y+3/4],[z+3/4,1/4-y,3/4-x]}",
            "1",
        ),
    ],
}
