"""
Wyckoff positions for point groups (reduced coordinate).
    point-group tag: [ (Wyckoff letter, positions, default position, site-symmetry) ]
"""
_data_wyckoff_pg = {
    "C1": [("1a", "{[x,y,z]}", "[0,0,0]", "1")],
    "Ci": [("1o", "{[0,0,0]}", "[0,0,0]", "-1"), ("2a", "{[x,y,z],[-x,-y,-z]}", "[1,0,0]", "1")],
    "C2": [("1a", "{[0,y,0]}", "[0,0,0]", "2"), ("2b", "{[x,y,z],[-x,y,-z]}", "[1,0,0]", "1")],
    "Cs": [("1a", "{[x,0,z]}", "[0,0,0]", "m"), ("2b", "{[x,y,z],[x,-y,z]}", "[0,1,0]", "1")],
    "C2h": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "2/m"),
        ("2a", "{[0,y,0],[0,-y,0]}", "[0,1,0]", "2"),
        ("2b", "{[x,0,z],[-x,0,-z]}", "[1,0,0]", "m"),
        ("4c", "{[x,y,z],[-x,y,-z],[-x,-y,-z],[x,-y,z]}", "[1,1,0]", "1"),
    ],
    "D2": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "222"),
        ("2a", "{[x,0,0],[-x,0,0]}", "[1,0,0]", "2.."),
        ("2b", "{[0,y,0],[0,-y,0]}", "[0,1,0]", ".2."),
        ("2c", "{[0,0,z],[0,0,-z]}", "[0,0,1]", "..2"),
        ("4d", "{[x,y,z],[-x,-y,z],[-x,y,-z],[x,-y,-z]}", "[1,1,0]", "1"),
    ],
    "C2v": [
        ("1a", "{[0,0,z]}", "[0,0,0]", "mm2"),
        ("2b", "{[x,0,z],[-x,0,z]}", "[1,0,0]", ".m."),
        ("2c", "{[0,y,z],[0,-y,z]}", "[0,1,0]", "m.."),
        ("4d", "{[x,y,z],[-x,-y,z],[x,-y,z],[-x,y,z]}", "[1,1,0]", "1"),
    ],
    "D2h": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "mmm"),
        ("2a", "{[x,0,0],[-x,0,0]}", "[1,0,0]", "2mm"),
        ("2b", "{[0,y,0],[0,-y,0]}", "[0,1,0]", "m2m"),
        ("2c", "{[0,0,z],[0,0,-z]}", "[0,0,1]", "mm2"),
        ("4d", "{[0,y,z],[0,-y,z],[0,y,-z],[0,-y,-z]}", "[0,1,1]", "m.."),
        ("4e", "{[x,0,z],[-x,0,z],[-x,0,-z],[x,0,-z]}", "[1,0,1]", ".m."),
        ("4f", "{[x,y,0],[-x,-y,0],[-x,y,0],[x,-y,0]}", "[1,1,0]", "..m"),
        ("8g", "{[x,y,z],[-x,-y,z],[-x,y,-z],[x,-y,-z],[-x,-y,-z],[x,y,-z],[x,-y,z],[-x,y,z]}", "[1,1,1]", "1"),
    ],
    "C4": [("1a", "{[0,0,z]}", "[0,0,0]", "4.."), ("4b", "{[x,y,z],[-x,-y,z],[-y,x,z],[y,-x,z]}", "[1,0,0]", "1")],
    "S4": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "-4"),
        ("2a", "{[0,0,z],[0,0,-z]}", "[0,0,1]", "2.."),
        ("4b", "{[x,y,z],[-x,-y,z],[y,-x,-z],[-y,x,-z]}", "[1,0,0]", "1"),
    ],
    "C4h": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "4/m"),
        ("2a", "{[0,0,z],[0,0,-z]}", "[0,0,1]", "4.."),
        ("4b", "{[x,y,0],[-x,-y,0],[-y,x,0],[y,-x,0]}", "[1,0,0]", "m.."),
        ("8c", "{[x,y,z],[-x,-y,z],[-y,x,z],[y,-x,z],[-x,-y,-z],[x,y,-z],[y,-x,-z],[-y,x,-z]}", "[1,1,1]", "1"),
    ],
    "D4": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "422"),
        ("2a", "{[0,0,z],[0,0,-z]}", "[0,0,1]", "4.."),
        ("4b", "{[x,x,0],[-x,-x,0],[x,-x,0],[-x,x,0]}", "[1,1,0]", "..2"),
        ("4c", "{[x,0,0],[-x,0,0],[0,x,0],[0,-x,0]}", "[1,0,0]", ".2."),
        ("8d", "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[y,x,-z],[-y,-x,-z],[-y,x,z],[y,-x,z]}", "[1,0,1]", "1"),
    ],
    "C4v": [
        ("1a", "{[0,0,z]}", "[0,0,0]", "4mm"),
        ("4b", "{[x,x,z],[-x,-x,z],[-x,x,z],[x,-x,z]}", "[1,1,0]", "..m"),
        ("4c", "{[x,0,z],[-x,0,z],[0,x,z],[0,-x,z]}", "[1,0,0]", ".m."),
        ("8d", "{[x,y,z],[-x,-y,z],[-y,x,z],[y,-x,z],[-x,y,z],[x,-y,z],[-y,-x,z],[y,x,z]}", "[2,1,0]", "1"),
    ],
    "D2d": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "-42m"),
        ("2a", "{[0,0,z],[0,0,-z]}", "[0,0,1]", "2.mm"),
        ("4b", "{[x,0,0],[-x,0,0],[0,-x,0],[0,x,0]}", "[1,0,0]", ".2."),
        ("4c", "{[x,x,z],[-x,-x,z],[x,-x,-z],[-x,x,-z]}", "[1,1,0]", "..m"),
        ("8d", "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[-y,-x,z],[y,x,z],[y,-x,-z],[-y,x,-z]}", "[2,1,0]", "1"),
    ],
    "D2d-1": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "-4m2"),
        ("2a", "{[0,0,z],[0,0,-z]}", "[0,0,1]", "2mm."),
        ("4b", "{[x,x,0],[-x,-x,0],[-x,x,0],[x,-x,0]}", "[1,1,0]", "..2"),
        ("4c", "{[x,0,z],[-x,0,z],[0,x,-z],[0,-x,-z]}", "[1,0,0]", ".m."),
        ("8d", "{[x,y,z],[-x,-y,z],[y,x,-z],[-y,-x,-z],[-x,y,z],[x,-y,z],[y,-x,-z],[-y,x,-z]}", "[2,1,0]", "1"),
    ],
    "D4h": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "4/mmm"),
        ("2a", "{[0,0,z],[0,0,-z]}", "[0,0,1]", "4mm"),
        ("4b", "{[x,x,0],[-x,-x,0],[x,-x,0],[-x,x,0]}", "[1,1,0]", "m.m2"),
        ("4c", "{[x,0,0],[-x,0,0],[0,x,0],[0,-x,0]}", "[1,0,0]", "m2m."),
        ("8d", "{[x,y,0],[-x,-y,0],[x,-y,0],[-x,y,0],[y,x,0],[-y,-x,0],[-y,x,0],[y,-x,0]}", "[2,1,0]", "m.."),
        ("8e", "{[x,x,z],[-x,-x,z],[x,-x,-z],[-x,x,-z],[x,x,-z],[-x,-x,-z],[-x,x,z],[x,-x,z]}", "[1,1,1]", "..m"),
        ("8f", "{[x,0,z],[-x,0,z],[x,0,-z],[-x,0,-z],[0,x,-z],[0,-x,-z],[0,x,z],[0,-x,z]}", "[1,0,1]", ".m."),
        (
            "16g",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[y,x,-z],[-y,-x,-z],[-y,x,z],[y,-x,z],[-x,-y,-z],[x,y,-z],[-x,y,z],[x,-y,z],[-y,-x,z],[y,x,z],[y,-x,-z],[-y,x,-z]}",
            "[2,1,1]",
            "1",
        ),
    ],
    "C3": [("1a", "{[0,0,z]}", "[0,0,0]", "3.."), ("3b", "{[x,y,z],[-y,x-y,z],[-x+y,-x,z]}", "[-1,-1,0]", "1")],
    "C3i": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "-3"),
        ("2a", "{[0,0,z],[0,0,-z]}", "[0,0,1]", "3.."),
        ("6b", "{[x,y,z],[-y,x-y,z],[-x+y,-x,z],[-x,-y,-z],[y,-x+y,-z],[x-y,x,-z]}", "[-1,-1,0]", "1"),
    ],
    "D3": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "312"),
        ("2a", "{[0,0,z],[0,0,-z]}", "[0,0,1]", "3.."),
        ("3b", "{[x,2*x,0],[x,-x,0],[-2*x,-x,0]}", "[1,2,0]", "..2"),
        ("6c", "{[x,y,z],[-x+y,y,-z],[x,x-y,-z],[-y,-x,-z],[-y,x-y,z],[-x+y,-x,z]}", "[-1,-1,1]", "1"),
    ],
    "D3-1": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "321"),
        ("2a", "{[0,0,z],[0,0,-z]}", "[0,0,1]", "3.."),
        ("3b", "{[x,0,0],[-x,-x,0],[0,x,0]}", "[1,0,0]", ".2."),
        ("6c", "{[x,y,z],[x-y,-y,-z],[-x,-x+y,-z],[y,x,-z],[-y,x-y,z],[-x+y,-x,z]}", "[1,-1,1]", "1"),
    ],
    "C3v": [
        ("1a", "{[0,0,z]}", "[0,0,0]", "3m."),
        ("3b", "{[x,2*x,z],[-2*x,-x,z],[x,-x,z]}", "[1,2,0]", ".m."),
        ("6c", "{[x,y,z],[-y,x-y,z],[-x+y,-x,z],[-x+y,y,z],[x,x-y,z],[-y,-x,z]}", "[-1,-1,0]", "1"),
    ],
    "C3v-1": [
        ("1a", "{[0,0,z]}", "[0,0,0]", "3.m"),
        ("3b", "{[x,0,z],[0,x,z],[-x,-x,z]}", "[1,0,0]", "..m"),
        ("6c", "{[x,y,z],[-y,x-y,z],[-x+y,-x,z],[x-y,-y,z],[-x,-x+y,z],[y,x,z]}", "[1,-1,0]", "1"),
    ],
    "D3d": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "-31m"),
        ("2a", "{[0,0,z],[0,0,-z]}", "[0,0,1]", "3.m"),
        ("6b", "{[x,2*x,0],[x,-x,0],[-2*x,-x,0],[-x,-2*x,0],[-x,x,0],[2*x,x,0]}", "[1,2,0]", "..2"),
        ("6c", "{[x,0,z],[-x,0,-z],[x,x,-z],[0,-x,-z],[0,x,z],[-x,-x,z]}", "[1,0,0]", "..m"),
        (
            "12d",
            "{[x,y,z],[-x+y,y,-z],[x,x-y,-z],[-y,-x,-z],[-y,x-y,z],[-x+y,-x,z],[-x,-y,-z],[x-y,-y,z],[-x,-x+y,z],[y,x,z],[y,-x+y,-z],[x-y,x,-z]}",
            "[1,-1,1]",
            "1",
        ),
    ],
    "D3d-1": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "-3m1"),
        ("2a", "{[0,0,z],[0,0,-z]}", "[0,0,1]", "3m."),
        ("6b", "{[x,0,0],[-x,-x,0],[0,x,0],[-x,0,0],[x,x,0],[0,-x,0]}", "[1,0,0]", ".2."),
        ("6c", "{[x,2*x,z],[-x,-2*x,-z],[-x,x,-z],[2*x,x,-z],[-2*x,-x,z],[x,-x,z]}", "[1,2,0]", ".m."),
        (
            "12d",
            "{[x,y,z],[x-y,-y,-z],[-x,-x+y,-z],[y,x,-z],[-y,x-y,z],[-x+y,-x,z],[-x,-y,-z],[-x+y,y,z],[x,x-y,z],[-y,-x,z],[y,-x+y,-z],[x-y,x,-z]}",
            "[-1,-1,1]",
            "1",
        ),
    ],
    "C6": [
        ("1a", "{[0,0,z]}", "[0,0,0]", "6.."),
        ("6b", "{[x,y,z],[-x,-y,z],[-y,x-y,z],[-x+y,-x,z],[x-y,x,z],[y,-x+y,z]}", "[1,-1,0]", "1"),
    ],
    "C3h": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "-6"),
        ("2a", "{[0,0,z],[0,0,-z]}", "[0,0,1]", "3.."),
        ("3b", "{[x,y,0],[-y,x-y,0],[-x+y,-x,0]}", "[1,0,0]", "m.."),
        ("6c", "{[x,y,z],[-y,x-y,z],[-x+y,-x,z],[x,y,-z],[-x+y,-x,-z],[-y,x-y,-z]}", "[-1,-1,1]", "1"),
    ],
    "C6h": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "6/m"),
        ("2a", "{[0,0,z],[0,0,-z]}", "[0,0,1]", "6.."),
        ("6b", "{[x,y,0],[-x,-y,0],[-y,x-y,0],[-x+y,-x,0],[x-y,x,0],[y,-x+y,0]}", "[1,0,0]", "m.."),
        (
            "12c",
            "{[x,y,z],[-x,-y,z],[-y,x-y,z],[-x+y,-x,z],[x-y,x,z],[y,-x+y,z],[-x,-y,-z],[x,y,-z],[y,-x+y,-z],[x-y,x,-z],[-x+y,-x,-z],[-y,x-y,-z]}",
            "[-1,-1,1]",
            "1",
        ),
    ],
    "D6": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "622"),
        ("2a", "{[0,0,z],[0,0,-z]}", "[0,0,1]", "6.."),
        ("6b", "{[x,0,0],[-x,0,0],[-x,-x,0],[0,x,0],[x,x,0],[0,-x,0]}", "[1,0,0]", ".2."),
        ("6c", "{[x,2*x,0],[-x,-2*x,0],[-x,x,0],[2*x,x,0],[x,-x,0],[-2*x,-x,0]}", "[1,2,0]", "..2"),
        (
            "12d",
            "{[x,y,z],[-x,-y,z],[x-y,-y,-z],[-x,-x+y,-z],[y,x,-z],[-x+y,y,-z],[x,x-y,-z],[-y,-x,-z],[-y,x-y,z],[-x+y,-x,z],[x-y,x,z],[y,-x+y,z]}",
            "[-1,-1,1]",
            "1",
        ),
    ],
    "C6v": [
        ("1a", "{[0,0,z]}", "[0,0,0]", "6mm"),
        ("6b", "{[x,0,z],[-x,0,z],[0,x,z],[-x,-x,z],[x,x,z],[0,-x,z]}", "[1,0,0]", "..m"),
        ("6c", "{[x,2*x,z],[-x,-2*x,z],[-2*x,-x,z],[x,-x,z],[-x,x,z],[2*x,x,z]}", "[1,2,0]", ".m."),
        (
            "12d",
            "{[x,y,z],[-x,-y,z],[-y,x-y,z],[-x+y,-x,z],[x-y,x,z],[y,-x+y,z],[-x+y,y,z],[x,x-y,z],[-y,-x,z],[x-y,-y,z],[-x,-x+y,z],[y,x,z]}",
            "[sqrt(3)+1,sqrt(3)-1,0]",
            "1",
        ),
    ],
    "D3h": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "-6m2"),
        ("2a", "{[0,0,z],[0,0,-z]}", "[0,0,1]", "3m."),
        ("3b", "{[x,2*x,0],[x,-x,0],[-2*x,-x,0]}", "[1,2,0]", "mm2"),
        ("6c", "{[x,2*x,z],[x,2*x,-z],[x,-x,-z],[-2*x,-x,-z],[-2*x,-x,z],[x,-x,z]}", "[1,2,1]", ".m."),
        ("6d", "{[x,y,0],[-x+y,y,0],[x,x-y,0],[-y,-x,0],[-y,x-y,0],[-x+y,-x,0]}", "[1,0,0]", "m.."),
        (
            "12e",
            "{[x,y,z],[-x+y,y,-z],[x,x-y,-z],[-y,-x,-z],[-y,x-y,z],[-x+y,-x,z],[-x+y,y,z],[x,x-y,z],[-y,-x,z],[x,y,-z],[-x+y,-x,-z],[-y,x-y,-z]}",
            "[-1,-1,1]",
            "1",
        ),
    ],
    "D3h-1": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "-62m"),
        ("2a", "{[0,0,z],[0,0,-z]}", "[0,0,1]", "3.m"),
        ("3b", "{[x,0,0],[-x,-x,0],[0,x,0]}", "[1,0,0]", "m2m"),
        ("6c", "{[x,0,z],[x,0,-z],[-x,-x,-z],[0,x,-z],[0,x,z],[-x,-x,z]}", "[1,0,1]", "..m"),
        ("6d", "{[x,y,0],[x-y,-y,0],[-x,-x+y,0],[y,x,0],[-y,x-y,0],[-x+y,-x,0]}", "[1,2,0]", "m.."),
        (
            "12e",
            "{[x,y,z],[x-y,-y,-z],[-x,-x+y,-z],[y,x,-z],[-y,x-y,z],[-x+y,-x,z],[x,y,-z],[x-y,-y,z],[-x,-x+y,z],[y,x,z],[-x+y,-x,-z],[-y,x-y,-z]}",
            "[1,-1,1]",
            "1",
        ),
    ],
    "D6h": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "6/mmm"),
        ("2a", "{[0,0,z],[0,0,-z]}", "[0,0,1]", "6mm"),
        ("6b", "{[x,0,0],[-x,0,0],[-x,-x,0],[0,x,0],[x,x,0],[0,-x,0]}", "[1,0,0]", "m2m"),
        ("6c", "{[x,2*x,0],[-x,-2*x,0],[-x,x,0],[2*x,x,0],[x,-x,0],[-2*x,-x,0]}", "[1,2,0]", "mm2"),
        (
            "12d",
            "{[x,0,z],[-x,0,z],[x,0,-z],[-x,-x,-z],[0,x,-z],[-x,0,-z],[x,x,-z],[0,-x,-z],[0,x,z],[-x,-x,z],[x,x,z],[0,-x,z]}",
            "[1,0,1]",
            "..m",
        ),
        (
            "12e",
            "{[x,2*x,z],[-x,-2*x,z],[-x,-2*x,-z],[-x,x,-z],[2*x,x,-z],[x,2*x,-z],[x,-x,-z],[-2*x,-x,-z],[-2*x,-x,z],[x,-x,z],[-x,x,z],[2*x,x,z]}",
            "[1,2,1]",
            ".m.",
        ),
        (
            "12f",
            "{[x,y,0],[-x,-y,0],[x-y,-y,0],[-x,-x+y,0],[y,x,0],[-x+y,y,0],[x,x-y,0],[-y,-x,0],[-y,x-y,0],[-x+y,-x,0],[x-y,x,0],[y,-x+y,0]}",
            "[sqrt(3)+1,sqrt(3)-1,0]",
            "m..",
        ),
        (
            "24g",
            "{[x,y,z],[-x,-y,z],[x-y,-y,-z],[-x,-x+y,-z],[y,x,-z],[-x+y,y,-z],[x,x-y,-z],[-y,-x,-z],[-y,x-y,z],[-x+y,-x,z],[x-y,x,z],[y,-x+y,z],[-x,-y,-z],[-x+y,y,z],[x,x-y,z],[-y,-x,z],[x,y,-z],[x-y,-y,z],[-x,-x+y,z],[y,x,z],[y,-x+y,-z],[x-y,x,-z],[-x+y,-x,-z],[-y,x-y,-z]}",
            "[sqrt(3)+1,sqrt(3)-1,1]",
            "1",
        ),
    ],
    "T": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "23"),
        ("4a", "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x]}", "[1,1,1]", ".3."),
        ("6b", "{[x,0,0],[-x,0,0],[0,x,0],[0,-x,0],[0,0,x],[0,0,-x]}", "[1,0,0]", "2.."),
        (
            "12c",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x]}",
            "[1,1,0]",
            "1",
        ),
    ],
    "Th": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "m-3"),
        ("6a", "{[x,0,0],[-x,0,0],[0,x,0],[0,-x,0],[0,0,x],[0,0,-x]}", "[1,0,0]", "2mm.."),
        ("8b", "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x],[-x,-x,-x],[x,x,-x],[-x,x,x],[x,-x,x]}", "[1,1,1]", ".3."),
        (
            "12c",
            "{[0,y,z],[0,-y,z],[0,-y,-z],[0,y,-z],[z,0,y],[-z,0,y],[z,0,-y],[-z,0,-y],[y,z,0],[-y,z,0],[-y,-z,0],[y,-z,0]}",
            "[0,1,1]",
            "m..",
        ),
        (
            "24d",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x],[-x,-y,-z],[x,y,-z],[-x,y,z],[x,-y,z],[-z,-x,-y],[z,x,-y],[-z,x,y],[z,-x,y],[-y,-z,-x],[y,-z,x],[y,z,-x],[-y,z,x]}",
            "[3,2,1]",
            "1",
        ),
    ],
    "O": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "432"),
        ("6a", "{[x,0,0],[-x,0,0],[0,x,0],[0,0,x],[0,-x,0],[0,0,-x]}", "[1,0,0]", "4.."),
        ("8b", "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x],[x,x,-x],[x,-x,x],[-x,x,x],[-x,-x,-x]}", "[1,1,1]", ".3."),
        (
            "12c",
            "{[0,y,y],[0,-y,y],[0,-y,-y],[0,y,-y],[y,0,-y],[y,-y,0],[-y,0,-y],[-y,-y,0],[y,0,y],[-y,0,y],[y,y,0],[-y,y,0]}",
            "[0,1,1]",
            "..2",
        ),
        (
            "24d",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[y,x,-z],[z,-y,x],[-x,z,y],[-y,-x,-z],[-z,-y,-x],[-x,-z,-y],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x],[-y,x,z],[x,-z,y],[z,y,-x],[y,-x,z],[x,z,-y],[-z,y,x]}",
            "[2,1,0]",
            "1",
        ),
    ],
    "Td": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "-43m"),
        ("4a", "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x]}", "[1,1,1]", ".3m"),
        ("6b", "{[x,0,0],[-x,0,0],[0,x,0],[0,-x,0],[0,0,x],[0,0,-x]}", "[1,0,0]", "2.mm"),
        (
            "12c",
            "{[x,x,z],[-x,-x,z],[x,-x,-z],[-x,x,-z],[z,x,x],[-z,-x,x],[z,-x,-x],[-z,x,-x],[x,z,x],[-x,z,-x],[-x,-z,x],[x,-z,-x]}",
            "[1,1,0]",
            "..m",
        ),
        (
            "24d",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x],[-y,-x,z],[-z,y,-x],[x,-z,-y],[y,x,z],[z,y,x],[x,z,y],[y,-x,-z],[-x,z,-y],[-z,-y,x],[-y,x,-z],[-x,-z,y],[z,-y,-x]}",
            "[2,1,0]",
            "1",
        ),
    ],
    "Oh": [
        ("1o", "{[0,0,0]}", "[0,0,0]", "m-3m"),
        ("6a", "{[x,0,0],[-x,0,0],[0,x,0],[0,0,x],[0,-x,0],[0,0,-x]}", "[1,0,0]", "4m.m"),
        ("8b", "{[x,x,x],[-x,-x,x],[x,-x,-x],[-x,x,-x],[x,x,-x],[x,-x,x],[-x,x,x],[-x,-x,-x]}", "[1,1,1]", ".3m"),
        (
            "12c",
            "{[0,y,y],[0,-y,y],[0,-y,-y],[0,y,-y],[y,0,-y],[y,-y,0],[-y,0,-y],[-y,-y,0],[y,0,y],[-y,0,y],[y,y,0],[-y,y,0]}",
            "[0,1,1]",
            "m.m2",
        ),
        (
            "24d",
            "{[0,y,z],[0,-y,z],[0,-y,-z],[0,y,-z],[y,0,-z],[z,-y,0],[0,z,y],[-y,0,-z],[-z,-y,0],[0,-z,-y],[z,0,y],[-z,0,y],[z,0,-y],[-z,0,-y],[y,z,0],[-y,z,0],[-y,-z,0],[y,-z,0],[-y,0,z],[0,-z,y],[z,y,0],[y,0,z],[0,z,-y],[-z,y,0]}",
            "[0,2,1]",
            "m..",
        ),
        (
            "24e",
            "{[x,x,z],[-x,-x,z],[x,-x,-z],[-x,x,-z],[x,x,-z],[z,-x,x],[-x,z,x],[-x,-x,-z],[-z,-x,-x],[-x,-z,-x],[z,x,x],[-z,-x,x],[z,-x,-x],[-z,x,-x],[x,z,x],[-x,z,-x],[-x,-z,x],[x,-z,-x],[-x,x,z],[x,-z,x],[z,x,-x],[x,-x,z],[x,z,-x],[-z,x,x]}",
            "[1,1,2]",
            "..m",
        ),
        (
            "48f",
            "{[x,y,z],[-x,-y,z],[x,-y,-z],[-x,y,-z],[y,x,-z],[z,-y,x],[-x,z,y],[-y,-x,-z],[-z,-y,-x],[-x,-z,-y],[z,x,y],[-z,-x,y],[z,-x,-y],[-z,x,-y],[y,z,x],[-y,z,-x],[-y,-z,x],[y,-z,-x],[-y,x,z],[x,-z,y],[z,y,-x],[y,-x,z],[x,z,-y],[-z,y,x],[-x,-y,-z],[x,y,-z],[-x,y,z],[x,-y,z],[-y,-x,z],[-z,y,-x],[x,-z,-y],[y,x,z],[z,y,x],[x,z,y],[-z,-x,-y],[z,x,-y],[-z,x,y],[z,-x,y],[-y,-z,-x],[y,-z,x],[y,z,-x],[-y,z,x],[y,-x,-z],[-x,z,-y],[-z,-y,x],[-y,x,-z],[-x,-z,y],[z,-y,-x]}",
            "[3,2,1]",
            "1",
        ),
    ],
}
