"""
basis of virtual cluster for other wyckoff positions (orthonormalized).
    { point-group tag : { wp: {multipole-tag: basis} } }
real version
"""
_data_virtual_cluster_basis_real = {
    "C1": {"1a": {"Qs(0,A,,)": "[1]"}},
    "Ci": {"2a": {"Qs(0,Ag,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,Au,1,)": "[sqrt(2)/2,-sqrt(2)/2]"}, "1o": {"Qs(0,Ag,,)": "[1]"}},
    "C2": {"2b": {"Qs(0,A,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,B,1,)": "[sqrt(2)/2,-sqrt(2)/2]"}, "1a": {"Qs(0,A,,)": "[1]"}},
    "Cs": {"2b": {"Qs(0,A',,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,A'',,)": "[sqrt(2)/2,-sqrt(2)/2]"}, "1a": {"Qs(0,A',,)": "[1]"}},
    "C2h": {
        "4c": {
            "Qs(0,Ag,,)": "[1/2,1/2,1/2,1/2]",
            "Qs(1,Au,,)": "[1/2,1/2,-1/2,-1/2]",
            "Qs(1,Bu,1,)": "[1/2,-1/2,-1/2,1/2]",
            "Qs(2,Bg,2,)": "[1/2,-1/2,1/2,-1/2]",
        },
        "2b": {"Qs(0,Ag,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,Bu,1,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "2a": {"Qs(0,Ag,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,Au,,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "1o": {"Qs(0,Ag,,)": "[1]"},
    },
    "D2": {
        "4d": {
            "Qs(0,A,,)": "[1/2,1/2,1/2,1/2]",
            "Qs(1,B2,,)": "[1/2,-1/2,1/2,-1/2]",
            "Qs(1,B3,,)": "[1/2,-1/2,-1/2,1/2]",
            "Qs(2,B1,,)": "[1/2,1/2,-1/2,-1/2]",
        },
        "2c": {"Qs(0,A,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,B1,,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "2b": {"Qs(0,A,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,B2,,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "2a": {"Qs(0,A,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,B3,,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "1o": {"Qs(0,A,,)": "[1]"},
    },
    "C2v": {
        "4d": {
            "Qs(0,A1,,)": "[1/2,1/2,1/2,1/2]",
            "Qs(1,B1,,)": "[1/2,-1/2,1/2,-1/2]",
            "Qs(1,B2,,)": "[1/2,-1/2,-1/2,1/2]",
            "Qs(2,A2,,)": "[1/2,1/2,-1/2,-1/2]",
        },
        "2c": {"Qs(0,A1,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,B2,,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "2b": {"Qs(0,A1,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,B1,,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "1a": {"Qs(0,A1,,)": "[1]"},
    },
    "D2h": {
        "8g": {
            "Qs(0,Ag,,)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,B1u,,)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,B2u,,)": "[sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,B3u,,)": "[sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(2,B1g,,)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
            "Qs(2,B2g,,)": "[sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(2,B3g,,)": "[sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4]",
            "Qs(3,Au,,)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
        },
        "4f": {
            "Qs(0,Ag,,)": "[1/2,1/2,1/2,1/2]",
            "Qs(1,B2u,,)": "[1/2,-1/2,1/2,-1/2]",
            "Qs(1,B3u,,)": "[1/2,-1/2,-1/2,1/2]",
            "Qs(2,B1g,,)": "[1/2,1/2,-1/2,-1/2]",
        },
        "4e": {
            "Qs(0,Ag,,)": "[1/2,1/2,1/2,1/2]",
            "Qs(1,B1u,,)": "[1/2,1/2,-1/2,-1/2]",
            "Qs(1,B3u,,)": "[1/2,-1/2,-1/2,1/2]",
            "Qs(2,B2g,,)": "[1/2,-1/2,1/2,-1/2]",
        },
        "4d": {
            "Qs(0,Ag,,)": "[1/2,1/2,1/2,1/2]",
            "Qs(1,B1u,,)": "[1/2,1/2,-1/2,-1/2]",
            "Qs(1,B2u,,)": "[1/2,-1/2,1/2,-1/2]",
            "Qs(2,B3g,,)": "[1/2,-1/2,-1/2,1/2]",
        },
        "2c": {"Qs(0,Ag,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,B1u,,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "2b": {"Qs(0,Ag,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,B2u,,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "2a": {"Qs(0,Ag,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,B3u,,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "1o": {"Qs(0,Ag,,)": "[1]"},
    },
    "C4": {
        "4b": {
            "Qs(0,A,,)": "[1/2,1/2,1/2,1/2]",
            "Qs(1,E,,0)": "[sqrt(2)/2,-sqrt(2)/2,0,0]",
            "Qs(1,E,,1)": "[0,0,sqrt(2)/2,-sqrt(2)/2]",
            "Qs(2,B,1,)": "[1/2,1/2,-1/2,-1/2]",
        },
        "1a": {"Qs(0,A,,)": "[1]"},
    },
    "S4": {
        "4b": {
            "Qs(0,A,,)": "[1/2,1/2,1/2,1/2]",
            "Qs(1,E,,0)": "[sqrt(2)/2,-sqrt(2)/2,0,0]",
            "Qs(1,E,,1)": "[0,0,-sqrt(2)/2,sqrt(2)/2]",
            "Qs(2,B,1,)": "[1/2,1/2,-1/2,-1/2]",
        },
        "2a": {"Qs(0,A,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,B,,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "1o": {"Qs(0,A,,)": "[1]"},
    },
    "C4h": {
        "8c": {
            "Qs(0,Ag,,)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,Au,,)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
            "Qs(1,Eu,,0)": "[sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(1,Eu,,1)": "[sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4]",
            "Qs(2,Bg,2,)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
            "Qs(2,Eg,,0)": "[sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(2,Eg,,1)": "[-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(3,Bu,1,)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
        },
        "4b": {
            "Qs(0,Ag,,)": "[1/2,1/2,1/2,1/2]",
            "Qs(1,Eu,,0)": "[sqrt(2)/2,-sqrt(2)/2,0,0]",
            "Qs(1,Eu,,1)": "[0,0,sqrt(2)/2,-sqrt(2)/2]",
            "Qs(2,Bg,1,)": "[1/2,1/2,-1/2,-1/2]",
        },
        "2a": {"Qs(0,Ag,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,Au,,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "1o": {"Qs(0,Ag,,)": "[1]"},
    },
    "D4": {
        "8d": {
            "Qs(0,A1,,)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,A2,,)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,E,,0)": "[1/2,-1/2,1/2,-1/2,0,0,0,0]",
            "Qs(1,E,,1)": "[0,0,0,0,1/2,-1/2,1/2,-1/2]",
            "Qs(2,B1,,)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
            "Qs(2,E,,0)": "[0,0,0,0,-1/2,1/2,1/2,-1/2]",
            "Qs(2,E,,1)": "[-1/2,1/2,1/2,-1/2,0,0,0,0]",
            "Qs(3,B2,,)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
        },
        "4c": {
            "Qs(0,A1,,)": "[1/2,1/2,1/2,1/2]",
            "Qs(1,E,,0)": "[sqrt(2)/2,-sqrt(2)/2,0,0]",
            "Qs(1,E,,1)": "[0,0,sqrt(2)/2,-sqrt(2)/2]",
            "Qs(2,B1,,)": "[1/2,1/2,-1/2,-1/2]",
        },
        "4b": {
            "Qs(0,A1,,)": "[1/2,1/2,1/2,1/2]",
            "Qs(1,E,,0)": "[1/2,-1/2,1/2,-1/2]",
            "Qs(1,E,,1)": "[1/2,-1/2,-1/2,1/2]",
            "Qs(2,B2,,)": "[1/2,1/2,-1/2,-1/2]",
        },
        "2a": {"Qs(0,A1,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,A2,,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "1o": {"Qs(0,A1,,)": "[1]"},
    },
    "C4v": {
        "8d": {
            "Qs(0,A1,,)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,E,,0)": "[sqrt(5)/5,-sqrt(5)/5,-sqrt(5)/10,sqrt(5)/10,-sqrt(5)/5,sqrt(5)/5,-sqrt(5)/10,sqrt(5)/10]",
            "Qs(1,E,,1)": "[sqrt(5)/10,-sqrt(5)/10,sqrt(5)/5,-sqrt(5)/5,sqrt(5)/10,-sqrt(5)/10,-sqrt(5)/5,sqrt(5)/5]",
            "Qs(2,B1,,)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
            "Qs(2,B2,,)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
            "Qs(3,E,1,0)": "[sqrt(5)/10,-sqrt(5)/10,sqrt(5)/5,-sqrt(5)/5,-sqrt(5)/10,sqrt(5)/10,sqrt(5)/5,-sqrt(5)/5]",
            "Qs(3,E,1,1)": "[-sqrt(5)/5,sqrt(5)/5,sqrt(5)/10,-sqrt(5)/10,-sqrt(5)/5,sqrt(5)/5,-sqrt(5)/10,sqrt(5)/10]",
            "Qs(4,A2,,)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
        },
        "4c": {
            "Qs(0,A1,,)": "[1/2,1/2,1/2,1/2]",
            "Qs(1,E,,0)": "[sqrt(2)/2,-sqrt(2)/2,0,0]",
            "Qs(1,E,,1)": "[0,0,sqrt(2)/2,-sqrt(2)/2]",
            "Qs(2,B1,,)": "[1/2,1/2,-1/2,-1/2]",
        },
        "4b": {
            "Qs(0,A1,,)": "[1/2,1/2,1/2,1/2]",
            "Qs(1,E,,0)": "[1/2,-1/2,-1/2,1/2]",
            "Qs(1,E,,1)": "[1/2,-1/2,1/2,-1/2]",
            "Qs(2,B2,,)": "[1/2,1/2,-1/2,-1/2]",
        },
        "1a": {"Qs(0,A1,,)": "[1]"},
    },
    "D2d": {
        "8d": {
            "Qs(0,A1,,)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,E,,0)": "[sqrt(5)/5,-sqrt(5)/5,sqrt(5)/5,-sqrt(5)/5,-sqrt(5)/10,sqrt(5)/10,sqrt(5)/10,-sqrt(5)/10]",
            "Qs(1,E,,1)": "[sqrt(5)/10,-sqrt(5)/10,-sqrt(5)/10,sqrt(5)/10,-sqrt(5)/5,sqrt(5)/5,-sqrt(5)/5,sqrt(5)/5]",
            "Qs(2,B1,,)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
            "Qs(2,B2,,)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
            "Qs(3,E,1,0)": "[sqrt(5)/10,-sqrt(5)/10,sqrt(5)/10,-sqrt(5)/10,sqrt(5)/5,-sqrt(5)/5,-sqrt(5)/5,sqrt(5)/5]",
            "Qs(3,E,1,1)": "[-sqrt(5)/5,sqrt(5)/5,sqrt(5)/5,-sqrt(5)/5,-sqrt(5)/10,sqrt(5)/10,-sqrt(5)/10,sqrt(5)/10]",
            "Qs(4,A2,,)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
        },
        "4c": {
            "Qs(0,A1,,)": "[1/2,1/2,1/2,1/2]",
            "Qs(1,E,,0)": "[1/2,-1/2,1/2,-1/2]",
            "Qs(1,E,,1)": "[1/2,-1/2,-1/2,1/2]",
            "Qs(2,B2,,)": "[1/2,1/2,-1/2,-1/2]",
        },
        "4b": {
            "Qs(0,A1,,)": "[1/2,1/2,1/2,1/2]",
            "Qs(1,E,,0)": "[sqrt(2)/2,-sqrt(2)/2,0,0]",
            "Qs(1,E,,1)": "[0,0,-sqrt(2)/2,sqrt(2)/2]",
            "Qs(2,B1,,)": "[1/2,1/2,-1/2,-1/2]",
        },
        "2a": {"Qs(0,A1,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,B2,,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "1o": {"Qs(0,A1,,)": "[1]"},
    },
    "D2d-1": {
        "8d": {
            "Qs(0,A1,,)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,E,,0)": "[sqrt(5)/5,-sqrt(5)/5,sqrt(5)/10,-sqrt(5)/10,-sqrt(5)/5,sqrt(5)/5,sqrt(5)/10,-sqrt(5)/10]",
            "Qs(1,E,,1)": "[sqrt(5)/10,-sqrt(5)/10,sqrt(5)/5,-sqrt(5)/5,sqrt(5)/10,-sqrt(5)/10,-sqrt(5)/5,sqrt(5)/5]",
            "Qs(2,B1,,)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
            "Qs(2,B2,,)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
            "Qs(3,E,1,0)": "[sqrt(5)/10,-sqrt(5)/10,-sqrt(5)/5,sqrt(5)/5,-sqrt(5)/10,sqrt(5)/10,-sqrt(5)/5,sqrt(5)/5]",
            "Qs(3,E,1,1)": "[-sqrt(5)/5,sqrt(5)/5,sqrt(5)/10,-sqrt(5)/10,-sqrt(5)/5,sqrt(5)/5,-sqrt(5)/10,sqrt(5)/10]",
            "Qs(4,A2,,)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
        },
        "4c": {
            "Qs(0,A1,,)": "[1/2,1/2,1/2,1/2]",
            "Qs(1,E,,0)": "[sqrt(2)/2,-sqrt(2)/2,0,0]",
            "Qs(1,E,,1)": "[0,0,sqrt(2)/2,-sqrt(2)/2]",
            "Qs(2,B2,,)": "[1/2,1/2,-1/2,-1/2]",
        },
        "4b": {
            "Qs(0,A1,,)": "[1/2,1/2,1/2,1/2]",
            "Qs(1,E,,0)": "[1/2,-1/2,-1/2,1/2]",
            "Qs(1,E,,1)": "[1/2,-1/2,1/2,-1/2]",
            "Qs(2,B1,,)": "[1/2,1/2,-1/2,-1/2]",
        },
        "2a": {"Qs(0,A1,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,B2,,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "1o": {"Qs(0,A1,,)": "[1]"},
    },
    "D4h": {
        "16g": {
            "Qs(0,A1g,,)": "[1/4,1/4,1/4,1/4,1/4,1/4,1/4,1/4,1/4,1/4,1/4,1/4,1/4,1/4,1/4,1/4]",
            "Qs(1,A2u,,)": "[1/4,1/4,-1/4,-1/4,-1/4,-1/4,1/4,1/4,-1/4,-1/4,1/4,1/4,1/4,1/4,-1/4,-1/4]",
            "Qs(1,Eu,,0)": "[sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/20,sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20]",
            "Qs(1,Eu,,1)": "[sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,-sqrt(10)/20,sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10]",
            "Qs(2,B1g,,)": "[1/4,1/4,1/4,1/4,-1/4,-1/4,-1/4,-1/4,1/4,1/4,1/4,1/4,-1/4,-1/4,-1/4,-1/4]",
            "Qs(2,B2g,,)": "[1/4,1/4,-1/4,-1/4,1/4,1/4,-1/4,-1/4,1/4,1/4,-1/4,-1/4,1/4,1/4,-1/4,-1/4]",
            "Qs(2,Eg,,0)": "[sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/10,sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/10,sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10]",
            "Qs(2,Eg,,1)": "[sqrt(10)/10,-sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,sqrt(10)/10,-sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20]",
            "Qs(3,B1u,,)": "[1/4,1/4,1/4,1/4,-1/4,-1/4,-1/4,-1/4,-1/4,-1/4,-1/4,-1/4,1/4,1/4,1/4,1/4]",
            "Qs(3,B2u,,)": "[1/4,1/4,-1/4,-1/4,1/4,1/4,-1/4,-1/4,-1/4,-1/4,1/4,1/4,-1/4,-1/4,1/4,1/4]",
            "Qs(3,Eu,1,0)": "[sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/10,sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,-sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,sqrt(10)/10,-sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10]",
            "Qs(3,Eu,1,1)": "[-sqrt(10)/10,sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,sqrt(10)/10,-sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20]",
            "Qs(4,A2g,,)": "[1/4,1/4,-1/4,-1/4,-1/4,-1/4,1/4,1/4,1/4,1/4,-1/4,-1/4,-1/4,-1/4,1/4,1/4]",
            "Qs(4,Eg,1,0)": "[-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/20,sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/20,sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20]",
            "Qs(4,Eg,1,1)": "[sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10]",
            "Qs(5,A1u,,)": "[1/4,1/4,1/4,1/4,1/4,1/4,1/4,1/4,-1/4,-1/4,-1/4,-1/4,-1/4,-1/4,-1/4,-1/4]",
        },
        "8f": {
            "Qs(0,A1g,,)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,A2u,,)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,Eu,,0)": "[1/2,-1/2,1/2,-1/2,0,0,0,0]",
            "Qs(1,Eu,,1)": "[0,0,0,0,1/2,-1/2,1/2,-1/2]",
            "Qs(2,B1g,,)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
            "Qs(2,Eg,,0)": "[0,0,0,0,-1/2,1/2,1/2,-1/2]",
            "Qs(2,Eg,,1)": "[1/2,-1/2,-1/2,1/2,0,0,0,0]",
            "Qs(3,B2u,,)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
        },
        "8e": {
            "Qs(0,A1g,,)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,A2u,,)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,Eu,,0)": "[sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,Eu,,1)": "[sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(2,B2g,,)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
            "Qs(2,Eg,,0)": "[sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(2,Eg,,1)": "[sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4]",
            "Qs(3,B1u,,)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
        },
        "8d": {
            "Qs(0,A1g,,)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,Eu,,0)": "[sqrt(5)/5,-sqrt(5)/5,sqrt(5)/5,-sqrt(5)/5,sqrt(5)/10,-sqrt(5)/10,-sqrt(5)/10,sqrt(5)/10]",
            "Qs(1,Eu,,1)": "[sqrt(5)/10,-sqrt(5)/10,-sqrt(5)/10,sqrt(5)/10,sqrt(5)/5,-sqrt(5)/5,sqrt(5)/5,-sqrt(5)/5]",
            "Qs(2,B1g,,)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
            "Qs(2,B2g,,)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
            "Qs(3,Eu,1,0)": "[sqrt(5)/10,-sqrt(5)/10,sqrt(5)/10,-sqrt(5)/10,-sqrt(5)/5,sqrt(5)/5,sqrt(5)/5,-sqrt(5)/5]",
            "Qs(3,Eu,1,1)": "[-sqrt(5)/5,sqrt(5)/5,sqrt(5)/5,-sqrt(5)/5,sqrt(5)/10,-sqrt(5)/10,sqrt(5)/10,-sqrt(5)/10]",
            "Qs(4,A2g,,)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
        },
        "4c": {
            "Qs(0,A1g,,)": "[1/2,1/2,1/2,1/2]",
            "Qs(1,Eu,,0)": "[sqrt(2)/2,-sqrt(2)/2,0,0]",
            "Qs(1,Eu,,1)": "[0,0,sqrt(2)/2,-sqrt(2)/2]",
            "Qs(2,B1g,,)": "[1/2,1/2,-1/2,-1/2]",
        },
        "4b": {
            "Qs(0,A1g,,)": "[1/2,1/2,1/2,1/2]",
            "Qs(1,Eu,,0)": "[1/2,-1/2,1/2,-1/2]",
            "Qs(1,Eu,,1)": "[1/2,-1/2,-1/2,1/2]",
            "Qs(2,B2g,,)": "[1/2,1/2,-1/2,-1/2]",
        },
        "2a": {"Qs(0,A1g,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,A2u,,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "1o": {"Qs(0,A1g,,)": "[1]"},
    },
    "C3": {
        "3b": {
            "Qs(0,A,,)": "[sqrt(3)/3,sqrt(3)/3,sqrt(3)/3]",
            "Qs(1,E,,0)": "[-sqrt(6)/6,sqrt(6)/3,-sqrt(6)/6]",
            "Qs(1,E,,1)": "[-sqrt(2)/2,0,sqrt(2)/2]",
        },
        "1a": {"Qs(0,A,,)": "[1]"},
    },
    "C3i": {
        "6b": {
            "Qs(0,Ag,,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,Eu,,0)": "[-sqrt(3)/6,sqrt(3)/3,-sqrt(3)/6,sqrt(3)/6,-sqrt(3)/3,sqrt(3)/6]",
            "Qs(1,Eu,,1)": "[-1/2,0,1/2,1/2,0,-1/2]",
            "Qs(2,Eg,2,0)": "[-sqrt(3)/6,sqrt(3)/3,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/3,-sqrt(3)/6]",
            "Qs(2,Eg,2,1)": "[-1/2,0,1/2,-1/2,0,1/2]",
            "Qs(3,Au,3,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6]",
        },
        "2a": {"Qs(0,Ag,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,Au,,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "1o": {"Qs(0,Ag,,)": "[1]"},
    },
    "D3": {
        "6c": {
            "Qs(0,A1,,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,A2,,)": "[sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,E,,0)": "[-sqrt(3)/6,sqrt(3)/6,-sqrt(3)/3,sqrt(3)/6,sqrt(3)/3,-sqrt(3)/6]",
            "Qs(1,E,,1)": "[-1/2,-1/2,0,1/2,0,1/2]",
            "Qs(2,E,1,0)": "[-1/2,1/2,0,-1/2,0,1/2]",
            "Qs(2,E,1,1)": "[sqrt(3)/6,sqrt(3)/6,-sqrt(3)/3,sqrt(3)/6,-sqrt(3)/3,sqrt(3)/6]",
        },
        "3b": {
            "Qs(0,A1,,)": "[sqrt(3)/3,sqrt(3)/3,sqrt(3)/3]",
            "Qs(1,E,,0)": "[0,sqrt(2)/2,-sqrt(2)/2]",
            "Qs(1,E,,1)": "[sqrt(6)/3,-sqrt(6)/6,-sqrt(6)/6]",
        },
        "2a": {"Qs(0,A1,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,A2,,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "1o": {"Qs(0,A1,,)": "[1]"},
    },
    "D3-1": {
        "6c": {
            "Qs(0,A1,,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,A2,,)": "[sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,E,,0)": "[1/2,1/2,0,-1/2,0,-1/2]",
            "Qs(1,E,,1)": "[-sqrt(3)/6,sqrt(3)/6,-sqrt(3)/3,sqrt(3)/6,sqrt(3)/3,-sqrt(3)/6]",
            "Qs(2,E,1,0)": "[-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/3,-sqrt(3)/6,sqrt(3)/3,-sqrt(3)/6]",
            "Qs(2,E,1,1)": "[-1/2,1/2,0,-1/2,0,1/2]",
        },
        "3b": {
            "Qs(0,A1,,)": "[sqrt(3)/3,sqrt(3)/3,sqrt(3)/3]",
            "Qs(1,E,,0)": "[sqrt(6)/3,-sqrt(6)/6,-sqrt(6)/6]",
            "Qs(1,E,,1)": "[0,-sqrt(2)/2,sqrt(2)/2]",
        },
        "2a": {"Qs(0,A1,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,A2,,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "1o": {"Qs(0,A1,,)": "[1]"},
    },
    "C3v": {
        "6c": {
            "Qs(0,A1,,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,E,,0)": "[-sqrt(3)/6,sqrt(3)/3,-sqrt(3)/6,sqrt(3)/6,-sqrt(3)/3,sqrt(3)/6]",
            "Qs(1,E,,1)": "[-1/2,0,1/2,-1/2,0,1/2]",
            "Qs(2,E,2,0)": "[-1/2,0,1/2,1/2,0,-1/2]",
            "Qs(2,E,2,1)": "[sqrt(3)/6,-sqrt(3)/3,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/3,sqrt(3)/6]",
            "Qs(3,A2,,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6]",
        },
        "3b": {
            "Qs(0,A1,,)": "[sqrt(3)/3,sqrt(3)/3,sqrt(3)/3]",
            "Qs(1,E,,0)": "[0,-sqrt(2)/2,sqrt(2)/2]",
            "Qs(1,E,,1)": "[sqrt(6)/3,-sqrt(6)/6,-sqrt(6)/6]",
        },
        "1a": {"Qs(0,A1,,)": "[1]"},
    },
    "C3v-1": {
        "6c": {
            "Qs(0,A1,,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,E,,0)": "[1/2,0,-1/2,1/2,0,-1/2]",
            "Qs(1,E,,1)": "[-sqrt(3)/6,sqrt(3)/3,-sqrt(3)/6,sqrt(3)/6,-sqrt(3)/3,sqrt(3)/6]",
            "Qs(2,E,2,0)": "[sqrt(3)/6,-sqrt(3)/3,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/3,sqrt(3)/6]",
            "Qs(2,E,2,1)": "[1/2,0,-1/2,-1/2,0,1/2]",
            "Qs(3,A2,,)": "[-sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
        },
        "3b": {
            "Qs(0,A1,,)": "[sqrt(3)/3,sqrt(3)/3,sqrt(3)/3]",
            "Qs(1,E,,0)": "[sqrt(6)/3,-sqrt(6)/6,-sqrt(6)/6]",
            "Qs(1,E,,1)": "[0,sqrt(2)/2,-sqrt(2)/2]",
        },
        "1a": {"Qs(0,A1,,)": "[1]"},
    },
    "D3d": {
        "12d": {
            "Qs(0,A1g,,)": "[sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(1,A2u,,)": "[sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(1,Eu,,0)": "[sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,0,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,0,sqrt(2)/4]",
            "Qs(1,Eu,,1)": "[-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12]",
            "Qs(2,Eg,1,0)": "[sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,0,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,0,-sqrt(2)/4]",
            "Qs(2,Eg,1,1)": "[-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12]",
            "Qs(2,Eg,2,0)": "[sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12]",
            "Qs(2,Eg,2,1)": "[sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,0,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,0,-sqrt(2)/4]",
            "Qs(3,A1u,,)": "[-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(3,Eu,2,0)": "[sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12]",
            "Qs(3,Eu,2,1)": "[sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,0,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,0,sqrt(2)/4]",
            "Qs(4,A2g,,)": "[-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
        },
        "6c": {
            "Qs(0,A1g,,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,Eu,,0)": "[sqrt(3)/3,-sqrt(3)/3,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(1,Eu,,1)": "[0,0,1/2,-1/2,1/2,-1/2]",
            "Qs(2,Eg,2,0)": "[sqrt(3)/3,sqrt(3)/3,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(2,Eg,2,1)": "[0,0,-1/2,1/2,1/2,-1/2]",
            "Qs(3,A2u,2,)": "[sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
        },
        "6b": {
            "Qs(0,A1g,,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,Eu,,0)": "[0,1/2,-1/2,0,-1/2,1/2]",
            "Qs(1,Eu,,1)": "[sqrt(3)/3,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/3,sqrt(3)/6,sqrt(3)/6]",
            "Qs(2,Eg,2,0)": "[-sqrt(3)/3,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/3,sqrt(3)/6,sqrt(3)/6]",
            "Qs(2,Eg,2,1)": "[0,1/2,-1/2,0,1/2,-1/2]",
            "Qs(3,A1u,,)": "[-sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
        },
        "2a": {"Qs(0,A1g,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,A2u,,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "1o": {"Qs(0,A1g,,)": "[1]"},
    },
    "D3d-1": {
        "12d": {
            "Qs(0,A1g,,)": "[sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(1,A2u,,)": "[sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(1,Eu,,0)": "[-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12]",
            "Qs(1,Eu,,1)": "[-sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,0,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,0,-sqrt(2)/4]",
            "Qs(2,Eg,1,0)": "[-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12]",
            "Qs(2,Eg,1,1)": "[-sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,0,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,0,sqrt(2)/4]",
            "Qs(2,Eg,2,0)": "[-sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,0,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,0,sqrt(2)/4]",
            "Qs(2,Eg,2,1)": "[sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12]",
            "Qs(3,A1u,,)": "[sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(3,Eu,2,0)": "[-sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,0,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,0,-sqrt(2)/4]",
            "Qs(3,Eu,2,1)": "[sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12]",
            "Qs(4,A2g,,)": "[sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
        },
        "6c": {
            "Qs(0,A1g,,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,Eu,,0)": "[0,0,-1/2,1/2,-1/2,1/2]",
            "Qs(1,Eu,,1)": "[sqrt(3)/3,-sqrt(3)/3,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(2,Eg,2,0)": "[0,0,1/2,-1/2,-1/2,1/2]",
            "Qs(2,Eg,2,1)": "[sqrt(3)/3,sqrt(3)/3,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(3,A2u,2,)": "[-sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6]",
        },
        "6b": {
            "Qs(0,A1g,,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,Eu,,0)": "[sqrt(3)/3,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/3,sqrt(3)/6,sqrt(3)/6]",
            "Qs(1,Eu,,1)": "[0,-1/2,1/2,0,1/2,-1/2]",
            "Qs(2,Eg,2,0)": "[0,-1/2,1/2,0,-1/2,1/2]",
            "Qs(2,Eg,2,1)": "[-sqrt(3)/3,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/3,sqrt(3)/6,sqrt(3)/6]",
            "Qs(3,A1u,,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6]",
        },
        "2a": {"Qs(0,A1g,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,A2u,,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "1o": {"Qs(0,A1g,,)": "[1]"},
    },
    "C6": {
        "6b": {
            "Qs(0,A,,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,E1,,0)": "[1/2,-1/2,0,-1/2,1/2,0]",
            "Qs(1,E1,,1)": "[-sqrt(3)/6,sqrt(3)/6,sqrt(3)/3,-sqrt(3)/6,sqrt(3)/6,-sqrt(3)/3]",
            "Qs(2,E2,,0)": "[sqrt(3)/6,sqrt(3)/6,-sqrt(3)/3,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/3]",
            "Qs(2,E2,,1)": "[1/2,1/2,0,-1/2,-1/2,0]",
            "Qs(3,B,1,)": "[-sqrt(6)/6,sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
        },
        "1a": {"Qs(0,A,,)": "[1]"},
    },
    "C3h": {
        "6c": {
            "Qs(0,A',,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,A'',,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6]",
            "Qs(1,E',,0)": "[-sqrt(3)/6,sqrt(3)/3,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/3]",
            "Qs(1,E',,1)": "[-1/2,0,1/2,-1/2,1/2,0]",
            "Qs(2,E'',,0)": "[-sqrt(3)/6,sqrt(3)/3,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/3]",
            "Qs(2,E'',,1)": "[-1/2,0,1/2,1/2,-1/2,0]",
        },
        "3b": {
            "Qs(0,A',,)": "[sqrt(3)/3,sqrt(3)/3,sqrt(3)/3]",
            "Qs(1,E',,0)": "[sqrt(6)/3,-sqrt(6)/6,-sqrt(6)/6]",
            "Qs(1,E',,1)": "[0,sqrt(2)/2,-sqrt(2)/2]",
        },
        "2a": {"Qs(0,A',,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,A'',,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "1o": {"Qs(0,A',,)": "[1]"},
    },
    "C6h": {
        "12c": {
            "Qs(0,Ag,,)": "[sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(1,Au,,)": "[sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(1,E1u,,0)": "[-sqrt(6)/12,sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6]",
            "Qs(1,E1u,,1)": "[-sqrt(2)/4,sqrt(2)/4,0,sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,-sqrt(2)/4,0,-sqrt(2)/4,sqrt(2)/4,0]",
            "Qs(2,E1g,,0)": "[-sqrt(6)/12,sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6]",
            "Qs(2,E1g,,1)": "[-sqrt(2)/4,sqrt(2)/4,0,sqrt(2)/4,-sqrt(2)/4,0,-sqrt(2)/4,sqrt(2)/4,0,sqrt(2)/4,-sqrt(2)/4,0]",
            "Qs(2,E2g,,0)": "[-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6]",
            "Qs(2,E2g,,1)": "[-sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,sqrt(2)/4,0]",
            "Qs(3,Bu,2,)": "[sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(3,E2u,,0)": "[-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6]",
            "Qs(3,E2u,,1)": "[-sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,sqrt(2)/4,0,sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,-sqrt(2)/4,0]",
            "Qs(4,Bg,1,)": "[sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
        },
        "6b": {
            "Qs(0,Ag,,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,E1u,,0)": "[sqrt(3)/3,-sqrt(3)/3,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(1,E1u,,1)": "[0,0,1/2,-1/2,1/2,-1/2]",
            "Qs(2,E2g,,0)": "[sqrt(3)/3,sqrt(3)/3,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(2,E2g,,1)": "[0,0,1/2,-1/2,-1/2,1/2]",
            "Qs(3,Bu,2,)": "[sqrt(6)/6,-sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6]",
        },
        "2a": {"Qs(0,Ag,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,Au,,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "1o": {"Qs(0,Ag,,)": "[1]"},
    },
    "D6": {
        "12d": {
            "Qs(0,A1,,)": "[sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(1,A2,,)": "[sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(1,E1,,0)": "[-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6]",
            "Qs(1,E1,,1)": "[-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,0,sqrt(2)/4,-sqrt(2)/4,0]",
            "Qs(2,E1,,0)": "[-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,0,sqrt(2)/4,-sqrt(2)/4,0]",
            "Qs(2,E1,,1)": "[sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6]",
            "Qs(2,E2,,0)": "[-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6]",
            "Qs(2,E2,,1)": "[-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,0,sqrt(2)/4,sqrt(2)/4,0]",
            "Qs(3,B2,,)": "[sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(3,E2,,0)": "[-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,0,sqrt(2)/4,sqrt(2)/4,0]",
            "Qs(3,E2,,1)": "[sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6]",
            "Qs(4,B1,,)": "[sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
        },
        "6c": {
            "Qs(0,A1,,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,E1,,0)": "[0,0,-1/2,1/2,1/2,-1/2]",
            "Qs(1,E1,,1)": "[sqrt(3)/3,-sqrt(3)/3,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(2,E2,,0)": "[-sqrt(3)/3,-sqrt(3)/3,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(2,E2,,1)": "[0,0,1/2,-1/2,1/2,-1/2]",
            "Qs(3,B1,,)": "[-sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6]",
        },
        "6b": {
            "Qs(0,A1,,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,E1,,0)": "[sqrt(3)/3,-sqrt(3)/3,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(1,E1,,1)": "[0,0,-1/2,1/2,1/2,-1/2]",
            "Qs(2,E2,,0)": "[sqrt(3)/3,sqrt(3)/3,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(2,E2,,1)": "[0,0,-1/2,1/2,-1/2,1/2]",
            "Qs(3,B2,,)": "[sqrt(6)/6,-sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6]",
        },
        "2a": {"Qs(0,A1,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,A2,,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "1o": {"Qs(0,A1,,)": "[1]"},
    },
    "C6v": {
        "12d": {
            "Qs(0,A1,,)": "[sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(1,E1,,0)": "[sqrt(3)/12+1/4,-1/4-sqrt(3)/12,-sqrt(3)/6,-1/4+sqrt(3)/12,1/4-sqrt(3)/12,sqrt(3)/6,-1/4-sqrt(3)/12,sqrt(3)/6,1/4-sqrt(3)/12,sqrt(3)/12+1/4,-sqrt(3)/6,-1/4+sqrt(3)/12]",
            "Qs(1,E1,,1)": "[1/4-sqrt(3)/12,-1/4+sqrt(3)/12,sqrt(3)/6,-1/4-sqrt(3)/12,sqrt(3)/12+1/4,-sqrt(3)/6,1/4-sqrt(3)/12,sqrt(3)/6,-1/4-sqrt(3)/12,-1/4+sqrt(3)/12,-sqrt(3)/6,sqrt(3)/12+1/4]",
            "Qs(2,E2,,0)": "[sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,0,-sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4]",
            "Qs(2,E2,,1)": "[-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12]",
            "Qs(3,B1,,)": "[sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(3,B2,,)": "[sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(4,E2,1,0)": "[sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12]",
            "Qs(4,E2,1,1)": "[sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,-sqrt(2)/4,0,-sqrt(2)/4,0,sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4]",
            "Qs(5,E1,1,0)": "[1/4-sqrt(3)/12,-1/4+sqrt(3)/12,sqrt(3)/6,-1/4-sqrt(3)/12,sqrt(3)/12+1/4,-sqrt(3)/6,-1/4+sqrt(3)/12,-sqrt(3)/6,sqrt(3)/12+1/4,1/4-sqrt(3)/12,sqrt(3)/6,-1/4-sqrt(3)/12]",
            "Qs(5,E1,1,1)": "[-1/4-sqrt(3)/12,sqrt(3)/12+1/4,sqrt(3)/6,1/4-sqrt(3)/12,-1/4+sqrt(3)/12,-sqrt(3)/6,-1/4-sqrt(3)/12,sqrt(3)/6,1/4-sqrt(3)/12,sqrt(3)/12+1/4,-sqrt(3)/6,-1/4+sqrt(3)/12]",
            "Qs(6,A2,,)": "[sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
        },
        "6c": {
            "Qs(0,A1,,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,E1,,0)": "[0,0,-1/2,1/2,-1/2,1/2]",
            "Qs(1,E1,,1)": "[sqrt(3)/3,-sqrt(3)/3,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(2,E2,,0)": "[-sqrt(3)/3,-sqrt(3)/3,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(2,E2,,1)": "[0,0,-1/2,1/2,1/2,-1/2]",
            "Qs(3,B1,,)": "[-sqrt(6)/6,sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
        },
        "6b": {
            "Qs(0,A1,,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,E1,,0)": "[sqrt(3)/3,-sqrt(3)/3,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(1,E1,,1)": "[0,0,1/2,-1/2,1/2,-1/2]",
            "Qs(2,E2,,0)": "[sqrt(3)/3,sqrt(3)/3,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(2,E2,,1)": "[0,0,1/2,-1/2,-1/2,1/2]",
            "Qs(3,B2,,)": "[sqrt(6)/6,-sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6]",
        },
        "1a": {"Qs(0,A1,,)": "[1]"},
    },
    "D3h": {
        "12e": {
            "Qs(0,A1',,)": "[sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(1,A2'',,)": "[sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(1,E',,0)": "[-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6]",
            "Qs(1,E',,1)": "[-sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,0,sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,0]",
            "Qs(2,E',,0)": "[-sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,0,sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,0]",
            "Qs(2,E',,1)": "[sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6]",
            "Qs(2,E'',,0)": "[-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6]",
            "Qs(2,E'',,1)": "[-sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,0,sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,0]",
            "Qs(3,A2',,)": "[sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(3,E'',,0)": "[-sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,0,sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,0]",
            "Qs(3,E'',,1)": "[sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6]",
            "Qs(4,A1'',,)": "[sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
        },
        "6d": {
            "Qs(0,A1',,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,E',,0)": "[sqrt(3)/3,-sqrt(3)/3,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(1,E',,1)": "[0,0,1/2,-1/2,1/2,-1/2]",
            "Qs(2,E',,0)": "[0,0,-1/2,1/2,1/2,-1/2]",
            "Qs(2,E',,1)": "[-sqrt(3)/3,-sqrt(3)/3,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(3,A2',,)": "[sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
        },
        "6c": {
            "Qs(0,A1',,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,A2'',,)": "[sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,E',,0)": "[0,0,1/2,-1/2,-1/2,1/2]",
            "Qs(1,E',,1)": "[sqrt(3)/3,sqrt(3)/3,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(2,E'',,0)": "[0,0,-1/2,1/2,-1/2,1/2]",
            "Qs(2,E'',,1)": "[sqrt(3)/3,-sqrt(3)/3,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
        },
        "3b": {
            "Qs(0,A1',,)": "[sqrt(3)/3,sqrt(3)/3,sqrt(3)/3]",
            "Qs(1,E',,0)": "[0,sqrt(2)/2,-sqrt(2)/2]",
            "Qs(1,E',,1)": "[sqrt(6)/3,-sqrt(6)/6,-sqrt(6)/6]",
        },
        "2a": {"Qs(0,A1',,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,A2'',,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "1o": {"Qs(0,A1',,)": "[1]"},
    },
    "D3h-1": {
        "12e": {
            "Qs(0,A1',,)": "[sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(1,A2'',,)": "[sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(1,E',,0)": "[sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,0,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,-sqrt(2)/4,0]",
            "Qs(1,E',,1)": "[-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6]",
            "Qs(2,E',,0)": "[sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6]",
            "Qs(2,E',,1)": "[sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,0,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,-sqrt(2)/4,0]",
            "Qs(2,E'',,0)": "[sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,0,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,sqrt(2)/4,0]",
            "Qs(2,E'',,1)": "[-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6]",
            "Qs(3,A2',,)": "[-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(3,E'',,0)": "[sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6]",
            "Qs(3,E'',,1)": "[sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,0,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,sqrt(2)/4,0]",
            "Qs(4,A1'',,)": "[-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
        },
        "6d": {
            "Qs(0,A1',,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,E',,0)": "[0,0,-1/2,1/2,-1/2,1/2]",
            "Qs(1,E',,1)": "[sqrt(3)/3,-sqrt(3)/3,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(2,E',,0)": "[-sqrt(3)/3,-sqrt(3)/3,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(2,E',,1)": "[0,0,1/2,-1/2,-1/2,1/2]",
            "Qs(3,A2',,)": "[-sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6]",
        },
        "6c": {
            "Qs(0,A1',,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,A2'',,)": "[sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,E',,0)": "[sqrt(3)/3,sqrt(3)/3,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(1,E',,1)": "[0,0,-1/2,1/2,1/2,-1/2]",
            "Qs(2,E'',,0)": "[sqrt(3)/3,-sqrt(3)/3,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(2,E'',,1)": "[0,0,1/2,-1/2,1/2,-1/2]",
        },
        "3b": {
            "Qs(0,A1',,)": "[sqrt(3)/3,sqrt(3)/3,sqrt(3)/3]",
            "Qs(1,E',,0)": "[sqrt(6)/3,-sqrt(6)/6,-sqrt(6)/6]",
            "Qs(1,E',,1)": "[0,-sqrt(2)/2,sqrt(2)/2]",
        },
        "2a": {"Qs(0,A1',,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,A2'',,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "1o": {"Qs(0,A1',,)": "[1]"},
    },
    "D6h": {
        "24g": {
            "Qs(0,A1g,,)": "[sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12]",
            "Qs(1,A2u,,)": "[sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12]",
            "Qs(1,E1u,,0)": "[sqrt(6)/24+sqrt(2)/8,-sqrt(2)/8-sqrt(6)/24,sqrt(6)/24+sqrt(2)/8,-sqrt(6)/12,-sqrt(2)/8+sqrt(6)/24,-sqrt(2)/8-sqrt(6)/24,sqrt(6)/12,-sqrt(6)/24+sqrt(2)/8,-sqrt(6)/12,-sqrt(2)/8+sqrt(6)/24,-sqrt(6)/24+sqrt(2)/8,sqrt(6)/12,-sqrt(2)/8-sqrt(6)/24,-sqrt(2)/8-sqrt(6)/24,sqrt(6)/12,-sqrt(6)/24+sqrt(2)/8,sqrt(6)/24+sqrt(2)/8,sqrt(6)/24+sqrt(2)/8,-sqrt(6)/12,-sqrt(2)/8+sqrt(6)/24,sqrt(6)/12,-sqrt(6)/24+sqrt(2)/8,-sqrt(2)/8+sqrt(6)/24,-sqrt(6)/12]",
            "Qs(1,E1u,,1)": "[-sqrt(6)/24+sqrt(2)/8,-sqrt(2)/8+sqrt(6)/24,-sqrt(2)/8+sqrt(6)/24,-sqrt(6)/12,sqrt(6)/24+sqrt(2)/8,-sqrt(6)/24+sqrt(2)/8,sqrt(6)/12,-sqrt(2)/8-sqrt(6)/24,sqrt(6)/12,-sqrt(2)/8-sqrt(6)/24,sqrt(6)/24+sqrt(2)/8,-sqrt(6)/12,-sqrt(2)/8+sqrt(6)/24,-sqrt(6)/24+sqrt(2)/8,sqrt(6)/12,-sqrt(2)/8-sqrt(6)/24,-sqrt(6)/24+sqrt(2)/8,-sqrt(2)/8+sqrt(6)/24,-sqrt(6)/12,sqrt(6)/24+sqrt(2)/8,-sqrt(6)/12,sqrt(6)/24+sqrt(2)/8,-sqrt(2)/8-sqrt(6)/24,sqrt(6)/12]",
            "Qs(2,E1g,,0)": "[sqrt(6)/24+sqrt(2)/8,-sqrt(2)/8-sqrt(6)/24,-sqrt(2)/8-sqrt(6)/24,sqrt(6)/12,-sqrt(6)/24+sqrt(2)/8,sqrt(6)/24+sqrt(2)/8,-sqrt(6)/12,-sqrt(2)/8+sqrt(6)/24,-sqrt(6)/12,-sqrt(2)/8+sqrt(6)/24,-sqrt(6)/24+sqrt(2)/8,sqrt(6)/12,sqrt(6)/24+sqrt(2)/8,-sqrt(2)/8-sqrt(6)/24,sqrt(6)/12,-sqrt(6)/24+sqrt(2)/8,-sqrt(2)/8-sqrt(6)/24,sqrt(6)/24+sqrt(2)/8,-sqrt(6)/12,-sqrt(2)/8+sqrt(6)/24,-sqrt(6)/12,-sqrt(2)/8+sqrt(6)/24,-sqrt(6)/24+sqrt(2)/8,sqrt(6)/12]",
            "Qs(2,E1g,,1)": "[-sqrt(6)/24+sqrt(2)/8,-sqrt(2)/8+sqrt(6)/24,-sqrt(6)/24+sqrt(2)/8,sqrt(6)/12,-sqrt(2)/8-sqrt(6)/24,-sqrt(2)/8+sqrt(6)/24,-sqrt(6)/12,sqrt(6)/24+sqrt(2)/8,sqrt(6)/12,-sqrt(2)/8-sqrt(6)/24,sqrt(6)/24+sqrt(2)/8,-sqrt(6)/12,-sqrt(6)/24+sqrt(2)/8,-sqrt(6)/24+sqrt(2)/8,sqrt(6)/12,-sqrt(2)/8-sqrt(6)/24,-sqrt(2)/8+sqrt(6)/24,-sqrt(2)/8+sqrt(6)/24,-sqrt(6)/12,sqrt(6)/24+sqrt(2)/8,sqrt(6)/12,-sqrt(2)/8-sqrt(6)/24,sqrt(6)/24+sqrt(2)/8,-sqrt(6)/12]",
            "Qs(2,E2g,,0)": "[1/4,1/4,1/4,0,-1/4,1/4,0,-1/4,0,-1/4,-1/4,0,1/4,1/4,0,-1/4,1/4,1/4,0,-1/4,0,-1/4,-1/4,0]",
            "Qs(2,E2g,,1)": "[-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/6,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/6,sqrt(3)/12,sqrt(3)/6,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/6,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/6,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/6,sqrt(3)/12,sqrt(3)/6,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/6]",
            "Qs(3,B1u,,)": "[sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12]",
            "Qs(3,B2u,,)": "[sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12]",
            "Qs(3,E2u,,0)": "[1/4,1/4,-1/4,0,1/4,-1/4,0,1/4,0,-1/4,-1/4,0,-1/4,1/4,0,-1/4,-1/4,1/4,0,-1/4,0,1/4,1/4,0]",
            "Qs(3,E2u,,1)": "[-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/6,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/6,-sqrt(3)/12,sqrt(3)/6,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/6,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/6,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/6,sqrt(3)/12,-sqrt(3)/6,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/6]",
            "Qs(4,B1g,,)": "[sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12]",
            "Qs(4,B2g,,)": "[sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12]",
            "Qs(4,E2g,1,0)": "[sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/6,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/6,sqrt(3)/12,-sqrt(3)/6,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/6,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/6,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/6,sqrt(3)/12,-sqrt(3)/6,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/6]",
            "Qs(4,E2g,1,1)": "[1/4,1/4,-1/4,0,1/4,-1/4,0,1/4,0,-1/4,-1/4,0,1/4,-1/4,0,1/4,1/4,-1/4,0,1/4,0,-1/4,-1/4,0]",
            "Qs(5,E1u,1,0)": "[-sqrt(6)/24+sqrt(2)/8,-sqrt(2)/8+sqrt(6)/24,-sqrt(6)/24+sqrt(2)/8,sqrt(6)/12,-sqrt(2)/8-sqrt(6)/24,-sqrt(2)/8+sqrt(6)/24,-sqrt(6)/12,sqrt(6)/24+sqrt(2)/8,sqrt(6)/12,-sqrt(2)/8-sqrt(6)/24,sqrt(6)/24+sqrt(2)/8,-sqrt(6)/12,-sqrt(2)/8+sqrt(6)/24,-sqrt(2)/8+sqrt(6)/24,-sqrt(6)/12,sqrt(6)/24+sqrt(2)/8,-sqrt(6)/24+sqrt(2)/8,-sqrt(6)/24+sqrt(2)/8,sqrt(6)/12,-sqrt(2)/8-sqrt(6)/24,-sqrt(6)/12,sqrt(6)/24+sqrt(2)/8,-sqrt(2)/8-sqrt(6)/24,sqrt(6)/12]",
            "Qs(5,E1u,1,1)": "[-sqrt(2)/8-sqrt(6)/24,sqrt(6)/24+sqrt(2)/8,sqrt(6)/24+sqrt(2)/8,-sqrt(6)/12,-sqrt(2)/8+sqrt(6)/24,-sqrt(2)/8-sqrt(6)/24,sqrt(6)/12,-sqrt(6)/24+sqrt(2)/8,sqrt(6)/12,-sqrt(6)/24+sqrt(2)/8,-sqrt(2)/8+sqrt(6)/24,-sqrt(6)/12,sqrt(6)/24+sqrt(2)/8,-sqrt(2)/8-sqrt(6)/24,sqrt(6)/12,-sqrt(6)/24+sqrt(2)/8,-sqrt(2)/8-sqrt(6)/24,sqrt(6)/24+sqrt(2)/8,-sqrt(6)/12,-sqrt(2)/8+sqrt(6)/24,-sqrt(6)/12,-sqrt(2)/8+sqrt(6)/24,-sqrt(6)/24+sqrt(2)/8,sqrt(6)/12]",
            "Qs(5,E2u,1,0)": "[sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/6,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/6,-sqrt(3)/12,-sqrt(3)/6,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/6,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/6,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/6,sqrt(3)/12,sqrt(3)/6,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/6]",
            "Qs(5,E2u,1,1)": "[1/4,1/4,1/4,0,-1/4,1/4,0,-1/4,0,-1/4,-1/4,0,-1/4,-1/4,0,1/4,-1/4,-1/4,0,1/4,0,1/4,1/4,0]",
            "Qs(6,A2g,,)": "[sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12]",
            "Qs(6,E1g,1,0)": "[-sqrt(6)/24+sqrt(2)/8,-sqrt(2)/8+sqrt(6)/24,-sqrt(2)/8+sqrt(6)/24,-sqrt(6)/12,sqrt(6)/24+sqrt(2)/8,-sqrt(6)/24+sqrt(2)/8,sqrt(6)/12,-sqrt(2)/8-sqrt(6)/24,sqrt(6)/12,-sqrt(2)/8-sqrt(6)/24,sqrt(6)/24+sqrt(2)/8,-sqrt(6)/12,-sqrt(6)/24+sqrt(2)/8,-sqrt(2)/8+sqrt(6)/24,-sqrt(6)/12,sqrt(6)/24+sqrt(2)/8,-sqrt(2)/8+sqrt(6)/24,-sqrt(6)/24+sqrt(2)/8,sqrt(6)/12,-sqrt(2)/8-sqrt(6)/24,sqrt(6)/12,-sqrt(2)/8-sqrt(6)/24,sqrt(6)/24+sqrt(2)/8,-sqrt(6)/12]",
            "Qs(6,E1g,1,1)": "[-sqrt(2)/8-sqrt(6)/24,sqrt(6)/24+sqrt(2)/8,-sqrt(2)/8-sqrt(6)/24,sqrt(6)/12,-sqrt(6)/24+sqrt(2)/8,sqrt(6)/24+sqrt(2)/8,-sqrt(6)/12,-sqrt(2)/8+sqrt(6)/24,sqrt(6)/12,-sqrt(6)/24+sqrt(2)/8,-sqrt(2)/8+sqrt(6)/24,-sqrt(6)/12,-sqrt(2)/8-sqrt(6)/24,-sqrt(2)/8-sqrt(6)/24,sqrt(6)/12,-sqrt(6)/24+sqrt(2)/8,sqrt(6)/24+sqrt(2)/8,sqrt(6)/24+sqrt(2)/8,-sqrt(6)/12,-sqrt(2)/8+sqrt(6)/24,sqrt(6)/12,-sqrt(6)/24+sqrt(2)/8,-sqrt(2)/8+sqrt(6)/24,-sqrt(6)/12]",
            "Qs(7,A1u,,)": "[sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12]",
        },
        "12f": {
            "Qs(0,A1g,,)": "[sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(1,E1u,,0)": "[sqrt(3)/12+1/4,-1/4-sqrt(3)/12,sqrt(3)/12+1/4,-sqrt(3)/6,-1/4+sqrt(3)/12,-1/4-sqrt(3)/12,sqrt(3)/6,1/4-sqrt(3)/12,-sqrt(3)/6,-1/4+sqrt(3)/12,1/4-sqrt(3)/12,sqrt(3)/6]",
            "Qs(1,E1u,,1)": "[1/4-sqrt(3)/12,-1/4+sqrt(3)/12,-1/4+sqrt(3)/12,-sqrt(3)/6,sqrt(3)/12+1/4,1/4-sqrt(3)/12,sqrt(3)/6,-1/4-sqrt(3)/12,sqrt(3)/6,-1/4-sqrt(3)/12,sqrt(3)/12+1/4,-sqrt(3)/6]",
            "Qs(2,E2g,,0)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,0,-sqrt(2)/4,-sqrt(2)/4,0]",
            "Qs(2,E2g,,1)": "[-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6]",
            "Qs(3,B1u,,)": "[sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(3,B2u,,)": "[sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(4,E2g,1,0)": "[sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6]",
            "Qs(4,E2g,1,1)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,0,-sqrt(2)/4,-sqrt(2)/4,0]",
            "Qs(5,E1u,1,0)": "[1/4-sqrt(3)/12,-1/4+sqrt(3)/12,1/4-sqrt(3)/12,sqrt(3)/6,-1/4-sqrt(3)/12,-1/4+sqrt(3)/12,-sqrt(3)/6,sqrt(3)/12+1/4,sqrt(3)/6,-1/4-sqrt(3)/12,sqrt(3)/12+1/4,-sqrt(3)/6]",
            "Qs(5,E1u,1,1)": "[-1/4-sqrt(3)/12,sqrt(3)/12+1/4,sqrt(3)/12+1/4,-sqrt(3)/6,-1/4+sqrt(3)/12,-1/4-sqrt(3)/12,sqrt(3)/6,1/4-sqrt(3)/12,sqrt(3)/6,1/4-sqrt(3)/12,-1/4+sqrt(3)/12,-sqrt(3)/6]",
            "Qs(6,A2g,,)": "[sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
        },
        "12e": {
            "Qs(0,A1g,,)": "[sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(1,A2u,,)": "[sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(1,E1u,,0)": "[0,0,0,-sqrt(2)/4,sqrt(2)/4,0,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,E1u,,1)": "[sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12]",
            "Qs(2,E1g,,0)": "[0,0,0,sqrt(2)/4,-sqrt(2)/4,0,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4]",
            "Qs(2,E1g,,1)": "[sqrt(6)/6,-sqrt(6)/6,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12]",
            "Qs(2,E2g,,0)": "[-sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12]",
            "Qs(2,E2g,,1)": "[0,0,0,sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(3,B1u,,)": "[-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(3,E2u,,0)": "[-sqrt(6)/6,-sqrt(6)/6,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12]",
            "Qs(3,E2u,,1)": "[0,0,0,-sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(4,B2g,,)": "[-sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
        },
        "12d": {
            "Qs(0,A1g,,)": "[sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(1,A2u,,)": "[sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(1,E1u,,0)": "[sqrt(6)/6,-sqrt(6)/6,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12]",
            "Qs(1,E1u,,1)": "[0,0,0,-sqrt(2)/4,sqrt(2)/4,0,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(2,E1g,,0)": "[sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12]",
            "Qs(2,E1g,,1)": "[0,0,0,sqrt(2)/4,-sqrt(2)/4,0,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(2,E2g,,0)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/6,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12]",
            "Qs(2,E2g,,1)": "[0,0,0,-sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4]",
            "Qs(3,B2u,,)": "[sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(3,E2u,,0)": "[sqrt(6)/6,sqrt(6)/6,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12]",
            "Qs(3,E2u,,1)": "[0,0,0,sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4]",
            "Qs(4,B1g,,)": "[sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
        },
        "6c": {
            "Qs(0,A1g,,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,E1u,,0)": "[0,0,-1/2,1/2,1/2,-1/2]",
            "Qs(1,E1u,,1)": "[sqrt(3)/3,-sqrt(3)/3,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(2,E2g,,0)": "[-sqrt(3)/3,-sqrt(3)/3,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(2,E2g,,1)": "[0,0,1/2,-1/2,1/2,-1/2]",
            "Qs(3,B1u,,)": "[-sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6]",
        },
        "6b": {
            "Qs(0,A1g,,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,E1u,,0)": "[sqrt(3)/3,-sqrt(3)/3,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(1,E1u,,1)": "[0,0,-1/2,1/2,1/2,-1/2]",
            "Qs(2,E2g,,0)": "[sqrt(3)/3,sqrt(3)/3,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6]",
            "Qs(2,E2g,,1)": "[0,0,-1/2,1/2,-1/2,1/2]",
            "Qs(3,B2u,,)": "[sqrt(6)/6,-sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6]",
        },
        "2a": {"Qs(0,A1g,,)": "[sqrt(2)/2,sqrt(2)/2]", "Qs(1,A2u,,)": "[sqrt(2)/2,-sqrt(2)/2]"},
        "1o": {"Qs(0,A1g,,)": "[1]"},
    },
    "T": {
        "12c": {
            "Qs(0,A,,)": "[sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(1,T,,0)": "[sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,0,0,0,0,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,T,,1)": "[sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,0,0,0,0]",
            "Qs(1,T,,2)": "[0,0,0,0,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(2,E,,0)": "[-sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12]",
            "Qs(2,E,,1)": "[0,0,0,0,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
            "Qs(2,T,,0)": "[0,0,0,0,1/2,-1/2,1/2,-1/2,0,0,0,0]",
            "Qs(2,T,,1)": "[0,0,0,0,0,0,0,0,1/2,1/2,-1/2,-1/2]",
            "Qs(2,T,,2)": "[1/2,1/2,-1/2,-1/2,0,0,0,0,0,0,0,0]",
            "Qs(3,T,2,0)": "[sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,0,0,0,0,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(3,T,2,1)": "[-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,0,0,0,0]",
            "Qs(3,T,2,2)": "[0,0,0,0,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
        },
        "6b": {
            "Qs(0,A,,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,T,,0)": "[sqrt(2)/2,-sqrt(2)/2,0,0,0,0]",
            "Qs(1,T,,1)": "[0,0,sqrt(2)/2,-sqrt(2)/2,0,0]",
            "Qs(1,T,,2)": "[0,0,0,0,sqrt(2)/2,-sqrt(2)/2]",
            "Qs(2,E,,0)": "[-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/3,sqrt(3)/3]",
            "Qs(2,E,,1)": "[1/2,1/2,-1/2,-1/2,0,0]",
        },
        "4a": {
            "Qs(0,A,,)": "[1/2,1/2,1/2,1/2]",
            "Qs(1,T,,0)": "[1/2,-1/2,1/2,-1/2]",
            "Qs(1,T,,1)": "[1/2,-1/2,-1/2,1/2]",
            "Qs(1,T,,2)": "[1/2,1/2,-1/2,-1/2]",
        },
        "1o": {"Qs(0,A,,)": "[1]"},
    },
    "Th": {
        "24d": {
            "Qs(0,Ag,,)": "[sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12]",
            "Qs(1,Tu,,0)": "[3*sqrt(7)/28,-3*sqrt(7)/28,3*sqrt(7)/28,-3*sqrt(7)/28,sqrt(7)/28,-sqrt(7)/28,sqrt(7)/28,-sqrt(7)/28,sqrt(7)/14,-sqrt(7)/14,-sqrt(7)/14,sqrt(7)/14,-3*sqrt(7)/28,3*sqrt(7)/28,-3*sqrt(7)/28,3*sqrt(7)/28,-sqrt(7)/28,sqrt(7)/28,-sqrt(7)/28,sqrt(7)/28,-sqrt(7)/14,sqrt(7)/14,sqrt(7)/14,-sqrt(7)/14]",
            "Qs(1,Tu,,1)": "[sqrt(7)/14,-sqrt(7)/14,-sqrt(7)/14,sqrt(7)/14,3*sqrt(7)/28,-3*sqrt(7)/28,-3*sqrt(7)/28,3*sqrt(7)/28,sqrt(7)/28,sqrt(7)/28,-sqrt(7)/28,-sqrt(7)/28,-sqrt(7)/14,sqrt(7)/14,sqrt(7)/14,-sqrt(7)/14,-3*sqrt(7)/28,3*sqrt(7)/28,3*sqrt(7)/28,-3*sqrt(7)/28,-sqrt(7)/28,-sqrt(7)/28,sqrt(7)/28,sqrt(7)/28]",
            "Qs(1,Tu,,2)": "[sqrt(7)/28,sqrt(7)/28,-sqrt(7)/28,-sqrt(7)/28,sqrt(7)/14,sqrt(7)/14,-sqrt(7)/14,-sqrt(7)/14,3*sqrt(7)/28,-3*sqrt(7)/28,3*sqrt(7)/28,-3*sqrt(7)/28,-sqrt(7)/28,-sqrt(7)/28,sqrt(7)/28,sqrt(7)/28,-sqrt(7)/14,-sqrt(7)/14,sqrt(7)/14,sqrt(7)/14,-3*sqrt(7)/28,3*sqrt(7)/28,-3*sqrt(7)/28,3*sqrt(7)/28]",
            "Qs(2,Eg,,0)": "[-11*sqrt(3)/84,-11*sqrt(3)/84,-11*sqrt(3)/84,-11*sqrt(3)/84,-sqrt(3)/42,-sqrt(3)/42,-sqrt(3)/42,-sqrt(3)/42,13*sqrt(3)/84,13*sqrt(3)/84,13*sqrt(3)/84,13*sqrt(3)/84,-11*sqrt(3)/84,-11*sqrt(3)/84,-11*sqrt(3)/84,-11*sqrt(3)/84,-sqrt(3)/42,-sqrt(3)/42,-sqrt(3)/42,-sqrt(3)/42,13*sqrt(3)/84,13*sqrt(3)/84,13*sqrt(3)/84,13*sqrt(3)/84]",
            "Qs(2,Eg,,1)": "[5/28,5/28,5/28,5/28,-2/7,-2/7,-2/7,-2/7,3/28,3/28,3/28,3/28,5/28,5/28,5/28,5/28,-2/7,-2/7,-2/7,-2/7,3/28,3/28,3/28,3/28]",
            "Qs(2,Tg,,0)": "[sqrt(2)/14,-sqrt(2)/14,sqrt(2)/14,-sqrt(2)/14,3*sqrt(2)/14,-3*sqrt(2)/14,3*sqrt(2)/14,-3*sqrt(2)/14,3*sqrt(2)/28,-3*sqrt(2)/28,-3*sqrt(2)/28,3*sqrt(2)/28,sqrt(2)/14,-sqrt(2)/14,sqrt(2)/14,-sqrt(2)/14,3*sqrt(2)/14,-3*sqrt(2)/14,3*sqrt(2)/14,-3*sqrt(2)/14,3*sqrt(2)/28,-3*sqrt(2)/28,-3*sqrt(2)/28,3*sqrt(2)/28]",
            "Qs(2,Tg,,1)": "[3*sqrt(2)/28,-3*sqrt(2)/28,-3*sqrt(2)/28,3*sqrt(2)/28,sqrt(2)/14,-sqrt(2)/14,-sqrt(2)/14,sqrt(2)/14,3*sqrt(2)/14,3*sqrt(2)/14,-3*sqrt(2)/14,-3*sqrt(2)/14,3*sqrt(2)/28,-3*sqrt(2)/28,-3*sqrt(2)/28,3*sqrt(2)/28,sqrt(2)/14,-sqrt(2)/14,-sqrt(2)/14,sqrt(2)/14,3*sqrt(2)/14,3*sqrt(2)/14,-3*sqrt(2)/14,-3*sqrt(2)/14]",
            "Qs(2,Tg,,2)": "[3*sqrt(2)/14,3*sqrt(2)/14,-3*sqrt(2)/14,-3*sqrt(2)/14,3*sqrt(2)/28,3*sqrt(2)/28,-3*sqrt(2)/28,-3*sqrt(2)/28,sqrt(2)/14,-sqrt(2)/14,sqrt(2)/14,-sqrt(2)/14,3*sqrt(2)/14,3*sqrt(2)/14,-3*sqrt(2)/14,-3*sqrt(2)/14,3*sqrt(2)/28,3*sqrt(2)/28,-3*sqrt(2)/28,-3*sqrt(2)/28,sqrt(2)/14,-sqrt(2)/14,sqrt(2)/14,-sqrt(2)/14]",
            "Qs(3,Au,,)": "[sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12]",
            "Qs(3,Tu,1,0)": "[sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12]",
            "Qs(3,Tu,1,1)": "[-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12]",
            "Qs(3,Tu,1,2)": "[-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12]",
            "Qs(3,Tu,2,0)": "[sqrt(21)/84,-sqrt(21)/84,sqrt(21)/84,-sqrt(21)/84,5*sqrt(21)/84,-5*sqrt(21)/84,5*sqrt(21)/84,-5*sqrt(21)/84,-sqrt(21)/21,sqrt(21)/21,sqrt(21)/21,-sqrt(21)/21,-sqrt(21)/84,sqrt(21)/84,-sqrt(21)/84,sqrt(21)/84,-5*sqrt(21)/84,5*sqrt(21)/84,-5*sqrt(21)/84,5*sqrt(21)/84,sqrt(21)/21,-sqrt(21)/21,-sqrt(21)/21,sqrt(21)/21]",
            "Qs(3,Tu,2,1)": "[-sqrt(21)/21,sqrt(21)/21,sqrt(21)/21,-sqrt(21)/21,sqrt(21)/84,-sqrt(21)/84,-sqrt(21)/84,sqrt(21)/84,5*sqrt(21)/84,5*sqrt(21)/84,-5*sqrt(21)/84,-5*sqrt(21)/84,sqrt(21)/21,-sqrt(21)/21,-sqrt(21)/21,sqrt(21)/21,-sqrt(21)/84,sqrt(21)/84,sqrt(21)/84,-sqrt(21)/84,-5*sqrt(21)/84,-5*sqrt(21)/84,5*sqrt(21)/84,5*sqrt(21)/84]",
            "Qs(3,Tu,2,2)": "[5*sqrt(21)/84,5*sqrt(21)/84,-5*sqrt(21)/84,-5*sqrt(21)/84,-sqrt(21)/21,-sqrt(21)/21,sqrt(21)/21,sqrt(21)/21,sqrt(21)/84,-sqrt(21)/84,sqrt(21)/84,-sqrt(21)/84,-5*sqrt(21)/84,-5*sqrt(21)/84,5*sqrt(21)/84,5*sqrt(21)/84,sqrt(21)/21,sqrt(21)/21,-sqrt(21)/21,-sqrt(21)/21,-sqrt(21)/84,sqrt(21)/84,-sqrt(21)/84,sqrt(21)/84]",
            "Qs(4,Tg,1,0)": "[9*sqrt(829)/23212,-9*sqrt(829)/23212,9*sqrt(829)/23212,-9*sqrt(829)/23212,125*sqrt(829)/23212,-125*sqrt(829)/23212,125*sqrt(829)/23212,-125*sqrt(829)/23212,-64*sqrt(829)/5803,64*sqrt(829)/5803,64*sqrt(829)/5803,-64*sqrt(829)/5803,9*sqrt(829)/23212,-9*sqrt(829)/23212,9*sqrt(829)/23212,-9*sqrt(829)/23212,125*sqrt(829)/23212,-125*sqrt(829)/23212,125*sqrt(829)/23212,-125*sqrt(829)/23212,-64*sqrt(829)/5803,64*sqrt(829)/5803,64*sqrt(829)/5803,-64*sqrt(829)/5803]",
            "Qs(4,Tg,1,1)": "[-64*sqrt(829)/5803,64*sqrt(829)/5803,64*sqrt(829)/5803,-64*sqrt(829)/5803,9*sqrt(829)/23212,-9*sqrt(829)/23212,-9*sqrt(829)/23212,9*sqrt(829)/23212,125*sqrt(829)/23212,125*sqrt(829)/23212,-125*sqrt(829)/23212,-125*sqrt(829)/23212,-64*sqrt(829)/5803,64*sqrt(829)/5803,64*sqrt(829)/5803,-64*sqrt(829)/5803,9*sqrt(829)/23212,-9*sqrt(829)/23212,-9*sqrt(829)/23212,9*sqrt(829)/23212,125*sqrt(829)/23212,125*sqrt(829)/23212,-125*sqrt(829)/23212,-125*sqrt(829)/23212]",
            "Qs(4,Tg,1,2)": "[125*sqrt(829)/23212,125*sqrt(829)/23212,-125*sqrt(829)/23212,-125*sqrt(829)/23212,-64*sqrt(829)/5803,-64*sqrt(829)/5803,64*sqrt(829)/5803,64*sqrt(829)/5803,9*sqrt(829)/23212,-9*sqrt(829)/23212,9*sqrt(829)/23212,-9*sqrt(829)/23212,125*sqrt(829)/23212,125*sqrt(829)/23212,-125*sqrt(829)/23212,-125*sqrt(829)/23212,-64*sqrt(829)/5803,-64*sqrt(829)/5803,64*sqrt(829)/5803,64*sqrt(829)/5803,9*sqrt(829)/23212,-9*sqrt(829)/23212,9*sqrt(829)/23212,-9*sqrt(829)/23212]",
            "Qs(4,Tg,2,0)": "[39*sqrt(829)/3316,-39*sqrt(829)/3316,39*sqrt(829)/3316,-39*sqrt(829)/3316,-11*sqrt(829)/3316,11*sqrt(829)/3316,-11*sqrt(829)/3316,11*sqrt(829)/3316,-sqrt(829)/829,sqrt(829)/829,sqrt(829)/829,-sqrt(829)/829,39*sqrt(829)/3316,-39*sqrt(829)/3316,39*sqrt(829)/3316,-39*sqrt(829)/3316,-11*sqrt(829)/3316,11*sqrt(829)/3316,-11*sqrt(829)/3316,11*sqrt(829)/3316,-sqrt(829)/829,sqrt(829)/829,sqrt(829)/829,-sqrt(829)/829]",
            "Qs(4,Tg,2,1)": "[-sqrt(829)/829,sqrt(829)/829,sqrt(829)/829,-sqrt(829)/829,39*sqrt(829)/3316,-39*sqrt(829)/3316,-39*sqrt(829)/3316,39*sqrt(829)/3316,-11*sqrt(829)/3316,-11*sqrt(829)/3316,11*sqrt(829)/3316,11*sqrt(829)/3316,-sqrt(829)/829,sqrt(829)/829,sqrt(829)/829,-sqrt(829)/829,39*sqrt(829)/3316,-39*sqrt(829)/3316,-39*sqrt(829)/3316,39*sqrt(829)/3316,-11*sqrt(829)/3316,-11*sqrt(829)/3316,11*sqrt(829)/3316,11*sqrt(829)/3316]",
            "Qs(4,Tg,2,2)": "[-11*sqrt(829)/3316,-11*sqrt(829)/3316,11*sqrt(829)/3316,11*sqrt(829)/3316,-sqrt(829)/829,-sqrt(829)/829,sqrt(829)/829,sqrt(829)/829,39*sqrt(829)/3316,-39*sqrt(829)/3316,39*sqrt(829)/3316,-39*sqrt(829)/3316,-11*sqrt(829)/3316,-11*sqrt(829)/3316,11*sqrt(829)/3316,11*sqrt(829)/3316,-sqrt(829)/829,-sqrt(829)/829,sqrt(829)/829,sqrt(829)/829,39*sqrt(829)/3316,-39*sqrt(829)/3316,39*sqrt(829)/3316,-39*sqrt(829)/3316]",
            "Qs(5,Eu,,0)": "[5/28,5/28,5/28,5/28,-2/7,-2/7,-2/7,-2/7,3/28,3/28,3/28,3/28,-5/28,-5/28,-5/28,-5/28,2/7,2/7,2/7,2/7,-3/28,-3/28,-3/28,-3/28]",
            "Qs(5,Eu,,1)": "[11*sqrt(3)/84,11*sqrt(3)/84,11*sqrt(3)/84,11*sqrt(3)/84,sqrt(3)/42,sqrt(3)/42,sqrt(3)/42,sqrt(3)/42,-13*sqrt(3)/84,-13*sqrt(3)/84,-13*sqrt(3)/84,-13*sqrt(3)/84,-11*sqrt(3)/84,-11*sqrt(3)/84,-11*sqrt(3)/84,-11*sqrt(3)/84,-sqrt(3)/42,-sqrt(3)/42,-sqrt(3)/42,-sqrt(3)/42,13*sqrt(3)/84,13*sqrt(3)/84,13*sqrt(3)/84,13*sqrt(3)/84]",
        },
        "12c": {
            "Qs(0,Ag,,)": "[sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(1,Tu,,0)": "[0,0,0,0,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,Tu,,1)": "[sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,0,0,0,0,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
            "Qs(1,Tu,,2)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,0,0,0,0]",
            "Qs(2,Eg,,0)": "[sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6]",
            "Qs(2,Eg,,1)": "[-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,0,0,0,0]",
            "Qs(2,Tg,,0)": "[1/2,-1/2,1/2,-1/2,0,0,0,0,0,0,0,0]",
            "Qs(2,Tg,,1)": "[0,0,0,0,1/2,-1/2,-1/2,1/2,0,0,0,0]",
            "Qs(2,Tg,,2)": "[0,0,0,0,0,0,0,0,1/2,-1/2,1/2,-1/2]",
            "Qs(3,Tu,2,0)": "[0,0,0,0,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4]",
            "Qs(3,Tu,2,1)": "[sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,0,0,0,0,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
            "Qs(3,Tu,2,2)": "[-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,0,0,0,0]",
        },
        "8b": {
            "Qs(0,Ag,,)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,Tu,,0)": "[sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,Tu,,1)": "[sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(1,Tu,,2)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
            "Qs(2,Tg,,0)": "[sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(2,Tg,,1)": "[sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4]",
            "Qs(2,Tg,,2)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
            "Qs(3,Au,,)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
        },
        "6a": {
            "Qs(0,Ag,,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,Tu,,0)": "[sqrt(2)/2,-sqrt(2)/2,0,0,0,0]",
            "Qs(1,Tu,,1)": "[0,0,sqrt(2)/2,-sqrt(2)/2,0,0]",
            "Qs(1,Tu,,2)": "[0,0,0,0,sqrt(2)/2,-sqrt(2)/2]",
            "Qs(2,Eg,,0)": "[-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/3,sqrt(3)/3]",
            "Qs(2,Eg,,1)": "[1/2,1/2,-1/2,-1/2,0,0]",
        },
        "1o": {"Qs(0,Ag,,)": "[1]"},
    },
    "O": {
        "24d": {
            "Qs(0,A1,,)": "[sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12]",
            "Qs(1,T1,,0)": "[sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,sqrt(10)/20,0,-sqrt(10)/10,-sqrt(10)/20,0,-sqrt(10)/10,0,0,0,0,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,sqrt(10)/10,0,sqrt(10)/20,sqrt(10)/10,0]",
            "Qs(1,T1,,1)": "[sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,sqrt(10)/10,-sqrt(10)/20,0,-sqrt(10)/10,-sqrt(10)/20,0,sqrt(10)/10,-sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,0,0,0,0,sqrt(10)/10,0,sqrt(10)/20,-sqrt(10)/10,0,sqrt(10)/20]",
            "Qs(1,T1,,2)": "[0,0,0,0,0,sqrt(10)/10,sqrt(10)/20,0,-sqrt(10)/10,-sqrt(10)/20,sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,0,sqrt(10)/20,-sqrt(10)/10,0,-sqrt(10)/20,sqrt(10)/10]",
            "Qs(2,E,,0)": "[-5*sqrt(39)/156,-5*sqrt(39)/156,-5*sqrt(39)/156,-5*sqrt(39)/156,-5*sqrt(39)/156,7*sqrt(39)/156,-sqrt(39)/78,-5*sqrt(39)/156,7*sqrt(39)/156,-sqrt(39)/78,-sqrt(39)/78,-sqrt(39)/78,-sqrt(39)/78,-sqrt(39)/78,7*sqrt(39)/156,7*sqrt(39)/156,7*sqrt(39)/156,7*sqrt(39)/156,-5*sqrt(39)/156,-sqrt(39)/78,7*sqrt(39)/156,-5*sqrt(39)/156,-sqrt(39)/78,7*sqrt(39)/156]",
            "Qs(2,E,,1)": "[3*sqrt(13)/52,3*sqrt(13)/52,3*sqrt(13)/52,3*sqrt(13)/52,-3*sqrt(13)/52,-sqrt(13)/52,sqrt(13)/13,-3*sqrt(13)/52,-sqrt(13)/52,sqrt(13)/13,-sqrt(13)/13,-sqrt(13)/13,-sqrt(13)/13,-sqrt(13)/13,sqrt(13)/52,sqrt(13)/52,sqrt(13)/52,sqrt(13)/52,-3*sqrt(13)/52,sqrt(13)/13,-sqrt(13)/52,-3*sqrt(13)/52,sqrt(13)/13,-sqrt(13)/52]",
            "Qs(2,T2,,0)": "[0,0,0,0,0,-sqrt(2)/4,0,0,sqrt(2)/4,0,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,0,0,0,0,0,0,-sqrt(2)/4,0,0,sqrt(2)/4]",
            "Qs(2,T2,,1)": "[0,0,0,0,0,0,-sqrt(2)/4,0,0,sqrt(2)/4,0,0,0,0,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,0,sqrt(2)/4,0,0,-sqrt(2)/4,0]",
            "Qs(2,T2,,2)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,0,0,sqrt(2)/4,0,0,0,0,0,0,0,0,0,0,-sqrt(2)/4,0,0,-sqrt(2)/4,0,0]",
            "Qs(3,T1,,0)": "[sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/10,0,-sqrt(10)/20,sqrt(10)/10,0,-sqrt(10)/20,0,0,0,0,-sqrt(10)/10,sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,sqrt(10)/20,0,-sqrt(10)/10,sqrt(10)/20,0]",
            "Qs(3,T1,,1)": "[-sqrt(10)/10,sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,sqrt(10)/20,sqrt(10)/10,0,-sqrt(10)/20,sqrt(10)/10,0,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,0,0,0,0,sqrt(10)/20,0,-sqrt(10)/10,-sqrt(10)/20,0,-sqrt(10)/10]",
            "Qs(3,T1,,2)": "[0,0,0,0,0,sqrt(10)/20,-sqrt(10)/10,0,-sqrt(10)/20,sqrt(10)/10,-sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,sqrt(10)/10,sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,0,-sqrt(10)/10,-sqrt(10)/20,0,sqrt(10)/10,sqrt(10)/20]",
            "Qs(3,T2,,0)": "[sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,sqrt(10)/10,0,sqrt(10)/20,-sqrt(10)/10,0,sqrt(10)/20,0,0,0,0,-sqrt(10)/10,sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,-sqrt(10)/10,-sqrt(10)/20,0,sqrt(10)/10,-sqrt(10)/20,0]",
            "Qs(3,T2,,1)": "[-sqrt(10)/10,sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,-sqrt(10)/20,-sqrt(10)/10,0,sqrt(10)/20,-sqrt(10)/10,0,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,0,0,0,0,-sqrt(10)/20,0,sqrt(10)/10,sqrt(10)/20,0,sqrt(10)/10]",
            "Qs(3,T2,,2)": "[0,0,0,0,0,-sqrt(10)/20,sqrt(10)/10,0,sqrt(10)/20,-sqrt(10)/10,-sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,sqrt(10)/10,sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,0,sqrt(10)/10,sqrt(10)/20,0,-sqrt(10)/10,-sqrt(10)/20]",
            "Qs(4,E,,0)": "[3*sqrt(13)/52,3*sqrt(13)/52,3*sqrt(13)/52,3*sqrt(13)/52,3*sqrt(13)/52,sqrt(13)/52,-sqrt(13)/13,3*sqrt(13)/52,sqrt(13)/52,-sqrt(13)/13,-sqrt(13)/13,-sqrt(13)/13,-sqrt(13)/13,-sqrt(13)/13,sqrt(13)/52,sqrt(13)/52,sqrt(13)/52,sqrt(13)/52,3*sqrt(13)/52,-sqrt(13)/13,sqrt(13)/52,3*sqrt(13)/52,-sqrt(13)/13,sqrt(13)/52]",
            "Qs(4,E,,1)": "[5*sqrt(39)/156,5*sqrt(39)/156,5*sqrt(39)/156,5*sqrt(39)/156,-5*sqrt(39)/156,7*sqrt(39)/156,-sqrt(39)/78,-5*sqrt(39)/156,7*sqrt(39)/156,-sqrt(39)/78,sqrt(39)/78,sqrt(39)/78,sqrt(39)/78,sqrt(39)/78,-7*sqrt(39)/156,-7*sqrt(39)/156,-7*sqrt(39)/156,-7*sqrt(39)/156,-5*sqrt(39)/156,-sqrt(39)/78,7*sqrt(39)/156,-5*sqrt(39)/156,-sqrt(39)/78,7*sqrt(39)/156]",
            "Qs(4,T1,,0)": "[0,0,0,0,0,sqrt(2)/4,0,0,-sqrt(2)/4,0,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,0,0,0,0,0,0,sqrt(2)/4,0,0,-sqrt(2)/4]",
            "Qs(4,T1,,1)": "[0,0,0,0,0,0,sqrt(2)/4,0,0,-sqrt(2)/4,0,0,0,0,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,0,-sqrt(2)/4,0,0,sqrt(2)/4,0]",
            "Qs(4,T1,,2)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,0,0,-sqrt(2)/4,0,0,0,0,0,0,0,0,0,0,sqrt(2)/4,0,0,sqrt(2)/4,0,0]",
            "Qs(5,T2,,0)": "[sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,-sqrt(10)/20,0,sqrt(10)/10,sqrt(10)/20,0,sqrt(10)/10,0,0,0,0,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,sqrt(10)/20,-sqrt(10)/10,0,-sqrt(10)/20,-sqrt(10)/10,0]",
            "Qs(5,T2,,1)": "[sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,-sqrt(10)/10,sqrt(10)/20,0,sqrt(10)/10,sqrt(10)/20,0,sqrt(10)/10,-sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,0,0,0,0,-sqrt(10)/10,0,-sqrt(10)/20,sqrt(10)/10,0,-sqrt(10)/20]",
            "Qs(5,T2,,2)": "[0,0,0,0,0,-sqrt(10)/10,-sqrt(10)/20,0,sqrt(10)/10,sqrt(10)/20,sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,0,-sqrt(10)/20,sqrt(10)/10,0,sqrt(10)/20,-sqrt(10)/10]",
            "Qs(6,A2,,)": "[sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12]",
        },
        "12c": {
            "Qs(0,A1,,)": "[sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(1,T1,,0)": "[0,0,0,0,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(1,T1,,1)": "[sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,0,-sqrt(2)/4,0,0,sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,T1,,2)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,0,-sqrt(2)/4,0,sqrt(2)/4,sqrt(2)/4,0,0]",
            "Qs(2,E,,0)": "[sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,-sqrt(6)/6]",
            "Qs(2,E,,1)": "[-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,0,sqrt(2)/4,0,sqrt(2)/4,sqrt(2)/4,0,0]",
            "Qs(2,T2,,0)": "[1/2,-1/2,1/2,-1/2,0,0,0,0,0,0,0,0]",
            "Qs(2,T2,,1)": "[0,0,0,0,-1/2,0,1/2,0,1/2,-1/2,0,0]",
            "Qs(2,T2,,2)": "[0,0,0,0,0,-1/2,0,1/2,0,0,1/2,-1/2]",
            "Qs(3,T2,,0)": "[0,0,0,0,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(3,T2,,1)": "[sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,0,sqrt(2)/4,0,sqrt(2)/4,0,0,-sqrt(2)/4,-sqrt(2)/4]",
            "Qs(3,T2,,2)": "[-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,0,-sqrt(2)/4,0,sqrt(2)/4,sqrt(2)/4,0,0]",
        },
        "8b": {
            "Qs(0,A1,,)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,T1,,0)": "[sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
            "Qs(1,T1,,1)": "[sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(1,T1,,2)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(2,T2,,0)": "[sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
            "Qs(2,T2,,1)": "[sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4]",
            "Qs(2,T2,,2)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4]",
            "Qs(3,A2,,)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
        },
        "6a": {
            "Qs(0,A1,,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,T1,,0)": "[sqrt(2)/2,-sqrt(2)/2,0,0,0,0]",
            "Qs(1,T1,,1)": "[0,0,sqrt(2)/2,0,-sqrt(2)/2,0]",
            "Qs(1,T1,,2)": "[0,0,0,sqrt(2)/2,0,-sqrt(2)/2]",
            "Qs(2,E,,0)": "[-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/3,-sqrt(3)/6,sqrt(3)/3]",
            "Qs(2,E,,1)": "[1/2,1/2,-1/2,0,-1/2,0]",
        },
        "1o": {"Qs(0,A1,,)": "[1]"},
    },
    "Td": {
        "24d": {
            "Qs(0,A1,,)": "[sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12]",
            "Qs(1,T2,,0)": "[sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,0,0,0,0,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,0,sqrt(10)/10,sqrt(10)/20,0,sqrt(10)/10,sqrt(10)/20,-sqrt(10)/10,0,-sqrt(10)/20,-sqrt(10)/10,0]",
            "Qs(1,T2,,1)": "[sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,sqrt(10)/10,-sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,0,0,0,0,-sqrt(10)/10,sqrt(10)/20,0,sqrt(10)/10,sqrt(10)/20,0,-sqrt(10)/10,0,-sqrt(10)/20,sqrt(10)/10,0,-sqrt(10)/20]",
            "Qs(1,T2,,2)": "[0,0,0,0,sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,0,-sqrt(10)/10,-sqrt(10)/20,0,sqrt(10)/10,sqrt(10)/20,0,-sqrt(10)/20,sqrt(10)/10,0,sqrt(10)/20,-sqrt(10)/10]",
            "Qs(2,E,,0)": "[-5*sqrt(39)/156,-5*sqrt(39)/156,-5*sqrt(39)/156,-5*sqrt(39)/156,-sqrt(39)/78,-sqrt(39)/78,-sqrt(39)/78,-sqrt(39)/78,7*sqrt(39)/156,7*sqrt(39)/156,7*sqrt(39)/156,7*sqrt(39)/156,-5*sqrt(39)/156,7*sqrt(39)/156,-sqrt(39)/78,-5*sqrt(39)/156,7*sqrt(39)/156,-sqrt(39)/78,-5*sqrt(39)/156,-sqrt(39)/78,7*sqrt(39)/156,-5*sqrt(39)/156,-sqrt(39)/78,7*sqrt(39)/156]",
            "Qs(2,E,,1)": "[3*sqrt(13)/52,3*sqrt(13)/52,3*sqrt(13)/52,3*sqrt(13)/52,-sqrt(13)/13,-sqrt(13)/13,-sqrt(13)/13,-sqrt(13)/13,sqrt(13)/52,sqrt(13)/52,sqrt(13)/52,sqrt(13)/52,-3*sqrt(13)/52,-sqrt(13)/52,sqrt(13)/13,-3*sqrt(13)/52,-sqrt(13)/52,sqrt(13)/13,-3*sqrt(13)/52,sqrt(13)/13,-sqrt(13)/52,-3*sqrt(13)/52,sqrt(13)/13,-sqrt(13)/52]",
            "Qs(2,T2,,0)": "[0,0,0,0,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,0,0,0,0,0,-sqrt(2)/4,0,0,sqrt(2)/4,0,0,0,-sqrt(2)/4,0,0,sqrt(2)/4]",
            "Qs(2,T2,,1)": "[0,0,0,0,0,0,0,0,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,0,0,-sqrt(2)/4,0,0,sqrt(2)/4,0,sqrt(2)/4,0,0,-sqrt(2)/4,0]",
            "Qs(2,T2,,2)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,0,0,0,0,0,0,0,0,sqrt(2)/4,0,0,sqrt(2)/4,0,0,-sqrt(2)/4,0,0,-sqrt(2)/4,0,0]",
            "Qs(3,T1,,0)": "[sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,0,0,0,0,-sqrt(10)/10,sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,-sqrt(10)/10,0,-sqrt(10)/20,sqrt(10)/10,0,-sqrt(10)/20,sqrt(10)/10,sqrt(10)/20,0,-sqrt(10)/10,sqrt(10)/20,0]",
            "Qs(3,T1,,1)": "[-sqrt(10)/10,sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,0,0,0,0,sqrt(10)/20,sqrt(10)/10,0,-sqrt(10)/20,sqrt(10)/10,0,sqrt(10)/20,0,-sqrt(10)/10,-sqrt(10)/20,0,-sqrt(10)/10]",
            "Qs(3,T1,,2)": "[0,0,0,0,-sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,sqrt(10)/10,sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,0,sqrt(10)/20,-sqrt(10)/10,0,-sqrt(10)/20,sqrt(10)/10,0,-sqrt(10)/10,-sqrt(10)/20,0,sqrt(10)/10,sqrt(10)/20]",
            "Qs(3,T2,,0)": "[sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,0,0,0,0,-sqrt(10)/10,sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,0,sqrt(10)/20,-sqrt(10)/10,0,sqrt(10)/20,-sqrt(10)/10,-sqrt(10)/20,0,sqrt(10)/10,-sqrt(10)/20,0]",
            "Qs(3,T2,,1)": "[-sqrt(10)/10,sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,0,0,0,0,-sqrt(10)/20,-sqrt(10)/10,0,sqrt(10)/20,-sqrt(10)/10,0,-sqrt(10)/20,0,sqrt(10)/10,sqrt(10)/20,0,sqrt(10)/10]",
            "Qs(3,T2,,2)": "[0,0,0,0,-sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,sqrt(10)/10,sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,0,-sqrt(10)/20,sqrt(10)/10,0,sqrt(10)/20,-sqrt(10)/10,0,sqrt(10)/10,sqrt(10)/20,0,-sqrt(10)/10,-sqrt(10)/20]",
            "Qs(4,E,,0)": "[3*sqrt(13)/52,3*sqrt(13)/52,3*sqrt(13)/52,3*sqrt(13)/52,-sqrt(13)/13,-sqrt(13)/13,-sqrt(13)/13,-sqrt(13)/13,sqrt(13)/52,sqrt(13)/52,sqrt(13)/52,sqrt(13)/52,3*sqrt(13)/52,sqrt(13)/52,-sqrt(13)/13,3*sqrt(13)/52,sqrt(13)/52,-sqrt(13)/13,3*sqrt(13)/52,-sqrt(13)/13,sqrt(13)/52,3*sqrt(13)/52,-sqrt(13)/13,sqrt(13)/52]",
            "Qs(4,E,,1)": "[5*sqrt(39)/156,5*sqrt(39)/156,5*sqrt(39)/156,5*sqrt(39)/156,sqrt(39)/78,sqrt(39)/78,sqrt(39)/78,sqrt(39)/78,-7*sqrt(39)/156,-7*sqrt(39)/156,-7*sqrt(39)/156,-7*sqrt(39)/156,-5*sqrt(39)/156,7*sqrt(39)/156,-sqrt(39)/78,-5*sqrt(39)/156,7*sqrt(39)/156,-sqrt(39)/78,-5*sqrt(39)/156,-sqrt(39)/78,7*sqrt(39)/156,-5*sqrt(39)/156,-sqrt(39)/78,7*sqrt(39)/156]",
            "Qs(4,T1,,0)": "[0,0,0,0,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,0,0,0,0,0,sqrt(2)/4,0,0,-sqrt(2)/4,0,0,0,sqrt(2)/4,0,0,-sqrt(2)/4]",
            "Qs(4,T1,,1)": "[0,0,0,0,0,0,0,0,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,0,0,sqrt(2)/4,0,0,-sqrt(2)/4,0,-sqrt(2)/4,0,0,sqrt(2)/4,0]",
            "Qs(4,T1,,2)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,0,0,0,0,0,0,0,0,-sqrt(2)/4,0,0,-sqrt(2)/4,0,0,sqrt(2)/4,0,0,sqrt(2)/4,0,0]",
            "Qs(5,T1,,0)": "[sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,0,0,0,0,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,sqrt(10)/20,0,-sqrt(10)/10,-sqrt(10)/20,0,-sqrt(10)/10,-sqrt(10)/20,sqrt(10)/10,0,sqrt(10)/20,sqrt(10)/10,0]",
            "Qs(5,T1,,1)": "[sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,sqrt(10)/10,-sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,0,0,0,0,sqrt(10)/10,-sqrt(10)/20,0,-sqrt(10)/10,-sqrt(10)/20,0,sqrt(10)/10,0,sqrt(10)/20,-sqrt(10)/10,0,sqrt(10)/20]",
            "Qs(5,T1,,2)": "[0,0,0,0,sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,0,sqrt(10)/10,sqrt(10)/20,0,-sqrt(10)/10,-sqrt(10)/20,0,sqrt(10)/20,-sqrt(10)/10,0,-sqrt(10)/20,sqrt(10)/10]",
            "Qs(6,A2,,)": "[sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12]",
        },
        "12c": {
            "Qs(0,A1,,)": "[sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(1,T2,,0)": "[sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,0,0,0,0,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,T2,,1)": "[sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,0,0,0,0]",
            "Qs(1,T2,,2)": "[0,0,0,0,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(2,E,,0)": "[-sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12]",
            "Qs(2,E,,1)": "[0,0,0,0,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
            "Qs(2,T2,,0)": "[0,0,0,0,1/2,-1/2,1/2,-1/2,0,0,0,0]",
            "Qs(2,T2,,1)": "[0,0,0,0,0,0,0,0,1/2,1/2,-1/2,-1/2]",
            "Qs(2,T2,,2)": "[1/2,1/2,-1/2,-1/2,0,0,0,0,0,0,0,0]",
            "Qs(3,T1,,0)": "[sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,0,0,0,0,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(3,T1,,1)": "[-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,0,0,0,0]",
            "Qs(3,T1,,2)": "[0,0,0,0,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
        },
        "6b": {
            "Qs(0,A1,,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,T2,,0)": "[sqrt(2)/2,-sqrt(2)/2,0,0,0,0]",
            "Qs(1,T2,,1)": "[0,0,sqrt(2)/2,-sqrt(2)/2,0,0]",
            "Qs(1,T2,,2)": "[0,0,0,0,sqrt(2)/2,-sqrt(2)/2]",
            "Qs(2,E,,0)": "[-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/3,sqrt(3)/3]",
            "Qs(2,E,,1)": "[1/2,1/2,-1/2,-1/2,0,0]",
        },
        "4a": {
            "Qs(0,A1,,)": "[1/2,1/2,1/2,1/2]",
            "Qs(1,T2,,0)": "[1/2,-1/2,1/2,-1/2]",
            "Qs(1,T2,,1)": "[1/2,-1/2,-1/2,1/2]",
            "Qs(1,T2,,2)": "[1/2,1/2,-1/2,-1/2]",
        },
        "1o": {"Qs(0,A1,,)": "[1]"},
    },
    "Oh": {
        "48f": {
            "Qs(0,A1g,,)": "[sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12]",
            "Qs(1,T1u,,0)": "[3*sqrt(14)/56,-3*sqrt(14)/56,3*sqrt(14)/56,-3*sqrt(14)/56,sqrt(14)/28,sqrt(14)/56,-3*sqrt(14)/56,-sqrt(14)/28,-sqrt(14)/56,-3*sqrt(14)/56,sqrt(14)/56,-sqrt(14)/56,sqrt(14)/56,-sqrt(14)/56,sqrt(14)/28,-sqrt(14)/28,-sqrt(14)/28,sqrt(14)/28,-sqrt(14)/28,3*sqrt(14)/56,sqrt(14)/56,sqrt(14)/28,3*sqrt(14)/56,-sqrt(14)/56,-3*sqrt(14)/56,3*sqrt(14)/56,-3*sqrt(14)/56,3*sqrt(14)/56,-sqrt(14)/28,-sqrt(14)/56,3*sqrt(14)/56,sqrt(14)/28,sqrt(14)/56,3*sqrt(14)/56,-sqrt(14)/56,sqrt(14)/56,-sqrt(14)/56,sqrt(14)/56,-sqrt(14)/28,sqrt(14)/28,sqrt(14)/28,-sqrt(14)/28,sqrt(14)/28,-3*sqrt(14)/56,-sqrt(14)/56,-sqrt(14)/28,-3*sqrt(14)/56,sqrt(14)/56]",
            "Qs(1,T1u,,1)": "[sqrt(14)/28,-sqrt(14)/28,-sqrt(14)/28,sqrt(14)/28,3*sqrt(14)/56,-sqrt(14)/28,sqrt(14)/56,-3*sqrt(14)/56,-sqrt(14)/28,-sqrt(14)/56,3*sqrt(14)/56,-3*sqrt(14)/56,-3*sqrt(14)/56,3*sqrt(14)/56,sqrt(14)/56,sqrt(14)/56,-sqrt(14)/56,-sqrt(14)/56,3*sqrt(14)/56,-sqrt(14)/56,sqrt(14)/28,-3*sqrt(14)/56,sqrt(14)/56,sqrt(14)/28,-sqrt(14)/28,sqrt(14)/28,sqrt(14)/28,-sqrt(14)/28,-3*sqrt(14)/56,sqrt(14)/28,-sqrt(14)/56,3*sqrt(14)/56,sqrt(14)/28,sqrt(14)/56,-3*sqrt(14)/56,3*sqrt(14)/56,3*sqrt(14)/56,-3*sqrt(14)/56,-sqrt(14)/56,-sqrt(14)/56,sqrt(14)/56,sqrt(14)/56,-3*sqrt(14)/56,sqrt(14)/56,-sqrt(14)/28,3*sqrt(14)/56,-sqrt(14)/56,-sqrt(14)/28]",
            "Qs(1,T1u,,2)": "[sqrt(14)/56,sqrt(14)/56,-sqrt(14)/56,-sqrt(14)/56,-sqrt(14)/56,3*sqrt(14)/56,sqrt(14)/28,-sqrt(14)/56,-3*sqrt(14)/56,-sqrt(14)/28,sqrt(14)/28,sqrt(14)/28,-sqrt(14)/28,-sqrt(14)/28,3*sqrt(14)/56,-3*sqrt(14)/56,3*sqrt(14)/56,-3*sqrt(14)/56,sqrt(14)/56,sqrt(14)/28,-3*sqrt(14)/56,sqrt(14)/56,-sqrt(14)/28,3*sqrt(14)/56,-sqrt(14)/56,-sqrt(14)/56,sqrt(14)/56,sqrt(14)/56,sqrt(14)/56,-3*sqrt(14)/56,-sqrt(14)/28,sqrt(14)/56,3*sqrt(14)/56,sqrt(14)/28,-sqrt(14)/28,-sqrt(14)/28,sqrt(14)/28,sqrt(14)/28,-3*sqrt(14)/56,3*sqrt(14)/56,-3*sqrt(14)/56,3*sqrt(14)/56,-sqrt(14)/56,-sqrt(14)/28,3*sqrt(14)/56,-sqrt(14)/56,sqrt(14)/28,-3*sqrt(14)/56]",
            "Qs(2,Eg,,0)": "[-11*sqrt(6)/168,-11*sqrt(6)/168,-11*sqrt(6)/168,-11*sqrt(6)/168,-11*sqrt(6)/168,13*sqrt(6)/168,-sqrt(6)/84,-11*sqrt(6)/168,13*sqrt(6)/168,-sqrt(6)/84,-sqrt(6)/84,-sqrt(6)/84,-sqrt(6)/84,-sqrt(6)/84,13*sqrt(6)/168,13*sqrt(6)/168,13*sqrt(6)/168,13*sqrt(6)/168,-11*sqrt(6)/168,-sqrt(6)/84,13*sqrt(6)/168,-11*sqrt(6)/168,-sqrt(6)/84,13*sqrt(6)/168,-11*sqrt(6)/168,-11*sqrt(6)/168,-11*sqrt(6)/168,-11*sqrt(6)/168,-11*sqrt(6)/168,13*sqrt(6)/168,-sqrt(6)/84,-11*sqrt(6)/168,13*sqrt(6)/168,-sqrt(6)/84,-sqrt(6)/84,-sqrt(6)/84,-sqrt(6)/84,-sqrt(6)/84,13*sqrt(6)/168,13*sqrt(6)/168,13*sqrt(6)/168,13*sqrt(6)/168,-11*sqrt(6)/168,-sqrt(6)/84,13*sqrt(6)/168,-11*sqrt(6)/168,-sqrt(6)/84,13*sqrt(6)/168]",
            "Qs(2,Eg,,1)": "[5*sqrt(2)/56,5*sqrt(2)/56,5*sqrt(2)/56,5*sqrt(2)/56,-5*sqrt(2)/56,-3*sqrt(2)/56,sqrt(2)/7,-5*sqrt(2)/56,-3*sqrt(2)/56,sqrt(2)/7,-sqrt(2)/7,-sqrt(2)/7,-sqrt(2)/7,-sqrt(2)/7,3*sqrt(2)/56,3*sqrt(2)/56,3*sqrt(2)/56,3*sqrt(2)/56,-5*sqrt(2)/56,sqrt(2)/7,-3*sqrt(2)/56,-5*sqrt(2)/56,sqrt(2)/7,-3*sqrt(2)/56,5*sqrt(2)/56,5*sqrt(2)/56,5*sqrt(2)/56,5*sqrt(2)/56,-5*sqrt(2)/56,-3*sqrt(2)/56,sqrt(2)/7,-5*sqrt(2)/56,-3*sqrt(2)/56,sqrt(2)/7,-sqrt(2)/7,-sqrt(2)/7,-sqrt(2)/7,-sqrt(2)/7,3*sqrt(2)/56,3*sqrt(2)/56,3*sqrt(2)/56,3*sqrt(2)/56,-5*sqrt(2)/56,sqrt(2)/7,-3*sqrt(2)/56,-5*sqrt(2)/56,sqrt(2)/7,-3*sqrt(2)/56]",
            "Qs(2,T2g,,0)": "[1/14,-1/14,1/14,-1/14,-3/28,-3/14,1/14,3/28,3/14,1/14,3/14,-3/14,3/14,-3/14,3/28,-3/28,-3/28,3/28,3/28,-1/14,-3/14,-3/28,-1/14,3/14,1/14,-1/14,1/14,-1/14,-3/28,-3/14,1/14,3/28,3/14,1/14,3/14,-3/14,3/14,-3/14,3/28,-3/28,-3/28,3/28,3/28,-1/14,-3/14,-3/28,-1/14,3/14]",
            "Qs(2,T2g,,1)": "[3/28,-3/28,-3/28,3/28,-1/14,3/28,-3/14,1/14,3/28,3/14,1/14,-1/14,-1/14,1/14,3/14,3/14,-3/14,-3/14,-1/14,3/14,-3/28,1/14,-3/14,-3/28,3/28,-3/28,-3/28,3/28,-1/14,3/28,-3/14,1/14,3/28,3/14,1/14,-1/14,-1/14,1/14,3/14,3/14,-3/14,-3/14,-1/14,3/14,-3/28,1/14,-3/14,-3/28]",
            "Qs(2,T2g,,2)": "[3/14,3/14,-3/14,-3/14,3/14,-1/14,-3/28,3/14,1/14,3/28,3/28,3/28,-3/28,-3/28,1/14,-1/14,1/14,-1/14,-3/14,-3/28,1/14,-3/14,3/28,-1/14,3/14,3/14,-3/14,-3/14,3/14,-1/14,-3/28,3/14,1/14,3/28,3/28,3/28,-3/28,-3/28,1/14,-1/14,1/14,-1/14,-3/14,-3/28,1/14,-3/14,3/28,-1/14]",
            "Qs(3,A2u,,)": "[sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12]",
            "Qs(3,T1u,,0)": "[sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12]",
            "Qs(3,T1u,,1)": "[-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12]",
            "Qs(3,T1u,,2)": "[-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12]",
            "Qs(3,T2u,,0)": "[9*sqrt(362)/1448,-9*sqrt(362)/1448,9*sqrt(362)/1448,-9*sqrt(362)/1448,2*sqrt(362)/181,-5*sqrt(362)/1448,9*sqrt(362)/1448,-2*sqrt(362)/181,5*sqrt(362)/1448,9*sqrt(362)/1448,5*sqrt(362)/1448,-5*sqrt(362)/1448,5*sqrt(362)/1448,-5*sqrt(362)/1448,-2*sqrt(362)/181,2*sqrt(362)/181,2*sqrt(362)/181,-2*sqrt(362)/181,-2*sqrt(362)/181,-9*sqrt(362)/1448,-5*sqrt(362)/1448,2*sqrt(362)/181,-9*sqrt(362)/1448,5*sqrt(362)/1448,-9*sqrt(362)/1448,9*sqrt(362)/1448,-9*sqrt(362)/1448,9*sqrt(362)/1448,-2*sqrt(362)/181,5*sqrt(362)/1448,-9*sqrt(362)/1448,2*sqrt(362)/181,-5*sqrt(362)/1448,-9*sqrt(362)/1448,-5*sqrt(362)/1448,5*sqrt(362)/1448,-5*sqrt(362)/1448,5*sqrt(362)/1448,2*sqrt(362)/181,-2*sqrt(362)/181,-2*sqrt(362)/181,2*sqrt(362)/181,2*sqrt(362)/181,9*sqrt(362)/1448,5*sqrt(362)/1448,-2*sqrt(362)/181,9*sqrt(362)/1448,-5*sqrt(362)/1448]",
            "Qs(3,T2u,,1)": "[-2*sqrt(362)/181,2*sqrt(362)/181,2*sqrt(362)/181,-2*sqrt(362)/181,-9*sqrt(362)/1448,-2*sqrt(362)/181,-5*sqrt(362)/1448,9*sqrt(362)/1448,-2*sqrt(362)/181,5*sqrt(362)/1448,9*sqrt(362)/1448,-9*sqrt(362)/1448,-9*sqrt(362)/1448,9*sqrt(362)/1448,5*sqrt(362)/1448,5*sqrt(362)/1448,-5*sqrt(362)/1448,-5*sqrt(362)/1448,-9*sqrt(362)/1448,5*sqrt(362)/1448,2*sqrt(362)/181,9*sqrt(362)/1448,-5*sqrt(362)/1448,2*sqrt(362)/181,2*sqrt(362)/181,-2*sqrt(362)/181,-2*sqrt(362)/181,2*sqrt(362)/181,9*sqrt(362)/1448,2*sqrt(362)/181,5*sqrt(362)/1448,-9*sqrt(362)/1448,2*sqrt(362)/181,-5*sqrt(362)/1448,-9*sqrt(362)/1448,9*sqrt(362)/1448,9*sqrt(362)/1448,-9*sqrt(362)/1448,-5*sqrt(362)/1448,-5*sqrt(362)/1448,5*sqrt(362)/1448,5*sqrt(362)/1448,9*sqrt(362)/1448,-5*sqrt(362)/1448,-2*sqrt(362)/181,-9*sqrt(362)/1448,5*sqrt(362)/1448,-2*sqrt(362)/181]",
            "Qs(3,T2u,,2)": "[5*sqrt(362)/1448,5*sqrt(362)/1448,-5*sqrt(362)/1448,-5*sqrt(362)/1448,5*sqrt(362)/1448,-9*sqrt(362)/1448,2*sqrt(362)/181,5*sqrt(362)/1448,9*sqrt(362)/1448,-2*sqrt(362)/181,-2*sqrt(362)/181,-2*sqrt(362)/181,2*sqrt(362)/181,2*sqrt(362)/181,9*sqrt(362)/1448,-9*sqrt(362)/1448,9*sqrt(362)/1448,-9*sqrt(362)/1448,-5*sqrt(362)/1448,2*sqrt(362)/181,9*sqrt(362)/1448,-5*sqrt(362)/1448,-2*sqrt(362)/181,-9*sqrt(362)/1448,-5*sqrt(362)/1448,-5*sqrt(362)/1448,5*sqrt(362)/1448,5*sqrt(362)/1448,-5*sqrt(362)/1448,9*sqrt(362)/1448,-2*sqrt(362)/181,-5*sqrt(362)/1448,-9*sqrt(362)/1448,2*sqrt(362)/181,2*sqrt(362)/181,2*sqrt(362)/181,-2*sqrt(362)/181,-2*sqrt(362)/181,-9*sqrt(362)/1448,9*sqrt(362)/1448,-9*sqrt(362)/1448,9*sqrt(362)/1448,5*sqrt(362)/1448,-2*sqrt(362)/181,-9*sqrt(362)/1448,5*sqrt(362)/1448,2*sqrt(362)/181,9*sqrt(362)/1448]",
            "Qs(4,Eg,,0)": "[5*sqrt(2)/56,5*sqrt(2)/56,5*sqrt(2)/56,5*sqrt(2)/56,5*sqrt(2)/56,3*sqrt(2)/56,-sqrt(2)/7,5*sqrt(2)/56,3*sqrt(2)/56,-sqrt(2)/7,-sqrt(2)/7,-sqrt(2)/7,-sqrt(2)/7,-sqrt(2)/7,3*sqrt(2)/56,3*sqrt(2)/56,3*sqrt(2)/56,3*sqrt(2)/56,5*sqrt(2)/56,-sqrt(2)/7,3*sqrt(2)/56,5*sqrt(2)/56,-sqrt(2)/7,3*sqrt(2)/56,5*sqrt(2)/56,5*sqrt(2)/56,5*sqrt(2)/56,5*sqrt(2)/56,5*sqrt(2)/56,3*sqrt(2)/56,-sqrt(2)/7,5*sqrt(2)/56,3*sqrt(2)/56,-sqrt(2)/7,-sqrt(2)/7,-sqrt(2)/7,-sqrt(2)/7,-sqrt(2)/7,3*sqrt(2)/56,3*sqrt(2)/56,3*sqrt(2)/56,3*sqrt(2)/56,5*sqrt(2)/56,-sqrt(2)/7,3*sqrt(2)/56,5*sqrt(2)/56,-sqrt(2)/7,3*sqrt(2)/56]",
            "Qs(4,Eg,,1)": "[11*sqrt(6)/168,11*sqrt(6)/168,11*sqrt(6)/168,11*sqrt(6)/168,-11*sqrt(6)/168,13*sqrt(6)/168,-sqrt(6)/84,-11*sqrt(6)/168,13*sqrt(6)/168,-sqrt(6)/84,sqrt(6)/84,sqrt(6)/84,sqrt(6)/84,sqrt(6)/84,-13*sqrt(6)/168,-13*sqrt(6)/168,-13*sqrt(6)/168,-13*sqrt(6)/168,-11*sqrt(6)/168,-sqrt(6)/84,13*sqrt(6)/168,-11*sqrt(6)/168,-sqrt(6)/84,13*sqrt(6)/168,11*sqrt(6)/168,11*sqrt(6)/168,11*sqrt(6)/168,11*sqrt(6)/168,-11*sqrt(6)/168,13*sqrt(6)/168,-sqrt(6)/84,-11*sqrt(6)/168,13*sqrt(6)/168,-sqrt(6)/84,sqrt(6)/84,sqrt(6)/84,sqrt(6)/84,sqrt(6)/84,-13*sqrt(6)/168,-13*sqrt(6)/168,-13*sqrt(6)/168,-13*sqrt(6)/168,-11*sqrt(6)/168,-sqrt(6)/84,13*sqrt(6)/168,-11*sqrt(6)/168,-sqrt(6)/84,13*sqrt(6)/168]",
            "Qs(4,T1g,,0)": "[sqrt(42)/168,-sqrt(42)/168,sqrt(42)/168,-sqrt(42)/168,-sqrt(42)/42,5*sqrt(42)/168,-sqrt(42)/168,sqrt(42)/42,-5*sqrt(42)/168,-sqrt(42)/168,5*sqrt(42)/168,-5*sqrt(42)/168,5*sqrt(42)/168,-5*sqrt(42)/168,-sqrt(42)/42,sqrt(42)/42,sqrt(42)/42,-sqrt(42)/42,sqrt(42)/42,sqrt(42)/168,5*sqrt(42)/168,-sqrt(42)/42,sqrt(42)/168,-5*sqrt(42)/168,sqrt(42)/168,-sqrt(42)/168,sqrt(42)/168,-sqrt(42)/168,-sqrt(42)/42,5*sqrt(42)/168,-sqrt(42)/168,sqrt(42)/42,-5*sqrt(42)/168,-sqrt(42)/168,5*sqrt(42)/168,-5*sqrt(42)/168,5*sqrt(42)/168,-5*sqrt(42)/168,-sqrt(42)/42,sqrt(42)/42,sqrt(42)/42,-sqrt(42)/42,sqrt(42)/42,sqrt(42)/168,5*sqrt(42)/168,-sqrt(42)/42,sqrt(42)/168,-5*sqrt(42)/168]",
            "Qs(4,T1g,,1)": "[-sqrt(42)/42,sqrt(42)/42,sqrt(42)/42,-sqrt(42)/42,sqrt(42)/168,sqrt(42)/42,5*sqrt(42)/168,-sqrt(42)/168,sqrt(42)/42,-5*sqrt(42)/168,sqrt(42)/168,-sqrt(42)/168,-sqrt(42)/168,sqrt(42)/168,5*sqrt(42)/168,5*sqrt(42)/168,-5*sqrt(42)/168,-5*sqrt(42)/168,sqrt(42)/168,-5*sqrt(42)/168,-sqrt(42)/42,-sqrt(42)/168,5*sqrt(42)/168,-sqrt(42)/42,-sqrt(42)/42,sqrt(42)/42,sqrt(42)/42,-sqrt(42)/42,sqrt(42)/168,sqrt(42)/42,5*sqrt(42)/168,-sqrt(42)/168,sqrt(42)/42,-5*sqrt(42)/168,sqrt(42)/168,-sqrt(42)/168,-sqrt(42)/168,sqrt(42)/168,5*sqrt(42)/168,5*sqrt(42)/168,-5*sqrt(42)/168,-5*sqrt(42)/168,sqrt(42)/168,-5*sqrt(42)/168,-sqrt(42)/42,-sqrt(42)/168,5*sqrt(42)/168,-sqrt(42)/42]",
            "Qs(4,T1g,,2)": "[5*sqrt(42)/168,5*sqrt(42)/168,-5*sqrt(42)/168,-5*sqrt(42)/168,-5*sqrt(42)/168,sqrt(42)/168,-sqrt(42)/42,-5*sqrt(42)/168,-sqrt(42)/168,sqrt(42)/42,-sqrt(42)/42,-sqrt(42)/42,sqrt(42)/42,sqrt(42)/42,sqrt(42)/168,-sqrt(42)/168,sqrt(42)/168,-sqrt(42)/168,5*sqrt(42)/168,-sqrt(42)/42,-sqrt(42)/168,5*sqrt(42)/168,sqrt(42)/42,sqrt(42)/168,5*sqrt(42)/168,5*sqrt(42)/168,-5*sqrt(42)/168,-5*sqrt(42)/168,-5*sqrt(42)/168,sqrt(42)/168,-sqrt(42)/42,-5*sqrt(42)/168,-sqrt(42)/168,sqrt(42)/42,-sqrt(42)/42,-sqrt(42)/42,sqrt(42)/42,sqrt(42)/42,sqrt(42)/168,-sqrt(42)/168,sqrt(42)/168,-sqrt(42)/168,5*sqrt(42)/168,-sqrt(42)/42,-sqrt(42)/168,5*sqrt(42)/168,sqrt(42)/42,sqrt(42)/168]",
            "Qs(4,T2g,,0)": "[111*sqrt(362)/10136,-111*sqrt(362)/10136,111*sqrt(362)/10136,-111*sqrt(362)/10136,-11*sqrt(362)/2534,59*sqrt(362)/10136,111*sqrt(362)/10136,11*sqrt(362)/2534,-59*sqrt(362)/10136,111*sqrt(362)/10136,-59*sqrt(362)/10136,59*sqrt(362)/10136,-59*sqrt(362)/10136,59*sqrt(362)/10136,11*sqrt(362)/2534,-11*sqrt(362)/2534,-11*sqrt(362)/2534,11*sqrt(362)/2534,11*sqrt(362)/2534,-111*sqrt(362)/10136,59*sqrt(362)/10136,-11*sqrt(362)/2534,-111*sqrt(362)/10136,-59*sqrt(362)/10136,111*sqrt(362)/10136,-111*sqrt(362)/10136,111*sqrt(362)/10136,-111*sqrt(362)/10136,-11*sqrt(362)/2534,59*sqrt(362)/10136,111*sqrt(362)/10136,11*sqrt(362)/2534,-59*sqrt(362)/10136,111*sqrt(362)/10136,-59*sqrt(362)/10136,59*sqrt(362)/10136,-59*sqrt(362)/10136,59*sqrt(362)/10136,11*sqrt(362)/2534,-11*sqrt(362)/2534,-11*sqrt(362)/2534,11*sqrt(362)/2534,11*sqrt(362)/2534,-111*sqrt(362)/10136,59*sqrt(362)/10136,-11*sqrt(362)/2534,-111*sqrt(362)/10136,-59*sqrt(362)/10136]",
            "Qs(4,T2g,,1)": "[11*sqrt(362)/2534,-11*sqrt(362)/2534,-11*sqrt(362)/2534,11*sqrt(362)/2534,-111*sqrt(362)/10136,11*sqrt(362)/2534,59*sqrt(362)/10136,111*sqrt(362)/10136,11*sqrt(362)/2534,-59*sqrt(362)/10136,111*sqrt(362)/10136,-111*sqrt(362)/10136,-111*sqrt(362)/10136,111*sqrt(362)/10136,-59*sqrt(362)/10136,-59*sqrt(362)/10136,59*sqrt(362)/10136,59*sqrt(362)/10136,-111*sqrt(362)/10136,-59*sqrt(362)/10136,-11*sqrt(362)/2534,111*sqrt(362)/10136,59*sqrt(362)/10136,-11*sqrt(362)/2534,11*sqrt(362)/2534,-11*sqrt(362)/2534,-11*sqrt(362)/2534,11*sqrt(362)/2534,-111*sqrt(362)/10136,11*sqrt(362)/2534,59*sqrt(362)/10136,111*sqrt(362)/10136,11*sqrt(362)/2534,-59*sqrt(362)/10136,111*sqrt(362)/10136,-111*sqrt(362)/10136,-111*sqrt(362)/10136,111*sqrt(362)/10136,-59*sqrt(362)/10136,-59*sqrt(362)/10136,59*sqrt(362)/10136,59*sqrt(362)/10136,-111*sqrt(362)/10136,-59*sqrt(362)/10136,-11*sqrt(362)/2534,111*sqrt(362)/10136,59*sqrt(362)/10136,-11*sqrt(362)/2534]",
            "Qs(4,T2g,,2)": "[-59*sqrt(362)/10136,-59*sqrt(362)/10136,59*sqrt(362)/10136,59*sqrt(362)/10136,-59*sqrt(362)/10136,-111*sqrt(362)/10136,-11*sqrt(362)/2534,-59*sqrt(362)/10136,111*sqrt(362)/10136,11*sqrt(362)/2534,11*sqrt(362)/2534,11*sqrt(362)/2534,-11*sqrt(362)/2534,-11*sqrt(362)/2534,111*sqrt(362)/10136,-111*sqrt(362)/10136,111*sqrt(362)/10136,-111*sqrt(362)/10136,59*sqrt(362)/10136,-11*sqrt(362)/2534,111*sqrt(362)/10136,59*sqrt(362)/10136,11*sqrt(362)/2534,-111*sqrt(362)/10136,-59*sqrt(362)/10136,-59*sqrt(362)/10136,59*sqrt(362)/10136,59*sqrt(362)/10136,-59*sqrt(362)/10136,-111*sqrt(362)/10136,-11*sqrt(362)/2534,-59*sqrt(362)/10136,111*sqrt(362)/10136,11*sqrt(362)/2534,11*sqrt(362)/2534,11*sqrt(362)/2534,-11*sqrt(362)/2534,-11*sqrt(362)/2534,111*sqrt(362)/10136,-111*sqrt(362)/10136,111*sqrt(362)/10136,-111*sqrt(362)/10136,59*sqrt(362)/10136,-11*sqrt(362)/2534,111*sqrt(362)/10136,59*sqrt(362)/10136,11*sqrt(362)/2534,-111*sqrt(362)/10136]",
            "Qs(5,Eu,,0)": "[5*sqrt(2)/56,5*sqrt(2)/56,5*sqrt(2)/56,5*sqrt(2)/56,5*sqrt(2)/56,3*sqrt(2)/56,-sqrt(2)/7,5*sqrt(2)/56,3*sqrt(2)/56,-sqrt(2)/7,-sqrt(2)/7,-sqrt(2)/7,-sqrt(2)/7,-sqrt(2)/7,3*sqrt(2)/56,3*sqrt(2)/56,3*sqrt(2)/56,3*sqrt(2)/56,5*sqrt(2)/56,-sqrt(2)/7,3*sqrt(2)/56,5*sqrt(2)/56,-sqrt(2)/7,3*sqrt(2)/56,-5*sqrt(2)/56,-5*sqrt(2)/56,-5*sqrt(2)/56,-5*sqrt(2)/56,-5*sqrt(2)/56,-3*sqrt(2)/56,sqrt(2)/7,-5*sqrt(2)/56,-3*sqrt(2)/56,sqrt(2)/7,sqrt(2)/7,sqrt(2)/7,sqrt(2)/7,sqrt(2)/7,-3*sqrt(2)/56,-3*sqrt(2)/56,-3*sqrt(2)/56,-3*sqrt(2)/56,-5*sqrt(2)/56,sqrt(2)/7,-3*sqrt(2)/56,-5*sqrt(2)/56,sqrt(2)/7,-3*sqrt(2)/56]",
            "Qs(5,Eu,,1)": "[11*sqrt(6)/168,11*sqrt(6)/168,11*sqrt(6)/168,11*sqrt(6)/168,-11*sqrt(6)/168,13*sqrt(6)/168,-sqrt(6)/84,-11*sqrt(6)/168,13*sqrt(6)/168,-sqrt(6)/84,sqrt(6)/84,sqrt(6)/84,sqrt(6)/84,sqrt(6)/84,-13*sqrt(6)/168,-13*sqrt(6)/168,-13*sqrt(6)/168,-13*sqrt(6)/168,-11*sqrt(6)/168,-sqrt(6)/84,13*sqrt(6)/168,-11*sqrt(6)/168,-sqrt(6)/84,13*sqrt(6)/168,-11*sqrt(6)/168,-11*sqrt(6)/168,-11*sqrt(6)/168,-11*sqrt(6)/168,11*sqrt(6)/168,-13*sqrt(6)/168,sqrt(6)/84,11*sqrt(6)/168,-13*sqrt(6)/168,sqrt(6)/84,-sqrt(6)/84,-sqrt(6)/84,-sqrt(6)/84,-sqrt(6)/84,13*sqrt(6)/168,13*sqrt(6)/168,13*sqrt(6)/168,13*sqrt(6)/168,11*sqrt(6)/168,sqrt(6)/84,-13*sqrt(6)/168,11*sqrt(6)/168,sqrt(6)/84,-13*sqrt(6)/168]",
            "Qs(5,T1u,1,0)": "[sqrt(42)/168,-sqrt(42)/168,sqrt(42)/168,-sqrt(42)/168,-sqrt(42)/42,5*sqrt(42)/168,-sqrt(42)/168,sqrt(42)/42,-5*sqrt(42)/168,-sqrt(42)/168,5*sqrt(42)/168,-5*sqrt(42)/168,5*sqrt(42)/168,-5*sqrt(42)/168,-sqrt(42)/42,sqrt(42)/42,sqrt(42)/42,-sqrt(42)/42,sqrt(42)/42,sqrt(42)/168,5*sqrt(42)/168,-sqrt(42)/42,sqrt(42)/168,-5*sqrt(42)/168,-sqrt(42)/168,sqrt(42)/168,-sqrt(42)/168,sqrt(42)/168,sqrt(42)/42,-5*sqrt(42)/168,sqrt(42)/168,-sqrt(42)/42,5*sqrt(42)/168,sqrt(42)/168,-5*sqrt(42)/168,5*sqrt(42)/168,-5*sqrt(42)/168,5*sqrt(42)/168,sqrt(42)/42,-sqrt(42)/42,-sqrt(42)/42,sqrt(42)/42,-sqrt(42)/42,-sqrt(42)/168,-5*sqrt(42)/168,sqrt(42)/42,-sqrt(42)/168,5*sqrt(42)/168]",
            "Qs(5,T1u,1,1)": "[-sqrt(42)/42,sqrt(42)/42,sqrt(42)/42,-sqrt(42)/42,sqrt(42)/168,sqrt(42)/42,5*sqrt(42)/168,-sqrt(42)/168,sqrt(42)/42,-5*sqrt(42)/168,sqrt(42)/168,-sqrt(42)/168,-sqrt(42)/168,sqrt(42)/168,5*sqrt(42)/168,5*sqrt(42)/168,-5*sqrt(42)/168,-5*sqrt(42)/168,sqrt(42)/168,-5*sqrt(42)/168,-sqrt(42)/42,-sqrt(42)/168,5*sqrt(42)/168,-sqrt(42)/42,sqrt(42)/42,-sqrt(42)/42,-sqrt(42)/42,sqrt(42)/42,-sqrt(42)/168,-sqrt(42)/42,-5*sqrt(42)/168,sqrt(42)/168,-sqrt(42)/42,5*sqrt(42)/168,-sqrt(42)/168,sqrt(42)/168,sqrt(42)/168,-sqrt(42)/168,-5*sqrt(42)/168,-5*sqrt(42)/168,5*sqrt(42)/168,5*sqrt(42)/168,-sqrt(42)/168,5*sqrt(42)/168,sqrt(42)/42,sqrt(42)/168,-5*sqrt(42)/168,sqrt(42)/42]",
            "Qs(5,T1u,1,2)": "[5*sqrt(42)/168,5*sqrt(42)/168,-5*sqrt(42)/168,-5*sqrt(42)/168,-5*sqrt(42)/168,sqrt(42)/168,-sqrt(42)/42,-5*sqrt(42)/168,-sqrt(42)/168,sqrt(42)/42,-sqrt(42)/42,-sqrt(42)/42,sqrt(42)/42,sqrt(42)/42,sqrt(42)/168,-sqrt(42)/168,sqrt(42)/168,-sqrt(42)/168,5*sqrt(42)/168,-sqrt(42)/42,-sqrt(42)/168,5*sqrt(42)/168,sqrt(42)/42,sqrt(42)/168,-5*sqrt(42)/168,-5*sqrt(42)/168,5*sqrt(42)/168,5*sqrt(42)/168,5*sqrt(42)/168,-sqrt(42)/168,sqrt(42)/42,5*sqrt(42)/168,sqrt(42)/168,-sqrt(42)/42,sqrt(42)/42,sqrt(42)/42,-sqrt(42)/42,-sqrt(42)/42,-sqrt(42)/168,sqrt(42)/168,-sqrt(42)/168,sqrt(42)/168,-5*sqrt(42)/168,sqrt(42)/42,sqrt(42)/168,-5*sqrt(42)/168,-sqrt(42)/42,-sqrt(42)/168]",
            "Qs(5,T2u,,0)": "[111*sqrt(362)/10136,-111*sqrt(362)/10136,111*sqrt(362)/10136,-111*sqrt(362)/10136,-11*sqrt(362)/2534,59*sqrt(362)/10136,111*sqrt(362)/10136,11*sqrt(362)/2534,-59*sqrt(362)/10136,111*sqrt(362)/10136,-59*sqrt(362)/10136,59*sqrt(362)/10136,-59*sqrt(362)/10136,59*sqrt(362)/10136,11*sqrt(362)/2534,-11*sqrt(362)/2534,-11*sqrt(362)/2534,11*sqrt(362)/2534,11*sqrt(362)/2534,-111*sqrt(362)/10136,59*sqrt(362)/10136,-11*sqrt(362)/2534,-111*sqrt(362)/10136,-59*sqrt(362)/10136,-111*sqrt(362)/10136,111*sqrt(362)/10136,-111*sqrt(362)/10136,111*sqrt(362)/10136,11*sqrt(362)/2534,-59*sqrt(362)/10136,-111*sqrt(362)/10136,-11*sqrt(362)/2534,59*sqrt(362)/10136,-111*sqrt(362)/10136,59*sqrt(362)/10136,-59*sqrt(362)/10136,59*sqrt(362)/10136,-59*sqrt(362)/10136,-11*sqrt(362)/2534,11*sqrt(362)/2534,11*sqrt(362)/2534,-11*sqrt(362)/2534,-11*sqrt(362)/2534,111*sqrt(362)/10136,-59*sqrt(362)/10136,11*sqrt(362)/2534,111*sqrt(362)/10136,59*sqrt(362)/10136]",
            "Qs(5,T2u,,1)": "[11*sqrt(362)/2534,-11*sqrt(362)/2534,-11*sqrt(362)/2534,11*sqrt(362)/2534,-111*sqrt(362)/10136,11*sqrt(362)/2534,59*sqrt(362)/10136,111*sqrt(362)/10136,11*sqrt(362)/2534,-59*sqrt(362)/10136,111*sqrt(362)/10136,-111*sqrt(362)/10136,-111*sqrt(362)/10136,111*sqrt(362)/10136,-59*sqrt(362)/10136,-59*sqrt(362)/10136,59*sqrt(362)/10136,59*sqrt(362)/10136,-111*sqrt(362)/10136,-59*sqrt(362)/10136,-11*sqrt(362)/2534,111*sqrt(362)/10136,59*sqrt(362)/10136,-11*sqrt(362)/2534,-11*sqrt(362)/2534,11*sqrt(362)/2534,11*sqrt(362)/2534,-11*sqrt(362)/2534,111*sqrt(362)/10136,-11*sqrt(362)/2534,-59*sqrt(362)/10136,-111*sqrt(362)/10136,-11*sqrt(362)/2534,59*sqrt(362)/10136,-111*sqrt(362)/10136,111*sqrt(362)/10136,111*sqrt(362)/10136,-111*sqrt(362)/10136,59*sqrt(362)/10136,59*sqrt(362)/10136,-59*sqrt(362)/10136,-59*sqrt(362)/10136,111*sqrt(362)/10136,59*sqrt(362)/10136,11*sqrt(362)/2534,-111*sqrt(362)/10136,-59*sqrt(362)/10136,11*sqrt(362)/2534]",
            "Qs(5,T2u,,2)": "[-59*sqrt(362)/10136,-59*sqrt(362)/10136,59*sqrt(362)/10136,59*sqrt(362)/10136,-59*sqrt(362)/10136,-111*sqrt(362)/10136,-11*sqrt(362)/2534,-59*sqrt(362)/10136,111*sqrt(362)/10136,11*sqrt(362)/2534,11*sqrt(362)/2534,11*sqrt(362)/2534,-11*sqrt(362)/2534,-11*sqrt(362)/2534,111*sqrt(362)/10136,-111*sqrt(362)/10136,111*sqrt(362)/10136,-111*sqrt(362)/10136,59*sqrt(362)/10136,-11*sqrt(362)/2534,111*sqrt(362)/10136,59*sqrt(362)/10136,11*sqrt(362)/2534,-111*sqrt(362)/10136,59*sqrt(362)/10136,59*sqrt(362)/10136,-59*sqrt(362)/10136,-59*sqrt(362)/10136,59*sqrt(362)/10136,111*sqrt(362)/10136,11*sqrt(362)/2534,59*sqrt(362)/10136,-111*sqrt(362)/10136,-11*sqrt(362)/2534,-11*sqrt(362)/2534,-11*sqrt(362)/2534,11*sqrt(362)/2534,11*sqrt(362)/2534,-111*sqrt(362)/10136,111*sqrt(362)/10136,-111*sqrt(362)/10136,111*sqrt(362)/10136,-59*sqrt(362)/10136,11*sqrt(362)/2534,-111*sqrt(362)/10136,-59*sqrt(362)/10136,-11*sqrt(362)/2534,111*sqrt(362)/10136]",
            "Qs(6,A2g,,)": "[sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12]",
            "Qs(6,T1g,,0)": "[sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12]",
            "Qs(6,T1g,,1)": "[-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12]",
            "Qs(6,T1g,,2)": "[-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12]",
            "Qs(6,T2g,1,0)": "[-9*sqrt(362)/1448,9*sqrt(362)/1448,-9*sqrt(362)/1448,9*sqrt(362)/1448,-2*sqrt(362)/181,5*sqrt(362)/1448,-9*sqrt(362)/1448,2*sqrt(362)/181,-5*sqrt(362)/1448,-9*sqrt(362)/1448,-5*sqrt(362)/1448,5*sqrt(362)/1448,-5*sqrt(362)/1448,5*sqrt(362)/1448,2*sqrt(362)/181,-2*sqrt(362)/181,-2*sqrt(362)/181,2*sqrt(362)/181,2*sqrt(362)/181,9*sqrt(362)/1448,5*sqrt(362)/1448,-2*sqrt(362)/181,9*sqrt(362)/1448,-5*sqrt(362)/1448,-9*sqrt(362)/1448,9*sqrt(362)/1448,-9*sqrt(362)/1448,9*sqrt(362)/1448,-2*sqrt(362)/181,5*sqrt(362)/1448,-9*sqrt(362)/1448,2*sqrt(362)/181,-5*sqrt(362)/1448,-9*sqrt(362)/1448,-5*sqrt(362)/1448,5*sqrt(362)/1448,-5*sqrt(362)/1448,5*sqrt(362)/1448,2*sqrt(362)/181,-2*sqrt(362)/181,-2*sqrt(362)/181,2*sqrt(362)/181,2*sqrt(362)/181,9*sqrt(362)/1448,5*sqrt(362)/1448,-2*sqrt(362)/181,9*sqrt(362)/1448,-5*sqrt(362)/1448]",
            "Qs(6,T2g,1,1)": "[2*sqrt(362)/181,-2*sqrt(362)/181,-2*sqrt(362)/181,2*sqrt(362)/181,9*sqrt(362)/1448,2*sqrt(362)/181,5*sqrt(362)/1448,-9*sqrt(362)/1448,2*sqrt(362)/181,-5*sqrt(362)/1448,-9*sqrt(362)/1448,9*sqrt(362)/1448,9*sqrt(362)/1448,-9*sqrt(362)/1448,-5*sqrt(362)/1448,-5*sqrt(362)/1448,5*sqrt(362)/1448,5*sqrt(362)/1448,9*sqrt(362)/1448,-5*sqrt(362)/1448,-2*sqrt(362)/181,-9*sqrt(362)/1448,5*sqrt(362)/1448,-2*sqrt(362)/181,2*sqrt(362)/181,-2*sqrt(362)/181,-2*sqrt(362)/181,2*sqrt(362)/181,9*sqrt(362)/1448,2*sqrt(362)/181,5*sqrt(362)/1448,-9*sqrt(362)/1448,2*sqrt(362)/181,-5*sqrt(362)/1448,-9*sqrt(362)/1448,9*sqrt(362)/1448,9*sqrt(362)/1448,-9*sqrt(362)/1448,-5*sqrt(362)/1448,-5*sqrt(362)/1448,5*sqrt(362)/1448,5*sqrt(362)/1448,9*sqrt(362)/1448,-5*sqrt(362)/1448,-2*sqrt(362)/181,-9*sqrt(362)/1448,5*sqrt(362)/1448,-2*sqrt(362)/181]",
            "Qs(6,T2g,1,2)": "[-5*sqrt(362)/1448,-5*sqrt(362)/1448,5*sqrt(362)/1448,5*sqrt(362)/1448,-5*sqrt(362)/1448,9*sqrt(362)/1448,-2*sqrt(362)/181,-5*sqrt(362)/1448,-9*sqrt(362)/1448,2*sqrt(362)/181,2*sqrt(362)/181,2*sqrt(362)/181,-2*sqrt(362)/181,-2*sqrt(362)/181,-9*sqrt(362)/1448,9*sqrt(362)/1448,-9*sqrt(362)/1448,9*sqrt(362)/1448,5*sqrt(362)/1448,-2*sqrt(362)/181,-9*sqrt(362)/1448,5*sqrt(362)/1448,2*sqrt(362)/181,9*sqrt(362)/1448,-5*sqrt(362)/1448,-5*sqrt(362)/1448,5*sqrt(362)/1448,5*sqrt(362)/1448,-5*sqrt(362)/1448,9*sqrt(362)/1448,-2*sqrt(362)/181,-5*sqrt(362)/1448,-9*sqrt(362)/1448,2*sqrt(362)/181,2*sqrt(362)/181,2*sqrt(362)/181,-2*sqrt(362)/181,-2*sqrt(362)/181,-9*sqrt(362)/1448,9*sqrt(362)/1448,-9*sqrt(362)/1448,9*sqrt(362)/1448,5*sqrt(362)/1448,-2*sqrt(362)/181,-9*sqrt(362)/1448,5*sqrt(362)/1448,2*sqrt(362)/181,9*sqrt(362)/1448]",
            "Qs(7,Eu,,0)": "[-11*sqrt(6)/168,-11*sqrt(6)/168,-11*sqrt(6)/168,-11*sqrt(6)/168,-11*sqrt(6)/168,13*sqrt(6)/168,-sqrt(6)/84,-11*sqrt(6)/168,13*sqrt(6)/168,-sqrt(6)/84,-sqrt(6)/84,-sqrt(6)/84,-sqrt(6)/84,-sqrt(6)/84,13*sqrt(6)/168,13*sqrt(6)/168,13*sqrt(6)/168,13*sqrt(6)/168,-11*sqrt(6)/168,-sqrt(6)/84,13*sqrt(6)/168,-11*sqrt(6)/168,-sqrt(6)/84,13*sqrt(6)/168,11*sqrt(6)/168,11*sqrt(6)/168,11*sqrt(6)/168,11*sqrt(6)/168,11*sqrt(6)/168,-13*sqrt(6)/168,sqrt(6)/84,11*sqrt(6)/168,-13*sqrt(6)/168,sqrt(6)/84,sqrt(6)/84,sqrt(6)/84,sqrt(6)/84,sqrt(6)/84,-13*sqrt(6)/168,-13*sqrt(6)/168,-13*sqrt(6)/168,-13*sqrt(6)/168,11*sqrt(6)/168,sqrt(6)/84,-13*sqrt(6)/168,11*sqrt(6)/168,sqrt(6)/84,-13*sqrt(6)/168]",
            "Qs(7,Eu,,1)": "[5*sqrt(2)/56,5*sqrt(2)/56,5*sqrt(2)/56,5*sqrt(2)/56,-5*sqrt(2)/56,-3*sqrt(2)/56,sqrt(2)/7,-5*sqrt(2)/56,-3*sqrt(2)/56,sqrt(2)/7,-sqrt(2)/7,-sqrt(2)/7,-sqrt(2)/7,-sqrt(2)/7,3*sqrt(2)/56,3*sqrt(2)/56,3*sqrt(2)/56,3*sqrt(2)/56,-5*sqrt(2)/56,sqrt(2)/7,-3*sqrt(2)/56,-5*sqrt(2)/56,sqrt(2)/7,-3*sqrt(2)/56,-5*sqrt(2)/56,-5*sqrt(2)/56,-5*sqrt(2)/56,-5*sqrt(2)/56,5*sqrt(2)/56,3*sqrt(2)/56,-sqrt(2)/7,5*sqrt(2)/56,3*sqrt(2)/56,-sqrt(2)/7,sqrt(2)/7,sqrt(2)/7,sqrt(2)/7,sqrt(2)/7,-3*sqrt(2)/56,-3*sqrt(2)/56,-3*sqrt(2)/56,-3*sqrt(2)/56,5*sqrt(2)/56,-sqrt(2)/7,3*sqrt(2)/56,5*sqrt(2)/56,-sqrt(2)/7,3*sqrt(2)/56]",
            "Qs(7,T2u,1,0)": "[-1/14,1/14,-1/14,1/14,3/28,3/14,-1/14,-3/28,-3/14,-1/14,-3/14,3/14,-3/14,3/14,-3/28,3/28,3/28,-3/28,-3/28,1/14,3/14,3/28,1/14,-3/14,1/14,-1/14,1/14,-1/14,-3/28,-3/14,1/14,3/28,3/14,1/14,3/14,-3/14,3/14,-3/14,3/28,-3/28,-3/28,3/28,3/28,-1/14,-3/14,-3/28,-1/14,3/14]",
            "Qs(7,T2u,1,1)": "[-3/28,3/28,3/28,-3/28,1/14,-3/28,3/14,-1/14,-3/28,-3/14,-1/14,1/14,1/14,-1/14,-3/14,-3/14,3/14,3/14,1/14,-3/14,3/28,-1/14,3/14,3/28,3/28,-3/28,-3/28,3/28,-1/14,3/28,-3/14,1/14,3/28,3/14,1/14,-1/14,-1/14,1/14,3/14,3/14,-3/14,-3/14,-1/14,3/14,-3/28,1/14,-3/14,-3/28]",
            "Qs(7,T2u,1,2)": "[-3/14,-3/14,3/14,3/14,-3/14,1/14,3/28,-3/14,-1/14,-3/28,-3/28,-3/28,3/28,3/28,-1/14,1/14,-1/14,1/14,3/14,3/28,-1/14,3/14,-3/28,1/14,3/14,3/14,-3/14,-3/14,3/14,-1/14,-3/28,3/14,1/14,3/28,3/28,3/28,-3/28,-3/28,1/14,-1/14,1/14,-1/14,-3/14,-3/28,1/14,-3/14,3/28,-1/14]",
            "Qs(8,T1g,1,0)": "[-3*sqrt(14)/56,3*sqrt(14)/56,-3*sqrt(14)/56,3*sqrt(14)/56,-sqrt(14)/28,-sqrt(14)/56,3*sqrt(14)/56,sqrt(14)/28,sqrt(14)/56,3*sqrt(14)/56,-sqrt(14)/56,sqrt(14)/56,-sqrt(14)/56,sqrt(14)/56,-sqrt(14)/28,sqrt(14)/28,sqrt(14)/28,-sqrt(14)/28,sqrt(14)/28,-3*sqrt(14)/56,-sqrt(14)/56,-sqrt(14)/28,-3*sqrt(14)/56,sqrt(14)/56,-3*sqrt(14)/56,3*sqrt(14)/56,-3*sqrt(14)/56,3*sqrt(14)/56,-sqrt(14)/28,-sqrt(14)/56,3*sqrt(14)/56,sqrt(14)/28,sqrt(14)/56,3*sqrt(14)/56,-sqrt(14)/56,sqrt(14)/56,-sqrt(14)/56,sqrt(14)/56,-sqrt(14)/28,sqrt(14)/28,sqrt(14)/28,-sqrt(14)/28,sqrt(14)/28,-3*sqrt(14)/56,-sqrt(14)/56,-sqrt(14)/28,-3*sqrt(14)/56,sqrt(14)/56]",
            "Qs(8,T1g,1,1)": "[-sqrt(14)/28,sqrt(14)/28,sqrt(14)/28,-sqrt(14)/28,-3*sqrt(14)/56,sqrt(14)/28,-sqrt(14)/56,3*sqrt(14)/56,sqrt(14)/28,sqrt(14)/56,-3*sqrt(14)/56,3*sqrt(14)/56,3*sqrt(14)/56,-3*sqrt(14)/56,-sqrt(14)/56,-sqrt(14)/56,sqrt(14)/56,sqrt(14)/56,-3*sqrt(14)/56,sqrt(14)/56,-sqrt(14)/28,3*sqrt(14)/56,-sqrt(14)/56,-sqrt(14)/28,-sqrt(14)/28,sqrt(14)/28,sqrt(14)/28,-sqrt(14)/28,-3*sqrt(14)/56,sqrt(14)/28,-sqrt(14)/56,3*sqrt(14)/56,sqrt(14)/28,sqrt(14)/56,-3*sqrt(14)/56,3*sqrt(14)/56,3*sqrt(14)/56,-3*sqrt(14)/56,-sqrt(14)/56,-sqrt(14)/56,sqrt(14)/56,sqrt(14)/56,-3*sqrt(14)/56,sqrt(14)/56,-sqrt(14)/28,3*sqrt(14)/56,-sqrt(14)/56,-sqrt(14)/28]",
            "Qs(8,T1g,1,2)": "[-sqrt(14)/56,-sqrt(14)/56,sqrt(14)/56,sqrt(14)/56,sqrt(14)/56,-3*sqrt(14)/56,-sqrt(14)/28,sqrt(14)/56,3*sqrt(14)/56,sqrt(14)/28,-sqrt(14)/28,-sqrt(14)/28,sqrt(14)/28,sqrt(14)/28,-3*sqrt(14)/56,3*sqrt(14)/56,-3*sqrt(14)/56,3*sqrt(14)/56,-sqrt(14)/56,-sqrt(14)/28,3*sqrt(14)/56,-sqrt(14)/56,sqrt(14)/28,-3*sqrt(14)/56,-sqrt(14)/56,-sqrt(14)/56,sqrt(14)/56,sqrt(14)/56,sqrt(14)/56,-3*sqrt(14)/56,-sqrt(14)/28,sqrt(14)/56,3*sqrt(14)/56,sqrt(14)/28,-sqrt(14)/28,-sqrt(14)/28,sqrt(14)/28,sqrt(14)/28,-3*sqrt(14)/56,3*sqrt(14)/56,-3*sqrt(14)/56,3*sqrt(14)/56,-sqrt(14)/56,-sqrt(14)/28,3*sqrt(14)/56,-sqrt(14)/56,sqrt(14)/28,-3*sqrt(14)/56]",
            "Qs(9,A1u,,)": "[sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12]",
        },
        "24e": {
            "Qs(0,A1g,,)": "[sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12]",
            "Qs(1,T1u,,0)": "[sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/6,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/6,-sqrt(3)/12,sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/6,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/6]",
            "Qs(1,T1u,,1)": "[sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/6,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/6,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/12,-sqrt(3)/6,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/6,sqrt(3)/12]",
            "Qs(1,T1u,,2)": "[sqrt(3)/6,sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/6,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/6,sqrt(3)/12,-sqrt(3)/12,sqrt(3)/6,-sqrt(3)/12,sqrt(3)/12]",
            "Qs(2,Eg,,0)": "[sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/6,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/6,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/6,-sqrt(3)/12,-sqrt(3)/12]",
            "Qs(2,Eg,,1)": "[0,0,0,0,0,1/4,-1/4,0,1/4,-1/4,1/4,1/4,1/4,1/4,-1/4,-1/4,-1/4,-1/4,0,-1/4,1/4,0,-1/4,1/4]",
            "Qs(2,T2g,,0)": "[sqrt(2)/6,-sqrt(2)/6,sqrt(2)/6,-sqrt(2)/6,-sqrt(2)/6,-sqrt(2)/12,sqrt(2)/6,sqrt(2)/6,sqrt(2)/12,sqrt(2)/6,sqrt(2)/12,-sqrt(2)/12,sqrt(2)/12,-sqrt(2)/12,sqrt(2)/6,-sqrt(2)/6,-sqrt(2)/6,sqrt(2)/6,sqrt(2)/6,-sqrt(2)/6,-sqrt(2)/12,-sqrt(2)/6,-sqrt(2)/6,sqrt(2)/12]",
            "Qs(2,T2g,,1)": "[sqrt(2)/6,-sqrt(2)/6,-sqrt(2)/6,sqrt(2)/6,-sqrt(2)/6,sqrt(2)/6,-sqrt(2)/12,sqrt(2)/6,sqrt(2)/6,sqrt(2)/12,sqrt(2)/6,-sqrt(2)/6,-sqrt(2)/6,sqrt(2)/6,sqrt(2)/12,sqrt(2)/12,-sqrt(2)/12,-sqrt(2)/12,-sqrt(2)/6,sqrt(2)/12,-sqrt(2)/6,sqrt(2)/6,-sqrt(2)/12,-sqrt(2)/6]",
            "Qs(2,T2g,,2)": "[sqrt(2)/12,sqrt(2)/12,-sqrt(2)/12,-sqrt(2)/12,sqrt(2)/12,-sqrt(2)/6,-sqrt(2)/6,sqrt(2)/12,sqrt(2)/6,sqrt(2)/6,sqrt(2)/6,sqrt(2)/6,-sqrt(2)/6,-sqrt(2)/6,sqrt(2)/6,-sqrt(2)/6,sqrt(2)/6,-sqrt(2)/6,-sqrt(2)/12,-sqrt(2)/6,sqrt(2)/6,-sqrt(2)/12,sqrt(2)/6,-sqrt(2)/6]",
            "Qs(3,A2u,,)": "[sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12]",
            "Qs(3,T1u,,0)": "[-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12]",
            "Qs(3,T1u,,1)": "[-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12]",
            "Qs(3,T1u,,2)": "[sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12]",
            "Qs(3,T2u,,0)": "[-1/4,1/4,-1/4,1/4,-1/4,0,-1/4,1/4,0,-1/4,0,0,0,0,1/4,-1/4,-1/4,1/4,1/4,1/4,0,-1/4,1/4,0]",
            "Qs(3,T2u,,1)": "[1/4,-1/4,-1/4,1/4,1/4,1/4,0,-1/4,1/4,0,-1/4,1/4,1/4,-1/4,0,0,0,0,1/4,0,-1/4,-1/4,0,-1/4]",
            "Qs(3,T2u,,2)": "[0,0,0,0,0,1/4,-1/4,0,-1/4,1/4,1/4,1/4,-1/4,-1/4,-1/4,1/4,-1/4,1/4,0,-1/4,-1/4,0,1/4,1/4]",
            "Qs(4,T1g,,0)": "[-1/4,1/4,-1/4,1/4,1/4,0,1/4,-1/4,0,1/4,0,0,0,0,1/4,-1/4,-1/4,1/4,-1/4,-1/4,0,1/4,-1/4,0]",
            "Qs(4,T1g,,1)": "[1/4,-1/4,-1/4,1/4,-1/4,-1/4,0,1/4,-1/4,0,-1/4,1/4,1/4,-1/4,0,0,0,0,-1/4,0,1/4,1/4,0,1/4]",
            "Qs(4,T1g,,2)": "[0,0,0,0,0,-1/4,1/4,0,1/4,-1/4,1/4,1/4,-1/4,-1/4,-1/4,1/4,-1/4,1/4,0,1/4,1/4,0,-1/4,-1/4]",
            "Qs(4,T2g,,0)": "[-1/12,1/12,-1/12,1/12,1/12,-1/3,-1/12,-1/12,1/3,-1/12,1/3,-1/3,1/3,-1/3,-1/12,1/12,1/12,-1/12,-1/12,1/12,-1/3,1/12,1/12,1/3]",
            "Qs(4,T2g,,1)": "[-1/12,1/12,1/12,-1/12,1/12,-1/12,-1/3,-1/12,-1/12,1/3,-1/12,1/12,1/12,-1/12,1/3,1/3,-1/3,-1/3,1/12,1/3,1/12,-1/12,-1/3,1/12]",
            "Qs(4,T2g,,2)": "[1/3,1/3,-1/3,-1/3,1/3,1/12,1/12,1/3,-1/12,-1/12,-1/12,-1/12,1/12,1/12,-1/12,1/12,-1/12,1/12,-1/3,1/12,-1/12,-1/3,-1/12,1/12]",
            "Qs(5,Eu,,0)": "[0,0,0,0,0,-1/4,1/4,0,-1/4,1/4,1/4,1/4,1/4,1/4,-1/4,-1/4,-1/4,-1/4,0,1/4,-1/4,0,1/4,-1/4]",
            "Qs(5,Eu,,1)": "[-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/6,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/6,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/12,sqrt(3)/6,-sqrt(3)/12,-sqrt(3)/12,sqrt(3)/6,-sqrt(3)/12,-sqrt(3)/12]",
        },
        "24d": {
            "Qs(0,A1g,,)": "[sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12]",
            "Qs(1,T1u,,0)": "[0,0,0,0,sqrt(10)/10,sqrt(10)/20,0,-sqrt(10)/10,-sqrt(10)/20,0,sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,sqrt(10)/10,-sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,0,sqrt(10)/20,sqrt(10)/10,0,-sqrt(10)/20]",
            "Qs(1,T1u,,1)": "[sqrt(10)/10,-sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,0,-sqrt(10)/10,sqrt(10)/20,0,-sqrt(10)/10,-sqrt(10)/20,0,0,0,0,sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,0,-sqrt(10)/20,sqrt(10)/10,0,sqrt(10)/20,sqrt(10)/10]",
            "Qs(1,T1u,,2)": "[sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,0,sqrt(10)/10,-sqrt(10)/20,0,-sqrt(10)/10,sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,-sqrt(10)/10,0,0,0,0,sqrt(10)/20,sqrt(10)/10,0,sqrt(10)/20,-sqrt(10)/10,0]",
            "Qs(2,Eg,,0)": "[-sqrt(39)/78,-sqrt(39)/78,-sqrt(39)/78,-sqrt(39)/78,-sqrt(39)/78,-5*sqrt(39)/156,7*sqrt(39)/156,-sqrt(39)/78,-5*sqrt(39)/156,7*sqrt(39)/156,7*sqrt(39)/156,7*sqrt(39)/156,7*sqrt(39)/156,7*sqrt(39)/156,-5*sqrt(39)/156,-5*sqrt(39)/156,-5*sqrt(39)/156,-5*sqrt(39)/156,-sqrt(39)/78,7*sqrt(39)/156,-5*sqrt(39)/156,-sqrt(39)/78,7*sqrt(39)/156,-5*sqrt(39)/156]",
            "Qs(2,Eg,,1)": "[-sqrt(13)/13,-sqrt(13)/13,-sqrt(13)/13,-sqrt(13)/13,sqrt(13)/13,-3*sqrt(13)/52,-sqrt(13)/52,sqrt(13)/13,-3*sqrt(13)/52,-sqrt(13)/52,sqrt(13)/52,sqrt(13)/52,sqrt(13)/52,sqrt(13)/52,3*sqrt(13)/52,3*sqrt(13)/52,3*sqrt(13)/52,3*sqrt(13)/52,sqrt(13)/13,-sqrt(13)/52,-3*sqrt(13)/52,sqrt(13)/13,-sqrt(13)/52,-3*sqrt(13)/52]",
            "Qs(2,T2g,,0)": "[sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,0,0,sqrt(2)/4,0,0,sqrt(2)/4,0,0,0,0,0,0,0,0,0,-sqrt(2)/4,0,0,-sqrt(2)/4,0]",
            "Qs(2,T2g,,1)": "[0,0,0,0,-sqrt(2)/4,0,0,sqrt(2)/4,0,0,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,0,0,0,0,-sqrt(2)/4,0,0,sqrt(2)/4,0,0]",
            "Qs(2,T2g,,2)": "[0,0,0,0,0,-sqrt(2)/4,0,0,sqrt(2)/4,0,0,0,0,0,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,0,0,sqrt(2)/4,0,0,-sqrt(2)/4]",
            "Qs(3,T1u,,0)": "[0,0,0,0,sqrt(10)/20,-sqrt(10)/10,0,-sqrt(10)/20,sqrt(10)/10,0,-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,0,-sqrt(10)/10,sqrt(10)/20,0,sqrt(10)/10]",
            "Qs(3,T1u,,1)": "[sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,0,-sqrt(10)/20,-sqrt(10)/10,0,-sqrt(10)/20,sqrt(10)/10,0,0,0,0,-sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,sqrt(10)/10,0,sqrt(10)/10,sqrt(10)/20,0,-sqrt(10)/10,sqrt(10)/20]",
            "Qs(3,T1u,,2)": "[-sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,sqrt(10)/10,sqrt(10)/10,0,sqrt(10)/20,sqrt(10)/10,0,-sqrt(10)/20,sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,0,0,0,0,-sqrt(10)/10,sqrt(10)/20,0,-sqrt(10)/10,-sqrt(10)/20,0]",
            "Qs(3,T2u,,0)": "[0,0,0,0,-sqrt(10)/20,sqrt(10)/10,0,sqrt(10)/20,-sqrt(10)/10,0,-sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,sqrt(10)/20,0,sqrt(10)/10,-sqrt(10)/20,0,-sqrt(10)/10]",
            "Qs(3,T2u,,1)": "[sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,0,sqrt(10)/20,sqrt(10)/10,0,sqrt(10)/20,-sqrt(10)/10,0,0,0,0,-sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,sqrt(10)/10,0,-sqrt(10)/10,-sqrt(10)/20,0,sqrt(10)/10,-sqrt(10)/20]",
            "Qs(3,T2u,,2)": "[-sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,0,-sqrt(10)/20,-sqrt(10)/10,0,sqrt(10)/20,sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,0,0,0,0,sqrt(10)/10,-sqrt(10)/20,0,sqrt(10)/10,sqrt(10)/20,0]",
            "Qs(4,Eg,,0)": "[-sqrt(13)/13,-sqrt(13)/13,-sqrt(13)/13,-sqrt(13)/13,-sqrt(13)/13,3*sqrt(13)/52,sqrt(13)/52,-sqrt(13)/13,3*sqrt(13)/52,sqrt(13)/52,sqrt(13)/52,sqrt(13)/52,sqrt(13)/52,sqrt(13)/52,3*sqrt(13)/52,3*sqrt(13)/52,3*sqrt(13)/52,3*sqrt(13)/52,-sqrt(13)/13,sqrt(13)/52,3*sqrt(13)/52,-sqrt(13)/13,sqrt(13)/52,3*sqrt(13)/52]",
            "Qs(4,Eg,,1)": "[sqrt(39)/78,sqrt(39)/78,sqrt(39)/78,sqrt(39)/78,-sqrt(39)/78,-5*sqrt(39)/156,7*sqrt(39)/156,-sqrt(39)/78,-5*sqrt(39)/156,7*sqrt(39)/156,-7*sqrt(39)/156,-7*sqrt(39)/156,-7*sqrt(39)/156,-7*sqrt(39)/156,5*sqrt(39)/156,5*sqrt(39)/156,5*sqrt(39)/156,5*sqrt(39)/156,-sqrt(39)/78,7*sqrt(39)/156,-5*sqrt(39)/156,-sqrt(39)/78,7*sqrt(39)/156,-5*sqrt(39)/156]",
            "Qs(4,T1g,,0)": "[sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,0,0,-sqrt(2)/4,0,0,-sqrt(2)/4,0,0,0,0,0,0,0,0,0,sqrt(2)/4,0,0,sqrt(2)/4,0]",
            "Qs(4,T1g,,1)": "[0,0,0,0,sqrt(2)/4,0,0,-sqrt(2)/4,0,0,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,0,0,0,0,sqrt(2)/4,0,0,-sqrt(2)/4,0,0]",
            "Qs(4,T1g,,2)": "[0,0,0,0,0,sqrt(2)/4,0,0,-sqrt(2)/4,0,0,0,0,0,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,0,0,-sqrt(2)/4,0,0,sqrt(2)/4]",
            "Qs(5,T2u,,0)": "[0,0,0,0,-sqrt(10)/10,-sqrt(10)/20,0,sqrt(10)/10,sqrt(10)/20,0,sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,sqrt(10)/10,-sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,sqrt(10)/10,0,-sqrt(10)/20,-sqrt(10)/10,0,sqrt(10)/20]",
            "Qs(5,T2u,,1)": "[sqrt(10)/10,-sqrt(10)/10,-sqrt(10)/10,sqrt(10)/10,0,sqrt(10)/10,-sqrt(10)/20,0,sqrt(10)/10,sqrt(10)/20,0,0,0,0,sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,0,sqrt(10)/20,-sqrt(10)/10,0,-sqrt(10)/20,-sqrt(10)/10]",
            "Qs(5,T2u,,2)": "[sqrt(10)/20,sqrt(10)/20,-sqrt(10)/20,-sqrt(10)/20,sqrt(10)/20,0,-sqrt(10)/10,sqrt(10)/20,0,sqrt(10)/10,sqrt(10)/10,sqrt(10)/10,-sqrt(10)/10,-sqrt(10)/10,0,0,0,0,-sqrt(10)/20,-sqrt(10)/10,0,-sqrt(10)/20,sqrt(10)/10,0]",
            "Qs(6,A2g,,)": "[sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12,-sqrt(6)/12]",
        },
        "12c": {
            "Qs(0,A1g,,)": "[sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6,sqrt(3)/6]",
            "Qs(1,T1u,,0)": "[0,0,0,0,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(1,T1u,,1)": "[sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,0,-sqrt(2)/4,0,-sqrt(2)/4,0,0,sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,T1u,,2)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,0,-sqrt(2)/4,0,sqrt(2)/4,sqrt(2)/4,0,0]",
            "Qs(2,Eg,,0)": "[sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,-sqrt(6)/6,sqrt(6)/12,sqrt(6)/12,-sqrt(6)/6,-sqrt(6)/6]",
            "Qs(2,Eg,,1)": "[-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,0,sqrt(2)/4,0,sqrt(2)/4,sqrt(2)/4,0,0]",
            "Qs(2,T2g,,0)": "[1/2,-1/2,1/2,-1/2,0,0,0,0,0,0,0,0]",
            "Qs(2,T2g,,1)": "[0,0,0,0,-1/2,0,1/2,0,1/2,-1/2,0,0]",
            "Qs(2,T2g,,2)": "[0,0,0,0,0,-1/2,0,1/2,0,0,1/2,-1/2]",
            "Qs(3,T2u,,0)": "[0,0,0,0,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(3,T2u,,1)": "[sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,0,sqrt(2)/4,0,sqrt(2)/4,0,0,-sqrt(2)/4,-sqrt(2)/4]",
            "Qs(3,T2u,,2)": "[-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,0,-sqrt(2)/4,0,sqrt(2)/4,sqrt(2)/4,0,0]",
        },
        "8b": {
            "Qs(0,A1g,,)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
            "Qs(1,T1u,,0)": "[sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
            "Qs(1,T1u,,1)": "[sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(1,T1u,,2)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4]",
            "Qs(2,T2g,,0)": "[sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,sqrt(2)/4]",
            "Qs(2,T2g,,1)": "[sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4]",
            "Qs(2,T2g,,2)": "[sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,sqrt(2)/4]",
            "Qs(3,A2u,,)": "[sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4,-sqrt(2)/4]",
        },
        "6a": {
            "Qs(0,A1g,,)": "[sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6,sqrt(6)/6]",
            "Qs(1,T1u,,0)": "[sqrt(2)/2,-sqrt(2)/2,0,0,0,0]",
            "Qs(1,T1u,,1)": "[0,0,sqrt(2)/2,0,-sqrt(2)/2,0]",
            "Qs(1,T1u,,2)": "[0,0,0,sqrt(2)/2,0,-sqrt(2)/2]",
            "Qs(2,Eg,,0)": "[-sqrt(3)/6,-sqrt(3)/6,-sqrt(3)/6,sqrt(3)/3,-sqrt(3)/6,sqrt(3)/3]",
            "Qs(2,Eg,,1)": "[1/2,1/2,-1/2,0,-1/2,0]",
        },
        "1o": {"Qs(0,A1g,,)": "[1]"},
    },
}

"""
site positions of virtual cluster for other wyckoff positions (reduced coordinate).
    { point-group tag : { wp: sites} }
real version
"""
_data_virtual_cluster_site_real = {
    "C1": {"1a": "{[0,0,0]}"},
    "Ci": {"2a": "{[1,0,0],[-1,0,0]}", "1o": "{[0,0,0]}"},
    "C2": {"2b": "{[1,0,0],[-1,0,0]}", "1a": "{[0,0,0]}"},
    "Cs": {"2b": "{[0,1,0],[0,-1,0]}", "1a": "{[0,0,0]}"},
    "C2h": {
        "4c": "{[1,1,0],[-1,1,0],[-1,-1,0],[1,-1,0]}",
        "2b": "{[1,0,0],[-1,0,0]}",
        "2a": "{[0,1,0],[0,-1,0]}",
        "1o": "{[0,0,0]}",
    },
    "D2": {
        "4d": "{[1,1,0],[-1,-1,0],[-1,1,0],[1,-1,0]}",
        "2c": "{[0,0,1],[0,0,-1]}",
        "2b": "{[0,1,0],[0,-1,0]}",
        "2a": "{[1,0,0],[-1,0,0]}",
        "1o": "{[0,0,0]}",
    },
    "C2v": {
        "4d": "{[1,1,0],[-1,-1,0],[1,-1,0],[-1,1,0]}",
        "2c": "{[0,1,0],[0,-1,0]}",
        "2b": "{[1,0,0],[-1,0,0]}",
        "1a": "{[0,0,0]}",
    },
    "D2h": {
        "8g": "{[1,1,1],[-1,-1,1],[-1,1,-1],[1,-1,-1],[-1,-1,-1],[1,1,-1],[1,-1,1],[-1,1,1]}",
        "4f": "{[1,1,0],[-1,-1,0],[-1,1,0],[1,-1,0]}",
        "4e": "{[1,0,1],[-1,0,1],[-1,0,-1],[1,0,-1]}",
        "4d": "{[0,1,1],[0,-1,1],[0,1,-1],[0,-1,-1]}",
        "2c": "{[0,0,1],[0,0,-1]}",
        "2b": "{[0,1,0],[0,-1,0]}",
        "2a": "{[1,0,0],[-1,0,0]}",
        "1o": "{[0,0,0]}",
    },
    "C4": {"4b": "{[1,0,0],[-1,0,0],[0,1,0],[0,-1,0]}", "1a": "{[0,0,0]}"},
    "S4": {"4b": "{[1,0,0],[-1,0,0],[0,-1,0],[0,1,0]}", "2a": "{[0,0,1],[0,0,-1]}", "1o": "{[0,0,0]}"},
    "C4h": {
        "8c": "{[1,1,1],[-1,-1,1],[-1,1,1],[1,-1,1],[-1,-1,-1],[1,1,-1],[1,-1,-1],[-1,1,-1]}",
        "4b": "{[1,0,0],[-1,0,0],[0,1,0],[0,-1,0]}",
        "2a": "{[0,0,1],[0,0,-1]}",
        "1o": "{[0,0,0]}",
    },
    "D4": {
        "8d": "{[1,0,1],[-1,0,1],[1,0,-1],[-1,0,-1],[0,1,-1],[0,-1,-1],[0,1,1],[0,-1,1]}",
        "4c": "{[1,0,0],[-1,0,0],[0,1,0],[0,-1,0]}",
        "4b": "{[1,1,0],[-1,-1,0],[1,-1,0],[-1,1,0]}",
        "2a": "{[0,0,1],[0,0,-1]}",
        "1o": "{[0,0,0]}",
    },
    "C4v": {
        "8d": "{[2,1,0],[-2,-1,0],[-1,2,0],[1,-2,0],[-2,1,0],[2,-1,0],[-1,-2,0],[1,2,0]}",
        "4c": "{[1,0,0],[-1,0,0],[0,1,0],[0,-1,0]}",
        "4b": "{[1,1,0],[-1,-1,0],[-1,1,0],[1,-1,0]}",
        "1a": "{[0,0,0]}",
    },
    "D2d": {
        "8d": "{[2,1,0],[-2,-1,0],[2,-1,0],[-2,1,0],[-1,-2,0],[1,2,0],[1,-2,0],[-1,2,0]}",
        "4c": "{[1,1,0],[-1,-1,0],[1,-1,0],[-1,1,0]}",
        "4b": "{[1,0,0],[-1,0,0],[0,-1,0],[0,1,0]}",
        "2a": "{[0,0,1],[0,0,-1]}",
        "1o": "{[0,0,0]}",
    },
    "D2d-1": {
        "8d": "{[2,1,0],[-2,-1,0],[1,2,0],[-1,-2,0],[-2,1,0],[2,-1,0],[1,-2,0],[-1,2,0]}",
        "4c": "{[1,0,0],[-1,0,0],[0,1,0],[0,-1,0]}",
        "4b": "{[1,1,0],[-1,-1,0],[-1,1,0],[1,-1,0]}",
        "2a": "{[0,0,1],[0,0,-1]}",
        "1o": "{[0,0,0]}",
    },
    "D4h": {
        "16g": "{[2,1,1],[-2,-1,1],[2,-1,-1],[-2,1,-1],[1,2,-1],[-1,-2,-1],[-1,2,1],[1,-2,1],[-2,-1,-1],[2,1,-1],[-2,1,1],[2,-1,1],[-1,-2,1],[1,2,1],[1,-2,-1],[-1,2,-1]}",
        "8f": "{[1,0,1],[-1,0,1],[1,0,-1],[-1,0,-1],[0,1,-1],[0,-1,-1],[0,1,1],[0,-1,1]}",
        "8e": "{[1,1,1],[-1,-1,1],[1,-1,-1],[-1,1,-1],[1,1,-1],[-1,-1,-1],[-1,1,1],[1,-1,1]}",
        "8d": "{[2,1,0],[-2,-1,0],[2,-1,0],[-2,1,0],[1,2,0],[-1,-2,0],[-1,2,0],[1,-2,0]}",
        "4c": "{[1,0,0],[-1,0,0],[0,1,0],[0,-1,0]}",
        "4b": "{[1,1,0],[-1,-1,0],[1,-1,0],[-1,1,0]}",
        "2a": "{[0,0,1],[0,0,-1]}",
        "1o": "{[0,0,0]}",
    },
    "C3": {"3b": "{[-1,-1,0],[1,0,0],[0,1,0]}", "1a": "{[0,0,0]}"},
    "C3i": {"6b": "{[-1,-1,0],[1,0,0],[0,1,0],[1,1,0],[-1,0,0],[0,-1,0]}", "2a": "{[0,0,1],[0,0,-1]}", "1o": "{[0,0,0]}"},
    "D3": {
        "6c": "{[-1,-1,1],[0,-1,-1],[-1,0,-1],[1,1,-1],[1,0,1],[0,1,1]}",
        "3b": "{[1,2,0],[1,-1,0],[-2,-1,0]}",
        "2a": "{[0,0,1],[0,0,-1]}",
        "1o": "{[0,0,0]}",
    },
    "D3-1": {
        "6c": "{[1,-1,1],[2,1,-1],[-1,-2,-1],[-1,1,-1],[1,2,1],[-2,-1,1]}",
        "3b": "{[1,0,0],[-1,-1,0],[0,1,0]}",
        "2a": "{[0,0,1],[0,0,-1]}",
        "1o": "{[0,0,0]}",
    },
    "C3v": {
        "6c": "{[-1,-1,0],[1,0,0],[0,1,0],[0,-1,0],[-1,0,0],[1,1,0]}",
        "3b": "{[1,2,0],[-2,-1,0],[1,-1,0]}",
        "1a": "{[0,0,0]}",
    },
    "C3v-1": {
        "6c": "{[1,-1,0],[1,2,0],[-2,-1,0],[2,1,0],[-1,-2,0],[-1,1,0]}",
        "3b": "{[1,0,0],[0,1,0],[-1,-1,0]}",
        "1a": "{[0,0,0]}",
    },
    "D3d": {
        "12d": "{[1,-1,1],[-2,-1,-1],[1,2,-1],[1,-1,-1],[1,2,1],[-2,-1,1],[-1,1,-1],[2,1,1],[-1,-2,1],[-1,1,1],[-1,-2,-1],[2,1,-1]}",
        "6c": "{[1,0,0],[-1,0,0],[1,1,0],[0,-1,0],[0,1,0],[-1,-1,0]}",
        "6b": "{[1,2,0],[1,-1,0],[-2,-1,0],[-1,-2,0],[-1,1,0],[2,1,0]}",
        "2a": "{[0,0,1],[0,0,-1]}",
        "1o": "{[0,0,0]}",
    },
    "D3d-1": {
        "12d": "{[-1,-1,1],[0,1,-1],[1,0,-1],[-1,-1,-1],[1,0,1],[0,1,1],[1,1,-1],[0,-1,1],[-1,0,1],[1,1,1],[-1,0,-1],[0,-1,-1]}",
        "6c": "{[1,2,0],[-1,-2,0],[-1,1,0],[2,1,0],[-2,-1,0],[1,-1,0]}",
        "6b": "{[1,0,0],[-1,-1,0],[0,1,0],[-1,0,0],[1,1,0],[0,-1,0]}",
        "2a": "{[0,0,1],[0,0,-1]}",
        "1o": "{[0,0,0]}",
    },
    "C6": {"6b": "{[1,-1,0],[-1,1,0],[1,2,0],[-2,-1,0],[2,1,0],[-1,-2,0]}", "1a": "{[0,0,0]}"},
    "C3h": {
        "6c": "{[-1,-1,1],[1,0,1],[0,1,1],[-1,-1,-1],[0,1,-1],[1,0,-1]}",
        "3b": "{[1,0,0],[0,1,0],[-1,-1,0]}",
        "2a": "{[0,0,1],[0,0,-1]}",
        "1o": "{[0,0,0]}",
    },
    "C6h": {
        "12c": "{[-1,-1,1],[1,1,1],[1,0,1],[0,1,1],[0,-1,1],[-1,0,1],[1,1,-1],[-1,-1,-1],[-1,0,-1],[0,-1,-1],[0,1,-1],[1,0,-1]}",
        "6b": "{[1,0,0],[-1,0,0],[0,1,0],[-1,-1,0],[1,1,0],[0,-1,0]}",
        "2a": "{[0,0,1],[0,0,-1]}",
        "1o": "{[0,0,0]}",
    },
    "D6": {
        "12d": "{[-1,-1,1],[1,1,1],[0,1,-1],[1,0,-1],[-1,-1,-1],[0,-1,-1],[-1,0,-1],[1,1,-1],[1,0,1],[0,1,1],[0,-1,1],[-1,0,1]}",
        "6c": "{[1,2,0],[-1,-2,0],[-1,1,0],[2,1,0],[1,-1,0],[-2,-1,0]}",
        "6b": "{[1,0,0],[-1,0,0],[-1,-1,0],[0,1,0],[1,1,0],[0,-1,0]}",
        "2a": "{[0,0,1],[0,0,-1]}",
        "1o": "{[0,0,0]}",
    },
    "C6v": {
        "12d": "{[1+sqrt(3),-1+sqrt(3),0],[-sqrt(3)-1,1-sqrt(3),0],[1-sqrt(3),2,0],[-2,-sqrt(3)-1,0],[2,1+sqrt(3),0],[-1+sqrt(3),-2,0],[-2,-1+sqrt(3),0],[1+sqrt(3),2,0],[1-sqrt(3),-sqrt(3)-1,0],[2,1-sqrt(3),0],[-sqrt(3)-1,-2,0],[-1+sqrt(3),1+sqrt(3),0]}",
        "6c": "{[1,2,0],[-1,-2,0],[-2,-1,0],[1,-1,0],[-1,1,0],[2,1,0]}",
        "6b": "{[1,0,0],[-1,0,0],[0,1,0],[-1,-1,0],[1,1,0],[0,-1,0]}",
        "1a": "{[0,0,0]}",
    },
    "D3h": {
        "12e": "{[-1,-1,1],[0,-1,-1],[-1,0,-1],[1,1,-1],[1,0,1],[0,1,1],[0,-1,1],[-1,0,1],[1,1,1],[-1,-1,-1],[0,1,-1],[1,0,-1]}",
        "6d": "{[1,0,0],[-1,0,0],[1,1,0],[0,-1,0],[0,1,0],[-1,-1,0]}",
        "6c": "{[1,2,1],[1,2,-1],[1,-1,-1],[-2,-1,-1],[-2,-1,1],[1,-1,1]}",
        "3b": "{[1,2,0],[1,-1,0],[-2,-1,0]}",
        "2a": "{[0,0,1],[0,0,-1]}",
        "1o": "{[0,0,0]}",
    },
    "D3h-1": {
        "12e": "{[1,-1,1],[2,1,-1],[-1,-2,-1],[-1,1,-1],[1,2,1],[-2,-1,1],[1,-1,-1],[2,1,1],[-1,-2,1],[-1,1,1],[-2,-1,-1],[1,2,-1]}",
        "6d": "{[1,2,0],[-1,-2,0],[-1,1,0],[2,1,0],[-2,-1,0],[1,-1,0]}",
        "6c": "{[1,0,1],[1,0,-1],[-1,-1,-1],[0,1,-1],[0,1,1],[-1,-1,1]}",
        "3b": "{[1,0,0],[-1,-1,0],[0,1,0]}",
        "2a": "{[0,0,1],[0,0,-1]}",
        "1o": "{[0,0,0]}",
    },
    "D6h": {
        "24g": "{[1+sqrt(3),-1+sqrt(3),1],[-sqrt(3)-1,1-sqrt(3),1],[2,1-sqrt(3),-1],[-sqrt(3)-1,-2,-1],[-1+sqrt(3),1+sqrt(3),-1],[-2,-1+sqrt(3),-1],[1+sqrt(3),2,-1],[1-sqrt(3),-sqrt(3)-1,-1],[1-sqrt(3),2,1],[-2,-sqrt(3)-1,1],[2,1+sqrt(3),1],[-1+sqrt(3),-2,1],[-sqrt(3)-1,1-sqrt(3),-1],[-2,-1+sqrt(3),1],[1+sqrt(3),2,1],[1-sqrt(3),-sqrt(3)-1,1],[1+sqrt(3),-1+sqrt(3),-1],[2,1-sqrt(3),1],[-sqrt(3)-1,-2,1],[-1+sqrt(3),1+sqrt(3),1],[-1+sqrt(3),-2,-1],[2,1+sqrt(3),-1],[-2,-sqrt(3)-1,-1],[1-sqrt(3),2,-1]}",
        "12f": "{[1+sqrt(3),-1+sqrt(3),0],[-sqrt(3)-1,1-sqrt(3),0],[2,1-sqrt(3),0],[-sqrt(3)-1,-2,0],[-1+sqrt(3),1+sqrt(3),0],[-2,-1+sqrt(3),0],[1+sqrt(3),2,0],[1-sqrt(3),-sqrt(3)-1,0],[1-sqrt(3),2,0],[-2,-sqrt(3)-1,0],[2,1+sqrt(3),0],[-1+sqrt(3),-2,0]}",
        "12e": "{[1,2,1],[-1,-2,1],[-1,-2,-1],[-1,1,-1],[2,1,-1],[1,2,-1],[1,-1,-1],[-2,-1,-1],[-2,-1,1],[1,-1,1],[-1,1,1],[2,1,1]}",
        "12d": "{[1,0,1],[-1,0,1],[1,0,-1],[-1,-1,-1],[0,1,-1],[-1,0,-1],[1,1,-1],[0,-1,-1],[0,1,1],[-1,-1,1],[1,1,1],[0,-1,1]}",
        "6c": "{[1,2,0],[-1,-2,0],[-1,1,0],[2,1,0],[1,-1,0],[-2,-1,0]}",
        "6b": "{[1,0,0],[-1,0,0],[-1,-1,0],[0,1,0],[1,1,0],[0,-1,0]}",
        "2a": "{[0,0,1],[0,0,-1]}",
        "1o": "{[0,0,0]}",
    },
    "T": {
        "12c": "{[1,1,0],[-1,-1,0],[1,-1,0],[-1,1,0],[0,1,1],[0,-1,1],[0,-1,-1],[0,1,-1],[1,0,1],[-1,0,-1],[-1,0,1],[1,0,-1]}",
        "6b": "{[1,0,0],[-1,0,0],[0,1,0],[0,-1,0],[0,0,1],[0,0,-1]}",
        "4a": "{[1,1,1],[-1,-1,1],[1,-1,-1],[-1,1,-1]}",
        "1o": "{[0,0,0]}",
    },
    "Th": {
        "24d": "{[3,2,1],[-3,-2,1],[3,-2,-1],[-3,2,-1],[1,3,2],[-1,-3,2],[1,-3,-2],[-1,3,-2],[2,1,3],[-2,1,-3],[-2,-1,3],[2,-1,-3],[-3,-2,-1],[3,2,-1],[-3,2,1],[3,-2,1],[-1,-3,-2],[1,3,-2],[-1,3,2],[1,-3,2],[-2,-1,-3],[2,-1,3],[2,1,-3],[-2,1,3]}",
        "12c": "{[0,1,1],[0,-1,1],[0,-1,-1],[0,1,-1],[1,0,1],[-1,0,1],[1,0,-1],[-1,0,-1],[1,1,0],[-1,1,0],[-1,-1,0],[1,-1,0]}",
        "8b": "{[1,1,1],[-1,-1,1],[1,-1,-1],[-1,1,-1],[-1,-1,-1],[1,1,-1],[-1,1,1],[1,-1,1]}",
        "6a": "{[1,0,0],[-1,0,0],[0,1,0],[0,-1,0],[0,0,1],[0,0,-1]}",
        "1o": "{[0,0,0]}",
    },
    "O": {
        "24d": "{[2,1,0],[-2,-1,0],[2,-1,0],[-2,1,0],[1,2,0],[0,-1,2],[-2,0,1],[-1,-2,0],[0,-1,-2],[-2,0,-1],[0,2,1],[0,-2,1],[0,-2,-1],[0,2,-1],[1,0,2],[-1,0,-2],[-1,0,2],[1,0,-2],[-1,2,0],[2,0,1],[0,1,-2],[1,-2,0],[2,0,-1],[0,1,2]}",
        "12c": "{[0,1,1],[0,-1,1],[0,-1,-1],[0,1,-1],[1,0,-1],[1,-1,0],[-1,0,-1],[-1,-1,0],[1,0,1],[-1,0,1],[1,1,0],[-1,1,0]}",
        "8b": "{[1,1,1],[-1,-1,1],[1,-1,-1],[-1,1,-1],[1,1,-1],[1,-1,1],[-1,1,1],[-1,-1,-1]}",
        "6a": "{[1,0,0],[-1,0,0],[0,1,0],[0,0,1],[0,-1,0],[0,0,-1]}",
        "1o": "{[0,0,0]}",
    },
    "Td": {
        "24d": "{[2,1,0],[-2,-1,0],[2,-1,0],[-2,1,0],[0,2,1],[0,-2,1],[0,-2,-1],[0,2,-1],[1,0,2],[-1,0,-2],[-1,0,2],[1,0,-2],[-1,-2,0],[0,1,-2],[2,0,-1],[1,2,0],[0,1,2],[2,0,1],[1,-2,0],[-2,0,-1],[0,-1,2],[-1,2,0],[-2,0,1],[0,-1,-2]}",
        "12c": "{[1,1,0],[-1,-1,0],[1,-1,0],[-1,1,0],[0,1,1],[0,-1,1],[0,-1,-1],[0,1,-1],[1,0,1],[-1,0,-1],[-1,0,1],[1,0,-1]}",
        "6b": "{[1,0,0],[-1,0,0],[0,1,0],[0,-1,0],[0,0,1],[0,0,-1]}",
        "4a": "{[1,1,1],[-1,-1,1],[1,-1,-1],[-1,1,-1]}",
        "1o": "{[0,0,0]}",
    },
    "Oh": {
        "48f": "{[3,2,1],[-3,-2,1],[3,-2,-1],[-3,2,-1],[2,3,-1],[1,-2,3],[-3,1,2],[-2,-3,-1],[-1,-2,-3],[-3,-1,-2],[1,3,2],[-1,-3,2],[1,-3,-2],[-1,3,-2],[2,1,3],[-2,1,-3],[-2,-1,3],[2,-1,-3],[-2,3,1],[3,-1,2],[1,2,-3],[2,-3,1],[3,1,-2],[-1,2,3],[-3,-2,-1],[3,2,-1],[-3,2,1],[3,-2,1],[-2,-3,1],[-1,2,-3],[3,-1,-2],[2,3,1],[1,2,3],[3,1,2],[-1,-3,-2],[1,3,-2],[-1,3,2],[1,-3,2],[-2,-1,-3],[2,-1,3],[2,1,-3],[-2,1,3],[2,-3,-1],[-3,1,-2],[-1,-2,3],[-2,3,-1],[-3,-1,2],[1,-2,-3]}",
        "24e": "{[1,1,2],[-1,-1,2],[1,-1,-2],[-1,1,-2],[1,1,-2],[2,-1,1],[-1,2,1],[-1,-1,-2],[-2,-1,-1],[-1,-2,-1],[2,1,1],[-2,-1,1],[2,-1,-1],[-2,1,-1],[1,2,1],[-1,2,-1],[-1,-2,1],[1,-2,-1],[-1,1,2],[1,-2,1],[2,1,-1],[1,-1,2],[1,2,-1],[-2,1,1]}",
        "24d": "{[0,2,1],[0,-2,1],[0,-2,-1],[0,2,-1],[2,0,-1],[1,-2,0],[0,1,2],[-2,0,-1],[-1,-2,0],[0,-1,-2],[1,0,2],[-1,0,2],[1,0,-2],[-1,0,-2],[2,1,0],[-2,1,0],[-2,-1,0],[2,-1,0],[-2,0,1],[0,-1,2],[1,2,0],[2,0,1],[0,1,-2],[-1,2,0]}",
        "12c": "{[0,1,1],[0,-1,1],[0,-1,-1],[0,1,-1],[1,0,-1],[1,-1,0],[-1,0,-1],[-1,-1,0],[1,0,1],[-1,0,1],[1,1,0],[-1,1,0]}",
        "8b": "{[1,1,1],[-1,-1,1],[1,-1,-1],[-1,1,-1],[1,1,-1],[1,-1,1],[-1,1,1],[-1,-1,-1]}",
        "6a": "{[1,0,0],[-1,0,0],[0,1,0],[0,0,1],[0,-1,0],[0,0,-1]}",
        "1o": "{[0,0,0]}",
    },
}
