"""
from reduced to catesian coordinate for hexagonal system
"""
_data_trans_Ah = "[[1,-1/2,0],[0,sqrt(3)/2,0],[0,0,1]]"
_data_trans_Ah4 = "[[1,-1/2,0,0],[0,sqrt(3)/2,0,0],[0,0,1,0],[0,0,0,1]]"

"""
transformation matrix, P (4x4)
"""
_data_trans_lattice_p = {
    "A": "[[1/2, 0, 1/2, 0], [0, 1, 0, 0], [-1/2, 0, 1/2, 0], [0, 0, 0, 1]]",
    "B": "[[1, 0, 0, 0], [0, 1/2, -1/2, 0], [0, 1/2, 1/2, 0], [0, 0, 0, 1]]",
    "C": "[[1/2, -1/2, 0, 0], [1/2, 1/2, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1]]",
    "P": "[[1, 0, 0, 0], [0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1]]",  # primitive.
    "I": "[[-1/2, 1/2, 1/2, 0], [1/2, -1/2, 1/2, 0], [1/2, 1/2, -1/2, 0], [0, 0, 0, 1]]",
    "F": "[[0, 1/2, 1/2, 0], [1/2, 0, 1/2, 0], [1/2, 1/2, 0, 0], [0, 0, 0, 1]]",
    "R": "[[2/3, -1/3, -1/3, 0], [1/3, 1/3, -2/3, 0], [1/3, 1/3, 1/3, 0], [0, 0, 0, 1]]",
    "a": "[[0, 1, 0, 0], [0, 0, 1, 0], [1, 0, 0, 0], [0, 0, 0, 1]]",
    "b": "[[1, 0, 0, 0], [0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1]]",  # default setting.
    "c": "[[0, 0, 1, 0], [1, 0, 0, 0], [0, 1, 0, 0], [0, 0, 0, 1]]",
}

"""
partial translation (3x1)
"""
_data_trans_lattice_t = {
    "A": "{[0, 0, 0], [0, 1/2, 1/2]}",
    "B": "{[0, 0, 0], [1/2, 0, 1/2]}",
    "C": "{[0, 0, 0], [1/2, 1/2, 0]}",
    "P": "{[0, 0, 0]}",  # primitive.
    "I": "{[0, 0, 0], [1/2, 1/2, 1/2]}",
    "F": "{[0, 0, 0], [0, 1/2, 1/2], [1/2, 0, 1/2], [1/2, 1/2, 0]}",
    "R": "{[0, 0, 0], [2/3, 1/3, 1/3], [1/3, 2/3, 2/3]}",
}
