"""
space-group information.
    space-group tag : (No, Schoenflies symbol, international symbol(short), setting, crystal, point-group)
"""
_data_tag_space_group = {
    "C1^1": (1, "C_{1}^{1}", "P1", "", "triclinic", "C1"),
    "Ci^1": (2, "C_{i}^{1}", "P-1", "", "triclinic", "Ci"),
    "C2^1": (3, "C_{2}^{1}", "P2", "b-axis", "monoclinic", "C2"),
    "C2^2": (4, "C_{2}^{2}", "P2_1", "b-axis", "monoclinic", "C2"),
    "C2^3": (5, "C_{2}^{3}", "C2", "b-axis", "monoclinic", "C2"),
    "Cs^1": (6, "C_{s}^{1}", "Pm", "b-axis", "monoclinic", "Cs"),
    "Cs^2": (7, "C_{s}^{2}", "Pc", "b-axis", "monoclinic", "Cs"),
    "Cs^3": (8, "C_{s}^{3}", "Cm", "b-axis", "monoclinic", "Cs"),
    "Cs^4": (9, "C_{s}^{4}", "Cc", "b-axis", "monoclinic", "Cs"),
    "C2h^1": (10, "C_{2h}^{1}", "P2/m", "b-axis", "monoclinic", "C2h"),
    "C2h^2": (11, "C_{2h}^{2}", "P2_1/m", "b-axis", "monoclinic", "C2h"),
    "C2h^3": (12, "C_{2h}^{3}", "C2/m", "b-axis", "monoclinic", "C2h"),
    "C2h^4": (13, "C_{2h}^{4}", "P2/c", "b-axis", "monoclinic", "C2h"),
    "C2h^5": (14, "C_{2h}^{5}", "P2_1/c", "b-axis", "monoclinic", "C2h"),
    "C2h^6": (15, "C_{2h}^{6}", "C2/c", "b-axis", "monoclinic", "C2h"),
    "D2^1": (16, "D_{2}^{1}", "P222", "", "orthorhombic", "D2"),
    "D2^2": (17, "D_{2}^{2}", "P222_1", "", "orthorhombic", "D2"),
    "D2^3": (18, "D_{2}^{3}", "P2_12_12", "", "orthorhombic", "D2"),
    "D2^4": (19, "D_{2}^{4}", "P2_12_12_1", "", "orthorhombic", "D2"),
    "D2^5": (20, "D_{2}^{5}", "C222_1", "", "orthorhombic", "D2"),
    "D2^6": (21, "D_{2}^{6}", "C222", "", "orthorhombic", "D2"),
    "D2^7": (22, "D_{2}^{7}", "F222", "", "orthorhombic", "D2"),
    "D2^8": (23, "D_{2}^{8}", "I222", "", "orthorhombic", "D2"),
    "D2^9": (24, "D_{2}^{9}", "I2_12_12_1", "", "orthorhombic", "D2"),
    "C2v^1": (25, "C_{2v}^{1}", "Pmm2", "", "orthorhombic", "C2v"),
    "C2v^2": (26, "C_{2v}^{2}", "Pmc2_1", "", "orthorhombic", "C2v"),
    "C2v^3": (27, "C_{2v}^{3}", "Pcc2", "", "orthorhombic", "C2v"),
    "C2v^4": (28, "C_{2v}^{4}", "Pma2", "", "orthorhombic", "C2v"),
    "C2v^5": (29, "C_{2v}^{5}", "Pca2_1", "", "orthorhombic", "C2v"),
    "C2v^6": (30, "C_{2v}^{6}", "Pnc2", "", "orthorhombic", "C2v"),
    "C2v^7": (31, "C_{2v}^{7}", "Pmn2_1", "", "orthorhombic", "C2v"),
    "C2v^8": (32, "C_{2v}^{8}", "Pba2", "", "orthorhombic", "C2v"),
    "C2v^9": (33, "C_{2v}^{9}", "Pna2_1", "", "orthorhombic", "C2v"),
    "C2v^10": (34, "C_{2v}^{10}", "Pnn2", "", "orthorhombic", "C2v"),
    "C2v^11": (35, "C_{2v}^{11}", "Cmm2", "", "orthorhombic", "C2v"),
    "C2v^12": (36, "C_{2v}^{12}", "Cmc2_1", "", "orthorhombic", "C2v"),
    "C2v^13": (37, "C_{2v}^{13}", "Ccc2", "", "orthorhombic", "C2v"),
    "C2v^14": (38, "C_{2v}^{14}", "Amm2", "", "orthorhombic", "C2v"),
    "C2v^15": (39, "C_{2v}^{15}", "Aem2", "", "orthorhombic", "C2v"),
    "C2v^16": (40, "C_{2v}^{16}", "Ama2", "", "orthorhombic", "C2v"),
    "C2v^17": (41, "C_{2v}^{17}", "Aea2", "", "orthorhombic", "C2v"),
    "C2v^18": (42, "C_{2v}^{18}", "Fmm2", "", "orthorhombic", "C2v"),
    "C2v^19": (43, "C_{2v}^{19}", "Fdd2", "", "orthorhombic", "C2v"),
    "C2v^20": (44, "C_{2v}^{20}", "Imm2", "", "orthorhombic", "C2v"),
    "C2v^21": (45, "C_{2v}^{21}", "Iba2", "", "orthorhombic", "C2v"),
    "C2v^22": (46, "C_{2v}^{22}", "Ima2", "", "orthorhombic", "C2v"),
    "D2h^1": (47, "D_{2h}^{1}", "Pmmm", "", "orthorhombic", "D2h"),
    "D2h^2": (48, "D_{2h}^{2}", "Pnnn", "", "orthorhombic", "D2h"),
    "D2h^3": (49, "D_{2h}^{3}", "Pccm", "", "orthorhombic", "D2h"),
    "D2h^4": (50, "D_{2h}^{4}", "Pban", "", "orthorhombic", "D2h"),
    "D2h^5": (51, "D_{2h}^{5}", "Pmma", "", "orthorhombic", "D2h"),
    "D2h^6": (52, "D_{2h}^{6}", "Pnna", "", "orthorhombic", "D2h"),
    "D2h^7": (53, "D_{2h}^{7}", "Pmna", "", "orthorhombic", "D2h"),
    "D2h^8": (54, "D_{2h}^{8}", "Pcca", "", "orthorhombic", "D2h"),
    "D2h^9": (55, "D_{2h}^{9}", "Pbam", "", "orthorhombic", "D2h"),
    "D2h^10": (56, "D_{2h}^{10}", "Pccn", "", "orthorhombic", "D2h"),
    "D2h^11": (57, "D_{2h}^{11}", "Pbcm", "", "orthorhombic", "D2h"),
    "D2h^12": (58, "D_{2h}^{12}", "Pnnm", "", "orthorhombic", "D2h"),
    "D2h^13": (59, "D_{2h}^{13}", "Pmmn", "", "orthorhombic", "D2h"),
    "D2h^14": (60, "D_{2h}^{14}", "Pbcn", "", "orthorhombic", "D2h"),
    "D2h^15": (61, "D_{2h}^{15}", "Pbca", "", "orthorhombic", "D2h"),
    "D2h^16": (62, "D_{2h}^{16}", "Pnma", "", "orthorhombic", "D2h"),
    "D2h^17": (63, "D_{2h}^{17}", "Cmcm", "", "orthorhombic", "D2h"),
    "D2h^18": (64, "D_{2h}^{18}", "Cmce", "", "orthorhombic", "D2h"),
    "D2h^19": (65, "D_{2h}^{19}", "Cmmm", "", "orthorhombic", "D2h"),
    "D2h^20": (66, "D_{2h}^{20}", "Cccm", "", "orthorhombic", "D2h"),
    "D2h^21": (67, "D_{2h}^{21}", "Cmme", "", "orthorhombic", "D2h"),
    "D2h^22": (68, "D_{2h}^{22}", "Ccce", "", "orthorhombic", "D2h"),
    "D2h^23": (69, "D_{2h}^{23}", "Fmmm", "", "orthorhombic", "D2h"),
    "D2h^24": (70, "D_{2h}^{24}", "Fddd", "", "orthorhombic", "D2h"),
    "D2h^25": (71, "D_{2h}^{25}", "Immm", "", "orthorhombic", "D2h"),
    "D2h^26": (72, "D_{2h}^{26}", "Ibam", "", "orthorhombic", "D2h"),
    "D2h^27": (73, "D_{2h}^{27}", "Ibca", "", "orthorhombic", "D2h"),
    "D2h^28": (74, "D_{2h}^{28}", "Imma", "", "orthorhombic", "D2h"),
    "C4^1": (75, "C_{4}^{1}", "P4", "", "tetragonal", "C4"),
    "C4^2": (76, "C_{4}^{2}", "P4_1", "", "tetragonal", "C4"),
    "C4^3": (77, "C_{4}^{3}", "P4_2", "", "tetragonal", "C4"),
    "C4^4": (78, "C_{4}^{4}", "P4_3", "", "tetragonal", "C4"),
    "C4^5": (79, "C_{4}^{5}", "I4", "", "tetragonal", "C4"),
    "C4^6": (80, "C_{4}^{6}", "I4_1", "", "tetragonal", "C4"),
    "S4^1": (81, "S_{4}^{1}", "P-4", "", "tetragonal", "S4"),
    "S4^2": (82, "S_{4}^{2}", "I-4", "", "tetragonal", "S4"),
    "C4h^1": (83, "C_{4h}^{1}", "P4/m", "", "tetragonal", "C4h"),
    "C4h^2": (84, "C_{4h}^{2}", "P4_2/m", "", "tetragonal", "C4h"),
    "C4h^3": (85, "C_{4h}^{3}", "P4/n", "", "tetragonal", "C4h"),
    "C4h^4": (86, "C_{4h}^{4}", "P4_2/n", "", "tetragonal", "C4h"),
    "C4h^5": (87, "C_{4h}^{5}", "I4/m", "", "tetragonal", "C4h"),
    "C4h^6": (88, "C_{4h}^{6}", "I4_1/a", "", "tetragonal", "C4h"),
    "D4^1": (89, "D_{4}^{1}", "P422", "", "tetragonal", "D4"),
    "D4^2": (90, "D_{4}^{2}", "P42_12", "", "tetragonal", "D4"),
    "D4^3": (91, "D_{4}^{3}", "P4_122", "", "tetragonal", "D4"),
    "D4^4": (92, "D_{4}^{4}", "P4_12_12", "", "tetragonal", "D4"),
    "D4^5": (93, "D_{4}^{5}", "P4_222", "", "tetragonal", "D4"),
    "D4^6": (94, "D_{4}^{6}", "P4_22_12", "", "tetragonal", "D4"),
    "D4^7": (95, "D_{4}^{7}", "P4_322", "", "tetragonal", "D4"),
    "D4^8": (96, "D_{4}^{8}", "P4_32_12", "", "tetragonal", "D4"),
    "D4^9": (97, "D_{4}^{9}", "I422", "", "tetragonal", "D4"),
    "D4^10": (98, "D_{4}^{10}", "I4_122", "", "tetragonal", "D4"),
    "C4v^1": (99, "C_{4v}^{1}", "P4mm", "", "tetragonal", "C4v"),
    "C4v^2": (100, "C_{4v}^{2}", "P4bm", "", "tetragonal", "C4v"),
    "C4v^3": (101, "C_{4v}^{3}", "P4_2cm", "", "tetragonal", "C4v"),
    "C4v^4": (102, "C_{4v}^{4}", "P4_2nm", "", "tetragonal", "C4v"),
    "C4v^5": (103, "C_{4v}^{5}", "P4cc", "", "tetragonal", "C4v"),
    "C4v^6": (104, "C_{4v}^{6}", "P4nc", "", "tetragonal", "C4v"),
    "C4v^7": (105, "C_{4v}^{7}", "P4_2mc", "", "tetragonal", "C4v"),
    "C4v^8": (106, "C_{4v}^{8}", "P4_2bc", "", "tetragonal", "C4v"),
    "C4v^9": (107, "C_{4v}^{9}", "I4mm", "", "tetragonal", "C4v"),
    "C4v^10": (108, "C_{4v}^{10}", "I4cm", "", "tetragonal", "C4v"),
    "C4v^11": (109, "C_{4v}^{11}", "I4_1md", "", "tetragonal", "C4v"),
    "C4v^12": (110, "C_{4v}^{12}", "I4_1cd", "", "tetragonal", "C4v"),
    "D2d^1": (111, "D_{2d}^{1}", "P-42m", "", "tetragonal", "D2d"),
    "D2d^2": (112, "D_{2d}^{2}", "P-42c", "", "tetragonal", "D2d"),
    "D2d^3": (113, "D_{2d}^{3}", "P-42_1m", "", "tetragonal", "D2d"),
    "D2d^4": (114, "D_{2d}^{4}", "P-42_1c", "", "tetragonal", "D2d"),
    "D2d^5": (115, "D_{2d}^{5}", "P-4m2", "", "tetragonal", "D2d-1"),
    "D2d^6": (116, "D_{2d}^{6}", "P-4c2", "", "tetragonal", "D2d-1"),
    "D2d^7": (117, "D_{2d}^{7}", "P-4b2", "", "tetragonal", "D2d-1"),
    "D2d^8": (118, "D_{2d}^{8}", "P-4n2", "", "tetragonal", "D2d-1"),
    "D2d^9": (119, "D_{2d}^{9}", "I-4m2", "", "tetragonal", "D2d-1"),
    "D2d^10": (120, "D_{2d}^{10}", "I-4c2", "", "tetragonal", "D2d-1"),
    "D2d^11": (121, "D_{2d}^{11}", "I-42m", "", "tetragonal", "D2d"),
    "D2d^12": (122, "D_{2d}^{12}", "I-42d", "", "tetragonal", "D2d"),
    "D4h^1": (123, "D_{4h}^{1}", "P4/mmm", "", "tetragonal", "D4h"),
    "D4h^2": (124, "D_{4h}^{2}", "P4/mcc", "", "tetragonal", "D4h"),
    "D4h^3": (125, "D_{4h}^{3}", "P4/nbm", "", "tetragonal", "D4h"),
    "D4h^4": (126, "D_{4h}^{4}", "P4/nnc", "", "tetragonal", "D4h"),
    "D4h^5": (127, "D_{4h}^{5}", "P4/mbm", "", "tetragonal", "D4h"),
    "D4h^6": (128, "D_{4h}^{6}", "P4/mnc", "", "tetragonal", "D4h"),
    "D4h^7": (129, "D_{4h}^{7}", "P4/nmm", "", "tetragonal", "D4h"),
    "D4h^8": (130, "D_{4h}^{8}", "P4/ncc", "", "tetragonal", "D4h"),
    "D4h^9": (131, "D_{4h}^{9}", "P4_2/mmc", "", "tetragonal", "D4h"),
    "D4h^10": (132, "D_{4h}^{10}", "P4_2/mcm", "", "tetragonal", "D4h"),
    "D4h^11": (133, "D_{4h}^{11}", "P4_2/nbc", "", "tetragonal", "D4h"),
    "D4h^12": (134, "D_{4h}^{12}", "P4_2/nnm", "", "tetragonal", "D4h"),
    "D4h^13": (135, "D_{4h}^{13}", "P4_2/mbc", "", "tetragonal", "D4h"),
    "D4h^14": (136, "D_{4h}^{14}", "P4_2/mnm", "", "tetragonal", "D4h"),
    "D4h^15": (137, "D_{4h}^{15}", "P4_2/nmc", "", "tetragonal", "D4h"),
    "D4h^16": (138, "D_{4h}^{16}", "P4_2/ncm", "", "tetragonal", "D4h"),
    "D4h^17": (139, "D_{4h}^{17}", "I4/mmm", "", "tetragonal", "D4h"),
    "D4h^18": (140, "D_{4h}^{18}", "I4/mcm", "", "tetragonal", "D4h"),
    "D4h^19": (141, "D_{4h}^{19}", "I4_1/amd", "", "tetragonal", "D4h"),
    "D4h^20": (142, "D_{4h}^{20}", "I4_1/acd", "", "tetragonal", "D4h"),
    "C3^1": (143, "C_{3}^{1}", "P3", "", "trigonal", "C3"),
    "C3^2": (144, "C_{3}^{2}", "P3_1", "", "trigonal", "C3"),
    "C3^3": (145, "C_{3}^{3}", "P3_2", "", "trigonal", "C3"),
    "C3^4": (146, "C_{3}^{4}", "R3", "", "trigonal", "C3"),
    "C3i^1": (147, "C_{3i}^{1}", "P-3", "", "trigonal", "C3i"),
    "C3i^2": (148, "C_{3i}^{2}", "R-3", "", "trigonal", "C3i"),
    "D3^1": (149, "D_{3}^{1}", "P312", "", "trigonal", "D3"),
    "D3^2": (150, "D_{3}^{2}", "P321", "", "trigonal", "D3-1"),
    "D3^3": (151, "D_{3}^{3}", "P3_112", "", "trigonal", "D3"),
    "D3^4": (152, "D_{3}^{4}", "P3_121", "", "trigonal", "D3-1"),
    "D3^5": (153, "D_{3}^{5}", "P3_212", "", "trigonal", "D3"),
    "D3^6": (154, "D_{3}^{6}", "P3_221", "", "trigonal", "D3-1"),
    "D3^7": (155, "D_{3}^{7}", "R32", "", "trigonal", "D3-1"),
    "C3v^1": (156, "C_{3v}^{1}", "P3m1", "", "trigonal", "C3v"),
    "C3v^2": (157, "C_{3v}^{2}", "P31m", "", "trigonal", "C3v-1"),
    "C3v^3": (158, "C_{3v}^{3}", "P3c1", "", "trigonal", "C3v"),
    "C3v^4": (159, "C_{3v}^{4}", "P31c", "", "trigonal", "C3v-1"),
    "C3v^5": (160, "C_{3v}^{5}", "R3m", "", "trigonal", "C3v"),
    "C3v^6": (161, "C_{3v}^{6}", "R3c", "", "trigonal", "C3v"),
    "D3d^1": (162, "D_{3d}^{1}", "P-31m", "", "trigonal", "D3d"),
    "D3d^2": (163, "D_{3d}^{2}", "P-31c", "", "trigonal", "D3d"),
    "D3d^3": (164, "D_{3d}^{3}", "P-3m1", "", "trigonal", "D3d-1"),
    "D3d^4": (165, "D_{3d}^{4}", "P-3c1", "", "trigonal", "D3d-1"),
    "D3d^5": (166, "D_{3d}^{5}", "R-3m", "", "trigonal", "D3d-1"),
    "D3d^6": (167, "D_{3d}^{6}", "R-3c", "", "trigonal", "D3d-1"),
    "C6^1": (168, "C_{6}^{1}", "P6", "", "hexagonal", "C6"),
    "C6^2": (169, "C_{6}^{2}", "P6_1", "", "hexagonal", "C6"),
    "C6^3": (170, "C_{6}^{3}", "P6_5", "", "hexagonal", "C6"),
    "C6^4": (171, "C_{6}^{4}", "P6_2", "", "hexagonal", "C6"),
    "C6^5": (172, "C_{6}^{5}", "P6_4", "", "hexagonal", "C6"),
    "C6^6": (173, "C_{6}^{6}", "P6_3", "", "hexagonal", "C6"),
    "C3h^1": (174, "C_{3h}^{1}", "P-6", "", "hexagonal", "C3h"),
    "C6h^1": (175, "C_{6h}^{1}", "P6/m", "", "hexagonal", "C6h"),
    "C6h^2": (176, "C_{6h}^{2}", "P6_3/m", "", "hexagonal", "C6h"),
    "D6^1": (177, "D_{6}^{1}", "P622", "", "hexagonal", "D6"),
    "D6^2": (178, "D_{6}^{2}", "P6_122", "", "hexagonal", "D6"),
    "D6^3": (179, "D_{6}^{3}", "P6_522", "", "hexagonal", "D6"),
    "D6^4": (180, "D_{6}^{4}", "P6_222", "", "hexagonal", "D6"),
    "D6^5": (181, "D_{6}^{5}", "P6_422", "", "hexagonal", "D6"),
    "D6^6": (182, "D_{6}^{6}", "P6_322", "", "hexagonal", "D6"),
    "C6v^1": (183, "C_{6v}^{1}", "P6mm", "", "hexagonal", "C6v"),
    "C6v^2": (184, "C_{6v}^{2}", "P6cc", "", "hexagonal", "C6v"),
    "C6v^3": (185, "C_{6v}^{3}", "P6_3cm", "", "hexagonal", "C6v"),
    "C6v^4": (186, "C_{6v}^{4}", "P6_3mc", "", "hexagonal", "C6v"),
    "D3h^1": (187, "D_{3h}^{1}", "P-6m2", "", "hexagonal", "D3h"),
    "D3h^2": (188, "D_{3h}^{2}", "P-6c2", "", "hexagonal", "D3h"),
    "D3h^3": (189, "D_{3h}^{3}", "P-62m", "", "hexagonal", "D3h-1"),
    "D3h^4": (190, "D_{3h}^{4}", "P-62c", "", "hexagonal", "D3h-1"),
    "D6h^1": (191, "D_{6h}^{1}", "P6/mmm", "", "hexagonal", "D6h"),
    "D6h^2": (192, "D_{6h}^{2}", "P6/mcc", "", "hexagonal", "D6h"),
    "D6h^3": (193, "D_{6h}^{3}", "P6_3/mcm", "", "hexagonal", "D6h"),
    "D6h^4": (194, "D_{6h}^{4}", "P6_3/mmc", "", "hexagonal", "D6h"),
    "T^1": (195, "T_{}^{1}", "P23", "", "cubic", "T"),
    "T^2": (196, "T_{}^{2}", "F23", "", "cubic", "T"),
    "T^3": (197, "T_{}^{3}", "I23", "", "cubic", "T"),
    "T^4": (198, "T_{}^{4}", "P2_13", "", "cubic", "T"),
    "T^5": (199, "T_{}^{5}", "I2_13", "", "cubic", "T"),
    "Th^1": (200, "T_{h}^{1}", "Pm-3", "", "cubic", "Th"),
    "Th^2": (201, "T_{h}^{2}", "Pn-3", "", "cubic", "Th"),
    "Th^3": (202, "T_{h}^{3}", "Fm-3", "", "cubic", "Th"),
    "Th^4": (203, "T_{h}^{4}", "Fd-3", "", "cubic", "Th"),
    "Th^5": (204, "T_{h}^{5}", "Im-3", "", "cubic", "Th"),
    "Th^6": (205, "T_{h}^{6}", "Pa-3", "", "cubic", "Th"),
    "Th^7": (206, "T_{h}^{7}", "Ia-3", "", "cubic", "Th"),
    "O^1": (207, "O_{}^{1}", "P432", "", "cubic", "O"),
    "O^2": (208, "O_{}^{2}", "P4_232", "", "cubic", "O"),
    "O^3": (209, "O_{}^{3}", "F432", "", "cubic", "O"),
    "O^4": (210, "O_{}^{4}", "F4_132", "", "cubic", "O"),
    "O^5": (211, "O_{}^{5}", "I432", "", "cubic", "O"),
    "O^6": (212, "O_{}^{6}", "P4_332", "", "cubic", "O"),
    "O^7": (213, "O_{}^{7}", "P4_132", "", "cubic", "O"),
    "O^8": (214, "O_{}^{8}", "I4_132", "", "cubic", "O"),
    "Td^1": (215, "T_{d}^{1}", "P-43m", "", "cubic", "Td"),
    "Td^2": (216, "T_{d}^{2}", "F-43m", "", "cubic", "Td"),
    "Td^3": (217, "T_{d}^{3}", "I-43m", "", "cubic", "Td"),
    "Td^4": (218, "T_{d}^{4}", "P-43n", "", "cubic", "Td"),
    "Td^5": (219, "T_{d}^{5}", "F-43c", "", "cubic", "Td"),
    "Td^6": (220, "T_{d}^{6}", "I-43d", "", "cubic", "Td"),
    "Oh^1": (221, "O_{h}^{1}", "Pm-3m", "", "cubic", "Oh"),
    "Oh^2": (222, "O_{h}^{2}", "Pn-3n", "", "cubic", "Oh"),
    "Oh^3": (223, "O_{h}^{3}", "Pm-3n", "", "cubic", "Oh"),
    "Oh^4": (224, "O_{h}^{4}", "Pn-3m", "", "cubic", "Oh"),
    "Oh^5": (225, "O_{h}^{5}", "Fm-3m", "", "cubic", "Oh"),
    "Oh^6": (226, "O_{h}^{6}", "Fm-3c", "", "cubic", "Oh"),
    "Oh^7": (227, "O_{h}^{7}", "Fd-3m", "", "cubic", "Oh"),
    "Oh^8": (228, "O_{h}^{8}", "Fd-3c", "", "cubic", "Oh"),
    "Oh^9": (229, "O_{h}^{9}", "Im-3m", "", "cubic", "Oh"),
    "Oh^10": (230, "O_{h}^{10}", "Ia-3d", "", "cubic", "Oh"),
}


"""
space groups categorized by crystal.
"""
_data_tag_space_group_crystal = {val[4]: [] for val in _data_tag_space_group.values()}
for tag, val in _data_tag_space_group.items():
    _data_tag_space_group_crystal[val[4]].append(tag)
_data_tag_space_group_crystal = {c: tuple(v) for c, v in _data_tag_space_group_crystal.items()}
