"""
symmetry operation for space groups
    {space-group-tag: (generator, [conjugacy class])}
"""
_data_symmetry_operation_sg = {
    "C1^1": (["1:[0,0,0]"], [["1:[0,0,0]"]]),
    "Ci^1": (["-1:[0,0,0]"], [["1:[0,0,0]"], ["-1:[0,0,0]"]]),
    "C2^1": (["2[010]:[0,0,0]"], [["1:[0,0,0]"], ["2[010]:[0,0,0]"]]),
    "C2^2": (["2[010]:[0,1/2,0]"], [["1:[0,0,0]"], ["2[010]:[0,1/2,0]"]]),
    "C2^3": (["2[010]:[0,0,0]"], [["1:[0,0,0]"], ["2[010]:[0,0,0]"]]),
    "Cs^1": (["m[010]:[0,0,0]"], [["1:[0,0,0]"], ["m[010]:[0,0,0]"]]),
    "Cs^2": (["m[010]:[0,0,1/2]"], [["1:[0,0,0]"], ["m[010]:[0,0,1/2]"]]),
    "Cs^3": (["m[010]:[0,0,0]"], [["1:[0,0,0]"], ["m[010]:[0,0,0]"]]),
    "Cs^4": (["m[010]:[0,0,1/2]"], [["1:[0,0,0]"], ["m[010]:[0,0,1/2]"]]),
    "C2h^1": (["2[010]:[0,0,0]", "-1:[0,0,0]"], [["1:[0,0,0]"], ["2[010]:[0,0,0]"], ["-1:[0,0,0]"], ["m[010]:[0,0,0]"]]),
    "C2h^2": (["2[010]:[0,1/2,0]", "-1:[0,0,0]"], [["1:[0,0,0]"], ["2[010]:[0,1/2,0]"], ["-1:[0,0,0]"], ["m[010]:[0,1/2,0]"]]),
    "C2h^3": (["2[010]:[0,0,0]", "-1:[0,0,0]"], [["1:[0,0,0]"], ["2[010]:[0,0,0]"], ["-1:[0,0,0]"], ["m[010]:[0,0,0]"]]),
    "C2h^4": (["2[010]:[0,0,1/2]", "-1:[0,0,0]"], [["1:[0,0,0]"], ["2[010]:[0,0,1/2]"], ["-1:[0,0,0]"], ["m[010]:[0,0,1/2]"]]),
    "C2h^5": (["2[010]:[0,1/2,1/2]", "-1:[0,0,0]"], [["1:[0,0,0]"], ["2[010]:[0,1/2,1/2]"], ["-1:[0,0,0]"], ["m[010]:[0,1/2,1/2]"]]),
    "C2h^6": (["2[010]:[0,0,1/2]", "-1:[0,0,0]"], [["1:[0,0,0]"], ["2[010]:[0,0,1/2]"], ["-1:[0,0,0]"], ["m[010]:[0,0,1/2]"]]),
    "D2^1": (["2[001]:[0,0,0]", "2[010]:[0,0,0]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["2[010]:[0,0,0]"], ["2[100]:[0,0,0]"]]),
    "D2^2": (["2[001]:[0,0,1/2]", "2[010]:[0,0,1/2]"], [["1:[0,0,0]"], ["2[001]:[0,0,1/2]"], ["2[010]:[0,0,1/2]"], ["2[100]:[0,0,0]"]]),
    "D2^3": (["2[001]:[0,0,0]", "2[010]:[1/2,1/2,0]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["2[010]:[1/2,1/2,0]"], ["2[100]:[1/2,1/2,0]"]]),
    "D2^4": (["2[001]:[1/2,0,1/2]", "2[010]:[0,1/2,1/2]"], [["1:[0,0,0]"], ["2[001]:[1/2,0,1/2]"], ["2[010]:[0,1/2,1/2]"], ["2[100]:[1/2,1/2,0]"]]),
    "D2^5": (["2[001]:[0,0,1/2]", "2[010]:[0,0,1/2]"], [["1:[0,0,0]"], ["2[001]:[0,0,1/2]"], ["2[010]:[0,0,1/2]"], ["2[100]:[0,0,0]"]]),
    "D2^6": (["2[001]:[0,0,0]", "2[010]:[0,0,0]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["2[010]:[0,0,0]"], ["2[100]:[0,0,0]"]]),
    "D2^7": (["2[001]:[0,0,0]", "2[010]:[0,0,0]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["2[010]:[0,0,0]"], ["2[100]:[0,0,0]"]]),
    "D2^8": (["2[001]:[0,0,0]", "2[010]:[0,0,0]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["2[010]:[0,0,0]"], ["2[100]:[0,0,0]"]]),
    "D2^9": (["2[001]:[1/2,0,1/2]", "2[010]:[0,1/2,1/2]"], [["1:[0,0,0]"], ["2[001]:[1/2,0,1/2]"], ["2[010]:[0,1/2,1/2]"], ["2[100]:[1/2,1/2,0]"]]),
    "C2v^1": (["2[001]:[0,0,0]", "m[010]:[0,0,0]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["m[010]:[0,0,0]"], ["m[100]:[0,0,0]"]]),
    "C2v^2": (["2[001]:[0,0,1/2]", "m[010]:[0,0,1/2]"], [["1:[0,0,0]"], ["2[001]:[0,0,1/2]"], ["m[010]:[0,0,1/2]"], ["m[100]:[0,0,0]"]]),
    "C2v^3": (["2[001]:[0,0,0]", "m[010]:[0,0,1/2]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["m[010]:[0,0,1/2]"], ["m[100]:[0,0,1/2]"]]),
    "C2v^4": (["2[001]:[0,0,0]", "m[010]:[1/2,0,0]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["m[010]:[1/2,0,0]"], ["m[100]:[1/2,0,0]"]]),
    "C2v^5": (["2[001]:[0,0,1/2]", "m[010]:[1/2,0,0]"], [["1:[0,0,0]"], ["2[001]:[0,0,1/2]"], ["m[010]:[1/2,0,0]"], ["m[100]:[1/2,0,1/2]"]]),
    "C2v^6": (["2[001]:[0,0,0]", "m[010]:[0,1/2,1/2]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["m[010]:[0,1/2,1/2]"], ["m[100]:[0,1/2,1/2]"]]),
    "C2v^7": (["2[001]:[1/2,0,1/2]", "m[010]:[1/2,0,1/2]"], [["1:[0,0,0]"], ["2[001]:[1/2,0,1/2]"], ["m[010]:[1/2,0,1/2]"], ["m[100]:[0,0,0]"]]),
    "C2v^8": (["2[001]:[0,0,0]", "m[010]:[1/2,1/2,0]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["m[010]:[1/2,1/2,0]"], ["m[100]:[1/2,1/2,0]"]]),
    "C2v^9": (["2[001]:[0,0,1/2]", "m[010]:[1/2,1/2,0]"], [["1:[0,0,0]"], ["2[001]:[0,0,1/2]"], ["m[010]:[1/2,1/2,0]"], ["m[100]:[1/2,1/2,1/2]"]]),
    "C2v^10": (["2[001]:[0,0,0]", "m[010]:[1/2,1/2,1/2]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["m[010]:[1/2,1/2,1/2]"], ["m[100]:[1/2,1/2,1/2]"]]),
    "C2v^11": (["2[001]:[0,0,0]", "m[010]:[0,0,0]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["m[010]:[0,0,0]"], ["m[100]:[0,0,0]"]]),
    "C2v^12": (["2[001]:[0,0,1/2]", "m[010]:[0,0,1/2]"], [["1:[0,0,0]"], ["2[001]:[0,0,1/2]"], ["m[010]:[0,0,1/2]"], ["m[100]:[0,0,0]"]]),
    "C2v^13": (["2[001]:[0,0,0]", "m[010]:[0,0,1/2]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["m[010]:[0,0,1/2]"], ["m[100]:[0,0,1/2]"]]),
    "C2v^14": (["2[001]:[0,0,0]", "m[010]:[0,0,0]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["m[010]:[0,0,0]"], ["m[100]:[0,0,0]"]]),
    "C2v^15": (["2[001]:[0,0,0]", "m[010]:[0,1/2,0]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["m[010]:[0,1/2,0]"], ["m[100]:[0,1/2,0]"]]),
    "C2v^16": (["2[001]:[0,0,0]", "m[010]:[1/2,0,0]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["m[010]:[1/2,0,0]"], ["m[100]:[1/2,0,0]"]]),
    "C2v^17": (["2[001]:[0,0,0]", "m[010]:[1/2,1/2,0]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["m[010]:[1/2,1/2,0]"], ["m[100]:[1/2,1/2,0]"]]),
    "C2v^18": (["2[001]:[0,0,0]", "m[010]:[0,0,0]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["m[010]:[0,0,0]"], ["m[100]:[0,0,0]"]]),
    "C2v^19": (["2[001]:[0,0,0]", "m[010]:[1/4,1/4,1/4]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["m[010]:[1/4,1/4,1/4]"], ["m[100]:[1/4,1/4,1/4]"]]),
    "C2v^20": (["2[001]:[0,0,0]", "m[010]:[0,0,0]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["m[010]:[0,0,0]"], ["m[100]:[0,0,0]"]]),
    "C2v^21": (["2[001]:[0,0,0]", "m[010]:[1/2,1/2,0]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["m[010]:[1/2,1/2,0]"], ["m[100]:[1/2,1/2,0]"]]),
    "C2v^22": (["2[001]:[0,0,0]", "m[010]:[1/2,0,0]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["m[010]:[1/2,0,0]"], ["m[100]:[1/2,0,0]"]]),
    "D2h^1": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[010]:[0,0,0]"],
            ["2[100]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["m[010]:[0,0,0]"],
            ["m[100]:[0,0,0]"],
        ],
    ),
    "D2h^2": (
        ["2[001]:[1/2,1/2,0]", "2[010]:[1/2,0,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,1/2,0]"],
            ["2[010]:[1/2,0,1/2]"],
            ["2[100]:[0,1/2,1/2]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,1/2,0]"],
            ["m[010]:[1/2,0,1/2]"],
            ["m[100]:[0,1/2,1/2]"],
        ],
    ),
    "D2h^3": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[010]:[0,0,1/2]"],
            ["2[100]:[0,0,1/2]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["m[010]:[0,0,1/2]"],
            ["m[100]:[0,0,1/2]"],
        ],
    ),
    "D2h^4": (
        ["2[001]:[1/2,1/2,0]", "2[010]:[1/2,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,1/2,0]"],
            ["2[010]:[1/2,0,0]"],
            ["2[100]:[0,1/2,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,1/2,0]"],
            ["m[010]:[1/2,0,0]"],
            ["m[100]:[0,1/2,0]"],
        ],
    ),
    "D2h^5": (
        ["2[001]:[1/2,0,0]", "2[010]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,0,0]"],
            ["2[010]:[0,0,0]"],
            ["2[100]:[1/2,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,0,0]"],
            ["m[010]:[0,0,0]"],
            ["m[100]:[1/2,0,0]"],
        ],
    ),
    "D2h^6": (
        ["2[001]:[1/2,0,0]", "2[010]:[1/2,1/2,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,0,0]"],
            ["2[010]:[1/2,1/2,1/2]"],
            ["2[100]:[0,1/2,1/2]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,0,0]"],
            ["m[010]:[1/2,1/2,1/2]"],
            ["m[100]:[0,1/2,1/2]"],
        ],
    ),
    "D2h^7": (
        ["2[001]:[1/2,0,1/2]", "2[010]:[1/2,0,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,0,1/2]"],
            ["2[010]:[1/2,0,1/2]"],
            ["2[100]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,0,1/2]"],
            ["m[010]:[1/2,0,1/2]"],
            ["m[100]:[0,0,0]"],
        ],
    ),
    "D2h^8": (
        ["2[001]:[1/2,0,0]", "2[010]:[0,0,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,0,0]"],
            ["2[010]:[0,0,1/2]"],
            ["2[100]:[1/2,0,1/2]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,0,0]"],
            ["m[010]:[0,0,1/2]"],
            ["m[100]:[1/2,0,1/2]"],
        ],
    ),
    "D2h^9": (
        ["2[001]:[0,0,0]", "2[010]:[1/2,1/2,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[010]:[1/2,1/2,0]"],
            ["2[100]:[1/2,1/2,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["m[010]:[1/2,1/2,0]"],
            ["m[100]:[1/2,1/2,0]"],
        ],
    ),
    "D2h^10": (
        ["2[001]:[1/2,1/2,0]", "2[010]:[0,1/2,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,1/2,0]"],
            ["2[010]:[0,1/2,1/2]"],
            ["2[100]:[1/2,0,1/2]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,1/2,0]"],
            ["m[010]:[0,1/2,1/2]"],
            ["m[100]:[1/2,0,1/2]"],
        ],
    ),
    "D2h^11": (
        ["2[001]:[0,0,1/2]", "2[010]:[0,1/2,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,1/2]"],
            ["2[010]:[0,1/2,1/2]"],
            ["2[100]:[0,1/2,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,1/2]"],
            ["m[010]:[0,1/2,1/2]"],
            ["m[100]:[0,1/2,0]"],
        ],
    ),
    "D2h^12": (
        ["2[001]:[0,0,0]", "2[010]:[1/2,1/2,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[010]:[1/2,1/2,1/2]"],
            ["2[100]:[1/2,1/2,1/2]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["m[010]:[1/2,1/2,1/2]"],
            ["m[100]:[1/2,1/2,1/2]"],
        ],
    ),
    "D2h^13": (
        ["2[001]:[1/2,1/2,0]", "2[010]:[0,1/2,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,1/2,0]"],
            ["2[010]:[0,1/2,0]"],
            ["2[100]:[1/2,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,1/2,0]"],
            ["m[010]:[0,1/2,0]"],
            ["m[100]:[1/2,0,0]"],
        ],
    ),
    "D2h^14": (
        ["2[001]:[1/2,1/2,1/2]", "2[010]:[0,0,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,1/2,1/2]"],
            ["2[010]:[0,0,1/2]"],
            ["2[100]:[1/2,1/2,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,1/2,1/2]"],
            ["m[010]:[0,0,1/2]"],
            ["m[100]:[1/2,1/2,0]"],
        ],
    ),
    "D2h^15": (
        ["2[001]:[1/2,0,1/2]", "2[010]:[0,1/2,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,0,1/2]"],
            ["2[010]:[0,1/2,1/2]"],
            ["2[100]:[1/2,1/2,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,0,1/2]"],
            ["m[010]:[0,1/2,1/2]"],
            ["m[100]:[1/2,1/2,0]"],
        ],
    ),
    "D2h^16": (
        ["2[001]:[1/2,0,1/2]", "2[010]:[0,1/2,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,0,1/2]"],
            ["2[010]:[0,1/2,0]"],
            ["2[100]:[1/2,1/2,1/2]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,0,1/2]"],
            ["m[010]:[0,1/2,0]"],
            ["m[100]:[1/2,1/2,1/2]"],
        ],
    ),
    "D2h^17": (
        ["2[001]:[0,0,1/2]", "2[010]:[0,0,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,1/2]"],
            ["2[010]:[0,0,1/2]"],
            ["2[100]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,1/2]"],
            ["m[010]:[0,0,1/2]"],
            ["m[100]:[0,0,0]"],
        ],
    ),
    "D2h^18": (
        ["2[001]:[0,1/2,1/2]", "2[010]:[0,1/2,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,1/2,1/2]"],
            ["2[010]:[0,1/2,1/2]"],
            ["2[100]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,1/2,1/2]"],
            ["m[010]:[0,1/2,1/2]"],
            ["m[100]:[0,0,0]"],
        ],
    ),
    "D2h^19": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[010]:[0,0,0]"],
            ["2[100]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["m[010]:[0,0,0]"],
            ["m[100]:[0,0,0]"],
        ],
    ),
    "D2h^20": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[010]:[0,0,1/2]"],
            ["2[100]:[0,0,1/2]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["m[010]:[0,0,1/2]"],
            ["m[100]:[0,0,1/2]"],
        ],
    ),
    "D2h^21": (
        ["2[001]:[0,1/2,0]", "2[010]:[0,1/2,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,1/2,0]"],
            ["2[010]:[0,1/2,0]"],
            ["2[100]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,1/2,0]"],
            ["m[010]:[0,1/2,0]"],
            ["m[100]:[0,0,0]"],
        ],
    ),
    "D2h^22": (
        ["2[001]:[1/2,0,0]", "2[010]:[0,0,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,0,0]"],
            ["2[010]:[0,0,1/2]"],
            ["2[100]:[1/2,0,1/2]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,0,0]"],
            ["m[010]:[0,0,1/2]"],
            ["m[100]:[1/2,0,1/2]"],
        ],
    ),
    "D2h^23": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[010]:[0,0,0]"],
            ["2[100]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["m[010]:[0,0,0]"],
            ["m[100]:[0,0,0]"],
        ],
    ),
    "D2h^24": (
        ["2[001]:[3/4,3/4,0]", "2[010]:[3/4,0,3/4]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[3/4,3/4,0]"],
            ["2[010]:[3/4,0,3/4]"],
            ["2[100]:[0,3/4,3/4]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/4,1/4,0]"],
            ["m[010]:[1/4,0,1/4]"],
            ["m[100]:[0,1/4,1/4]"],
        ],
    ),
    "D2h^25": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[010]:[0,0,0]"],
            ["2[100]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["m[010]:[0,0,0]"],
            ["m[100]:[0,0,0]"],
        ],
    ),
    "D2h^26": (
        ["2[001]:[0,0,0]", "2[010]:[1/2,1/2,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[010]:[1/2,1/2,0]"],
            ["2[100]:[1/2,1/2,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["m[010]:[1/2,1/2,0]"],
            ["m[100]:[1/2,1/2,0]"],
        ],
    ),
    "D2h^27": (
        ["2[001]:[1/2,0,1/2]", "2[010]:[0,1/2,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,0,1/2]"],
            ["2[010]:[0,1/2,1/2]"],
            ["2[100]:[1/2,1/2,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,0,1/2]"],
            ["m[010]:[0,1/2,1/2]"],
            ["m[100]:[1/2,1/2,0]"],
        ],
    ),
    "D2h^28": (
        ["2[001]:[0,1/2,0]", "2[010]:[0,1/2,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,1/2,0]"],
            ["2[010]:[0,1/2,0]"],
            ["2[100]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,1/2,0]"],
            ["m[010]:[0,1/2,0]"],
            ["m[100]:[0,0,0]"],
        ],
    ),
    "C4^1": (["2[001]:[0,0,0]", "4+[001]:[0,0,0]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["4+[001]:[0,0,0]"], ["4-[001]:[0,0,0]"]]),
    "C4^2": (["2[001]:[0,0,1/2]", "4+[001]:[0,0,1/4]"], [["1:[0,0,0]"], ["2[001]:[0,0,1/2]"], ["4+[001]:[0,0,1/4]"], ["4-[001]:[0,0,3/4]"]]),
    "C4^3": (["2[001]:[0,0,0]", "4+[001]:[0,0,1/2]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["4+[001]:[0,0,1/2]"], ["4-[001]:[0,0,1/2]"]]),
    "C4^4": (["2[001]:[0,0,1/2]", "4+[001]:[0,0,3/4]"], [["1:[0,0,0]"], ["2[001]:[0,0,1/2]"], ["4+[001]:[0,0,3/4]"], ["4-[001]:[0,0,1/4]"]]),
    "C4^5": (["2[001]:[0,0,0]", "4+[001]:[0,0,0]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["4+[001]:[0,0,0]"], ["4-[001]:[0,0,0]"]]),
    "C4^6": (
        ["2[001]:[1/2,1/2,1/2]", "4+[001]:[0,1/2,1/4]"],
        [["1:[0,0,0]"], ["2[001]:[1/2,1/2,1/2]"], ["4+[001]:[0,1/2,1/4]"], ["4-[001]:[1/2,0,3/4]"]],
    ),
    "S4^1": (["2[001]:[0,0,0]", "-4+[001]:[0,0,0]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["-4+[001]:[0,0,0]"], ["-4-[001]:[0,0,0]"]]),
    "S4^2": (["2[001]:[0,0,0]", "-4+[001]:[0,0,0]"], [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["-4+[001]:[0,0,0]"], ["-4-[001]:[0,0,0]"]]),
    "C4h^1": (
        ["2[001]:[0,0,0]", "4+[001]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["4+[001]:[0,0,0]"],
            ["4-[001]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["-4+[001]:[0,0,0]"],
            ["-4-[001]:[0,0,0]"],
        ],
    ),
    "C4h^2": (
        ["2[001]:[0,0,0]", "4+[001]:[0,0,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["4+[001]:[0,0,1/2]"],
            ["4-[001]:[0,0,1/2]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["-4+[001]:[0,0,1/2]"],
            ["-4-[001]:[0,0,1/2]"],
        ],
    ),
    "C4h^3": (
        ["2[001]:[1/2,1/2,0]", "4+[001]:[1/2,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,1/2,0]"],
            ["4+[001]:[1/2,0,0]"],
            ["4-[001]:[0,1/2,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,1/2,0]"],
            ["-4+[001]:[1/2,0,0]"],
            ["-4-[001]:[0,1/2,0]"],
        ],
    ),
    "C4h^4": (
        ["2[001]:[1/2,1/2,0]", "4+[001]:[0,1/2,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,1/2,0]"],
            ["4+[001]:[0,1/2,1/2]"],
            ["4-[001]:[1/2,0,1/2]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,1/2,0]"],
            ["-4+[001]:[0,1/2,1/2]"],
            ["-4-[001]:[1/2,0,1/2]"],
        ],
    ),
    "C4h^5": (
        ["2[001]:[0,0,0]", "4+[001]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["4+[001]:[0,0,0]"],
            ["4-[001]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["-4+[001]:[0,0,0]"],
            ["-4-[001]:[0,0,0]"],
        ],
    ),
    "C4h^6": (
        ["2[001]:[1/2,0,1/2]", "4+[001]:[3/4,1/4,1/4]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,0,1/2]"],
            ["4+[001]:[3/4,1/4,1/4]"],
            ["4-[001]:[3/4,3/4,3/4]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,0,1/2]"],
            ["-4+[001]:[1/4,3/4,3/4]"],
            ["-4-[001]:[1/4,1/4,1/4]"],
        ],
    ),
    "D4^1": (
        ["2[001]:[0,0,0]", "4+[001]:[0,0,0]", "2[010]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            ["2[110]:[0,0,0]", "2[1-10]:[0,0,0]"],
            ["4+[001]:[0,0,0]", "4-[001]:[0,0,0]"],
        ],
    ),
    "D4^2": (
        ["2[001]:[0,0,0]", "4+[001]:[1/2,1/2,0]", "2[010]:[1/2,1/2,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[1/2,1/2,0]", "2[010]:[1/2,1/2,0]"],
            ["2[110]:[0,0,0]", "2[1-10]:[0,0,0]"],
            ["4+[001]:[1/2,1/2,0]", "4-[001]:[1/2,1/2,0]"],
        ],
    ),
    "D4^3": (
        ["2[001]:[0,0,1/2]", "4+[001]:[0,0,1/4]", "2[010]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,1/2]"],
            ["2[100]:[0,0,1/2]", "2[010]:[0,0,0]"],
            ["2[110]:[0,0,3/4]", "2[1-10]:[0,0,1/4]"],
            ["4+[001]:[0,0,1/4]", "4-[001]:[0,0,3/4]"],
        ],
    ),
    "D4^4": (
        ["2[001]:[0,0,1/2]", "4+[001]:[1/2,1/2,1/4]", "2[010]:[1/2,1/2,1/4]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,1/2]"],
            ["2[100]:[1/2,1/2,3/4]", "2[010]:[1/2,1/2,1/4]"],
            ["2[110]:[0,0,0]", "2[1-10]:[0,0,1/2]"],
            ["4+[001]:[1/2,1/2,1/4]", "4-[001]:[1/2,1/2,3/4]"],
        ],
    ),
    "D4^5": (
        ["2[001]:[0,0,0]", "4+[001]:[0,0,1/2]", "2[010]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            ["2[110]:[0,0,1/2]", "2[1-10]:[0,0,1/2]"],
            ["4+[001]:[0,0,1/2]", "4-[001]:[0,0,1/2]"],
        ],
    ),
    "D4^6": (
        ["2[001]:[0,0,0]", "4+[001]:[1/2,1/2,1/2]", "2[010]:[1/2,1/2,1/2]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[1/2,1/2,1/2]", "2[010]:[1/2,1/2,1/2]"],
            ["2[110]:[0,0,0]", "2[1-10]:[0,0,0]"],
            ["4+[001]:[1/2,1/2,1/2]", "4-[001]:[1/2,1/2,1/2]"],
        ],
    ),
    "D4^7": (
        ["2[001]:[0,0,1/2]", "4+[001]:[0,0,3/4]", "2[010]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,1/2]"],
            ["2[100]:[0,0,1/2]", "2[010]:[0,0,0]"],
            ["2[110]:[0,0,1/4]", "2[1-10]:[0,0,3/4]"],
            ["4+[001]:[0,0,3/4]", "4-[001]:[0,0,1/4]"],
        ],
    ),
    "D4^8": (
        ["2[001]:[0,0,1/2]", "4+[001]:[1/2,1/2,3/4]", "2[010]:[1/2,1/2,3/4]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,1/2]"],
            ["2[100]:[1/2,1/2,1/4]", "2[010]:[1/2,1/2,3/4]"],
            ["2[110]:[0,0,0]", "2[1-10]:[0,0,1/2]"],
            ["4+[001]:[1/2,1/2,3/4]", "4-[001]:[1/2,1/2,1/4]"],
        ],
    ),
    "D4^9": (
        ["2[001]:[0,0,0]", "4+[001]:[0,0,0]", "2[010]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            ["2[110]:[0,0,0]", "2[1-10]:[0,0,0]"],
            ["4+[001]:[0,0,0]", "4-[001]:[0,0,0]"],
        ],
    ),
    "D4^10": (
        ["2[001]:[1/2,1/2,1/2]", "4+[001]:[0,1/2,1/4]", "2[010]:[1/2,0,3/4]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,1/2,1/2]"],
            ["2[100]:[0,1/2,1/4]", "2[010]:[1/2,0,3/4]"],
            ["2[110]:[1/2,1/2,1/2]", "2[1-10]:[0,0,0]"],
            ["4+[001]:[0,1/2,1/4]", "4-[001]:[1/2,0,3/4]"],
        ],
    ),
    "C4v^1": (
        ["2[001]:[0,0,0]", "4+[001]:[0,0,0]", "m[010]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["4+[001]:[0,0,0]", "4-[001]:[0,0,0]"],
            ["m[100]:[0,0,0]", "m[010]:[0,0,0]"],
            ["m[110]:[0,0,0]", "m[1-10]:[0,0,0]"],
        ],
    ),
    "C4v^2": (
        ["2[001]:[0,0,0]", "4+[001]:[0,0,0]", "m[010]:[1/2,1/2,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["4+[001]:[0,0,0]", "4-[001]:[0,0,0]"],
            ["m[100]:[1/2,1/2,0]", "m[010]:[1/2,1/2,0]"],
            ["m[110]:[1/2,1/2,0]", "m[1-10]:[1/2,1/2,0]"],
        ],
    ),
    "C4v^3": (
        ["2[001]:[0,0,0]", "4+[001]:[0,0,1/2]", "m[010]:[0,0,1/2]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["4+[001]:[0,0,1/2]", "4-[001]:[0,0,1/2]"],
            ["m[100]:[0,0,1/2]", "m[010]:[0,0,1/2]"],
            ["m[110]:[0,0,0]", "m[1-10]:[0,0,0]"],
        ],
    ),
    "C4v^4": (
        ["2[001]:[0,0,0]", "4+[001]:[1/2,1/2,1/2]", "m[010]:[1/2,1/2,1/2]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["4+[001]:[1/2,1/2,1/2]", "4-[001]:[1/2,1/2,1/2]"],
            ["m[100]:[1/2,1/2,1/2]", "m[010]:[1/2,1/2,1/2]"],
            ["m[110]:[0,0,0]", "m[1-10]:[0,0,0]"],
        ],
    ),
    "C4v^5": (
        ["2[001]:[0,0,0]", "4+[001]:[0,0,0]", "m[010]:[0,0,1/2]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["4+[001]:[0,0,0]", "4-[001]:[0,0,0]"],
            ["m[100]:[0,0,1/2]", "m[010]:[0,0,1/2]"],
            ["m[110]:[0,0,1/2]", "m[1-10]:[0,0,1/2]"],
        ],
    ),
    "C4v^6": (
        ["2[001]:[0,0,0]", "4+[001]:[0,0,0]", "m[010]:[1/2,1/2,1/2]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["4+[001]:[0,0,0]", "4-[001]:[0,0,0]"],
            ["m[100]:[1/2,1/2,1/2]", "m[010]:[1/2,1/2,1/2]"],
            ["m[110]:[1/2,1/2,1/2]", "m[1-10]:[1/2,1/2,1/2]"],
        ],
    ),
    "C4v^7": (
        ["2[001]:[0,0,0]", "4+[001]:[0,0,1/2]", "m[010]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["4+[001]:[0,0,1/2]", "4-[001]:[0,0,1/2]"],
            ["m[100]:[0,0,0]", "m[010]:[0,0,0]"],
            ["m[110]:[0,0,1/2]", "m[1-10]:[0,0,1/2]"],
        ],
    ),
    "C4v^8": (
        ["2[001]:[0,0,0]", "4+[001]:[0,0,1/2]", "m[010]:[1/2,1/2,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["4+[001]:[0,0,1/2]", "4-[001]:[0,0,1/2]"],
            ["m[100]:[1/2,1/2,0]", "m[010]:[1/2,1/2,0]"],
            ["m[110]:[1/2,1/2,1/2]", "m[1-10]:[1/2,1/2,1/2]"],
        ],
    ),
    "C4v^9": (
        ["2[001]:[0,0,0]", "4+[001]:[0,0,0]", "m[010]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["4+[001]:[0,0,0]", "4-[001]:[0,0,0]"],
            ["m[100]:[0,0,0]", "m[010]:[0,0,0]"],
            ["m[110]:[0,0,0]", "m[1-10]:[0,0,0]"],
        ],
    ),
    "C4v^10": (
        ["2[001]:[0,0,0]", "4+[001]:[0,0,0]", "m[010]:[0,0,1/2]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["4+[001]:[0,0,0]", "4-[001]:[0,0,0]"],
            ["m[100]:[0,0,1/2]", "m[010]:[0,0,1/2]"],
            ["m[110]:[0,0,1/2]", "m[1-10]:[0,0,1/2]"],
        ],
    ),
    "C4v^11": (
        ["2[001]:[1/2,1/2,1/2]", "4+[001]:[0,1/2,1/4]", "m[010]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,1/2,1/2]"],
            ["4+[001]:[0,1/2,1/4]", "4-[001]:[1/2,0,3/4]"],
            ["m[100]:[1/2,1/2,1/2]", "m[010]:[0,0,0]"],
            ["m[110]:[0,1/2,1/4]", "m[1-10]:[1/2,0,3/4]"],
        ],
    ),
    "C4v^12": (
        ["2[001]:[1/2,1/2,1/2]", "4+[001]:[0,1/2,1/4]", "m[010]:[0,0,1/2]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,1/2,1/2]"],
            ["4+[001]:[0,1/2,1/4]", "4-[001]:[1/2,0,3/4]"],
            ["m[100]:[1/2,1/2,0]", "m[010]:[0,0,1/2]"],
            ["m[110]:[0,1/2,3/4]", "m[1-10]:[1/2,0,1/4]"],
        ],
    ),
    "D2d^1": (
        ["2[001]:[0,0,0]", "-4+[001]:[0,0,0]", "2[010]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            ["m[110]:[0,0,0]", "m[1-10]:[0,0,0]"],
            ["-4+[001]:[0,0,0]", "-4-[001]:[0,0,0]"],
        ],
    ),
    "D2d^2": (
        ["2[001]:[0,0,0]", "-4+[001]:[0,0,0]", "2[010]:[0,0,1/2]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[0,0,1/2]", "2[010]:[0,0,1/2]"],
            ["m[110]:[0,0,1/2]", "m[1-10]:[0,0,1/2]"],
            ["-4+[001]:[0,0,0]", "-4-[001]:[0,0,0]"],
        ],
    ),
    "D2d^3": (
        ["2[001]:[0,0,0]", "-4+[001]:[0,0,0]", "2[010]:[1/2,1/2,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[1/2,1/2,0]", "2[010]:[1/2,1/2,0]"],
            ["m[110]:[1/2,1/2,0]", "m[1-10]:[1/2,1/2,0]"],
            ["-4+[001]:[0,0,0]", "-4-[001]:[0,0,0]"],
        ],
    ),
    "D2d^4": (
        ["2[001]:[0,0,0]", "-4+[001]:[0,0,0]", "2[010]:[1/2,1/2,1/2]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[1/2,1/2,1/2]", "2[010]:[1/2,1/2,1/2]"],
            ["m[110]:[1/2,1/2,1/2]", "m[1-10]:[1/2,1/2,1/2]"],
            ["-4+[001]:[0,0,0]", "-4-[001]:[0,0,0]"],
        ],
    ),
    "D2d^5": (
        ["2[001]:[0,0,0]", "-4+[001]:[0,0,0]", "m[010]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[110]:[0,0,0]", "2[1-10]:[0,0,0]"],
            ["m[100]:[0,0,0]", "m[010]:[0,0,0]"],
            ["-4+[001]:[0,0,0]", "-4-[001]:[0,0,0]"],
        ],
    ),
    "D2d^6": (
        ["2[001]:[0,0,0]", "-4+[001]:[0,0,0]", "m[010]:[0,0,1/2]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[110]:[0,0,1/2]", "2[1-10]:[0,0,1/2]"],
            ["m[100]:[0,0,1/2]", "m[010]:[0,0,1/2]"],
            ["-4+[001]:[0,0,0]", "-4-[001]:[0,0,0]"],
        ],
    ),
    "D2d^7": (
        ["2[001]:[0,0,0]", "-4+[001]:[0,0,0]", "m[010]:[1/2,1/2,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[110]:[1/2,1/2,0]", "2[1-10]:[1/2,1/2,0]"],
            ["m[100]:[1/2,1/2,0]", "m[010]:[1/2,1/2,0]"],
            ["-4+[001]:[0,0,0]", "-4-[001]:[0,0,0]"],
        ],
    ),
    "D2d^8": (
        ["2[001]:[0,0,0]", "-4+[001]:[0,0,0]", "m[010]:[1/2,1/2,1/2]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[110]:[1/2,1/2,1/2]", "2[1-10]:[1/2,1/2,1/2]"],
            ["m[100]:[1/2,1/2,1/2]", "m[010]:[1/2,1/2,1/2]"],
            ["-4+[001]:[0,0,0]", "-4-[001]:[0,0,0]"],
        ],
    ),
    "D2d^9": (
        ["2[001]:[0,0,0]", "-4+[001]:[0,0,0]", "m[010]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[110]:[0,0,0]", "2[1-10]:[0,0,0]"],
            ["m[100]:[0,0,0]", "m[010]:[0,0,0]"],
            ["-4+[001]:[0,0,0]", "-4-[001]:[0,0,0]"],
        ],
    ),
    "D2d^10": (
        ["2[001]:[0,0,0]", "-4+[001]:[0,0,0]", "m[010]:[0,0,1/2]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[110]:[0,0,1/2]", "2[1-10]:[0,0,1/2]"],
            ["m[100]:[0,0,1/2]", "m[010]:[0,0,1/2]"],
            ["-4+[001]:[0,0,0]", "-4-[001]:[0,0,0]"],
        ],
    ),
    "D2d^11": (
        ["2[001]:[0,0,0]", "-4+[001]:[0,0,0]", "2[010]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            ["m[110]:[0,0,0]", "m[1-10]:[0,0,0]"],
            ["-4+[001]:[0,0,0]", "-4-[001]:[0,0,0]"],
        ],
    ),
    "D2d^12": (
        ["2[001]:[0,0,0]", "-4+[001]:[0,0,0]", "2[010]:[1/2,0,3/4]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[1/2,0,3/4]", "2[010]:[1/2,0,3/4]"],
            ["m[110]:[1/2,0,3/4]", "m[1-10]:[1/2,0,3/4]"],
            ["-4+[001]:[0,0,0]", "-4-[001]:[0,0,0]"],
        ],
    ),
    "D4h^1": (
        ["2[001]:[0,0,0]", "4+[001]:[0,0,0]", "2[010]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            ["2[110]:[0,0,0]", "2[1-10]:[0,0,0]"],
            ["4+[001]:[0,0,0]", "4-[001]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["m[100]:[0,0,0]", "m[010]:[0,0,0]"],
            ["m[110]:[0,0,0]", "m[1-10]:[0,0,0]"],
            ["-4+[001]:[0,0,0]", "-4-[001]:[0,0,0]"],
        ],
    ),
    "D4h^2": (
        ["2[001]:[0,0,0]", "4+[001]:[0,0,0]", "2[010]:[0,0,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[0,0,1/2]", "2[010]:[0,0,1/2]"],
            ["2[110]:[0,0,1/2]", "2[1-10]:[0,0,1/2]"],
            ["4+[001]:[0,0,0]", "4-[001]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["m[100]:[0,0,1/2]", "m[010]:[0,0,1/2]"],
            ["m[110]:[0,0,1/2]", "m[1-10]:[0,0,1/2]"],
            ["-4+[001]:[0,0,0]", "-4-[001]:[0,0,0]"],
        ],
    ),
    "D4h^3": (
        ["2[001]:[1/2,1/2,0]", "4+[001]:[1/2,0,0]", "2[010]:[1/2,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,1/2,0]"],
            ["2[100]:[0,1/2,0]", "2[010]:[1/2,0,0]"],
            ["2[110]:[0,0,0]", "2[1-10]:[1/2,1/2,0]"],
            ["4+[001]:[1/2,0,0]", "4-[001]:[0,1/2,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,1/2,0]"],
            ["m[100]:[0,1/2,0]", "m[010]:[1/2,0,0]"],
            ["m[110]:[0,0,0]", "m[1-10]:[1/2,1/2,0]"],
            ["-4+[001]:[1/2,0,0]", "-4-[001]:[0,1/2,0]"],
        ],
    ),
    "D4h^4": (
        ["2[001]:[1/2,1/2,0]", "4+[001]:[1/2,0,0]", "2[010]:[1/2,0,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,1/2,0]"],
            ["2[100]:[0,1/2,1/2]", "2[010]:[1/2,0,1/2]"],
            ["2[110]:[0,0,1/2]", "2[1-10]:[1/2,1/2,1/2]"],
            ["4+[001]:[1/2,0,0]", "4-[001]:[0,1/2,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,1/2,0]"],
            ["m[100]:[0,1/2,1/2]", "m[010]:[1/2,0,1/2]"],
            ["m[110]:[0,0,1/2]", "m[1-10]:[1/2,1/2,1/2]"],
            ["-4+[001]:[1/2,0,0]", "-4-[001]:[0,1/2,0]"],
        ],
    ),
    "D4h^5": (
        ["2[001]:[0,0,0]", "4+[001]:[0,0,0]", "2[010]:[1/2,1/2,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[1/2,1/2,0]", "2[010]:[1/2,1/2,0]"],
            ["2[110]:[1/2,1/2,0]", "2[1-10]:[1/2,1/2,0]"],
            ["4+[001]:[0,0,0]", "4-[001]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["m[100]:[1/2,1/2,0]", "m[010]:[1/2,1/2,0]"],
            ["m[110]:[1/2,1/2,0]", "m[1-10]:[1/2,1/2,0]"],
            ["-4+[001]:[0,0,0]", "-4-[001]:[0,0,0]"],
        ],
    ),
    "D4h^6": (
        ["2[001]:[0,0,0]", "4+[001]:[0,0,0]", "2[010]:[1/2,1/2,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[1/2,1/2,1/2]", "2[010]:[1/2,1/2,1/2]"],
            ["2[110]:[1/2,1/2,1/2]", "2[1-10]:[1/2,1/2,1/2]"],
            ["4+[001]:[0,0,0]", "4-[001]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["m[100]:[1/2,1/2,1/2]", "m[010]:[1/2,1/2,1/2]"],
            ["m[110]:[1/2,1/2,1/2]", "m[1-10]:[1/2,1/2,1/2]"],
            ["-4+[001]:[0,0,0]", "-4-[001]:[0,0,0]"],
        ],
    ),
    "D4h^7": (
        ["2[001]:[1/2,1/2,0]", "4+[001]:[1/2,0,0]", "2[010]:[0,1/2,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,1/2,0]"],
            ["2[100]:[1/2,0,0]", "2[010]:[0,1/2,0]"],
            ["2[110]:[1/2,1/2,0]", "2[1-10]:[0,0,0]"],
            ["4+[001]:[1/2,0,0]", "4-[001]:[0,1/2,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,1/2,0]"],
            ["m[100]:[1/2,0,0]", "m[010]:[0,1/2,0]"],
            ["m[110]:[1/2,1/2,0]", "m[1-10]:[0,0,0]"],
            ["-4+[001]:[1/2,0,0]", "-4-[001]:[0,1/2,0]"],
        ],
    ),
    "D4h^8": (
        ["2[001]:[1/2,1/2,0]", "4+[001]:[1/2,0,0]", "2[010]:[0,1/2,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,1/2,0]"],
            ["2[100]:[1/2,0,1/2]", "2[010]:[0,1/2,1/2]"],
            ["2[110]:[1/2,1/2,1/2]", "2[1-10]:[0,0,1/2]"],
            ["4+[001]:[1/2,0,0]", "4-[001]:[0,1/2,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,1/2,0]"],
            ["m[100]:[1/2,0,1/2]", "m[010]:[0,1/2,1/2]"],
            ["m[110]:[1/2,1/2,1/2]", "m[1-10]:[0,0,1/2]"],
            ["-4+[001]:[1/2,0,0]", "-4-[001]:[0,1/2,0]"],
        ],
    ),
    "D4h^9": (
        ["2[001]:[0,0,0]", "4+[001]:[0,0,1/2]", "2[010]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            ["2[110]:[0,0,1/2]", "2[1-10]:[0,0,1/2]"],
            ["4+[001]:[0,0,1/2]", "4-[001]:[0,0,1/2]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["m[100]:[0,0,0]", "m[010]:[0,0,0]"],
            ["m[110]:[0,0,1/2]", "m[1-10]:[0,0,1/2]"],
            ["-4+[001]:[0,0,1/2]", "-4-[001]:[0,0,1/2]"],
        ],
    ),
    "D4h^10": (
        ["2[001]:[0,0,0]", "4+[001]:[0,0,1/2]", "2[010]:[0,0,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[0,0,1/2]", "2[010]:[0,0,1/2]"],
            ["2[110]:[0,0,0]", "2[1-10]:[0,0,0]"],
            ["4+[001]:[0,0,1/2]", "4-[001]:[0,0,1/2]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["m[100]:[0,0,1/2]", "m[010]:[0,0,1/2]"],
            ["m[110]:[0,0,0]", "m[1-10]:[0,0,0]"],
            ["-4+[001]:[0,0,1/2]", "-4-[001]:[0,0,1/2]"],
        ],
    ),
    "D4h^11": (
        ["2[001]:[1/2,1/2,0]", "4+[001]:[1/2,0,1/2]", "2[010]:[1/2,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,1/2,0]"],
            ["2[100]:[0,1/2,0]", "2[010]:[1/2,0,0]"],
            ["2[110]:[0,0,1/2]", "2[1-10]:[1/2,1/2,1/2]"],
            ["4+[001]:[1/2,0,1/2]", "4-[001]:[0,1/2,1/2]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,1/2,0]"],
            ["m[100]:[0,1/2,0]", "m[010]:[1/2,0,0]"],
            ["m[110]:[0,0,1/2]", "m[1-10]:[1/2,1/2,1/2]"],
            ["-4+[001]:[1/2,0,1/2]", "-4-[001]:[0,1/2,1/2]"],
        ],
    ),
    "D4h^12": (
        ["2[001]:[1/2,1/2,0]", "4+[001]:[1/2,0,1/2]", "2[010]:[1/2,0,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,1/2,0]"],
            ["2[100]:[0,1/2,1/2]", "2[010]:[1/2,0,1/2]"],
            ["2[110]:[0,0,0]", "2[1-10]:[1/2,1/2,0]"],
            ["4+[001]:[1/2,0,1/2]", "4-[001]:[0,1/2,1/2]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,1/2,0]"],
            ["m[100]:[0,1/2,1/2]", "m[010]:[1/2,0,1/2]"],
            ["m[110]:[0,0,0]", "m[1-10]:[1/2,1/2,0]"],
            ["-4+[001]:[1/2,0,1/2]", "-4-[001]:[0,1/2,1/2]"],
        ],
    ),
    "D4h^13": (
        ["2[001]:[0,0,0]", "4+[001]:[0,0,1/2]", "2[010]:[1/2,1/2,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[1/2,1/2,0]", "2[010]:[1/2,1/2,0]"],
            ["2[110]:[1/2,1/2,1/2]", "2[1-10]:[1/2,1/2,1/2]"],
            ["4+[001]:[0,0,1/2]", "4-[001]:[0,0,1/2]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["m[100]:[1/2,1/2,0]", "m[010]:[1/2,1/2,0]"],
            ["m[110]:[1/2,1/2,1/2]", "m[1-10]:[1/2,1/2,1/2]"],
            ["-4+[001]:[0,0,1/2]", "-4-[001]:[0,0,1/2]"],
        ],
    ),
    "D4h^14": (
        ["2[001]:[0,0,0]", "4+[001]:[1/2,1/2,1/2]", "2[010]:[1/2,1/2,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[1/2,1/2,1/2]", "2[010]:[1/2,1/2,1/2]"],
            ["2[110]:[0,0,0]", "2[1-10]:[0,0,0]"],
            ["4+[001]:[1/2,1/2,1/2]", "4-[001]:[1/2,1/2,1/2]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["m[100]:[1/2,1/2,1/2]", "m[010]:[1/2,1/2,1/2]"],
            ["m[110]:[0,0,0]", "m[1-10]:[0,0,0]"],
            ["-4+[001]:[1/2,1/2,1/2]", "-4-[001]:[1/2,1/2,1/2]"],
        ],
    ),
    "D4h^15": (
        ["2[001]:[1/2,1/2,0]", "4+[001]:[1/2,0,1/2]", "2[010]:[0,1/2,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,1/2,0]"],
            ["2[100]:[1/2,0,0]", "2[010]:[0,1/2,0]"],
            ["2[110]:[1/2,1/2,1/2]", "2[1-10]:[0,0,1/2]"],
            ["4+[001]:[1/2,0,1/2]", "4-[001]:[0,1/2,1/2]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,1/2,0]"],
            ["m[100]:[1/2,0,0]", "m[010]:[0,1/2,0]"],
            ["m[110]:[1/2,1/2,1/2]", "m[1-10]:[0,0,1/2]"],
            ["-4+[001]:[1/2,0,1/2]", "-4-[001]:[0,1/2,1/2]"],
        ],
    ),
    "D4h^16": (
        ["2[001]:[1/2,1/2,0]", "4+[001]:[1/2,0,1/2]", "2[010]:[0,1/2,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,1/2,0]"],
            ["2[100]:[1/2,0,1/2]", "2[010]:[0,1/2,1/2]"],
            ["2[110]:[1/2,1/2,0]", "2[1-10]:[0,0,0]"],
            ["4+[001]:[1/2,0,1/2]", "4-[001]:[0,1/2,1/2]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,1/2,0]"],
            ["m[100]:[1/2,0,1/2]", "m[010]:[0,1/2,1/2]"],
            ["m[110]:[1/2,1/2,0]", "m[1-10]:[0,0,0]"],
            ["-4+[001]:[1/2,0,1/2]", "-4-[001]:[0,1/2,1/2]"],
        ],
    ),
    "D4h^17": (
        ["2[001]:[0,0,0]", "4+[001]:[0,0,0]", "2[010]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            ["2[110]:[0,0,0]", "2[1-10]:[0,0,0]"],
            ["4+[001]:[0,0,0]", "4-[001]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["m[100]:[0,0,0]", "m[010]:[0,0,0]"],
            ["m[110]:[0,0,0]", "m[1-10]:[0,0,0]"],
            ["-4+[001]:[0,0,0]", "-4-[001]:[0,0,0]"],
        ],
    ),
    "D4h^18": (
        ["2[001]:[0,0,0]", "4+[001]:[0,0,0]", "2[010]:[0,0,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[0,0,1/2]", "2[010]:[0,0,1/2]"],
            ["2[110]:[0,0,1/2]", "2[1-10]:[0,0,1/2]"],
            ["4+[001]:[0,0,0]", "4-[001]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["m[100]:[0,0,1/2]", "m[010]:[0,0,1/2]"],
            ["m[110]:[0,0,1/2]", "m[1-10]:[0,0,1/2]"],
            ["-4+[001]:[0,0,0]", "-4-[001]:[0,0,0]"],
        ],
    ),
    "D4h^19": (
        ["2[001]:[1/2,0,1/2]", "4+[001]:[1/4,3/4,1/4]", "2[010]:[1/2,0,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,0,1/2]"],
            ["2[100]:[0,0,0]", "2[010]:[1/2,0,1/2]"],
            ["2[110]:[1/4,3/4,1/4]", "2[1-10]:[1/4,1/4,3/4]"],
            ["4+[001]:[1/4,3/4,1/4]", "4-[001]:[1/4,1/4,3/4]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,0,1/2]"],
            ["m[100]:[0,0,0]", "m[010]:[1/2,0,1/2]"],
            ["m[110]:[3/4,1/4,3/4]", "m[1-10]:[3/4,3/4,1/4]"],
            ["-4+[001]:[3/4,1/4,3/4]", "-4-[001]:[3/4,3/4,1/4]"],
        ],
    ),
    "D4h^20": (
        ["2[001]:[1/2,0,1/2]", "4+[001]:[1/4,3/4,1/4]", "2[010]:[1/2,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,0,1/2]"],
            ["2[100]:[0,0,1/2]", "2[010]:[1/2,0,0]"],
            ["2[110]:[1/4,3/4,3/4]", "2[1-10]:[1/4,1/4,1/4]"],
            ["4+[001]:[1/4,3/4,1/4]", "4-[001]:[1/4,1/4,3/4]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,0,1/2]"],
            ["m[100]:[0,0,1/2]", "m[010]:[1/2,0,0]"],
            ["m[110]:[3/4,1/4,1/4]", "m[1-10]:[3/4,3/4,3/4]"],
            ["-4+[001]:[3/4,1/4,3/4]", "-4-[001]:[3/4,3/4,1/4]"],
        ],
    ),
    "C3^1": (["3+[001]:[0,0,0]"], [["1:[0,0,0]"], ["3+[001]:[0,0,0]"], ["3-[001]:[0,0,0]"]]),
    "C3^2": (["3+[001]:[0,0,1/3]"], [["1:[0,0,0]"], ["3+[001]:[0,0,1/3]"], ["3-[001]:[0,0,2/3]"]]),
    "C3^3": (["3+[001]:[0,0,2/3]"], [["1:[0,0,0]"], ["3+[001]:[0,0,2/3]"], ["3-[001]:[0,0,1/3]"]]),
    "C3^4": (["3+[001]:[0,0,0]"], [["1:[0,0,0]"], ["3+[001]:[0,0,0]"], ["3-[001]:[0,0,0]"]]),
    "C3i^1": (
        ["3+[001]:[0,0,0]", "-1:[0,0,0]"],
        [["1:[0,0,0]"], ["3+[001]:[0,0,0]"], ["3-[001]:[0,0,0]"], ["-1:[0,0,0]"], ["-3+[001]:[0,0,0]"], ["-3-[001]:[0,0,0]"]],
    ),
    "C3i^2": (
        ["3+[001]:[0,0,0]", "-1:[0,0,0]"],
        [["1:[0,0,0]"], ["3+[001]:[0,0,0]"], ["3-[001]:[0,0,0]"], ["-1:[0,0,0]"], ["-3+[001]:[0,0,0]"], ["-3-[001]:[0,0,0]"]],
    ),
    "D3^1": (
        ["3+[001]:[0,0,0]", "2[1-10]:[0,0,0]"],
        [["1:[0,0,0]"], ["2[120]:[0,0,0]", "2[210]:[0,0,0]", "2[1-10]:[0,0,0]"], ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"]],
    ),
    "D3^2": (
        ["3+[001]:[0,0,0]", "2[110]:[0,0,0]"],
        [["1:[0,0,0]"], ["2[100]:[0,0,0]", "2[010]:[0,0,0]", "2[110]:[0,0,0]"], ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"]],
    ),
    "D3^3": (
        ["3+[001]:[0,0,1/3]", "2[1-10]:[0,0,2/3]"],
        [["1:[0,0,0]"], ["2[120]:[0,0,1/3]", "2[210]:[0,0,0]", "2[1-10]:[0,0,2/3]"], ["3+[001]:[0,0,1/3]", "3-[001]:[0,0,2/3]"]],
    ),
    "D3^4": (
        ["3+[001]:[0,0,1/3]", "2[110]:[0,0,0]"],
        [["1:[0,0,0]"], ["2[100]:[0,0,2/3]", "2[010]:[0,0,1/3]", "2[110]:[0,0,0]"], ["3+[001]:[0,0,1/3]", "3-[001]:[0,0,2/3]"]],
    ),
    "D3^5": (
        ["3+[001]:[0,0,2/3]", "2[1-10]:[0,0,1/3]"],
        [["1:[0,0,0]"], ["2[120]:[0,0,2/3]", "2[210]:[0,0,0]", "2[1-10]:[0,0,1/3]"], ["3+[001]:[0,0,2/3]", "3-[001]:[0,0,1/3]"]],
    ),
    "D3^6": (
        ["3+[001]:[0,0,2/3]", "2[110]:[0,0,0]"],
        [["1:[0,0,0]"], ["2[100]:[0,0,1/3]", "2[010]:[0,0,2/3]", "2[110]:[0,0,0]"], ["3+[001]:[0,0,2/3]", "3-[001]:[0,0,1/3]"]],
    ),
    "D3^7": (
        ["3+[001]:[0,0,0]", "2[110]:[0,0,0]"],
        [["1:[0,0,0]"], ["2[100]:[0,0,0]", "2[010]:[0,0,0]", "2[110]:[0,0,0]"], ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"]],
    ),
    "C3v^1": (
        ["3+[001]:[0,0,0]", "m[110]:[0,0,0]"],
        [["1:[0,0,0]"], ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"], ["m[100]:[0,0,0]", "m[010]:[0,0,0]", "m[110]:[0,0,0]"]],
    ),
    "C3v^2": (
        ["3+[001]:[0,0,0]", "m[1-10]:[0,0,0]"],
        [["1:[0,0,0]"], ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"], ["m[120]:[0,0,0]", "m[210]:[0,0,0]", "m[1-10]:[0,0,0]"]],
    ),
    "C3v^3": (
        ["3+[001]:[0,0,0]", "m[110]:[0,0,1/2]"],
        [["1:[0,0,0]"], ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"], ["m[100]:[0,0,1/2]", "m[010]:[0,0,1/2]", "m[110]:[0,0,1/2]"]],
    ),
    "C3v^4": (
        ["3+[001]:[0,0,0]", "m[1-10]:[0,0,1/2]"],
        [["1:[0,0,0]"], ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"], ["m[120]:[0,0,1/2]", "m[210]:[0,0,1/2]", "m[1-10]:[0,0,1/2]"]],
    ),
    "C3v^5": (
        ["3+[001]:[0,0,0]", "m[110]:[0,0,0]"],
        [["1:[0,0,0]"], ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"], ["m[100]:[0,0,0]", "m[010]:[0,0,0]", "m[110]:[0,0,0]"]],
    ),
    "C3v^6": (
        ["3+[001]:[0,0,0]", "m[110]:[0,0,1/2]"],
        [["1:[0,0,0]"], ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"], ["m[100]:[0,0,1/2]", "m[010]:[0,0,1/2]", "m[110]:[0,0,1/2]"]],
    ),
    "D3d^1": (
        ["3+[001]:[0,0,0]", "2[1-10]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[120]:[0,0,0]", "2[210]:[0,0,0]", "2[1-10]:[0,0,0]"],
            ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[120]:[0,0,0]", "m[210]:[0,0,0]", "m[1-10]:[0,0,0]"],
            ["-3+[001]:[0,0,0]", "-3-[001]:[0,0,0]"],
        ],
    ),
    "D3d^2": (
        ["3+[001]:[0,0,0]", "2[1-10]:[0,0,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[120]:[0,0,1/2]", "2[210]:[0,0,1/2]", "2[1-10]:[0,0,1/2]"],
            ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[120]:[0,0,1/2]", "m[210]:[0,0,1/2]", "m[1-10]:[0,0,1/2]"],
            ["-3+[001]:[0,0,0]", "-3-[001]:[0,0,0]"],
        ],
    ),
    "D3d^3": (
        ["3+[001]:[0,0,0]", "2[110]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[100]:[0,0,0]", "2[010]:[0,0,0]", "2[110]:[0,0,0]"],
            ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[100]:[0,0,0]", "m[010]:[0,0,0]", "m[110]:[0,0,0]"],
            ["-3+[001]:[0,0,0]", "-3-[001]:[0,0,0]"],
        ],
    ),
    "D3d^4": (
        ["3+[001]:[0,0,0]", "2[110]:[0,0,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[100]:[0,0,1/2]", "2[010]:[0,0,1/2]", "2[110]:[0,0,1/2]"],
            ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[100]:[0,0,1/2]", "m[010]:[0,0,1/2]", "m[110]:[0,0,1/2]"],
            ["-3+[001]:[0,0,0]", "-3-[001]:[0,0,0]"],
        ],
    ),
    "D3d^5": (
        ["3+[001]:[0,0,0]", "2[110]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[100]:[0,0,0]", "2[010]:[0,0,0]", "2[110]:[0,0,0]"],
            ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[100]:[0,0,0]", "m[010]:[0,0,0]", "m[110]:[0,0,0]"],
            ["-3+[001]:[0,0,0]", "-3-[001]:[0,0,0]"],
        ],
    ),
    "D3d^6": (
        ["3+[001]:[0,0,0]", "2[110]:[0,0,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[100]:[0,0,1/2]", "2[010]:[0,0,1/2]", "2[110]:[0,0,1/2]"],
            ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[100]:[0,0,1/2]", "m[010]:[0,0,1/2]", "m[110]:[0,0,1/2]"],
            ["-3+[001]:[0,0,0]", "-3-[001]:[0,0,0]"],
        ],
    ),
    "C6^1": (
        ["3+[001]:[0,0,0]", "2[001]:[0,0,0]"],
        [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["3+[001]:[0,0,0]"], ["3-[001]:[0,0,0]"], ["6+[001]:[0,0,0]"], ["6-[001]:[0,0,0]"]],
    ),
    "C6^2": (
        ["3+[001]:[0,0,1/3]", "2[001]:[0,0,1/2]"],
        [["1:[0,0,0]"], ["2[001]:[0,0,1/2]"], ["3+[001]:[0,0,1/3]"], ["3-[001]:[0,0,2/3]"], ["6+[001]:[0,0,1/6]"], ["6-[001]:[0,0,5/6]"]],
    ),
    "C6^3": (
        ["3+[001]:[0,0,2/3]", "2[001]:[0,0,1/2]"],
        [["1:[0,0,0]"], ["2[001]:[0,0,1/2]"], ["3+[001]:[0,0,2/3]"], ["3-[001]:[0,0,1/3]"], ["6+[001]:[0,0,5/6]"], ["6-[001]:[0,0,1/6]"]],
    ),
    "C6^4": (
        ["3+[001]:[0,0,2/3]", "2[001]:[0,0,0]"],
        [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["3+[001]:[0,0,2/3]"], ["3-[001]:[0,0,1/3]"], ["6+[001]:[0,0,1/3]"], ["6-[001]:[0,0,2/3]"]],
    ),
    "C6^5": (
        ["3+[001]:[0,0,1/3]", "2[001]:[0,0,0]"],
        [["1:[0,0,0]"], ["2[001]:[0,0,0]"], ["3+[001]:[0,0,1/3]"], ["3-[001]:[0,0,2/3]"], ["6+[001]:[0,0,2/3]"], ["6-[001]:[0,0,1/3]"]],
    ),
    "C6^6": (
        ["3+[001]:[0,0,0]", "2[001]:[0,0,1/2]"],
        [["1:[0,0,0]"], ["2[001]:[0,0,1/2]"], ["3+[001]:[0,0,0]"], ["3-[001]:[0,0,0]"], ["6+[001]:[0,0,1/2]"], ["6-[001]:[0,0,1/2]"]],
    ),
    "C3h^1": (
        ["3+[001]:[0,0,0]", "m[001]:[0,0,0]"],
        [["1:[0,0,0]"], ["3+[001]:[0,0,0]"], ["3-[001]:[0,0,0]"], ["m[001]:[0,0,0]"], ["-6+[001]:[0,0,0]"], ["-6-[001]:[0,0,0]"]],
    ),
    "C6h^1": (
        ["3+[001]:[0,0,0]", "2[001]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["3+[001]:[0,0,0]"],
            ["3-[001]:[0,0,0]"],
            ["6+[001]:[0,0,0]"],
            ["6-[001]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["-3+[001]:[0,0,0]"],
            ["-3-[001]:[0,0,0]"],
            ["-6+[001]:[0,0,0]"],
            ["-6-[001]:[0,0,0]"],
        ],
    ),
    "C6h^2": (
        ["3+[001]:[0,0,0]", "2[001]:[0,0,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,1/2]"],
            ["3+[001]:[0,0,0]"],
            ["3-[001]:[0,0,0]"],
            ["6+[001]:[0,0,1/2]"],
            ["6-[001]:[0,0,1/2]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,1/2]"],
            ["-3+[001]:[0,0,0]"],
            ["-3-[001]:[0,0,0]"],
            ["-6+[001]:[0,0,1/2]"],
            ["-6-[001]:[0,0,1/2]"],
        ],
    ),
    "D6^1": (
        ["3+[001]:[0,0,0]", "2[001]:[0,0,0]", "2[110]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[0,0,0]", "2[010]:[0,0,0]", "2[110]:[0,0,0]"],
            ["2[120]:[0,0,0]", "2[210]:[0,0,0]", "2[1-10]:[0,0,0]"],
            ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"],
            ["6+[001]:[0,0,0]", "6-[001]:[0,0,0]"],
        ],
    ),
    "D6^2": (
        ["3+[001]:[0,0,1/3]", "2[001]:[0,0,1/2]", "2[110]:[0,0,1/3]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,1/2]"],
            ["2[100]:[0,0,0]", "2[010]:[0,0,2/3]", "2[110]:[0,0,1/3]"],
            ["2[120]:[0,0,1/2]", "2[210]:[0,0,1/6]", "2[1-10]:[0,0,5/6]"],
            ["3+[001]:[0,0,1/3]", "3-[001]:[0,0,2/3]"],
            ["6+[001]:[0,0,1/6]", "6-[001]:[0,0,5/6]"],
        ],
    ),
    "D6^3": (
        ["3+[001]:[0,0,2/3]", "2[001]:[0,0,1/2]", "2[110]:[0,0,2/3]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,1/2]"],
            ["2[100]:[0,0,0]", "2[010]:[0,0,1/3]", "2[110]:[0,0,2/3]"],
            ["2[120]:[0,0,1/2]", "2[210]:[0,0,5/6]", "2[1-10]:[0,0,1/6]"],
            ["3+[001]:[0,0,2/3]", "3-[001]:[0,0,1/3]"],
            ["6+[001]:[0,0,5/6]", "6-[001]:[0,0,1/6]"],
        ],
    ),
    "D6^4": (
        ["3+[001]:[0,0,2/3]", "2[001]:[0,0,0]", "2[110]:[0,0,2/3]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[0,0,0]", "2[010]:[0,0,1/3]", "2[110]:[0,0,2/3]"],
            ["2[120]:[0,0,0]", "2[210]:[0,0,1/3]", "2[1-10]:[0,0,2/3]"],
            ["3+[001]:[0,0,2/3]", "3-[001]:[0,0,1/3]"],
            ["6+[001]:[0,0,1/3]", "6-[001]:[0,0,2/3]"],
        ],
    ),
    "D6^5": (
        ["3+[001]:[0,0,1/3]", "2[001]:[0,0,0]", "2[110]:[0,0,1/3]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[0,0,0]", "2[010]:[0,0,2/3]", "2[110]:[0,0,1/3]"],
            ["2[120]:[0,0,0]", "2[210]:[0,0,2/3]", "2[1-10]:[0,0,1/3]"],
            ["3+[001]:[0,0,1/3]", "3-[001]:[0,0,2/3]"],
            ["6+[001]:[0,0,2/3]", "6-[001]:[0,0,1/3]"],
        ],
    ),
    "D6^6": (
        ["3+[001]:[0,0,0]", "2[001]:[0,0,1/2]", "2[110]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,1/2]"],
            ["2[100]:[0,0,0]", "2[010]:[0,0,0]", "2[110]:[0,0,0]"],
            ["2[120]:[0,0,1/2]", "2[210]:[0,0,1/2]", "2[1-10]:[0,0,1/2]"],
            ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"],
            ["6+[001]:[0,0,1/2]", "6-[001]:[0,0,1/2]"],
        ],
    ),
    "C6v^1": (
        ["3+[001]:[0,0,0]", "2[001]:[0,0,0]", "m[110]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"],
            ["6+[001]:[0,0,0]", "6-[001]:[0,0,0]"],
            ["m[100]:[0,0,0]", "m[010]:[0,0,0]", "m[110]:[0,0,0]"],
            ["m[120]:[0,0,0]", "m[210]:[0,0,0]", "m[1-10]:[0,0,0]"],
        ],
    ),
    "C6v^2": (
        ["3+[001]:[0,0,0]", "2[001]:[0,0,0]", "m[110]:[0,0,1/2]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"],
            ["6+[001]:[0,0,0]", "6-[001]:[0,0,0]"],
            ["m[100]:[0,0,1/2]", "m[010]:[0,0,1/2]", "m[110]:[0,0,1/2]"],
            ["m[120]:[0,0,1/2]", "m[210]:[0,0,1/2]", "m[1-10]:[0,0,1/2]"],
        ],
    ),
    "C6v^3": (
        ["3+[001]:[0,0,0]", "2[001]:[0,0,1/2]", "m[110]:[0,0,1/2]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,1/2]"],
            ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"],
            ["6+[001]:[0,0,1/2]", "6-[001]:[0,0,1/2]"],
            ["m[100]:[0,0,1/2]", "m[010]:[0,0,1/2]", "m[110]:[0,0,1/2]"],
            ["m[120]:[0,0,0]", "m[210]:[0,0,0]", "m[1-10]:[0,0,0]"],
        ],
    ),
    "C6v^4": (
        ["3+[001]:[0,0,0]", "2[001]:[0,0,1/2]", "m[110]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,1/2]"],
            ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"],
            ["6+[001]:[0,0,1/2]", "6-[001]:[0,0,1/2]"],
            ["m[100]:[0,0,0]", "m[010]:[0,0,0]", "m[110]:[0,0,0]"],
            ["m[120]:[0,0,1/2]", "m[210]:[0,0,1/2]", "m[1-10]:[0,0,1/2]"],
        ],
    ),
    "D3h^1": (
        ["3+[001]:[0,0,0]", "m[001]:[0,0,0]", "m[110]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[120]:[0,0,0]", "2[210]:[0,0,0]", "2[1-10]:[0,0,0]"],
            ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"],
            ["m[100]:[0,0,0]", "m[010]:[0,0,0]", "m[110]:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["-6+[001]:[0,0,0]", "-6-[001]:[0,0,0]"],
        ],
    ),
    "D3h^2": (
        ["3+[001]:[0,0,0]", "m[001]:[0,0,1/2]", "m[110]:[0,0,1/2]"],
        [
            ["1:[0,0,0]"],
            ["2[120]:[0,0,0]", "2[210]:[0,0,0]", "2[1-10]:[0,0,0]"],
            ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"],
            ["m[100]:[0,0,1/2]", "m[010]:[0,0,1/2]", "m[110]:[0,0,1/2]"],
            ["m[001]:[0,0,1/2]"],
            ["-6+[001]:[0,0,1/2]", "-6-[001]:[0,0,1/2]"],
        ],
    ),
    "D3h^3": (
        ["3+[001]:[0,0,0]", "m[001]:[0,0,0]", "2[110]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[100]:[0,0,0]", "2[010]:[0,0,0]", "2[110]:[0,0,0]"],
            ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["m[120]:[0,0,0]", "m[210]:[0,0,0]", "m[1-10]:[0,0,0]"],
            ["-6+[001]:[0,0,0]", "-6-[001]:[0,0,0]"],
        ],
    ),
    "D3h^4": (
        ["3+[001]:[0,0,0]", "m[001]:[0,0,1/2]", "2[110]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[100]:[0,0,0]", "2[010]:[0,0,0]", "2[110]:[0,0,0]"],
            ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"],
            ["m[001]:[0,0,1/2]"],
            ["m[120]:[0,0,1/2]", "m[210]:[0,0,1/2]", "m[1-10]:[0,0,1/2]"],
            ["-6+[001]:[0,0,1/2]", "-6-[001]:[0,0,1/2]"],
        ],
    ),
    "D6h^1": (
        ["3+[001]:[0,0,0]", "2[001]:[0,0,0]", "2[110]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[0,0,0]", "2[010]:[0,0,0]", "2[110]:[0,0,0]"],
            ["2[120]:[0,0,0]", "2[210]:[0,0,0]", "2[1-10]:[0,0,0]"],
            ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"],
            ["6+[001]:[0,0,0]", "6-[001]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[100]:[0,0,0]", "m[010]:[0,0,0]", "m[110]:[0,0,0]"],
            ["m[001]:[0,0,0]"],
            ["m[120]:[0,0,0]", "m[210]:[0,0,0]", "m[1-10]:[0,0,0]"],
            ["-3+[001]:[0,0,0]", "-3-[001]:[0,0,0]"],
            ["-6+[001]:[0,0,0]", "-6-[001]:[0,0,0]"],
        ],
    ),
    "D6h^2": (
        ["3+[001]:[0,0,0]", "2[001]:[0,0,0]", "2[110]:[0,0,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]"],
            ["2[100]:[0,0,1/2]", "2[010]:[0,0,1/2]", "2[110]:[0,0,1/2]"],
            ["2[120]:[0,0,1/2]", "2[210]:[0,0,1/2]", "2[1-10]:[0,0,1/2]"],
            ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"],
            ["6+[001]:[0,0,0]", "6-[001]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[100]:[0,0,1/2]", "m[010]:[0,0,1/2]", "m[110]:[0,0,1/2]"],
            ["m[001]:[0,0,0]"],
            ["m[120]:[0,0,1/2]", "m[210]:[0,0,1/2]", "m[1-10]:[0,0,1/2]"],
            ["-3+[001]:[0,0,0]", "-3-[001]:[0,0,0]"],
            ["-6+[001]:[0,0,0]", "-6-[001]:[0,0,0]"],
        ],
    ),
    "D6h^3": (
        ["3+[001]:[0,0,0]", "2[001]:[0,0,1/2]", "2[110]:[0,0,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,1/2]"],
            ["2[100]:[0,0,1/2]", "2[010]:[0,0,1/2]", "2[110]:[0,0,1/2]"],
            ["2[120]:[0,0,0]", "2[210]:[0,0,0]", "2[1-10]:[0,0,0]"],
            ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"],
            ["6+[001]:[0,0,1/2]", "6-[001]:[0,0,1/2]"],
            ["-1:[0,0,0]"],
            ["m[100]:[0,0,1/2]", "m[010]:[0,0,1/2]", "m[110]:[0,0,1/2]"],
            ["m[001]:[0,0,1/2]"],
            ["m[120]:[0,0,0]", "m[210]:[0,0,0]", "m[1-10]:[0,0,0]"],
            ["-3+[001]:[0,0,0]", "-3-[001]:[0,0,0]"],
            ["-6+[001]:[0,0,1/2]", "-6-[001]:[0,0,1/2]"],
        ],
    ),
    "D6h^4": (
        ["3+[001]:[0,0,0]", "2[001]:[0,0,1/2]", "2[110]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,1/2]"],
            ["2[100]:[0,0,0]", "2[010]:[0,0,0]", "2[110]:[0,0,0]"],
            ["2[120]:[0,0,1/2]", "2[210]:[0,0,1/2]", "2[1-10]:[0,0,1/2]"],
            ["3+[001]:[0,0,0]", "3-[001]:[0,0,0]"],
            ["6+[001]:[0,0,1/2]", "6-[001]:[0,0,1/2]"],
            ["-1:[0,0,0]"],
            ["m[100]:[0,0,0]", "m[010]:[0,0,0]", "m[110]:[0,0,0]"],
            ["m[001]:[0,0,1/2]"],
            ["m[120]:[0,0,1/2]", "m[210]:[0,0,1/2]", "m[1-10]:[0,0,1/2]"],
            ["-3+[001]:[0,0,0]", "-3-[001]:[0,0,0]"],
            ["-6+[001]:[0,0,1/2]", "-6-[001]:[0,0,1/2]"],
        ],
    ),
    "T^1": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,0]", "3+[111]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]", "2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            ["3+[111]:[0,0,0]", "3+[1-1-1]:[0,0,0]", "3+[-11-1]:[0,0,0]", "3+[-1-11]:[0,0,0]"],
            ["3-[111]:[0,0,0]", "3-[1-1-1]:[0,0,0]", "3-[-11-1]:[0,0,0]", "3-[-1-11]:[0,0,0]"],
        ],
    ),
    "T^2": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,0]", "3+[111]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]", "2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            ["3+[111]:[0,0,0]", "3+[1-1-1]:[0,0,0]", "3+[-11-1]:[0,0,0]", "3+[-1-11]:[0,0,0]"],
            ["3-[111]:[0,0,0]", "3-[1-1-1]:[0,0,0]", "3-[-11-1]:[0,0,0]", "3-[-1-11]:[0,0,0]"],
        ],
    ),
    "T^3": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,0]", "3+[111]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]", "2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            ["3+[111]:[0,0,0]", "3+[1-1-1]:[0,0,0]", "3+[-11-1]:[0,0,0]", "3+[-1-11]:[0,0,0]"],
            ["3-[111]:[0,0,0]", "3-[1-1-1]:[0,0,0]", "3-[-11-1]:[0,0,0]", "3-[-1-11]:[0,0,0]"],
        ],
    ),
    "T^4": (
        ["2[001]:[1/2,0,1/2]", "2[010]:[0,1/2,1/2]", "3+[111]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,0,1/2]", "2[100]:[1/2,1/2,0]", "2[010]:[0,1/2,1/2]"],
            ["3+[111]:[0,0,0]", "3+[1-1-1]:[1/2,0,1/2]", "3+[-11-1]:[1/2,1/2,0]", "3+[-1-11]:[0,1/2,1/2]"],
            ["3-[111]:[0,0,0]", "3-[1-1-1]:[0,1/2,1/2]", "3-[-11-1]:[1/2,0,1/2]", "3-[-1-11]:[1/2,1/2,0]"],
        ],
    ),
    "T^5": (
        ["2[001]:[1/2,0,1/2]", "2[010]:[0,1/2,1/2]", "3+[111]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,0,1/2]", "2[100]:[1/2,1/2,0]", "2[010]:[0,1/2,1/2]"],
            ["3+[111]:[0,0,0]", "3+[1-1-1]:[1/2,0,1/2]", "3+[-11-1]:[1/2,1/2,0]", "3+[-1-11]:[0,1/2,1/2]"],
            ["3-[111]:[0,0,0]", "3-[1-1-1]:[0,1/2,1/2]", "3-[-11-1]:[1/2,0,1/2]", "3-[-1-11]:[1/2,1/2,0]"],
        ],
    ),
    "Th^1": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,0]", "3+[111]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]", "2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            ["3+[111]:[0,0,0]", "3+[1-1-1]:[0,0,0]", "3+[-11-1]:[0,0,0]", "3+[-1-11]:[0,0,0]"],
            ["3-[111]:[0,0,0]", "3-[1-1-1]:[0,0,0]", "3-[-11-1]:[0,0,0]", "3-[-1-11]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]", "m[100]:[0,0,0]", "m[010]:[0,0,0]"],
            ["-3+[111]:[0,0,0]", "-3+[1-1-1]:[0,0,0]", "-3+[-11-1]:[0,0,0]", "-3+[-1-11]:[0,0,0]"],
            ["-3-[111]:[0,0,0]", "-3-[1-1-1]:[0,0,0]", "-3-[-11-1]:[0,0,0]", "-3-[-1-11]:[0,0,0]"],
        ],
    ),
    "Th^2": (
        ["2[001]:[1/2,1/2,0]", "2[010]:[1/2,0,1/2]", "3+[111]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,1/2,0]", "2[100]:[0,1/2,1/2]", "2[010]:[1/2,0,1/2]"],
            ["3+[111]:[0,0,0]", "3+[1-1-1]:[1/2,1/2,0]", "3+[-11-1]:[0,1/2,1/2]", "3+[-1-11]:[1/2,0,1/2]"],
            ["3-[111]:[0,0,0]", "3-[1-1-1]:[1/2,0,1/2]", "3-[-11-1]:[1/2,1/2,0]", "3-[-1-11]:[0,1/2,1/2]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,1/2,0]", "m[100]:[0,1/2,1/2]", "m[010]:[1/2,0,1/2]"],
            ["-3+[111]:[0,0,0]", "-3+[1-1-1]:[1/2,1/2,0]", "-3+[-11-1]:[0,1/2,1/2]", "-3+[-1-11]:[1/2,0,1/2]"],
            ["-3-[111]:[0,0,0]", "-3-[1-1-1]:[1/2,0,1/2]", "-3-[-11-1]:[1/2,1/2,0]", "-3-[-1-11]:[0,1/2,1/2]"],
        ],
    ),
    "Th^3": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,0]", "3+[111]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]", "2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            ["3+[111]:[0,0,0]", "3+[1-1-1]:[0,0,0]", "3+[-11-1]:[0,0,0]", "3+[-1-11]:[0,0,0]"],
            ["3-[111]:[0,0,0]", "3-[1-1-1]:[0,0,0]", "3-[-11-1]:[0,0,0]", "3-[-1-11]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]", "m[100]:[0,0,0]", "m[010]:[0,0,0]"],
            ["-3+[111]:[0,0,0]", "-3+[1-1-1]:[0,0,0]", "-3+[-11-1]:[0,0,0]", "-3+[-1-11]:[0,0,0]"],
            ["-3-[111]:[0,0,0]", "-3-[1-1-1]:[0,0,0]", "-3-[-11-1]:[0,0,0]", "-3-[-1-11]:[0,0,0]"],
        ],
    ),
    "Th^4": (
        ["2[001]:[3/4,3/4,0]", "2[010]:[3/4,0,3/4]", "3+[111]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[3/4,3/4,0]", "2[100]:[0,3/4,3/4]", "2[010]:[3/4,0,3/4]"],
            ["3+[111]:[0,0,0]", "3+[1-1-1]:[3/4,3/4,0]", "3+[-11-1]:[0,3/4,3/4]", "3+[-1-11]:[3/4,0,3/4]"],
            ["3-[111]:[0,0,0]", "3-[1-1-1]:[3/4,0,3/4]", "3-[-11-1]:[3/4,3/4,0]", "3-[-1-11]:[0,3/4,3/4]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/4,1/4,0]", "m[100]:[0,1/4,1/4]", "m[010]:[1/4,0,1/4]"],
            ["-3+[111]:[0,0,0]", "-3+[1-1-1]:[1/4,1/4,0]", "-3+[-11-1]:[0,1/4,1/4]", "-3+[-1-11]:[1/4,0,1/4]"],
            ["-3-[111]:[0,0,0]", "-3-[1-1-1]:[1/4,0,1/4]", "-3-[-11-1]:[1/4,1/4,0]", "-3-[-1-11]:[0,1/4,1/4]"],
        ],
    ),
    "Th^5": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,0]", "3+[111]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]", "2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            ["3+[111]:[0,0,0]", "3+[1-1-1]:[0,0,0]", "3+[-11-1]:[0,0,0]", "3+[-1-11]:[0,0,0]"],
            ["3-[111]:[0,0,0]", "3-[1-1-1]:[0,0,0]", "3-[-11-1]:[0,0,0]", "3-[-1-11]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]", "m[100]:[0,0,0]", "m[010]:[0,0,0]"],
            ["-3+[111]:[0,0,0]", "-3+[1-1-1]:[0,0,0]", "-3+[-11-1]:[0,0,0]", "-3+[-1-11]:[0,0,0]"],
            ["-3-[111]:[0,0,0]", "-3-[1-1-1]:[0,0,0]", "-3-[-11-1]:[0,0,0]", "-3-[-1-11]:[0,0,0]"],
        ],
    ),
    "Th^6": (
        ["2[001]:[1/2,0,1/2]", "2[010]:[0,1/2,1/2]", "3+[111]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,0,1/2]", "2[100]:[1/2,1/2,0]", "2[010]:[0,1/2,1/2]"],
            ["3+[111]:[0,0,0]", "3+[1-1-1]:[1/2,0,1/2]", "3+[-11-1]:[1/2,1/2,0]", "3+[-1-11]:[0,1/2,1/2]"],
            ["3-[111]:[0,0,0]", "3-[1-1-1]:[0,1/2,1/2]", "3-[-11-1]:[1/2,0,1/2]", "3-[-1-11]:[1/2,1/2,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,0,1/2]", "m[100]:[1/2,1/2,0]", "m[010]:[0,1/2,1/2]"],
            ["-3+[111]:[0,0,0]", "-3+[1-1-1]:[1/2,0,1/2]", "-3+[-11-1]:[1/2,1/2,0]", "-3+[-1-11]:[0,1/2,1/2]"],
            ["-3-[111]:[0,0,0]", "-3-[1-1-1]:[0,1/2,1/2]", "-3-[-11-1]:[1/2,0,1/2]", "-3-[-1-11]:[1/2,1/2,0]"],
        ],
    ),
    "Th^7": (
        ["2[001]:[1/2,0,1/2]", "2[010]:[0,1/2,1/2]", "3+[111]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,0,1/2]", "2[100]:[1/2,1/2,0]", "2[010]:[0,1/2,1/2]"],
            ["3+[111]:[0,0,0]", "3+[1-1-1]:[1/2,0,1/2]", "3+[-11-1]:[1/2,1/2,0]", "3+[-1-11]:[0,1/2,1/2]"],
            ["3-[111]:[0,0,0]", "3-[1-1-1]:[0,1/2,1/2]", "3-[-11-1]:[1/2,0,1/2]", "3-[-1-11]:[1/2,1/2,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,0,1/2]", "m[100]:[1/2,1/2,0]", "m[010]:[0,1/2,1/2]"],
            ["-3+[111]:[0,0,0]", "-3+[1-1-1]:[1/2,0,1/2]", "-3+[-11-1]:[1/2,1/2,0]", "-3+[-1-11]:[0,1/2,1/2]"],
            ["-3-[111]:[0,0,0]", "-3-[1-1-1]:[0,1/2,1/2]", "-3-[-11-1]:[1/2,0,1/2]", "-3-[-1-11]:[1/2,1/2,0]"],
        ],
    ),
    "O^1": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,0]", "3+[111]:[0,0,0]", "2[110]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]", "2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            ["2[110]:[0,0,0]", "2[101]:[0,0,0]", "2[011]:[0,0,0]", "2[1-10]:[0,0,0]", "2[-101]:[0,0,0]", "2[01-1]:[0,0,0]"],
            [
                "3+[111]:[0,0,0]",
                "3+[1-1-1]:[0,0,0]",
                "3+[-11-1]:[0,0,0]",
                "3+[-1-11]:[0,0,0]",
                "3-[111]:[0,0,0]",
                "3-[1-1-1]:[0,0,0]",
                "3-[-11-1]:[0,0,0]",
                "3-[-1-11]:[0,0,0]",
            ],
            ["4+[001]:[0,0,0]", "4+[100]:[0,0,0]", "4+[010]:[0,0,0]", "4-[001]:[0,0,0]", "4-[100]:[0,0,0]", "4-[010]:[0,0,0]"],
        ],
    ),
    "O^2": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,0]", "3+[111]:[0,0,0]", "2[110]:[1/2,1/2,1/2]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]", "2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            [
                "2[110]:[1/2,1/2,1/2]",
                "2[101]:[1/2,1/2,1/2]",
                "2[011]:[1/2,1/2,1/2]",
                "2[1-10]:[1/2,1/2,1/2]",
                "2[-101]:[1/2,1/2,1/2]",
                "2[01-1]:[1/2,1/2,1/2]",
            ],
            [
                "3+[111]:[0,0,0]",
                "3+[1-1-1]:[0,0,0]",
                "3+[-11-1]:[0,0,0]",
                "3+[-1-11]:[0,0,0]",
                "3-[111]:[0,0,0]",
                "3-[1-1-1]:[0,0,0]",
                "3-[-11-1]:[0,0,0]",
                "3-[-1-11]:[0,0,0]",
            ],
            [
                "4+[001]:[1/2,1/2,1/2]",
                "4+[100]:[1/2,1/2,1/2]",
                "4+[010]:[1/2,1/2,1/2]",
                "4-[001]:[1/2,1/2,1/2]",
                "4-[100]:[1/2,1/2,1/2]",
                "4-[010]:[1/2,1/2,1/2]",
            ],
        ],
    ),
    "O^3": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,0]", "3+[111]:[0,0,0]", "2[110]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]", "2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            ["2[110]:[0,0,0]", "2[101]:[0,0,0]", "2[011]:[0,0,0]", "2[1-10]:[0,0,0]", "2[-101]:[0,0,0]", "2[01-1]:[0,0,0]"],
            [
                "3+[111]:[0,0,0]",
                "3+[1-1-1]:[0,0,0]",
                "3+[-11-1]:[0,0,0]",
                "3+[-1-11]:[0,0,0]",
                "3-[111]:[0,0,0]",
                "3-[1-1-1]:[0,0,0]",
                "3-[-11-1]:[0,0,0]",
                "3-[-1-11]:[0,0,0]",
            ],
            ["4+[001]:[0,0,0]", "4+[100]:[0,0,0]", "4+[010]:[0,0,0]", "4-[001]:[0,0,0]", "4-[100]:[0,0,0]", "4-[010]:[0,0,0]"],
        ],
    ),
    "O^4": (
        ["2[001]:[0,1/2,1/2]", "2[010]:[1/2,1/2,0]", "3+[111]:[0,0,0]", "2[110]:[3/4,1/4,3/4]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,1/2,1/2]", "2[100]:[1/2,0,1/2]", "2[010]:[1/2,1/2,0]"],
            [
                "2[110]:[3/4,1/4,3/4]",
                "2[101]:[1/4,3/4,3/4]",
                "2[011]:[3/4,3/4,1/4]",
                "2[1-10]:[1/4,1/4,1/4]",
                "2[-101]:[1/4,1/4,1/4]",
                "2[01-1]:[1/4,1/4,1/4]",
            ],
            [
                "3+[111]:[0,0,0]",
                "3+[1-1-1]:[0,1/2,1/2]",
                "3+[-11-1]:[1/2,0,1/2]",
                "3+[-1-11]:[1/2,1/2,0]",
                "3-[111]:[0,0,0]",
                "3-[1-1-1]:[1/2,1/2,0]",
                "3-[-11-1]:[0,1/2,1/2]",
                "3-[-1-11]:[1/2,0,1/2]",
            ],
            [
                "4+[001]:[3/4,3/4,1/4]",
                "4+[100]:[1/4,3/4,3/4]",
                "4+[010]:[3/4,1/4,3/4]",
                "4-[001]:[1/4,3/4,3/4]",
                "4-[100]:[3/4,1/4,3/4]",
                "4-[010]:[3/4,3/4,1/4]",
            ],
        ],
    ),
    "O^5": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,0]", "3+[111]:[0,0,0]", "2[110]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]", "2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            ["2[110]:[0,0,0]", "2[101]:[0,0,0]", "2[011]:[0,0,0]", "2[1-10]:[0,0,0]", "2[-101]:[0,0,0]", "2[01-1]:[0,0,0]"],
            [
                "3+[111]:[0,0,0]",
                "3+[1-1-1]:[0,0,0]",
                "3+[-11-1]:[0,0,0]",
                "3+[-1-11]:[0,0,0]",
                "3-[111]:[0,0,0]",
                "3-[1-1-1]:[0,0,0]",
                "3-[-11-1]:[0,0,0]",
                "3-[-1-11]:[0,0,0]",
            ],
            ["4+[001]:[0,0,0]", "4+[100]:[0,0,0]", "4+[010]:[0,0,0]", "4-[001]:[0,0,0]", "4-[100]:[0,0,0]", "4-[010]:[0,0,0]"],
        ],
    ),
    "O^6": (
        ["2[001]:[1/2,0,1/2]", "2[010]:[0,1/2,1/2]", "3+[111]:[0,0,0]", "2[110]:[1/4,3/4,3/4]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,0,1/2]", "2[100]:[1/2,1/2,0]", "2[010]:[0,1/2,1/2]"],
            [
                "2[110]:[1/4,3/4,3/4]",
                "2[101]:[3/4,3/4,1/4]",
                "2[011]:[3/4,1/4,3/4]",
                "2[1-10]:[1/4,1/4,1/4]",
                "2[-101]:[1/4,1/4,1/4]",
                "2[01-1]:[1/4,1/4,1/4]",
            ],
            [
                "3+[111]:[0,0,0]",
                "3+[1-1-1]:[1/2,0,1/2]",
                "3+[-11-1]:[1/2,1/2,0]",
                "3+[-1-11]:[0,1/2,1/2]",
                "3-[111]:[0,0,0]",
                "3-[1-1-1]:[0,1/2,1/2]",
                "3-[-11-1]:[1/2,0,1/2]",
                "3-[-1-11]:[1/2,1/2,0]",
            ],
            [
                "4+[001]:[3/4,1/4,3/4]",
                "4+[100]:[3/4,3/4,1/4]",
                "4+[010]:[1/4,3/4,3/4]",
                "4-[001]:[3/4,3/4,1/4]",
                "4-[100]:[1/4,3/4,3/4]",
                "4-[010]:[3/4,1/4,3/4]",
            ],
        ],
    ),
    "O^7": (
        ["2[001]:[1/2,0,1/2]", "2[010]:[0,1/2,1/2]", "3+[111]:[0,0,0]", "2[110]:[3/4,1/4,1/4]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,0,1/2]", "2[100]:[1/2,1/2,0]", "2[010]:[0,1/2,1/2]"],
            [
                "2[110]:[3/4,1/4,1/4]",
                "2[101]:[1/4,1/4,3/4]",
                "2[011]:[1/4,3/4,1/4]",
                "2[1-10]:[3/4,3/4,3/4]",
                "2[-101]:[3/4,3/4,3/4]",
                "2[01-1]:[3/4,3/4,3/4]",
            ],
            [
                "3+[111]:[0,0,0]",
                "3+[1-1-1]:[1/2,0,1/2]",
                "3+[-11-1]:[1/2,1/2,0]",
                "3+[-1-11]:[0,1/2,1/2]",
                "3-[111]:[0,0,0]",
                "3-[1-1-1]:[0,1/2,1/2]",
                "3-[-11-1]:[1/2,0,1/2]",
                "3-[-1-11]:[1/2,1/2,0]",
            ],
            [
                "4+[001]:[1/4,3/4,1/4]",
                "4+[100]:[1/4,1/4,3/4]",
                "4+[010]:[3/4,1/4,1/4]",
                "4-[001]:[1/4,1/4,3/4]",
                "4-[100]:[3/4,1/4,1/4]",
                "4-[010]:[1/4,3/4,1/4]",
            ],
        ],
    ),
    "O^8": (
        ["2[001]:[1/2,0,1/2]", "2[010]:[0,1/2,1/2]", "3+[111]:[0,0,0]", "2[110]:[3/4,1/4,1/4]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,0,1/2]", "2[100]:[1/2,1/2,0]", "2[010]:[0,1/2,1/2]"],
            [
                "2[110]:[3/4,1/4,1/4]",
                "2[101]:[1/4,1/4,3/4]",
                "2[011]:[1/4,3/4,1/4]",
                "2[1-10]:[3/4,3/4,3/4]",
                "2[-101]:[3/4,3/4,3/4]",
                "2[01-1]:[3/4,3/4,3/4]",
            ],
            [
                "3+[111]:[0,0,0]",
                "3+[1-1-1]:[1/2,0,1/2]",
                "3+[-11-1]:[1/2,1/2,0]",
                "3+[-1-11]:[0,1/2,1/2]",
                "3-[111]:[0,0,0]",
                "3-[1-1-1]:[0,1/2,1/2]",
                "3-[-11-1]:[1/2,0,1/2]",
                "3-[-1-11]:[1/2,1/2,0]",
            ],
            [
                "4+[001]:[1/4,3/4,1/4]",
                "4+[100]:[1/4,1/4,3/4]",
                "4+[010]:[3/4,1/4,1/4]",
                "4-[001]:[1/4,1/4,3/4]",
                "4-[100]:[3/4,1/4,1/4]",
                "4-[010]:[1/4,3/4,1/4]",
            ],
        ],
    ),
    "Td^1": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,0]", "3+[111]:[0,0,0]", "m[1-10]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]", "2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            [
                "3+[111]:[0,0,0]",
                "3+[1-1-1]:[0,0,0]",
                "3+[-11-1]:[0,0,0]",
                "3+[-1-11]:[0,0,0]",
                "3-[111]:[0,0,0]",
                "3-[1-1-1]:[0,0,0]",
                "3-[-11-1]:[0,0,0]",
                "3-[-1-11]:[0,0,0]",
            ],
            ["m[110]:[0,0,0]", "m[101]:[0,0,0]", "m[011]:[0,0,0]", "m[1-10]:[0,0,0]", "m[-101]:[0,0,0]", "m[01-1]:[0,0,0]"],
            ["-4+[001]:[0,0,0]", "-4+[100]:[0,0,0]", "-4+[010]:[0,0,0]", "-4-[001]:[0,0,0]", "-4-[100]:[0,0,0]", "-4-[010]:[0,0,0]"],
        ],
    ),
    "Td^2": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,0]", "3+[111]:[0,0,0]", "m[1-10]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]", "2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            [
                "3+[111]:[0,0,0]",
                "3+[1-1-1]:[0,0,0]",
                "3+[-11-1]:[0,0,0]",
                "3+[-1-11]:[0,0,0]",
                "3-[111]:[0,0,0]",
                "3-[1-1-1]:[0,0,0]",
                "3-[-11-1]:[0,0,0]",
                "3-[-1-11]:[0,0,0]",
            ],
            ["m[110]:[0,0,0]", "m[101]:[0,0,0]", "m[011]:[0,0,0]", "m[1-10]:[0,0,0]", "m[-101]:[0,0,0]", "m[01-1]:[0,0,0]"],
            ["-4+[001]:[0,0,0]", "-4+[100]:[0,0,0]", "-4+[010]:[0,0,0]", "-4-[001]:[0,0,0]", "-4-[100]:[0,0,0]", "-4-[010]:[0,0,0]"],
        ],
    ),
    "Td^3": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,0]", "3+[111]:[0,0,0]", "m[1-10]:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]", "2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            [
                "3+[111]:[0,0,0]",
                "3+[1-1-1]:[0,0,0]",
                "3+[-11-1]:[0,0,0]",
                "3+[-1-11]:[0,0,0]",
                "3-[111]:[0,0,0]",
                "3-[1-1-1]:[0,0,0]",
                "3-[-11-1]:[0,0,0]",
                "3-[-1-11]:[0,0,0]",
            ],
            ["m[110]:[0,0,0]", "m[101]:[0,0,0]", "m[011]:[0,0,0]", "m[1-10]:[0,0,0]", "m[-101]:[0,0,0]", "m[01-1]:[0,0,0]"],
            ["-4+[001]:[0,0,0]", "-4+[100]:[0,0,0]", "-4+[010]:[0,0,0]", "-4-[001]:[0,0,0]", "-4-[100]:[0,0,0]", "-4-[010]:[0,0,0]"],
        ],
    ),
    "Td^4": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,0]", "3+[111]:[0,0,0]", "m[1-10]:[1/2,1/2,1/2]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]", "2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            [
                "3+[111]:[0,0,0]",
                "3+[1-1-1]:[0,0,0]",
                "3+[-11-1]:[0,0,0]",
                "3+[-1-11]:[0,0,0]",
                "3-[111]:[0,0,0]",
                "3-[1-1-1]:[0,0,0]",
                "3-[-11-1]:[0,0,0]",
                "3-[-1-11]:[0,0,0]",
            ],
            [
                "m[110]:[1/2,1/2,1/2]",
                "m[101]:[1/2,1/2,1/2]",
                "m[011]:[1/2,1/2,1/2]",
                "m[1-10]:[1/2,1/2,1/2]",
                "m[-101]:[1/2,1/2,1/2]",
                "m[01-1]:[1/2,1/2,1/2]",
            ],
            [
                "-4+[001]:[1/2,1/2,1/2]",
                "-4+[100]:[1/2,1/2,1/2]",
                "-4+[010]:[1/2,1/2,1/2]",
                "-4-[001]:[1/2,1/2,1/2]",
                "-4-[100]:[1/2,1/2,1/2]",
                "-4-[010]:[1/2,1/2,1/2]",
            ],
        ],
    ),
    "Td^5": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,0]", "3+[111]:[0,0,0]", "m[1-10]:[1/2,1/2,1/2]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]", "2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            [
                "3+[111]:[0,0,0]",
                "3+[1-1-1]:[0,0,0]",
                "3+[-11-1]:[0,0,0]",
                "3+[-1-11]:[0,0,0]",
                "3-[111]:[0,0,0]",
                "3-[1-1-1]:[0,0,0]",
                "3-[-11-1]:[0,0,0]",
                "3-[-1-11]:[0,0,0]",
            ],
            [
                "m[110]:[1/2,1/2,1/2]",
                "m[101]:[1/2,1/2,1/2]",
                "m[011]:[1/2,1/2,1/2]",
                "m[1-10]:[1/2,1/2,1/2]",
                "m[-101]:[1/2,1/2,1/2]",
                "m[01-1]:[1/2,1/2,1/2]",
            ],
            [
                "-4+[001]:[1/2,1/2,1/2]",
                "-4+[100]:[1/2,1/2,1/2]",
                "-4+[010]:[1/2,1/2,1/2]",
                "-4-[001]:[1/2,1/2,1/2]",
                "-4-[100]:[1/2,1/2,1/2]",
                "-4-[010]:[1/2,1/2,1/2]",
            ],
        ],
    ),
    "Td^6": (
        ["2[001]:[1/2,0,1/2]", "2[010]:[0,1/2,1/2]", "3+[111]:[0,0,0]", "m[1-10]:[1/4,1/4,1/4]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,0,1/2]", "2[100]:[1/2,1/2,0]", "2[010]:[0,1/2,1/2]"],
            [
                "3+[111]:[0,0,0]",
                "3+[1-1-1]:[1/2,0,1/2]",
                "3+[-11-1]:[1/2,1/2,0]",
                "3+[-1-11]:[0,1/2,1/2]",
                "3-[111]:[0,0,0]",
                "3-[1-1-1]:[0,1/2,1/2]",
                "3-[-11-1]:[1/2,0,1/2]",
                "3-[-1-11]:[1/2,1/2,0]",
            ],
            [
                "m[110]:[1/4,3/4,3/4]",
                "m[101]:[3/4,3/4,1/4]",
                "m[011]:[3/4,1/4,3/4]",
                "m[1-10]:[1/4,1/4,1/4]",
                "m[-101]:[1/4,1/4,1/4]",
                "m[01-1]:[1/4,1/4,1/4]",
            ],
            [
                "-4+[001]:[3/4,1/4,3/4]",
                "-4+[100]:[3/4,3/4,1/4]",
                "-4+[010]:[1/4,3/4,3/4]",
                "-4-[001]:[3/4,3/4,1/4]",
                "-4-[100]:[1/4,3/4,3/4]",
                "-4-[010]:[3/4,1/4,3/4]",
            ],
        ],
    ),
    "Oh^1": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,0]", "3+[111]:[0,0,0]", "2[110]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]", "2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            ["2[110]:[0,0,0]", "2[101]:[0,0,0]", "2[011]:[0,0,0]", "2[1-10]:[0,0,0]", "2[-101]:[0,0,0]", "2[01-1]:[0,0,0]"],
            [
                "3+[111]:[0,0,0]",
                "3+[1-1-1]:[0,0,0]",
                "3+[-11-1]:[0,0,0]",
                "3+[-1-11]:[0,0,0]",
                "3-[111]:[0,0,0]",
                "3-[1-1-1]:[0,0,0]",
                "3-[-11-1]:[0,0,0]",
                "3-[-1-11]:[0,0,0]",
            ],
            ["4+[001]:[0,0,0]", "4+[100]:[0,0,0]", "4+[010]:[0,0,0]", "4-[001]:[0,0,0]", "4-[100]:[0,0,0]", "4-[010]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]", "m[100]:[0,0,0]", "m[010]:[0,0,0]"],
            ["m[110]:[0,0,0]", "m[101]:[0,0,0]", "m[011]:[0,0,0]", "m[1-10]:[0,0,0]", "m[-101]:[0,0,0]", "m[01-1]:[0,0,0]"],
            [
                "-3+[111]:[0,0,0]",
                "-3+[1-1-1]:[0,0,0]",
                "-3+[-11-1]:[0,0,0]",
                "-3+[-1-11]:[0,0,0]",
                "-3-[111]:[0,0,0]",
                "-3-[1-1-1]:[0,0,0]",
                "-3-[-11-1]:[0,0,0]",
                "-3-[-1-11]:[0,0,0]",
            ],
            ["-4+[001]:[0,0,0]", "-4+[100]:[0,0,0]", "-4+[010]:[0,0,0]", "-4-[001]:[0,0,0]", "-4-[100]:[0,0,0]", "-4-[010]:[0,0,0]"],
        ],
    ),
    "Oh^2": (
        ["2[001]:[1/2,1/2,0]", "2[010]:[1/2,0,1/2]", "3+[111]:[0,0,0]", "2[110]:[0,0,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,1/2,0]", "2[100]:[0,1/2,1/2]", "2[010]:[1/2,0,1/2]"],
            ["2[110]:[0,0,1/2]", "2[101]:[0,1/2,0]", "2[011]:[1/2,0,0]", "2[1-10]:[1/2,1/2,1/2]", "2[-101]:[1/2,1/2,1/2]", "2[01-1]:[1/2,1/2,1/2]"],
            [
                "3+[111]:[0,0,0]",
                "3+[1-1-1]:[1/2,1/2,0]",
                "3+[-11-1]:[0,1/2,1/2]",
                "3+[-1-11]:[1/2,0,1/2]",
                "3-[111]:[0,0,0]",
                "3-[1-1-1]:[1/2,0,1/2]",
                "3-[-11-1]:[1/2,1/2,0]",
                "3-[-1-11]:[0,1/2,1/2]",
            ],
            ["4+[001]:[1/2,0,0]", "4+[100]:[0,1/2,0]", "4+[010]:[0,0,1/2]", "4-[001]:[0,1/2,0]", "4-[100]:[0,0,1/2]", "4-[010]:[1/2,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,1/2,0]", "m[100]:[0,1/2,1/2]", "m[010]:[1/2,0,1/2]"],
            ["m[110]:[0,0,1/2]", "m[101]:[0,1/2,0]", "m[011]:[1/2,0,0]", "m[1-10]:[1/2,1/2,1/2]", "m[-101]:[1/2,1/2,1/2]", "m[01-1]:[1/2,1/2,1/2]"],
            [
                "-3+[111]:[0,0,0]",
                "-3+[1-1-1]:[1/2,1/2,0]",
                "-3+[-11-1]:[0,1/2,1/2]",
                "-3+[-1-11]:[1/2,0,1/2]",
                "-3-[111]:[0,0,0]",
                "-3-[1-1-1]:[1/2,0,1/2]",
                "-3-[-11-1]:[1/2,1/2,0]",
                "-3-[-1-11]:[0,1/2,1/2]",
            ],
            ["-4+[001]:[1/2,0,0]", "-4+[100]:[0,1/2,0]", "-4+[010]:[0,0,1/2]", "-4-[001]:[0,1/2,0]", "-4-[100]:[0,0,1/2]", "-4-[010]:[1/2,0,0]"],
        ],
    ),
    "Oh^3": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,0]", "3+[111]:[0,0,0]", "2[110]:[1/2,1/2,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]", "2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            [
                "2[110]:[1/2,1/2,1/2]",
                "2[101]:[1/2,1/2,1/2]",
                "2[011]:[1/2,1/2,1/2]",
                "2[1-10]:[1/2,1/2,1/2]",
                "2[-101]:[1/2,1/2,1/2]",
                "2[01-1]:[1/2,1/2,1/2]",
            ],
            [
                "3+[111]:[0,0,0]",
                "3+[1-1-1]:[0,0,0]",
                "3+[-11-1]:[0,0,0]",
                "3+[-1-11]:[0,0,0]",
                "3-[111]:[0,0,0]",
                "3-[1-1-1]:[0,0,0]",
                "3-[-11-1]:[0,0,0]",
                "3-[-1-11]:[0,0,0]",
            ],
            [
                "4+[001]:[1/2,1/2,1/2]",
                "4+[100]:[1/2,1/2,1/2]",
                "4+[010]:[1/2,1/2,1/2]",
                "4-[001]:[1/2,1/2,1/2]",
                "4-[100]:[1/2,1/2,1/2]",
                "4-[010]:[1/2,1/2,1/2]",
            ],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]", "m[100]:[0,0,0]", "m[010]:[0,0,0]"],
            [
                "m[110]:[1/2,1/2,1/2]",
                "m[101]:[1/2,1/2,1/2]",
                "m[011]:[1/2,1/2,1/2]",
                "m[1-10]:[1/2,1/2,1/2]",
                "m[-101]:[1/2,1/2,1/2]",
                "m[01-1]:[1/2,1/2,1/2]",
            ],
            [
                "-3+[111]:[0,0,0]",
                "-3+[1-1-1]:[0,0,0]",
                "-3+[-11-1]:[0,0,0]",
                "-3+[-1-11]:[0,0,0]",
                "-3-[111]:[0,0,0]",
                "-3-[1-1-1]:[0,0,0]",
                "-3-[-11-1]:[0,0,0]",
                "-3-[-1-11]:[0,0,0]",
            ],
            [
                "-4+[001]:[1/2,1/2,1/2]",
                "-4+[100]:[1/2,1/2,1/2]",
                "-4+[010]:[1/2,1/2,1/2]",
                "-4-[001]:[1/2,1/2,1/2]",
                "-4-[100]:[1/2,1/2,1/2]",
                "-4-[010]:[1/2,1/2,1/2]",
            ],
        ],
    ),
    "Oh^4": (
        ["2[001]:[1/2,1/2,0]", "2[010]:[1/2,0,1/2]", "3+[111]:[0,0,0]", "2[110]:[1/2,1/2,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,1/2,0]", "2[100]:[0,1/2,1/2]", "2[010]:[1/2,0,1/2]"],
            ["2[110]:[1/2,1/2,0]", "2[101]:[1/2,0,1/2]", "2[011]:[0,1/2,1/2]", "2[1-10]:[0,0,0]", "2[-101]:[0,0,0]", "2[01-1]:[0,0,0]"],
            [
                "3+[111]:[0,0,0]",
                "3+[1-1-1]:[1/2,1/2,0]",
                "3+[-11-1]:[0,1/2,1/2]",
                "3+[-1-11]:[1/2,0,1/2]",
                "3-[111]:[0,0,0]",
                "3-[1-1-1]:[1/2,0,1/2]",
                "3-[-11-1]:[1/2,1/2,0]",
                "3-[-1-11]:[0,1/2,1/2]",
            ],
            [
                "4+[001]:[0,1/2,1/2]",
                "4+[100]:[1/2,0,1/2]",
                "4+[010]:[1/2,1/2,0]",
                "4-[001]:[1/2,0,1/2]",
                "4-[100]:[1/2,1/2,0]",
                "4-[010]:[0,1/2,1/2]",
            ],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,1/2,0]", "m[100]:[0,1/2,1/2]", "m[010]:[1/2,0,1/2]"],
            ["m[110]:[1/2,1/2,0]", "m[101]:[1/2,0,1/2]", "m[011]:[0,1/2,1/2]", "m[1-10]:[0,0,0]", "m[-101]:[0,0,0]", "m[01-1]:[0,0,0]"],
            [
                "-3+[111]:[0,0,0]",
                "-3+[1-1-1]:[1/2,1/2,0]",
                "-3+[-11-1]:[0,1/2,1/2]",
                "-3+[-1-11]:[1/2,0,1/2]",
                "-3-[111]:[0,0,0]",
                "-3-[1-1-1]:[1/2,0,1/2]",
                "-3-[-11-1]:[1/2,1/2,0]",
                "-3-[-1-11]:[0,1/2,1/2]",
            ],
            [
                "-4+[001]:[0,1/2,1/2]",
                "-4+[100]:[1/2,0,1/2]",
                "-4+[010]:[1/2,1/2,0]",
                "-4-[001]:[1/2,0,1/2]",
                "-4-[100]:[1/2,1/2,0]",
                "-4-[010]:[0,1/2,1/2]",
            ],
        ],
    ),
    "Oh^5": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,0]", "3+[111]:[0,0,0]", "2[110]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]", "2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            ["2[110]:[0,0,0]", "2[101]:[0,0,0]", "2[011]:[0,0,0]", "2[1-10]:[0,0,0]", "2[-101]:[0,0,0]", "2[01-1]:[0,0,0]"],
            [
                "3+[111]:[0,0,0]",
                "3+[1-1-1]:[0,0,0]",
                "3+[-11-1]:[0,0,0]",
                "3+[-1-11]:[0,0,0]",
                "3-[111]:[0,0,0]",
                "3-[1-1-1]:[0,0,0]",
                "3-[-11-1]:[0,0,0]",
                "3-[-1-11]:[0,0,0]",
            ],
            ["4+[001]:[0,0,0]", "4+[100]:[0,0,0]", "4+[010]:[0,0,0]", "4-[001]:[0,0,0]", "4-[100]:[0,0,0]", "4-[010]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]", "m[100]:[0,0,0]", "m[010]:[0,0,0]"],
            ["m[110]:[0,0,0]", "m[101]:[0,0,0]", "m[011]:[0,0,0]", "m[1-10]:[0,0,0]", "m[-101]:[0,0,0]", "m[01-1]:[0,0,0]"],
            [
                "-3+[111]:[0,0,0]",
                "-3+[1-1-1]:[0,0,0]",
                "-3+[-11-1]:[0,0,0]",
                "-3+[-1-11]:[0,0,0]",
                "-3-[111]:[0,0,0]",
                "-3-[1-1-1]:[0,0,0]",
                "-3-[-11-1]:[0,0,0]",
                "-3-[-1-11]:[0,0,0]",
            ],
            ["-4+[001]:[0,0,0]", "-4+[100]:[0,0,0]", "-4+[010]:[0,0,0]", "-4-[001]:[0,0,0]", "-4-[100]:[0,0,0]", "-4-[010]:[0,0,0]"],
        ],
    ),
    "Oh^6": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,0]", "3+[111]:[0,0,0]", "2[110]:[1/2,1/2,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]", "2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            [
                "2[110]:[1/2,1/2,1/2]",
                "2[101]:[1/2,1/2,1/2]",
                "2[011]:[1/2,1/2,1/2]",
                "2[1-10]:[1/2,1/2,1/2]",
                "2[-101]:[1/2,1/2,1/2]",
                "2[01-1]:[1/2,1/2,1/2]",
            ],
            [
                "3+[111]:[0,0,0]",
                "3+[1-1-1]:[0,0,0]",
                "3+[-11-1]:[0,0,0]",
                "3+[-1-11]:[0,0,0]",
                "3-[111]:[0,0,0]",
                "3-[1-1-1]:[0,0,0]",
                "3-[-11-1]:[0,0,0]",
                "3-[-1-11]:[0,0,0]",
            ],
            [
                "4+[001]:[1/2,1/2,1/2]",
                "4+[100]:[1/2,1/2,1/2]",
                "4+[010]:[1/2,1/2,1/2]",
                "4-[001]:[1/2,1/2,1/2]",
                "4-[100]:[1/2,1/2,1/2]",
                "4-[010]:[1/2,1/2,1/2]",
            ],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]", "m[100]:[0,0,0]", "m[010]:[0,0,0]"],
            [
                "m[110]:[1/2,1/2,1/2]",
                "m[101]:[1/2,1/2,1/2]",
                "m[011]:[1/2,1/2,1/2]",
                "m[1-10]:[1/2,1/2,1/2]",
                "m[-101]:[1/2,1/2,1/2]",
                "m[01-1]:[1/2,1/2,1/2]",
            ],
            [
                "-3+[111]:[0,0,0]",
                "-3+[1-1-1]:[0,0,0]",
                "-3+[-11-1]:[0,0,0]",
                "-3+[-1-11]:[0,0,0]",
                "-3-[111]:[0,0,0]",
                "-3-[1-1-1]:[0,0,0]",
                "-3-[-11-1]:[0,0,0]",
                "-3-[-1-11]:[0,0,0]",
            ],
            [
                "-4+[001]:[1/2,1/2,1/2]",
                "-4+[100]:[1/2,1/2,1/2]",
                "-4+[010]:[1/2,1/2,1/2]",
                "-4-[001]:[1/2,1/2,1/2]",
                "-4-[100]:[1/2,1/2,1/2]",
                "-4-[010]:[1/2,1/2,1/2]",
            ],
        ],
    ),
    "Oh^7": (
        ["2[001]:[3/4,1/4,1/2]", "2[010]:[1/4,1/2,3/4]", "3+[111]:[0,0,0]", "2[110]:[3/4,1/4,1/2]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[3/4,1/4,1/2]", "2[100]:[1/2,3/4,1/4]", "2[010]:[1/4,1/2,3/4]"],
            ["2[110]:[3/4,1/4,1/2]", "2[101]:[1/4,1/2,3/4]", "2[011]:[1/2,3/4,1/4]", "2[1-10]:[0,0,0]", "2[-101]:[0,0,0]", "2[01-1]:[0,0,0]"],
            [
                "3+[111]:[0,0,0]",
                "3+[1-1-1]:[3/4,1/4,1/2]",
                "3+[-11-1]:[1/2,3/4,1/4]",
                "3+[-1-11]:[1/4,1/2,3/4]",
                "3-[111]:[0,0,0]",
                "3-[1-1-1]:[1/4,1/2,3/4]",
                "3-[-11-1]:[3/4,1/4,1/2]",
                "3-[-1-11]:[1/2,3/4,1/4]",
            ],
            [
                "4+[001]:[1/2,3/4,1/4]",
                "4+[100]:[1/4,1/2,3/4]",
                "4+[010]:[3/4,1/4,1/2]",
                "4-[001]:[1/4,1/2,3/4]",
                "4-[100]:[3/4,1/4,1/2]",
                "4-[010]:[1/2,3/4,1/4]",
            ],
            ["-1:[0,0,0]"],
            ["m[001]:[1/4,3/4,1/2]", "m[100]:[1/2,1/4,3/4]", "m[010]:[3/4,1/2,1/4]"],
            ["m[110]:[1/4,3/4,1/2]", "m[101]:[3/4,1/2,1/4]", "m[011]:[1/2,1/4,3/4]", "m[1-10]:[0,0,0]", "m[-101]:[0,0,0]", "m[01-1]:[0,0,0]"],
            [
                "-3+[111]:[0,0,0]",
                "-3+[1-1-1]:[1/4,3/4,1/2]",
                "-3+[-11-1]:[1/2,1/4,3/4]",
                "-3+[-1-11]:[3/4,1/2,1/4]",
                "-3-[111]:[0,0,0]",
                "-3-[1-1-1]:[3/4,1/2,1/4]",
                "-3-[-11-1]:[1/4,3/4,1/2]",
                "-3-[-1-11]:[1/2,1/4,3/4]",
            ],
            [
                "-4+[001]:[1/2,1/4,3/4]",
                "-4+[100]:[3/4,1/2,1/4]",
                "-4+[010]:[1/4,3/4,1/2]",
                "-4-[001]:[3/4,1/2,1/4]",
                "-4-[100]:[1/4,3/4,1/2]",
                "-4-[010]:[1/2,1/4,3/4]",
            ],
        ],
    ),
    "Oh^8": (
        ["2[001]:[1/4,3/4,1/2]", "2[010]:[3/4,1/2,1/4]", "3+[111]:[0,0,0]", "2[110]:[3/4,1/4,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/4,3/4,1/2]", "2[100]:[1/2,1/4,3/4]", "2[010]:[3/4,1/2,1/4]"],
            [
                "2[110]:[3/4,1/4,0]",
                "2[101]:[1/4,0,3/4]",
                "2[011]:[0,3/4,1/4]",
                "2[1-10]:[1/2,1/2,1/2]",
                "2[-101]:[1/2,1/2,1/2]",
                "2[01-1]:[1/2,1/2,1/2]",
            ],
            [
                "3+[111]:[0,0,0]",
                "3+[1-1-1]:[1/4,3/4,1/2]",
                "3+[-11-1]:[1/2,1/4,3/4]",
                "3+[-1-11]:[3/4,1/2,1/4]",
                "3-[111]:[0,0,0]",
                "3-[1-1-1]:[3/4,1/2,1/4]",
                "3-[-11-1]:[1/4,3/4,1/2]",
                "3-[-1-11]:[1/2,1/4,3/4]",
            ],
            [
                "4+[001]:[0,3/4,1/4]",
                "4+[100]:[1/4,0,3/4]",
                "4+[010]:[3/4,1/4,0]",
                "4-[001]:[1/4,0,3/4]",
                "4-[100]:[3/4,1/4,0]",
                "4-[010]:[0,3/4,1/4]",
            ],
            ["-1:[0,0,0]"],
            ["m[001]:[3/4,1/4,1/2]", "m[100]:[1/2,3/4,1/4]", "m[010]:[1/4,1/2,3/4]"],
            [
                "m[110]:[1/4,3/4,0]",
                "m[101]:[3/4,0,1/4]",
                "m[011]:[0,1/4,3/4]",
                "m[1-10]:[1/2,1/2,1/2]",
                "m[-101]:[1/2,1/2,1/2]",
                "m[01-1]:[1/2,1/2,1/2]",
            ],
            [
                "-3+[111]:[0,0,0]",
                "-3+[1-1-1]:[3/4,1/4,1/2]",
                "-3+[-11-1]:[1/2,3/4,1/4]",
                "-3+[-1-11]:[1/4,1/2,3/4]",
                "-3-[111]:[0,0,0]",
                "-3-[1-1-1]:[1/4,1/2,3/4]",
                "-3-[-11-1]:[3/4,1/4,1/2]",
                "-3-[-1-11]:[1/2,3/4,1/4]",
            ],
            [
                "-4+[001]:[0,1/4,3/4]",
                "-4+[100]:[3/4,0,1/4]",
                "-4+[010]:[1/4,3/4,0]",
                "-4-[001]:[3/4,0,1/4]",
                "-4-[100]:[1/4,3/4,0]",
                "-4-[010]:[0,1/4,3/4]",
            ],
        ],
    ),
    "Oh^9": (
        ["2[001]:[0,0,0]", "2[010]:[0,0,0]", "3+[111]:[0,0,0]", "2[110]:[0,0,0]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[0,0,0]", "2[100]:[0,0,0]", "2[010]:[0,0,0]"],
            ["2[110]:[0,0,0]", "2[101]:[0,0,0]", "2[011]:[0,0,0]", "2[1-10]:[0,0,0]", "2[-101]:[0,0,0]", "2[01-1]:[0,0,0]"],
            [
                "3+[111]:[0,0,0]",
                "3+[1-1-1]:[0,0,0]",
                "3+[-11-1]:[0,0,0]",
                "3+[-1-11]:[0,0,0]",
                "3-[111]:[0,0,0]",
                "3-[1-1-1]:[0,0,0]",
                "3-[-11-1]:[0,0,0]",
                "3-[-1-11]:[0,0,0]",
            ],
            ["4+[001]:[0,0,0]", "4+[100]:[0,0,0]", "4+[010]:[0,0,0]", "4-[001]:[0,0,0]", "4-[100]:[0,0,0]", "4-[010]:[0,0,0]"],
            ["-1:[0,0,0]"],
            ["m[001]:[0,0,0]", "m[100]:[0,0,0]", "m[010]:[0,0,0]"],
            ["m[110]:[0,0,0]", "m[101]:[0,0,0]", "m[011]:[0,0,0]", "m[1-10]:[0,0,0]", "m[-101]:[0,0,0]", "m[01-1]:[0,0,0]"],
            [
                "-3+[111]:[0,0,0]",
                "-3+[1-1-1]:[0,0,0]",
                "-3+[-11-1]:[0,0,0]",
                "-3+[-1-11]:[0,0,0]",
                "-3-[111]:[0,0,0]",
                "-3-[1-1-1]:[0,0,0]",
                "-3-[-11-1]:[0,0,0]",
                "-3-[-1-11]:[0,0,0]",
            ],
            ["-4+[001]:[0,0,0]", "-4+[100]:[0,0,0]", "-4+[010]:[0,0,0]", "-4-[001]:[0,0,0]", "-4-[100]:[0,0,0]", "-4-[010]:[0,0,0]"],
        ],
    ),
    "Oh^10": (
        ["2[001]:[1/2,0,1/2]", "2[010]:[0,1/2,1/2]", "3+[111]:[0,0,0]", "2[110]:[3/4,1/4,1/4]", "-1:[0,0,0]"],
        [
            ["1:[0,0,0]"],
            ["2[001]:[1/2,0,1/2]", "2[100]:[1/2,1/2,0]", "2[010]:[0,1/2,1/2]"],
            [
                "2[110]:[3/4,1/4,1/4]",
                "2[101]:[1/4,1/4,3/4]",
                "2[011]:[1/4,3/4,1/4]",
                "2[1-10]:[3/4,3/4,3/4]",
                "2[-101]:[3/4,3/4,3/4]",
                "2[01-1]:[3/4,3/4,3/4]",
            ],
            [
                "3+[111]:[0,0,0]",
                "3+[1-1-1]:[1/2,0,1/2]",
                "3+[-11-1]:[1/2,1/2,0]",
                "3+[-1-11]:[0,1/2,1/2]",
                "3-[111]:[0,0,0]",
                "3-[1-1-1]:[0,1/2,1/2]",
                "3-[-11-1]:[1/2,0,1/2]",
                "3-[-1-11]:[1/2,1/2,0]",
            ],
            [
                "4+[001]:[1/4,3/4,1/4]",
                "4+[100]:[1/4,1/4,3/4]",
                "4+[010]:[3/4,1/4,1/4]",
                "4-[001]:[1/4,1/4,3/4]",
                "4-[100]:[3/4,1/4,1/4]",
                "4-[010]:[1/4,3/4,1/4]",
            ],
            ["-1:[0,0,0]"],
            ["m[001]:[1/2,0,1/2]", "m[100]:[1/2,1/2,0]", "m[010]:[0,1/2,1/2]"],
            [
                "m[110]:[1/4,3/4,3/4]",
                "m[101]:[3/4,3/4,1/4]",
                "m[011]:[3/4,1/4,3/4]",
                "m[1-10]:[1/4,1/4,1/4]",
                "m[-101]:[1/4,1/4,1/4]",
                "m[01-1]:[1/4,1/4,1/4]",
            ],
            [
                "-3+[111]:[0,0,0]",
                "-3+[1-1-1]:[1/2,0,1/2]",
                "-3+[-11-1]:[1/2,1/2,0]",
                "-3+[-1-11]:[0,1/2,1/2]",
                "-3-[111]:[0,0,0]",
                "-3-[1-1-1]:[0,1/2,1/2]",
                "-3-[-11-1]:[1/2,0,1/2]",
                "-3-[-1-11]:[1/2,1/2,0]",
            ],
            [
                "-4+[001]:[3/4,1/4,3/4]",
                "-4+[100]:[3/4,3/4,1/4]",
                "-4+[010]:[1/4,3/4,3/4]",
                "-4-[001]:[3/4,3/4,1/4]",
                "-4-[100]:[1/4,3/4,3/4]",
                "-4-[010]:[3/4,1/4,3/4]",
            ],
        ],
    ),
}
