"""
symmetry operation for point groups
    {point-group-tag: (generator, [conjugacy class])}
"""
_data_symmetry_operation_pg = {
    "C1": (["1"], [["1"]]),
    "Ci": (["-1"], [["1"], ["-1"]]),
    "C2": (["2[010]"], [["1"], ["2[010]"]]),
    "Cs": (["m[010]"], [["1"], ["m[010]"]]),
    "C2h": (["2[010]", "-1"], [["1"], ["2[010]"], ["-1"], ["m[010]"]]),
    "D2": (["2[001]", "2[010]"], [["1"], ["2[001]"], ["2[010]"], ["2[100]"]]),
    "C2v": (["2[001]", "m[010]"], [["1"], ["2[001]"], ["m[010]"], ["m[100]"]]),
    "D2h": (["2[001]", "2[010]", "-1"], [["1"], ["2[001]"], ["2[010]"], ["2[100]"], ["-1"], ["m[001]"], ["m[010]"], ["m[100]"]]),
    "C4": (["2[001]", "4+[001]"], [["1"], ["2[001]"], ["4+[001]"], ["4-[001]"]]),
    "S4": (["2[001]", "-4+[001]"], [["1"], ["2[001]"], ["-4+[001]"], ["-4-[001]"]]),
    "C4h": (["2[001]", "4+[001]", "-1"], [["1"], ["2[001]"], ["4+[001]"], ["4-[001]"], ["-1"], ["m[001]"], ["-4+[001]"], ["-4-[001]"]]),
    "D4": (["2[001]", "4+[001]", "2[010]"], [["1"], ["2[001]"], ["2[100]", "2[010]"], ["2[110]", "2[1-10]"], ["4+[001]", "4-[001]"]]),
    "C4v": (["2[001]", "4+[001]", "m[010]"], [["1"], ["2[001]"], ["4+[001]", "4-[001]"], ["m[100]", "m[010]"], ["m[110]", "m[1-10]"]]),
    "D2d": (["2[001]", "-4+[001]", "2[010]"], [["1"], ["2[001]"], ["2[100]", "2[010]"], ["m[110]", "m[1-10]"], ["-4+[001]", "-4-[001]"]]),
    "D2d-1": (["2[001]", "-4+[001]", "m[010]"], [["1"], ["2[001]"], ["2[110]", "2[1-10]"], ["m[100]", "m[010]"], ["-4+[001]", "-4-[001]"]]),
    "D4h": (
        ["2[001]", "4+[001]", "2[010]", "-1"],
        [
            ["1"],
            ["2[001]"],
            ["2[100]", "2[010]"],
            ["2[110]", "2[1-10]"],
            ["4+[001]", "4-[001]"],
            ["-1"],
            ["m[001]"],
            ["m[100]", "m[010]"],
            ["m[110]", "m[1-10]"],
            ["-4+[001]", "-4-[001]"],
        ],
    ),
    "C3": (["3+[001]"], [["1"], ["3+[001]"], ["3-[001]"]]),
    "C3i": (["3+[001]", "-1"], [["1"], ["3+[001]"], ["3-[001]"], ["-1"], ["-3+[001]"], ["-3-[001]"]]),
    "D3": (["3+[001]", "2[1-10]"], [["1"], ["2[120]", "2[210]", "2[1-10]"], ["3+[001]", "3-[001]"]]),
    "D3-1": (["3+[001]", "2[110]"], [["1"], ["2[100]", "2[010]", "2[110]"], ["3+[001]", "3-[001]"]]),
    "C3v": (["3+[001]", "m[110]"], [["1"], ["3+[001]", "3-[001]"], ["m[100]", "m[010]", "m[110]"]]),
    "C3v-1": (["3+[001]", "m[1-10]"], [["1"], ["3+[001]", "3-[001]"], ["m[120]", "m[210]", "m[1-10]"]]),
    "D3d": (
        ["3+[001]", "2[1-10]", "-1"],
        [["1"], ["2[120]", "2[210]", "2[1-10]"], ["3+[001]", "3-[001]"], ["-1"], ["m[120]", "m[210]", "m[1-10]"], ["-3+[001]", "-3-[001]"]],
    ),
    "D3d-1": (
        ["3+[001]", "2[110]", "-1"],
        [["1"], ["2[100]", "2[010]", "2[110]"], ["3+[001]", "3-[001]"], ["-1"], ["m[100]", "m[010]", "m[110]"], ["-3+[001]", "-3-[001]"]],
    ),
    "C6": (["3+[001]", "2[001]"], [["1"], ["2[001]"], ["3+[001]"], ["3-[001]"], ["6+[001]"], ["6-[001]"]]),
    "C3h": (["3+[001]", "m[001]"], [["1"], ["3+[001]"], ["3-[001]"], ["m[001]"], ["-6+[001]"], ["-6-[001]"]]),
    "C6h": (
        ["3+[001]", "2[001]", "-1"],
        [
            ["1"],
            ["2[001]"],
            ["3+[001]"],
            ["3-[001]"],
            ["6+[001]"],
            ["6-[001]"],
            ["-1"],
            ["m[001]"],
            ["-3+[001]"],
            ["-3-[001]"],
            ["-6+[001]"],
            ["-6-[001]"],
        ],
    ),
    "D6": (
        ["3+[001]", "2[001]", "2[110]"],
        [["1"], ["2[001]"], ["2[100]", "2[010]", "2[110]"], ["2[120]", "2[210]", "2[1-10]"], ["3+[001]", "3-[001]"], ["6+[001]", "6-[001]"]],
    ),
    "C6v": (
        ["3+[001]", "2[001]", "m[110]"],
        [["1"], ["2[001]"], ["3+[001]", "3-[001]"], ["6+[001]", "6-[001]"], ["m[100]", "m[010]", "m[110]"], ["m[120]", "m[210]", "m[1-10]"]],
    ),
    "D3h": (
        ["3+[001]", "m[001]", "m[110]"],
        [["1"], ["2[120]", "2[210]", "2[1-10]"], ["3+[001]", "3-[001]"], ["m[100]", "m[010]", "m[110]"], ["m[001]"], ["-6+[001]", "-6-[001]"]],
    ),
    "D3h-1": (
        ["3+[001]", "m[001]", "2[110]"],
        [["1"], ["2[100]", "2[010]", "2[110]"], ["3+[001]", "3-[001]"], ["m[001]"], ["m[120]", "m[210]", "m[1-10]"], ["-6+[001]", "-6-[001]"]],
    ),
    "D6h": (
        ["3+[001]", "2[001]", "2[110]", "-1"],
        [
            ["1"],
            ["2[001]"],
            ["2[100]", "2[010]", "2[110]"],
            ["2[120]", "2[210]", "2[1-10]"],
            ["3+[001]", "3-[001]"],
            ["6+[001]", "6-[001]"],
            ["-1"],
            ["m[100]", "m[010]", "m[110]"],
            ["m[001]"],
            ["m[120]", "m[210]", "m[1-10]"],
            ["-3+[001]", "-3-[001]"],
            ["-6+[001]", "-6-[001]"],
        ],
    ),
    "T": (
        ["2[001]", "2[010]", "3+[111]"],
        [
            ["1"],
            ["2[001]", "2[100]", "2[010]"],
            ["3+[111]", "3+[1-1-1]", "3+[-11-1]", "3+[-1-11]"],
            ["3-[111]", "3-[1-1-1]", "3-[-11-1]", "3-[-1-11]"],
        ],
    ),
    "Th": (
        ["2[001]", "2[010]", "3+[111]", "-1"],
        [
            ["1"],
            ["2[001]", "2[100]", "2[010]"],
            ["3+[111]", "3+[1-1-1]", "3+[-11-1]", "3+[-1-11]"],
            ["3-[111]", "3-[1-1-1]", "3-[-11-1]", "3-[-1-11]"],
            ["-1"],
            ["m[001]", "m[100]", "m[010]"],
            ["-3+[111]", "-3+[1-1-1]", "-3+[-11-1]", "-3+[-1-11]"],
            ["-3-[111]", "-3-[1-1-1]", "-3-[-11-1]", "-3-[-1-11]"],
        ],
    ),
    "O": (
        ["2[001]", "2[010]", "3+[111]", "2[110]"],
        [
            ["1"],
            ["2[001]", "2[100]", "2[010]"],
            ["2[110]", "2[101]", "2[011]", "2[1-10]", "2[-101]", "2[01-1]"],
            ["3+[111]", "3+[1-1-1]", "3+[-11-1]", "3+[-1-11]", "3-[111]", "3-[1-1-1]", "3-[-11-1]", "3-[-1-11]"],
            ["4+[001]", "4+[100]", "4+[010]", "4-[001]", "4-[100]", "4-[010]"],
        ],
    ),
    "Td": (
        ["2[001]", "2[010]", "3+[111]", "m[1-10]"],
        [
            ["1"],
            ["2[001]", "2[100]", "2[010]"],
            ["3+[111]", "3+[1-1-1]", "3+[-11-1]", "3+[-1-11]", "3-[111]", "3-[1-1-1]", "3-[-11-1]", "3-[-1-11]"],
            ["m[110]", "m[101]", "m[011]", "m[1-10]", "m[-101]", "m[01-1]"],
            ["-4+[001]", "-4+[100]", "-4+[010]", "-4-[001]", "-4-[100]", "-4-[010]"],
        ],
    ),
    "Oh": (
        ["2[001]", "2[010]", "3+[111]", "2[110]", "-1"],
        [
            ["1"],
            ["2[001]", "2[100]", "2[010]"],
            ["2[110]", "2[101]", "2[011]", "2[1-10]", "2[-101]", "2[01-1]"],
            ["3+[111]", "3+[1-1-1]", "3+[-11-1]", "3+[-1-11]", "3-[111]", "3-[1-1-1]", "3-[-11-1]", "3-[-1-11]"],
            ["4+[001]", "4+[100]", "4+[010]", "4-[001]", "4-[100]", "4-[010]"],
            ["-1"],
            ["m[001]", "m[100]", "m[010]"],
            ["m[110]", "m[101]", "m[011]", "m[1-10]", "m[-101]", "m[01-1]"],
            ["-3+[111]", "-3+[1-1-1]", "-3+[-11-1]", "-3+[-1-11]", "-3-[111]", "-3-[1-1-1]", "-3-[-11-1]", "-3-[-1-11]"],
            ["-4+[001]", "-4+[100]", "-4+[010]", "-4-[001]", "-4-[100]", "-4-[010]"],
        ],
    ),
}
