"""
product irrep decomposition
    pg_tag: (symmetric-product, antisymmetric-product)
        (symmetric)product = [[irrep, ... ], ... ]
            irrep = [ (count, irrep), ... ]
        antisymmetric product = [irrep, ... ]
            irrep = [ (count, irrep), ... ]
"""
_data_product_decomp = {
    "C1": ([[[(1, "A")]]], [[]]),
    "Ci": ([[[(1, "Ag")], [(1, "Au")]], [[(1, "Au")], [(1, "Ag")]]], [[], []]),
    "C2": ([[[(1, "A")], [(1, "B")]], [[(1, "B")], [(1, "A")]]], [[], []]),
    "Cs": ([[[(1, "A'")], [(1, "A''")]], [[(1, "A''")], [(1, "A'")]]], [[], []]),
    "C2h": (
        [
            [[(1, "Ag")], [(1, "Bg")], [(1, "Au")], [(1, "Bu")]],
            [[(1, "Bg")], [(1, "Ag")], [(1, "Bu")], [(1, "Au")]],
            [[(1, "Au")], [(1, "Bu")], [(1, "Ag")], [(1, "Bg")]],
            [[(1, "Bu")], [(1, "Au")], [(1, "Bg")], [(1, "Ag")]],
        ],
        [[], [], [], []],
    ),
    "D2": (
        [
            [[(1, "A")], [(1, "B1")], [(1, "B2")], [(1, "B3")]],
            [[(1, "B1")], [(1, "A")], [(1, "B3")], [(1, "B2")]],
            [[(1, "B2")], [(1, "B3")], [(1, "A")], [(1, "B1")]],
            [[(1, "B3")], [(1, "B2")], [(1, "B1")], [(1, "A")]],
        ],
        [[], [], [], []],
    ),
    "C2v": (
        [
            [[(1, "A1")], [(1, "A2")], [(1, "B1")], [(1, "B2")]],
            [[(1, "A2")], [(1, "A1")], [(1, "B2")], [(1, "B1")]],
            [[(1, "B1")], [(1, "B2")], [(1, "A1")], [(1, "A2")]],
            [[(1, "B2")], [(1, "B1")], [(1, "A2")], [(1, "A1")]],
        ],
        [[], [], [], []],
    ),
    "D2h": (
        [
            [[(1, "Ag")], [(1, "B1g")], [(1, "B2g")], [(1, "B3g")], [(1, "Au")], [(1, "B1u")], [(1, "B2u")], [(1, "B3u")]],
            [[(1, "B1g")], [(1, "Ag")], [(1, "B3g")], [(1, "B2g")], [(1, "B1u")], [(1, "Au")], [(1, "B3u")], [(1, "B2u")]],
            [[(1, "B2g")], [(1, "B3g")], [(1, "Ag")], [(1, "B1g")], [(1, "B2u")], [(1, "B3u")], [(1, "Au")], [(1, "B1u")]],
            [[(1, "B3g")], [(1, "B2g")], [(1, "B1g")], [(1, "Ag")], [(1, "B3u")], [(1, "B2u")], [(1, "B1u")], [(1, "Au")]],
            [[(1, "Au")], [(1, "B1u")], [(1, "B2u")], [(1, "B3u")], [(1, "Ag")], [(1, "B1g")], [(1, "B2g")], [(1, "B3g")]],
            [[(1, "B1u")], [(1, "Au")], [(1, "B3u")], [(1, "B2u")], [(1, "B1g")], [(1, "Ag")], [(1, "B3g")], [(1, "B2g")]],
            [[(1, "B2u")], [(1, "B3u")], [(1, "Au")], [(1, "B1u")], [(1, "B2g")], [(1, "B3g")], [(1, "Ag")], [(1, "B1g")]],
            [[(1, "B3u")], [(1, "B2u")], [(1, "B1u")], [(1, "Au")], [(1, "B3g")], [(1, "B2g")], [(1, "B1g")], [(1, "Ag")]],
        ],
        [[], [], [], [], [], [], [], []],
    ),
    "C4": (
        [
            [[(1, "A")], [(1, "B")], [(1, "Ea")], [(1, "Eb")]],
            [[(1, "B")], [(1, "A")], [(1, "Eb")], [(1, "Ea")]],
            [[(1, "Ea")], [(1, "Eb")], [(1, "B")], [(1, "A")]],
            [[(1, "Eb")], [(1, "Ea")], [(1, "A")], [(1, "B")]],
        ],
        [[], [], [], []],
    ),
    "S4": (
        [
            [[(1, "A")], [(1, "B")], [(1, "Ea")], [(1, "Eb")]],
            [[(1, "B")], [(1, "A")], [(1, "Eb")], [(1, "Ea")]],
            [[(1, "Ea")], [(1, "Eb")], [(1, "B")], [(1, "A")]],
            [[(1, "Eb")], [(1, "Ea")], [(1, "A")], [(1, "B")]],
        ],
        [[], [], [], []],
    ),
    "C4h": (
        [
            [[(1, "Ag")], [(1, "Bg")], [(1, "Ega")], [(1, "Egb")], [(1, "Au")], [(1, "Bu")], [(1, "Eua")], [(1, "Eub")]],
            [[(1, "Bg")], [(1, "Ag")], [(1, "Egb")], [(1, "Ega")], [(1, "Bu")], [(1, "Au")], [(1, "Eub")], [(1, "Eua")]],
            [[(1, "Ega")], [(1, "Egb")], [(1, "Bg")], [(1, "Ag")], [(1, "Eua")], [(1, "Eub")], [(1, "Bu")], [(1, "Au")]],
            [[(1, "Egb")], [(1, "Ega")], [(1, "Ag")], [(1, "Bg")], [(1, "Eub")], [(1, "Eua")], [(1, "Au")], [(1, "Bu")]],
            [[(1, "Au")], [(1, "Bu")], [(1, "Eua")], [(1, "Eub")], [(1, "Ag")], [(1, "Bg")], [(1, "Ega")], [(1, "Egb")]],
            [[(1, "Bu")], [(1, "Au")], [(1, "Eub")], [(1, "Eua")], [(1, "Bg")], [(1, "Ag")], [(1, "Egb")], [(1, "Ega")]],
            [[(1, "Eua")], [(1, "Eub")], [(1, "Bu")], [(1, "Au")], [(1, "Ega")], [(1, "Egb")], [(1, "Bg")], [(1, "Ag")]],
            [[(1, "Eub")], [(1, "Eua")], [(1, "Au")], [(1, "Bu")], [(1, "Egb")], [(1, "Ega")], [(1, "Ag")], [(1, "Bg")]],
        ],
        [[], [], [], [], [], [], [], []],
    ),
    "D4": (
        [
            [[(1, "A1")], [(1, "A2")], [(1, "B1")], [(1, "B2")], [(1, "E")]],
            [[(1, "A2")], [(1, "A1")], [(1, "B2")], [(1, "B1")], [(1, "E")]],
            [[(1, "B1")], [(1, "B2")], [(1, "A1")], [(1, "A2")], [(1, "E")]],
            [[(1, "B2")], [(1, "B1")], [(1, "A2")], [(1, "A1")], [(1, "E")]],
            [[(1, "E")], [(1, "E")], [(1, "E")], [(1, "E")], [(1, "A1"), (1, "B1"), (1, "B2")]],
        ],
        [[], [], [], [], [(1, "A2")]],
    ),
    "C4v": (
        [
            [[(1, "A1")], [(1, "A2")], [(1, "B1")], [(1, "B2")], [(1, "E")]],
            [[(1, "A2")], [(1, "A1")], [(1, "B2")], [(1, "B1")], [(1, "E")]],
            [[(1, "B1")], [(1, "B2")], [(1, "A1")], [(1, "A2")], [(1, "E")]],
            [[(1, "B2")], [(1, "B1")], [(1, "A2")], [(1, "A1")], [(1, "E")]],
            [[(1, "E")], [(1, "E")], [(1, "E")], [(1, "E")], [(1, "A1"), (1, "B1"), (1, "B2")]],
        ],
        [[], [], [], [], [(1, "A2")]],
    ),
    "D2d": (
        [
            [[(1, "A1")], [(1, "A2")], [(1, "B1")], [(1, "B2")], [(1, "E")]],
            [[(1, "A2")], [(1, "A1")], [(1, "B2")], [(1, "B1")], [(1, "E")]],
            [[(1, "B1")], [(1, "B2")], [(1, "A1")], [(1, "A2")], [(1, "E")]],
            [[(1, "B2")], [(1, "B1")], [(1, "A2")], [(1, "A1")], [(1, "E")]],
            [[(1, "E")], [(1, "E")], [(1, "E")], [(1, "E")], [(1, "A1"), (1, "B1"), (1, "B2")]],
        ],
        [[], [], [], [], [(1, "A2")]],
    ),
    "D2d-1": (
        [
            [[(1, "A1")], [(1, "A2")], [(1, "B1")], [(1, "B2")], [(1, "E")]],
            [[(1, "A2")], [(1, "A1")], [(1, "B2")], [(1, "B1")], [(1, "E")]],
            [[(1, "B1")], [(1, "B2")], [(1, "A1")], [(1, "A2")], [(1, "E")]],
            [[(1, "B2")], [(1, "B1")], [(1, "A2")], [(1, "A1")], [(1, "E")]],
            [[(1, "E")], [(1, "E")], [(1, "E")], [(1, "E")], [(1, "A1"), (1, "B1"), (1, "B2")]],
        ],
        [[], [], [], [], [(1, "A2")]],
    ),
    "D4h": (
        [
            [
                [(1, "A1g")],
                [(1, "A2g")],
                [(1, "B1g")],
                [(1, "B2g")],
                [(1, "Eg")],
                [(1, "A1u")],
                [(1, "A2u")],
                [(1, "B1u")],
                [(1, "B2u")],
                [(1, "Eu")],
            ],
            [
                [(1, "A2g")],
                [(1, "A1g")],
                [(1, "B2g")],
                [(1, "B1g")],
                [(1, "Eg")],
                [(1, "A2u")],
                [(1, "A1u")],
                [(1, "B2u")],
                [(1, "B1u")],
                [(1, "Eu")],
            ],
            [
                [(1, "B1g")],
                [(1, "B2g")],
                [(1, "A1g")],
                [(1, "A2g")],
                [(1, "Eg")],
                [(1, "B1u")],
                [(1, "B2u")],
                [(1, "A1u")],
                [(1, "A2u")],
                [(1, "Eu")],
            ],
            [
                [(1, "B2g")],
                [(1, "B1g")],
                [(1, "A2g")],
                [(1, "A1g")],
                [(1, "Eg")],
                [(1, "B2u")],
                [(1, "B1u")],
                [(1, "A2u")],
                [(1, "A1u")],
                [(1, "Eu")],
            ],
            [
                [(1, "Eg")],
                [(1, "Eg")],
                [(1, "Eg")],
                [(1, "Eg")],
                [(1, "A1g"), (1, "B1g"), (1, "B2g")],
                [(1, "Eu")],
                [(1, "Eu")],
                [(1, "Eu")],
                [(1, "Eu")],
                [(1, "A1u"), (1, "A2u"), (1, "B1u"), (1, "B2u")],
            ],
            [
                [(1, "A1u")],
                [(1, "A2u")],
                [(1, "B1u")],
                [(1, "B2u")],
                [(1, "Eu")],
                [(1, "A1g")],
                [(1, "A2g")],
                [(1, "B1g")],
                [(1, "B2g")],
                [(1, "Eg")],
            ],
            [
                [(1, "A2u")],
                [(1, "A1u")],
                [(1, "B2u")],
                [(1, "B1u")],
                [(1, "Eu")],
                [(1, "A2g")],
                [(1, "A1g")],
                [(1, "B2g")],
                [(1, "B1g")],
                [(1, "Eg")],
            ],
            [
                [(1, "B1u")],
                [(1, "B2u")],
                [(1, "A1u")],
                [(1, "A2u")],
                [(1, "Eu")],
                [(1, "B1g")],
                [(1, "B2g")],
                [(1, "A1g")],
                [(1, "A2g")],
                [(1, "Eg")],
            ],
            [
                [(1, "B2u")],
                [(1, "B1u")],
                [(1, "A2u")],
                [(1, "A1u")],
                [(1, "Eu")],
                [(1, "B2g")],
                [(1, "B1g")],
                [(1, "A2g")],
                [(1, "A1g")],
                [(1, "Eg")],
            ],
            [
                [(1, "Eu")],
                [(1, "Eu")],
                [(1, "Eu")],
                [(1, "Eu")],
                [(1, "A1u"), (1, "A2u"), (1, "B1u"), (1, "B2u")],
                [(1, "Eg")],
                [(1, "Eg")],
                [(1, "Eg")],
                [(1, "Eg")],
                [(1, "A1g"), (1, "B1g"), (1, "B2g")],
            ],
        ],
        [[], [], [], [], [(1, "A2g")], [], [], [], [], [(1, "A2g")]],
    ),
    "C3": ([[[(1, "A")], [(1, "Ea")], [(1, "Eb")]], [[(1, "Ea")], [(1, "Eb")], [(1, "A")]], [[(1, "Eb")], [(1, "A")], [(1, "Ea")]]], [[], [], []],),
    "C3i": (
        [
            [[(1, "Ag")], [(1, "Ega")], [(1, "Egb")], [(1, "Au")], [(1, "Eua")], [(1, "Eub")]],
            [[(1, "Ega")], [(1, "Egb")], [(1, "Ag")], [(1, "Eua")], [(1, "Eub")], [(1, "Au")]],
            [[(1, "Egb")], [(1, "Ag")], [(1, "Ega")], [(1, "Eub")], [(1, "Au")], [(1, "Eua")]],
            [[(1, "Au")], [(1, "Eua")], [(1, "Eub")], [(1, "Ag")], [(1, "Ega")], [(1, "Egb")]],
            [[(1, "Eua")], [(1, "Eub")], [(1, "Au")], [(1, "Ega")], [(1, "Egb")], [(1, "Ag")]],
            [[(1, "Eub")], [(1, "Au")], [(1, "Eua")], [(1, "Egb")], [(1, "Ag")], [(1, "Ega")]],
        ],
        [[], [], [], [], [], []],
    ),
    "D3": (
        [[[(1, "A1")], [(1, "A2")], [(1, "E")]], [[(1, "A2")], [(1, "A1")], [(1, "E")]], [[(1, "E")], [(1, "E")], [(1, "A1"), (1, "E")]]],
        [[], [], [(1, "A2")]],
    ),
    "D3-1": (
        [[[(1, "A1")], [(1, "A2")], [(1, "E")]], [[(1, "A2")], [(1, "A1")], [(1, "E")]], [[(1, "E")], [(1, "E")], [(1, "A1"), (1, "E")]]],
        [[], [], [(1, "A2")]],
    ),
    "C3v": (
        [[[(1, "A1")], [(1, "A2")], [(1, "E")]], [[(1, "A2")], [(1, "A1")], [(1, "E")]], [[(1, "E")], [(1, "E")], [(1, "A1"), (1, "E")]]],
        [[], [], [(1, "A2")]],
    ),
    "C3v-1": (
        [[[(1, "A1")], [(1, "A2")], [(1, "E")]], [[(1, "A2")], [(1, "A1")], [(1, "E")]], [[(1, "E")], [(1, "E")], [(1, "A1"), (1, "E")]]],
        [[], [], [(1, "A2")]],
    ),
    "D3d": (
        [
            [[(1, "A1g")], [(1, "A2g")], [(1, "Eg")], [(1, "A1u")], [(1, "A2u")], [(1, "Eu")]],
            [[(1, "A2g")], [(1, "A1g")], [(1, "Eg")], [(1, "A2u")], [(1, "A1u")], [(1, "Eu")]],
            [[(1, "Eg")], [(1, "Eg")], [(1, "A1g"), (1, "Eg")], [(1, "Eu")], [(1, "Eu")], [(1, "A1u"), (1, "A2u"), (1, "Eu")]],
            [[(1, "A1u")], [(1, "A2u")], [(1, "Eu")], [(1, "A1g")], [(1, "A2g")], [(1, "Eg")]],
            [[(1, "A2u")], [(1, "A1u")], [(1, "Eu")], [(1, "A2g")], [(1, "A1g")], [(1, "Eg")]],
            [[(1, "Eu")], [(1, "Eu")], [(1, "A1u"), (1, "A2u"), (1, "Eu")], [(1, "Eg")], [(1, "Eg")], [(1, "A1g"), (1, "Eg")]],
        ],
        [[], [], [(1, "A2g")], [], [], [(1, "A2g")]],
    ),
    "D3d-1": (
        [
            [[(1, "A1g")], [(1, "A2g")], [(1, "Eg")], [(1, "A1u")], [(1, "A2u")], [(1, "Eu")]],
            [[(1, "A2g")], [(1, "A1g")], [(1, "Eg")], [(1, "A2u")], [(1, "A1u")], [(1, "Eu")]],
            [[(1, "Eg")], [(1, "Eg")], [(1, "A1g"), (1, "Eg")], [(1, "Eu")], [(1, "Eu")], [(1, "A1u"), (1, "A2u"), (1, "Eu")]],
            [[(1, "A1u")], [(1, "A2u")], [(1, "Eu")], [(1, "A1g")], [(1, "A2g")], [(1, "Eg")]],
            [[(1, "A2u")], [(1, "A1u")], [(1, "Eu")], [(1, "A2g")], [(1, "A1g")], [(1, "Eg")]],
            [[(1, "Eu")], [(1, "Eu")], [(1, "A1u"), (1, "A2u"), (1, "Eu")], [(1, "Eg")], [(1, "Eg")], [(1, "A1g"), (1, "Eg")]],
        ],
        [[], [], [(1, "A2g")], [], [], [(1, "A2g")]],
    ),
    "C6": (
        [
            [[(1, "A")], [(1, "B")], [(1, "E1a")], [(1, "E1b")], [(1, "E2a")], [(1, "E2b")]],
            [[(1, "B")], [(1, "A")], [(1, "E2a")], [(1, "E2b")], [(1, "E1a")], [(1, "E1b")]],
            [[(1, "E1a")], [(1, "E2a")], [(1, "E2b")], [(1, "A")], [(1, "E1b")], [(1, "B")]],
            [[(1, "E1b")], [(1, "E2b")], [(1, "A")], [(1, "E2a")], [(1, "B")], [(1, "E1a")]],
            [[(1, "E2a")], [(1, "E1a")], [(1, "E1b")], [(1, "B")], [(1, "E2b")], [(1, "A")]],
            [[(1, "E2b")], [(1, "E1b")], [(1, "B")], [(1, "E1a")], [(1, "A")], [(1, "E2a")]],
        ],
        [[], [], [], [], [], []],
    ),
    "C3h": (
        [
            [[(1, "A'")], [(1, "A''")], [(1, "Ea'")], [(1, "Eb'")], [(1, "Ea''")], [(1, "Eb''")]],
            [[(1, "A''")], [(1, "A'")], [(1, "Ea''")], [(1, "Eb''")], [(1, "Ea'")], [(1, "Eb'")]],
            [[(1, "Ea'")], [(1, "Ea''")], [(1, "Eb'")], [(1, "A'")], [(1, "Eb''")], [(1, "A''")]],
            [[(1, "Eb'")], [(1, "Eb''")], [(1, "A'")], [(1, "Ea'")], [(1, "A''")], [(1, "Ea''")]],
            [[(1, "Ea''")], [(1, "Ea'")], [(1, "Eb''")], [(1, "A''")], [(1, "Eb'")], [(1, "A'")]],
            [[(1, "Eb''")], [(1, "Eb'")], [(1, "A''")], [(1, "Ea''")], [(1, "A'")], [(1, "Ea'")]],
        ],
        [[], [], [], [], [], []],
    ),
    "C6h": (
        [
            [
                [(1, "Ag")],
                [(1, "Bg")],
                [(1, "E1ga")],
                [(1, "E1gb")],
                [(1, "E2ga")],
                [(1, "E2gb")],
                [(1, "Au")],
                [(1, "Bu")],
                [(1, "E1ua")],
                [(1, "E1ub")],
                [(1, "E2ua")],
                [(1, "E2ub")],
            ],
            [
                [(1, "Bg")],
                [(1, "Ag")],
                [(1, "E2ga")],
                [(1, "E2gb")],
                [(1, "E1ga")],
                [(1, "E1gb")],
                [(1, "Bu")],
                [(1, "Au")],
                [(1, "E2ua")],
                [(1, "E2ub")],
                [(1, "E1ua")],
                [(1, "E1ub")],
            ],
            [
                [(1, "E1ga")],
                [(1, "E2ga")],
                [(1, "E2gb")],
                [(1, "Ag")],
                [(1, "E1gb")],
                [(1, "Bg")],
                [(1, "E1ua")],
                [(1, "E2ua")],
                [(1, "E2ub")],
                [(1, "Au")],
                [(1, "E1ub")],
                [(1, "Bu")],
            ],
            [
                [(1, "E1gb")],
                [(1, "E2gb")],
                [(1, "Ag")],
                [(1, "E2ga")],
                [(1, "Bg")],
                [(1, "E1ga")],
                [(1, "E1ub")],
                [(1, "E2ub")],
                [(1, "Au")],
                [(1, "E2ua")],
                [(1, "Bu")],
                [(1, "E1ua")],
            ],
            [
                [(1, "E2ga")],
                [(1, "E1ga")],
                [(1, "E1gb")],
                [(1, "Bg")],
                [(1, "E2gb")],
                [(1, "Ag")],
                [(1, "E2ua")],
                [(1, "E1ua")],
                [(1, "E1ub")],
                [(1, "Bu")],
                [(1, "E2ub")],
                [(1, "Au")],
            ],
            [
                [(1, "E2gb")],
                [(1, "E1gb")],
                [(1, "Bg")],
                [(1, "E1ga")],
                [(1, "Ag")],
                [(1, "E2ga")],
                [(1, "E2ub")],
                [(1, "E1ub")],
                [(1, "Bu")],
                [(1, "E1ua")],
                [(1, "Au")],
                [(1, "E2ua")],
            ],
            [
                [(1, "Au")],
                [(1, "Bu")],
                [(1, "E1ua")],
                [(1, "E1ub")],
                [(1, "E2ua")],
                [(1, "E2ub")],
                [(1, "Ag")],
                [(1, "Bg")],
                [(1, "E1ga")],
                [(1, "E1gb")],
                [(1, "E2ga")],
                [(1, "E2gb")],
            ],
            [
                [(1, "Bu")],
                [(1, "Au")],
                [(1, "E2ua")],
                [(1, "E2ub")],
                [(1, "E1ua")],
                [(1, "E1ub")],
                [(1, "Bg")],
                [(1, "Ag")],
                [(1, "E2ga")],
                [(1, "E2gb")],
                [(1, "E1ga")],
                [(1, "E1gb")],
            ],
            [
                [(1, "E1ua")],
                [(1, "E2ua")],
                [(1, "E2ub")],
                [(1, "Au")],
                [(1, "E1ub")],
                [(1, "Bu")],
                [(1, "E1ga")],
                [(1, "E2ga")],
                [(1, "E2gb")],
                [(1, "Ag")],
                [(1, "E1gb")],
                [(1, "Bg")],
            ],
            [
                [(1, "E1ub")],
                [(1, "E2ub")],
                [(1, "Au")],
                [(1, "E2ua")],
                [(1, "Bu")],
                [(1, "E1ua")],
                [(1, "E1gb")],
                [(1, "E2gb")],
                [(1, "Ag")],
                [(1, "E2ga")],
                [(1, "Bg")],
                [(1, "E1ga")],
            ],
            [
                [(1, "E2ua")],
                [(1, "E1ua")],
                [(1, "E1ub")],
                [(1, "Bu")],
                [(1, "E2ub")],
                [(1, "Au")],
                [(1, "E2ga")],
                [(1, "E1ga")],
                [(1, "E1gb")],
                [(1, "Bg")],
                [(1, "E2gb")],
                [(1, "Ag")],
            ],
            [
                [(1, "E2ub")],
                [(1, "E1ub")],
                [(1, "Bu")],
                [(1, "E1ua")],
                [(1, "Au")],
                [(1, "E2ua")],
                [(1, "E2gb")],
                [(1, "E1gb")],
                [(1, "Bg")],
                [(1, "E1ga")],
                [(1, "Ag")],
                [(1, "E2ga")],
            ],
        ],
        [[], [], [], [], [], [], [], [], [], [], [], []],
    ),
    "D6": (
        [
            [[(1, "A1")], [(1, "A2")], [(1, "B1")], [(1, "B2")], [(1, "E1")], [(1, "E2")]],
            [[(1, "A2")], [(1, "A1")], [(1, "B2")], [(1, "B1")], [(1, "E1")], [(1, "E2")]],
            [[(1, "B1")], [(1, "B2")], [(1, "A1")], [(1, "A2")], [(1, "E2")], [(1, "E1")]],
            [[(1, "B2")], [(1, "B1")], [(1, "A2")], [(1, "A1")], [(1, "E2")], [(1, "E1")]],
            [[(1, "E1")], [(1, "E1")], [(1, "E2")], [(1, "E2")], [(1, "A1"), (1, "E2")], [(1, "B1"), (1, "B2"), (1, "E1")]],
            [[(1, "E2")], [(1, "E2")], [(1, "E1")], [(1, "E1")], [(1, "B1"), (1, "B2"), (1, "E1")], [(1, "A1"), (1, "E2")]],
        ],
        [[], [], [], [], [(1, "A2")], [(1, "A2")]],
    ),
    "C6v": (
        [
            [[(1, "A1")], [(1, "A2")], [(1, "B1")], [(1, "B2")], [(1, "E1")], [(1, "E2")]],
            [[(1, "A2")], [(1, "A1")], [(1, "B2")], [(1, "B1")], [(1, "E1")], [(1, "E2")]],
            [[(1, "B1")], [(1, "B2")], [(1, "A1")], [(1, "A2")], [(1, "E2")], [(1, "E1")]],
            [[(1, "B2")], [(1, "B1")], [(1, "A2")], [(1, "A1")], [(1, "E2")], [(1, "E1")]],
            [[(1, "E1")], [(1, "E1")], [(1, "E2")], [(1, "E2")], [(1, "A1"), (1, "E2")], [(1, "B1"), (1, "B2"), (1, "E1")]],
            [[(1, "E2")], [(1, "E2")], [(1, "E1")], [(1, "E1")], [(1, "B1"), (1, "B2"), (1, "E1")], [(1, "A1"), (1, "E2")]],
        ],
        [[], [], [], [], [(1, "A2")], [(1, "A2")]],
    ),
    "D3h": (
        [
            [[(1, "A1'")], [(1, "A2'")], [(1, "A1''")], [(1, "A2''")], [(1, "E'")], [(1, "E''")]],
            [[(1, "A2'")], [(1, "A1'")], [(1, "A2''")], [(1, "A1''")], [(1, "E'")], [(1, "E''")]],
            [[(1, "A1''")], [(1, "A2''")], [(1, "A1'")], [(1, "A2'")], [(1, "E''")], [(1, "E'")]],
            [[(1, "A2''")], [(1, "A1''")], [(1, "A2'")], [(1, "A1'")], [(1, "E''")], [(1, "E'")]],
            [[(1, "E'")], [(1, "E'")], [(1, "E''")], [(1, "E''")], [(1, "A1'"), (1, "E'")], [(1, "A1''"), (1, "A2''"), (1, "E''")]],
            [[(1, "E''")], [(1, "E''")], [(1, "E'")], [(1, "E'")], [(1, "A1''"), (1, "A2''"), (1, "E''")], [(1, "A1'"), (1, "E'")]],
        ],
        [[], [], [], [], [(1, "A2'")], [(1, "A2'")]],
    ),
    "D3h-1": (
        [
            [[(1, "A1'")], [(1, "A2'")], [(1, "A1''")], [(1, "A2''")], [(1, "E'")], [(1, "E''")]],
            [[(1, "A2'")], [(1, "A1'")], [(1, "A2''")], [(1, "A1''")], [(1, "E'")], [(1, "E''")]],
            [[(1, "A1''")], [(1, "A2''")], [(1, "A1'")], [(1, "A2'")], [(1, "E''")], [(1, "E'")]],
            [[(1, "A2''")], [(1, "A1''")], [(1, "A2'")], [(1, "A1'")], [(1, "E''")], [(1, "E'")]],
            [[(1, "E'")], [(1, "E'")], [(1, "E''")], [(1, "E''")], [(1, "A1'"), (1, "E'")], [(1, "A1''"), (1, "A2''"), (1, "E''")]],
            [[(1, "E''")], [(1, "E''")], [(1, "E'")], [(1, "E'")], [(1, "A1''"), (1, "A2''"), (1, "E''")], [(1, "A1'"), (1, "E'")]],
        ],
        [[], [], [], [], [(1, "A2'")], [(1, "A2'")]],
    ),
    "D6h": (
        [
            [
                [(1, "A1g")],
                [(1, "A2g")],
                [(1, "B1g")],
                [(1, "B2g")],
                [(1, "E1g")],
                [(1, "E2g")],
                [(1, "A1u")],
                [(1, "A2u")],
                [(1, "B1u")],
                [(1, "B2u")],
                [(1, "E1u")],
                [(1, "E2u")],
            ],
            [
                [(1, "A2g")],
                [(1, "A1g")],
                [(1, "B2g")],
                [(1, "B1g")],
                [(1, "E1g")],
                [(1, "E2g")],
                [(1, "A2u")],
                [(1, "A1u")],
                [(1, "B2u")],
                [(1, "B1u")],
                [(1, "E1u")],
                [(1, "E2u")],
            ],
            [
                [(1, "B1g")],
                [(1, "B2g")],
                [(1, "A1g")],
                [(1, "A2g")],
                [(1, "E2g")],
                [(1, "E1g")],
                [(1, "B1u")],
                [(1, "B2u")],
                [(1, "A1u")],
                [(1, "A2u")],
                [(1, "E2u")],
                [(1, "E1u")],
            ],
            [
                [(1, "B2g")],
                [(1, "B1g")],
                [(1, "A2g")],
                [(1, "A1g")],
                [(1, "E2g")],
                [(1, "E1g")],
                [(1, "B2u")],
                [(1, "B1u")],
                [(1, "A2u")],
                [(1, "A1u")],
                [(1, "E2u")],
                [(1, "E1u")],
            ],
            [
                [(1, "E1g")],
                [(1, "E1g")],
                [(1, "E2g")],
                [(1, "E2g")],
                [(1, "A1g"), (1, "E2g")],
                [(1, "B1g"), (1, "B2g"), (1, "E1g")],
                [(1, "E1u")],
                [(1, "E1u")],
                [(1, "E2u")],
                [(1, "E2u")],
                [(1, "A1u"), (1, "A2u"), (1, "E2u")],
                [(1, "B1u"), (1, "B2u"), (1, "E1u")],
            ],
            [
                [(1, "E2g")],
                [(1, "E2g")],
                [(1, "E1g")],
                [(1, "E1g")],
                [(1, "B1g"), (1, "B2g"), (1, "E1g")],
                [(1, "A1g"), (1, "E2g")],
                [(1, "E2u")],
                [(1, "E2u")],
                [(1, "E1u")],
                [(1, "E1u")],
                [(1, "B1u"), (1, "B2u"), (1, "E1u")],
                [(1, "A1u"), (1, "A2u"), (1, "E2u")],
            ],
            [
                [(1, "A1u")],
                [(1, "A2u")],
                [(1, "B1u")],
                [(1, "B2u")],
                [(1, "E1u")],
                [(1, "E2u")],
                [(1, "A1g")],
                [(1, "A2g")],
                [(1, "B1g")],
                [(1, "B2g")],
                [(1, "E1g")],
                [(1, "E2g")],
            ],
            [
                [(1, "A2u")],
                [(1, "A1u")],
                [(1, "B2u")],
                [(1, "B1u")],
                [(1, "E1u")],
                [(1, "E2u")],
                [(1, "A2g")],
                [(1, "A1g")],
                [(1, "B2g")],
                [(1, "B1g")],
                [(1, "E1g")],
                [(1, "E2g")],
            ],
            [
                [(1, "B1u")],
                [(1, "B2u")],
                [(1, "A1u")],
                [(1, "A2u")],
                [(1, "E2u")],
                [(1, "E1u")],
                [(1, "B1g")],
                [(1, "B2g")],
                [(1, "A1g")],
                [(1, "A2g")],
                [(1, "E2g")],
                [(1, "E1g")],
            ],
            [
                [(1, "B2u")],
                [(1, "B1u")],
                [(1, "A2u")],
                [(1, "A1u")],
                [(1, "E2u")],
                [(1, "E1u")],
                [(1, "B2g")],
                [(1, "B1g")],
                [(1, "A2g")],
                [(1, "A1g")],
                [(1, "E2g")],
                [(1, "E1g")],
            ],
            [
                [(1, "E1u")],
                [(1, "E1u")],
                [(1, "E2u")],
                [(1, "E2u")],
                [(1, "A1u"), (1, "A2u"), (1, "E2u")],
                [(1, "B1u"), (1, "B2u"), (1, "E1u")],
                [(1, "E1g")],
                [(1, "E1g")],
                [(1, "E2g")],
                [(1, "E2g")],
                [(1, "A1g"), (1, "E2g")],
                [(1, "B1g"), (1, "B2g"), (1, "E1g")],
            ],
            [
                [(1, "E2u")],
                [(1, "E2u")],
                [(1, "E1u")],
                [(1, "E1u")],
                [(1, "B1u"), (1, "B2u"), (1, "E1u")],
                [(1, "A1u"), (1, "A2u"), (1, "E2u")],
                [(1, "E2g")],
                [(1, "E2g")],
                [(1, "E1g")],
                [(1, "E1g")],
                [(1, "B1g"), (1, "B2g"), (1, "E1g")],
                [(1, "A1g"), (1, "E2g")],
            ],
        ],
        [[], [], [], [], [(1, "A2g")], [(1, "A2g")], [], [], [], [], [(1, "A2g")], [(1, "A2g")]],
    ),
    "T": (
        [
            [[(1, "A")], [(1, "Ea")], [(1, "Eb")], [(1, "T")]],
            [[(1, "Ea")], [(1, "Eb")], [(1, "A")], [(1, "T")]],
            [[(1, "Eb")], [(1, "A")], [(1, "Ea")], [(1, "T")]],
            [[(1, "T")], [(1, "T")], [(1, "T")], [(1, "A"), (1, "Ea"), (1, "Eb"), (1, "T")]],
        ],
        [[], [], [], [(1, "T")]],
    ),
    "Th": (
        [
            [[(1, "Ag")], [(1, "Ega")], [(1, "Egb")], [(1, "Tg")], [(1, "Au")], [(1, "Eua")], [(1, "Eub")], [(1, "Tu")]],
            [[(1, "Ega")], [(1, "Egb")], [(1, "Ag")], [(1, "Tg")], [(1, "Eua")], [(1, "Eub")], [(1, "Au")], [(1, "Tu")]],
            [[(1, "Egb")], [(1, "Ag")], [(1, "Ega")], [(1, "Tg")], [(1, "Eub")], [(1, "Au")], [(1, "Eua")], [(1, "Tu")]],
            [
                [(1, "Tg")],
                [(1, "Tg")],
                [(1, "Tg")],
                [(1, "Ag"), (1, "Ega"), (1, "Egb"), (1, "Tg")],
                [(1, "Tu")],
                [(1, "Tu")],
                [(1, "Tu")],
                [(1, "Au"), (1, "Eua"), (1, "Eub"), (2, "Tu")],
            ],
            [[(1, "Au")], [(1, "Eua")], [(1, "Eub")], [(1, "Tu")], [(1, "Ag")], [(1, "Ega")], [(1, "Egb")], [(1, "Tg")]],
            [[(1, "Eua")], [(1, "Eub")], [(1, "Au")], [(1, "Tu")], [(1, "Ega")], [(1, "Egb")], [(1, "Ag")], [(1, "Tg")]],
            [[(1, "Eub")], [(1, "Au")], [(1, "Eua")], [(1, "Tu")], [(1, "Egb")], [(1, "Ag")], [(1, "Ega")], [(1, "Tg")]],
            [
                [(1, "Tu")],
                [(1, "Tu")],
                [(1, "Tu")],
                [(1, "Au"), (1, "Eua"), (1, "Eub"), (2, "Tu")],
                [(1, "Tg")],
                [(1, "Tg")],
                [(1, "Tg")],
                [(1, "Ag"), (1, "Ega"), (1, "Egb"), (1, "Tg")],
            ],
        ],
        [[], [], [], [(1, "Tg")], [], [], [], [(1, "Tg")]],
    ),
    "O": (
        [
            [[(1, "A1")], [(1, "A2")], [(1, "E")], [(1, "T1")], [(1, "T2")]],
            [[(1, "A2")], [(1, "A1")], [(1, "E")], [(1, "T2")], [(1, "T1")]],
            [[(1, "E")], [(1, "E")], [(1, "A1"), (1, "E")], [(1, "T1"), (1, "T2")], [(1, "T1"), (1, "T2")]],
            [[(1, "T1")], [(1, "T2")], [(1, "T1"), (1, "T2")], [(1, "A1"), (1, "E"), (1, "T2")], [(1, "A2"), (1, "E"), (1, "T1"), (1, "T2")]],
            [[(1, "T2")], [(1, "T1")], [(1, "T1"), (1, "T2")], [(1, "A2"), (1, "E"), (1, "T1"), (1, "T2")], [(1, "A1"), (1, "E"), (1, "T2")]],
        ],
        [[], [], [(1, "A2")], [(1, "T1")], [(1, "T1")]],
    ),
    "Td": (
        [
            [[(1, "A1")], [(1, "A2")], [(1, "E")], [(1, "T1")], [(1, "T2")]],
            [[(1, "A2")], [(1, "A1")], [(1, "E")], [(1, "T2")], [(1, "T1")]],
            [[(1, "E")], [(1, "E")], [(1, "A1"), (1, "E")], [(1, "T1"), (1, "T2")], [(1, "T1"), (1, "T2")]],
            [[(1, "T1")], [(1, "T2")], [(1, "T1"), (1, "T2")], [(1, "A1"), (1, "E"), (1, "T2")], [(1, "A2"), (1, "E"), (1, "T1"), (1, "T2")]],
            [[(1, "T2")], [(1, "T1")], [(1, "T1"), (1, "T2")], [(1, "A2"), (1, "E"), (1, "T1"), (1, "T2")], [(1, "A1"), (1, "E"), (1, "T2")]],
        ],
        [[], [], [(1, "A2")], [(1, "T1")], [(1, "T1")]],
    ),
    "Oh": (
        [
            [
                [(1, "A1g")],
                [(1, "A2g")],
                [(1, "Eg")],
                [(1, "T1g")],
                [(1, "T2g")],
                [(1, "A1u")],
                [(1, "A2u")],
                [(1, "Eu")],
                [(1, "T1u")],
                [(1, "T2u")],
            ],
            [
                [(1, "A2g")],
                [(1, "A1g")],
                [(1, "Eg")],
                [(1, "T2g")],
                [(1, "T1g")],
                [(1, "A2u")],
                [(1, "A1u")],
                [(1, "Eu")],
                [(1, "T2u")],
                [(1, "T1u")],
            ],
            [
                [(1, "Eg")],
                [(1, "Eg")],
                [(1, "A1g"), (1, "Eg")],
                [(1, "T1g"), (1, "T2g")],
                [(1, "T1g"), (1, "T2g")],
                [(1, "Eu")],
                [(1, "Eu")],
                [(1, "A1u"), (1, "A2u"), (1, "Eu")],
                [(1, "T1u"), (1, "T2u")],
                [(1, "T1u"), (1, "T2u")],
            ],
            [
                [(1, "T1g")],
                [(1, "T2g")],
                [(1, "T1g"), (1, "T2g")],
                [(1, "A1g"), (1, "Eg"), (1, "T2g")],
                [(1, "A2g"), (1, "Eg"), (1, "T1g"), (1, "T2g")],
                [(1, "T1u")],
                [(1, "T2u")],
                [(1, "T1u"), (1, "T2u")],
                [(1, "A1u"), (1, "Eu"), (1, "T1u"), (1, "T2u")],
                [(1, "A2u"), (1, "Eu"), (1, "T1u"), (1, "T2u")],
            ],
            [
                [(1, "T2g")],
                [(1, "T1g")],
                [(1, "T1g"), (1, "T2g")],
                [(1, "A2g"), (1, "Eg"), (1, "T1g"), (1, "T2g")],
                [(1, "A1g"), (1, "Eg"), (1, "T2g")],
                [(1, "T2u")],
                [(1, "T1u")],
                [(1, "T1u"), (1, "T2u")],
                [(1, "A2u"), (1, "Eu"), (1, "T1u"), (1, "T2u")],
                [(1, "A1u"), (1, "Eu"), (1, "T1u"), (1, "T2u")],
            ],
            [
                [(1, "A1u")],
                [(1, "A2u")],
                [(1, "Eu")],
                [(1, "T1u")],
                [(1, "T2u")],
                [(1, "A1g")],
                [(1, "A2g")],
                [(1, "Eg")],
                [(1, "T1g")],
                [(1, "T2g")],
            ],
            [
                [(1, "A2u")],
                [(1, "A1u")],
                [(1, "Eu")],
                [(1, "T2u")],
                [(1, "T1u")],
                [(1, "A2g")],
                [(1, "A1g")],
                [(1, "Eg")],
                [(1, "T2g")],
                [(1, "T1g")],
            ],
            [
                [(1, "Eu")],
                [(1, "Eu")],
                [(1, "A1u"), (1, "A2u"), (1, "Eu")],
                [(1, "T1u"), (1, "T2u")],
                [(1, "T1u"), (1, "T2u")],
                [(1, "Eg")],
                [(1, "Eg")],
                [(1, "A1g"), (1, "Eg")],
                [(1, "T1g"), (1, "T2g")],
                [(1, "T1g"), (1, "T2g")],
            ],
            [
                [(1, "T1u")],
                [(1, "T2u")],
                [(1, "T1u"), (1, "T2u")],
                [(1, "A1u"), (1, "Eu"), (1, "T1u"), (1, "T2u")],
                [(1, "A2u"), (1, "Eu"), (1, "T1u"), (1, "T2u")],
                [(1, "T1g")],
                [(1, "T2g")],
                [(1, "T1g"), (1, "T2g")],
                [(1, "A1g"), (1, "Eg"), (1, "T2g")],
                [(1, "A2g"), (1, "Eg"), (1, "T1g"), (1, "T2g")],
            ],
            [
                [(1, "T2u")],
                [(1, "T1u")],
                [(1, "T1u"), (1, "T2u")],
                [(1, "A2u"), (1, "Eu"), (1, "T1u"), (1, "T2u")],
                [(1, "A1u"), (1, "Eu"), (1, "T1u"), (1, "T2u")],
                [(1, "T2g")],
                [(1, "T1g")],
                [(1, "T1g"), (1, "T2g")],
                [(1, "A2g"), (1, "Eg"), (1, "T1g"), (1, "T2g")],
                [(1, "A1g"), (1, "Eg"), (1, "T2g")],
            ],
        ],
        [[], [], [(1, "A2g")], [(1, "T1g")], [(1, "T1g")], [], [], [(1, "A2g")], [(1, "T1g")], [(1, "T1g")]],
    ),
}
