"""
data of point-group harmonics (polar).
{ tag_harmonics: data }
    data = ( tesseral_harmonics ex., cartesian ex., unitary matrix in descending order, [l,l-1,...,-l] )
Ea and Eb are promoted to E 0:(Ea+Eb)/sqrt(2), 1:(Ea-Eb)/sqrt(2)i.
"""
_data_harmonics_polar_real = {
    "C4": {
        "Qh(0,A,,)": ("C0", "1", "[1]"),
        "Qh(1,A,,)": ("C0", "z", "[0,1,0]"),
        "Qh(1,E,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(1,E,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(2,A,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(2,B,1,)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(2,B,2,)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Qh(2,E,,0)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(2,E,,1)": ("-C1", "-sqrt(3)*x*z", "[0,sqrt(2)/2,0,-sqrt(2)/2,0]"),
        "Qh(3,A,,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(3,B,1,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(3,B,2,)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(3,E,1,0)": (
            "-sqrt(6)*C1/4+sqrt(10)*C3/4",
            "x*(2*x**2-3*y**2-3*z**2)/2",
            "[-sqrt(5)/4,0,sqrt(3)/4,0,-sqrt(3)/4,0,sqrt(5)/4]",
        ),
        "Qh(3,E,1,1)": (
            "-sqrt(6)*S1/4-sqrt(10)*S3/4",
            "y*(-3*x**2+2*y**2-3*z**2)/2",
            "[-sqrt(5)*I/4,0,-sqrt(3)*I/4,0,-sqrt(3)*I/4,0,-sqrt(5)*I/4]",
        ),
        "Qh(3,E,2,0)": (
            "-sqrt(10)*C1/4-sqrt(6)*C3/4",
            "sqrt(15)*x*(y**2-z**2)/2",
            "[sqrt(3)/4,0,sqrt(5)/4,0,-sqrt(5)/4,0,-sqrt(3)/4]",
        ),
        "Qh(3,E,2,1)": (
            "-sqrt(10)*S1/4+sqrt(6)*S3/4",
            "sqrt(15)*y*(x**2-z**2)/2",
            "[sqrt(3)*I/4,0,-sqrt(5)*I/4,0,-sqrt(5)*I/4,0,sqrt(3)*I/4]",
        ),
        "Qh(4,A,1,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Qh(4,A,2,)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "-sqrt(15)*(x**4-12*x**2*y**2+6*x**2*z**2+y**4+6*y**2*z**2-2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Qh(4,A,3,)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(4,B,1,)": ("-C2", "sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Qh(4,B,2,)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(4,E,1,0)": (
            "sqrt(2)*(-sqrt(7)*S1-S3)/4",
            "sqrt(35)*y*z*(y**2-z**2)/2",
            "[0,-I/4,0,-sqrt(7)*I/4,0,-sqrt(7)*I/4,0,-I/4,0]",
        ),
        "Qh(4,E,1,1)": ("sqrt(14)*C1/4-sqrt(2)*C3/4", "sqrt(35)*x*z*(-x**2+z**2)/2", "[0,1/4,0,-sqrt(7)/4,0,sqrt(7)/4,0,-1/4,0]"),
        "Qh(4,E,2,0)": (
            "sqrt(2)*(-S1+sqrt(7)*S3)/4",
            "sqrt(5)*y*z*(6*x**2-y**2-z**2)/2",
            "[0,sqrt(7)*I/4,0,-I/4,0,-I/4,0,sqrt(7)*I/4,0]",
        ),
        "Qh(4,E,2,1)": (
            "sqrt(2)*C1/4+sqrt(14)*C3/4",
            "sqrt(5)*x*z*(x**2-6*y**2+z**2)/2",
            "[0,-sqrt(7)/4,0,-1/4,0,1/4,0,sqrt(7)/4,0]",
        ),
        "Qh(5,A,1,)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(5,A,2,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(5,A,3,)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(5,B,1,)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(5,B,2,)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(5,E,1,0)": (
            "sqrt(15)*C1/8-sqrt(70)*C3/16+3*sqrt(14)*C5/16",
            "x*(8*x**4-40*x**2*y**2-40*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/8",
            "[-3*sqrt(7)/16,0,sqrt(35)/16,0,-sqrt(30)/16,0,sqrt(30)/16,0,-sqrt(35)/16,0,3*sqrt(7)/16]",
        ),
        "Qh(5,E,1,1)": (
            "sqrt(15)*S1/8+sqrt(70)*S3/16+3*sqrt(14)*S5/16",
            "y*(15*x**4-40*x**2*y**2+30*x**2*z**2+8*y**4-40*y**2*z**2+15*z**4)/8",
            "[3*sqrt(7)*I/16,0,sqrt(35)*I/16,0,sqrt(30)*I/16,0,sqrt(30)*I/16,0,sqrt(35)*I/16,0,3*sqrt(7)*I/16]",
        ),
        "Qh(5,E,2,0)": (
            "sqrt(2)*(sqrt(42)*C1+9*C3+sqrt(5)*C5)/16",
            "3*sqrt(35)*x*(y**4-6*y**2*z**2+z**4)/8",
            "[-sqrt(5)/16,0,-9/16,0,-sqrt(42)/16,0,sqrt(42)/16,0,9/16,0,sqrt(5)/16]",
        ),
        "Qh(5,E,2,1)": (
            "sqrt(2)*(sqrt(42)*S1-9*S3+sqrt(5)*S5)/16",
            "3*sqrt(35)*y*(x**4-6*x**2*z**2+z**4)/8",
            "[sqrt(5)*I/16,0,-9*I/16,0,sqrt(42)*I/16,0,sqrt(42)*I/16,0,-9*I/16,0,sqrt(5)*I/16]",
        ),
        "Qh(5,E,3,0)": (
            "sqrt(7)*C1/4-sqrt(6)*C3/8-sqrt(30)*C5/8",
            "sqrt(105)*x*(2*x**2*y**2-2*x**2*z**2-y**4+z**4)/4",
            "[sqrt(15)/8,0,sqrt(3)/8,0,-sqrt(14)/8,0,sqrt(14)/8,0,-sqrt(3)/8,0,-sqrt(15)/8]",
        ),
        "Qh(5,E,3,1)": (
            "sqrt(7)*S1/4+sqrt(6)*S3/8-sqrt(30)*S5/8",
            "sqrt(105)*y*(-x**4+2*x**2*y**2-2*y**2*z**2+z**4)/4",
            "[-sqrt(15)*I/8,0,sqrt(3)*I/8,0,sqrt(14)*I/8,0,sqrt(14)*I/8,0,sqrt(3)*I/8,0,-sqrt(15)*I/8]",
        ),
        "Qh(6,A,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Qh(6,A,2,)": (
            "sqrt(14)*C0/4+sqrt(2)*C4/4",
            "-sqrt(14)*(x**6-15*x**4*z**2+15*x**2*z**4+y**6-15*y**4*z**2+15*y**2*z**4-2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Qh(6,A,3,)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(6,B,1,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Qh(6,B,2,)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x-y)*(x+y)*(x**4-9*x**2*y**2-5*x**2*z**2+y**4-5*y**2*z**2+5*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Qh(6,B,3,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(6,B,4,)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(6,E,1,0)": (
            "sqrt(3)*S1/4-sqrt(30)*S3/8-sqrt(22)*S5/8",
            "3*sqrt(7)*y*z*(10*x**2*y**2-10*x**2*z**2-y**4+z**4)/4",
            "[0,-sqrt(11)*I/8,0,-sqrt(15)*I/8,0,sqrt(6)*I/8,0,sqrt(6)*I/8,0,-sqrt(15)*I/8,0,-sqrt(11)*I/8,0]",
        ),
        "Qh(6,E,1,1)": (
            "-sqrt(3)*C1/4-sqrt(30)*C3/8+sqrt(22)*C5/8",
            "3*sqrt(7)*x*z*(x**4-10*x**2*y**2+10*y**2*z**2-z**4)/4",
            "[0,-sqrt(11)/8,0,sqrt(15)/8,0,sqrt(6)/8,0,-sqrt(6)/8,0,-sqrt(15)/8,0,sqrt(11)/8,0]",
        ),
        "Qh(6,E,2,0)": (
            "3*sqrt(22)*S1/16+sqrt(55)*S3/16+sqrt(3)*S5/16",
            "sqrt(462)*y*z*(3*y**4-10*y**2*z**2+3*z**4)/16",
            "[0,sqrt(6)*I/32,0,sqrt(110)*I/32,0,3*sqrt(11)*I/16,0,3*sqrt(11)*I/16,0,sqrt(110)*I/32,0,sqrt(6)*I/32,0]",
        ),
        "Qh(6,E,2,1)": (
            "-3*sqrt(22)*C1/16+sqrt(55)*C3/16-sqrt(3)*C5/16",
            "sqrt(462)*x*z*(-3*x**4+10*x**2*z**2-3*z**4)/16",
            "[0,sqrt(6)/32,0,-sqrt(110)/32,0,3*sqrt(11)/16,0,-3*sqrt(11)/16,0,sqrt(110)/32,0,-sqrt(6)/32,0]",
        ),
        "Qh(6,E,3,0)": (
            "sqrt(10)*S1/16-9*S3/16+sqrt(165)*S5/16",
            "sqrt(210)*y*z*(16*x**4-16*x**2*y**2-16*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,sqrt(330)*I/32,0,-9*sqrt(2)*I/32,0,sqrt(5)*I/16,0,sqrt(5)*I/16,0,-9*sqrt(2)*I/32,0,sqrt(330)*I/32,0]",
        ),
        "Qh(6,E,3,1)": (
            "-sqrt(10)*C1/16-9*C3/16-sqrt(165)*C5/16",
            "sqrt(210)*x*z*(-x**4+16*x**2*y**2-2*x**2*z**2-16*y**4+16*y**2*z**2-z**4)/16",
            "[0,sqrt(330)/32,0,9*sqrt(2)/32,0,sqrt(5)/16,0,-sqrt(5)/16,0,-9*sqrt(2)/32,0,-sqrt(330)/32,0]",
        ),
        "Qh(7,A,1,)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(7,A,2,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(7,A,3,)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(7,B,1,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Qh(7,B,2,)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "-sqrt(77)*x*y*z*(3*x**4-20*x**2*y**2+10*x**2*z**2+3*y**4+10*y**2*z**2-6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Qh(7,B,3,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(7,B,4,)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(7,E,1,0)": (
            "-5*sqrt(7)*C1/32+3*sqrt(21)*C3/32-sqrt(231)*C5/32+sqrt(429)*C7/32",
            "x*(16*x**6-168*x**4*y**2-168*x**4*z**2+210*x**2*y**4+420*x**2*y**2*z**2+210*x**2*z**4-35*y**6-105*y**4*z**2-105*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)/64,0,sqrt(462)/64,0,-3*sqrt(42)/64,0,5*sqrt(14)/64,0,-5*sqrt(14)/64,0,3*sqrt(42)/64,0,-sqrt(462)/64,0,sqrt(858)/64]",
        ),
        "Qh(7,E,1,1)": (
            "-5*sqrt(7)*S1/32-3*sqrt(21)*S3/32-sqrt(231)*S5/32-sqrt(429)*S7/32",
            "y*(-35*x**6+210*x**4*y**2-105*x**4*z**2-168*x**2*y**4+420*x**2*y**2*z**2-105*x**2*z**4+16*y**6-168*y**4*z**2+210*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)*I/64,0,-sqrt(462)*I/64,0,-3*sqrt(42)*I/64,0,-5*sqrt(14)*I/64,0,-5*sqrt(14)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(462)*I/64,0,-sqrt(858)*I/64]",
        ),
        "Qh(7,E,2,0)": (
            "-3*sqrt(33)*C1/32-sqrt(11)*C3/32+25*C5/32+sqrt(91)*C7/32",
            "sqrt(231)*x*(10*x**2*y**4-60*x**2*y**2*z**2+10*x**2*z**4-3*y**6+15*y**4*z**2+15*y**2*z**4-3*z**6)/16",
            "[-sqrt(182)/64,0,-25*sqrt(2)/64,0,sqrt(22)/64,0,3*sqrt(66)/64,0,-3*sqrt(66)/64,0,-sqrt(22)/64,0,25*sqrt(2)/64,0,sqrt(182)/64]",
        ),
        "Qh(7,E,2,1)": (
            "-3*sqrt(33)*S1/32+sqrt(11)*S3/32+25*S5/32-sqrt(91)*S7/32",
            "sqrt(231)*y*(-3*x**6+10*x**4*y**2+15*x**4*z**2-60*x**2*y**2*z**2+15*x**2*z**4+10*y**2*z**4-3*z**6)/16",
            "[-sqrt(182)*I/64,0,25*sqrt(2)*I/64,0,sqrt(22)*I/64,0,-3*sqrt(66)*I/64,0,-3*sqrt(66)*I/64,0,sqrt(22)*I/64,0,25*sqrt(2)*I/64,0,-sqrt(182)*I/64]",
        ),
        "Qh(7,E,3,0)": (
            "-sqrt(858)*C1/64-3*sqrt(286)*C3/64-5*sqrt(26)*C5/64-sqrt(14)*C7/64",
            "sqrt(6006)*x*(y**6-15*y**4*z**2+15*y**2*z**4-z**6)/32",
            "[sqrt(7)/64,0,5*sqrt(13)/64,0,3*sqrt(143)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-3*sqrt(143)/64,0,-5*sqrt(13)/64,0,-sqrt(7)/64]",
        ),
        "Qh(7,E,3,1)": (
            "-sqrt(858)*S1/64+3*sqrt(286)*S3/64-5*sqrt(26)*S5/64+sqrt(14)*S7/64",
            "sqrt(6006)*y*(x**6-15*x**4*z**2+15*x**2*z**4-z**6)/32",
            "[sqrt(7)*I/64,0,-5*sqrt(13)*I/64,0,3*sqrt(143)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,3*sqrt(143)*I/64,0,-5*sqrt(13)*I/64,0,sqrt(7)*I/64]",
        ),
        "Qh(7,E,4,0)": (
            "sqrt(2)*(-15*sqrt(3)*C1+19*C3-sqrt(11)*C5-sqrt(1001)*C7)/64",
            "sqrt(42)*x*(48*x**4*y**2-48*x**4*z**2-80*x**2*y**4+80*x**2*z**4+15*y**6+15*y**4*z**2-15*y**2*z**4-15*z**6)/32",
            "[sqrt(1001)/64,0,sqrt(11)/64,0,-19/64,0,15*sqrt(3)/64,0,-15*sqrt(3)/64,0,19/64,0,-sqrt(11)/64,0,-sqrt(1001)/64]",
        ),
        "Qh(7,E,4,1)": (
            "-15*sqrt(6)*S1/64-19*sqrt(2)*S3/64-sqrt(22)*S5/64+sqrt(2002)*S7/64",
            "sqrt(42)*y*(15*x**6-80*x**4*y**2+15*x**4*z**2+48*x**2*y**4-15*x**2*z**4-48*y**4*z**2+80*y**2*z**4-15*z**6)/32",
            "[sqrt(1001)*I/64,0,-sqrt(11)*I/64,0,-19*I/64,0,-15*sqrt(3)*I/64,0,-15*sqrt(3)*I/64,0,-19*I/64,0,-sqrt(11)*I/64,0,sqrt(1001)*I/64]",
        ),
        "Qh(8,A,1,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Qh(8,A,2,)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Qh(8,A,3,)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Qh(8,A,4,)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(8,A,5,)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(8,B,1,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(8,B,2,)": (
            "C2",
            "-3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(8,B,3,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(8,B,4,)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(8,E,1,0)": (
            "-sqrt(715)*S1/32-sqrt(273)*S3/32-sqrt(35)*S5/32-S7/32",
            "3*sqrt(715)*y*z*(y**6-7*y**4*z**2+7*y**2*z**4-z**6)/16",
            "[0,-sqrt(2)*I/64,0,-sqrt(70)*I/64,0,-sqrt(546)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(546)*I/64,0,-sqrt(70)*I/64,0,-sqrt(2)*I/64,0]",
        ),
        "Qh(8,E,1,1)": (
            "sqrt(715)*C1/32-sqrt(273)*C3/32+sqrt(35)*C5/32-C7/32",
            "3*sqrt(715)*x*z*(-x**6+7*x**4*z**2-7*x**2*z**4+z**6)/16",
            "[0,sqrt(2)/64,0,-sqrt(70)/64,0,sqrt(546)/64,0,-sqrt(1430)/64,0,sqrt(1430)/64,0,-sqrt(546)/64,0,sqrt(70)/64,0,-sqrt(2)/64,0]",
        ),
        "Qh(8,E,2,0)": (
            "-sqrt(77)*S1/32+5*sqrt(15)*S3/32-3*sqrt(13)*S5/32-sqrt(455)*S7/32",
            "3*sqrt(77)*y*z*(40*x**4*y**2-40*x**4*z**2-24*x**2*y**4+24*x**2*z**4+y**6+y**4*z**2-y**2*z**4-z**6)/16",
            "[0,-sqrt(910)*I/64,0,-3*sqrt(26)*I/64,0,5*sqrt(30)*I/64,0,-sqrt(154)*I/64,0,-sqrt(154)*I/64,0,5*sqrt(30)*I/64,0,-3*sqrt(26)*I/64,0,-sqrt(910)*I/64,0]",
        ),
        "Qh(8,E,2,1)": (
            "sqrt(77)*C1/32+5*sqrt(15)*C3/32+3*sqrt(13)*C5/32-sqrt(455)*C7/32",
            "3*sqrt(77)*x*z*(-x**6+24*x**4*y**2-x**4*z**2-40*x**2*y**4+x**2*z**4+40*y**4*z**2-24*y**2*z**4+z**6)/16",
            "[0,sqrt(910)/64,0,-3*sqrt(26)/64,0,-5*sqrt(30)/64,0,-sqrt(154)/64,0,sqrt(154)/64,0,5*sqrt(30)/64,0,3*sqrt(26)/64,0,-sqrt(910)/64,0]",
        ),
        "Qh(8,E,3,0)": (
            "-sqrt(858)*S1/64+sqrt(910)*S3/64+7*sqrt(42)*S5/64+3*sqrt(30)*S7/64",
            "sqrt(858)*y*z*(42*x**2*y**4-140*x**2*y**2*z**2+42*x**2*z**4-3*y**6+7*y**4*z**2+7*y**2*z**4-3*z**6)/32",
            "[0,3*sqrt(15)*I/64,0,7*sqrt(21)*I/64,0,sqrt(455)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(455)*I/64,0,7*sqrt(21)*I/64,0,3*sqrt(15)*I/64,0]",
        ),
        "Qh(8,E,3,1)": (
            "sqrt(858)*C1/64+sqrt(910)*C3/64-7*sqrt(42)*C5/64+3*sqrt(30)*C7/64",
            "sqrt(858)*x*z*(3*x**6-42*x**4*y**2-7*x**4*z**2+140*x**2*y**2*z**2-7*x**2*z**4-42*y**2*z**4+3*z**6)/32",
            "[0,-3*sqrt(15)/64,0,7*sqrt(21)/64,0,-sqrt(455)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(455)/64,0,-7*sqrt(21)/64,0,3*sqrt(15)/64,0]",
        ),
        "Qh(8,E,4,0)": (
            "-sqrt(70)*S1/64+3*sqrt(66)*S3/64-sqrt(1430)*S5/64+sqrt(2002)*S7/64",
            "3*sqrt(70)*y*z*(32*x**6-80*x**4*y**2-80*x**4*z**2+30*x**2*y**4+60*x**2*y**2*z**2+30*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,sqrt(1001)*I/64,0,-sqrt(715)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(35)*I/64,0,-sqrt(35)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(715)*I/64,0,sqrt(1001)*I/64,0]",
        ),
        "Qh(8,E,4,1)": (
            "sqrt(70)*C1/64+3*sqrt(66)*C3/64+sqrt(1430)*C5/64+sqrt(2002)*C7/64",
            "3*sqrt(70)*x*z*(x**6-30*x**4*y**2+3*x**4*z**2+80*x**2*y**4-60*x**2*y**2*z**2+3*x**2*z**4-32*y**6+80*y**4*z**2-30*y**2*z**4+z**6)/32",
            "[0,-sqrt(1001)/64,0,-sqrt(715)/64,0,-3*sqrt(33)/64,0,-sqrt(35)/64,0,sqrt(35)/64,0,3*sqrt(33)/64,0,sqrt(715)/64,0,sqrt(1001)/64,0]",
        ),
        "Qh(9,A,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Qh(9,A,2,)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(x-y)*(x+y)*(3*x**4-11*x**2*y**2-7*x**2*z**2+3*y**4-7*y**2*z**2+7*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Qh(9,A,3,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,A,4,)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,A,5,)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(9,B,1,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Qh(9,B,2,)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Qh(9,B,3,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,B,4,)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E,1,0)": (
            "21*sqrt(5)*C1/128-sqrt(2310)*C3/128+3*sqrt(286)*C5/128-3*sqrt(1430)*C7/256+sqrt(24310)*C9/256",
            "x*(128*x**8-2304*x**6*y**2-2304*x**6*z**2+6048*x**4*y**4+12096*x**4*y**2*z**2+6048*x**4*z**4-3360*x**2*y**6-10080*x**2*y**4*z**2-10080*x**2*y**2*z**4-3360*x**2*z**6+315*y**8+1260*y**6*z**2+1890*y**4*z**4+1260*y**2*z**6+315*z**8)/128",
            "[-sqrt(12155)/256,0,3*sqrt(715)/256,0,-3*sqrt(143)/128,0,sqrt(1155)/128,0,-21*sqrt(10)/256,0,21*sqrt(10)/256,0,-sqrt(1155)/128,0,3*sqrt(143)/128,0,-3*sqrt(715)/256,0,sqrt(12155)/256]",
        ),
        "Qh(9,E,1,1)": (
            "21*sqrt(5)*S1/128+sqrt(2310)*S3/128+3*sqrt(286)*S5/128+3*sqrt(1430)*S7/256+sqrt(24310)*S9/256",
            "y*(315*x**8-3360*x**6*y**2+1260*x**6*z**2+6048*x**4*y**4-10080*x**4*y**2*z**2+1890*x**4*z**4-2304*x**2*y**6+12096*x**2*y**4*z**2-10080*x**2*y**2*z**4+1260*x**2*z**6+128*y**8-2304*y**6*z**2+6048*y**4*z**4-3360*y**2*z**6+315*z**8)/128",
            "[sqrt(12155)*I/256,0,3*sqrt(715)*I/256,0,3*sqrt(143)*I/128,0,sqrt(1155)*I/128,0,21*sqrt(10)*I/256,0,21*sqrt(10)*I/256,0,sqrt(1155)*I/128,0,3*sqrt(143)*I/128,0,3*sqrt(715)*I/256,0,sqrt(12155)*I/256]",
        ),
        "Qh(9,E,2,0)": (
            "sqrt(2)*(sqrt(4862)*C1+2*sqrt(4641)*C3+10*sqrt(85)*C5+7*sqrt(17)*C7+3*C9)/256",
            "3*sqrt(12155)*x*(y**8-28*y**6*z**2+70*y**4*z**4-28*y**2*z**6+z**8)/128",
            "[-3/256,0,-7*sqrt(17)/256,0,-5*sqrt(85)/128,0,-sqrt(4641)/128,0,-sqrt(4862)/256,0,sqrt(4862)/256,0,sqrt(4641)/128,0,5*sqrt(85)/128,0,7*sqrt(17)/256,0,3/256]",
        ),
        "Qh(9,E,2,1)": (
            "sqrt(2)*(sqrt(4862)*S1-2*sqrt(4641)*S3+10*sqrt(85)*S5-7*sqrt(17)*S7+3*S9)/256",
            "3*sqrt(12155)*y*(x**8-28*x**6*z**2+70*x**4*z**4-28*x**2*z**6+z**8)/128",
            "[3*I/256,0,-7*sqrt(17)*I/256,0,5*sqrt(85)*I/128,0,-sqrt(4641)*I/128,0,sqrt(4862)*I/256,0,sqrt(4862)*I/256,0,-sqrt(4641)*I/128,0,5*sqrt(85)*I/128,0,-7*sqrt(17)*I/256,0,3*I/256]",
        ),
        "Qh(9,E,3,0)": (
            "sqrt(1001)*C1/64-sqrt(78)*C3/64-3*sqrt(70)*C5/64+23*sqrt(14)*C7/128+3*sqrt(238)*C9/128",
            "3*sqrt(5005)*x*(8*x**4*y**4-48*x**4*y**2*z**2+8*x**4*z**4-8*x**2*y**6+40*x**2*y**4*z**2+40*x**2*y**2*z**4-8*x**2*z**6+y**8-4*y**6*z**2-10*y**4*z**4-4*y**2*z**6+z**8)/64",
            "[-3*sqrt(119)/128,0,-23*sqrt(7)/128,0,3*sqrt(35)/64,0,sqrt(39)/64,0,-sqrt(2002)/128,0,sqrt(2002)/128,0,-sqrt(39)/64,0,-3*sqrt(35)/64,0,23*sqrt(7)/128,0,3*sqrt(119)/128]",
        ),
        "Qh(9,E,3,1)": (
            "sqrt(1001)*S1/64+sqrt(78)*S3/64-3*sqrt(70)*S5/64-23*sqrt(14)*S7/128+3*sqrt(238)*S9/128",
            "3*sqrt(5005)*y*(x**8-8*x**6*y**2-4*x**6*z**2+8*x**4*y**4+40*x**4*y**2*z**2-10*x**4*z**4-48*x**2*y**4*z**2+40*x**2*y**2*z**4-4*x**2*z**6+8*y**4*z**4-8*y**2*z**6+z**8)/64",
            "[3*sqrt(119)*I/128,0,-23*sqrt(7)*I/128,0,-3*sqrt(35)*I/64,0,sqrt(39)*I/64,0,sqrt(2002)*I/128,0,sqrt(2002)*I/128,0,sqrt(39)*I/64,0,-3*sqrt(35)*I/64,0,-23*sqrt(7)*I/128,0,3*sqrt(119)*I/128]",
        ),
        "Qh(9,E,4,0)": (
            "sqrt(858)*C1/64+sqrt(91)*C3/32-5*sqrt(15)*C5/32-21*sqrt(3)*C7/64-sqrt(51)*C9/64",
            "sqrt(4290)*x*(14*x**2*y**6-210*x**2*y**4*z**2+210*x**2*y**2*z**4-14*x**2*z**6-3*y**8+42*y**6*z**2-42*y**2*z**6+3*z**8)/64",
            "[sqrt(102)/128,0,21*sqrt(6)/128,0,5*sqrt(30)/64,0,-sqrt(182)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(182)/64,0,-5*sqrt(30)/64,0,-21*sqrt(6)/128,0,-sqrt(102)/128]",
        ),
        "Qh(9,E,4,1)": (
            "sqrt(858)*S1/64-sqrt(91)*S3/32-5*sqrt(15)*S5/32+21*sqrt(3)*S7/64-sqrt(51)*S9/64",
            "sqrt(4290)*y*(-3*x**8+14*x**6*y**2+42*x**6*z**2-210*x**4*y**2*z**2+210*x**2*y**2*z**4-42*x**2*z**6-14*y**2*z**6+3*z**8)/64",
            "[-sqrt(102)*I/128,0,21*sqrt(6)*I/128,0,-5*sqrt(30)*I/64,0,-sqrt(182)*I/64,0,sqrt(429)*I/64,0,sqrt(429)*I/64,0,-sqrt(182)*I/64,0,-5*sqrt(30)*I/64,0,21*sqrt(6)*I/128,0,-sqrt(102)*I/128]",
        ),
        "Qh(9,E,5,0)": (
            "7*sqrt(22)*C1/64-3*sqrt(21)*C3/32+sqrt(65)*C5/32+sqrt(13)*C7/64-3*sqrt(221)*C9/64",
            "3*sqrt(110)*x*(32*x**6*y**2-32*x**6*z**2-112*x**4*y**4+112*x**4*z**4+70*x**2*y**6+70*x**2*y**4*z**2-70*x**2*y**2*z**4-70*x**2*z**6-7*y**8-14*y**6*z**2+14*y**2*z**6+7*z**8)/64",
            "[3*sqrt(442)/128,0,-sqrt(26)/128,0,-sqrt(130)/64,0,3*sqrt(42)/64,0,-7*sqrt(11)/64,0,7*sqrt(11)/64,0,-3*sqrt(42)/64,0,sqrt(130)/64,0,sqrt(26)/128,0,-3*sqrt(442)/128]",
        ),
        "Qh(9,E,5,1)": (
            "7*sqrt(22)*S1/64+3*sqrt(21)*S3/32+sqrt(65)*S5/32-sqrt(13)*S7/64-3*sqrt(221)*S9/64",
            "3*sqrt(110)*y*(-7*x**8+70*x**6*y**2-14*x**6*z**2-112*x**4*y**4+70*x**4*y**2*z**2+32*x**2*y**6-70*x**2*y**2*z**4+14*x**2*z**6-32*y**6*z**2+112*y**4*z**4-70*y**2*z**6+7*z**8)/64",
            "[-3*sqrt(442)*I/128,0,-sqrt(26)*I/128,0,sqrt(130)*I/64,0,3*sqrt(42)*I/64,0,7*sqrt(11)*I/64,0,7*sqrt(11)*I/64,0,3*sqrt(42)*I/64,0,sqrt(130)*I/64,0,-sqrt(26)*I/128,0,-3*sqrt(442)*I/128]",
        ),
        "Qh(10,A,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Qh(10,A,2,)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "-sqrt(420189)*(22*x**10+45*x**8*y**2-1035*x**8*z**2-105*x**6*y**4-630*x**6*y**2*z**2+4935*x**6*z**4-105*x**4*y**6+3150*x**4*y**4*z**2-1575*x**4*y**2*z**4-4830*x**4*z**6+45*x**2*y**8-630*x**2*y**6*z**2-1575*x**2*y**4*z**4+1260*x**2*y**2*z**6+990*x**2*z**8+22*y**10-1035*y**8*z**2+4935*y**6*z**4-4830*y**4*z**6+990*y**2*z**8-44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Qh(10,A,3,)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "-sqrt(3213210)*(3*x**10-96*x**8*y**2-39*x**8*z**2+224*x**6*y**4+1344*x**6*y**2*z**2-42*x**6*z**4+224*x**4*y**6-6720*x**4*y**4*z**2+3360*x**4*y**2*z**4-182*x**4*z**6-96*x**2*y**8+1344*x**2*y**6*z**2+3360*x**2*y**4*z**4-2688*x**2*y**2*z**6+135*x**2*z**8+3*y**10-39*y**8*z**2-42*y**6*z**4-182*y**4*z**6+135*y**2*z**8-6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Qh(10,A,4,)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(10,A,5,)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(10,B,1,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Qh(10,B,2,)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(x-y)*(x+y)*(22*x**8-653*x**6*y**2-315*x**6*z**2+2602*x**4*y**4-945*x**4*y**2*z**2+1575*x**4*z**4-653*x**2*y**6-945*x**2*y**4*z**2+3150*x**2*y**2*z**4-1680*x**2*z**6+22*y**8-315*y**6*z**2+1575*y**4*z**4-1680*y**2*z**6+360*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Qh(10,B,3,)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(x-y)*(x+y)*(9*x**8-165*x**6*y**2-231*x**6*z**2-25*x**4*y**4+3801*x**4*y**2*z**2+406*x**4*z**4-165*x**2*y**6+3801*x**2*y**4*z**2-9674*x**2*y**2*z**4+266*x**2*z**6+9*y**8-231*y**6*z**2+406*y**4*z**4+266*y**2*z**6-57*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Qh(10,B,4,)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(10,B,5,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,B,6,)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E,1,0)": (
            "sqrt(221)*S1/32-sqrt(102)*S3/32-sqrt(510)*S5/32-11*sqrt(6)*S7/64-sqrt(38)*S9/64",
            "sqrt(12155)*y*z*(18*x**2*y**6-126*x**2*y**4*z**2+126*x**2*y**2*z**4-18*x**2*z**6-y**8+6*y**6*z**2-6*y**2*z**6+z**8)/32",
            "[0,-sqrt(19)*I/64,0,-11*sqrt(3)*I/64,0,-sqrt(255)*I/32,0,-sqrt(51)*I/32,0,sqrt(442)*I/64,0,sqrt(442)*I/64,0,-sqrt(51)*I/32,0,-sqrt(255)*I/32,0,-11*sqrt(3)*I/64,0,-sqrt(19)*I/64,0]",
        ),
        "Qh(10,E,1,1)": (
            "-sqrt(221)*C1/32-sqrt(102)*C3/32+sqrt(510)*C5/32-11*sqrt(6)*C7/64+sqrt(38)*C9/64",
            "sqrt(12155)*x*z*(x**8-18*x**6*y**2-6*x**6*z**2+126*x**4*y**2*z**2-126*x**2*y**2*z**4+6*x**2*z**6+18*y**2*z**6-z**8)/32",
            "[0,-sqrt(19)/64,0,11*sqrt(3)/64,0,-sqrt(255)/32,0,sqrt(51)/32,0,sqrt(442)/64,0,-sqrt(442)/64,0,-sqrt(51)/32,0,sqrt(255)/32,0,-11*sqrt(3)/64,0,sqrt(19)/64,0]",
        ),
        "Qh(10,E,2,0)": (
            "sqrt(2)*(sqrt(78)*S1-22*S3+10*sqrt(5)*S5-sqrt(17)*S7-sqrt(969)*S9)/64",
            "sqrt(2145)*y*z*(112*x**6*y**2-112*x**6*z**2-168*x**4*y**4+168*x**4*z**4+42*x**2*y**6+42*x**2*y**4*z**2-42*x**2*y**2*z**4-42*x**2*z**6-y**8-2*y**6*z**2+2*y**2*z**6+z**8)/32",
            "[0,-sqrt(969)*I/64,0,-sqrt(17)*I/64,0,5*sqrt(5)*I/32,0,-11*I/32,0,sqrt(78)*I/64,0,sqrt(78)*I/64,0,-11*I/32,0,5*sqrt(5)*I/32,0,-sqrt(17)*I/64,0,-sqrt(969)*I/64,0]",
        ),
        "Qh(10,E,2,1)": (
            "-sqrt(2)*(sqrt(78)*C1+22*C3+10*sqrt(5)*C5+sqrt(17)*C7-sqrt(969)*C9)/64",
            "sqrt(2145)*x*z*(x**8-42*x**6*y**2+2*x**6*z**2+168*x**4*y**4-42*x**4*y**2*z**2-112*x**2*y**6+42*x**2*y**2*z**4-2*x**2*z**6+112*y**6*z**2-168*y**4*z**4+42*y**2*z**6-z**8)/32",
            "[0,-sqrt(969)/64,0,sqrt(17)/64,0,5*sqrt(5)/32,0,11/32,0,sqrt(78)/64,0,-sqrt(78)/64,0,-11/32,0,-5*sqrt(5)/32,0,-sqrt(17)/64,0,sqrt(969)/64,0]",
        ),
        "Qh(10,E,3,0)": (
            "sqrt(41990)*S1/256+sqrt(4845)*S3/128+sqrt(969)*S5/128+sqrt(285)*S7/256+sqrt(5)*S9/256",
            "sqrt(92378)*y*z*(5*y**8-60*y**6*z**2+126*y**4*z**4-60*y**2*z**6+5*z**8)/256",
            "[0,sqrt(10)*I/512,0,sqrt(570)*I/512,0,sqrt(1938)*I/256,0,sqrt(9690)*I/256,0,sqrt(20995)*I/256,0,sqrt(20995)*I/256,0,sqrt(9690)*I/256,0,sqrt(1938)*I/256,0,sqrt(570)*I/512,0,sqrt(10)*I/512,0]",
        ),
        "Qh(10,E,3,1)": (
            "-sqrt(41990)*C1/256+sqrt(4845)*C3/128-sqrt(969)*C5/128+sqrt(285)*C7/256-sqrt(5)*C9/256",
            "sqrt(92378)*x*z*(-5*x**8+60*x**6*z**2-126*x**4*z**4+60*x**2*z**6-5*z**8)/256",
            "[0,sqrt(10)/512,0,-sqrt(570)/512,0,sqrt(1938)/256,0,-sqrt(9690)/256,0,sqrt(20995)/256,0,-sqrt(20995)/256,0,sqrt(9690)/256,0,-sqrt(1938)/256,0,sqrt(570)/512,0,-sqrt(10)/512,0]",
        ),
        "Qh(10,E,4,0)": (
            "9*sqrt(78)*S1/256-69*S3/128-sqrt(5)*S5/128+43*sqrt(17)*S7/256+3*sqrt(969)*S9/256",
            "sqrt(4290)*y*z*(672*x**4*y**4-2240*x**4*y**2*z**2+672*x**4*z**4-288*x**2*y**6+672*x**2*y**4*z**2+672*x**2*y**2*z**4-288*x**2*z**6+9*y**8-12*y**6*z**2-42*y**4*z**4-12*y**2*z**6+9*z**8)/256",
            "[0,3*sqrt(1938)*I/512,0,43*sqrt(34)*I/512,0,-sqrt(10)*I/256,0,-69*sqrt(2)*I/256,0,9*sqrt(39)*I/256,0,9*sqrt(39)*I/256,0,-69*sqrt(2)*I/256,0,-sqrt(10)*I/256,0,43*sqrt(34)*I/512,0,3*sqrt(1938)*I/512,0]",
        ),
        "Qh(10,E,4,1)": (
            "-9*sqrt(78)*C1/256-69*C3/128+sqrt(5)*C5/128+43*sqrt(17)*C7/256-3*sqrt(969)*C9/256",
            "sqrt(4290)*x*z*(-9*x**8+288*x**6*y**2+12*x**6*z**2-672*x**4*y**4-672*x**4*y**2*z**2+42*x**4*z**4+2240*x**2*y**4*z**2-672*x**2*y**2*z**4+12*x**2*z**6-672*y**4*z**4+288*y**2*z**6-9*z**8)/256",
            "[0,3*sqrt(1938)/512,0,-43*sqrt(34)/512,0,-sqrt(10)/256,0,69*sqrt(2)/256,0,9*sqrt(39)/256,0,-9*sqrt(39)/256,0,-69*sqrt(2)/256,0,sqrt(10)/256,0,43*sqrt(34)/512,0,-3*sqrt(1938)/512,0]",
        ),
        "Qh(10,E,5,0)": (
            "7*sqrt(3)*S1/128-7*sqrt(26)*S3/128+5*sqrt(130)*S5/128-7*sqrt(442)*S7/256+sqrt(25194)*S9/256",
            "sqrt(165)*y*z*(384*x**8-1792*x**6*y**2-1792*x**6*z**2+1680*x**4*y**4+3360*x**4*y**2*z**2+1680*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+7*y**8+28*y**6*z**2+42*y**4*z**4+28*y**2*z**6+7*z**8)/128",
            "[0,sqrt(12597)*I/256,0,-7*sqrt(221)*I/256,0,5*sqrt(65)*I/128,0,-7*sqrt(13)*I/128,0,7*sqrt(6)*I/256,0,7*sqrt(6)*I/256,0,-7*sqrt(13)*I/128,0,5*sqrt(65)*I/128,0,-7*sqrt(221)*I/256,0,sqrt(12597)*I/256,0]",
        ),
        "Qh(10,E,5,1)": (
            "-7*sqrt(3)*C1/128-7*sqrt(26)*C3/128-5*sqrt(130)*C5/128-7*sqrt(442)*C7/256-sqrt(25194)*C9/256",
            "sqrt(165)*x*z*(-7*x**8+336*x**6*y**2-28*x**6*z**2-1680*x**4*y**4+1008*x**4*y**2*z**2-42*x**4*z**4+1792*x**2*y**6-3360*x**2*y**4*z**2+1008*x**2*y**2*z**4-28*x**2*z**6-384*y**8+1792*y**6*z**2-1680*y**4*z**4+336*y**2*z**6-7*z**8)/128",
            "[0,sqrt(12597)/256,0,7*sqrt(221)/256,0,5*sqrt(65)/128,0,7*sqrt(13)/128,0,7*sqrt(6)/256,0,-7*sqrt(6)/256,0,-7*sqrt(13)/128,0,-5*sqrt(65)/128,0,-7*sqrt(221)/256,0,-sqrt(12597)/256,0]",
        ),
        "Qh(11,A,1,)": (
            "S8",
            "-sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(11,A,2,)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A,3,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A,4,)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(11,A,5,)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,B,1,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Qh(11,B,2,)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "-sqrt(230945)*x*y*z*(x**8-6*x**6*y**2-6*x**6*z**2+42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2-84*x**2*y**2*z**4+12*x**2*z**6+y**8-6*y**6*z**2+12*y**2*z**6-2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Qh(11,B,3,)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "-sqrt(3003)*x*y*z*(5*x**8-150*x**6*y**2+90*x**6*z**2+336*x**4*y**4-70*x**4*y**2*z**2-168*x**4*z**4-150*x**2*y**6-70*x**2*y**4*z**2+140*x**2*y**2*z**4+60*x**2*z**6+5*y**8+90*y**6*z**2-168*y**4*z**4+60*y**2*z**6-10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Qh(11,B,4,)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(11,B,5,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,B,6,)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,1,0)": (
            "-21*sqrt(66)*C1/512+sqrt(88179)*C11/512+sqrt(30030)*C3/512-15*sqrt(143)*C5/512+sqrt(36465)*C7/512-sqrt(46189)*C9/512",
            "x*(256*x**10-7040*x**8*y**2-7040*x**8*z**2+31680*x**6*y**4+63360*x**6*y**2*z**2+31680*x**6*z**4-36960*x**4*y**6-110880*x**4*y**4*z**2-110880*x**4*y**2*z**4-36960*x**4*z**6+11550*x**2*y**8+46200*x**2*y**6*z**2+69300*x**2*y**4*z**4+46200*x**2*y**2*z**6+11550*x**2*z**8-693*y**10-3465*y**8*z**2-6930*y**6*z**4-6930*y**4*z**6-3465*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)/1024,0,sqrt(92378)/1024,0,-sqrt(72930)/1024,0,15*sqrt(286)/1024,0,-sqrt(15015)/512,0,21*sqrt(33)/512,0,-21*sqrt(33)/512,0,sqrt(15015)/512,0,-15*sqrt(286)/1024,0,sqrt(72930)/1024,0,-sqrt(92378)/1024,0,sqrt(176358)/1024]",
        ),
        "Qh(11,E,1,1)": (
            "-21*sqrt(66)*S1/512-sqrt(88179)*S11/512-sqrt(30030)*S3/512-15*sqrt(143)*S5/512-sqrt(36465)*S7/512-sqrt(46189)*S9/512",
            "y*(-693*x**10+11550*x**8*y**2-3465*x**8*z**2-36960*x**6*y**4+46200*x**6*y**2*z**2-6930*x**6*z**4+31680*x**4*y**6-110880*x**4*y**4*z**2+69300*x**4*y**2*z**4-6930*x**4*z**6-7040*x**2*y**8+63360*x**2*y**6*z**2-110880*x**2*y**4*z**4+46200*x**2*y**2*z**6-3465*x**2*z**8+256*y**10-7040*y**8*z**2+31680*y**6*z**4-36960*y**4*z**6+11550*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(72930)*I/1024,0,-15*sqrt(286)*I/1024,0,-sqrt(15015)*I/512,0,-21*sqrt(33)*I/512,0,-21*sqrt(33)*I/512,0,-sqrt(15015)*I/512,0,-15*sqrt(286)*I/1024,0,-sqrt(72930)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(176358)*I/1024]",
        ),
        "Qh(11,E,2,0)": (
            "-sqrt(41990)*C1/512+sqrt(385)*C11/512-3*sqrt(4522)*C3/512+3*sqrt(4845)*C5/512+77*sqrt(19)*C7/512+39*sqrt(15)*C9/512",
            "sqrt(692835)*x*(6*x**2*y**8-168*x**2*y**6*z**2+420*x**2*y**4*z**4-168*x**2*y**2*z**6+6*x**2*z**8-y**10+27*y**8*z**2-42*y**6*z**4-42*y**4*z**6+27*y**2*z**8-z**10)/256",
            "[-sqrt(770)/1024,0,-39*sqrt(30)/1024,0,-77*sqrt(38)/1024,0,-3*sqrt(9690)/1024,0,3*sqrt(2261)/512,0,sqrt(20995)/512,0,-sqrt(20995)/512,0,-3*sqrt(2261)/512,0,3*sqrt(9690)/1024,0,77*sqrt(38)/1024,0,39*sqrt(30)/1024,0,sqrt(770)/1024]",
        ),
        "Qh(11,E,2,1)": (
            "-sqrt(41990)*S1/512-sqrt(385)*S11/512+3*sqrt(4522)*S3/512+3*sqrt(4845)*S5/512-77*sqrt(19)*S7/512+39*sqrt(15)*S9/512",
            "sqrt(692835)*y*(-x**10+6*x**8*y**2+27*x**8*z**2-168*x**6*y**2*z**2-42*x**6*z**4+420*x**4*y**2*z**4-42*x**4*z**6-168*x**2*y**2*z**6+27*x**2*z**8+6*y**2*z**8-z**10)/256",
            "[-sqrt(770)*I/1024,0,39*sqrt(30)*I/1024,0,-77*sqrt(38)*I/1024,0,3*sqrt(9690)*I/1024,0,3*sqrt(2261)*I/512,0,-sqrt(20995)*I/512,0,-sqrt(20995)*I/512,0,3*sqrt(2261)*I/512,0,3*sqrt(9690)*I/1024,0,-77*sqrt(38)*I/1024,0,39*sqrt(30)*I/1024,0,-sqrt(770)*I/1024]",
        ),
        "Qh(11,E,3,0)": (
            "-5*sqrt(546)*C1/256+sqrt(10659)*C11/256+11*sqrt(30)*C3/256+13*sqrt(7)*C5/256-3*sqrt(1785)*C7/256+3*sqrt(2261)*C9/256",
            "3*sqrt(1001)*x*(80*x**6*y**4-480*x**6*y**2*z**2+80*x**6*z**4-168*x**4*y**6+840*x**4*y**4*z**2+840*x**4*y**2*z**4-168*x**4*z**6+70*x**2*y**8-280*x**2*y**6*z**2-700*x**2*y**4*z**4-280*x**2*y**2*z**6+70*x**2*z**8-5*y**10+15*y**8*z**2+70*y**6*z**4+70*y**4*z**6+15*y**2*z**8-5*z**10)/128",
            "[-sqrt(21318)/512,0,-3*sqrt(4522)/512,0,3*sqrt(3570)/512,0,-13*sqrt(14)/512,0,-11*sqrt(15)/256,0,5*sqrt(273)/256,0,-5*sqrt(273)/256,0,11*sqrt(15)/256,0,13*sqrt(14)/512,0,-3*sqrt(3570)/512,0,3*sqrt(4522)/512,0,sqrt(21318)/512]",
        ),
        "Qh(11,E,3,1)": (
            "-5*sqrt(546)*S1/256-sqrt(10659)*S11/256-11*sqrt(30)*S3/256+13*sqrt(7)*S5/256+3*sqrt(1785)*S7/256+3*sqrt(2261)*S9/256",
            "3*sqrt(1001)*y*(-5*x**10+70*x**8*y**2+15*x**8*z**2-168*x**6*y**4-280*x**6*y**2*z**2+70*x**6*z**4+80*x**4*y**6+840*x**4*y**4*z**2-700*x**4*y**2*z**4+70*x**4*z**6-480*x**2*y**6*z**2+840*x**2*y**4*z**4-280*x**2*y**2*z**6+15*x**2*z**8+80*y**6*z**4-168*y**4*z**6+70*y**2*z**8-5*z**10)/128",
            "[-sqrt(21318)*I/512,0,3*sqrt(4522)*I/512,0,3*sqrt(3570)*I/512,0,13*sqrt(14)*I/512,0,-11*sqrt(15)*I/256,0,-5*sqrt(273)*I/256,0,-5*sqrt(273)*I/256,0,-11*sqrt(15)*I/256,0,13*sqrt(14)*I/512,0,3*sqrt(3570)*I/512,0,3*sqrt(4522)*I/512,0,-sqrt(21318)*I/512]",
        ),
        "Qh(11,E,4,0)": (
            "-sqrt(29393)*C1/512-sqrt(22)*C11/1024-9*sqrt(1615)*C3/512-5*sqrt(13566)*C5/1024-7*sqrt(1330)*C7/1024-9*sqrt(42)*C9/1024",
            "sqrt(1939938)*x*(y**10-45*y**8*z**2+210*y**6*z**4-210*y**4*z**6+45*y**2*z**8-z**10)/512",
            "[sqrt(11)/1024,0,9*sqrt(21)/1024,0,7*sqrt(665)/1024,0,5*sqrt(6783)/1024,0,9*sqrt(3230)/1024,0,sqrt(58786)/1024,0,-sqrt(58786)/1024,0,-9*sqrt(3230)/1024,0,-5*sqrt(6783)/1024,0,-7*sqrt(665)/1024,0,-9*sqrt(21)/1024,0,-sqrt(11)/1024]",
        ),
        "Qh(11,E,4,1)": (
            "-sqrt(29393)*S1/512+sqrt(22)*S11/1024+9*sqrt(1615)*S3/512-5*sqrt(13566)*S5/1024+7*sqrt(1330)*S7/1024-9*sqrt(42)*S9/1024",
            "sqrt(1939938)*y*(x**10-45*x**8*z**2+210*x**6*z**4-210*x**4*z**6+45*x**2*z**8-z**10)/512",
            "[sqrt(11)*I/1024,0,-9*sqrt(21)*I/1024,0,7*sqrt(665)*I/1024,0,-5*sqrt(6783)*I/1024,0,9*sqrt(3230)*I/1024,0,-sqrt(58786)*I/1024,0,-sqrt(58786)*I/1024,0,9*sqrt(3230)*I/1024,0,-5*sqrt(6783)*I/1024,0,7*sqrt(665)*I/1024,0,-9*sqrt(21)*I/1024,0,sqrt(11)*I/1024]",
        ),
        "Qh(11,E,5,0)": (
            "-15*sqrt(221)*C1/512-3*sqrt(2926)*C11/1024-sqrt(595)*C3/512+53*sqrt(102)*C5/1024-105*sqrt(10)*C7/1024-61*sqrt(114)*C9/1024",
            "sqrt(14586)*x*(224*x**4*y**6-3360*x**4*y**4*z**2+3360*x**4*y**2*z**4-224*x**4*z**6-160*x**2*y**8+2240*x**2*y**6*z**2-2240*x**2*y**2*z**6+160*x**2*z**8+15*y**10-195*y**8*z**2-210*y**6*z**4+210*y**4*z**6+195*y**2*z**8-15*z**10)/512",
            "[3*sqrt(1463)/1024,0,61*sqrt(57)/1024,0,105*sqrt(5)/1024,0,-53*sqrt(51)/1024,0,sqrt(1190)/1024,0,15*sqrt(442)/1024,0,-15*sqrt(442)/1024,0,-sqrt(1190)/1024,0,53*sqrt(51)/1024,0,-105*sqrt(5)/1024,0,-61*sqrt(57)/1024,0,-3*sqrt(1463)/1024]",
        ),
        "Qh(11,E,5,1)": (
            "-15*sqrt(221)*S1/512+3*sqrt(2926)*S11/1024+sqrt(595)*S3/512+53*sqrt(102)*S5/1024+105*sqrt(10)*S7/1024-61*sqrt(114)*S9/1024",
            "sqrt(14586)*y*(15*x**10-160*x**8*y**2-195*x**8*z**2+224*x**6*y**4+2240*x**6*y**2*z**2-210*x**6*z**4-3360*x**4*y**4*z**2+210*x**4*z**6+3360*x**2*y**4*z**4-2240*x**2*y**2*z**6+195*x**2*z**8-224*y**4*z**6+160*y**2*z**8-15*z**10)/512",
            "[3*sqrt(1463)*I/1024,0,-61*sqrt(57)*I/1024,0,105*sqrt(5)*I/1024,0,53*sqrt(51)*I/1024,0,sqrt(1190)*I/1024,0,-15*sqrt(442)*I/1024,0,-15*sqrt(442)*I/1024,0,sqrt(1190)*I/1024,0,53*sqrt(51)*I/1024,0,105*sqrt(5)*I/1024,0,-61*sqrt(57)*I/1024,0,3*sqrt(1463)*I/1024]",
        ),
        "Qh(11,E,6,0)": (
            "-21*sqrt(130)*C1/512-sqrt(124355)*C11/512+57*sqrt(14)*C3/512-41*sqrt(15)*C5/512+17*sqrt(17)*C7/512+sqrt(4845)*C9/512",
            "sqrt(2145)*x*(128*x**8*y**2-128*x**8*z**2-768*x**6*y**4+768*x**6*z**4+1008*x**4*y**6+1008*x**4*y**4*z**2-1008*x**4*y**2*z**4-1008*x**4*z**6-336*x**2*y**8-672*x**2*y**6*z**2+672*x**2*y**2*z**6+336*x**2*z**8+21*y**10+63*y**8*z**2+42*y**6*z**4-42*y**4*z**6-63*y**2*z**8-21*z**10)/256",
            "[sqrt(248710)/1024,0,-sqrt(9690)/1024,0,-17*sqrt(34)/1024,0,41*sqrt(30)/1024,0,-57*sqrt(7)/512,0,21*sqrt(65)/512,0,-21*sqrt(65)/512,0,57*sqrt(7)/512,0,-41*sqrt(30)/1024,0,17*sqrt(34)/1024,0,sqrt(9690)/1024,0,-sqrt(248710)/1024]",
        ),
        "Qh(11,E,6,1)": (
            "-21*sqrt(130)*S1/512+sqrt(124355)*S11/512-57*sqrt(14)*S3/512-41*sqrt(15)*S5/512-17*sqrt(17)*S7/512+sqrt(4845)*S9/512",
            "sqrt(2145)*y*(21*x**10-336*x**8*y**2+63*x**8*z**2+1008*x**6*y**4-672*x**6*y**2*z**2+42*x**6*z**4-768*x**4*y**6+1008*x**4*y**4*z**2-42*x**4*z**6+128*x**2*y**8-1008*x**2*y**4*z**4+672*x**2*y**2*z**6-63*x**2*z**8-128*y**8*z**2+768*y**6*z**4-1008*y**4*z**6+336*y**2*z**8-21*z**10)/256",
            "[sqrt(248710)*I/1024,0,sqrt(9690)*I/1024,0,-17*sqrt(34)*I/1024,0,-41*sqrt(30)*I/1024,0,-57*sqrt(7)*I/512,0,-21*sqrt(65)*I/512,0,-21*sqrt(65)*I/512,0,-57*sqrt(7)*I/512,0,-41*sqrt(30)*I/1024,0,-17*sqrt(34)*I/1024,0,sqrt(9690)*I/1024,0,sqrt(248710)*I/1024]",
        ),
    },
    "S4": {
        "Qh(0,A,,)": ("C0", "1", "[1]"),
        "Qh(1,B,,)": ("C0", "z", "[0,1,0]"),
        "Qh(1,E,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(1,E,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(2,A,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(2,B,1,)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(2,B,2,)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Qh(2,E,,0)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(2,E,,1)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Qh(3,A,1,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(3,A,2,)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(3,B,,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(3,E,1,0)": (
            "-sqrt(6)*C1/4+sqrt(10)*C3/4",
            "x*(2*x**2-3*y**2-3*z**2)/2",
            "[-sqrt(5)/4,0,sqrt(3)/4,0,-sqrt(3)/4,0,sqrt(5)/4]",
        ),
        "Qh(3,E,1,1)": (
            "-sqrt(6)*S1/4-sqrt(10)*S3/4",
            "y*(-3*x**2+2*y**2-3*z**2)/2",
            "[-sqrt(5)*I/4,0,-sqrt(3)*I/4,0,-sqrt(3)*I/4,0,-sqrt(5)*I/4]",
        ),
        "Qh(3,E,2,0)": (
            "-sqrt(10)*C1/4-sqrt(6)*C3/4",
            "sqrt(15)*x*(y**2-z**2)/2",
            "[sqrt(3)/4,0,sqrt(5)/4,0,-sqrt(5)/4,0,-sqrt(3)/4]",
        ),
        "Qh(3,E,2,1)": (
            "-sqrt(10)*S1/4+sqrt(6)*S3/4",
            "sqrt(15)*y*(x**2-z**2)/2",
            "[sqrt(3)*I/4,0,-sqrt(5)*I/4,0,-sqrt(5)*I/4,0,sqrt(3)*I/4]",
        ),
        "Qh(4,A,1,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Qh(4,A,2,)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "-sqrt(15)*(x**4-12*x**2*y**2+6*x**2*z**2+y**4+6*y**2*z**2-2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Qh(4,A,3,)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(4,B,1,)": ("-C2", "sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Qh(4,B,2,)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(4,E,1,0)": (
            "sqrt(2)*(-sqrt(7)*S1-S3)/4",
            "sqrt(35)*y*z*(y**2-z**2)/2",
            "[0,-I/4,0,-sqrt(7)*I/4,0,-sqrt(7)*I/4,0,-I/4,0]",
        ),
        "Qh(4,E,1,1)": ("-sqrt(14)*C1/4+sqrt(2)*C3/4", "sqrt(35)*x*z*(x**2-z**2)/2", "[0,-1/4,0,sqrt(7)/4,0,-sqrt(7)/4,0,1/4,0]"),
        "Qh(4,E,2,0)": (
            "sqrt(2)*(-S1+sqrt(7)*S3)/4",
            "sqrt(5)*y*z*(6*x**2-y**2-z**2)/2",
            "[0,sqrt(7)*I/4,0,-I/4,0,-I/4,0,sqrt(7)*I/4,0]",
        ),
        "Qh(4,E,2,1)": (
            "-sqrt(2)*(C1+sqrt(7)*C3)/4",
            "sqrt(5)*x*z*(-x**2+6*y**2-z**2)/2",
            "[0,sqrt(7)/4,0,1/4,0,-1/4,0,-sqrt(7)/4,0]",
        ),
        "Qh(5,A,1,)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(5,A,2,)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(5,B,1,)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(5,B,2,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(5,B,3,)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(5,E,1,0)": (
            "sqrt(15)*C1/8-sqrt(70)*C3/16+3*sqrt(14)*C5/16",
            "x*(8*x**4-40*x**2*y**2-40*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/8",
            "[-3*sqrt(7)/16,0,sqrt(35)/16,0,-sqrt(30)/16,0,sqrt(30)/16,0,-sqrt(35)/16,0,3*sqrt(7)/16]",
        ),
        "Qh(5,E,1,1)": (
            "sqrt(15)*S1/8+sqrt(70)*S3/16+3*sqrt(14)*S5/16",
            "y*(15*x**4-40*x**2*y**2+30*x**2*z**2+8*y**4-40*y**2*z**2+15*z**4)/8",
            "[3*sqrt(7)*I/16,0,sqrt(35)*I/16,0,sqrt(30)*I/16,0,sqrt(30)*I/16,0,sqrt(35)*I/16,0,3*sqrt(7)*I/16]",
        ),
        "Qh(5,E,2,0)": (
            "sqrt(2)*(sqrt(42)*C1+9*C3+sqrt(5)*C5)/16",
            "3*sqrt(35)*x*(y**4-6*y**2*z**2+z**4)/8",
            "[-sqrt(5)/16,0,-9/16,0,-sqrt(42)/16,0,sqrt(42)/16,0,9/16,0,sqrt(5)/16]",
        ),
        "Qh(5,E,2,1)": (
            "sqrt(2)*(sqrt(42)*S1-9*S3+sqrt(5)*S5)/16",
            "3*sqrt(35)*y*(x**4-6*x**2*z**2+z**4)/8",
            "[sqrt(5)*I/16,0,-9*I/16,0,sqrt(42)*I/16,0,sqrt(42)*I/16,0,-9*I/16,0,sqrt(5)*I/16]",
        ),
        "Qh(5,E,3,0)": (
            "sqrt(7)*C1/4-sqrt(6)*C3/8-sqrt(30)*C5/8",
            "sqrt(105)*x*(2*x**2*y**2-2*x**2*z**2-y**4+z**4)/4",
            "[sqrt(15)/8,0,sqrt(3)/8,0,-sqrt(14)/8,0,sqrt(14)/8,0,-sqrt(3)/8,0,-sqrt(15)/8]",
        ),
        "Qh(5,E,3,1)": (
            "sqrt(7)*S1/4+sqrt(6)*S3/8-sqrt(30)*S5/8",
            "sqrt(105)*y*(-x**4+2*x**2*y**2-2*y**2*z**2+z**4)/4",
            "[-sqrt(15)*I/8,0,sqrt(3)*I/8,0,sqrt(14)*I/8,0,sqrt(14)*I/8,0,sqrt(3)*I/8,0,-sqrt(15)*I/8]",
        ),
        "Qh(6,A,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Qh(6,A,2,)": (
            "sqrt(14)*C0/4+sqrt(2)*C4/4",
            "-sqrt(14)*(x**6-15*x**4*z**2+15*x**2*z**4+y**6-15*y**4*z**2+15*y**2*z**4-2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Qh(6,A,3,)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(6,B,1,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Qh(6,B,2,)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x-y)*(x+y)*(x**4-9*x**2*y**2-5*x**2*z**2+y**4-5*y**2*z**2+5*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Qh(6,B,3,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(6,B,4,)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(6,E,1,0)": (
            "sqrt(3)*S1/4-sqrt(30)*S3/8-sqrt(22)*S5/8",
            "3*sqrt(7)*y*z*(10*x**2*y**2-10*x**2*z**2-y**4+z**4)/4",
            "[0,-sqrt(11)*I/8,0,-sqrt(15)*I/8,0,sqrt(6)*I/8,0,sqrt(6)*I/8,0,-sqrt(15)*I/8,0,-sqrt(11)*I/8,0]",
        ),
        "Qh(6,E,1,1)": (
            "sqrt(3)*C1/4+sqrt(30)*C3/8-sqrt(22)*C5/8",
            "3*sqrt(7)*x*z*(-x**4+10*x**2*y**2-10*y**2*z**2+z**4)/4",
            "[0,sqrt(11)/8,0,-sqrt(15)/8,0,-sqrt(6)/8,0,sqrt(6)/8,0,sqrt(15)/8,0,-sqrt(11)/8,0]",
        ),
        "Qh(6,E,2,0)": (
            "3*sqrt(22)*S1/16+sqrt(55)*S3/16+sqrt(3)*S5/16",
            "sqrt(462)*y*z*(3*y**4-10*y**2*z**2+3*z**4)/16",
            "[0,sqrt(6)*I/32,0,sqrt(110)*I/32,0,3*sqrt(11)*I/16,0,3*sqrt(11)*I/16,0,sqrt(110)*I/32,0,sqrt(6)*I/32,0]",
        ),
        "Qh(6,E,2,1)": (
            "3*sqrt(22)*C1/16-sqrt(55)*C3/16+sqrt(3)*C5/16",
            "sqrt(462)*x*z*(3*x**4-10*x**2*z**2+3*z**4)/16",
            "[0,-sqrt(6)/32,0,sqrt(110)/32,0,-3*sqrt(11)/16,0,3*sqrt(11)/16,0,-sqrt(110)/32,0,sqrt(6)/32,0]",
        ),
        "Qh(6,E,3,0)": (
            "sqrt(10)*S1/16-9*S3/16+sqrt(165)*S5/16",
            "sqrt(210)*y*z*(16*x**4-16*x**2*y**2-16*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,sqrt(330)*I/32,0,-9*sqrt(2)*I/32,0,sqrt(5)*I/16,0,sqrt(5)*I/16,0,-9*sqrt(2)*I/32,0,sqrt(330)*I/32,0]",
        ),
        "Qh(6,E,3,1)": (
            "sqrt(10)*C1/16+9*C3/16+sqrt(165)*C5/16",
            "sqrt(210)*x*z*(x**4-16*x**2*y**2+2*x**2*z**2+16*y**4-16*y**2*z**2+z**4)/16",
            "[0,-sqrt(330)/32,0,-9*sqrt(2)/32,0,-sqrt(5)/16,0,sqrt(5)/16,0,9*sqrt(2)/32,0,sqrt(330)/32,0]",
        ),
        "Qh(7,A,1,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Qh(7,A,2,)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "-sqrt(77)*x*y*z*(3*x**4-20*x**2*y**2+10*x**2*z**2+3*y**4+10*y**2*z**2-6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Qh(7,A,3,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(7,A,4,)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(7,B,1,)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(7,B,2,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(7,B,3,)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(7,E,1,0)": (
            "-5*sqrt(7)*C1/32+3*sqrt(21)*C3/32-sqrt(231)*C5/32+sqrt(429)*C7/32",
            "x*(16*x**6-168*x**4*y**2-168*x**4*z**2+210*x**2*y**4+420*x**2*y**2*z**2+210*x**2*z**4-35*y**6-105*y**4*z**2-105*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)/64,0,sqrt(462)/64,0,-3*sqrt(42)/64,0,5*sqrt(14)/64,0,-5*sqrt(14)/64,0,3*sqrt(42)/64,0,-sqrt(462)/64,0,sqrt(858)/64]",
        ),
        "Qh(7,E,1,1)": (
            "-5*sqrt(7)*S1/32-3*sqrt(21)*S3/32-sqrt(231)*S5/32-sqrt(429)*S7/32",
            "y*(-35*x**6+210*x**4*y**2-105*x**4*z**2-168*x**2*y**4+420*x**2*y**2*z**2-105*x**2*z**4+16*y**6-168*y**4*z**2+210*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)*I/64,0,-sqrt(462)*I/64,0,-3*sqrt(42)*I/64,0,-5*sqrt(14)*I/64,0,-5*sqrt(14)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(462)*I/64,0,-sqrt(858)*I/64]",
        ),
        "Qh(7,E,2,0)": (
            "-3*sqrt(33)*C1/32-sqrt(11)*C3/32+25*C5/32+sqrt(91)*C7/32",
            "sqrt(231)*x*(10*x**2*y**4-60*x**2*y**2*z**2+10*x**2*z**4-3*y**6+15*y**4*z**2+15*y**2*z**4-3*z**6)/16",
            "[-sqrt(182)/64,0,-25*sqrt(2)/64,0,sqrt(22)/64,0,3*sqrt(66)/64,0,-3*sqrt(66)/64,0,-sqrt(22)/64,0,25*sqrt(2)/64,0,sqrt(182)/64]",
        ),
        "Qh(7,E,2,1)": (
            "-3*sqrt(33)*S1/32+sqrt(11)*S3/32+25*S5/32-sqrt(91)*S7/32",
            "sqrt(231)*y*(-3*x**6+10*x**4*y**2+15*x**4*z**2-60*x**2*y**2*z**2+15*x**2*z**4+10*y**2*z**4-3*z**6)/16",
            "[-sqrt(182)*I/64,0,25*sqrt(2)*I/64,0,sqrt(22)*I/64,0,-3*sqrt(66)*I/64,0,-3*sqrt(66)*I/64,0,sqrt(22)*I/64,0,25*sqrt(2)*I/64,0,-sqrt(182)*I/64]",
        ),
        "Qh(7,E,3,0)": (
            "-sqrt(858)*C1/64-3*sqrt(286)*C3/64-5*sqrt(26)*C5/64-sqrt(14)*C7/64",
            "sqrt(6006)*x*(y**6-15*y**4*z**2+15*y**2*z**4-z**6)/32",
            "[sqrt(7)/64,0,5*sqrt(13)/64,0,3*sqrt(143)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-3*sqrt(143)/64,0,-5*sqrt(13)/64,0,-sqrt(7)/64]",
        ),
        "Qh(7,E,3,1)": (
            "-sqrt(858)*S1/64+3*sqrt(286)*S3/64-5*sqrt(26)*S5/64+sqrt(14)*S7/64",
            "sqrt(6006)*y*(x**6-15*x**4*z**2+15*x**2*z**4-z**6)/32",
            "[sqrt(7)*I/64,0,-5*sqrt(13)*I/64,0,3*sqrt(143)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,3*sqrt(143)*I/64,0,-5*sqrt(13)*I/64,0,sqrt(7)*I/64]",
        ),
        "Qh(7,E,4,0)": (
            "sqrt(2)*(-15*sqrt(3)*C1+19*C3-sqrt(11)*C5-sqrt(1001)*C7)/64",
            "sqrt(42)*x*(48*x**4*y**2-48*x**4*z**2-80*x**2*y**4+80*x**2*z**4+15*y**6+15*y**4*z**2-15*y**2*z**4-15*z**6)/32",
            "[sqrt(1001)/64,0,sqrt(11)/64,0,-19/64,0,15*sqrt(3)/64,0,-15*sqrt(3)/64,0,19/64,0,-sqrt(11)/64,0,-sqrt(1001)/64]",
        ),
        "Qh(7,E,4,1)": (
            "-15*sqrt(6)*S1/64-19*sqrt(2)*S3/64-sqrt(22)*S5/64+sqrt(2002)*S7/64",
            "sqrt(42)*y*(15*x**6-80*x**4*y**2+15*x**4*z**2+48*x**2*y**4-15*x**2*z**4-48*y**4*z**2+80*y**2*z**4-15*z**6)/32",
            "[sqrt(1001)*I/64,0,-sqrt(11)*I/64,0,-19*I/64,0,-15*sqrt(3)*I/64,0,-15*sqrt(3)*I/64,0,-19*I/64,0,-sqrt(11)*I/64,0,sqrt(1001)*I/64]",
        ),
        "Qh(8,A,1,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Qh(8,A,2,)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Qh(8,A,3,)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Qh(8,A,4,)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(8,A,5,)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(8,B,1,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(8,B,2,)": (
            "C2",
            "-3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(8,B,3,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(8,B,4,)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(8,E,1,0)": (
            "-sqrt(715)*S1/32-sqrt(273)*S3/32-sqrt(35)*S5/32-S7/32",
            "3*sqrt(715)*y*z*(y**6-7*y**4*z**2+7*y**2*z**4-z**6)/16",
            "[0,-sqrt(2)*I/64,0,-sqrt(70)*I/64,0,-sqrt(546)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(546)*I/64,0,-sqrt(70)*I/64,0,-sqrt(2)*I/64,0]",
        ),
        "Qh(8,E,1,1)": (
            "-sqrt(715)*C1/32+sqrt(273)*C3/32-sqrt(35)*C5/32+C7/32",
            "3*sqrt(715)*x*z*(x**6-7*x**4*z**2+7*x**2*z**4-z**6)/16",
            "[0,-sqrt(2)/64,0,sqrt(70)/64,0,-sqrt(546)/64,0,sqrt(1430)/64,0,-sqrt(1430)/64,0,sqrt(546)/64,0,-sqrt(70)/64,0,sqrt(2)/64,0]",
        ),
        "Qh(8,E,2,0)": (
            "-sqrt(77)*S1/32+5*sqrt(15)*S3/32-3*sqrt(13)*S5/32-sqrt(455)*S7/32",
            "3*sqrt(77)*y*z*(40*x**4*y**2-40*x**4*z**2-24*x**2*y**4+24*x**2*z**4+y**6+y**4*z**2-y**2*z**4-z**6)/16",
            "[0,-sqrt(910)*I/64,0,-3*sqrt(26)*I/64,0,5*sqrt(30)*I/64,0,-sqrt(154)*I/64,0,-sqrt(154)*I/64,0,5*sqrt(30)*I/64,0,-3*sqrt(26)*I/64,0,-sqrt(910)*I/64,0]",
        ),
        "Qh(8,E,2,1)": (
            "-sqrt(77)*C1/32-5*sqrt(15)*C3/32-3*sqrt(13)*C5/32+sqrt(455)*C7/32",
            "3*sqrt(77)*x*z*(x**6-24*x**4*y**2+x**4*z**2+40*x**2*y**4-x**2*z**4-40*y**4*z**2+24*y**2*z**4-z**6)/16",
            "[0,-sqrt(910)/64,0,3*sqrt(26)/64,0,5*sqrt(30)/64,0,sqrt(154)/64,0,-sqrt(154)/64,0,-5*sqrt(30)/64,0,-3*sqrt(26)/64,0,sqrt(910)/64,0]",
        ),
        "Qh(8,E,3,0)": (
            "-sqrt(858)*S1/64+sqrt(910)*S3/64+7*sqrt(42)*S5/64+3*sqrt(30)*S7/64",
            "sqrt(858)*y*z*(42*x**2*y**4-140*x**2*y**2*z**2+42*x**2*z**4-3*y**6+7*y**4*z**2+7*y**2*z**4-3*z**6)/32",
            "[0,3*sqrt(15)*I/64,0,7*sqrt(21)*I/64,0,sqrt(455)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(455)*I/64,0,7*sqrt(21)*I/64,0,3*sqrt(15)*I/64,0]",
        ),
        "Qh(8,E,3,1)": (
            "-sqrt(858)*C1/64-sqrt(910)*C3/64+7*sqrt(42)*C5/64-3*sqrt(30)*C7/64",
            "sqrt(858)*x*z*(-3*x**6+42*x**4*y**2+7*x**4*z**2-140*x**2*y**2*z**2+7*x**2*z**4+42*y**2*z**4-3*z**6)/32",
            "[0,3*sqrt(15)/64,0,-7*sqrt(21)/64,0,sqrt(455)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-sqrt(455)/64,0,7*sqrt(21)/64,0,-3*sqrt(15)/64,0]",
        ),
        "Qh(8,E,4,0)": (
            "-sqrt(70)*S1/64+3*sqrt(66)*S3/64-sqrt(1430)*S5/64+sqrt(2002)*S7/64",
            "3*sqrt(70)*y*z*(32*x**6-80*x**4*y**2-80*x**4*z**2+30*x**2*y**4+60*x**2*y**2*z**2+30*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,sqrt(1001)*I/64,0,-sqrt(715)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(35)*I/64,0,-sqrt(35)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(715)*I/64,0,sqrt(1001)*I/64,0]",
        ),
        "Qh(8,E,4,1)": (
            "-sqrt(70)*C1/64-3*sqrt(66)*C3/64-sqrt(1430)*C5/64-sqrt(2002)*C7/64",
            "3*sqrt(70)*x*z*(-x**6+30*x**4*y**2-3*x**4*z**2-80*x**2*y**4+60*x**2*y**2*z**2-3*x**2*z**4+32*y**6-80*y**4*z**2+30*y**2*z**4-z**6)/32",
            "[0,sqrt(1001)/64,0,sqrt(715)/64,0,3*sqrt(33)/64,0,sqrt(35)/64,0,-sqrt(35)/64,0,-3*sqrt(33)/64,0,-sqrt(715)/64,0,-sqrt(1001)/64,0]",
        ),
        "Qh(9,A,1,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Qh(9,A,2,)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Qh(9,A,3,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,A,4,)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(9,B,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Qh(9,B,2,)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(x-y)*(x+y)*(3*x**4-11*x**2*y**2-7*x**2*z**2+3*y**4-7*y**2*z**2+7*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Qh(9,B,3,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,B,4,)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,B,5,)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(9,E,1,0)": (
            "21*sqrt(5)*C1/128-sqrt(2310)*C3/128+3*sqrt(286)*C5/128-3*sqrt(1430)*C7/256+sqrt(24310)*C9/256",
            "x*(128*x**8-2304*x**6*y**2-2304*x**6*z**2+6048*x**4*y**4+12096*x**4*y**2*z**2+6048*x**4*z**4-3360*x**2*y**6-10080*x**2*y**4*z**2-10080*x**2*y**2*z**4-3360*x**2*z**6+315*y**8+1260*y**6*z**2+1890*y**4*z**4+1260*y**2*z**6+315*z**8)/128",
            "[-sqrt(12155)/256,0,3*sqrt(715)/256,0,-3*sqrt(143)/128,0,sqrt(1155)/128,0,-21*sqrt(10)/256,0,21*sqrt(10)/256,0,-sqrt(1155)/128,0,3*sqrt(143)/128,0,-3*sqrt(715)/256,0,sqrt(12155)/256]",
        ),
        "Qh(9,E,1,1)": (
            "21*sqrt(5)*S1/128+sqrt(2310)*S3/128+3*sqrt(286)*S5/128+3*sqrt(1430)*S7/256+sqrt(24310)*S9/256",
            "y*(315*x**8-3360*x**6*y**2+1260*x**6*z**2+6048*x**4*y**4-10080*x**4*y**2*z**2+1890*x**4*z**4-2304*x**2*y**6+12096*x**2*y**4*z**2-10080*x**2*y**2*z**4+1260*x**2*z**6+128*y**8-2304*y**6*z**2+6048*y**4*z**4-3360*y**2*z**6+315*z**8)/128",
            "[sqrt(12155)*I/256,0,3*sqrt(715)*I/256,0,3*sqrt(143)*I/128,0,sqrt(1155)*I/128,0,21*sqrt(10)*I/256,0,21*sqrt(10)*I/256,0,sqrt(1155)*I/128,0,3*sqrt(143)*I/128,0,3*sqrt(715)*I/256,0,sqrt(12155)*I/256]",
        ),
        "Qh(9,E,2,0)": (
            "sqrt(2)*(sqrt(4862)*C1+2*sqrt(4641)*C3+10*sqrt(85)*C5+7*sqrt(17)*C7+3*C9)/256",
            "3*sqrt(12155)*x*(y**8-28*y**6*z**2+70*y**4*z**4-28*y**2*z**6+z**8)/128",
            "[-3/256,0,-7*sqrt(17)/256,0,-5*sqrt(85)/128,0,-sqrt(4641)/128,0,-sqrt(4862)/256,0,sqrt(4862)/256,0,sqrt(4641)/128,0,5*sqrt(85)/128,0,7*sqrt(17)/256,0,3/256]",
        ),
        "Qh(9,E,2,1)": (
            "sqrt(2)*(sqrt(4862)*S1-2*sqrt(4641)*S3+10*sqrt(85)*S5-7*sqrt(17)*S7+3*S9)/256",
            "3*sqrt(12155)*y*(x**8-28*x**6*z**2+70*x**4*z**4-28*x**2*z**6+z**8)/128",
            "[3*I/256,0,-7*sqrt(17)*I/256,0,5*sqrt(85)*I/128,0,-sqrt(4641)*I/128,0,sqrt(4862)*I/256,0,sqrt(4862)*I/256,0,-sqrt(4641)*I/128,0,5*sqrt(85)*I/128,0,-7*sqrt(17)*I/256,0,3*I/256]",
        ),
        "Qh(9,E,3,0)": (
            "sqrt(1001)*C1/64-sqrt(78)*C3/64-3*sqrt(70)*C5/64+23*sqrt(14)*C7/128+3*sqrt(238)*C9/128",
            "3*sqrt(5005)*x*(8*x**4*y**4-48*x**4*y**2*z**2+8*x**4*z**4-8*x**2*y**6+40*x**2*y**4*z**2+40*x**2*y**2*z**4-8*x**2*z**6+y**8-4*y**6*z**2-10*y**4*z**4-4*y**2*z**6+z**8)/64",
            "[-3*sqrt(119)/128,0,-23*sqrt(7)/128,0,3*sqrt(35)/64,0,sqrt(39)/64,0,-sqrt(2002)/128,0,sqrt(2002)/128,0,-sqrt(39)/64,0,-3*sqrt(35)/64,0,23*sqrt(7)/128,0,3*sqrt(119)/128]",
        ),
        "Qh(9,E,3,1)": (
            "sqrt(1001)*S1/64+sqrt(78)*S3/64-3*sqrt(70)*S5/64-23*sqrt(14)*S7/128+3*sqrt(238)*S9/128",
            "3*sqrt(5005)*y*(x**8-8*x**6*y**2-4*x**6*z**2+8*x**4*y**4+40*x**4*y**2*z**2-10*x**4*z**4-48*x**2*y**4*z**2+40*x**2*y**2*z**4-4*x**2*z**6+8*y**4*z**4-8*y**2*z**6+z**8)/64",
            "[3*sqrt(119)*I/128,0,-23*sqrt(7)*I/128,0,-3*sqrt(35)*I/64,0,sqrt(39)*I/64,0,sqrt(2002)*I/128,0,sqrt(2002)*I/128,0,sqrt(39)*I/64,0,-3*sqrt(35)*I/64,0,-23*sqrt(7)*I/128,0,3*sqrt(119)*I/128]",
        ),
        "Qh(9,E,4,0)": (
            "sqrt(858)*C1/64+sqrt(91)*C3/32-5*sqrt(15)*C5/32-21*sqrt(3)*C7/64-sqrt(51)*C9/64",
            "sqrt(4290)*x*(14*x**2*y**6-210*x**2*y**4*z**2+210*x**2*y**2*z**4-14*x**2*z**6-3*y**8+42*y**6*z**2-42*y**2*z**6+3*z**8)/64",
            "[sqrt(102)/128,0,21*sqrt(6)/128,0,5*sqrt(30)/64,0,-sqrt(182)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(182)/64,0,-5*sqrt(30)/64,0,-21*sqrt(6)/128,0,-sqrt(102)/128]",
        ),
        "Qh(9,E,4,1)": (
            "sqrt(858)*S1/64-sqrt(91)*S3/32-5*sqrt(15)*S5/32+21*sqrt(3)*S7/64-sqrt(51)*S9/64",
            "sqrt(4290)*y*(-3*x**8+14*x**6*y**2+42*x**6*z**2-210*x**4*y**2*z**2+210*x**2*y**2*z**4-42*x**2*z**6-14*y**2*z**6+3*z**8)/64",
            "[-sqrt(102)*I/128,0,21*sqrt(6)*I/128,0,-5*sqrt(30)*I/64,0,-sqrt(182)*I/64,0,sqrt(429)*I/64,0,sqrt(429)*I/64,0,-sqrt(182)*I/64,0,-5*sqrt(30)*I/64,0,21*sqrt(6)*I/128,0,-sqrt(102)*I/128]",
        ),
        "Qh(9,E,5,0)": (
            "7*sqrt(22)*C1/64-3*sqrt(21)*C3/32+sqrt(65)*C5/32+sqrt(13)*C7/64-3*sqrt(221)*C9/64",
            "3*sqrt(110)*x*(32*x**6*y**2-32*x**6*z**2-112*x**4*y**4+112*x**4*z**4+70*x**2*y**6+70*x**2*y**4*z**2-70*x**2*y**2*z**4-70*x**2*z**6-7*y**8-14*y**6*z**2+14*y**2*z**6+7*z**8)/64",
            "[3*sqrt(442)/128,0,-sqrt(26)/128,0,-sqrt(130)/64,0,3*sqrt(42)/64,0,-7*sqrt(11)/64,0,7*sqrt(11)/64,0,-3*sqrt(42)/64,0,sqrt(130)/64,0,sqrt(26)/128,0,-3*sqrt(442)/128]",
        ),
        "Qh(9,E,5,1)": (
            "7*sqrt(22)*S1/64+3*sqrt(21)*S3/32+sqrt(65)*S5/32-sqrt(13)*S7/64-3*sqrt(221)*S9/64",
            "3*sqrt(110)*y*(-7*x**8+70*x**6*y**2-14*x**6*z**2-112*x**4*y**4+70*x**4*y**2*z**2+32*x**2*y**6-70*x**2*y**2*z**4+14*x**2*z**6-32*y**6*z**2+112*y**4*z**4-70*y**2*z**6+7*z**8)/64",
            "[-3*sqrt(442)*I/128,0,-sqrt(26)*I/128,0,sqrt(130)*I/64,0,3*sqrt(42)*I/64,0,7*sqrt(11)*I/64,0,7*sqrt(11)*I/64,0,3*sqrt(42)*I/64,0,sqrt(130)*I/64,0,-sqrt(26)*I/128,0,-3*sqrt(442)*I/128]",
        ),
        "Qh(10,A,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Qh(10,A,2,)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "-sqrt(420189)*(22*x**10+45*x**8*y**2-1035*x**8*z**2-105*x**6*y**4-630*x**6*y**2*z**2+4935*x**6*z**4-105*x**4*y**6+3150*x**4*y**4*z**2-1575*x**4*y**2*z**4-4830*x**4*z**6+45*x**2*y**8-630*x**2*y**6*z**2-1575*x**2*y**4*z**4+1260*x**2*y**2*z**6+990*x**2*z**8+22*y**10-1035*y**8*z**2+4935*y**6*z**4-4830*y**4*z**6+990*y**2*z**8-44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Qh(10,A,3,)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "-sqrt(3213210)*(3*x**10-96*x**8*y**2-39*x**8*z**2+224*x**6*y**4+1344*x**6*y**2*z**2-42*x**6*z**4+224*x**4*y**6-6720*x**4*y**4*z**2+3360*x**4*y**2*z**4-182*x**4*z**6-96*x**2*y**8+1344*x**2*y**6*z**2+3360*x**2*y**4*z**4-2688*x**2*y**2*z**6+135*x**2*z**8+3*y**10-39*y**8*z**2-42*y**6*z**4-182*y**4*z**6+135*y**2*z**8-6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Qh(10,A,4,)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(10,A,5,)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(10,B,1,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Qh(10,B,2,)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(x-y)*(x+y)*(22*x**8-653*x**6*y**2-315*x**6*z**2+2602*x**4*y**4-945*x**4*y**2*z**2+1575*x**4*z**4-653*x**2*y**6-945*x**2*y**4*z**2+3150*x**2*y**2*z**4-1680*x**2*z**6+22*y**8-315*y**6*z**2+1575*y**4*z**4-1680*y**2*z**6+360*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Qh(10,B,3,)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(x-y)*(x+y)*(9*x**8-165*x**6*y**2-231*x**6*z**2-25*x**4*y**4+3801*x**4*y**2*z**2+406*x**4*z**4-165*x**2*y**6+3801*x**2*y**4*z**2-9674*x**2*y**2*z**4+266*x**2*z**6+9*y**8-231*y**6*z**2+406*y**4*z**4+266*y**2*z**6-57*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Qh(10,B,4,)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(10,B,5,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,B,6,)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E,1,0)": (
            "sqrt(221)*S1/32-sqrt(102)*S3/32-sqrt(510)*S5/32-11*sqrt(6)*S7/64-sqrt(38)*S9/64",
            "sqrt(12155)*y*z*(18*x**2*y**6-126*x**2*y**4*z**2+126*x**2*y**2*z**4-18*x**2*z**6-y**8+6*y**6*z**2-6*y**2*z**6+z**8)/32",
            "[0,-sqrt(19)*I/64,0,-11*sqrt(3)*I/64,0,-sqrt(255)*I/32,0,-sqrt(51)*I/32,0,sqrt(442)*I/64,0,sqrt(442)*I/64,0,-sqrt(51)*I/32,0,-sqrt(255)*I/32,0,-11*sqrt(3)*I/64,0,-sqrt(19)*I/64,0]",
        ),
        "Qh(10,E,1,1)": (
            "sqrt(221)*C1/32+sqrt(102)*C3/32-sqrt(510)*C5/32+11*sqrt(6)*C7/64-sqrt(38)*C9/64",
            "sqrt(12155)*x*z*(-x**8+18*x**6*y**2+6*x**6*z**2-126*x**4*y**2*z**2+126*x**2*y**2*z**4-6*x**2*z**6-18*y**2*z**6+z**8)/32",
            "[0,sqrt(19)/64,0,-11*sqrt(3)/64,0,sqrt(255)/32,0,-sqrt(51)/32,0,-sqrt(442)/64,0,sqrt(442)/64,0,sqrt(51)/32,0,-sqrt(255)/32,0,11*sqrt(3)/64,0,-sqrt(19)/64,0]",
        ),
        "Qh(10,E,2,0)": (
            "sqrt(2)*(sqrt(78)*S1-22*S3+10*sqrt(5)*S5-sqrt(17)*S7-sqrt(969)*S9)/64",
            "sqrt(2145)*y*z*(112*x**6*y**2-112*x**6*z**2-168*x**4*y**4+168*x**4*z**4+42*x**2*y**6+42*x**2*y**4*z**2-42*x**2*y**2*z**4-42*x**2*z**6-y**8-2*y**6*z**2+2*y**2*z**6+z**8)/32",
            "[0,-sqrt(969)*I/64,0,-sqrt(17)*I/64,0,5*sqrt(5)*I/32,0,-11*I/32,0,sqrt(78)*I/64,0,sqrt(78)*I/64,0,-11*I/32,0,5*sqrt(5)*I/32,0,-sqrt(17)*I/64,0,-sqrt(969)*I/64,0]",
        ),
        "Qh(10,E,2,1)": (
            "sqrt(2)*(sqrt(78)*C1+22*C3+10*sqrt(5)*C5+sqrt(17)*C7-sqrt(969)*C9)/64",
            "sqrt(2145)*x*z*(-x**8+42*x**6*y**2-2*x**6*z**2-168*x**4*y**4+42*x**4*y**2*z**2+112*x**2*y**6-42*x**2*y**2*z**4+2*x**2*z**6-112*y**6*z**2+168*y**4*z**4-42*y**2*z**6+z**8)/32",
            "[0,sqrt(969)/64,0,-sqrt(17)/64,0,-5*sqrt(5)/32,0,-11/32,0,-sqrt(78)/64,0,sqrt(78)/64,0,11/32,0,5*sqrt(5)/32,0,sqrt(17)/64,0,-sqrt(969)/64,0]",
        ),
        "Qh(10,E,3,0)": (
            "sqrt(41990)*S1/256+sqrt(4845)*S3/128+sqrt(969)*S5/128+sqrt(285)*S7/256+sqrt(5)*S9/256",
            "sqrt(92378)*y*z*(5*y**8-60*y**6*z**2+126*y**4*z**4-60*y**2*z**6+5*z**8)/256",
            "[0,sqrt(10)*I/512,0,sqrt(570)*I/512,0,sqrt(1938)*I/256,0,sqrt(9690)*I/256,0,sqrt(20995)*I/256,0,sqrt(20995)*I/256,0,sqrt(9690)*I/256,0,sqrt(1938)*I/256,0,sqrt(570)*I/512,0,sqrt(10)*I/512,0]",
        ),
        "Qh(10,E,3,1)": (
            "sqrt(41990)*C1/256-sqrt(4845)*C3/128+sqrt(969)*C5/128-sqrt(285)*C7/256+sqrt(5)*C9/256",
            "sqrt(92378)*x*z*(5*x**8-60*x**6*z**2+126*x**4*z**4-60*x**2*z**6+5*z**8)/256",
            "[0,-sqrt(10)/512,0,sqrt(570)/512,0,-sqrt(1938)/256,0,sqrt(9690)/256,0,-sqrt(20995)/256,0,sqrt(20995)/256,0,-sqrt(9690)/256,0,sqrt(1938)/256,0,-sqrt(570)/512,0,sqrt(10)/512,0]",
        ),
        "Qh(10,E,4,0)": (
            "9*sqrt(78)*S1/256-69*S3/128-sqrt(5)*S5/128+43*sqrt(17)*S7/256+3*sqrt(969)*S9/256",
            "sqrt(4290)*y*z*(672*x**4*y**4-2240*x**4*y**2*z**2+672*x**4*z**4-288*x**2*y**6+672*x**2*y**4*z**2+672*x**2*y**2*z**4-288*x**2*z**6+9*y**8-12*y**6*z**2-42*y**4*z**4-12*y**2*z**6+9*z**8)/256",
            "[0,3*sqrt(1938)*I/512,0,43*sqrt(34)*I/512,0,-sqrt(10)*I/256,0,-69*sqrt(2)*I/256,0,9*sqrt(39)*I/256,0,9*sqrt(39)*I/256,0,-69*sqrt(2)*I/256,0,-sqrt(10)*I/256,0,43*sqrt(34)*I/512,0,3*sqrt(1938)*I/512,0]",
        ),
        "Qh(10,E,4,1)": (
            "9*sqrt(78)*C1/256+69*C3/128-sqrt(5)*C5/128-43*sqrt(17)*C7/256+3*sqrt(969)*C9/256",
            "sqrt(4290)*x*z*(9*x**8-288*x**6*y**2-12*x**6*z**2+672*x**4*y**4+672*x**4*y**2*z**2-42*x**4*z**4-2240*x**2*y**4*z**2+672*x**2*y**2*z**4-12*x**2*z**6+672*y**4*z**4-288*y**2*z**6+9*z**8)/256",
            "[0,-3*sqrt(1938)/512,0,43*sqrt(34)/512,0,sqrt(10)/256,0,-69*sqrt(2)/256,0,-9*sqrt(39)/256,0,9*sqrt(39)/256,0,69*sqrt(2)/256,0,-sqrt(10)/256,0,-43*sqrt(34)/512,0,3*sqrt(1938)/512,0]",
        ),
        "Qh(10,E,5,0)": (
            "7*sqrt(3)*S1/128-7*sqrt(26)*S3/128+5*sqrt(130)*S5/128-7*sqrt(442)*S7/256+sqrt(25194)*S9/256",
            "sqrt(165)*y*z*(384*x**8-1792*x**6*y**2-1792*x**6*z**2+1680*x**4*y**4+3360*x**4*y**2*z**2+1680*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+7*y**8+28*y**6*z**2+42*y**4*z**4+28*y**2*z**6+7*z**8)/128",
            "[0,sqrt(12597)*I/256,0,-7*sqrt(221)*I/256,0,5*sqrt(65)*I/128,0,-7*sqrt(13)*I/128,0,7*sqrt(6)*I/256,0,7*sqrt(6)*I/256,0,-7*sqrt(13)*I/128,0,5*sqrt(65)*I/128,0,-7*sqrt(221)*I/256,0,sqrt(12597)*I/256,0]",
        ),
        "Qh(10,E,5,1)": (
            "7*sqrt(3)*C1/128+7*sqrt(26)*C3/128+5*sqrt(130)*C5/128+7*sqrt(442)*C7/256+sqrt(25194)*C9/256",
            "sqrt(165)*x*z*(7*x**8-336*x**6*y**2+28*x**6*z**2+1680*x**4*y**4-1008*x**4*y**2*z**2+42*x**4*z**4-1792*x**2*y**6+3360*x**2*y**4*z**2-1008*x**2*y**2*z**4+28*x**2*z**6+384*y**8-1792*y**6*z**2+1680*y**4*z**4-336*y**2*z**6+7*z**8)/128",
            "[0,-sqrt(12597)/256,0,-7*sqrt(221)/256,0,-5*sqrt(65)/128,0,-7*sqrt(13)/128,0,-7*sqrt(6)/256,0,7*sqrt(6)/256,0,7*sqrt(13)/128,0,5*sqrt(65)/128,0,7*sqrt(221)/256,0,sqrt(12597)/256,0]",
        ),
        "Qh(11,A,1,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Qh(11,A,2,)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "-sqrt(230945)*x*y*z*(x**8-6*x**6*y**2-6*x**6*z**2+42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2-84*x**2*y**2*z**4+12*x**2*z**6+y**8-6*y**6*z**2+12*y**2*z**6-2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Qh(11,A,3,)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "-sqrt(3003)*x*y*z*(5*x**8-150*x**6*y**2+90*x**6*z**2+336*x**4*y**4-70*x**4*y**2*z**2-168*x**4*z**4-150*x**2*y**6-70*x**2*y**4*z**2+140*x**2*y**2*z**4+60*x**2*z**6+5*y**8+90*y**6*z**2-168*y**4*z**4+60*y**2*z**6-10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Qh(11,A,4,)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(11,A,5,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,A,6,)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,B,1,)": (
            "S8",
            "-sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(11,B,2,)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,B,3,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,B,4,)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(11,B,5,)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,1,0)": (
            "-21*sqrt(66)*C1/512+sqrt(88179)*C11/512+sqrt(30030)*C3/512-15*sqrt(143)*C5/512+sqrt(36465)*C7/512-sqrt(46189)*C9/512",
            "x*(256*x**10-7040*x**8*y**2-7040*x**8*z**2+31680*x**6*y**4+63360*x**6*y**2*z**2+31680*x**6*z**4-36960*x**4*y**6-110880*x**4*y**4*z**2-110880*x**4*y**2*z**4-36960*x**4*z**6+11550*x**2*y**8+46200*x**2*y**6*z**2+69300*x**2*y**4*z**4+46200*x**2*y**2*z**6+11550*x**2*z**8-693*y**10-3465*y**8*z**2-6930*y**6*z**4-6930*y**4*z**6-3465*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)/1024,0,sqrt(92378)/1024,0,-sqrt(72930)/1024,0,15*sqrt(286)/1024,0,-sqrt(15015)/512,0,21*sqrt(33)/512,0,-21*sqrt(33)/512,0,sqrt(15015)/512,0,-15*sqrt(286)/1024,0,sqrt(72930)/1024,0,-sqrt(92378)/1024,0,sqrt(176358)/1024]",
        ),
        "Qh(11,E,1,1)": (
            "-21*sqrt(66)*S1/512-sqrt(88179)*S11/512-sqrt(30030)*S3/512-15*sqrt(143)*S5/512-sqrt(36465)*S7/512-sqrt(46189)*S9/512",
            "y*(-693*x**10+11550*x**8*y**2-3465*x**8*z**2-36960*x**6*y**4+46200*x**6*y**2*z**2-6930*x**6*z**4+31680*x**4*y**6-110880*x**4*y**4*z**2+69300*x**4*y**2*z**4-6930*x**4*z**6-7040*x**2*y**8+63360*x**2*y**6*z**2-110880*x**2*y**4*z**4+46200*x**2*y**2*z**6-3465*x**2*z**8+256*y**10-7040*y**8*z**2+31680*y**6*z**4-36960*y**4*z**6+11550*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(72930)*I/1024,0,-15*sqrt(286)*I/1024,0,-sqrt(15015)*I/512,0,-21*sqrt(33)*I/512,0,-21*sqrt(33)*I/512,0,-sqrt(15015)*I/512,0,-15*sqrt(286)*I/1024,0,-sqrt(72930)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(176358)*I/1024]",
        ),
        "Qh(11,E,2,0)": (
            "-sqrt(41990)*C1/512+sqrt(385)*C11/512-3*sqrt(4522)*C3/512+3*sqrt(4845)*C5/512+77*sqrt(19)*C7/512+39*sqrt(15)*C9/512",
            "sqrt(692835)*x*(6*x**2*y**8-168*x**2*y**6*z**2+420*x**2*y**4*z**4-168*x**2*y**2*z**6+6*x**2*z**8-y**10+27*y**8*z**2-42*y**6*z**4-42*y**4*z**6+27*y**2*z**8-z**10)/256",
            "[-sqrt(770)/1024,0,-39*sqrt(30)/1024,0,-77*sqrt(38)/1024,0,-3*sqrt(9690)/1024,0,3*sqrt(2261)/512,0,sqrt(20995)/512,0,-sqrt(20995)/512,0,-3*sqrt(2261)/512,0,3*sqrt(9690)/1024,0,77*sqrt(38)/1024,0,39*sqrt(30)/1024,0,sqrt(770)/1024]",
        ),
        "Qh(11,E,2,1)": (
            "-sqrt(41990)*S1/512-sqrt(385)*S11/512+3*sqrt(4522)*S3/512+3*sqrt(4845)*S5/512-77*sqrt(19)*S7/512+39*sqrt(15)*S9/512",
            "sqrt(692835)*y*(-x**10+6*x**8*y**2+27*x**8*z**2-168*x**6*y**2*z**2-42*x**6*z**4+420*x**4*y**2*z**4-42*x**4*z**6-168*x**2*y**2*z**6+27*x**2*z**8+6*y**2*z**8-z**10)/256",
            "[-sqrt(770)*I/1024,0,39*sqrt(30)*I/1024,0,-77*sqrt(38)*I/1024,0,3*sqrt(9690)*I/1024,0,3*sqrt(2261)*I/512,0,-sqrt(20995)*I/512,0,-sqrt(20995)*I/512,0,3*sqrt(2261)*I/512,0,3*sqrt(9690)*I/1024,0,-77*sqrt(38)*I/1024,0,39*sqrt(30)*I/1024,0,-sqrt(770)*I/1024]",
        ),
        "Qh(11,E,3,0)": (
            "-5*sqrt(546)*C1/256+sqrt(10659)*C11/256+11*sqrt(30)*C3/256+13*sqrt(7)*C5/256-3*sqrt(1785)*C7/256+3*sqrt(2261)*C9/256",
            "3*sqrt(1001)*x*(80*x**6*y**4-480*x**6*y**2*z**2+80*x**6*z**4-168*x**4*y**6+840*x**4*y**4*z**2+840*x**4*y**2*z**4-168*x**4*z**6+70*x**2*y**8-280*x**2*y**6*z**2-700*x**2*y**4*z**4-280*x**2*y**2*z**6+70*x**2*z**8-5*y**10+15*y**8*z**2+70*y**6*z**4+70*y**4*z**6+15*y**2*z**8-5*z**10)/128",
            "[-sqrt(21318)/512,0,-3*sqrt(4522)/512,0,3*sqrt(3570)/512,0,-13*sqrt(14)/512,0,-11*sqrt(15)/256,0,5*sqrt(273)/256,0,-5*sqrt(273)/256,0,11*sqrt(15)/256,0,13*sqrt(14)/512,0,-3*sqrt(3570)/512,0,3*sqrt(4522)/512,0,sqrt(21318)/512]",
        ),
        "Qh(11,E,3,1)": (
            "-5*sqrt(546)*S1/256-sqrt(10659)*S11/256-11*sqrt(30)*S3/256+13*sqrt(7)*S5/256+3*sqrt(1785)*S7/256+3*sqrt(2261)*S9/256",
            "3*sqrt(1001)*y*(-5*x**10+70*x**8*y**2+15*x**8*z**2-168*x**6*y**4-280*x**6*y**2*z**2+70*x**6*z**4+80*x**4*y**6+840*x**4*y**4*z**2-700*x**4*y**2*z**4+70*x**4*z**6-480*x**2*y**6*z**2+840*x**2*y**4*z**4-280*x**2*y**2*z**6+15*x**2*z**8+80*y**6*z**4-168*y**4*z**6+70*y**2*z**8-5*z**10)/128",
            "[-sqrt(21318)*I/512,0,3*sqrt(4522)*I/512,0,3*sqrt(3570)*I/512,0,13*sqrt(14)*I/512,0,-11*sqrt(15)*I/256,0,-5*sqrt(273)*I/256,0,-5*sqrt(273)*I/256,0,-11*sqrt(15)*I/256,0,13*sqrt(14)*I/512,0,3*sqrt(3570)*I/512,0,3*sqrt(4522)*I/512,0,-sqrt(21318)*I/512]",
        ),
        "Qh(11,E,4,0)": (
            "-sqrt(29393)*C1/512-sqrt(22)*C11/1024-9*sqrt(1615)*C3/512-5*sqrt(13566)*C5/1024-7*sqrt(1330)*C7/1024-9*sqrt(42)*C9/1024",
            "sqrt(1939938)*x*(y**10-45*y**8*z**2+210*y**6*z**4-210*y**4*z**6+45*y**2*z**8-z**10)/512",
            "[sqrt(11)/1024,0,9*sqrt(21)/1024,0,7*sqrt(665)/1024,0,5*sqrt(6783)/1024,0,9*sqrt(3230)/1024,0,sqrt(58786)/1024,0,-sqrt(58786)/1024,0,-9*sqrt(3230)/1024,0,-5*sqrt(6783)/1024,0,-7*sqrt(665)/1024,0,-9*sqrt(21)/1024,0,-sqrt(11)/1024]",
        ),
        "Qh(11,E,4,1)": (
            "-sqrt(29393)*S1/512+sqrt(22)*S11/1024+9*sqrt(1615)*S3/512-5*sqrt(13566)*S5/1024+7*sqrt(1330)*S7/1024-9*sqrt(42)*S9/1024",
            "sqrt(1939938)*y*(x**10-45*x**8*z**2+210*x**6*z**4-210*x**4*z**6+45*x**2*z**8-z**10)/512",
            "[sqrt(11)*I/1024,0,-9*sqrt(21)*I/1024,0,7*sqrt(665)*I/1024,0,-5*sqrt(6783)*I/1024,0,9*sqrt(3230)*I/1024,0,-sqrt(58786)*I/1024,0,-sqrt(58786)*I/1024,0,9*sqrt(3230)*I/1024,0,-5*sqrt(6783)*I/1024,0,7*sqrt(665)*I/1024,0,-9*sqrt(21)*I/1024,0,sqrt(11)*I/1024]",
        ),
        "Qh(11,E,5,0)": (
            "-15*sqrt(221)*C1/512-3*sqrt(2926)*C11/1024-sqrt(595)*C3/512+53*sqrt(102)*C5/1024-105*sqrt(10)*C7/1024-61*sqrt(114)*C9/1024",
            "sqrt(14586)*x*(224*x**4*y**6-3360*x**4*y**4*z**2+3360*x**4*y**2*z**4-224*x**4*z**6-160*x**2*y**8+2240*x**2*y**6*z**2-2240*x**2*y**2*z**6+160*x**2*z**8+15*y**10-195*y**8*z**2-210*y**6*z**4+210*y**4*z**6+195*y**2*z**8-15*z**10)/512",
            "[3*sqrt(1463)/1024,0,61*sqrt(57)/1024,0,105*sqrt(5)/1024,0,-53*sqrt(51)/1024,0,sqrt(1190)/1024,0,15*sqrt(442)/1024,0,-15*sqrt(442)/1024,0,-sqrt(1190)/1024,0,53*sqrt(51)/1024,0,-105*sqrt(5)/1024,0,-61*sqrt(57)/1024,0,-3*sqrt(1463)/1024]",
        ),
        "Qh(11,E,5,1)": (
            "-15*sqrt(221)*S1/512+3*sqrt(2926)*S11/1024+sqrt(595)*S3/512+53*sqrt(102)*S5/1024+105*sqrt(10)*S7/1024-61*sqrt(114)*S9/1024",
            "sqrt(14586)*y*(15*x**10-160*x**8*y**2-195*x**8*z**2+224*x**6*y**4+2240*x**6*y**2*z**2-210*x**6*z**4-3360*x**4*y**4*z**2+210*x**4*z**6+3360*x**2*y**4*z**4-2240*x**2*y**2*z**6+195*x**2*z**8-224*y**4*z**6+160*y**2*z**8-15*z**10)/512",
            "[3*sqrt(1463)*I/1024,0,-61*sqrt(57)*I/1024,0,105*sqrt(5)*I/1024,0,53*sqrt(51)*I/1024,0,sqrt(1190)*I/1024,0,-15*sqrt(442)*I/1024,0,-15*sqrt(442)*I/1024,0,sqrt(1190)*I/1024,0,53*sqrt(51)*I/1024,0,105*sqrt(5)*I/1024,0,-61*sqrt(57)*I/1024,0,3*sqrt(1463)*I/1024]",
        ),
        "Qh(11,E,6,0)": (
            "-21*sqrt(130)*C1/512-sqrt(124355)*C11/512+57*sqrt(14)*C3/512-41*sqrt(15)*C5/512+17*sqrt(17)*C7/512+sqrt(4845)*C9/512",
            "sqrt(2145)*x*(128*x**8*y**2-128*x**8*z**2-768*x**6*y**4+768*x**6*z**4+1008*x**4*y**6+1008*x**4*y**4*z**2-1008*x**4*y**2*z**4-1008*x**4*z**6-336*x**2*y**8-672*x**2*y**6*z**2+672*x**2*y**2*z**6+336*x**2*z**8+21*y**10+63*y**8*z**2+42*y**6*z**4-42*y**4*z**6-63*y**2*z**8-21*z**10)/256",
            "[sqrt(248710)/1024,0,-sqrt(9690)/1024,0,-17*sqrt(34)/1024,0,41*sqrt(30)/1024,0,-57*sqrt(7)/512,0,21*sqrt(65)/512,0,-21*sqrt(65)/512,0,57*sqrt(7)/512,0,-41*sqrt(30)/1024,0,17*sqrt(34)/1024,0,sqrt(9690)/1024,0,-sqrt(248710)/1024]",
        ),
        "Qh(11,E,6,1)": (
            "-21*sqrt(130)*S1/512+sqrt(124355)*S11/512-57*sqrt(14)*S3/512-41*sqrt(15)*S5/512-17*sqrt(17)*S7/512+sqrt(4845)*S9/512",
            "sqrt(2145)*y*(21*x**10-336*x**8*y**2+63*x**8*z**2+1008*x**6*y**4-672*x**6*y**2*z**2+42*x**6*z**4-768*x**4*y**6+1008*x**4*y**4*z**2-42*x**4*z**6+128*x**2*y**8-1008*x**2*y**4*z**4+672*x**2*y**2*z**6-63*x**2*z**8-128*y**8*z**2+768*y**6*z**4-1008*y**4*z**6+336*y**2*z**8-21*z**10)/256",
            "[sqrt(248710)*I/1024,0,sqrt(9690)*I/1024,0,-17*sqrt(34)*I/1024,0,-41*sqrt(30)*I/1024,0,-57*sqrt(7)*I/512,0,-21*sqrt(65)*I/512,0,-21*sqrt(65)*I/512,0,-57*sqrt(7)*I/512,0,-41*sqrt(30)*I/1024,0,-17*sqrt(34)*I/1024,0,sqrt(9690)*I/1024,0,sqrt(248710)*I/1024]",
        ),
    },
    "C4h": {
        "Qh(0,Ag,,)": ("C0", "1", "[1]"),
        "Qh(1,Au,,)": ("C0", "z", "[0,1,0]"),
        "Qh(1,Eu,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(1,Eu,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(2,Ag,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(2,Bg,1,)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(2,Bg,2,)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Qh(2,Eg,,0)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(2,Eg,,1)": ("-C1", "-sqrt(3)*x*z", "[0,sqrt(2)/2,0,-sqrt(2)/2,0]"),
        "Qh(3,Au,,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(3,Bu,1,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(3,Bu,2,)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(3,Eu,1,0)": (
            "-sqrt(6)*C1/4+sqrt(10)*C3/4",
            "x*(2*x**2-3*y**2-3*z**2)/2",
            "[-sqrt(5)/4,0,sqrt(3)/4,0,-sqrt(3)/4,0,sqrt(5)/4]",
        ),
        "Qh(3,Eu,1,1)": (
            "-sqrt(6)*S1/4-sqrt(10)*S3/4",
            "y*(-3*x**2+2*y**2-3*z**2)/2",
            "[-sqrt(5)*I/4,0,-sqrt(3)*I/4,0,-sqrt(3)*I/4,0,-sqrt(5)*I/4]",
        ),
        "Qh(3,Eu,2,0)": (
            "-sqrt(10)*C1/4-sqrt(6)*C3/4",
            "sqrt(15)*x*(y**2-z**2)/2",
            "[sqrt(3)/4,0,sqrt(5)/4,0,-sqrt(5)/4,0,-sqrt(3)/4]",
        ),
        "Qh(3,Eu,2,1)": (
            "-sqrt(10)*S1/4+sqrt(6)*S3/4",
            "sqrt(15)*y*(x**2-z**2)/2",
            "[sqrt(3)*I/4,0,-sqrt(5)*I/4,0,-sqrt(5)*I/4,0,sqrt(3)*I/4]",
        ),
        "Qh(4,Ag,1,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Qh(4,Ag,2,)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "-sqrt(15)*(x**4-12*x**2*y**2+6*x**2*z**2+y**4+6*y**2*z**2-2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Qh(4,Ag,3,)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(4,Bg,1,)": ("-C2", "sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Qh(4,Bg,2,)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(4,Eg,1,0)": (
            "sqrt(2)*(-sqrt(7)*S1-S3)/4",
            "sqrt(35)*y*z*(y**2-z**2)/2",
            "[0,-I/4,0,-sqrt(7)*I/4,0,-sqrt(7)*I/4,0,-I/4,0]",
        ),
        "Qh(4,Eg,1,1)": (
            "sqrt(14)*C1/4-sqrt(2)*C3/4",
            "sqrt(35)*x*z*(-x**2+z**2)/2",
            "[0,1/4,0,-sqrt(7)/4,0,sqrt(7)/4,0,-1/4,0]",
        ),
        "Qh(4,Eg,2,0)": (
            "sqrt(2)*(-S1+sqrt(7)*S3)/4",
            "sqrt(5)*y*z*(6*x**2-y**2-z**2)/2",
            "[0,sqrt(7)*I/4,0,-I/4,0,-I/4,0,sqrt(7)*I/4,0]",
        ),
        "Qh(4,Eg,2,1)": (
            "sqrt(2)*C1/4+sqrt(14)*C3/4",
            "sqrt(5)*x*z*(x**2-6*y**2+z**2)/2",
            "[0,-sqrt(7)/4,0,-1/4,0,1/4,0,sqrt(7)/4,0]",
        ),
        "Qh(5,Au,1,)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(5,Au,2,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(5,Au,3,)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(5,Bu,1,)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(5,Bu,2,)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(5,Eu,1,0)": (
            "sqrt(15)*C1/8-sqrt(70)*C3/16+3*sqrt(14)*C5/16",
            "x*(8*x**4-40*x**2*y**2-40*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/8",
            "[-3*sqrt(7)/16,0,sqrt(35)/16,0,-sqrt(30)/16,0,sqrt(30)/16,0,-sqrt(35)/16,0,3*sqrt(7)/16]",
        ),
        "Qh(5,Eu,1,1)": (
            "sqrt(15)*S1/8+sqrt(70)*S3/16+3*sqrt(14)*S5/16",
            "y*(15*x**4-40*x**2*y**2+30*x**2*z**2+8*y**4-40*y**2*z**2+15*z**4)/8",
            "[3*sqrt(7)*I/16,0,sqrt(35)*I/16,0,sqrt(30)*I/16,0,sqrt(30)*I/16,0,sqrt(35)*I/16,0,3*sqrt(7)*I/16]",
        ),
        "Qh(5,Eu,2,0)": (
            "sqrt(2)*(sqrt(42)*C1+9*C3+sqrt(5)*C5)/16",
            "3*sqrt(35)*x*(y**4-6*y**2*z**2+z**4)/8",
            "[-sqrt(5)/16,0,-9/16,0,-sqrt(42)/16,0,sqrt(42)/16,0,9/16,0,sqrt(5)/16]",
        ),
        "Qh(5,Eu,2,1)": (
            "sqrt(2)*(sqrt(42)*S1-9*S3+sqrt(5)*S5)/16",
            "3*sqrt(35)*y*(x**4-6*x**2*z**2+z**4)/8",
            "[sqrt(5)*I/16,0,-9*I/16,0,sqrt(42)*I/16,0,sqrt(42)*I/16,0,-9*I/16,0,sqrt(5)*I/16]",
        ),
        "Qh(5,Eu,3,0)": (
            "sqrt(7)*C1/4-sqrt(6)*C3/8-sqrt(30)*C5/8",
            "sqrt(105)*x*(2*x**2*y**2-2*x**2*z**2-y**4+z**4)/4",
            "[sqrt(15)/8,0,sqrt(3)/8,0,-sqrt(14)/8,0,sqrt(14)/8,0,-sqrt(3)/8,0,-sqrt(15)/8]",
        ),
        "Qh(5,Eu,3,1)": (
            "sqrt(7)*S1/4+sqrt(6)*S3/8-sqrt(30)*S5/8",
            "sqrt(105)*y*(-x**4+2*x**2*y**2-2*y**2*z**2+z**4)/4",
            "[-sqrt(15)*I/8,0,sqrt(3)*I/8,0,sqrt(14)*I/8,0,sqrt(14)*I/8,0,sqrt(3)*I/8,0,-sqrt(15)*I/8]",
        ),
        "Qh(6,Ag,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Qh(6,Ag,2,)": (
            "sqrt(14)*C0/4+sqrt(2)*C4/4",
            "-sqrt(14)*(x**6-15*x**4*z**2+15*x**2*z**4+y**6-15*y**4*z**2+15*y**2*z**4-2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Qh(6,Ag,3,)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(6,Bg,1,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Qh(6,Bg,2,)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x-y)*(x+y)*(x**4-9*x**2*y**2-5*x**2*z**2+y**4-5*y**2*z**2+5*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Qh(6,Bg,3,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(6,Bg,4,)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(6,Eg,1,0)": (
            "sqrt(3)*S1/4-sqrt(30)*S3/8-sqrt(22)*S5/8",
            "3*sqrt(7)*y*z*(10*x**2*y**2-10*x**2*z**2-y**4+z**4)/4",
            "[0,-sqrt(11)*I/8,0,-sqrt(15)*I/8,0,sqrt(6)*I/8,0,sqrt(6)*I/8,0,-sqrt(15)*I/8,0,-sqrt(11)*I/8,0]",
        ),
        "Qh(6,Eg,1,1)": (
            "-sqrt(3)*C1/4-sqrt(30)*C3/8+sqrt(22)*C5/8",
            "3*sqrt(7)*x*z*(x**4-10*x**2*y**2+10*y**2*z**2-z**4)/4",
            "[0,-sqrt(11)/8,0,sqrt(15)/8,0,sqrt(6)/8,0,-sqrt(6)/8,0,-sqrt(15)/8,0,sqrt(11)/8,0]",
        ),
        "Qh(6,Eg,2,0)": (
            "3*sqrt(22)*S1/16+sqrt(55)*S3/16+sqrt(3)*S5/16",
            "sqrt(462)*y*z*(3*y**4-10*y**2*z**2+3*z**4)/16",
            "[0,sqrt(6)*I/32,0,sqrt(110)*I/32,0,3*sqrt(11)*I/16,0,3*sqrt(11)*I/16,0,sqrt(110)*I/32,0,sqrt(6)*I/32,0]",
        ),
        "Qh(6,Eg,2,1)": (
            "-3*sqrt(22)*C1/16+sqrt(55)*C3/16-sqrt(3)*C5/16",
            "sqrt(462)*x*z*(-3*x**4+10*x**2*z**2-3*z**4)/16",
            "[0,sqrt(6)/32,0,-sqrt(110)/32,0,3*sqrt(11)/16,0,-3*sqrt(11)/16,0,sqrt(110)/32,0,-sqrt(6)/32,0]",
        ),
        "Qh(6,Eg,3,0)": (
            "sqrt(10)*S1/16-9*S3/16+sqrt(165)*S5/16",
            "sqrt(210)*y*z*(16*x**4-16*x**2*y**2-16*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,sqrt(330)*I/32,0,-9*sqrt(2)*I/32,0,sqrt(5)*I/16,0,sqrt(5)*I/16,0,-9*sqrt(2)*I/32,0,sqrt(330)*I/32,0]",
        ),
        "Qh(6,Eg,3,1)": (
            "-sqrt(10)*C1/16-9*C3/16-sqrt(165)*C5/16",
            "sqrt(210)*x*z*(-x**4+16*x**2*y**2-2*x**2*z**2-16*y**4+16*y**2*z**2-z**4)/16",
            "[0,sqrt(330)/32,0,9*sqrt(2)/32,0,sqrt(5)/16,0,-sqrt(5)/16,0,-9*sqrt(2)/32,0,-sqrt(330)/32,0]",
        ),
        "Qh(7,Au,1,)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(7,Au,2,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(7,Au,3,)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(7,Bu,1,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Qh(7,Bu,2,)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "-sqrt(77)*x*y*z*(3*x**4-20*x**2*y**2+10*x**2*z**2+3*y**4+10*y**2*z**2-6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Qh(7,Bu,3,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(7,Bu,4,)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(7,Eu,1,0)": (
            "-5*sqrt(7)*C1/32+3*sqrt(21)*C3/32-sqrt(231)*C5/32+sqrt(429)*C7/32",
            "x*(16*x**6-168*x**4*y**2-168*x**4*z**2+210*x**2*y**4+420*x**2*y**2*z**2+210*x**2*z**4-35*y**6-105*y**4*z**2-105*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)/64,0,sqrt(462)/64,0,-3*sqrt(42)/64,0,5*sqrt(14)/64,0,-5*sqrt(14)/64,0,3*sqrt(42)/64,0,-sqrt(462)/64,0,sqrt(858)/64]",
        ),
        "Qh(7,Eu,1,1)": (
            "-5*sqrt(7)*S1/32-3*sqrt(21)*S3/32-sqrt(231)*S5/32-sqrt(429)*S7/32",
            "y*(-35*x**6+210*x**4*y**2-105*x**4*z**2-168*x**2*y**4+420*x**2*y**2*z**2-105*x**2*z**4+16*y**6-168*y**4*z**2+210*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)*I/64,0,-sqrt(462)*I/64,0,-3*sqrt(42)*I/64,0,-5*sqrt(14)*I/64,0,-5*sqrt(14)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(462)*I/64,0,-sqrt(858)*I/64]",
        ),
        "Qh(7,Eu,2,0)": (
            "-3*sqrt(33)*C1/32-sqrt(11)*C3/32+25*C5/32+sqrt(91)*C7/32",
            "sqrt(231)*x*(10*x**2*y**4-60*x**2*y**2*z**2+10*x**2*z**4-3*y**6+15*y**4*z**2+15*y**2*z**4-3*z**6)/16",
            "[-sqrt(182)/64,0,-25*sqrt(2)/64,0,sqrt(22)/64,0,3*sqrt(66)/64,0,-3*sqrt(66)/64,0,-sqrt(22)/64,0,25*sqrt(2)/64,0,sqrt(182)/64]",
        ),
        "Qh(7,Eu,2,1)": (
            "-3*sqrt(33)*S1/32+sqrt(11)*S3/32+25*S5/32-sqrt(91)*S7/32",
            "sqrt(231)*y*(-3*x**6+10*x**4*y**2+15*x**4*z**2-60*x**2*y**2*z**2+15*x**2*z**4+10*y**2*z**4-3*z**6)/16",
            "[-sqrt(182)*I/64,0,25*sqrt(2)*I/64,0,sqrt(22)*I/64,0,-3*sqrt(66)*I/64,0,-3*sqrt(66)*I/64,0,sqrt(22)*I/64,0,25*sqrt(2)*I/64,0,-sqrt(182)*I/64]",
        ),
        "Qh(7,Eu,3,0)": (
            "-sqrt(858)*C1/64-3*sqrt(286)*C3/64-5*sqrt(26)*C5/64-sqrt(14)*C7/64",
            "sqrt(6006)*x*(y**6-15*y**4*z**2+15*y**2*z**4-z**6)/32",
            "[sqrt(7)/64,0,5*sqrt(13)/64,0,3*sqrt(143)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-3*sqrt(143)/64,0,-5*sqrt(13)/64,0,-sqrt(7)/64]",
        ),
        "Qh(7,Eu,3,1)": (
            "-sqrt(858)*S1/64+3*sqrt(286)*S3/64-5*sqrt(26)*S5/64+sqrt(14)*S7/64",
            "sqrt(6006)*y*(x**6-15*x**4*z**2+15*x**2*z**4-z**6)/32",
            "[sqrt(7)*I/64,0,-5*sqrt(13)*I/64,0,3*sqrt(143)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,3*sqrt(143)*I/64,0,-5*sqrt(13)*I/64,0,sqrt(7)*I/64]",
        ),
        "Qh(7,Eu,4,0)": (
            "sqrt(2)*(-15*sqrt(3)*C1+19*C3-sqrt(11)*C5-sqrt(1001)*C7)/64",
            "sqrt(42)*x*(48*x**4*y**2-48*x**4*z**2-80*x**2*y**4+80*x**2*z**4+15*y**6+15*y**4*z**2-15*y**2*z**4-15*z**6)/32",
            "[sqrt(1001)/64,0,sqrt(11)/64,0,-19/64,0,15*sqrt(3)/64,0,-15*sqrt(3)/64,0,19/64,0,-sqrt(11)/64,0,-sqrt(1001)/64]",
        ),
        "Qh(7,Eu,4,1)": (
            "-15*sqrt(6)*S1/64-19*sqrt(2)*S3/64-sqrt(22)*S5/64+sqrt(2002)*S7/64",
            "sqrt(42)*y*(15*x**6-80*x**4*y**2+15*x**4*z**2+48*x**2*y**4-15*x**2*z**4-48*y**4*z**2+80*y**2*z**4-15*z**6)/32",
            "[sqrt(1001)*I/64,0,-sqrt(11)*I/64,0,-19*I/64,0,-15*sqrt(3)*I/64,0,-15*sqrt(3)*I/64,0,-19*I/64,0,-sqrt(11)*I/64,0,sqrt(1001)*I/64]",
        ),
        "Qh(8,Ag,1,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Qh(8,Ag,2,)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Qh(8,Ag,3,)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Qh(8,Ag,4,)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(8,Ag,5,)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(8,Bg,1,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(8,Bg,2,)": (
            "C2",
            "-3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(8,Bg,3,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(8,Bg,4,)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(8,Eg,1,0)": (
            "-sqrt(715)*S1/32-sqrt(273)*S3/32-sqrt(35)*S5/32-S7/32",
            "3*sqrt(715)*y*z*(y**6-7*y**4*z**2+7*y**2*z**4-z**6)/16",
            "[0,-sqrt(2)*I/64,0,-sqrt(70)*I/64,0,-sqrt(546)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(546)*I/64,0,-sqrt(70)*I/64,0,-sqrt(2)*I/64,0]",
        ),
        "Qh(8,Eg,1,1)": (
            "sqrt(715)*C1/32-sqrt(273)*C3/32+sqrt(35)*C5/32-C7/32",
            "3*sqrt(715)*x*z*(-x**6+7*x**4*z**2-7*x**2*z**4+z**6)/16",
            "[0,sqrt(2)/64,0,-sqrt(70)/64,0,sqrt(546)/64,0,-sqrt(1430)/64,0,sqrt(1430)/64,0,-sqrt(546)/64,0,sqrt(70)/64,0,-sqrt(2)/64,0]",
        ),
        "Qh(8,Eg,2,0)": (
            "-sqrt(77)*S1/32+5*sqrt(15)*S3/32-3*sqrt(13)*S5/32-sqrt(455)*S7/32",
            "3*sqrt(77)*y*z*(40*x**4*y**2-40*x**4*z**2-24*x**2*y**4+24*x**2*z**4+y**6+y**4*z**2-y**2*z**4-z**6)/16",
            "[0,-sqrt(910)*I/64,0,-3*sqrt(26)*I/64,0,5*sqrt(30)*I/64,0,-sqrt(154)*I/64,0,-sqrt(154)*I/64,0,5*sqrt(30)*I/64,0,-3*sqrt(26)*I/64,0,-sqrt(910)*I/64,0]",
        ),
        "Qh(8,Eg,2,1)": (
            "sqrt(77)*C1/32+5*sqrt(15)*C3/32+3*sqrt(13)*C5/32-sqrt(455)*C7/32",
            "3*sqrt(77)*x*z*(-x**6+24*x**4*y**2-x**4*z**2-40*x**2*y**4+x**2*z**4+40*y**4*z**2-24*y**2*z**4+z**6)/16",
            "[0,sqrt(910)/64,0,-3*sqrt(26)/64,0,-5*sqrt(30)/64,0,-sqrt(154)/64,0,sqrt(154)/64,0,5*sqrt(30)/64,0,3*sqrt(26)/64,0,-sqrt(910)/64,0]",
        ),
        "Qh(8,Eg,3,0)": (
            "-sqrt(858)*S1/64+sqrt(910)*S3/64+7*sqrt(42)*S5/64+3*sqrt(30)*S7/64",
            "sqrt(858)*y*z*(42*x**2*y**4-140*x**2*y**2*z**2+42*x**2*z**4-3*y**6+7*y**4*z**2+7*y**2*z**4-3*z**6)/32",
            "[0,3*sqrt(15)*I/64,0,7*sqrt(21)*I/64,0,sqrt(455)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(455)*I/64,0,7*sqrt(21)*I/64,0,3*sqrt(15)*I/64,0]",
        ),
        "Qh(8,Eg,3,1)": (
            "sqrt(858)*C1/64+sqrt(910)*C3/64-7*sqrt(42)*C5/64+3*sqrt(30)*C7/64",
            "sqrt(858)*x*z*(3*x**6-42*x**4*y**2-7*x**4*z**2+140*x**2*y**2*z**2-7*x**2*z**4-42*y**2*z**4+3*z**6)/32",
            "[0,-3*sqrt(15)/64,0,7*sqrt(21)/64,0,-sqrt(455)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(455)/64,0,-7*sqrt(21)/64,0,3*sqrt(15)/64,0]",
        ),
        "Qh(8,Eg,4,0)": (
            "-sqrt(70)*S1/64+3*sqrt(66)*S3/64-sqrt(1430)*S5/64+sqrt(2002)*S7/64",
            "3*sqrt(70)*y*z*(32*x**6-80*x**4*y**2-80*x**4*z**2+30*x**2*y**4+60*x**2*y**2*z**2+30*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,sqrt(1001)*I/64,0,-sqrt(715)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(35)*I/64,0,-sqrt(35)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(715)*I/64,0,sqrt(1001)*I/64,0]",
        ),
        "Qh(8,Eg,4,1)": (
            "sqrt(70)*C1/64+3*sqrt(66)*C3/64+sqrt(1430)*C5/64+sqrt(2002)*C7/64",
            "3*sqrt(70)*x*z*(x**6-30*x**4*y**2+3*x**4*z**2+80*x**2*y**4-60*x**2*y**2*z**2+3*x**2*z**4-32*y**6+80*y**4*z**2-30*y**2*z**4+z**6)/32",
            "[0,-sqrt(1001)/64,0,-sqrt(715)/64,0,-3*sqrt(33)/64,0,-sqrt(35)/64,0,sqrt(35)/64,0,3*sqrt(33)/64,0,sqrt(715)/64,0,sqrt(1001)/64,0]",
        ),
        "Qh(9,Au,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Qh(9,Au,2,)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(x-y)*(x+y)*(3*x**4-11*x**2*y**2-7*x**2*z**2+3*y**4-7*y**2*z**2+7*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Qh(9,Au,3,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Au,4,)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,Au,5,)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(9,Bu,1,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Qh(9,Bu,2,)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Qh(9,Bu,3,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,Bu,4,)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Eu,1,0)": (
            "21*sqrt(5)*C1/128-sqrt(2310)*C3/128+3*sqrt(286)*C5/128-3*sqrt(1430)*C7/256+sqrt(24310)*C9/256",
            "x*(128*x**8-2304*x**6*y**2-2304*x**6*z**2+6048*x**4*y**4+12096*x**4*y**2*z**2+6048*x**4*z**4-3360*x**2*y**6-10080*x**2*y**4*z**2-10080*x**2*y**2*z**4-3360*x**2*z**6+315*y**8+1260*y**6*z**2+1890*y**4*z**4+1260*y**2*z**6+315*z**8)/128",
            "[-sqrt(12155)/256,0,3*sqrt(715)/256,0,-3*sqrt(143)/128,0,sqrt(1155)/128,0,-21*sqrt(10)/256,0,21*sqrt(10)/256,0,-sqrt(1155)/128,0,3*sqrt(143)/128,0,-3*sqrt(715)/256,0,sqrt(12155)/256]",
        ),
        "Qh(9,Eu,1,1)": (
            "21*sqrt(5)*S1/128+sqrt(2310)*S3/128+3*sqrt(286)*S5/128+3*sqrt(1430)*S7/256+sqrt(24310)*S9/256",
            "y*(315*x**8-3360*x**6*y**2+1260*x**6*z**2+6048*x**4*y**4-10080*x**4*y**2*z**2+1890*x**4*z**4-2304*x**2*y**6+12096*x**2*y**4*z**2-10080*x**2*y**2*z**4+1260*x**2*z**6+128*y**8-2304*y**6*z**2+6048*y**4*z**4-3360*y**2*z**6+315*z**8)/128",
            "[sqrt(12155)*I/256,0,3*sqrt(715)*I/256,0,3*sqrt(143)*I/128,0,sqrt(1155)*I/128,0,21*sqrt(10)*I/256,0,21*sqrt(10)*I/256,0,sqrt(1155)*I/128,0,3*sqrt(143)*I/128,0,3*sqrt(715)*I/256,0,sqrt(12155)*I/256]",
        ),
        "Qh(9,Eu,2,0)": (
            "sqrt(2)*(sqrt(4862)*C1+2*sqrt(4641)*C3+10*sqrt(85)*C5+7*sqrt(17)*C7+3*C9)/256",
            "3*sqrt(12155)*x*(y**8-28*y**6*z**2+70*y**4*z**4-28*y**2*z**6+z**8)/128",
            "[-3/256,0,-7*sqrt(17)/256,0,-5*sqrt(85)/128,0,-sqrt(4641)/128,0,-sqrt(4862)/256,0,sqrt(4862)/256,0,sqrt(4641)/128,0,5*sqrt(85)/128,0,7*sqrt(17)/256,0,3/256]",
        ),
        "Qh(9,Eu,2,1)": (
            "sqrt(2)*(sqrt(4862)*S1-2*sqrt(4641)*S3+10*sqrt(85)*S5-7*sqrt(17)*S7+3*S9)/256",
            "3*sqrt(12155)*y*(x**8-28*x**6*z**2+70*x**4*z**4-28*x**2*z**6+z**8)/128",
            "[3*I/256,0,-7*sqrt(17)*I/256,0,5*sqrt(85)*I/128,0,-sqrt(4641)*I/128,0,sqrt(4862)*I/256,0,sqrt(4862)*I/256,0,-sqrt(4641)*I/128,0,5*sqrt(85)*I/128,0,-7*sqrt(17)*I/256,0,3*I/256]",
        ),
        "Qh(9,Eu,3,0)": (
            "sqrt(1001)*C1/64-sqrt(78)*C3/64-3*sqrt(70)*C5/64+23*sqrt(14)*C7/128+3*sqrt(238)*C9/128",
            "3*sqrt(5005)*x*(8*x**4*y**4-48*x**4*y**2*z**2+8*x**4*z**4-8*x**2*y**6+40*x**2*y**4*z**2+40*x**2*y**2*z**4-8*x**2*z**6+y**8-4*y**6*z**2-10*y**4*z**4-4*y**2*z**6+z**8)/64",
            "[-3*sqrt(119)/128,0,-23*sqrt(7)/128,0,3*sqrt(35)/64,0,sqrt(39)/64,0,-sqrt(2002)/128,0,sqrt(2002)/128,0,-sqrt(39)/64,0,-3*sqrt(35)/64,0,23*sqrt(7)/128,0,3*sqrt(119)/128]",
        ),
        "Qh(9,Eu,3,1)": (
            "sqrt(1001)*S1/64+sqrt(78)*S3/64-3*sqrt(70)*S5/64-23*sqrt(14)*S7/128+3*sqrt(238)*S9/128",
            "3*sqrt(5005)*y*(x**8-8*x**6*y**2-4*x**6*z**2+8*x**4*y**4+40*x**4*y**2*z**2-10*x**4*z**4-48*x**2*y**4*z**2+40*x**2*y**2*z**4-4*x**2*z**6+8*y**4*z**4-8*y**2*z**6+z**8)/64",
            "[3*sqrt(119)*I/128,0,-23*sqrt(7)*I/128,0,-3*sqrt(35)*I/64,0,sqrt(39)*I/64,0,sqrt(2002)*I/128,0,sqrt(2002)*I/128,0,sqrt(39)*I/64,0,-3*sqrt(35)*I/64,0,-23*sqrt(7)*I/128,0,3*sqrt(119)*I/128]",
        ),
        "Qh(9,Eu,4,0)": (
            "sqrt(858)*C1/64+sqrt(91)*C3/32-5*sqrt(15)*C5/32-21*sqrt(3)*C7/64-sqrt(51)*C9/64",
            "sqrt(4290)*x*(14*x**2*y**6-210*x**2*y**4*z**2+210*x**2*y**2*z**4-14*x**2*z**6-3*y**8+42*y**6*z**2-42*y**2*z**6+3*z**8)/64",
            "[sqrt(102)/128,0,21*sqrt(6)/128,0,5*sqrt(30)/64,0,-sqrt(182)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(182)/64,0,-5*sqrt(30)/64,0,-21*sqrt(6)/128,0,-sqrt(102)/128]",
        ),
        "Qh(9,Eu,4,1)": (
            "sqrt(858)*S1/64-sqrt(91)*S3/32-5*sqrt(15)*S5/32+21*sqrt(3)*S7/64-sqrt(51)*S9/64",
            "sqrt(4290)*y*(-3*x**8+14*x**6*y**2+42*x**6*z**2-210*x**4*y**2*z**2+210*x**2*y**2*z**4-42*x**2*z**6-14*y**2*z**6+3*z**8)/64",
            "[-sqrt(102)*I/128,0,21*sqrt(6)*I/128,0,-5*sqrt(30)*I/64,0,-sqrt(182)*I/64,0,sqrt(429)*I/64,0,sqrt(429)*I/64,0,-sqrt(182)*I/64,0,-5*sqrt(30)*I/64,0,21*sqrt(6)*I/128,0,-sqrt(102)*I/128]",
        ),
        "Qh(9,Eu,5,0)": (
            "7*sqrt(22)*C1/64-3*sqrt(21)*C3/32+sqrt(65)*C5/32+sqrt(13)*C7/64-3*sqrt(221)*C9/64",
            "3*sqrt(110)*x*(32*x**6*y**2-32*x**6*z**2-112*x**4*y**4+112*x**4*z**4+70*x**2*y**6+70*x**2*y**4*z**2-70*x**2*y**2*z**4-70*x**2*z**6-7*y**8-14*y**6*z**2+14*y**2*z**6+7*z**8)/64",
            "[3*sqrt(442)/128,0,-sqrt(26)/128,0,-sqrt(130)/64,0,3*sqrt(42)/64,0,-7*sqrt(11)/64,0,7*sqrt(11)/64,0,-3*sqrt(42)/64,0,sqrt(130)/64,0,sqrt(26)/128,0,-3*sqrt(442)/128]",
        ),
        "Qh(9,Eu,5,1)": (
            "7*sqrt(22)*S1/64+3*sqrt(21)*S3/32+sqrt(65)*S5/32-sqrt(13)*S7/64-3*sqrt(221)*S9/64",
            "3*sqrt(110)*y*(-7*x**8+70*x**6*y**2-14*x**6*z**2-112*x**4*y**4+70*x**4*y**2*z**2+32*x**2*y**6-70*x**2*y**2*z**4+14*x**2*z**6-32*y**6*z**2+112*y**4*z**4-70*y**2*z**6+7*z**8)/64",
            "[-3*sqrt(442)*I/128,0,-sqrt(26)*I/128,0,sqrt(130)*I/64,0,3*sqrt(42)*I/64,0,7*sqrt(11)*I/64,0,7*sqrt(11)*I/64,0,3*sqrt(42)*I/64,0,sqrt(130)*I/64,0,-sqrt(26)*I/128,0,-3*sqrt(442)*I/128]",
        ),
        "Qh(10,Ag,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Qh(10,Ag,2,)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "-sqrt(420189)*(22*x**10+45*x**8*y**2-1035*x**8*z**2-105*x**6*y**4-630*x**6*y**2*z**2+4935*x**6*z**4-105*x**4*y**6+3150*x**4*y**4*z**2-1575*x**4*y**2*z**4-4830*x**4*z**6+45*x**2*y**8-630*x**2*y**6*z**2-1575*x**2*y**4*z**4+1260*x**2*y**2*z**6+990*x**2*z**8+22*y**10-1035*y**8*z**2+4935*y**6*z**4-4830*y**4*z**6+990*y**2*z**8-44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Qh(10,Ag,3,)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "-sqrt(3213210)*(3*x**10-96*x**8*y**2-39*x**8*z**2+224*x**6*y**4+1344*x**6*y**2*z**2-42*x**6*z**4+224*x**4*y**6-6720*x**4*y**4*z**2+3360*x**4*y**2*z**4-182*x**4*z**6-96*x**2*y**8+1344*x**2*y**6*z**2+3360*x**2*y**4*z**4-2688*x**2*y**2*z**6+135*x**2*z**8+3*y**10-39*y**8*z**2-42*y**6*z**4-182*y**4*z**6+135*y**2*z**8-6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Qh(10,Ag,4,)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(10,Ag,5,)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(10,Bg,1,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Qh(10,Bg,2,)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(x-y)*(x+y)*(22*x**8-653*x**6*y**2-315*x**6*z**2+2602*x**4*y**4-945*x**4*y**2*z**2+1575*x**4*z**4-653*x**2*y**6-945*x**2*y**4*z**2+3150*x**2*y**2*z**4-1680*x**2*z**6+22*y**8-315*y**6*z**2+1575*y**4*z**4-1680*y**2*z**6+360*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Qh(10,Bg,3,)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(x-y)*(x+y)*(9*x**8-165*x**6*y**2-231*x**6*z**2-25*x**4*y**4+3801*x**4*y**2*z**2+406*x**4*z**4-165*x**2*y**6+3801*x**2*y**4*z**2-9674*x**2*y**2*z**4+266*x**2*z**6+9*y**8-231*y**6*z**2+406*y**4*z**4+266*y**2*z**6-57*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Qh(10,Bg,4,)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(10,Bg,5,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,Bg,6,)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Eg,1,0)": (
            "sqrt(221)*S1/32-sqrt(102)*S3/32-sqrt(510)*S5/32-11*sqrt(6)*S7/64-sqrt(38)*S9/64",
            "sqrt(12155)*y*z*(18*x**2*y**6-126*x**2*y**4*z**2+126*x**2*y**2*z**4-18*x**2*z**6-y**8+6*y**6*z**2-6*y**2*z**6+z**8)/32",
            "[0,-sqrt(19)*I/64,0,-11*sqrt(3)*I/64,0,-sqrt(255)*I/32,0,-sqrt(51)*I/32,0,sqrt(442)*I/64,0,sqrt(442)*I/64,0,-sqrt(51)*I/32,0,-sqrt(255)*I/32,0,-11*sqrt(3)*I/64,0,-sqrt(19)*I/64,0]",
        ),
        "Qh(10,Eg,1,1)": (
            "-sqrt(221)*C1/32-sqrt(102)*C3/32+sqrt(510)*C5/32-11*sqrt(6)*C7/64+sqrt(38)*C9/64",
            "sqrt(12155)*x*z*(x**8-18*x**6*y**2-6*x**6*z**2+126*x**4*y**2*z**2-126*x**2*y**2*z**4+6*x**2*z**6+18*y**2*z**6-z**8)/32",
            "[0,-sqrt(19)/64,0,11*sqrt(3)/64,0,-sqrt(255)/32,0,sqrt(51)/32,0,sqrt(442)/64,0,-sqrt(442)/64,0,-sqrt(51)/32,0,sqrt(255)/32,0,-11*sqrt(3)/64,0,sqrt(19)/64,0]",
        ),
        "Qh(10,Eg,2,0)": (
            "sqrt(2)*(sqrt(78)*S1-22*S3+10*sqrt(5)*S5-sqrt(17)*S7-sqrt(969)*S9)/64",
            "sqrt(2145)*y*z*(112*x**6*y**2-112*x**6*z**2-168*x**4*y**4+168*x**4*z**4+42*x**2*y**6+42*x**2*y**4*z**2-42*x**2*y**2*z**4-42*x**2*z**6-y**8-2*y**6*z**2+2*y**2*z**6+z**8)/32",
            "[0,-sqrt(969)*I/64,0,-sqrt(17)*I/64,0,5*sqrt(5)*I/32,0,-11*I/32,0,sqrt(78)*I/64,0,sqrt(78)*I/64,0,-11*I/32,0,5*sqrt(5)*I/32,0,-sqrt(17)*I/64,0,-sqrt(969)*I/64,0]",
        ),
        "Qh(10,Eg,2,1)": (
            "-sqrt(2)*(sqrt(78)*C1+22*C3+10*sqrt(5)*C5+sqrt(17)*C7-sqrt(969)*C9)/64",
            "sqrt(2145)*x*z*(x**8-42*x**6*y**2+2*x**6*z**2+168*x**4*y**4-42*x**4*y**2*z**2-112*x**2*y**6+42*x**2*y**2*z**4-2*x**2*z**6+112*y**6*z**2-168*y**4*z**4+42*y**2*z**6-z**8)/32",
            "[0,-sqrt(969)/64,0,sqrt(17)/64,0,5*sqrt(5)/32,0,11/32,0,sqrt(78)/64,0,-sqrt(78)/64,0,-11/32,0,-5*sqrt(5)/32,0,-sqrt(17)/64,0,sqrt(969)/64,0]",
        ),
        "Qh(10,Eg,3,0)": (
            "sqrt(41990)*S1/256+sqrt(4845)*S3/128+sqrt(969)*S5/128+sqrt(285)*S7/256+sqrt(5)*S9/256",
            "sqrt(92378)*y*z*(5*y**8-60*y**6*z**2+126*y**4*z**4-60*y**2*z**6+5*z**8)/256",
            "[0,sqrt(10)*I/512,0,sqrt(570)*I/512,0,sqrt(1938)*I/256,0,sqrt(9690)*I/256,0,sqrt(20995)*I/256,0,sqrt(20995)*I/256,0,sqrt(9690)*I/256,0,sqrt(1938)*I/256,0,sqrt(570)*I/512,0,sqrt(10)*I/512,0]",
        ),
        "Qh(10,Eg,3,1)": (
            "-sqrt(41990)*C1/256+sqrt(4845)*C3/128-sqrt(969)*C5/128+sqrt(285)*C7/256-sqrt(5)*C9/256",
            "sqrt(92378)*x*z*(-5*x**8+60*x**6*z**2-126*x**4*z**4+60*x**2*z**6-5*z**8)/256",
            "[0,sqrt(10)/512,0,-sqrt(570)/512,0,sqrt(1938)/256,0,-sqrt(9690)/256,0,sqrt(20995)/256,0,-sqrt(20995)/256,0,sqrt(9690)/256,0,-sqrt(1938)/256,0,sqrt(570)/512,0,-sqrt(10)/512,0]",
        ),
        "Qh(10,Eg,4,0)": (
            "9*sqrt(78)*S1/256-69*S3/128-sqrt(5)*S5/128+43*sqrt(17)*S7/256+3*sqrt(969)*S9/256",
            "sqrt(4290)*y*z*(672*x**4*y**4-2240*x**4*y**2*z**2+672*x**4*z**4-288*x**2*y**6+672*x**2*y**4*z**2+672*x**2*y**2*z**4-288*x**2*z**6+9*y**8-12*y**6*z**2-42*y**4*z**4-12*y**2*z**6+9*z**8)/256",
            "[0,3*sqrt(1938)*I/512,0,43*sqrt(34)*I/512,0,-sqrt(10)*I/256,0,-69*sqrt(2)*I/256,0,9*sqrt(39)*I/256,0,9*sqrt(39)*I/256,0,-69*sqrt(2)*I/256,0,-sqrt(10)*I/256,0,43*sqrt(34)*I/512,0,3*sqrt(1938)*I/512,0]",
        ),
        "Qh(10,Eg,4,1)": (
            "-9*sqrt(78)*C1/256-69*C3/128+sqrt(5)*C5/128+43*sqrt(17)*C7/256-3*sqrt(969)*C9/256",
            "sqrt(4290)*x*z*(-9*x**8+288*x**6*y**2+12*x**6*z**2-672*x**4*y**4-672*x**4*y**2*z**2+42*x**4*z**4+2240*x**2*y**4*z**2-672*x**2*y**2*z**4+12*x**2*z**6-672*y**4*z**4+288*y**2*z**6-9*z**8)/256",
            "[0,3*sqrt(1938)/512,0,-43*sqrt(34)/512,0,-sqrt(10)/256,0,69*sqrt(2)/256,0,9*sqrt(39)/256,0,-9*sqrt(39)/256,0,-69*sqrt(2)/256,0,sqrt(10)/256,0,43*sqrt(34)/512,0,-3*sqrt(1938)/512,0]",
        ),
        "Qh(10,Eg,5,0)": (
            "7*sqrt(3)*S1/128-7*sqrt(26)*S3/128+5*sqrt(130)*S5/128-7*sqrt(442)*S7/256+sqrt(25194)*S9/256",
            "sqrt(165)*y*z*(384*x**8-1792*x**6*y**2-1792*x**6*z**2+1680*x**4*y**4+3360*x**4*y**2*z**2+1680*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+7*y**8+28*y**6*z**2+42*y**4*z**4+28*y**2*z**6+7*z**8)/128",
            "[0,sqrt(12597)*I/256,0,-7*sqrt(221)*I/256,0,5*sqrt(65)*I/128,0,-7*sqrt(13)*I/128,0,7*sqrt(6)*I/256,0,7*sqrt(6)*I/256,0,-7*sqrt(13)*I/128,0,5*sqrt(65)*I/128,0,-7*sqrt(221)*I/256,0,sqrt(12597)*I/256,0]",
        ),
        "Qh(10,Eg,5,1)": (
            "-7*sqrt(3)*C1/128-7*sqrt(26)*C3/128-5*sqrt(130)*C5/128-7*sqrt(442)*C7/256-sqrt(25194)*C9/256",
            "sqrt(165)*x*z*(-7*x**8+336*x**6*y**2-28*x**6*z**2-1680*x**4*y**4+1008*x**4*y**2*z**2-42*x**4*z**4+1792*x**2*y**6-3360*x**2*y**4*z**2+1008*x**2*y**2*z**4-28*x**2*z**6-384*y**8+1792*y**6*z**2-1680*y**4*z**4+336*y**2*z**6-7*z**8)/128",
            "[0,sqrt(12597)/256,0,7*sqrt(221)/256,0,5*sqrt(65)/128,0,7*sqrt(13)/128,0,7*sqrt(6)/256,0,-7*sqrt(6)/256,0,-7*sqrt(13)/128,0,-5*sqrt(65)/128,0,-7*sqrt(221)/256,0,-sqrt(12597)/256,0]",
        ),
        "Qh(11,Au,1,)": (
            "S8",
            "-sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(11,Au,2,)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Au,3,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Au,4,)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(11,Au,5,)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Bu,1,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Qh(11,Bu,2,)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "-sqrt(230945)*x*y*z*(x**8-6*x**6*y**2-6*x**6*z**2+42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2-84*x**2*y**2*z**4+12*x**2*z**6+y**8-6*y**6*z**2+12*y**2*z**6-2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Qh(11,Bu,3,)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "-sqrt(3003)*x*y*z*(5*x**8-150*x**6*y**2+90*x**6*z**2+336*x**4*y**4-70*x**4*y**2*z**2-168*x**4*z**4-150*x**2*y**6-70*x**2*y**4*z**2+140*x**2*y**2*z**4+60*x**2*z**6+5*y**8+90*y**6*z**2-168*y**4*z**4+60*y**2*z**6-10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Qh(11,Bu,4,)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(11,Bu,5,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,Bu,6,)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eu,1,0)": (
            "-21*sqrt(66)*C1/512+sqrt(88179)*C11/512+sqrt(30030)*C3/512-15*sqrt(143)*C5/512+sqrt(36465)*C7/512-sqrt(46189)*C9/512",
            "x*(256*x**10-7040*x**8*y**2-7040*x**8*z**2+31680*x**6*y**4+63360*x**6*y**2*z**2+31680*x**6*z**4-36960*x**4*y**6-110880*x**4*y**4*z**2-110880*x**4*y**2*z**4-36960*x**4*z**6+11550*x**2*y**8+46200*x**2*y**6*z**2+69300*x**2*y**4*z**4+46200*x**2*y**2*z**6+11550*x**2*z**8-693*y**10-3465*y**8*z**2-6930*y**6*z**4-6930*y**4*z**6-3465*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)/1024,0,sqrt(92378)/1024,0,-sqrt(72930)/1024,0,15*sqrt(286)/1024,0,-sqrt(15015)/512,0,21*sqrt(33)/512,0,-21*sqrt(33)/512,0,sqrt(15015)/512,0,-15*sqrt(286)/1024,0,sqrt(72930)/1024,0,-sqrt(92378)/1024,0,sqrt(176358)/1024]",
        ),
        "Qh(11,Eu,1,1)": (
            "-21*sqrt(66)*S1/512-sqrt(88179)*S11/512-sqrt(30030)*S3/512-15*sqrt(143)*S5/512-sqrt(36465)*S7/512-sqrt(46189)*S9/512",
            "y*(-693*x**10+11550*x**8*y**2-3465*x**8*z**2-36960*x**6*y**4+46200*x**6*y**2*z**2-6930*x**6*z**4+31680*x**4*y**6-110880*x**4*y**4*z**2+69300*x**4*y**2*z**4-6930*x**4*z**6-7040*x**2*y**8+63360*x**2*y**6*z**2-110880*x**2*y**4*z**4+46200*x**2*y**2*z**6-3465*x**2*z**8+256*y**10-7040*y**8*z**2+31680*y**6*z**4-36960*y**4*z**6+11550*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(72930)*I/1024,0,-15*sqrt(286)*I/1024,0,-sqrt(15015)*I/512,0,-21*sqrt(33)*I/512,0,-21*sqrt(33)*I/512,0,-sqrt(15015)*I/512,0,-15*sqrt(286)*I/1024,0,-sqrt(72930)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(176358)*I/1024]",
        ),
        "Qh(11,Eu,2,0)": (
            "-sqrt(41990)*C1/512+sqrt(385)*C11/512-3*sqrt(4522)*C3/512+3*sqrt(4845)*C5/512+77*sqrt(19)*C7/512+39*sqrt(15)*C9/512",
            "sqrt(692835)*x*(6*x**2*y**8-168*x**2*y**6*z**2+420*x**2*y**4*z**4-168*x**2*y**2*z**6+6*x**2*z**8-y**10+27*y**8*z**2-42*y**6*z**4-42*y**4*z**6+27*y**2*z**8-z**10)/256",
            "[-sqrt(770)/1024,0,-39*sqrt(30)/1024,0,-77*sqrt(38)/1024,0,-3*sqrt(9690)/1024,0,3*sqrt(2261)/512,0,sqrt(20995)/512,0,-sqrt(20995)/512,0,-3*sqrt(2261)/512,0,3*sqrt(9690)/1024,0,77*sqrt(38)/1024,0,39*sqrt(30)/1024,0,sqrt(770)/1024]",
        ),
        "Qh(11,Eu,2,1)": (
            "-sqrt(41990)*S1/512-sqrt(385)*S11/512+3*sqrt(4522)*S3/512+3*sqrt(4845)*S5/512-77*sqrt(19)*S7/512+39*sqrt(15)*S9/512",
            "sqrt(692835)*y*(-x**10+6*x**8*y**2+27*x**8*z**2-168*x**6*y**2*z**2-42*x**6*z**4+420*x**4*y**2*z**4-42*x**4*z**6-168*x**2*y**2*z**6+27*x**2*z**8+6*y**2*z**8-z**10)/256",
            "[-sqrt(770)*I/1024,0,39*sqrt(30)*I/1024,0,-77*sqrt(38)*I/1024,0,3*sqrt(9690)*I/1024,0,3*sqrt(2261)*I/512,0,-sqrt(20995)*I/512,0,-sqrt(20995)*I/512,0,3*sqrt(2261)*I/512,0,3*sqrt(9690)*I/1024,0,-77*sqrt(38)*I/1024,0,39*sqrt(30)*I/1024,0,-sqrt(770)*I/1024]",
        ),
        "Qh(11,Eu,3,0)": (
            "-5*sqrt(546)*C1/256+sqrt(10659)*C11/256+11*sqrt(30)*C3/256+13*sqrt(7)*C5/256-3*sqrt(1785)*C7/256+3*sqrt(2261)*C9/256",
            "3*sqrt(1001)*x*(80*x**6*y**4-480*x**6*y**2*z**2+80*x**6*z**4-168*x**4*y**6+840*x**4*y**4*z**2+840*x**4*y**2*z**4-168*x**4*z**6+70*x**2*y**8-280*x**2*y**6*z**2-700*x**2*y**4*z**4-280*x**2*y**2*z**6+70*x**2*z**8-5*y**10+15*y**8*z**2+70*y**6*z**4+70*y**4*z**6+15*y**2*z**8-5*z**10)/128",
            "[-sqrt(21318)/512,0,-3*sqrt(4522)/512,0,3*sqrt(3570)/512,0,-13*sqrt(14)/512,0,-11*sqrt(15)/256,0,5*sqrt(273)/256,0,-5*sqrt(273)/256,0,11*sqrt(15)/256,0,13*sqrt(14)/512,0,-3*sqrt(3570)/512,0,3*sqrt(4522)/512,0,sqrt(21318)/512]",
        ),
        "Qh(11,Eu,3,1)": (
            "-5*sqrt(546)*S1/256-sqrt(10659)*S11/256-11*sqrt(30)*S3/256+13*sqrt(7)*S5/256+3*sqrt(1785)*S7/256+3*sqrt(2261)*S9/256",
            "3*sqrt(1001)*y*(-5*x**10+70*x**8*y**2+15*x**8*z**2-168*x**6*y**4-280*x**6*y**2*z**2+70*x**6*z**4+80*x**4*y**6+840*x**4*y**4*z**2-700*x**4*y**2*z**4+70*x**4*z**6-480*x**2*y**6*z**2+840*x**2*y**4*z**4-280*x**2*y**2*z**6+15*x**2*z**8+80*y**6*z**4-168*y**4*z**6+70*y**2*z**8-5*z**10)/128",
            "[-sqrt(21318)*I/512,0,3*sqrt(4522)*I/512,0,3*sqrt(3570)*I/512,0,13*sqrt(14)*I/512,0,-11*sqrt(15)*I/256,0,-5*sqrt(273)*I/256,0,-5*sqrt(273)*I/256,0,-11*sqrt(15)*I/256,0,13*sqrt(14)*I/512,0,3*sqrt(3570)*I/512,0,3*sqrt(4522)*I/512,0,-sqrt(21318)*I/512]",
        ),
        "Qh(11,Eu,4,0)": (
            "-sqrt(29393)*C1/512-sqrt(22)*C11/1024-9*sqrt(1615)*C3/512-5*sqrt(13566)*C5/1024-7*sqrt(1330)*C7/1024-9*sqrt(42)*C9/1024",
            "sqrt(1939938)*x*(y**10-45*y**8*z**2+210*y**6*z**4-210*y**4*z**6+45*y**2*z**8-z**10)/512",
            "[sqrt(11)/1024,0,9*sqrt(21)/1024,0,7*sqrt(665)/1024,0,5*sqrt(6783)/1024,0,9*sqrt(3230)/1024,0,sqrt(58786)/1024,0,-sqrt(58786)/1024,0,-9*sqrt(3230)/1024,0,-5*sqrt(6783)/1024,0,-7*sqrt(665)/1024,0,-9*sqrt(21)/1024,0,-sqrt(11)/1024]",
        ),
        "Qh(11,Eu,4,1)": (
            "-sqrt(29393)*S1/512+sqrt(22)*S11/1024+9*sqrt(1615)*S3/512-5*sqrt(13566)*S5/1024+7*sqrt(1330)*S7/1024-9*sqrt(42)*S9/1024",
            "sqrt(1939938)*y*(x**10-45*x**8*z**2+210*x**6*z**4-210*x**4*z**6+45*x**2*z**8-z**10)/512",
            "[sqrt(11)*I/1024,0,-9*sqrt(21)*I/1024,0,7*sqrt(665)*I/1024,0,-5*sqrt(6783)*I/1024,0,9*sqrt(3230)*I/1024,0,-sqrt(58786)*I/1024,0,-sqrt(58786)*I/1024,0,9*sqrt(3230)*I/1024,0,-5*sqrt(6783)*I/1024,0,7*sqrt(665)*I/1024,0,-9*sqrt(21)*I/1024,0,sqrt(11)*I/1024]",
        ),
        "Qh(11,Eu,5,0)": (
            "-15*sqrt(221)*C1/512-3*sqrt(2926)*C11/1024-sqrt(595)*C3/512+53*sqrt(102)*C5/1024-105*sqrt(10)*C7/1024-61*sqrt(114)*C9/1024",
            "sqrt(14586)*x*(224*x**4*y**6-3360*x**4*y**4*z**2+3360*x**4*y**2*z**4-224*x**4*z**6-160*x**2*y**8+2240*x**2*y**6*z**2-2240*x**2*y**2*z**6+160*x**2*z**8+15*y**10-195*y**8*z**2-210*y**6*z**4+210*y**4*z**6+195*y**2*z**8-15*z**10)/512",
            "[3*sqrt(1463)/1024,0,61*sqrt(57)/1024,0,105*sqrt(5)/1024,0,-53*sqrt(51)/1024,0,sqrt(1190)/1024,0,15*sqrt(442)/1024,0,-15*sqrt(442)/1024,0,-sqrt(1190)/1024,0,53*sqrt(51)/1024,0,-105*sqrt(5)/1024,0,-61*sqrt(57)/1024,0,-3*sqrt(1463)/1024]",
        ),
        "Qh(11,Eu,5,1)": (
            "-15*sqrt(221)*S1/512+3*sqrt(2926)*S11/1024+sqrt(595)*S3/512+53*sqrt(102)*S5/1024+105*sqrt(10)*S7/1024-61*sqrt(114)*S9/1024",
            "sqrt(14586)*y*(15*x**10-160*x**8*y**2-195*x**8*z**2+224*x**6*y**4+2240*x**6*y**2*z**2-210*x**6*z**4-3360*x**4*y**4*z**2+210*x**4*z**6+3360*x**2*y**4*z**4-2240*x**2*y**2*z**6+195*x**2*z**8-224*y**4*z**6+160*y**2*z**8-15*z**10)/512",
            "[3*sqrt(1463)*I/1024,0,-61*sqrt(57)*I/1024,0,105*sqrt(5)*I/1024,0,53*sqrt(51)*I/1024,0,sqrt(1190)*I/1024,0,-15*sqrt(442)*I/1024,0,-15*sqrt(442)*I/1024,0,sqrt(1190)*I/1024,0,53*sqrt(51)*I/1024,0,105*sqrt(5)*I/1024,0,-61*sqrt(57)*I/1024,0,3*sqrt(1463)*I/1024]",
        ),
        "Qh(11,Eu,6,0)": (
            "-21*sqrt(130)*C1/512-sqrt(124355)*C11/512+57*sqrt(14)*C3/512-41*sqrt(15)*C5/512+17*sqrt(17)*C7/512+sqrt(4845)*C9/512",
            "sqrt(2145)*x*(128*x**8*y**2-128*x**8*z**2-768*x**6*y**4+768*x**6*z**4+1008*x**4*y**6+1008*x**4*y**4*z**2-1008*x**4*y**2*z**4-1008*x**4*z**6-336*x**2*y**8-672*x**2*y**6*z**2+672*x**2*y**2*z**6+336*x**2*z**8+21*y**10+63*y**8*z**2+42*y**6*z**4-42*y**4*z**6-63*y**2*z**8-21*z**10)/256",
            "[sqrt(248710)/1024,0,-sqrt(9690)/1024,0,-17*sqrt(34)/1024,0,41*sqrt(30)/1024,0,-57*sqrt(7)/512,0,21*sqrt(65)/512,0,-21*sqrt(65)/512,0,57*sqrt(7)/512,0,-41*sqrt(30)/1024,0,17*sqrt(34)/1024,0,sqrt(9690)/1024,0,-sqrt(248710)/1024]",
        ),
        "Qh(11,Eu,6,1)": (
            "-21*sqrt(130)*S1/512+sqrt(124355)*S11/512-57*sqrt(14)*S3/512-41*sqrt(15)*S5/512-17*sqrt(17)*S7/512+sqrt(4845)*S9/512",
            "sqrt(2145)*y*(21*x**10-336*x**8*y**2+63*x**8*z**2+1008*x**6*y**4-672*x**6*y**2*z**2+42*x**6*z**4-768*x**4*y**6+1008*x**4*y**4*z**2-42*x**4*z**6+128*x**2*y**8-1008*x**2*y**4*z**4+672*x**2*y**2*z**6-63*x**2*z**8-128*y**8*z**2+768*y**6*z**4-1008*y**4*z**6+336*y**2*z**8-21*z**10)/256",
            "[sqrt(248710)*I/1024,0,sqrt(9690)*I/1024,0,-17*sqrt(34)*I/1024,0,-41*sqrt(30)*I/1024,0,-57*sqrt(7)*I/512,0,-21*sqrt(65)*I/512,0,-21*sqrt(65)*I/512,0,-57*sqrt(7)*I/512,0,-41*sqrt(30)*I/1024,0,-17*sqrt(34)*I/1024,0,sqrt(9690)*I/1024,0,sqrt(248710)*I/1024]",
        ),
    },
    "C3": {
        "Qh(0,A,,)": ("C0", "1", "[1]"),
        "Qh(1,A,,)": ("C0", "z", "[0,1,0]"),
        "Qh(1,E,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(1,E,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(2,A,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(2,E,1,0)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Qh(2,E,1,1)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(2,E,2,0)": ("C2", "sqrt(3)*(x**2-y**2)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(2,E,2,1)": ("-S2", "-sqrt(3)*x*y", "[sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2]"),
        "Qh(3,A,1,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(3,A,2,)": ("S3", "sqrt(10)*y*(3*x**2-y**2)/4", "[sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(3,A,3,)": ("C3", "sqrt(10)*x*(x**2-3*y**2)/4", "[-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(3,E,1,0)": ("C1", "sqrt(6)*x*(-x**2-y**2+4*z**2)/4", "[0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0]"),
        "Qh(3,E,1,1)": ("S1", "sqrt(6)*y*(-x**2-y**2+4*z**2)/4", "[0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0]"),
        "Qh(3,E,2,0)": ("C2", "sqrt(15)*z*(x**2-y**2)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(3,E,2,1)": ("-S2", "-sqrt(15)*x*y*z", "[0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0]"),
        "Qh(4,A,1,)": ("C0", "3*x**4/8+3*x**2*y**2/4-3*x**2*z**2+3*y**4/8-3*y**2*z**2+z**4", "[0,0,0,0,1,0,0,0,0]"),
        "Qh(4,A,2,)": ("C3", "sqrt(70)*x*z*(x**2-3*y**2)/4", "[0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(4,A,3,)": ("S3", "sqrt(70)*y*z*(3*x**2-y**2)/4", "[0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(4,E,1,0)": ("C1", "sqrt(10)*x*z*(-3*x**2-3*y**2+4*z**2)/4", "[0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0]"),
        "Qh(4,E,1,1)": ("S1", "sqrt(10)*y*z*(-3*x**2-3*y**2+4*z**2)/4", "[0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0]"),
        "Qh(4,E,2,0)": ("C4", "sqrt(35)*(x**4-6*x**2*y**2+y**4)/8", "[sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(4,E,2,1)": ("S4", "sqrt(35)*x*y*(x**2-y**2)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(4,E,3,0)": ("C2", "sqrt(5)*(-x**2+y**2)*(x**2+y**2-6*z**2)/4", "[0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0]"),
        "Qh(4,E,3,1)": ("-S2", "sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0]"),
        "Qh(5,A,1,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(5,A,2,)": ("S3", "-sqrt(70)*y*(3*x**2-y**2)*(x**2+y**2-8*z**2)/16", "[0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(5,A,3,)": ("C3", "-sqrt(70)*x*(x**2-3*y**2)*(x**2+y**2-8*z**2)/16", "[0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0]"),
        "Qh(5,E,1,0)": ("C5", "3*sqrt(14)*x*(x**4-10*x**2*y**2+5*y**4)/16", "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(5,E,1,1)": ("-S5", "3*sqrt(14)*y*(-5*x**4+10*x**2*y**2-y**4)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]"),
        "Qh(5,E,2,0)": (
            "C1",
            "sqrt(15)*x*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(5,E,2,1)": (
            "S1",
            "sqrt(15)*y*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(5,E,3,0)": ("C4", "3*sqrt(35)*z*(x**4-6*x**2*y**2+y**4)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(5,E,3,1)": ("S4", "3*sqrt(35)*x*y*z*(x**2-y**2)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(5,E,4,0)": ("C2", "sqrt(105)*z*(-x**2+y**2)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(5,E,4,1)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(6,A,1,)": (
            "C0",
            "-5*x**6/16-15*x**4*y**2/16+45*x**4*z**2/8-15*x**2*y**4/16+45*x**2*y**2*z**2/4-15*x**2*z**4/2-5*y**6/16+45*y**4*z**2/8-15*y**2*z**4/2+z**6",
            "[0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Qh(6,A,2,)": (
            "C6",
            "sqrt(462)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(6,A,3,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(6,A,4,)": (
            "C3",
            "-sqrt(210)*x*z*(x**2-3*y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(6,A,5,)": (
            "S3",
            "-sqrt(210)*y*z*(3*x**2-y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(6,E,1,0)": ("C5", "3*sqrt(154)*x*z*(x**4-10*x**2*y**2+5*y**4)/16", "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(6,E,1,1)": (
            "-S5",
            "3*sqrt(154)*y*z*(-5*x**4+10*x**2*y**2-y**4)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Qh(6,E,2,0)": (
            "C1",
            "sqrt(21)*x*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(6,E,2,1)": (
            "S1",
            "sqrt(21)*y*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(6,E,3,0)": (
            "C4",
            "3*sqrt(7)*(x**2+y**2-10*z**2)*(-x**4+6*x**2*y**2-y**4)/16",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(6,E,3,1)": (
            "S4",
            "-3*sqrt(7)*x*y*(x**2-y**2)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(6,E,4,0)": (
            "C2",
            "sqrt(210)*(x**2-y**2)*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(6,E,4,1)": (
            "-S2",
            "sqrt(210)*x*y*(-x**4-2*x**2*y**2+16*x**2*z**2-y**4+16*y**2*z**2-16*z**4)/16",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(7,A,1,)": (
            "S6",
            "sqrt(6006)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(7,A,2,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(7,A,3,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(7,A,4,)": (
            "S3",
            "sqrt(21)*y*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(7,A,5,)": (
            "C3",
            "sqrt(21)*x*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(7,E,1,0)": (
            "C7",
            "sqrt(429)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(7,E,1,1)": (
            "S7",
            "sqrt(429)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(7,E,2,0)": (
            "C5",
            "sqrt(231)*x*(x**2+y**2-12*z**2)*(-x**4+10*x**2*y**2-5*y**4)/32",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(7,E,2,1)": (
            "-S5",
            "sqrt(231)*y*(x**2+y**2-12*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Qh(7,E,3,0)": (
            "C1",
            "sqrt(7)*x*(-5*x**6-15*x**4*y**2+120*x**4*z**2-15*x**2*y**4+240*x**2*y**2*z**2-240*x**2*z**4-5*y**6+120*y**4*z**2-240*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(7,E,3,1)": (
            "S1",
            "sqrt(7)*y*(-5*x**6-15*x**4*y**2+120*x**4*z**2-15*x**2*y**4+240*x**2*y**2*z**2-240*x**2*z**4-5*y**6+120*y**4*z**2-240*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(7,E,4,0)": (
            "C4",
            "sqrt(231)*z*(3*x**2+3*y**2-10*z**2)*(-x**4+6*x**2*y**2-y**4)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(7,E,4,1)": (
            "S4",
            "-sqrt(231)*x*y*z*(x**2-y**2)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(7,E,5,0)": (
            "C2",
            "sqrt(42)*z*(x**2-y**2)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(7,E,5,1)": (
            "-S2",
            "sqrt(42)*x*y*z*(-15*x**4-30*x**2*y**2+80*x**2*z**2-15*y**4+80*y**2*z**2-48*z**4)/16",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(8,A,1,)": (
            "C0",
            "35*x**8/128+35*x**6*y**2/32-35*x**6*z**2/4+105*x**4*y**4/64-105*x**4*y**2*z**2/4+105*x**4*z**4/4+35*x**2*y**6/32-105*x**2*y**4*z**2/4+105*x**2*y**2*z**4/2-14*x**2*z**6+35*y**8/128-35*y**6*z**2/4+105*y**4*z**4/4-14*y**2*z**6+z**8",
            "[0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0]",
        ),
        "Qh(8,A,2,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(8,A,3,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(8,A,4,)": (
            "C3",
            "sqrt(1155)*x*z*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(8,A,5,)": (
            "S3",
            "sqrt(1155)*y*z*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(8,E,1,0)": (
            "C7",
            "3*sqrt(715)*x*z*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(8,E,1,1)": (
            "S7",
            "3*sqrt(715)*y*z*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(8,E,2,0)": (
            "C5",
            "3*sqrt(1001)*x*z*(x**2+y**2-4*z**2)*(-x**4+10*x**2*y**2-5*y**4)/32",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(8,E,2,1)": (
            "-S5",
            "3*sqrt(1001)*y*z*(x**2+y**2-4*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(8,E,3,0)": (
            "C1",
            "3*x*z*(-35*x**6-105*x**4*y**2+280*x**4*z**2-105*x**2*y**4+560*x**2*y**2*z**2-336*x**2*z**4-35*y**6+280*y**4*z**2-336*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(8,E,3,1)": (
            "S1",
            "3*y*z*(-35*x**6-105*x**4*y**2+280*x**4*z**2-105*x**2*y**4+560*x**2*y**2*z**2-336*x**2*z**4-35*y**6+280*y**4*z**2-336*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(8,E,4,0)": (
            "C8",
            "3*sqrt(715)*(x**8-28*x**6*y**2+70*x**4*y**4-28*x**2*y**6+y**8)/128",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(8,E,4,1)": (
            "-S8",
            "3*sqrt(715)*x*y*(-x**6+7*x**4*y**2-7*x**2*y**4+y**6)/16",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Qh(8,E,5,0)": (
            "C4",
            "3*sqrt(77)*(x**4-6*x**2*y**2+y**4)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/64",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(8,E,5,1)": (
            "S4",
            "3*sqrt(77)*x*y*(x**2-y**2)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(8,E,6,0)": (
            "C2",
            "3*sqrt(70)*(-x**2+y**2)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(8,E,6,1)": (
            "-S2",
            "3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,A,1,)": (
            "S6",
            "-sqrt(4290)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**2+3*y**2-14*z**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(9,A,2,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,A,3,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,A,4,)": (
            "S9",
            "sqrt(24310)*y*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(9,A,5,)": (
            "S3",
            "-sqrt(2310)*y*(3*x**2-y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,A,6,)": (
            "C9",
            "sqrt(24310)*x*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(9,A,7,)": (
            "C3",
            "-sqrt(2310)*x*(x**2-3*y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(9,E,1,0)": (
            "C7",
            "3*sqrt(1430)*x*(x**2+y**2-16*z**2)*(-x**6+21*x**4*y**2-35*x**2*y**4+7*y**6)/256",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,E,1,1)": (
            "S7",
            "-3*sqrt(1430)*y*(x**2+y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(9,E,2,0)": (
            "C5",
            "3*sqrt(286)*x*(x**4-10*x**2*y**2+5*y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(9,E,2,1)": (
            "-S5",
            "-3*sqrt(286)*y*(5*x**4-10*x**2*y**2+y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(9,E,3,0)": (
            "C1",
            "3*sqrt(5)*x*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E,3,1)": (
            "S1",
            "3*sqrt(5)*y*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E,4,0)": (
            "C8",
            "3*sqrt(12155)*z*(x**8-28*x**6*y**2+70*x**4*y**4-28*x**2*y**6+y**8)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,E,4,1)": (
            "-S8",
            "3*sqrt(12155)*x*y*z*(-x**6+7*x**4*y**2-7*x**2*y**4+y**6)/16",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Qh(9,E,5,0)": (
            "C4",
            "3*sqrt(5005)*z*(x**4-6*x**2*y**2+y**4)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(9,E,5,1)": (
            "S4",
            "3*sqrt(5005)*x*y*z*(x**2-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/16",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(9,E,6,0)": (
            "C2",
            "3*sqrt(110)*z*(-x**2+y**2)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E,6,1)": (
            "-S2",
            "3*sqrt(110)*x*y*z*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A,1,)": (
            "C0",
            "-63*x**10/256-315*x**8*y**2/256+1575*x**8*z**2/128-315*x**6*y**4/128+1575*x**6*y**2*z**2/32-525*x**6*z**4/8-315*x**4*y**6/128+4725*x**4*y**4*z**2/64-1575*x**4*y**2*z**4/8+315*x**4*z**6/4-315*x**2*y**8/256+1575*x**2*y**6*z**2/32-1575*x**2*y**4*z**4/8+315*x**2*y**2*z**6/2-45*x**2*z**8/2-63*y**10/256+1575*y**8*z**2/128-525*y**6*z**4/8+315*y**4*z**6/4-45*y**2*z**8/2+z**10",
            "[0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A,2,)": (
            "C6",
            "sqrt(4290)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(10,A,3,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,A,4,)": (
            "C9",
            "sqrt(461890)*x*z*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(10,A,5,)": (
            "C3",
            "-sqrt(4290)*x*z*(x**2-3*y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A,6,)": (
            "S9",
            "sqrt(461890)*y*z*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(10,A,7,)": (
            "S3",
            "-sqrt(4290)*y*z*(3*x**2-y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E,1,0)": (
            "C7",
            "sqrt(72930)*x*z*(3*x**2+3*y**2-16*z**2)*(-x**6+21*x**4*y**2-35*x**2*y**4+7*y**6)/256",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(10,E,1,1)": (
            "S7",
            "-sqrt(72930)*y*z*(3*x**2+3*y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(10,E,2,0)": (
            "C5",
            "sqrt(858)*x*z*(x**4-10*x**2*y**2+5*y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(10,E,2,1)": (
            "-S5",
            "-sqrt(858)*y*z*(5*x**4-10*x**2*y**2+y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(10,E,3,0)": (
            "C1",
            "sqrt(55)*x*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E,3,1)": (
            "S1",
            "sqrt(55)*y*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E,4,0)": (
            "C10",
            "sqrt(92378)*(x**10-45*x**8*y**2+210*x**6*y**4-210*x**4*y**6+45*x**2*y**8-y**10)/512",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(10,E,4,1)": (
            "S10",
            "sqrt(92378)*x*y*(5*x**8-60*x**6*y**2+126*x**4*y**4-60*x**2*y**6+5*y**8)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(10,E,5,0)": (
            "C8",
            "sqrt(12155)*(x**2+y**2-18*z**2)*(-x**8+28*x**6*y**2-70*x**4*y**4+28*x**2*y**6-y**8)/256",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(10,E,5,1)": (
            "-S8",
            "sqrt(12155)*x*y*(x**2+y**2-18*z**2)*(x**6-7*x**4*y**2+7*x**2*y**4-y**6)/32",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Qh(10,E,6,0)": (
            "C4",
            "sqrt(2145)*(-x**4+6*x**2*y**2-y**4)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(10,E,6,1)": (
            "S4",
            "-sqrt(2145)*x*y*(x**2-y**2)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(10,E,7,0)": (
            "C2",
            "sqrt(165)*(x**2-y**2)*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/256",
            "[0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E,7,1)": (
            "-S2",
            "sqrt(165)*x*y*(-7*x**8-28*x**6*y**2+336*x**6*z**2-42*x**4*y**4+1008*x**4*y**2*z**2-1680*x**4*z**4-28*x**2*y**6+1008*x**2*y**4*z**2-3360*x**2*y**2*z**4+1792*x**2*z**6-7*y**8+336*y**6*z**2-1680*y**4*z**4+1792*y**2*z**6-384*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A,1,)": (
            "S6",
            "sqrt(14586)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(11,A,2,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A,3,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,A,4,)": (
            "S9",
            "-sqrt(46189)*y*(3*x**2-y**2)*(x**2+y**2-20*z**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/512",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(11,A,5,)": (
            "S3",
            "sqrt(30030)*y*(3*x**2-y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A,6,)": (
            "C9",
            "-sqrt(46189)*x*(x**2-3*y**2)*(x**2+y**2-20*z**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/512",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(11,A,7,)": (
            "C3",
            "sqrt(30030)*x*(x**2-3*y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,1,0)": (
            "C11",
            "sqrt(88179)*x*(x**10-55*x**8*y**2+330*x**6*y**4-462*x**4*y**6+165*x**2*y**8-11*y**10)/512",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(11,E,1,1)": (
            "-S11",
            "sqrt(88179)*y*(-11*x**10+165*x**8*y**2-462*x**6*y**4+330*x**4*y**6-55*x**2*y**8+y**10)/512",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Qh(11,E,2,0)": (
            "C7",
            "sqrt(36465)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(11,E,2,1)": (
            "S7",
            "sqrt(36465)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(11,E,3,0)": (
            "C5",
            "3*sqrt(143)*x*(-x**4+10*x**2*y**2-5*y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(11,E,3,1)": (
            "-S5",
            "3*sqrt(143)*y*(5*x**4-10*x**2*y**2+y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(11,E,4,0)": (
            "C1",
            "sqrt(66)*x*(-21*x**10-105*x**8*y**2+1260*x**8*z**2-210*x**6*y**4+5040*x**6*y**2*z**2-8400*x**6*z**4-210*x**4*y**6+7560*x**4*y**4*z**2-25200*x**4*y**2*z**4+13440*x**4*z**6-105*x**2*y**8+5040*x**2*y**6*z**2-25200*x**2*y**4*z**4+26880*x**2*y**2*z**6-5760*x**2*z**8-21*y**10+1260*y**8*z**2-8400*y**6*z**4+13440*y**4*z**6-5760*y**2*z**8+512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,4,1)": (
            "S1",
            "sqrt(66)*y*(-21*x**10-105*x**8*y**2+1260*x**8*z**2-210*x**6*y**4+5040*x**6*y**2*z**2-8400*x**6*z**4-210*x**4*y**6+7560*x**4*y**4*z**2-25200*x**4*y**2*z**4+13440*x**4*z**6-105*x**2*y**8+5040*x**2*y**6*z**2-25200*x**2*y**4*z**4+26880*x**2*y**2*z**6-5760*x**2*z**8-21*y**10+1260*y**8*z**2-8400*y**6*z**4+13440*y**4*z**6-5760*y**2*z**8+512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,5,0)": (
            "C10",
            "sqrt(1939938)*z*(x**10-45*x**8*y**2+210*x**6*y**4-210*x**4*y**6+45*x**2*y**8-y**10)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(11,E,5,1)": (
            "S10",
            "sqrt(1939938)*x*y*z*(5*x**8-60*x**6*y**2+126*x**4*y**4-60*x**2*y**6+5*y**8)/256",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(11,E,6,0)": (
            "C8",
            "sqrt(692835)*z*(x**2+y**2-6*z**2)*(-x**8+28*x**6*y**2-70*x**4*y**4+28*x**2*y**6-y**8)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(11,E,6,1)": (
            "-S8",
            "sqrt(692835)*x*y*z*(x**2+y**2-6*z**2)*(x**6-7*x**4*y**2+7*x**2*y**4-y**6)/32",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(11,E,7,0)": (
            "C4",
            "3*sqrt(1001)*z*(-x**4+6*x**2*y**2-y**4)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,7,1)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x**2-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,8,0)": (
            "C2",
            "sqrt(2145)*z*(x**2-y**2)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,8,1)": (
            "-S2",
            "sqrt(2145)*x*y*z*(-21*x**8-84*x**6*y**2+336*x**6*z**2-126*x**4*y**4+1008*x**4*y**2*z**2-1008*x**4*z**4-84*x**2*y**6+1008*x**2*y**4*z**2-2016*x**2*y**2*z**4+768*x**2*z**6-21*y**8+336*y**6*z**2-1008*y**4*z**4+768*y**2*z**6-128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
    },
    "C3i": {
        "Qh(0,Ag,,)": ("C0", "1", "[1]"),
        "Qh(1,Au,,)": ("C0", "z", "[0,1,0]"),
        "Qh(1,Eu,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(1,Eu,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(2,Ag,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(2,Eg,1,0)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Qh(2,Eg,1,1)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(2,Eg,2,0)": ("C2", "sqrt(3)*(x**2-y**2)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(2,Eg,2,1)": ("-S2", "-sqrt(3)*x*y", "[sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2]"),
        "Qh(3,Au,1,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(3,Au,2,)": ("S3", "sqrt(10)*y*(3*x**2-y**2)/4", "[sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(3,Au,3,)": ("C3", "sqrt(10)*x*(x**2-3*y**2)/4", "[-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(3,Eu,1,0)": ("C1", "sqrt(6)*x*(-x**2-y**2+4*z**2)/4", "[0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0]"),
        "Qh(3,Eu,1,1)": ("S1", "sqrt(6)*y*(-x**2-y**2+4*z**2)/4", "[0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0]"),
        "Qh(3,Eu,2,0)": ("C2", "sqrt(15)*z*(x**2-y**2)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(3,Eu,2,1)": ("-S2", "-sqrt(15)*x*y*z", "[0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0]"),
        "Qh(4,Ag,1,)": ("C0", "3*x**4/8+3*x**2*y**2/4-3*x**2*z**2+3*y**4/8-3*y**2*z**2+z**4", "[0,0,0,0,1,0,0,0,0]"),
        "Qh(4,Ag,2,)": ("C3", "sqrt(70)*x*z*(x**2-3*y**2)/4", "[0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(4,Ag,3,)": ("S3", "sqrt(70)*y*z*(3*x**2-y**2)/4", "[0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(4,Eg,1,0)": ("C1", "sqrt(10)*x*z*(-3*x**2-3*y**2+4*z**2)/4", "[0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0]"),
        "Qh(4,Eg,1,1)": ("S1", "sqrt(10)*y*z*(-3*x**2-3*y**2+4*z**2)/4", "[0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0]"),
        "Qh(4,Eg,2,0)": ("C4", "sqrt(35)*(x**4-6*x**2*y**2+y**4)/8", "[sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(4,Eg,2,1)": ("S4", "sqrt(35)*x*y*(x**2-y**2)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(4,Eg,3,0)": ("C2", "sqrt(5)*(-x**2+y**2)*(x**2+y**2-6*z**2)/4", "[0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0]"),
        "Qh(4,Eg,3,1)": ("-S2", "sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0]"),
        "Qh(5,Au,1,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(5,Au,2,)": ("S3", "-sqrt(70)*y*(3*x**2-y**2)*(x**2+y**2-8*z**2)/16", "[0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(5,Au,3,)": ("C3", "-sqrt(70)*x*(x**2-3*y**2)*(x**2+y**2-8*z**2)/16", "[0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0]"),
        "Qh(5,Eu,1,0)": ("C5", "3*sqrt(14)*x*(x**4-10*x**2*y**2+5*y**4)/16", "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(5,Eu,1,1)": ("-S5", "3*sqrt(14)*y*(-5*x**4+10*x**2*y**2-y**4)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]"),
        "Qh(5,Eu,2,0)": (
            "C1",
            "sqrt(15)*x*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(5,Eu,2,1)": (
            "S1",
            "sqrt(15)*y*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(5,Eu,3,0)": ("C4", "3*sqrt(35)*z*(x**4-6*x**2*y**2+y**4)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(5,Eu,3,1)": ("S4", "3*sqrt(35)*x*y*z*(x**2-y**2)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(5,Eu,4,0)": ("C2", "sqrt(105)*z*(-x**2+y**2)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(5,Eu,4,1)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(6,Ag,1,)": (
            "C0",
            "-5*x**6/16-15*x**4*y**2/16+45*x**4*z**2/8-15*x**2*y**4/16+45*x**2*y**2*z**2/4-15*x**2*z**4/2-5*y**6/16+45*y**4*z**2/8-15*y**2*z**4/2+z**6",
            "[0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Qh(6,Ag,2,)": (
            "C6",
            "sqrt(462)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(6,Ag,3,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(6,Ag,4,)": (
            "C3",
            "-sqrt(210)*x*z*(x**2-3*y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(6,Ag,5,)": (
            "S3",
            "-sqrt(210)*y*z*(3*x**2-y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(6,Eg,1,0)": ("C5", "3*sqrt(154)*x*z*(x**4-10*x**2*y**2+5*y**4)/16", "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(6,Eg,1,1)": (
            "-S5",
            "3*sqrt(154)*y*z*(-5*x**4+10*x**2*y**2-y**4)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Qh(6,Eg,2,0)": (
            "C1",
            "sqrt(21)*x*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(6,Eg,2,1)": (
            "S1",
            "sqrt(21)*y*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(6,Eg,3,0)": (
            "C4",
            "3*sqrt(7)*(x**2+y**2-10*z**2)*(-x**4+6*x**2*y**2-y**4)/16",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(6,Eg,3,1)": (
            "S4",
            "-3*sqrt(7)*x*y*(x**2-y**2)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(6,Eg,4,0)": (
            "C2",
            "sqrt(210)*(x**2-y**2)*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(6,Eg,4,1)": (
            "-S2",
            "sqrt(210)*x*y*(-x**4-2*x**2*y**2+16*x**2*z**2-y**4+16*y**2*z**2-16*z**4)/16",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(7,Au,1,)": (
            "S6",
            "sqrt(6006)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(7,Au,2,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(7,Au,3,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(7,Au,4,)": (
            "S3",
            "sqrt(21)*y*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(7,Au,5,)": (
            "C3",
            "sqrt(21)*x*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(7,Eu,1,0)": (
            "C7",
            "sqrt(429)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(7,Eu,1,1)": (
            "S7",
            "sqrt(429)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(7,Eu,2,0)": (
            "C5",
            "sqrt(231)*x*(x**2+y**2-12*z**2)*(-x**4+10*x**2*y**2-5*y**4)/32",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(7,Eu,2,1)": (
            "-S5",
            "sqrt(231)*y*(x**2+y**2-12*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Qh(7,Eu,3,0)": (
            "C1",
            "sqrt(7)*x*(-5*x**6-15*x**4*y**2+120*x**4*z**2-15*x**2*y**4+240*x**2*y**2*z**2-240*x**2*z**4-5*y**6+120*y**4*z**2-240*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(7,Eu,3,1)": (
            "S1",
            "sqrt(7)*y*(-5*x**6-15*x**4*y**2+120*x**4*z**2-15*x**2*y**4+240*x**2*y**2*z**2-240*x**2*z**4-5*y**6+120*y**4*z**2-240*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(7,Eu,4,0)": (
            "C4",
            "sqrt(231)*z*(3*x**2+3*y**2-10*z**2)*(-x**4+6*x**2*y**2-y**4)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(7,Eu,4,1)": (
            "S4",
            "-sqrt(231)*x*y*z*(x**2-y**2)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(7,Eu,5,0)": (
            "C2",
            "sqrt(42)*z*(x**2-y**2)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(7,Eu,5,1)": (
            "-S2",
            "sqrt(42)*x*y*z*(-15*x**4-30*x**2*y**2+80*x**2*z**2-15*y**4+80*y**2*z**2-48*z**4)/16",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(8,Ag,1,)": (
            "C0",
            "35*x**8/128+35*x**6*y**2/32-35*x**6*z**2/4+105*x**4*y**4/64-105*x**4*y**2*z**2/4+105*x**4*z**4/4+35*x**2*y**6/32-105*x**2*y**4*z**2/4+105*x**2*y**2*z**4/2-14*x**2*z**6+35*y**8/128-35*y**6*z**2/4+105*y**4*z**4/4-14*y**2*z**6+z**8",
            "[0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0]",
        ),
        "Qh(8,Ag,2,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(8,Ag,3,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(8,Ag,4,)": (
            "C3",
            "sqrt(1155)*x*z*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(8,Ag,5,)": (
            "S3",
            "sqrt(1155)*y*z*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(8,Eg,1,0)": (
            "C7",
            "3*sqrt(715)*x*z*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(8,Eg,1,1)": (
            "S7",
            "3*sqrt(715)*y*z*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(8,Eg,2,0)": (
            "C5",
            "3*sqrt(1001)*x*z*(x**2+y**2-4*z**2)*(-x**4+10*x**2*y**2-5*y**4)/32",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(8,Eg,2,1)": (
            "-S5",
            "3*sqrt(1001)*y*z*(x**2+y**2-4*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(8,Eg,3,0)": (
            "C1",
            "3*x*z*(-35*x**6-105*x**4*y**2+280*x**4*z**2-105*x**2*y**4+560*x**2*y**2*z**2-336*x**2*z**4-35*y**6+280*y**4*z**2-336*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(8,Eg,3,1)": (
            "S1",
            "3*y*z*(-35*x**6-105*x**4*y**2+280*x**4*z**2-105*x**2*y**4+560*x**2*y**2*z**2-336*x**2*z**4-35*y**6+280*y**4*z**2-336*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(8,Eg,4,0)": (
            "C8",
            "3*sqrt(715)*(x**8-28*x**6*y**2+70*x**4*y**4-28*x**2*y**6+y**8)/128",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(8,Eg,4,1)": (
            "-S8",
            "3*sqrt(715)*x*y*(-x**6+7*x**4*y**2-7*x**2*y**4+y**6)/16",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Qh(8,Eg,5,0)": (
            "C4",
            "3*sqrt(77)*(x**4-6*x**2*y**2+y**4)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/64",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(8,Eg,5,1)": (
            "S4",
            "3*sqrt(77)*x*y*(x**2-y**2)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(8,Eg,6,0)": (
            "C2",
            "3*sqrt(70)*(-x**2+y**2)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(8,Eg,6,1)": (
            "-S2",
            "3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,Au,1,)": (
            "S6",
            "-sqrt(4290)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**2+3*y**2-14*z**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(9,Au,2,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Au,3,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,Au,4,)": (
            "S9",
            "sqrt(24310)*y*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(9,Au,5,)": (
            "S3",
            "-sqrt(2310)*y*(3*x**2-y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,Au,6,)": (
            "C9",
            "sqrt(24310)*x*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(9,Au,7,)": (
            "C3",
            "-sqrt(2310)*x*(x**2-3*y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(9,Eu,1,0)": (
            "C7",
            "3*sqrt(1430)*x*(x**2+y**2-16*z**2)*(-x**6+21*x**4*y**2-35*x**2*y**4+7*y**6)/256",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,Eu,1,1)": (
            "S7",
            "-3*sqrt(1430)*y*(x**2+y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(9,Eu,2,0)": (
            "C5",
            "3*sqrt(286)*x*(x**4-10*x**2*y**2+5*y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(9,Eu,2,1)": (
            "-S5",
            "-3*sqrt(286)*y*(5*x**4-10*x**2*y**2+y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(9,Eu,3,0)": (
            "C1",
            "3*sqrt(5)*x*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Eu,3,1)": (
            "S1",
            "3*sqrt(5)*y*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Eu,4,0)": (
            "C8",
            "3*sqrt(12155)*z*(x**8-28*x**6*y**2+70*x**4*y**4-28*x**2*y**6+y**8)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,Eu,4,1)": (
            "-S8",
            "3*sqrt(12155)*x*y*z*(-x**6+7*x**4*y**2-7*x**2*y**4+y**6)/16",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Qh(9,Eu,5,0)": (
            "C4",
            "3*sqrt(5005)*z*(x**4-6*x**2*y**2+y**4)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(9,Eu,5,1)": (
            "S4",
            "3*sqrt(5005)*x*y*z*(x**2-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/16",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(9,Eu,6,0)": (
            "C2",
            "3*sqrt(110)*z*(-x**2+y**2)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Eu,6,1)": (
            "-S2",
            "3*sqrt(110)*x*y*z*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Ag,1,)": (
            "C0",
            "-63*x**10/256-315*x**8*y**2/256+1575*x**8*z**2/128-315*x**6*y**4/128+1575*x**6*y**2*z**2/32-525*x**6*z**4/8-315*x**4*y**6/128+4725*x**4*y**4*z**2/64-1575*x**4*y**2*z**4/8+315*x**4*z**6/4-315*x**2*y**8/256+1575*x**2*y**6*z**2/32-1575*x**2*y**4*z**4/8+315*x**2*y**2*z**6/2-45*x**2*z**8/2-63*y**10/256+1575*y**8*z**2/128-525*y**6*z**4/8+315*y**4*z**6/4-45*y**2*z**8/2+z**10",
            "[0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Ag,2,)": (
            "C6",
            "sqrt(4290)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(10,Ag,3,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,Ag,4,)": (
            "C9",
            "sqrt(461890)*x*z*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(10,Ag,5,)": (
            "C3",
            "-sqrt(4290)*x*z*(x**2-3*y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Ag,6,)": (
            "S9",
            "sqrt(461890)*y*z*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(10,Ag,7,)": (
            "S3",
            "-sqrt(4290)*y*z*(3*x**2-y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Eg,1,0)": (
            "C7",
            "sqrt(72930)*x*z*(3*x**2+3*y**2-16*z**2)*(-x**6+21*x**4*y**2-35*x**2*y**4+7*y**6)/256",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(10,Eg,1,1)": (
            "S7",
            "-sqrt(72930)*y*z*(3*x**2+3*y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(10,Eg,2,0)": (
            "C5",
            "sqrt(858)*x*z*(x**4-10*x**2*y**2+5*y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(10,Eg,2,1)": (
            "-S5",
            "-sqrt(858)*y*z*(5*x**4-10*x**2*y**2+y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(10,Eg,3,0)": (
            "C1",
            "sqrt(55)*x*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Eg,3,1)": (
            "S1",
            "sqrt(55)*y*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Eg,4,0)": (
            "C10",
            "sqrt(92378)*(x**10-45*x**8*y**2+210*x**6*y**4-210*x**4*y**6+45*x**2*y**8-y**10)/512",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(10,Eg,4,1)": (
            "S10",
            "sqrt(92378)*x*y*(5*x**8-60*x**6*y**2+126*x**4*y**4-60*x**2*y**6+5*y**8)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(10,Eg,5,0)": (
            "C8",
            "sqrt(12155)*(x**2+y**2-18*z**2)*(-x**8+28*x**6*y**2-70*x**4*y**4+28*x**2*y**6-y**8)/256",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(10,Eg,5,1)": (
            "-S8",
            "sqrt(12155)*x*y*(x**2+y**2-18*z**2)*(x**6-7*x**4*y**2+7*x**2*y**4-y**6)/32",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Qh(10,Eg,6,0)": (
            "C4",
            "sqrt(2145)*(-x**4+6*x**2*y**2-y**4)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(10,Eg,6,1)": (
            "S4",
            "-sqrt(2145)*x*y*(x**2-y**2)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(10,Eg,7,0)": (
            "C2",
            "sqrt(165)*(x**2-y**2)*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/256",
            "[0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Eg,7,1)": (
            "-S2",
            "sqrt(165)*x*y*(-7*x**8-28*x**6*y**2+336*x**6*z**2-42*x**4*y**4+1008*x**4*y**2*z**2-1680*x**4*z**4-28*x**2*y**6+1008*x**2*y**4*z**2-3360*x**2*y**2*z**4+1792*x**2*z**6-7*y**8+336*y**6*z**2-1680*y**4*z**4+1792*y**2*z**6-384*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Au,1,)": (
            "S6",
            "sqrt(14586)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(11,Au,2,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Au,3,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,Au,4,)": (
            "S9",
            "-sqrt(46189)*y*(3*x**2-y**2)*(x**2+y**2-20*z**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/512",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(11,Au,5,)": (
            "S3",
            "sqrt(30030)*y*(3*x**2-y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Au,6,)": (
            "C9",
            "-sqrt(46189)*x*(x**2-3*y**2)*(x**2+y**2-20*z**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/512",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(11,Au,7,)": (
            "C3",
            "sqrt(30030)*x*(x**2-3*y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eu,1,0)": (
            "C11",
            "sqrt(88179)*x*(x**10-55*x**8*y**2+330*x**6*y**4-462*x**4*y**6+165*x**2*y**8-11*y**10)/512",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(11,Eu,1,1)": (
            "-S11",
            "sqrt(88179)*y*(-11*x**10+165*x**8*y**2-462*x**6*y**4+330*x**4*y**6-55*x**2*y**8+y**10)/512",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Qh(11,Eu,2,0)": (
            "C7",
            "sqrt(36465)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(11,Eu,2,1)": (
            "S7",
            "sqrt(36465)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(11,Eu,3,0)": (
            "C5",
            "3*sqrt(143)*x*(-x**4+10*x**2*y**2-5*y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(11,Eu,3,1)": (
            "-S5",
            "3*sqrt(143)*y*(5*x**4-10*x**2*y**2+y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(11,Eu,4,0)": (
            "C1",
            "sqrt(66)*x*(-21*x**10-105*x**8*y**2+1260*x**8*z**2-210*x**6*y**4+5040*x**6*y**2*z**2-8400*x**6*z**4-210*x**4*y**6+7560*x**4*y**4*z**2-25200*x**4*y**2*z**4+13440*x**4*z**6-105*x**2*y**8+5040*x**2*y**6*z**2-25200*x**2*y**4*z**4+26880*x**2*y**2*z**6-5760*x**2*z**8-21*y**10+1260*y**8*z**2-8400*y**6*z**4+13440*y**4*z**6-5760*y**2*z**8+512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eu,4,1)": (
            "S1",
            "sqrt(66)*y*(-21*x**10-105*x**8*y**2+1260*x**8*z**2-210*x**6*y**4+5040*x**6*y**2*z**2-8400*x**6*z**4-210*x**4*y**6+7560*x**4*y**4*z**2-25200*x**4*y**2*z**4+13440*x**4*z**6-105*x**2*y**8+5040*x**2*y**6*z**2-25200*x**2*y**4*z**4+26880*x**2*y**2*z**6-5760*x**2*z**8-21*y**10+1260*y**8*z**2-8400*y**6*z**4+13440*y**4*z**6-5760*y**2*z**8+512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eu,5,0)": (
            "C10",
            "sqrt(1939938)*z*(x**10-45*x**8*y**2+210*x**6*y**4-210*x**4*y**6+45*x**2*y**8-y**10)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(11,Eu,5,1)": (
            "S10",
            "sqrt(1939938)*x*y*z*(5*x**8-60*x**6*y**2+126*x**4*y**4-60*x**2*y**6+5*y**8)/256",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(11,Eu,6,0)": (
            "C8",
            "sqrt(692835)*z*(x**2+y**2-6*z**2)*(-x**8+28*x**6*y**2-70*x**4*y**4+28*x**2*y**6-y**8)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(11,Eu,6,1)": (
            "-S8",
            "sqrt(692835)*x*y*z*(x**2+y**2-6*z**2)*(x**6-7*x**4*y**2+7*x**2*y**4-y**6)/32",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(11,Eu,7,0)": (
            "C4",
            "3*sqrt(1001)*z*(-x**4+6*x**2*y**2-y**4)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eu,7,1)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x**2-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eu,8,0)": (
            "C2",
            "sqrt(2145)*z*(x**2-y**2)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eu,8,1)": (
            "-S2",
            "sqrt(2145)*x*y*z*(-21*x**8-84*x**6*y**2+336*x**6*z**2-126*x**4*y**4+1008*x**4*y**2*z**2-1008*x**4*z**4-84*x**2*y**6+1008*x**2*y**4*z**2-2016*x**2*y**2*z**4+768*x**2*z**6-21*y**8+336*y**6*z**2-1008*y**4*z**4+768*y**2*z**6-128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
    },
    "C6": {
        "Qh(0,A,,)": ("C0", "1", "[1]"),
        "Qh(1,A,,)": ("C0", "z", "[0,1,0]"),
        "Qh(1,E1,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(1,E1,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(2,A,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(2,E1,,0)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Qh(2,E1,,1)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(2,E2,,0)": ("C2", "sqrt(3)*(x**2-y**2)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(2,E2,,1)": ("-S2", "-sqrt(3)*x*y", "[sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2]"),
        "Qh(3,A,,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(3,B,1,)": ("S3", "sqrt(10)*y*(3*x**2-y**2)/4", "[sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(3,B,2,)": ("C3", "sqrt(10)*x*(x**2-3*y**2)/4", "[-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(3,E1,,0)": ("C1", "sqrt(6)*x*(-x**2-y**2+4*z**2)/4", "[0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0]"),
        "Qh(3,E1,,1)": ("S1", "sqrt(6)*y*(-x**2-y**2+4*z**2)/4", "[0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0]"),
        "Qh(3,E2,,0)": ("C2", "sqrt(15)*z*(x**2-y**2)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(3,E2,,1)": ("-S2", "-sqrt(15)*x*y*z", "[0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0]"),
        "Qh(4,A,,)": ("C0", "3*x**4/8+3*x**2*y**2/4-3*x**2*z**2+3*y**4/8-3*y**2*z**2+z**4", "[0,0,0,0,1,0,0,0,0]"),
        "Qh(4,B,1,)": ("C3", "sqrt(70)*x*z*(x**2-3*y**2)/4", "[0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(4,B,2,)": ("S3", "sqrt(70)*y*z*(3*x**2-y**2)/4", "[0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(4,E1,,0)": ("C1", "sqrt(10)*x*z*(-3*x**2-3*y**2+4*z**2)/4", "[0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0]"),
        "Qh(4,E1,,1)": ("S1", "sqrt(10)*y*z*(-3*x**2-3*y**2+4*z**2)/4", "[0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0]"),
        "Qh(4,E2,1,0)": ("C4", "sqrt(35)*(x**4-6*x**2*y**2+y**4)/8", "[sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(4,E2,1,1)": ("S4", "sqrt(35)*x*y*(x**2-y**2)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(4,E2,2,0)": ("C2", "sqrt(5)*(-x**2+y**2)*(x**2+y**2-6*z**2)/4", "[0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0]"),
        "Qh(4,E2,2,1)": ("-S2", "sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0]"),
        "Qh(5,A,,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(5,B,1,)": ("S3", "-sqrt(70)*y*(3*x**2-y**2)*(x**2+y**2-8*z**2)/16", "[0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(5,B,2,)": ("C3", "-sqrt(70)*x*(x**2-3*y**2)*(x**2+y**2-8*z**2)/16", "[0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0]"),
        "Qh(5,E1,1,0)": ("C5", "3*sqrt(14)*x*(x**4-10*x**2*y**2+5*y**4)/16", "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(5,E1,1,1)": ("-S5", "3*sqrt(14)*y*(-5*x**4+10*x**2*y**2-y**4)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]"),
        "Qh(5,E1,2,0)": (
            "C1",
            "sqrt(15)*x*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(5,E1,2,1)": (
            "S1",
            "sqrt(15)*y*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(5,E2,1,0)": ("C4", "3*sqrt(35)*z*(x**4-6*x**2*y**2+y**4)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(5,E2,1,1)": ("S4", "3*sqrt(35)*x*y*z*(x**2-y**2)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(5,E2,2,0)": ("C2", "sqrt(105)*z*(-x**2+y**2)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(5,E2,2,1)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(6,A,1,)": (
            "C0",
            "-5*x**6/16-15*x**4*y**2/16+45*x**4*z**2/8-15*x**2*y**4/16+45*x**2*y**2*z**2/4-15*x**2*z**4/2-5*y**6/16+45*y**4*z**2/8-15*y**2*z**4/2+z**6",
            "[0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Qh(6,A,2,)": (
            "C6",
            "sqrt(462)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(6,A,3,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(6,B,1,)": (
            "C3",
            "-sqrt(210)*x*z*(x**2-3*y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(6,B,2,)": (
            "S3",
            "-sqrt(210)*y*z*(3*x**2-y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(6,E1,1,0)": ("C5", "3*sqrt(154)*x*z*(x**4-10*x**2*y**2+5*y**4)/16", "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(6,E1,1,1)": (
            "-S5",
            "3*sqrt(154)*y*z*(-5*x**4+10*x**2*y**2-y**4)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Qh(6,E1,2,0)": (
            "C1",
            "sqrt(21)*x*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(6,E1,2,1)": (
            "S1",
            "sqrt(21)*y*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(6,E2,1,0)": (
            "C4",
            "3*sqrt(7)*(x**2+y**2-10*z**2)*(-x**4+6*x**2*y**2-y**4)/16",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(6,E2,1,1)": (
            "S4",
            "-3*sqrt(7)*x*y*(x**2-y**2)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(6,E2,2,0)": (
            "C2",
            "sqrt(210)*(x**2-y**2)*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(6,E2,2,1)": (
            "-S2",
            "sqrt(210)*x*y*(-x**4-2*x**2*y**2+16*x**2*z**2-y**4+16*y**2*z**2-16*z**4)/16",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(7,A,1,)": (
            "S6",
            "sqrt(6006)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(7,A,2,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(7,A,3,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(7,B,1,)": (
            "S3",
            "sqrt(21)*y*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(7,B,2,)": (
            "C3",
            "sqrt(21)*x*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(7,E1,1,0)": (
            "C7",
            "sqrt(429)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(7,E1,1,1)": (
            "S7",
            "sqrt(429)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(7,E1,2,0)": (
            "C5",
            "sqrt(231)*x*(x**2+y**2-12*z**2)*(-x**4+10*x**2*y**2-5*y**4)/32",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(7,E1,2,1)": (
            "-S5",
            "sqrt(231)*y*(x**2+y**2-12*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Qh(7,E1,3,0)": (
            "C1",
            "sqrt(7)*x*(-5*x**6-15*x**4*y**2+120*x**4*z**2-15*x**2*y**4+240*x**2*y**2*z**2-240*x**2*z**4-5*y**6+120*y**4*z**2-240*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(7,E1,3,1)": (
            "S1",
            "sqrt(7)*y*(-5*x**6-15*x**4*y**2+120*x**4*z**2-15*x**2*y**4+240*x**2*y**2*z**2-240*x**2*z**4-5*y**6+120*y**4*z**2-240*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(7,E2,1,0)": (
            "C4",
            "sqrt(231)*z*(3*x**2+3*y**2-10*z**2)*(-x**4+6*x**2*y**2-y**4)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(7,E2,1,1)": (
            "S4",
            "-sqrt(231)*x*y*z*(x**2-y**2)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(7,E2,2,0)": (
            "C2",
            "sqrt(42)*z*(x**2-y**2)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(7,E2,2,1)": (
            "-S2",
            "sqrt(42)*x*y*z*(-15*x**4-30*x**2*y**2+80*x**2*z**2-15*y**4+80*y**2*z**2-48*z**4)/16",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(8,A,1,)": (
            "C0",
            "35*x**8/128+35*x**6*y**2/32-35*x**6*z**2/4+105*x**4*y**4/64-105*x**4*y**2*z**2/4+105*x**4*z**4/4+35*x**2*y**6/32-105*x**2*y**4*z**2/4+105*x**2*y**2*z**4/2-14*x**2*z**6+35*y**8/128-35*y**6*z**2/4+105*y**4*z**4/4-14*y**2*z**6+z**8",
            "[0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0]",
        ),
        "Qh(8,A,2,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(8,A,3,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(8,B,1,)": (
            "C3",
            "sqrt(1155)*x*z*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(8,B,2,)": (
            "S3",
            "sqrt(1155)*y*z*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(8,E1,1,0)": (
            "C7",
            "3*sqrt(715)*x*z*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(8,E1,1,1)": (
            "S7",
            "3*sqrt(715)*y*z*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(8,E1,2,0)": (
            "C5",
            "3*sqrt(1001)*x*z*(x**2+y**2-4*z**2)*(-x**4+10*x**2*y**2-5*y**4)/32",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(8,E1,2,1)": (
            "-S5",
            "3*sqrt(1001)*y*z*(x**2+y**2-4*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(8,E1,3,0)": (
            "C1",
            "3*x*z*(-35*x**6-105*x**4*y**2+280*x**4*z**2-105*x**2*y**4+560*x**2*y**2*z**2-336*x**2*z**4-35*y**6+280*y**4*z**2-336*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(8,E1,3,1)": (
            "S1",
            "3*y*z*(-35*x**6-105*x**4*y**2+280*x**4*z**2-105*x**2*y**4+560*x**2*y**2*z**2-336*x**2*z**4-35*y**6+280*y**4*z**2-336*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(8,E2,1,0)": (
            "C8",
            "3*sqrt(715)*(x**8-28*x**6*y**2+70*x**4*y**4-28*x**2*y**6+y**8)/128",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(8,E2,1,1)": (
            "-S8",
            "3*sqrt(715)*x*y*(-x**6+7*x**4*y**2-7*x**2*y**4+y**6)/16",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Qh(8,E2,2,0)": (
            "C4",
            "3*sqrt(77)*(x**4-6*x**2*y**2+y**4)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/64",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(8,E2,2,1)": (
            "S4",
            "3*sqrt(77)*x*y*(x**2-y**2)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(8,E2,3,0)": (
            "C2",
            "3*sqrt(70)*(-x**2+y**2)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(8,E2,3,1)": (
            "-S2",
            "3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,A,1,)": (
            "S6",
            "-sqrt(4290)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**2+3*y**2-14*z**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(9,A,2,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,A,3,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,B,1,)": (
            "S9",
            "sqrt(24310)*y*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(9,B,2,)": (
            "S3",
            "-sqrt(2310)*y*(3*x**2-y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,B,3,)": (
            "C9",
            "sqrt(24310)*x*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(9,B,4,)": (
            "C3",
            "-sqrt(2310)*x*(x**2-3*y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(9,E1,1,0)": (
            "C7",
            "3*sqrt(1430)*x*(x**2+y**2-16*z**2)*(-x**6+21*x**4*y**2-35*x**2*y**4+7*y**6)/256",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,E1,1,1)": (
            "S7",
            "-3*sqrt(1430)*y*(x**2+y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(9,E1,2,0)": (
            "C5",
            "3*sqrt(286)*x*(x**4-10*x**2*y**2+5*y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(9,E1,2,1)": (
            "-S5",
            "-3*sqrt(286)*y*(5*x**4-10*x**2*y**2+y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(9,E1,3,0)": (
            "C1",
            "3*sqrt(5)*x*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E1,3,1)": (
            "S1",
            "3*sqrt(5)*y*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E2,1,0)": (
            "C8",
            "3*sqrt(12155)*z*(x**8-28*x**6*y**2+70*x**4*y**4-28*x**2*y**6+y**8)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,E2,1,1)": (
            "-S8",
            "3*sqrt(12155)*x*y*z*(-x**6+7*x**4*y**2-7*x**2*y**4+y**6)/16",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Qh(9,E2,2,0)": (
            "C4",
            "3*sqrt(5005)*z*(x**4-6*x**2*y**2+y**4)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(9,E2,2,1)": (
            "S4",
            "3*sqrt(5005)*x*y*z*(x**2-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/16",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(9,E2,3,0)": (
            "C2",
            "3*sqrt(110)*z*(-x**2+y**2)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E2,3,1)": (
            "-S2",
            "3*sqrt(110)*x*y*z*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A,1,)": (
            "C0",
            "-63*x**10/256-315*x**8*y**2/256+1575*x**8*z**2/128-315*x**6*y**4/128+1575*x**6*y**2*z**2/32-525*x**6*z**4/8-315*x**4*y**6/128+4725*x**4*y**4*z**2/64-1575*x**4*y**2*z**4/8+315*x**4*z**6/4-315*x**2*y**8/256+1575*x**2*y**6*z**2/32-1575*x**2*y**4*z**4/8+315*x**2*y**2*z**6/2-45*x**2*z**8/2-63*y**10/256+1575*y**8*z**2/128-525*y**6*z**4/8+315*y**4*z**6/4-45*y**2*z**8/2+z**10",
            "[0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A,2,)": (
            "C6",
            "sqrt(4290)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(10,A,3,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,B,1,)": (
            "C9",
            "sqrt(461890)*x*z*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(10,B,2,)": (
            "C3",
            "-sqrt(4290)*x*z*(x**2-3*y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,B,3,)": (
            "S9",
            "sqrt(461890)*y*z*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(10,B,4,)": (
            "S3",
            "-sqrt(4290)*y*z*(3*x**2-y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E1,1,0)": (
            "C7",
            "sqrt(72930)*x*z*(3*x**2+3*y**2-16*z**2)*(-x**6+21*x**4*y**2-35*x**2*y**4+7*y**6)/256",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(10,E1,1,1)": (
            "S7",
            "-sqrt(72930)*y*z*(3*x**2+3*y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(10,E1,2,0)": (
            "C5",
            "sqrt(858)*x*z*(x**4-10*x**2*y**2+5*y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(10,E1,2,1)": (
            "-S5",
            "-sqrt(858)*y*z*(5*x**4-10*x**2*y**2+y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(10,E1,3,0)": (
            "C1",
            "sqrt(55)*x*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E1,3,1)": (
            "S1",
            "sqrt(55)*y*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E2,1,0)": (
            "C10",
            "sqrt(92378)*(x**10-45*x**8*y**2+210*x**6*y**4-210*x**4*y**6+45*x**2*y**8-y**10)/512",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(10,E2,1,1)": (
            "S10",
            "sqrt(92378)*x*y*(5*x**8-60*x**6*y**2+126*x**4*y**4-60*x**2*y**6+5*y**8)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(10,E2,2,0)": (
            "C8",
            "sqrt(12155)*(x**2+y**2-18*z**2)*(-x**8+28*x**6*y**2-70*x**4*y**4+28*x**2*y**6-y**8)/256",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(10,E2,2,1)": (
            "-S8",
            "sqrt(12155)*x*y*(x**2+y**2-18*z**2)*(x**6-7*x**4*y**2+7*x**2*y**4-y**6)/32",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Qh(10,E2,3,0)": (
            "C4",
            "sqrt(2145)*(-x**4+6*x**2*y**2-y**4)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(10,E2,3,1)": (
            "S4",
            "-sqrt(2145)*x*y*(x**2-y**2)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(10,E2,4,0)": (
            "C2",
            "sqrt(165)*(x**2-y**2)*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/256",
            "[0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E2,4,1)": (
            "-S2",
            "sqrt(165)*x*y*(-7*x**8-28*x**6*y**2+336*x**6*z**2-42*x**4*y**4+1008*x**4*y**2*z**2-1680*x**4*z**4-28*x**2*y**6+1008*x**2*y**4*z**2-3360*x**2*y**2*z**4+1792*x**2*z**6-7*y**8+336*y**6*z**2-1680*y**4*z**4+1792*y**2*z**6-384*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A,1,)": (
            "S6",
            "sqrt(14586)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(11,A,2,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A,3,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,B,1,)": (
            "S9",
            "-sqrt(46189)*y*(3*x**2-y**2)*(x**2+y**2-20*z**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/512",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(11,B,2,)": (
            "S3",
            "sqrt(30030)*y*(3*x**2-y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,B,3,)": (
            "C9",
            "-sqrt(46189)*x*(x**2-3*y**2)*(x**2+y**2-20*z**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/512",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(11,B,4,)": (
            "C3",
            "sqrt(30030)*x*(x**2-3*y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E1,1,0)": (
            "C11",
            "sqrt(88179)*x*(x**10-55*x**8*y**2+330*x**6*y**4-462*x**4*y**6+165*x**2*y**8-11*y**10)/512",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(11,E1,1,1)": (
            "-S11",
            "sqrt(88179)*y*(-11*x**10+165*x**8*y**2-462*x**6*y**4+330*x**4*y**6-55*x**2*y**8+y**10)/512",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Qh(11,E1,2,0)": (
            "C7",
            "sqrt(36465)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(11,E1,2,1)": (
            "S7",
            "sqrt(36465)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(11,E1,3,0)": (
            "C5",
            "3*sqrt(143)*x*(-x**4+10*x**2*y**2-5*y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(11,E1,3,1)": (
            "-S5",
            "3*sqrt(143)*y*(5*x**4-10*x**2*y**2+y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(11,E1,4,0)": (
            "C1",
            "sqrt(66)*x*(-21*x**10-105*x**8*y**2+1260*x**8*z**2-210*x**6*y**4+5040*x**6*y**2*z**2-8400*x**6*z**4-210*x**4*y**6+7560*x**4*y**4*z**2-25200*x**4*y**2*z**4+13440*x**4*z**6-105*x**2*y**8+5040*x**2*y**6*z**2-25200*x**2*y**4*z**4+26880*x**2*y**2*z**6-5760*x**2*z**8-21*y**10+1260*y**8*z**2-8400*y**6*z**4+13440*y**4*z**6-5760*y**2*z**8+512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E1,4,1)": (
            "S1",
            "sqrt(66)*y*(-21*x**10-105*x**8*y**2+1260*x**8*z**2-210*x**6*y**4+5040*x**6*y**2*z**2-8400*x**6*z**4-210*x**4*y**6+7560*x**4*y**4*z**2-25200*x**4*y**2*z**4+13440*x**4*z**6-105*x**2*y**8+5040*x**2*y**6*z**2-25200*x**2*y**4*z**4+26880*x**2*y**2*z**6-5760*x**2*z**8-21*y**10+1260*y**8*z**2-8400*y**6*z**4+13440*y**4*z**6-5760*y**2*z**8+512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E2,1,0)": (
            "C10",
            "sqrt(1939938)*z*(x**10-45*x**8*y**2+210*x**6*y**4-210*x**4*y**6+45*x**2*y**8-y**10)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(11,E2,1,1)": (
            "S10",
            "sqrt(1939938)*x*y*z*(5*x**8-60*x**6*y**2+126*x**4*y**4-60*x**2*y**6+5*y**8)/256",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(11,E2,2,0)": (
            "C8",
            "sqrt(692835)*z*(x**2+y**2-6*z**2)*(-x**8+28*x**6*y**2-70*x**4*y**4+28*x**2*y**6-y**8)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(11,E2,2,1)": (
            "-S8",
            "sqrt(692835)*x*y*z*(x**2+y**2-6*z**2)*(x**6-7*x**4*y**2+7*x**2*y**4-y**6)/32",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(11,E2,3,0)": (
            "C4",
            "3*sqrt(1001)*z*(-x**4+6*x**2*y**2-y**4)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E2,3,1)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x**2-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E2,4,0)": (
            "C2",
            "sqrt(2145)*z*(x**2-y**2)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E2,4,1)": (
            "-S2",
            "sqrt(2145)*x*y*z*(-21*x**8-84*x**6*y**2+336*x**6*z**2-126*x**4*y**4+1008*x**4*y**2*z**2-1008*x**4*z**4-84*x**2*y**6+1008*x**2*y**4*z**2-2016*x**2*y**2*z**4+768*x**2*z**6-21*y**8+336*y**6*z**2-1008*y**4*z**4+768*y**2*z**6-128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
    },
    "C3h": {
        "Qh(0,A',,)": ("C0", "1", "[1]"),
        "Qh(1,A'',,)": ("C0", "z", "[0,1,0]"),
        "Qh(1,E',,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(1,E',,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(2,A',,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(2,E'',,0)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Qh(2,E'',,1)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(2,E',,0)": ("C2", "sqrt(3)*(x**2-y**2)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(2,E',,1)": ("-S2", "-sqrt(3)*x*y", "[sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2]"),
        "Qh(3,A'',,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(3,A',1,)": ("S3", "sqrt(10)*y*(3*x**2-y**2)/4", "[sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(3,A',2,)": ("C3", "sqrt(10)*x*(x**2-3*y**2)/4", "[-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(3,E'',,0)": ("C2", "sqrt(15)*z*(x**2-y**2)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(3,E'',,1)": ("-S2", "-sqrt(15)*x*y*z", "[0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0]"),
        "Qh(3,E',,0)": ("C1", "sqrt(6)*x*(-x**2-y**2+4*z**2)/4", "[0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0]"),
        "Qh(3,E',,1)": ("S1", "sqrt(6)*y*(-x**2-y**2+4*z**2)/4", "[0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0]"),
        "Qh(4,A'',1,)": ("C3", "sqrt(70)*x*z*(x**2-3*y**2)/4", "[0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(4,A'',2,)": ("S3", "sqrt(70)*y*z*(3*x**2-y**2)/4", "[0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(4,A',,)": ("C0", "3*x**4/8+3*x**2*y**2/4-3*x**2*z**2+3*y**4/8-3*y**2*z**2+z**4", "[0,0,0,0,1,0,0,0,0]"),
        "Qh(4,E'',,0)": ("C1", "sqrt(10)*x*z*(-3*x**2-3*y**2+4*z**2)/4", "[0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0]"),
        "Qh(4,E'',,1)": ("S1", "sqrt(10)*y*z*(-3*x**2-3*y**2+4*z**2)/4", "[0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0]"),
        "Qh(4,E',1,0)": ("C4", "sqrt(35)*(x**4-6*x**2*y**2+y**4)/8", "[sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(4,E',1,1)": ("S4", "sqrt(35)*x*y*(x**2-y**2)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(4,E',2,0)": ("C2", "sqrt(5)*(-x**2+y**2)*(x**2+y**2-6*z**2)/4", "[0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0]"),
        "Qh(4,E',2,1)": ("-S2", "sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0]"),
        "Qh(5,A'',,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(5,A',1,)": ("S3", "-sqrt(70)*y*(3*x**2-y**2)*(x**2+y**2-8*z**2)/16", "[0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(5,A',2,)": ("C3", "-sqrt(70)*x*(x**2-3*y**2)*(x**2+y**2-8*z**2)/16", "[0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0]"),
        "Qh(5,E'',1,0)": ("C4", "3*sqrt(35)*z*(x**4-6*x**2*y**2+y**4)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(5,E'',1,1)": ("S4", "3*sqrt(35)*x*y*z*(x**2-y**2)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(5,E'',2,0)": ("C2", "sqrt(105)*z*(-x**2+y**2)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(5,E'',2,1)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(5,E',1,0)": ("C5", "3*sqrt(14)*x*(x**4-10*x**2*y**2+5*y**4)/16", "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(5,E',1,1)": ("-S5", "3*sqrt(14)*y*(-5*x**4+10*x**2*y**2-y**4)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]"),
        "Qh(5,E',2,0)": (
            "C1",
            "sqrt(15)*x*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(5,E',2,1)": (
            "S1",
            "sqrt(15)*y*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(6,A'',1,)": (
            "C3",
            "-sqrt(210)*x*z*(x**2-3*y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(6,A'',2,)": (
            "S3",
            "-sqrt(210)*y*z*(3*x**2-y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(6,A',1,)": (
            "C0",
            "-5*x**6/16-15*x**4*y**2/16+45*x**4*z**2/8-15*x**2*y**4/16+45*x**2*y**2*z**2/4-15*x**2*z**4/2-5*y**6/16+45*y**4*z**2/8-15*y**2*z**4/2+z**6",
            "[0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Qh(6,A',2,)": (
            "C6",
            "sqrt(462)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(6,A',3,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(6,E'',1,0)": ("C5", "3*sqrt(154)*x*z*(x**4-10*x**2*y**2+5*y**4)/16", "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(6,E'',1,1)": (
            "-S5",
            "3*sqrt(154)*y*z*(-5*x**4+10*x**2*y**2-y**4)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Qh(6,E'',2,0)": (
            "C1",
            "sqrt(21)*x*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(6,E'',2,1)": (
            "S1",
            "sqrt(21)*y*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(6,E',1,0)": (
            "C4",
            "3*sqrt(7)*(x**2+y**2-10*z**2)*(-x**4+6*x**2*y**2-y**4)/16",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(6,E',1,1)": (
            "S4",
            "-3*sqrt(7)*x*y*(x**2-y**2)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(6,E',2,0)": (
            "C2",
            "sqrt(210)*(x**2-y**2)*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(6,E',2,1)": (
            "-S2",
            "sqrt(210)*x*y*(-x**4-2*x**2*y**2+16*x**2*z**2-y**4+16*y**2*z**2-16*z**4)/16",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(7,A'',1,)": (
            "S6",
            "sqrt(6006)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(7,A'',2,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(7,A'',3,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(7,A',1,)": (
            "S3",
            "sqrt(21)*y*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(7,A',2,)": (
            "C3",
            "sqrt(21)*x*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(7,E'',1,0)": (
            "C4",
            "sqrt(231)*z*(3*x**2+3*y**2-10*z**2)*(-x**4+6*x**2*y**2-y**4)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(7,E'',1,1)": (
            "S4",
            "-sqrt(231)*x*y*z*(x**2-y**2)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(7,E'',2,0)": (
            "C2",
            "sqrt(42)*z*(x**2-y**2)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(7,E'',2,1)": (
            "-S2",
            "sqrt(42)*x*y*z*(-15*x**4-30*x**2*y**2+80*x**2*z**2-15*y**4+80*y**2*z**2-48*z**4)/16",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(7,E',1,0)": (
            "C7",
            "sqrt(429)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(7,E',1,1)": (
            "S7",
            "sqrt(429)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(7,E',2,0)": (
            "C5",
            "sqrt(231)*x*(x**2+y**2-12*z**2)*(-x**4+10*x**2*y**2-5*y**4)/32",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(7,E',2,1)": (
            "-S5",
            "sqrt(231)*y*(x**2+y**2-12*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Qh(7,E',3,0)": (
            "C1",
            "sqrt(7)*x*(-5*x**6-15*x**4*y**2+120*x**4*z**2-15*x**2*y**4+240*x**2*y**2*z**2-240*x**2*z**4-5*y**6+120*y**4*z**2-240*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(7,E',3,1)": (
            "S1",
            "sqrt(7)*y*(-5*x**6-15*x**4*y**2+120*x**4*z**2-15*x**2*y**4+240*x**2*y**2*z**2-240*x**2*z**4-5*y**6+120*y**4*z**2-240*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(8,A'',1,)": (
            "C3",
            "sqrt(1155)*x*z*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(8,A'',2,)": (
            "S3",
            "sqrt(1155)*y*z*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(8,A',1,)": (
            "C0",
            "35*x**8/128+35*x**6*y**2/32-35*x**6*z**2/4+105*x**4*y**4/64-105*x**4*y**2*z**2/4+105*x**4*z**4/4+35*x**2*y**6/32-105*x**2*y**4*z**2/4+105*x**2*y**2*z**4/2-14*x**2*z**6+35*y**8/128-35*y**6*z**2/4+105*y**4*z**4/4-14*y**2*z**6+z**8",
            "[0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0]",
        ),
        "Qh(8,A',2,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(8,A',3,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(8,E'',1,0)": (
            "C7",
            "3*sqrt(715)*x*z*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(8,E'',1,1)": (
            "S7",
            "3*sqrt(715)*y*z*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(8,E'',2,0)": (
            "C5",
            "3*sqrt(1001)*x*z*(x**2+y**2-4*z**2)*(-x**4+10*x**2*y**2-5*y**4)/32",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(8,E'',2,1)": (
            "-S5",
            "3*sqrt(1001)*y*z*(x**2+y**2-4*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(8,E'',3,0)": (
            "C1",
            "3*x*z*(-35*x**6-105*x**4*y**2+280*x**4*z**2-105*x**2*y**4+560*x**2*y**2*z**2-336*x**2*z**4-35*y**6+280*y**4*z**2-336*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(8,E'',3,1)": (
            "S1",
            "3*y*z*(-35*x**6-105*x**4*y**2+280*x**4*z**2-105*x**2*y**4+560*x**2*y**2*z**2-336*x**2*z**4-35*y**6+280*y**4*z**2-336*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(8,E',1,0)": (
            "C8",
            "3*sqrt(715)*(x**8-28*x**6*y**2+70*x**4*y**4-28*x**2*y**6+y**8)/128",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(8,E',1,1)": (
            "-S8",
            "3*sqrt(715)*x*y*(-x**6+7*x**4*y**2-7*x**2*y**4+y**6)/16",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Qh(8,E',2,0)": (
            "C4",
            "3*sqrt(77)*(x**4-6*x**2*y**2+y**4)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/64",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(8,E',2,1)": (
            "S4",
            "3*sqrt(77)*x*y*(x**2-y**2)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(8,E',3,0)": (
            "C2",
            "3*sqrt(70)*(-x**2+y**2)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(8,E',3,1)": (
            "-S2",
            "3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,A'',1,)": (
            "S6",
            "-sqrt(4290)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**2+3*y**2-14*z**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(9,A'',2,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,A'',3,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,A',1,)": (
            "S9",
            "sqrt(24310)*y*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(9,A',2,)": (
            "S3",
            "-sqrt(2310)*y*(3*x**2-y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,A',3,)": (
            "C9",
            "sqrt(24310)*x*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(9,A',4,)": (
            "C3",
            "-sqrt(2310)*x*(x**2-3*y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(9,E'',1,0)": (
            "C8",
            "3*sqrt(12155)*z*(x**8-28*x**6*y**2+70*x**4*y**4-28*x**2*y**6+y**8)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,E'',1,1)": (
            "-S8",
            "3*sqrt(12155)*x*y*z*(-x**6+7*x**4*y**2-7*x**2*y**4+y**6)/16",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Qh(9,E'',2,0)": (
            "C4",
            "3*sqrt(5005)*z*(x**4-6*x**2*y**2+y**4)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(9,E'',2,1)": (
            "S4",
            "3*sqrt(5005)*x*y*z*(x**2-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/16",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(9,E'',3,0)": (
            "C2",
            "3*sqrt(110)*z*(-x**2+y**2)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E'',3,1)": (
            "-S2",
            "3*sqrt(110)*x*y*z*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E',1,0)": (
            "C7",
            "3*sqrt(1430)*x*(x**2+y**2-16*z**2)*(-x**6+21*x**4*y**2-35*x**2*y**4+7*y**6)/256",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,E',1,1)": (
            "S7",
            "-3*sqrt(1430)*y*(x**2+y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(9,E',2,0)": (
            "C5",
            "3*sqrt(286)*x*(x**4-10*x**2*y**2+5*y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(9,E',2,1)": (
            "-S5",
            "-3*sqrt(286)*y*(5*x**4-10*x**2*y**2+y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(9,E',3,0)": (
            "C1",
            "3*sqrt(5)*x*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E',3,1)": (
            "S1",
            "3*sqrt(5)*y*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A'',1,)": (
            "C9",
            "sqrt(461890)*x*z*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(10,A'',2,)": (
            "C3",
            "-sqrt(4290)*x*z*(x**2-3*y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A'',3,)": (
            "S9",
            "sqrt(461890)*y*z*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(10,A'',4,)": (
            "S3",
            "-sqrt(4290)*y*z*(3*x**2-y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A',1,)": (
            "C0",
            "-63*x**10/256-315*x**8*y**2/256+1575*x**8*z**2/128-315*x**6*y**4/128+1575*x**6*y**2*z**2/32-525*x**6*z**4/8-315*x**4*y**6/128+4725*x**4*y**4*z**2/64-1575*x**4*y**2*z**4/8+315*x**4*z**6/4-315*x**2*y**8/256+1575*x**2*y**6*z**2/32-1575*x**2*y**4*z**4/8+315*x**2*y**2*z**6/2-45*x**2*z**8/2-63*y**10/256+1575*y**8*z**2/128-525*y**6*z**4/8+315*y**4*z**6/4-45*y**2*z**8/2+z**10",
            "[0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A',2,)": (
            "C6",
            "sqrt(4290)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(10,A',3,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,E'',1,0)": (
            "C7",
            "sqrt(72930)*x*z*(3*x**2+3*y**2-16*z**2)*(-x**6+21*x**4*y**2-35*x**2*y**4+7*y**6)/256",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(10,E'',1,1)": (
            "S7",
            "-sqrt(72930)*y*z*(3*x**2+3*y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(10,E'',2,0)": (
            "C5",
            "sqrt(858)*x*z*(x**4-10*x**2*y**2+5*y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(10,E'',2,1)": (
            "-S5",
            "-sqrt(858)*y*z*(5*x**4-10*x**2*y**2+y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(10,E'',3,0)": (
            "C1",
            "sqrt(55)*x*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E'',3,1)": (
            "S1",
            "sqrt(55)*y*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E',1,0)": (
            "C10",
            "sqrt(92378)*(x**10-45*x**8*y**2+210*x**6*y**4-210*x**4*y**6+45*x**2*y**8-y**10)/512",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(10,E',1,1)": (
            "S10",
            "sqrt(92378)*x*y*(5*x**8-60*x**6*y**2+126*x**4*y**4-60*x**2*y**6+5*y**8)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(10,E',2,0)": (
            "C8",
            "sqrt(12155)*(x**2+y**2-18*z**2)*(-x**8+28*x**6*y**2-70*x**4*y**4+28*x**2*y**6-y**8)/256",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(10,E',2,1)": (
            "-S8",
            "sqrt(12155)*x*y*(x**2+y**2-18*z**2)*(x**6-7*x**4*y**2+7*x**2*y**4-y**6)/32",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Qh(10,E',3,0)": (
            "C4",
            "sqrt(2145)*(-x**4+6*x**2*y**2-y**4)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(10,E',3,1)": (
            "S4",
            "-sqrt(2145)*x*y*(x**2-y**2)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(10,E',4,0)": (
            "C2",
            "sqrt(165)*(x**2-y**2)*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/256",
            "[0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E',4,1)": (
            "-S2",
            "sqrt(165)*x*y*(-7*x**8-28*x**6*y**2+336*x**6*z**2-42*x**4*y**4+1008*x**4*y**2*z**2-1680*x**4*z**4-28*x**2*y**6+1008*x**2*y**4*z**2-3360*x**2*y**2*z**4+1792*x**2*z**6-7*y**8+336*y**6*z**2-1680*y**4*z**4+1792*y**2*z**6-384*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A'',1,)": (
            "S6",
            "sqrt(14586)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(11,A'',2,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A'',3,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,A',1,)": (
            "S9",
            "-sqrt(46189)*y*(3*x**2-y**2)*(x**2+y**2-20*z**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/512",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(11,A',2,)": (
            "S3",
            "sqrt(30030)*y*(3*x**2-y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A',3,)": (
            "C9",
            "-sqrt(46189)*x*(x**2-3*y**2)*(x**2+y**2-20*z**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/512",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(11,A',4,)": (
            "C3",
            "sqrt(30030)*x*(x**2-3*y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E'',1,0)": (
            "C10",
            "sqrt(1939938)*z*(x**10-45*x**8*y**2+210*x**6*y**4-210*x**4*y**6+45*x**2*y**8-y**10)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(11,E'',1,1)": (
            "S10",
            "sqrt(1939938)*x*y*z*(5*x**8-60*x**6*y**2+126*x**4*y**4-60*x**2*y**6+5*y**8)/256",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(11,E'',2,0)": (
            "C8",
            "sqrt(692835)*z*(x**2+y**2-6*z**2)*(-x**8+28*x**6*y**2-70*x**4*y**4+28*x**2*y**6-y**8)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(11,E'',2,1)": (
            "-S8",
            "sqrt(692835)*x*y*z*(x**2+y**2-6*z**2)*(x**6-7*x**4*y**2+7*x**2*y**4-y**6)/32",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(11,E'',3,0)": (
            "C4",
            "3*sqrt(1001)*z*(-x**4+6*x**2*y**2-y**4)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E'',3,1)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x**2-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E'',4,0)": (
            "C2",
            "sqrt(2145)*z*(x**2-y**2)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E'',4,1)": (
            "-S2",
            "sqrt(2145)*x*y*z*(-21*x**8-84*x**6*y**2+336*x**6*z**2-126*x**4*y**4+1008*x**4*y**2*z**2-1008*x**4*z**4-84*x**2*y**6+1008*x**2*y**4*z**2-2016*x**2*y**2*z**4+768*x**2*z**6-21*y**8+336*y**6*z**2-1008*y**4*z**4+768*y**2*z**6-128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E',1,0)": (
            "C11",
            "sqrt(88179)*x*(x**10-55*x**8*y**2+330*x**6*y**4-462*x**4*y**6+165*x**2*y**8-11*y**10)/512",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(11,E',1,1)": (
            "-S11",
            "sqrt(88179)*y*(-11*x**10+165*x**8*y**2-462*x**6*y**4+330*x**4*y**6-55*x**2*y**8+y**10)/512",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Qh(11,E',2,0)": (
            "C7",
            "sqrt(36465)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(11,E',2,1)": (
            "S7",
            "sqrt(36465)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(11,E',3,0)": (
            "C5",
            "3*sqrt(143)*x*(-x**4+10*x**2*y**2-5*y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(11,E',3,1)": (
            "-S5",
            "3*sqrt(143)*y*(5*x**4-10*x**2*y**2+y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(11,E',4,0)": (
            "C1",
            "sqrt(66)*x*(-21*x**10-105*x**8*y**2+1260*x**8*z**2-210*x**6*y**4+5040*x**6*y**2*z**2-8400*x**6*z**4-210*x**4*y**6+7560*x**4*y**4*z**2-25200*x**4*y**2*z**4+13440*x**4*z**6-105*x**2*y**8+5040*x**2*y**6*z**2-25200*x**2*y**4*z**4+26880*x**2*y**2*z**6-5760*x**2*z**8-21*y**10+1260*y**8*z**2-8400*y**6*z**4+13440*y**4*z**6-5760*y**2*z**8+512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E',4,1)": (
            "S1",
            "sqrt(66)*y*(-21*x**10-105*x**8*y**2+1260*x**8*z**2-210*x**6*y**4+5040*x**6*y**2*z**2-8400*x**6*z**4-210*x**4*y**6+7560*x**4*y**4*z**2-25200*x**4*y**2*z**4+13440*x**4*z**6-105*x**2*y**8+5040*x**2*y**6*z**2-25200*x**2*y**4*z**4+26880*x**2*y**2*z**6-5760*x**2*z**8-21*y**10+1260*y**8*z**2-8400*y**6*z**4+13440*y**4*z**6-5760*y**2*z**8+512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0]",
        ),
    },
    "C6h": {
        "Qh(0,Ag,,)": ("C0", "1", "[1]"),
        "Qh(1,Au,,)": ("C0", "z", "[0,1,0]"),
        "Qh(1,E1u,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(1,E1u,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(2,Ag,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(2,E1g,,0)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Qh(2,E1g,,1)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(2,E2g,,0)": ("C2", "sqrt(3)*(x**2-y**2)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(2,E2g,,1)": ("-S2", "-sqrt(3)*x*y", "[sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2]"),
        "Qh(3,Au,,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(3,Bu,1,)": ("S3", "sqrt(10)*y*(3*x**2-y**2)/4", "[sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(3,Bu,2,)": ("C3", "sqrt(10)*x*(x**2-3*y**2)/4", "[-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(3,E1u,,0)": ("C1", "sqrt(6)*x*(-x**2-y**2+4*z**2)/4", "[0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0]"),
        "Qh(3,E1u,,1)": ("S1", "sqrt(6)*y*(-x**2-y**2+4*z**2)/4", "[0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0]"),
        "Qh(3,E2u,,0)": ("C2", "sqrt(15)*z*(x**2-y**2)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(3,E2u,,1)": ("-S2", "-sqrt(15)*x*y*z", "[0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0]"),
        "Qh(4,Ag,,)": ("C0", "3*x**4/8+3*x**2*y**2/4-3*x**2*z**2+3*y**4/8-3*y**2*z**2+z**4", "[0,0,0,0,1,0,0,0,0]"),
        "Qh(4,Bg,1,)": ("C3", "sqrt(70)*x*z*(x**2-3*y**2)/4", "[0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(4,Bg,2,)": ("S3", "sqrt(70)*y*z*(3*x**2-y**2)/4", "[0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(4,E1g,,0)": ("C1", "sqrt(10)*x*z*(-3*x**2-3*y**2+4*z**2)/4", "[0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0]"),
        "Qh(4,E1g,,1)": ("S1", "sqrt(10)*y*z*(-3*x**2-3*y**2+4*z**2)/4", "[0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0]"),
        "Qh(4,E2g,1,0)": ("C4", "sqrt(35)*(x**4-6*x**2*y**2+y**4)/8", "[sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(4,E2g,1,1)": ("S4", "sqrt(35)*x*y*(x**2-y**2)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(4,E2g,2,0)": ("C2", "sqrt(5)*(-x**2+y**2)*(x**2+y**2-6*z**2)/4", "[0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0]"),
        "Qh(4,E2g,2,1)": ("-S2", "sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0]"),
        "Qh(5,Au,,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(5,Bu,1,)": ("S3", "-sqrt(70)*y*(3*x**2-y**2)*(x**2+y**2-8*z**2)/16", "[0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(5,Bu,2,)": ("C3", "-sqrt(70)*x*(x**2-3*y**2)*(x**2+y**2-8*z**2)/16", "[0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0]"),
        "Qh(5,E1u,1,0)": ("C5", "3*sqrt(14)*x*(x**4-10*x**2*y**2+5*y**4)/16", "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(5,E1u,1,1)": ("-S5", "3*sqrt(14)*y*(-5*x**4+10*x**2*y**2-y**4)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]"),
        "Qh(5,E1u,2,0)": (
            "C1",
            "sqrt(15)*x*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(5,E1u,2,1)": (
            "S1",
            "sqrt(15)*y*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(5,E2u,1,0)": ("C4", "3*sqrt(35)*z*(x**4-6*x**2*y**2+y**4)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(5,E2u,1,1)": ("S4", "3*sqrt(35)*x*y*z*(x**2-y**2)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(5,E2u,2,0)": ("C2", "sqrt(105)*z*(-x**2+y**2)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(5,E2u,2,1)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(6,Ag,1,)": (
            "C0",
            "-5*x**6/16-15*x**4*y**2/16+45*x**4*z**2/8-15*x**2*y**4/16+45*x**2*y**2*z**2/4-15*x**2*z**4/2-5*y**6/16+45*y**4*z**2/8-15*y**2*z**4/2+z**6",
            "[0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Qh(6,Ag,2,)": (
            "C6",
            "sqrt(462)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(6,Ag,3,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(6,Bg,1,)": (
            "C3",
            "-sqrt(210)*x*z*(x**2-3*y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(6,Bg,2,)": (
            "S3",
            "-sqrt(210)*y*z*(3*x**2-y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(6,E1g,1,0)": ("C5", "3*sqrt(154)*x*z*(x**4-10*x**2*y**2+5*y**4)/16", "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(6,E1g,1,1)": (
            "-S5",
            "3*sqrt(154)*y*z*(-5*x**4+10*x**2*y**2-y**4)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Qh(6,E1g,2,0)": (
            "C1",
            "sqrt(21)*x*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(6,E1g,2,1)": (
            "S1",
            "sqrt(21)*y*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(6,E2g,1,0)": (
            "C4",
            "3*sqrt(7)*(x**2+y**2-10*z**2)*(-x**4+6*x**2*y**2-y**4)/16",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(6,E2g,1,1)": (
            "S4",
            "-3*sqrt(7)*x*y*(x**2-y**2)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(6,E2g,2,0)": (
            "C2",
            "sqrt(210)*(x**2-y**2)*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(6,E2g,2,1)": (
            "-S2",
            "sqrt(210)*x*y*(-x**4-2*x**2*y**2+16*x**2*z**2-y**4+16*y**2*z**2-16*z**4)/16",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(7,Au,1,)": (
            "S6",
            "sqrt(6006)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(7,Au,2,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(7,Au,3,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(7,Bu,1,)": (
            "S3",
            "sqrt(21)*y*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(7,Bu,2,)": (
            "C3",
            "sqrt(21)*x*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(7,E1u,1,0)": (
            "C7",
            "sqrt(429)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(7,E1u,1,1)": (
            "S7",
            "sqrt(429)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(7,E1u,2,0)": (
            "C5",
            "sqrt(231)*x*(x**2+y**2-12*z**2)*(-x**4+10*x**2*y**2-5*y**4)/32",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(7,E1u,2,1)": (
            "-S5",
            "sqrt(231)*y*(x**2+y**2-12*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Qh(7,E1u,3,0)": (
            "C1",
            "sqrt(7)*x*(-5*x**6-15*x**4*y**2+120*x**4*z**2-15*x**2*y**4+240*x**2*y**2*z**2-240*x**2*z**4-5*y**6+120*y**4*z**2-240*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(7,E1u,3,1)": (
            "S1",
            "sqrt(7)*y*(-5*x**6-15*x**4*y**2+120*x**4*z**2-15*x**2*y**4+240*x**2*y**2*z**2-240*x**2*z**4-5*y**6+120*y**4*z**2-240*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(7,E2u,1,0)": (
            "C4",
            "sqrt(231)*z*(3*x**2+3*y**2-10*z**2)*(-x**4+6*x**2*y**2-y**4)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(7,E2u,1,1)": (
            "S4",
            "-sqrt(231)*x*y*z*(x**2-y**2)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(7,E2u,2,0)": (
            "C2",
            "sqrt(42)*z*(x**2-y**2)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(7,E2u,2,1)": (
            "-S2",
            "sqrt(42)*x*y*z*(-15*x**4-30*x**2*y**2+80*x**2*z**2-15*y**4+80*y**2*z**2-48*z**4)/16",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(8,Ag,1,)": (
            "C0",
            "35*x**8/128+35*x**6*y**2/32-35*x**6*z**2/4+105*x**4*y**4/64-105*x**4*y**2*z**2/4+105*x**4*z**4/4+35*x**2*y**6/32-105*x**2*y**4*z**2/4+105*x**2*y**2*z**4/2-14*x**2*z**6+35*y**8/128-35*y**6*z**2/4+105*y**4*z**4/4-14*y**2*z**6+z**8",
            "[0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0]",
        ),
        "Qh(8,Ag,2,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(8,Ag,3,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(8,Bg,1,)": (
            "C3",
            "sqrt(1155)*x*z*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(8,Bg,2,)": (
            "S3",
            "sqrt(1155)*y*z*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(8,E1g,1,0)": (
            "C7",
            "3*sqrt(715)*x*z*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(8,E1g,1,1)": (
            "S7",
            "3*sqrt(715)*y*z*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(8,E1g,2,0)": (
            "C5",
            "3*sqrt(1001)*x*z*(x**2+y**2-4*z**2)*(-x**4+10*x**2*y**2-5*y**4)/32",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(8,E1g,2,1)": (
            "-S5",
            "3*sqrt(1001)*y*z*(x**2+y**2-4*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(8,E1g,3,0)": (
            "C1",
            "3*x*z*(-35*x**6-105*x**4*y**2+280*x**4*z**2-105*x**2*y**4+560*x**2*y**2*z**2-336*x**2*z**4-35*y**6+280*y**4*z**2-336*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(8,E1g,3,1)": (
            "S1",
            "3*y*z*(-35*x**6-105*x**4*y**2+280*x**4*z**2-105*x**2*y**4+560*x**2*y**2*z**2-336*x**2*z**4-35*y**6+280*y**4*z**2-336*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(8,E2g,1,0)": (
            "C8",
            "3*sqrt(715)*(x**8-28*x**6*y**2+70*x**4*y**4-28*x**2*y**6+y**8)/128",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(8,E2g,1,1)": (
            "-S8",
            "3*sqrt(715)*x*y*(-x**6+7*x**4*y**2-7*x**2*y**4+y**6)/16",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Qh(8,E2g,2,0)": (
            "C4",
            "3*sqrt(77)*(x**4-6*x**2*y**2+y**4)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/64",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(8,E2g,2,1)": (
            "S4",
            "3*sqrt(77)*x*y*(x**2-y**2)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(8,E2g,3,0)": (
            "C2",
            "3*sqrt(70)*(-x**2+y**2)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(8,E2g,3,1)": (
            "-S2",
            "3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,Au,1,)": (
            "S6",
            "-sqrt(4290)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**2+3*y**2-14*z**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(9,Au,2,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Au,3,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,Bu,1,)": (
            "S9",
            "sqrt(24310)*y*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(9,Bu,2,)": (
            "S3",
            "-sqrt(2310)*y*(3*x**2-y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,Bu,3,)": (
            "C9",
            "sqrt(24310)*x*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(9,Bu,4,)": (
            "C3",
            "-sqrt(2310)*x*(x**2-3*y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(9,E1u,1,0)": (
            "C7",
            "3*sqrt(1430)*x*(x**2+y**2-16*z**2)*(-x**6+21*x**4*y**2-35*x**2*y**4+7*y**6)/256",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,E1u,1,1)": (
            "S7",
            "-3*sqrt(1430)*y*(x**2+y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(9,E1u,2,0)": (
            "C5",
            "3*sqrt(286)*x*(x**4-10*x**2*y**2+5*y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(9,E1u,2,1)": (
            "-S5",
            "-3*sqrt(286)*y*(5*x**4-10*x**2*y**2+y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(9,E1u,3,0)": (
            "C1",
            "3*sqrt(5)*x*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E1u,3,1)": (
            "S1",
            "3*sqrt(5)*y*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E2u,1,0)": (
            "C8",
            "3*sqrt(12155)*z*(x**8-28*x**6*y**2+70*x**4*y**4-28*x**2*y**6+y**8)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,E2u,1,1)": (
            "-S8",
            "3*sqrt(12155)*x*y*z*(-x**6+7*x**4*y**2-7*x**2*y**4+y**6)/16",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Qh(9,E2u,2,0)": (
            "C4",
            "3*sqrt(5005)*z*(x**4-6*x**2*y**2+y**4)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(9,E2u,2,1)": (
            "S4",
            "3*sqrt(5005)*x*y*z*(x**2-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/16",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(9,E2u,3,0)": (
            "C2",
            "3*sqrt(110)*z*(-x**2+y**2)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E2u,3,1)": (
            "-S2",
            "3*sqrt(110)*x*y*z*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Ag,1,)": (
            "C0",
            "-63*x**10/256-315*x**8*y**2/256+1575*x**8*z**2/128-315*x**6*y**4/128+1575*x**6*y**2*z**2/32-525*x**6*z**4/8-315*x**4*y**6/128+4725*x**4*y**4*z**2/64-1575*x**4*y**2*z**4/8+315*x**4*z**6/4-315*x**2*y**8/256+1575*x**2*y**6*z**2/32-1575*x**2*y**4*z**4/8+315*x**2*y**2*z**6/2-45*x**2*z**8/2-63*y**10/256+1575*y**8*z**2/128-525*y**6*z**4/8+315*y**4*z**6/4-45*y**2*z**8/2+z**10",
            "[0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Ag,2,)": (
            "C6",
            "sqrt(4290)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(10,Ag,3,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,Bg,1,)": (
            "C9",
            "sqrt(461890)*x*z*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(10,Bg,2,)": (
            "C3",
            "-sqrt(4290)*x*z*(x**2-3*y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Bg,3,)": (
            "S9",
            "sqrt(461890)*y*z*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(10,Bg,4,)": (
            "S3",
            "-sqrt(4290)*y*z*(3*x**2-y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E1g,1,0)": (
            "C7",
            "sqrt(72930)*x*z*(3*x**2+3*y**2-16*z**2)*(-x**6+21*x**4*y**2-35*x**2*y**4+7*y**6)/256",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(10,E1g,1,1)": (
            "S7",
            "-sqrt(72930)*y*z*(3*x**2+3*y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(10,E1g,2,0)": (
            "C5",
            "sqrt(858)*x*z*(x**4-10*x**2*y**2+5*y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(10,E1g,2,1)": (
            "-S5",
            "-sqrt(858)*y*z*(5*x**4-10*x**2*y**2+y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(10,E1g,3,0)": (
            "C1",
            "sqrt(55)*x*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E1g,3,1)": (
            "S1",
            "sqrt(55)*y*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E2g,1,0)": (
            "C10",
            "sqrt(92378)*(x**10-45*x**8*y**2+210*x**6*y**4-210*x**4*y**6+45*x**2*y**8-y**10)/512",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(10,E2g,1,1)": (
            "S10",
            "sqrt(92378)*x*y*(5*x**8-60*x**6*y**2+126*x**4*y**4-60*x**2*y**6+5*y**8)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(10,E2g,2,0)": (
            "C8",
            "sqrt(12155)*(x**2+y**2-18*z**2)*(-x**8+28*x**6*y**2-70*x**4*y**4+28*x**2*y**6-y**8)/256",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(10,E2g,2,1)": (
            "-S8",
            "sqrt(12155)*x*y*(x**2+y**2-18*z**2)*(x**6-7*x**4*y**2+7*x**2*y**4-y**6)/32",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Qh(10,E2g,3,0)": (
            "C4",
            "sqrt(2145)*(-x**4+6*x**2*y**2-y**4)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(10,E2g,3,1)": (
            "S4",
            "-sqrt(2145)*x*y*(x**2-y**2)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(10,E2g,4,0)": (
            "C2",
            "sqrt(165)*(x**2-y**2)*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/256",
            "[0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E2g,4,1)": (
            "-S2",
            "sqrt(165)*x*y*(-7*x**8-28*x**6*y**2+336*x**6*z**2-42*x**4*y**4+1008*x**4*y**2*z**2-1680*x**4*z**4-28*x**2*y**6+1008*x**2*y**4*z**2-3360*x**2*y**2*z**4+1792*x**2*z**6-7*y**8+336*y**6*z**2-1680*y**4*z**4+1792*y**2*z**6-384*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Au,1,)": (
            "S6",
            "sqrt(14586)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(11,Au,2,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Au,3,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,Bu,1,)": (
            "S9",
            "-sqrt(46189)*y*(3*x**2-y**2)*(x**2+y**2-20*z**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/512",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(11,Bu,2,)": (
            "S3",
            "sqrt(30030)*y*(3*x**2-y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Bu,3,)": (
            "C9",
            "-sqrt(46189)*x*(x**2-3*y**2)*(x**2+y**2-20*z**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/512",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(11,Bu,4,)": (
            "C3",
            "sqrt(30030)*x*(x**2-3*y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E1u,1,0)": (
            "C11",
            "sqrt(88179)*x*(x**10-55*x**8*y**2+330*x**6*y**4-462*x**4*y**6+165*x**2*y**8-11*y**10)/512",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(11,E1u,1,1)": (
            "-S11",
            "sqrt(88179)*y*(-11*x**10+165*x**8*y**2-462*x**6*y**4+330*x**4*y**6-55*x**2*y**8+y**10)/512",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Qh(11,E1u,2,0)": (
            "C7",
            "sqrt(36465)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(11,E1u,2,1)": (
            "S7",
            "sqrt(36465)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(11,E1u,3,0)": (
            "C5",
            "3*sqrt(143)*x*(-x**4+10*x**2*y**2-5*y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(11,E1u,3,1)": (
            "-S5",
            "3*sqrt(143)*y*(5*x**4-10*x**2*y**2+y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(11,E1u,4,0)": (
            "C1",
            "sqrt(66)*x*(-21*x**10-105*x**8*y**2+1260*x**8*z**2-210*x**6*y**4+5040*x**6*y**2*z**2-8400*x**6*z**4-210*x**4*y**6+7560*x**4*y**4*z**2-25200*x**4*y**2*z**4+13440*x**4*z**6-105*x**2*y**8+5040*x**2*y**6*z**2-25200*x**2*y**4*z**4+26880*x**2*y**2*z**6-5760*x**2*z**8-21*y**10+1260*y**8*z**2-8400*y**6*z**4+13440*y**4*z**6-5760*y**2*z**8+512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E1u,4,1)": (
            "S1",
            "sqrt(66)*y*(-21*x**10-105*x**8*y**2+1260*x**8*z**2-210*x**6*y**4+5040*x**6*y**2*z**2-8400*x**6*z**4-210*x**4*y**6+7560*x**4*y**4*z**2-25200*x**4*y**2*z**4+13440*x**4*z**6-105*x**2*y**8+5040*x**2*y**6*z**2-25200*x**2*y**4*z**4+26880*x**2*y**2*z**6-5760*x**2*z**8-21*y**10+1260*y**8*z**2-8400*y**6*z**4+13440*y**4*z**6-5760*y**2*z**8+512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E2u,1,0)": (
            "C10",
            "sqrt(1939938)*z*(x**10-45*x**8*y**2+210*x**6*y**4-210*x**4*y**6+45*x**2*y**8-y**10)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(11,E2u,1,1)": (
            "S10",
            "sqrt(1939938)*x*y*z*(5*x**8-60*x**6*y**2+126*x**4*y**4-60*x**2*y**6+5*y**8)/256",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(11,E2u,2,0)": (
            "C8",
            "sqrt(692835)*z*(x**2+y**2-6*z**2)*(-x**8+28*x**6*y**2-70*x**4*y**4+28*x**2*y**6-y**8)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(11,E2u,2,1)": (
            "-S8",
            "sqrt(692835)*x*y*z*(x**2+y**2-6*z**2)*(x**6-7*x**4*y**2+7*x**2*y**4-y**6)/32",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(11,E2u,3,0)": (
            "C4",
            "3*sqrt(1001)*z*(-x**4+6*x**2*y**2-y**4)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E2u,3,1)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x**2-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E2u,4,0)": (
            "C2",
            "sqrt(2145)*z*(x**2-y**2)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E2u,4,1)": (
            "-S2",
            "sqrt(2145)*x*y*z*(-21*x**8-84*x**6*y**2+336*x**6*z**2-126*x**4*y**4+1008*x**4*y**2*z**2-1008*x**4*z**4-84*x**2*y**6+1008*x**2*y**4*z**2-2016*x**2*y**2*z**4+768*x**2*z**6-21*y**8+336*y**6*z**2-1008*y**4*z**4+768*y**2*z**6-128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
    },
    "T": {
        "Qh(0,A,,)": ("C0", "1", "[1]"),
        "Qh(1,T,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(1,T,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(1,T,,2)": ("C0", "z", "[0,1,0]"),
        "Qh(2,E,,0)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(2,E,,1)": ("C2", "sqrt(3)*(x**2-y**2)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(2,T,,0)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(2,T,,1)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Qh(2,T,,2)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Qh(3,A,,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(3,T,1,0)": (
            "-sqrt(6)*C1/4+sqrt(10)*C3/4",
            "x*(2*x**2-3*y**2-3*z**2)/2",
            "[-sqrt(5)/4,0,sqrt(3)/4,0,-sqrt(3)/4,0,sqrt(5)/4]",
        ),
        "Qh(3,T,1,1)": (
            "-sqrt(6)*S1/4-sqrt(10)*S3/4",
            "-y*(3*x**2-2*y**2+3*z**2)/2",
            "[-sqrt(5)*I/4,0,-sqrt(3)*I/4,0,-sqrt(3)*I/4,0,-sqrt(5)*I/4]",
        ),
        "Qh(3,T,1,2)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(3,T,2,0)": (
            "-sqrt(10)*C1/4-sqrt(6)*C3/4",
            "sqrt(15)*x*(y-z)*(y+z)/2",
            "[sqrt(3)/4,0,sqrt(5)/4,0,-sqrt(5)/4,0,-sqrt(3)/4]",
        ),
        "Qh(3,T,2,1)": (
            "sqrt(10)*S1/4-sqrt(6)*S3/4",
            "-sqrt(15)*y*(x-z)*(x+z)/2",
            "[-sqrt(3)*I/4,0,sqrt(5)*I/4,0,sqrt(5)*I/4,0,-sqrt(3)*I/4]",
        ),
        "Qh(3,T,2,2)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(4,A,,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Qh(4,E,,0)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "sqrt(15)*(-x**4+12*x**2*y**2-6*x**2*z**2-y**4-6*y**2*z**2+2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Qh(4,E,,1)": ("-C2", "sqrt(5)*(x**4-6*x**2*z**2-y**4+6*y**2*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Qh(4,T,1,0)": (
            "-sqrt(14)*S1/4-sqrt(2)*S3/4",
            "sqrt(35)*y*z*(y-z)*(y+z)/2",
            "[0,-I/4,0,-sqrt(7)*I/4,0,-sqrt(7)*I/4,0,-I/4,0]",
        ),
        "Qh(4,T,1,1)": ("sqrt(14)*C1/4-sqrt(2)*C3/4", "-sqrt(35)*x*z*(x-z)*(x+z)/2", "[0,1/4,0,-sqrt(7)/4,0,sqrt(7)/4,0,-1/4,0]"),
        "Qh(4,T,1,2)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(4,T,2,0)": (
            "-sqrt(2)*S1/4+sqrt(14)*S3/4",
            "sqrt(5)*y*z*(6*x**2-y**2-z**2)/2",
            "[0,sqrt(7)*I/4,0,-I/4,0,-I/4,0,sqrt(7)*I/4,0]",
        ),
        "Qh(4,T,2,1)": (
            "-sqrt(2)*C1/4-sqrt(14)*C3/4",
            "-sqrt(5)*x*z*(x**2-6*y**2+z**2)/2",
            "[0,sqrt(7)/4,0,1/4,0,-1/4,0,-sqrt(7)/4,0]",
        ),
        "Qh(4,T,2,2)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(5,E,,0)": ("S4", "3*sqrt(35)*x*y*z*(x**2-y**2)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(5,E,,1)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(5,T,1,0)": (
            "sqrt(15)*C1/8-sqrt(70)*C3/16+3*sqrt(14)*C5/16",
            "x*(8*x**4-40*x**2*y**2-40*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/8",
            "[-3*sqrt(7)/16,0,sqrt(35)/16,0,-sqrt(30)/16,0,sqrt(30)/16,0,-sqrt(35)/16,0,3*sqrt(7)/16]",
        ),
        "Qh(5,T,1,1)": (
            "sqrt(15)*S1/8+sqrt(70)*S3/16+3*sqrt(14)*S5/16",
            "y*(15*x**4-40*x**2*y**2+30*x**2*z**2+8*y**4-40*y**2*z**2+15*z**4)/8",
            "[3*sqrt(7)*I/16,0,sqrt(35)*I/16,0,sqrt(30)*I/16,0,sqrt(30)*I/16,0,sqrt(35)*I/16,0,3*sqrt(7)*I/16]",
        ),
        "Qh(5,T,1,2)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(5,T,2,0)": (
            "sqrt(21)*C1/8+9*sqrt(2)*C3/16+sqrt(10)*C5/16",
            "3*sqrt(35)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/8",
            "[-sqrt(5)/16,0,-9/16,0,-sqrt(42)/16,0,sqrt(42)/16,0,9/16,0,sqrt(5)/16]",
        ),
        "Qh(5,T,2,1)": (
            "sqrt(21)*S1/8-9*sqrt(2)*S3/16+sqrt(10)*S5/16",
            "3*sqrt(35)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/8",
            "[sqrt(5)*I/16,0,-9*I/16,0,sqrt(42)*I/16,0,sqrt(42)*I/16,0,-9*I/16,0,sqrt(5)*I/16]",
        ),
        "Qh(5,T,2,2)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(5,T,3,0)": (
            "sqrt(7)*C1/4-sqrt(6)*C3/8-sqrt(30)*C5/8",
            "sqrt(105)*x*(y-z)*(y+z)*(2*x**2-y**2-z**2)/4",
            "[sqrt(15)/8,0,sqrt(3)/8,0,-sqrt(14)/8,0,sqrt(14)/8,0,-sqrt(3)/8,0,-sqrt(15)/8]",
        ),
        "Qh(5,T,3,1)": (
            "-sqrt(7)*S1/4-sqrt(6)*S3/8+sqrt(30)*S5/8",
            "sqrt(105)*y*(x-z)*(x+z)*(x**2-2*y**2+z**2)/4",
            "[sqrt(15)*I/8,0,-sqrt(3)*I/8,0,-sqrt(14)*I/8,0,-sqrt(14)*I/8,0,-sqrt(3)*I/8,0,sqrt(15)*I/8]",
        ),
        "Qh(5,T,3,2)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(6,A,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Qh(6,A,2,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Qh(6,E,,0)": (
            "sqrt(2)*(sqrt(7)*C0+C4)/4",
            "sqrt(14)*(-x**6+15*x**4*z**2-15*x**2*z**4-y**6+15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Qh(6,E,,1)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x**6-10*x**4*y**2-5*x**4*z**2+10*x**2*y**4+5*x**2*z**4-y**6+5*y**4*z**2-5*y**2*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Qh(6,T,1,0)": (
            "sqrt(3)*S1/4-sqrt(30)*S3/8-sqrt(22)*S5/8",
            "3*sqrt(7)*y*z*(y-z)*(y+z)*(10*x**2-y**2-z**2)/4",
            "[0,-sqrt(11)*I/8,0,-sqrt(15)*I/8,0,sqrt(6)*I/8,0,sqrt(6)*I/8,0,-sqrt(15)*I/8,0,-sqrt(11)*I/8,0]",
        ),
        "Qh(6,T,1,1)": (
            "-sqrt(3)*C1/4-sqrt(30)*C3/8+sqrt(22)*C5/8",
            "3*sqrt(7)*x*z*(x-z)*(x+z)*(x**2-10*y**2+z**2)/4",
            "[0,-sqrt(11)/8,0,sqrt(15)/8,0,sqrt(6)/8,0,-sqrt(6)/8,0,-sqrt(15)/8,0,sqrt(11)/8,0]",
        ),
        "Qh(6,T,1,2)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(6,T,2,0)": (
            "3*sqrt(22)*S1/16+sqrt(55)*S3/16+sqrt(3)*S5/16",
            "sqrt(462)*y*z*(y**2-3*z**2)*(3*y**2-z**2)/16",
            "[0,sqrt(6)*I/32,0,sqrt(110)*I/32,0,3*sqrt(11)*I/16,0,3*sqrt(11)*I/16,0,sqrt(110)*I/32,0,sqrt(6)*I/32,0]",
        ),
        "Qh(6,T,2,1)": (
            "3*sqrt(22)*C1/16-sqrt(55)*C3/16+sqrt(3)*C5/16",
            "sqrt(462)*x*z*(x**2-3*z**2)*(3*x**2-z**2)/16",
            "[0,-sqrt(6)/32,0,sqrt(110)/32,0,-3*sqrt(11)/16,0,3*sqrt(11)/16,0,-sqrt(110)/32,0,sqrt(6)/32,0]",
        ),
        "Qh(6,T,2,2)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(6,T,3,0)": (
            "sqrt(10)*S1/16-9*S3/16+sqrt(165)*S5/16",
            "sqrt(210)*y*z*(16*x**4-16*x**2*y**2-16*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,sqrt(330)*I/32,0,-9*sqrt(2)*I/32,0,sqrt(5)*I/16,0,sqrt(5)*I/16,0,-9*sqrt(2)*I/32,0,sqrt(330)*I/32,0]",
        ),
        "Qh(6,T,3,1)": (
            "sqrt(10)*C1/16+9*C3/16+sqrt(165)*C5/16",
            "sqrt(210)*x*z*(x**4-16*x**2*y**2+2*x**2*z**2+16*y**4-16*y**2*z**2+z**4)/16",
            "[0,-sqrt(330)/32,0,-9*sqrt(2)/32,0,-sqrt(5)/16,0,sqrt(5)/16,0,9*sqrt(2)/32,0,sqrt(330)/32,0]",
        ),
        "Qh(6,T,3,2)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(7,A,,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Qh(7,E,,0)": (
            "S4",
            "sqrt(231)*x*y*z*(-3*x**4+10*x**2*z**2+3*y**4-10*y**2*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(7,E,,1)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "sqrt(77)*x*y*z*(-3*x**4+20*x**2*y**2-10*x**2*z**2-3*y**4-10*y**2*z**2+6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Qh(7,T,1,0)": (
            "-5*sqrt(7)*C1/32+3*sqrt(21)*C3/32-sqrt(231)*C5/32+sqrt(429)*C7/32",
            "x*(16*x**6-168*x**4*y**2-168*x**4*z**2+210*x**2*y**4+420*x**2*y**2*z**2+210*x**2*z**4-35*y**6-105*y**4*z**2-105*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)/64,0,sqrt(462)/64,0,-3*sqrt(42)/64,0,5*sqrt(14)/64,0,-5*sqrt(14)/64,0,3*sqrt(42)/64,0,-sqrt(462)/64,0,sqrt(858)/64]",
        ),
        "Qh(7,T,1,1)": (
            "-5*sqrt(7)*S1/32-3*sqrt(21)*S3/32-sqrt(231)*S5/32-sqrt(429)*S7/32",
            "-y*(35*x**6-210*x**4*y**2+105*x**4*z**2+168*x**2*y**4-420*x**2*y**2*z**2+105*x**2*z**4-16*y**6+168*y**4*z**2-210*y**2*z**4+35*z**6)/16",
            "[-sqrt(858)*I/64,0,-sqrt(462)*I/64,0,-3*sqrt(42)*I/64,0,-5*sqrt(14)*I/64,0,-5*sqrt(14)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(462)*I/64,0,-sqrt(858)*I/64]",
        ),
        "Qh(7,T,1,2)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(7,T,2,0)": (
            "-3*sqrt(33)*C1/32-sqrt(11)*C3/32+25*C5/32+sqrt(91)*C7/32",
            "sqrt(231)*x*(10*x**2-3*y**2-3*z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[-sqrt(182)/64,0,-25*sqrt(2)/64,0,sqrt(22)/64,0,3*sqrt(66)/64,0,-3*sqrt(66)/64,0,-sqrt(22)/64,0,25*sqrt(2)/64,0,sqrt(182)/64]",
        ),
        "Qh(7,T,2,1)": (
            "-3*sqrt(33)*S1/32+sqrt(11)*S3/32+25*S5/32-sqrt(91)*S7/32",
            "-sqrt(231)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(3*x**2-10*y**2+3*z**2)/16",
            "[-sqrt(182)*I/64,0,25*sqrt(2)*I/64,0,sqrt(22)*I/64,0,-3*sqrt(66)*I/64,0,-3*sqrt(66)*I/64,0,sqrt(22)*I/64,0,25*sqrt(2)*I/64,0,-sqrt(182)*I/64]",
        ),
        "Qh(7,T,2,2)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(7,T,3,0)": (
            "-sqrt(858)*C1/64-3*sqrt(286)*C3/64-5*sqrt(26)*C5/64-sqrt(14)*C7/64",
            "sqrt(6006)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/32",
            "[sqrt(7)/64,0,5*sqrt(13)/64,0,3*sqrt(143)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-3*sqrt(143)/64,0,-5*sqrt(13)/64,0,-sqrt(7)/64]",
        ),
        "Qh(7,T,3,1)": (
            "sqrt(858)*S1/64-3*sqrt(286)*S3/64+5*sqrt(26)*S5/64-sqrt(14)*S7/64",
            "-sqrt(6006)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)/32",
            "[-sqrt(7)*I/64,0,5*sqrt(13)*I/64,0,-3*sqrt(143)*I/64,0,sqrt(429)*I/64,0,sqrt(429)*I/64,0,-3*sqrt(143)*I/64,0,5*sqrt(13)*I/64,0,-sqrt(7)*I/64]",
        ),
        "Qh(7,T,3,2)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(7,T,4,0)": (
            "-15*sqrt(6)*C1/64+19*sqrt(2)*C3/64-sqrt(22)*C5/64-sqrt(2002)*C7/64",
            "sqrt(42)*x*(y-z)*(y+z)*(48*x**4-80*x**2*y**2-80*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/32",
            "[sqrt(1001)/64,0,sqrt(11)/64,0,-19/64,0,15*sqrt(3)/64,0,-15*sqrt(3)/64,0,19/64,0,-sqrt(11)/64,0,-sqrt(1001)/64]",
        ),
        "Qh(7,T,4,1)": (
            "15*sqrt(6)*S1/64+19*sqrt(2)*S3/64+sqrt(22)*S5/64-sqrt(2002)*S7/64",
            "-sqrt(42)*y*(x-z)*(x+z)*(15*x**4-80*x**2*y**2+30*x**2*z**2+48*y**4-80*y**2*z**2+15*z**4)/32",
            "[-sqrt(1001)*I/64,0,sqrt(11)*I/64,0,19*I/64,0,15*sqrt(3)*I/64,0,15*sqrt(3)*I/64,0,19*I/64,0,sqrt(11)*I/64,0,-sqrt(1001)*I/64]",
        ),
        "Qh(7,T,4,2)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(8,A,,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Qh(8,E,1,0)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Qh(8,E,1,1)": (
            "C6",
            "sqrt(858)*(-x**8+14*x**6*y**2+14*x**6*z**2-210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2+y**8-14*y**6*z**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(8,E,2,0)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Qh(8,E,2,1)": (
            "C2",
            "3*sqrt(70)*(-x**8-2*x**6*y**2+30*x**6*z**2+30*x**4*y**2*z**2-80*x**4*z**4+2*x**2*y**6-30*x**2*y**4*z**2+32*x**2*z**6+y**8-30*y**6*z**2+80*y**4*z**4-32*y**2*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(8,T,1,0)": (
            "-sqrt(715)*S1/32-sqrt(273)*S3/32-sqrt(35)*S5/32-S7/32",
            "3*sqrt(715)*y*z*(y-z)*(y+z)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[0,-sqrt(2)*I/64,0,-sqrt(70)*I/64,0,-sqrt(546)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(546)*I/64,0,-sqrt(70)*I/64,0,-sqrt(2)*I/64,0]",
        ),
        "Qh(8,T,1,1)": (
            "sqrt(715)*C1/32-sqrt(273)*C3/32+sqrt(35)*C5/32-C7/32",
            "-3*sqrt(715)*x*z*(x-z)*(x+z)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/16",
            "[0,sqrt(2)/64,0,-sqrt(70)/64,0,sqrt(546)/64,0,-sqrt(1430)/64,0,sqrt(1430)/64,0,-sqrt(546)/64,0,sqrt(70)/64,0,-sqrt(2)/64,0]",
        ),
        "Qh(8,T,1,2)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(8,T,2,0)": (
            "-sqrt(77)*S1/32+5*sqrt(15)*S3/32-3*sqrt(13)*S5/32-sqrt(455)*S7/32",
            "3*sqrt(77)*y*z*(y-z)*(y+z)*(40*x**4-24*x**2*y**2-24*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,-sqrt(910)*I/64,0,-3*sqrt(26)*I/64,0,5*sqrt(30)*I/64,0,-sqrt(154)*I/64,0,-sqrt(154)*I/64,0,5*sqrt(30)*I/64,0,-3*sqrt(26)*I/64,0,-sqrt(910)*I/64,0]",
        ),
        "Qh(8,T,2,1)": (
            "sqrt(77)*C1/32+5*sqrt(15)*C3/32+3*sqrt(13)*C5/32-sqrt(455)*C7/32",
            "-3*sqrt(77)*x*z*(x-z)*(x+z)*(x**4-24*x**2*y**2+2*x**2*z**2+40*y**4-24*y**2*z**2+z**4)/16",
            "[0,sqrt(910)/64,0,-3*sqrt(26)/64,0,-5*sqrt(30)/64,0,-sqrt(154)/64,0,sqrt(154)/64,0,5*sqrt(30)/64,0,3*sqrt(26)/64,0,-sqrt(910)/64,0]",
        ),
        "Qh(8,T,2,2)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(8,T,3,0)": (
            "-sqrt(858)*S1/64+sqrt(910)*S3/64+7*sqrt(42)*S5/64+3*sqrt(30)*S7/64",
            "sqrt(858)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(14*x**2-y**2-z**2)/32",
            "[0,3*sqrt(15)*I/64,0,7*sqrt(21)*I/64,0,sqrt(455)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(455)*I/64,0,7*sqrt(21)*I/64,0,3*sqrt(15)*I/64,0]",
        ),
        "Qh(8,T,3,1)": (
            "-sqrt(858)*C1/64-sqrt(910)*C3/64+7*sqrt(42)*C5/64-3*sqrt(30)*C7/64",
            "-sqrt(858)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(x**2-14*y**2+z**2)/32",
            "[0,3*sqrt(15)/64,0,-7*sqrt(21)/64,0,sqrt(455)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-sqrt(455)/64,0,7*sqrt(21)/64,0,-3*sqrt(15)/64,0]",
        ),
        "Qh(8,T,3,2)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(8,T,4,0)": (
            "-sqrt(70)*S1/64+3*sqrt(66)*S3/64-sqrt(1430)*S5/64+sqrt(2002)*S7/64",
            "3*sqrt(70)*y*z*(32*x**6-80*x**4*y**2-80*x**4*z**2+30*x**2*y**4+60*x**2*y**2*z**2+30*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,sqrt(1001)*I/64,0,-sqrt(715)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(35)*I/64,0,-sqrt(35)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(715)*I/64,0,sqrt(1001)*I/64,0]",
        ),
        "Qh(8,T,4,1)": (
            "-sqrt(70)*C1/64-3*sqrt(66)*C3/64-sqrt(1430)*C5/64-sqrt(2002)*C7/64",
            "-3*sqrt(70)*x*z*(x**6-30*x**4*y**2+3*x**4*z**2+80*x**2*y**4-60*x**2*y**2*z**2+3*x**2*z**4-32*y**6+80*y**4*z**2-30*y**2*z**4+z**6)/32",
            "[0,sqrt(1001)/64,0,sqrt(715)/64,0,3*sqrt(33)/64,0,sqrt(35)/64,0,-sqrt(35)/64,0,-3*sqrt(33)/64,0,-sqrt(715)/64,0,-sqrt(1001)/64,0]",
        ),
        "Qh(8,T,4,2)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,A,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Qh(9,A,2,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Qh(9,E,,0)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(3*x**6-14*x**4*y**2-7*x**4*z**2+14*x**2*y**4+7*x**2*z**4-3*y**6+7*y**4*z**2-7*y**2*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Qh(9,E,,1)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Qh(9,T,1,0)": (
            "21*sqrt(5)*C1/128-sqrt(2310)*C3/128+3*sqrt(286)*C5/128-3*sqrt(1430)*C7/256+sqrt(24310)*C9/256",
            "x*(128*x**8-2304*x**6*y**2-2304*x**6*z**2+6048*x**4*y**4+12096*x**4*y**2*z**2+6048*x**4*z**4-3360*x**2*y**6-10080*x**2*y**4*z**2-10080*x**2*y**2*z**4-3360*x**2*z**6+315*y**8+1260*y**6*z**2+1890*y**4*z**4+1260*y**2*z**6+315*z**8)/128",
            "[-sqrt(12155)/256,0,3*sqrt(715)/256,0,-3*sqrt(143)/128,0,sqrt(1155)/128,0,-21*sqrt(10)/256,0,21*sqrt(10)/256,0,-sqrt(1155)/128,0,3*sqrt(143)/128,0,-3*sqrt(715)/256,0,sqrt(12155)/256]",
        ),
        "Qh(9,T,1,1)": (
            "21*sqrt(5)*S1/128+sqrt(2310)*S3/128+3*sqrt(286)*S5/128+3*sqrt(1430)*S7/256+sqrt(24310)*S9/256",
            "y*(315*x**8-3360*x**6*y**2+1260*x**6*z**2+6048*x**4*y**4-10080*x**4*y**2*z**2+1890*x**4*z**4-2304*x**2*y**6+12096*x**2*y**4*z**2-10080*x**2*y**2*z**4+1260*x**2*z**6+128*y**8-2304*y**6*z**2+6048*y**4*z**4-3360*y**2*z**6+315*z**8)/128",
            "[sqrt(12155)*I/256,0,3*sqrt(715)*I/256,0,3*sqrt(143)*I/128,0,sqrt(1155)*I/128,0,21*sqrt(10)*I/256,0,21*sqrt(10)*I/256,0,sqrt(1155)*I/128,0,3*sqrt(143)*I/128,0,3*sqrt(715)*I/256,0,sqrt(12155)*I/256]",
        ),
        "Qh(9,T,1,2)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,T,2,0)": (
            "sqrt(2431)*C1/128+sqrt(9282)*C3/128+5*sqrt(170)*C5/128+7*sqrt(34)*C7/256+3*sqrt(2)*C9/256",
            "3*sqrt(12155)*x*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/128",
            "[-3/256,0,-7*sqrt(17)/256,0,-5*sqrt(85)/128,0,-sqrt(4641)/128,0,-sqrt(4862)/256,0,sqrt(4862)/256,0,sqrt(4641)/128,0,5*sqrt(85)/128,0,7*sqrt(17)/256,0,3/256]",
        ),
        "Qh(9,T,2,1)": (
            "sqrt(2431)*S1/128-sqrt(9282)*S3/128+5*sqrt(170)*S5/128-7*sqrt(34)*S7/256+3*sqrt(2)*S9/256",
            "3*sqrt(12155)*y*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/128",
            "[3*I/256,0,-7*sqrt(17)*I/256,0,5*sqrt(85)*I/128,0,-sqrt(4641)*I/128,0,sqrt(4862)*I/256,0,sqrt(4862)*I/256,0,-sqrt(4641)*I/128,0,5*sqrt(85)*I/128,0,-7*sqrt(17)*I/256,0,3*I/256]",
        ),
        "Qh(9,T,2,2)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,T,3,0)": (
            "sqrt(1001)*C1/64-sqrt(78)*C3/64-3*sqrt(70)*C5/64+23*sqrt(14)*C7/128+3*sqrt(238)*C9/128",
            "3*sqrt(5005)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(8*x**4-8*x**2*y**2-8*x**2*z**2+y**4+2*y**2*z**2+z**4)/64",
            "[-3*sqrt(119)/128,0,-23*sqrt(7)/128,0,3*sqrt(35)/64,0,sqrt(39)/64,0,-sqrt(2002)/128,0,sqrt(2002)/128,0,-sqrt(39)/64,0,-3*sqrt(35)/64,0,23*sqrt(7)/128,0,3*sqrt(119)/128]",
        ),
        "Qh(9,T,3,1)": (
            "sqrt(1001)*S1/64+sqrt(78)*S3/64-3*sqrt(70)*S5/64-23*sqrt(14)*S7/128+3*sqrt(238)*S9/128",
            "3*sqrt(5005)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(x**4-8*x**2*y**2+2*x**2*z**2+8*y**4-8*y**2*z**2+z**4)/64",
            "[3*sqrt(119)*I/128,0,-23*sqrt(7)*I/128,0,-3*sqrt(35)*I/64,0,sqrt(39)*I/64,0,sqrt(2002)*I/128,0,sqrt(2002)*I/128,0,sqrt(39)*I/64,0,-3*sqrt(35)*I/64,0,-23*sqrt(7)*I/128,0,3*sqrt(119)*I/128]",
        ),
        "Qh(9,T,3,2)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(9,T,4,0)": (
            "sqrt(858)*C1/64+sqrt(91)*C3/32-5*sqrt(15)*C5/32-21*sqrt(3)*C7/64-sqrt(51)*C9/64",
            "sqrt(4290)*x*(y-z)*(y+z)*(14*x**2-3*y**2-3*z**2)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/64",
            "[sqrt(102)/128,0,21*sqrt(6)/128,0,5*sqrt(30)/64,0,-sqrt(182)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(182)/64,0,-5*sqrt(30)/64,0,-21*sqrt(6)/128,0,-sqrt(102)/128]",
        ),
        "Qh(9,T,4,1)": (
            "-sqrt(858)*S1/64+sqrt(91)*S3/32+5*sqrt(15)*S5/32-21*sqrt(3)*S7/64+sqrt(51)*S9/64",
            "sqrt(4290)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(3*x**2-14*y**2+3*z**2)/64",
            "[sqrt(102)*I/128,0,-21*sqrt(6)*I/128,0,5*sqrt(30)*I/64,0,sqrt(182)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(182)*I/64,0,5*sqrt(30)*I/64,0,-21*sqrt(6)*I/128,0,sqrt(102)*I/128]",
        ),
        "Qh(9,T,4,2)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,T,5,0)": (
            "7*sqrt(22)*C1/64-3*sqrt(21)*C3/32+sqrt(65)*C5/32+sqrt(13)*C7/64-3*sqrt(221)*C9/64",
            "3*sqrt(110)*x*(y-z)*(y+z)*(32*x**6-112*x**4*y**2-112*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-7*y**6-21*y**4*z**2-21*y**2*z**4-7*z**6)/64",
            "[3*sqrt(442)/128,0,-sqrt(26)/128,0,-sqrt(130)/64,0,3*sqrt(42)/64,0,-7*sqrt(11)/64,0,7*sqrt(11)/64,0,-3*sqrt(42)/64,0,sqrt(130)/64,0,sqrt(26)/128,0,-3*sqrt(442)/128]",
        ),
        "Qh(9,T,5,1)": (
            "-7*sqrt(22)*S1/64-3*sqrt(21)*S3/32-sqrt(65)*S5/32+sqrt(13)*S7/64+3*sqrt(221)*S9/64",
            "3*sqrt(110)*y*(x-z)*(x+z)*(7*x**6-70*x**4*y**2+21*x**4*z**2+112*x**2*y**4-140*x**2*y**2*z**2+21*x**2*z**4-32*y**6+112*y**4*z**2-70*y**2*z**4+7*z**6)/64",
            "[3*sqrt(442)*I/128,0,sqrt(26)*I/128,0,-sqrt(130)*I/64,0,-3*sqrt(42)*I/64,0,-7*sqrt(11)*I/64,0,-7*sqrt(11)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(130)*I/64,0,sqrt(26)*I/128,0,3*sqrt(442)*I/128]",
        ),
        "Qh(9,T,5,2)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Qh(10,A,2,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Qh(10,E,1,0)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "sqrt(420189)*(-22*x**10-45*x**8*y**2+1035*x**8*z**2+105*x**6*y**4+630*x**6*y**2*z**2-4935*x**6*z**4+105*x**4*y**6-3150*x**4*y**4*z**2+1575*x**4*y**2*z**4+4830*x**4*z**6-45*x**2*y**8+630*x**2*y**6*z**2+1575*x**2*y**4*z**4-1260*x**2*y**2*z**6-990*x**2*z**8-22*y**10+1035*y**8*z**2-4935*y**6*z**4+4830*y**4*z**6-990*y**2*z**8+44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Qh(10,E,1,1)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(22*x**10-675*x**8*y**2-315*x**8*z**2+3255*x**6*y**4-630*x**6*y**2*z**2+1575*x**6*z**4-3255*x**4*y**6+1575*x**4*y**2*z**4-1680*x**4*z**6+675*x**2*y**8+630*x**2*y**6*z**2-1575*x**2*y**4*z**4+360*x**2*z**8-22*y**10+315*y**8*z**2-1575*y**6*z**4+1680*y**4*z**6-360*y**2*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Qh(10,E,2,0)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "sqrt(3213210)*(-3*x**10+96*x**8*y**2+39*x**8*z**2-224*x**6*y**4-1344*x**6*y**2*z**2+42*x**6*z**4-224*x**4*y**6+6720*x**4*y**4*z**2-3360*x**4*y**2*z**4+182*x**4*z**6+96*x**2*y**8-1344*x**2*y**6*z**2-3360*x**2*y**4*z**4+2688*x**2*y**2*z**6-135*x**2*z**8-3*y**10+39*y**8*z**2+42*y**6*z**4+182*y**4*z**6-135*y**2*z**8+6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Qh(10,E,2,1)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(9*x**10-174*x**8*y**2-231*x**8*z**2+140*x**6*y**4+4032*x**6*y**2*z**2+406*x**6*z**4-140*x**4*y**6-10080*x**4*y**2*z**4+266*x**4*z**6+174*x**2*y**8-4032*x**2*y**6*z**2+10080*x**2*y**4*z**4-57*x**2*z**8-9*y**10+231*y**8*z**2-406*y**6*z**4-266*y**4*z**6+57*y**2*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Qh(10,T,1,0)": (
            "sqrt(221)*S1/32-sqrt(102)*S3/32-sqrt(510)*S5/32-11*sqrt(6)*S7/64-sqrt(38)*S9/64",
            "sqrt(12155)*y*z*(y-z)*(y+z)*(18*x**2-y**2-z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/32",
            "[0,-sqrt(19)*I/64,0,-11*sqrt(3)*I/64,0,-sqrt(255)*I/32,0,-sqrt(51)*I/32,0,sqrt(442)*I/64,0,sqrt(442)*I/64,0,-sqrt(51)*I/32,0,-sqrt(255)*I/32,0,-11*sqrt(3)*I/64,0,-sqrt(19)*I/64,0]",
        ),
        "Qh(10,T,1,1)": (
            "-sqrt(221)*C1/32-sqrt(102)*C3/32+sqrt(510)*C5/32-11*sqrt(6)*C7/64+sqrt(38)*C9/64",
            "sqrt(12155)*x*z*(x-z)*(x+z)*(x**2-18*y**2+z**2)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/32",
            "[0,-sqrt(19)/64,0,11*sqrt(3)/64,0,-sqrt(255)/32,0,sqrt(51)/32,0,sqrt(442)/64,0,-sqrt(442)/64,0,-sqrt(51)/32,0,sqrt(255)/32,0,-11*sqrt(3)/64,0,sqrt(19)/64,0]",
        ),
        "Qh(10,T,1,2)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(10,T,2,0)": (
            "sqrt(39)*S1/32-11*sqrt(2)*S3/32+5*sqrt(10)*S5/32-sqrt(34)*S7/64-sqrt(1938)*S9/64",
            "sqrt(2145)*y*z*(y-z)*(y+z)*(112*x**6-168*x**4*y**2-168*x**4*z**2+42*x**2*y**4+84*x**2*y**2*z**2+42*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,-sqrt(969)*I/64,0,-sqrt(17)*I/64,0,5*sqrt(5)*I/32,0,-11*I/32,0,sqrt(78)*I/64,0,sqrt(78)*I/64,0,-11*I/32,0,5*sqrt(5)*I/32,0,-sqrt(17)*I/64,0,-sqrt(969)*I/64,0]",
        ),
        "Qh(10,T,2,1)": (
            "-sqrt(39)*C1/32-11*sqrt(2)*C3/32-5*sqrt(10)*C5/32-sqrt(34)*C7/64+sqrt(1938)*C9/64",
            "sqrt(2145)*x*z*(x-z)*(x+z)*(x**6-42*x**4*y**2+3*x**4*z**2+168*x**2*y**4-84*x**2*y**2*z**2+3*x**2*z**4-112*y**6+168*y**4*z**2-42*y**2*z**4+z**6)/32",
            "[0,-sqrt(969)/64,0,sqrt(17)/64,0,5*sqrt(5)/32,0,11/32,0,sqrt(78)/64,0,-sqrt(78)/64,0,-11/32,0,-5*sqrt(5)/32,0,-sqrt(17)/64,0,sqrt(969)/64,0]",
        ),
        "Qh(10,T,2,2)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(10,T,3,0)": (
            "sqrt(41990)*S1/256+sqrt(4845)*S3/128+sqrt(969)*S5/128+sqrt(285)*S7/256+sqrt(5)*S9/256",
            "sqrt(92378)*y*z*(y**4-10*y**2*z**2+5*z**4)*(5*y**4-10*y**2*z**2+z**4)/256",
            "[0,sqrt(10)*I/512,0,sqrt(570)*I/512,0,sqrt(1938)*I/256,0,sqrt(9690)*I/256,0,sqrt(20995)*I/256,0,sqrt(20995)*I/256,0,sqrt(9690)*I/256,0,sqrt(1938)*I/256,0,sqrt(570)*I/512,0,sqrt(10)*I/512,0]",
        ),
        "Qh(10,T,3,1)": (
            "sqrt(41990)*C1/256-sqrt(4845)*C3/128+sqrt(969)*C5/128-sqrt(285)*C7/256+sqrt(5)*C9/256",
            "sqrt(92378)*x*z*(x**4-10*x**2*z**2+5*z**4)*(5*x**4-10*x**2*z**2+z**4)/256",
            "[0,-sqrt(10)/512,0,sqrt(570)/512,0,-sqrt(1938)/256,0,sqrt(9690)/256,0,-sqrt(20995)/256,0,sqrt(20995)/256,0,-sqrt(9690)/256,0,sqrt(1938)/256,0,-sqrt(570)/512,0,sqrt(10)/512,0]",
        ),
        "Qh(10,T,3,2)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(10,T,4,0)": (
            "9*sqrt(78)*S1/256-69*S3/128-sqrt(5)*S5/128+43*sqrt(17)*S7/256+3*sqrt(969)*S9/256",
            "sqrt(4290)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(224*x**4-96*x**2*y**2-96*x**2*z**2+3*y**4+6*y**2*z**2+3*z**4)/256",
            "[0,3*sqrt(1938)*I/512,0,43*sqrt(34)*I/512,0,-sqrt(10)*I/256,0,-69*sqrt(2)*I/256,0,9*sqrt(39)*I/256,0,9*sqrt(39)*I/256,0,-69*sqrt(2)*I/256,0,-sqrt(10)*I/256,0,43*sqrt(34)*I/512,0,3*sqrt(1938)*I/512,0]",
        ),
        "Qh(10,T,4,1)": (
            "9*sqrt(78)*C1/256+69*C3/128-sqrt(5)*C5/128-43*sqrt(17)*C7/256+3*sqrt(969)*C9/256",
            "sqrt(4290)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(3*x**4-96*x**2*y**2+6*x**2*z**2+224*y**4-96*y**2*z**2+3*z**4)/256",
            "[0,-3*sqrt(1938)/512,0,43*sqrt(34)/512,0,sqrt(10)/256,0,-69*sqrt(2)/256,0,-9*sqrt(39)/256,0,9*sqrt(39)/256,0,69*sqrt(2)/256,0,-sqrt(10)/256,0,-43*sqrt(34)/512,0,3*sqrt(1938)/512,0]",
        ),
        "Qh(10,T,4,2)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,T,5,0)": (
            "7*sqrt(3)*S1/128-7*sqrt(26)*S3/128+5*sqrt(130)*S5/128-7*sqrt(442)*S7/256+sqrt(25194)*S9/256",
            "sqrt(165)*y*z*(384*x**8-1792*x**6*y**2-1792*x**6*z**2+1680*x**4*y**4+3360*x**4*y**2*z**2+1680*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+7*y**8+28*y**6*z**2+42*y**4*z**4+28*y**2*z**6+7*z**8)/128",
            "[0,sqrt(12597)*I/256,0,-7*sqrt(221)*I/256,0,5*sqrt(65)*I/128,0,-7*sqrt(13)*I/128,0,7*sqrt(6)*I/256,0,7*sqrt(6)*I/256,0,-7*sqrt(13)*I/128,0,5*sqrt(65)*I/128,0,-7*sqrt(221)*I/256,0,sqrt(12597)*I/256,0]",
        ),
        "Qh(10,T,5,1)": (
            "7*sqrt(3)*C1/128+7*sqrt(26)*C3/128+5*sqrt(130)*C5/128+7*sqrt(442)*C7/256+sqrt(25194)*C9/256",
            "sqrt(165)*x*z*(7*x**8-336*x**6*y**2+28*x**6*z**2+1680*x**4*y**4-1008*x**4*y**2*z**2+42*x**4*z**4-1792*x**2*y**6+3360*x**2*y**4*z**2-1008*x**2*y**2*z**4+28*x**2*z**6+384*y**8-1792*y**6*z**2+1680*y**4*z**4-336*y**2*z**6+7*z**8)/128",
            "[0,-sqrt(12597)/256,0,-7*sqrt(221)/256,0,-5*sqrt(65)/128,0,-7*sqrt(13)/128,0,-7*sqrt(6)/256,0,7*sqrt(6)/256,0,7*sqrt(13)/128,0,5*sqrt(65)/128,0,7*sqrt(221)/256,0,sqrt(12597)/256,0]",
        ),
        "Qh(10,T,5,2)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A,,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Qh(11,E,1,0)": (
            "S8",
            "sqrt(692835)*x*y*z*(-x**8+6*x**6*y**2+6*x**6*z**2-42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2+y**8-6*y**6*z**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(11,E,1,1)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "sqrt(230945)*x*y*z*(-x**8+6*x**6*y**2+6*x**6*z**2-42*x**4*y**2*z**2+6*x**2*y**6-42*x**2*y**4*z**2+84*x**2*y**2*z**4-12*x**2*z**6-y**8+6*y**6*z**2-12*y**2*z**6+2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Qh(11,E,2,0)": (
            "S4",
            "3*sqrt(1001)*x*y*z*(-5*x**8-10*x**6*y**2+70*x**6*z**2+70*x**4*y**2*z**2-168*x**4*z**4+10*x**2*y**6-70*x**2*y**4*z**2+80*x**2*z**6+5*y**8-70*y**6*z**2+168*y**4*z**4-80*y**2*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,2,1)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "sqrt(3003)*x*y*z*(-5*x**8+150*x**6*y**2-90*x**6*z**2-336*x**4*y**4+70*x**4*y**2*z**2+168*x**4*z**4+150*x**2*y**6+70*x**2*y**4*z**2-140*x**2*y**2*z**4-60*x**2*z**6-5*y**8-90*y**6*z**2+168*y**4*z**4-60*y**2*z**6+10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Qh(11,T,1,0)": (
            "-21*sqrt(66)*C1/512+sqrt(88179)*C11/512+sqrt(30030)*C3/512-15*sqrt(143)*C5/512+sqrt(36465)*C7/512-sqrt(46189)*C9/512",
            "x*(256*x**10-7040*x**8*y**2-7040*x**8*z**2+31680*x**6*y**4+63360*x**6*y**2*z**2+31680*x**6*z**4-36960*x**4*y**6-110880*x**4*y**4*z**2-110880*x**4*y**2*z**4-36960*x**4*z**6+11550*x**2*y**8+46200*x**2*y**6*z**2+69300*x**2*y**4*z**4+46200*x**2*y**2*z**6+11550*x**2*z**8-693*y**10-3465*y**8*z**2-6930*y**6*z**4-6930*y**4*z**6-3465*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)/1024,0,sqrt(92378)/1024,0,-sqrt(72930)/1024,0,15*sqrt(286)/1024,0,-sqrt(15015)/512,0,21*sqrt(33)/512,0,-21*sqrt(33)/512,0,sqrt(15015)/512,0,-15*sqrt(286)/1024,0,sqrt(72930)/1024,0,-sqrt(92378)/1024,0,sqrt(176358)/1024]",
        ),
        "Qh(11,T,1,1)": (
            "-21*sqrt(66)*S1/512-sqrt(88179)*S11/512-sqrt(30030)*S3/512-15*sqrt(143)*S5/512-sqrt(36465)*S7/512-sqrt(46189)*S9/512",
            "-y*(693*x**10-11550*x**8*y**2+3465*x**8*z**2+36960*x**6*y**4-46200*x**6*y**2*z**2+6930*x**6*z**4-31680*x**4*y**6+110880*x**4*y**4*z**2-69300*x**4*y**2*z**4+6930*x**4*z**6+7040*x**2*y**8-63360*x**2*y**6*z**2+110880*x**2*y**4*z**4-46200*x**2*y**2*z**6+3465*x**2*z**8-256*y**10+7040*y**8*z**2-31680*y**6*z**4+36960*y**4*z**6-11550*y**2*z**8+693*z**10)/256",
            "[-sqrt(176358)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(72930)*I/1024,0,-15*sqrt(286)*I/1024,0,-sqrt(15015)*I/512,0,-21*sqrt(33)*I/512,0,-21*sqrt(33)*I/512,0,-sqrt(15015)*I/512,0,-15*sqrt(286)*I/1024,0,-sqrt(72930)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(176358)*I/1024]",
        ),
        "Qh(11,T,1,2)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,T,2,0)": (
            "-sqrt(41990)*C1/512+sqrt(385)*C11/512-3*sqrt(4522)*C3/512+3*sqrt(4845)*C5/512+77*sqrt(19)*C7/512+39*sqrt(15)*C9/512",
            "sqrt(692835)*x*(6*x**2-y**2-z**2)*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/256",
            "[-sqrt(770)/1024,0,-39*sqrt(30)/1024,0,-77*sqrt(38)/1024,0,-3*sqrt(9690)/1024,0,3*sqrt(2261)/512,0,sqrt(20995)/512,0,-sqrt(20995)/512,0,-3*sqrt(2261)/512,0,3*sqrt(9690)/1024,0,77*sqrt(38)/1024,0,39*sqrt(30)/1024,0,sqrt(770)/1024]",
        ),
        "Qh(11,T,2,1)": (
            "-sqrt(41990)*S1/512-sqrt(385)*S11/512+3*sqrt(4522)*S3/512+3*sqrt(4845)*S5/512-77*sqrt(19)*S7/512+39*sqrt(15)*S9/512",
            "-sqrt(692835)*y*(x**2-6*y**2+z**2)*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/256",
            "[-sqrt(770)*I/1024,0,39*sqrt(30)*I/1024,0,-77*sqrt(38)*I/1024,0,3*sqrt(9690)*I/1024,0,3*sqrt(2261)*I/512,0,-sqrt(20995)*I/512,0,-sqrt(20995)*I/512,0,3*sqrt(2261)*I/512,0,3*sqrt(9690)*I/1024,0,-77*sqrt(38)*I/1024,0,39*sqrt(30)*I/1024,0,-sqrt(770)*I/1024]",
        ),
        "Qh(11,T,2,2)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(11,T,3,0)": (
            "-5*sqrt(546)*C1/256+sqrt(10659)*C11/256+11*sqrt(30)*C3/256+13*sqrt(7)*C5/256-3*sqrt(1785)*C7/256+3*sqrt(2261)*C9/256",
            "3*sqrt(1001)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(80*x**6-168*x**4*y**2-168*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-5*y**6-15*y**4*z**2-15*y**2*z**4-5*z**6)/128",
            "[-sqrt(21318)/512,0,-3*sqrt(4522)/512,0,3*sqrt(3570)/512,0,-13*sqrt(14)/512,0,-11*sqrt(15)/256,0,5*sqrt(273)/256,0,-5*sqrt(273)/256,0,11*sqrt(15)/256,0,13*sqrt(14)/512,0,-3*sqrt(3570)/512,0,3*sqrt(4522)/512,0,sqrt(21318)/512]",
        ),
        "Qh(11,T,3,1)": (
            "-5*sqrt(546)*S1/256-sqrt(10659)*S11/256-11*sqrt(30)*S3/256+13*sqrt(7)*S5/256+3*sqrt(1785)*S7/256+3*sqrt(2261)*S9/256",
            "-3*sqrt(1001)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(5*x**6-70*x**4*y**2+15*x**4*z**2+168*x**2*y**4-140*x**2*y**2*z**2+15*x**2*z**4-80*y**6+168*y**4*z**2-70*y**2*z**4+5*z**6)/128",
            "[-sqrt(21318)*I/512,0,3*sqrt(4522)*I/512,0,3*sqrt(3570)*I/512,0,13*sqrt(14)*I/512,0,-11*sqrt(15)*I/256,0,-5*sqrt(273)*I/256,0,-5*sqrt(273)*I/256,0,-11*sqrt(15)*I/256,0,13*sqrt(14)*I/512,0,3*sqrt(3570)*I/512,0,3*sqrt(4522)*I/512,0,-sqrt(21318)*I/512]",
        ),
        "Qh(11,T,3,2)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,T,4,0)": (
            "-sqrt(29393)*C1/512-sqrt(22)*C11/1024-9*sqrt(1615)*C3/512-5*sqrt(13566)*C5/1024-7*sqrt(1330)*C7/1024-9*sqrt(42)*C9/1024",
            "sqrt(1939938)*x*(y-z)*(y+z)*(y**4-4*y**3*z-14*y**2*z**2-4*y*z**3+z**4)*(y**4+4*y**3*z-14*y**2*z**2+4*y*z**3+z**4)/512",
            "[sqrt(11)/1024,0,9*sqrt(21)/1024,0,7*sqrt(665)/1024,0,5*sqrt(6783)/1024,0,9*sqrt(3230)/1024,0,sqrt(58786)/1024,0,-sqrt(58786)/1024,0,-9*sqrt(3230)/1024,0,-5*sqrt(6783)/1024,0,-7*sqrt(665)/1024,0,-9*sqrt(21)/1024,0,-sqrt(11)/1024]",
        ),
        "Qh(11,T,4,1)": (
            "sqrt(29393)*S1/512-sqrt(22)*S11/1024-9*sqrt(1615)*S3/512+5*sqrt(13566)*S5/1024-7*sqrt(1330)*S7/1024+9*sqrt(42)*S9/1024",
            "-sqrt(1939938)*y*(x-z)*(x+z)*(x**4-4*x**3*z-14*x**2*z**2-4*x*z**3+z**4)*(x**4+4*x**3*z-14*x**2*z**2+4*x*z**3+z**4)/512",
            "[-sqrt(11)*I/1024,0,9*sqrt(21)*I/1024,0,-7*sqrt(665)*I/1024,0,5*sqrt(6783)*I/1024,0,-9*sqrt(3230)*I/1024,0,sqrt(58786)*I/1024,0,sqrt(58786)*I/1024,0,-9*sqrt(3230)*I/1024,0,5*sqrt(6783)*I/1024,0,-7*sqrt(665)*I/1024,0,9*sqrt(21)*I/1024,0,-sqrt(11)*I/1024]",
        ),
        "Qh(11,T,4,2)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(11,T,5,0)": (
            "-15*sqrt(221)*C1/512-3*sqrt(2926)*C11/1024-sqrt(595)*C3/512+53*sqrt(102)*C5/1024-105*sqrt(10)*C7/1024-61*sqrt(114)*C9/1024",
            "sqrt(14586)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)*(224*x**4-160*x**2*y**2-160*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/512",
            "[3*sqrt(1463)/1024,0,61*sqrt(57)/1024,0,105*sqrt(5)/1024,0,-53*sqrt(51)/1024,0,sqrt(1190)/1024,0,15*sqrt(442)/1024,0,-15*sqrt(442)/1024,0,-sqrt(1190)/1024,0,53*sqrt(51)/1024,0,-105*sqrt(5)/1024,0,-61*sqrt(57)/1024,0,-3*sqrt(1463)/1024]",
        ),
        "Qh(11,T,5,1)": (
            "15*sqrt(221)*S1/512-3*sqrt(2926)*S11/1024-sqrt(595)*S3/512-53*sqrt(102)*S5/1024-105*sqrt(10)*S7/1024+61*sqrt(114)*S9/1024",
            "-sqrt(14586)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(15*x**4-160*x**2*y**2+30*x**2*z**2+224*y**4-160*y**2*z**2+15*z**4)/512",
            "[-3*sqrt(1463)*I/1024,0,61*sqrt(57)*I/1024,0,-105*sqrt(5)*I/1024,0,-53*sqrt(51)*I/1024,0,-sqrt(1190)*I/1024,0,15*sqrt(442)*I/1024,0,15*sqrt(442)*I/1024,0,-sqrt(1190)*I/1024,0,-53*sqrt(51)*I/1024,0,-105*sqrt(5)*I/1024,0,61*sqrt(57)*I/1024,0,-3*sqrt(1463)*I/1024]",
        ),
        "Qh(11,T,5,2)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,T,6,0)": (
            "-21*sqrt(130)*C1/512-sqrt(124355)*C11/512+57*sqrt(14)*C3/512-41*sqrt(15)*C5/512+17*sqrt(17)*C7/512+sqrt(4845)*C9/512",
            "sqrt(2145)*x*(y-z)*(y+z)*(128*x**8-768*x**6*y**2-768*x**6*z**2+1008*x**4*y**4+2016*x**4*y**2*z**2+1008*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+21*y**8+84*y**6*z**2+126*y**4*z**4+84*y**2*z**6+21*z**8)/256",
            "[sqrt(248710)/1024,0,-sqrt(9690)/1024,0,-17*sqrt(34)/1024,0,41*sqrt(30)/1024,0,-57*sqrt(7)/512,0,21*sqrt(65)/512,0,-21*sqrt(65)/512,0,57*sqrt(7)/512,0,-41*sqrt(30)/1024,0,17*sqrt(34)/1024,0,sqrt(9690)/1024,0,-sqrt(248710)/1024]",
        ),
        "Qh(11,T,6,1)": (
            "21*sqrt(130)*S1/512-sqrt(124355)*S11/512+57*sqrt(14)*S3/512+41*sqrt(15)*S5/512+17*sqrt(17)*S7/512-sqrt(4845)*S9/512",
            "-sqrt(2145)*y*(x-z)*(x+z)*(21*x**8-336*x**6*y**2+84*x**6*z**2+1008*x**4*y**4-1008*x**4*y**2*z**2+126*x**4*z**4-768*x**2*y**6+2016*x**2*y**4*z**2-1008*x**2*y**2*z**4+84*x**2*z**6+128*y**8-768*y**6*z**2+1008*y**4*z**4-336*y**2*z**6+21*z**8)/256",
            "[-sqrt(248710)*I/1024,0,-sqrt(9690)*I/1024,0,17*sqrt(34)*I/1024,0,41*sqrt(30)*I/1024,0,57*sqrt(7)*I/512,0,21*sqrt(65)*I/512,0,21*sqrt(65)*I/512,0,57*sqrt(7)*I/512,0,41*sqrt(30)*I/1024,0,17*sqrt(34)*I/1024,0,-sqrt(9690)*I/1024,0,-sqrt(248710)*I/1024]",
        ),
        "Qh(11,T,6,2)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
    },
    "Th": {
        "Qh(0,Ag,,)": ("C0", "1", "[1]"),
        "Qh(1,Tu,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(1,Tu,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(1,Tu,,2)": ("C0", "z", "[0,1,0]"),
        "Qh(2,Eg,,0)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(2,Eg,,1)": ("C2", "sqrt(3)*(x**2-y**2)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(2,Tg,,0)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(2,Tg,,1)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Qh(2,Tg,,2)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Qh(3,Au,,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(3,Tu,1,0)": (
            "-sqrt(6)*C1/4+sqrt(10)*C3/4",
            "x*(2*x**2-3*y**2-3*z**2)/2",
            "[-sqrt(5)/4,0,sqrt(3)/4,0,-sqrt(3)/4,0,sqrt(5)/4]",
        ),
        "Qh(3,Tu,1,1)": (
            "-sqrt(6)*S1/4-sqrt(10)*S3/4",
            "-y*(3*x**2-2*y**2+3*z**2)/2",
            "[-sqrt(5)*I/4,0,-sqrt(3)*I/4,0,-sqrt(3)*I/4,0,-sqrt(5)*I/4]",
        ),
        "Qh(3,Tu,1,2)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(3,Tu,2,0)": (
            "-sqrt(10)*C1/4-sqrt(6)*C3/4",
            "sqrt(15)*x*(y-z)*(y+z)/2",
            "[sqrt(3)/4,0,sqrt(5)/4,0,-sqrt(5)/4,0,-sqrt(3)/4]",
        ),
        "Qh(3,Tu,2,1)": (
            "sqrt(10)*S1/4-sqrt(6)*S3/4",
            "-sqrt(15)*y*(x-z)*(x+z)/2",
            "[-sqrt(3)*I/4,0,sqrt(5)*I/4,0,sqrt(5)*I/4,0,-sqrt(3)*I/4]",
        ),
        "Qh(3,Tu,2,2)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(4,Ag,,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Qh(4,Eg,,0)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "sqrt(15)*(-x**4+12*x**2*y**2-6*x**2*z**2-y**4-6*y**2*z**2+2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Qh(4,Eg,,1)": ("-C2", "sqrt(5)*(x**4-6*x**2*z**2-y**4+6*y**2*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Qh(4,Tg,1,0)": (
            "-sqrt(14)*S1/4-sqrt(2)*S3/4",
            "sqrt(35)*y*z*(y-z)*(y+z)/2",
            "[0,-I/4,0,-sqrt(7)*I/4,0,-sqrt(7)*I/4,0,-I/4,0]",
        ),
        "Qh(4,Tg,1,1)": (
            "sqrt(14)*C1/4-sqrt(2)*C3/4",
            "-sqrt(35)*x*z*(x-z)*(x+z)/2",
            "[0,1/4,0,-sqrt(7)/4,0,sqrt(7)/4,0,-1/4,0]",
        ),
        "Qh(4,Tg,1,2)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(4,Tg,2,0)": (
            "-sqrt(2)*S1/4+sqrt(14)*S3/4",
            "sqrt(5)*y*z*(6*x**2-y**2-z**2)/2",
            "[0,sqrt(7)*I/4,0,-I/4,0,-I/4,0,sqrt(7)*I/4,0]",
        ),
        "Qh(4,Tg,2,1)": (
            "-sqrt(2)*C1/4-sqrt(14)*C3/4",
            "-sqrt(5)*x*z*(x**2-6*y**2+z**2)/2",
            "[0,sqrt(7)/4,0,1/4,0,-1/4,0,-sqrt(7)/4,0]",
        ),
        "Qh(4,Tg,2,2)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(5,Eu,,0)": ("S4", "3*sqrt(35)*x*y*z*(x**2-y**2)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(5,Eu,,1)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(5,Tu,1,0)": (
            "sqrt(15)*C1/8-sqrt(70)*C3/16+3*sqrt(14)*C5/16",
            "x*(8*x**4-40*x**2*y**2-40*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/8",
            "[-3*sqrt(7)/16,0,sqrt(35)/16,0,-sqrt(30)/16,0,sqrt(30)/16,0,-sqrt(35)/16,0,3*sqrt(7)/16]",
        ),
        "Qh(5,Tu,1,1)": (
            "sqrt(15)*S1/8+sqrt(70)*S3/16+3*sqrt(14)*S5/16",
            "y*(15*x**4-40*x**2*y**2+30*x**2*z**2+8*y**4-40*y**2*z**2+15*z**4)/8",
            "[3*sqrt(7)*I/16,0,sqrt(35)*I/16,0,sqrt(30)*I/16,0,sqrt(30)*I/16,0,sqrt(35)*I/16,0,3*sqrt(7)*I/16]",
        ),
        "Qh(5,Tu,1,2)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(5,Tu,2,0)": (
            "sqrt(21)*C1/8+9*sqrt(2)*C3/16+sqrt(10)*C5/16",
            "3*sqrt(35)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/8",
            "[-sqrt(5)/16,0,-9/16,0,-sqrt(42)/16,0,sqrt(42)/16,0,9/16,0,sqrt(5)/16]",
        ),
        "Qh(5,Tu,2,1)": (
            "sqrt(21)*S1/8-9*sqrt(2)*S3/16+sqrt(10)*S5/16",
            "3*sqrt(35)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/8",
            "[sqrt(5)*I/16,0,-9*I/16,0,sqrt(42)*I/16,0,sqrt(42)*I/16,0,-9*I/16,0,sqrt(5)*I/16]",
        ),
        "Qh(5,Tu,2,2)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(5,Tu,3,0)": (
            "sqrt(7)*C1/4-sqrt(6)*C3/8-sqrt(30)*C5/8",
            "sqrt(105)*x*(y-z)*(y+z)*(2*x**2-y**2-z**2)/4",
            "[sqrt(15)/8,0,sqrt(3)/8,0,-sqrt(14)/8,0,sqrt(14)/8,0,-sqrt(3)/8,0,-sqrt(15)/8]",
        ),
        "Qh(5,Tu,3,1)": (
            "-sqrt(7)*S1/4-sqrt(6)*S3/8+sqrt(30)*S5/8",
            "sqrt(105)*y*(x-z)*(x+z)*(x**2-2*y**2+z**2)/4",
            "[sqrt(15)*I/8,0,-sqrt(3)*I/8,0,-sqrt(14)*I/8,0,-sqrt(14)*I/8,0,-sqrt(3)*I/8,0,sqrt(15)*I/8]",
        ),
        "Qh(5,Tu,3,2)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(6,Ag,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Qh(6,Ag,2,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Qh(6,Eg,,0)": (
            "sqrt(2)*(sqrt(7)*C0+C4)/4",
            "sqrt(14)*(-x**6+15*x**4*z**2-15*x**2*z**4-y**6+15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Qh(6,Eg,,1)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x**6-10*x**4*y**2-5*x**4*z**2+10*x**2*y**4+5*x**2*z**4-y**6+5*y**4*z**2-5*y**2*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Qh(6,Tg,1,0)": (
            "sqrt(3)*S1/4-sqrt(30)*S3/8-sqrt(22)*S5/8",
            "3*sqrt(7)*y*z*(y-z)*(y+z)*(10*x**2-y**2-z**2)/4",
            "[0,-sqrt(11)*I/8,0,-sqrt(15)*I/8,0,sqrt(6)*I/8,0,sqrt(6)*I/8,0,-sqrt(15)*I/8,0,-sqrt(11)*I/8,0]",
        ),
        "Qh(6,Tg,1,1)": (
            "-sqrt(3)*C1/4-sqrt(30)*C3/8+sqrt(22)*C5/8",
            "3*sqrt(7)*x*z*(x-z)*(x+z)*(x**2-10*y**2+z**2)/4",
            "[0,-sqrt(11)/8,0,sqrt(15)/8,0,sqrt(6)/8,0,-sqrt(6)/8,0,-sqrt(15)/8,0,sqrt(11)/8,0]",
        ),
        "Qh(6,Tg,1,2)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(6,Tg,2,0)": (
            "3*sqrt(22)*S1/16+sqrt(55)*S3/16+sqrt(3)*S5/16",
            "sqrt(462)*y*z*(y**2-3*z**2)*(3*y**2-z**2)/16",
            "[0,sqrt(6)*I/32,0,sqrt(110)*I/32,0,3*sqrt(11)*I/16,0,3*sqrt(11)*I/16,0,sqrt(110)*I/32,0,sqrt(6)*I/32,0]",
        ),
        "Qh(6,Tg,2,1)": (
            "3*sqrt(22)*C1/16-sqrt(55)*C3/16+sqrt(3)*C5/16",
            "sqrt(462)*x*z*(x**2-3*z**2)*(3*x**2-z**2)/16",
            "[0,-sqrt(6)/32,0,sqrt(110)/32,0,-3*sqrt(11)/16,0,3*sqrt(11)/16,0,-sqrt(110)/32,0,sqrt(6)/32,0]",
        ),
        "Qh(6,Tg,2,2)": (
            "S6",
            "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(6,Tg,3,0)": (
            "sqrt(10)*S1/16-9*S3/16+sqrt(165)*S5/16",
            "sqrt(210)*y*z*(16*x**4-16*x**2*y**2-16*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,sqrt(330)*I/32,0,-9*sqrt(2)*I/32,0,sqrt(5)*I/16,0,sqrt(5)*I/16,0,-9*sqrt(2)*I/32,0,sqrt(330)*I/32,0]",
        ),
        "Qh(6,Tg,3,1)": (
            "sqrt(10)*C1/16+9*C3/16+sqrt(165)*C5/16",
            "sqrt(210)*x*z*(x**4-16*x**2*y**2+2*x**2*z**2+16*y**4-16*y**2*z**2+z**4)/16",
            "[0,-sqrt(330)/32,0,-9*sqrt(2)/32,0,-sqrt(5)/16,0,sqrt(5)/16,0,9*sqrt(2)/32,0,sqrt(330)/32,0]",
        ),
        "Qh(6,Tg,3,2)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(7,Au,,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Qh(7,Eu,,0)": (
            "S4",
            "sqrt(231)*x*y*z*(-3*x**4+10*x**2*z**2+3*y**4-10*y**2*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(7,Eu,,1)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "sqrt(77)*x*y*z*(-3*x**4+20*x**2*y**2-10*x**2*z**2-3*y**4-10*y**2*z**2+6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Qh(7,Tu,1,0)": (
            "-5*sqrt(7)*C1/32+3*sqrt(21)*C3/32-sqrt(231)*C5/32+sqrt(429)*C7/32",
            "x*(16*x**6-168*x**4*y**2-168*x**4*z**2+210*x**2*y**4+420*x**2*y**2*z**2+210*x**2*z**4-35*y**6-105*y**4*z**2-105*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)/64,0,sqrt(462)/64,0,-3*sqrt(42)/64,0,5*sqrt(14)/64,0,-5*sqrt(14)/64,0,3*sqrt(42)/64,0,-sqrt(462)/64,0,sqrt(858)/64]",
        ),
        "Qh(7,Tu,1,1)": (
            "-5*sqrt(7)*S1/32-3*sqrt(21)*S3/32-sqrt(231)*S5/32-sqrt(429)*S7/32",
            "-y*(35*x**6-210*x**4*y**2+105*x**4*z**2+168*x**2*y**4-420*x**2*y**2*z**2+105*x**2*z**4-16*y**6+168*y**4*z**2-210*y**2*z**4+35*z**6)/16",
            "[-sqrt(858)*I/64,0,-sqrt(462)*I/64,0,-3*sqrt(42)*I/64,0,-5*sqrt(14)*I/64,0,-5*sqrt(14)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(462)*I/64,0,-sqrt(858)*I/64]",
        ),
        "Qh(7,Tu,1,2)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(7,Tu,2,0)": (
            "-3*sqrt(33)*C1/32-sqrt(11)*C3/32+25*C5/32+sqrt(91)*C7/32",
            "sqrt(231)*x*(10*x**2-3*y**2-3*z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[-sqrt(182)/64,0,-25*sqrt(2)/64,0,sqrt(22)/64,0,3*sqrt(66)/64,0,-3*sqrt(66)/64,0,-sqrt(22)/64,0,25*sqrt(2)/64,0,sqrt(182)/64]",
        ),
        "Qh(7,Tu,2,1)": (
            "-3*sqrt(33)*S1/32+sqrt(11)*S3/32+25*S5/32-sqrt(91)*S7/32",
            "-sqrt(231)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(3*x**2-10*y**2+3*z**2)/16",
            "[-sqrt(182)*I/64,0,25*sqrt(2)*I/64,0,sqrt(22)*I/64,0,-3*sqrt(66)*I/64,0,-3*sqrt(66)*I/64,0,sqrt(22)*I/64,0,25*sqrt(2)*I/64,0,-sqrt(182)*I/64]",
        ),
        "Qh(7,Tu,2,2)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(7,Tu,3,0)": (
            "-sqrt(858)*C1/64-3*sqrt(286)*C3/64-5*sqrt(26)*C5/64-sqrt(14)*C7/64",
            "sqrt(6006)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/32",
            "[sqrt(7)/64,0,5*sqrt(13)/64,0,3*sqrt(143)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-3*sqrt(143)/64,0,-5*sqrt(13)/64,0,-sqrt(7)/64]",
        ),
        "Qh(7,Tu,3,1)": (
            "sqrt(858)*S1/64-3*sqrt(286)*S3/64+5*sqrt(26)*S5/64-sqrt(14)*S7/64",
            "-sqrt(6006)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)/32",
            "[-sqrt(7)*I/64,0,5*sqrt(13)*I/64,0,-3*sqrt(143)*I/64,0,sqrt(429)*I/64,0,sqrt(429)*I/64,0,-3*sqrt(143)*I/64,0,5*sqrt(13)*I/64,0,-sqrt(7)*I/64]",
        ),
        "Qh(7,Tu,3,2)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(7,Tu,4,0)": (
            "-15*sqrt(6)*C1/64+19*sqrt(2)*C3/64-sqrt(22)*C5/64-sqrt(2002)*C7/64",
            "sqrt(42)*x*(y-z)*(y+z)*(48*x**4-80*x**2*y**2-80*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/32",
            "[sqrt(1001)/64,0,sqrt(11)/64,0,-19/64,0,15*sqrt(3)/64,0,-15*sqrt(3)/64,0,19/64,0,-sqrt(11)/64,0,-sqrt(1001)/64]",
        ),
        "Qh(7,Tu,4,1)": (
            "15*sqrt(6)*S1/64+19*sqrt(2)*S3/64+sqrt(22)*S5/64-sqrt(2002)*S7/64",
            "-sqrt(42)*y*(x-z)*(x+z)*(15*x**4-80*x**2*y**2+30*x**2*z**2+48*y**4-80*y**2*z**2+15*z**4)/32",
            "[-sqrt(1001)*I/64,0,sqrt(11)*I/64,0,19*I/64,0,15*sqrt(3)*I/64,0,15*sqrt(3)*I/64,0,19*I/64,0,sqrt(11)*I/64,0,-sqrt(1001)*I/64]",
        ),
        "Qh(7,Tu,4,2)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(8,Ag,,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Qh(8,Eg,1,0)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Qh(8,Eg,1,1)": (
            "C6",
            "sqrt(858)*(-x**8+14*x**6*y**2+14*x**6*z**2-210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2+y**8-14*y**6*z**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(8,Eg,2,0)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Qh(8,Eg,2,1)": (
            "C2",
            "3*sqrt(70)*(-x**8-2*x**6*y**2+30*x**6*z**2+30*x**4*y**2*z**2-80*x**4*z**4+2*x**2*y**6-30*x**2*y**4*z**2+32*x**2*z**6+y**8-30*y**6*z**2+80*y**4*z**4-32*y**2*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(8,Tg,1,0)": (
            "-sqrt(715)*S1/32-sqrt(273)*S3/32-sqrt(35)*S5/32-S7/32",
            "3*sqrt(715)*y*z*(y-z)*(y+z)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[0,-sqrt(2)*I/64,0,-sqrt(70)*I/64,0,-sqrt(546)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(546)*I/64,0,-sqrt(70)*I/64,0,-sqrt(2)*I/64,0]",
        ),
        "Qh(8,Tg,1,1)": (
            "sqrt(715)*C1/32-sqrt(273)*C3/32+sqrt(35)*C5/32-C7/32",
            "-3*sqrt(715)*x*z*(x-z)*(x+z)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/16",
            "[0,sqrt(2)/64,0,-sqrt(70)/64,0,sqrt(546)/64,0,-sqrt(1430)/64,0,sqrt(1430)/64,0,-sqrt(546)/64,0,sqrt(70)/64,0,-sqrt(2)/64,0]",
        ),
        "Qh(8,Tg,1,2)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(8,Tg,2,0)": (
            "-sqrt(77)*S1/32+5*sqrt(15)*S3/32-3*sqrt(13)*S5/32-sqrt(455)*S7/32",
            "3*sqrt(77)*y*z*(y-z)*(y+z)*(40*x**4-24*x**2*y**2-24*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,-sqrt(910)*I/64,0,-3*sqrt(26)*I/64,0,5*sqrt(30)*I/64,0,-sqrt(154)*I/64,0,-sqrt(154)*I/64,0,5*sqrt(30)*I/64,0,-3*sqrt(26)*I/64,0,-sqrt(910)*I/64,0]",
        ),
        "Qh(8,Tg,2,1)": (
            "sqrt(77)*C1/32+5*sqrt(15)*C3/32+3*sqrt(13)*C5/32-sqrt(455)*C7/32",
            "-3*sqrt(77)*x*z*(x-z)*(x+z)*(x**4-24*x**2*y**2+2*x**2*z**2+40*y**4-24*y**2*z**2+z**4)/16",
            "[0,sqrt(910)/64,0,-3*sqrt(26)/64,0,-5*sqrt(30)/64,0,-sqrt(154)/64,0,sqrt(154)/64,0,5*sqrt(30)/64,0,3*sqrt(26)/64,0,-sqrt(910)/64,0]",
        ),
        "Qh(8,Tg,2,2)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(8,Tg,3,0)": (
            "-sqrt(858)*S1/64+sqrt(910)*S3/64+7*sqrt(42)*S5/64+3*sqrt(30)*S7/64",
            "sqrt(858)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(14*x**2-y**2-z**2)/32",
            "[0,3*sqrt(15)*I/64,0,7*sqrt(21)*I/64,0,sqrt(455)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(455)*I/64,0,7*sqrt(21)*I/64,0,3*sqrt(15)*I/64,0]",
        ),
        "Qh(8,Tg,3,1)": (
            "-sqrt(858)*C1/64-sqrt(910)*C3/64+7*sqrt(42)*C5/64-3*sqrt(30)*C7/64",
            "-sqrt(858)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(x**2-14*y**2+z**2)/32",
            "[0,3*sqrt(15)/64,0,-7*sqrt(21)/64,0,sqrt(455)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-sqrt(455)/64,0,7*sqrt(21)/64,0,-3*sqrt(15)/64,0]",
        ),
        "Qh(8,Tg,3,2)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(8,Tg,4,0)": (
            "-sqrt(70)*S1/64+3*sqrt(66)*S3/64-sqrt(1430)*S5/64+sqrt(2002)*S7/64",
            "3*sqrt(70)*y*z*(32*x**6-80*x**4*y**2-80*x**4*z**2+30*x**2*y**4+60*x**2*y**2*z**2+30*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,sqrt(1001)*I/64,0,-sqrt(715)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(35)*I/64,0,-sqrt(35)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(715)*I/64,0,sqrt(1001)*I/64,0]",
        ),
        "Qh(8,Tg,4,1)": (
            "-sqrt(70)*C1/64-3*sqrt(66)*C3/64-sqrt(1430)*C5/64-sqrt(2002)*C7/64",
            "-3*sqrt(70)*x*z*(x**6-30*x**4*y**2+3*x**4*z**2+80*x**2*y**4-60*x**2*y**2*z**2+3*x**2*z**4-32*y**6+80*y**4*z**2-30*y**2*z**4+z**6)/32",
            "[0,sqrt(1001)/64,0,sqrt(715)/64,0,3*sqrt(33)/64,0,sqrt(35)/64,0,-sqrt(35)/64,0,-3*sqrt(33)/64,0,-sqrt(715)/64,0,-sqrt(1001)/64,0]",
        ),
        "Qh(8,Tg,4,2)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,Au,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Qh(9,Au,2,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Qh(9,Eu,,0)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(3*x**6-14*x**4*y**2-7*x**4*z**2+14*x**2*y**4+7*x**2*z**4-3*y**6+7*y**4*z**2-7*y**2*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Qh(9,Eu,,1)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Qh(9,Tu,1,0)": (
            "21*sqrt(5)*C1/128-sqrt(2310)*C3/128+3*sqrt(286)*C5/128-3*sqrt(1430)*C7/256+sqrt(24310)*C9/256",
            "x*(128*x**8-2304*x**6*y**2-2304*x**6*z**2+6048*x**4*y**4+12096*x**4*y**2*z**2+6048*x**4*z**4-3360*x**2*y**6-10080*x**2*y**4*z**2-10080*x**2*y**2*z**4-3360*x**2*z**6+315*y**8+1260*y**6*z**2+1890*y**4*z**4+1260*y**2*z**6+315*z**8)/128",
            "[-sqrt(12155)/256,0,3*sqrt(715)/256,0,-3*sqrt(143)/128,0,sqrt(1155)/128,0,-21*sqrt(10)/256,0,21*sqrt(10)/256,0,-sqrt(1155)/128,0,3*sqrt(143)/128,0,-3*sqrt(715)/256,0,sqrt(12155)/256]",
        ),
        "Qh(9,Tu,1,1)": (
            "21*sqrt(5)*S1/128+sqrt(2310)*S3/128+3*sqrt(286)*S5/128+3*sqrt(1430)*S7/256+sqrt(24310)*S9/256",
            "y*(315*x**8-3360*x**6*y**2+1260*x**6*z**2+6048*x**4*y**4-10080*x**4*y**2*z**2+1890*x**4*z**4-2304*x**2*y**6+12096*x**2*y**4*z**2-10080*x**2*y**2*z**4+1260*x**2*z**6+128*y**8-2304*y**6*z**2+6048*y**4*z**4-3360*y**2*z**6+315*z**8)/128",
            "[sqrt(12155)*I/256,0,3*sqrt(715)*I/256,0,3*sqrt(143)*I/128,0,sqrt(1155)*I/128,0,21*sqrt(10)*I/256,0,21*sqrt(10)*I/256,0,sqrt(1155)*I/128,0,3*sqrt(143)*I/128,0,3*sqrt(715)*I/256,0,sqrt(12155)*I/256]",
        ),
        "Qh(9,Tu,1,2)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Tu,2,0)": (
            "sqrt(2431)*C1/128+sqrt(9282)*C3/128+5*sqrt(170)*C5/128+7*sqrt(34)*C7/256+3*sqrt(2)*C9/256",
            "3*sqrt(12155)*x*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/128",
            "[-3/256,0,-7*sqrt(17)/256,0,-5*sqrt(85)/128,0,-sqrt(4641)/128,0,-sqrt(4862)/256,0,sqrt(4862)/256,0,sqrt(4641)/128,0,5*sqrt(85)/128,0,7*sqrt(17)/256,0,3/256]",
        ),
        "Qh(9,Tu,2,1)": (
            "sqrt(2431)*S1/128-sqrt(9282)*S3/128+5*sqrt(170)*S5/128-7*sqrt(34)*S7/256+3*sqrt(2)*S9/256",
            "3*sqrt(12155)*y*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/128",
            "[3*I/256,0,-7*sqrt(17)*I/256,0,5*sqrt(85)*I/128,0,-sqrt(4641)*I/128,0,sqrt(4862)*I/256,0,sqrt(4862)*I/256,0,-sqrt(4641)*I/128,0,5*sqrt(85)*I/128,0,-7*sqrt(17)*I/256,0,3*I/256]",
        ),
        "Qh(9,Tu,2,2)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,Tu,3,0)": (
            "sqrt(1001)*C1/64-sqrt(78)*C3/64-3*sqrt(70)*C5/64+23*sqrt(14)*C7/128+3*sqrt(238)*C9/128",
            "3*sqrt(5005)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(8*x**4-8*x**2*y**2-8*x**2*z**2+y**4+2*y**2*z**2+z**4)/64",
            "[-3*sqrt(119)/128,0,-23*sqrt(7)/128,0,3*sqrt(35)/64,0,sqrt(39)/64,0,-sqrt(2002)/128,0,sqrt(2002)/128,0,-sqrt(39)/64,0,-3*sqrt(35)/64,0,23*sqrt(7)/128,0,3*sqrt(119)/128]",
        ),
        "Qh(9,Tu,3,1)": (
            "sqrt(1001)*S1/64+sqrt(78)*S3/64-3*sqrt(70)*S5/64-23*sqrt(14)*S7/128+3*sqrt(238)*S9/128",
            "3*sqrt(5005)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(x**4-8*x**2*y**2+2*x**2*z**2+8*y**4-8*y**2*z**2+z**4)/64",
            "[3*sqrt(119)*I/128,0,-23*sqrt(7)*I/128,0,-3*sqrt(35)*I/64,0,sqrt(39)*I/64,0,sqrt(2002)*I/128,0,sqrt(2002)*I/128,0,sqrt(39)*I/64,0,-3*sqrt(35)*I/64,0,-23*sqrt(7)*I/128,0,3*sqrt(119)*I/128]",
        ),
        "Qh(9,Tu,3,2)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(9,Tu,4,0)": (
            "sqrt(858)*C1/64+sqrt(91)*C3/32-5*sqrt(15)*C5/32-21*sqrt(3)*C7/64-sqrt(51)*C9/64",
            "sqrt(4290)*x*(y-z)*(y+z)*(14*x**2-3*y**2-3*z**2)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/64",
            "[sqrt(102)/128,0,21*sqrt(6)/128,0,5*sqrt(30)/64,0,-sqrt(182)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(182)/64,0,-5*sqrt(30)/64,0,-21*sqrt(6)/128,0,-sqrt(102)/128]",
        ),
        "Qh(9,Tu,4,1)": (
            "-sqrt(858)*S1/64+sqrt(91)*S3/32+5*sqrt(15)*S5/32-21*sqrt(3)*S7/64+sqrt(51)*S9/64",
            "sqrt(4290)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(3*x**2-14*y**2+3*z**2)/64",
            "[sqrt(102)*I/128,0,-21*sqrt(6)*I/128,0,5*sqrt(30)*I/64,0,sqrt(182)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(182)*I/64,0,5*sqrt(30)*I/64,0,-21*sqrt(6)*I/128,0,sqrt(102)*I/128]",
        ),
        "Qh(9,Tu,4,2)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,Tu,5,0)": (
            "7*sqrt(22)*C1/64-3*sqrt(21)*C3/32+sqrt(65)*C5/32+sqrt(13)*C7/64-3*sqrt(221)*C9/64",
            "3*sqrt(110)*x*(y-z)*(y+z)*(32*x**6-112*x**4*y**2-112*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-7*y**6-21*y**4*z**2-21*y**2*z**4-7*z**6)/64",
            "[3*sqrt(442)/128,0,-sqrt(26)/128,0,-sqrt(130)/64,0,3*sqrt(42)/64,0,-7*sqrt(11)/64,0,7*sqrt(11)/64,0,-3*sqrt(42)/64,0,sqrt(130)/64,0,sqrt(26)/128,0,-3*sqrt(442)/128]",
        ),
        "Qh(9,Tu,5,1)": (
            "-7*sqrt(22)*S1/64-3*sqrt(21)*S3/32-sqrt(65)*S5/32+sqrt(13)*S7/64+3*sqrt(221)*S9/64",
            "3*sqrt(110)*y*(x-z)*(x+z)*(7*x**6-70*x**4*y**2+21*x**4*z**2+112*x**2*y**4-140*x**2*y**2*z**2+21*x**2*z**4-32*y**6+112*y**4*z**2-70*y**2*z**4+7*z**6)/64",
            "[3*sqrt(442)*I/128,0,sqrt(26)*I/128,0,-sqrt(130)*I/64,0,-3*sqrt(42)*I/64,0,-7*sqrt(11)*I/64,0,-7*sqrt(11)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(130)*I/64,0,sqrt(26)*I/128,0,3*sqrt(442)*I/128]",
        ),
        "Qh(9,Tu,5,2)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Ag,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Qh(10,Ag,2,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Qh(10,Eg,1,0)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "sqrt(420189)*(-22*x**10-45*x**8*y**2+1035*x**8*z**2+105*x**6*y**4+630*x**6*y**2*z**2-4935*x**6*z**4+105*x**4*y**6-3150*x**4*y**4*z**2+1575*x**4*y**2*z**4+4830*x**4*z**6-45*x**2*y**8+630*x**2*y**6*z**2+1575*x**2*y**4*z**4-1260*x**2*y**2*z**6-990*x**2*z**8-22*y**10+1035*y**8*z**2-4935*y**6*z**4+4830*y**4*z**6-990*y**2*z**8+44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Qh(10,Eg,1,1)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(22*x**10-675*x**8*y**2-315*x**8*z**2+3255*x**6*y**4-630*x**6*y**2*z**2+1575*x**6*z**4-3255*x**4*y**6+1575*x**4*y**2*z**4-1680*x**4*z**6+675*x**2*y**8+630*x**2*y**6*z**2-1575*x**2*y**4*z**4+360*x**2*z**8-22*y**10+315*y**8*z**2-1575*y**6*z**4+1680*y**4*z**6-360*y**2*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Qh(10,Eg,2,0)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "sqrt(3213210)*(-3*x**10+96*x**8*y**2+39*x**8*z**2-224*x**6*y**4-1344*x**6*y**2*z**2+42*x**6*z**4-224*x**4*y**6+6720*x**4*y**4*z**2-3360*x**4*y**2*z**4+182*x**4*z**6+96*x**2*y**8-1344*x**2*y**6*z**2-3360*x**2*y**4*z**4+2688*x**2*y**2*z**6-135*x**2*z**8-3*y**10+39*y**8*z**2+42*y**6*z**4+182*y**4*z**6-135*y**2*z**8+6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Qh(10,Eg,2,1)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(9*x**10-174*x**8*y**2-231*x**8*z**2+140*x**6*y**4+4032*x**6*y**2*z**2+406*x**6*z**4-140*x**4*y**6-10080*x**4*y**2*z**4+266*x**4*z**6+174*x**2*y**8-4032*x**2*y**6*z**2+10080*x**2*y**4*z**4-57*x**2*z**8-9*y**10+231*y**8*z**2-406*y**6*z**4-266*y**4*z**6+57*y**2*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Qh(10,Tg,1,0)": (
            "sqrt(221)*S1/32-sqrt(102)*S3/32-sqrt(510)*S5/32-11*sqrt(6)*S7/64-sqrt(38)*S9/64",
            "sqrt(12155)*y*z*(y-z)*(y+z)*(18*x**2-y**2-z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/32",
            "[0,-sqrt(19)*I/64,0,-11*sqrt(3)*I/64,0,-sqrt(255)*I/32,0,-sqrt(51)*I/32,0,sqrt(442)*I/64,0,sqrt(442)*I/64,0,-sqrt(51)*I/32,0,-sqrt(255)*I/32,0,-11*sqrt(3)*I/64,0,-sqrt(19)*I/64,0]",
        ),
        "Qh(10,Tg,1,1)": (
            "-sqrt(221)*C1/32-sqrt(102)*C3/32+sqrt(510)*C5/32-11*sqrt(6)*C7/64+sqrt(38)*C9/64",
            "sqrt(12155)*x*z*(x-z)*(x+z)*(x**2-18*y**2+z**2)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/32",
            "[0,-sqrt(19)/64,0,11*sqrt(3)/64,0,-sqrt(255)/32,0,sqrt(51)/32,0,sqrt(442)/64,0,-sqrt(442)/64,0,-sqrt(51)/32,0,sqrt(255)/32,0,-11*sqrt(3)/64,0,sqrt(19)/64,0]",
        ),
        "Qh(10,Tg,1,2)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(10,Tg,2,0)": (
            "sqrt(39)*S1/32-11*sqrt(2)*S3/32+5*sqrt(10)*S5/32-sqrt(34)*S7/64-sqrt(1938)*S9/64",
            "sqrt(2145)*y*z*(y-z)*(y+z)*(112*x**6-168*x**4*y**2-168*x**4*z**2+42*x**2*y**4+84*x**2*y**2*z**2+42*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,-sqrt(969)*I/64,0,-sqrt(17)*I/64,0,5*sqrt(5)*I/32,0,-11*I/32,0,sqrt(78)*I/64,0,sqrt(78)*I/64,0,-11*I/32,0,5*sqrt(5)*I/32,0,-sqrt(17)*I/64,0,-sqrt(969)*I/64,0]",
        ),
        "Qh(10,Tg,2,1)": (
            "-sqrt(39)*C1/32-11*sqrt(2)*C3/32-5*sqrt(10)*C5/32-sqrt(34)*C7/64+sqrt(1938)*C9/64",
            "sqrt(2145)*x*z*(x-z)*(x+z)*(x**6-42*x**4*y**2+3*x**4*z**2+168*x**2*y**4-84*x**2*y**2*z**2+3*x**2*z**4-112*y**6+168*y**4*z**2-42*y**2*z**4+z**6)/32",
            "[0,-sqrt(969)/64,0,sqrt(17)/64,0,5*sqrt(5)/32,0,11/32,0,sqrt(78)/64,0,-sqrt(78)/64,0,-11/32,0,-5*sqrt(5)/32,0,-sqrt(17)/64,0,sqrt(969)/64,0]",
        ),
        "Qh(10,Tg,2,2)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(10,Tg,3,0)": (
            "sqrt(41990)*S1/256+sqrt(4845)*S3/128+sqrt(969)*S5/128+sqrt(285)*S7/256+sqrt(5)*S9/256",
            "sqrt(92378)*y*z*(y**4-10*y**2*z**2+5*z**4)*(5*y**4-10*y**2*z**2+z**4)/256",
            "[0,sqrt(10)*I/512,0,sqrt(570)*I/512,0,sqrt(1938)*I/256,0,sqrt(9690)*I/256,0,sqrt(20995)*I/256,0,sqrt(20995)*I/256,0,sqrt(9690)*I/256,0,sqrt(1938)*I/256,0,sqrt(570)*I/512,0,sqrt(10)*I/512,0]",
        ),
        "Qh(10,Tg,3,1)": (
            "sqrt(41990)*C1/256-sqrt(4845)*C3/128+sqrt(969)*C5/128-sqrt(285)*C7/256+sqrt(5)*C9/256",
            "sqrt(92378)*x*z*(x**4-10*x**2*z**2+5*z**4)*(5*x**4-10*x**2*z**2+z**4)/256",
            "[0,-sqrt(10)/512,0,sqrt(570)/512,0,-sqrt(1938)/256,0,sqrt(9690)/256,0,-sqrt(20995)/256,0,sqrt(20995)/256,0,-sqrt(9690)/256,0,sqrt(1938)/256,0,-sqrt(570)/512,0,sqrt(10)/512,0]",
        ),
        "Qh(10,Tg,3,2)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(10,Tg,4,0)": (
            "9*sqrt(78)*S1/256-69*S3/128-sqrt(5)*S5/128+43*sqrt(17)*S7/256+3*sqrt(969)*S9/256",
            "sqrt(4290)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(224*x**4-96*x**2*y**2-96*x**2*z**2+3*y**4+6*y**2*z**2+3*z**4)/256",
            "[0,3*sqrt(1938)*I/512,0,43*sqrt(34)*I/512,0,-sqrt(10)*I/256,0,-69*sqrt(2)*I/256,0,9*sqrt(39)*I/256,0,9*sqrt(39)*I/256,0,-69*sqrt(2)*I/256,0,-sqrt(10)*I/256,0,43*sqrt(34)*I/512,0,3*sqrt(1938)*I/512,0]",
        ),
        "Qh(10,Tg,4,1)": (
            "9*sqrt(78)*C1/256+69*C3/128-sqrt(5)*C5/128-43*sqrt(17)*C7/256+3*sqrt(969)*C9/256",
            "sqrt(4290)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(3*x**4-96*x**2*y**2+6*x**2*z**2+224*y**4-96*y**2*z**2+3*z**4)/256",
            "[0,-3*sqrt(1938)/512,0,43*sqrt(34)/512,0,sqrt(10)/256,0,-69*sqrt(2)/256,0,-9*sqrt(39)/256,0,9*sqrt(39)/256,0,69*sqrt(2)/256,0,-sqrt(10)/256,0,-43*sqrt(34)/512,0,3*sqrt(1938)/512,0]",
        ),
        "Qh(10,Tg,4,2)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,Tg,5,0)": (
            "7*sqrt(3)*S1/128-7*sqrt(26)*S3/128+5*sqrt(130)*S5/128-7*sqrt(442)*S7/256+sqrt(25194)*S9/256",
            "sqrt(165)*y*z*(384*x**8-1792*x**6*y**2-1792*x**6*z**2+1680*x**4*y**4+3360*x**4*y**2*z**2+1680*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+7*y**8+28*y**6*z**2+42*y**4*z**4+28*y**2*z**6+7*z**8)/128",
            "[0,sqrt(12597)*I/256,0,-7*sqrt(221)*I/256,0,5*sqrt(65)*I/128,0,-7*sqrt(13)*I/128,0,7*sqrt(6)*I/256,0,7*sqrt(6)*I/256,0,-7*sqrt(13)*I/128,0,5*sqrt(65)*I/128,0,-7*sqrt(221)*I/256,0,sqrt(12597)*I/256,0]",
        ),
        "Qh(10,Tg,5,1)": (
            "7*sqrt(3)*C1/128+7*sqrt(26)*C3/128+5*sqrt(130)*C5/128+7*sqrt(442)*C7/256+sqrt(25194)*C9/256",
            "sqrt(165)*x*z*(7*x**8-336*x**6*y**2+28*x**6*z**2+1680*x**4*y**4-1008*x**4*y**2*z**2+42*x**4*z**4-1792*x**2*y**6+3360*x**2*y**4*z**2-1008*x**2*y**2*z**4+28*x**2*z**6+384*y**8-1792*y**6*z**2+1680*y**4*z**4-336*y**2*z**6+7*z**8)/128",
            "[0,-sqrt(12597)/256,0,-7*sqrt(221)/256,0,-5*sqrt(65)/128,0,-7*sqrt(13)/128,0,-7*sqrt(6)/256,0,7*sqrt(6)/256,0,7*sqrt(13)/128,0,5*sqrt(65)/128,0,7*sqrt(221)/256,0,sqrt(12597)/256,0]",
        ),
        "Qh(10,Tg,5,2)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Au,,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Qh(11,Eu,1,0)": (
            "S8",
            "sqrt(692835)*x*y*z*(-x**8+6*x**6*y**2+6*x**6*z**2-42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2+y**8-6*y**6*z**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(11,Eu,1,1)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "sqrt(230945)*x*y*z*(-x**8+6*x**6*y**2+6*x**6*z**2-42*x**4*y**2*z**2+6*x**2*y**6-42*x**2*y**4*z**2+84*x**2*y**2*z**4-12*x**2*z**6-y**8+6*y**6*z**2-12*y**2*z**6+2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Qh(11,Eu,2,0)": (
            "S4",
            "3*sqrt(1001)*x*y*z*(-5*x**8-10*x**6*y**2+70*x**6*z**2+70*x**4*y**2*z**2-168*x**4*z**4+10*x**2*y**6-70*x**2*y**4*z**2+80*x**2*z**6+5*y**8-70*y**6*z**2+168*y**4*z**4-80*y**2*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eu,2,1)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "sqrt(3003)*x*y*z*(-5*x**8+150*x**6*y**2-90*x**6*z**2-336*x**4*y**4+70*x**4*y**2*z**2+168*x**4*z**4+150*x**2*y**6+70*x**2*y**4*z**2-140*x**2*y**2*z**4-60*x**2*z**6-5*y**8-90*y**6*z**2+168*y**4*z**4-60*y**2*z**6+10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Qh(11,Tu,1,0)": (
            "-21*sqrt(66)*C1/512+sqrt(88179)*C11/512+sqrt(30030)*C3/512-15*sqrt(143)*C5/512+sqrt(36465)*C7/512-sqrt(46189)*C9/512",
            "x*(256*x**10-7040*x**8*y**2-7040*x**8*z**2+31680*x**6*y**4+63360*x**6*y**2*z**2+31680*x**6*z**4-36960*x**4*y**6-110880*x**4*y**4*z**2-110880*x**4*y**2*z**4-36960*x**4*z**6+11550*x**2*y**8+46200*x**2*y**6*z**2+69300*x**2*y**4*z**4+46200*x**2*y**2*z**6+11550*x**2*z**8-693*y**10-3465*y**8*z**2-6930*y**6*z**4-6930*y**4*z**6-3465*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)/1024,0,sqrt(92378)/1024,0,-sqrt(72930)/1024,0,15*sqrt(286)/1024,0,-sqrt(15015)/512,0,21*sqrt(33)/512,0,-21*sqrt(33)/512,0,sqrt(15015)/512,0,-15*sqrt(286)/1024,0,sqrt(72930)/1024,0,-sqrt(92378)/1024,0,sqrt(176358)/1024]",
        ),
        "Qh(11,Tu,1,1)": (
            "-21*sqrt(66)*S1/512-sqrt(88179)*S11/512-sqrt(30030)*S3/512-15*sqrt(143)*S5/512-sqrt(36465)*S7/512-sqrt(46189)*S9/512",
            "-y*(693*x**10-11550*x**8*y**2+3465*x**8*z**2+36960*x**6*y**4-46200*x**6*y**2*z**2+6930*x**6*z**4-31680*x**4*y**6+110880*x**4*y**4*z**2-69300*x**4*y**2*z**4+6930*x**4*z**6+7040*x**2*y**8-63360*x**2*y**6*z**2+110880*x**2*y**4*z**4-46200*x**2*y**2*z**6+3465*x**2*z**8-256*y**10+7040*y**8*z**2-31680*y**6*z**4+36960*y**4*z**6-11550*y**2*z**8+693*z**10)/256",
            "[-sqrt(176358)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(72930)*I/1024,0,-15*sqrt(286)*I/1024,0,-sqrt(15015)*I/512,0,-21*sqrt(33)*I/512,0,-21*sqrt(33)*I/512,0,-sqrt(15015)*I/512,0,-15*sqrt(286)*I/1024,0,-sqrt(72930)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(176358)*I/1024]",
        ),
        "Qh(11,Tu,1,2)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Tu,2,0)": (
            "-sqrt(41990)*C1/512+sqrt(385)*C11/512-3*sqrt(4522)*C3/512+3*sqrt(4845)*C5/512+77*sqrt(19)*C7/512+39*sqrt(15)*C9/512",
            "sqrt(692835)*x*(6*x**2-y**2-z**2)*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/256",
            "[-sqrt(770)/1024,0,-39*sqrt(30)/1024,0,-77*sqrt(38)/1024,0,-3*sqrt(9690)/1024,0,3*sqrt(2261)/512,0,sqrt(20995)/512,0,-sqrt(20995)/512,0,-3*sqrt(2261)/512,0,3*sqrt(9690)/1024,0,77*sqrt(38)/1024,0,39*sqrt(30)/1024,0,sqrt(770)/1024]",
        ),
        "Qh(11,Tu,2,1)": (
            "-sqrt(41990)*S1/512-sqrt(385)*S11/512+3*sqrt(4522)*S3/512+3*sqrt(4845)*S5/512-77*sqrt(19)*S7/512+39*sqrt(15)*S9/512",
            "-sqrt(692835)*y*(x**2-6*y**2+z**2)*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/256",
            "[-sqrt(770)*I/1024,0,39*sqrt(30)*I/1024,0,-77*sqrt(38)*I/1024,0,3*sqrt(9690)*I/1024,0,3*sqrt(2261)*I/512,0,-sqrt(20995)*I/512,0,-sqrt(20995)*I/512,0,3*sqrt(2261)*I/512,0,3*sqrt(9690)*I/1024,0,-77*sqrt(38)*I/1024,0,39*sqrt(30)*I/1024,0,-sqrt(770)*I/1024]",
        ),
        "Qh(11,Tu,2,2)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(11,Tu,3,0)": (
            "-5*sqrt(546)*C1/256+sqrt(10659)*C11/256+11*sqrt(30)*C3/256+13*sqrt(7)*C5/256-3*sqrt(1785)*C7/256+3*sqrt(2261)*C9/256",
            "3*sqrt(1001)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(80*x**6-168*x**4*y**2-168*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-5*y**6-15*y**4*z**2-15*y**2*z**4-5*z**6)/128",
            "[-sqrt(21318)/512,0,-3*sqrt(4522)/512,0,3*sqrt(3570)/512,0,-13*sqrt(14)/512,0,-11*sqrt(15)/256,0,5*sqrt(273)/256,0,-5*sqrt(273)/256,0,11*sqrt(15)/256,0,13*sqrt(14)/512,0,-3*sqrt(3570)/512,0,3*sqrt(4522)/512,0,sqrt(21318)/512]",
        ),
        "Qh(11,Tu,3,1)": (
            "-5*sqrt(546)*S1/256-sqrt(10659)*S11/256-11*sqrt(30)*S3/256+13*sqrt(7)*S5/256+3*sqrt(1785)*S7/256+3*sqrt(2261)*S9/256",
            "-3*sqrt(1001)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(5*x**6-70*x**4*y**2+15*x**4*z**2+168*x**2*y**4-140*x**2*y**2*z**2+15*x**2*z**4-80*y**6+168*y**4*z**2-70*y**2*z**4+5*z**6)/128",
            "[-sqrt(21318)*I/512,0,3*sqrt(4522)*I/512,0,3*sqrt(3570)*I/512,0,13*sqrt(14)*I/512,0,-11*sqrt(15)*I/256,0,-5*sqrt(273)*I/256,0,-5*sqrt(273)*I/256,0,-11*sqrt(15)*I/256,0,13*sqrt(14)*I/512,0,3*sqrt(3570)*I/512,0,3*sqrt(4522)*I/512,0,-sqrt(21318)*I/512]",
        ),
        "Qh(11,Tu,3,2)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Tu,4,0)": (
            "-sqrt(29393)*C1/512-sqrt(22)*C11/1024-9*sqrt(1615)*C3/512-5*sqrt(13566)*C5/1024-7*sqrt(1330)*C7/1024-9*sqrt(42)*C9/1024",
            "sqrt(1939938)*x*(y-z)*(y+z)*(y**4-4*y**3*z-14*y**2*z**2-4*y*z**3+z**4)*(y**4+4*y**3*z-14*y**2*z**2+4*y*z**3+z**4)/512",
            "[sqrt(11)/1024,0,9*sqrt(21)/1024,0,7*sqrt(665)/1024,0,5*sqrt(6783)/1024,0,9*sqrt(3230)/1024,0,sqrt(58786)/1024,0,-sqrt(58786)/1024,0,-9*sqrt(3230)/1024,0,-5*sqrt(6783)/1024,0,-7*sqrt(665)/1024,0,-9*sqrt(21)/1024,0,-sqrt(11)/1024]",
        ),
        "Qh(11,Tu,4,1)": (
            "sqrt(29393)*S1/512-sqrt(22)*S11/1024-9*sqrt(1615)*S3/512+5*sqrt(13566)*S5/1024-7*sqrt(1330)*S7/1024+9*sqrt(42)*S9/1024",
            "-sqrt(1939938)*y*(x-z)*(x+z)*(x**4-4*x**3*z-14*x**2*z**2-4*x*z**3+z**4)*(x**4+4*x**3*z-14*x**2*z**2+4*x*z**3+z**4)/512",
            "[-sqrt(11)*I/1024,0,9*sqrt(21)*I/1024,0,-7*sqrt(665)*I/1024,0,5*sqrt(6783)*I/1024,0,-9*sqrt(3230)*I/1024,0,sqrt(58786)*I/1024,0,sqrt(58786)*I/1024,0,-9*sqrt(3230)*I/1024,0,5*sqrt(6783)*I/1024,0,-7*sqrt(665)*I/1024,0,9*sqrt(21)*I/1024,0,-sqrt(11)*I/1024]",
        ),
        "Qh(11,Tu,4,2)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(11,Tu,5,0)": (
            "-15*sqrt(221)*C1/512-3*sqrt(2926)*C11/1024-sqrt(595)*C3/512+53*sqrt(102)*C5/1024-105*sqrt(10)*C7/1024-61*sqrt(114)*C9/1024",
            "sqrt(14586)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)*(224*x**4-160*x**2*y**2-160*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/512",
            "[3*sqrt(1463)/1024,0,61*sqrt(57)/1024,0,105*sqrt(5)/1024,0,-53*sqrt(51)/1024,0,sqrt(1190)/1024,0,15*sqrt(442)/1024,0,-15*sqrt(442)/1024,0,-sqrt(1190)/1024,0,53*sqrt(51)/1024,0,-105*sqrt(5)/1024,0,-61*sqrt(57)/1024,0,-3*sqrt(1463)/1024]",
        ),
        "Qh(11,Tu,5,1)": (
            "15*sqrt(221)*S1/512-3*sqrt(2926)*S11/1024-sqrt(595)*S3/512-53*sqrt(102)*S5/1024-105*sqrt(10)*S7/1024+61*sqrt(114)*S9/1024",
            "-sqrt(14586)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(15*x**4-160*x**2*y**2+30*x**2*z**2+224*y**4-160*y**2*z**2+15*z**4)/512",
            "[-3*sqrt(1463)*I/1024,0,61*sqrt(57)*I/1024,0,-105*sqrt(5)*I/1024,0,-53*sqrt(51)*I/1024,0,-sqrt(1190)*I/1024,0,15*sqrt(442)*I/1024,0,15*sqrt(442)*I/1024,0,-sqrt(1190)*I/1024,0,-53*sqrt(51)*I/1024,0,-105*sqrt(5)*I/1024,0,61*sqrt(57)*I/1024,0,-3*sqrt(1463)*I/1024]",
        ),
        "Qh(11,Tu,5,2)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,Tu,6,0)": (
            "-21*sqrt(130)*C1/512-sqrt(124355)*C11/512+57*sqrt(14)*C3/512-41*sqrt(15)*C5/512+17*sqrt(17)*C7/512+sqrt(4845)*C9/512",
            "sqrt(2145)*x*(y-z)*(y+z)*(128*x**8-768*x**6*y**2-768*x**6*z**2+1008*x**4*y**4+2016*x**4*y**2*z**2+1008*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+21*y**8+84*y**6*z**2+126*y**4*z**4+84*y**2*z**6+21*z**8)/256",
            "[sqrt(248710)/1024,0,-sqrt(9690)/1024,0,-17*sqrt(34)/1024,0,41*sqrt(30)/1024,0,-57*sqrt(7)/512,0,21*sqrt(65)/512,0,-21*sqrt(65)/512,0,57*sqrt(7)/512,0,-41*sqrt(30)/1024,0,17*sqrt(34)/1024,0,sqrt(9690)/1024,0,-sqrt(248710)/1024]",
        ),
        "Qh(11,Tu,6,1)": (
            "21*sqrt(130)*S1/512-sqrt(124355)*S11/512+57*sqrt(14)*S3/512+41*sqrt(15)*S5/512+17*sqrt(17)*S7/512-sqrt(4845)*S9/512",
            "-sqrt(2145)*y*(x-z)*(x+z)*(21*x**8-336*x**6*y**2+84*x**6*z**2+1008*x**4*y**4-1008*x**4*y**2*z**2+126*x**4*z**4-768*x**2*y**6+2016*x**2*y**4*z**2-1008*x**2*y**2*z**4+84*x**2*z**6+128*y**8-768*y**6*z**2+1008*y**4*z**4-336*y**2*z**6+21*z**8)/256",
            "[-sqrt(248710)*I/1024,0,-sqrt(9690)*I/1024,0,17*sqrt(34)*I/1024,0,41*sqrt(30)*I/1024,0,57*sqrt(7)*I/512,0,21*sqrt(65)*I/512,0,21*sqrt(65)*I/512,0,57*sqrt(7)*I/512,0,41*sqrt(30)*I/1024,0,17*sqrt(34)*I/1024,0,-sqrt(9690)*I/1024,0,-sqrt(248710)*I/1024]",
        ),
        "Qh(11,Tu,6,2)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
    },
}

"""
data of point-group harmonics (axial).
{ tag_harmonics: data }
    data = ( tesseral_harmonics ex., cartesian ex., unitary matrix in descending order, [l,l-1,...,-l] )
Ea and Eb are promoted to E 0:(Ea+Eb)/sqrt(2), 1:(Ea-Eb)/sqrt(2)i.
"""
_data_harmonics_axial_real = {
    "C4": {
        "Gh(0,A,,)": ("C0", "1", "[1]"),
        "Gh(1,A,,)": ("C0", "z", "[0,1,0]"),
        "Gh(1,E,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Gh(1,E,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Gh(2,A,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Gh(2,B,1,)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Gh(2,B,2,)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Gh(2,E,,0)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Gh(2,E,,1)": ("-C1", "-sqrt(3)*x*z", "[0,sqrt(2)/2,0,-sqrt(2)/2,0]"),
        "Gh(3,A,,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Gh(3,B,1,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Gh(3,B,2,)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Gh(3,E,1,0)": (
            "-sqrt(6)*C1/4+sqrt(10)*C3/4",
            "x*(2*x**2-3*y**2-3*z**2)/2",
            "[-sqrt(5)/4,0,sqrt(3)/4,0,-sqrt(3)/4,0,sqrt(5)/4]",
        ),
        "Gh(3,E,1,1)": (
            "-sqrt(6)*S1/4-sqrt(10)*S3/4",
            "y*(-3*x**2+2*y**2-3*z**2)/2",
            "[-sqrt(5)*I/4,0,-sqrt(3)*I/4,0,-sqrt(3)*I/4,0,-sqrt(5)*I/4]",
        ),
        "Gh(3,E,2,0)": (
            "-sqrt(10)*C1/4-sqrt(6)*C3/4",
            "sqrt(15)*x*(y**2-z**2)/2",
            "[sqrt(3)/4,0,sqrt(5)/4,0,-sqrt(5)/4,0,-sqrt(3)/4]",
        ),
        "Gh(3,E,2,1)": (
            "-sqrt(10)*S1/4+sqrt(6)*S3/4",
            "sqrt(15)*y*(x**2-z**2)/2",
            "[sqrt(3)*I/4,0,-sqrt(5)*I/4,0,-sqrt(5)*I/4,0,sqrt(3)*I/4]",
        ),
        "Gh(4,A,1,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Gh(4,A,2,)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "-sqrt(15)*(x**4-12*x**2*y**2+6*x**2*z**2+y**4+6*y**2*z**2-2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Gh(4,A,3,)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Gh(4,B,1,)": ("-C2", "sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Gh(4,B,2,)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Gh(4,E,1,0)": (
            "sqrt(2)*(-sqrt(7)*S1-S3)/4",
            "sqrt(35)*y*z*(y**2-z**2)/2",
            "[0,-I/4,0,-sqrt(7)*I/4,0,-sqrt(7)*I/4,0,-I/4,0]",
        ),
        "Gh(4,E,1,1)": ("sqrt(14)*C1/4-sqrt(2)*C3/4", "sqrt(35)*x*z*(-x**2+z**2)/2", "[0,1/4,0,-sqrt(7)/4,0,sqrt(7)/4,0,-1/4,0]"),
        "Gh(4,E,2,0)": (
            "sqrt(2)*(-S1+sqrt(7)*S3)/4",
            "sqrt(5)*y*z*(6*x**2-y**2-z**2)/2",
            "[0,sqrt(7)*I/4,0,-I/4,0,-I/4,0,sqrt(7)*I/4,0]",
        ),
        "Gh(4,E,2,1)": (
            "sqrt(2)*C1/4+sqrt(14)*C3/4",
            "sqrt(5)*x*z*(x**2-6*y**2+z**2)/2",
            "[0,-sqrt(7)/4,0,-1/4,0,1/4,0,sqrt(7)/4,0]",
        ),
        "Gh(5,A,1,)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Gh(5,A,2,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Gh(5,A,3,)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Gh(5,B,1,)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Gh(5,B,2,)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Gh(5,E,1,0)": (
            "sqrt(15)*C1/8-sqrt(70)*C3/16+3*sqrt(14)*C5/16",
            "x*(8*x**4-40*x**2*y**2-40*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/8",
            "[-3*sqrt(7)/16,0,sqrt(35)/16,0,-sqrt(30)/16,0,sqrt(30)/16,0,-sqrt(35)/16,0,3*sqrt(7)/16]",
        ),
        "Gh(5,E,1,1)": (
            "sqrt(15)*S1/8+sqrt(70)*S3/16+3*sqrt(14)*S5/16",
            "y*(15*x**4-40*x**2*y**2+30*x**2*z**2+8*y**4-40*y**2*z**2+15*z**4)/8",
            "[3*sqrt(7)*I/16,0,sqrt(35)*I/16,0,sqrt(30)*I/16,0,sqrt(30)*I/16,0,sqrt(35)*I/16,0,3*sqrt(7)*I/16]",
        ),
        "Gh(5,E,2,0)": (
            "sqrt(2)*(sqrt(42)*C1+9*C3+sqrt(5)*C5)/16",
            "3*sqrt(35)*x*(y**4-6*y**2*z**2+z**4)/8",
            "[-sqrt(5)/16,0,-9/16,0,-sqrt(42)/16,0,sqrt(42)/16,0,9/16,0,sqrt(5)/16]",
        ),
        "Gh(5,E,2,1)": (
            "sqrt(2)*(sqrt(42)*S1-9*S3+sqrt(5)*S5)/16",
            "3*sqrt(35)*y*(x**4-6*x**2*z**2+z**4)/8",
            "[sqrt(5)*I/16,0,-9*I/16,0,sqrt(42)*I/16,0,sqrt(42)*I/16,0,-9*I/16,0,sqrt(5)*I/16]",
        ),
        "Gh(5,E,3,0)": (
            "sqrt(7)*C1/4-sqrt(6)*C3/8-sqrt(30)*C5/8",
            "sqrt(105)*x*(2*x**2*y**2-2*x**2*z**2-y**4+z**4)/4",
            "[sqrt(15)/8,0,sqrt(3)/8,0,-sqrt(14)/8,0,sqrt(14)/8,0,-sqrt(3)/8,0,-sqrt(15)/8]",
        ),
        "Gh(5,E,3,1)": (
            "sqrt(7)*S1/4+sqrt(6)*S3/8-sqrt(30)*S5/8",
            "sqrt(105)*y*(-x**4+2*x**2*y**2-2*y**2*z**2+z**4)/4",
            "[-sqrt(15)*I/8,0,sqrt(3)*I/8,0,sqrt(14)*I/8,0,sqrt(14)*I/8,0,sqrt(3)*I/8,0,-sqrt(15)*I/8]",
        ),
        "Gh(6,A,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Gh(6,A,2,)": (
            "sqrt(14)*C0/4+sqrt(2)*C4/4",
            "-sqrt(14)*(x**6-15*x**4*z**2+15*x**2*z**4+y**6-15*y**4*z**2+15*y**2*z**4-2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Gh(6,A,3,)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(6,B,1,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Gh(6,B,2,)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x-y)*(x+y)*(x**4-9*x**2*y**2-5*x**2*z**2+y**4-5*y**2*z**2+5*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Gh(6,B,3,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Gh(6,B,4,)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(6,E,1,0)": (
            "sqrt(3)*S1/4-sqrt(30)*S3/8-sqrt(22)*S5/8",
            "3*sqrt(7)*y*z*(10*x**2*y**2-10*x**2*z**2-y**4+z**4)/4",
            "[0,-sqrt(11)*I/8,0,-sqrt(15)*I/8,0,sqrt(6)*I/8,0,sqrt(6)*I/8,0,-sqrt(15)*I/8,0,-sqrt(11)*I/8,0]",
        ),
        "Gh(6,E,1,1)": (
            "-sqrt(3)*C1/4-sqrt(30)*C3/8+sqrt(22)*C5/8",
            "3*sqrt(7)*x*z*(x**4-10*x**2*y**2+10*y**2*z**2-z**4)/4",
            "[0,-sqrt(11)/8,0,sqrt(15)/8,0,sqrt(6)/8,0,-sqrt(6)/8,0,-sqrt(15)/8,0,sqrt(11)/8,0]",
        ),
        "Gh(6,E,2,0)": (
            "3*sqrt(22)*S1/16+sqrt(55)*S3/16+sqrt(3)*S5/16",
            "sqrt(462)*y*z*(3*y**4-10*y**2*z**2+3*z**4)/16",
            "[0,sqrt(6)*I/32,0,sqrt(110)*I/32,0,3*sqrt(11)*I/16,0,3*sqrt(11)*I/16,0,sqrt(110)*I/32,0,sqrt(6)*I/32,0]",
        ),
        "Gh(6,E,2,1)": (
            "-3*sqrt(22)*C1/16+sqrt(55)*C3/16-sqrt(3)*C5/16",
            "sqrt(462)*x*z*(-3*x**4+10*x**2*z**2-3*z**4)/16",
            "[0,sqrt(6)/32,0,-sqrt(110)/32,0,3*sqrt(11)/16,0,-3*sqrt(11)/16,0,sqrt(110)/32,0,-sqrt(6)/32,0]",
        ),
        "Gh(6,E,3,0)": (
            "sqrt(10)*S1/16-9*S3/16+sqrt(165)*S5/16",
            "sqrt(210)*y*z*(16*x**4-16*x**2*y**2-16*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,sqrt(330)*I/32,0,-9*sqrt(2)*I/32,0,sqrt(5)*I/16,0,sqrt(5)*I/16,0,-9*sqrt(2)*I/32,0,sqrt(330)*I/32,0]",
        ),
        "Gh(6,E,3,1)": (
            "-sqrt(10)*C1/16-9*C3/16-sqrt(165)*C5/16",
            "sqrt(210)*x*z*(-x**4+16*x**2*y**2-2*x**2*z**2-16*y**4+16*y**2*z**2-z**4)/16",
            "[0,sqrt(330)/32,0,9*sqrt(2)/32,0,sqrt(5)/16,0,-sqrt(5)/16,0,-9*sqrt(2)/32,0,-sqrt(330)/32,0]",
        ),
        "Gh(7,A,1,)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(7,A,2,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Gh(7,A,3,)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(7,B,1,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Gh(7,B,2,)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "-sqrt(77)*x*y*z*(3*x**4-20*x**2*y**2+10*x**2*z**2+3*y**4+10*y**2*z**2-6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Gh(7,B,3,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(7,B,4,)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(7,E,1,0)": (
            "-5*sqrt(7)*C1/32+3*sqrt(21)*C3/32-sqrt(231)*C5/32+sqrt(429)*C7/32",
            "x*(16*x**6-168*x**4*y**2-168*x**4*z**2+210*x**2*y**4+420*x**2*y**2*z**2+210*x**2*z**4-35*y**6-105*y**4*z**2-105*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)/64,0,sqrt(462)/64,0,-3*sqrt(42)/64,0,5*sqrt(14)/64,0,-5*sqrt(14)/64,0,3*sqrt(42)/64,0,-sqrt(462)/64,0,sqrt(858)/64]",
        ),
        "Gh(7,E,1,1)": (
            "-5*sqrt(7)*S1/32-3*sqrt(21)*S3/32-sqrt(231)*S5/32-sqrt(429)*S7/32",
            "y*(-35*x**6+210*x**4*y**2-105*x**4*z**2-168*x**2*y**4+420*x**2*y**2*z**2-105*x**2*z**4+16*y**6-168*y**4*z**2+210*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)*I/64,0,-sqrt(462)*I/64,0,-3*sqrt(42)*I/64,0,-5*sqrt(14)*I/64,0,-5*sqrt(14)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(462)*I/64,0,-sqrt(858)*I/64]",
        ),
        "Gh(7,E,2,0)": (
            "-3*sqrt(33)*C1/32-sqrt(11)*C3/32+25*C5/32+sqrt(91)*C7/32",
            "sqrt(231)*x*(10*x**2*y**4-60*x**2*y**2*z**2+10*x**2*z**4-3*y**6+15*y**4*z**2+15*y**2*z**4-3*z**6)/16",
            "[-sqrt(182)/64,0,-25*sqrt(2)/64,0,sqrt(22)/64,0,3*sqrt(66)/64,0,-3*sqrt(66)/64,0,-sqrt(22)/64,0,25*sqrt(2)/64,0,sqrt(182)/64]",
        ),
        "Gh(7,E,2,1)": (
            "-3*sqrt(33)*S1/32+sqrt(11)*S3/32+25*S5/32-sqrt(91)*S7/32",
            "sqrt(231)*y*(-3*x**6+10*x**4*y**2+15*x**4*z**2-60*x**2*y**2*z**2+15*x**2*z**4+10*y**2*z**4-3*z**6)/16",
            "[-sqrt(182)*I/64,0,25*sqrt(2)*I/64,0,sqrt(22)*I/64,0,-3*sqrt(66)*I/64,0,-3*sqrt(66)*I/64,0,sqrt(22)*I/64,0,25*sqrt(2)*I/64,0,-sqrt(182)*I/64]",
        ),
        "Gh(7,E,3,0)": (
            "-sqrt(858)*C1/64-3*sqrt(286)*C3/64-5*sqrt(26)*C5/64-sqrt(14)*C7/64",
            "sqrt(6006)*x*(y**6-15*y**4*z**2+15*y**2*z**4-z**6)/32",
            "[sqrt(7)/64,0,5*sqrt(13)/64,0,3*sqrt(143)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-3*sqrt(143)/64,0,-5*sqrt(13)/64,0,-sqrt(7)/64]",
        ),
        "Gh(7,E,3,1)": (
            "-sqrt(858)*S1/64+3*sqrt(286)*S3/64-5*sqrt(26)*S5/64+sqrt(14)*S7/64",
            "sqrt(6006)*y*(x**6-15*x**4*z**2+15*x**2*z**4-z**6)/32",
            "[sqrt(7)*I/64,0,-5*sqrt(13)*I/64,0,3*sqrt(143)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,3*sqrt(143)*I/64,0,-5*sqrt(13)*I/64,0,sqrt(7)*I/64]",
        ),
        "Gh(7,E,4,0)": (
            "sqrt(2)*(-15*sqrt(3)*C1+19*C3-sqrt(11)*C5-sqrt(1001)*C7)/64",
            "sqrt(42)*x*(48*x**4*y**2-48*x**4*z**2-80*x**2*y**4+80*x**2*z**4+15*y**6+15*y**4*z**2-15*y**2*z**4-15*z**6)/32",
            "[sqrt(1001)/64,0,sqrt(11)/64,0,-19/64,0,15*sqrt(3)/64,0,-15*sqrt(3)/64,0,19/64,0,-sqrt(11)/64,0,-sqrt(1001)/64]",
        ),
        "Gh(7,E,4,1)": (
            "-15*sqrt(6)*S1/64-19*sqrt(2)*S3/64-sqrt(22)*S5/64+sqrt(2002)*S7/64",
            "sqrt(42)*y*(15*x**6-80*x**4*y**2+15*x**4*z**2+48*x**2*y**4-15*x**2*z**4-48*y**4*z**2+80*y**2*z**4-15*z**6)/32",
            "[sqrt(1001)*I/64,0,-sqrt(11)*I/64,0,-19*I/64,0,-15*sqrt(3)*I/64,0,-15*sqrt(3)*I/64,0,-19*I/64,0,-sqrt(11)*I/64,0,sqrt(1001)*I/64]",
        ),
        "Gh(8,A,1,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Gh(8,A,2,)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Gh(8,A,3,)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Gh(8,A,4,)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(8,A,5,)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(8,B,1,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(8,B,2,)": (
            "C2",
            "-3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(8,B,3,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(8,B,4,)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(8,E,1,0)": (
            "-sqrt(715)*S1/32-sqrt(273)*S3/32-sqrt(35)*S5/32-S7/32",
            "3*sqrt(715)*y*z*(y**6-7*y**4*z**2+7*y**2*z**4-z**6)/16",
            "[0,-sqrt(2)*I/64,0,-sqrt(70)*I/64,0,-sqrt(546)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(546)*I/64,0,-sqrt(70)*I/64,0,-sqrt(2)*I/64,0]",
        ),
        "Gh(8,E,1,1)": (
            "sqrt(715)*C1/32-sqrt(273)*C3/32+sqrt(35)*C5/32-C7/32",
            "3*sqrt(715)*x*z*(-x**6+7*x**4*z**2-7*x**2*z**4+z**6)/16",
            "[0,sqrt(2)/64,0,-sqrt(70)/64,0,sqrt(546)/64,0,-sqrt(1430)/64,0,sqrt(1430)/64,0,-sqrt(546)/64,0,sqrt(70)/64,0,-sqrt(2)/64,0]",
        ),
        "Gh(8,E,2,0)": (
            "-sqrt(77)*S1/32+5*sqrt(15)*S3/32-3*sqrt(13)*S5/32-sqrt(455)*S7/32",
            "3*sqrt(77)*y*z*(40*x**4*y**2-40*x**4*z**2-24*x**2*y**4+24*x**2*z**4+y**6+y**4*z**2-y**2*z**4-z**6)/16",
            "[0,-sqrt(910)*I/64,0,-3*sqrt(26)*I/64,0,5*sqrt(30)*I/64,0,-sqrt(154)*I/64,0,-sqrt(154)*I/64,0,5*sqrt(30)*I/64,0,-3*sqrt(26)*I/64,0,-sqrt(910)*I/64,0]",
        ),
        "Gh(8,E,2,1)": (
            "sqrt(77)*C1/32+5*sqrt(15)*C3/32+3*sqrt(13)*C5/32-sqrt(455)*C7/32",
            "3*sqrt(77)*x*z*(-x**6+24*x**4*y**2-x**4*z**2-40*x**2*y**4+x**2*z**4+40*y**4*z**2-24*y**2*z**4+z**6)/16",
            "[0,sqrt(910)/64,0,-3*sqrt(26)/64,0,-5*sqrt(30)/64,0,-sqrt(154)/64,0,sqrt(154)/64,0,5*sqrt(30)/64,0,3*sqrt(26)/64,0,-sqrt(910)/64,0]",
        ),
        "Gh(8,E,3,0)": (
            "-sqrt(858)*S1/64+sqrt(910)*S3/64+7*sqrt(42)*S5/64+3*sqrt(30)*S7/64",
            "sqrt(858)*y*z*(42*x**2*y**4-140*x**2*y**2*z**2+42*x**2*z**4-3*y**6+7*y**4*z**2+7*y**2*z**4-3*z**6)/32",
            "[0,3*sqrt(15)*I/64,0,7*sqrt(21)*I/64,0,sqrt(455)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(455)*I/64,0,7*sqrt(21)*I/64,0,3*sqrt(15)*I/64,0]",
        ),
        "Gh(8,E,3,1)": (
            "sqrt(858)*C1/64+sqrt(910)*C3/64-7*sqrt(42)*C5/64+3*sqrt(30)*C7/64",
            "sqrt(858)*x*z*(3*x**6-42*x**4*y**2-7*x**4*z**2+140*x**2*y**2*z**2-7*x**2*z**4-42*y**2*z**4+3*z**6)/32",
            "[0,-3*sqrt(15)/64,0,7*sqrt(21)/64,0,-sqrt(455)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(455)/64,0,-7*sqrt(21)/64,0,3*sqrt(15)/64,0]",
        ),
        "Gh(8,E,4,0)": (
            "-sqrt(70)*S1/64+3*sqrt(66)*S3/64-sqrt(1430)*S5/64+sqrt(2002)*S7/64",
            "3*sqrt(70)*y*z*(32*x**6-80*x**4*y**2-80*x**4*z**2+30*x**2*y**4+60*x**2*y**2*z**2+30*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,sqrt(1001)*I/64,0,-sqrt(715)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(35)*I/64,0,-sqrt(35)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(715)*I/64,0,sqrt(1001)*I/64,0]",
        ),
        "Gh(8,E,4,1)": (
            "sqrt(70)*C1/64+3*sqrt(66)*C3/64+sqrt(1430)*C5/64+sqrt(2002)*C7/64",
            "3*sqrt(70)*x*z*(x**6-30*x**4*y**2+3*x**4*z**2+80*x**2*y**4-60*x**2*y**2*z**2+3*x**2*z**4-32*y**6+80*y**4*z**2-30*y**2*z**4+z**6)/32",
            "[0,-sqrt(1001)/64,0,-sqrt(715)/64,0,-3*sqrt(33)/64,0,-sqrt(35)/64,0,sqrt(35)/64,0,3*sqrt(33)/64,0,sqrt(715)/64,0,sqrt(1001)/64,0]",
        ),
        "Gh(9,A,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Gh(9,A,2,)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(x-y)*(x+y)*(3*x**4-11*x**2*y**2-7*x**2*z**2+3*y**4-7*y**2*z**2+7*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Gh(9,A,3,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(9,A,4,)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(9,A,5,)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(9,B,1,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Gh(9,B,2,)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Gh(9,B,3,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(9,B,4,)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(9,E,1,0)": (
            "21*sqrt(5)*C1/128-sqrt(2310)*C3/128+3*sqrt(286)*C5/128-3*sqrt(1430)*C7/256+sqrt(24310)*C9/256",
            "x*(128*x**8-2304*x**6*y**2-2304*x**6*z**2+6048*x**4*y**4+12096*x**4*y**2*z**2+6048*x**4*z**4-3360*x**2*y**6-10080*x**2*y**4*z**2-10080*x**2*y**2*z**4-3360*x**2*z**6+315*y**8+1260*y**6*z**2+1890*y**4*z**4+1260*y**2*z**6+315*z**8)/128",
            "[-sqrt(12155)/256,0,3*sqrt(715)/256,0,-3*sqrt(143)/128,0,sqrt(1155)/128,0,-21*sqrt(10)/256,0,21*sqrt(10)/256,0,-sqrt(1155)/128,0,3*sqrt(143)/128,0,-3*sqrt(715)/256,0,sqrt(12155)/256]",
        ),
        "Gh(9,E,1,1)": (
            "21*sqrt(5)*S1/128+sqrt(2310)*S3/128+3*sqrt(286)*S5/128+3*sqrt(1430)*S7/256+sqrt(24310)*S9/256",
            "y*(315*x**8-3360*x**6*y**2+1260*x**6*z**2+6048*x**4*y**4-10080*x**4*y**2*z**2+1890*x**4*z**4-2304*x**2*y**6+12096*x**2*y**4*z**2-10080*x**2*y**2*z**4+1260*x**2*z**6+128*y**8-2304*y**6*z**2+6048*y**4*z**4-3360*y**2*z**6+315*z**8)/128",
            "[sqrt(12155)*I/256,0,3*sqrt(715)*I/256,0,3*sqrt(143)*I/128,0,sqrt(1155)*I/128,0,21*sqrt(10)*I/256,0,21*sqrt(10)*I/256,0,sqrt(1155)*I/128,0,3*sqrt(143)*I/128,0,3*sqrt(715)*I/256,0,sqrt(12155)*I/256]",
        ),
        "Gh(9,E,2,0)": (
            "sqrt(2)*(sqrt(4862)*C1+2*sqrt(4641)*C3+10*sqrt(85)*C5+7*sqrt(17)*C7+3*C9)/256",
            "3*sqrt(12155)*x*(y**8-28*y**6*z**2+70*y**4*z**4-28*y**2*z**6+z**8)/128",
            "[-3/256,0,-7*sqrt(17)/256,0,-5*sqrt(85)/128,0,-sqrt(4641)/128,0,-sqrt(4862)/256,0,sqrt(4862)/256,0,sqrt(4641)/128,0,5*sqrt(85)/128,0,7*sqrt(17)/256,0,3/256]",
        ),
        "Gh(9,E,2,1)": (
            "sqrt(2)*(sqrt(4862)*S1-2*sqrt(4641)*S3+10*sqrt(85)*S5-7*sqrt(17)*S7+3*S9)/256",
            "3*sqrt(12155)*y*(x**8-28*x**6*z**2+70*x**4*z**4-28*x**2*z**6+z**8)/128",
            "[3*I/256,0,-7*sqrt(17)*I/256,0,5*sqrt(85)*I/128,0,-sqrt(4641)*I/128,0,sqrt(4862)*I/256,0,sqrt(4862)*I/256,0,-sqrt(4641)*I/128,0,5*sqrt(85)*I/128,0,-7*sqrt(17)*I/256,0,3*I/256]",
        ),
        "Gh(9,E,3,0)": (
            "sqrt(1001)*C1/64-sqrt(78)*C3/64-3*sqrt(70)*C5/64+23*sqrt(14)*C7/128+3*sqrt(238)*C9/128",
            "3*sqrt(5005)*x*(8*x**4*y**4-48*x**4*y**2*z**2+8*x**4*z**4-8*x**2*y**6+40*x**2*y**4*z**2+40*x**2*y**2*z**4-8*x**2*z**6+y**8-4*y**6*z**2-10*y**4*z**4-4*y**2*z**6+z**8)/64",
            "[-3*sqrt(119)/128,0,-23*sqrt(7)/128,0,3*sqrt(35)/64,0,sqrt(39)/64,0,-sqrt(2002)/128,0,sqrt(2002)/128,0,-sqrt(39)/64,0,-3*sqrt(35)/64,0,23*sqrt(7)/128,0,3*sqrt(119)/128]",
        ),
        "Gh(9,E,3,1)": (
            "sqrt(1001)*S1/64+sqrt(78)*S3/64-3*sqrt(70)*S5/64-23*sqrt(14)*S7/128+3*sqrt(238)*S9/128",
            "3*sqrt(5005)*y*(x**8-8*x**6*y**2-4*x**6*z**2+8*x**4*y**4+40*x**4*y**2*z**2-10*x**4*z**4-48*x**2*y**4*z**2+40*x**2*y**2*z**4-4*x**2*z**6+8*y**4*z**4-8*y**2*z**6+z**8)/64",
            "[3*sqrt(119)*I/128,0,-23*sqrt(7)*I/128,0,-3*sqrt(35)*I/64,0,sqrt(39)*I/64,0,sqrt(2002)*I/128,0,sqrt(2002)*I/128,0,sqrt(39)*I/64,0,-3*sqrt(35)*I/64,0,-23*sqrt(7)*I/128,0,3*sqrt(119)*I/128]",
        ),
        "Gh(9,E,4,0)": (
            "sqrt(858)*C1/64+sqrt(91)*C3/32-5*sqrt(15)*C5/32-21*sqrt(3)*C7/64-sqrt(51)*C9/64",
            "sqrt(4290)*x*(14*x**2*y**6-210*x**2*y**4*z**2+210*x**2*y**2*z**4-14*x**2*z**6-3*y**8+42*y**6*z**2-42*y**2*z**6+3*z**8)/64",
            "[sqrt(102)/128,0,21*sqrt(6)/128,0,5*sqrt(30)/64,0,-sqrt(182)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(182)/64,0,-5*sqrt(30)/64,0,-21*sqrt(6)/128,0,-sqrt(102)/128]",
        ),
        "Gh(9,E,4,1)": (
            "sqrt(858)*S1/64-sqrt(91)*S3/32-5*sqrt(15)*S5/32+21*sqrt(3)*S7/64-sqrt(51)*S9/64",
            "sqrt(4290)*y*(-3*x**8+14*x**6*y**2+42*x**6*z**2-210*x**4*y**2*z**2+210*x**2*y**2*z**4-42*x**2*z**6-14*y**2*z**6+3*z**8)/64",
            "[-sqrt(102)*I/128,0,21*sqrt(6)*I/128,0,-5*sqrt(30)*I/64,0,-sqrt(182)*I/64,0,sqrt(429)*I/64,0,sqrt(429)*I/64,0,-sqrt(182)*I/64,0,-5*sqrt(30)*I/64,0,21*sqrt(6)*I/128,0,-sqrt(102)*I/128]",
        ),
        "Gh(9,E,5,0)": (
            "7*sqrt(22)*C1/64-3*sqrt(21)*C3/32+sqrt(65)*C5/32+sqrt(13)*C7/64-3*sqrt(221)*C9/64",
            "3*sqrt(110)*x*(32*x**6*y**2-32*x**6*z**2-112*x**4*y**4+112*x**4*z**4+70*x**2*y**6+70*x**2*y**4*z**2-70*x**2*y**2*z**4-70*x**2*z**6-7*y**8-14*y**6*z**2+14*y**2*z**6+7*z**8)/64",
            "[3*sqrt(442)/128,0,-sqrt(26)/128,0,-sqrt(130)/64,0,3*sqrt(42)/64,0,-7*sqrt(11)/64,0,7*sqrt(11)/64,0,-3*sqrt(42)/64,0,sqrt(130)/64,0,sqrt(26)/128,0,-3*sqrt(442)/128]",
        ),
        "Gh(9,E,5,1)": (
            "7*sqrt(22)*S1/64+3*sqrt(21)*S3/32+sqrt(65)*S5/32-sqrt(13)*S7/64-3*sqrt(221)*S9/64",
            "3*sqrt(110)*y*(-7*x**8+70*x**6*y**2-14*x**6*z**2-112*x**4*y**4+70*x**4*y**2*z**2+32*x**2*y**6-70*x**2*y**2*z**4+14*x**2*z**6-32*y**6*z**2+112*y**4*z**4-70*y**2*z**6+7*z**8)/64",
            "[-3*sqrt(442)*I/128,0,-sqrt(26)*I/128,0,sqrt(130)*I/64,0,3*sqrt(42)*I/64,0,7*sqrt(11)*I/64,0,7*sqrt(11)*I/64,0,3*sqrt(42)*I/64,0,sqrt(130)*I/64,0,-sqrt(26)*I/128,0,-3*sqrt(442)*I/128]",
        ),
        "Gh(10,A,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Gh(10,A,2,)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "-sqrt(420189)*(22*x**10+45*x**8*y**2-1035*x**8*z**2-105*x**6*y**4-630*x**6*y**2*z**2+4935*x**6*z**4-105*x**4*y**6+3150*x**4*y**4*z**2-1575*x**4*y**2*z**4-4830*x**4*z**6+45*x**2*y**8-630*x**2*y**6*z**2-1575*x**2*y**4*z**4+1260*x**2*y**2*z**6+990*x**2*z**8+22*y**10-1035*y**8*z**2+4935*y**6*z**4-4830*y**4*z**6+990*y**2*z**8-44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Gh(10,A,3,)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "-sqrt(3213210)*(3*x**10-96*x**8*y**2-39*x**8*z**2+224*x**6*y**4+1344*x**6*y**2*z**2-42*x**6*z**4+224*x**4*y**6-6720*x**4*y**4*z**2+3360*x**4*y**2*z**4-182*x**4*z**6-96*x**2*y**8+1344*x**2*y**6*z**2+3360*x**2*y**4*z**4-2688*x**2*y**2*z**6+135*x**2*z**8+3*y**10-39*y**8*z**2-42*y**6*z**4-182*y**4*z**6+135*y**2*z**8-6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Gh(10,A,4,)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(10,A,5,)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(10,B,1,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Gh(10,B,2,)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(x-y)*(x+y)*(22*x**8-653*x**6*y**2-315*x**6*z**2+2602*x**4*y**4-945*x**4*y**2*z**2+1575*x**4*z**4-653*x**2*y**6-945*x**2*y**4*z**2+3150*x**2*y**2*z**4-1680*x**2*z**6+22*y**8-315*y**6*z**2+1575*y**4*z**4-1680*y**2*z**6+360*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Gh(10,B,3,)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(x-y)*(x+y)*(9*x**8-165*x**6*y**2-231*x**6*z**2-25*x**4*y**4+3801*x**4*y**2*z**2+406*x**4*z**4-165*x**2*y**6+3801*x**2*y**4*z**2-9674*x**2*y**2*z**4+266*x**2*z**6+9*y**8-231*y**6*z**2+406*y**4*z**4+266*y**2*z**6-57*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Gh(10,B,4,)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(10,B,5,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(10,B,6,)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(10,E,1,0)": (
            "sqrt(221)*S1/32-sqrt(102)*S3/32-sqrt(510)*S5/32-11*sqrt(6)*S7/64-sqrt(38)*S9/64",
            "sqrt(12155)*y*z*(18*x**2*y**6-126*x**2*y**4*z**2+126*x**2*y**2*z**4-18*x**2*z**6-y**8+6*y**6*z**2-6*y**2*z**6+z**8)/32",
            "[0,-sqrt(19)*I/64,0,-11*sqrt(3)*I/64,0,-sqrt(255)*I/32,0,-sqrt(51)*I/32,0,sqrt(442)*I/64,0,sqrt(442)*I/64,0,-sqrt(51)*I/32,0,-sqrt(255)*I/32,0,-11*sqrt(3)*I/64,0,-sqrt(19)*I/64,0]",
        ),
        "Gh(10,E,1,1)": (
            "-sqrt(221)*C1/32-sqrt(102)*C3/32+sqrt(510)*C5/32-11*sqrt(6)*C7/64+sqrt(38)*C9/64",
            "sqrt(12155)*x*z*(x**8-18*x**6*y**2-6*x**6*z**2+126*x**4*y**2*z**2-126*x**2*y**2*z**4+6*x**2*z**6+18*y**2*z**6-z**8)/32",
            "[0,-sqrt(19)/64,0,11*sqrt(3)/64,0,-sqrt(255)/32,0,sqrt(51)/32,0,sqrt(442)/64,0,-sqrt(442)/64,0,-sqrt(51)/32,0,sqrt(255)/32,0,-11*sqrt(3)/64,0,sqrt(19)/64,0]",
        ),
        "Gh(10,E,2,0)": (
            "sqrt(2)*(sqrt(78)*S1-22*S3+10*sqrt(5)*S5-sqrt(17)*S7-sqrt(969)*S9)/64",
            "sqrt(2145)*y*z*(112*x**6*y**2-112*x**6*z**2-168*x**4*y**4+168*x**4*z**4+42*x**2*y**6+42*x**2*y**4*z**2-42*x**2*y**2*z**4-42*x**2*z**6-y**8-2*y**6*z**2+2*y**2*z**6+z**8)/32",
            "[0,-sqrt(969)*I/64,0,-sqrt(17)*I/64,0,5*sqrt(5)*I/32,0,-11*I/32,0,sqrt(78)*I/64,0,sqrt(78)*I/64,0,-11*I/32,0,5*sqrt(5)*I/32,0,-sqrt(17)*I/64,0,-sqrt(969)*I/64,0]",
        ),
        "Gh(10,E,2,1)": (
            "-sqrt(2)*(sqrt(78)*C1+22*C3+10*sqrt(5)*C5+sqrt(17)*C7-sqrt(969)*C9)/64",
            "sqrt(2145)*x*z*(x**8-42*x**6*y**2+2*x**6*z**2+168*x**4*y**4-42*x**4*y**2*z**2-112*x**2*y**6+42*x**2*y**2*z**4-2*x**2*z**6+112*y**6*z**2-168*y**4*z**4+42*y**2*z**6-z**8)/32",
            "[0,-sqrt(969)/64,0,sqrt(17)/64,0,5*sqrt(5)/32,0,11/32,0,sqrt(78)/64,0,-sqrt(78)/64,0,-11/32,0,-5*sqrt(5)/32,0,-sqrt(17)/64,0,sqrt(969)/64,0]",
        ),
        "Gh(10,E,3,0)": (
            "sqrt(41990)*S1/256+sqrt(4845)*S3/128+sqrt(969)*S5/128+sqrt(285)*S7/256+sqrt(5)*S9/256",
            "sqrt(92378)*y*z*(5*y**8-60*y**6*z**2+126*y**4*z**4-60*y**2*z**6+5*z**8)/256",
            "[0,sqrt(10)*I/512,0,sqrt(570)*I/512,0,sqrt(1938)*I/256,0,sqrt(9690)*I/256,0,sqrt(20995)*I/256,0,sqrt(20995)*I/256,0,sqrt(9690)*I/256,0,sqrt(1938)*I/256,0,sqrt(570)*I/512,0,sqrt(10)*I/512,0]",
        ),
        "Gh(10,E,3,1)": (
            "-sqrt(41990)*C1/256+sqrt(4845)*C3/128-sqrt(969)*C5/128+sqrt(285)*C7/256-sqrt(5)*C9/256",
            "sqrt(92378)*x*z*(-5*x**8+60*x**6*z**2-126*x**4*z**4+60*x**2*z**6-5*z**8)/256",
            "[0,sqrt(10)/512,0,-sqrt(570)/512,0,sqrt(1938)/256,0,-sqrt(9690)/256,0,sqrt(20995)/256,0,-sqrt(20995)/256,0,sqrt(9690)/256,0,-sqrt(1938)/256,0,sqrt(570)/512,0,-sqrt(10)/512,0]",
        ),
        "Gh(10,E,4,0)": (
            "9*sqrt(78)*S1/256-69*S3/128-sqrt(5)*S5/128+43*sqrt(17)*S7/256+3*sqrt(969)*S9/256",
            "sqrt(4290)*y*z*(672*x**4*y**4-2240*x**4*y**2*z**2+672*x**4*z**4-288*x**2*y**6+672*x**2*y**4*z**2+672*x**2*y**2*z**4-288*x**2*z**6+9*y**8-12*y**6*z**2-42*y**4*z**4-12*y**2*z**6+9*z**8)/256",
            "[0,3*sqrt(1938)*I/512,0,43*sqrt(34)*I/512,0,-sqrt(10)*I/256,0,-69*sqrt(2)*I/256,0,9*sqrt(39)*I/256,0,9*sqrt(39)*I/256,0,-69*sqrt(2)*I/256,0,-sqrt(10)*I/256,0,43*sqrt(34)*I/512,0,3*sqrt(1938)*I/512,0]",
        ),
        "Gh(10,E,4,1)": (
            "-9*sqrt(78)*C1/256-69*C3/128+sqrt(5)*C5/128+43*sqrt(17)*C7/256-3*sqrt(969)*C9/256",
            "sqrt(4290)*x*z*(-9*x**8+288*x**6*y**2+12*x**6*z**2-672*x**4*y**4-672*x**4*y**2*z**2+42*x**4*z**4+2240*x**2*y**4*z**2-672*x**2*y**2*z**4+12*x**2*z**6-672*y**4*z**4+288*y**2*z**6-9*z**8)/256",
            "[0,3*sqrt(1938)/512,0,-43*sqrt(34)/512,0,-sqrt(10)/256,0,69*sqrt(2)/256,0,9*sqrt(39)/256,0,-9*sqrt(39)/256,0,-69*sqrt(2)/256,0,sqrt(10)/256,0,43*sqrt(34)/512,0,-3*sqrt(1938)/512,0]",
        ),
        "Gh(10,E,5,0)": (
            "7*sqrt(3)*S1/128-7*sqrt(26)*S3/128+5*sqrt(130)*S5/128-7*sqrt(442)*S7/256+sqrt(25194)*S9/256",
            "sqrt(165)*y*z*(384*x**8-1792*x**6*y**2-1792*x**6*z**2+1680*x**4*y**4+3360*x**4*y**2*z**2+1680*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+7*y**8+28*y**6*z**2+42*y**4*z**4+28*y**2*z**6+7*z**8)/128",
            "[0,sqrt(12597)*I/256,0,-7*sqrt(221)*I/256,0,5*sqrt(65)*I/128,0,-7*sqrt(13)*I/128,0,7*sqrt(6)*I/256,0,7*sqrt(6)*I/256,0,-7*sqrt(13)*I/128,0,5*sqrt(65)*I/128,0,-7*sqrt(221)*I/256,0,sqrt(12597)*I/256,0]",
        ),
        "Gh(10,E,5,1)": (
            "-7*sqrt(3)*C1/128-7*sqrt(26)*C3/128-5*sqrt(130)*C5/128-7*sqrt(442)*C7/256-sqrt(25194)*C9/256",
            "sqrt(165)*x*z*(-7*x**8+336*x**6*y**2-28*x**6*z**2-1680*x**4*y**4+1008*x**4*y**2*z**2-42*x**4*z**4+1792*x**2*y**6-3360*x**2*y**4*z**2+1008*x**2*y**2*z**4-28*x**2*z**6-384*y**8+1792*y**6*z**2-1680*y**4*z**4+336*y**2*z**6-7*z**8)/128",
            "[0,sqrt(12597)/256,0,7*sqrt(221)/256,0,5*sqrt(65)/128,0,7*sqrt(13)/128,0,7*sqrt(6)/256,0,-7*sqrt(6)/256,0,-7*sqrt(13)/128,0,-5*sqrt(65)/128,0,-7*sqrt(221)/256,0,-sqrt(12597)/256,0]",
        ),
        "Gh(11,A,1,)": (
            "S8",
            "-sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(11,A,2,)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(11,A,3,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,A,4,)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(11,A,5,)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(11,B,1,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Gh(11,B,2,)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "-sqrt(230945)*x*y*z*(x**8-6*x**6*y**2-6*x**6*z**2+42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2-84*x**2*y**2*z**4+12*x**2*z**6+y**8-6*y**6*z**2+12*y**2*z**6-2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Gh(11,B,3,)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "-sqrt(3003)*x*y*z*(5*x**8-150*x**6*y**2+90*x**6*z**2+336*x**4*y**4-70*x**4*y**2*z**2-168*x**4*z**4-150*x**2*y**6-70*x**2*y**4*z**2+140*x**2*y**2*z**4+60*x**2*z**6+5*y**8+90*y**6*z**2-168*y**4*z**4+60*y**2*z**6-10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Gh(11,B,4,)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(11,B,5,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(11,B,6,)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E,1,0)": (
            "-21*sqrt(66)*C1/512+sqrt(88179)*C11/512+sqrt(30030)*C3/512-15*sqrt(143)*C5/512+sqrt(36465)*C7/512-sqrt(46189)*C9/512",
            "x*(256*x**10-7040*x**8*y**2-7040*x**8*z**2+31680*x**6*y**4+63360*x**6*y**2*z**2+31680*x**6*z**4-36960*x**4*y**6-110880*x**4*y**4*z**2-110880*x**4*y**2*z**4-36960*x**4*z**6+11550*x**2*y**8+46200*x**2*y**6*z**2+69300*x**2*y**4*z**4+46200*x**2*y**2*z**6+11550*x**2*z**8-693*y**10-3465*y**8*z**2-6930*y**6*z**4-6930*y**4*z**6-3465*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)/1024,0,sqrt(92378)/1024,0,-sqrt(72930)/1024,0,15*sqrt(286)/1024,0,-sqrt(15015)/512,0,21*sqrt(33)/512,0,-21*sqrt(33)/512,0,sqrt(15015)/512,0,-15*sqrt(286)/1024,0,sqrt(72930)/1024,0,-sqrt(92378)/1024,0,sqrt(176358)/1024]",
        ),
        "Gh(11,E,1,1)": (
            "-21*sqrt(66)*S1/512-sqrt(88179)*S11/512-sqrt(30030)*S3/512-15*sqrt(143)*S5/512-sqrt(36465)*S7/512-sqrt(46189)*S9/512",
            "y*(-693*x**10+11550*x**8*y**2-3465*x**8*z**2-36960*x**6*y**4+46200*x**6*y**2*z**2-6930*x**6*z**4+31680*x**4*y**6-110880*x**4*y**4*z**2+69300*x**4*y**2*z**4-6930*x**4*z**6-7040*x**2*y**8+63360*x**2*y**6*z**2-110880*x**2*y**4*z**4+46200*x**2*y**2*z**6-3465*x**2*z**8+256*y**10-7040*y**8*z**2+31680*y**6*z**4-36960*y**4*z**6+11550*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(72930)*I/1024,0,-15*sqrt(286)*I/1024,0,-sqrt(15015)*I/512,0,-21*sqrt(33)*I/512,0,-21*sqrt(33)*I/512,0,-sqrt(15015)*I/512,0,-15*sqrt(286)*I/1024,0,-sqrt(72930)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(176358)*I/1024]",
        ),
        "Gh(11,E,2,0)": (
            "-sqrt(41990)*C1/512+sqrt(385)*C11/512-3*sqrt(4522)*C3/512+3*sqrt(4845)*C5/512+77*sqrt(19)*C7/512+39*sqrt(15)*C9/512",
            "sqrt(692835)*x*(6*x**2*y**8-168*x**2*y**6*z**2+420*x**2*y**4*z**4-168*x**2*y**2*z**6+6*x**2*z**8-y**10+27*y**8*z**2-42*y**6*z**4-42*y**4*z**6+27*y**2*z**8-z**10)/256",
            "[-sqrt(770)/1024,0,-39*sqrt(30)/1024,0,-77*sqrt(38)/1024,0,-3*sqrt(9690)/1024,0,3*sqrt(2261)/512,0,sqrt(20995)/512,0,-sqrt(20995)/512,0,-3*sqrt(2261)/512,0,3*sqrt(9690)/1024,0,77*sqrt(38)/1024,0,39*sqrt(30)/1024,0,sqrt(770)/1024]",
        ),
        "Gh(11,E,2,1)": (
            "-sqrt(41990)*S1/512-sqrt(385)*S11/512+3*sqrt(4522)*S3/512+3*sqrt(4845)*S5/512-77*sqrt(19)*S7/512+39*sqrt(15)*S9/512",
            "sqrt(692835)*y*(-x**10+6*x**8*y**2+27*x**8*z**2-168*x**6*y**2*z**2-42*x**6*z**4+420*x**4*y**2*z**4-42*x**4*z**6-168*x**2*y**2*z**6+27*x**2*z**8+6*y**2*z**8-z**10)/256",
            "[-sqrt(770)*I/1024,0,39*sqrt(30)*I/1024,0,-77*sqrt(38)*I/1024,0,3*sqrt(9690)*I/1024,0,3*sqrt(2261)*I/512,0,-sqrt(20995)*I/512,0,-sqrt(20995)*I/512,0,3*sqrt(2261)*I/512,0,3*sqrt(9690)*I/1024,0,-77*sqrt(38)*I/1024,0,39*sqrt(30)*I/1024,0,-sqrt(770)*I/1024]",
        ),
        "Gh(11,E,3,0)": (
            "-5*sqrt(546)*C1/256+sqrt(10659)*C11/256+11*sqrt(30)*C3/256+13*sqrt(7)*C5/256-3*sqrt(1785)*C7/256+3*sqrt(2261)*C9/256",
            "3*sqrt(1001)*x*(80*x**6*y**4-480*x**6*y**2*z**2+80*x**6*z**4-168*x**4*y**6+840*x**4*y**4*z**2+840*x**4*y**2*z**4-168*x**4*z**6+70*x**2*y**8-280*x**2*y**6*z**2-700*x**2*y**4*z**4-280*x**2*y**2*z**6+70*x**2*z**8-5*y**10+15*y**8*z**2+70*y**6*z**4+70*y**4*z**6+15*y**2*z**8-5*z**10)/128",
            "[-sqrt(21318)/512,0,-3*sqrt(4522)/512,0,3*sqrt(3570)/512,0,-13*sqrt(14)/512,0,-11*sqrt(15)/256,0,5*sqrt(273)/256,0,-5*sqrt(273)/256,0,11*sqrt(15)/256,0,13*sqrt(14)/512,0,-3*sqrt(3570)/512,0,3*sqrt(4522)/512,0,sqrt(21318)/512]",
        ),
        "Gh(11,E,3,1)": (
            "-5*sqrt(546)*S1/256-sqrt(10659)*S11/256-11*sqrt(30)*S3/256+13*sqrt(7)*S5/256+3*sqrt(1785)*S7/256+3*sqrt(2261)*S9/256",
            "3*sqrt(1001)*y*(-5*x**10+70*x**8*y**2+15*x**8*z**2-168*x**6*y**4-280*x**6*y**2*z**2+70*x**6*z**4+80*x**4*y**6+840*x**4*y**4*z**2-700*x**4*y**2*z**4+70*x**4*z**6-480*x**2*y**6*z**2+840*x**2*y**4*z**4-280*x**2*y**2*z**6+15*x**2*z**8+80*y**6*z**4-168*y**4*z**6+70*y**2*z**8-5*z**10)/128",
            "[-sqrt(21318)*I/512,0,3*sqrt(4522)*I/512,0,3*sqrt(3570)*I/512,0,13*sqrt(14)*I/512,0,-11*sqrt(15)*I/256,0,-5*sqrt(273)*I/256,0,-5*sqrt(273)*I/256,0,-11*sqrt(15)*I/256,0,13*sqrt(14)*I/512,0,3*sqrt(3570)*I/512,0,3*sqrt(4522)*I/512,0,-sqrt(21318)*I/512]",
        ),
        "Gh(11,E,4,0)": (
            "-sqrt(29393)*C1/512-sqrt(22)*C11/1024-9*sqrt(1615)*C3/512-5*sqrt(13566)*C5/1024-7*sqrt(1330)*C7/1024-9*sqrt(42)*C9/1024",
            "sqrt(1939938)*x*(y**10-45*y**8*z**2+210*y**6*z**4-210*y**4*z**6+45*y**2*z**8-z**10)/512",
            "[sqrt(11)/1024,0,9*sqrt(21)/1024,0,7*sqrt(665)/1024,0,5*sqrt(6783)/1024,0,9*sqrt(3230)/1024,0,sqrt(58786)/1024,0,-sqrt(58786)/1024,0,-9*sqrt(3230)/1024,0,-5*sqrt(6783)/1024,0,-7*sqrt(665)/1024,0,-9*sqrt(21)/1024,0,-sqrt(11)/1024]",
        ),
        "Gh(11,E,4,1)": (
            "-sqrt(29393)*S1/512+sqrt(22)*S11/1024+9*sqrt(1615)*S3/512-5*sqrt(13566)*S5/1024+7*sqrt(1330)*S7/1024-9*sqrt(42)*S9/1024",
            "sqrt(1939938)*y*(x**10-45*x**8*z**2+210*x**6*z**4-210*x**4*z**6+45*x**2*z**8-z**10)/512",
            "[sqrt(11)*I/1024,0,-9*sqrt(21)*I/1024,0,7*sqrt(665)*I/1024,0,-5*sqrt(6783)*I/1024,0,9*sqrt(3230)*I/1024,0,-sqrt(58786)*I/1024,0,-sqrt(58786)*I/1024,0,9*sqrt(3230)*I/1024,0,-5*sqrt(6783)*I/1024,0,7*sqrt(665)*I/1024,0,-9*sqrt(21)*I/1024,0,sqrt(11)*I/1024]",
        ),
        "Gh(11,E,5,0)": (
            "-15*sqrt(221)*C1/512-3*sqrt(2926)*C11/1024-sqrt(595)*C3/512+53*sqrt(102)*C5/1024-105*sqrt(10)*C7/1024-61*sqrt(114)*C9/1024",
            "sqrt(14586)*x*(224*x**4*y**6-3360*x**4*y**4*z**2+3360*x**4*y**2*z**4-224*x**4*z**6-160*x**2*y**8+2240*x**2*y**6*z**2-2240*x**2*y**2*z**6+160*x**2*z**8+15*y**10-195*y**8*z**2-210*y**6*z**4+210*y**4*z**6+195*y**2*z**8-15*z**10)/512",
            "[3*sqrt(1463)/1024,0,61*sqrt(57)/1024,0,105*sqrt(5)/1024,0,-53*sqrt(51)/1024,0,sqrt(1190)/1024,0,15*sqrt(442)/1024,0,-15*sqrt(442)/1024,0,-sqrt(1190)/1024,0,53*sqrt(51)/1024,0,-105*sqrt(5)/1024,0,-61*sqrt(57)/1024,0,-3*sqrt(1463)/1024]",
        ),
        "Gh(11,E,5,1)": (
            "-15*sqrt(221)*S1/512+3*sqrt(2926)*S11/1024+sqrt(595)*S3/512+53*sqrt(102)*S5/1024+105*sqrt(10)*S7/1024-61*sqrt(114)*S9/1024",
            "sqrt(14586)*y*(15*x**10-160*x**8*y**2-195*x**8*z**2+224*x**6*y**4+2240*x**6*y**2*z**2-210*x**6*z**4-3360*x**4*y**4*z**2+210*x**4*z**6+3360*x**2*y**4*z**4-2240*x**2*y**2*z**6+195*x**2*z**8-224*y**4*z**6+160*y**2*z**8-15*z**10)/512",
            "[3*sqrt(1463)*I/1024,0,-61*sqrt(57)*I/1024,0,105*sqrt(5)*I/1024,0,53*sqrt(51)*I/1024,0,sqrt(1190)*I/1024,0,-15*sqrt(442)*I/1024,0,-15*sqrt(442)*I/1024,0,sqrt(1190)*I/1024,0,53*sqrt(51)*I/1024,0,105*sqrt(5)*I/1024,0,-61*sqrt(57)*I/1024,0,3*sqrt(1463)*I/1024]",
        ),
        "Gh(11,E,6,0)": (
            "-21*sqrt(130)*C1/512-sqrt(124355)*C11/512+57*sqrt(14)*C3/512-41*sqrt(15)*C5/512+17*sqrt(17)*C7/512+sqrt(4845)*C9/512",
            "sqrt(2145)*x*(128*x**8*y**2-128*x**8*z**2-768*x**6*y**4+768*x**6*z**4+1008*x**4*y**6+1008*x**4*y**4*z**2-1008*x**4*y**2*z**4-1008*x**4*z**6-336*x**2*y**8-672*x**2*y**6*z**2+672*x**2*y**2*z**6+336*x**2*z**8+21*y**10+63*y**8*z**2+42*y**6*z**4-42*y**4*z**6-63*y**2*z**8-21*z**10)/256",
            "[sqrt(248710)/1024,0,-sqrt(9690)/1024,0,-17*sqrt(34)/1024,0,41*sqrt(30)/1024,0,-57*sqrt(7)/512,0,21*sqrt(65)/512,0,-21*sqrt(65)/512,0,57*sqrt(7)/512,0,-41*sqrt(30)/1024,0,17*sqrt(34)/1024,0,sqrt(9690)/1024,0,-sqrt(248710)/1024]",
        ),
        "Gh(11,E,6,1)": (
            "-21*sqrt(130)*S1/512+sqrt(124355)*S11/512-57*sqrt(14)*S3/512-41*sqrt(15)*S5/512-17*sqrt(17)*S7/512+sqrt(4845)*S9/512",
            "sqrt(2145)*y*(21*x**10-336*x**8*y**2+63*x**8*z**2+1008*x**6*y**4-672*x**6*y**2*z**2+42*x**6*z**4-768*x**4*y**6+1008*x**4*y**4*z**2-42*x**4*z**6+128*x**2*y**8-1008*x**2*y**4*z**4+672*x**2*y**2*z**6-63*x**2*z**8-128*y**8*z**2+768*y**6*z**4-1008*y**4*z**6+336*y**2*z**8-21*z**10)/256",
            "[sqrt(248710)*I/1024,0,sqrt(9690)*I/1024,0,-17*sqrt(34)*I/1024,0,-41*sqrt(30)*I/1024,0,-57*sqrt(7)*I/512,0,-21*sqrt(65)*I/512,0,-21*sqrt(65)*I/512,0,-57*sqrt(7)*I/512,0,-41*sqrt(30)*I/1024,0,-17*sqrt(34)*I/1024,0,sqrt(9690)*I/1024,0,sqrt(248710)*I/1024]",
        ),
    },
    "S4": {
        "Gh(0,B,,)": ("C0", "1", "[1]"),
        "Gh(1,A,,)": ("C0", "z", "[0,1,0]"),
        "Gh(1,E,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Gh(1,E,,1)": ("-S1", "-y", "[-sqrt(2)*I/2,0,-sqrt(2)*I/2]"),
        "Gh(2,A,1,)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Gh(2,A,2,)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Gh(2,B,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Gh(2,E,,0)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Gh(2,E,,1)": ("-C1", "-sqrt(3)*x*z", "[0,sqrt(2)/2,0,-sqrt(2)/2,0]"),
        "Gh(3,A,,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Gh(3,B,1,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Gh(3,B,2,)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Gh(3,E,1,0)": (
            "-sqrt(6)*C1/4+sqrt(10)*C3/4",
            "x*(2*x**2-3*y**2-3*z**2)/2",
            "[-sqrt(5)/4,0,sqrt(3)/4,0,-sqrt(3)/4,0,sqrt(5)/4]",
        ),
        "Gh(3,E,1,1)": (
            "sqrt(6)*S1/4+sqrt(10)*S3/4",
            "y*(3*x**2-2*y**2+3*z**2)/2",
            "[sqrt(5)*I/4,0,sqrt(3)*I/4,0,sqrt(3)*I/4,0,sqrt(5)*I/4]",
        ),
        "Gh(3,E,2,0)": (
            "-sqrt(10)*C1/4-sqrt(6)*C3/4",
            "sqrt(15)*x*(y**2-z**2)/2",
            "[sqrt(3)/4,0,sqrt(5)/4,0,-sqrt(5)/4,0,-sqrt(3)/4]",
        ),
        "Gh(3,E,2,1)": (
            "sqrt(10)*S1/4-sqrt(6)*S3/4",
            "sqrt(15)*y*(-x**2+z**2)/2",
            "[-sqrt(3)*I/4,0,sqrt(5)*I/4,0,sqrt(5)*I/4,0,-sqrt(3)*I/4]",
        ),
        "Gh(4,A,1,)": ("-C2", "sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Gh(4,A,2,)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Gh(4,B,1,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Gh(4,B,2,)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "-sqrt(15)*(x**4-12*x**2*y**2+6*x**2*z**2+y**4+6*y**2*z**2-2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Gh(4,B,3,)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Gh(4,E,1,0)": (
            "sqrt(2)*(-sqrt(7)*S1-S3)/4",
            "sqrt(35)*y*z*(y**2-z**2)/2",
            "[0,-I/4,0,-sqrt(7)*I/4,0,-sqrt(7)*I/4,0,-I/4,0]",
        ),
        "Gh(4,E,1,1)": ("sqrt(14)*C1/4-sqrt(2)*C3/4", "sqrt(35)*x*z*(-x**2+z**2)/2", "[0,1/4,0,-sqrt(7)/4,0,sqrt(7)/4,0,-1/4,0]"),
        "Gh(4,E,2,0)": (
            "sqrt(2)*(-S1+sqrt(7)*S3)/4",
            "sqrt(5)*y*z*(6*x**2-y**2-z**2)/2",
            "[0,sqrt(7)*I/4,0,-I/4,0,-I/4,0,sqrt(7)*I/4,0]",
        ),
        "Gh(4,E,2,1)": (
            "sqrt(2)*C1/4+sqrt(14)*C3/4",
            "sqrt(5)*x*z*(x**2-6*y**2+z**2)/2",
            "[0,-sqrt(7)/4,0,-1/4,0,1/4,0,sqrt(7)/4,0]",
        ),
        "Gh(5,A,1,)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Gh(5,A,2,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Gh(5,A,3,)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Gh(5,B,1,)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Gh(5,B,2,)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Gh(5,E,1,0)": (
            "sqrt(15)*C1/8-sqrt(70)*C3/16+3*sqrt(14)*C5/16",
            "x*(8*x**4-40*x**2*y**2-40*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/8",
            "[-3*sqrt(7)/16,0,sqrt(35)/16,0,-sqrt(30)/16,0,sqrt(30)/16,0,-sqrt(35)/16,0,3*sqrt(7)/16]",
        ),
        "Gh(5,E,1,1)": (
            "-sqrt(15)*S1/8-sqrt(70)*S3/16-3*sqrt(14)*S5/16",
            "y*(-15*x**4+40*x**2*y**2-30*x**2*z**2-8*y**4+40*y**2*z**2-15*z**4)/8",
            "[-3*sqrt(7)*I/16,0,-sqrt(35)*I/16,0,-sqrt(30)*I/16,0,-sqrt(30)*I/16,0,-sqrt(35)*I/16,0,-3*sqrt(7)*I/16]",
        ),
        "Gh(5,E,2,0)": (
            "sqrt(2)*(sqrt(42)*C1+9*C3+sqrt(5)*C5)/16",
            "3*sqrt(35)*x*(y**4-6*y**2*z**2+z**4)/8",
            "[-sqrt(5)/16,0,-9/16,0,-sqrt(42)/16,0,sqrt(42)/16,0,9/16,0,sqrt(5)/16]",
        ),
        "Gh(5,E,2,1)": (
            "-sqrt(2)*(sqrt(42)*S1-9*S3+sqrt(5)*S5)/16",
            "3*sqrt(35)*y*(-x**4+6*x**2*z**2-z**4)/8",
            "[-sqrt(5)*I/16,0,9*I/16,0,-sqrt(42)*I/16,0,-sqrt(42)*I/16,0,9*I/16,0,-sqrt(5)*I/16]",
        ),
        "Gh(5,E,3,0)": (
            "sqrt(7)*C1/4-sqrt(6)*C3/8-sqrt(30)*C5/8",
            "sqrt(105)*x*(2*x**2*y**2-2*x**2*z**2-y**4+z**4)/4",
            "[sqrt(15)/8,0,sqrt(3)/8,0,-sqrt(14)/8,0,sqrt(14)/8,0,-sqrt(3)/8,0,-sqrt(15)/8]",
        ),
        "Gh(5,E,3,1)": (
            "-sqrt(7)*S1/4-sqrt(6)*S3/8+sqrt(30)*S5/8",
            "sqrt(105)*y*(x**4-2*x**2*y**2+2*y**2*z**2-z**4)/4",
            "[sqrt(15)*I/8,0,-sqrt(3)*I/8,0,-sqrt(14)*I/8,0,-sqrt(14)*I/8,0,-sqrt(3)*I/8,0,sqrt(15)*I/8]",
        ),
        "Gh(6,A,1,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Gh(6,A,2,)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x-y)*(x+y)*(x**4-9*x**2*y**2-5*x**2*z**2+y**4-5*y**2*z**2+5*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Gh(6,A,3,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Gh(6,A,4,)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(6,B,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Gh(6,B,2,)": (
            "sqrt(14)*C0/4+sqrt(2)*C4/4",
            "-sqrt(14)*(x**6-15*x**4*z**2+15*x**2*z**4+y**6-15*y**4*z**2+15*y**2*z**4-2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Gh(6,B,3,)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(6,E,1,0)": (
            "sqrt(3)*S1/4-sqrt(30)*S3/8-sqrt(22)*S5/8",
            "3*sqrt(7)*y*z*(10*x**2*y**2-10*x**2*z**2-y**4+z**4)/4",
            "[0,-sqrt(11)*I/8,0,-sqrt(15)*I/8,0,sqrt(6)*I/8,0,sqrt(6)*I/8,0,-sqrt(15)*I/8,0,-sqrt(11)*I/8,0]",
        ),
        "Gh(6,E,1,1)": (
            "-sqrt(3)*C1/4-sqrt(30)*C3/8+sqrt(22)*C5/8",
            "3*sqrt(7)*x*z*(x**4-10*x**2*y**2+10*y**2*z**2-z**4)/4",
            "[0,-sqrt(11)/8,0,sqrt(15)/8,0,sqrt(6)/8,0,-sqrt(6)/8,0,-sqrt(15)/8,0,sqrt(11)/8,0]",
        ),
        "Gh(6,E,2,0)": (
            "3*sqrt(22)*S1/16+sqrt(55)*S3/16+sqrt(3)*S5/16",
            "sqrt(462)*y*z*(3*y**4-10*y**2*z**2+3*z**4)/16",
            "[0,sqrt(6)*I/32,0,sqrt(110)*I/32,0,3*sqrt(11)*I/16,0,3*sqrt(11)*I/16,0,sqrt(110)*I/32,0,sqrt(6)*I/32,0]",
        ),
        "Gh(6,E,2,1)": (
            "-3*sqrt(22)*C1/16+sqrt(55)*C3/16-sqrt(3)*C5/16",
            "sqrt(462)*x*z*(-3*x**4+10*x**2*z**2-3*z**4)/16",
            "[0,sqrt(6)/32,0,-sqrt(110)/32,0,3*sqrt(11)/16,0,-3*sqrt(11)/16,0,sqrt(110)/32,0,-sqrt(6)/32,0]",
        ),
        "Gh(6,E,3,0)": (
            "sqrt(10)*S1/16-9*S3/16+sqrt(165)*S5/16",
            "sqrt(210)*y*z*(16*x**4-16*x**2*y**2-16*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,sqrt(330)*I/32,0,-9*sqrt(2)*I/32,0,sqrt(5)*I/16,0,sqrt(5)*I/16,0,-9*sqrt(2)*I/32,0,sqrt(330)*I/32,0]",
        ),
        "Gh(6,E,3,1)": (
            "-sqrt(10)*C1/16-9*C3/16-sqrt(165)*C5/16",
            "sqrt(210)*x*z*(-x**4+16*x**2*y**2-2*x**2*z**2-16*y**4+16*y**2*z**2-z**4)/16",
            "[0,sqrt(330)/32,0,9*sqrt(2)/32,0,sqrt(5)/16,0,-sqrt(5)/16,0,-9*sqrt(2)/32,0,-sqrt(330)/32,0]",
        ),
        "Gh(7,A,1,)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(7,A,2,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Gh(7,A,3,)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(7,B,1,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Gh(7,B,2,)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "-sqrt(77)*x*y*z*(3*x**4-20*x**2*y**2+10*x**2*z**2+3*y**4+10*y**2*z**2-6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Gh(7,B,3,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(7,B,4,)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(7,E,1,0)": (
            "-5*sqrt(7)*C1/32+3*sqrt(21)*C3/32-sqrt(231)*C5/32+sqrt(429)*C7/32",
            "x*(16*x**6-168*x**4*y**2-168*x**4*z**2+210*x**2*y**4+420*x**2*y**2*z**2+210*x**2*z**4-35*y**6-105*y**4*z**2-105*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)/64,0,sqrt(462)/64,0,-3*sqrt(42)/64,0,5*sqrt(14)/64,0,-5*sqrt(14)/64,0,3*sqrt(42)/64,0,-sqrt(462)/64,0,sqrt(858)/64]",
        ),
        "Gh(7,E,1,1)": (
            "5*sqrt(7)*S1/32+3*sqrt(21)*S3/32+sqrt(231)*S5/32+sqrt(429)*S7/32",
            "y*(35*x**6-210*x**4*y**2+105*x**4*z**2+168*x**2*y**4-420*x**2*y**2*z**2+105*x**2*z**4-16*y**6+168*y**4*z**2-210*y**2*z**4+35*z**6)/16",
            "[sqrt(858)*I/64,0,sqrt(462)*I/64,0,3*sqrt(42)*I/64,0,5*sqrt(14)*I/64,0,5*sqrt(14)*I/64,0,3*sqrt(42)*I/64,0,sqrt(462)*I/64,0,sqrt(858)*I/64]",
        ),
        "Gh(7,E,2,0)": (
            "-3*sqrt(33)*C1/32-sqrt(11)*C3/32+25*C5/32+sqrt(91)*C7/32",
            "sqrt(231)*x*(10*x**2*y**4-60*x**2*y**2*z**2+10*x**2*z**4-3*y**6+15*y**4*z**2+15*y**2*z**4-3*z**6)/16",
            "[-sqrt(182)/64,0,-25*sqrt(2)/64,0,sqrt(22)/64,0,3*sqrt(66)/64,0,-3*sqrt(66)/64,0,-sqrt(22)/64,0,25*sqrt(2)/64,0,sqrt(182)/64]",
        ),
        "Gh(7,E,2,1)": (
            "3*sqrt(33)*S1/32-sqrt(11)*S3/32-25*S5/32+sqrt(91)*S7/32",
            "sqrt(231)*y*(3*x**6-10*x**4*y**2-15*x**4*z**2+60*x**2*y**2*z**2-15*x**2*z**4-10*y**2*z**4+3*z**6)/16",
            "[sqrt(182)*I/64,0,-25*sqrt(2)*I/64,0,-sqrt(22)*I/64,0,3*sqrt(66)*I/64,0,3*sqrt(66)*I/64,0,-sqrt(22)*I/64,0,-25*sqrt(2)*I/64,0,sqrt(182)*I/64]",
        ),
        "Gh(7,E,3,0)": (
            "-sqrt(858)*C1/64-3*sqrt(286)*C3/64-5*sqrt(26)*C5/64-sqrt(14)*C7/64",
            "sqrt(6006)*x*(y**6-15*y**4*z**2+15*y**2*z**4-z**6)/32",
            "[sqrt(7)/64,0,5*sqrt(13)/64,0,3*sqrt(143)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-3*sqrt(143)/64,0,-5*sqrt(13)/64,0,-sqrt(7)/64]",
        ),
        "Gh(7,E,3,1)": (
            "sqrt(858)*S1/64-3*sqrt(286)*S3/64+5*sqrt(26)*S5/64-sqrt(14)*S7/64",
            "sqrt(6006)*y*(-x**6+15*x**4*z**2-15*x**2*z**4+z**6)/32",
            "[-sqrt(7)*I/64,0,5*sqrt(13)*I/64,0,-3*sqrt(143)*I/64,0,sqrt(429)*I/64,0,sqrt(429)*I/64,0,-3*sqrt(143)*I/64,0,5*sqrt(13)*I/64,0,-sqrt(7)*I/64]",
        ),
        "Gh(7,E,4,0)": (
            "sqrt(2)*(-15*sqrt(3)*C1+19*C3-sqrt(11)*C5-sqrt(1001)*C7)/64",
            "sqrt(42)*x*(48*x**4*y**2-48*x**4*z**2-80*x**2*y**4+80*x**2*z**4+15*y**6+15*y**4*z**2-15*y**2*z**4-15*z**6)/32",
            "[sqrt(1001)/64,0,sqrt(11)/64,0,-19/64,0,15*sqrt(3)/64,0,-15*sqrt(3)/64,0,19/64,0,-sqrt(11)/64,0,-sqrt(1001)/64]",
        ),
        "Gh(7,E,4,1)": (
            "15*sqrt(6)*S1/64+19*sqrt(2)*S3/64+sqrt(22)*S5/64-sqrt(2002)*S7/64",
            "sqrt(42)*y*(-15*x**6+80*x**4*y**2-15*x**4*z**2-48*x**2*y**4+15*x**2*z**4+48*y**4*z**2-80*y**2*z**4+15*z**6)/32",
            "[-sqrt(1001)*I/64,0,sqrt(11)*I/64,0,19*I/64,0,15*sqrt(3)*I/64,0,15*sqrt(3)*I/64,0,19*I/64,0,sqrt(11)*I/64,0,-sqrt(1001)*I/64]",
        ),
        "Gh(8,A,1,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(8,A,2,)": (
            "C2",
            "-3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(8,A,3,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(8,A,4,)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(8,B,1,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Gh(8,B,2,)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Gh(8,B,3,)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Gh(8,B,4,)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(8,B,5,)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(8,E,1,0)": (
            "-sqrt(715)*S1/32-sqrt(273)*S3/32-sqrt(35)*S5/32-S7/32",
            "3*sqrt(715)*y*z*(y**6-7*y**4*z**2+7*y**2*z**4-z**6)/16",
            "[0,-sqrt(2)*I/64,0,-sqrt(70)*I/64,0,-sqrt(546)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(546)*I/64,0,-sqrt(70)*I/64,0,-sqrt(2)*I/64,0]",
        ),
        "Gh(8,E,1,1)": (
            "sqrt(715)*C1/32-sqrt(273)*C3/32+sqrt(35)*C5/32-C7/32",
            "3*sqrt(715)*x*z*(-x**6+7*x**4*z**2-7*x**2*z**4+z**6)/16",
            "[0,sqrt(2)/64,0,-sqrt(70)/64,0,sqrt(546)/64,0,-sqrt(1430)/64,0,sqrt(1430)/64,0,-sqrt(546)/64,0,sqrt(70)/64,0,-sqrt(2)/64,0]",
        ),
        "Gh(8,E,2,0)": (
            "-sqrt(77)*S1/32+5*sqrt(15)*S3/32-3*sqrt(13)*S5/32-sqrt(455)*S7/32",
            "3*sqrt(77)*y*z*(40*x**4*y**2-40*x**4*z**2-24*x**2*y**4+24*x**2*z**4+y**6+y**4*z**2-y**2*z**4-z**6)/16",
            "[0,-sqrt(910)*I/64,0,-3*sqrt(26)*I/64,0,5*sqrt(30)*I/64,0,-sqrt(154)*I/64,0,-sqrt(154)*I/64,0,5*sqrt(30)*I/64,0,-3*sqrt(26)*I/64,0,-sqrt(910)*I/64,0]",
        ),
        "Gh(8,E,2,1)": (
            "sqrt(77)*C1/32+5*sqrt(15)*C3/32+3*sqrt(13)*C5/32-sqrt(455)*C7/32",
            "3*sqrt(77)*x*z*(-x**6+24*x**4*y**2-x**4*z**2-40*x**2*y**4+x**2*z**4+40*y**4*z**2-24*y**2*z**4+z**6)/16",
            "[0,sqrt(910)/64,0,-3*sqrt(26)/64,0,-5*sqrt(30)/64,0,-sqrt(154)/64,0,sqrt(154)/64,0,5*sqrt(30)/64,0,3*sqrt(26)/64,0,-sqrt(910)/64,0]",
        ),
        "Gh(8,E,3,0)": (
            "-sqrt(858)*S1/64+sqrt(910)*S3/64+7*sqrt(42)*S5/64+3*sqrt(30)*S7/64",
            "sqrt(858)*y*z*(42*x**2*y**4-140*x**2*y**2*z**2+42*x**2*z**4-3*y**6+7*y**4*z**2+7*y**2*z**4-3*z**6)/32",
            "[0,3*sqrt(15)*I/64,0,7*sqrt(21)*I/64,0,sqrt(455)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(455)*I/64,0,7*sqrt(21)*I/64,0,3*sqrt(15)*I/64,0]",
        ),
        "Gh(8,E,3,1)": (
            "sqrt(858)*C1/64+sqrt(910)*C3/64-7*sqrt(42)*C5/64+3*sqrt(30)*C7/64",
            "sqrt(858)*x*z*(3*x**6-42*x**4*y**2-7*x**4*z**2+140*x**2*y**2*z**2-7*x**2*z**4-42*y**2*z**4+3*z**6)/32",
            "[0,-3*sqrt(15)/64,0,7*sqrt(21)/64,0,-sqrt(455)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(455)/64,0,-7*sqrt(21)/64,0,3*sqrt(15)/64,0]",
        ),
        "Gh(8,E,4,0)": (
            "-sqrt(70)*S1/64+3*sqrt(66)*S3/64-sqrt(1430)*S5/64+sqrt(2002)*S7/64",
            "3*sqrt(70)*y*z*(32*x**6-80*x**4*y**2-80*x**4*z**2+30*x**2*y**4+60*x**2*y**2*z**2+30*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,sqrt(1001)*I/64,0,-sqrt(715)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(35)*I/64,0,-sqrt(35)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(715)*I/64,0,sqrt(1001)*I/64,0]",
        ),
        "Gh(8,E,4,1)": (
            "sqrt(70)*C1/64+3*sqrt(66)*C3/64+sqrt(1430)*C5/64+sqrt(2002)*C7/64",
            "3*sqrt(70)*x*z*(x**6-30*x**4*y**2+3*x**4*z**2+80*x**2*y**4-60*x**2*y**2*z**2+3*x**2*z**4-32*y**6+80*y**4*z**2-30*y**2*z**4+z**6)/32",
            "[0,-sqrt(1001)/64,0,-sqrt(715)/64,0,-3*sqrt(33)/64,0,-sqrt(35)/64,0,sqrt(35)/64,0,3*sqrt(33)/64,0,sqrt(715)/64,0,sqrt(1001)/64,0]",
        ),
        "Gh(9,A,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Gh(9,A,2,)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(x-y)*(x+y)*(3*x**4-11*x**2*y**2-7*x**2*z**2+3*y**4-7*y**2*z**2+7*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Gh(9,A,3,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(9,A,4,)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(9,A,5,)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(9,B,1,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Gh(9,B,2,)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Gh(9,B,3,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(9,B,4,)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(9,E,1,0)": (
            "21*sqrt(5)*C1/128-sqrt(2310)*C3/128+3*sqrt(286)*C5/128-3*sqrt(1430)*C7/256+sqrt(24310)*C9/256",
            "x*(128*x**8-2304*x**6*y**2-2304*x**6*z**2+6048*x**4*y**4+12096*x**4*y**2*z**2+6048*x**4*z**4-3360*x**2*y**6-10080*x**2*y**4*z**2-10080*x**2*y**2*z**4-3360*x**2*z**6+315*y**8+1260*y**6*z**2+1890*y**4*z**4+1260*y**2*z**6+315*z**8)/128",
            "[-sqrt(12155)/256,0,3*sqrt(715)/256,0,-3*sqrt(143)/128,0,sqrt(1155)/128,0,-21*sqrt(10)/256,0,21*sqrt(10)/256,0,-sqrt(1155)/128,0,3*sqrt(143)/128,0,-3*sqrt(715)/256,0,sqrt(12155)/256]",
        ),
        "Gh(9,E,1,1)": (
            "-21*sqrt(5)*S1/128-sqrt(2310)*S3/128-3*sqrt(286)*S5/128-3*sqrt(1430)*S7/256-sqrt(24310)*S9/256",
            "y*(-315*x**8+3360*x**6*y**2-1260*x**6*z**2-6048*x**4*y**4+10080*x**4*y**2*z**2-1890*x**4*z**4+2304*x**2*y**6-12096*x**2*y**4*z**2+10080*x**2*y**2*z**4-1260*x**2*z**6-128*y**8+2304*y**6*z**2-6048*y**4*z**4+3360*y**2*z**6-315*z**8)/128",
            "[-sqrt(12155)*I/256,0,-3*sqrt(715)*I/256,0,-3*sqrt(143)*I/128,0,-sqrt(1155)*I/128,0,-21*sqrt(10)*I/256,0,-21*sqrt(10)*I/256,0,-sqrt(1155)*I/128,0,-3*sqrt(143)*I/128,0,-3*sqrt(715)*I/256,0,-sqrt(12155)*I/256]",
        ),
        "Gh(9,E,2,0)": (
            "sqrt(2)*(sqrt(4862)*C1+2*sqrt(4641)*C3+10*sqrt(85)*C5+7*sqrt(17)*C7+3*C9)/256",
            "3*sqrt(12155)*x*(y**8-28*y**6*z**2+70*y**4*z**4-28*y**2*z**6+z**8)/128",
            "[-3/256,0,-7*sqrt(17)/256,0,-5*sqrt(85)/128,0,-sqrt(4641)/128,0,-sqrt(4862)/256,0,sqrt(4862)/256,0,sqrt(4641)/128,0,5*sqrt(85)/128,0,7*sqrt(17)/256,0,3/256]",
        ),
        "Gh(9,E,2,1)": (
            "-sqrt(2)*(sqrt(4862)*S1-2*sqrt(4641)*S3+10*sqrt(85)*S5-7*sqrt(17)*S7+3*S9)/256",
            "3*sqrt(12155)*y*(-x**8+28*x**6*z**2-70*x**4*z**4+28*x**2*z**6-z**8)/128",
            "[-3*I/256,0,7*sqrt(17)*I/256,0,-5*sqrt(85)*I/128,0,sqrt(4641)*I/128,0,-sqrt(4862)*I/256,0,-sqrt(4862)*I/256,0,sqrt(4641)*I/128,0,-5*sqrt(85)*I/128,0,7*sqrt(17)*I/256,0,-3*I/256]",
        ),
        "Gh(9,E,3,0)": (
            "sqrt(1001)*C1/64-sqrt(78)*C3/64-3*sqrt(70)*C5/64+23*sqrt(14)*C7/128+3*sqrt(238)*C9/128",
            "3*sqrt(5005)*x*(8*x**4*y**4-48*x**4*y**2*z**2+8*x**4*z**4-8*x**2*y**6+40*x**2*y**4*z**2+40*x**2*y**2*z**4-8*x**2*z**6+y**8-4*y**6*z**2-10*y**4*z**4-4*y**2*z**6+z**8)/64",
            "[-3*sqrt(119)/128,0,-23*sqrt(7)/128,0,3*sqrt(35)/64,0,sqrt(39)/64,0,-sqrt(2002)/128,0,sqrt(2002)/128,0,-sqrt(39)/64,0,-3*sqrt(35)/64,0,23*sqrt(7)/128,0,3*sqrt(119)/128]",
        ),
        "Gh(9,E,3,1)": (
            "-sqrt(1001)*S1/64-sqrt(78)*S3/64+3*sqrt(70)*S5/64+23*sqrt(14)*S7/128-3*sqrt(238)*S9/128",
            "3*sqrt(5005)*y*(-x**8+8*x**6*y**2+4*x**6*z**2-8*x**4*y**4-40*x**4*y**2*z**2+10*x**4*z**4+48*x**2*y**4*z**2-40*x**2*y**2*z**4+4*x**2*z**6-8*y**4*z**4+8*y**2*z**6-z**8)/64",
            "[-3*sqrt(119)*I/128,0,23*sqrt(7)*I/128,0,3*sqrt(35)*I/64,0,-sqrt(39)*I/64,0,-sqrt(2002)*I/128,0,-sqrt(2002)*I/128,0,-sqrt(39)*I/64,0,3*sqrt(35)*I/64,0,23*sqrt(7)*I/128,0,-3*sqrt(119)*I/128]",
        ),
        "Gh(9,E,4,0)": (
            "sqrt(858)*C1/64+sqrt(91)*C3/32-5*sqrt(15)*C5/32-21*sqrt(3)*C7/64-sqrt(51)*C9/64",
            "sqrt(4290)*x*(14*x**2*y**6-210*x**2*y**4*z**2+210*x**2*y**2*z**4-14*x**2*z**6-3*y**8+42*y**6*z**2-42*y**2*z**6+3*z**8)/64",
            "[sqrt(102)/128,0,21*sqrt(6)/128,0,5*sqrt(30)/64,0,-sqrt(182)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(182)/64,0,-5*sqrt(30)/64,0,-21*sqrt(6)/128,0,-sqrt(102)/128]",
        ),
        "Gh(9,E,4,1)": (
            "-sqrt(858)*S1/64+sqrt(91)*S3/32+5*sqrt(15)*S5/32-21*sqrt(3)*S7/64+sqrt(51)*S9/64",
            "sqrt(4290)*y*(3*x**8-14*x**6*y**2-42*x**6*z**2+210*x**4*y**2*z**2-210*x**2*y**2*z**4+42*x**2*z**6+14*y**2*z**6-3*z**8)/64",
            "[sqrt(102)*I/128,0,-21*sqrt(6)*I/128,0,5*sqrt(30)*I/64,0,sqrt(182)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(182)*I/64,0,5*sqrt(30)*I/64,0,-21*sqrt(6)*I/128,0,sqrt(102)*I/128]",
        ),
        "Gh(9,E,5,0)": (
            "7*sqrt(22)*C1/64-3*sqrt(21)*C3/32+sqrt(65)*C5/32+sqrt(13)*C7/64-3*sqrt(221)*C9/64",
            "3*sqrt(110)*x*(32*x**6*y**2-32*x**6*z**2-112*x**4*y**4+112*x**4*z**4+70*x**2*y**6+70*x**2*y**4*z**2-70*x**2*y**2*z**4-70*x**2*z**6-7*y**8-14*y**6*z**2+14*y**2*z**6+7*z**8)/64",
            "[3*sqrt(442)/128,0,-sqrt(26)/128,0,-sqrt(130)/64,0,3*sqrt(42)/64,0,-7*sqrt(11)/64,0,7*sqrt(11)/64,0,-3*sqrt(42)/64,0,sqrt(130)/64,0,sqrt(26)/128,0,-3*sqrt(442)/128]",
        ),
        "Gh(9,E,5,1)": (
            "-7*sqrt(22)*S1/64-3*sqrt(21)*S3/32-sqrt(65)*S5/32+sqrt(13)*S7/64+3*sqrt(221)*S9/64",
            "3*sqrt(110)*y*(7*x**8-70*x**6*y**2+14*x**6*z**2+112*x**4*y**4-70*x**4*y**2*z**2-32*x**2*y**6+70*x**2*y**2*z**4-14*x**2*z**6+32*y**6*z**2-112*y**4*z**4+70*y**2*z**6-7*z**8)/64",
            "[3*sqrt(442)*I/128,0,sqrt(26)*I/128,0,-sqrt(130)*I/64,0,-3*sqrt(42)*I/64,0,-7*sqrt(11)*I/64,0,-7*sqrt(11)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(130)*I/64,0,sqrt(26)*I/128,0,3*sqrt(442)*I/128]",
        ),
        "Gh(10,A,1,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Gh(10,A,2,)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(x-y)*(x+y)*(22*x**8-653*x**6*y**2-315*x**6*z**2+2602*x**4*y**4-945*x**4*y**2*z**2+1575*x**4*z**4-653*x**2*y**6-945*x**2*y**4*z**2+3150*x**2*y**2*z**4-1680*x**2*z**6+22*y**8-315*y**6*z**2+1575*y**4*z**4-1680*y**2*z**6+360*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Gh(10,A,3,)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(x-y)*(x+y)*(9*x**8-165*x**6*y**2-231*x**6*z**2-25*x**4*y**4+3801*x**4*y**2*z**2+406*x**4*z**4-165*x**2*y**6+3801*x**2*y**4*z**2-9674*x**2*y**2*z**4+266*x**2*z**6+9*y**8-231*y**6*z**2+406*y**4*z**4+266*y**2*z**6-57*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Gh(10,A,4,)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(10,A,5,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(10,A,6,)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(10,B,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Gh(10,B,2,)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "-sqrt(420189)*(22*x**10+45*x**8*y**2-1035*x**8*z**2-105*x**6*y**4-630*x**6*y**2*z**2+4935*x**6*z**4-105*x**4*y**6+3150*x**4*y**4*z**2-1575*x**4*y**2*z**4-4830*x**4*z**6+45*x**2*y**8-630*x**2*y**6*z**2-1575*x**2*y**4*z**4+1260*x**2*y**2*z**6+990*x**2*z**8+22*y**10-1035*y**8*z**2+4935*y**6*z**4-4830*y**4*z**6+990*y**2*z**8-44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Gh(10,B,3,)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "-sqrt(3213210)*(3*x**10-96*x**8*y**2-39*x**8*z**2+224*x**6*y**4+1344*x**6*y**2*z**2-42*x**6*z**4+224*x**4*y**6-6720*x**4*y**4*z**2+3360*x**4*y**2*z**4-182*x**4*z**6-96*x**2*y**8+1344*x**2*y**6*z**2+3360*x**2*y**4*z**4-2688*x**2*y**2*z**6+135*x**2*z**8+3*y**10-39*y**8*z**2-42*y**6*z**4-182*y**4*z**6+135*y**2*z**8-6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Gh(10,B,4,)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(10,B,5,)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(10,E,1,0)": (
            "sqrt(221)*S1/32-sqrt(102)*S3/32-sqrt(510)*S5/32-11*sqrt(6)*S7/64-sqrt(38)*S9/64",
            "sqrt(12155)*y*z*(18*x**2*y**6-126*x**2*y**4*z**2+126*x**2*y**2*z**4-18*x**2*z**6-y**8+6*y**6*z**2-6*y**2*z**6+z**8)/32",
            "[0,-sqrt(19)*I/64,0,-11*sqrt(3)*I/64,0,-sqrt(255)*I/32,0,-sqrt(51)*I/32,0,sqrt(442)*I/64,0,sqrt(442)*I/64,0,-sqrt(51)*I/32,0,-sqrt(255)*I/32,0,-11*sqrt(3)*I/64,0,-sqrt(19)*I/64,0]",
        ),
        "Gh(10,E,1,1)": (
            "-sqrt(221)*C1/32-sqrt(102)*C3/32+sqrt(510)*C5/32-11*sqrt(6)*C7/64+sqrt(38)*C9/64",
            "sqrt(12155)*x*z*(x**8-18*x**6*y**2-6*x**6*z**2+126*x**4*y**2*z**2-126*x**2*y**2*z**4+6*x**2*z**6+18*y**2*z**6-z**8)/32",
            "[0,-sqrt(19)/64,0,11*sqrt(3)/64,0,-sqrt(255)/32,0,sqrt(51)/32,0,sqrt(442)/64,0,-sqrt(442)/64,0,-sqrt(51)/32,0,sqrt(255)/32,0,-11*sqrt(3)/64,0,sqrt(19)/64,0]",
        ),
        "Gh(10,E,2,0)": (
            "sqrt(2)*(sqrt(78)*S1-22*S3+10*sqrt(5)*S5-sqrt(17)*S7-sqrt(969)*S9)/64",
            "sqrt(2145)*y*z*(112*x**6*y**2-112*x**6*z**2-168*x**4*y**4+168*x**4*z**4+42*x**2*y**6+42*x**2*y**4*z**2-42*x**2*y**2*z**4-42*x**2*z**6-y**8-2*y**6*z**2+2*y**2*z**6+z**8)/32",
            "[0,-sqrt(969)*I/64,0,-sqrt(17)*I/64,0,5*sqrt(5)*I/32,0,-11*I/32,0,sqrt(78)*I/64,0,sqrt(78)*I/64,0,-11*I/32,0,5*sqrt(5)*I/32,0,-sqrt(17)*I/64,0,-sqrt(969)*I/64,0]",
        ),
        "Gh(10,E,2,1)": (
            "-sqrt(2)*(sqrt(78)*C1+22*C3+10*sqrt(5)*C5+sqrt(17)*C7-sqrt(969)*C9)/64",
            "sqrt(2145)*x*z*(x**8-42*x**6*y**2+2*x**6*z**2+168*x**4*y**4-42*x**4*y**2*z**2-112*x**2*y**6+42*x**2*y**2*z**4-2*x**2*z**6+112*y**6*z**2-168*y**4*z**4+42*y**2*z**6-z**8)/32",
            "[0,-sqrt(969)/64,0,sqrt(17)/64,0,5*sqrt(5)/32,0,11/32,0,sqrt(78)/64,0,-sqrt(78)/64,0,-11/32,0,-5*sqrt(5)/32,0,-sqrt(17)/64,0,sqrt(969)/64,0]",
        ),
        "Gh(10,E,3,0)": (
            "sqrt(41990)*S1/256+sqrt(4845)*S3/128+sqrt(969)*S5/128+sqrt(285)*S7/256+sqrt(5)*S9/256",
            "sqrt(92378)*y*z*(5*y**8-60*y**6*z**2+126*y**4*z**4-60*y**2*z**6+5*z**8)/256",
            "[0,sqrt(10)*I/512,0,sqrt(570)*I/512,0,sqrt(1938)*I/256,0,sqrt(9690)*I/256,0,sqrt(20995)*I/256,0,sqrt(20995)*I/256,0,sqrt(9690)*I/256,0,sqrt(1938)*I/256,0,sqrt(570)*I/512,0,sqrt(10)*I/512,0]",
        ),
        "Gh(10,E,3,1)": (
            "-sqrt(41990)*C1/256+sqrt(4845)*C3/128-sqrt(969)*C5/128+sqrt(285)*C7/256-sqrt(5)*C9/256",
            "sqrt(92378)*x*z*(-5*x**8+60*x**6*z**2-126*x**4*z**4+60*x**2*z**6-5*z**8)/256",
            "[0,sqrt(10)/512,0,-sqrt(570)/512,0,sqrt(1938)/256,0,-sqrt(9690)/256,0,sqrt(20995)/256,0,-sqrt(20995)/256,0,sqrt(9690)/256,0,-sqrt(1938)/256,0,sqrt(570)/512,0,-sqrt(10)/512,0]",
        ),
        "Gh(10,E,4,0)": (
            "9*sqrt(78)*S1/256-69*S3/128-sqrt(5)*S5/128+43*sqrt(17)*S7/256+3*sqrt(969)*S9/256",
            "sqrt(4290)*y*z*(672*x**4*y**4-2240*x**4*y**2*z**2+672*x**4*z**4-288*x**2*y**6+672*x**2*y**4*z**2+672*x**2*y**2*z**4-288*x**2*z**6+9*y**8-12*y**6*z**2-42*y**4*z**4-12*y**2*z**6+9*z**8)/256",
            "[0,3*sqrt(1938)*I/512,0,43*sqrt(34)*I/512,0,-sqrt(10)*I/256,0,-69*sqrt(2)*I/256,0,9*sqrt(39)*I/256,0,9*sqrt(39)*I/256,0,-69*sqrt(2)*I/256,0,-sqrt(10)*I/256,0,43*sqrt(34)*I/512,0,3*sqrt(1938)*I/512,0]",
        ),
        "Gh(10,E,4,1)": (
            "-9*sqrt(78)*C1/256-69*C3/128+sqrt(5)*C5/128+43*sqrt(17)*C7/256-3*sqrt(969)*C9/256",
            "sqrt(4290)*x*z*(-9*x**8+288*x**6*y**2+12*x**6*z**2-672*x**4*y**4-672*x**4*y**2*z**2+42*x**4*z**4+2240*x**2*y**4*z**2-672*x**2*y**2*z**4+12*x**2*z**6-672*y**4*z**4+288*y**2*z**6-9*z**8)/256",
            "[0,3*sqrt(1938)/512,0,-43*sqrt(34)/512,0,-sqrt(10)/256,0,69*sqrt(2)/256,0,9*sqrt(39)/256,0,-9*sqrt(39)/256,0,-69*sqrt(2)/256,0,sqrt(10)/256,0,43*sqrt(34)/512,0,-3*sqrt(1938)/512,0]",
        ),
        "Gh(10,E,5,0)": (
            "7*sqrt(3)*S1/128-7*sqrt(26)*S3/128+5*sqrt(130)*S5/128-7*sqrt(442)*S7/256+sqrt(25194)*S9/256",
            "sqrt(165)*y*z*(384*x**8-1792*x**6*y**2-1792*x**6*z**2+1680*x**4*y**4+3360*x**4*y**2*z**2+1680*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+7*y**8+28*y**6*z**2+42*y**4*z**4+28*y**2*z**6+7*z**8)/128",
            "[0,sqrt(12597)*I/256,0,-7*sqrt(221)*I/256,0,5*sqrt(65)*I/128,0,-7*sqrt(13)*I/128,0,7*sqrt(6)*I/256,0,7*sqrt(6)*I/256,0,-7*sqrt(13)*I/128,0,5*sqrt(65)*I/128,0,-7*sqrt(221)*I/256,0,sqrt(12597)*I/256,0]",
        ),
        "Gh(10,E,5,1)": (
            "-7*sqrt(3)*C1/128-7*sqrt(26)*C3/128-5*sqrt(130)*C5/128-7*sqrt(442)*C7/256-sqrt(25194)*C9/256",
            "sqrt(165)*x*z*(-7*x**8+336*x**6*y**2-28*x**6*z**2-1680*x**4*y**4+1008*x**4*y**2*z**2-42*x**4*z**4+1792*x**2*y**6-3360*x**2*y**4*z**2+1008*x**2*y**2*z**4-28*x**2*z**6-384*y**8+1792*y**6*z**2-1680*y**4*z**4+336*y**2*z**6-7*z**8)/128",
            "[0,sqrt(12597)/256,0,7*sqrt(221)/256,0,5*sqrt(65)/128,0,7*sqrt(13)/128,0,7*sqrt(6)/256,0,-7*sqrt(6)/256,0,-7*sqrt(13)/128,0,-5*sqrt(65)/128,0,-7*sqrt(221)/256,0,-sqrt(12597)/256,0]",
        ),
        "Gh(11,A,1,)": (
            "S8",
            "-sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(11,A,2,)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(11,A,3,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,A,4,)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(11,A,5,)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(11,B,1,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Gh(11,B,2,)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "-sqrt(230945)*x*y*z*(x**8-6*x**6*y**2-6*x**6*z**2+42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2-84*x**2*y**2*z**4+12*x**2*z**6+y**8-6*y**6*z**2+12*y**2*z**6-2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Gh(11,B,3,)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "-sqrt(3003)*x*y*z*(5*x**8-150*x**6*y**2+90*x**6*z**2+336*x**4*y**4-70*x**4*y**2*z**2-168*x**4*z**4-150*x**2*y**6-70*x**2*y**4*z**2+140*x**2*y**2*z**4+60*x**2*z**6+5*y**8+90*y**6*z**2-168*y**4*z**4+60*y**2*z**6-10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Gh(11,B,4,)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(11,B,5,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(11,B,6,)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E,1,0)": (
            "-21*sqrt(66)*C1/512+sqrt(88179)*C11/512+sqrt(30030)*C3/512-15*sqrt(143)*C5/512+sqrt(36465)*C7/512-sqrt(46189)*C9/512",
            "x*(256*x**10-7040*x**8*y**2-7040*x**8*z**2+31680*x**6*y**4+63360*x**6*y**2*z**2+31680*x**6*z**4-36960*x**4*y**6-110880*x**4*y**4*z**2-110880*x**4*y**2*z**4-36960*x**4*z**6+11550*x**2*y**8+46200*x**2*y**6*z**2+69300*x**2*y**4*z**4+46200*x**2*y**2*z**6+11550*x**2*z**8-693*y**10-3465*y**8*z**2-6930*y**6*z**4-6930*y**4*z**6-3465*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)/1024,0,sqrt(92378)/1024,0,-sqrt(72930)/1024,0,15*sqrt(286)/1024,0,-sqrt(15015)/512,0,21*sqrt(33)/512,0,-21*sqrt(33)/512,0,sqrt(15015)/512,0,-15*sqrt(286)/1024,0,sqrt(72930)/1024,0,-sqrt(92378)/1024,0,sqrt(176358)/1024]",
        ),
        "Gh(11,E,1,1)": (
            "21*sqrt(66)*S1/512+sqrt(88179)*S11/512+sqrt(30030)*S3/512+15*sqrt(143)*S5/512+sqrt(36465)*S7/512+sqrt(46189)*S9/512",
            "y*(693*x**10-11550*x**8*y**2+3465*x**8*z**2+36960*x**6*y**4-46200*x**6*y**2*z**2+6930*x**6*z**4-31680*x**4*y**6+110880*x**4*y**4*z**2-69300*x**4*y**2*z**4+6930*x**4*z**6+7040*x**2*y**8-63360*x**2*y**6*z**2+110880*x**2*y**4*z**4-46200*x**2*y**2*z**6+3465*x**2*z**8-256*y**10+7040*y**8*z**2-31680*y**6*z**4+36960*y**4*z**6-11550*y**2*z**8+693*z**10)/256",
            "[sqrt(176358)*I/1024,0,sqrt(92378)*I/1024,0,sqrt(72930)*I/1024,0,15*sqrt(286)*I/1024,0,sqrt(15015)*I/512,0,21*sqrt(33)*I/512,0,21*sqrt(33)*I/512,0,sqrt(15015)*I/512,0,15*sqrt(286)*I/1024,0,sqrt(72930)*I/1024,0,sqrt(92378)*I/1024,0,sqrt(176358)*I/1024]",
        ),
        "Gh(11,E,2,0)": (
            "-sqrt(41990)*C1/512+sqrt(385)*C11/512-3*sqrt(4522)*C3/512+3*sqrt(4845)*C5/512+77*sqrt(19)*C7/512+39*sqrt(15)*C9/512",
            "sqrt(692835)*x*(6*x**2*y**8-168*x**2*y**6*z**2+420*x**2*y**4*z**4-168*x**2*y**2*z**6+6*x**2*z**8-y**10+27*y**8*z**2-42*y**6*z**4-42*y**4*z**6+27*y**2*z**8-z**10)/256",
            "[-sqrt(770)/1024,0,-39*sqrt(30)/1024,0,-77*sqrt(38)/1024,0,-3*sqrt(9690)/1024,0,3*sqrt(2261)/512,0,sqrt(20995)/512,0,-sqrt(20995)/512,0,-3*sqrt(2261)/512,0,3*sqrt(9690)/1024,0,77*sqrt(38)/1024,0,39*sqrt(30)/1024,0,sqrt(770)/1024]",
        ),
        "Gh(11,E,2,1)": (
            "sqrt(41990)*S1/512+sqrt(385)*S11/512-3*sqrt(4522)*S3/512-3*sqrt(4845)*S5/512+77*sqrt(19)*S7/512-39*sqrt(15)*S9/512",
            "sqrt(692835)*y*(x**10-6*x**8*y**2-27*x**8*z**2+168*x**6*y**2*z**2+42*x**6*z**4-420*x**4*y**2*z**4+42*x**4*z**6+168*x**2*y**2*z**6-27*x**2*z**8-6*y**2*z**8+z**10)/256",
            "[sqrt(770)*I/1024,0,-39*sqrt(30)*I/1024,0,77*sqrt(38)*I/1024,0,-3*sqrt(9690)*I/1024,0,-3*sqrt(2261)*I/512,0,sqrt(20995)*I/512,0,sqrt(20995)*I/512,0,-3*sqrt(2261)*I/512,0,-3*sqrt(9690)*I/1024,0,77*sqrt(38)*I/1024,0,-39*sqrt(30)*I/1024,0,sqrt(770)*I/1024]",
        ),
        "Gh(11,E,3,0)": (
            "-5*sqrt(546)*C1/256+sqrt(10659)*C11/256+11*sqrt(30)*C3/256+13*sqrt(7)*C5/256-3*sqrt(1785)*C7/256+3*sqrt(2261)*C9/256",
            "3*sqrt(1001)*x*(80*x**6*y**4-480*x**6*y**2*z**2+80*x**6*z**4-168*x**4*y**6+840*x**4*y**4*z**2+840*x**4*y**2*z**4-168*x**4*z**6+70*x**2*y**8-280*x**2*y**6*z**2-700*x**2*y**4*z**4-280*x**2*y**2*z**6+70*x**2*z**8-5*y**10+15*y**8*z**2+70*y**6*z**4+70*y**4*z**6+15*y**2*z**8-5*z**10)/128",
            "[-sqrt(21318)/512,0,-3*sqrt(4522)/512,0,3*sqrt(3570)/512,0,-13*sqrt(14)/512,0,-11*sqrt(15)/256,0,5*sqrt(273)/256,0,-5*sqrt(273)/256,0,11*sqrt(15)/256,0,13*sqrt(14)/512,0,-3*sqrt(3570)/512,0,3*sqrt(4522)/512,0,sqrt(21318)/512]",
        ),
        "Gh(11,E,3,1)": (
            "5*sqrt(546)*S1/256+sqrt(10659)*S11/256+11*sqrt(30)*S3/256-13*sqrt(7)*S5/256-3*sqrt(1785)*S7/256-3*sqrt(2261)*S9/256",
            "3*sqrt(1001)*y*(5*x**10-70*x**8*y**2-15*x**8*z**2+168*x**6*y**4+280*x**6*y**2*z**2-70*x**6*z**4-80*x**4*y**6-840*x**4*y**4*z**2+700*x**4*y**2*z**4-70*x**4*z**6+480*x**2*y**6*z**2-840*x**2*y**4*z**4+280*x**2*y**2*z**6-15*x**2*z**8-80*y**6*z**4+168*y**4*z**6-70*y**2*z**8+5*z**10)/128",
            "[sqrt(21318)*I/512,0,-3*sqrt(4522)*I/512,0,-3*sqrt(3570)*I/512,0,-13*sqrt(14)*I/512,0,11*sqrt(15)*I/256,0,5*sqrt(273)*I/256,0,5*sqrt(273)*I/256,0,11*sqrt(15)*I/256,0,-13*sqrt(14)*I/512,0,-3*sqrt(3570)*I/512,0,-3*sqrt(4522)*I/512,0,sqrt(21318)*I/512]",
        ),
        "Gh(11,E,4,0)": (
            "-sqrt(29393)*C1/512-sqrt(22)*C11/1024-9*sqrt(1615)*C3/512-5*sqrt(13566)*C5/1024-7*sqrt(1330)*C7/1024-9*sqrt(42)*C9/1024",
            "sqrt(1939938)*x*(y**10-45*y**8*z**2+210*y**6*z**4-210*y**4*z**6+45*y**2*z**8-z**10)/512",
            "[sqrt(11)/1024,0,9*sqrt(21)/1024,0,7*sqrt(665)/1024,0,5*sqrt(6783)/1024,0,9*sqrt(3230)/1024,0,sqrt(58786)/1024,0,-sqrt(58786)/1024,0,-9*sqrt(3230)/1024,0,-5*sqrt(6783)/1024,0,-7*sqrt(665)/1024,0,-9*sqrt(21)/1024,0,-sqrt(11)/1024]",
        ),
        "Gh(11,E,4,1)": (
            "sqrt(29393)*S1/512-sqrt(22)*S11/1024-9*sqrt(1615)*S3/512+5*sqrt(13566)*S5/1024-7*sqrt(1330)*S7/1024+9*sqrt(42)*S9/1024",
            "sqrt(1939938)*y*(-x**10+45*x**8*z**2-210*x**6*z**4+210*x**4*z**6-45*x**2*z**8+z**10)/512",
            "[-sqrt(11)*I/1024,0,9*sqrt(21)*I/1024,0,-7*sqrt(665)*I/1024,0,5*sqrt(6783)*I/1024,0,-9*sqrt(3230)*I/1024,0,sqrt(58786)*I/1024,0,sqrt(58786)*I/1024,0,-9*sqrt(3230)*I/1024,0,5*sqrt(6783)*I/1024,0,-7*sqrt(665)*I/1024,0,9*sqrt(21)*I/1024,0,-sqrt(11)*I/1024]",
        ),
        "Gh(11,E,5,0)": (
            "-15*sqrt(221)*C1/512-3*sqrt(2926)*C11/1024-sqrt(595)*C3/512+53*sqrt(102)*C5/1024-105*sqrt(10)*C7/1024-61*sqrt(114)*C9/1024",
            "sqrt(14586)*x*(224*x**4*y**6-3360*x**4*y**4*z**2+3360*x**4*y**2*z**4-224*x**4*z**6-160*x**2*y**8+2240*x**2*y**6*z**2-2240*x**2*y**2*z**6+160*x**2*z**8+15*y**10-195*y**8*z**2-210*y**6*z**4+210*y**4*z**6+195*y**2*z**8-15*z**10)/512",
            "[3*sqrt(1463)/1024,0,61*sqrt(57)/1024,0,105*sqrt(5)/1024,0,-53*sqrt(51)/1024,0,sqrt(1190)/1024,0,15*sqrt(442)/1024,0,-15*sqrt(442)/1024,0,-sqrt(1190)/1024,0,53*sqrt(51)/1024,0,-105*sqrt(5)/1024,0,-61*sqrt(57)/1024,0,-3*sqrt(1463)/1024]",
        ),
        "Gh(11,E,5,1)": (
            "15*sqrt(221)*S1/512-3*sqrt(2926)*S11/1024-sqrt(595)*S3/512-53*sqrt(102)*S5/1024-105*sqrt(10)*S7/1024+61*sqrt(114)*S9/1024",
            "sqrt(14586)*y*(-15*x**10+160*x**8*y**2+195*x**8*z**2-224*x**6*y**4-2240*x**6*y**2*z**2+210*x**6*z**4+3360*x**4*y**4*z**2-210*x**4*z**6-3360*x**2*y**4*z**4+2240*x**2*y**2*z**6-195*x**2*z**8+224*y**4*z**6-160*y**2*z**8+15*z**10)/512",
            "[-3*sqrt(1463)*I/1024,0,61*sqrt(57)*I/1024,0,-105*sqrt(5)*I/1024,0,-53*sqrt(51)*I/1024,0,-sqrt(1190)*I/1024,0,15*sqrt(442)*I/1024,0,15*sqrt(442)*I/1024,0,-sqrt(1190)*I/1024,0,-53*sqrt(51)*I/1024,0,-105*sqrt(5)*I/1024,0,61*sqrt(57)*I/1024,0,-3*sqrt(1463)*I/1024]",
        ),
        "Gh(11,E,6,0)": (
            "-21*sqrt(130)*C1/512-sqrt(124355)*C11/512+57*sqrt(14)*C3/512-41*sqrt(15)*C5/512+17*sqrt(17)*C7/512+sqrt(4845)*C9/512",
            "sqrt(2145)*x*(128*x**8*y**2-128*x**8*z**2-768*x**6*y**4+768*x**6*z**4+1008*x**4*y**6+1008*x**4*y**4*z**2-1008*x**4*y**2*z**4-1008*x**4*z**6-336*x**2*y**8-672*x**2*y**6*z**2+672*x**2*y**2*z**6+336*x**2*z**8+21*y**10+63*y**8*z**2+42*y**6*z**4-42*y**4*z**6-63*y**2*z**8-21*z**10)/256",
            "[sqrt(248710)/1024,0,-sqrt(9690)/1024,0,-17*sqrt(34)/1024,0,41*sqrt(30)/1024,0,-57*sqrt(7)/512,0,21*sqrt(65)/512,0,-21*sqrt(65)/512,0,57*sqrt(7)/512,0,-41*sqrt(30)/1024,0,17*sqrt(34)/1024,0,sqrt(9690)/1024,0,-sqrt(248710)/1024]",
        ),
        "Gh(11,E,6,1)": (
            "21*sqrt(130)*S1/512-sqrt(124355)*S11/512+57*sqrt(14)*S3/512+41*sqrt(15)*S5/512+17*sqrt(17)*S7/512-sqrt(4845)*S9/512",
            "sqrt(2145)*y*(-21*x**10+336*x**8*y**2-63*x**8*z**2-1008*x**6*y**4+672*x**6*y**2*z**2-42*x**6*z**4+768*x**4*y**6-1008*x**4*y**4*z**2+42*x**4*z**6-128*x**2*y**8+1008*x**2*y**4*z**4-672*x**2*y**2*z**6+63*x**2*z**8+128*y**8*z**2-768*y**6*z**4+1008*y**4*z**6-336*y**2*z**8+21*z**10)/256",
            "[-sqrt(248710)*I/1024,0,-sqrt(9690)*I/1024,0,17*sqrt(34)*I/1024,0,41*sqrt(30)*I/1024,0,57*sqrt(7)*I/512,0,21*sqrt(65)*I/512,0,21*sqrt(65)*I/512,0,57*sqrt(7)*I/512,0,41*sqrt(30)*I/1024,0,17*sqrt(34)*I/1024,0,-sqrt(9690)*I/1024,0,-sqrt(248710)*I/1024]",
        ),
    },
    "C4h": {
        "Gh(0,Au,,)": ("C0", "1", "[1]"),
        "Gh(1,Ag,,)": ("C0", "z", "[0,1,0]"),
        "Gh(1,Eg,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Gh(1,Eg,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Gh(2,Au,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Gh(2,Bu,1,)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Gh(2,Bu,2,)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Gh(2,Eu,,0)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Gh(2,Eu,,1)": ("-C1", "-sqrt(3)*x*z", "[0,sqrt(2)/2,0,-sqrt(2)/2,0]"),
        "Gh(3,Ag,,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Gh(3,Bg,1,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Gh(3,Bg,2,)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Gh(3,Eg,1,0)": (
            "-sqrt(6)*C1/4+sqrt(10)*C3/4",
            "x*(2*x**2-3*y**2-3*z**2)/2",
            "[-sqrt(5)/4,0,sqrt(3)/4,0,-sqrt(3)/4,0,sqrt(5)/4]",
        ),
        "Gh(3,Eg,1,1)": (
            "-sqrt(6)*S1/4-sqrt(10)*S3/4",
            "y*(-3*x**2+2*y**2-3*z**2)/2",
            "[-sqrt(5)*I/4,0,-sqrt(3)*I/4,0,-sqrt(3)*I/4,0,-sqrt(5)*I/4]",
        ),
        "Gh(3,Eg,2,0)": (
            "-sqrt(10)*C1/4-sqrt(6)*C3/4",
            "sqrt(15)*x*(y**2-z**2)/2",
            "[sqrt(3)/4,0,sqrt(5)/4,0,-sqrt(5)/4,0,-sqrt(3)/4]",
        ),
        "Gh(3,Eg,2,1)": (
            "-sqrt(10)*S1/4+sqrt(6)*S3/4",
            "sqrt(15)*y*(x**2-z**2)/2",
            "[sqrt(3)*I/4,0,-sqrt(5)*I/4,0,-sqrt(5)*I/4,0,sqrt(3)*I/4]",
        ),
        "Gh(4,Au,1,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Gh(4,Au,2,)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "-sqrt(15)*(x**4-12*x**2*y**2+6*x**2*z**2+y**4+6*y**2*z**2-2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Gh(4,Au,3,)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Gh(4,Bu,1,)": ("-C2", "sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Gh(4,Bu,2,)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Gh(4,Eu,1,0)": (
            "sqrt(2)*(-sqrt(7)*S1-S3)/4",
            "sqrt(35)*y*z*(y**2-z**2)/2",
            "[0,-I/4,0,-sqrt(7)*I/4,0,-sqrt(7)*I/4,0,-I/4,0]",
        ),
        "Gh(4,Eu,1,1)": (
            "sqrt(14)*C1/4-sqrt(2)*C3/4",
            "sqrt(35)*x*z*(-x**2+z**2)/2",
            "[0,1/4,0,-sqrt(7)/4,0,sqrt(7)/4,0,-1/4,0]",
        ),
        "Gh(4,Eu,2,0)": (
            "sqrt(2)*(-S1+sqrt(7)*S3)/4",
            "sqrt(5)*y*z*(6*x**2-y**2-z**2)/2",
            "[0,sqrt(7)*I/4,0,-I/4,0,-I/4,0,sqrt(7)*I/4,0]",
        ),
        "Gh(4,Eu,2,1)": (
            "sqrt(2)*C1/4+sqrt(14)*C3/4",
            "sqrt(5)*x*z*(x**2-6*y**2+z**2)/2",
            "[0,-sqrt(7)/4,0,-1/4,0,1/4,0,sqrt(7)/4,0]",
        ),
        "Gh(5,Ag,1,)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Gh(5,Ag,2,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Gh(5,Ag,3,)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Gh(5,Bg,1,)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Gh(5,Bg,2,)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Gh(5,Eg,1,0)": (
            "sqrt(15)*C1/8-sqrt(70)*C3/16+3*sqrt(14)*C5/16",
            "x*(8*x**4-40*x**2*y**2-40*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/8",
            "[-3*sqrt(7)/16,0,sqrt(35)/16,0,-sqrt(30)/16,0,sqrt(30)/16,0,-sqrt(35)/16,0,3*sqrt(7)/16]",
        ),
        "Gh(5,Eg,1,1)": (
            "sqrt(15)*S1/8+sqrt(70)*S3/16+3*sqrt(14)*S5/16",
            "y*(15*x**4-40*x**2*y**2+30*x**2*z**2+8*y**4-40*y**2*z**2+15*z**4)/8",
            "[3*sqrt(7)*I/16,0,sqrt(35)*I/16,0,sqrt(30)*I/16,0,sqrt(30)*I/16,0,sqrt(35)*I/16,0,3*sqrt(7)*I/16]",
        ),
        "Gh(5,Eg,2,0)": (
            "sqrt(2)*(sqrt(42)*C1+9*C3+sqrt(5)*C5)/16",
            "3*sqrt(35)*x*(y**4-6*y**2*z**2+z**4)/8",
            "[-sqrt(5)/16,0,-9/16,0,-sqrt(42)/16,0,sqrt(42)/16,0,9/16,0,sqrt(5)/16]",
        ),
        "Gh(5,Eg,2,1)": (
            "sqrt(2)*(sqrt(42)*S1-9*S3+sqrt(5)*S5)/16",
            "3*sqrt(35)*y*(x**4-6*x**2*z**2+z**4)/8",
            "[sqrt(5)*I/16,0,-9*I/16,0,sqrt(42)*I/16,0,sqrt(42)*I/16,0,-9*I/16,0,sqrt(5)*I/16]",
        ),
        "Gh(5,Eg,3,0)": (
            "sqrt(7)*C1/4-sqrt(6)*C3/8-sqrt(30)*C5/8",
            "sqrt(105)*x*(2*x**2*y**2-2*x**2*z**2-y**4+z**4)/4",
            "[sqrt(15)/8,0,sqrt(3)/8,0,-sqrt(14)/8,0,sqrt(14)/8,0,-sqrt(3)/8,0,-sqrt(15)/8]",
        ),
        "Gh(5,Eg,3,1)": (
            "sqrt(7)*S1/4+sqrt(6)*S3/8-sqrt(30)*S5/8",
            "sqrt(105)*y*(-x**4+2*x**2*y**2-2*y**2*z**2+z**4)/4",
            "[-sqrt(15)*I/8,0,sqrt(3)*I/8,0,sqrt(14)*I/8,0,sqrt(14)*I/8,0,sqrt(3)*I/8,0,-sqrt(15)*I/8]",
        ),
        "Gh(6,Au,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Gh(6,Au,2,)": (
            "sqrt(14)*C0/4+sqrt(2)*C4/4",
            "-sqrt(14)*(x**6-15*x**4*z**2+15*x**2*z**4+y**6-15*y**4*z**2+15*y**2*z**4-2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Gh(6,Au,3,)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(6,Bu,1,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Gh(6,Bu,2,)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x-y)*(x+y)*(x**4-9*x**2*y**2-5*x**2*z**2+y**4-5*y**2*z**2+5*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Gh(6,Bu,3,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Gh(6,Bu,4,)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(6,Eu,1,0)": (
            "sqrt(3)*S1/4-sqrt(30)*S3/8-sqrt(22)*S5/8",
            "3*sqrt(7)*y*z*(10*x**2*y**2-10*x**2*z**2-y**4+z**4)/4",
            "[0,-sqrt(11)*I/8,0,-sqrt(15)*I/8,0,sqrt(6)*I/8,0,sqrt(6)*I/8,0,-sqrt(15)*I/8,0,-sqrt(11)*I/8,0]",
        ),
        "Gh(6,Eu,1,1)": (
            "-sqrt(3)*C1/4-sqrt(30)*C3/8+sqrt(22)*C5/8",
            "3*sqrt(7)*x*z*(x**4-10*x**2*y**2+10*y**2*z**2-z**4)/4",
            "[0,-sqrt(11)/8,0,sqrt(15)/8,0,sqrt(6)/8,0,-sqrt(6)/8,0,-sqrt(15)/8,0,sqrt(11)/8,0]",
        ),
        "Gh(6,Eu,2,0)": (
            "3*sqrt(22)*S1/16+sqrt(55)*S3/16+sqrt(3)*S5/16",
            "sqrt(462)*y*z*(3*y**4-10*y**2*z**2+3*z**4)/16",
            "[0,sqrt(6)*I/32,0,sqrt(110)*I/32,0,3*sqrt(11)*I/16,0,3*sqrt(11)*I/16,0,sqrt(110)*I/32,0,sqrt(6)*I/32,0]",
        ),
        "Gh(6,Eu,2,1)": (
            "-3*sqrt(22)*C1/16+sqrt(55)*C3/16-sqrt(3)*C5/16",
            "sqrt(462)*x*z*(-3*x**4+10*x**2*z**2-3*z**4)/16",
            "[0,sqrt(6)/32,0,-sqrt(110)/32,0,3*sqrt(11)/16,0,-3*sqrt(11)/16,0,sqrt(110)/32,0,-sqrt(6)/32,0]",
        ),
        "Gh(6,Eu,3,0)": (
            "sqrt(10)*S1/16-9*S3/16+sqrt(165)*S5/16",
            "sqrt(210)*y*z*(16*x**4-16*x**2*y**2-16*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,sqrt(330)*I/32,0,-9*sqrt(2)*I/32,0,sqrt(5)*I/16,0,sqrt(5)*I/16,0,-9*sqrt(2)*I/32,0,sqrt(330)*I/32,0]",
        ),
        "Gh(6,Eu,3,1)": (
            "-sqrt(10)*C1/16-9*C3/16-sqrt(165)*C5/16",
            "sqrt(210)*x*z*(-x**4+16*x**2*y**2-2*x**2*z**2-16*y**4+16*y**2*z**2-z**4)/16",
            "[0,sqrt(330)/32,0,9*sqrt(2)/32,0,sqrt(5)/16,0,-sqrt(5)/16,0,-9*sqrt(2)/32,0,-sqrt(330)/32,0]",
        ),
        "Gh(7,Ag,1,)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(7,Ag,2,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Gh(7,Ag,3,)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(7,Bg,1,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Gh(7,Bg,2,)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "-sqrt(77)*x*y*z*(3*x**4-20*x**2*y**2+10*x**2*z**2+3*y**4+10*y**2*z**2-6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Gh(7,Bg,3,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(7,Bg,4,)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(7,Eg,1,0)": (
            "-5*sqrt(7)*C1/32+3*sqrt(21)*C3/32-sqrt(231)*C5/32+sqrt(429)*C7/32",
            "x*(16*x**6-168*x**4*y**2-168*x**4*z**2+210*x**2*y**4+420*x**2*y**2*z**2+210*x**2*z**4-35*y**6-105*y**4*z**2-105*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)/64,0,sqrt(462)/64,0,-3*sqrt(42)/64,0,5*sqrt(14)/64,0,-5*sqrt(14)/64,0,3*sqrt(42)/64,0,-sqrt(462)/64,0,sqrt(858)/64]",
        ),
        "Gh(7,Eg,1,1)": (
            "-5*sqrt(7)*S1/32-3*sqrt(21)*S3/32-sqrt(231)*S5/32-sqrt(429)*S7/32",
            "y*(-35*x**6+210*x**4*y**2-105*x**4*z**2-168*x**2*y**4+420*x**2*y**2*z**2-105*x**2*z**4+16*y**6-168*y**4*z**2+210*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)*I/64,0,-sqrt(462)*I/64,0,-3*sqrt(42)*I/64,0,-5*sqrt(14)*I/64,0,-5*sqrt(14)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(462)*I/64,0,-sqrt(858)*I/64]",
        ),
        "Gh(7,Eg,2,0)": (
            "-3*sqrt(33)*C1/32-sqrt(11)*C3/32+25*C5/32+sqrt(91)*C7/32",
            "sqrt(231)*x*(10*x**2*y**4-60*x**2*y**2*z**2+10*x**2*z**4-3*y**6+15*y**4*z**2+15*y**2*z**4-3*z**6)/16",
            "[-sqrt(182)/64,0,-25*sqrt(2)/64,0,sqrt(22)/64,0,3*sqrt(66)/64,0,-3*sqrt(66)/64,0,-sqrt(22)/64,0,25*sqrt(2)/64,0,sqrt(182)/64]",
        ),
        "Gh(7,Eg,2,1)": (
            "-3*sqrt(33)*S1/32+sqrt(11)*S3/32+25*S5/32-sqrt(91)*S7/32",
            "sqrt(231)*y*(-3*x**6+10*x**4*y**2+15*x**4*z**2-60*x**2*y**2*z**2+15*x**2*z**4+10*y**2*z**4-3*z**6)/16",
            "[-sqrt(182)*I/64,0,25*sqrt(2)*I/64,0,sqrt(22)*I/64,0,-3*sqrt(66)*I/64,0,-3*sqrt(66)*I/64,0,sqrt(22)*I/64,0,25*sqrt(2)*I/64,0,-sqrt(182)*I/64]",
        ),
        "Gh(7,Eg,3,0)": (
            "-sqrt(858)*C1/64-3*sqrt(286)*C3/64-5*sqrt(26)*C5/64-sqrt(14)*C7/64",
            "sqrt(6006)*x*(y**6-15*y**4*z**2+15*y**2*z**4-z**6)/32",
            "[sqrt(7)/64,0,5*sqrt(13)/64,0,3*sqrt(143)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-3*sqrt(143)/64,0,-5*sqrt(13)/64,0,-sqrt(7)/64]",
        ),
        "Gh(7,Eg,3,1)": (
            "-sqrt(858)*S1/64+3*sqrt(286)*S3/64-5*sqrt(26)*S5/64+sqrt(14)*S7/64",
            "sqrt(6006)*y*(x**6-15*x**4*z**2+15*x**2*z**4-z**6)/32",
            "[sqrt(7)*I/64,0,-5*sqrt(13)*I/64,0,3*sqrt(143)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,3*sqrt(143)*I/64,0,-5*sqrt(13)*I/64,0,sqrt(7)*I/64]",
        ),
        "Gh(7,Eg,4,0)": (
            "sqrt(2)*(-15*sqrt(3)*C1+19*C3-sqrt(11)*C5-sqrt(1001)*C7)/64",
            "sqrt(42)*x*(48*x**4*y**2-48*x**4*z**2-80*x**2*y**4+80*x**2*z**4+15*y**6+15*y**4*z**2-15*y**2*z**4-15*z**6)/32",
            "[sqrt(1001)/64,0,sqrt(11)/64,0,-19/64,0,15*sqrt(3)/64,0,-15*sqrt(3)/64,0,19/64,0,-sqrt(11)/64,0,-sqrt(1001)/64]",
        ),
        "Gh(7,Eg,4,1)": (
            "-15*sqrt(6)*S1/64-19*sqrt(2)*S3/64-sqrt(22)*S5/64+sqrt(2002)*S7/64",
            "sqrt(42)*y*(15*x**6-80*x**4*y**2+15*x**4*z**2+48*x**2*y**4-15*x**2*z**4-48*y**4*z**2+80*y**2*z**4-15*z**6)/32",
            "[sqrt(1001)*I/64,0,-sqrt(11)*I/64,0,-19*I/64,0,-15*sqrt(3)*I/64,0,-15*sqrt(3)*I/64,0,-19*I/64,0,-sqrt(11)*I/64,0,sqrt(1001)*I/64]",
        ),
        "Gh(8,Au,1,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Gh(8,Au,2,)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Gh(8,Au,3,)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Gh(8,Au,4,)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(8,Au,5,)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(8,Bu,1,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(8,Bu,2,)": (
            "C2",
            "-3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(8,Bu,3,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(8,Bu,4,)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(8,Eu,1,0)": (
            "-sqrt(715)*S1/32-sqrt(273)*S3/32-sqrt(35)*S5/32-S7/32",
            "3*sqrt(715)*y*z*(y**6-7*y**4*z**2+7*y**2*z**4-z**6)/16",
            "[0,-sqrt(2)*I/64,0,-sqrt(70)*I/64,0,-sqrt(546)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(546)*I/64,0,-sqrt(70)*I/64,0,-sqrt(2)*I/64,0]",
        ),
        "Gh(8,Eu,1,1)": (
            "sqrt(715)*C1/32-sqrt(273)*C3/32+sqrt(35)*C5/32-C7/32",
            "3*sqrt(715)*x*z*(-x**6+7*x**4*z**2-7*x**2*z**4+z**6)/16",
            "[0,sqrt(2)/64,0,-sqrt(70)/64,0,sqrt(546)/64,0,-sqrt(1430)/64,0,sqrt(1430)/64,0,-sqrt(546)/64,0,sqrt(70)/64,0,-sqrt(2)/64,0]",
        ),
        "Gh(8,Eu,2,0)": (
            "-sqrt(77)*S1/32+5*sqrt(15)*S3/32-3*sqrt(13)*S5/32-sqrt(455)*S7/32",
            "3*sqrt(77)*y*z*(40*x**4*y**2-40*x**4*z**2-24*x**2*y**4+24*x**2*z**4+y**6+y**4*z**2-y**2*z**4-z**6)/16",
            "[0,-sqrt(910)*I/64,0,-3*sqrt(26)*I/64,0,5*sqrt(30)*I/64,0,-sqrt(154)*I/64,0,-sqrt(154)*I/64,0,5*sqrt(30)*I/64,0,-3*sqrt(26)*I/64,0,-sqrt(910)*I/64,0]",
        ),
        "Gh(8,Eu,2,1)": (
            "sqrt(77)*C1/32+5*sqrt(15)*C3/32+3*sqrt(13)*C5/32-sqrt(455)*C7/32",
            "3*sqrt(77)*x*z*(-x**6+24*x**4*y**2-x**4*z**2-40*x**2*y**4+x**2*z**4+40*y**4*z**2-24*y**2*z**4+z**6)/16",
            "[0,sqrt(910)/64,0,-3*sqrt(26)/64,0,-5*sqrt(30)/64,0,-sqrt(154)/64,0,sqrt(154)/64,0,5*sqrt(30)/64,0,3*sqrt(26)/64,0,-sqrt(910)/64,0]",
        ),
        "Gh(8,Eu,3,0)": (
            "-sqrt(858)*S1/64+sqrt(910)*S3/64+7*sqrt(42)*S5/64+3*sqrt(30)*S7/64",
            "sqrt(858)*y*z*(42*x**2*y**4-140*x**2*y**2*z**2+42*x**2*z**4-3*y**6+7*y**4*z**2+7*y**2*z**4-3*z**6)/32",
            "[0,3*sqrt(15)*I/64,0,7*sqrt(21)*I/64,0,sqrt(455)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(455)*I/64,0,7*sqrt(21)*I/64,0,3*sqrt(15)*I/64,0]",
        ),
        "Gh(8,Eu,3,1)": (
            "sqrt(858)*C1/64+sqrt(910)*C3/64-7*sqrt(42)*C5/64+3*sqrt(30)*C7/64",
            "sqrt(858)*x*z*(3*x**6-42*x**4*y**2-7*x**4*z**2+140*x**2*y**2*z**2-7*x**2*z**4-42*y**2*z**4+3*z**6)/32",
            "[0,-3*sqrt(15)/64,0,7*sqrt(21)/64,0,-sqrt(455)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(455)/64,0,-7*sqrt(21)/64,0,3*sqrt(15)/64,0]",
        ),
        "Gh(8,Eu,4,0)": (
            "-sqrt(70)*S1/64+3*sqrt(66)*S3/64-sqrt(1430)*S5/64+sqrt(2002)*S7/64",
            "3*sqrt(70)*y*z*(32*x**6-80*x**4*y**2-80*x**4*z**2+30*x**2*y**4+60*x**2*y**2*z**2+30*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,sqrt(1001)*I/64,0,-sqrt(715)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(35)*I/64,0,-sqrt(35)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(715)*I/64,0,sqrt(1001)*I/64,0]",
        ),
        "Gh(8,Eu,4,1)": (
            "sqrt(70)*C1/64+3*sqrt(66)*C3/64+sqrt(1430)*C5/64+sqrt(2002)*C7/64",
            "3*sqrt(70)*x*z*(x**6-30*x**4*y**2+3*x**4*z**2+80*x**2*y**4-60*x**2*y**2*z**2+3*x**2*z**4-32*y**6+80*y**4*z**2-30*y**2*z**4+z**6)/32",
            "[0,-sqrt(1001)/64,0,-sqrt(715)/64,0,-3*sqrt(33)/64,0,-sqrt(35)/64,0,sqrt(35)/64,0,3*sqrt(33)/64,0,sqrt(715)/64,0,sqrt(1001)/64,0]",
        ),
        "Gh(9,Ag,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Gh(9,Ag,2,)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(x-y)*(x+y)*(3*x**4-11*x**2*y**2-7*x**2*z**2+3*y**4-7*y**2*z**2+7*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Gh(9,Ag,3,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(9,Ag,4,)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(9,Ag,5,)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(9,Bg,1,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Gh(9,Bg,2,)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Gh(9,Bg,3,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(9,Bg,4,)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(9,Eg,1,0)": (
            "21*sqrt(5)*C1/128-sqrt(2310)*C3/128+3*sqrt(286)*C5/128-3*sqrt(1430)*C7/256+sqrt(24310)*C9/256",
            "x*(128*x**8-2304*x**6*y**2-2304*x**6*z**2+6048*x**4*y**4+12096*x**4*y**2*z**2+6048*x**4*z**4-3360*x**2*y**6-10080*x**2*y**4*z**2-10080*x**2*y**2*z**4-3360*x**2*z**6+315*y**8+1260*y**6*z**2+1890*y**4*z**4+1260*y**2*z**6+315*z**8)/128",
            "[-sqrt(12155)/256,0,3*sqrt(715)/256,0,-3*sqrt(143)/128,0,sqrt(1155)/128,0,-21*sqrt(10)/256,0,21*sqrt(10)/256,0,-sqrt(1155)/128,0,3*sqrt(143)/128,0,-3*sqrt(715)/256,0,sqrt(12155)/256]",
        ),
        "Gh(9,Eg,1,1)": (
            "21*sqrt(5)*S1/128+sqrt(2310)*S3/128+3*sqrt(286)*S5/128+3*sqrt(1430)*S7/256+sqrt(24310)*S9/256",
            "y*(315*x**8-3360*x**6*y**2+1260*x**6*z**2+6048*x**4*y**4-10080*x**4*y**2*z**2+1890*x**4*z**4-2304*x**2*y**6+12096*x**2*y**4*z**2-10080*x**2*y**2*z**4+1260*x**2*z**6+128*y**8-2304*y**6*z**2+6048*y**4*z**4-3360*y**2*z**6+315*z**8)/128",
            "[sqrt(12155)*I/256,0,3*sqrt(715)*I/256,0,3*sqrt(143)*I/128,0,sqrt(1155)*I/128,0,21*sqrt(10)*I/256,0,21*sqrt(10)*I/256,0,sqrt(1155)*I/128,0,3*sqrt(143)*I/128,0,3*sqrt(715)*I/256,0,sqrt(12155)*I/256]",
        ),
        "Gh(9,Eg,2,0)": (
            "sqrt(2)*(sqrt(4862)*C1+2*sqrt(4641)*C3+10*sqrt(85)*C5+7*sqrt(17)*C7+3*C9)/256",
            "3*sqrt(12155)*x*(y**8-28*y**6*z**2+70*y**4*z**4-28*y**2*z**6+z**8)/128",
            "[-3/256,0,-7*sqrt(17)/256,0,-5*sqrt(85)/128,0,-sqrt(4641)/128,0,-sqrt(4862)/256,0,sqrt(4862)/256,0,sqrt(4641)/128,0,5*sqrt(85)/128,0,7*sqrt(17)/256,0,3/256]",
        ),
        "Gh(9,Eg,2,1)": (
            "sqrt(2)*(sqrt(4862)*S1-2*sqrt(4641)*S3+10*sqrt(85)*S5-7*sqrt(17)*S7+3*S9)/256",
            "3*sqrt(12155)*y*(x**8-28*x**6*z**2+70*x**4*z**4-28*x**2*z**6+z**8)/128",
            "[3*I/256,0,-7*sqrt(17)*I/256,0,5*sqrt(85)*I/128,0,-sqrt(4641)*I/128,0,sqrt(4862)*I/256,0,sqrt(4862)*I/256,0,-sqrt(4641)*I/128,0,5*sqrt(85)*I/128,0,-7*sqrt(17)*I/256,0,3*I/256]",
        ),
        "Gh(9,Eg,3,0)": (
            "sqrt(1001)*C1/64-sqrt(78)*C3/64-3*sqrt(70)*C5/64+23*sqrt(14)*C7/128+3*sqrt(238)*C9/128",
            "3*sqrt(5005)*x*(8*x**4*y**4-48*x**4*y**2*z**2+8*x**4*z**4-8*x**2*y**6+40*x**2*y**4*z**2+40*x**2*y**2*z**4-8*x**2*z**6+y**8-4*y**6*z**2-10*y**4*z**4-4*y**2*z**6+z**8)/64",
            "[-3*sqrt(119)/128,0,-23*sqrt(7)/128,0,3*sqrt(35)/64,0,sqrt(39)/64,0,-sqrt(2002)/128,0,sqrt(2002)/128,0,-sqrt(39)/64,0,-3*sqrt(35)/64,0,23*sqrt(7)/128,0,3*sqrt(119)/128]",
        ),
        "Gh(9,Eg,3,1)": (
            "sqrt(1001)*S1/64+sqrt(78)*S3/64-3*sqrt(70)*S5/64-23*sqrt(14)*S7/128+3*sqrt(238)*S9/128",
            "3*sqrt(5005)*y*(x**8-8*x**6*y**2-4*x**6*z**2+8*x**4*y**4+40*x**4*y**2*z**2-10*x**4*z**4-48*x**2*y**4*z**2+40*x**2*y**2*z**4-4*x**2*z**6+8*y**4*z**4-8*y**2*z**6+z**8)/64",
            "[3*sqrt(119)*I/128,0,-23*sqrt(7)*I/128,0,-3*sqrt(35)*I/64,0,sqrt(39)*I/64,0,sqrt(2002)*I/128,0,sqrt(2002)*I/128,0,sqrt(39)*I/64,0,-3*sqrt(35)*I/64,0,-23*sqrt(7)*I/128,0,3*sqrt(119)*I/128]",
        ),
        "Gh(9,Eg,4,0)": (
            "sqrt(858)*C1/64+sqrt(91)*C3/32-5*sqrt(15)*C5/32-21*sqrt(3)*C7/64-sqrt(51)*C9/64",
            "sqrt(4290)*x*(14*x**2*y**6-210*x**2*y**4*z**2+210*x**2*y**2*z**4-14*x**2*z**6-3*y**8+42*y**6*z**2-42*y**2*z**6+3*z**8)/64",
            "[sqrt(102)/128,0,21*sqrt(6)/128,0,5*sqrt(30)/64,0,-sqrt(182)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(182)/64,0,-5*sqrt(30)/64,0,-21*sqrt(6)/128,0,-sqrt(102)/128]",
        ),
        "Gh(9,Eg,4,1)": (
            "sqrt(858)*S1/64-sqrt(91)*S3/32-5*sqrt(15)*S5/32+21*sqrt(3)*S7/64-sqrt(51)*S9/64",
            "sqrt(4290)*y*(-3*x**8+14*x**6*y**2+42*x**6*z**2-210*x**4*y**2*z**2+210*x**2*y**2*z**4-42*x**2*z**6-14*y**2*z**6+3*z**8)/64",
            "[-sqrt(102)*I/128,0,21*sqrt(6)*I/128,0,-5*sqrt(30)*I/64,0,-sqrt(182)*I/64,0,sqrt(429)*I/64,0,sqrt(429)*I/64,0,-sqrt(182)*I/64,0,-5*sqrt(30)*I/64,0,21*sqrt(6)*I/128,0,-sqrt(102)*I/128]",
        ),
        "Gh(9,Eg,5,0)": (
            "7*sqrt(22)*C1/64-3*sqrt(21)*C3/32+sqrt(65)*C5/32+sqrt(13)*C7/64-3*sqrt(221)*C9/64",
            "3*sqrt(110)*x*(32*x**6*y**2-32*x**6*z**2-112*x**4*y**4+112*x**4*z**4+70*x**2*y**6+70*x**2*y**4*z**2-70*x**2*y**2*z**4-70*x**2*z**6-7*y**8-14*y**6*z**2+14*y**2*z**6+7*z**8)/64",
            "[3*sqrt(442)/128,0,-sqrt(26)/128,0,-sqrt(130)/64,0,3*sqrt(42)/64,0,-7*sqrt(11)/64,0,7*sqrt(11)/64,0,-3*sqrt(42)/64,0,sqrt(130)/64,0,sqrt(26)/128,0,-3*sqrt(442)/128]",
        ),
        "Gh(9,Eg,5,1)": (
            "7*sqrt(22)*S1/64+3*sqrt(21)*S3/32+sqrt(65)*S5/32-sqrt(13)*S7/64-3*sqrt(221)*S9/64",
            "3*sqrt(110)*y*(-7*x**8+70*x**6*y**2-14*x**6*z**2-112*x**4*y**4+70*x**4*y**2*z**2+32*x**2*y**6-70*x**2*y**2*z**4+14*x**2*z**6-32*y**6*z**2+112*y**4*z**4-70*y**2*z**6+7*z**8)/64",
            "[-3*sqrt(442)*I/128,0,-sqrt(26)*I/128,0,sqrt(130)*I/64,0,3*sqrt(42)*I/64,0,7*sqrt(11)*I/64,0,7*sqrt(11)*I/64,0,3*sqrt(42)*I/64,0,sqrt(130)*I/64,0,-sqrt(26)*I/128,0,-3*sqrt(442)*I/128]",
        ),
        "Gh(10,Au,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Gh(10,Au,2,)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "-sqrt(420189)*(22*x**10+45*x**8*y**2-1035*x**8*z**2-105*x**6*y**4-630*x**6*y**2*z**2+4935*x**6*z**4-105*x**4*y**6+3150*x**4*y**4*z**2-1575*x**4*y**2*z**4-4830*x**4*z**6+45*x**2*y**8-630*x**2*y**6*z**2-1575*x**2*y**4*z**4+1260*x**2*y**2*z**6+990*x**2*z**8+22*y**10-1035*y**8*z**2+4935*y**6*z**4-4830*y**4*z**6+990*y**2*z**8-44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Gh(10,Au,3,)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "-sqrt(3213210)*(3*x**10-96*x**8*y**2-39*x**8*z**2+224*x**6*y**4+1344*x**6*y**2*z**2-42*x**6*z**4+224*x**4*y**6-6720*x**4*y**4*z**2+3360*x**4*y**2*z**4-182*x**4*z**6-96*x**2*y**8+1344*x**2*y**6*z**2+3360*x**2*y**4*z**4-2688*x**2*y**2*z**6+135*x**2*z**8+3*y**10-39*y**8*z**2-42*y**6*z**4-182*y**4*z**6+135*y**2*z**8-6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Gh(10,Au,4,)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(10,Au,5,)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(10,Bu,1,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Gh(10,Bu,2,)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(x-y)*(x+y)*(22*x**8-653*x**6*y**2-315*x**6*z**2+2602*x**4*y**4-945*x**4*y**2*z**2+1575*x**4*z**4-653*x**2*y**6-945*x**2*y**4*z**2+3150*x**2*y**2*z**4-1680*x**2*z**6+22*y**8-315*y**6*z**2+1575*y**4*z**4-1680*y**2*z**6+360*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Gh(10,Bu,3,)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(x-y)*(x+y)*(9*x**8-165*x**6*y**2-231*x**6*z**2-25*x**4*y**4+3801*x**4*y**2*z**2+406*x**4*z**4-165*x**2*y**6+3801*x**2*y**4*z**2-9674*x**2*y**2*z**4+266*x**2*z**6+9*y**8-231*y**6*z**2+406*y**4*z**4+266*y**2*z**6-57*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Gh(10,Bu,4,)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(10,Bu,5,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(10,Bu,6,)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(10,Eu,1,0)": (
            "sqrt(221)*S1/32-sqrt(102)*S3/32-sqrt(510)*S5/32-11*sqrt(6)*S7/64-sqrt(38)*S9/64",
            "sqrt(12155)*y*z*(18*x**2*y**6-126*x**2*y**4*z**2+126*x**2*y**2*z**4-18*x**2*z**6-y**8+6*y**6*z**2-6*y**2*z**6+z**8)/32",
            "[0,-sqrt(19)*I/64,0,-11*sqrt(3)*I/64,0,-sqrt(255)*I/32,0,-sqrt(51)*I/32,0,sqrt(442)*I/64,0,sqrt(442)*I/64,0,-sqrt(51)*I/32,0,-sqrt(255)*I/32,0,-11*sqrt(3)*I/64,0,-sqrt(19)*I/64,0]",
        ),
        "Gh(10,Eu,1,1)": (
            "-sqrt(221)*C1/32-sqrt(102)*C3/32+sqrt(510)*C5/32-11*sqrt(6)*C7/64+sqrt(38)*C9/64",
            "sqrt(12155)*x*z*(x**8-18*x**6*y**2-6*x**6*z**2+126*x**4*y**2*z**2-126*x**2*y**2*z**4+6*x**2*z**6+18*y**2*z**6-z**8)/32",
            "[0,-sqrt(19)/64,0,11*sqrt(3)/64,0,-sqrt(255)/32,0,sqrt(51)/32,0,sqrt(442)/64,0,-sqrt(442)/64,0,-sqrt(51)/32,0,sqrt(255)/32,0,-11*sqrt(3)/64,0,sqrt(19)/64,0]",
        ),
        "Gh(10,Eu,2,0)": (
            "sqrt(2)*(sqrt(78)*S1-22*S3+10*sqrt(5)*S5-sqrt(17)*S7-sqrt(969)*S9)/64",
            "sqrt(2145)*y*z*(112*x**6*y**2-112*x**6*z**2-168*x**4*y**4+168*x**4*z**4+42*x**2*y**6+42*x**2*y**4*z**2-42*x**2*y**2*z**4-42*x**2*z**6-y**8-2*y**6*z**2+2*y**2*z**6+z**8)/32",
            "[0,-sqrt(969)*I/64,0,-sqrt(17)*I/64,0,5*sqrt(5)*I/32,0,-11*I/32,0,sqrt(78)*I/64,0,sqrt(78)*I/64,0,-11*I/32,0,5*sqrt(5)*I/32,0,-sqrt(17)*I/64,0,-sqrt(969)*I/64,0]",
        ),
        "Gh(10,Eu,2,1)": (
            "-sqrt(2)*(sqrt(78)*C1+22*C3+10*sqrt(5)*C5+sqrt(17)*C7-sqrt(969)*C9)/64",
            "sqrt(2145)*x*z*(x**8-42*x**6*y**2+2*x**6*z**2+168*x**4*y**4-42*x**4*y**2*z**2-112*x**2*y**6+42*x**2*y**2*z**4-2*x**2*z**6+112*y**6*z**2-168*y**4*z**4+42*y**2*z**6-z**8)/32",
            "[0,-sqrt(969)/64,0,sqrt(17)/64,0,5*sqrt(5)/32,0,11/32,0,sqrt(78)/64,0,-sqrt(78)/64,0,-11/32,0,-5*sqrt(5)/32,0,-sqrt(17)/64,0,sqrt(969)/64,0]",
        ),
        "Gh(10,Eu,3,0)": (
            "sqrt(41990)*S1/256+sqrt(4845)*S3/128+sqrt(969)*S5/128+sqrt(285)*S7/256+sqrt(5)*S9/256",
            "sqrt(92378)*y*z*(5*y**8-60*y**6*z**2+126*y**4*z**4-60*y**2*z**6+5*z**8)/256",
            "[0,sqrt(10)*I/512,0,sqrt(570)*I/512,0,sqrt(1938)*I/256,0,sqrt(9690)*I/256,0,sqrt(20995)*I/256,0,sqrt(20995)*I/256,0,sqrt(9690)*I/256,0,sqrt(1938)*I/256,0,sqrt(570)*I/512,0,sqrt(10)*I/512,0]",
        ),
        "Gh(10,Eu,3,1)": (
            "-sqrt(41990)*C1/256+sqrt(4845)*C3/128-sqrt(969)*C5/128+sqrt(285)*C7/256-sqrt(5)*C9/256",
            "sqrt(92378)*x*z*(-5*x**8+60*x**6*z**2-126*x**4*z**4+60*x**2*z**6-5*z**8)/256",
            "[0,sqrt(10)/512,0,-sqrt(570)/512,0,sqrt(1938)/256,0,-sqrt(9690)/256,0,sqrt(20995)/256,0,-sqrt(20995)/256,0,sqrt(9690)/256,0,-sqrt(1938)/256,0,sqrt(570)/512,0,-sqrt(10)/512,0]",
        ),
        "Gh(10,Eu,4,0)": (
            "9*sqrt(78)*S1/256-69*S3/128-sqrt(5)*S5/128+43*sqrt(17)*S7/256+3*sqrt(969)*S9/256",
            "sqrt(4290)*y*z*(672*x**4*y**4-2240*x**4*y**2*z**2+672*x**4*z**4-288*x**2*y**6+672*x**2*y**4*z**2+672*x**2*y**2*z**4-288*x**2*z**6+9*y**8-12*y**6*z**2-42*y**4*z**4-12*y**2*z**6+9*z**8)/256",
            "[0,3*sqrt(1938)*I/512,0,43*sqrt(34)*I/512,0,-sqrt(10)*I/256,0,-69*sqrt(2)*I/256,0,9*sqrt(39)*I/256,0,9*sqrt(39)*I/256,0,-69*sqrt(2)*I/256,0,-sqrt(10)*I/256,0,43*sqrt(34)*I/512,0,3*sqrt(1938)*I/512,0]",
        ),
        "Gh(10,Eu,4,1)": (
            "-9*sqrt(78)*C1/256-69*C3/128+sqrt(5)*C5/128+43*sqrt(17)*C7/256-3*sqrt(969)*C9/256",
            "sqrt(4290)*x*z*(-9*x**8+288*x**6*y**2+12*x**6*z**2-672*x**4*y**4-672*x**4*y**2*z**2+42*x**4*z**4+2240*x**2*y**4*z**2-672*x**2*y**2*z**4+12*x**2*z**6-672*y**4*z**4+288*y**2*z**6-9*z**8)/256",
            "[0,3*sqrt(1938)/512,0,-43*sqrt(34)/512,0,-sqrt(10)/256,0,69*sqrt(2)/256,0,9*sqrt(39)/256,0,-9*sqrt(39)/256,0,-69*sqrt(2)/256,0,sqrt(10)/256,0,43*sqrt(34)/512,0,-3*sqrt(1938)/512,0]",
        ),
        "Gh(10,Eu,5,0)": (
            "7*sqrt(3)*S1/128-7*sqrt(26)*S3/128+5*sqrt(130)*S5/128-7*sqrt(442)*S7/256+sqrt(25194)*S9/256",
            "sqrt(165)*y*z*(384*x**8-1792*x**6*y**2-1792*x**6*z**2+1680*x**4*y**4+3360*x**4*y**2*z**2+1680*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+7*y**8+28*y**6*z**2+42*y**4*z**4+28*y**2*z**6+7*z**8)/128",
            "[0,sqrt(12597)*I/256,0,-7*sqrt(221)*I/256,0,5*sqrt(65)*I/128,0,-7*sqrt(13)*I/128,0,7*sqrt(6)*I/256,0,7*sqrt(6)*I/256,0,-7*sqrt(13)*I/128,0,5*sqrt(65)*I/128,0,-7*sqrt(221)*I/256,0,sqrt(12597)*I/256,0]",
        ),
        "Gh(10,Eu,5,1)": (
            "-7*sqrt(3)*C1/128-7*sqrt(26)*C3/128-5*sqrt(130)*C5/128-7*sqrt(442)*C7/256-sqrt(25194)*C9/256",
            "sqrt(165)*x*z*(-7*x**8+336*x**6*y**2-28*x**6*z**2-1680*x**4*y**4+1008*x**4*y**2*z**2-42*x**4*z**4+1792*x**2*y**6-3360*x**2*y**4*z**2+1008*x**2*y**2*z**4-28*x**2*z**6-384*y**8+1792*y**6*z**2-1680*y**4*z**4+336*y**2*z**6-7*z**8)/128",
            "[0,sqrt(12597)/256,0,7*sqrt(221)/256,0,5*sqrt(65)/128,0,7*sqrt(13)/128,0,7*sqrt(6)/256,0,-7*sqrt(6)/256,0,-7*sqrt(13)/128,0,-5*sqrt(65)/128,0,-7*sqrt(221)/256,0,-sqrt(12597)/256,0]",
        ),
        "Gh(11,Ag,1,)": (
            "S8",
            "-sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(11,Ag,2,)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(11,Ag,3,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,Ag,4,)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(11,Ag,5,)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(11,Bg,1,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Gh(11,Bg,2,)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "-sqrt(230945)*x*y*z*(x**8-6*x**6*y**2-6*x**6*z**2+42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2-84*x**2*y**2*z**4+12*x**2*z**6+y**8-6*y**6*z**2+12*y**2*z**6-2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Gh(11,Bg,3,)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "-sqrt(3003)*x*y*z*(5*x**8-150*x**6*y**2+90*x**6*z**2+336*x**4*y**4-70*x**4*y**2*z**2-168*x**4*z**4-150*x**2*y**6-70*x**2*y**4*z**2+140*x**2*y**2*z**4+60*x**2*z**6+5*y**8+90*y**6*z**2-168*y**4*z**4+60*y**2*z**6-10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Gh(11,Bg,4,)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(11,Bg,5,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(11,Bg,6,)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,Eg,1,0)": (
            "-21*sqrt(66)*C1/512+sqrt(88179)*C11/512+sqrt(30030)*C3/512-15*sqrt(143)*C5/512+sqrt(36465)*C7/512-sqrt(46189)*C9/512",
            "x*(256*x**10-7040*x**8*y**2-7040*x**8*z**2+31680*x**6*y**4+63360*x**6*y**2*z**2+31680*x**6*z**4-36960*x**4*y**6-110880*x**4*y**4*z**2-110880*x**4*y**2*z**4-36960*x**4*z**6+11550*x**2*y**8+46200*x**2*y**6*z**2+69300*x**2*y**4*z**4+46200*x**2*y**2*z**6+11550*x**2*z**8-693*y**10-3465*y**8*z**2-6930*y**6*z**4-6930*y**4*z**6-3465*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)/1024,0,sqrt(92378)/1024,0,-sqrt(72930)/1024,0,15*sqrt(286)/1024,0,-sqrt(15015)/512,0,21*sqrt(33)/512,0,-21*sqrt(33)/512,0,sqrt(15015)/512,0,-15*sqrt(286)/1024,0,sqrt(72930)/1024,0,-sqrt(92378)/1024,0,sqrt(176358)/1024]",
        ),
        "Gh(11,Eg,1,1)": (
            "-21*sqrt(66)*S1/512-sqrt(88179)*S11/512-sqrt(30030)*S3/512-15*sqrt(143)*S5/512-sqrt(36465)*S7/512-sqrt(46189)*S9/512",
            "y*(-693*x**10+11550*x**8*y**2-3465*x**8*z**2-36960*x**6*y**4+46200*x**6*y**2*z**2-6930*x**6*z**4+31680*x**4*y**6-110880*x**4*y**4*z**2+69300*x**4*y**2*z**4-6930*x**4*z**6-7040*x**2*y**8+63360*x**2*y**6*z**2-110880*x**2*y**4*z**4+46200*x**2*y**2*z**6-3465*x**2*z**8+256*y**10-7040*y**8*z**2+31680*y**6*z**4-36960*y**4*z**6+11550*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(72930)*I/1024,0,-15*sqrt(286)*I/1024,0,-sqrt(15015)*I/512,0,-21*sqrt(33)*I/512,0,-21*sqrt(33)*I/512,0,-sqrt(15015)*I/512,0,-15*sqrt(286)*I/1024,0,-sqrt(72930)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(176358)*I/1024]",
        ),
        "Gh(11,Eg,2,0)": (
            "-sqrt(41990)*C1/512+sqrt(385)*C11/512-3*sqrt(4522)*C3/512+3*sqrt(4845)*C5/512+77*sqrt(19)*C7/512+39*sqrt(15)*C9/512",
            "sqrt(692835)*x*(6*x**2*y**8-168*x**2*y**6*z**2+420*x**2*y**4*z**4-168*x**2*y**2*z**6+6*x**2*z**8-y**10+27*y**8*z**2-42*y**6*z**4-42*y**4*z**6+27*y**2*z**8-z**10)/256",
            "[-sqrt(770)/1024,0,-39*sqrt(30)/1024,0,-77*sqrt(38)/1024,0,-3*sqrt(9690)/1024,0,3*sqrt(2261)/512,0,sqrt(20995)/512,0,-sqrt(20995)/512,0,-3*sqrt(2261)/512,0,3*sqrt(9690)/1024,0,77*sqrt(38)/1024,0,39*sqrt(30)/1024,0,sqrt(770)/1024]",
        ),
        "Gh(11,Eg,2,1)": (
            "-sqrt(41990)*S1/512-sqrt(385)*S11/512+3*sqrt(4522)*S3/512+3*sqrt(4845)*S5/512-77*sqrt(19)*S7/512+39*sqrt(15)*S9/512",
            "sqrt(692835)*y*(-x**10+6*x**8*y**2+27*x**8*z**2-168*x**6*y**2*z**2-42*x**6*z**4+420*x**4*y**2*z**4-42*x**4*z**6-168*x**2*y**2*z**6+27*x**2*z**8+6*y**2*z**8-z**10)/256",
            "[-sqrt(770)*I/1024,0,39*sqrt(30)*I/1024,0,-77*sqrt(38)*I/1024,0,3*sqrt(9690)*I/1024,0,3*sqrt(2261)*I/512,0,-sqrt(20995)*I/512,0,-sqrt(20995)*I/512,0,3*sqrt(2261)*I/512,0,3*sqrt(9690)*I/1024,0,-77*sqrt(38)*I/1024,0,39*sqrt(30)*I/1024,0,-sqrt(770)*I/1024]",
        ),
        "Gh(11,Eg,3,0)": (
            "-5*sqrt(546)*C1/256+sqrt(10659)*C11/256+11*sqrt(30)*C3/256+13*sqrt(7)*C5/256-3*sqrt(1785)*C7/256+3*sqrt(2261)*C9/256",
            "3*sqrt(1001)*x*(80*x**6*y**4-480*x**6*y**2*z**2+80*x**6*z**4-168*x**4*y**6+840*x**4*y**4*z**2+840*x**4*y**2*z**4-168*x**4*z**6+70*x**2*y**8-280*x**2*y**6*z**2-700*x**2*y**4*z**4-280*x**2*y**2*z**6+70*x**2*z**8-5*y**10+15*y**8*z**2+70*y**6*z**4+70*y**4*z**6+15*y**2*z**8-5*z**10)/128",
            "[-sqrt(21318)/512,0,-3*sqrt(4522)/512,0,3*sqrt(3570)/512,0,-13*sqrt(14)/512,0,-11*sqrt(15)/256,0,5*sqrt(273)/256,0,-5*sqrt(273)/256,0,11*sqrt(15)/256,0,13*sqrt(14)/512,0,-3*sqrt(3570)/512,0,3*sqrt(4522)/512,0,sqrt(21318)/512]",
        ),
        "Gh(11,Eg,3,1)": (
            "-5*sqrt(546)*S1/256-sqrt(10659)*S11/256-11*sqrt(30)*S3/256+13*sqrt(7)*S5/256+3*sqrt(1785)*S7/256+3*sqrt(2261)*S9/256",
            "3*sqrt(1001)*y*(-5*x**10+70*x**8*y**2+15*x**8*z**2-168*x**6*y**4-280*x**6*y**2*z**2+70*x**6*z**4+80*x**4*y**6+840*x**4*y**4*z**2-700*x**4*y**2*z**4+70*x**4*z**6-480*x**2*y**6*z**2+840*x**2*y**4*z**4-280*x**2*y**2*z**6+15*x**2*z**8+80*y**6*z**4-168*y**4*z**6+70*y**2*z**8-5*z**10)/128",
            "[-sqrt(21318)*I/512,0,3*sqrt(4522)*I/512,0,3*sqrt(3570)*I/512,0,13*sqrt(14)*I/512,0,-11*sqrt(15)*I/256,0,-5*sqrt(273)*I/256,0,-5*sqrt(273)*I/256,0,-11*sqrt(15)*I/256,0,13*sqrt(14)*I/512,0,3*sqrt(3570)*I/512,0,3*sqrt(4522)*I/512,0,-sqrt(21318)*I/512]",
        ),
        "Gh(11,Eg,4,0)": (
            "-sqrt(29393)*C1/512-sqrt(22)*C11/1024-9*sqrt(1615)*C3/512-5*sqrt(13566)*C5/1024-7*sqrt(1330)*C7/1024-9*sqrt(42)*C9/1024",
            "sqrt(1939938)*x*(y**10-45*y**8*z**2+210*y**6*z**4-210*y**4*z**6+45*y**2*z**8-z**10)/512",
            "[sqrt(11)/1024,0,9*sqrt(21)/1024,0,7*sqrt(665)/1024,0,5*sqrt(6783)/1024,0,9*sqrt(3230)/1024,0,sqrt(58786)/1024,0,-sqrt(58786)/1024,0,-9*sqrt(3230)/1024,0,-5*sqrt(6783)/1024,0,-7*sqrt(665)/1024,0,-9*sqrt(21)/1024,0,-sqrt(11)/1024]",
        ),
        "Gh(11,Eg,4,1)": (
            "-sqrt(29393)*S1/512+sqrt(22)*S11/1024+9*sqrt(1615)*S3/512-5*sqrt(13566)*S5/1024+7*sqrt(1330)*S7/1024-9*sqrt(42)*S9/1024",
            "sqrt(1939938)*y*(x**10-45*x**8*z**2+210*x**6*z**4-210*x**4*z**6+45*x**2*z**8-z**10)/512",
            "[sqrt(11)*I/1024,0,-9*sqrt(21)*I/1024,0,7*sqrt(665)*I/1024,0,-5*sqrt(6783)*I/1024,0,9*sqrt(3230)*I/1024,0,-sqrt(58786)*I/1024,0,-sqrt(58786)*I/1024,0,9*sqrt(3230)*I/1024,0,-5*sqrt(6783)*I/1024,0,7*sqrt(665)*I/1024,0,-9*sqrt(21)*I/1024,0,sqrt(11)*I/1024]",
        ),
        "Gh(11,Eg,5,0)": (
            "-15*sqrt(221)*C1/512-3*sqrt(2926)*C11/1024-sqrt(595)*C3/512+53*sqrt(102)*C5/1024-105*sqrt(10)*C7/1024-61*sqrt(114)*C9/1024",
            "sqrt(14586)*x*(224*x**4*y**6-3360*x**4*y**4*z**2+3360*x**4*y**2*z**4-224*x**4*z**6-160*x**2*y**8+2240*x**2*y**6*z**2-2240*x**2*y**2*z**6+160*x**2*z**8+15*y**10-195*y**8*z**2-210*y**6*z**4+210*y**4*z**6+195*y**2*z**8-15*z**10)/512",
            "[3*sqrt(1463)/1024,0,61*sqrt(57)/1024,0,105*sqrt(5)/1024,0,-53*sqrt(51)/1024,0,sqrt(1190)/1024,0,15*sqrt(442)/1024,0,-15*sqrt(442)/1024,0,-sqrt(1190)/1024,0,53*sqrt(51)/1024,0,-105*sqrt(5)/1024,0,-61*sqrt(57)/1024,0,-3*sqrt(1463)/1024]",
        ),
        "Gh(11,Eg,5,1)": (
            "-15*sqrt(221)*S1/512+3*sqrt(2926)*S11/1024+sqrt(595)*S3/512+53*sqrt(102)*S5/1024+105*sqrt(10)*S7/1024-61*sqrt(114)*S9/1024",
            "sqrt(14586)*y*(15*x**10-160*x**8*y**2-195*x**8*z**2+224*x**6*y**4+2240*x**6*y**2*z**2-210*x**6*z**4-3360*x**4*y**4*z**2+210*x**4*z**6+3360*x**2*y**4*z**4-2240*x**2*y**2*z**6+195*x**2*z**8-224*y**4*z**6+160*y**2*z**8-15*z**10)/512",
            "[3*sqrt(1463)*I/1024,0,-61*sqrt(57)*I/1024,0,105*sqrt(5)*I/1024,0,53*sqrt(51)*I/1024,0,sqrt(1190)*I/1024,0,-15*sqrt(442)*I/1024,0,-15*sqrt(442)*I/1024,0,sqrt(1190)*I/1024,0,53*sqrt(51)*I/1024,0,105*sqrt(5)*I/1024,0,-61*sqrt(57)*I/1024,0,3*sqrt(1463)*I/1024]",
        ),
        "Gh(11,Eg,6,0)": (
            "-21*sqrt(130)*C1/512-sqrt(124355)*C11/512+57*sqrt(14)*C3/512-41*sqrt(15)*C5/512+17*sqrt(17)*C7/512+sqrt(4845)*C9/512",
            "sqrt(2145)*x*(128*x**8*y**2-128*x**8*z**2-768*x**6*y**4+768*x**6*z**4+1008*x**4*y**6+1008*x**4*y**4*z**2-1008*x**4*y**2*z**4-1008*x**4*z**6-336*x**2*y**8-672*x**2*y**6*z**2+672*x**2*y**2*z**6+336*x**2*z**8+21*y**10+63*y**8*z**2+42*y**6*z**4-42*y**4*z**6-63*y**2*z**8-21*z**10)/256",
            "[sqrt(248710)/1024,0,-sqrt(9690)/1024,0,-17*sqrt(34)/1024,0,41*sqrt(30)/1024,0,-57*sqrt(7)/512,0,21*sqrt(65)/512,0,-21*sqrt(65)/512,0,57*sqrt(7)/512,0,-41*sqrt(30)/1024,0,17*sqrt(34)/1024,0,sqrt(9690)/1024,0,-sqrt(248710)/1024]",
        ),
        "Gh(11,Eg,6,1)": (
            "-21*sqrt(130)*S1/512+sqrt(124355)*S11/512-57*sqrt(14)*S3/512-41*sqrt(15)*S5/512-17*sqrt(17)*S7/512+sqrt(4845)*S9/512",
            "sqrt(2145)*y*(21*x**10-336*x**8*y**2+63*x**8*z**2+1008*x**6*y**4-672*x**6*y**2*z**2+42*x**6*z**4-768*x**4*y**6+1008*x**4*y**4*z**2-42*x**4*z**6+128*x**2*y**8-1008*x**2*y**4*z**4+672*x**2*y**2*z**6-63*x**2*z**8-128*y**8*z**2+768*y**6*z**4-1008*y**4*z**6+336*y**2*z**8-21*z**10)/256",
            "[sqrt(248710)*I/1024,0,sqrt(9690)*I/1024,0,-17*sqrt(34)*I/1024,0,-41*sqrt(30)*I/1024,0,-57*sqrt(7)*I/512,0,-21*sqrt(65)*I/512,0,-21*sqrt(65)*I/512,0,-57*sqrt(7)*I/512,0,-41*sqrt(30)*I/1024,0,-17*sqrt(34)*I/1024,0,sqrt(9690)*I/1024,0,sqrt(248710)*I/1024]",
        ),
    },
    "C3": {
        "Gh(0,A,,)": ("C0", "1", "[1]"),
        "Gh(1,A,,)": ("C0", "z", "[0,1,0]"),
        "Gh(1,E,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Gh(1,E,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Gh(2,A,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Gh(2,E,1,0)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Gh(2,E,1,1)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Gh(2,E,2,0)": ("C2", "sqrt(3)*(x**2-y**2)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Gh(2,E,2,1)": ("-S2", "-sqrt(3)*x*y", "[sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2]"),
        "Gh(3,A,1,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Gh(3,A,2,)": ("S3", "sqrt(10)*y*(3*x**2-y**2)/4", "[sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2]"),
        "Gh(3,A,3,)": ("C3", "sqrt(10)*x*(x**2-3*y**2)/4", "[-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2]"),
        "Gh(3,E,1,0)": ("C1", "sqrt(6)*x*(-x**2-y**2+4*z**2)/4", "[0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0]"),
        "Gh(3,E,1,1)": ("S1", "sqrt(6)*y*(-x**2-y**2+4*z**2)/4", "[0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0]"),
        "Gh(3,E,2,0)": ("C2", "sqrt(15)*z*(x**2-y**2)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Gh(3,E,2,1)": ("-S2", "-sqrt(15)*x*y*z", "[0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0]"),
        "Gh(4,A,1,)": ("C0", "3*x**4/8+3*x**2*y**2/4-3*x**2*z**2+3*y**4/8-3*y**2*z**2+z**4", "[0,0,0,0,1,0,0,0,0]"),
        "Gh(4,A,2,)": ("C3", "sqrt(70)*x*z*(x**2-3*y**2)/4", "[0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0]"),
        "Gh(4,A,3,)": ("S3", "sqrt(70)*y*z*(3*x**2-y**2)/4", "[0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Gh(4,E,1,0)": ("C1", "sqrt(10)*x*z*(-3*x**2-3*y**2+4*z**2)/4", "[0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0]"),
        "Gh(4,E,1,1)": ("S1", "sqrt(10)*y*z*(-3*x**2-3*y**2+4*z**2)/4", "[0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0]"),
        "Gh(4,E,2,0)": ("C4", "sqrt(35)*(x**4-6*x**2*y**2+y**4)/8", "[sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Gh(4,E,2,1)": ("S4", "sqrt(35)*x*y*(x**2-y**2)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Gh(4,E,3,0)": ("C2", "sqrt(5)*(-x**2+y**2)*(x**2+y**2-6*z**2)/4", "[0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0]"),
        "Gh(4,E,3,1)": ("-S2", "sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0]"),
        "Gh(5,A,1,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Gh(5,A,2,)": ("S3", "-sqrt(70)*y*(3*x**2-y**2)*(x**2+y**2-8*z**2)/16", "[0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0]"),
        "Gh(5,A,3,)": ("C3", "-sqrt(70)*x*(x**2-3*y**2)*(x**2+y**2-8*z**2)/16", "[0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0]"),
        "Gh(5,E,1,0)": ("C5", "3*sqrt(14)*x*(x**4-10*x**2*y**2+5*y**4)/16", "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Gh(5,E,1,1)": ("-S5", "3*sqrt(14)*y*(-5*x**4+10*x**2*y**2-y**4)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]"),
        "Gh(5,E,2,0)": (
            "C1",
            "sqrt(15)*x*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(5,E,2,1)": (
            "S1",
            "sqrt(15)*y*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(5,E,3,0)": ("C4", "3*sqrt(35)*z*(x**4-6*x**2*y**2+y**4)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Gh(5,E,3,1)": ("S4", "3*sqrt(35)*x*y*z*(x**2-y**2)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Gh(5,E,4,0)": ("C2", "sqrt(105)*z*(-x**2+y**2)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Gh(5,E,4,1)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Gh(6,A,1,)": (
            "C0",
            "-5*x**6/16-15*x**4*y**2/16+45*x**4*z**2/8-15*x**2*y**4/16+45*x**2*y**2*z**2/4-15*x**2*z**4/2-5*y**6/16+45*y**4*z**2/8-15*y**2*z**4/2+z**6",
            "[0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Gh(6,A,2,)": (
            "C6",
            "sqrt(462)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(6,A,3,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Gh(6,A,4,)": (
            "C3",
            "-sqrt(210)*x*z*(x**2-3*y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(6,A,5,)": (
            "S3",
            "-sqrt(210)*y*z*(3*x**2-y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(6,E,1,0)": ("C5", "3*sqrt(154)*x*z*(x**4-10*x**2*y**2+5*y**4)/16", "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Gh(6,E,1,1)": (
            "-S5",
            "3*sqrt(154)*y*z*(-5*x**4+10*x**2*y**2-y**4)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Gh(6,E,2,0)": (
            "C1",
            "sqrt(21)*x*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(6,E,2,1)": (
            "S1",
            "sqrt(21)*y*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(6,E,3,0)": (
            "C4",
            "3*sqrt(7)*(x**2+y**2-10*z**2)*(-x**4+6*x**2*y**2-y**4)/16",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(6,E,3,1)": (
            "S4",
            "-3*sqrt(7)*x*y*(x**2-y**2)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(6,E,4,0)": (
            "C2",
            "sqrt(210)*(x**2-y**2)*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(6,E,4,1)": (
            "-S2",
            "sqrt(210)*x*y*(-x**4-2*x**2*y**2+16*x**2*z**2-y**4+16*y**2*z**2-16*z**4)/16",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(7,A,1,)": (
            "S6",
            "sqrt(6006)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Gh(7,A,2,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Gh(7,A,3,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(7,A,4,)": (
            "S3",
            "sqrt(21)*y*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(7,A,5,)": (
            "C3",
            "sqrt(21)*x*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(7,E,1,0)": (
            "C7",
            "sqrt(429)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(7,E,1,1)": (
            "S7",
            "sqrt(429)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(7,E,2,0)": (
            "C5",
            "sqrt(231)*x*(x**2+y**2-12*z**2)*(-x**4+10*x**2*y**2-5*y**4)/32",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(7,E,2,1)": (
            "-S5",
            "sqrt(231)*y*(x**2+y**2-12*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Gh(7,E,3,0)": (
            "C1",
            "sqrt(7)*x*(-5*x**6-15*x**4*y**2+120*x**4*z**2-15*x**2*y**4+240*x**2*y**2*z**2-240*x**2*z**4-5*y**6+120*y**4*z**2-240*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(7,E,3,1)": (
            "S1",
            "sqrt(7)*y*(-5*x**6-15*x**4*y**2+120*x**4*z**2-15*x**2*y**4+240*x**2*y**2*z**2-240*x**2*z**4-5*y**6+120*y**4*z**2-240*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(7,E,4,0)": (
            "C4",
            "sqrt(231)*z*(3*x**2+3*y**2-10*z**2)*(-x**4+6*x**2*y**2-y**4)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(7,E,4,1)": (
            "S4",
            "-sqrt(231)*x*y*z*(x**2-y**2)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(7,E,5,0)": (
            "C2",
            "sqrt(42)*z*(x**2-y**2)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(7,E,5,1)": (
            "-S2",
            "sqrt(42)*x*y*z*(-15*x**4-30*x**2*y**2+80*x**2*z**2-15*y**4+80*y**2*z**2-48*z**4)/16",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(8,A,1,)": (
            "C0",
            "35*x**8/128+35*x**6*y**2/32-35*x**6*z**2/4+105*x**4*y**4/64-105*x**4*y**2*z**2/4+105*x**4*z**4/4+35*x**2*y**6/32-105*x**2*y**4*z**2/4+105*x**2*y**2*z**4/2-14*x**2*z**6+35*y**8/128-35*y**6*z**2/4+105*y**4*z**4/4-14*y**2*z**6+z**8",
            "[0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0]",
        ),
        "Gh(8,A,2,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(8,A,3,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(8,A,4,)": (
            "C3",
            "sqrt(1155)*x*z*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(8,A,5,)": (
            "S3",
            "sqrt(1155)*y*z*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(8,E,1,0)": (
            "C7",
            "3*sqrt(715)*x*z*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(8,E,1,1)": (
            "S7",
            "3*sqrt(715)*y*z*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Gh(8,E,2,0)": (
            "C5",
            "3*sqrt(1001)*x*z*(x**2+y**2-4*z**2)*(-x**4+10*x**2*y**2-5*y**4)/32",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(8,E,2,1)": (
            "-S5",
            "3*sqrt(1001)*y*z*(x**2+y**2-4*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(8,E,3,0)": (
            "C1",
            "3*x*z*(-35*x**6-105*x**4*y**2+280*x**4*z**2-105*x**2*y**4+560*x**2*y**2*z**2-336*x**2*z**4-35*y**6+280*y**4*z**2-336*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(8,E,3,1)": (
            "S1",
            "3*y*z*(-35*x**6-105*x**4*y**2+280*x**4*z**2-105*x**2*y**4+560*x**2*y**2*z**2-336*x**2*z**4-35*y**6+280*y**4*z**2-336*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(8,E,4,0)": (
            "C8",
            "3*sqrt(715)*(x**8-28*x**6*y**2+70*x**4*y**4-28*x**2*y**6+y**8)/128",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(8,E,4,1)": (
            "-S8",
            "3*sqrt(715)*x*y*(-x**6+7*x**4*y**2-7*x**2*y**4+y**6)/16",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Gh(8,E,5,0)": (
            "C4",
            "3*sqrt(77)*(x**4-6*x**2*y**2+y**4)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/64",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(8,E,5,1)": (
            "S4",
            "3*sqrt(77)*x*y*(x**2-y**2)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(8,E,6,0)": (
            "C2",
            "3*sqrt(70)*(-x**2+y**2)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(8,E,6,1)": (
            "-S2",
            "3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(9,A,1,)": (
            "S6",
            "-sqrt(4290)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**2+3*y**2-14*z**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(9,A,2,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(9,A,3,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(9,A,4,)": (
            "S9",
            "sqrt(24310)*y*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(9,A,5,)": (
            "S3",
            "-sqrt(2310)*y*(3*x**2-y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(9,A,6,)": (
            "C9",
            "sqrt(24310)*x*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(9,A,7,)": (
            "C3",
            "-sqrt(2310)*x*(x**2-3*y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(9,E,1,0)": (
            "C7",
            "3*sqrt(1430)*x*(x**2+y**2-16*z**2)*(-x**6+21*x**4*y**2-35*x**2*y**4+7*y**6)/256",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(9,E,1,1)": (
            "S7",
            "-3*sqrt(1430)*y*(x**2+y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(9,E,2,0)": (
            "C5",
            "3*sqrt(286)*x*(x**4-10*x**2*y**2+5*y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(9,E,2,1)": (
            "-S5",
            "-3*sqrt(286)*y*(5*x**4-10*x**2*y**2+y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(9,E,3,0)": (
            "C1",
            "3*sqrt(5)*x*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(9,E,3,1)": (
            "S1",
            "3*sqrt(5)*y*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(9,E,4,0)": (
            "C8",
            "3*sqrt(12155)*z*(x**8-28*x**6*y**2+70*x**4*y**4-28*x**2*y**6+y**8)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(9,E,4,1)": (
            "-S8",
            "3*sqrt(12155)*x*y*z*(-x**6+7*x**4*y**2-7*x**2*y**4+y**6)/16",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Gh(9,E,5,0)": (
            "C4",
            "3*sqrt(5005)*z*(x**4-6*x**2*y**2+y**4)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(9,E,5,1)": (
            "S4",
            "3*sqrt(5005)*x*y*z*(x**2-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/16",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(9,E,6,0)": (
            "C2",
            "3*sqrt(110)*z*(-x**2+y**2)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(9,E,6,1)": (
            "-S2",
            "3*sqrt(110)*x*y*z*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(10,A,1,)": (
            "C0",
            "-63*x**10/256-315*x**8*y**2/256+1575*x**8*z**2/128-315*x**6*y**4/128+1575*x**6*y**2*z**2/32-525*x**6*z**4/8-315*x**4*y**6/128+4725*x**4*y**4*z**2/64-1575*x**4*y**2*z**4/8+315*x**4*z**6/4-315*x**2*y**8/256+1575*x**2*y**6*z**2/32-1575*x**2*y**4*z**4/8+315*x**2*y**2*z**6/2-45*x**2*z**8/2-63*y**10/256+1575*y**8*z**2/128-525*y**6*z**4/8+315*y**4*z**6/4-45*y**2*z**8/2+z**10",
            "[0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(10,A,2,)": (
            "C6",
            "sqrt(4290)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(10,A,3,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(10,A,4,)": (
            "C9",
            "sqrt(461890)*x*z*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(10,A,5,)": (
            "C3",
            "-sqrt(4290)*x*z*(x**2-3*y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(10,A,6,)": (
            "S9",
            "sqrt(461890)*y*z*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Gh(10,A,7,)": (
            "S3",
            "-sqrt(4290)*y*z*(3*x**2-y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(10,E,1,0)": (
            "C7",
            "sqrt(72930)*x*z*(3*x**2+3*y**2-16*z**2)*(-x**6+21*x**4*y**2-35*x**2*y**4+7*y**6)/256",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(10,E,1,1)": (
            "S7",
            "-sqrt(72930)*y*z*(3*x**2+3*y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(10,E,2,0)": (
            "C5",
            "sqrt(858)*x*z*(x**4-10*x**2*y**2+5*y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(10,E,2,1)": (
            "-S5",
            "-sqrt(858)*y*z*(5*x**4-10*x**2*y**2+y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(10,E,3,0)": (
            "C1",
            "sqrt(55)*x*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(10,E,3,1)": (
            "S1",
            "sqrt(55)*y*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(10,E,4,0)": (
            "C10",
            "sqrt(92378)*(x**10-45*x**8*y**2+210*x**6*y**4-210*x**4*y**6+45*x**2*y**8-y**10)/512",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(10,E,4,1)": (
            "S10",
            "sqrt(92378)*x*y*(5*x**8-60*x**6*y**2+126*x**4*y**4-60*x**2*y**6+5*y**8)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(10,E,5,0)": (
            "C8",
            "sqrt(12155)*(x**2+y**2-18*z**2)*(-x**8+28*x**6*y**2-70*x**4*y**4+28*x**2*y**6-y**8)/256",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(10,E,5,1)": (
            "-S8",
            "sqrt(12155)*x*y*(x**2+y**2-18*z**2)*(x**6-7*x**4*y**2+7*x**2*y**4-y**6)/32",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Gh(10,E,6,0)": (
            "C4",
            "sqrt(2145)*(-x**4+6*x**2*y**2-y**4)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(10,E,6,1)": (
            "S4",
            "-sqrt(2145)*x*y*(x**2-y**2)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(10,E,7,0)": (
            "C2",
            "sqrt(165)*(x**2-y**2)*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/256",
            "[0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(10,E,7,1)": (
            "-S2",
            "sqrt(165)*x*y*(-7*x**8-28*x**6*y**2+336*x**6*z**2-42*x**4*y**4+1008*x**4*y**2*z**2-1680*x**4*z**4-28*x**2*y**6+1008*x**2*y**4*z**2-3360*x**2*y**2*z**4+1792*x**2*z**6-7*y**8+336*y**6*z**2-1680*y**4*z**4+1792*y**2*z**6-384*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,A,1,)": (
            "S6",
            "sqrt(14586)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(11,A,2,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,A,3,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(11,A,4,)": (
            "S9",
            "-sqrt(46189)*y*(3*x**2-y**2)*(x**2+y**2-20*z**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/512",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(11,A,5,)": (
            "S3",
            "sqrt(30030)*y*(3*x**2-y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,A,6,)": (
            "C9",
            "-sqrt(46189)*x*(x**2-3*y**2)*(x**2+y**2-20*z**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/512",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(11,A,7,)": (
            "C3",
            "sqrt(30030)*x*(x**2-3*y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E,1,0)": (
            "C11",
            "sqrt(88179)*x*(x**10-55*x**8*y**2+330*x**6*y**4-462*x**4*y**6+165*x**2*y**8-11*y**10)/512",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(11,E,1,1)": (
            "-S11",
            "sqrt(88179)*y*(-11*x**10+165*x**8*y**2-462*x**6*y**4+330*x**4*y**6-55*x**2*y**8+y**10)/512",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Gh(11,E,2,0)": (
            "C7",
            "sqrt(36465)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(11,E,2,1)": (
            "S7",
            "sqrt(36465)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(11,E,3,0)": (
            "C5",
            "3*sqrt(143)*x*(-x**4+10*x**2*y**2-5*y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(11,E,3,1)": (
            "-S5",
            "3*sqrt(143)*y*(5*x**4-10*x**2*y**2+y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(11,E,4,0)": (
            "C1",
            "sqrt(66)*x*(-21*x**10-105*x**8*y**2+1260*x**8*z**2-210*x**6*y**4+5040*x**6*y**2*z**2-8400*x**6*z**4-210*x**4*y**6+7560*x**4*y**4*z**2-25200*x**4*y**2*z**4+13440*x**4*z**6-105*x**2*y**8+5040*x**2*y**6*z**2-25200*x**2*y**4*z**4+26880*x**2*y**2*z**6-5760*x**2*z**8-21*y**10+1260*y**8*z**2-8400*y**6*z**4+13440*y**4*z**6-5760*y**2*z**8+512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E,4,1)": (
            "S1",
            "sqrt(66)*y*(-21*x**10-105*x**8*y**2+1260*x**8*z**2-210*x**6*y**4+5040*x**6*y**2*z**2-8400*x**6*z**4-210*x**4*y**6+7560*x**4*y**4*z**2-25200*x**4*y**2*z**4+13440*x**4*z**6-105*x**2*y**8+5040*x**2*y**6*z**2-25200*x**2*y**4*z**4+26880*x**2*y**2*z**6-5760*x**2*z**8-21*y**10+1260*y**8*z**2-8400*y**6*z**4+13440*y**4*z**6-5760*y**2*z**8+512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E,5,0)": (
            "C10",
            "sqrt(1939938)*z*(x**10-45*x**8*y**2+210*x**6*y**4-210*x**4*y**6+45*x**2*y**8-y**10)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(11,E,5,1)": (
            "S10",
            "sqrt(1939938)*x*y*z*(5*x**8-60*x**6*y**2+126*x**4*y**4-60*x**2*y**6+5*y**8)/256",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Gh(11,E,6,0)": (
            "C8",
            "sqrt(692835)*z*(x**2+y**2-6*z**2)*(-x**8+28*x**6*y**2-70*x**4*y**4+28*x**2*y**6-y**8)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(11,E,6,1)": (
            "-S8",
            "sqrt(692835)*x*y*z*(x**2+y**2-6*z**2)*(x**6-7*x**4*y**2+7*x**2*y**4-y**6)/32",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(11,E,7,0)": (
            "C4",
            "3*sqrt(1001)*z*(-x**4+6*x**2*y**2-y**4)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E,7,1)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x**2-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E,8,0)": (
            "C2",
            "sqrt(2145)*z*(x**2-y**2)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E,8,1)": (
            "-S2",
            "sqrt(2145)*x*y*z*(-21*x**8-84*x**6*y**2+336*x**6*z**2-126*x**4*y**4+1008*x**4*y**2*z**2-1008*x**4*z**4-84*x**2*y**6+1008*x**2*y**4*z**2-2016*x**2*y**2*z**4+768*x**2*z**6-21*y**8+336*y**6*z**2-1008*y**4*z**4+768*y**2*z**6-128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
    },
    "C3i": {
        "Gh(0,Au,,)": ("C0", "1", "[1]"),
        "Gh(1,Ag,,)": ("C0", "z", "[0,1,0]"),
        "Gh(1,Eg,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Gh(1,Eg,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Gh(2,Au,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Gh(2,Eu,1,0)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Gh(2,Eu,1,1)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Gh(2,Eu,2,0)": ("C2", "sqrt(3)*(x**2-y**2)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Gh(2,Eu,2,1)": ("-S2", "-sqrt(3)*x*y", "[sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2]"),
        "Gh(3,Ag,1,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Gh(3,Ag,2,)": ("S3", "sqrt(10)*y*(3*x**2-y**2)/4", "[sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2]"),
        "Gh(3,Ag,3,)": ("C3", "sqrt(10)*x*(x**2-3*y**2)/4", "[-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2]"),
        "Gh(3,Eg,1,0)": ("C1", "sqrt(6)*x*(-x**2-y**2+4*z**2)/4", "[0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0]"),
        "Gh(3,Eg,1,1)": ("S1", "sqrt(6)*y*(-x**2-y**2+4*z**2)/4", "[0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0]"),
        "Gh(3,Eg,2,0)": ("C2", "sqrt(15)*z*(x**2-y**2)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Gh(3,Eg,2,1)": ("-S2", "-sqrt(15)*x*y*z", "[0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0]"),
        "Gh(4,Au,1,)": ("C0", "3*x**4/8+3*x**2*y**2/4-3*x**2*z**2+3*y**4/8-3*y**2*z**2+z**4", "[0,0,0,0,1,0,0,0,0]"),
        "Gh(4,Au,2,)": ("C3", "sqrt(70)*x*z*(x**2-3*y**2)/4", "[0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0]"),
        "Gh(4,Au,3,)": ("S3", "sqrt(70)*y*z*(3*x**2-y**2)/4", "[0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Gh(4,Eu,1,0)": ("C1", "sqrt(10)*x*z*(-3*x**2-3*y**2+4*z**2)/4", "[0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0]"),
        "Gh(4,Eu,1,1)": ("S1", "sqrt(10)*y*z*(-3*x**2-3*y**2+4*z**2)/4", "[0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0]"),
        "Gh(4,Eu,2,0)": ("C4", "sqrt(35)*(x**4-6*x**2*y**2+y**4)/8", "[sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Gh(4,Eu,2,1)": ("S4", "sqrt(35)*x*y*(x**2-y**2)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Gh(4,Eu,3,0)": ("C2", "sqrt(5)*(-x**2+y**2)*(x**2+y**2-6*z**2)/4", "[0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0]"),
        "Gh(4,Eu,3,1)": ("-S2", "sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0]"),
        "Gh(5,Ag,1,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Gh(5,Ag,2,)": ("S3", "-sqrt(70)*y*(3*x**2-y**2)*(x**2+y**2-8*z**2)/16", "[0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0]"),
        "Gh(5,Ag,3,)": ("C3", "-sqrt(70)*x*(x**2-3*y**2)*(x**2+y**2-8*z**2)/16", "[0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0]"),
        "Gh(5,Eg,1,0)": ("C5", "3*sqrt(14)*x*(x**4-10*x**2*y**2+5*y**4)/16", "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Gh(5,Eg,1,1)": ("-S5", "3*sqrt(14)*y*(-5*x**4+10*x**2*y**2-y**4)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]"),
        "Gh(5,Eg,2,0)": (
            "C1",
            "sqrt(15)*x*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(5,Eg,2,1)": (
            "S1",
            "sqrt(15)*y*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(5,Eg,3,0)": ("C4", "3*sqrt(35)*z*(x**4-6*x**2*y**2+y**4)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Gh(5,Eg,3,1)": ("S4", "3*sqrt(35)*x*y*z*(x**2-y**2)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Gh(5,Eg,4,0)": ("C2", "sqrt(105)*z*(-x**2+y**2)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Gh(5,Eg,4,1)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Gh(6,Au,1,)": (
            "C0",
            "-5*x**6/16-15*x**4*y**2/16+45*x**4*z**2/8-15*x**2*y**4/16+45*x**2*y**2*z**2/4-15*x**2*z**4/2-5*y**6/16+45*y**4*z**2/8-15*y**2*z**4/2+z**6",
            "[0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Gh(6,Au,2,)": (
            "C6",
            "sqrt(462)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(6,Au,3,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Gh(6,Au,4,)": (
            "C3",
            "-sqrt(210)*x*z*(x**2-3*y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(6,Au,5,)": (
            "S3",
            "-sqrt(210)*y*z*(3*x**2-y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(6,Eu,1,0)": ("C5", "3*sqrt(154)*x*z*(x**4-10*x**2*y**2+5*y**4)/16", "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Gh(6,Eu,1,1)": (
            "-S5",
            "3*sqrt(154)*y*z*(-5*x**4+10*x**2*y**2-y**4)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Gh(6,Eu,2,0)": (
            "C1",
            "sqrt(21)*x*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(6,Eu,2,1)": (
            "S1",
            "sqrt(21)*y*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(6,Eu,3,0)": (
            "C4",
            "3*sqrt(7)*(x**2+y**2-10*z**2)*(-x**4+6*x**2*y**2-y**4)/16",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(6,Eu,3,1)": (
            "S4",
            "-3*sqrt(7)*x*y*(x**2-y**2)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(6,Eu,4,0)": (
            "C2",
            "sqrt(210)*(x**2-y**2)*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(6,Eu,4,1)": (
            "-S2",
            "sqrt(210)*x*y*(-x**4-2*x**2*y**2+16*x**2*z**2-y**4+16*y**2*z**2-16*z**4)/16",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(7,Ag,1,)": (
            "S6",
            "sqrt(6006)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Gh(7,Ag,2,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Gh(7,Ag,3,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(7,Ag,4,)": (
            "S3",
            "sqrt(21)*y*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(7,Ag,5,)": (
            "C3",
            "sqrt(21)*x*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(7,Eg,1,0)": (
            "C7",
            "sqrt(429)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(7,Eg,1,1)": (
            "S7",
            "sqrt(429)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(7,Eg,2,0)": (
            "C5",
            "sqrt(231)*x*(x**2+y**2-12*z**2)*(-x**4+10*x**2*y**2-5*y**4)/32",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(7,Eg,2,1)": (
            "-S5",
            "sqrt(231)*y*(x**2+y**2-12*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Gh(7,Eg,3,0)": (
            "C1",
            "sqrt(7)*x*(-5*x**6-15*x**4*y**2+120*x**4*z**2-15*x**2*y**4+240*x**2*y**2*z**2-240*x**2*z**4-5*y**6+120*y**4*z**2-240*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(7,Eg,3,1)": (
            "S1",
            "sqrt(7)*y*(-5*x**6-15*x**4*y**2+120*x**4*z**2-15*x**2*y**4+240*x**2*y**2*z**2-240*x**2*z**4-5*y**6+120*y**4*z**2-240*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(7,Eg,4,0)": (
            "C4",
            "sqrt(231)*z*(3*x**2+3*y**2-10*z**2)*(-x**4+6*x**2*y**2-y**4)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(7,Eg,4,1)": (
            "S4",
            "-sqrt(231)*x*y*z*(x**2-y**2)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(7,Eg,5,0)": (
            "C2",
            "sqrt(42)*z*(x**2-y**2)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(7,Eg,5,1)": (
            "-S2",
            "sqrt(42)*x*y*z*(-15*x**4-30*x**2*y**2+80*x**2*z**2-15*y**4+80*y**2*z**2-48*z**4)/16",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(8,Au,1,)": (
            "C0",
            "35*x**8/128+35*x**6*y**2/32-35*x**6*z**2/4+105*x**4*y**4/64-105*x**4*y**2*z**2/4+105*x**4*z**4/4+35*x**2*y**6/32-105*x**2*y**4*z**2/4+105*x**2*y**2*z**4/2-14*x**2*z**6+35*y**8/128-35*y**6*z**2/4+105*y**4*z**4/4-14*y**2*z**6+z**8",
            "[0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0]",
        ),
        "Gh(8,Au,2,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(8,Au,3,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(8,Au,4,)": (
            "C3",
            "sqrt(1155)*x*z*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(8,Au,5,)": (
            "S3",
            "sqrt(1155)*y*z*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(8,Eu,1,0)": (
            "C7",
            "3*sqrt(715)*x*z*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(8,Eu,1,1)": (
            "S7",
            "3*sqrt(715)*y*z*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Gh(8,Eu,2,0)": (
            "C5",
            "3*sqrt(1001)*x*z*(x**2+y**2-4*z**2)*(-x**4+10*x**2*y**2-5*y**4)/32",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(8,Eu,2,1)": (
            "-S5",
            "3*sqrt(1001)*y*z*(x**2+y**2-4*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(8,Eu,3,0)": (
            "C1",
            "3*x*z*(-35*x**6-105*x**4*y**2+280*x**4*z**2-105*x**2*y**4+560*x**2*y**2*z**2-336*x**2*z**4-35*y**6+280*y**4*z**2-336*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(8,Eu,3,1)": (
            "S1",
            "3*y*z*(-35*x**6-105*x**4*y**2+280*x**4*z**2-105*x**2*y**4+560*x**2*y**2*z**2-336*x**2*z**4-35*y**6+280*y**4*z**2-336*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(8,Eu,4,0)": (
            "C8",
            "3*sqrt(715)*(x**8-28*x**6*y**2+70*x**4*y**4-28*x**2*y**6+y**8)/128",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(8,Eu,4,1)": (
            "-S8",
            "3*sqrt(715)*x*y*(-x**6+7*x**4*y**2-7*x**2*y**4+y**6)/16",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Gh(8,Eu,5,0)": (
            "C4",
            "3*sqrt(77)*(x**4-6*x**2*y**2+y**4)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/64",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(8,Eu,5,1)": (
            "S4",
            "3*sqrt(77)*x*y*(x**2-y**2)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(8,Eu,6,0)": (
            "C2",
            "3*sqrt(70)*(-x**2+y**2)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(8,Eu,6,1)": (
            "-S2",
            "3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(9,Ag,1,)": (
            "S6",
            "-sqrt(4290)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**2+3*y**2-14*z**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(9,Ag,2,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(9,Ag,3,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(9,Ag,4,)": (
            "S9",
            "sqrt(24310)*y*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(9,Ag,5,)": (
            "S3",
            "-sqrt(2310)*y*(3*x**2-y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(9,Ag,6,)": (
            "C9",
            "sqrt(24310)*x*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(9,Ag,7,)": (
            "C3",
            "-sqrt(2310)*x*(x**2-3*y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(9,Eg,1,0)": (
            "C7",
            "3*sqrt(1430)*x*(x**2+y**2-16*z**2)*(-x**6+21*x**4*y**2-35*x**2*y**4+7*y**6)/256",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(9,Eg,1,1)": (
            "S7",
            "-3*sqrt(1430)*y*(x**2+y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(9,Eg,2,0)": (
            "C5",
            "3*sqrt(286)*x*(x**4-10*x**2*y**2+5*y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(9,Eg,2,1)": (
            "-S5",
            "-3*sqrt(286)*y*(5*x**4-10*x**2*y**2+y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(9,Eg,3,0)": (
            "C1",
            "3*sqrt(5)*x*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(9,Eg,3,1)": (
            "S1",
            "3*sqrt(5)*y*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(9,Eg,4,0)": (
            "C8",
            "3*sqrt(12155)*z*(x**8-28*x**6*y**2+70*x**4*y**4-28*x**2*y**6+y**8)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(9,Eg,4,1)": (
            "-S8",
            "3*sqrt(12155)*x*y*z*(-x**6+7*x**4*y**2-7*x**2*y**4+y**6)/16",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Gh(9,Eg,5,0)": (
            "C4",
            "3*sqrt(5005)*z*(x**4-6*x**2*y**2+y**4)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(9,Eg,5,1)": (
            "S4",
            "3*sqrt(5005)*x*y*z*(x**2-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/16",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(9,Eg,6,0)": (
            "C2",
            "3*sqrt(110)*z*(-x**2+y**2)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(9,Eg,6,1)": (
            "-S2",
            "3*sqrt(110)*x*y*z*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(10,Au,1,)": (
            "C0",
            "-63*x**10/256-315*x**8*y**2/256+1575*x**8*z**2/128-315*x**6*y**4/128+1575*x**6*y**2*z**2/32-525*x**6*z**4/8-315*x**4*y**6/128+4725*x**4*y**4*z**2/64-1575*x**4*y**2*z**4/8+315*x**4*z**6/4-315*x**2*y**8/256+1575*x**2*y**6*z**2/32-1575*x**2*y**4*z**4/8+315*x**2*y**2*z**6/2-45*x**2*z**8/2-63*y**10/256+1575*y**8*z**2/128-525*y**6*z**4/8+315*y**4*z**6/4-45*y**2*z**8/2+z**10",
            "[0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(10,Au,2,)": (
            "C6",
            "sqrt(4290)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(10,Au,3,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(10,Au,4,)": (
            "C9",
            "sqrt(461890)*x*z*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(10,Au,5,)": (
            "C3",
            "-sqrt(4290)*x*z*(x**2-3*y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(10,Au,6,)": (
            "S9",
            "sqrt(461890)*y*z*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Gh(10,Au,7,)": (
            "S3",
            "-sqrt(4290)*y*z*(3*x**2-y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(10,Eu,1,0)": (
            "C7",
            "sqrt(72930)*x*z*(3*x**2+3*y**2-16*z**2)*(-x**6+21*x**4*y**2-35*x**2*y**4+7*y**6)/256",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(10,Eu,1,1)": (
            "S7",
            "-sqrt(72930)*y*z*(3*x**2+3*y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(10,Eu,2,0)": (
            "C5",
            "sqrt(858)*x*z*(x**4-10*x**2*y**2+5*y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(10,Eu,2,1)": (
            "-S5",
            "-sqrt(858)*y*z*(5*x**4-10*x**2*y**2+y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(10,Eu,3,0)": (
            "C1",
            "sqrt(55)*x*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(10,Eu,3,1)": (
            "S1",
            "sqrt(55)*y*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(10,Eu,4,0)": (
            "C10",
            "sqrt(92378)*(x**10-45*x**8*y**2+210*x**6*y**4-210*x**4*y**6+45*x**2*y**8-y**10)/512",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(10,Eu,4,1)": (
            "S10",
            "sqrt(92378)*x*y*(5*x**8-60*x**6*y**2+126*x**4*y**4-60*x**2*y**6+5*y**8)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(10,Eu,5,0)": (
            "C8",
            "sqrt(12155)*(x**2+y**2-18*z**2)*(-x**8+28*x**6*y**2-70*x**4*y**4+28*x**2*y**6-y**8)/256",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(10,Eu,5,1)": (
            "-S8",
            "sqrt(12155)*x*y*(x**2+y**2-18*z**2)*(x**6-7*x**4*y**2+7*x**2*y**4-y**6)/32",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Gh(10,Eu,6,0)": (
            "C4",
            "sqrt(2145)*(-x**4+6*x**2*y**2-y**4)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(10,Eu,6,1)": (
            "S4",
            "-sqrt(2145)*x*y*(x**2-y**2)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(10,Eu,7,0)": (
            "C2",
            "sqrt(165)*(x**2-y**2)*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/256",
            "[0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(10,Eu,7,1)": (
            "-S2",
            "sqrt(165)*x*y*(-7*x**8-28*x**6*y**2+336*x**6*z**2-42*x**4*y**4+1008*x**4*y**2*z**2-1680*x**4*z**4-28*x**2*y**6+1008*x**2*y**4*z**2-3360*x**2*y**2*z**4+1792*x**2*z**6-7*y**8+336*y**6*z**2-1680*y**4*z**4+1792*y**2*z**6-384*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,Ag,1,)": (
            "S6",
            "sqrt(14586)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(11,Ag,2,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,Ag,3,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(11,Ag,4,)": (
            "S9",
            "-sqrt(46189)*y*(3*x**2-y**2)*(x**2+y**2-20*z**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/512",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(11,Ag,5,)": (
            "S3",
            "sqrt(30030)*y*(3*x**2-y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,Ag,6,)": (
            "C9",
            "-sqrt(46189)*x*(x**2-3*y**2)*(x**2+y**2-20*z**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/512",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(11,Ag,7,)": (
            "C3",
            "sqrt(30030)*x*(x**2-3*y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,Eg,1,0)": (
            "C11",
            "sqrt(88179)*x*(x**10-55*x**8*y**2+330*x**6*y**4-462*x**4*y**6+165*x**2*y**8-11*y**10)/512",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(11,Eg,1,1)": (
            "-S11",
            "sqrt(88179)*y*(-11*x**10+165*x**8*y**2-462*x**6*y**4+330*x**4*y**6-55*x**2*y**8+y**10)/512",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Gh(11,Eg,2,0)": (
            "C7",
            "sqrt(36465)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(11,Eg,2,1)": (
            "S7",
            "sqrt(36465)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(11,Eg,3,0)": (
            "C5",
            "3*sqrt(143)*x*(-x**4+10*x**2*y**2-5*y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(11,Eg,3,1)": (
            "-S5",
            "3*sqrt(143)*y*(5*x**4-10*x**2*y**2+y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(11,Eg,4,0)": (
            "C1",
            "sqrt(66)*x*(-21*x**10-105*x**8*y**2+1260*x**8*z**2-210*x**6*y**4+5040*x**6*y**2*z**2-8400*x**6*z**4-210*x**4*y**6+7560*x**4*y**4*z**2-25200*x**4*y**2*z**4+13440*x**4*z**6-105*x**2*y**8+5040*x**2*y**6*z**2-25200*x**2*y**4*z**4+26880*x**2*y**2*z**6-5760*x**2*z**8-21*y**10+1260*y**8*z**2-8400*y**6*z**4+13440*y**4*z**6-5760*y**2*z**8+512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,Eg,4,1)": (
            "S1",
            "sqrt(66)*y*(-21*x**10-105*x**8*y**2+1260*x**8*z**2-210*x**6*y**4+5040*x**6*y**2*z**2-8400*x**6*z**4-210*x**4*y**6+7560*x**4*y**4*z**2-25200*x**4*y**2*z**4+13440*x**4*z**6-105*x**2*y**8+5040*x**2*y**6*z**2-25200*x**2*y**4*z**4+26880*x**2*y**2*z**6-5760*x**2*z**8-21*y**10+1260*y**8*z**2-8400*y**6*z**4+13440*y**4*z**6-5760*y**2*z**8+512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,Eg,5,0)": (
            "C10",
            "sqrt(1939938)*z*(x**10-45*x**8*y**2+210*x**6*y**4-210*x**4*y**6+45*x**2*y**8-y**10)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(11,Eg,5,1)": (
            "S10",
            "sqrt(1939938)*x*y*z*(5*x**8-60*x**6*y**2+126*x**4*y**4-60*x**2*y**6+5*y**8)/256",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Gh(11,Eg,6,0)": (
            "C8",
            "sqrt(692835)*z*(x**2+y**2-6*z**2)*(-x**8+28*x**6*y**2-70*x**4*y**4+28*x**2*y**6-y**8)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(11,Eg,6,1)": (
            "-S8",
            "sqrt(692835)*x*y*z*(x**2+y**2-6*z**2)*(x**6-7*x**4*y**2+7*x**2*y**4-y**6)/32",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(11,Eg,7,0)": (
            "C4",
            "3*sqrt(1001)*z*(-x**4+6*x**2*y**2-y**4)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(11,Eg,7,1)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x**2-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(11,Eg,8,0)": (
            "C2",
            "sqrt(2145)*z*(x**2-y**2)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,Eg,8,1)": (
            "-S2",
            "sqrt(2145)*x*y*z*(-21*x**8-84*x**6*y**2+336*x**6*z**2-126*x**4*y**4+1008*x**4*y**2*z**2-1008*x**4*z**4-84*x**2*y**6+1008*x**2*y**4*z**2-2016*x**2*y**2*z**4+768*x**2*z**6-21*y**8+336*y**6*z**2-1008*y**4*z**4+768*y**2*z**6-128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
    },
    "C6": {
        "Gh(0,A,,)": ("C0", "1", "[1]"),
        "Gh(1,A,,)": ("C0", "z", "[0,1,0]"),
        "Gh(1,E1,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Gh(1,E1,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Gh(2,A,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Gh(2,E1,,0)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Gh(2,E1,,1)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Gh(2,E2,,0)": ("C2", "sqrt(3)*(x**2-y**2)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Gh(2,E2,,1)": ("-S2", "-sqrt(3)*x*y", "[sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2]"),
        "Gh(3,A,,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Gh(3,B,1,)": ("S3", "sqrt(10)*y*(3*x**2-y**2)/4", "[sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2]"),
        "Gh(3,B,2,)": ("C3", "sqrt(10)*x*(x**2-3*y**2)/4", "[-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2]"),
        "Gh(3,E1,,0)": ("C1", "sqrt(6)*x*(-x**2-y**2+4*z**2)/4", "[0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0]"),
        "Gh(3,E1,,1)": ("S1", "sqrt(6)*y*(-x**2-y**2+4*z**2)/4", "[0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0]"),
        "Gh(3,E2,,0)": ("C2", "sqrt(15)*z*(x**2-y**2)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Gh(3,E2,,1)": ("-S2", "-sqrt(15)*x*y*z", "[0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0]"),
        "Gh(4,A,,)": ("C0", "3*x**4/8+3*x**2*y**2/4-3*x**2*z**2+3*y**4/8-3*y**2*z**2+z**4", "[0,0,0,0,1,0,0,0,0]"),
        "Gh(4,B,1,)": ("C3", "sqrt(70)*x*z*(x**2-3*y**2)/4", "[0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0]"),
        "Gh(4,B,2,)": ("S3", "sqrt(70)*y*z*(3*x**2-y**2)/4", "[0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Gh(4,E1,,0)": ("C1", "sqrt(10)*x*z*(-3*x**2-3*y**2+4*z**2)/4", "[0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0]"),
        "Gh(4,E1,,1)": ("S1", "sqrt(10)*y*z*(-3*x**2-3*y**2+4*z**2)/4", "[0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0]"),
        "Gh(4,E2,1,0)": ("C4", "sqrt(35)*(x**4-6*x**2*y**2+y**4)/8", "[sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Gh(4,E2,1,1)": ("S4", "sqrt(35)*x*y*(x**2-y**2)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Gh(4,E2,2,0)": ("C2", "sqrt(5)*(-x**2+y**2)*(x**2+y**2-6*z**2)/4", "[0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0]"),
        "Gh(4,E2,2,1)": ("-S2", "sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0]"),
        "Gh(5,A,,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Gh(5,B,1,)": ("S3", "-sqrt(70)*y*(3*x**2-y**2)*(x**2+y**2-8*z**2)/16", "[0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0]"),
        "Gh(5,B,2,)": ("C3", "-sqrt(70)*x*(x**2-3*y**2)*(x**2+y**2-8*z**2)/16", "[0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0]"),
        "Gh(5,E1,1,0)": ("C5", "3*sqrt(14)*x*(x**4-10*x**2*y**2+5*y**4)/16", "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Gh(5,E1,1,1)": ("-S5", "3*sqrt(14)*y*(-5*x**4+10*x**2*y**2-y**4)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]"),
        "Gh(5,E1,2,0)": (
            "C1",
            "sqrt(15)*x*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(5,E1,2,1)": (
            "S1",
            "sqrt(15)*y*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(5,E2,1,0)": ("C4", "3*sqrt(35)*z*(x**4-6*x**2*y**2+y**4)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Gh(5,E2,1,1)": ("S4", "3*sqrt(35)*x*y*z*(x**2-y**2)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Gh(5,E2,2,0)": ("C2", "sqrt(105)*z*(-x**2+y**2)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Gh(5,E2,2,1)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Gh(6,A,1,)": (
            "C0",
            "-5*x**6/16-15*x**4*y**2/16+45*x**4*z**2/8-15*x**2*y**4/16+45*x**2*y**2*z**2/4-15*x**2*z**4/2-5*y**6/16+45*y**4*z**2/8-15*y**2*z**4/2+z**6",
            "[0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Gh(6,A,2,)": (
            "C6",
            "sqrt(462)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(6,A,3,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Gh(6,B,1,)": (
            "C3",
            "-sqrt(210)*x*z*(x**2-3*y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(6,B,2,)": (
            "S3",
            "-sqrt(210)*y*z*(3*x**2-y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(6,E1,1,0)": ("C5", "3*sqrt(154)*x*z*(x**4-10*x**2*y**2+5*y**4)/16", "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Gh(6,E1,1,1)": (
            "-S5",
            "3*sqrt(154)*y*z*(-5*x**4+10*x**2*y**2-y**4)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Gh(6,E1,2,0)": (
            "C1",
            "sqrt(21)*x*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(6,E1,2,1)": (
            "S1",
            "sqrt(21)*y*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(6,E2,1,0)": (
            "C4",
            "3*sqrt(7)*(x**2+y**2-10*z**2)*(-x**4+6*x**2*y**2-y**4)/16",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(6,E2,1,1)": (
            "S4",
            "-3*sqrt(7)*x*y*(x**2-y**2)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(6,E2,2,0)": (
            "C2",
            "sqrt(210)*(x**2-y**2)*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(6,E2,2,1)": (
            "-S2",
            "sqrt(210)*x*y*(-x**4-2*x**2*y**2+16*x**2*z**2-y**4+16*y**2*z**2-16*z**4)/16",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(7,A,1,)": (
            "S6",
            "sqrt(6006)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Gh(7,A,2,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Gh(7,A,3,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(7,B,1,)": (
            "S3",
            "sqrt(21)*y*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(7,B,2,)": (
            "C3",
            "sqrt(21)*x*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(7,E1,1,0)": (
            "C7",
            "sqrt(429)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(7,E1,1,1)": (
            "S7",
            "sqrt(429)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(7,E1,2,0)": (
            "C5",
            "sqrt(231)*x*(x**2+y**2-12*z**2)*(-x**4+10*x**2*y**2-5*y**4)/32",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(7,E1,2,1)": (
            "-S5",
            "sqrt(231)*y*(x**2+y**2-12*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Gh(7,E1,3,0)": (
            "C1",
            "sqrt(7)*x*(-5*x**6-15*x**4*y**2+120*x**4*z**2-15*x**2*y**4+240*x**2*y**2*z**2-240*x**2*z**4-5*y**6+120*y**4*z**2-240*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(7,E1,3,1)": (
            "S1",
            "sqrt(7)*y*(-5*x**6-15*x**4*y**2+120*x**4*z**2-15*x**2*y**4+240*x**2*y**2*z**2-240*x**2*z**4-5*y**6+120*y**4*z**2-240*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(7,E2,1,0)": (
            "C4",
            "sqrt(231)*z*(3*x**2+3*y**2-10*z**2)*(-x**4+6*x**2*y**2-y**4)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(7,E2,1,1)": (
            "S4",
            "-sqrt(231)*x*y*z*(x**2-y**2)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(7,E2,2,0)": (
            "C2",
            "sqrt(42)*z*(x**2-y**2)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(7,E2,2,1)": (
            "-S2",
            "sqrt(42)*x*y*z*(-15*x**4-30*x**2*y**2+80*x**2*z**2-15*y**4+80*y**2*z**2-48*z**4)/16",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(8,A,1,)": (
            "C0",
            "35*x**8/128+35*x**6*y**2/32-35*x**6*z**2/4+105*x**4*y**4/64-105*x**4*y**2*z**2/4+105*x**4*z**4/4+35*x**2*y**6/32-105*x**2*y**4*z**2/4+105*x**2*y**2*z**4/2-14*x**2*z**6+35*y**8/128-35*y**6*z**2/4+105*y**4*z**4/4-14*y**2*z**6+z**8",
            "[0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0]",
        ),
        "Gh(8,A,2,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(8,A,3,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(8,B,1,)": (
            "C3",
            "sqrt(1155)*x*z*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(8,B,2,)": (
            "S3",
            "sqrt(1155)*y*z*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(8,E1,1,0)": (
            "C7",
            "3*sqrt(715)*x*z*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(8,E1,1,1)": (
            "S7",
            "3*sqrt(715)*y*z*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Gh(8,E1,2,0)": (
            "C5",
            "3*sqrt(1001)*x*z*(x**2+y**2-4*z**2)*(-x**4+10*x**2*y**2-5*y**4)/32",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(8,E1,2,1)": (
            "-S5",
            "3*sqrt(1001)*y*z*(x**2+y**2-4*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(8,E1,3,0)": (
            "C1",
            "3*x*z*(-35*x**6-105*x**4*y**2+280*x**4*z**2-105*x**2*y**4+560*x**2*y**2*z**2-336*x**2*z**4-35*y**6+280*y**4*z**2-336*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(8,E1,3,1)": (
            "S1",
            "3*y*z*(-35*x**6-105*x**4*y**2+280*x**4*z**2-105*x**2*y**4+560*x**2*y**2*z**2-336*x**2*z**4-35*y**6+280*y**4*z**2-336*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(8,E2,1,0)": (
            "C8",
            "3*sqrt(715)*(x**8-28*x**6*y**2+70*x**4*y**4-28*x**2*y**6+y**8)/128",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(8,E2,1,1)": (
            "-S8",
            "3*sqrt(715)*x*y*(-x**6+7*x**4*y**2-7*x**2*y**4+y**6)/16",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Gh(8,E2,2,0)": (
            "C4",
            "3*sqrt(77)*(x**4-6*x**2*y**2+y**4)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/64",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(8,E2,2,1)": (
            "S4",
            "3*sqrt(77)*x*y*(x**2-y**2)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(8,E2,3,0)": (
            "C2",
            "3*sqrt(70)*(-x**2+y**2)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(8,E2,3,1)": (
            "-S2",
            "3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(9,A,1,)": (
            "S6",
            "-sqrt(4290)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**2+3*y**2-14*z**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(9,A,2,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(9,A,3,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(9,B,1,)": (
            "S9",
            "sqrt(24310)*y*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(9,B,2,)": (
            "S3",
            "-sqrt(2310)*y*(3*x**2-y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(9,B,3,)": (
            "C9",
            "sqrt(24310)*x*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(9,B,4,)": (
            "C3",
            "-sqrt(2310)*x*(x**2-3*y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(9,E1,1,0)": (
            "C7",
            "3*sqrt(1430)*x*(x**2+y**2-16*z**2)*(-x**6+21*x**4*y**2-35*x**2*y**4+7*y**6)/256",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(9,E1,1,1)": (
            "S7",
            "-3*sqrt(1430)*y*(x**2+y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(9,E1,2,0)": (
            "C5",
            "3*sqrt(286)*x*(x**4-10*x**2*y**2+5*y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(9,E1,2,1)": (
            "-S5",
            "-3*sqrt(286)*y*(5*x**4-10*x**2*y**2+y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(9,E1,3,0)": (
            "C1",
            "3*sqrt(5)*x*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(9,E1,3,1)": (
            "S1",
            "3*sqrt(5)*y*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(9,E2,1,0)": (
            "C8",
            "3*sqrt(12155)*z*(x**8-28*x**6*y**2+70*x**4*y**4-28*x**2*y**6+y**8)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(9,E2,1,1)": (
            "-S8",
            "3*sqrt(12155)*x*y*z*(-x**6+7*x**4*y**2-7*x**2*y**4+y**6)/16",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Gh(9,E2,2,0)": (
            "C4",
            "3*sqrt(5005)*z*(x**4-6*x**2*y**2+y**4)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(9,E2,2,1)": (
            "S4",
            "3*sqrt(5005)*x*y*z*(x**2-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/16",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(9,E2,3,0)": (
            "C2",
            "3*sqrt(110)*z*(-x**2+y**2)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(9,E2,3,1)": (
            "-S2",
            "3*sqrt(110)*x*y*z*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(10,A,1,)": (
            "C0",
            "-63*x**10/256-315*x**8*y**2/256+1575*x**8*z**2/128-315*x**6*y**4/128+1575*x**6*y**2*z**2/32-525*x**6*z**4/8-315*x**4*y**6/128+4725*x**4*y**4*z**2/64-1575*x**4*y**2*z**4/8+315*x**4*z**6/4-315*x**2*y**8/256+1575*x**2*y**6*z**2/32-1575*x**2*y**4*z**4/8+315*x**2*y**2*z**6/2-45*x**2*z**8/2-63*y**10/256+1575*y**8*z**2/128-525*y**6*z**4/8+315*y**4*z**6/4-45*y**2*z**8/2+z**10",
            "[0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(10,A,2,)": (
            "C6",
            "sqrt(4290)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(10,A,3,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(10,B,1,)": (
            "C9",
            "sqrt(461890)*x*z*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(10,B,2,)": (
            "C3",
            "-sqrt(4290)*x*z*(x**2-3*y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(10,B,3,)": (
            "S9",
            "sqrt(461890)*y*z*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Gh(10,B,4,)": (
            "S3",
            "-sqrt(4290)*y*z*(3*x**2-y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(10,E1,1,0)": (
            "C7",
            "sqrt(72930)*x*z*(3*x**2+3*y**2-16*z**2)*(-x**6+21*x**4*y**2-35*x**2*y**4+7*y**6)/256",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(10,E1,1,1)": (
            "S7",
            "-sqrt(72930)*y*z*(3*x**2+3*y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(10,E1,2,0)": (
            "C5",
            "sqrt(858)*x*z*(x**4-10*x**2*y**2+5*y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(10,E1,2,1)": (
            "-S5",
            "-sqrt(858)*y*z*(5*x**4-10*x**2*y**2+y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(10,E1,3,0)": (
            "C1",
            "sqrt(55)*x*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(10,E1,3,1)": (
            "S1",
            "sqrt(55)*y*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(10,E2,1,0)": (
            "C10",
            "sqrt(92378)*(x**10-45*x**8*y**2+210*x**6*y**4-210*x**4*y**6+45*x**2*y**8-y**10)/512",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(10,E2,1,1)": (
            "S10",
            "sqrt(92378)*x*y*(5*x**8-60*x**6*y**2+126*x**4*y**4-60*x**2*y**6+5*y**8)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(10,E2,2,0)": (
            "C8",
            "sqrt(12155)*(x**2+y**2-18*z**2)*(-x**8+28*x**6*y**2-70*x**4*y**4+28*x**2*y**6-y**8)/256",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(10,E2,2,1)": (
            "-S8",
            "sqrt(12155)*x*y*(x**2+y**2-18*z**2)*(x**6-7*x**4*y**2+7*x**2*y**4-y**6)/32",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Gh(10,E2,3,0)": (
            "C4",
            "sqrt(2145)*(-x**4+6*x**2*y**2-y**4)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(10,E2,3,1)": (
            "S4",
            "-sqrt(2145)*x*y*(x**2-y**2)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(10,E2,4,0)": (
            "C2",
            "sqrt(165)*(x**2-y**2)*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/256",
            "[0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(10,E2,4,1)": (
            "-S2",
            "sqrt(165)*x*y*(-7*x**8-28*x**6*y**2+336*x**6*z**2-42*x**4*y**4+1008*x**4*y**2*z**2-1680*x**4*z**4-28*x**2*y**6+1008*x**2*y**4*z**2-3360*x**2*y**2*z**4+1792*x**2*z**6-7*y**8+336*y**6*z**2-1680*y**4*z**4+1792*y**2*z**6-384*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,A,1,)": (
            "S6",
            "sqrt(14586)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(11,A,2,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,A,3,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(11,B,1,)": (
            "S9",
            "-sqrt(46189)*y*(3*x**2-y**2)*(x**2+y**2-20*z**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/512",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(11,B,2,)": (
            "S3",
            "sqrt(30030)*y*(3*x**2-y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,B,3,)": (
            "C9",
            "-sqrt(46189)*x*(x**2-3*y**2)*(x**2+y**2-20*z**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/512",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(11,B,4,)": (
            "C3",
            "sqrt(30030)*x*(x**2-3*y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E1,1,0)": (
            "C11",
            "sqrt(88179)*x*(x**10-55*x**8*y**2+330*x**6*y**4-462*x**4*y**6+165*x**2*y**8-11*y**10)/512",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(11,E1,1,1)": (
            "-S11",
            "sqrt(88179)*y*(-11*x**10+165*x**8*y**2-462*x**6*y**4+330*x**4*y**6-55*x**2*y**8+y**10)/512",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Gh(11,E1,2,0)": (
            "C7",
            "sqrt(36465)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(11,E1,2,1)": (
            "S7",
            "sqrt(36465)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(11,E1,3,0)": (
            "C5",
            "3*sqrt(143)*x*(-x**4+10*x**2*y**2-5*y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(11,E1,3,1)": (
            "-S5",
            "3*sqrt(143)*y*(5*x**4-10*x**2*y**2+y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(11,E1,4,0)": (
            "C1",
            "sqrt(66)*x*(-21*x**10-105*x**8*y**2+1260*x**8*z**2-210*x**6*y**4+5040*x**6*y**2*z**2-8400*x**6*z**4-210*x**4*y**6+7560*x**4*y**4*z**2-25200*x**4*y**2*z**4+13440*x**4*z**6-105*x**2*y**8+5040*x**2*y**6*z**2-25200*x**2*y**4*z**4+26880*x**2*y**2*z**6-5760*x**2*z**8-21*y**10+1260*y**8*z**2-8400*y**6*z**4+13440*y**4*z**6-5760*y**2*z**8+512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E1,4,1)": (
            "S1",
            "sqrt(66)*y*(-21*x**10-105*x**8*y**2+1260*x**8*z**2-210*x**6*y**4+5040*x**6*y**2*z**2-8400*x**6*z**4-210*x**4*y**6+7560*x**4*y**4*z**2-25200*x**4*y**2*z**4+13440*x**4*z**6-105*x**2*y**8+5040*x**2*y**6*z**2-25200*x**2*y**4*z**4+26880*x**2*y**2*z**6-5760*x**2*z**8-21*y**10+1260*y**8*z**2-8400*y**6*z**4+13440*y**4*z**6-5760*y**2*z**8+512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E2,1,0)": (
            "C10",
            "sqrt(1939938)*z*(x**10-45*x**8*y**2+210*x**6*y**4-210*x**4*y**6+45*x**2*y**8-y**10)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(11,E2,1,1)": (
            "S10",
            "sqrt(1939938)*x*y*z*(5*x**8-60*x**6*y**2+126*x**4*y**4-60*x**2*y**6+5*y**8)/256",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Gh(11,E2,2,0)": (
            "C8",
            "sqrt(692835)*z*(x**2+y**2-6*z**2)*(-x**8+28*x**6*y**2-70*x**4*y**4+28*x**2*y**6-y**8)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(11,E2,2,1)": (
            "-S8",
            "sqrt(692835)*x*y*z*(x**2+y**2-6*z**2)*(x**6-7*x**4*y**2+7*x**2*y**4-y**6)/32",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(11,E2,3,0)": (
            "C4",
            "3*sqrt(1001)*z*(-x**4+6*x**2*y**2-y**4)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E2,3,1)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x**2-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E2,4,0)": (
            "C2",
            "sqrt(2145)*z*(x**2-y**2)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E2,4,1)": (
            "-S2",
            "sqrt(2145)*x*y*z*(-21*x**8-84*x**6*y**2+336*x**6*z**2-126*x**4*y**4+1008*x**4*y**2*z**2-1008*x**4*z**4-84*x**2*y**6+1008*x**2*y**4*z**2-2016*x**2*y**2*z**4+768*x**2*z**6-21*y**8+336*y**6*z**2-1008*y**4*z**4+768*y**2*z**6-128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
    },
    "C3h": {
        "Gh(0,A'',,)": ("C0", "1", "[1]"),
        "Gh(1,A',,)": ("C0", "z", "[0,1,0]"),
        "Gh(1,E'',,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Gh(1,E'',,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Gh(2,A'',,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Gh(2,E'',,0)": ("C2", "sqrt(3)*(x**2-y**2)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Gh(2,E'',,1)": ("-S2", "-sqrt(3)*x*y", "[sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2]"),
        "Gh(2,E',,0)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Gh(2,E',,1)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Gh(3,A'',1,)": ("S3", "sqrt(10)*y*(3*x**2-y**2)/4", "[sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2]"),
        "Gh(3,A'',2,)": ("C3", "sqrt(10)*x*(x**2-3*y**2)/4", "[-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2]"),
        "Gh(3,A',,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Gh(3,E'',,0)": ("C1", "sqrt(6)*x*(-x**2-y**2+4*z**2)/4", "[0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0]"),
        "Gh(3,E'',,1)": ("S1", "sqrt(6)*y*(-x**2-y**2+4*z**2)/4", "[0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0]"),
        "Gh(3,E',,0)": ("C2", "sqrt(15)*z*(x**2-y**2)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Gh(3,E',,1)": ("-S2", "-sqrt(15)*x*y*z", "[0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0]"),
        "Gh(4,A'',,)": ("C0", "3*x**4/8+3*x**2*y**2/4-3*x**2*z**2+3*y**4/8-3*y**2*z**2+z**4", "[0,0,0,0,1,0,0,0,0]"),
        "Gh(4,A',1,)": ("C3", "sqrt(70)*x*z*(x**2-3*y**2)/4", "[0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0]"),
        "Gh(4,A',2,)": ("S3", "sqrt(70)*y*z*(3*x**2-y**2)/4", "[0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Gh(4,E'',1,0)": ("C4", "sqrt(35)*(x**4-6*x**2*y**2+y**4)/8", "[sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Gh(4,E'',1,1)": ("S4", "sqrt(35)*x*y*(x**2-y**2)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Gh(4,E'',2,0)": ("C2", "sqrt(5)*(-x**2+y**2)*(x**2+y**2-6*z**2)/4", "[0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0]"),
        "Gh(4,E'',2,1)": ("-S2", "sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0]"),
        "Gh(4,E',,0)": ("C1", "sqrt(10)*x*z*(-3*x**2-3*y**2+4*z**2)/4", "[0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0]"),
        "Gh(4,E',,1)": ("S1", "sqrt(10)*y*z*(-3*x**2-3*y**2+4*z**2)/4", "[0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0]"),
        "Gh(5,A'',1,)": ("S3", "-sqrt(70)*y*(3*x**2-y**2)*(x**2+y**2-8*z**2)/16", "[0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0]"),
        "Gh(5,A'',2,)": ("C3", "-sqrt(70)*x*(x**2-3*y**2)*(x**2+y**2-8*z**2)/16", "[0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0]"),
        "Gh(5,A',,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Gh(5,E'',1,0)": ("C5", "3*sqrt(14)*x*(x**4-10*x**2*y**2+5*y**4)/16", "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Gh(5,E'',1,1)": ("-S5", "3*sqrt(14)*y*(-5*x**4+10*x**2*y**2-y**4)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]"),
        "Gh(5,E'',2,0)": (
            "C1",
            "sqrt(15)*x*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(5,E'',2,1)": (
            "S1",
            "sqrt(15)*y*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(5,E',1,0)": ("C4", "3*sqrt(35)*z*(x**4-6*x**2*y**2+y**4)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Gh(5,E',1,1)": ("S4", "3*sqrt(35)*x*y*z*(x**2-y**2)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Gh(5,E',2,0)": ("C2", "sqrt(105)*z*(-x**2+y**2)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Gh(5,E',2,1)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Gh(6,A'',1,)": (
            "C0",
            "-5*x**6/16-15*x**4*y**2/16+45*x**4*z**2/8-15*x**2*y**4/16+45*x**2*y**2*z**2/4-15*x**2*z**4/2-5*y**6/16+45*y**4*z**2/8-15*y**2*z**4/2+z**6",
            "[0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Gh(6,A'',2,)": (
            "C6",
            "sqrt(462)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(6,A'',3,)": (
            "S6",
            "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(6,A',1,)": (
            "C3",
            "-sqrt(210)*x*z*(x**2-3*y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(6,A',2,)": (
            "S3",
            "-sqrt(210)*y*z*(3*x**2-y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(6,E'',1,0)": (
            "C4",
            "3*sqrt(7)*(x**2+y**2-10*z**2)*(-x**4+6*x**2*y**2-y**4)/16",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(6,E'',1,1)": (
            "S4",
            "-3*sqrt(7)*x*y*(x**2-y**2)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(6,E'',2,0)": (
            "C2",
            "sqrt(210)*(x**2-y**2)*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(6,E'',2,1)": (
            "-S2",
            "sqrt(210)*x*y*(-x**4-2*x**2*y**2+16*x**2*z**2-y**4+16*y**2*z**2-16*z**4)/16",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(6,E',1,0)": ("C5", "3*sqrt(154)*x*z*(x**4-10*x**2*y**2+5*y**4)/16", "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Gh(6,E',1,1)": (
            "-S5",
            "3*sqrt(154)*y*z*(-5*x**4+10*x**2*y**2-y**4)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Gh(6,E',2,0)": (
            "C1",
            "sqrt(21)*x*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(6,E',2,1)": (
            "S1",
            "sqrt(21)*y*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(7,A'',1,)": (
            "S3",
            "sqrt(21)*y*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(7,A'',2,)": (
            "C3",
            "sqrt(21)*x*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(7,A',1,)": (
            "S6",
            "sqrt(6006)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Gh(7,A',2,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Gh(7,A',3,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(7,E'',1,0)": (
            "C7",
            "sqrt(429)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(7,E'',1,1)": (
            "S7",
            "sqrt(429)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(7,E'',2,0)": (
            "C5",
            "sqrt(231)*x*(x**2+y**2-12*z**2)*(-x**4+10*x**2*y**2-5*y**4)/32",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(7,E'',2,1)": (
            "-S5",
            "sqrt(231)*y*(x**2+y**2-12*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Gh(7,E'',3,0)": (
            "C1",
            "sqrt(7)*x*(-5*x**6-15*x**4*y**2+120*x**4*z**2-15*x**2*y**4+240*x**2*y**2*z**2-240*x**2*z**4-5*y**6+120*y**4*z**2-240*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(7,E'',3,1)": (
            "S1",
            "sqrt(7)*y*(-5*x**6-15*x**4*y**2+120*x**4*z**2-15*x**2*y**4+240*x**2*y**2*z**2-240*x**2*z**4-5*y**6+120*y**4*z**2-240*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(7,E',1,0)": (
            "C4",
            "sqrt(231)*z*(3*x**2+3*y**2-10*z**2)*(-x**4+6*x**2*y**2-y**4)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(7,E',1,1)": (
            "S4",
            "-sqrt(231)*x*y*z*(x**2-y**2)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(7,E',2,0)": (
            "C2",
            "sqrt(42)*z*(x**2-y**2)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(7,E',2,1)": (
            "-S2",
            "sqrt(42)*x*y*z*(-15*x**4-30*x**2*y**2+80*x**2*z**2-15*y**4+80*y**2*z**2-48*z**4)/16",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(8,A'',1,)": (
            "C0",
            "35*x**8/128+35*x**6*y**2/32-35*x**6*z**2/4+105*x**4*y**4/64-105*x**4*y**2*z**2/4+105*x**4*z**4/4+35*x**2*y**6/32-105*x**2*y**4*z**2/4+105*x**2*y**2*z**4/2-14*x**2*z**6+35*y**8/128-35*y**6*z**2/4+105*y**4*z**4/4-14*y**2*z**6+z**8",
            "[0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0]",
        ),
        "Gh(8,A'',2,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(8,A'',3,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(8,A',1,)": (
            "C3",
            "sqrt(1155)*x*z*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(8,A',2,)": (
            "S3",
            "sqrt(1155)*y*z*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(8,E'',1,0)": (
            "C8",
            "3*sqrt(715)*(x**8-28*x**6*y**2+70*x**4*y**4-28*x**2*y**6+y**8)/128",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(8,E'',1,1)": (
            "-S8",
            "3*sqrt(715)*x*y*(-x**6+7*x**4*y**2-7*x**2*y**4+y**6)/16",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Gh(8,E'',2,0)": (
            "C4",
            "3*sqrt(77)*(x**4-6*x**2*y**2+y**4)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/64",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(8,E'',2,1)": (
            "S4",
            "3*sqrt(77)*x*y*(x**2-y**2)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(8,E'',3,0)": (
            "C2",
            "3*sqrt(70)*(-x**2+y**2)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(8,E'',3,1)": (
            "-S2",
            "3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(8,E',1,0)": (
            "C7",
            "3*sqrt(715)*x*z*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(8,E',1,1)": (
            "S7",
            "3*sqrt(715)*y*z*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Gh(8,E',2,0)": (
            "C5",
            "3*sqrt(1001)*x*z*(x**2+y**2-4*z**2)*(-x**4+10*x**2*y**2-5*y**4)/32",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(8,E',2,1)": (
            "-S5",
            "3*sqrt(1001)*y*z*(x**2+y**2-4*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(8,E',3,0)": (
            "C1",
            "3*x*z*(-35*x**6-105*x**4*y**2+280*x**4*z**2-105*x**2*y**4+560*x**2*y**2*z**2-336*x**2*z**4-35*y**6+280*y**4*z**2-336*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(8,E',3,1)": (
            "S1",
            "3*y*z*(-35*x**6-105*x**4*y**2+280*x**4*z**2-105*x**2*y**4+560*x**2*y**2*z**2-336*x**2*z**4-35*y**6+280*y**4*z**2-336*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(9,A'',1,)": (
            "S9",
            "sqrt(24310)*y*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(9,A'',2,)": (
            "S3",
            "-sqrt(2310)*y*(3*x**2-y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(9,A'',3,)": (
            "C9",
            "sqrt(24310)*x*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(9,A'',4,)": (
            "C3",
            "-sqrt(2310)*x*(x**2-3*y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(9,A',1,)": (
            "S6",
            "-sqrt(4290)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**2+3*y**2-14*z**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(9,A',2,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(9,A',3,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(9,E'',1,0)": (
            "C7",
            "3*sqrt(1430)*x*(x**2+y**2-16*z**2)*(-x**6+21*x**4*y**2-35*x**2*y**4+7*y**6)/256",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(9,E'',1,1)": (
            "S7",
            "-3*sqrt(1430)*y*(x**2+y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(9,E'',2,0)": (
            "C5",
            "3*sqrt(286)*x*(x**4-10*x**2*y**2+5*y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(9,E'',2,1)": (
            "-S5",
            "-3*sqrt(286)*y*(5*x**4-10*x**2*y**2+y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(9,E'',3,0)": (
            "C1",
            "3*sqrt(5)*x*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(9,E'',3,1)": (
            "S1",
            "3*sqrt(5)*y*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(9,E',1,0)": (
            "C8",
            "3*sqrt(12155)*z*(x**8-28*x**6*y**2+70*x**4*y**4-28*x**2*y**6+y**8)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(9,E',1,1)": (
            "-S8",
            "3*sqrt(12155)*x*y*z*(-x**6+7*x**4*y**2-7*x**2*y**4+y**6)/16",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Gh(9,E',2,0)": (
            "C4",
            "3*sqrt(5005)*z*(x**4-6*x**2*y**2+y**4)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(9,E',2,1)": (
            "S4",
            "3*sqrt(5005)*x*y*z*(x**2-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/16",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(9,E',3,0)": (
            "C2",
            "3*sqrt(110)*z*(-x**2+y**2)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(9,E',3,1)": (
            "-S2",
            "3*sqrt(110)*x*y*z*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(10,A'',1,)": (
            "C0",
            "-63*x**10/256-315*x**8*y**2/256+1575*x**8*z**2/128-315*x**6*y**4/128+1575*x**6*y**2*z**2/32-525*x**6*z**4/8-315*x**4*y**6/128+4725*x**4*y**4*z**2/64-1575*x**4*y**2*z**4/8+315*x**4*z**6/4-315*x**2*y**8/256+1575*x**2*y**6*z**2/32-1575*x**2*y**4*z**4/8+315*x**2*y**2*z**6/2-45*x**2*z**8/2-63*y**10/256+1575*y**8*z**2/128-525*y**6*z**4/8+315*y**4*z**6/4-45*y**2*z**8/2+z**10",
            "[0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(10,A'',2,)": (
            "C6",
            "sqrt(4290)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(10,A'',3,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(10,A',1,)": (
            "C9",
            "sqrt(461890)*x*z*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(10,A',2,)": (
            "C3",
            "-sqrt(4290)*x*z*(x**2-3*y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(10,A',3,)": (
            "S9",
            "sqrt(461890)*y*z*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Gh(10,A',4,)": (
            "S3",
            "-sqrt(4290)*y*z*(3*x**2-y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(10,E'',1,0)": (
            "C10",
            "sqrt(92378)*(x**10-45*x**8*y**2+210*x**6*y**4-210*x**4*y**6+45*x**2*y**8-y**10)/512",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(10,E'',1,1)": (
            "S10",
            "sqrt(92378)*x*y*(5*x**8-60*x**6*y**2+126*x**4*y**4-60*x**2*y**6+5*y**8)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(10,E'',2,0)": (
            "C8",
            "sqrt(12155)*(x**2+y**2-18*z**2)*(-x**8+28*x**6*y**2-70*x**4*y**4+28*x**2*y**6-y**8)/256",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(10,E'',2,1)": (
            "-S8",
            "sqrt(12155)*x*y*(x**2+y**2-18*z**2)*(x**6-7*x**4*y**2+7*x**2*y**4-y**6)/32",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Gh(10,E'',3,0)": (
            "C4",
            "sqrt(2145)*(-x**4+6*x**2*y**2-y**4)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(10,E'',3,1)": (
            "S4",
            "-sqrt(2145)*x*y*(x**2-y**2)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(10,E'',4,0)": (
            "C2",
            "sqrt(165)*(x**2-y**2)*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/256",
            "[0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(10,E'',4,1)": (
            "-S2",
            "sqrt(165)*x*y*(-7*x**8-28*x**6*y**2+336*x**6*z**2-42*x**4*y**4+1008*x**4*y**2*z**2-1680*x**4*z**4-28*x**2*y**6+1008*x**2*y**4*z**2-3360*x**2*y**2*z**4+1792*x**2*z**6-7*y**8+336*y**6*z**2-1680*y**4*z**4+1792*y**2*z**6-384*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(10,E',1,0)": (
            "C7",
            "sqrt(72930)*x*z*(3*x**2+3*y**2-16*z**2)*(-x**6+21*x**4*y**2-35*x**2*y**4+7*y**6)/256",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(10,E',1,1)": (
            "S7",
            "-sqrt(72930)*y*z*(3*x**2+3*y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(10,E',2,0)": (
            "C5",
            "sqrt(858)*x*z*(x**4-10*x**2*y**2+5*y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(10,E',2,1)": (
            "-S5",
            "-sqrt(858)*y*z*(5*x**4-10*x**2*y**2+y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(10,E',3,0)": (
            "C1",
            "sqrt(55)*x*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(10,E',3,1)": (
            "S1",
            "sqrt(55)*y*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,A'',1,)": (
            "S9",
            "-sqrt(46189)*y*(3*x**2-y**2)*(x**2+y**2-20*z**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/512",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(11,A'',2,)": (
            "S3",
            "sqrt(30030)*y*(3*x**2-y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,A'',3,)": (
            "C9",
            "-sqrt(46189)*x*(x**2-3*y**2)*(x**2+y**2-20*z**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/512",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(11,A'',4,)": (
            "C3",
            "sqrt(30030)*x*(x**2-3*y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,A',1,)": (
            "S6",
            "sqrt(14586)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(11,A',2,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,A',3,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(11,E'',1,0)": (
            "C11",
            "sqrt(88179)*x*(x**10-55*x**8*y**2+330*x**6*y**4-462*x**4*y**6+165*x**2*y**8-11*y**10)/512",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(11,E'',1,1)": (
            "-S11",
            "sqrt(88179)*y*(-11*x**10+165*x**8*y**2-462*x**6*y**4+330*x**4*y**6-55*x**2*y**8+y**10)/512",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Gh(11,E'',2,0)": (
            "C7",
            "sqrt(36465)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(11,E'',2,1)": (
            "S7",
            "sqrt(36465)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(11,E'',3,0)": (
            "C5",
            "3*sqrt(143)*x*(-x**4+10*x**2*y**2-5*y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(11,E'',3,1)": (
            "-S5",
            "3*sqrt(143)*y*(5*x**4-10*x**2*y**2+y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(11,E'',4,0)": (
            "C1",
            "sqrt(66)*x*(-21*x**10-105*x**8*y**2+1260*x**8*z**2-210*x**6*y**4+5040*x**6*y**2*z**2-8400*x**6*z**4-210*x**4*y**6+7560*x**4*y**4*z**2-25200*x**4*y**2*z**4+13440*x**4*z**6-105*x**2*y**8+5040*x**2*y**6*z**2-25200*x**2*y**4*z**4+26880*x**2*y**2*z**6-5760*x**2*z**8-21*y**10+1260*y**8*z**2-8400*y**6*z**4+13440*y**4*z**6-5760*y**2*z**8+512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E'',4,1)": (
            "S1",
            "sqrt(66)*y*(-21*x**10-105*x**8*y**2+1260*x**8*z**2-210*x**6*y**4+5040*x**6*y**2*z**2-8400*x**6*z**4-210*x**4*y**6+7560*x**4*y**4*z**2-25200*x**4*y**2*z**4+13440*x**4*z**6-105*x**2*y**8+5040*x**2*y**6*z**2-25200*x**2*y**4*z**4+26880*x**2*y**2*z**6-5760*x**2*z**8-21*y**10+1260*y**8*z**2-8400*y**6*z**4+13440*y**4*z**6-5760*y**2*z**8+512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E',1,0)": (
            "C10",
            "sqrt(1939938)*z*(x**10-45*x**8*y**2+210*x**6*y**4-210*x**4*y**6+45*x**2*y**8-y**10)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(11,E',1,1)": (
            "S10",
            "sqrt(1939938)*x*y*z*(5*x**8-60*x**6*y**2+126*x**4*y**4-60*x**2*y**6+5*y**8)/256",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Gh(11,E',2,0)": (
            "C8",
            "sqrt(692835)*z*(x**2+y**2-6*z**2)*(-x**8+28*x**6*y**2-70*x**4*y**4+28*x**2*y**6-y**8)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(11,E',2,1)": (
            "-S8",
            "sqrt(692835)*x*y*z*(x**2+y**2-6*z**2)*(x**6-7*x**4*y**2+7*x**2*y**4-y**6)/32",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(11,E',3,0)": (
            "C4",
            "3*sqrt(1001)*z*(-x**4+6*x**2*y**2-y**4)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E',3,1)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x**2-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E',4,0)": (
            "C2",
            "sqrt(2145)*z*(x**2-y**2)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E',4,1)": (
            "-S2",
            "sqrt(2145)*x*y*z*(-21*x**8-84*x**6*y**2+336*x**6*z**2-126*x**4*y**4+1008*x**4*y**2*z**2-1008*x**4*z**4-84*x**2*y**6+1008*x**2*y**4*z**2-2016*x**2*y**2*z**4+768*x**2*z**6-21*y**8+336*y**6*z**2-1008*y**4*z**4+768*y**2*z**6-128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
    },
    "C6h": {
        "Gh(0,Au,,)": ("C0", "1", "[1]"),
        "Gh(1,Ag,,)": ("C0", "z", "[0,1,0]"),
        "Gh(1,E1g,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Gh(1,E1g,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Gh(2,Au,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Gh(2,E1u,,0)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Gh(2,E1u,,1)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Gh(2,E2u,,0)": ("C2", "sqrt(3)*(x**2-y**2)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Gh(2,E2u,,1)": ("-S2", "-sqrt(3)*x*y", "[sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2]"),
        "Gh(3,Ag,,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Gh(3,Bg,1,)": ("S3", "sqrt(10)*y*(3*x**2-y**2)/4", "[sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2]"),
        "Gh(3,Bg,2,)": ("C3", "sqrt(10)*x*(x**2-3*y**2)/4", "[-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2]"),
        "Gh(3,E1g,,0)": ("C1", "sqrt(6)*x*(-x**2-y**2+4*z**2)/4", "[0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0]"),
        "Gh(3,E1g,,1)": ("S1", "sqrt(6)*y*(-x**2-y**2+4*z**2)/4", "[0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0]"),
        "Gh(3,E2g,,0)": ("C2", "sqrt(15)*z*(x**2-y**2)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Gh(3,E2g,,1)": ("-S2", "-sqrt(15)*x*y*z", "[0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0]"),
        "Gh(4,Au,,)": ("C0", "3*x**4/8+3*x**2*y**2/4-3*x**2*z**2+3*y**4/8-3*y**2*z**2+z**4", "[0,0,0,0,1,0,0,0,0]"),
        "Gh(4,Bu,1,)": ("C3", "sqrt(70)*x*z*(x**2-3*y**2)/4", "[0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0]"),
        "Gh(4,Bu,2,)": ("S3", "sqrt(70)*y*z*(3*x**2-y**2)/4", "[0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Gh(4,E1u,,0)": ("C1", "sqrt(10)*x*z*(-3*x**2-3*y**2+4*z**2)/4", "[0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0]"),
        "Gh(4,E1u,,1)": ("S1", "sqrt(10)*y*z*(-3*x**2-3*y**2+4*z**2)/4", "[0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0]"),
        "Gh(4,E2u,1,0)": ("C4", "sqrt(35)*(x**4-6*x**2*y**2+y**4)/8", "[sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Gh(4,E2u,1,1)": ("S4", "sqrt(35)*x*y*(x**2-y**2)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Gh(4,E2u,2,0)": ("C2", "sqrt(5)*(-x**2+y**2)*(x**2+y**2-6*z**2)/4", "[0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0]"),
        "Gh(4,E2u,2,1)": ("-S2", "sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0]"),
        "Gh(5,Ag,,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Gh(5,Bg,1,)": ("S3", "-sqrt(70)*y*(3*x**2-y**2)*(x**2+y**2-8*z**2)/16", "[0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0]"),
        "Gh(5,Bg,2,)": ("C3", "-sqrt(70)*x*(x**2-3*y**2)*(x**2+y**2-8*z**2)/16", "[0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0]"),
        "Gh(5,E1g,1,0)": ("C5", "3*sqrt(14)*x*(x**4-10*x**2*y**2+5*y**4)/16", "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Gh(5,E1g,1,1)": ("-S5", "3*sqrt(14)*y*(-5*x**4+10*x**2*y**2-y**4)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]"),
        "Gh(5,E1g,2,0)": (
            "C1",
            "sqrt(15)*x*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(5,E1g,2,1)": (
            "S1",
            "sqrt(15)*y*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(5,E2g,1,0)": ("C4", "3*sqrt(35)*z*(x**4-6*x**2*y**2+y**4)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Gh(5,E2g,1,1)": ("S4", "3*sqrt(35)*x*y*z*(x**2-y**2)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Gh(5,E2g,2,0)": ("C2", "sqrt(105)*z*(-x**2+y**2)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Gh(5,E2g,2,1)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Gh(6,Au,1,)": (
            "C0",
            "-5*x**6/16-15*x**4*y**2/16+45*x**4*z**2/8-15*x**2*y**4/16+45*x**2*y**2*z**2/4-15*x**2*z**4/2-5*y**6/16+45*y**4*z**2/8-15*y**2*z**4/2+z**6",
            "[0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Gh(6,Au,2,)": (
            "C6",
            "sqrt(462)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(6,Au,3,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Gh(6,Bu,1,)": (
            "C3",
            "-sqrt(210)*x*z*(x**2-3*y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(6,Bu,2,)": (
            "S3",
            "-sqrt(210)*y*z*(3*x**2-y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(6,E1u,1,0)": ("C5", "3*sqrt(154)*x*z*(x**4-10*x**2*y**2+5*y**4)/16", "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Gh(6,E1u,1,1)": (
            "-S5",
            "3*sqrt(154)*y*z*(-5*x**4+10*x**2*y**2-y**4)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Gh(6,E1u,2,0)": (
            "C1",
            "sqrt(21)*x*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(6,E1u,2,1)": (
            "S1",
            "sqrt(21)*y*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(6,E2u,1,0)": (
            "C4",
            "3*sqrt(7)*(x**2+y**2-10*z**2)*(-x**4+6*x**2*y**2-y**4)/16",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(6,E2u,1,1)": (
            "S4",
            "-3*sqrt(7)*x*y*(x**2-y**2)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(6,E2u,2,0)": (
            "C2",
            "sqrt(210)*(x**2-y**2)*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(6,E2u,2,1)": (
            "-S2",
            "sqrt(210)*x*y*(-x**4-2*x**2*y**2+16*x**2*z**2-y**4+16*y**2*z**2-16*z**4)/16",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(7,Ag,1,)": (
            "S6",
            "sqrt(6006)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Gh(7,Ag,2,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Gh(7,Ag,3,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(7,Bg,1,)": (
            "S3",
            "sqrt(21)*y*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(7,Bg,2,)": (
            "C3",
            "sqrt(21)*x*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(7,E1g,1,0)": (
            "C7",
            "sqrt(429)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(7,E1g,1,1)": (
            "S7",
            "sqrt(429)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(7,E1g,2,0)": (
            "C5",
            "sqrt(231)*x*(x**2+y**2-12*z**2)*(-x**4+10*x**2*y**2-5*y**4)/32",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(7,E1g,2,1)": (
            "-S5",
            "sqrt(231)*y*(x**2+y**2-12*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Gh(7,E1g,3,0)": (
            "C1",
            "sqrt(7)*x*(-5*x**6-15*x**4*y**2+120*x**4*z**2-15*x**2*y**4+240*x**2*y**2*z**2-240*x**2*z**4-5*y**6+120*y**4*z**2-240*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(7,E1g,3,1)": (
            "S1",
            "sqrt(7)*y*(-5*x**6-15*x**4*y**2+120*x**4*z**2-15*x**2*y**4+240*x**2*y**2*z**2-240*x**2*z**4-5*y**6+120*y**4*z**2-240*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(7,E2g,1,0)": (
            "C4",
            "sqrt(231)*z*(3*x**2+3*y**2-10*z**2)*(-x**4+6*x**2*y**2-y**4)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(7,E2g,1,1)": (
            "S4",
            "-sqrt(231)*x*y*z*(x**2-y**2)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(7,E2g,2,0)": (
            "C2",
            "sqrt(42)*z*(x**2-y**2)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(7,E2g,2,1)": (
            "-S2",
            "sqrt(42)*x*y*z*(-15*x**4-30*x**2*y**2+80*x**2*z**2-15*y**4+80*y**2*z**2-48*z**4)/16",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(8,Au,1,)": (
            "C0",
            "35*x**8/128+35*x**6*y**2/32-35*x**6*z**2/4+105*x**4*y**4/64-105*x**4*y**2*z**2/4+105*x**4*z**4/4+35*x**2*y**6/32-105*x**2*y**4*z**2/4+105*x**2*y**2*z**4/2-14*x**2*z**6+35*y**8/128-35*y**6*z**2/4+105*y**4*z**4/4-14*y**2*z**6+z**8",
            "[0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0]",
        ),
        "Gh(8,Au,2,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(8,Au,3,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(8,Bu,1,)": (
            "C3",
            "sqrt(1155)*x*z*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(8,Bu,2,)": (
            "S3",
            "sqrt(1155)*y*z*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(8,E1u,1,0)": (
            "C7",
            "3*sqrt(715)*x*z*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(8,E1u,1,1)": (
            "S7",
            "3*sqrt(715)*y*z*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Gh(8,E1u,2,0)": (
            "C5",
            "3*sqrt(1001)*x*z*(x**2+y**2-4*z**2)*(-x**4+10*x**2*y**2-5*y**4)/32",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(8,E1u,2,1)": (
            "-S5",
            "3*sqrt(1001)*y*z*(x**2+y**2-4*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(8,E1u,3,0)": (
            "C1",
            "3*x*z*(-35*x**6-105*x**4*y**2+280*x**4*z**2-105*x**2*y**4+560*x**2*y**2*z**2-336*x**2*z**4-35*y**6+280*y**4*z**2-336*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(8,E1u,3,1)": (
            "S1",
            "3*y*z*(-35*x**6-105*x**4*y**2+280*x**4*z**2-105*x**2*y**4+560*x**2*y**2*z**2-336*x**2*z**4-35*y**6+280*y**4*z**2-336*y**2*z**4+64*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(8,E2u,1,0)": (
            "C8",
            "3*sqrt(715)*(x**8-28*x**6*y**2+70*x**4*y**4-28*x**2*y**6+y**8)/128",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(8,E2u,1,1)": (
            "-S8",
            "3*sqrt(715)*x*y*(-x**6+7*x**4*y**2-7*x**2*y**4+y**6)/16",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Gh(8,E2u,2,0)": (
            "C4",
            "3*sqrt(77)*(x**4-6*x**2*y**2+y**4)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/64",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(8,E2u,2,1)": (
            "S4",
            "3*sqrt(77)*x*y*(x**2-y**2)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(8,E2u,3,0)": (
            "C2",
            "3*sqrt(70)*(-x**2+y**2)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(8,E2u,3,1)": (
            "-S2",
            "3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(9,Ag,1,)": (
            "S6",
            "-sqrt(4290)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**2+3*y**2-14*z**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(9,Ag,2,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(9,Ag,3,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(9,Bg,1,)": (
            "S9",
            "sqrt(24310)*y*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(9,Bg,2,)": (
            "S3",
            "-sqrt(2310)*y*(3*x**2-y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(9,Bg,3,)": (
            "C9",
            "sqrt(24310)*x*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(9,Bg,4,)": (
            "C3",
            "-sqrt(2310)*x*(x**2-3*y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(9,E1g,1,0)": (
            "C7",
            "3*sqrt(1430)*x*(x**2+y**2-16*z**2)*(-x**6+21*x**4*y**2-35*x**2*y**4+7*y**6)/256",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(9,E1g,1,1)": (
            "S7",
            "-3*sqrt(1430)*y*(x**2+y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(9,E1g,2,0)": (
            "C5",
            "3*sqrt(286)*x*(x**4-10*x**2*y**2+5*y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(9,E1g,2,1)": (
            "-S5",
            "-3*sqrt(286)*y*(5*x**4-10*x**2*y**2+y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(9,E1g,3,0)": (
            "C1",
            "3*sqrt(5)*x*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(9,E1g,3,1)": (
            "S1",
            "3*sqrt(5)*y*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(9,E2g,1,0)": (
            "C8",
            "3*sqrt(12155)*z*(x**8-28*x**6*y**2+70*x**4*y**4-28*x**2*y**6+y**8)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(9,E2g,1,1)": (
            "-S8",
            "3*sqrt(12155)*x*y*z*(-x**6+7*x**4*y**2-7*x**2*y**4+y**6)/16",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Gh(9,E2g,2,0)": (
            "C4",
            "3*sqrt(5005)*z*(x**4-6*x**2*y**2+y**4)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(9,E2g,2,1)": (
            "S4",
            "3*sqrt(5005)*x*y*z*(x**2-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/16",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(9,E2g,3,0)": (
            "C2",
            "3*sqrt(110)*z*(-x**2+y**2)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(9,E2g,3,1)": (
            "-S2",
            "3*sqrt(110)*x*y*z*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(10,Au,1,)": (
            "C0",
            "-63*x**10/256-315*x**8*y**2/256+1575*x**8*z**2/128-315*x**6*y**4/128+1575*x**6*y**2*z**2/32-525*x**6*z**4/8-315*x**4*y**6/128+4725*x**4*y**4*z**2/64-1575*x**4*y**2*z**4/8+315*x**4*z**6/4-315*x**2*y**8/256+1575*x**2*y**6*z**2/32-1575*x**2*y**4*z**4/8+315*x**2*y**2*z**6/2-45*x**2*z**8/2-63*y**10/256+1575*y**8*z**2/128-525*y**6*z**4/8+315*y**4*z**6/4-45*y**2*z**8/2+z**10",
            "[0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(10,Au,2,)": (
            "C6",
            "sqrt(4290)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(10,Au,3,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(10,Bu,1,)": (
            "C9",
            "sqrt(461890)*x*z*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(10,Bu,2,)": (
            "C3",
            "-sqrt(4290)*x*z*(x**2-3*y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(10,Bu,3,)": (
            "S9",
            "sqrt(461890)*y*z*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Gh(10,Bu,4,)": (
            "S3",
            "-sqrt(4290)*y*z*(3*x**2-y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(10,E1u,1,0)": (
            "C7",
            "sqrt(72930)*x*z*(3*x**2+3*y**2-16*z**2)*(-x**6+21*x**4*y**2-35*x**2*y**4+7*y**6)/256",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(10,E1u,1,1)": (
            "S7",
            "-sqrt(72930)*y*z*(3*x**2+3*y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(10,E1u,2,0)": (
            "C5",
            "sqrt(858)*x*z*(x**4-10*x**2*y**2+5*y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(10,E1u,2,1)": (
            "-S5",
            "-sqrt(858)*y*z*(5*x**4-10*x**2*y**2+y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(10,E1u,3,0)": (
            "C1",
            "sqrt(55)*x*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(10,E1u,3,1)": (
            "S1",
            "sqrt(55)*y*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(10,E2u,1,0)": (
            "C10",
            "sqrt(92378)*(x**10-45*x**8*y**2+210*x**6*y**4-210*x**4*y**6+45*x**2*y**8-y**10)/512",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(10,E2u,1,1)": (
            "S10",
            "sqrt(92378)*x*y*(5*x**8-60*x**6*y**2+126*x**4*y**4-60*x**2*y**6+5*y**8)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(10,E2u,2,0)": (
            "C8",
            "sqrt(12155)*(x**2+y**2-18*z**2)*(-x**8+28*x**6*y**2-70*x**4*y**4+28*x**2*y**6-y**8)/256",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(10,E2u,2,1)": (
            "-S8",
            "sqrt(12155)*x*y*(x**2+y**2-18*z**2)*(x**6-7*x**4*y**2+7*x**2*y**4-y**6)/32",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Gh(10,E2u,3,0)": (
            "C4",
            "sqrt(2145)*(-x**4+6*x**2*y**2-y**4)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(10,E2u,3,1)": (
            "S4",
            "-sqrt(2145)*x*y*(x**2-y**2)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(10,E2u,4,0)": (
            "C2",
            "sqrt(165)*(x**2-y**2)*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/256",
            "[0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(10,E2u,4,1)": (
            "-S2",
            "sqrt(165)*x*y*(-7*x**8-28*x**6*y**2+336*x**6*z**2-42*x**4*y**4+1008*x**4*y**2*z**2-1680*x**4*z**4-28*x**2*y**6+1008*x**2*y**4*z**2-3360*x**2*y**2*z**4+1792*x**2*z**6-7*y**8+336*y**6*z**2-1680*y**4*z**4+1792*y**2*z**6-384*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,Ag,1,)": (
            "S6",
            "sqrt(14586)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Gh(11,Ag,2,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,Ag,3,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(11,Bg,1,)": (
            "S9",
            "-sqrt(46189)*y*(3*x**2-y**2)*(x**2+y**2-20*z**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/512",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(11,Bg,2,)": (
            "S3",
            "sqrt(30030)*y*(3*x**2-y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,Bg,3,)": (
            "C9",
            "-sqrt(46189)*x*(x**2-3*y**2)*(x**2+y**2-20*z**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/512",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(11,Bg,4,)": (
            "C3",
            "sqrt(30030)*x*(x**2-3*y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E1g,1,0)": (
            "C11",
            "sqrt(88179)*x*(x**10-55*x**8*y**2+330*x**6*y**4-462*x**4*y**6+165*x**2*y**8-11*y**10)/512",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Gh(11,E1g,1,1)": (
            "-S11",
            "sqrt(88179)*y*(-11*x**10+165*x**8*y**2-462*x**6*y**4+330*x**4*y**6-55*x**2*y**8+y**10)/512",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Gh(11,E1g,2,0)": (
            "C7",
            "sqrt(36465)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Gh(11,E1g,2,1)": (
            "S7",
            "sqrt(36465)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(11,E1g,3,0)": (
            "C5",
            "3*sqrt(143)*x*(-x**4+10*x**2*y**2-5*y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(11,E1g,3,1)": (
            "-S5",
            "3*sqrt(143)*y*(5*x**4-10*x**2*y**2+y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(11,E1g,4,0)": (
            "C1",
            "sqrt(66)*x*(-21*x**10-105*x**8*y**2+1260*x**8*z**2-210*x**6*y**4+5040*x**6*y**2*z**2-8400*x**6*z**4-210*x**4*y**6+7560*x**4*y**4*z**2-25200*x**4*y**2*z**4+13440*x**4*z**6-105*x**2*y**8+5040*x**2*y**6*z**2-25200*x**2*y**4*z**4+26880*x**2*y**2*z**6-5760*x**2*z**8-21*y**10+1260*y**8*z**2-8400*y**6*z**4+13440*y**4*z**6-5760*y**2*z**8+512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E1g,4,1)": (
            "S1",
            "sqrt(66)*y*(-21*x**10-105*x**8*y**2+1260*x**8*z**2-210*x**6*y**4+5040*x**6*y**2*z**2-8400*x**6*z**4-210*x**4*y**6+7560*x**4*y**4*z**2-25200*x**4*y**2*z**4+13440*x**4*z**6-105*x**2*y**8+5040*x**2*y**6*z**2-25200*x**2*y**4*z**4+26880*x**2*y**2*z**6-5760*x**2*z**8-21*y**10+1260*y**8*z**2-8400*y**6*z**4+13440*y**4*z**6-5760*y**2*z**8+512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E2g,1,0)": (
            "C10",
            "sqrt(1939938)*z*(x**10-45*x**8*y**2+210*x**6*y**4-210*x**4*y**6+45*x**2*y**8-y**10)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(11,E2g,1,1)": (
            "S10",
            "sqrt(1939938)*x*y*z*(5*x**8-60*x**6*y**2+126*x**4*y**4-60*x**2*y**6+5*y**8)/256",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Gh(11,E2g,2,0)": (
            "C8",
            "sqrt(692835)*z*(x**2+y**2-6*z**2)*(-x**8+28*x**6*y**2-70*x**4*y**4+28*x**2*y**6-y**8)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(11,E2g,2,1)": (
            "-S8",
            "sqrt(692835)*x*y*z*(x**2+y**2-6*z**2)*(x**6-7*x**4*y**2+7*x**2*y**4-y**6)/32",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(11,E2g,3,0)": (
            "C4",
            "3*sqrt(1001)*z*(-x**4+6*x**2*y**2-y**4)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E2g,3,1)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x**2-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E2g,4,0)": (
            "C2",
            "sqrt(2145)*z*(x**2-y**2)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E2g,4,1)": (
            "-S2",
            "sqrt(2145)*x*y*z*(-21*x**8-84*x**6*y**2+336*x**6*z**2-126*x**4*y**4+1008*x**4*y**2*z**2-1008*x**4*z**4-84*x**2*y**6+1008*x**2*y**4*z**2-2016*x**2*y**2*z**4+768*x**2*z**6-21*y**8+336*y**6*z**2-1008*y**4*z**4+768*y**2*z**6-128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
    },
    "T": {
        "Gh(0,A,,)": ("C0", "1", "[1]"),
        "Gh(1,T,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Gh(1,T,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Gh(1,T,,2)": ("C0", "z", "[0,1,0]"),
        "Gh(2,E,,0)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Gh(2,E,,1)": ("C2", "sqrt(3)*(x**2-y**2)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Gh(2,T,,0)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Gh(2,T,,1)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Gh(2,T,,2)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Gh(3,A,,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Gh(3,T,1,0)": (
            "-sqrt(6)*C1/4+sqrt(10)*C3/4",
            "x*(2*x**2-3*y**2-3*z**2)/2",
            "[-sqrt(5)/4,0,sqrt(3)/4,0,-sqrt(3)/4,0,sqrt(5)/4]",
        ),
        "Gh(3,T,1,1)": (
            "-sqrt(6)*S1/4-sqrt(10)*S3/4",
            "-y*(3*x**2-2*y**2+3*z**2)/2",
            "[-sqrt(5)*I/4,0,-sqrt(3)*I/4,0,-sqrt(3)*I/4,0,-sqrt(5)*I/4]",
        ),
        "Gh(3,T,1,2)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Gh(3,T,2,0)": (
            "-sqrt(10)*C1/4-sqrt(6)*C3/4",
            "sqrt(15)*x*(y-z)*(y+z)/2",
            "[sqrt(3)/4,0,sqrt(5)/4,0,-sqrt(5)/4,0,-sqrt(3)/4]",
        ),
        "Gh(3,T,2,1)": (
            "sqrt(10)*S1/4-sqrt(6)*S3/4",
            "-sqrt(15)*y*(x-z)*(x+z)/2",
            "[-sqrt(3)*I/4,0,sqrt(5)*I/4,0,sqrt(5)*I/4,0,-sqrt(3)*I/4]",
        ),
        "Gh(3,T,2,2)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Gh(4,A,,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Gh(4,E,,0)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "sqrt(15)*(-x**4+12*x**2*y**2-6*x**2*z**2-y**4-6*y**2*z**2+2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Gh(4,E,,1)": ("-C2", "sqrt(5)*(x**4-6*x**2*z**2-y**4+6*y**2*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Gh(4,T,1,0)": (
            "-sqrt(14)*S1/4-sqrt(2)*S3/4",
            "sqrt(35)*y*z*(y-z)*(y+z)/2",
            "[0,-I/4,0,-sqrt(7)*I/4,0,-sqrt(7)*I/4,0,-I/4,0]",
        ),
        "Gh(4,T,1,1)": ("sqrt(14)*C1/4-sqrt(2)*C3/4", "-sqrt(35)*x*z*(x-z)*(x+z)/2", "[0,1/4,0,-sqrt(7)/4,0,sqrt(7)/4,0,-1/4,0]"),
        "Gh(4,T,1,2)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Gh(4,T,2,0)": (
            "-sqrt(2)*S1/4+sqrt(14)*S3/4",
            "sqrt(5)*y*z*(6*x**2-y**2-z**2)/2",
            "[0,sqrt(7)*I/4,0,-I/4,0,-I/4,0,sqrt(7)*I/4,0]",
        ),
        "Gh(4,T,2,1)": (
            "-sqrt(2)*C1/4-sqrt(14)*C3/4",
            "-sqrt(5)*x*z*(x**2-6*y**2+z**2)/2",
            "[0,sqrt(7)/4,0,1/4,0,-1/4,0,-sqrt(7)/4,0]",
        ),
        "Gh(4,T,2,2)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Gh(5,E,,0)": ("S4", "3*sqrt(35)*x*y*z*(x**2-y**2)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Gh(5,E,,1)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Gh(5,T,1,0)": (
            "sqrt(15)*C1/8-sqrt(70)*C3/16+3*sqrt(14)*C5/16",
            "x*(8*x**4-40*x**2*y**2-40*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/8",
            "[-3*sqrt(7)/16,0,sqrt(35)/16,0,-sqrt(30)/16,0,sqrt(30)/16,0,-sqrt(35)/16,0,3*sqrt(7)/16]",
        ),
        "Gh(5,T,1,1)": (
            "sqrt(15)*S1/8+sqrt(70)*S3/16+3*sqrt(14)*S5/16",
            "y*(15*x**4-40*x**2*y**2+30*x**2*z**2+8*y**4-40*y**2*z**2+15*z**4)/8",
            "[3*sqrt(7)*I/16,0,sqrt(35)*I/16,0,sqrt(30)*I/16,0,sqrt(30)*I/16,0,sqrt(35)*I/16,0,3*sqrt(7)*I/16]",
        ),
        "Gh(5,T,1,2)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Gh(5,T,2,0)": (
            "sqrt(21)*C1/8+9*sqrt(2)*C3/16+sqrt(10)*C5/16",
            "3*sqrt(35)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/8",
            "[-sqrt(5)/16,0,-9/16,0,-sqrt(42)/16,0,sqrt(42)/16,0,9/16,0,sqrt(5)/16]",
        ),
        "Gh(5,T,2,1)": (
            "sqrt(21)*S1/8-9*sqrt(2)*S3/16+sqrt(10)*S5/16",
            "3*sqrt(35)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/8",
            "[sqrt(5)*I/16,0,-9*I/16,0,sqrt(42)*I/16,0,sqrt(42)*I/16,0,-9*I/16,0,sqrt(5)*I/16]",
        ),
        "Gh(5,T,2,2)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Gh(5,T,3,0)": (
            "sqrt(7)*C1/4-sqrt(6)*C3/8-sqrt(30)*C5/8",
            "sqrt(105)*x*(y-z)*(y+z)*(2*x**2-y**2-z**2)/4",
            "[sqrt(15)/8,0,sqrt(3)/8,0,-sqrt(14)/8,0,sqrt(14)/8,0,-sqrt(3)/8,0,-sqrt(15)/8]",
        ),
        "Gh(5,T,3,1)": (
            "-sqrt(7)*S1/4-sqrt(6)*S3/8+sqrt(30)*S5/8",
            "sqrt(105)*y*(x-z)*(x+z)*(x**2-2*y**2+z**2)/4",
            "[sqrt(15)*I/8,0,-sqrt(3)*I/8,0,-sqrt(14)*I/8,0,-sqrt(14)*I/8,0,-sqrt(3)*I/8,0,sqrt(15)*I/8]",
        ),
        "Gh(5,T,3,2)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Gh(6,A,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Gh(6,A,2,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Gh(6,E,,0)": (
            "sqrt(2)*(sqrt(7)*C0+C4)/4",
            "sqrt(14)*(-x**6+15*x**4*z**2-15*x**2*z**4-y**6+15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Gh(6,E,,1)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x**6-10*x**4*y**2-5*x**4*z**2+10*x**2*y**4+5*x**2*z**4-y**6+5*y**4*z**2-5*y**2*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Gh(6,T,1,0)": (
            "sqrt(3)*S1/4-sqrt(30)*S3/8-sqrt(22)*S5/8",
            "3*sqrt(7)*y*z*(y-z)*(y+z)*(10*x**2-y**2-z**2)/4",
            "[0,-sqrt(11)*I/8,0,-sqrt(15)*I/8,0,sqrt(6)*I/8,0,sqrt(6)*I/8,0,-sqrt(15)*I/8,0,-sqrt(11)*I/8,0]",
        ),
        "Gh(6,T,1,1)": (
            "-sqrt(3)*C1/4-sqrt(30)*C3/8+sqrt(22)*C5/8",
            "3*sqrt(7)*x*z*(x-z)*(x+z)*(x**2-10*y**2+z**2)/4",
            "[0,-sqrt(11)/8,0,sqrt(15)/8,0,sqrt(6)/8,0,-sqrt(6)/8,0,-sqrt(15)/8,0,sqrt(11)/8,0]",
        ),
        "Gh(6,T,1,2)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(6,T,2,0)": (
            "3*sqrt(22)*S1/16+sqrt(55)*S3/16+sqrt(3)*S5/16",
            "sqrt(462)*y*z*(y**2-3*z**2)*(3*y**2-z**2)/16",
            "[0,sqrt(6)*I/32,0,sqrt(110)*I/32,0,3*sqrt(11)*I/16,0,3*sqrt(11)*I/16,0,sqrt(110)*I/32,0,sqrt(6)*I/32,0]",
        ),
        "Gh(6,T,2,1)": (
            "3*sqrt(22)*C1/16-sqrt(55)*C3/16+sqrt(3)*C5/16",
            "sqrt(462)*x*z*(x**2-3*z**2)*(3*x**2-z**2)/16",
            "[0,-sqrt(6)/32,0,sqrt(110)/32,0,-3*sqrt(11)/16,0,3*sqrt(11)/16,0,-sqrt(110)/32,0,sqrt(6)/32,0]",
        ),
        "Gh(6,T,2,2)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Gh(6,T,3,0)": (
            "sqrt(10)*S1/16-9*S3/16+sqrt(165)*S5/16",
            "sqrt(210)*y*z*(16*x**4-16*x**2*y**2-16*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,sqrt(330)*I/32,0,-9*sqrt(2)*I/32,0,sqrt(5)*I/16,0,sqrt(5)*I/16,0,-9*sqrt(2)*I/32,0,sqrt(330)*I/32,0]",
        ),
        "Gh(6,T,3,1)": (
            "sqrt(10)*C1/16+9*C3/16+sqrt(165)*C5/16",
            "sqrt(210)*x*z*(x**4-16*x**2*y**2+2*x**2*z**2+16*y**4-16*y**2*z**2+z**4)/16",
            "[0,-sqrt(330)/32,0,-9*sqrt(2)/32,0,-sqrt(5)/16,0,sqrt(5)/16,0,9*sqrt(2)/32,0,sqrt(330)/32,0]",
        ),
        "Gh(6,T,3,2)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(7,A,,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Gh(7,E,,0)": (
            "S4",
            "sqrt(231)*x*y*z*(-3*x**4+10*x**2*z**2+3*y**4-10*y**2*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(7,E,,1)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "sqrt(77)*x*y*z*(-3*x**4+20*x**2*y**2-10*x**2*z**2-3*y**4-10*y**2*z**2+6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Gh(7,T,1,0)": (
            "-5*sqrt(7)*C1/32+3*sqrt(21)*C3/32-sqrt(231)*C5/32+sqrt(429)*C7/32",
            "x*(16*x**6-168*x**4*y**2-168*x**4*z**2+210*x**2*y**4+420*x**2*y**2*z**2+210*x**2*z**4-35*y**6-105*y**4*z**2-105*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)/64,0,sqrt(462)/64,0,-3*sqrt(42)/64,0,5*sqrt(14)/64,0,-5*sqrt(14)/64,0,3*sqrt(42)/64,0,-sqrt(462)/64,0,sqrt(858)/64]",
        ),
        "Gh(7,T,1,1)": (
            "-5*sqrt(7)*S1/32-3*sqrt(21)*S3/32-sqrt(231)*S5/32-sqrt(429)*S7/32",
            "-y*(35*x**6-210*x**4*y**2+105*x**4*z**2+168*x**2*y**4-420*x**2*y**2*z**2+105*x**2*z**4-16*y**6+168*y**4*z**2-210*y**2*z**4+35*z**6)/16",
            "[-sqrt(858)*I/64,0,-sqrt(462)*I/64,0,-3*sqrt(42)*I/64,0,-5*sqrt(14)*I/64,0,-5*sqrt(14)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(462)*I/64,0,-sqrt(858)*I/64]",
        ),
        "Gh(7,T,1,2)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Gh(7,T,2,0)": (
            "-3*sqrt(33)*C1/32-sqrt(11)*C3/32+25*C5/32+sqrt(91)*C7/32",
            "sqrt(231)*x*(10*x**2-3*y**2-3*z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[-sqrt(182)/64,0,-25*sqrt(2)/64,0,sqrt(22)/64,0,3*sqrt(66)/64,0,-3*sqrt(66)/64,0,-sqrt(22)/64,0,25*sqrt(2)/64,0,sqrt(182)/64]",
        ),
        "Gh(7,T,2,1)": (
            "-3*sqrt(33)*S1/32+sqrt(11)*S3/32+25*S5/32-sqrt(91)*S7/32",
            "-sqrt(231)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(3*x**2-10*y**2+3*z**2)/16",
            "[-sqrt(182)*I/64,0,25*sqrt(2)*I/64,0,sqrt(22)*I/64,0,-3*sqrt(66)*I/64,0,-3*sqrt(66)*I/64,0,sqrt(22)*I/64,0,25*sqrt(2)*I/64,0,-sqrt(182)*I/64]",
        ),
        "Gh(7,T,2,2)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(7,T,3,0)": (
            "-sqrt(858)*C1/64-3*sqrt(286)*C3/64-5*sqrt(26)*C5/64-sqrt(14)*C7/64",
            "sqrt(6006)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/32",
            "[sqrt(7)/64,0,5*sqrt(13)/64,0,3*sqrt(143)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-3*sqrt(143)/64,0,-5*sqrt(13)/64,0,-sqrt(7)/64]",
        ),
        "Gh(7,T,3,1)": (
            "sqrt(858)*S1/64-3*sqrt(286)*S3/64+5*sqrt(26)*S5/64-sqrt(14)*S7/64",
            "-sqrt(6006)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)/32",
            "[-sqrt(7)*I/64,0,5*sqrt(13)*I/64,0,-3*sqrt(143)*I/64,0,sqrt(429)*I/64,0,sqrt(429)*I/64,0,-3*sqrt(143)*I/64,0,5*sqrt(13)*I/64,0,-sqrt(7)*I/64]",
        ),
        "Gh(7,T,3,2)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(7,T,4,0)": (
            "-15*sqrt(6)*C1/64+19*sqrt(2)*C3/64-sqrt(22)*C5/64-sqrt(2002)*C7/64",
            "sqrt(42)*x*(y-z)*(y+z)*(48*x**4-80*x**2*y**2-80*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/32",
            "[sqrt(1001)/64,0,sqrt(11)/64,0,-19/64,0,15*sqrt(3)/64,0,-15*sqrt(3)/64,0,19/64,0,-sqrt(11)/64,0,-sqrt(1001)/64]",
        ),
        "Gh(7,T,4,1)": (
            "15*sqrt(6)*S1/64+19*sqrt(2)*S3/64+sqrt(22)*S5/64-sqrt(2002)*S7/64",
            "-sqrt(42)*y*(x-z)*(x+z)*(15*x**4-80*x**2*y**2+30*x**2*z**2+48*y**4-80*y**2*z**2+15*z**4)/32",
            "[-sqrt(1001)*I/64,0,sqrt(11)*I/64,0,19*I/64,0,15*sqrt(3)*I/64,0,15*sqrt(3)*I/64,0,19*I/64,0,sqrt(11)*I/64,0,-sqrt(1001)*I/64]",
        ),
        "Gh(7,T,4,2)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(8,A,,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Gh(8,E,1,0)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Gh(8,E,1,1)": (
            "C6",
            "sqrt(858)*(-x**8+14*x**6*y**2+14*x**6*z**2-210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2+y**8-14*y**6*z**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(8,E,2,0)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Gh(8,E,2,1)": (
            "C2",
            "3*sqrt(70)*(-x**8-2*x**6*y**2+30*x**6*z**2+30*x**4*y**2*z**2-80*x**4*z**4+2*x**2*y**6-30*x**2*y**4*z**2+32*x**2*z**6+y**8-30*y**6*z**2+80*y**4*z**4-32*y**2*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(8,T,1,0)": (
            "-sqrt(715)*S1/32-sqrt(273)*S3/32-sqrt(35)*S5/32-S7/32",
            "3*sqrt(715)*y*z*(y-z)*(y+z)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[0,-sqrt(2)*I/64,0,-sqrt(70)*I/64,0,-sqrt(546)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(546)*I/64,0,-sqrt(70)*I/64,0,-sqrt(2)*I/64,0]",
        ),
        "Gh(8,T,1,1)": (
            "sqrt(715)*C1/32-sqrt(273)*C3/32+sqrt(35)*C5/32-C7/32",
            "-3*sqrt(715)*x*z*(x-z)*(x+z)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/16",
            "[0,sqrt(2)/64,0,-sqrt(70)/64,0,sqrt(546)/64,0,-sqrt(1430)/64,0,sqrt(1430)/64,0,-sqrt(546)/64,0,sqrt(70)/64,0,-sqrt(2)/64,0]",
        ),
        "Gh(8,T,1,2)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(8,T,2,0)": (
            "-sqrt(77)*S1/32+5*sqrt(15)*S3/32-3*sqrt(13)*S5/32-sqrt(455)*S7/32",
            "3*sqrt(77)*y*z*(y-z)*(y+z)*(40*x**4-24*x**2*y**2-24*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,-sqrt(910)*I/64,0,-3*sqrt(26)*I/64,0,5*sqrt(30)*I/64,0,-sqrt(154)*I/64,0,-sqrt(154)*I/64,0,5*sqrt(30)*I/64,0,-3*sqrt(26)*I/64,0,-sqrt(910)*I/64,0]",
        ),
        "Gh(8,T,2,1)": (
            "sqrt(77)*C1/32+5*sqrt(15)*C3/32+3*sqrt(13)*C5/32-sqrt(455)*C7/32",
            "-3*sqrt(77)*x*z*(x-z)*(x+z)*(x**4-24*x**2*y**2+2*x**2*z**2+40*y**4-24*y**2*z**2+z**4)/16",
            "[0,sqrt(910)/64,0,-3*sqrt(26)/64,0,-5*sqrt(30)/64,0,-sqrt(154)/64,0,sqrt(154)/64,0,5*sqrt(30)/64,0,3*sqrt(26)/64,0,-sqrt(910)/64,0]",
        ),
        "Gh(8,T,2,2)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(8,T,3,0)": (
            "-sqrt(858)*S1/64+sqrt(910)*S3/64+7*sqrt(42)*S5/64+3*sqrt(30)*S7/64",
            "sqrt(858)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(14*x**2-y**2-z**2)/32",
            "[0,3*sqrt(15)*I/64,0,7*sqrt(21)*I/64,0,sqrt(455)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(455)*I/64,0,7*sqrt(21)*I/64,0,3*sqrt(15)*I/64,0]",
        ),
        "Gh(8,T,3,1)": (
            "-sqrt(858)*C1/64-sqrt(910)*C3/64+7*sqrt(42)*C5/64-3*sqrt(30)*C7/64",
            "-sqrt(858)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(x**2-14*y**2+z**2)/32",
            "[0,3*sqrt(15)/64,0,-7*sqrt(21)/64,0,sqrt(455)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-sqrt(455)/64,0,7*sqrt(21)/64,0,-3*sqrt(15)/64,0]",
        ),
        "Gh(8,T,3,2)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(8,T,4,0)": (
            "-sqrt(70)*S1/64+3*sqrt(66)*S3/64-sqrt(1430)*S5/64+sqrt(2002)*S7/64",
            "3*sqrt(70)*y*z*(32*x**6-80*x**4*y**2-80*x**4*z**2+30*x**2*y**4+60*x**2*y**2*z**2+30*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,sqrt(1001)*I/64,0,-sqrt(715)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(35)*I/64,0,-sqrt(35)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(715)*I/64,0,sqrt(1001)*I/64,0]",
        ),
        "Gh(8,T,4,1)": (
            "-sqrt(70)*C1/64-3*sqrt(66)*C3/64-sqrt(1430)*C5/64-sqrt(2002)*C7/64",
            "-3*sqrt(70)*x*z*(x**6-30*x**4*y**2+3*x**4*z**2+80*x**2*y**4-60*x**2*y**2*z**2+3*x**2*z**4-32*y**6+80*y**4*z**2-30*y**2*z**4+z**6)/32",
            "[0,sqrt(1001)/64,0,sqrt(715)/64,0,3*sqrt(33)/64,0,sqrt(35)/64,0,-sqrt(35)/64,0,-3*sqrt(33)/64,0,-sqrt(715)/64,0,-sqrt(1001)/64,0]",
        ),
        "Gh(8,T,4,2)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(9,A,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Gh(9,A,2,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Gh(9,E,,0)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(3*x**6-14*x**4*y**2-7*x**4*z**2+14*x**2*y**4+7*x**2*z**4-3*y**6+7*y**4*z**2-7*y**2*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Gh(9,E,,1)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Gh(9,T,1,0)": (
            "21*sqrt(5)*C1/128-sqrt(2310)*C3/128+3*sqrt(286)*C5/128-3*sqrt(1430)*C7/256+sqrt(24310)*C9/256",
            "x*(128*x**8-2304*x**6*y**2-2304*x**6*z**2+6048*x**4*y**4+12096*x**4*y**2*z**2+6048*x**4*z**4-3360*x**2*y**6-10080*x**2*y**4*z**2-10080*x**2*y**2*z**4-3360*x**2*z**6+315*y**8+1260*y**6*z**2+1890*y**4*z**4+1260*y**2*z**6+315*z**8)/128",
            "[-sqrt(12155)/256,0,3*sqrt(715)/256,0,-3*sqrt(143)/128,0,sqrt(1155)/128,0,-21*sqrt(10)/256,0,21*sqrt(10)/256,0,-sqrt(1155)/128,0,3*sqrt(143)/128,0,-3*sqrt(715)/256,0,sqrt(12155)/256]",
        ),
        "Gh(9,T,1,1)": (
            "21*sqrt(5)*S1/128+sqrt(2310)*S3/128+3*sqrt(286)*S5/128+3*sqrt(1430)*S7/256+sqrt(24310)*S9/256",
            "y*(315*x**8-3360*x**6*y**2+1260*x**6*z**2+6048*x**4*y**4-10080*x**4*y**2*z**2+1890*x**4*z**4-2304*x**2*y**6+12096*x**2*y**4*z**2-10080*x**2*y**2*z**4+1260*x**2*z**6+128*y**8-2304*y**6*z**2+6048*y**4*z**4-3360*y**2*z**6+315*z**8)/128",
            "[sqrt(12155)*I/256,0,3*sqrt(715)*I/256,0,3*sqrt(143)*I/128,0,sqrt(1155)*I/128,0,21*sqrt(10)*I/256,0,21*sqrt(10)*I/256,0,sqrt(1155)*I/128,0,3*sqrt(143)*I/128,0,3*sqrt(715)*I/256,0,sqrt(12155)*I/256]",
        ),
        "Gh(9,T,1,2)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(9,T,2,0)": (
            "sqrt(2431)*C1/128+sqrt(9282)*C3/128+5*sqrt(170)*C5/128+7*sqrt(34)*C7/256+3*sqrt(2)*C9/256",
            "3*sqrt(12155)*x*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/128",
            "[-3/256,0,-7*sqrt(17)/256,0,-5*sqrt(85)/128,0,-sqrt(4641)/128,0,-sqrt(4862)/256,0,sqrt(4862)/256,0,sqrt(4641)/128,0,5*sqrt(85)/128,0,7*sqrt(17)/256,0,3/256]",
        ),
        "Gh(9,T,2,1)": (
            "sqrt(2431)*S1/128-sqrt(9282)*S3/128+5*sqrt(170)*S5/128-7*sqrt(34)*S7/256+3*sqrt(2)*S9/256",
            "3*sqrt(12155)*y*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/128",
            "[3*I/256,0,-7*sqrt(17)*I/256,0,5*sqrt(85)*I/128,0,-sqrt(4641)*I/128,0,sqrt(4862)*I/256,0,sqrt(4862)*I/256,0,-sqrt(4641)*I/128,0,5*sqrt(85)*I/128,0,-7*sqrt(17)*I/256,0,3*I/256]",
        ),
        "Gh(9,T,2,2)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(9,T,3,0)": (
            "sqrt(1001)*C1/64-sqrt(78)*C3/64-3*sqrt(70)*C5/64+23*sqrt(14)*C7/128+3*sqrt(238)*C9/128",
            "3*sqrt(5005)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(8*x**4-8*x**2*y**2-8*x**2*z**2+y**4+2*y**2*z**2+z**4)/64",
            "[-3*sqrt(119)/128,0,-23*sqrt(7)/128,0,3*sqrt(35)/64,0,sqrt(39)/64,0,-sqrt(2002)/128,0,sqrt(2002)/128,0,-sqrt(39)/64,0,-3*sqrt(35)/64,0,23*sqrt(7)/128,0,3*sqrt(119)/128]",
        ),
        "Gh(9,T,3,1)": (
            "sqrt(1001)*S1/64+sqrt(78)*S3/64-3*sqrt(70)*S5/64-23*sqrt(14)*S7/128+3*sqrt(238)*S9/128",
            "3*sqrt(5005)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(x**4-8*x**2*y**2+2*x**2*z**2+8*y**4-8*y**2*z**2+z**4)/64",
            "[3*sqrt(119)*I/128,0,-23*sqrt(7)*I/128,0,-3*sqrt(35)*I/64,0,sqrt(39)*I/64,0,sqrt(2002)*I/128,0,sqrt(2002)*I/128,0,sqrt(39)*I/64,0,-3*sqrt(35)*I/64,0,-23*sqrt(7)*I/128,0,3*sqrt(119)*I/128]",
        ),
        "Gh(9,T,3,2)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(9,T,4,0)": (
            "sqrt(858)*C1/64+sqrt(91)*C3/32-5*sqrt(15)*C5/32-21*sqrt(3)*C7/64-sqrt(51)*C9/64",
            "sqrt(4290)*x*(y-z)*(y+z)*(14*x**2-3*y**2-3*z**2)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/64",
            "[sqrt(102)/128,0,21*sqrt(6)/128,0,5*sqrt(30)/64,0,-sqrt(182)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(182)/64,0,-5*sqrt(30)/64,0,-21*sqrt(6)/128,0,-sqrt(102)/128]",
        ),
        "Gh(9,T,4,1)": (
            "-sqrt(858)*S1/64+sqrt(91)*S3/32+5*sqrt(15)*S5/32-21*sqrt(3)*S7/64+sqrt(51)*S9/64",
            "sqrt(4290)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(3*x**2-14*y**2+3*z**2)/64",
            "[sqrt(102)*I/128,0,-21*sqrt(6)*I/128,0,5*sqrt(30)*I/64,0,sqrt(182)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(182)*I/64,0,5*sqrt(30)*I/64,0,-21*sqrt(6)*I/128,0,sqrt(102)*I/128]",
        ),
        "Gh(9,T,4,2)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(9,T,5,0)": (
            "7*sqrt(22)*C1/64-3*sqrt(21)*C3/32+sqrt(65)*C5/32+sqrt(13)*C7/64-3*sqrt(221)*C9/64",
            "3*sqrt(110)*x*(y-z)*(y+z)*(32*x**6-112*x**4*y**2-112*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-7*y**6-21*y**4*z**2-21*y**2*z**4-7*z**6)/64",
            "[3*sqrt(442)/128,0,-sqrt(26)/128,0,-sqrt(130)/64,0,3*sqrt(42)/64,0,-7*sqrt(11)/64,0,7*sqrt(11)/64,0,-3*sqrt(42)/64,0,sqrt(130)/64,0,sqrt(26)/128,0,-3*sqrt(442)/128]",
        ),
        "Gh(9,T,5,1)": (
            "-7*sqrt(22)*S1/64-3*sqrt(21)*S3/32-sqrt(65)*S5/32+sqrt(13)*S7/64+3*sqrt(221)*S9/64",
            "3*sqrt(110)*y*(x-z)*(x+z)*(7*x**6-70*x**4*y**2+21*x**4*z**2+112*x**2*y**4-140*x**2*y**2*z**2+21*x**2*z**4-32*y**6+112*y**4*z**2-70*y**2*z**4+7*z**6)/64",
            "[3*sqrt(442)*I/128,0,sqrt(26)*I/128,0,-sqrt(130)*I/64,0,-3*sqrt(42)*I/64,0,-7*sqrt(11)*I/64,0,-7*sqrt(11)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(130)*I/64,0,sqrt(26)*I/128,0,3*sqrt(442)*I/128]",
        ),
        "Gh(9,T,5,2)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(10,A,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Gh(10,A,2,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Gh(10,E,1,0)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "sqrt(420189)*(-22*x**10-45*x**8*y**2+1035*x**8*z**2+105*x**6*y**4+630*x**6*y**2*z**2-4935*x**6*z**4+105*x**4*y**6-3150*x**4*y**4*z**2+1575*x**4*y**2*z**4+4830*x**4*z**6-45*x**2*y**8+630*x**2*y**6*z**2+1575*x**2*y**4*z**4-1260*x**2*y**2*z**6-990*x**2*z**8-22*y**10+1035*y**8*z**2-4935*y**6*z**4+4830*y**4*z**6-990*y**2*z**8+44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Gh(10,E,1,1)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(22*x**10-675*x**8*y**2-315*x**8*z**2+3255*x**6*y**4-630*x**6*y**2*z**2+1575*x**6*z**4-3255*x**4*y**6+1575*x**4*y**2*z**4-1680*x**4*z**6+675*x**2*y**8+630*x**2*y**6*z**2-1575*x**2*y**4*z**4+360*x**2*z**8-22*y**10+315*y**8*z**2-1575*y**6*z**4+1680*y**4*z**6-360*y**2*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Gh(10,E,2,0)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "sqrt(3213210)*(-3*x**10+96*x**8*y**2+39*x**8*z**2-224*x**6*y**4-1344*x**6*y**2*z**2+42*x**6*z**4-224*x**4*y**6+6720*x**4*y**4*z**2-3360*x**4*y**2*z**4+182*x**4*z**6+96*x**2*y**8-1344*x**2*y**6*z**2-3360*x**2*y**4*z**4+2688*x**2*y**2*z**6-135*x**2*z**8-3*y**10+39*y**8*z**2+42*y**6*z**4+182*y**4*z**6-135*y**2*z**8+6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Gh(10,E,2,1)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(9*x**10-174*x**8*y**2-231*x**8*z**2+140*x**6*y**4+4032*x**6*y**2*z**2+406*x**6*z**4-140*x**4*y**6-10080*x**4*y**2*z**4+266*x**4*z**6+174*x**2*y**8-4032*x**2*y**6*z**2+10080*x**2*y**4*z**4-57*x**2*z**8-9*y**10+231*y**8*z**2-406*y**6*z**4-266*y**4*z**6+57*y**2*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Gh(10,T,1,0)": (
            "sqrt(221)*S1/32-sqrt(102)*S3/32-sqrt(510)*S5/32-11*sqrt(6)*S7/64-sqrt(38)*S9/64",
            "sqrt(12155)*y*z*(y-z)*(y+z)*(18*x**2-y**2-z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/32",
            "[0,-sqrt(19)*I/64,0,-11*sqrt(3)*I/64,0,-sqrt(255)*I/32,0,-sqrt(51)*I/32,0,sqrt(442)*I/64,0,sqrt(442)*I/64,0,-sqrt(51)*I/32,0,-sqrt(255)*I/32,0,-11*sqrt(3)*I/64,0,-sqrt(19)*I/64,0]",
        ),
        "Gh(10,T,1,1)": (
            "-sqrt(221)*C1/32-sqrt(102)*C3/32+sqrt(510)*C5/32-11*sqrt(6)*C7/64+sqrt(38)*C9/64",
            "sqrt(12155)*x*z*(x-z)*(x+z)*(x**2-18*y**2+z**2)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/32",
            "[0,-sqrt(19)/64,0,11*sqrt(3)/64,0,-sqrt(255)/32,0,sqrt(51)/32,0,sqrt(442)/64,0,-sqrt(442)/64,0,-sqrt(51)/32,0,sqrt(255)/32,0,-11*sqrt(3)/64,0,sqrt(19)/64,0]",
        ),
        "Gh(10,T,1,2)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(10,T,2,0)": (
            "sqrt(39)*S1/32-11*sqrt(2)*S3/32+5*sqrt(10)*S5/32-sqrt(34)*S7/64-sqrt(1938)*S9/64",
            "sqrt(2145)*y*z*(y-z)*(y+z)*(112*x**6-168*x**4*y**2-168*x**4*z**2+42*x**2*y**4+84*x**2*y**2*z**2+42*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,-sqrt(969)*I/64,0,-sqrt(17)*I/64,0,5*sqrt(5)*I/32,0,-11*I/32,0,sqrt(78)*I/64,0,sqrt(78)*I/64,0,-11*I/32,0,5*sqrt(5)*I/32,0,-sqrt(17)*I/64,0,-sqrt(969)*I/64,0]",
        ),
        "Gh(10,T,2,1)": (
            "-sqrt(39)*C1/32-11*sqrt(2)*C3/32-5*sqrt(10)*C5/32-sqrt(34)*C7/64+sqrt(1938)*C9/64",
            "sqrt(2145)*x*z*(x-z)*(x+z)*(x**6-42*x**4*y**2+3*x**4*z**2+168*x**2*y**4-84*x**2*y**2*z**2+3*x**2*z**4-112*y**6+168*y**4*z**2-42*y**2*z**4+z**6)/32",
            "[0,-sqrt(969)/64,0,sqrt(17)/64,0,5*sqrt(5)/32,0,11/32,0,sqrt(78)/64,0,-sqrt(78)/64,0,-11/32,0,-5*sqrt(5)/32,0,-sqrt(17)/64,0,sqrt(969)/64,0]",
        ),
        "Gh(10,T,2,2)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(10,T,3,0)": (
            "sqrt(41990)*S1/256+sqrt(4845)*S3/128+sqrt(969)*S5/128+sqrt(285)*S7/256+sqrt(5)*S9/256",
            "sqrt(92378)*y*z*(y**4-10*y**2*z**2+5*z**4)*(5*y**4-10*y**2*z**2+z**4)/256",
            "[0,sqrt(10)*I/512,0,sqrt(570)*I/512,0,sqrt(1938)*I/256,0,sqrt(9690)*I/256,0,sqrt(20995)*I/256,0,sqrt(20995)*I/256,0,sqrt(9690)*I/256,0,sqrt(1938)*I/256,0,sqrt(570)*I/512,0,sqrt(10)*I/512,0]",
        ),
        "Gh(10,T,3,1)": (
            "sqrt(41990)*C1/256-sqrt(4845)*C3/128+sqrt(969)*C5/128-sqrt(285)*C7/256+sqrt(5)*C9/256",
            "sqrt(92378)*x*z*(x**4-10*x**2*z**2+5*z**4)*(5*x**4-10*x**2*z**2+z**4)/256",
            "[0,-sqrt(10)/512,0,sqrt(570)/512,0,-sqrt(1938)/256,0,sqrt(9690)/256,0,-sqrt(20995)/256,0,sqrt(20995)/256,0,-sqrt(9690)/256,0,sqrt(1938)/256,0,-sqrt(570)/512,0,sqrt(10)/512,0]",
        ),
        "Gh(10,T,3,2)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(10,T,4,0)": (
            "9*sqrt(78)*S1/256-69*S3/128-sqrt(5)*S5/128+43*sqrt(17)*S7/256+3*sqrt(969)*S9/256",
            "sqrt(4290)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(224*x**4-96*x**2*y**2-96*x**2*z**2+3*y**4+6*y**2*z**2+3*z**4)/256",
            "[0,3*sqrt(1938)*I/512,0,43*sqrt(34)*I/512,0,-sqrt(10)*I/256,0,-69*sqrt(2)*I/256,0,9*sqrt(39)*I/256,0,9*sqrt(39)*I/256,0,-69*sqrt(2)*I/256,0,-sqrt(10)*I/256,0,43*sqrt(34)*I/512,0,3*sqrt(1938)*I/512,0]",
        ),
        "Gh(10,T,4,1)": (
            "9*sqrt(78)*C1/256+69*C3/128-sqrt(5)*C5/128-43*sqrt(17)*C7/256+3*sqrt(969)*C9/256",
            "sqrt(4290)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(3*x**4-96*x**2*y**2+6*x**2*z**2+224*y**4-96*y**2*z**2+3*z**4)/256",
            "[0,-3*sqrt(1938)/512,0,43*sqrt(34)/512,0,sqrt(10)/256,0,-69*sqrt(2)/256,0,-9*sqrt(39)/256,0,9*sqrt(39)/256,0,69*sqrt(2)/256,0,-sqrt(10)/256,0,-43*sqrt(34)/512,0,3*sqrt(1938)/512,0]",
        ),
        "Gh(10,T,4,2)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(10,T,5,0)": (
            "7*sqrt(3)*S1/128-7*sqrt(26)*S3/128+5*sqrt(130)*S5/128-7*sqrt(442)*S7/256+sqrt(25194)*S9/256",
            "sqrt(165)*y*z*(384*x**8-1792*x**6*y**2-1792*x**6*z**2+1680*x**4*y**4+3360*x**4*y**2*z**2+1680*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+7*y**8+28*y**6*z**2+42*y**4*z**4+28*y**2*z**6+7*z**8)/128",
            "[0,sqrt(12597)*I/256,0,-7*sqrt(221)*I/256,0,5*sqrt(65)*I/128,0,-7*sqrt(13)*I/128,0,7*sqrt(6)*I/256,0,7*sqrt(6)*I/256,0,-7*sqrt(13)*I/128,0,5*sqrt(65)*I/128,0,-7*sqrt(221)*I/256,0,sqrt(12597)*I/256,0]",
        ),
        "Gh(10,T,5,1)": (
            "7*sqrt(3)*C1/128+7*sqrt(26)*C3/128+5*sqrt(130)*C5/128+7*sqrt(442)*C7/256+sqrt(25194)*C9/256",
            "sqrt(165)*x*z*(7*x**8-336*x**6*y**2+28*x**6*z**2+1680*x**4*y**4-1008*x**4*y**2*z**2+42*x**4*z**4-1792*x**2*y**6+3360*x**2*y**4*z**2-1008*x**2*y**2*z**4+28*x**2*z**6+384*y**8-1792*y**6*z**2+1680*y**4*z**4-336*y**2*z**6+7*z**8)/128",
            "[0,-sqrt(12597)/256,0,-7*sqrt(221)/256,0,-5*sqrt(65)/128,0,-7*sqrt(13)/128,0,-7*sqrt(6)/256,0,7*sqrt(6)/256,0,7*sqrt(13)/128,0,5*sqrt(65)/128,0,7*sqrt(221)/256,0,sqrt(12597)/256,0]",
        ),
        "Gh(10,T,5,2)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,A,,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Gh(11,E,1,0)": (
            "S8",
            "sqrt(692835)*x*y*z*(-x**8+6*x**6*y**2+6*x**6*z**2-42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2+y**8-6*y**6*z**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(11,E,1,1)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "sqrt(230945)*x*y*z*(-x**8+6*x**6*y**2+6*x**6*z**2-42*x**4*y**2*z**2+6*x**2*y**6-42*x**2*y**4*z**2+84*x**2*y**2*z**4-12*x**2*z**6-y**8+6*y**6*z**2-12*y**2*z**6+2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Gh(11,E,2,0)": (
            "S4",
            "3*sqrt(1001)*x*y*z*(-5*x**8-10*x**6*y**2+70*x**6*z**2+70*x**4*y**2*z**2-168*x**4*z**4+10*x**2*y**6-70*x**2*y**4*z**2+80*x**2*z**6+5*y**8-70*y**6*z**2+168*y**4*z**4-80*y**2*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(11,E,2,1)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "sqrt(3003)*x*y*z*(-5*x**8+150*x**6*y**2-90*x**6*z**2-336*x**4*y**4+70*x**4*y**2*z**2+168*x**4*z**4+150*x**2*y**6+70*x**2*y**4*z**2-140*x**2*y**2*z**4-60*x**2*z**6-5*y**8-90*y**6*z**2+168*y**4*z**4-60*y**2*z**6+10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Gh(11,T,1,0)": (
            "-21*sqrt(66)*C1/512+sqrt(88179)*C11/512+sqrt(30030)*C3/512-15*sqrt(143)*C5/512+sqrt(36465)*C7/512-sqrt(46189)*C9/512",
            "x*(256*x**10-7040*x**8*y**2-7040*x**8*z**2+31680*x**6*y**4+63360*x**6*y**2*z**2+31680*x**6*z**4-36960*x**4*y**6-110880*x**4*y**4*z**2-110880*x**4*y**2*z**4-36960*x**4*z**6+11550*x**2*y**8+46200*x**2*y**6*z**2+69300*x**2*y**4*z**4+46200*x**2*y**2*z**6+11550*x**2*z**8-693*y**10-3465*y**8*z**2-6930*y**6*z**4-6930*y**4*z**6-3465*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)/1024,0,sqrt(92378)/1024,0,-sqrt(72930)/1024,0,15*sqrt(286)/1024,0,-sqrt(15015)/512,0,21*sqrt(33)/512,0,-21*sqrt(33)/512,0,sqrt(15015)/512,0,-15*sqrt(286)/1024,0,sqrt(72930)/1024,0,-sqrt(92378)/1024,0,sqrt(176358)/1024]",
        ),
        "Gh(11,T,1,1)": (
            "-21*sqrt(66)*S1/512-sqrt(88179)*S11/512-sqrt(30030)*S3/512-15*sqrt(143)*S5/512-sqrt(36465)*S7/512-sqrt(46189)*S9/512",
            "-y*(693*x**10-11550*x**8*y**2+3465*x**8*z**2+36960*x**6*y**4-46200*x**6*y**2*z**2+6930*x**6*z**4-31680*x**4*y**6+110880*x**4*y**4*z**2-69300*x**4*y**2*z**4+6930*x**4*z**6+7040*x**2*y**8-63360*x**2*y**6*z**2+110880*x**2*y**4*z**4-46200*x**2*y**2*z**6+3465*x**2*z**8-256*y**10+7040*y**8*z**2-31680*y**6*z**4+36960*y**4*z**6-11550*y**2*z**8+693*z**10)/256",
            "[-sqrt(176358)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(72930)*I/1024,0,-15*sqrt(286)*I/1024,0,-sqrt(15015)*I/512,0,-21*sqrt(33)*I/512,0,-21*sqrt(33)*I/512,0,-sqrt(15015)*I/512,0,-15*sqrt(286)*I/1024,0,-sqrt(72930)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(176358)*I/1024]",
        ),
        "Gh(11,T,1,2)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,T,2,0)": (
            "-sqrt(41990)*C1/512+sqrt(385)*C11/512-3*sqrt(4522)*C3/512+3*sqrt(4845)*C5/512+77*sqrt(19)*C7/512+39*sqrt(15)*C9/512",
            "sqrt(692835)*x*(6*x**2-y**2-z**2)*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/256",
            "[-sqrt(770)/1024,0,-39*sqrt(30)/1024,0,-77*sqrt(38)/1024,0,-3*sqrt(9690)/1024,0,3*sqrt(2261)/512,0,sqrt(20995)/512,0,-sqrt(20995)/512,0,-3*sqrt(2261)/512,0,3*sqrt(9690)/1024,0,77*sqrt(38)/1024,0,39*sqrt(30)/1024,0,sqrt(770)/1024]",
        ),
        "Gh(11,T,2,1)": (
            "-sqrt(41990)*S1/512-sqrt(385)*S11/512+3*sqrt(4522)*S3/512+3*sqrt(4845)*S5/512-77*sqrt(19)*S7/512+39*sqrt(15)*S9/512",
            "-sqrt(692835)*y*(x**2-6*y**2+z**2)*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/256",
            "[-sqrt(770)*I/1024,0,39*sqrt(30)*I/1024,0,-77*sqrt(38)*I/1024,0,3*sqrt(9690)*I/1024,0,3*sqrt(2261)*I/512,0,-sqrt(20995)*I/512,0,-sqrt(20995)*I/512,0,3*sqrt(2261)*I/512,0,3*sqrt(9690)*I/1024,0,-77*sqrt(38)*I/1024,0,39*sqrt(30)*I/1024,0,-sqrt(770)*I/1024]",
        ),
        "Gh(11,T,2,2)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(11,T,3,0)": (
            "-5*sqrt(546)*C1/256+sqrt(10659)*C11/256+11*sqrt(30)*C3/256+13*sqrt(7)*C5/256-3*sqrt(1785)*C7/256+3*sqrt(2261)*C9/256",
            "3*sqrt(1001)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(80*x**6-168*x**4*y**2-168*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-5*y**6-15*y**4*z**2-15*y**2*z**4-5*z**6)/128",
            "[-sqrt(21318)/512,0,-3*sqrt(4522)/512,0,3*sqrt(3570)/512,0,-13*sqrt(14)/512,0,-11*sqrt(15)/256,0,5*sqrt(273)/256,0,-5*sqrt(273)/256,0,11*sqrt(15)/256,0,13*sqrt(14)/512,0,-3*sqrt(3570)/512,0,3*sqrt(4522)/512,0,sqrt(21318)/512]",
        ),
        "Gh(11,T,3,1)": (
            "-5*sqrt(546)*S1/256-sqrt(10659)*S11/256-11*sqrt(30)*S3/256+13*sqrt(7)*S5/256+3*sqrt(1785)*S7/256+3*sqrt(2261)*S9/256",
            "-3*sqrt(1001)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(5*x**6-70*x**4*y**2+15*x**4*z**2+168*x**2*y**4-140*x**2*y**2*z**2+15*x**2*z**4-80*y**6+168*y**4*z**2-70*y**2*z**4+5*z**6)/128",
            "[-sqrt(21318)*I/512,0,3*sqrt(4522)*I/512,0,3*sqrt(3570)*I/512,0,13*sqrt(14)*I/512,0,-11*sqrt(15)*I/256,0,-5*sqrt(273)*I/256,0,-5*sqrt(273)*I/256,0,-11*sqrt(15)*I/256,0,13*sqrt(14)*I/512,0,3*sqrt(3570)*I/512,0,3*sqrt(4522)*I/512,0,-sqrt(21318)*I/512]",
        ),
        "Gh(11,T,3,2)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(11,T,4,0)": (
            "-sqrt(29393)*C1/512-sqrt(22)*C11/1024-9*sqrt(1615)*C3/512-5*sqrt(13566)*C5/1024-7*sqrt(1330)*C7/1024-9*sqrt(42)*C9/1024",
            "sqrt(1939938)*x*(y-z)*(y+z)*(y**4-4*y**3*z-14*y**2*z**2-4*y*z**3+z**4)*(y**4+4*y**3*z-14*y**2*z**2+4*y*z**3+z**4)/512",
            "[sqrt(11)/1024,0,9*sqrt(21)/1024,0,7*sqrt(665)/1024,0,5*sqrt(6783)/1024,0,9*sqrt(3230)/1024,0,sqrt(58786)/1024,0,-sqrt(58786)/1024,0,-9*sqrt(3230)/1024,0,-5*sqrt(6783)/1024,0,-7*sqrt(665)/1024,0,-9*sqrt(21)/1024,0,-sqrt(11)/1024]",
        ),
        "Gh(11,T,4,1)": (
            "sqrt(29393)*S1/512-sqrt(22)*S11/1024-9*sqrt(1615)*S3/512+5*sqrt(13566)*S5/1024-7*sqrt(1330)*S7/1024+9*sqrt(42)*S9/1024",
            "-sqrt(1939938)*y*(x-z)*(x+z)*(x**4-4*x**3*z-14*x**2*z**2-4*x*z**3+z**4)*(x**4+4*x**3*z-14*x**2*z**2+4*x*z**3+z**4)/512",
            "[-sqrt(11)*I/1024,0,9*sqrt(21)*I/1024,0,-7*sqrt(665)*I/1024,0,5*sqrt(6783)*I/1024,0,-9*sqrt(3230)*I/1024,0,sqrt(58786)*I/1024,0,sqrt(58786)*I/1024,0,-9*sqrt(3230)*I/1024,0,5*sqrt(6783)*I/1024,0,-7*sqrt(665)*I/1024,0,9*sqrt(21)*I/1024,0,-sqrt(11)*I/1024]",
        ),
        "Gh(11,T,4,2)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(11,T,5,0)": (
            "-15*sqrt(221)*C1/512-3*sqrt(2926)*C11/1024-sqrt(595)*C3/512+53*sqrt(102)*C5/1024-105*sqrt(10)*C7/1024-61*sqrt(114)*C9/1024",
            "sqrt(14586)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)*(224*x**4-160*x**2*y**2-160*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/512",
            "[3*sqrt(1463)/1024,0,61*sqrt(57)/1024,0,105*sqrt(5)/1024,0,-53*sqrt(51)/1024,0,sqrt(1190)/1024,0,15*sqrt(442)/1024,0,-15*sqrt(442)/1024,0,-sqrt(1190)/1024,0,53*sqrt(51)/1024,0,-105*sqrt(5)/1024,0,-61*sqrt(57)/1024,0,-3*sqrt(1463)/1024]",
        ),
        "Gh(11,T,5,1)": (
            "15*sqrt(221)*S1/512-3*sqrt(2926)*S11/1024-sqrt(595)*S3/512-53*sqrt(102)*S5/1024-105*sqrt(10)*S7/1024+61*sqrt(114)*S9/1024",
            "-sqrt(14586)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(15*x**4-160*x**2*y**2+30*x**2*z**2+224*y**4-160*y**2*z**2+15*z**4)/512",
            "[-3*sqrt(1463)*I/1024,0,61*sqrt(57)*I/1024,0,-105*sqrt(5)*I/1024,0,-53*sqrt(51)*I/1024,0,-sqrt(1190)*I/1024,0,15*sqrt(442)*I/1024,0,15*sqrt(442)*I/1024,0,-sqrt(1190)*I/1024,0,-53*sqrt(51)*I/1024,0,-105*sqrt(5)*I/1024,0,61*sqrt(57)*I/1024,0,-3*sqrt(1463)*I/1024]",
        ),
        "Gh(11,T,5,2)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(11,T,6,0)": (
            "-21*sqrt(130)*C1/512-sqrt(124355)*C11/512+57*sqrt(14)*C3/512-41*sqrt(15)*C5/512+17*sqrt(17)*C7/512+sqrt(4845)*C9/512",
            "sqrt(2145)*x*(y-z)*(y+z)*(128*x**8-768*x**6*y**2-768*x**6*z**2+1008*x**4*y**4+2016*x**4*y**2*z**2+1008*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+21*y**8+84*y**6*z**2+126*y**4*z**4+84*y**2*z**6+21*z**8)/256",
            "[sqrt(248710)/1024,0,-sqrt(9690)/1024,0,-17*sqrt(34)/1024,0,41*sqrt(30)/1024,0,-57*sqrt(7)/512,0,21*sqrt(65)/512,0,-21*sqrt(65)/512,0,57*sqrt(7)/512,0,-41*sqrt(30)/1024,0,17*sqrt(34)/1024,0,sqrt(9690)/1024,0,-sqrt(248710)/1024]",
        ),
        "Gh(11,T,6,1)": (
            "21*sqrt(130)*S1/512-sqrt(124355)*S11/512+57*sqrt(14)*S3/512+41*sqrt(15)*S5/512+17*sqrt(17)*S7/512-sqrt(4845)*S9/512",
            "-sqrt(2145)*y*(x-z)*(x+z)*(21*x**8-336*x**6*y**2+84*x**6*z**2+1008*x**4*y**4-1008*x**4*y**2*z**2+126*x**4*z**4-768*x**2*y**6+2016*x**2*y**4*z**2-1008*x**2*y**2*z**4+84*x**2*z**6+128*y**8-768*y**6*z**2+1008*y**4*z**4-336*y**2*z**6+21*z**8)/256",
            "[-sqrt(248710)*I/1024,0,-sqrt(9690)*I/1024,0,17*sqrt(34)*I/1024,0,41*sqrt(30)*I/1024,0,57*sqrt(7)*I/512,0,21*sqrt(65)*I/512,0,21*sqrt(65)*I/512,0,57*sqrt(7)*I/512,0,41*sqrt(30)*I/1024,0,17*sqrt(34)*I/1024,0,-sqrt(9690)*I/1024,0,-sqrt(248710)*I/1024]",
        ),
        "Gh(11,T,6,2)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
    },
    "Th": {
        "Gh(0,Au,,)": ("C0", "1", "[1]"),
        "Gh(1,Tg,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Gh(1,Tg,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Gh(1,Tg,,2)": ("C0", "z", "[0,1,0]"),
        "Gh(2,Eu,,0)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Gh(2,Eu,,1)": ("C2", "sqrt(3)*(x**2-y**2)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Gh(2,Tu,,0)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Gh(2,Tu,,1)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Gh(2,Tu,,2)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Gh(3,Ag,,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Gh(3,Tg,1,0)": (
            "-sqrt(6)*C1/4+sqrt(10)*C3/4",
            "x*(2*x**2-3*y**2-3*z**2)/2",
            "[-sqrt(5)/4,0,sqrt(3)/4,0,-sqrt(3)/4,0,sqrt(5)/4]",
        ),
        "Gh(3,Tg,1,1)": (
            "-sqrt(6)*S1/4-sqrt(10)*S3/4",
            "-y*(3*x**2-2*y**2+3*z**2)/2",
            "[-sqrt(5)*I/4,0,-sqrt(3)*I/4,0,-sqrt(3)*I/4,0,-sqrt(5)*I/4]",
        ),
        "Gh(3,Tg,1,2)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Gh(3,Tg,2,0)": (
            "-sqrt(10)*C1/4-sqrt(6)*C3/4",
            "sqrt(15)*x*(y-z)*(y+z)/2",
            "[sqrt(3)/4,0,sqrt(5)/4,0,-sqrt(5)/4,0,-sqrt(3)/4]",
        ),
        "Gh(3,Tg,2,1)": (
            "sqrt(10)*S1/4-sqrt(6)*S3/4",
            "-sqrt(15)*y*(x-z)*(x+z)/2",
            "[-sqrt(3)*I/4,0,sqrt(5)*I/4,0,sqrt(5)*I/4,0,-sqrt(3)*I/4]",
        ),
        "Gh(3,Tg,2,2)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Gh(4,Au,,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Gh(4,Eu,,0)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "sqrt(15)*(-x**4+12*x**2*y**2-6*x**2*z**2-y**4-6*y**2*z**2+2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Gh(4,Eu,,1)": ("-C2", "sqrt(5)*(x**4-6*x**2*z**2-y**4+6*y**2*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Gh(4,Tu,1,0)": (
            "-sqrt(14)*S1/4-sqrt(2)*S3/4",
            "sqrt(35)*y*z*(y-z)*(y+z)/2",
            "[0,-I/4,0,-sqrt(7)*I/4,0,-sqrt(7)*I/4,0,-I/4,0]",
        ),
        "Gh(4,Tu,1,1)": (
            "sqrt(14)*C1/4-sqrt(2)*C3/4",
            "-sqrt(35)*x*z*(x-z)*(x+z)/2",
            "[0,1/4,0,-sqrt(7)/4,0,sqrt(7)/4,0,-1/4,0]",
        ),
        "Gh(4,Tu,1,2)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Gh(4,Tu,2,0)": (
            "-sqrt(2)*S1/4+sqrt(14)*S3/4",
            "sqrt(5)*y*z*(6*x**2-y**2-z**2)/2",
            "[0,sqrt(7)*I/4,0,-I/4,0,-I/4,0,sqrt(7)*I/4,0]",
        ),
        "Gh(4,Tu,2,1)": (
            "-sqrt(2)*C1/4-sqrt(14)*C3/4",
            "-sqrt(5)*x*z*(x**2-6*y**2+z**2)/2",
            "[0,sqrt(7)/4,0,1/4,0,-1/4,0,-sqrt(7)/4,0]",
        ),
        "Gh(4,Tu,2,2)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Gh(5,Eg,,0)": ("S4", "3*sqrt(35)*x*y*z*(x**2-y**2)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Gh(5,Eg,,1)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Gh(5,Tg,1,0)": (
            "sqrt(15)*C1/8-sqrt(70)*C3/16+3*sqrt(14)*C5/16",
            "x*(8*x**4-40*x**2*y**2-40*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/8",
            "[-3*sqrt(7)/16,0,sqrt(35)/16,0,-sqrt(30)/16,0,sqrt(30)/16,0,-sqrt(35)/16,0,3*sqrt(7)/16]",
        ),
        "Gh(5,Tg,1,1)": (
            "sqrt(15)*S1/8+sqrt(70)*S3/16+3*sqrt(14)*S5/16",
            "y*(15*x**4-40*x**2*y**2+30*x**2*z**2+8*y**4-40*y**2*z**2+15*z**4)/8",
            "[3*sqrt(7)*I/16,0,sqrt(35)*I/16,0,sqrt(30)*I/16,0,sqrt(30)*I/16,0,sqrt(35)*I/16,0,3*sqrt(7)*I/16]",
        ),
        "Gh(5,Tg,1,2)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Gh(5,Tg,2,0)": (
            "sqrt(21)*C1/8+9*sqrt(2)*C3/16+sqrt(10)*C5/16",
            "3*sqrt(35)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/8",
            "[-sqrt(5)/16,0,-9/16,0,-sqrt(42)/16,0,sqrt(42)/16,0,9/16,0,sqrt(5)/16]",
        ),
        "Gh(5,Tg,2,1)": (
            "sqrt(21)*S1/8-9*sqrt(2)*S3/16+sqrt(10)*S5/16",
            "3*sqrt(35)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/8",
            "[sqrt(5)*I/16,0,-9*I/16,0,sqrt(42)*I/16,0,sqrt(42)*I/16,0,-9*I/16,0,sqrt(5)*I/16]",
        ),
        "Gh(5,Tg,2,2)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Gh(5,Tg,3,0)": (
            "sqrt(7)*C1/4-sqrt(6)*C3/8-sqrt(30)*C5/8",
            "sqrt(105)*x*(y-z)*(y+z)*(2*x**2-y**2-z**2)/4",
            "[sqrt(15)/8,0,sqrt(3)/8,0,-sqrt(14)/8,0,sqrt(14)/8,0,-sqrt(3)/8,0,-sqrt(15)/8]",
        ),
        "Gh(5,Tg,3,1)": (
            "-sqrt(7)*S1/4-sqrt(6)*S3/8+sqrt(30)*S5/8",
            "sqrt(105)*y*(x-z)*(x+z)*(x**2-2*y**2+z**2)/4",
            "[sqrt(15)*I/8,0,-sqrt(3)*I/8,0,-sqrt(14)*I/8,0,-sqrt(14)*I/8,0,-sqrt(3)*I/8,0,sqrt(15)*I/8]",
        ),
        "Gh(5,Tg,3,2)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Gh(6,Au,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Gh(6,Au,2,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Gh(6,Eu,,0)": (
            "sqrt(2)*(sqrt(7)*C0+C4)/4",
            "sqrt(14)*(-x**6+15*x**4*z**2-15*x**2*z**4-y**6+15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Gh(6,Eu,,1)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x**6-10*x**4*y**2-5*x**4*z**2+10*x**2*y**4+5*x**2*z**4-y**6+5*y**4*z**2-5*y**2*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Gh(6,Tu,1,0)": (
            "sqrt(3)*S1/4-sqrt(30)*S3/8-sqrt(22)*S5/8",
            "3*sqrt(7)*y*z*(y-z)*(y+z)*(10*x**2-y**2-z**2)/4",
            "[0,-sqrt(11)*I/8,0,-sqrt(15)*I/8,0,sqrt(6)*I/8,0,sqrt(6)*I/8,0,-sqrt(15)*I/8,0,-sqrt(11)*I/8,0]",
        ),
        "Gh(6,Tu,1,1)": (
            "-sqrt(3)*C1/4-sqrt(30)*C3/8+sqrt(22)*C5/8",
            "3*sqrt(7)*x*z*(x-z)*(x+z)*(x**2-10*y**2+z**2)/4",
            "[0,-sqrt(11)/8,0,sqrt(15)/8,0,sqrt(6)/8,0,-sqrt(6)/8,0,-sqrt(15)/8,0,sqrt(11)/8,0]",
        ),
        "Gh(6,Tu,1,2)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(6,Tu,2,0)": (
            "3*sqrt(22)*S1/16+sqrt(55)*S3/16+sqrt(3)*S5/16",
            "sqrt(462)*y*z*(y**2-3*z**2)*(3*y**2-z**2)/16",
            "[0,sqrt(6)*I/32,0,sqrt(110)*I/32,0,3*sqrt(11)*I/16,0,3*sqrt(11)*I/16,0,sqrt(110)*I/32,0,sqrt(6)*I/32,0]",
        ),
        "Gh(6,Tu,2,1)": (
            "3*sqrt(22)*C1/16-sqrt(55)*C3/16+sqrt(3)*C5/16",
            "sqrt(462)*x*z*(x**2-3*z**2)*(3*x**2-z**2)/16",
            "[0,-sqrt(6)/32,0,sqrt(110)/32,0,-3*sqrt(11)/16,0,3*sqrt(11)/16,0,-sqrt(110)/32,0,sqrt(6)/32,0]",
        ),
        "Gh(6,Tu,2,2)": (
            "S6",
            "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(6,Tu,3,0)": (
            "sqrt(10)*S1/16-9*S3/16+sqrt(165)*S5/16",
            "sqrt(210)*y*z*(16*x**4-16*x**2*y**2-16*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,sqrt(330)*I/32,0,-9*sqrt(2)*I/32,0,sqrt(5)*I/16,0,sqrt(5)*I/16,0,-9*sqrt(2)*I/32,0,sqrt(330)*I/32,0]",
        ),
        "Gh(6,Tu,3,1)": (
            "sqrt(10)*C1/16+9*C3/16+sqrt(165)*C5/16",
            "sqrt(210)*x*z*(x**4-16*x**2*y**2+2*x**2*z**2+16*y**4-16*y**2*z**2+z**4)/16",
            "[0,-sqrt(330)/32,0,-9*sqrt(2)/32,0,-sqrt(5)/16,0,sqrt(5)/16,0,9*sqrt(2)/32,0,sqrt(330)/32,0]",
        ),
        "Gh(6,Tu,3,2)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(7,Ag,,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Gh(7,Eg,,0)": (
            "S4",
            "sqrt(231)*x*y*z*(-3*x**4+10*x**2*z**2+3*y**4-10*y**2*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(7,Eg,,1)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "sqrt(77)*x*y*z*(-3*x**4+20*x**2*y**2-10*x**2*z**2-3*y**4-10*y**2*z**2+6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Gh(7,Tg,1,0)": (
            "-5*sqrt(7)*C1/32+3*sqrt(21)*C3/32-sqrt(231)*C5/32+sqrt(429)*C7/32",
            "x*(16*x**6-168*x**4*y**2-168*x**4*z**2+210*x**2*y**4+420*x**2*y**2*z**2+210*x**2*z**4-35*y**6-105*y**4*z**2-105*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)/64,0,sqrt(462)/64,0,-3*sqrt(42)/64,0,5*sqrt(14)/64,0,-5*sqrt(14)/64,0,3*sqrt(42)/64,0,-sqrt(462)/64,0,sqrt(858)/64]",
        ),
        "Gh(7,Tg,1,1)": (
            "-5*sqrt(7)*S1/32-3*sqrt(21)*S3/32-sqrt(231)*S5/32-sqrt(429)*S7/32",
            "-y*(35*x**6-210*x**4*y**2+105*x**4*z**2+168*x**2*y**4-420*x**2*y**2*z**2+105*x**2*z**4-16*y**6+168*y**4*z**2-210*y**2*z**4+35*z**6)/16",
            "[-sqrt(858)*I/64,0,-sqrt(462)*I/64,0,-3*sqrt(42)*I/64,0,-5*sqrt(14)*I/64,0,-5*sqrt(14)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(462)*I/64,0,-sqrt(858)*I/64]",
        ),
        "Gh(7,Tg,1,2)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Gh(7,Tg,2,0)": (
            "-3*sqrt(33)*C1/32-sqrt(11)*C3/32+25*C5/32+sqrt(91)*C7/32",
            "sqrt(231)*x*(10*x**2-3*y**2-3*z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[-sqrt(182)/64,0,-25*sqrt(2)/64,0,sqrt(22)/64,0,3*sqrt(66)/64,0,-3*sqrt(66)/64,0,-sqrt(22)/64,0,25*sqrt(2)/64,0,sqrt(182)/64]",
        ),
        "Gh(7,Tg,2,1)": (
            "-3*sqrt(33)*S1/32+sqrt(11)*S3/32+25*S5/32-sqrt(91)*S7/32",
            "-sqrt(231)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(3*x**2-10*y**2+3*z**2)/16",
            "[-sqrt(182)*I/64,0,25*sqrt(2)*I/64,0,sqrt(22)*I/64,0,-3*sqrt(66)*I/64,0,-3*sqrt(66)*I/64,0,sqrt(22)*I/64,0,25*sqrt(2)*I/64,0,-sqrt(182)*I/64]",
        ),
        "Gh(7,Tg,2,2)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(7,Tg,3,0)": (
            "-sqrt(858)*C1/64-3*sqrt(286)*C3/64-5*sqrt(26)*C5/64-sqrt(14)*C7/64",
            "sqrt(6006)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/32",
            "[sqrt(7)/64,0,5*sqrt(13)/64,0,3*sqrt(143)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-3*sqrt(143)/64,0,-5*sqrt(13)/64,0,-sqrt(7)/64]",
        ),
        "Gh(7,Tg,3,1)": (
            "sqrt(858)*S1/64-3*sqrt(286)*S3/64+5*sqrt(26)*S5/64-sqrt(14)*S7/64",
            "-sqrt(6006)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)/32",
            "[-sqrt(7)*I/64,0,5*sqrt(13)*I/64,0,-3*sqrt(143)*I/64,0,sqrt(429)*I/64,0,sqrt(429)*I/64,0,-3*sqrt(143)*I/64,0,5*sqrt(13)*I/64,0,-sqrt(7)*I/64]",
        ),
        "Gh(7,Tg,3,2)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(7,Tg,4,0)": (
            "-15*sqrt(6)*C1/64+19*sqrt(2)*C3/64-sqrt(22)*C5/64-sqrt(2002)*C7/64",
            "sqrt(42)*x*(y-z)*(y+z)*(48*x**4-80*x**2*y**2-80*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/32",
            "[sqrt(1001)/64,0,sqrt(11)/64,0,-19/64,0,15*sqrt(3)/64,0,-15*sqrt(3)/64,0,19/64,0,-sqrt(11)/64,0,-sqrt(1001)/64]",
        ),
        "Gh(7,Tg,4,1)": (
            "15*sqrt(6)*S1/64+19*sqrt(2)*S3/64+sqrt(22)*S5/64-sqrt(2002)*S7/64",
            "-sqrt(42)*y*(x-z)*(x+z)*(15*x**4-80*x**2*y**2+30*x**2*z**2+48*y**4-80*y**2*z**2+15*z**4)/32",
            "[-sqrt(1001)*I/64,0,sqrt(11)*I/64,0,19*I/64,0,15*sqrt(3)*I/64,0,15*sqrt(3)*I/64,0,19*I/64,0,sqrt(11)*I/64,0,-sqrt(1001)*I/64]",
        ),
        "Gh(7,Tg,4,2)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(8,Au,,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Gh(8,Eu,1,0)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Gh(8,Eu,1,1)": (
            "C6",
            "sqrt(858)*(-x**8+14*x**6*y**2+14*x**6*z**2-210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2+y**8-14*y**6*z**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Gh(8,Eu,2,0)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Gh(8,Eu,2,1)": (
            "C2",
            "3*sqrt(70)*(-x**8-2*x**6*y**2+30*x**6*z**2+30*x**4*y**2*z**2-80*x**4*z**4+2*x**2*y**6-30*x**2*y**4*z**2+32*x**2*z**6+y**8-30*y**6*z**2+80*y**4*z**4-32*y**2*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Gh(8,Tu,1,0)": (
            "-sqrt(715)*S1/32-sqrt(273)*S3/32-sqrt(35)*S5/32-S7/32",
            "3*sqrt(715)*y*z*(y-z)*(y+z)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[0,-sqrt(2)*I/64,0,-sqrt(70)*I/64,0,-sqrt(546)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(546)*I/64,0,-sqrt(70)*I/64,0,-sqrt(2)*I/64,0]",
        ),
        "Gh(8,Tu,1,1)": (
            "sqrt(715)*C1/32-sqrt(273)*C3/32+sqrt(35)*C5/32-C7/32",
            "-3*sqrt(715)*x*z*(x-z)*(x+z)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/16",
            "[0,sqrt(2)/64,0,-sqrt(70)/64,0,sqrt(546)/64,0,-sqrt(1430)/64,0,sqrt(1430)/64,0,-sqrt(546)/64,0,sqrt(70)/64,0,-sqrt(2)/64,0]",
        ),
        "Gh(8,Tu,1,2)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(8,Tu,2,0)": (
            "-sqrt(77)*S1/32+5*sqrt(15)*S3/32-3*sqrt(13)*S5/32-sqrt(455)*S7/32",
            "3*sqrt(77)*y*z*(y-z)*(y+z)*(40*x**4-24*x**2*y**2-24*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,-sqrt(910)*I/64,0,-3*sqrt(26)*I/64,0,5*sqrt(30)*I/64,0,-sqrt(154)*I/64,0,-sqrt(154)*I/64,0,5*sqrt(30)*I/64,0,-3*sqrt(26)*I/64,0,-sqrt(910)*I/64,0]",
        ),
        "Gh(8,Tu,2,1)": (
            "sqrt(77)*C1/32+5*sqrt(15)*C3/32+3*sqrt(13)*C5/32-sqrt(455)*C7/32",
            "-3*sqrt(77)*x*z*(x-z)*(x+z)*(x**4-24*x**2*y**2+2*x**2*z**2+40*y**4-24*y**2*z**2+z**4)/16",
            "[0,sqrt(910)/64,0,-3*sqrt(26)/64,0,-5*sqrt(30)/64,0,-sqrt(154)/64,0,sqrt(154)/64,0,5*sqrt(30)/64,0,3*sqrt(26)/64,0,-sqrt(910)/64,0]",
        ),
        "Gh(8,Tu,2,2)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(8,Tu,3,0)": (
            "-sqrt(858)*S1/64+sqrt(910)*S3/64+7*sqrt(42)*S5/64+3*sqrt(30)*S7/64",
            "sqrt(858)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(14*x**2-y**2-z**2)/32",
            "[0,3*sqrt(15)*I/64,0,7*sqrt(21)*I/64,0,sqrt(455)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(455)*I/64,0,7*sqrt(21)*I/64,0,3*sqrt(15)*I/64,0]",
        ),
        "Gh(8,Tu,3,1)": (
            "-sqrt(858)*C1/64-sqrt(910)*C3/64+7*sqrt(42)*C5/64-3*sqrt(30)*C7/64",
            "-sqrt(858)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(x**2-14*y**2+z**2)/32",
            "[0,3*sqrt(15)/64,0,-7*sqrt(21)/64,0,sqrt(455)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-sqrt(455)/64,0,7*sqrt(21)/64,0,-3*sqrt(15)/64,0]",
        ),
        "Gh(8,Tu,3,2)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(8,Tu,4,0)": (
            "-sqrt(70)*S1/64+3*sqrt(66)*S3/64-sqrt(1430)*S5/64+sqrt(2002)*S7/64",
            "3*sqrt(70)*y*z*(32*x**6-80*x**4*y**2-80*x**4*z**2+30*x**2*y**4+60*x**2*y**2*z**2+30*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,sqrt(1001)*I/64,0,-sqrt(715)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(35)*I/64,0,-sqrt(35)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(715)*I/64,0,sqrt(1001)*I/64,0]",
        ),
        "Gh(8,Tu,4,1)": (
            "-sqrt(70)*C1/64-3*sqrt(66)*C3/64-sqrt(1430)*C5/64-sqrt(2002)*C7/64",
            "-3*sqrt(70)*x*z*(x**6-30*x**4*y**2+3*x**4*z**2+80*x**2*y**4-60*x**2*y**2*z**2+3*x**2*z**4-32*y**6+80*y**4*z**2-30*y**2*z**4+z**6)/32",
            "[0,sqrt(1001)/64,0,sqrt(715)/64,0,3*sqrt(33)/64,0,sqrt(35)/64,0,-sqrt(35)/64,0,-3*sqrt(33)/64,0,-sqrt(715)/64,0,-sqrt(1001)/64,0]",
        ),
        "Gh(8,Tu,4,2)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(9,Ag,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Gh(9,Ag,2,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Gh(9,Eg,,0)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(3*x**6-14*x**4*y**2-7*x**4*z**2+14*x**2*y**4+7*x**2*z**4-3*y**6+7*y**4*z**2-7*y**2*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Gh(9,Eg,,1)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Gh(9,Tg,1,0)": (
            "21*sqrt(5)*C1/128-sqrt(2310)*C3/128+3*sqrt(286)*C5/128-3*sqrt(1430)*C7/256+sqrt(24310)*C9/256",
            "x*(128*x**8-2304*x**6*y**2-2304*x**6*z**2+6048*x**4*y**4+12096*x**4*y**2*z**2+6048*x**4*z**4-3360*x**2*y**6-10080*x**2*y**4*z**2-10080*x**2*y**2*z**4-3360*x**2*z**6+315*y**8+1260*y**6*z**2+1890*y**4*z**4+1260*y**2*z**6+315*z**8)/128",
            "[-sqrt(12155)/256,0,3*sqrt(715)/256,0,-3*sqrt(143)/128,0,sqrt(1155)/128,0,-21*sqrt(10)/256,0,21*sqrt(10)/256,0,-sqrt(1155)/128,0,3*sqrt(143)/128,0,-3*sqrt(715)/256,0,sqrt(12155)/256]",
        ),
        "Gh(9,Tg,1,1)": (
            "21*sqrt(5)*S1/128+sqrt(2310)*S3/128+3*sqrt(286)*S5/128+3*sqrt(1430)*S7/256+sqrt(24310)*S9/256",
            "y*(315*x**8-3360*x**6*y**2+1260*x**6*z**2+6048*x**4*y**4-10080*x**4*y**2*z**2+1890*x**4*z**4-2304*x**2*y**6+12096*x**2*y**4*z**2-10080*x**2*y**2*z**4+1260*x**2*z**6+128*y**8-2304*y**6*z**2+6048*y**4*z**4-3360*y**2*z**6+315*z**8)/128",
            "[sqrt(12155)*I/256,0,3*sqrt(715)*I/256,0,3*sqrt(143)*I/128,0,sqrt(1155)*I/128,0,21*sqrt(10)*I/256,0,21*sqrt(10)*I/256,0,sqrt(1155)*I/128,0,3*sqrt(143)*I/128,0,3*sqrt(715)*I/256,0,sqrt(12155)*I/256]",
        ),
        "Gh(9,Tg,1,2)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(9,Tg,2,0)": (
            "sqrt(2431)*C1/128+sqrt(9282)*C3/128+5*sqrt(170)*C5/128+7*sqrt(34)*C7/256+3*sqrt(2)*C9/256",
            "3*sqrt(12155)*x*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/128",
            "[-3/256,0,-7*sqrt(17)/256,0,-5*sqrt(85)/128,0,-sqrt(4641)/128,0,-sqrt(4862)/256,0,sqrt(4862)/256,0,sqrt(4641)/128,0,5*sqrt(85)/128,0,7*sqrt(17)/256,0,3/256]",
        ),
        "Gh(9,Tg,2,1)": (
            "sqrt(2431)*S1/128-sqrt(9282)*S3/128+5*sqrt(170)*S5/128-7*sqrt(34)*S7/256+3*sqrt(2)*S9/256",
            "3*sqrt(12155)*y*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/128",
            "[3*I/256,0,-7*sqrt(17)*I/256,0,5*sqrt(85)*I/128,0,-sqrt(4641)*I/128,0,sqrt(4862)*I/256,0,sqrt(4862)*I/256,0,-sqrt(4641)*I/128,0,5*sqrt(85)*I/128,0,-7*sqrt(17)*I/256,0,3*I/256]",
        ),
        "Gh(9,Tg,2,2)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(9,Tg,3,0)": (
            "sqrt(1001)*C1/64-sqrt(78)*C3/64-3*sqrt(70)*C5/64+23*sqrt(14)*C7/128+3*sqrt(238)*C9/128",
            "3*sqrt(5005)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(8*x**4-8*x**2*y**2-8*x**2*z**2+y**4+2*y**2*z**2+z**4)/64",
            "[-3*sqrt(119)/128,0,-23*sqrt(7)/128,0,3*sqrt(35)/64,0,sqrt(39)/64,0,-sqrt(2002)/128,0,sqrt(2002)/128,0,-sqrt(39)/64,0,-3*sqrt(35)/64,0,23*sqrt(7)/128,0,3*sqrt(119)/128]",
        ),
        "Gh(9,Tg,3,1)": (
            "sqrt(1001)*S1/64+sqrt(78)*S3/64-3*sqrt(70)*S5/64-23*sqrt(14)*S7/128+3*sqrt(238)*S9/128",
            "3*sqrt(5005)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(x**4-8*x**2*y**2+2*x**2*z**2+8*y**4-8*y**2*z**2+z**4)/64",
            "[3*sqrt(119)*I/128,0,-23*sqrt(7)*I/128,0,-3*sqrt(35)*I/64,0,sqrt(39)*I/64,0,sqrt(2002)*I/128,0,sqrt(2002)*I/128,0,sqrt(39)*I/64,0,-3*sqrt(35)*I/64,0,-23*sqrt(7)*I/128,0,3*sqrt(119)*I/128]",
        ),
        "Gh(9,Tg,3,2)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(9,Tg,4,0)": (
            "sqrt(858)*C1/64+sqrt(91)*C3/32-5*sqrt(15)*C5/32-21*sqrt(3)*C7/64-sqrt(51)*C9/64",
            "sqrt(4290)*x*(y-z)*(y+z)*(14*x**2-3*y**2-3*z**2)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/64",
            "[sqrt(102)/128,0,21*sqrt(6)/128,0,5*sqrt(30)/64,0,-sqrt(182)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(182)/64,0,-5*sqrt(30)/64,0,-21*sqrt(6)/128,0,-sqrt(102)/128]",
        ),
        "Gh(9,Tg,4,1)": (
            "-sqrt(858)*S1/64+sqrt(91)*S3/32+5*sqrt(15)*S5/32-21*sqrt(3)*S7/64+sqrt(51)*S9/64",
            "sqrt(4290)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(3*x**2-14*y**2+3*z**2)/64",
            "[sqrt(102)*I/128,0,-21*sqrt(6)*I/128,0,5*sqrt(30)*I/64,0,sqrt(182)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(182)*I/64,0,5*sqrt(30)*I/64,0,-21*sqrt(6)*I/128,0,sqrt(102)*I/128]",
        ),
        "Gh(9,Tg,4,2)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(9,Tg,5,0)": (
            "7*sqrt(22)*C1/64-3*sqrt(21)*C3/32+sqrt(65)*C5/32+sqrt(13)*C7/64-3*sqrt(221)*C9/64",
            "3*sqrt(110)*x*(y-z)*(y+z)*(32*x**6-112*x**4*y**2-112*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-7*y**6-21*y**4*z**2-21*y**2*z**4-7*z**6)/64",
            "[3*sqrt(442)/128,0,-sqrt(26)/128,0,-sqrt(130)/64,0,3*sqrt(42)/64,0,-7*sqrt(11)/64,0,7*sqrt(11)/64,0,-3*sqrt(42)/64,0,sqrt(130)/64,0,sqrt(26)/128,0,-3*sqrt(442)/128]",
        ),
        "Gh(9,Tg,5,1)": (
            "-7*sqrt(22)*S1/64-3*sqrt(21)*S3/32-sqrt(65)*S5/32+sqrt(13)*S7/64+3*sqrt(221)*S9/64",
            "3*sqrt(110)*y*(x-z)*(x+z)*(7*x**6-70*x**4*y**2+21*x**4*z**2+112*x**2*y**4-140*x**2*y**2*z**2+21*x**2*z**4-32*y**6+112*y**4*z**2-70*y**2*z**4+7*z**6)/64",
            "[3*sqrt(442)*I/128,0,sqrt(26)*I/128,0,-sqrt(130)*I/64,0,-3*sqrt(42)*I/64,0,-7*sqrt(11)*I/64,0,-7*sqrt(11)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(130)*I/64,0,sqrt(26)*I/128,0,3*sqrt(442)*I/128]",
        ),
        "Gh(9,Tg,5,2)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(10,Au,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Gh(10,Au,2,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Gh(10,Eu,1,0)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "sqrt(420189)*(-22*x**10-45*x**8*y**2+1035*x**8*z**2+105*x**6*y**4+630*x**6*y**2*z**2-4935*x**6*z**4+105*x**4*y**6-3150*x**4*y**4*z**2+1575*x**4*y**2*z**4+4830*x**4*z**6-45*x**2*y**8+630*x**2*y**6*z**2+1575*x**2*y**4*z**4-1260*x**2*y**2*z**6-990*x**2*z**8-22*y**10+1035*y**8*z**2-4935*y**6*z**4+4830*y**4*z**6-990*y**2*z**8+44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Gh(10,Eu,1,1)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(22*x**10-675*x**8*y**2-315*x**8*z**2+3255*x**6*y**4-630*x**6*y**2*z**2+1575*x**6*z**4-3255*x**4*y**6+1575*x**4*y**2*z**4-1680*x**4*z**6+675*x**2*y**8+630*x**2*y**6*z**2-1575*x**2*y**4*z**4+360*x**2*z**8-22*y**10+315*y**8*z**2-1575*y**6*z**4+1680*y**4*z**6-360*y**2*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Gh(10,Eu,2,0)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "sqrt(3213210)*(-3*x**10+96*x**8*y**2+39*x**8*z**2-224*x**6*y**4-1344*x**6*y**2*z**2+42*x**6*z**4-224*x**4*y**6+6720*x**4*y**4*z**2-3360*x**4*y**2*z**4+182*x**4*z**6+96*x**2*y**8-1344*x**2*y**6*z**2-3360*x**2*y**4*z**4+2688*x**2*y**2*z**6-135*x**2*z**8-3*y**10+39*y**8*z**2+42*y**6*z**4+182*y**4*z**6-135*y**2*z**8+6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Gh(10,Eu,2,1)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(9*x**10-174*x**8*y**2-231*x**8*z**2+140*x**6*y**4+4032*x**6*y**2*z**2+406*x**6*z**4-140*x**4*y**6-10080*x**4*y**2*z**4+266*x**4*z**6+174*x**2*y**8-4032*x**2*y**6*z**2+10080*x**2*y**4*z**4-57*x**2*z**8-9*y**10+231*y**8*z**2-406*y**6*z**4-266*y**4*z**6+57*y**2*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Gh(10,Tu,1,0)": (
            "sqrt(221)*S1/32-sqrt(102)*S3/32-sqrt(510)*S5/32-11*sqrt(6)*S7/64-sqrt(38)*S9/64",
            "sqrt(12155)*y*z*(y-z)*(y+z)*(18*x**2-y**2-z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/32",
            "[0,-sqrt(19)*I/64,0,-11*sqrt(3)*I/64,0,-sqrt(255)*I/32,0,-sqrt(51)*I/32,0,sqrt(442)*I/64,0,sqrt(442)*I/64,0,-sqrt(51)*I/32,0,-sqrt(255)*I/32,0,-11*sqrt(3)*I/64,0,-sqrt(19)*I/64,0]",
        ),
        "Gh(10,Tu,1,1)": (
            "-sqrt(221)*C1/32-sqrt(102)*C3/32+sqrt(510)*C5/32-11*sqrt(6)*C7/64+sqrt(38)*C9/64",
            "sqrt(12155)*x*z*(x-z)*(x+z)*(x**2-18*y**2+z**2)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/32",
            "[0,-sqrt(19)/64,0,11*sqrt(3)/64,0,-sqrt(255)/32,0,sqrt(51)/32,0,sqrt(442)/64,0,-sqrt(442)/64,0,-sqrt(51)/32,0,sqrt(255)/32,0,-11*sqrt(3)/64,0,sqrt(19)/64,0]",
        ),
        "Gh(10,Tu,1,2)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Gh(10,Tu,2,0)": (
            "sqrt(39)*S1/32-11*sqrt(2)*S3/32+5*sqrt(10)*S5/32-sqrt(34)*S7/64-sqrt(1938)*S9/64",
            "sqrt(2145)*y*z*(y-z)*(y+z)*(112*x**6-168*x**4*y**2-168*x**4*z**2+42*x**2*y**4+84*x**2*y**2*z**2+42*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,-sqrt(969)*I/64,0,-sqrt(17)*I/64,0,5*sqrt(5)*I/32,0,-11*I/32,0,sqrt(78)*I/64,0,sqrt(78)*I/64,0,-11*I/32,0,5*sqrt(5)*I/32,0,-sqrt(17)*I/64,0,-sqrt(969)*I/64,0]",
        ),
        "Gh(10,Tu,2,1)": (
            "-sqrt(39)*C1/32-11*sqrt(2)*C3/32-5*sqrt(10)*C5/32-sqrt(34)*C7/64+sqrt(1938)*C9/64",
            "sqrt(2145)*x*z*(x-z)*(x+z)*(x**6-42*x**4*y**2+3*x**4*z**2+168*x**2*y**4-84*x**2*y**2*z**2+3*x**2*z**4-112*y**6+168*y**4*z**2-42*y**2*z**4+z**6)/32",
            "[0,-sqrt(969)/64,0,sqrt(17)/64,0,5*sqrt(5)/32,0,11/32,0,sqrt(78)/64,0,-sqrt(78)/64,0,-11/32,0,-5*sqrt(5)/32,0,-sqrt(17)/64,0,sqrt(969)/64,0]",
        ),
        "Gh(10,Tu,2,2)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Gh(10,Tu,3,0)": (
            "sqrt(41990)*S1/256+sqrt(4845)*S3/128+sqrt(969)*S5/128+sqrt(285)*S7/256+sqrt(5)*S9/256",
            "sqrt(92378)*y*z*(y**4-10*y**2*z**2+5*z**4)*(5*y**4-10*y**2*z**2+z**4)/256",
            "[0,sqrt(10)*I/512,0,sqrt(570)*I/512,0,sqrt(1938)*I/256,0,sqrt(9690)*I/256,0,sqrt(20995)*I/256,0,sqrt(20995)*I/256,0,sqrt(9690)*I/256,0,sqrt(1938)*I/256,0,sqrt(570)*I/512,0,sqrt(10)*I/512,0]",
        ),
        "Gh(10,Tu,3,1)": (
            "sqrt(41990)*C1/256-sqrt(4845)*C3/128+sqrt(969)*C5/128-sqrt(285)*C7/256+sqrt(5)*C9/256",
            "sqrt(92378)*x*z*(x**4-10*x**2*z**2+5*z**4)*(5*x**4-10*x**2*z**2+z**4)/256",
            "[0,-sqrt(10)/512,0,sqrt(570)/512,0,-sqrt(1938)/256,0,sqrt(9690)/256,0,-sqrt(20995)/256,0,sqrt(20995)/256,0,-sqrt(9690)/256,0,sqrt(1938)/256,0,-sqrt(570)/512,0,sqrt(10)/512,0]",
        ),
        "Gh(10,Tu,3,2)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Gh(10,Tu,4,0)": (
            "9*sqrt(78)*S1/256-69*S3/128-sqrt(5)*S5/128+43*sqrt(17)*S7/256+3*sqrt(969)*S9/256",
            "sqrt(4290)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(224*x**4-96*x**2*y**2-96*x**2*z**2+3*y**4+6*y**2*z**2+3*z**4)/256",
            "[0,3*sqrt(1938)*I/512,0,43*sqrt(34)*I/512,0,-sqrt(10)*I/256,0,-69*sqrt(2)*I/256,0,9*sqrt(39)*I/256,0,9*sqrt(39)*I/256,0,-69*sqrt(2)*I/256,0,-sqrt(10)*I/256,0,43*sqrt(34)*I/512,0,3*sqrt(1938)*I/512,0]",
        ),
        "Gh(10,Tu,4,1)": (
            "9*sqrt(78)*C1/256+69*C3/128-sqrt(5)*C5/128-43*sqrt(17)*C7/256+3*sqrt(969)*C9/256",
            "sqrt(4290)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(3*x**4-96*x**2*y**2+6*x**2*z**2+224*y**4-96*y**2*z**2+3*z**4)/256",
            "[0,-3*sqrt(1938)/512,0,43*sqrt(34)/512,0,sqrt(10)/256,0,-69*sqrt(2)/256,0,-9*sqrt(39)/256,0,9*sqrt(39)/256,0,69*sqrt(2)/256,0,-sqrt(10)/256,0,-43*sqrt(34)/512,0,3*sqrt(1938)/512,0]",
        ),
        "Gh(10,Tu,4,2)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Gh(10,Tu,5,0)": (
            "7*sqrt(3)*S1/128-7*sqrt(26)*S3/128+5*sqrt(130)*S5/128-7*sqrt(442)*S7/256+sqrt(25194)*S9/256",
            "sqrt(165)*y*z*(384*x**8-1792*x**6*y**2-1792*x**6*z**2+1680*x**4*y**4+3360*x**4*y**2*z**2+1680*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+7*y**8+28*y**6*z**2+42*y**4*z**4+28*y**2*z**6+7*z**8)/128",
            "[0,sqrt(12597)*I/256,0,-7*sqrt(221)*I/256,0,5*sqrt(65)*I/128,0,-7*sqrt(13)*I/128,0,7*sqrt(6)*I/256,0,7*sqrt(6)*I/256,0,-7*sqrt(13)*I/128,0,5*sqrt(65)*I/128,0,-7*sqrt(221)*I/256,0,sqrt(12597)*I/256,0]",
        ),
        "Gh(10,Tu,5,1)": (
            "7*sqrt(3)*C1/128+7*sqrt(26)*C3/128+5*sqrt(130)*C5/128+7*sqrt(442)*C7/256+sqrt(25194)*C9/256",
            "sqrt(165)*x*z*(7*x**8-336*x**6*y**2+28*x**6*z**2+1680*x**4*y**4-1008*x**4*y**2*z**2+42*x**4*z**4-1792*x**2*y**6+3360*x**2*y**4*z**2-1008*x**2*y**2*z**4+28*x**2*z**6+384*y**8-1792*y**6*z**2+1680*y**4*z**4-336*y**2*z**6+7*z**8)/128",
            "[0,-sqrt(12597)/256,0,-7*sqrt(221)/256,0,-5*sqrt(65)/128,0,-7*sqrt(13)/128,0,-7*sqrt(6)/256,0,7*sqrt(6)/256,0,7*sqrt(13)/128,0,5*sqrt(65)/128,0,7*sqrt(221)/256,0,sqrt(12597)/256,0]",
        ),
        "Gh(10,Tu,5,2)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,Ag,,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Gh(11,Eg,1,0)": (
            "S8",
            "sqrt(692835)*x*y*z*(-x**8+6*x**6*y**2+6*x**6*z**2-42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2+y**8-6*y**6*z**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Gh(11,Eg,1,1)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "sqrt(230945)*x*y*z*(-x**8+6*x**6*y**2+6*x**6*z**2-42*x**4*y**2*z**2+6*x**2*y**6-42*x**2*y**4*z**2+84*x**2*y**2*z**4-12*x**2*z**6-y**8+6*y**6*z**2-12*y**2*z**6+2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Gh(11,Eg,2,0)": (
            "S4",
            "3*sqrt(1001)*x*y*z*(-5*x**8-10*x**6*y**2+70*x**6*z**2+70*x**4*y**2*z**2-168*x**4*z**4+10*x**2*y**6-70*x**2*y**4*z**2+80*x**2*z**6+5*y**8-70*y**6*z**2+168*y**4*z**4-80*y**2*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Gh(11,Eg,2,1)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "sqrt(3003)*x*y*z*(-5*x**8+150*x**6*y**2-90*x**6*z**2-336*x**4*y**4+70*x**4*y**2*z**2+168*x**4*z**4+150*x**2*y**6+70*x**2*y**4*z**2-140*x**2*y**2*z**4-60*x**2*z**6-5*y**8-90*y**6*z**2+168*y**4*z**4-60*y**2*z**6+10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Gh(11,Tg,1,0)": (
            "-21*sqrt(66)*C1/512+sqrt(88179)*C11/512+sqrt(30030)*C3/512-15*sqrt(143)*C5/512+sqrt(36465)*C7/512-sqrt(46189)*C9/512",
            "x*(256*x**10-7040*x**8*y**2-7040*x**8*z**2+31680*x**6*y**4+63360*x**6*y**2*z**2+31680*x**6*z**4-36960*x**4*y**6-110880*x**4*y**4*z**2-110880*x**4*y**2*z**4-36960*x**4*z**6+11550*x**2*y**8+46200*x**2*y**6*z**2+69300*x**2*y**4*z**4+46200*x**2*y**2*z**6+11550*x**2*z**8-693*y**10-3465*y**8*z**2-6930*y**6*z**4-6930*y**4*z**6-3465*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)/1024,0,sqrt(92378)/1024,0,-sqrt(72930)/1024,0,15*sqrt(286)/1024,0,-sqrt(15015)/512,0,21*sqrt(33)/512,0,-21*sqrt(33)/512,0,sqrt(15015)/512,0,-15*sqrt(286)/1024,0,sqrt(72930)/1024,0,-sqrt(92378)/1024,0,sqrt(176358)/1024]",
        ),
        "Gh(11,Tg,1,1)": (
            "-21*sqrt(66)*S1/512-sqrt(88179)*S11/512-sqrt(30030)*S3/512-15*sqrt(143)*S5/512-sqrt(36465)*S7/512-sqrt(46189)*S9/512",
            "-y*(693*x**10-11550*x**8*y**2+3465*x**8*z**2+36960*x**6*y**4-46200*x**6*y**2*z**2+6930*x**6*z**4-31680*x**4*y**6+110880*x**4*y**4*z**2-69300*x**4*y**2*z**4+6930*x**4*z**6+7040*x**2*y**8-63360*x**2*y**6*z**2+110880*x**2*y**4*z**4-46200*x**2*y**2*z**6+3465*x**2*z**8-256*y**10+7040*y**8*z**2-31680*y**6*z**4+36960*y**4*z**6-11550*y**2*z**8+693*z**10)/256",
            "[-sqrt(176358)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(72930)*I/1024,0,-15*sqrt(286)*I/1024,0,-sqrt(15015)*I/512,0,-21*sqrt(33)*I/512,0,-21*sqrt(33)*I/512,0,-sqrt(15015)*I/512,0,-15*sqrt(286)*I/1024,0,-sqrt(72930)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(176358)*I/1024]",
        ),
        "Gh(11,Tg,1,2)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Gh(11,Tg,2,0)": (
            "-sqrt(41990)*C1/512+sqrt(385)*C11/512-3*sqrt(4522)*C3/512+3*sqrt(4845)*C5/512+77*sqrt(19)*C7/512+39*sqrt(15)*C9/512",
            "sqrt(692835)*x*(6*x**2-y**2-z**2)*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/256",
            "[-sqrt(770)/1024,0,-39*sqrt(30)/1024,0,-77*sqrt(38)/1024,0,-3*sqrt(9690)/1024,0,3*sqrt(2261)/512,0,sqrt(20995)/512,0,-sqrt(20995)/512,0,-3*sqrt(2261)/512,0,3*sqrt(9690)/1024,0,77*sqrt(38)/1024,0,39*sqrt(30)/1024,0,sqrt(770)/1024]",
        ),
        "Gh(11,Tg,2,1)": (
            "-sqrt(41990)*S1/512-sqrt(385)*S11/512+3*sqrt(4522)*S3/512+3*sqrt(4845)*S5/512-77*sqrt(19)*S7/512+39*sqrt(15)*S9/512",
            "-sqrt(692835)*y*(x**2-6*y**2+z**2)*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/256",
            "[-sqrt(770)*I/1024,0,39*sqrt(30)*I/1024,0,-77*sqrt(38)*I/1024,0,3*sqrt(9690)*I/1024,0,3*sqrt(2261)*I/512,0,-sqrt(20995)*I/512,0,-sqrt(20995)*I/512,0,3*sqrt(2261)*I/512,0,3*sqrt(9690)*I/1024,0,-77*sqrt(38)*I/1024,0,39*sqrt(30)*I/1024,0,-sqrt(770)*I/1024]",
        ),
        "Gh(11,Tg,2,2)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Gh(11,Tg,3,0)": (
            "-5*sqrt(546)*C1/256+sqrt(10659)*C11/256+11*sqrt(30)*C3/256+13*sqrt(7)*C5/256-3*sqrt(1785)*C7/256+3*sqrt(2261)*C9/256",
            "3*sqrt(1001)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(80*x**6-168*x**4*y**2-168*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-5*y**6-15*y**4*z**2-15*y**2*z**4-5*z**6)/128",
            "[-sqrt(21318)/512,0,-3*sqrt(4522)/512,0,3*sqrt(3570)/512,0,-13*sqrt(14)/512,0,-11*sqrt(15)/256,0,5*sqrt(273)/256,0,-5*sqrt(273)/256,0,11*sqrt(15)/256,0,13*sqrt(14)/512,0,-3*sqrt(3570)/512,0,3*sqrt(4522)/512,0,sqrt(21318)/512]",
        ),
        "Gh(11,Tg,3,1)": (
            "-5*sqrt(546)*S1/256-sqrt(10659)*S11/256-11*sqrt(30)*S3/256+13*sqrt(7)*S5/256+3*sqrt(1785)*S7/256+3*sqrt(2261)*S9/256",
            "-3*sqrt(1001)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(5*x**6-70*x**4*y**2+15*x**4*z**2+168*x**2*y**4-140*x**2*y**2*z**2+15*x**2*z**4-80*y**6+168*y**4*z**2-70*y**2*z**4+5*z**6)/128",
            "[-sqrt(21318)*I/512,0,3*sqrt(4522)*I/512,0,3*sqrt(3570)*I/512,0,13*sqrt(14)*I/512,0,-11*sqrt(15)*I/256,0,-5*sqrt(273)*I/256,0,-5*sqrt(273)*I/256,0,-11*sqrt(15)*I/256,0,13*sqrt(14)*I/512,0,3*sqrt(3570)*I/512,0,3*sqrt(4522)*I/512,0,-sqrt(21318)*I/512]",
        ),
        "Gh(11,Tg,3,2)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Gh(11,Tg,4,0)": (
            "-sqrt(29393)*C1/512-sqrt(22)*C11/1024-9*sqrt(1615)*C3/512-5*sqrt(13566)*C5/1024-7*sqrt(1330)*C7/1024-9*sqrt(42)*C9/1024",
            "sqrt(1939938)*x*(y-z)*(y+z)*(y**4-4*y**3*z-14*y**2*z**2-4*y*z**3+z**4)*(y**4+4*y**3*z-14*y**2*z**2+4*y*z**3+z**4)/512",
            "[sqrt(11)/1024,0,9*sqrt(21)/1024,0,7*sqrt(665)/1024,0,5*sqrt(6783)/1024,0,9*sqrt(3230)/1024,0,sqrt(58786)/1024,0,-sqrt(58786)/1024,0,-9*sqrt(3230)/1024,0,-5*sqrt(6783)/1024,0,-7*sqrt(665)/1024,0,-9*sqrt(21)/1024,0,-sqrt(11)/1024]",
        ),
        "Gh(11,Tg,4,1)": (
            "sqrt(29393)*S1/512-sqrt(22)*S11/1024-9*sqrt(1615)*S3/512+5*sqrt(13566)*S5/1024-7*sqrt(1330)*S7/1024+9*sqrt(42)*S9/1024",
            "-sqrt(1939938)*y*(x-z)*(x+z)*(x**4-4*x**3*z-14*x**2*z**2-4*x*z**3+z**4)*(x**4+4*x**3*z-14*x**2*z**2+4*x*z**3+z**4)/512",
            "[-sqrt(11)*I/1024,0,9*sqrt(21)*I/1024,0,-7*sqrt(665)*I/1024,0,5*sqrt(6783)*I/1024,0,-9*sqrt(3230)*I/1024,0,sqrt(58786)*I/1024,0,sqrt(58786)*I/1024,0,-9*sqrt(3230)*I/1024,0,5*sqrt(6783)*I/1024,0,-7*sqrt(665)*I/1024,0,9*sqrt(21)*I/1024,0,-sqrt(11)*I/1024]",
        ),
        "Gh(11,Tg,4,2)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Gh(11,Tg,5,0)": (
            "-15*sqrt(221)*C1/512-3*sqrt(2926)*C11/1024-sqrt(595)*C3/512+53*sqrt(102)*C5/1024-105*sqrt(10)*C7/1024-61*sqrt(114)*C9/1024",
            "sqrt(14586)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)*(224*x**4-160*x**2*y**2-160*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/512",
            "[3*sqrt(1463)/1024,0,61*sqrt(57)/1024,0,105*sqrt(5)/1024,0,-53*sqrt(51)/1024,0,sqrt(1190)/1024,0,15*sqrt(442)/1024,0,-15*sqrt(442)/1024,0,-sqrt(1190)/1024,0,53*sqrt(51)/1024,0,-105*sqrt(5)/1024,0,-61*sqrt(57)/1024,0,-3*sqrt(1463)/1024]",
        ),
        "Gh(11,Tg,5,1)": (
            "15*sqrt(221)*S1/512-3*sqrt(2926)*S11/1024-sqrt(595)*S3/512-53*sqrt(102)*S5/1024-105*sqrt(10)*S7/1024+61*sqrt(114)*S9/1024",
            "-sqrt(14586)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(15*x**4-160*x**2*y**2+30*x**2*z**2+224*y**4-160*y**2*z**2+15*z**4)/512",
            "[-3*sqrt(1463)*I/1024,0,61*sqrt(57)*I/1024,0,-105*sqrt(5)*I/1024,0,-53*sqrt(51)*I/1024,0,-sqrt(1190)*I/1024,0,15*sqrt(442)*I/1024,0,15*sqrt(442)*I/1024,0,-sqrt(1190)*I/1024,0,-53*sqrt(51)*I/1024,0,-105*sqrt(5)*I/1024,0,61*sqrt(57)*I/1024,0,-3*sqrt(1463)*I/1024]",
        ),
        "Gh(11,Tg,5,2)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Gh(11,Tg,6,0)": (
            "-21*sqrt(130)*C1/512-sqrt(124355)*C11/512+57*sqrt(14)*C3/512-41*sqrt(15)*C5/512+17*sqrt(17)*C7/512+sqrt(4845)*C9/512",
            "sqrt(2145)*x*(y-z)*(y+z)*(128*x**8-768*x**6*y**2-768*x**6*z**2+1008*x**4*y**4+2016*x**4*y**2*z**2+1008*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+21*y**8+84*y**6*z**2+126*y**4*z**4+84*y**2*z**6+21*z**8)/256",
            "[sqrt(248710)/1024,0,-sqrt(9690)/1024,0,-17*sqrt(34)/1024,0,41*sqrt(30)/1024,0,-57*sqrt(7)/512,0,21*sqrt(65)/512,0,-21*sqrt(65)/512,0,57*sqrt(7)/512,0,-41*sqrt(30)/1024,0,17*sqrt(34)/1024,0,sqrt(9690)/1024,0,-sqrt(248710)/1024]",
        ),
        "Gh(11,Tg,6,1)": (
            "21*sqrt(130)*S1/512-sqrt(124355)*S11/512+57*sqrt(14)*S3/512+41*sqrt(15)*S5/512+17*sqrt(17)*S7/512-sqrt(4845)*S9/512",
            "-sqrt(2145)*y*(x-z)*(x+z)*(21*x**8-336*x**6*y**2+84*x**6*z**2+1008*x**4*y**4-1008*x**4*y**2*z**2+126*x**4*z**4-768*x**2*y**6+2016*x**2*y**4*z**2-1008*x**2*y**2*z**4+84*x**2*z**6+128*y**8-768*y**6*z**2+1008*y**4*z**4-336*y**2*z**6+21*z**8)/256",
            "[-sqrt(248710)*I/1024,0,-sqrt(9690)*I/1024,0,17*sqrt(34)*I/1024,0,41*sqrt(30)*I/1024,0,57*sqrt(7)*I/512,0,21*sqrt(65)*I/512,0,21*sqrt(65)*I/512,0,57*sqrt(7)*I/512,0,41*sqrt(30)*I/1024,0,17*sqrt(34)*I/1024,0,-sqrt(9690)*I/1024,0,-sqrt(248710)*I/1024]",
        ),
        "Gh(11,Tg,6,2)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
    },
}
