"""
data of point-group harmonics (polar).
{ tag_harmonics: data }
    data = ( tesseral_harmonics ex., cartesian ex., unitary matrix in descending order, [l,l-1,...,-l] )
"""
_data_harmonics_polar = {
    "C1": {
        "Qh(0,A,,)": ("C0", "1", "[1]"),
        "Qh(1,A,1,)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(2,A,1,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(3,A,1,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(4,A,1,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Qh(5,A,1,)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(6,A,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Qh(7,A,1,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Qh(8,A,1,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Qh(9,A,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Qh(10,A,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Qh(11,A,1,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Qh(1,A,2,)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(2,A,2,)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(3,A,2,)": (
            "-sqrt(6)*C1/4+sqrt(10)*C3/4",
            "x*(2*x**2-3*y**2-3*z**2)/2",
            "[-sqrt(5)/4,0,sqrt(3)/4,0,-sqrt(3)/4,0,sqrt(5)/4]",
        ),
        "Qh(4,A,2,)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "-sqrt(15)*(x**4-12*x**2*y**2+6*x**2*z**2+y**4+6*y**2*z**2-2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Qh(5,A,2,)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(6,A,2,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Qh(7,A,2,)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(8,A,2,)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Qh(9,A,2,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Qh(10,A,2,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Qh(11,A,2,)": (
            "S8",
            "-sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(1,A,3,)": ("C0", "z", "[0,1,0]"),
        "Qh(2,A,3,)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(3,A,3,)": (
            "-sqrt(6)*S1/4-sqrt(10)*S3/4",
            "-y*(3*x**2-2*y**2+3*z**2)/2",
            "[-sqrt(5)*I/4,0,-sqrt(3)*I/4,0,-sqrt(3)*I/4,0,-sqrt(5)*I/4]",
        ),
        "Qh(4,A,3,)": ("-C2", "sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Qh(5,A,3,)": (
            "sqrt(15)*C1/8-sqrt(70)*C3/16+3*sqrt(14)*C5/16",
            "x*(8*x**4-40*x**2*y**2-40*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/8",
            "[-3*sqrt(7)/16,0,sqrt(35)/16,0,-sqrt(30)/16,0,sqrt(30)/16,0,-sqrt(35)/16,0,3*sqrt(7)/16]",
        ),
        "Qh(6,A,3,)": (
            "sqrt(14)*C0/4+sqrt(2)*C4/4",
            "-sqrt(14)*(x**6-15*x**4*z**2+15*x**2*z**4+y**6-15*y**4*z**2+15*y**2*z**4-2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Qh(7,A,3,)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "-sqrt(77)*x*y*z*(3*x**4-20*x**2*y**2+10*x**2*z**2+3*y**4+10*y**2*z**2-6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Qh(8,A,3,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,A,3,)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(x-y)*(x+y)*(3*x**4-11*x**2*y**2-7*x**2*z**2+3*y**4-7*y**2*z**2+7*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Qh(10,A,3,)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "-sqrt(420189)*(22*x**10+45*x**8*y**2-1035*x**8*z**2-105*x**6*y**4-630*x**6*y**2*z**2+4935*x**6*z**4-105*x**4*y**6+3150*x**4*y**4*z**2-1575*x**4*y**2*z**4-4830*x**4*z**6+45*x**2*y**8-630*x**2*y**6*z**2-1575*x**2*y**4*z**4+1260*x**2*y**2*z**6+990*x**2*z**8+22*y**10-1035*y**8*z**2+4935*y**6*z**4-4830*y**4*z**6+990*y**2*z**8-44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Qh(11,A,3,)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "-sqrt(230945)*x*y*z*(x**8-6*x**6*y**2-6*x**6*z**2+42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2-84*x**2*y**2*z**4+12*x**2*z**6+y**8-6*y**6*z**2+12*y**2*z**6-2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Qh(2,A,4,)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Qh(3,A,4,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(4,A,4,)": (
            "-sqrt(14)*S1/4-sqrt(2)*S3/4",
            "sqrt(35)*y*z*(y-z)*(y+z)/2",
            "[0,-I/4,0,-sqrt(7)*I/4,0,-sqrt(7)*I/4,0,-I/4,0]",
        ),
        "Qh(5,A,4,)": (
            "sqrt(15)*S1/8+sqrt(70)*S3/16+3*sqrt(14)*S5/16",
            "y*(15*x**4-40*x**2*y**2+30*x**2*z**2+8*y**4-40*y**2*z**2+15*z**4)/8",
            "[3*sqrt(7)*I/16,0,sqrt(35)*I/16,0,sqrt(30)*I/16,0,sqrt(30)*I/16,0,sqrt(35)*I/16,0,3*sqrt(7)*I/16]",
        ),
        "Qh(6,A,4,)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x-y)*(x+y)*(x**4-9*x**2*y**2-5*x**2*z**2+y**4-5*y**2*z**2+5*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Qh(7,A,4,)": (
            "-5*sqrt(7)*C1/32+3*sqrt(21)*C3/32-sqrt(231)*C5/32+sqrt(429)*C7/32",
            "x*(16*x**6-168*x**4*y**2-168*x**4*z**2+210*x**2*y**4+420*x**2*y**2*z**2+210*x**2*z**4-35*y**6-105*y**4*z**2-105*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)/64,0,sqrt(462)/64,0,-3*sqrt(42)/64,0,5*sqrt(14)/64,0,-5*sqrt(14)/64,0,3*sqrt(42)/64,0,-sqrt(462)/64,0,sqrt(858)/64]",
        ),
        "Qh(8,A,4,)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Qh(9,A,4,)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Qh(10,A,4,)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(x-y)*(x+y)*(22*x**8-653*x**6*y**2-315*x**6*z**2+2602*x**4*y**4-945*x**4*y**2*z**2+1575*x**4*z**4-653*x**2*y**6-945*x**2*y**4*z**2+3150*x**2*y**2*z**4-1680*x**2*z**6+22*y**8-315*y**6*z**2+1575*y**4*z**4-1680*y**2*z**6+360*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Qh(11,A,4,)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(2,A,5,)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Qh(3,A,5,)": (
            "-sqrt(10)*C1/4-sqrt(6)*C3/4",
            "sqrt(15)*x*(y-z)*(y+z)/2",
            "[sqrt(3)/4,0,sqrt(5)/4,0,-sqrt(5)/4,0,-sqrt(3)/4]",
        ),
        "Qh(4,A,5,)": ("sqrt(14)*C1/4-sqrt(2)*C3/4", "-sqrt(35)*x*z*(x-z)*(x+z)/2", "[0,1/4,0,-sqrt(7)/4,0,sqrt(7)/4,0,-1/4,0]"),
        "Qh(5,A,5,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(6,A,5,)": (
            "sqrt(3)*S1/4-sqrt(30)*S3/8-sqrt(22)*S5/8",
            "3*sqrt(7)*y*z*(y-z)*(y+z)*(10*x**2-y**2-z**2)/4",
            "[0,-sqrt(11)*I/8,0,-sqrt(15)*I/8,0,sqrt(6)*I/8,0,sqrt(6)*I/8,0,-sqrt(15)*I/8,0,-sqrt(11)*I/8,0]",
        ),
        "Qh(7,A,5,)": (
            "-5*sqrt(7)*S1/32-3*sqrt(21)*S3/32-sqrt(231)*S5/32-sqrt(429)*S7/32",
            "-y*(35*x**6-210*x**4*y**2+105*x**4*z**2+168*x**2*y**4-420*x**2*y**2*z**2+105*x**2*z**4-16*y**6+168*y**4*z**2-210*y**2*z**4+35*z**6)/16",
            "[-sqrt(858)*I/64,0,-sqrt(462)*I/64,0,-3*sqrt(42)*I/64,0,-5*sqrt(14)*I/64,0,-5*sqrt(14)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(462)*I/64,0,-sqrt(858)*I/64]",
        ),
        "Qh(8,A,5,)": (
            "C2",
            "-3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(9,A,5,)": (
            "21*sqrt(5)*C1/128-sqrt(2310)*C3/128+3*sqrt(286)*C5/128-3*sqrt(1430)*C7/256+sqrt(24310)*C9/256",
            "x*(128*x**8-2304*x**6*y**2-2304*x**6*z**2+6048*x**4*y**4+12096*x**4*y**2*z**2+6048*x**4*z**4-3360*x**2*y**6-10080*x**2*y**4*z**2-10080*x**2*y**2*z**4-3360*x**2*z**6+315*y**8+1260*y**6*z**2+1890*y**4*z**4+1260*y**2*z**6+315*z**8)/128",
            "[-sqrt(12155)/256,0,3*sqrt(715)/256,0,-3*sqrt(143)/128,0,sqrt(1155)/128,0,-21*sqrt(10)/256,0,21*sqrt(10)/256,0,-sqrt(1155)/128,0,3*sqrt(143)/128,0,-3*sqrt(715)/256,0,sqrt(12155)/256]",
        ),
        "Qh(10,A,5,)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "-sqrt(3213210)*(3*x**10-96*x**8*y**2-39*x**8*z**2+224*x**6*y**4+1344*x**6*y**2*z**2-42*x**6*z**4+224*x**4*y**6-6720*x**4*y**4*z**2+3360*x**4*y**2*z**4-182*x**4*z**6-96*x**2*y**8+1344*x**2*y**6*z**2+3360*x**2*y**4*z**4-2688*x**2*y**2*z**6+135*x**2*z**8+3*y**10-39*y**8*z**2-42*y**6*z**4-182*y**4*z**6+135*y**2*z**8-6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Qh(11,A,5,)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "-sqrt(3003)*x*y*z*(5*x**8-150*x**6*y**2+90*x**6*z**2+336*x**4*y**4-70*x**4*y**2*z**2-168*x**4*z**4-150*x**2*y**6-70*x**2*y**4*z**2+140*x**2*y**2*z**4+60*x**2*z**6+5*y**8+90*y**6*z**2-168*y**4*z**4+60*y**2*z**6-10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Qh(3,A,6,)": (
            "sqrt(10)*S1/4-sqrt(6)*S3/4",
            "-sqrt(15)*y*(x-z)*(x+z)/2",
            "[-sqrt(3)*I/4,0,sqrt(5)*I/4,0,sqrt(5)*I/4,0,-sqrt(3)*I/4]",
        ),
        "Qh(4,A,6,)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(5,A,6,)": (
            "sqrt(21)*C1/8+9*sqrt(2)*C3/16+sqrt(10)*C5/16",
            "3*sqrt(35)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/8",
            "[-sqrt(5)/16,0,-9/16,0,-sqrt(42)/16,0,sqrt(42)/16,0,9/16,0,sqrt(5)/16]",
        ),
        "Qh(6,A,6,)": (
            "-sqrt(3)*C1/4-sqrt(30)*C3/8+sqrt(22)*C5/8",
            "3*sqrt(7)*x*z*(x-z)*(x+z)*(x**2-10*y**2+z**2)/4",
            "[0,-sqrt(11)/8,0,sqrt(15)/8,0,sqrt(6)/8,0,-sqrt(6)/8,0,-sqrt(15)/8,0,sqrt(11)/8,0]",
        ),
        "Qh(7,A,6,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(8,A,6,)": (
            "-sqrt(715)*S1/32-sqrt(273)*S3/32-sqrt(35)*S5/32-S7/32",
            "3*sqrt(715)*y*z*(y-z)*(y+z)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[0,-sqrt(2)*I/64,0,-sqrt(70)*I/64,0,-sqrt(546)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(546)*I/64,0,-sqrt(70)*I/64,0,-sqrt(2)*I/64,0]",
        ),
        "Qh(9,A,6,)": (
            "21*sqrt(5)*S1/128+sqrt(2310)*S3/128+3*sqrt(286)*S5/128+3*sqrt(1430)*S7/256+sqrt(24310)*S9/256",
            "y*(315*x**8-3360*x**6*y**2+1260*x**6*z**2+6048*x**4*y**4-10080*x**4*y**2*z**2+1890*x**4*z**4-2304*x**2*y**6+12096*x**2*y**4*z**2-10080*x**2*y**2*z**4+1260*x**2*z**6+128*y**8-2304*y**6*z**2+6048*y**4*z**4-3360*y**2*z**6+315*z**8)/128",
            "[sqrt(12155)*I/256,0,3*sqrt(715)*I/256,0,3*sqrt(143)*I/128,0,sqrt(1155)*I/128,0,21*sqrt(10)*I/256,0,21*sqrt(10)*I/256,0,sqrt(1155)*I/128,0,3*sqrt(143)*I/128,0,3*sqrt(715)*I/256,0,sqrt(12155)*I/256]",
        ),
        "Qh(10,A,6,)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(x-y)*(x+y)*(9*x**8-165*x**6*y**2-231*x**6*z**2-25*x**4*y**4+3801*x**4*y**2*z**2+406*x**4*z**4-165*x**2*y**6+3801*x**2*y**4*z**2-9674*x**2*y**2*z**4+266*x**2*z**6+9*y**8-231*y**6*z**2+406*y**4*z**4+266*y**2*z**6-57*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Qh(11,A,6,)": (
            "-21*sqrt(66)*C1/512+sqrt(88179)*C11/512+sqrt(30030)*C3/512-15*sqrt(143)*C5/512+sqrt(36465)*C7/512-sqrt(46189)*C9/512",
            "x*(256*x**10-7040*x**8*y**2-7040*x**8*z**2+31680*x**6*y**4+63360*x**6*y**2*z**2+31680*x**6*z**4-36960*x**4*y**6-110880*x**4*y**4*z**2-110880*x**4*y**2*z**4-36960*x**4*z**6+11550*x**2*y**8+46200*x**2*y**6*z**2+69300*x**2*y**4*z**4+46200*x**2*y**2*z**6+11550*x**2*z**8-693*y**10-3465*y**8*z**2-6930*y**6*z**4-6930*y**4*z**6-3465*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)/1024,0,sqrt(92378)/1024,0,-sqrt(72930)/1024,0,15*sqrt(286)/1024,0,-sqrt(15015)/512,0,21*sqrt(33)/512,0,-21*sqrt(33)/512,0,sqrt(15015)/512,0,-15*sqrt(286)/1024,0,sqrt(72930)/1024,0,-sqrt(92378)/1024,0,sqrt(176358)/1024]",
        ),
        "Qh(3,A,7,)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(4,A,7,)": (
            "-sqrt(2)*S1/4+sqrt(14)*S3/4",
            "sqrt(5)*y*z*(6*x**2-y**2-z**2)/2",
            "[0,sqrt(7)*I/4,0,-I/4,0,-I/4,0,sqrt(7)*I/4,0]",
        ),
        "Qh(5,A,7,)": (
            "sqrt(21)*S1/8-9*sqrt(2)*S3/16+sqrt(10)*S5/16",
            "3*sqrt(35)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/8",
            "[sqrt(5)*I/16,0,-9*I/16,0,sqrt(42)*I/16,0,sqrt(42)*I/16,0,-9*I/16,0,sqrt(5)*I/16]",
        ),
        "Qh(6,A,7,)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(7,A,7,)": (
            "-3*sqrt(33)*C1/32-sqrt(11)*C3/32+25*C5/32+sqrt(91)*C7/32",
            "sqrt(231)*x*(10*x**2-3*y**2-3*z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[-sqrt(182)/64,0,-25*sqrt(2)/64,0,sqrt(22)/64,0,3*sqrt(66)/64,0,-3*sqrt(66)/64,0,-sqrt(22)/64,0,25*sqrt(2)/64,0,sqrt(182)/64]",
        ),
        "Qh(8,A,7,)": (
            "sqrt(715)*C1/32-sqrt(273)*C3/32+sqrt(35)*C5/32-C7/32",
            "-3*sqrt(715)*x*z*(x-z)*(x+z)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/16",
            "[0,sqrt(2)/64,0,-sqrt(70)/64,0,sqrt(546)/64,0,-sqrt(1430)/64,0,sqrt(1430)/64,0,-sqrt(546)/64,0,sqrt(70)/64,0,-sqrt(2)/64,0]",
        ),
        "Qh(9,A,7,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A,7,)": (
            "sqrt(221)*S1/32-sqrt(102)*S3/32-sqrt(510)*S5/32-11*sqrt(6)*S7/64-sqrt(38)*S9/64",
            "sqrt(12155)*y*z*(y-z)*(y+z)*(18*x**2-y**2-z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/32",
            "[0,-sqrt(19)*I/64,0,-11*sqrt(3)*I/64,0,-sqrt(255)*I/32,0,-sqrt(51)*I/32,0,sqrt(442)*I/64,0,sqrt(442)*I/64,0,-sqrt(51)*I/32,0,-sqrt(255)*I/32,0,-11*sqrt(3)*I/64,0,-sqrt(19)*I/64,0]",
        ),
        "Qh(11,A,7,)": (
            "-21*sqrt(66)*S1/512-sqrt(88179)*S11/512-sqrt(30030)*S3/512-15*sqrt(143)*S5/512-sqrt(36465)*S7/512-sqrt(46189)*S9/512",
            "-y*(693*x**10-11550*x**8*y**2+3465*x**8*z**2+36960*x**6*y**4-46200*x**6*y**2*z**2+6930*x**6*z**4-31680*x**4*y**6+110880*x**4*y**4*z**2-69300*x**4*y**2*z**4+6930*x**4*z**6+7040*x**2*y**8-63360*x**2*y**6*z**2+110880*x**2*y**4*z**4-46200*x**2*y**2*z**6+3465*x**2*z**8-256*y**10+7040*y**8*z**2-31680*y**6*z**4+36960*y**4*z**6-11550*y**2*z**8+693*z**10)/256",
            "[-sqrt(176358)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(72930)*I/1024,0,-15*sqrt(286)*I/1024,0,-sqrt(15015)*I/512,0,-21*sqrt(33)*I/512,0,-21*sqrt(33)*I/512,0,-sqrt(15015)*I/512,0,-15*sqrt(286)*I/1024,0,-sqrt(72930)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(176358)*I/1024]",
        ),
        "Qh(4,A,8,)": (
            "-sqrt(2)*C1/4-sqrt(14)*C3/4",
            "-sqrt(5)*x*z*(x**2-6*y**2+z**2)/2",
            "[0,sqrt(7)/4,0,1/4,0,-1/4,0,-sqrt(7)/4,0]",
        ),
        "Qh(5,A,8,)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(6,A,8,)": (
            "3*sqrt(22)*S1/16+sqrt(55)*S3/16+sqrt(3)*S5/16",
            "sqrt(462)*y*z*(y**2-3*z**2)*(3*y**2-z**2)/16",
            "[0,sqrt(6)*I/32,0,sqrt(110)*I/32,0,3*sqrt(11)*I/16,0,3*sqrt(11)*I/16,0,sqrt(110)*I/32,0,sqrt(6)*I/32,0]",
        ),
        "Qh(7,A,8,)": (
            "-3*sqrt(33)*S1/32+sqrt(11)*S3/32+25*S5/32-sqrt(91)*S7/32",
            "-sqrt(231)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(3*x**2-10*y**2+3*z**2)/16",
            "[-sqrt(182)*I/64,0,25*sqrt(2)*I/64,0,sqrt(22)*I/64,0,-3*sqrt(66)*I/64,0,-3*sqrt(66)*I/64,0,sqrt(22)*I/64,0,25*sqrt(2)*I/64,0,-sqrt(182)*I/64]",
        ),
        "Qh(8,A,8,)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(9,A,8,)": (
            "sqrt(2431)*C1/128+sqrt(9282)*C3/128+5*sqrt(170)*C5/128+7*sqrt(34)*C7/256+3*sqrt(2)*C9/256",
            "3*sqrt(12155)*x*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/128",
            "[-3/256,0,-7*sqrt(17)/256,0,-5*sqrt(85)/128,0,-sqrt(4641)/128,0,-sqrt(4862)/256,0,sqrt(4862)/256,0,sqrt(4641)/128,0,5*sqrt(85)/128,0,7*sqrt(17)/256,0,3/256]",
        ),
        "Qh(10,A,8,)": (
            "-sqrt(221)*C1/32-sqrt(102)*C3/32+sqrt(510)*C5/32-11*sqrt(6)*C7/64+sqrt(38)*C9/64",
            "sqrt(12155)*x*z*(x-z)*(x+z)*(x**2-18*y**2+z**2)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/32",
            "[0,-sqrt(19)/64,0,11*sqrt(3)/64,0,-sqrt(255)/32,0,sqrt(51)/32,0,sqrt(442)/64,0,-sqrt(442)/64,0,-sqrt(51)/32,0,sqrt(255)/32,0,-11*sqrt(3)/64,0,sqrt(19)/64,0]",
        ),
        "Qh(11,A,8,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(4,A,9,)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(5,A,9,)": (
            "sqrt(7)*C1/4-sqrt(6)*C3/8-sqrt(30)*C5/8",
            "sqrt(105)*x*(y-z)*(y+z)*(2*x**2-y**2-z**2)/4",
            "[sqrt(15)/8,0,sqrt(3)/8,0,-sqrt(14)/8,0,sqrt(14)/8,0,-sqrt(3)/8,0,-sqrt(15)/8]",
        ),
        "Qh(6,A,9,)": (
            "3*sqrt(22)*C1/16-sqrt(55)*C3/16+sqrt(3)*C5/16",
            "sqrt(462)*x*z*(x**2-3*z**2)*(3*x**2-z**2)/16",
            "[0,-sqrt(6)/32,0,sqrt(110)/32,0,-3*sqrt(11)/16,0,3*sqrt(11)/16,0,-sqrt(110)/32,0,sqrt(6)/32,0]",
        ),
        "Qh(7,A,9,)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(8,A,9,)": (
            "-sqrt(77)*S1/32+5*sqrt(15)*S3/32-3*sqrt(13)*S5/32-sqrt(455)*S7/32",
            "3*sqrt(77)*y*z*(y-z)*(y+z)*(40*x**4-24*x**2*y**2-24*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,-sqrt(910)*I/64,0,-3*sqrt(26)*I/64,0,5*sqrt(30)*I/64,0,-sqrt(154)*I/64,0,-sqrt(154)*I/64,0,5*sqrt(30)*I/64,0,-3*sqrt(26)*I/64,0,-sqrt(910)*I/64,0]",
        ),
        "Qh(9,A,9,)": (
            "sqrt(2431)*S1/128-sqrt(9282)*S3/128+5*sqrt(170)*S5/128-7*sqrt(34)*S7/256+3*sqrt(2)*S9/256",
            "3*sqrt(12155)*y*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/128",
            "[3*I/256,0,-7*sqrt(17)*I/256,0,5*sqrt(85)*I/128,0,-sqrt(4641)*I/128,0,sqrt(4862)*I/256,0,sqrt(4862)*I/256,0,-sqrt(4641)*I/128,0,5*sqrt(85)*I/128,0,-7*sqrt(17)*I/256,0,3*I/256]",
        ),
        "Qh(10,A,9,)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(11,A,9,)": (
            "-sqrt(41990)*C1/512+sqrt(385)*C11/512-3*sqrt(4522)*C3/512+3*sqrt(4845)*C5/512+77*sqrt(19)*C7/512+39*sqrt(15)*C9/512",
            "sqrt(692835)*x*(6*x**2-y**2-z**2)*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/256",
            "[-sqrt(770)/1024,0,-39*sqrt(30)/1024,0,-77*sqrt(38)/1024,0,-3*sqrt(9690)/1024,0,3*sqrt(2261)/512,0,sqrt(20995)/512,0,-sqrt(20995)/512,0,-3*sqrt(2261)/512,0,3*sqrt(9690)/1024,0,77*sqrt(38)/1024,0,39*sqrt(30)/1024,0,sqrt(770)/1024]",
        ),
        "Qh(5,A,10,)": (
            "-sqrt(7)*S1/4-sqrt(6)*S3/8+sqrt(30)*S5/8",
            "sqrt(105)*y*(x-z)*(x+z)*(x**2-2*y**2+z**2)/4",
            "[sqrt(15)*I/8,0,-sqrt(3)*I/8,0,-sqrt(14)*I/8,0,-sqrt(14)*I/8,0,-sqrt(3)*I/8,0,sqrt(15)*I/8]",
        ),
        "Qh(6,A,10,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(7,A,10,)": (
            "-sqrt(858)*C1/64-3*sqrt(286)*C3/64-5*sqrt(26)*C5/64-sqrt(14)*C7/64",
            "sqrt(6006)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/32",
            "[sqrt(7)/64,0,5*sqrt(13)/64,0,3*sqrt(143)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-3*sqrt(143)/64,0,-5*sqrt(13)/64,0,-sqrt(7)/64]",
        ),
        "Qh(8,A,10,)": (
            "sqrt(77)*C1/32+5*sqrt(15)*C3/32+3*sqrt(13)*C5/32-sqrt(455)*C7/32",
            "-3*sqrt(77)*x*z*(x-z)*(x+z)*(x**4-24*x**2*y**2+2*x**2*z**2+40*y**4-24*y**2*z**2+z**4)/16",
            "[0,sqrt(910)/64,0,-3*sqrt(26)/64,0,-5*sqrt(30)/64,0,-sqrt(154)/64,0,sqrt(154)/64,0,5*sqrt(30)/64,0,3*sqrt(26)/64,0,-sqrt(910)/64,0]",
        ),
        "Qh(9,A,10,)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(10,A,10,)": (
            "sqrt(39)*S1/32-11*sqrt(2)*S3/32+5*sqrt(10)*S5/32-sqrt(34)*S7/64-sqrt(1938)*S9/64",
            "sqrt(2145)*y*z*(y-z)*(y+z)*(112*x**6-168*x**4*y**2-168*x**4*z**2+42*x**2*y**4+84*x**2*y**2*z**2+42*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,-sqrt(969)*I/64,0,-sqrt(17)*I/64,0,5*sqrt(5)*I/32,0,-11*I/32,0,sqrt(78)*I/64,0,sqrt(78)*I/64,0,-11*I/32,0,5*sqrt(5)*I/32,0,-sqrt(17)*I/64,0,-sqrt(969)*I/64,0]",
        ),
        "Qh(11,A,10,)": (
            "-sqrt(41990)*S1/512-sqrt(385)*S11/512+3*sqrt(4522)*S3/512+3*sqrt(4845)*S5/512-77*sqrt(19)*S7/512+39*sqrt(15)*S9/512",
            "-sqrt(692835)*y*(x**2-6*y**2+z**2)*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/256",
            "[-sqrt(770)*I/1024,0,39*sqrt(30)*I/1024,0,-77*sqrt(38)*I/1024,0,3*sqrt(9690)*I/1024,0,3*sqrt(2261)*I/512,0,-sqrt(20995)*I/512,0,-sqrt(20995)*I/512,0,3*sqrt(2261)*I/512,0,3*sqrt(9690)*I/1024,0,-77*sqrt(38)*I/1024,0,39*sqrt(30)*I/1024,0,-sqrt(770)*I/1024]",
        ),
        "Qh(5,A,11,)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(6,A,11,)": (
            "sqrt(10)*S1/16-9*S3/16+sqrt(165)*S5/16",
            "sqrt(210)*y*z*(16*x**4-16*x**2*y**2-16*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,sqrt(330)*I/32,0,-9*sqrt(2)*I/32,0,sqrt(5)*I/16,0,sqrt(5)*I/16,0,-9*sqrt(2)*I/32,0,sqrt(330)*I/32,0]",
        ),
        "Qh(7,A,11,)": (
            "sqrt(858)*S1/64-3*sqrt(286)*S3/64+5*sqrt(26)*S5/64-sqrt(14)*S7/64",
            "-sqrt(6006)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)/32",
            "[-sqrt(7)*I/64,0,5*sqrt(13)*I/64,0,-3*sqrt(143)*I/64,0,sqrt(429)*I/64,0,sqrt(429)*I/64,0,-3*sqrt(143)*I/64,0,5*sqrt(13)*I/64,0,-sqrt(7)*I/64]",
        ),
        "Qh(8,A,11,)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(9,A,11,)": (
            "sqrt(1001)*C1/64-sqrt(78)*C3/64-3*sqrt(70)*C5/64+23*sqrt(14)*C7/128+3*sqrt(238)*C9/128",
            "3*sqrt(5005)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(8*x**4-8*x**2*y**2-8*x**2*z**2+y**4+2*y**2*z**2+z**4)/64",
            "[-3*sqrt(119)/128,0,-23*sqrt(7)/128,0,3*sqrt(35)/64,0,sqrt(39)/64,0,-sqrt(2002)/128,0,sqrt(2002)/128,0,-sqrt(39)/64,0,-3*sqrt(35)/64,0,23*sqrt(7)/128,0,3*sqrt(119)/128]",
        ),
        "Qh(10,A,11,)": (
            "-sqrt(39)*C1/32-11*sqrt(2)*C3/32-5*sqrt(10)*C5/32-sqrt(34)*C7/64+sqrt(1938)*C9/64",
            "sqrt(2145)*x*z*(x-z)*(x+z)*(x**6-42*x**4*y**2+3*x**4*z**2+168*x**2*y**4-84*x**2*y**2*z**2+3*x**2*z**4-112*y**6+168*y**4*z**2-42*y**2*z**4+z**6)/32",
            "[0,-sqrt(969)/64,0,sqrt(17)/64,0,5*sqrt(5)/32,0,11/32,0,sqrt(78)/64,0,-sqrt(78)/64,0,-11/32,0,-5*sqrt(5)/32,0,-sqrt(17)/64,0,sqrt(969)/64,0]",
        ),
        "Qh(11,A,11,)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(6,A,12,)": (
            "sqrt(10)*C1/16+9*C3/16+sqrt(165)*C5/16",
            "sqrt(210)*x*z*(x**4-16*x**2*y**2+2*x**2*z**2+16*y**4-16*y**2*z**2+z**4)/16",
            "[0,-sqrt(330)/32,0,-9*sqrt(2)/32,0,-sqrt(5)/16,0,sqrt(5)/16,0,9*sqrt(2)/32,0,sqrt(330)/32,0]",
        ),
        "Qh(7,A,12,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(8,A,12,)": (
            "-sqrt(858)*S1/64+sqrt(910)*S3/64+7*sqrt(42)*S5/64+3*sqrt(30)*S7/64",
            "sqrt(858)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(14*x**2-y**2-z**2)/32",
            "[0,3*sqrt(15)*I/64,0,7*sqrt(21)*I/64,0,sqrt(455)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(455)*I/64,0,7*sqrt(21)*I/64,0,3*sqrt(15)*I/64,0]",
        ),
        "Qh(9,A,12,)": (
            "sqrt(1001)*S1/64+sqrt(78)*S3/64-3*sqrt(70)*S5/64-23*sqrt(14)*S7/128+3*sqrt(238)*S9/128",
            "3*sqrt(5005)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(x**4-8*x**2*y**2+2*x**2*z**2+8*y**4-8*y**2*z**2+z**4)/64",
            "[3*sqrt(119)*I/128,0,-23*sqrt(7)*I/128,0,-3*sqrt(35)*I/64,0,sqrt(39)*I/64,0,sqrt(2002)*I/128,0,sqrt(2002)*I/128,0,sqrt(39)*I/64,0,-3*sqrt(35)*I/64,0,-23*sqrt(7)*I/128,0,3*sqrt(119)*I/128]",
        ),
        "Qh(10,A,12,)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(11,A,12,)": (
            "-5*sqrt(546)*C1/256+sqrt(10659)*C11/256+11*sqrt(30)*C3/256+13*sqrt(7)*C5/256-3*sqrt(1785)*C7/256+3*sqrt(2261)*C9/256",
            "3*sqrt(1001)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(80*x**6-168*x**4*y**2-168*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-5*y**6-15*y**4*z**2-15*y**2*z**4-5*z**6)/128",
            "[-sqrt(21318)/512,0,-3*sqrt(4522)/512,0,3*sqrt(3570)/512,0,-13*sqrt(14)/512,0,-11*sqrt(15)/256,0,5*sqrt(273)/256,0,-5*sqrt(273)/256,0,11*sqrt(15)/256,0,13*sqrt(14)/512,0,-3*sqrt(3570)/512,0,3*sqrt(4522)/512,0,sqrt(21318)/512]",
        ),
        "Qh(6,A,13,)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(7,A,13,)": (
            "-15*sqrt(6)*C1/64+19*sqrt(2)*C3/64-sqrt(22)*C5/64-sqrt(2002)*C7/64",
            "sqrt(42)*x*(y-z)*(y+z)*(48*x**4-80*x**2*y**2-80*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/32",
            "[sqrt(1001)/64,0,sqrt(11)/64,0,-19/64,0,15*sqrt(3)/64,0,-15*sqrt(3)/64,0,19/64,0,-sqrt(11)/64,0,-sqrt(1001)/64]",
        ),
        "Qh(8,A,13,)": (
            "-sqrt(858)*C1/64-sqrt(910)*C3/64+7*sqrt(42)*C5/64-3*sqrt(30)*C7/64",
            "-sqrt(858)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(x**2-14*y**2+z**2)/32",
            "[0,3*sqrt(15)/64,0,-7*sqrt(21)/64,0,sqrt(455)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-sqrt(455)/64,0,7*sqrt(21)/64,0,-3*sqrt(15)/64,0]",
        ),
        "Qh(9,A,13,)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(10,A,13,)": (
            "sqrt(41990)*S1/256+sqrt(4845)*S3/128+sqrt(969)*S5/128+sqrt(285)*S7/256+sqrt(5)*S9/256",
            "sqrt(92378)*y*z*(y**4-10*y**2*z**2+5*z**4)*(5*y**4-10*y**2*z**2+z**4)/256",
            "[0,sqrt(10)*I/512,0,sqrt(570)*I/512,0,sqrt(1938)*I/256,0,sqrt(9690)*I/256,0,sqrt(20995)*I/256,0,sqrt(20995)*I/256,0,sqrt(9690)*I/256,0,sqrt(1938)*I/256,0,sqrt(570)*I/512,0,sqrt(10)*I/512,0]",
        ),
        "Qh(11,A,13,)": (
            "-5*sqrt(546)*S1/256-sqrt(10659)*S11/256-11*sqrt(30)*S3/256+13*sqrt(7)*S5/256+3*sqrt(1785)*S7/256+3*sqrt(2261)*S9/256",
            "-3*sqrt(1001)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(5*x**6-70*x**4*y**2+15*x**4*z**2+168*x**2*y**4-140*x**2*y**2*z**2+15*x**2*z**4-80*y**6+168*y**4*z**2-70*y**2*z**4+5*z**6)/128",
            "[-sqrt(21318)*I/512,0,3*sqrt(4522)*I/512,0,3*sqrt(3570)*I/512,0,13*sqrt(14)*I/512,0,-11*sqrt(15)*I/256,0,-5*sqrt(273)*I/256,0,-5*sqrt(273)*I/256,0,-11*sqrt(15)*I/256,0,13*sqrt(14)*I/512,0,3*sqrt(3570)*I/512,0,3*sqrt(4522)*I/512,0,-sqrt(21318)*I/512]",
        ),
        "Qh(7,A,14,)": (
            "15*sqrt(6)*S1/64+19*sqrt(2)*S3/64+sqrt(22)*S5/64-sqrt(2002)*S7/64",
            "-sqrt(42)*y*(x-z)*(x+z)*(15*x**4-80*x**2*y**2+30*x**2*z**2+48*y**4-80*y**2*z**2+15*z**4)/32",
            "[-sqrt(1001)*I/64,0,sqrt(11)*I/64,0,19*I/64,0,15*sqrt(3)*I/64,0,15*sqrt(3)*I/64,0,19*I/64,0,sqrt(11)*I/64,0,-sqrt(1001)*I/64]",
        ),
        "Qh(8,A,14,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(9,A,14,)": (
            "sqrt(858)*C1/64+sqrt(91)*C3/32-5*sqrt(15)*C5/32-21*sqrt(3)*C7/64-sqrt(51)*C9/64",
            "sqrt(4290)*x*(y-z)*(y+z)*(14*x**2-3*y**2-3*z**2)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/64",
            "[sqrt(102)/128,0,21*sqrt(6)/128,0,5*sqrt(30)/64,0,-sqrt(182)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(182)/64,0,-5*sqrt(30)/64,0,-21*sqrt(6)/128,0,-sqrt(102)/128]",
        ),
        "Qh(10,A,14,)": (
            "sqrt(41990)*C1/256-sqrt(4845)*C3/128+sqrt(969)*C5/128-sqrt(285)*C7/256+sqrt(5)*C9/256",
            "sqrt(92378)*x*z*(x**4-10*x**2*z**2+5*z**4)*(5*x**4-10*x**2*z**2+z**4)/256",
            "[0,-sqrt(10)/512,0,sqrt(570)/512,0,-sqrt(1938)/256,0,sqrt(9690)/256,0,-sqrt(20995)/256,0,sqrt(20995)/256,0,-sqrt(9690)/256,0,sqrt(1938)/256,0,-sqrt(570)/512,0,sqrt(10)/512,0]",
        ),
        "Qh(11,A,14,)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(7,A,15,)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(8,A,15,)": (
            "-sqrt(70)*S1/64+3*sqrt(66)*S3/64-sqrt(1430)*S5/64+sqrt(2002)*S7/64",
            "3*sqrt(70)*y*z*(32*x**6-80*x**4*y**2-80*x**4*z**2+30*x**2*y**4+60*x**2*y**2*z**2+30*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,sqrt(1001)*I/64,0,-sqrt(715)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(35)*I/64,0,-sqrt(35)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(715)*I/64,0,sqrt(1001)*I/64,0]",
        ),
        "Qh(9,A,15,)": (
            "-sqrt(858)*S1/64+sqrt(91)*S3/32+5*sqrt(15)*S5/32-21*sqrt(3)*S7/64+sqrt(51)*S9/64",
            "sqrt(4290)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(3*x**2-14*y**2+3*z**2)/64",
            "[sqrt(102)*I/128,0,-21*sqrt(6)*I/128,0,5*sqrt(30)*I/64,0,sqrt(182)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(182)*I/64,0,5*sqrt(30)*I/64,0,-21*sqrt(6)*I/128,0,sqrt(102)*I/128]",
        ),
        "Qh(10,A,15,)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(11,A,15,)": (
            "-sqrt(29393)*C1/512-sqrt(22)*C11/1024-9*sqrt(1615)*C3/512-5*sqrt(13566)*C5/1024-7*sqrt(1330)*C7/1024-9*sqrt(42)*C9/1024",
            "sqrt(1939938)*x*(y-z)*(y+z)*(y**4-4*y**3*z-14*y**2*z**2-4*y*z**3+z**4)*(y**4+4*y**3*z-14*y**2*z**2+4*y*z**3+z**4)/512",
            "[sqrt(11)/1024,0,9*sqrt(21)/1024,0,7*sqrt(665)/1024,0,5*sqrt(6783)/1024,0,9*sqrt(3230)/1024,0,sqrt(58786)/1024,0,-sqrt(58786)/1024,0,-9*sqrt(3230)/1024,0,-5*sqrt(6783)/1024,0,-7*sqrt(665)/1024,0,-9*sqrt(21)/1024,0,-sqrt(11)/1024]",
        ),
        "Qh(8,A,16,)": (
            "-sqrt(70)*C1/64-3*sqrt(66)*C3/64-sqrt(1430)*C5/64-sqrt(2002)*C7/64",
            "-3*sqrt(70)*x*z*(x**6-30*x**4*y**2+3*x**4*z**2+80*x**2*y**4-60*x**2*y**2*z**2+3*x**2*z**4-32*y**6+80*y**4*z**2-30*y**2*z**4+z**6)/32",
            "[0,sqrt(1001)/64,0,sqrt(715)/64,0,3*sqrt(33)/64,0,sqrt(35)/64,0,-sqrt(35)/64,0,-3*sqrt(33)/64,0,-sqrt(715)/64,0,-sqrt(1001)/64,0]",
        ),
        "Qh(9,A,16,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(10,A,16,)": (
            "9*sqrt(78)*S1/256-69*S3/128-sqrt(5)*S5/128+43*sqrt(17)*S7/256+3*sqrt(969)*S9/256",
            "sqrt(4290)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(224*x**4-96*x**2*y**2-96*x**2*z**2+3*y**4+6*y**2*z**2+3*z**4)/256",
            "[0,3*sqrt(1938)*I/512,0,43*sqrt(34)*I/512,0,-sqrt(10)*I/256,0,-69*sqrt(2)*I/256,0,9*sqrt(39)*I/256,0,9*sqrt(39)*I/256,0,-69*sqrt(2)*I/256,0,-sqrt(10)*I/256,0,43*sqrt(34)*I/512,0,3*sqrt(1938)*I/512,0]",
        ),
        "Qh(11,A,16,)": (
            "sqrt(29393)*S1/512-sqrt(22)*S11/1024-9*sqrt(1615)*S3/512+5*sqrt(13566)*S5/1024-7*sqrt(1330)*S7/1024+9*sqrt(42)*S9/1024",
            "-sqrt(1939938)*y*(x-z)*(x+z)*(x**4-4*x**3*z-14*x**2*z**2-4*x*z**3+z**4)*(x**4+4*x**3*z-14*x**2*z**2+4*x*z**3+z**4)/512",
            "[-sqrt(11)*I/1024,0,9*sqrt(21)*I/1024,0,-7*sqrt(665)*I/1024,0,5*sqrt(6783)*I/1024,0,-9*sqrt(3230)*I/1024,0,sqrt(58786)*I/1024,0,sqrt(58786)*I/1024,0,-9*sqrt(3230)*I/1024,0,5*sqrt(6783)*I/1024,0,-7*sqrt(665)*I/1024,0,9*sqrt(21)*I/1024,0,-sqrt(11)*I/1024]",
        ),
        "Qh(8,A,17,)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,A,17,)": (
            "7*sqrt(22)*C1/64-3*sqrt(21)*C3/32+sqrt(65)*C5/32+sqrt(13)*C7/64-3*sqrt(221)*C9/64",
            "3*sqrt(110)*x*(y-z)*(y+z)*(32*x**6-112*x**4*y**2-112*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-7*y**6-21*y**4*z**2-21*y**2*z**4-7*z**6)/64",
            "[3*sqrt(442)/128,0,-sqrt(26)/128,0,-sqrt(130)/64,0,3*sqrt(42)/64,0,-7*sqrt(11)/64,0,7*sqrt(11)/64,0,-3*sqrt(42)/64,0,sqrt(130)/64,0,sqrt(26)/128,0,-3*sqrt(442)/128]",
        ),
        "Qh(10,A,17,)": (
            "9*sqrt(78)*C1/256+69*C3/128-sqrt(5)*C5/128-43*sqrt(17)*C7/256+3*sqrt(969)*C9/256",
            "sqrt(4290)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(3*x**4-96*x**2*y**2+6*x**2*z**2+224*y**4-96*y**2*z**2+3*z**4)/256",
            "[0,-3*sqrt(1938)/512,0,43*sqrt(34)/512,0,sqrt(10)/256,0,-69*sqrt(2)/256,0,-9*sqrt(39)/256,0,9*sqrt(39)/256,0,69*sqrt(2)/256,0,-sqrt(10)/256,0,-43*sqrt(34)/512,0,3*sqrt(1938)/512,0]",
        ),
        "Qh(11,A,17,)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,A,18,)": (
            "-7*sqrt(22)*S1/64-3*sqrt(21)*S3/32-sqrt(65)*S5/32+sqrt(13)*S7/64+3*sqrt(221)*S9/64",
            "3*sqrt(110)*y*(x-z)*(x+z)*(7*x**6-70*x**4*y**2+21*x**4*z**2+112*x**2*y**4-140*x**2*y**2*z**2+21*x**2*z**4-32*y**6+112*y**4*z**2-70*y**2*z**4+7*z**6)/64",
            "[3*sqrt(442)*I/128,0,sqrt(26)*I/128,0,-sqrt(130)*I/64,0,-3*sqrt(42)*I/64,0,-7*sqrt(11)*I/64,0,-7*sqrt(11)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(130)*I/64,0,sqrt(26)*I/128,0,3*sqrt(442)*I/128]",
        ),
        "Qh(10,A,18,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(11,A,18,)": (
            "-15*sqrt(221)*C1/512-3*sqrt(2926)*C11/1024-sqrt(595)*C3/512+53*sqrt(102)*C5/1024-105*sqrt(10)*C7/1024-61*sqrt(114)*C9/1024",
            "sqrt(14586)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)*(224*x**4-160*x**2*y**2-160*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/512",
            "[3*sqrt(1463)/1024,0,61*sqrt(57)/1024,0,105*sqrt(5)/1024,0,-53*sqrt(51)/1024,0,sqrt(1190)/1024,0,15*sqrt(442)/1024,0,-15*sqrt(442)/1024,0,-sqrt(1190)/1024,0,53*sqrt(51)/1024,0,-105*sqrt(5)/1024,0,-61*sqrt(57)/1024,0,-3*sqrt(1463)/1024]",
        ),
        "Qh(9,A,19,)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A,19,)": (
            "7*sqrt(3)*S1/128-7*sqrt(26)*S3/128+5*sqrt(130)*S5/128-7*sqrt(442)*S7/256+sqrt(25194)*S9/256",
            "sqrt(165)*y*z*(384*x**8-1792*x**6*y**2-1792*x**6*z**2+1680*x**4*y**4+3360*x**4*y**2*z**2+1680*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+7*y**8+28*y**6*z**2+42*y**4*z**4+28*y**2*z**6+7*z**8)/128",
            "[0,sqrt(12597)*I/256,0,-7*sqrt(221)*I/256,0,5*sqrt(65)*I/128,0,-7*sqrt(13)*I/128,0,7*sqrt(6)*I/256,0,7*sqrt(6)*I/256,0,-7*sqrt(13)*I/128,0,5*sqrt(65)*I/128,0,-7*sqrt(221)*I/256,0,sqrt(12597)*I/256,0]",
        ),
        "Qh(11,A,19,)": (
            "15*sqrt(221)*S1/512-3*sqrt(2926)*S11/1024-sqrt(595)*S3/512-53*sqrt(102)*S5/1024-105*sqrt(10)*S7/1024+61*sqrt(114)*S9/1024",
            "-sqrt(14586)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(15*x**4-160*x**2*y**2+30*x**2*z**2+224*y**4-160*y**2*z**2+15*z**4)/512",
            "[-3*sqrt(1463)*I/1024,0,61*sqrt(57)*I/1024,0,-105*sqrt(5)*I/1024,0,-53*sqrt(51)*I/1024,0,-sqrt(1190)*I/1024,0,15*sqrt(442)*I/1024,0,15*sqrt(442)*I/1024,0,-sqrt(1190)*I/1024,0,-53*sqrt(51)*I/1024,0,-105*sqrt(5)*I/1024,0,61*sqrt(57)*I/1024,0,-3*sqrt(1463)*I/1024]",
        ),
        "Qh(10,A,20,)": (
            "7*sqrt(3)*C1/128+7*sqrt(26)*C3/128+5*sqrt(130)*C5/128+7*sqrt(442)*C7/256+sqrt(25194)*C9/256",
            "sqrt(165)*x*z*(7*x**8-336*x**6*y**2+28*x**6*z**2+1680*x**4*y**4-1008*x**4*y**2*z**2+42*x**4*z**4-1792*x**2*y**6+3360*x**2*y**4*z**2-1008*x**2*y**2*z**4+28*x**2*z**6+384*y**8-1792*y**6*z**2+1680*y**4*z**4-336*y**2*z**6+7*z**8)/128",
            "[0,-sqrt(12597)/256,0,-7*sqrt(221)/256,0,-5*sqrt(65)/128,0,-7*sqrt(13)/128,0,-7*sqrt(6)/256,0,7*sqrt(6)/256,0,7*sqrt(13)/128,0,5*sqrt(65)/128,0,7*sqrt(221)/256,0,sqrt(12597)/256,0]",
        ),
        "Qh(11,A,20,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(10,A,21,)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A,21,)": (
            "-21*sqrt(130)*C1/512-sqrt(124355)*C11/512+57*sqrt(14)*C3/512-41*sqrt(15)*C5/512+17*sqrt(17)*C7/512+sqrt(4845)*C9/512",
            "sqrt(2145)*x*(y-z)*(y+z)*(128*x**8-768*x**6*y**2-768*x**6*z**2+1008*x**4*y**4+2016*x**4*y**2*z**2+1008*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+21*y**8+84*y**6*z**2+126*y**4*z**4+84*y**2*z**6+21*z**8)/256",
            "[sqrt(248710)/1024,0,-sqrt(9690)/1024,0,-17*sqrt(34)/1024,0,41*sqrt(30)/1024,0,-57*sqrt(7)/512,0,21*sqrt(65)/512,0,-21*sqrt(65)/512,0,57*sqrt(7)/512,0,-41*sqrt(30)/1024,0,17*sqrt(34)/1024,0,sqrt(9690)/1024,0,-sqrt(248710)/1024]",
        ),
        "Qh(11,A,22,)": (
            "21*sqrt(130)*S1/512-sqrt(124355)*S11/512+57*sqrt(14)*S3/512+41*sqrt(15)*S5/512+17*sqrt(17)*S7/512-sqrt(4845)*S9/512",
            "-sqrt(2145)*y*(x-z)*(x+z)*(21*x**8-336*x**6*y**2+84*x**6*z**2+1008*x**4*y**4-1008*x**4*y**2*z**2+126*x**4*z**4-768*x**2*y**6+2016*x**2*y**4*z**2-1008*x**2*y**2*z**4+84*x**2*z**6+128*y**8-768*y**6*z**2+1008*y**4*z**4-336*y**2*z**6+21*z**8)/256",
            "[-sqrt(248710)*I/1024,0,-sqrt(9690)*I/1024,0,17*sqrt(34)*I/1024,0,41*sqrt(30)*I/1024,0,57*sqrt(7)*I/512,0,21*sqrt(65)*I/512,0,21*sqrt(65)*I/512,0,57*sqrt(7)*I/512,0,41*sqrt(30)*I/1024,0,17*sqrt(34)*I/1024,0,-sqrt(9690)*I/1024,0,-sqrt(248710)*I/1024]",
        ),
        "Qh(11,A,23,)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
    },
    "Ci": {
        "Qh(0,Ag,,)": ("C0", "1", "[1]"),
        "Qh(2,Ag,1,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(4,Ag,1,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Qh(6,Ag,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Qh(8,Ag,1,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Qh(10,Ag,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Qh(2,Ag,2,)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(4,Ag,2,)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "-sqrt(15)*(x**4-12*x**2*y**2+6*x**2*z**2+y**4+6*y**2*z**2-2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Qh(6,Ag,2,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Qh(8,Ag,2,)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Qh(10,Ag,2,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Qh(2,Ag,3,)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(4,Ag,3,)": ("-C2", "sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Qh(6,Ag,3,)": (
            "sqrt(14)*C0/4+sqrt(2)*C4/4",
            "-sqrt(14)*(x**6-15*x**4*z**2+15*x**2*z**4+y**6-15*y**4*z**2+15*y**2*z**4-2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Qh(8,Ag,3,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(10,Ag,3,)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "-sqrt(420189)*(22*x**10+45*x**8*y**2-1035*x**8*z**2-105*x**6*y**4-630*x**6*y**2*z**2+4935*x**6*z**4-105*x**4*y**6+3150*x**4*y**4*z**2-1575*x**4*y**2*z**4-4830*x**4*z**6+45*x**2*y**8-630*x**2*y**6*z**2-1575*x**2*y**4*z**4+1260*x**2*y**2*z**6+990*x**2*z**8+22*y**10-1035*y**8*z**2+4935*y**6*z**4-4830*y**4*z**6+990*y**2*z**8-44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Qh(2,Ag,4,)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Qh(4,Ag,4,)": (
            "-sqrt(14)*S1/4-sqrt(2)*S3/4",
            "sqrt(35)*y*z*(y-z)*(y+z)/2",
            "[0,-I/4,0,-sqrt(7)*I/4,0,-sqrt(7)*I/4,0,-I/4,0]",
        ),
        "Qh(6,Ag,4,)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x-y)*(x+y)*(x**4-9*x**2*y**2-5*x**2*z**2+y**4-5*y**2*z**2+5*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Qh(8,Ag,4,)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Qh(10,Ag,4,)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(x-y)*(x+y)*(22*x**8-653*x**6*y**2-315*x**6*z**2+2602*x**4*y**4-945*x**4*y**2*z**2+1575*x**4*z**4-653*x**2*y**6-945*x**2*y**4*z**2+3150*x**2*y**2*z**4-1680*x**2*z**6+22*y**8-315*y**6*z**2+1575*y**4*z**4-1680*y**2*z**6+360*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Qh(2,Ag,5,)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Qh(4,Ag,5,)": ("sqrt(14)*C1/4-sqrt(2)*C3/4", "-sqrt(35)*x*z*(x-z)*(x+z)/2", "[0,1/4,0,-sqrt(7)/4,0,sqrt(7)/4,0,-1/4,0]"),
        "Qh(6,Ag,5,)": (
            "sqrt(3)*S1/4-sqrt(30)*S3/8-sqrt(22)*S5/8",
            "3*sqrt(7)*y*z*(y-z)*(y+z)*(10*x**2-y**2-z**2)/4",
            "[0,-sqrt(11)*I/8,0,-sqrt(15)*I/8,0,sqrt(6)*I/8,0,sqrt(6)*I/8,0,-sqrt(15)*I/8,0,-sqrt(11)*I/8,0]",
        ),
        "Qh(8,Ag,5,)": (
            "C2",
            "-3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(10,Ag,5,)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "-sqrt(3213210)*(3*x**10-96*x**8*y**2-39*x**8*z**2+224*x**6*y**4+1344*x**6*y**2*z**2-42*x**6*z**4+224*x**4*y**6-6720*x**4*y**4*z**2+3360*x**4*y**2*z**4-182*x**4*z**6-96*x**2*y**8+1344*x**2*y**6*z**2+3360*x**2*y**4*z**4-2688*x**2*y**2*z**6+135*x**2*z**8+3*y**10-39*y**8*z**2-42*y**6*z**4-182*y**4*z**6+135*y**2*z**8-6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Qh(4,Ag,6,)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(6,Ag,6,)": (
            "-sqrt(3)*C1/4-sqrt(30)*C3/8+sqrt(22)*C5/8",
            "3*sqrt(7)*x*z*(x-z)*(x+z)*(x**2-10*y**2+z**2)/4",
            "[0,-sqrt(11)/8,0,sqrt(15)/8,0,sqrt(6)/8,0,-sqrt(6)/8,0,-sqrt(15)/8,0,sqrt(11)/8,0]",
        ),
        "Qh(8,Ag,6,)": (
            "-sqrt(715)*S1/32-sqrt(273)*S3/32-sqrt(35)*S5/32-S7/32",
            "3*sqrt(715)*y*z*(y-z)*(y+z)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[0,-sqrt(2)*I/64,0,-sqrt(70)*I/64,0,-sqrt(546)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(546)*I/64,0,-sqrt(70)*I/64,0,-sqrt(2)*I/64,0]",
        ),
        "Qh(10,Ag,6,)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(x-y)*(x+y)*(9*x**8-165*x**6*y**2-231*x**6*z**2-25*x**4*y**4+3801*x**4*y**2*z**2+406*x**4*z**4-165*x**2*y**6+3801*x**2*y**4*z**2-9674*x**2*y**2*z**4+266*x**2*z**6+9*y**8-231*y**6*z**2+406*y**4*z**4+266*y**2*z**6-57*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Qh(4,Ag,7,)": (
            "-sqrt(2)*S1/4+sqrt(14)*S3/4",
            "sqrt(5)*y*z*(6*x**2-y**2-z**2)/2",
            "[0,sqrt(7)*I/4,0,-I/4,0,-I/4,0,sqrt(7)*I/4,0]",
        ),
        "Qh(6,Ag,7,)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(8,Ag,7,)": (
            "sqrt(715)*C1/32-sqrt(273)*C3/32+sqrt(35)*C5/32-C7/32",
            "-3*sqrt(715)*x*z*(x-z)*(x+z)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/16",
            "[0,sqrt(2)/64,0,-sqrt(70)/64,0,sqrt(546)/64,0,-sqrt(1430)/64,0,sqrt(1430)/64,0,-sqrt(546)/64,0,sqrt(70)/64,0,-sqrt(2)/64,0]",
        ),
        "Qh(10,Ag,7,)": (
            "sqrt(221)*S1/32-sqrt(102)*S3/32-sqrt(510)*S5/32-11*sqrt(6)*S7/64-sqrt(38)*S9/64",
            "sqrt(12155)*y*z*(y-z)*(y+z)*(18*x**2-y**2-z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/32",
            "[0,-sqrt(19)*I/64,0,-11*sqrt(3)*I/64,0,-sqrt(255)*I/32,0,-sqrt(51)*I/32,0,sqrt(442)*I/64,0,sqrt(442)*I/64,0,-sqrt(51)*I/32,0,-sqrt(255)*I/32,0,-11*sqrt(3)*I/64,0,-sqrt(19)*I/64,0]",
        ),
        "Qh(4,Ag,8,)": (
            "-sqrt(2)*C1/4-sqrt(14)*C3/4",
            "-sqrt(5)*x*z*(x**2-6*y**2+z**2)/2",
            "[0,sqrt(7)/4,0,1/4,0,-1/4,0,-sqrt(7)/4,0]",
        ),
        "Qh(6,Ag,8,)": (
            "3*sqrt(22)*S1/16+sqrt(55)*S3/16+sqrt(3)*S5/16",
            "sqrt(462)*y*z*(y**2-3*z**2)*(3*y**2-z**2)/16",
            "[0,sqrt(6)*I/32,0,sqrt(110)*I/32,0,3*sqrt(11)*I/16,0,3*sqrt(11)*I/16,0,sqrt(110)*I/32,0,sqrt(6)*I/32,0]",
        ),
        "Qh(8,Ag,8,)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(10,Ag,8,)": (
            "-sqrt(221)*C1/32-sqrt(102)*C3/32+sqrt(510)*C5/32-11*sqrt(6)*C7/64+sqrt(38)*C9/64",
            "sqrt(12155)*x*z*(x-z)*(x+z)*(x**2-18*y**2+z**2)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/32",
            "[0,-sqrt(19)/64,0,11*sqrt(3)/64,0,-sqrt(255)/32,0,sqrt(51)/32,0,sqrt(442)/64,0,-sqrt(442)/64,0,-sqrt(51)/32,0,sqrt(255)/32,0,-11*sqrt(3)/64,0,sqrt(19)/64,0]",
        ),
        "Qh(4,Ag,9,)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(6,Ag,9,)": (
            "3*sqrt(22)*C1/16-sqrt(55)*C3/16+sqrt(3)*C5/16",
            "sqrt(462)*x*z*(x**2-3*z**2)*(3*x**2-z**2)/16",
            "[0,-sqrt(6)/32,0,sqrt(110)/32,0,-3*sqrt(11)/16,0,3*sqrt(11)/16,0,-sqrt(110)/32,0,sqrt(6)/32,0]",
        ),
        "Qh(8,Ag,9,)": (
            "-sqrt(77)*S1/32+5*sqrt(15)*S3/32-3*sqrt(13)*S5/32-sqrt(455)*S7/32",
            "3*sqrt(77)*y*z*(y-z)*(y+z)*(40*x**4-24*x**2*y**2-24*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,-sqrt(910)*I/64,0,-3*sqrt(26)*I/64,0,5*sqrt(30)*I/64,0,-sqrt(154)*I/64,0,-sqrt(154)*I/64,0,5*sqrt(30)*I/64,0,-3*sqrt(26)*I/64,0,-sqrt(910)*I/64,0]",
        ),
        "Qh(10,Ag,9,)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(6,Ag,10,)": (
            "S6",
            "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(8,Ag,10,)": (
            "sqrt(77)*C1/32+5*sqrt(15)*C3/32+3*sqrt(13)*C5/32-sqrt(455)*C7/32",
            "-3*sqrt(77)*x*z*(x-z)*(x+z)*(x**4-24*x**2*y**2+2*x**2*z**2+40*y**4-24*y**2*z**2+z**4)/16",
            "[0,sqrt(910)/64,0,-3*sqrt(26)/64,0,-5*sqrt(30)/64,0,-sqrt(154)/64,0,sqrt(154)/64,0,5*sqrt(30)/64,0,3*sqrt(26)/64,0,-sqrt(910)/64,0]",
        ),
        "Qh(10,Ag,10,)": (
            "sqrt(39)*S1/32-11*sqrt(2)*S3/32+5*sqrt(10)*S5/32-sqrt(34)*S7/64-sqrt(1938)*S9/64",
            "sqrt(2145)*y*z*(y-z)*(y+z)*(112*x**6-168*x**4*y**2-168*x**4*z**2+42*x**2*y**4+84*x**2*y**2*z**2+42*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,-sqrt(969)*I/64,0,-sqrt(17)*I/64,0,5*sqrt(5)*I/32,0,-11*I/32,0,sqrt(78)*I/64,0,sqrt(78)*I/64,0,-11*I/32,0,5*sqrt(5)*I/32,0,-sqrt(17)*I/64,0,-sqrt(969)*I/64,0]",
        ),
        "Qh(6,Ag,11,)": (
            "sqrt(10)*S1/16-9*S3/16+sqrt(165)*S5/16",
            "sqrt(210)*y*z*(16*x**4-16*x**2*y**2-16*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,sqrt(330)*I/32,0,-9*sqrt(2)*I/32,0,sqrt(5)*I/16,0,sqrt(5)*I/16,0,-9*sqrt(2)*I/32,0,sqrt(330)*I/32,0]",
        ),
        "Qh(8,Ag,11,)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,Ag,11,)": (
            "-sqrt(39)*C1/32-11*sqrt(2)*C3/32-5*sqrt(10)*C5/32-sqrt(34)*C7/64+sqrt(1938)*C9/64",
            "sqrt(2145)*x*z*(x-z)*(x+z)*(x**6-42*x**4*y**2+3*x**4*z**2+168*x**2*y**4-84*x**2*y**2*z**2+3*x**2*z**4-112*y**6+168*y**4*z**2-42*y**2*z**4+z**6)/32",
            "[0,-sqrt(969)/64,0,sqrt(17)/64,0,5*sqrt(5)/32,0,11/32,0,sqrt(78)/64,0,-sqrt(78)/64,0,-11/32,0,-5*sqrt(5)/32,0,-sqrt(17)/64,0,sqrt(969)/64,0]",
        ),
        "Qh(6,Ag,12,)": (
            "sqrt(10)*C1/16+9*C3/16+sqrt(165)*C5/16",
            "sqrt(210)*x*z*(x**4-16*x**2*y**2+2*x**2*z**2+16*y**4-16*y**2*z**2+z**4)/16",
            "[0,-sqrt(330)/32,0,-9*sqrt(2)/32,0,-sqrt(5)/16,0,sqrt(5)/16,0,9*sqrt(2)/32,0,sqrt(330)/32,0]",
        ),
        "Qh(8,Ag,12,)": (
            "-sqrt(858)*S1/64+sqrt(910)*S3/64+7*sqrt(42)*S5/64+3*sqrt(30)*S7/64",
            "sqrt(858)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(14*x**2-y**2-z**2)/32",
            "[0,3*sqrt(15)*I/64,0,7*sqrt(21)*I/64,0,sqrt(455)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(455)*I/64,0,7*sqrt(21)*I/64,0,3*sqrt(15)*I/64,0]",
        ),
        "Qh(10,Ag,12,)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(6,Ag,13,)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(8,Ag,13,)": (
            "-sqrt(858)*C1/64-sqrt(910)*C3/64+7*sqrt(42)*C5/64-3*sqrt(30)*C7/64",
            "-sqrt(858)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(x**2-14*y**2+z**2)/32",
            "[0,3*sqrt(15)/64,0,-7*sqrt(21)/64,0,sqrt(455)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-sqrt(455)/64,0,7*sqrt(21)/64,0,-3*sqrt(15)/64,0]",
        ),
        "Qh(10,Ag,13,)": (
            "sqrt(41990)*S1/256+sqrt(4845)*S3/128+sqrt(969)*S5/128+sqrt(285)*S7/256+sqrt(5)*S9/256",
            "sqrt(92378)*y*z*(y**4-10*y**2*z**2+5*z**4)*(5*y**4-10*y**2*z**2+z**4)/256",
            "[0,sqrt(10)*I/512,0,sqrt(570)*I/512,0,sqrt(1938)*I/256,0,sqrt(9690)*I/256,0,sqrt(20995)*I/256,0,sqrt(20995)*I/256,0,sqrt(9690)*I/256,0,sqrt(1938)*I/256,0,sqrt(570)*I/512,0,sqrt(10)*I/512,0]",
        ),
        "Qh(8,Ag,14,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(10,Ag,14,)": (
            "sqrt(41990)*C1/256-sqrt(4845)*C3/128+sqrt(969)*C5/128-sqrt(285)*C7/256+sqrt(5)*C9/256",
            "sqrt(92378)*x*z*(x**4-10*x**2*z**2+5*z**4)*(5*x**4-10*x**2*z**2+z**4)/256",
            "[0,-sqrt(10)/512,0,sqrt(570)/512,0,-sqrt(1938)/256,0,sqrt(9690)/256,0,-sqrt(20995)/256,0,sqrt(20995)/256,0,-sqrt(9690)/256,0,sqrt(1938)/256,0,-sqrt(570)/512,0,sqrt(10)/512,0]",
        ),
        "Qh(8,Ag,15,)": (
            "-sqrt(70)*S1/64+3*sqrt(66)*S3/64-sqrt(1430)*S5/64+sqrt(2002)*S7/64",
            "3*sqrt(70)*y*z*(32*x**6-80*x**4*y**2-80*x**4*z**2+30*x**2*y**4+60*x**2*y**2*z**2+30*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,sqrt(1001)*I/64,0,-sqrt(715)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(35)*I/64,0,-sqrt(35)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(715)*I/64,0,sqrt(1001)*I/64,0]",
        ),
        "Qh(10,Ag,15,)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(8,Ag,16,)": (
            "-sqrt(70)*C1/64-3*sqrt(66)*C3/64-sqrt(1430)*C5/64-sqrt(2002)*C7/64",
            "-3*sqrt(70)*x*z*(x**6-30*x**4*y**2+3*x**4*z**2+80*x**2*y**4-60*x**2*y**2*z**2+3*x**2*z**4-32*y**6+80*y**4*z**2-30*y**2*z**4+z**6)/32",
            "[0,sqrt(1001)/64,0,sqrt(715)/64,0,3*sqrt(33)/64,0,sqrt(35)/64,0,-sqrt(35)/64,0,-3*sqrt(33)/64,0,-sqrt(715)/64,0,-sqrt(1001)/64,0]",
        ),
        "Qh(10,Ag,16,)": (
            "9*sqrt(78)*S1/256-69*S3/128-sqrt(5)*S5/128+43*sqrt(17)*S7/256+3*sqrt(969)*S9/256",
            "sqrt(4290)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(224*x**4-96*x**2*y**2-96*x**2*z**2+3*y**4+6*y**2*z**2+3*z**4)/256",
            "[0,3*sqrt(1938)*I/512,0,43*sqrt(34)*I/512,0,-sqrt(10)*I/256,0,-69*sqrt(2)*I/256,0,9*sqrt(39)*I/256,0,9*sqrt(39)*I/256,0,-69*sqrt(2)*I/256,0,-sqrt(10)*I/256,0,43*sqrt(34)*I/512,0,3*sqrt(1938)*I/512,0]",
        ),
        "Qh(8,Ag,17,)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(10,Ag,17,)": (
            "9*sqrt(78)*C1/256+69*C3/128-sqrt(5)*C5/128-43*sqrt(17)*C7/256+3*sqrt(969)*C9/256",
            "sqrt(4290)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(3*x**4-96*x**2*y**2+6*x**2*z**2+224*y**4-96*y**2*z**2+3*z**4)/256",
            "[0,-3*sqrt(1938)/512,0,43*sqrt(34)/512,0,sqrt(10)/256,0,-69*sqrt(2)/256,0,-9*sqrt(39)/256,0,9*sqrt(39)/256,0,69*sqrt(2)/256,0,-sqrt(10)/256,0,-43*sqrt(34)/512,0,3*sqrt(1938)/512,0]",
        ),
        "Qh(10,Ag,18,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,Ag,19,)": (
            "7*sqrt(3)*S1/128-7*sqrt(26)*S3/128+5*sqrt(130)*S5/128-7*sqrt(442)*S7/256+sqrt(25194)*S9/256",
            "sqrt(165)*y*z*(384*x**8-1792*x**6*y**2-1792*x**6*z**2+1680*x**4*y**4+3360*x**4*y**2*z**2+1680*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+7*y**8+28*y**6*z**2+42*y**4*z**4+28*y**2*z**6+7*z**8)/128",
            "[0,sqrt(12597)*I/256,0,-7*sqrt(221)*I/256,0,5*sqrt(65)*I/128,0,-7*sqrt(13)*I/128,0,7*sqrt(6)*I/256,0,7*sqrt(6)*I/256,0,-7*sqrt(13)*I/128,0,5*sqrt(65)*I/128,0,-7*sqrt(221)*I/256,0,sqrt(12597)*I/256,0]",
        ),
        "Qh(10,Ag,20,)": (
            "7*sqrt(3)*C1/128+7*sqrt(26)*C3/128+5*sqrt(130)*C5/128+7*sqrt(442)*C7/256+sqrt(25194)*C9/256",
            "sqrt(165)*x*z*(7*x**8-336*x**6*y**2+28*x**6*z**2+1680*x**4*y**4-1008*x**4*y**2*z**2+42*x**4*z**4-1792*x**2*y**6+3360*x**2*y**4*z**2-1008*x**2*y**2*z**4+28*x**2*z**6+384*y**8-1792*y**6*z**2+1680*y**4*z**4-336*y**2*z**6+7*z**8)/128",
            "[0,-sqrt(12597)/256,0,-7*sqrt(221)/256,0,-5*sqrt(65)/128,0,-7*sqrt(13)/128,0,-7*sqrt(6)/256,0,7*sqrt(6)/256,0,7*sqrt(13)/128,0,5*sqrt(65)/128,0,7*sqrt(221)/256,0,sqrt(12597)/256,0]",
        ),
        "Qh(10,Ag,21,)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(1,Au,1,)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(3,Au,1,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(5,Au,1,)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(7,Au,1,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Qh(9,Au,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Qh(11,Au,1,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Qh(1,Au,2,)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(3,Au,2,)": (
            "-sqrt(6)*C1/4+sqrt(10)*C3/4",
            "x*(2*x**2-3*y**2-3*z**2)/2",
            "[-sqrt(5)/4,0,sqrt(3)/4,0,-sqrt(3)/4,0,sqrt(5)/4]",
        ),
        "Qh(5,Au,2,)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(7,Au,2,)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(9,Au,2,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Qh(11,Au,2,)": (
            "S8",
            "-sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(1,Au,3,)": ("C0", "z", "[0,1,0]"),
        "Qh(3,Au,3,)": (
            "-sqrt(6)*S1/4-sqrt(10)*S3/4",
            "-y*(3*x**2-2*y**2+3*z**2)/2",
            "[-sqrt(5)*I/4,0,-sqrt(3)*I/4,0,-sqrt(3)*I/4,0,-sqrt(5)*I/4]",
        ),
        "Qh(5,Au,3,)": (
            "sqrt(15)*C1/8-sqrt(70)*C3/16+3*sqrt(14)*C5/16",
            "x*(8*x**4-40*x**2*y**2-40*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/8",
            "[-3*sqrt(7)/16,0,sqrt(35)/16,0,-sqrt(30)/16,0,sqrt(30)/16,0,-sqrt(35)/16,0,3*sqrt(7)/16]",
        ),
        "Qh(7,Au,3,)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "-sqrt(77)*x*y*z*(3*x**4-20*x**2*y**2+10*x**2*z**2+3*y**4+10*y**2*z**2-6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Qh(9,Au,3,)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(x-y)*(x+y)*(3*x**4-11*x**2*y**2-7*x**2*z**2+3*y**4-7*y**2*z**2+7*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Qh(11,Au,3,)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "-sqrt(230945)*x*y*z*(x**8-6*x**6*y**2-6*x**6*z**2+42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2-84*x**2*y**2*z**4+12*x**2*z**6+y**8-6*y**6*z**2+12*y**2*z**6-2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Qh(3,Au,4,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(5,Au,4,)": (
            "sqrt(15)*S1/8+sqrt(70)*S3/16+3*sqrt(14)*S5/16",
            "y*(15*x**4-40*x**2*y**2+30*x**2*z**2+8*y**4-40*y**2*z**2+15*z**4)/8",
            "[3*sqrt(7)*I/16,0,sqrt(35)*I/16,0,sqrt(30)*I/16,0,sqrt(30)*I/16,0,sqrt(35)*I/16,0,3*sqrt(7)*I/16]",
        ),
        "Qh(7,Au,4,)": (
            "-5*sqrt(7)*C1/32+3*sqrt(21)*C3/32-sqrt(231)*C5/32+sqrt(429)*C7/32",
            "x*(16*x**6-168*x**4*y**2-168*x**4*z**2+210*x**2*y**4+420*x**2*y**2*z**2+210*x**2*z**4-35*y**6-105*y**4*z**2-105*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)/64,0,sqrt(462)/64,0,-3*sqrt(42)/64,0,5*sqrt(14)/64,0,-5*sqrt(14)/64,0,3*sqrt(42)/64,0,-sqrt(462)/64,0,sqrt(858)/64]",
        ),
        "Qh(9,Au,4,)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Qh(11,Au,4,)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(3,Au,5,)": (
            "-sqrt(10)*C1/4-sqrt(6)*C3/4",
            "sqrt(15)*x*(y-z)*(y+z)/2",
            "[sqrt(3)/4,0,sqrt(5)/4,0,-sqrt(5)/4,0,-sqrt(3)/4]",
        ),
        "Qh(5,Au,5,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(7,Au,5,)": (
            "-5*sqrt(7)*S1/32-3*sqrt(21)*S3/32-sqrt(231)*S5/32-sqrt(429)*S7/32",
            "-y*(35*x**6-210*x**4*y**2+105*x**4*z**2+168*x**2*y**4-420*x**2*y**2*z**2+105*x**2*z**4-16*y**6+168*y**4*z**2-210*y**2*z**4+35*z**6)/16",
            "[-sqrt(858)*I/64,0,-sqrt(462)*I/64,0,-3*sqrt(42)*I/64,0,-5*sqrt(14)*I/64,0,-5*sqrt(14)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(462)*I/64,0,-sqrt(858)*I/64]",
        ),
        "Qh(9,Au,5,)": (
            "21*sqrt(5)*C1/128-sqrt(2310)*C3/128+3*sqrt(286)*C5/128-3*sqrt(1430)*C7/256+sqrt(24310)*C9/256",
            "x*(128*x**8-2304*x**6*y**2-2304*x**6*z**2+6048*x**4*y**4+12096*x**4*y**2*z**2+6048*x**4*z**4-3360*x**2*y**6-10080*x**2*y**4*z**2-10080*x**2*y**2*z**4-3360*x**2*z**6+315*y**8+1260*y**6*z**2+1890*y**4*z**4+1260*y**2*z**6+315*z**8)/128",
            "[-sqrt(12155)/256,0,3*sqrt(715)/256,0,-3*sqrt(143)/128,0,sqrt(1155)/128,0,-21*sqrt(10)/256,0,21*sqrt(10)/256,0,-sqrt(1155)/128,0,3*sqrt(143)/128,0,-3*sqrt(715)/256,0,sqrt(12155)/256]",
        ),
        "Qh(11,Au,5,)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "-sqrt(3003)*x*y*z*(5*x**8-150*x**6*y**2+90*x**6*z**2+336*x**4*y**4-70*x**4*y**2*z**2-168*x**4*z**4-150*x**2*y**6-70*x**2*y**4*z**2+140*x**2*y**2*z**4+60*x**2*z**6+5*y**8+90*y**6*z**2-168*y**4*z**4+60*y**2*z**6-10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Qh(3,Au,6,)": (
            "sqrt(10)*S1/4-sqrt(6)*S3/4",
            "-sqrt(15)*y*(x-z)*(x+z)/2",
            "[-sqrt(3)*I/4,0,sqrt(5)*I/4,0,sqrt(5)*I/4,0,-sqrt(3)*I/4]",
        ),
        "Qh(5,Au,6,)": (
            "sqrt(21)*C1/8+9*sqrt(2)*C3/16+sqrt(10)*C5/16",
            "3*sqrt(35)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/8",
            "[-sqrt(5)/16,0,-9/16,0,-sqrt(42)/16,0,sqrt(42)/16,0,9/16,0,sqrt(5)/16]",
        ),
        "Qh(7,Au,6,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Au,6,)": (
            "21*sqrt(5)*S1/128+sqrt(2310)*S3/128+3*sqrt(286)*S5/128+3*sqrt(1430)*S7/256+sqrt(24310)*S9/256",
            "y*(315*x**8-3360*x**6*y**2+1260*x**6*z**2+6048*x**4*y**4-10080*x**4*y**2*z**2+1890*x**4*z**4-2304*x**2*y**6+12096*x**2*y**4*z**2-10080*x**2*y**2*z**4+1260*x**2*z**6+128*y**8-2304*y**6*z**2+6048*y**4*z**4-3360*y**2*z**6+315*z**8)/128",
            "[sqrt(12155)*I/256,0,3*sqrt(715)*I/256,0,3*sqrt(143)*I/128,0,sqrt(1155)*I/128,0,21*sqrt(10)*I/256,0,21*sqrt(10)*I/256,0,sqrt(1155)*I/128,0,3*sqrt(143)*I/128,0,3*sqrt(715)*I/256,0,sqrt(12155)*I/256]",
        ),
        "Qh(11,Au,6,)": (
            "-21*sqrt(66)*C1/512+sqrt(88179)*C11/512+sqrt(30030)*C3/512-15*sqrt(143)*C5/512+sqrt(36465)*C7/512-sqrt(46189)*C9/512",
            "x*(256*x**10-7040*x**8*y**2-7040*x**8*z**2+31680*x**6*y**4+63360*x**6*y**2*z**2+31680*x**6*z**4-36960*x**4*y**6-110880*x**4*y**4*z**2-110880*x**4*y**2*z**4-36960*x**4*z**6+11550*x**2*y**8+46200*x**2*y**6*z**2+69300*x**2*y**4*z**4+46200*x**2*y**2*z**6+11550*x**2*z**8-693*y**10-3465*y**8*z**2-6930*y**6*z**4-6930*y**4*z**6-3465*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)/1024,0,sqrt(92378)/1024,0,-sqrt(72930)/1024,0,15*sqrt(286)/1024,0,-sqrt(15015)/512,0,21*sqrt(33)/512,0,-21*sqrt(33)/512,0,sqrt(15015)/512,0,-15*sqrt(286)/1024,0,sqrt(72930)/1024,0,-sqrt(92378)/1024,0,sqrt(176358)/1024]",
        ),
        "Qh(3,Au,7,)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(5,Au,7,)": (
            "sqrt(21)*S1/8-9*sqrt(2)*S3/16+sqrt(10)*S5/16",
            "3*sqrt(35)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/8",
            "[sqrt(5)*I/16,0,-9*I/16,0,sqrt(42)*I/16,0,sqrt(42)*I/16,0,-9*I/16,0,sqrt(5)*I/16]",
        ),
        "Qh(7,Au,7,)": (
            "-3*sqrt(33)*C1/32-sqrt(11)*C3/32+25*C5/32+sqrt(91)*C7/32",
            "sqrt(231)*x*(10*x**2-3*y**2-3*z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[-sqrt(182)/64,0,-25*sqrt(2)/64,0,sqrt(22)/64,0,3*sqrt(66)/64,0,-3*sqrt(66)/64,0,-sqrt(22)/64,0,25*sqrt(2)/64,0,sqrt(182)/64]",
        ),
        "Qh(9,Au,7,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Au,7,)": (
            "-21*sqrt(66)*S1/512-sqrt(88179)*S11/512-sqrt(30030)*S3/512-15*sqrt(143)*S5/512-sqrt(36465)*S7/512-sqrt(46189)*S9/512",
            "-y*(693*x**10-11550*x**8*y**2+3465*x**8*z**2+36960*x**6*y**4-46200*x**6*y**2*z**2+6930*x**6*z**4-31680*x**4*y**6+110880*x**4*y**4*z**2-69300*x**4*y**2*z**4+6930*x**4*z**6+7040*x**2*y**8-63360*x**2*y**6*z**2+110880*x**2*y**4*z**4-46200*x**2*y**2*z**6+3465*x**2*z**8-256*y**10+7040*y**8*z**2-31680*y**6*z**4+36960*y**4*z**6-11550*y**2*z**8+693*z**10)/256",
            "[-sqrt(176358)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(72930)*I/1024,0,-15*sqrt(286)*I/1024,0,-sqrt(15015)*I/512,0,-21*sqrt(33)*I/512,0,-21*sqrt(33)*I/512,0,-sqrt(15015)*I/512,0,-15*sqrt(286)*I/1024,0,-sqrt(72930)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(176358)*I/1024]",
        ),
        "Qh(5,Au,8,)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(7,Au,8,)": (
            "-3*sqrt(33)*S1/32+sqrt(11)*S3/32+25*S5/32-sqrt(91)*S7/32",
            "-sqrt(231)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(3*x**2-10*y**2+3*z**2)/16",
            "[-sqrt(182)*I/64,0,25*sqrt(2)*I/64,0,sqrt(22)*I/64,0,-3*sqrt(66)*I/64,0,-3*sqrt(66)*I/64,0,sqrt(22)*I/64,0,25*sqrt(2)*I/64,0,-sqrt(182)*I/64]",
        ),
        "Qh(9,Au,8,)": (
            "sqrt(2431)*C1/128+sqrt(9282)*C3/128+5*sqrt(170)*C5/128+7*sqrt(34)*C7/256+3*sqrt(2)*C9/256",
            "3*sqrt(12155)*x*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/128",
            "[-3/256,0,-7*sqrt(17)/256,0,-5*sqrt(85)/128,0,-sqrt(4641)/128,0,-sqrt(4862)/256,0,sqrt(4862)/256,0,sqrt(4641)/128,0,5*sqrt(85)/128,0,7*sqrt(17)/256,0,3/256]",
        ),
        "Qh(11,Au,8,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(5,Au,9,)": (
            "sqrt(7)*C1/4-sqrt(6)*C3/8-sqrt(30)*C5/8",
            "sqrt(105)*x*(y-z)*(y+z)*(2*x**2-y**2-z**2)/4",
            "[sqrt(15)/8,0,sqrt(3)/8,0,-sqrt(14)/8,0,sqrt(14)/8,0,-sqrt(3)/8,0,-sqrt(15)/8]",
        ),
        "Qh(7,Au,9,)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,Au,9,)": (
            "sqrt(2431)*S1/128-sqrt(9282)*S3/128+5*sqrt(170)*S5/128-7*sqrt(34)*S7/256+3*sqrt(2)*S9/256",
            "3*sqrt(12155)*y*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/128",
            "[3*I/256,0,-7*sqrt(17)*I/256,0,5*sqrt(85)*I/128,0,-sqrt(4641)*I/128,0,sqrt(4862)*I/256,0,sqrt(4862)*I/256,0,-sqrt(4641)*I/128,0,5*sqrt(85)*I/128,0,-7*sqrt(17)*I/256,0,3*I/256]",
        ),
        "Qh(11,Au,9,)": (
            "-sqrt(41990)*C1/512+sqrt(385)*C11/512-3*sqrt(4522)*C3/512+3*sqrt(4845)*C5/512+77*sqrt(19)*C7/512+39*sqrt(15)*C9/512",
            "sqrt(692835)*x*(6*x**2-y**2-z**2)*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/256",
            "[-sqrt(770)/1024,0,-39*sqrt(30)/1024,0,-77*sqrt(38)/1024,0,-3*sqrt(9690)/1024,0,3*sqrt(2261)/512,0,sqrt(20995)/512,0,-sqrt(20995)/512,0,-3*sqrt(2261)/512,0,3*sqrt(9690)/1024,0,77*sqrt(38)/1024,0,39*sqrt(30)/1024,0,sqrt(770)/1024]",
        ),
        "Qh(5,Au,10,)": (
            "-sqrt(7)*S1/4-sqrt(6)*S3/8+sqrt(30)*S5/8",
            "sqrt(105)*y*(x-z)*(x+z)*(x**2-2*y**2+z**2)/4",
            "[sqrt(15)*I/8,0,-sqrt(3)*I/8,0,-sqrt(14)*I/8,0,-sqrt(14)*I/8,0,-sqrt(3)*I/8,0,sqrt(15)*I/8]",
        ),
        "Qh(7,Au,10,)": (
            "-sqrt(858)*C1/64-3*sqrt(286)*C3/64-5*sqrt(26)*C5/64-sqrt(14)*C7/64",
            "sqrt(6006)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/32",
            "[sqrt(7)/64,0,5*sqrt(13)/64,0,3*sqrt(143)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-3*sqrt(143)/64,0,-5*sqrt(13)/64,0,-sqrt(7)/64]",
        ),
        "Qh(9,Au,10,)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(11,Au,10,)": (
            "-sqrt(41990)*S1/512-sqrt(385)*S11/512+3*sqrt(4522)*S3/512+3*sqrt(4845)*S5/512-77*sqrt(19)*S7/512+39*sqrt(15)*S9/512",
            "-sqrt(692835)*y*(x**2-6*y**2+z**2)*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/256",
            "[-sqrt(770)*I/1024,0,39*sqrt(30)*I/1024,0,-77*sqrt(38)*I/1024,0,3*sqrt(9690)*I/1024,0,3*sqrt(2261)*I/512,0,-sqrt(20995)*I/512,0,-sqrt(20995)*I/512,0,3*sqrt(2261)*I/512,0,3*sqrt(9690)*I/1024,0,-77*sqrt(38)*I/1024,0,39*sqrt(30)*I/1024,0,-sqrt(770)*I/1024]",
        ),
        "Qh(5,Au,11,)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(7,Au,11,)": (
            "sqrt(858)*S1/64-3*sqrt(286)*S3/64+5*sqrt(26)*S5/64-sqrt(14)*S7/64",
            "-sqrt(6006)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)/32",
            "[-sqrt(7)*I/64,0,5*sqrt(13)*I/64,0,-3*sqrt(143)*I/64,0,sqrt(429)*I/64,0,sqrt(429)*I/64,0,-3*sqrt(143)*I/64,0,5*sqrt(13)*I/64,0,-sqrt(7)*I/64]",
        ),
        "Qh(9,Au,11,)": (
            "sqrt(1001)*C1/64-sqrt(78)*C3/64-3*sqrt(70)*C5/64+23*sqrt(14)*C7/128+3*sqrt(238)*C9/128",
            "3*sqrt(5005)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(8*x**4-8*x**2*y**2-8*x**2*z**2+y**4+2*y**2*z**2+z**4)/64",
            "[-3*sqrt(119)/128,0,-23*sqrt(7)/128,0,3*sqrt(35)/64,0,sqrt(39)/64,0,-sqrt(2002)/128,0,sqrt(2002)/128,0,-sqrt(39)/64,0,-3*sqrt(35)/64,0,23*sqrt(7)/128,0,3*sqrt(119)/128]",
        ),
        "Qh(11,Au,11,)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(7,Au,12,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,Au,12,)": (
            "sqrt(1001)*S1/64+sqrt(78)*S3/64-3*sqrt(70)*S5/64-23*sqrt(14)*S7/128+3*sqrt(238)*S9/128",
            "3*sqrt(5005)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(x**4-8*x**2*y**2+2*x**2*z**2+8*y**4-8*y**2*z**2+z**4)/64",
            "[3*sqrt(119)*I/128,0,-23*sqrt(7)*I/128,0,-3*sqrt(35)*I/64,0,sqrt(39)*I/64,0,sqrt(2002)*I/128,0,sqrt(2002)*I/128,0,sqrt(39)*I/64,0,-3*sqrt(35)*I/64,0,-23*sqrt(7)*I/128,0,3*sqrt(119)*I/128]",
        ),
        "Qh(11,Au,12,)": (
            "-5*sqrt(546)*C1/256+sqrt(10659)*C11/256+11*sqrt(30)*C3/256+13*sqrt(7)*C5/256-3*sqrt(1785)*C7/256+3*sqrt(2261)*C9/256",
            "3*sqrt(1001)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(80*x**6-168*x**4*y**2-168*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-5*y**6-15*y**4*z**2-15*y**2*z**4-5*z**6)/128",
            "[-sqrt(21318)/512,0,-3*sqrt(4522)/512,0,3*sqrt(3570)/512,0,-13*sqrt(14)/512,0,-11*sqrt(15)/256,0,5*sqrt(273)/256,0,-5*sqrt(273)/256,0,11*sqrt(15)/256,0,13*sqrt(14)/512,0,-3*sqrt(3570)/512,0,3*sqrt(4522)/512,0,sqrt(21318)/512]",
        ),
        "Qh(7,Au,13,)": (
            "-15*sqrt(6)*C1/64+19*sqrt(2)*C3/64-sqrt(22)*C5/64-sqrt(2002)*C7/64",
            "sqrt(42)*x*(y-z)*(y+z)*(48*x**4-80*x**2*y**2-80*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/32",
            "[sqrt(1001)/64,0,sqrt(11)/64,0,-19/64,0,15*sqrt(3)/64,0,-15*sqrt(3)/64,0,19/64,0,-sqrt(11)/64,0,-sqrt(1001)/64]",
        ),
        "Qh(9,Au,13,)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,Au,13,)": (
            "-5*sqrt(546)*S1/256-sqrt(10659)*S11/256-11*sqrt(30)*S3/256+13*sqrt(7)*S5/256+3*sqrt(1785)*S7/256+3*sqrt(2261)*S9/256",
            "-3*sqrt(1001)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(5*x**6-70*x**4*y**2+15*x**4*z**2+168*x**2*y**4-140*x**2*y**2*z**2+15*x**2*z**4-80*y**6+168*y**4*z**2-70*y**2*z**4+5*z**6)/128",
            "[-sqrt(21318)*I/512,0,3*sqrt(4522)*I/512,0,3*sqrt(3570)*I/512,0,13*sqrt(14)*I/512,0,-11*sqrt(15)*I/256,0,-5*sqrt(273)*I/256,0,-5*sqrt(273)*I/256,0,-11*sqrt(15)*I/256,0,13*sqrt(14)*I/512,0,3*sqrt(3570)*I/512,0,3*sqrt(4522)*I/512,0,-sqrt(21318)*I/512]",
        ),
        "Qh(7,Au,14,)": (
            "15*sqrt(6)*S1/64+19*sqrt(2)*S3/64+sqrt(22)*S5/64-sqrt(2002)*S7/64",
            "-sqrt(42)*y*(x-z)*(x+z)*(15*x**4-80*x**2*y**2+30*x**2*z**2+48*y**4-80*y**2*z**2+15*z**4)/32",
            "[-sqrt(1001)*I/64,0,sqrt(11)*I/64,0,19*I/64,0,15*sqrt(3)*I/64,0,15*sqrt(3)*I/64,0,19*I/64,0,sqrt(11)*I/64,0,-sqrt(1001)*I/64]",
        ),
        "Qh(9,Au,14,)": (
            "sqrt(858)*C1/64+sqrt(91)*C3/32-5*sqrt(15)*C5/32-21*sqrt(3)*C7/64-sqrt(51)*C9/64",
            "sqrt(4290)*x*(y-z)*(y+z)*(14*x**2-3*y**2-3*z**2)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/64",
            "[sqrt(102)/128,0,21*sqrt(6)/128,0,5*sqrt(30)/64,0,-sqrt(182)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(182)/64,0,-5*sqrt(30)/64,0,-21*sqrt(6)/128,0,-sqrt(102)/128]",
        ),
        "Qh(11,Au,14,)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(7,Au,15,)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(9,Au,15,)": (
            "-sqrt(858)*S1/64+sqrt(91)*S3/32+5*sqrt(15)*S5/32-21*sqrt(3)*S7/64+sqrt(51)*S9/64",
            "sqrt(4290)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(3*x**2-14*y**2+3*z**2)/64",
            "[sqrt(102)*I/128,0,-21*sqrt(6)*I/128,0,5*sqrt(30)*I/64,0,sqrt(182)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(182)*I/64,0,5*sqrt(30)*I/64,0,-21*sqrt(6)*I/128,0,sqrt(102)*I/128]",
        ),
        "Qh(11,Au,15,)": (
            "-sqrt(29393)*C1/512-sqrt(22)*C11/1024-9*sqrt(1615)*C3/512-5*sqrt(13566)*C5/1024-7*sqrt(1330)*C7/1024-9*sqrt(42)*C9/1024",
            "sqrt(1939938)*x*(y-z)*(y+z)*(y**4-4*y**3*z-14*y**2*z**2-4*y*z**3+z**4)*(y**4+4*y**3*z-14*y**2*z**2+4*y*z**3+z**4)/512",
            "[sqrt(11)/1024,0,9*sqrt(21)/1024,0,7*sqrt(665)/1024,0,5*sqrt(6783)/1024,0,9*sqrt(3230)/1024,0,sqrt(58786)/1024,0,-sqrt(58786)/1024,0,-9*sqrt(3230)/1024,0,-5*sqrt(6783)/1024,0,-7*sqrt(665)/1024,0,-9*sqrt(21)/1024,0,-sqrt(11)/1024]",
        ),
        "Qh(9,Au,16,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(11,Au,16,)": (
            "sqrt(29393)*S1/512-sqrt(22)*S11/1024-9*sqrt(1615)*S3/512+5*sqrt(13566)*S5/1024-7*sqrt(1330)*S7/1024+9*sqrt(42)*S9/1024",
            "-sqrt(1939938)*y*(x-z)*(x+z)*(x**4-4*x**3*z-14*x**2*z**2-4*x*z**3+z**4)*(x**4+4*x**3*z-14*x**2*z**2+4*x*z**3+z**4)/512",
            "[-sqrt(11)*I/1024,0,9*sqrt(21)*I/1024,0,-7*sqrt(665)*I/1024,0,5*sqrt(6783)*I/1024,0,-9*sqrt(3230)*I/1024,0,sqrt(58786)*I/1024,0,sqrt(58786)*I/1024,0,-9*sqrt(3230)*I/1024,0,5*sqrt(6783)*I/1024,0,-7*sqrt(665)*I/1024,0,9*sqrt(21)*I/1024,0,-sqrt(11)*I/1024]",
        ),
        "Qh(9,Au,17,)": (
            "7*sqrt(22)*C1/64-3*sqrt(21)*C3/32+sqrt(65)*C5/32+sqrt(13)*C7/64-3*sqrt(221)*C9/64",
            "3*sqrt(110)*x*(y-z)*(y+z)*(32*x**6-112*x**4*y**2-112*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-7*y**6-21*y**4*z**2-21*y**2*z**4-7*z**6)/64",
            "[3*sqrt(442)/128,0,-sqrt(26)/128,0,-sqrt(130)/64,0,3*sqrt(42)/64,0,-7*sqrt(11)/64,0,7*sqrt(11)/64,0,-3*sqrt(42)/64,0,sqrt(130)/64,0,sqrt(26)/128,0,-3*sqrt(442)/128]",
        ),
        "Qh(11,Au,17,)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,Au,18,)": (
            "-7*sqrt(22)*S1/64-3*sqrt(21)*S3/32-sqrt(65)*S5/32+sqrt(13)*S7/64+3*sqrt(221)*S9/64",
            "3*sqrt(110)*y*(x-z)*(x+z)*(7*x**6-70*x**4*y**2+21*x**4*z**2+112*x**2*y**4-140*x**2*y**2*z**2+21*x**2*z**4-32*y**6+112*y**4*z**2-70*y**2*z**4+7*z**6)/64",
            "[3*sqrt(442)*I/128,0,sqrt(26)*I/128,0,-sqrt(130)*I/64,0,-3*sqrt(42)*I/64,0,-7*sqrt(11)*I/64,0,-7*sqrt(11)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(130)*I/64,0,sqrt(26)*I/128,0,3*sqrt(442)*I/128]",
        ),
        "Qh(11,Au,18,)": (
            "-15*sqrt(221)*C1/512-3*sqrt(2926)*C11/1024-sqrt(595)*C3/512+53*sqrt(102)*C5/1024-105*sqrt(10)*C7/1024-61*sqrt(114)*C9/1024",
            "sqrt(14586)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)*(224*x**4-160*x**2*y**2-160*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/512",
            "[3*sqrt(1463)/1024,0,61*sqrt(57)/1024,0,105*sqrt(5)/1024,0,-53*sqrt(51)/1024,0,sqrt(1190)/1024,0,15*sqrt(442)/1024,0,-15*sqrt(442)/1024,0,-sqrt(1190)/1024,0,53*sqrt(51)/1024,0,-105*sqrt(5)/1024,0,-61*sqrt(57)/1024,0,-3*sqrt(1463)/1024]",
        ),
        "Qh(9,Au,19,)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Au,19,)": (
            "15*sqrt(221)*S1/512-3*sqrt(2926)*S11/1024-sqrt(595)*S3/512-53*sqrt(102)*S5/1024-105*sqrt(10)*S7/1024+61*sqrt(114)*S9/1024",
            "-sqrt(14586)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(15*x**4-160*x**2*y**2+30*x**2*z**2+224*y**4-160*y**2*z**2+15*z**4)/512",
            "[-3*sqrt(1463)*I/1024,0,61*sqrt(57)*I/1024,0,-105*sqrt(5)*I/1024,0,-53*sqrt(51)*I/1024,0,-sqrt(1190)*I/1024,0,15*sqrt(442)*I/1024,0,15*sqrt(442)*I/1024,0,-sqrt(1190)*I/1024,0,-53*sqrt(51)*I/1024,0,-105*sqrt(5)*I/1024,0,61*sqrt(57)*I/1024,0,-3*sqrt(1463)*I/1024]",
        ),
        "Qh(11,Au,20,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,Au,21,)": (
            "-21*sqrt(130)*C1/512-sqrt(124355)*C11/512+57*sqrt(14)*C3/512-41*sqrt(15)*C5/512+17*sqrt(17)*C7/512+sqrt(4845)*C9/512",
            "sqrt(2145)*x*(y-z)*(y+z)*(128*x**8-768*x**6*y**2-768*x**6*z**2+1008*x**4*y**4+2016*x**4*y**2*z**2+1008*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+21*y**8+84*y**6*z**2+126*y**4*z**4+84*y**2*z**6+21*z**8)/256",
            "[sqrt(248710)/1024,0,-sqrt(9690)/1024,0,-17*sqrt(34)/1024,0,41*sqrt(30)/1024,0,-57*sqrt(7)/512,0,21*sqrt(65)/512,0,-21*sqrt(65)/512,0,57*sqrt(7)/512,0,-41*sqrt(30)/1024,0,17*sqrt(34)/1024,0,sqrt(9690)/1024,0,-sqrt(248710)/1024]",
        ),
        "Qh(11,Au,22,)": (
            "21*sqrt(130)*S1/512-sqrt(124355)*S11/512+57*sqrt(14)*S3/512+41*sqrt(15)*S5/512+17*sqrt(17)*S7/512-sqrt(4845)*S9/512",
            "-sqrt(2145)*y*(x-z)*(x+z)*(21*x**8-336*x**6*y**2+84*x**6*z**2+1008*x**4*y**4-1008*x**4*y**2*z**2+126*x**4*z**4-768*x**2*y**6+2016*x**2*y**4*z**2-1008*x**2*y**2*z**4+84*x**2*z**6+128*y**8-768*y**6*z**2+1008*y**4*z**4-336*y**2*z**6+21*z**8)/256",
            "[-sqrt(248710)*I/1024,0,-sqrt(9690)*I/1024,0,17*sqrt(34)*I/1024,0,41*sqrt(30)*I/1024,0,57*sqrt(7)*I/512,0,21*sqrt(65)*I/512,0,21*sqrt(65)*I/512,0,57*sqrt(7)*I/512,0,41*sqrt(30)*I/1024,0,17*sqrt(34)*I/1024,0,-sqrt(9690)*I/1024,0,-sqrt(248710)*I/1024]",
        ),
        "Qh(11,Au,23,)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
    },
    "C2": {
        "Qh(0,A,,)": ("C0", "1", "[1]"),
        "Qh(1,A,,)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(2,A,1,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(3,A,1,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(4,A,1,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Qh(5,A,1,)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(6,A,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Qh(7,A,1,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Qh(8,A,1,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Qh(9,A,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Qh(10,A,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Qh(11,A,1,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Qh(2,A,2,)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(3,A,2,)": (
            "-sqrt(6)*S1/4-sqrt(10)*S3/4",
            "-y*(3*x**2-2*y**2+3*z**2)/2",
            "[-sqrt(5)*I/4,0,-sqrt(3)*I/4,0,-sqrt(3)*I/4,0,-sqrt(5)*I/4]",
        ),
        "Qh(4,A,2,)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "-sqrt(15)*(x**4-12*x**2*y**2+6*x**2*z**2+y**4+6*y**2*z**2-2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Qh(5,A,2,)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(6,A,2,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Qh(7,A,2,)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(8,A,2,)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Qh(9,A,2,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Qh(10,A,2,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Qh(11,A,2,)": (
            "S8",
            "-sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(2,A,3,)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Qh(3,A,3,)": (
            "sqrt(10)*S1/4-sqrt(6)*S3/4",
            "-sqrt(15)*y*(x-z)*(x+z)/2",
            "[-sqrt(3)*I/4,0,sqrt(5)*I/4,0,sqrt(5)*I/4,0,-sqrt(3)*I/4]",
        ),
        "Qh(4,A,3,)": ("-C2", "sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Qh(5,A,3,)": (
            "sqrt(15)*S1/8+sqrt(70)*S3/16+3*sqrt(14)*S5/16",
            "y*(15*x**4-40*x**2*y**2+30*x**2*z**2+8*y**4-40*y**2*z**2+15*z**4)/8",
            "[3*sqrt(7)*I/16,0,sqrt(35)*I/16,0,sqrt(30)*I/16,0,sqrt(30)*I/16,0,sqrt(35)*I/16,0,3*sqrt(7)*I/16]",
        ),
        "Qh(6,A,3,)": (
            "sqrt(14)*C0/4+sqrt(2)*C4/4",
            "-sqrt(14)*(x**6-15*x**4*z**2+15*x**2*z**4+y**6-15*y**4*z**2+15*y**2*z**4-2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Qh(7,A,3,)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "-sqrt(77)*x*y*z*(3*x**4-20*x**2*y**2+10*x**2*z**2+3*y**4+10*y**2*z**2-6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Qh(8,A,3,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,A,3,)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(x-y)*(x+y)*(3*x**4-11*x**2*y**2-7*x**2*z**2+3*y**4-7*y**2*z**2+7*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Qh(10,A,3,)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "-sqrt(420189)*(22*x**10+45*x**8*y**2-1035*x**8*z**2-105*x**6*y**4-630*x**6*y**2*z**2+4935*x**6*z**4-105*x**4*y**6+3150*x**4*y**4*z**2-1575*x**4*y**2*z**4-4830*x**4*z**6+45*x**2*y**8-630*x**2*y**6*z**2-1575*x**2*y**4*z**4+1260*x**2*y**2*z**6+990*x**2*z**8+22*y**10-1035*y**8*z**2+4935*y**6*z**4-4830*y**4*z**6+990*y**2*z**8-44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Qh(11,A,3,)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "-sqrt(230945)*x*y*z*(x**8-6*x**6*y**2-6*x**6*z**2+42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2-84*x**2*y**2*z**4+12*x**2*z**6+y**8-6*y**6*z**2+12*y**2*z**6-2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Qh(4,A,4,)": ("sqrt(14)*C1/4-sqrt(2)*C3/4", "-sqrt(35)*x*z*(x-z)*(x+z)/2", "[0,1/4,0,-sqrt(7)/4,0,sqrt(7)/4,0,-1/4,0]"),
        "Qh(5,A,4,)": (
            "sqrt(21)*S1/8-9*sqrt(2)*S3/16+sqrt(10)*S5/16",
            "3*sqrt(35)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/8",
            "[sqrt(5)*I/16,0,-9*I/16,0,sqrt(42)*I/16,0,sqrt(42)*I/16,0,-9*I/16,0,sqrt(5)*I/16]",
        ),
        "Qh(6,A,4,)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x-y)*(x+y)*(x**4-9*x**2*y**2-5*x**2*z**2+y**4-5*y**2*z**2+5*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Qh(7,A,4,)": (
            "-5*sqrt(7)*S1/32-3*sqrt(21)*S3/32-sqrt(231)*S5/32-sqrt(429)*S7/32",
            "-y*(35*x**6-210*x**4*y**2+105*x**4*z**2+168*x**2*y**4-420*x**2*y**2*z**2+105*x**2*z**4-16*y**6+168*y**4*z**2-210*y**2*z**4+35*z**6)/16",
            "[-sqrt(858)*I/64,0,-sqrt(462)*I/64,0,-3*sqrt(42)*I/64,0,-5*sqrt(14)*I/64,0,-5*sqrt(14)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(462)*I/64,0,-sqrt(858)*I/64]",
        ),
        "Qh(8,A,4,)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Qh(9,A,4,)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Qh(10,A,4,)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(x-y)*(x+y)*(22*x**8-653*x**6*y**2-315*x**6*z**2+2602*x**4*y**4-945*x**4*y**2*z**2+1575*x**4*z**4-653*x**2*y**6-945*x**2*y**4*z**2+3150*x**2*y**2*z**4-1680*x**2*z**6+22*y**8-315*y**6*z**2+1575*y**4*z**4-1680*y**2*z**6+360*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Qh(11,A,4,)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(4,A,5,)": (
            "-sqrt(2)*C1/4-sqrt(14)*C3/4",
            "-sqrt(5)*x*z*(x**2-6*y**2+z**2)/2",
            "[0,sqrt(7)/4,0,1/4,0,-1/4,0,-sqrt(7)/4,0]",
        ),
        "Qh(5,A,5,)": (
            "-sqrt(7)*S1/4-sqrt(6)*S3/8+sqrt(30)*S5/8",
            "sqrt(105)*y*(x-z)*(x+z)*(x**2-2*y**2+z**2)/4",
            "[sqrt(15)*I/8,0,-sqrt(3)*I/8,0,-sqrt(14)*I/8,0,-sqrt(14)*I/8,0,-sqrt(3)*I/8,0,sqrt(15)*I/8]",
        ),
        "Qh(6,A,5,)": (
            "-sqrt(3)*C1/4-sqrt(30)*C3/8+sqrt(22)*C5/8",
            "3*sqrt(7)*x*z*(x-z)*(x+z)*(x**2-10*y**2+z**2)/4",
            "[0,-sqrt(11)/8,0,sqrt(15)/8,0,sqrt(6)/8,0,-sqrt(6)/8,0,-sqrt(15)/8,0,sqrt(11)/8,0]",
        ),
        "Qh(7,A,5,)": (
            "-3*sqrt(33)*S1/32+sqrt(11)*S3/32+25*S5/32-sqrt(91)*S7/32",
            "-sqrt(231)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(3*x**2-10*y**2+3*z**2)/16",
            "[-sqrt(182)*I/64,0,25*sqrt(2)*I/64,0,sqrt(22)*I/64,0,-3*sqrt(66)*I/64,0,-3*sqrt(66)*I/64,0,sqrt(22)*I/64,0,25*sqrt(2)*I/64,0,-sqrt(182)*I/64]",
        ),
        "Qh(8,A,5,)": (
            "C2",
            "-3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(9,A,5,)": (
            "21*sqrt(5)*S1/128+sqrt(2310)*S3/128+3*sqrt(286)*S5/128+3*sqrt(1430)*S7/256+sqrt(24310)*S9/256",
            "y*(315*x**8-3360*x**6*y**2+1260*x**6*z**2+6048*x**4*y**4-10080*x**4*y**2*z**2+1890*x**4*z**4-2304*x**2*y**6+12096*x**2*y**4*z**2-10080*x**2*y**2*z**4+1260*x**2*z**6+128*y**8-2304*y**6*z**2+6048*y**4*z**4-3360*y**2*z**6+315*z**8)/128",
            "[sqrt(12155)*I/256,0,3*sqrt(715)*I/256,0,3*sqrt(143)*I/128,0,sqrt(1155)*I/128,0,21*sqrt(10)*I/256,0,21*sqrt(10)*I/256,0,sqrt(1155)*I/128,0,3*sqrt(143)*I/128,0,3*sqrt(715)*I/256,0,sqrt(12155)*I/256]",
        ),
        "Qh(10,A,5,)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "-sqrt(3213210)*(3*x**10-96*x**8*y**2-39*x**8*z**2+224*x**6*y**4+1344*x**6*y**2*z**2-42*x**6*z**4+224*x**4*y**6-6720*x**4*y**4*z**2+3360*x**4*y**2*z**4-182*x**4*z**6-96*x**2*y**8+1344*x**2*y**6*z**2+3360*x**2*y**4*z**4-2688*x**2*y**2*z**6+135*x**2*z**8+3*y**10-39*y**8*z**2-42*y**6*z**4-182*y**4*z**6+135*y**2*z**8-6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Qh(11,A,5,)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "-sqrt(3003)*x*y*z*(5*x**8-150*x**6*y**2+90*x**6*z**2+336*x**4*y**4-70*x**4*y**2*z**2-168*x**4*z**4-150*x**2*y**6-70*x**2*y**4*z**2+140*x**2*y**2*z**4+60*x**2*z**6+5*y**8+90*y**6*z**2-168*y**4*z**4+60*y**2*z**6-10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Qh(6,A,6,)": (
            "3*sqrt(22)*C1/16-sqrt(55)*C3/16+sqrt(3)*C5/16",
            "sqrt(462)*x*z*(x**2-3*z**2)*(3*x**2-z**2)/16",
            "[0,-sqrt(6)/32,0,sqrt(110)/32,0,-3*sqrt(11)/16,0,3*sqrt(11)/16,0,-sqrt(110)/32,0,sqrt(6)/32,0]",
        ),
        "Qh(7,A,6,)": (
            "sqrt(858)*S1/64-3*sqrt(286)*S3/64+5*sqrt(26)*S5/64-sqrt(14)*S7/64",
            "-sqrt(6006)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)/32",
            "[-sqrt(7)*I/64,0,5*sqrt(13)*I/64,0,-3*sqrt(143)*I/64,0,sqrt(429)*I/64,0,sqrt(429)*I/64,0,-3*sqrt(143)*I/64,0,5*sqrt(13)*I/64,0,-sqrt(7)*I/64]",
        ),
        "Qh(8,A,6,)": (
            "sqrt(715)*C1/32-sqrt(273)*C3/32+sqrt(35)*C5/32-C7/32",
            "-3*sqrt(715)*x*z*(x-z)*(x+z)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/16",
            "[0,sqrt(2)/64,0,-sqrt(70)/64,0,sqrt(546)/64,0,-sqrt(1430)/64,0,sqrt(1430)/64,0,-sqrt(546)/64,0,sqrt(70)/64,0,-sqrt(2)/64,0]",
        ),
        "Qh(9,A,6,)": (
            "sqrt(2431)*S1/128-sqrt(9282)*S3/128+5*sqrt(170)*S5/128-7*sqrt(34)*S7/256+3*sqrt(2)*S9/256",
            "3*sqrt(12155)*y*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/128",
            "[3*I/256,0,-7*sqrt(17)*I/256,0,5*sqrt(85)*I/128,0,-sqrt(4641)*I/128,0,sqrt(4862)*I/256,0,sqrt(4862)*I/256,0,-sqrt(4641)*I/128,0,5*sqrt(85)*I/128,0,-7*sqrt(17)*I/256,0,3*I/256]",
        ),
        "Qh(10,A,6,)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(x-y)*(x+y)*(9*x**8-165*x**6*y**2-231*x**6*z**2-25*x**4*y**4+3801*x**4*y**2*z**2+406*x**4*z**4-165*x**2*y**6+3801*x**2*y**4*z**2-9674*x**2*y**2*z**4+266*x**2*z**6+9*y**8-231*y**6*z**2+406*y**4*z**4+266*y**2*z**6-57*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Qh(11,A,6,)": (
            "-21*sqrt(66)*S1/512-sqrt(88179)*S11/512-sqrt(30030)*S3/512-15*sqrt(143)*S5/512-sqrt(36465)*S7/512-sqrt(46189)*S9/512",
            "-y*(693*x**10-11550*x**8*y**2+3465*x**8*z**2+36960*x**6*y**4-46200*x**6*y**2*z**2+6930*x**6*z**4-31680*x**4*y**6+110880*x**4*y**4*z**2-69300*x**4*y**2*z**4+6930*x**4*z**6+7040*x**2*y**8-63360*x**2*y**6*z**2+110880*x**2*y**4*z**4-46200*x**2*y**2*z**6+3465*x**2*z**8-256*y**10+7040*y**8*z**2-31680*y**6*z**4+36960*y**4*z**6-11550*y**2*z**8+693*z**10)/256",
            "[-sqrt(176358)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(72930)*I/1024,0,-15*sqrt(286)*I/1024,0,-sqrt(15015)*I/512,0,-21*sqrt(33)*I/512,0,-21*sqrt(33)*I/512,0,-sqrt(15015)*I/512,0,-15*sqrt(286)*I/1024,0,-sqrt(72930)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(176358)*I/1024]",
        ),
        "Qh(6,A,7,)": (
            "sqrt(10)*C1/16+9*C3/16+sqrt(165)*C5/16",
            "sqrt(210)*x*z*(x**4-16*x**2*y**2+2*x**2*z**2+16*y**4-16*y**2*z**2+z**4)/16",
            "[0,-sqrt(330)/32,0,-9*sqrt(2)/32,0,-sqrt(5)/16,0,sqrt(5)/16,0,9*sqrt(2)/32,0,sqrt(330)/32,0]",
        ),
        "Qh(7,A,7,)": (
            "15*sqrt(6)*S1/64+19*sqrt(2)*S3/64+sqrt(22)*S5/64-sqrt(2002)*S7/64",
            "-sqrt(42)*y*(x-z)*(x+z)*(15*x**4-80*x**2*y**2+30*x**2*z**2+48*y**4-80*y**2*z**2+15*z**4)/32",
            "[-sqrt(1001)*I/64,0,sqrt(11)*I/64,0,19*I/64,0,15*sqrt(3)*I/64,0,15*sqrt(3)*I/64,0,19*I/64,0,sqrt(11)*I/64,0,-sqrt(1001)*I/64]",
        ),
        "Qh(8,A,7,)": (
            "sqrt(77)*C1/32+5*sqrt(15)*C3/32+3*sqrt(13)*C5/32-sqrt(455)*C7/32",
            "-3*sqrt(77)*x*z*(x-z)*(x+z)*(x**4-24*x**2*y**2+2*x**2*z**2+40*y**4-24*y**2*z**2+z**4)/16",
            "[0,sqrt(910)/64,0,-3*sqrt(26)/64,0,-5*sqrt(30)/64,0,-sqrt(154)/64,0,sqrt(154)/64,0,5*sqrt(30)/64,0,3*sqrt(26)/64,0,-sqrt(910)/64,0]",
        ),
        "Qh(9,A,7,)": (
            "sqrt(1001)*S1/64+sqrt(78)*S3/64-3*sqrt(70)*S5/64-23*sqrt(14)*S7/128+3*sqrt(238)*S9/128",
            "3*sqrt(5005)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(x**4-8*x**2*y**2+2*x**2*z**2+8*y**4-8*y**2*z**2+z**4)/64",
            "[3*sqrt(119)*I/128,0,-23*sqrt(7)*I/128,0,-3*sqrt(35)*I/64,0,sqrt(39)*I/64,0,sqrt(2002)*I/128,0,sqrt(2002)*I/128,0,sqrt(39)*I/64,0,-3*sqrt(35)*I/64,0,-23*sqrt(7)*I/128,0,3*sqrt(119)*I/128]",
        ),
        "Qh(10,A,7,)": (
            "-sqrt(221)*C1/32-sqrt(102)*C3/32+sqrt(510)*C5/32-11*sqrt(6)*C7/64+sqrt(38)*C9/64",
            "sqrt(12155)*x*z*(x-z)*(x+z)*(x**2-18*y**2+z**2)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/32",
            "[0,-sqrt(19)/64,0,11*sqrt(3)/64,0,-sqrt(255)/32,0,sqrt(51)/32,0,sqrt(442)/64,0,-sqrt(442)/64,0,-sqrt(51)/32,0,sqrt(255)/32,0,-11*sqrt(3)/64,0,sqrt(19)/64,0]",
        ),
        "Qh(11,A,7,)": (
            "-sqrt(41990)*S1/512-sqrt(385)*S11/512+3*sqrt(4522)*S3/512+3*sqrt(4845)*S5/512-77*sqrt(19)*S7/512+39*sqrt(15)*S9/512",
            "-sqrt(692835)*y*(x**2-6*y**2+z**2)*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/256",
            "[-sqrt(770)*I/1024,0,39*sqrt(30)*I/1024,0,-77*sqrt(38)*I/1024,0,3*sqrt(9690)*I/1024,0,3*sqrt(2261)*I/512,0,-sqrt(20995)*I/512,0,-sqrt(20995)*I/512,0,3*sqrt(2261)*I/512,0,3*sqrt(9690)*I/1024,0,-77*sqrt(38)*I/1024,0,39*sqrt(30)*I/1024,0,-sqrt(770)*I/1024]",
        ),
        "Qh(8,A,8,)": (
            "-sqrt(858)*C1/64-sqrt(910)*C3/64+7*sqrt(42)*C5/64-3*sqrt(30)*C7/64",
            "-sqrt(858)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(x**2-14*y**2+z**2)/32",
            "[0,3*sqrt(15)/64,0,-7*sqrt(21)/64,0,sqrt(455)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-sqrt(455)/64,0,7*sqrt(21)/64,0,-3*sqrt(15)/64,0]",
        ),
        "Qh(9,A,8,)": (
            "-sqrt(858)*S1/64+sqrt(91)*S3/32+5*sqrt(15)*S5/32-21*sqrt(3)*S7/64+sqrt(51)*S9/64",
            "sqrt(4290)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(3*x**2-14*y**2+3*z**2)/64",
            "[sqrt(102)*I/128,0,-21*sqrt(6)*I/128,0,5*sqrt(30)*I/64,0,sqrt(182)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(182)*I/64,0,5*sqrt(30)*I/64,0,-21*sqrt(6)*I/128,0,sqrt(102)*I/128]",
        ),
        "Qh(10,A,8,)": (
            "-sqrt(39)*C1/32-11*sqrt(2)*C3/32-5*sqrt(10)*C5/32-sqrt(34)*C7/64+sqrt(1938)*C9/64",
            "sqrt(2145)*x*z*(x-z)*(x+z)*(x**6-42*x**4*y**2+3*x**4*z**2+168*x**2*y**4-84*x**2*y**2*z**2+3*x**2*z**4-112*y**6+168*y**4*z**2-42*y**2*z**4+z**6)/32",
            "[0,-sqrt(969)/64,0,sqrt(17)/64,0,5*sqrt(5)/32,0,11/32,0,sqrt(78)/64,0,-sqrt(78)/64,0,-11/32,0,-5*sqrt(5)/32,0,-sqrt(17)/64,0,sqrt(969)/64,0]",
        ),
        "Qh(11,A,8,)": (
            "-5*sqrt(546)*S1/256-sqrt(10659)*S11/256-11*sqrt(30)*S3/256+13*sqrt(7)*S5/256+3*sqrt(1785)*S7/256+3*sqrt(2261)*S9/256",
            "-3*sqrt(1001)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(5*x**6-70*x**4*y**2+15*x**4*z**2+168*x**2*y**4-140*x**2*y**2*z**2+15*x**2*z**4-80*y**6+168*y**4*z**2-70*y**2*z**4+5*z**6)/128",
            "[-sqrt(21318)*I/512,0,3*sqrt(4522)*I/512,0,3*sqrt(3570)*I/512,0,13*sqrt(14)*I/512,0,-11*sqrt(15)*I/256,0,-5*sqrt(273)*I/256,0,-5*sqrt(273)*I/256,0,-11*sqrt(15)*I/256,0,13*sqrt(14)*I/512,0,3*sqrt(3570)*I/512,0,3*sqrt(4522)*I/512,0,-sqrt(21318)*I/512]",
        ),
        "Qh(8,A,9,)": (
            "-sqrt(70)*C1/64-3*sqrt(66)*C3/64-sqrt(1430)*C5/64-sqrt(2002)*C7/64",
            "-3*sqrt(70)*x*z*(x**6-30*x**4*y**2+3*x**4*z**2+80*x**2*y**4-60*x**2*y**2*z**2+3*x**2*z**4-32*y**6+80*y**4*z**2-30*y**2*z**4+z**6)/32",
            "[0,sqrt(1001)/64,0,sqrt(715)/64,0,3*sqrt(33)/64,0,sqrt(35)/64,0,-sqrt(35)/64,0,-3*sqrt(33)/64,0,-sqrt(715)/64,0,-sqrt(1001)/64,0]",
        ),
        "Qh(9,A,9,)": (
            "-7*sqrt(22)*S1/64-3*sqrt(21)*S3/32-sqrt(65)*S5/32+sqrt(13)*S7/64+3*sqrt(221)*S9/64",
            "3*sqrt(110)*y*(x-z)*(x+z)*(7*x**6-70*x**4*y**2+21*x**4*z**2+112*x**2*y**4-140*x**2*y**2*z**2+21*x**2*z**4-32*y**6+112*y**4*z**2-70*y**2*z**4+7*z**6)/64",
            "[3*sqrt(442)*I/128,0,sqrt(26)*I/128,0,-sqrt(130)*I/64,0,-3*sqrt(42)*I/64,0,-7*sqrt(11)*I/64,0,-7*sqrt(11)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(130)*I/64,0,sqrt(26)*I/128,0,3*sqrt(442)*I/128]",
        ),
        "Qh(10,A,9,)": (
            "sqrt(41990)*C1/256-sqrt(4845)*C3/128+sqrt(969)*C5/128-sqrt(285)*C7/256+sqrt(5)*C9/256",
            "sqrt(92378)*x*z*(x**4-10*x**2*z**2+5*z**4)*(5*x**4-10*x**2*z**2+z**4)/256",
            "[0,-sqrt(10)/512,0,sqrt(570)/512,0,-sqrt(1938)/256,0,sqrt(9690)/256,0,-sqrt(20995)/256,0,sqrt(20995)/256,0,-sqrt(9690)/256,0,sqrt(1938)/256,0,-sqrt(570)/512,0,sqrt(10)/512,0]",
        ),
        "Qh(11,A,9,)": (
            "sqrt(29393)*S1/512-sqrt(22)*S11/1024-9*sqrt(1615)*S3/512+5*sqrt(13566)*S5/1024-7*sqrt(1330)*S7/1024+9*sqrt(42)*S9/1024",
            "-sqrt(1939938)*y*(x-z)*(x+z)*(x**4-4*x**3*z-14*x**2*z**2-4*x*z**3+z**4)*(x**4+4*x**3*z-14*x**2*z**2+4*x*z**3+z**4)/512",
            "[-sqrt(11)*I/1024,0,9*sqrt(21)*I/1024,0,-7*sqrt(665)*I/1024,0,5*sqrt(6783)*I/1024,0,-9*sqrt(3230)*I/1024,0,sqrt(58786)*I/1024,0,sqrt(58786)*I/1024,0,-9*sqrt(3230)*I/1024,0,5*sqrt(6783)*I/1024,0,-7*sqrt(665)*I/1024,0,9*sqrt(21)*I/1024,0,-sqrt(11)*I/1024]",
        ),
        "Qh(10,A,10,)": (
            "9*sqrt(78)*C1/256+69*C3/128-sqrt(5)*C5/128-43*sqrt(17)*C7/256+3*sqrt(969)*C9/256",
            "sqrt(4290)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(3*x**4-96*x**2*y**2+6*x**2*z**2+224*y**4-96*y**2*z**2+3*z**4)/256",
            "[0,-3*sqrt(1938)/512,0,43*sqrt(34)/512,0,sqrt(10)/256,0,-69*sqrt(2)/256,0,-9*sqrt(39)/256,0,9*sqrt(39)/256,0,69*sqrt(2)/256,0,-sqrt(10)/256,0,-43*sqrt(34)/512,0,3*sqrt(1938)/512,0]",
        ),
        "Qh(11,A,10,)": (
            "15*sqrt(221)*S1/512-3*sqrt(2926)*S11/1024-sqrt(595)*S3/512-53*sqrt(102)*S5/1024-105*sqrt(10)*S7/1024+61*sqrt(114)*S9/1024",
            "-sqrt(14586)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(15*x**4-160*x**2*y**2+30*x**2*z**2+224*y**4-160*y**2*z**2+15*z**4)/512",
            "[-3*sqrt(1463)*I/1024,0,61*sqrt(57)*I/1024,0,-105*sqrt(5)*I/1024,0,-53*sqrt(51)*I/1024,0,-sqrt(1190)*I/1024,0,15*sqrt(442)*I/1024,0,15*sqrt(442)*I/1024,0,-sqrt(1190)*I/1024,0,-53*sqrt(51)*I/1024,0,-105*sqrt(5)*I/1024,0,61*sqrt(57)*I/1024,0,-3*sqrt(1463)*I/1024]",
        ),
        "Qh(10,A,11,)": (
            "7*sqrt(3)*C1/128+7*sqrt(26)*C3/128+5*sqrt(130)*C5/128+7*sqrt(442)*C7/256+sqrt(25194)*C9/256",
            "sqrt(165)*x*z*(7*x**8-336*x**6*y**2+28*x**6*z**2+1680*x**4*y**4-1008*x**4*y**2*z**2+42*x**4*z**4-1792*x**2*y**6+3360*x**2*y**4*z**2-1008*x**2*y**2*z**4+28*x**2*z**6+384*y**8-1792*y**6*z**2+1680*y**4*z**4-336*y**2*z**6+7*z**8)/128",
            "[0,-sqrt(12597)/256,0,-7*sqrt(221)/256,0,-5*sqrt(65)/128,0,-7*sqrt(13)/128,0,-7*sqrt(6)/256,0,7*sqrt(6)/256,0,7*sqrt(13)/128,0,5*sqrt(65)/128,0,7*sqrt(221)/256,0,sqrt(12597)/256,0]",
        ),
        "Qh(11,A,11,)": (
            "21*sqrt(130)*S1/512-sqrt(124355)*S11/512+57*sqrt(14)*S3/512+41*sqrt(15)*S5/512+17*sqrt(17)*S7/512-sqrt(4845)*S9/512",
            "-sqrt(2145)*y*(x-z)*(x+z)*(21*x**8-336*x**6*y**2+84*x**6*z**2+1008*x**4*y**4-1008*x**4*y**2*z**2+126*x**4*z**4-768*x**2*y**6+2016*x**2*y**4*z**2-1008*x**2*y**2*z**4+84*x**2*z**6+128*y**8-768*y**6*z**2+1008*y**4*z**4-336*y**2*z**6+21*z**8)/256",
            "[-sqrt(248710)*I/1024,0,-sqrt(9690)*I/1024,0,17*sqrt(34)*I/1024,0,41*sqrt(30)*I/1024,0,57*sqrt(7)*I/512,0,21*sqrt(65)*I/512,0,21*sqrt(65)*I/512,0,57*sqrt(7)*I/512,0,41*sqrt(30)*I/1024,0,17*sqrt(34)*I/1024,0,-sqrt(9690)*I/1024,0,-sqrt(248710)*I/1024]",
        ),
        "Qh(1,B,1,)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(2,B,1,)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(3,B,1,)": (
            "-sqrt(6)*C1/4+sqrt(10)*C3/4",
            "x*(2*x**2-3*y**2-3*z**2)/2",
            "[-sqrt(5)/4,0,sqrt(3)/4,0,-sqrt(3)/4,0,sqrt(5)/4]",
        ),
        "Qh(4,B,1,)": (
            "-sqrt(14)*S1/4-sqrt(2)*S3/4",
            "sqrt(35)*y*z*(y-z)*(y+z)/2",
            "[0,-I/4,0,-sqrt(7)*I/4,0,-sqrt(7)*I/4,0,-I/4,0]",
        ),
        "Qh(5,B,1,)": (
            "sqrt(15)*C1/8-sqrt(70)*C3/16+3*sqrt(14)*C5/16",
            "x*(8*x**4-40*x**2*y**2-40*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/8",
            "[-3*sqrt(7)/16,0,sqrt(35)/16,0,-sqrt(30)/16,0,sqrt(30)/16,0,-sqrt(35)/16,0,3*sqrt(7)/16]",
        ),
        "Qh(6,B,1,)": (
            "sqrt(3)*S1/4-sqrt(30)*S3/8-sqrt(22)*S5/8",
            "3*sqrt(7)*y*z*(y-z)*(y+z)*(10*x**2-y**2-z**2)/4",
            "[0,-sqrt(11)*I/8,0,-sqrt(15)*I/8,0,sqrt(6)*I/8,0,sqrt(6)*I/8,0,-sqrt(15)*I/8,0,-sqrt(11)*I/8,0]",
        ),
        "Qh(7,B,1,)": (
            "-5*sqrt(7)*C1/32+3*sqrt(21)*C3/32-sqrt(231)*C5/32+sqrt(429)*C7/32",
            "x*(16*x**6-168*x**4*y**2-168*x**4*z**2+210*x**2*y**4+420*x**2*y**2*z**2+210*x**2*z**4-35*y**6-105*y**4*z**2-105*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)/64,0,sqrt(462)/64,0,-3*sqrt(42)/64,0,5*sqrt(14)/64,0,-5*sqrt(14)/64,0,3*sqrt(42)/64,0,-sqrt(462)/64,0,sqrt(858)/64]",
        ),
        "Qh(8,B,1,)": (
            "-sqrt(715)*S1/32-sqrt(273)*S3/32-sqrt(35)*S5/32-S7/32",
            "3*sqrt(715)*y*z*(y-z)*(y+z)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[0,-sqrt(2)*I/64,0,-sqrt(70)*I/64,0,-sqrt(546)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(546)*I/64,0,-sqrt(70)*I/64,0,-sqrt(2)*I/64,0]",
        ),
        "Qh(9,B,1,)": (
            "21*sqrt(5)*C1/128-sqrt(2310)*C3/128+3*sqrt(286)*C5/128-3*sqrt(1430)*C7/256+sqrt(24310)*C9/256",
            "x*(128*x**8-2304*x**6*y**2-2304*x**6*z**2+6048*x**4*y**4+12096*x**4*y**2*z**2+6048*x**4*z**4-3360*x**2*y**6-10080*x**2*y**4*z**2-10080*x**2*y**2*z**4-3360*x**2*z**6+315*y**8+1260*y**6*z**2+1890*y**4*z**4+1260*y**2*z**6+315*z**8)/128",
            "[-sqrt(12155)/256,0,3*sqrt(715)/256,0,-3*sqrt(143)/128,0,sqrt(1155)/128,0,-21*sqrt(10)/256,0,21*sqrt(10)/256,0,-sqrt(1155)/128,0,3*sqrt(143)/128,0,-3*sqrt(715)/256,0,sqrt(12155)/256]",
        ),
        "Qh(10,B,1,)": (
            "sqrt(221)*S1/32-sqrt(102)*S3/32-sqrt(510)*S5/32-11*sqrt(6)*S7/64-sqrt(38)*S9/64",
            "sqrt(12155)*y*z*(y-z)*(y+z)*(18*x**2-y**2-z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/32",
            "[0,-sqrt(19)*I/64,0,-11*sqrt(3)*I/64,0,-sqrt(255)*I/32,0,-sqrt(51)*I/32,0,sqrt(442)*I/64,0,sqrt(442)*I/64,0,-sqrt(51)*I/32,0,-sqrt(255)*I/32,0,-11*sqrt(3)*I/64,0,-sqrt(19)*I/64,0]",
        ),
        "Qh(11,B,1,)": (
            "-21*sqrt(66)*C1/512+sqrt(88179)*C11/512+sqrt(30030)*C3/512-15*sqrt(143)*C5/512+sqrt(36465)*C7/512-sqrt(46189)*C9/512",
            "x*(256*x**10-7040*x**8*y**2-7040*x**8*z**2+31680*x**6*y**4+63360*x**6*y**2*z**2+31680*x**6*z**4-36960*x**4*y**6-110880*x**4*y**4*z**2-110880*x**4*y**2*z**4-36960*x**4*z**6+11550*x**2*y**8+46200*x**2*y**6*z**2+69300*x**2*y**4*z**4+46200*x**2*y**2*z**6+11550*x**2*z**8-693*y**10-3465*y**8*z**2-6930*y**6*z**4-6930*y**4*z**6-3465*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)/1024,0,sqrt(92378)/1024,0,-sqrt(72930)/1024,0,15*sqrt(286)/1024,0,-sqrt(15015)/512,0,21*sqrt(33)/512,0,-21*sqrt(33)/512,0,sqrt(15015)/512,0,-15*sqrt(286)/1024,0,sqrt(72930)/1024,0,-sqrt(92378)/1024,0,sqrt(176358)/1024]",
        ),
        "Qh(1,B,2,)": ("C0", "z", "[0,1,0]"),
        "Qh(2,B,2,)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Qh(3,B,2,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(4,B,2,)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(5,B,2,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(6,B,2,)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(7,B,2,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(8,B,2,)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(9,B,2,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,B,2,)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(11,B,2,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(3,B,3,)": (
            "-sqrt(10)*C1/4-sqrt(6)*C3/4",
            "sqrt(15)*x*(y-z)*(y+z)/2",
            "[sqrt(3)/4,0,sqrt(5)/4,0,-sqrt(5)/4,0,-sqrt(3)/4]",
        ),
        "Qh(4,B,3,)": (
            "-sqrt(2)*S1/4+sqrt(14)*S3/4",
            "sqrt(5)*y*z*(6*x**2-y**2-z**2)/2",
            "[0,sqrt(7)*I/4,0,-I/4,0,-I/4,0,sqrt(7)*I/4,0]",
        ),
        "Qh(5,B,3,)": (
            "sqrt(21)*C1/8+9*sqrt(2)*C3/16+sqrt(10)*C5/16",
            "3*sqrt(35)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/8",
            "[-sqrt(5)/16,0,-9/16,0,-sqrt(42)/16,0,sqrt(42)/16,0,9/16,0,sqrt(5)/16]",
        ),
        "Qh(6,B,3,)": (
            "3*sqrt(22)*S1/16+sqrt(55)*S3/16+sqrt(3)*S5/16",
            "sqrt(462)*y*z*(y**2-3*z**2)*(3*y**2-z**2)/16",
            "[0,sqrt(6)*I/32,0,sqrt(110)*I/32,0,3*sqrt(11)*I/16,0,3*sqrt(11)*I/16,0,sqrt(110)*I/32,0,sqrt(6)*I/32,0]",
        ),
        "Qh(7,B,3,)": (
            "-3*sqrt(33)*C1/32-sqrt(11)*C3/32+25*C5/32+sqrt(91)*C7/32",
            "sqrt(231)*x*(10*x**2-3*y**2-3*z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[-sqrt(182)/64,0,-25*sqrt(2)/64,0,sqrt(22)/64,0,3*sqrt(66)/64,0,-3*sqrt(66)/64,0,-sqrt(22)/64,0,25*sqrt(2)/64,0,sqrt(182)/64]",
        ),
        "Qh(8,B,3,)": (
            "-sqrt(77)*S1/32+5*sqrt(15)*S3/32-3*sqrt(13)*S5/32-sqrt(455)*S7/32",
            "3*sqrt(77)*y*z*(y-z)*(y+z)*(40*x**4-24*x**2*y**2-24*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,-sqrt(910)*I/64,0,-3*sqrt(26)*I/64,0,5*sqrt(30)*I/64,0,-sqrt(154)*I/64,0,-sqrt(154)*I/64,0,5*sqrt(30)*I/64,0,-3*sqrt(26)*I/64,0,-sqrt(910)*I/64,0]",
        ),
        "Qh(9,B,3,)": (
            "sqrt(2431)*C1/128+sqrt(9282)*C3/128+5*sqrt(170)*C5/128+7*sqrt(34)*C7/256+3*sqrt(2)*C9/256",
            "3*sqrt(12155)*x*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/128",
            "[-3/256,0,-7*sqrt(17)/256,0,-5*sqrt(85)/128,0,-sqrt(4641)/128,0,-sqrt(4862)/256,0,sqrt(4862)/256,0,sqrt(4641)/128,0,5*sqrt(85)/128,0,7*sqrt(17)/256,0,3/256]",
        ),
        "Qh(10,B,3,)": (
            "sqrt(39)*S1/32-11*sqrt(2)*S3/32+5*sqrt(10)*S5/32-sqrt(34)*S7/64-sqrt(1938)*S9/64",
            "sqrt(2145)*y*z*(y-z)*(y+z)*(112*x**6-168*x**4*y**2-168*x**4*z**2+42*x**2*y**4+84*x**2*y**2*z**2+42*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,-sqrt(969)*I/64,0,-sqrt(17)*I/64,0,5*sqrt(5)*I/32,0,-11*I/32,0,sqrt(78)*I/64,0,sqrt(78)*I/64,0,-11*I/32,0,5*sqrt(5)*I/32,0,-sqrt(17)*I/64,0,-sqrt(969)*I/64,0]",
        ),
        "Qh(11,B,3,)": (
            "-sqrt(41990)*C1/512+sqrt(385)*C11/512-3*sqrt(4522)*C3/512+3*sqrt(4845)*C5/512+77*sqrt(19)*C7/512+39*sqrt(15)*C9/512",
            "sqrt(692835)*x*(6*x**2-y**2-z**2)*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/256",
            "[-sqrt(770)/1024,0,-39*sqrt(30)/1024,0,-77*sqrt(38)/1024,0,-3*sqrt(9690)/1024,0,3*sqrt(2261)/512,0,sqrt(20995)/512,0,-sqrt(20995)/512,0,-3*sqrt(2261)/512,0,3*sqrt(9690)/1024,0,77*sqrt(38)/1024,0,39*sqrt(30)/1024,0,sqrt(770)/1024]",
        ),
        "Qh(3,B,4,)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(4,B,4,)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(5,B,4,)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(6,B,4,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(7,B,4,)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(8,B,4,)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(9,B,4,)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(10,B,4,)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(11,B,4,)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(5,B,5,)": (
            "sqrt(7)*C1/4-sqrt(6)*C3/8-sqrt(30)*C5/8",
            "sqrt(105)*x*(y-z)*(y+z)*(2*x**2-y**2-z**2)/4",
            "[sqrt(15)/8,0,sqrt(3)/8,0,-sqrt(14)/8,0,sqrt(14)/8,0,-sqrt(3)/8,0,-sqrt(15)/8]",
        ),
        "Qh(6,B,5,)": (
            "sqrt(10)*S1/16-9*S3/16+sqrt(165)*S5/16",
            "sqrt(210)*y*z*(16*x**4-16*x**2*y**2-16*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,sqrt(330)*I/32,0,-9*sqrt(2)*I/32,0,sqrt(5)*I/16,0,sqrt(5)*I/16,0,-9*sqrt(2)*I/32,0,sqrt(330)*I/32,0]",
        ),
        "Qh(7,B,5,)": (
            "-sqrt(858)*C1/64-3*sqrt(286)*C3/64-5*sqrt(26)*C5/64-sqrt(14)*C7/64",
            "sqrt(6006)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/32",
            "[sqrt(7)/64,0,5*sqrt(13)/64,0,3*sqrt(143)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-3*sqrt(143)/64,0,-5*sqrt(13)/64,0,-sqrt(7)/64]",
        ),
        "Qh(8,B,5,)": (
            "-sqrt(858)*S1/64+sqrt(910)*S3/64+7*sqrt(42)*S5/64+3*sqrt(30)*S7/64",
            "sqrt(858)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(14*x**2-y**2-z**2)/32",
            "[0,3*sqrt(15)*I/64,0,7*sqrt(21)*I/64,0,sqrt(455)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(455)*I/64,0,7*sqrt(21)*I/64,0,3*sqrt(15)*I/64,0]",
        ),
        "Qh(9,B,5,)": (
            "sqrt(1001)*C1/64-sqrt(78)*C3/64-3*sqrt(70)*C5/64+23*sqrt(14)*C7/128+3*sqrt(238)*C9/128",
            "3*sqrt(5005)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(8*x**4-8*x**2*y**2-8*x**2*z**2+y**4+2*y**2*z**2+z**4)/64",
            "[-3*sqrt(119)/128,0,-23*sqrt(7)/128,0,3*sqrt(35)/64,0,sqrt(39)/64,0,-sqrt(2002)/128,0,sqrt(2002)/128,0,-sqrt(39)/64,0,-3*sqrt(35)/64,0,23*sqrt(7)/128,0,3*sqrt(119)/128]",
        ),
        "Qh(10,B,5,)": (
            "sqrt(41990)*S1/256+sqrt(4845)*S3/128+sqrt(969)*S5/128+sqrt(285)*S7/256+sqrt(5)*S9/256",
            "sqrt(92378)*y*z*(y**4-10*y**2*z**2+5*z**4)*(5*y**4-10*y**2*z**2+z**4)/256",
            "[0,sqrt(10)*I/512,0,sqrt(570)*I/512,0,sqrt(1938)*I/256,0,sqrt(9690)*I/256,0,sqrt(20995)*I/256,0,sqrt(20995)*I/256,0,sqrt(9690)*I/256,0,sqrt(1938)*I/256,0,sqrt(570)*I/512,0,sqrt(10)*I/512,0]",
        ),
        "Qh(11,B,5,)": (
            "-5*sqrt(546)*C1/256+sqrt(10659)*C11/256+11*sqrt(30)*C3/256+13*sqrt(7)*C5/256-3*sqrt(1785)*C7/256+3*sqrt(2261)*C9/256",
            "3*sqrt(1001)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(80*x**6-168*x**4*y**2-168*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-5*y**6-15*y**4*z**2-15*y**2*z**4-5*z**6)/128",
            "[-sqrt(21318)/512,0,-3*sqrt(4522)/512,0,3*sqrt(3570)/512,0,-13*sqrt(14)/512,0,-11*sqrt(15)/256,0,5*sqrt(273)/256,0,-5*sqrt(273)/256,0,11*sqrt(15)/256,0,13*sqrt(14)/512,0,-3*sqrt(3570)/512,0,3*sqrt(4522)/512,0,sqrt(21318)/512]",
        ),
        "Qh(5,B,6,)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(6,B,6,)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(7,B,6,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(8,B,6,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(9,B,6,)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(10,B,6,)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(11,B,6,)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(7,B,7,)": (
            "-15*sqrt(6)*C1/64+19*sqrt(2)*C3/64-sqrt(22)*C5/64-sqrt(2002)*C7/64",
            "sqrt(42)*x*(y-z)*(y+z)*(48*x**4-80*x**2*y**2-80*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/32",
            "[sqrt(1001)/64,0,sqrt(11)/64,0,-19/64,0,15*sqrt(3)/64,0,-15*sqrt(3)/64,0,19/64,0,-sqrt(11)/64,0,-sqrt(1001)/64]",
        ),
        "Qh(8,B,7,)": (
            "-sqrt(70)*S1/64+3*sqrt(66)*S3/64-sqrt(1430)*S5/64+sqrt(2002)*S7/64",
            "3*sqrt(70)*y*z*(32*x**6-80*x**4*y**2-80*x**4*z**2+30*x**2*y**4+60*x**2*y**2*z**2+30*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,sqrt(1001)*I/64,0,-sqrt(715)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(35)*I/64,0,-sqrt(35)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(715)*I/64,0,sqrt(1001)*I/64,0]",
        ),
        "Qh(9,B,7,)": (
            "sqrt(858)*C1/64+sqrt(91)*C3/32-5*sqrt(15)*C5/32-21*sqrt(3)*C7/64-sqrt(51)*C9/64",
            "sqrt(4290)*x*(y-z)*(y+z)*(14*x**2-3*y**2-3*z**2)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/64",
            "[sqrt(102)/128,0,21*sqrt(6)/128,0,5*sqrt(30)/64,0,-sqrt(182)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(182)/64,0,-5*sqrt(30)/64,0,-21*sqrt(6)/128,0,-sqrt(102)/128]",
        ),
        "Qh(10,B,7,)": (
            "9*sqrt(78)*S1/256-69*S3/128-sqrt(5)*S5/128+43*sqrt(17)*S7/256+3*sqrt(969)*S9/256",
            "sqrt(4290)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(224*x**4-96*x**2*y**2-96*x**2*z**2+3*y**4+6*y**2*z**2+3*z**4)/256",
            "[0,3*sqrt(1938)*I/512,0,43*sqrt(34)*I/512,0,-sqrt(10)*I/256,0,-69*sqrt(2)*I/256,0,9*sqrt(39)*I/256,0,9*sqrt(39)*I/256,0,-69*sqrt(2)*I/256,0,-sqrt(10)*I/256,0,43*sqrt(34)*I/512,0,3*sqrt(1938)*I/512,0]",
        ),
        "Qh(11,B,7,)": (
            "-sqrt(29393)*C1/512-sqrt(22)*C11/1024-9*sqrt(1615)*C3/512-5*sqrt(13566)*C5/1024-7*sqrt(1330)*C7/1024-9*sqrt(42)*C9/1024",
            "sqrt(1939938)*x*(y-z)*(y+z)*(y**4-4*y**3*z-14*y**2*z**2-4*y*z**3+z**4)*(y**4+4*y**3*z-14*y**2*z**2+4*y*z**3+z**4)/512",
            "[sqrt(11)/1024,0,9*sqrt(21)/1024,0,7*sqrt(665)/1024,0,5*sqrt(6783)/1024,0,9*sqrt(3230)/1024,0,sqrt(58786)/1024,0,-sqrt(58786)/1024,0,-9*sqrt(3230)/1024,0,-5*sqrt(6783)/1024,0,-7*sqrt(665)/1024,0,-9*sqrt(21)/1024,0,-sqrt(11)/1024]",
        ),
        "Qh(7,B,8,)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(8,B,8,)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,B,8,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(10,B,8,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(11,B,8,)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,B,9,)": (
            "7*sqrt(22)*C1/64-3*sqrt(21)*C3/32+sqrt(65)*C5/32+sqrt(13)*C7/64-3*sqrt(221)*C9/64",
            "3*sqrt(110)*x*(y-z)*(y+z)*(32*x**6-112*x**4*y**2-112*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-7*y**6-21*y**4*z**2-21*y**2*z**4-7*z**6)/64",
            "[3*sqrt(442)/128,0,-sqrt(26)/128,0,-sqrt(130)/64,0,3*sqrt(42)/64,0,-7*sqrt(11)/64,0,7*sqrt(11)/64,0,-3*sqrt(42)/64,0,sqrt(130)/64,0,sqrt(26)/128,0,-3*sqrt(442)/128]",
        ),
        "Qh(10,B,9,)": (
            "7*sqrt(3)*S1/128-7*sqrt(26)*S3/128+5*sqrt(130)*S5/128-7*sqrt(442)*S7/256+sqrt(25194)*S9/256",
            "sqrt(165)*y*z*(384*x**8-1792*x**6*y**2-1792*x**6*z**2+1680*x**4*y**4+3360*x**4*y**2*z**2+1680*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+7*y**8+28*y**6*z**2+42*y**4*z**4+28*y**2*z**6+7*z**8)/128",
            "[0,sqrt(12597)*I/256,0,-7*sqrt(221)*I/256,0,5*sqrt(65)*I/128,0,-7*sqrt(13)*I/128,0,7*sqrt(6)*I/256,0,7*sqrt(6)*I/256,0,-7*sqrt(13)*I/128,0,5*sqrt(65)*I/128,0,-7*sqrt(221)*I/256,0,sqrt(12597)*I/256,0]",
        ),
        "Qh(11,B,9,)": (
            "-15*sqrt(221)*C1/512-3*sqrt(2926)*C11/1024-sqrt(595)*C3/512+53*sqrt(102)*C5/1024-105*sqrt(10)*C7/1024-61*sqrt(114)*C9/1024",
            "sqrt(14586)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)*(224*x**4-160*x**2*y**2-160*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/512",
            "[3*sqrt(1463)/1024,0,61*sqrt(57)/1024,0,105*sqrt(5)/1024,0,-53*sqrt(51)/1024,0,sqrt(1190)/1024,0,15*sqrt(442)/1024,0,-15*sqrt(442)/1024,0,-sqrt(1190)/1024,0,53*sqrt(51)/1024,0,-105*sqrt(5)/1024,0,-61*sqrt(57)/1024,0,-3*sqrt(1463)/1024]",
        ),
        "Qh(9,B,10,)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,B,10,)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,B,10,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,B,11,)": (
            "-21*sqrt(130)*C1/512-sqrt(124355)*C11/512+57*sqrt(14)*C3/512-41*sqrt(15)*C5/512+17*sqrt(17)*C7/512+sqrt(4845)*C9/512",
            "sqrt(2145)*x*(y-z)*(y+z)*(128*x**8-768*x**6*y**2-768*x**6*z**2+1008*x**4*y**4+2016*x**4*y**2*z**2+1008*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+21*y**8+84*y**6*z**2+126*y**4*z**4+84*y**2*z**6+21*z**8)/256",
            "[sqrt(248710)/1024,0,-sqrt(9690)/1024,0,-17*sqrt(34)/1024,0,41*sqrt(30)/1024,0,-57*sqrt(7)/512,0,21*sqrt(65)/512,0,-21*sqrt(65)/512,0,57*sqrt(7)/512,0,-41*sqrt(30)/1024,0,17*sqrt(34)/1024,0,sqrt(9690)/1024,0,-sqrt(248710)/1024]",
        ),
        "Qh(11,B,12,)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
    },
    "Cs": {
        "Qh(0,A',,)": ("C0", "1", "[1]"),
        "Qh(1,A',1,)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(2,A',1,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(3,A',1,)": (
            "-sqrt(6)*C1/4+sqrt(10)*C3/4",
            "x*(2*x**2-3*y**2-3*z**2)/2",
            "[-sqrt(5)/4,0,sqrt(3)/4,0,-sqrt(3)/4,0,sqrt(5)/4]",
        ),
        "Qh(4,A',1,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Qh(5,A',1,)": (
            "sqrt(15)*C1/8-sqrt(70)*C3/16+3*sqrt(14)*C5/16",
            "x*(8*x**4-40*x**2*y**2-40*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/8",
            "[-3*sqrt(7)/16,0,sqrt(35)/16,0,-sqrt(30)/16,0,sqrt(30)/16,0,-sqrt(35)/16,0,3*sqrt(7)/16]",
        ),
        "Qh(6,A',1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Qh(7,A',1,)": (
            "-5*sqrt(7)*C1/32+3*sqrt(21)*C3/32-sqrt(231)*C5/32+sqrt(429)*C7/32",
            "x*(16*x**6-168*x**4*y**2-168*x**4*z**2+210*x**2*y**4+420*x**2*y**2*z**2+210*x**2*z**4-35*y**6-105*y**4*z**2-105*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)/64,0,sqrt(462)/64,0,-3*sqrt(42)/64,0,5*sqrt(14)/64,0,-5*sqrt(14)/64,0,3*sqrt(42)/64,0,-sqrt(462)/64,0,sqrt(858)/64]",
        ),
        "Qh(8,A',1,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Qh(9,A',1,)": (
            "21*sqrt(5)*C1/128-sqrt(2310)*C3/128+3*sqrt(286)*C5/128-3*sqrt(1430)*C7/256+sqrt(24310)*C9/256",
            "x*(128*x**8-2304*x**6*y**2-2304*x**6*z**2+6048*x**4*y**4+12096*x**4*y**2*z**2+6048*x**4*z**4-3360*x**2*y**6-10080*x**2*y**4*z**2-10080*x**2*y**2*z**4-3360*x**2*z**6+315*y**8+1260*y**6*z**2+1890*y**4*z**4+1260*y**2*z**6+315*z**8)/128",
            "[-sqrt(12155)/256,0,3*sqrt(715)/256,0,-3*sqrt(143)/128,0,sqrt(1155)/128,0,-21*sqrt(10)/256,0,21*sqrt(10)/256,0,-sqrt(1155)/128,0,3*sqrt(143)/128,0,-3*sqrt(715)/256,0,sqrt(12155)/256]",
        ),
        "Qh(10,A',1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Qh(11,A',1,)": (
            "-21*sqrt(66)*C1/512+sqrt(88179)*C11/512+sqrt(30030)*C3/512-15*sqrt(143)*C5/512+sqrt(36465)*C7/512-sqrt(46189)*C9/512",
            "x*(256*x**10-7040*x**8*y**2-7040*x**8*z**2+31680*x**6*y**4+63360*x**6*y**2*z**2+31680*x**6*z**4-36960*x**4*y**6-110880*x**4*y**4*z**2-110880*x**4*y**2*z**4-36960*x**4*z**6+11550*x**2*y**8+46200*x**2*y**6*z**2+69300*x**2*y**4*z**4+46200*x**2*y**2*z**6+11550*x**2*z**8-693*y**10-3465*y**8*z**2-6930*y**6*z**4-6930*y**4*z**6-3465*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)/1024,0,sqrt(92378)/1024,0,-sqrt(72930)/1024,0,15*sqrt(286)/1024,0,-sqrt(15015)/512,0,21*sqrt(33)/512,0,-21*sqrt(33)/512,0,sqrt(15015)/512,0,-15*sqrt(286)/1024,0,sqrt(72930)/1024,0,-sqrt(92378)/1024,0,sqrt(176358)/1024]",
        ),
        "Qh(1,A',2,)": ("C0", "z", "[0,1,0]"),
        "Qh(2,A',2,)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(3,A',2,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(4,A',2,)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "-sqrt(15)*(x**4-12*x**2*y**2+6*x**2*z**2+y**4+6*y**2*z**2-2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Qh(5,A',2,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(6,A',2,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Qh(7,A',2,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(8,A',2,)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Qh(9,A',2,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A',2,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Qh(11,A',2,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(2,A',3,)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Qh(3,A',3,)": (
            "-sqrt(10)*C1/4-sqrt(6)*C3/4",
            "sqrt(15)*x*(y-z)*(y+z)/2",
            "[sqrt(3)/4,0,sqrt(5)/4,0,-sqrt(5)/4,0,-sqrt(3)/4]",
        ),
        "Qh(4,A',3,)": ("-C2", "sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Qh(5,A',3,)": (
            "sqrt(21)*C1/8+9*sqrt(2)*C3/16+sqrt(10)*C5/16",
            "3*sqrt(35)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/8",
            "[-sqrt(5)/16,0,-9/16,0,-sqrt(42)/16,0,sqrt(42)/16,0,9/16,0,sqrt(5)/16]",
        ),
        "Qh(6,A',3,)": (
            "sqrt(14)*C0/4+sqrt(2)*C4/4",
            "-sqrt(14)*(x**6-15*x**4*z**2+15*x**2*z**4+y**6-15*y**4*z**2+15*y**2*z**4-2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Qh(7,A',3,)": (
            "-3*sqrt(33)*C1/32-sqrt(11)*C3/32+25*C5/32+sqrt(91)*C7/32",
            "sqrt(231)*x*(10*x**2-3*y**2-3*z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[-sqrt(182)/64,0,-25*sqrt(2)/64,0,sqrt(22)/64,0,3*sqrt(66)/64,0,-3*sqrt(66)/64,0,-sqrt(22)/64,0,25*sqrt(2)/64,0,sqrt(182)/64]",
        ),
        "Qh(8,A',3,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,A',3,)": (
            "sqrt(2431)*C1/128+sqrt(9282)*C3/128+5*sqrt(170)*C5/128+7*sqrt(34)*C7/256+3*sqrt(2)*C9/256",
            "3*sqrt(12155)*x*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/128",
            "[-3/256,0,-7*sqrt(17)/256,0,-5*sqrt(85)/128,0,-sqrt(4641)/128,0,-sqrt(4862)/256,0,sqrt(4862)/256,0,sqrt(4641)/128,0,5*sqrt(85)/128,0,7*sqrt(17)/256,0,3/256]",
        ),
        "Qh(10,A',3,)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "-sqrt(420189)*(22*x**10+45*x**8*y**2-1035*x**8*z**2-105*x**6*y**4-630*x**6*y**2*z**2+4935*x**6*z**4-105*x**4*y**6+3150*x**4*y**4*z**2-1575*x**4*y**2*z**4-4830*x**4*z**6+45*x**2*y**8-630*x**2*y**6*z**2-1575*x**2*y**4*z**4+1260*x**2*y**2*z**6+990*x**2*z**8+22*y**10-1035*y**8*z**2+4935*y**6*z**4-4830*y**4*z**6+990*y**2*z**8-44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Qh(11,A',3,)": (
            "-sqrt(41990)*C1/512+sqrt(385)*C11/512-3*sqrt(4522)*C3/512+3*sqrt(4845)*C5/512+77*sqrt(19)*C7/512+39*sqrt(15)*C9/512",
            "sqrt(692835)*x*(6*x**2-y**2-z**2)*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/256",
            "[-sqrt(770)/1024,0,-39*sqrt(30)/1024,0,-77*sqrt(38)/1024,0,-3*sqrt(9690)/1024,0,3*sqrt(2261)/512,0,sqrt(20995)/512,0,-sqrt(20995)/512,0,-3*sqrt(2261)/512,0,3*sqrt(9690)/1024,0,77*sqrt(38)/1024,0,39*sqrt(30)/1024,0,sqrt(770)/1024]",
        ),
        "Qh(3,A',4,)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(4,A',4,)": ("sqrt(14)*C1/4-sqrt(2)*C3/4", "-sqrt(35)*x*z*(x-z)*(x+z)/2", "[0,1/4,0,-sqrt(7)/4,0,sqrt(7)/4,0,-1/4,0]"),
        "Qh(5,A',4,)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(6,A',4,)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x-y)*(x+y)*(x**4-9*x**2*y**2-5*x**2*z**2+y**4-5*y**2*z**2+5*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Qh(7,A',4,)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(8,A',4,)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Qh(9,A',4,)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(10,A',4,)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(x-y)*(x+y)*(22*x**8-653*x**6*y**2-315*x**6*z**2+2602*x**4*y**4-945*x**4*y**2*z**2+1575*x**4*z**4-653*x**2*y**6-945*x**2*y**4*z**2+3150*x**2*y**2*z**4-1680*x**2*z**6+22*y**8-315*y**6*z**2+1575*y**4*z**4-1680*y**2*z**6+360*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Qh(11,A',4,)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(4,A',5,)": (
            "-sqrt(2)*C1/4-sqrt(14)*C3/4",
            "-sqrt(5)*x*z*(x**2-6*y**2+z**2)/2",
            "[0,sqrt(7)/4,0,1/4,0,-1/4,0,-sqrt(7)/4,0]",
        ),
        "Qh(5,A',5,)": (
            "sqrt(7)*C1/4-sqrt(6)*C3/8-sqrt(30)*C5/8",
            "sqrt(105)*x*(y-z)*(y+z)*(2*x**2-y**2-z**2)/4",
            "[sqrt(15)/8,0,sqrt(3)/8,0,-sqrt(14)/8,0,sqrt(14)/8,0,-sqrt(3)/8,0,-sqrt(15)/8]",
        ),
        "Qh(6,A',5,)": (
            "-sqrt(3)*C1/4-sqrt(30)*C3/8+sqrt(22)*C5/8",
            "3*sqrt(7)*x*z*(x-z)*(x+z)*(x**2-10*y**2+z**2)/4",
            "[0,-sqrt(11)/8,0,sqrt(15)/8,0,sqrt(6)/8,0,-sqrt(6)/8,0,-sqrt(15)/8,0,sqrt(11)/8,0]",
        ),
        "Qh(7,A',5,)": (
            "-sqrt(858)*C1/64-3*sqrt(286)*C3/64-5*sqrt(26)*C5/64-sqrt(14)*C7/64",
            "sqrt(6006)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/32",
            "[sqrt(7)/64,0,5*sqrt(13)/64,0,3*sqrt(143)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-3*sqrt(143)/64,0,-5*sqrt(13)/64,0,-sqrt(7)/64]",
        ),
        "Qh(8,A',5,)": (
            "C2",
            "-3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(9,A',5,)": (
            "sqrt(1001)*C1/64-sqrt(78)*C3/64-3*sqrt(70)*C5/64+23*sqrt(14)*C7/128+3*sqrt(238)*C9/128",
            "3*sqrt(5005)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(8*x**4-8*x**2*y**2-8*x**2*z**2+y**4+2*y**2*z**2+z**4)/64",
            "[-3*sqrt(119)/128,0,-23*sqrt(7)/128,0,3*sqrt(35)/64,0,sqrt(39)/64,0,-sqrt(2002)/128,0,sqrt(2002)/128,0,-sqrt(39)/64,0,-3*sqrt(35)/64,0,23*sqrt(7)/128,0,3*sqrt(119)/128]",
        ),
        "Qh(10,A',5,)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "-sqrt(3213210)*(3*x**10-96*x**8*y**2-39*x**8*z**2+224*x**6*y**4+1344*x**6*y**2*z**2-42*x**6*z**4+224*x**4*y**6-6720*x**4*y**4*z**2+3360*x**4*y**2*z**4-182*x**4*z**6-96*x**2*y**8+1344*x**2*y**6*z**2+3360*x**2*y**4*z**4-2688*x**2*y**2*z**6+135*x**2*z**8+3*y**10-39*y**8*z**2-42*y**6*z**4-182*y**4*z**6+135*y**2*z**8-6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Qh(11,A',5,)": (
            "-5*sqrt(546)*C1/256+sqrt(10659)*C11/256+11*sqrt(30)*C3/256+13*sqrt(7)*C5/256-3*sqrt(1785)*C7/256+3*sqrt(2261)*C9/256",
            "3*sqrt(1001)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(80*x**6-168*x**4*y**2-168*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-5*y**6-15*y**4*z**2-15*y**2*z**4-5*z**6)/128",
            "[-sqrt(21318)/512,0,-3*sqrt(4522)/512,0,3*sqrt(3570)/512,0,-13*sqrt(14)/512,0,-11*sqrt(15)/256,0,5*sqrt(273)/256,0,-5*sqrt(273)/256,0,11*sqrt(15)/256,0,13*sqrt(14)/512,0,-3*sqrt(3570)/512,0,3*sqrt(4522)/512,0,sqrt(21318)/512]",
        ),
        "Qh(5,A',6,)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(6,A',6,)": (
            "3*sqrt(22)*C1/16-sqrt(55)*C3/16+sqrt(3)*C5/16",
            "sqrt(462)*x*z*(x**2-3*z**2)*(3*x**2-z**2)/16",
            "[0,-sqrt(6)/32,0,sqrt(110)/32,0,-3*sqrt(11)/16,0,3*sqrt(11)/16,0,-sqrt(110)/32,0,sqrt(6)/32,0]",
        ),
        "Qh(7,A',6,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(8,A',6,)": (
            "sqrt(715)*C1/32-sqrt(273)*C3/32+sqrt(35)*C5/32-C7/32",
            "-3*sqrt(715)*x*z*(x-z)*(x+z)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/16",
            "[0,sqrt(2)/64,0,-sqrt(70)/64,0,sqrt(546)/64,0,-sqrt(1430)/64,0,sqrt(1430)/64,0,-sqrt(546)/64,0,sqrt(70)/64,0,-sqrt(2)/64,0]",
        ),
        "Qh(9,A',6,)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(10,A',6,)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(x-y)*(x+y)*(9*x**8-165*x**6*y**2-231*x**6*z**2-25*x**4*y**4+3801*x**4*y**2*z**2+406*x**4*z**4-165*x**2*y**6+3801*x**2*y**4*z**2-9674*x**2*y**2*z**4+266*x**2*z**6+9*y**8-231*y**6*z**2+406*y**4*z**4+266*y**2*z**6-57*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Qh(11,A',6,)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(6,A',7,)": (
            "sqrt(10)*C1/16+9*C3/16+sqrt(165)*C5/16",
            "sqrt(210)*x*z*(x**4-16*x**2*y**2+2*x**2*z**2+16*y**4-16*y**2*z**2+z**4)/16",
            "[0,-sqrt(330)/32,0,-9*sqrt(2)/32,0,-sqrt(5)/16,0,sqrt(5)/16,0,9*sqrt(2)/32,0,sqrt(330)/32,0]",
        ),
        "Qh(7,A',7,)": (
            "-15*sqrt(6)*C1/64+19*sqrt(2)*C3/64-sqrt(22)*C5/64-sqrt(2002)*C7/64",
            "sqrt(42)*x*(y-z)*(y+z)*(48*x**4-80*x**2*y**2-80*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/32",
            "[sqrt(1001)/64,0,sqrt(11)/64,0,-19/64,0,15*sqrt(3)/64,0,-15*sqrt(3)/64,0,19/64,0,-sqrt(11)/64,0,-sqrt(1001)/64]",
        ),
        "Qh(8,A',7,)": (
            "sqrt(77)*C1/32+5*sqrt(15)*C3/32+3*sqrt(13)*C5/32-sqrt(455)*C7/32",
            "-3*sqrt(77)*x*z*(x-z)*(x+z)*(x**4-24*x**2*y**2+2*x**2*z**2+40*y**4-24*y**2*z**2+z**4)/16",
            "[0,sqrt(910)/64,0,-3*sqrt(26)/64,0,-5*sqrt(30)/64,0,-sqrt(154)/64,0,sqrt(154)/64,0,5*sqrt(30)/64,0,3*sqrt(26)/64,0,-sqrt(910)/64,0]",
        ),
        "Qh(9,A',7,)": (
            "sqrt(858)*C1/64+sqrt(91)*C3/32-5*sqrt(15)*C5/32-21*sqrt(3)*C7/64-sqrt(51)*C9/64",
            "sqrt(4290)*x*(y-z)*(y+z)*(14*x**2-3*y**2-3*z**2)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/64",
            "[sqrt(102)/128,0,21*sqrt(6)/128,0,5*sqrt(30)/64,0,-sqrt(182)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(182)/64,0,-5*sqrt(30)/64,0,-21*sqrt(6)/128,0,-sqrt(102)/128]",
        ),
        "Qh(10,A',7,)": (
            "-sqrt(221)*C1/32-sqrt(102)*C3/32+sqrt(510)*C5/32-11*sqrt(6)*C7/64+sqrt(38)*C9/64",
            "sqrt(12155)*x*z*(x-z)*(x+z)*(x**2-18*y**2+z**2)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/32",
            "[0,-sqrt(19)/64,0,11*sqrt(3)/64,0,-sqrt(255)/32,0,sqrt(51)/32,0,sqrt(442)/64,0,-sqrt(442)/64,0,-sqrt(51)/32,0,sqrt(255)/32,0,-11*sqrt(3)/64,0,sqrt(19)/64,0]",
        ),
        "Qh(11,A',7,)": (
            "-sqrt(29393)*C1/512-sqrt(22)*C11/1024-9*sqrt(1615)*C3/512-5*sqrt(13566)*C5/1024-7*sqrt(1330)*C7/1024-9*sqrt(42)*C9/1024",
            "sqrt(1939938)*x*(y-z)*(y+z)*(y**4-4*y**3*z-14*y**2*z**2-4*y*z**3+z**4)*(y**4+4*y**3*z-14*y**2*z**2+4*y*z**3+z**4)/512",
            "[sqrt(11)/1024,0,9*sqrt(21)/1024,0,7*sqrt(665)/1024,0,5*sqrt(6783)/1024,0,9*sqrt(3230)/1024,0,sqrt(58786)/1024,0,-sqrt(58786)/1024,0,-9*sqrt(3230)/1024,0,-5*sqrt(6783)/1024,0,-7*sqrt(665)/1024,0,-9*sqrt(21)/1024,0,-sqrt(11)/1024]",
        ),
        "Qh(7,A',8,)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(8,A',8,)": (
            "-sqrt(858)*C1/64-sqrt(910)*C3/64+7*sqrt(42)*C5/64-3*sqrt(30)*C7/64",
            "-sqrt(858)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(x**2-14*y**2+z**2)/32",
            "[0,3*sqrt(15)/64,0,-7*sqrt(21)/64,0,sqrt(455)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-sqrt(455)/64,0,7*sqrt(21)/64,0,-3*sqrt(15)/64,0]",
        ),
        "Qh(9,A',8,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(10,A',8,)": (
            "-sqrt(39)*C1/32-11*sqrt(2)*C3/32-5*sqrt(10)*C5/32-sqrt(34)*C7/64+sqrt(1938)*C9/64",
            "sqrt(2145)*x*z*(x-z)*(x+z)*(x**6-42*x**4*y**2+3*x**4*z**2+168*x**2*y**4-84*x**2*y**2*z**2+3*x**2*z**4-112*y**6+168*y**4*z**2-42*y**2*z**4+z**6)/32",
            "[0,-sqrt(969)/64,0,sqrt(17)/64,0,5*sqrt(5)/32,0,11/32,0,sqrt(78)/64,0,-sqrt(78)/64,0,-11/32,0,-5*sqrt(5)/32,0,-sqrt(17)/64,0,sqrt(969)/64,0]",
        ),
        "Qh(11,A',8,)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(8,A',9,)": (
            "-sqrt(70)*C1/64-3*sqrt(66)*C3/64-sqrt(1430)*C5/64-sqrt(2002)*C7/64",
            "-3*sqrt(70)*x*z*(x**6-30*x**4*y**2+3*x**4*z**2+80*x**2*y**4-60*x**2*y**2*z**2+3*x**2*z**4-32*y**6+80*y**4*z**2-30*y**2*z**4+z**6)/32",
            "[0,sqrt(1001)/64,0,sqrt(715)/64,0,3*sqrt(33)/64,0,sqrt(35)/64,0,-sqrt(35)/64,0,-3*sqrt(33)/64,0,-sqrt(715)/64,0,-sqrt(1001)/64,0]",
        ),
        "Qh(9,A',9,)": (
            "7*sqrt(22)*C1/64-3*sqrt(21)*C3/32+sqrt(65)*C5/32+sqrt(13)*C7/64-3*sqrt(221)*C9/64",
            "3*sqrt(110)*x*(y-z)*(y+z)*(32*x**6-112*x**4*y**2-112*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-7*y**6-21*y**4*z**2-21*y**2*z**4-7*z**6)/64",
            "[3*sqrt(442)/128,0,-sqrt(26)/128,0,-sqrt(130)/64,0,3*sqrt(42)/64,0,-7*sqrt(11)/64,0,7*sqrt(11)/64,0,-3*sqrt(42)/64,0,sqrt(130)/64,0,sqrt(26)/128,0,-3*sqrt(442)/128]",
        ),
        "Qh(10,A',9,)": (
            "sqrt(41990)*C1/256-sqrt(4845)*C3/128+sqrt(969)*C5/128-sqrt(285)*C7/256+sqrt(5)*C9/256",
            "sqrt(92378)*x*z*(x**4-10*x**2*z**2+5*z**4)*(5*x**4-10*x**2*z**2+z**4)/256",
            "[0,-sqrt(10)/512,0,sqrt(570)/512,0,-sqrt(1938)/256,0,sqrt(9690)/256,0,-sqrt(20995)/256,0,sqrt(20995)/256,0,-sqrt(9690)/256,0,sqrt(1938)/256,0,-sqrt(570)/512,0,sqrt(10)/512,0]",
        ),
        "Qh(11,A',9,)": (
            "-15*sqrt(221)*C1/512-3*sqrt(2926)*C11/1024-sqrt(595)*C3/512+53*sqrt(102)*C5/1024-105*sqrt(10)*C7/1024-61*sqrt(114)*C9/1024",
            "sqrt(14586)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)*(224*x**4-160*x**2*y**2-160*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/512",
            "[3*sqrt(1463)/1024,0,61*sqrt(57)/1024,0,105*sqrt(5)/1024,0,-53*sqrt(51)/1024,0,sqrt(1190)/1024,0,15*sqrt(442)/1024,0,-15*sqrt(442)/1024,0,-sqrt(1190)/1024,0,53*sqrt(51)/1024,0,-105*sqrt(5)/1024,0,-61*sqrt(57)/1024,0,-3*sqrt(1463)/1024]",
        ),
        "Qh(9,A',10,)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A',10,)": (
            "9*sqrt(78)*C1/256+69*C3/128-sqrt(5)*C5/128-43*sqrt(17)*C7/256+3*sqrt(969)*C9/256",
            "sqrt(4290)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(3*x**4-96*x**2*y**2+6*x**2*z**2+224*y**4-96*y**2*z**2+3*z**4)/256",
            "[0,-3*sqrt(1938)/512,0,43*sqrt(34)/512,0,sqrt(10)/256,0,-69*sqrt(2)/256,0,-9*sqrt(39)/256,0,9*sqrt(39)/256,0,69*sqrt(2)/256,0,-sqrt(10)/256,0,-43*sqrt(34)/512,0,3*sqrt(1938)/512,0]",
        ),
        "Qh(11,A',10,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(10,A',11,)": (
            "7*sqrt(3)*C1/128+7*sqrt(26)*C3/128+5*sqrt(130)*C5/128+7*sqrt(442)*C7/256+sqrt(25194)*C9/256",
            "sqrt(165)*x*z*(7*x**8-336*x**6*y**2+28*x**6*z**2+1680*x**4*y**4-1008*x**4*y**2*z**2+42*x**4*z**4-1792*x**2*y**6+3360*x**2*y**4*z**2-1008*x**2*y**2*z**4+28*x**2*z**6+384*y**8-1792*y**6*z**2+1680*y**4*z**4-336*y**2*z**6+7*z**8)/128",
            "[0,-sqrt(12597)/256,0,-7*sqrt(221)/256,0,-5*sqrt(65)/128,0,-7*sqrt(13)/128,0,-7*sqrt(6)/256,0,7*sqrt(6)/256,0,7*sqrt(13)/128,0,5*sqrt(65)/128,0,7*sqrt(221)/256,0,sqrt(12597)/256,0]",
        ),
        "Qh(11,A',11,)": (
            "-21*sqrt(130)*C1/512-sqrt(124355)*C11/512+57*sqrt(14)*C3/512-41*sqrt(15)*C5/512+17*sqrt(17)*C7/512+sqrt(4845)*C9/512",
            "sqrt(2145)*x*(y-z)*(y+z)*(128*x**8-768*x**6*y**2-768*x**6*z**2+1008*x**4*y**4+2016*x**4*y**2*z**2+1008*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+21*y**8+84*y**6*z**2+126*y**4*z**4+84*y**2*z**6+21*z**8)/256",
            "[sqrt(248710)/1024,0,-sqrt(9690)/1024,0,-17*sqrt(34)/1024,0,41*sqrt(30)/1024,0,-57*sqrt(7)/512,0,21*sqrt(65)/512,0,-21*sqrt(65)/512,0,57*sqrt(7)/512,0,-41*sqrt(30)/1024,0,17*sqrt(34)/1024,0,sqrt(9690)/1024,0,-sqrt(248710)/1024]",
        ),
        "Qh(11,A',12,)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(1,A'',,)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(2,A'',1,)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(3,A'',1,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(4,A'',1,)": (
            "-sqrt(14)*S1/4-sqrt(2)*S3/4",
            "sqrt(35)*y*z*(y-z)*(y+z)/2",
            "[0,-I/4,0,-sqrt(7)*I/4,0,-sqrt(7)*I/4,0,-I/4,0]",
        ),
        "Qh(5,A'',1,)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(6,A'',1,)": (
            "sqrt(3)*S1/4-sqrt(30)*S3/8-sqrt(22)*S5/8",
            "3*sqrt(7)*y*z*(y-z)*(y+z)*(10*x**2-y**2-z**2)/4",
            "[0,-sqrt(11)*I/8,0,-sqrt(15)*I/8,0,sqrt(6)*I/8,0,sqrt(6)*I/8,0,-sqrt(15)*I/8,0,-sqrt(11)*I/8,0]",
        ),
        "Qh(7,A'',1,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Qh(8,A'',1,)": (
            "-sqrt(715)*S1/32-sqrt(273)*S3/32-sqrt(35)*S5/32-S7/32",
            "3*sqrt(715)*y*z*(y-z)*(y+z)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[0,-sqrt(2)*I/64,0,-sqrt(70)*I/64,0,-sqrt(546)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(546)*I/64,0,-sqrt(70)*I/64,0,-sqrt(2)*I/64,0]",
        ),
        "Qh(9,A'',1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Qh(10,A'',1,)": (
            "sqrt(221)*S1/32-sqrt(102)*S3/32-sqrt(510)*S5/32-11*sqrt(6)*S7/64-sqrt(38)*S9/64",
            "sqrt(12155)*y*z*(y-z)*(y+z)*(18*x**2-y**2-z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/32",
            "[0,-sqrt(19)*I/64,0,-11*sqrt(3)*I/64,0,-sqrt(255)*I/32,0,-sqrt(51)*I/32,0,sqrt(442)*I/64,0,sqrt(442)*I/64,0,-sqrt(51)*I/32,0,-sqrt(255)*I/32,0,-11*sqrt(3)*I/64,0,-sqrt(19)*I/64,0]",
        ),
        "Qh(11,A'',1,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Qh(2,A'',2,)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Qh(3,A'',2,)": (
            "-sqrt(6)*S1/4-sqrt(10)*S3/4",
            "-y*(3*x**2-2*y**2+3*z**2)/2",
            "[-sqrt(5)*I/4,0,-sqrt(3)*I/4,0,-sqrt(3)*I/4,0,-sqrt(5)*I/4]",
        ),
        "Qh(4,A'',2,)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(5,A'',2,)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(6,A'',2,)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(7,A'',2,)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(8,A'',2,)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(9,A'',2,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Qh(10,A'',2,)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(11,A'',2,)": (
            "S8",
            "-sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(3,A'',3,)": (
            "sqrt(10)*S1/4-sqrt(6)*S3/4",
            "-sqrt(15)*y*(x-z)*(x+z)/2",
            "[-sqrt(3)*I/4,0,sqrt(5)*I/4,0,sqrt(5)*I/4,0,-sqrt(3)*I/4]",
        ),
        "Qh(4,A'',3,)": (
            "-sqrt(2)*S1/4+sqrt(14)*S3/4",
            "sqrt(5)*y*z*(6*x**2-y**2-z**2)/2",
            "[0,sqrt(7)*I/4,0,-I/4,0,-I/4,0,sqrt(7)*I/4,0]",
        ),
        "Qh(5,A'',3,)": (
            "sqrt(15)*S1/8+sqrt(70)*S3/16+3*sqrt(14)*S5/16",
            "y*(15*x**4-40*x**2*y**2+30*x**2*z**2+8*y**4-40*y**2*z**2+15*z**4)/8",
            "[3*sqrt(7)*I/16,0,sqrt(35)*I/16,0,sqrt(30)*I/16,0,sqrt(30)*I/16,0,sqrt(35)*I/16,0,3*sqrt(7)*I/16]",
        ),
        "Qh(6,A'',3,)": (
            "3*sqrt(22)*S1/16+sqrt(55)*S3/16+sqrt(3)*S5/16",
            "sqrt(462)*y*z*(y**2-3*z**2)*(3*y**2-z**2)/16",
            "[0,sqrt(6)*I/32,0,sqrt(110)*I/32,0,3*sqrt(11)*I/16,0,3*sqrt(11)*I/16,0,sqrt(110)*I/32,0,sqrt(6)*I/32,0]",
        ),
        "Qh(7,A'',3,)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "-sqrt(77)*x*y*z*(3*x**4-20*x**2*y**2+10*x**2*z**2+3*y**4+10*y**2*z**2-6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Qh(8,A'',3,)": (
            "-sqrt(77)*S1/32+5*sqrt(15)*S3/32-3*sqrt(13)*S5/32-sqrt(455)*S7/32",
            "3*sqrt(77)*y*z*(y-z)*(y+z)*(40*x**4-24*x**2*y**2-24*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,-sqrt(910)*I/64,0,-3*sqrt(26)*I/64,0,5*sqrt(30)*I/64,0,-sqrt(154)*I/64,0,-sqrt(154)*I/64,0,5*sqrt(30)*I/64,0,-3*sqrt(26)*I/64,0,-sqrt(910)*I/64,0]",
        ),
        "Qh(9,A'',3,)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(x-y)*(x+y)*(3*x**4-11*x**2*y**2-7*x**2*z**2+3*y**4-7*y**2*z**2+7*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Qh(10,A'',3,)": (
            "sqrt(39)*S1/32-11*sqrt(2)*S3/32+5*sqrt(10)*S5/32-sqrt(34)*S7/64-sqrt(1938)*S9/64",
            "sqrt(2145)*y*z*(y-z)*(y+z)*(112*x**6-168*x**4*y**2-168*x**4*z**2+42*x**2*y**4+84*x**2*y**2*z**2+42*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,-sqrt(969)*I/64,0,-sqrt(17)*I/64,0,5*sqrt(5)*I/32,0,-11*I/32,0,sqrt(78)*I/64,0,sqrt(78)*I/64,0,-11*I/32,0,5*sqrt(5)*I/32,0,-sqrt(17)*I/64,0,-sqrt(969)*I/64,0]",
        ),
        "Qh(11,A'',3,)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "-sqrt(230945)*x*y*z*(x**8-6*x**6*y**2-6*x**6*z**2+42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2-84*x**2*y**2*z**4+12*x**2*z**6+y**8-6*y**6*z**2+12*y**2*z**6-2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Qh(4,A'',4,)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(5,A'',4,)": (
            "sqrt(21)*S1/8-9*sqrt(2)*S3/16+sqrt(10)*S5/16",
            "3*sqrt(35)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/8",
            "[sqrt(5)*I/16,0,-9*I/16,0,sqrt(42)*I/16,0,sqrt(42)*I/16,0,-9*I/16,0,sqrt(5)*I/16]",
        ),
        "Qh(6,A'',4,)": (
            "S6",
            "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(7,A'',4,)": (
            "-5*sqrt(7)*S1/32-3*sqrt(21)*S3/32-sqrt(231)*S5/32-sqrt(429)*S7/32",
            "-y*(35*x**6-210*x**4*y**2+105*x**4*z**2+168*x**2*y**4-420*x**2*y**2*z**2+105*x**2*z**4-16*y**6+168*y**4*z**2-210*y**2*z**4+35*z**6)/16",
            "[-sqrt(858)*I/64,0,-sqrt(462)*I/64,0,-3*sqrt(42)*I/64,0,-5*sqrt(14)*I/64,0,-5*sqrt(14)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(462)*I/64,0,-sqrt(858)*I/64]",
        ),
        "Qh(8,A'',4,)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(9,A'',4,)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Qh(10,A'',4,)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(11,A'',4,)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(5,A'',5,)": (
            "-sqrt(7)*S1/4-sqrt(6)*S3/8+sqrt(30)*S5/8",
            "sqrt(105)*y*(x-z)*(x+z)*(x**2-2*y**2+z**2)/4",
            "[sqrt(15)*I/8,0,-sqrt(3)*I/8,0,-sqrt(14)*I/8,0,-sqrt(14)*I/8,0,-sqrt(3)*I/8,0,sqrt(15)*I/8]",
        ),
        "Qh(6,A'',5,)": (
            "sqrt(10)*S1/16-9*S3/16+sqrt(165)*S5/16",
            "sqrt(210)*y*z*(16*x**4-16*x**2*y**2-16*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,sqrt(330)*I/32,0,-9*sqrt(2)*I/32,0,sqrt(5)*I/16,0,sqrt(5)*I/16,0,-9*sqrt(2)*I/32,0,sqrt(330)*I/32,0]",
        ),
        "Qh(7,A'',5,)": (
            "-3*sqrt(33)*S1/32+sqrt(11)*S3/32+25*S5/32-sqrt(91)*S7/32",
            "-sqrt(231)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(3*x**2-10*y**2+3*z**2)/16",
            "[-sqrt(182)*I/64,0,25*sqrt(2)*I/64,0,sqrt(22)*I/64,0,-3*sqrt(66)*I/64,0,-3*sqrt(66)*I/64,0,sqrt(22)*I/64,0,25*sqrt(2)*I/64,0,-sqrt(182)*I/64]",
        ),
        "Qh(8,A'',5,)": (
            "-sqrt(858)*S1/64+sqrt(910)*S3/64+7*sqrt(42)*S5/64+3*sqrt(30)*S7/64",
            "sqrt(858)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(14*x**2-y**2-z**2)/32",
            "[0,3*sqrt(15)*I/64,0,7*sqrt(21)*I/64,0,sqrt(455)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(455)*I/64,0,7*sqrt(21)*I/64,0,3*sqrt(15)*I/64,0]",
        ),
        "Qh(9,A'',5,)": (
            "21*sqrt(5)*S1/128+sqrt(2310)*S3/128+3*sqrt(286)*S5/128+3*sqrt(1430)*S7/256+sqrt(24310)*S9/256",
            "y*(315*x**8-3360*x**6*y**2+1260*x**6*z**2+6048*x**4*y**4-10080*x**4*y**2*z**2+1890*x**4*z**4-2304*x**2*y**6+12096*x**2*y**4*z**2-10080*x**2*y**2*z**4+1260*x**2*z**6+128*y**8-2304*y**6*z**2+6048*y**4*z**4-3360*y**2*z**6+315*z**8)/128",
            "[sqrt(12155)*I/256,0,3*sqrt(715)*I/256,0,3*sqrt(143)*I/128,0,sqrt(1155)*I/128,0,21*sqrt(10)*I/256,0,21*sqrt(10)*I/256,0,sqrt(1155)*I/128,0,3*sqrt(143)*I/128,0,3*sqrt(715)*I/256,0,sqrt(12155)*I/256]",
        ),
        "Qh(10,A'',5,)": (
            "sqrt(41990)*S1/256+sqrt(4845)*S3/128+sqrt(969)*S5/128+sqrt(285)*S7/256+sqrt(5)*S9/256",
            "sqrt(92378)*y*z*(y**4-10*y**2*z**2+5*z**4)*(5*y**4-10*y**2*z**2+z**4)/256",
            "[0,sqrt(10)*I/512,0,sqrt(570)*I/512,0,sqrt(1938)*I/256,0,sqrt(9690)*I/256,0,sqrt(20995)*I/256,0,sqrt(20995)*I/256,0,sqrt(9690)*I/256,0,sqrt(1938)*I/256,0,sqrt(570)*I/512,0,sqrt(10)*I/512,0]",
        ),
        "Qh(11,A'',5,)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "-sqrt(3003)*x*y*z*(5*x**8-150*x**6*y**2+90*x**6*z**2+336*x**4*y**4-70*x**4*y**2*z**2-168*x**4*z**4-150*x**2*y**6-70*x**2*y**4*z**2+140*x**2*y**2*z**4+60*x**2*z**6+5*y**8+90*y**6*z**2-168*y**4*z**4+60*y**2*z**6-10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Qh(6,A'',6,)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(7,A'',6,)": (
            "sqrt(858)*S1/64-3*sqrt(286)*S3/64+5*sqrt(26)*S5/64-sqrt(14)*S7/64",
            "-sqrt(6006)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)/32",
            "[-sqrt(7)*I/64,0,5*sqrt(13)*I/64,0,-3*sqrt(143)*I/64,0,sqrt(429)*I/64,0,sqrt(429)*I/64,0,-3*sqrt(143)*I/64,0,5*sqrt(13)*I/64,0,-sqrt(7)*I/64]",
        ),
        "Qh(8,A'',6,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(9,A'',6,)": (
            "sqrt(2431)*S1/128-sqrt(9282)*S3/128+5*sqrt(170)*S5/128-7*sqrt(34)*S7/256+3*sqrt(2)*S9/256",
            "3*sqrt(12155)*y*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/128",
            "[3*I/256,0,-7*sqrt(17)*I/256,0,5*sqrt(85)*I/128,0,-sqrt(4641)*I/128,0,sqrt(4862)*I/256,0,sqrt(4862)*I/256,0,-sqrt(4641)*I/128,0,5*sqrt(85)*I/128,0,-7*sqrt(17)*I/256,0,3*I/256]",
        ),
        "Qh(10,A'',6,)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(11,A'',6,)": (
            "-21*sqrt(66)*S1/512-sqrt(88179)*S11/512-sqrt(30030)*S3/512-15*sqrt(143)*S5/512-sqrt(36465)*S7/512-sqrt(46189)*S9/512",
            "-y*(693*x**10-11550*x**8*y**2+3465*x**8*z**2+36960*x**6*y**4-46200*x**6*y**2*z**2+6930*x**6*z**4-31680*x**4*y**6+110880*x**4*y**4*z**2-69300*x**4*y**2*z**4+6930*x**4*z**6+7040*x**2*y**8-63360*x**2*y**6*z**2+110880*x**2*y**4*z**4-46200*x**2*y**2*z**6+3465*x**2*z**8-256*y**10+7040*y**8*z**2-31680*y**6*z**4+36960*y**4*z**6-11550*y**2*z**8+693*z**10)/256",
            "[-sqrt(176358)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(72930)*I/1024,0,-15*sqrt(286)*I/1024,0,-sqrt(15015)*I/512,0,-21*sqrt(33)*I/512,0,-21*sqrt(33)*I/512,0,-sqrt(15015)*I/512,0,-15*sqrt(286)*I/1024,0,-sqrt(72930)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(176358)*I/1024]",
        ),
        "Qh(7,A'',7,)": (
            "15*sqrt(6)*S1/64+19*sqrt(2)*S3/64+sqrt(22)*S5/64-sqrt(2002)*S7/64",
            "-sqrt(42)*y*(x-z)*(x+z)*(15*x**4-80*x**2*y**2+30*x**2*z**2+48*y**4-80*y**2*z**2+15*z**4)/32",
            "[-sqrt(1001)*I/64,0,sqrt(11)*I/64,0,19*I/64,0,15*sqrt(3)*I/64,0,15*sqrt(3)*I/64,0,19*I/64,0,sqrt(11)*I/64,0,-sqrt(1001)*I/64]",
        ),
        "Qh(8,A'',7,)": (
            "-sqrt(70)*S1/64+3*sqrt(66)*S3/64-sqrt(1430)*S5/64+sqrt(2002)*S7/64",
            "3*sqrt(70)*y*z*(32*x**6-80*x**4*y**2-80*x**4*z**2+30*x**2*y**4+60*x**2*y**2*z**2+30*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,sqrt(1001)*I/64,0,-sqrt(715)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(35)*I/64,0,-sqrt(35)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(715)*I/64,0,sqrt(1001)*I/64,0]",
        ),
        "Qh(9,A'',7,)": (
            "sqrt(1001)*S1/64+sqrt(78)*S3/64-3*sqrt(70)*S5/64-23*sqrt(14)*S7/128+3*sqrt(238)*S9/128",
            "3*sqrt(5005)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(x**4-8*x**2*y**2+2*x**2*z**2+8*y**4-8*y**2*z**2+z**4)/64",
            "[3*sqrt(119)*I/128,0,-23*sqrt(7)*I/128,0,-3*sqrt(35)*I/64,0,sqrt(39)*I/64,0,sqrt(2002)*I/128,0,sqrt(2002)*I/128,0,sqrt(39)*I/64,0,-3*sqrt(35)*I/64,0,-23*sqrt(7)*I/128,0,3*sqrt(119)*I/128]",
        ),
        "Qh(10,A'',7,)": (
            "9*sqrt(78)*S1/256-69*S3/128-sqrt(5)*S5/128+43*sqrt(17)*S7/256+3*sqrt(969)*S9/256",
            "sqrt(4290)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(224*x**4-96*x**2*y**2-96*x**2*z**2+3*y**4+6*y**2*z**2+3*z**4)/256",
            "[0,3*sqrt(1938)*I/512,0,43*sqrt(34)*I/512,0,-sqrt(10)*I/256,0,-69*sqrt(2)*I/256,0,9*sqrt(39)*I/256,0,9*sqrt(39)*I/256,0,-69*sqrt(2)*I/256,0,-sqrt(10)*I/256,0,43*sqrt(34)*I/512,0,3*sqrt(1938)*I/512,0]",
        ),
        "Qh(11,A'',7,)": (
            "-sqrt(41990)*S1/512-sqrt(385)*S11/512+3*sqrt(4522)*S3/512+3*sqrt(4845)*S5/512-77*sqrt(19)*S7/512+39*sqrt(15)*S9/512",
            "-sqrt(692835)*y*(x**2-6*y**2+z**2)*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/256",
            "[-sqrt(770)*I/1024,0,39*sqrt(30)*I/1024,0,-77*sqrt(38)*I/1024,0,3*sqrt(9690)*I/1024,0,3*sqrt(2261)*I/512,0,-sqrt(20995)*I/512,0,-sqrt(20995)*I/512,0,3*sqrt(2261)*I/512,0,3*sqrt(9690)*I/1024,0,-77*sqrt(38)*I/1024,0,39*sqrt(30)*I/1024,0,-sqrt(770)*I/1024]",
        ),
        "Qh(8,A'',8,)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,A'',8,)": (
            "-sqrt(858)*S1/64+sqrt(91)*S3/32+5*sqrt(15)*S5/32-21*sqrt(3)*S7/64+sqrt(51)*S9/64",
            "sqrt(4290)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(3*x**2-14*y**2+3*z**2)/64",
            "[sqrt(102)*I/128,0,-21*sqrt(6)*I/128,0,5*sqrt(30)*I/64,0,sqrt(182)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(182)*I/64,0,5*sqrt(30)*I/64,0,-21*sqrt(6)*I/128,0,sqrt(102)*I/128]",
        ),
        "Qh(10,A'',8,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(11,A'',8,)": (
            "-5*sqrt(546)*S1/256-sqrt(10659)*S11/256-11*sqrt(30)*S3/256+13*sqrt(7)*S5/256+3*sqrt(1785)*S7/256+3*sqrt(2261)*S9/256",
            "-3*sqrt(1001)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(5*x**6-70*x**4*y**2+15*x**4*z**2+168*x**2*y**4-140*x**2*y**2*z**2+15*x**2*z**4-80*y**6+168*y**4*z**2-70*y**2*z**4+5*z**6)/128",
            "[-sqrt(21318)*I/512,0,3*sqrt(4522)*I/512,0,3*sqrt(3570)*I/512,0,13*sqrt(14)*I/512,0,-11*sqrt(15)*I/256,0,-5*sqrt(273)*I/256,0,-5*sqrt(273)*I/256,0,-11*sqrt(15)*I/256,0,13*sqrt(14)*I/512,0,3*sqrt(3570)*I/512,0,3*sqrt(4522)*I/512,0,-sqrt(21318)*I/512]",
        ),
        "Qh(9,A'',9,)": (
            "-7*sqrt(22)*S1/64-3*sqrt(21)*S3/32-sqrt(65)*S5/32+sqrt(13)*S7/64+3*sqrt(221)*S9/64",
            "3*sqrt(110)*y*(x-z)*(x+z)*(7*x**6-70*x**4*y**2+21*x**4*z**2+112*x**2*y**4-140*x**2*y**2*z**2+21*x**2*z**4-32*y**6+112*y**4*z**2-70*y**2*z**4+7*z**6)/64",
            "[3*sqrt(442)*I/128,0,sqrt(26)*I/128,0,-sqrt(130)*I/64,0,-3*sqrt(42)*I/64,0,-7*sqrt(11)*I/64,0,-7*sqrt(11)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(130)*I/64,0,sqrt(26)*I/128,0,3*sqrt(442)*I/128]",
        ),
        "Qh(10,A'',9,)": (
            "7*sqrt(3)*S1/128-7*sqrt(26)*S3/128+5*sqrt(130)*S5/128-7*sqrt(442)*S7/256+sqrt(25194)*S9/256",
            "sqrt(165)*y*z*(384*x**8-1792*x**6*y**2-1792*x**6*z**2+1680*x**4*y**4+3360*x**4*y**2*z**2+1680*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+7*y**8+28*y**6*z**2+42*y**4*z**4+28*y**2*z**6+7*z**8)/128",
            "[0,sqrt(12597)*I/256,0,-7*sqrt(221)*I/256,0,5*sqrt(65)*I/128,0,-7*sqrt(13)*I/128,0,7*sqrt(6)*I/256,0,7*sqrt(6)*I/256,0,-7*sqrt(13)*I/128,0,5*sqrt(65)*I/128,0,-7*sqrt(221)*I/256,0,sqrt(12597)*I/256,0]",
        ),
        "Qh(11,A'',9,)": (
            "sqrt(29393)*S1/512-sqrt(22)*S11/1024-9*sqrt(1615)*S3/512+5*sqrt(13566)*S5/1024-7*sqrt(1330)*S7/1024+9*sqrt(42)*S9/1024",
            "-sqrt(1939938)*y*(x-z)*(x+z)*(x**4-4*x**3*z-14*x**2*z**2-4*x*z**3+z**4)*(x**4+4*x**3*z-14*x**2*z**2+4*x*z**3+z**4)/512",
            "[-sqrt(11)*I/1024,0,9*sqrt(21)*I/1024,0,-7*sqrt(665)*I/1024,0,5*sqrt(6783)*I/1024,0,-9*sqrt(3230)*I/1024,0,sqrt(58786)*I/1024,0,sqrt(58786)*I/1024,0,-9*sqrt(3230)*I/1024,0,5*sqrt(6783)*I/1024,0,-7*sqrt(665)*I/1024,0,9*sqrt(21)*I/1024,0,-sqrt(11)*I/1024]",
        ),
        "Qh(10,A'',10,)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A'',10,)": (
            "15*sqrt(221)*S1/512-3*sqrt(2926)*S11/1024-sqrt(595)*S3/512-53*sqrt(102)*S5/1024-105*sqrt(10)*S7/1024+61*sqrt(114)*S9/1024",
            "-sqrt(14586)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(15*x**4-160*x**2*y**2+30*x**2*z**2+224*y**4-160*y**2*z**2+15*z**4)/512",
            "[-3*sqrt(1463)*I/1024,0,61*sqrt(57)*I/1024,0,-105*sqrt(5)*I/1024,0,-53*sqrt(51)*I/1024,0,-sqrt(1190)*I/1024,0,15*sqrt(442)*I/1024,0,15*sqrt(442)*I/1024,0,-sqrt(1190)*I/1024,0,-53*sqrt(51)*I/1024,0,-105*sqrt(5)*I/1024,0,61*sqrt(57)*I/1024,0,-3*sqrt(1463)*I/1024]",
        ),
        "Qh(11,A'',11,)": (
            "21*sqrt(130)*S1/512-sqrt(124355)*S11/512+57*sqrt(14)*S3/512+41*sqrt(15)*S5/512+17*sqrt(17)*S7/512-sqrt(4845)*S9/512",
            "-sqrt(2145)*y*(x-z)*(x+z)*(21*x**8-336*x**6*y**2+84*x**6*z**2+1008*x**4*y**4-1008*x**4*y**2*z**2+126*x**4*z**4-768*x**2*y**6+2016*x**2*y**4*z**2-1008*x**2*y**2*z**4+84*x**2*z**6+128*y**8-768*y**6*z**2+1008*y**4*z**4-336*y**2*z**6+21*z**8)/256",
            "[-sqrt(248710)*I/1024,0,-sqrt(9690)*I/1024,0,17*sqrt(34)*I/1024,0,41*sqrt(30)*I/1024,0,57*sqrt(7)*I/512,0,21*sqrt(65)*I/512,0,21*sqrt(65)*I/512,0,57*sqrt(7)*I/512,0,41*sqrt(30)*I/1024,0,17*sqrt(34)*I/1024,0,-sqrt(9690)*I/1024,0,-sqrt(248710)*I/1024]",
        ),
    },
    "C2h": {
        "Qh(0,Ag,,)": ("C0", "1", "[1]"),
        "Qh(2,Ag,1,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(4,Ag,1,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Qh(6,Ag,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Qh(8,Ag,1,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Qh(10,Ag,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Qh(2,Ag,2,)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(4,Ag,2,)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "-sqrt(15)*(x**4-12*x**2*y**2+6*x**2*z**2+y**4+6*y**2*z**2-2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Qh(6,Ag,2,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Qh(8,Ag,2,)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Qh(10,Ag,2,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Qh(2,Ag,3,)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Qh(4,Ag,3,)": ("-C2", "sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Qh(6,Ag,3,)": (
            "sqrt(14)*C0/4+sqrt(2)*C4/4",
            "-sqrt(14)*(x**6-15*x**4*z**2+15*x**2*z**4+y**6-15*y**4*z**2+15*y**2*z**4-2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Qh(8,Ag,3,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(10,Ag,3,)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "-sqrt(420189)*(22*x**10+45*x**8*y**2-1035*x**8*z**2-105*x**6*y**4-630*x**6*y**2*z**2+4935*x**6*z**4-105*x**4*y**6+3150*x**4*y**4*z**2-1575*x**4*y**2*z**4-4830*x**4*z**6+45*x**2*y**8-630*x**2*y**6*z**2-1575*x**2*y**4*z**4+1260*x**2*y**2*z**6+990*x**2*z**8+22*y**10-1035*y**8*z**2+4935*y**6*z**4-4830*y**4*z**6+990*y**2*z**8-44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Qh(4,Ag,4,)": ("sqrt(14)*C1/4-sqrt(2)*C3/4", "-sqrt(35)*x*z*(x-z)*(x+z)/2", "[0,1/4,0,-sqrt(7)/4,0,sqrt(7)/4,0,-1/4,0]"),
        "Qh(6,Ag,4,)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x-y)*(x+y)*(x**4-9*x**2*y**2-5*x**2*z**2+y**4-5*y**2*z**2+5*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Qh(8,Ag,4,)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Qh(10,Ag,4,)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(x-y)*(x+y)*(22*x**8-653*x**6*y**2-315*x**6*z**2+2602*x**4*y**4-945*x**4*y**2*z**2+1575*x**4*z**4-653*x**2*y**6-945*x**2*y**4*z**2+3150*x**2*y**2*z**4-1680*x**2*z**6+22*y**8-315*y**6*z**2+1575*y**4*z**4-1680*y**2*z**6+360*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Qh(4,Ag,5,)": (
            "-sqrt(2)*C1/4-sqrt(14)*C3/4",
            "-sqrt(5)*x*z*(x**2-6*y**2+z**2)/2",
            "[0,sqrt(7)/4,0,1/4,0,-1/4,0,-sqrt(7)/4,0]",
        ),
        "Qh(6,Ag,5,)": (
            "-sqrt(3)*C1/4-sqrt(30)*C3/8+sqrt(22)*C5/8",
            "3*sqrt(7)*x*z*(x-z)*(x+z)*(x**2-10*y**2+z**2)/4",
            "[0,-sqrt(11)/8,0,sqrt(15)/8,0,sqrt(6)/8,0,-sqrt(6)/8,0,-sqrt(15)/8,0,sqrt(11)/8,0]",
        ),
        "Qh(8,Ag,5,)": (
            "C2",
            "-3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(10,Ag,5,)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "-sqrt(3213210)*(3*x**10-96*x**8*y**2-39*x**8*z**2+224*x**6*y**4+1344*x**6*y**2*z**2-42*x**6*z**4+224*x**4*y**6-6720*x**4*y**4*z**2+3360*x**4*y**2*z**4-182*x**4*z**6-96*x**2*y**8+1344*x**2*y**6*z**2+3360*x**2*y**4*z**4-2688*x**2*y**2*z**6+135*x**2*z**8+3*y**10-39*y**8*z**2-42*y**6*z**4-182*y**4*z**6+135*y**2*z**8-6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Qh(6,Ag,6,)": (
            "3*sqrt(22)*C1/16-sqrt(55)*C3/16+sqrt(3)*C5/16",
            "sqrt(462)*x*z*(x**2-3*z**2)*(3*x**2-z**2)/16",
            "[0,-sqrt(6)/32,0,sqrt(110)/32,0,-3*sqrt(11)/16,0,3*sqrt(11)/16,0,-sqrt(110)/32,0,sqrt(6)/32,0]",
        ),
        "Qh(8,Ag,6,)": (
            "sqrt(715)*C1/32-sqrt(273)*C3/32+sqrt(35)*C5/32-C7/32",
            "-3*sqrt(715)*x*z*(x-z)*(x+z)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/16",
            "[0,sqrt(2)/64,0,-sqrt(70)/64,0,sqrt(546)/64,0,-sqrt(1430)/64,0,sqrt(1430)/64,0,-sqrt(546)/64,0,sqrt(70)/64,0,-sqrt(2)/64,0]",
        ),
        "Qh(10,Ag,6,)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(x-y)*(x+y)*(9*x**8-165*x**6*y**2-231*x**6*z**2-25*x**4*y**4+3801*x**4*y**2*z**2+406*x**4*z**4-165*x**2*y**6+3801*x**2*y**4*z**2-9674*x**2*y**2*z**4+266*x**2*z**6+9*y**8-231*y**6*z**2+406*y**4*z**4+266*y**2*z**6-57*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Qh(6,Ag,7,)": (
            "sqrt(10)*C1/16+9*C3/16+sqrt(165)*C5/16",
            "sqrt(210)*x*z*(x**4-16*x**2*y**2+2*x**2*z**2+16*y**4-16*y**2*z**2+z**4)/16",
            "[0,-sqrt(330)/32,0,-9*sqrt(2)/32,0,-sqrt(5)/16,0,sqrt(5)/16,0,9*sqrt(2)/32,0,sqrt(330)/32,0]",
        ),
        "Qh(8,Ag,7,)": (
            "sqrt(77)*C1/32+5*sqrt(15)*C3/32+3*sqrt(13)*C5/32-sqrt(455)*C7/32",
            "-3*sqrt(77)*x*z*(x-z)*(x+z)*(x**4-24*x**2*y**2+2*x**2*z**2+40*y**4-24*y**2*z**2+z**4)/16",
            "[0,sqrt(910)/64,0,-3*sqrt(26)/64,0,-5*sqrt(30)/64,0,-sqrt(154)/64,0,sqrt(154)/64,0,5*sqrt(30)/64,0,3*sqrt(26)/64,0,-sqrt(910)/64,0]",
        ),
        "Qh(10,Ag,7,)": (
            "-sqrt(221)*C1/32-sqrt(102)*C3/32+sqrt(510)*C5/32-11*sqrt(6)*C7/64+sqrt(38)*C9/64",
            "sqrt(12155)*x*z*(x-z)*(x+z)*(x**2-18*y**2+z**2)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/32",
            "[0,-sqrt(19)/64,0,11*sqrt(3)/64,0,-sqrt(255)/32,0,sqrt(51)/32,0,sqrt(442)/64,0,-sqrt(442)/64,0,-sqrt(51)/32,0,sqrt(255)/32,0,-11*sqrt(3)/64,0,sqrt(19)/64,0]",
        ),
        "Qh(8,Ag,8,)": (
            "-sqrt(858)*C1/64-sqrt(910)*C3/64+7*sqrt(42)*C5/64-3*sqrt(30)*C7/64",
            "-sqrt(858)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(x**2-14*y**2+z**2)/32",
            "[0,3*sqrt(15)/64,0,-7*sqrt(21)/64,0,sqrt(455)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-sqrt(455)/64,0,7*sqrt(21)/64,0,-3*sqrt(15)/64,0]",
        ),
        "Qh(10,Ag,8,)": (
            "-sqrt(39)*C1/32-11*sqrt(2)*C3/32-5*sqrt(10)*C5/32-sqrt(34)*C7/64+sqrt(1938)*C9/64",
            "sqrt(2145)*x*z*(x-z)*(x+z)*(x**6-42*x**4*y**2+3*x**4*z**2+168*x**2*y**4-84*x**2*y**2*z**2+3*x**2*z**4-112*y**6+168*y**4*z**2-42*y**2*z**4+z**6)/32",
            "[0,-sqrt(969)/64,0,sqrt(17)/64,0,5*sqrt(5)/32,0,11/32,0,sqrt(78)/64,0,-sqrt(78)/64,0,-11/32,0,-5*sqrt(5)/32,0,-sqrt(17)/64,0,sqrt(969)/64,0]",
        ),
        "Qh(8,Ag,9,)": (
            "-sqrt(70)*C1/64-3*sqrt(66)*C3/64-sqrt(1430)*C5/64-sqrt(2002)*C7/64",
            "-3*sqrt(70)*x*z*(x**6-30*x**4*y**2+3*x**4*z**2+80*x**2*y**4-60*x**2*y**2*z**2+3*x**2*z**4-32*y**6+80*y**4*z**2-30*y**2*z**4+z**6)/32",
            "[0,sqrt(1001)/64,0,sqrt(715)/64,0,3*sqrt(33)/64,0,sqrt(35)/64,0,-sqrt(35)/64,0,-3*sqrt(33)/64,0,-sqrt(715)/64,0,-sqrt(1001)/64,0]",
        ),
        "Qh(10,Ag,9,)": (
            "sqrt(41990)*C1/256-sqrt(4845)*C3/128+sqrt(969)*C5/128-sqrt(285)*C7/256+sqrt(5)*C9/256",
            "sqrt(92378)*x*z*(x**4-10*x**2*z**2+5*z**4)*(5*x**4-10*x**2*z**2+z**4)/256",
            "[0,-sqrt(10)/512,0,sqrt(570)/512,0,-sqrt(1938)/256,0,sqrt(9690)/256,0,-sqrt(20995)/256,0,sqrt(20995)/256,0,-sqrt(9690)/256,0,sqrt(1938)/256,0,-sqrt(570)/512,0,sqrt(10)/512,0]",
        ),
        "Qh(10,Ag,10,)": (
            "9*sqrt(78)*C1/256+69*C3/128-sqrt(5)*C5/128-43*sqrt(17)*C7/256+3*sqrt(969)*C9/256",
            "sqrt(4290)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(3*x**4-96*x**2*y**2+6*x**2*z**2+224*y**4-96*y**2*z**2+3*z**4)/256",
            "[0,-3*sqrt(1938)/512,0,43*sqrt(34)/512,0,sqrt(10)/256,0,-69*sqrt(2)/256,0,-9*sqrt(39)/256,0,9*sqrt(39)/256,0,69*sqrt(2)/256,0,-sqrt(10)/256,0,-43*sqrt(34)/512,0,3*sqrt(1938)/512,0]",
        ),
        "Qh(10,Ag,11,)": (
            "7*sqrt(3)*C1/128+7*sqrt(26)*C3/128+5*sqrt(130)*C5/128+7*sqrt(442)*C7/256+sqrt(25194)*C9/256",
            "sqrt(165)*x*z*(7*x**8-336*x**6*y**2+28*x**6*z**2+1680*x**4*y**4-1008*x**4*y**2*z**2+42*x**4*z**4-1792*x**2*y**6+3360*x**2*y**4*z**2-1008*x**2*y**2*z**4+28*x**2*z**6+384*y**8-1792*y**6*z**2+1680*y**4*z**4-336*y**2*z**6+7*z**8)/128",
            "[0,-sqrt(12597)/256,0,-7*sqrt(221)/256,0,-5*sqrt(65)/128,0,-7*sqrt(13)/128,0,-7*sqrt(6)/256,0,7*sqrt(6)/256,0,7*sqrt(13)/128,0,5*sqrt(65)/128,0,7*sqrt(221)/256,0,sqrt(12597)/256,0]",
        ),
        "Qh(1,Au,,)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(3,Au,1,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(5,Au,1,)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(7,Au,1,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Qh(9,Au,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Qh(11,Au,1,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Qh(3,Au,2,)": (
            "-sqrt(6)*S1/4-sqrt(10)*S3/4",
            "-y*(3*x**2-2*y**2+3*z**2)/2",
            "[-sqrt(5)*I/4,0,-sqrt(3)*I/4,0,-sqrt(3)*I/4,0,-sqrt(5)*I/4]",
        ),
        "Qh(5,Au,2,)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(7,Au,2,)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(9,Au,2,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Qh(11,Au,2,)": (
            "S8",
            "-sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(3,Au,3,)": (
            "sqrt(10)*S1/4-sqrt(6)*S3/4",
            "-sqrt(15)*y*(x-z)*(x+z)/2",
            "[-sqrt(3)*I/4,0,sqrt(5)*I/4,0,sqrt(5)*I/4,0,-sqrt(3)*I/4]",
        ),
        "Qh(5,Au,3,)": (
            "sqrt(15)*S1/8+sqrt(70)*S3/16+3*sqrt(14)*S5/16",
            "y*(15*x**4-40*x**2*y**2+30*x**2*z**2+8*y**4-40*y**2*z**2+15*z**4)/8",
            "[3*sqrt(7)*I/16,0,sqrt(35)*I/16,0,sqrt(30)*I/16,0,sqrt(30)*I/16,0,sqrt(35)*I/16,0,3*sqrt(7)*I/16]",
        ),
        "Qh(7,Au,3,)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "-sqrt(77)*x*y*z*(3*x**4-20*x**2*y**2+10*x**2*z**2+3*y**4+10*y**2*z**2-6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Qh(9,Au,3,)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(x-y)*(x+y)*(3*x**4-11*x**2*y**2-7*x**2*z**2+3*y**4-7*y**2*z**2+7*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Qh(11,Au,3,)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "-sqrt(230945)*x*y*z*(x**8-6*x**6*y**2-6*x**6*z**2+42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2-84*x**2*y**2*z**4+12*x**2*z**6+y**8-6*y**6*z**2+12*y**2*z**6-2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Qh(5,Au,4,)": (
            "sqrt(21)*S1/8-9*sqrt(2)*S3/16+sqrt(10)*S5/16",
            "3*sqrt(35)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/8",
            "[sqrt(5)*I/16,0,-9*I/16,0,sqrt(42)*I/16,0,sqrt(42)*I/16,0,-9*I/16,0,sqrt(5)*I/16]",
        ),
        "Qh(7,Au,4,)": (
            "-5*sqrt(7)*S1/32-3*sqrt(21)*S3/32-sqrt(231)*S5/32-sqrt(429)*S7/32",
            "-y*(35*x**6-210*x**4*y**2+105*x**4*z**2+168*x**2*y**4-420*x**2*y**2*z**2+105*x**2*z**4-16*y**6+168*y**4*z**2-210*y**2*z**4+35*z**6)/16",
            "[-sqrt(858)*I/64,0,-sqrt(462)*I/64,0,-3*sqrt(42)*I/64,0,-5*sqrt(14)*I/64,0,-5*sqrt(14)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(462)*I/64,0,-sqrt(858)*I/64]",
        ),
        "Qh(9,Au,4,)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Qh(11,Au,4,)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(5,Au,5,)": (
            "-sqrt(7)*S1/4-sqrt(6)*S3/8+sqrt(30)*S5/8",
            "sqrt(105)*y*(x-z)*(x+z)*(x**2-2*y**2+z**2)/4",
            "[sqrt(15)*I/8,0,-sqrt(3)*I/8,0,-sqrt(14)*I/8,0,-sqrt(14)*I/8,0,-sqrt(3)*I/8,0,sqrt(15)*I/8]",
        ),
        "Qh(7,Au,5,)": (
            "-3*sqrt(33)*S1/32+sqrt(11)*S3/32+25*S5/32-sqrt(91)*S7/32",
            "-sqrt(231)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(3*x**2-10*y**2+3*z**2)/16",
            "[-sqrt(182)*I/64,0,25*sqrt(2)*I/64,0,sqrt(22)*I/64,0,-3*sqrt(66)*I/64,0,-3*sqrt(66)*I/64,0,sqrt(22)*I/64,0,25*sqrt(2)*I/64,0,-sqrt(182)*I/64]",
        ),
        "Qh(9,Au,5,)": (
            "21*sqrt(5)*S1/128+sqrt(2310)*S3/128+3*sqrt(286)*S5/128+3*sqrt(1430)*S7/256+sqrt(24310)*S9/256",
            "y*(315*x**8-3360*x**6*y**2+1260*x**6*z**2+6048*x**4*y**4-10080*x**4*y**2*z**2+1890*x**4*z**4-2304*x**2*y**6+12096*x**2*y**4*z**2-10080*x**2*y**2*z**4+1260*x**2*z**6+128*y**8-2304*y**6*z**2+6048*y**4*z**4-3360*y**2*z**6+315*z**8)/128",
            "[sqrt(12155)*I/256,0,3*sqrt(715)*I/256,0,3*sqrt(143)*I/128,0,sqrt(1155)*I/128,0,21*sqrt(10)*I/256,0,21*sqrt(10)*I/256,0,sqrt(1155)*I/128,0,3*sqrt(143)*I/128,0,3*sqrt(715)*I/256,0,sqrt(12155)*I/256]",
        ),
        "Qh(11,Au,5,)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "-sqrt(3003)*x*y*z*(5*x**8-150*x**6*y**2+90*x**6*z**2+336*x**4*y**4-70*x**4*y**2*z**2-168*x**4*z**4-150*x**2*y**6-70*x**2*y**4*z**2+140*x**2*y**2*z**4+60*x**2*z**6+5*y**8+90*y**6*z**2-168*y**4*z**4+60*y**2*z**6-10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Qh(7,Au,6,)": (
            "sqrt(858)*S1/64-3*sqrt(286)*S3/64+5*sqrt(26)*S5/64-sqrt(14)*S7/64",
            "-sqrt(6006)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)/32",
            "[-sqrt(7)*I/64,0,5*sqrt(13)*I/64,0,-3*sqrt(143)*I/64,0,sqrt(429)*I/64,0,sqrt(429)*I/64,0,-3*sqrt(143)*I/64,0,5*sqrt(13)*I/64,0,-sqrt(7)*I/64]",
        ),
        "Qh(9,Au,6,)": (
            "sqrt(2431)*S1/128-sqrt(9282)*S3/128+5*sqrt(170)*S5/128-7*sqrt(34)*S7/256+3*sqrt(2)*S9/256",
            "3*sqrt(12155)*y*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/128",
            "[3*I/256,0,-7*sqrt(17)*I/256,0,5*sqrt(85)*I/128,0,-sqrt(4641)*I/128,0,sqrt(4862)*I/256,0,sqrt(4862)*I/256,0,-sqrt(4641)*I/128,0,5*sqrt(85)*I/128,0,-7*sqrt(17)*I/256,0,3*I/256]",
        ),
        "Qh(11,Au,6,)": (
            "-21*sqrt(66)*S1/512-sqrt(88179)*S11/512-sqrt(30030)*S3/512-15*sqrt(143)*S5/512-sqrt(36465)*S7/512-sqrt(46189)*S9/512",
            "-y*(693*x**10-11550*x**8*y**2+3465*x**8*z**2+36960*x**6*y**4-46200*x**6*y**2*z**2+6930*x**6*z**4-31680*x**4*y**6+110880*x**4*y**4*z**2-69300*x**4*y**2*z**4+6930*x**4*z**6+7040*x**2*y**8-63360*x**2*y**6*z**2+110880*x**2*y**4*z**4-46200*x**2*y**2*z**6+3465*x**2*z**8-256*y**10+7040*y**8*z**2-31680*y**6*z**4+36960*y**4*z**6-11550*y**2*z**8+693*z**10)/256",
            "[-sqrt(176358)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(72930)*I/1024,0,-15*sqrt(286)*I/1024,0,-sqrt(15015)*I/512,0,-21*sqrt(33)*I/512,0,-21*sqrt(33)*I/512,0,-sqrt(15015)*I/512,0,-15*sqrt(286)*I/1024,0,-sqrt(72930)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(176358)*I/1024]",
        ),
        "Qh(7,Au,7,)": (
            "15*sqrt(6)*S1/64+19*sqrt(2)*S3/64+sqrt(22)*S5/64-sqrt(2002)*S7/64",
            "-sqrt(42)*y*(x-z)*(x+z)*(15*x**4-80*x**2*y**2+30*x**2*z**2+48*y**4-80*y**2*z**2+15*z**4)/32",
            "[-sqrt(1001)*I/64,0,sqrt(11)*I/64,0,19*I/64,0,15*sqrt(3)*I/64,0,15*sqrt(3)*I/64,0,19*I/64,0,sqrt(11)*I/64,0,-sqrt(1001)*I/64]",
        ),
        "Qh(9,Au,7,)": (
            "sqrt(1001)*S1/64+sqrt(78)*S3/64-3*sqrt(70)*S5/64-23*sqrt(14)*S7/128+3*sqrt(238)*S9/128",
            "3*sqrt(5005)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(x**4-8*x**2*y**2+2*x**2*z**2+8*y**4-8*y**2*z**2+z**4)/64",
            "[3*sqrt(119)*I/128,0,-23*sqrt(7)*I/128,0,-3*sqrt(35)*I/64,0,sqrt(39)*I/64,0,sqrt(2002)*I/128,0,sqrt(2002)*I/128,0,sqrt(39)*I/64,0,-3*sqrt(35)*I/64,0,-23*sqrt(7)*I/128,0,3*sqrt(119)*I/128]",
        ),
        "Qh(11,Au,7,)": (
            "-sqrt(41990)*S1/512-sqrt(385)*S11/512+3*sqrt(4522)*S3/512+3*sqrt(4845)*S5/512-77*sqrt(19)*S7/512+39*sqrt(15)*S9/512",
            "-sqrt(692835)*y*(x**2-6*y**2+z**2)*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/256",
            "[-sqrt(770)*I/1024,0,39*sqrt(30)*I/1024,0,-77*sqrt(38)*I/1024,0,3*sqrt(9690)*I/1024,0,3*sqrt(2261)*I/512,0,-sqrt(20995)*I/512,0,-sqrt(20995)*I/512,0,3*sqrt(2261)*I/512,0,3*sqrt(9690)*I/1024,0,-77*sqrt(38)*I/1024,0,39*sqrt(30)*I/1024,0,-sqrt(770)*I/1024]",
        ),
        "Qh(9,Au,8,)": (
            "-sqrt(858)*S1/64+sqrt(91)*S3/32+5*sqrt(15)*S5/32-21*sqrt(3)*S7/64+sqrt(51)*S9/64",
            "sqrt(4290)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(3*x**2-14*y**2+3*z**2)/64",
            "[sqrt(102)*I/128,0,-21*sqrt(6)*I/128,0,5*sqrt(30)*I/64,0,sqrt(182)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(182)*I/64,0,5*sqrt(30)*I/64,0,-21*sqrt(6)*I/128,0,sqrt(102)*I/128]",
        ),
        "Qh(11,Au,8,)": (
            "-5*sqrt(546)*S1/256-sqrt(10659)*S11/256-11*sqrt(30)*S3/256+13*sqrt(7)*S5/256+3*sqrt(1785)*S7/256+3*sqrt(2261)*S9/256",
            "-3*sqrt(1001)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(5*x**6-70*x**4*y**2+15*x**4*z**2+168*x**2*y**4-140*x**2*y**2*z**2+15*x**2*z**4-80*y**6+168*y**4*z**2-70*y**2*z**4+5*z**6)/128",
            "[-sqrt(21318)*I/512,0,3*sqrt(4522)*I/512,0,3*sqrt(3570)*I/512,0,13*sqrt(14)*I/512,0,-11*sqrt(15)*I/256,0,-5*sqrt(273)*I/256,0,-5*sqrt(273)*I/256,0,-11*sqrt(15)*I/256,0,13*sqrt(14)*I/512,0,3*sqrt(3570)*I/512,0,3*sqrt(4522)*I/512,0,-sqrt(21318)*I/512]",
        ),
        "Qh(9,Au,9,)": (
            "-7*sqrt(22)*S1/64-3*sqrt(21)*S3/32-sqrt(65)*S5/32+sqrt(13)*S7/64+3*sqrt(221)*S9/64",
            "3*sqrt(110)*y*(x-z)*(x+z)*(7*x**6-70*x**4*y**2+21*x**4*z**2+112*x**2*y**4-140*x**2*y**2*z**2+21*x**2*z**4-32*y**6+112*y**4*z**2-70*y**2*z**4+7*z**6)/64",
            "[3*sqrt(442)*I/128,0,sqrt(26)*I/128,0,-sqrt(130)*I/64,0,-3*sqrt(42)*I/64,0,-7*sqrt(11)*I/64,0,-7*sqrt(11)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(130)*I/64,0,sqrt(26)*I/128,0,3*sqrt(442)*I/128]",
        ),
        "Qh(11,Au,9,)": (
            "sqrt(29393)*S1/512-sqrt(22)*S11/1024-9*sqrt(1615)*S3/512+5*sqrt(13566)*S5/1024-7*sqrt(1330)*S7/1024+9*sqrt(42)*S9/1024",
            "-sqrt(1939938)*y*(x-z)*(x+z)*(x**4-4*x**3*z-14*x**2*z**2-4*x*z**3+z**4)*(x**4+4*x**3*z-14*x**2*z**2+4*x*z**3+z**4)/512",
            "[-sqrt(11)*I/1024,0,9*sqrt(21)*I/1024,0,-7*sqrt(665)*I/1024,0,5*sqrt(6783)*I/1024,0,-9*sqrt(3230)*I/1024,0,sqrt(58786)*I/1024,0,sqrt(58786)*I/1024,0,-9*sqrt(3230)*I/1024,0,5*sqrt(6783)*I/1024,0,-7*sqrt(665)*I/1024,0,9*sqrt(21)*I/1024,0,-sqrt(11)*I/1024]",
        ),
        "Qh(11,Au,10,)": (
            "15*sqrt(221)*S1/512-3*sqrt(2926)*S11/1024-sqrt(595)*S3/512-53*sqrt(102)*S5/1024-105*sqrt(10)*S7/1024+61*sqrt(114)*S9/1024",
            "-sqrt(14586)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(15*x**4-160*x**2*y**2+30*x**2*z**2+224*y**4-160*y**2*z**2+15*z**4)/512",
            "[-3*sqrt(1463)*I/1024,0,61*sqrt(57)*I/1024,0,-105*sqrt(5)*I/1024,0,-53*sqrt(51)*I/1024,0,-sqrt(1190)*I/1024,0,15*sqrt(442)*I/1024,0,15*sqrt(442)*I/1024,0,-sqrt(1190)*I/1024,0,-53*sqrt(51)*I/1024,0,-105*sqrt(5)*I/1024,0,61*sqrt(57)*I/1024,0,-3*sqrt(1463)*I/1024]",
        ),
        "Qh(11,Au,11,)": (
            "21*sqrt(130)*S1/512-sqrt(124355)*S11/512+57*sqrt(14)*S3/512+41*sqrt(15)*S5/512+17*sqrt(17)*S7/512-sqrt(4845)*S9/512",
            "-sqrt(2145)*y*(x-z)*(x+z)*(21*x**8-336*x**6*y**2+84*x**6*z**2+1008*x**4*y**4-1008*x**4*y**2*z**2+126*x**4*z**4-768*x**2*y**6+2016*x**2*y**4*z**2-1008*x**2*y**2*z**4+84*x**2*z**6+128*y**8-768*y**6*z**2+1008*y**4*z**4-336*y**2*z**6+21*z**8)/256",
            "[-sqrt(248710)*I/1024,0,-sqrt(9690)*I/1024,0,17*sqrt(34)*I/1024,0,41*sqrt(30)*I/1024,0,57*sqrt(7)*I/512,0,21*sqrt(65)*I/512,0,21*sqrt(65)*I/512,0,57*sqrt(7)*I/512,0,41*sqrt(30)*I/1024,0,17*sqrt(34)*I/1024,0,-sqrt(9690)*I/1024,0,-sqrt(248710)*I/1024]",
        ),
        "Qh(2,Bg,1,)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(4,Bg,1,)": (
            "-sqrt(14)*S1/4-sqrt(2)*S3/4",
            "sqrt(35)*y*z*(y-z)*(y+z)/2",
            "[0,-I/4,0,-sqrt(7)*I/4,0,-sqrt(7)*I/4,0,-I/4,0]",
        ),
        "Qh(6,Bg,1,)": (
            "sqrt(3)*S1/4-sqrt(30)*S3/8-sqrt(22)*S5/8",
            "3*sqrt(7)*y*z*(y-z)*(y+z)*(10*x**2-y**2-z**2)/4",
            "[0,-sqrt(11)*I/8,0,-sqrt(15)*I/8,0,sqrt(6)*I/8,0,sqrt(6)*I/8,0,-sqrt(15)*I/8,0,-sqrt(11)*I/8,0]",
        ),
        "Qh(8,Bg,1,)": (
            "-sqrt(715)*S1/32-sqrt(273)*S3/32-sqrt(35)*S5/32-S7/32",
            "3*sqrt(715)*y*z*(y-z)*(y+z)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[0,-sqrt(2)*I/64,0,-sqrt(70)*I/64,0,-sqrt(546)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(546)*I/64,0,-sqrt(70)*I/64,0,-sqrt(2)*I/64,0]",
        ),
        "Qh(10,Bg,1,)": (
            "sqrt(221)*S1/32-sqrt(102)*S3/32-sqrt(510)*S5/32-11*sqrt(6)*S7/64-sqrt(38)*S9/64",
            "sqrt(12155)*y*z*(y-z)*(y+z)*(18*x**2-y**2-z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/32",
            "[0,-sqrt(19)*I/64,0,-11*sqrt(3)*I/64,0,-sqrt(255)*I/32,0,-sqrt(51)*I/32,0,sqrt(442)*I/64,0,sqrt(442)*I/64,0,-sqrt(51)*I/32,0,-sqrt(255)*I/32,0,-11*sqrt(3)*I/64,0,-sqrt(19)*I/64,0]",
        ),
        "Qh(2,Bg,2,)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Qh(4,Bg,2,)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(6,Bg,2,)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(8,Bg,2,)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(10,Bg,2,)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(4,Bg,3,)": (
            "-sqrt(2)*S1/4+sqrt(14)*S3/4",
            "sqrt(5)*y*z*(6*x**2-y**2-z**2)/2",
            "[0,sqrt(7)*I/4,0,-I/4,0,-I/4,0,sqrt(7)*I/4,0]",
        ),
        "Qh(6,Bg,3,)": (
            "3*sqrt(22)*S1/16+sqrt(55)*S3/16+sqrt(3)*S5/16",
            "sqrt(462)*y*z*(y**2-3*z**2)*(3*y**2-z**2)/16",
            "[0,sqrt(6)*I/32,0,sqrt(110)*I/32,0,3*sqrt(11)*I/16,0,3*sqrt(11)*I/16,0,sqrt(110)*I/32,0,sqrt(6)*I/32,0]",
        ),
        "Qh(8,Bg,3,)": (
            "-sqrt(77)*S1/32+5*sqrt(15)*S3/32-3*sqrt(13)*S5/32-sqrt(455)*S7/32",
            "3*sqrt(77)*y*z*(y-z)*(y+z)*(40*x**4-24*x**2*y**2-24*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,-sqrt(910)*I/64,0,-3*sqrt(26)*I/64,0,5*sqrt(30)*I/64,0,-sqrt(154)*I/64,0,-sqrt(154)*I/64,0,5*sqrt(30)*I/64,0,-3*sqrt(26)*I/64,0,-sqrt(910)*I/64,0]",
        ),
        "Qh(10,Bg,3,)": (
            "sqrt(39)*S1/32-11*sqrt(2)*S3/32+5*sqrt(10)*S5/32-sqrt(34)*S7/64-sqrt(1938)*S9/64",
            "sqrt(2145)*y*z*(y-z)*(y+z)*(112*x**6-168*x**4*y**2-168*x**4*z**2+42*x**2*y**4+84*x**2*y**2*z**2+42*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,-sqrt(969)*I/64,0,-sqrt(17)*I/64,0,5*sqrt(5)*I/32,0,-11*I/32,0,sqrt(78)*I/64,0,sqrt(78)*I/64,0,-11*I/32,0,5*sqrt(5)*I/32,0,-sqrt(17)*I/64,0,-sqrt(969)*I/64,0]",
        ),
        "Qh(4,Bg,4,)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(6,Bg,4,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(8,Bg,4,)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,Bg,4,)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(6,Bg,5,)": (
            "sqrt(10)*S1/16-9*S3/16+sqrt(165)*S5/16",
            "sqrt(210)*y*z*(16*x**4-16*x**2*y**2-16*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,sqrt(330)*I/32,0,-9*sqrt(2)*I/32,0,sqrt(5)*I/16,0,sqrt(5)*I/16,0,-9*sqrt(2)*I/32,0,sqrt(330)*I/32,0]",
        ),
        "Qh(8,Bg,5,)": (
            "-sqrt(858)*S1/64+sqrt(910)*S3/64+7*sqrt(42)*S5/64+3*sqrt(30)*S7/64",
            "sqrt(858)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(14*x**2-y**2-z**2)/32",
            "[0,3*sqrt(15)*I/64,0,7*sqrt(21)*I/64,0,sqrt(455)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(455)*I/64,0,7*sqrt(21)*I/64,0,3*sqrt(15)*I/64,0]",
        ),
        "Qh(10,Bg,5,)": (
            "sqrt(41990)*S1/256+sqrt(4845)*S3/128+sqrt(969)*S5/128+sqrt(285)*S7/256+sqrt(5)*S9/256",
            "sqrt(92378)*y*z*(y**4-10*y**2*z**2+5*z**4)*(5*y**4-10*y**2*z**2+z**4)/256",
            "[0,sqrt(10)*I/512,0,sqrt(570)*I/512,0,sqrt(1938)*I/256,0,sqrt(9690)*I/256,0,sqrt(20995)*I/256,0,sqrt(20995)*I/256,0,sqrt(9690)*I/256,0,sqrt(1938)*I/256,0,sqrt(570)*I/512,0,sqrt(10)*I/512,0]",
        ),
        "Qh(6,Bg,6,)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(8,Bg,6,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(10,Bg,6,)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(8,Bg,7,)": (
            "-sqrt(70)*S1/64+3*sqrt(66)*S3/64-sqrt(1430)*S5/64+sqrt(2002)*S7/64",
            "3*sqrt(70)*y*z*(32*x**6-80*x**4*y**2-80*x**4*z**2+30*x**2*y**4+60*x**2*y**2*z**2+30*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,sqrt(1001)*I/64,0,-sqrt(715)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(35)*I/64,0,-sqrt(35)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(715)*I/64,0,sqrt(1001)*I/64,0]",
        ),
        "Qh(10,Bg,7,)": (
            "9*sqrt(78)*S1/256-69*S3/128-sqrt(5)*S5/128+43*sqrt(17)*S7/256+3*sqrt(969)*S9/256",
            "sqrt(4290)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(224*x**4-96*x**2*y**2-96*x**2*z**2+3*y**4+6*y**2*z**2+3*z**4)/256",
            "[0,3*sqrt(1938)*I/512,0,43*sqrt(34)*I/512,0,-sqrt(10)*I/256,0,-69*sqrt(2)*I/256,0,9*sqrt(39)*I/256,0,9*sqrt(39)*I/256,0,-69*sqrt(2)*I/256,0,-sqrt(10)*I/256,0,43*sqrt(34)*I/512,0,3*sqrt(1938)*I/512,0]",
        ),
        "Qh(8,Bg,8,)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(10,Bg,8,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,Bg,9,)": (
            "7*sqrt(3)*S1/128-7*sqrt(26)*S3/128+5*sqrt(130)*S5/128-7*sqrt(442)*S7/256+sqrt(25194)*S9/256",
            "sqrt(165)*y*z*(384*x**8-1792*x**6*y**2-1792*x**6*z**2+1680*x**4*y**4+3360*x**4*y**2*z**2+1680*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+7*y**8+28*y**6*z**2+42*y**4*z**4+28*y**2*z**6+7*z**8)/128",
            "[0,sqrt(12597)*I/256,0,-7*sqrt(221)*I/256,0,5*sqrt(65)*I/128,0,-7*sqrt(13)*I/128,0,7*sqrt(6)*I/256,0,7*sqrt(6)*I/256,0,-7*sqrt(13)*I/128,0,5*sqrt(65)*I/128,0,-7*sqrt(221)*I/256,0,sqrt(12597)*I/256,0]",
        ),
        "Qh(10,Bg,10,)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(1,Bu,1,)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(3,Bu,1,)": (
            "-sqrt(6)*C1/4+sqrt(10)*C3/4",
            "x*(2*x**2-3*y**2-3*z**2)/2",
            "[-sqrt(5)/4,0,sqrt(3)/4,0,-sqrt(3)/4,0,sqrt(5)/4]",
        ),
        "Qh(5,Bu,1,)": (
            "sqrt(15)*C1/8-sqrt(70)*C3/16+3*sqrt(14)*C5/16",
            "x*(8*x**4-40*x**2*y**2-40*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/8",
            "[-3*sqrt(7)/16,0,sqrt(35)/16,0,-sqrt(30)/16,0,sqrt(30)/16,0,-sqrt(35)/16,0,3*sqrt(7)/16]",
        ),
        "Qh(7,Bu,1,)": (
            "-5*sqrt(7)*C1/32+3*sqrt(21)*C3/32-sqrt(231)*C5/32+sqrt(429)*C7/32",
            "x*(16*x**6-168*x**4*y**2-168*x**4*z**2+210*x**2*y**4+420*x**2*y**2*z**2+210*x**2*z**4-35*y**6-105*y**4*z**2-105*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)/64,0,sqrt(462)/64,0,-3*sqrt(42)/64,0,5*sqrt(14)/64,0,-5*sqrt(14)/64,0,3*sqrt(42)/64,0,-sqrt(462)/64,0,sqrt(858)/64]",
        ),
        "Qh(9,Bu,1,)": (
            "21*sqrt(5)*C1/128-sqrt(2310)*C3/128+3*sqrt(286)*C5/128-3*sqrt(1430)*C7/256+sqrt(24310)*C9/256",
            "x*(128*x**8-2304*x**6*y**2-2304*x**6*z**2+6048*x**4*y**4+12096*x**4*y**2*z**2+6048*x**4*z**4-3360*x**2*y**6-10080*x**2*y**4*z**2-10080*x**2*y**2*z**4-3360*x**2*z**6+315*y**8+1260*y**6*z**2+1890*y**4*z**4+1260*y**2*z**6+315*z**8)/128",
            "[-sqrt(12155)/256,0,3*sqrt(715)/256,0,-3*sqrt(143)/128,0,sqrt(1155)/128,0,-21*sqrt(10)/256,0,21*sqrt(10)/256,0,-sqrt(1155)/128,0,3*sqrt(143)/128,0,-3*sqrt(715)/256,0,sqrt(12155)/256]",
        ),
        "Qh(11,Bu,1,)": (
            "-21*sqrt(66)*C1/512+sqrt(88179)*C11/512+sqrt(30030)*C3/512-15*sqrt(143)*C5/512+sqrt(36465)*C7/512-sqrt(46189)*C9/512",
            "x*(256*x**10-7040*x**8*y**2-7040*x**8*z**2+31680*x**6*y**4+63360*x**6*y**2*z**2+31680*x**6*z**4-36960*x**4*y**6-110880*x**4*y**4*z**2-110880*x**4*y**2*z**4-36960*x**4*z**6+11550*x**2*y**8+46200*x**2*y**6*z**2+69300*x**2*y**4*z**4+46200*x**2*y**2*z**6+11550*x**2*z**8-693*y**10-3465*y**8*z**2-6930*y**6*z**4-6930*y**4*z**6-3465*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)/1024,0,sqrt(92378)/1024,0,-sqrt(72930)/1024,0,15*sqrt(286)/1024,0,-sqrt(15015)/512,0,21*sqrt(33)/512,0,-21*sqrt(33)/512,0,sqrt(15015)/512,0,-15*sqrt(286)/1024,0,sqrt(72930)/1024,0,-sqrt(92378)/1024,0,sqrt(176358)/1024]",
        ),
        "Qh(1,Bu,2,)": ("C0", "z", "[0,1,0]"),
        "Qh(3,Bu,2,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(5,Bu,2,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(7,Bu,2,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Bu,2,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Bu,2,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(3,Bu,3,)": (
            "-sqrt(10)*C1/4-sqrt(6)*C3/4",
            "sqrt(15)*x*(y-z)*(y+z)/2",
            "[sqrt(3)/4,0,sqrt(5)/4,0,-sqrt(5)/4,0,-sqrt(3)/4]",
        ),
        "Qh(5,Bu,3,)": (
            "sqrt(21)*C1/8+9*sqrt(2)*C3/16+sqrt(10)*C5/16",
            "3*sqrt(35)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/8",
            "[-sqrt(5)/16,0,-9/16,0,-sqrt(42)/16,0,sqrt(42)/16,0,9/16,0,sqrt(5)/16]",
        ),
        "Qh(7,Bu,3,)": (
            "-3*sqrt(33)*C1/32-sqrt(11)*C3/32+25*C5/32+sqrt(91)*C7/32",
            "sqrt(231)*x*(10*x**2-3*y**2-3*z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[-sqrt(182)/64,0,-25*sqrt(2)/64,0,sqrt(22)/64,0,3*sqrt(66)/64,0,-3*sqrt(66)/64,0,-sqrt(22)/64,0,25*sqrt(2)/64,0,sqrt(182)/64]",
        ),
        "Qh(9,Bu,3,)": (
            "sqrt(2431)*C1/128+sqrt(9282)*C3/128+5*sqrt(170)*C5/128+7*sqrt(34)*C7/256+3*sqrt(2)*C9/256",
            "3*sqrt(12155)*x*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/128",
            "[-3/256,0,-7*sqrt(17)/256,0,-5*sqrt(85)/128,0,-sqrt(4641)/128,0,-sqrt(4862)/256,0,sqrt(4862)/256,0,sqrt(4641)/128,0,5*sqrt(85)/128,0,7*sqrt(17)/256,0,3/256]",
        ),
        "Qh(11,Bu,3,)": (
            "-sqrt(41990)*C1/512+sqrt(385)*C11/512-3*sqrt(4522)*C3/512+3*sqrt(4845)*C5/512+77*sqrt(19)*C7/512+39*sqrt(15)*C9/512",
            "sqrt(692835)*x*(6*x**2-y**2-z**2)*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/256",
            "[-sqrt(770)/1024,0,-39*sqrt(30)/1024,0,-77*sqrt(38)/1024,0,-3*sqrt(9690)/1024,0,3*sqrt(2261)/512,0,sqrt(20995)/512,0,-sqrt(20995)/512,0,-3*sqrt(2261)/512,0,3*sqrt(9690)/1024,0,77*sqrt(38)/1024,0,39*sqrt(30)/1024,0,sqrt(770)/1024]",
        ),
        "Qh(3,Bu,4,)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(5,Bu,4,)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(7,Bu,4,)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,Bu,4,)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(11,Bu,4,)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(5,Bu,5,)": (
            "sqrt(7)*C1/4-sqrt(6)*C3/8-sqrt(30)*C5/8",
            "sqrt(105)*x*(y-z)*(y+z)*(2*x**2-y**2-z**2)/4",
            "[sqrt(15)/8,0,sqrt(3)/8,0,-sqrt(14)/8,0,sqrt(14)/8,0,-sqrt(3)/8,0,-sqrt(15)/8]",
        ),
        "Qh(7,Bu,5,)": (
            "-sqrt(858)*C1/64-3*sqrt(286)*C3/64-5*sqrt(26)*C5/64-sqrt(14)*C7/64",
            "sqrt(6006)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/32",
            "[sqrt(7)/64,0,5*sqrt(13)/64,0,3*sqrt(143)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-3*sqrt(143)/64,0,-5*sqrt(13)/64,0,-sqrt(7)/64]",
        ),
        "Qh(9,Bu,5,)": (
            "sqrt(1001)*C1/64-sqrt(78)*C3/64-3*sqrt(70)*C5/64+23*sqrt(14)*C7/128+3*sqrt(238)*C9/128",
            "3*sqrt(5005)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(8*x**4-8*x**2*y**2-8*x**2*z**2+y**4+2*y**2*z**2+z**4)/64",
            "[-3*sqrt(119)/128,0,-23*sqrt(7)/128,0,3*sqrt(35)/64,0,sqrt(39)/64,0,-sqrt(2002)/128,0,sqrt(2002)/128,0,-sqrt(39)/64,0,-3*sqrt(35)/64,0,23*sqrt(7)/128,0,3*sqrt(119)/128]",
        ),
        "Qh(11,Bu,5,)": (
            "-5*sqrt(546)*C1/256+sqrt(10659)*C11/256+11*sqrt(30)*C3/256+13*sqrt(7)*C5/256-3*sqrt(1785)*C7/256+3*sqrt(2261)*C9/256",
            "3*sqrt(1001)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(80*x**6-168*x**4*y**2-168*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-5*y**6-15*y**4*z**2-15*y**2*z**4-5*z**6)/128",
            "[-sqrt(21318)/512,0,-3*sqrt(4522)/512,0,3*sqrt(3570)/512,0,-13*sqrt(14)/512,0,-11*sqrt(15)/256,0,5*sqrt(273)/256,0,-5*sqrt(273)/256,0,11*sqrt(15)/256,0,13*sqrt(14)/512,0,-3*sqrt(3570)/512,0,3*sqrt(4522)/512,0,sqrt(21318)/512]",
        ),
        "Qh(5,Bu,6,)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(7,Bu,6,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,Bu,6,)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,Bu,6,)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(7,Bu,7,)": (
            "-15*sqrt(6)*C1/64+19*sqrt(2)*C3/64-sqrt(22)*C5/64-sqrt(2002)*C7/64",
            "sqrt(42)*x*(y-z)*(y+z)*(48*x**4-80*x**2*y**2-80*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/32",
            "[sqrt(1001)/64,0,sqrt(11)/64,0,-19/64,0,15*sqrt(3)/64,0,-15*sqrt(3)/64,0,19/64,0,-sqrt(11)/64,0,-sqrt(1001)/64]",
        ),
        "Qh(9,Bu,7,)": (
            "sqrt(858)*C1/64+sqrt(91)*C3/32-5*sqrt(15)*C5/32-21*sqrt(3)*C7/64-sqrt(51)*C9/64",
            "sqrt(4290)*x*(y-z)*(y+z)*(14*x**2-3*y**2-3*z**2)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/64",
            "[sqrt(102)/128,0,21*sqrt(6)/128,0,5*sqrt(30)/64,0,-sqrt(182)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(182)/64,0,-5*sqrt(30)/64,0,-21*sqrt(6)/128,0,-sqrt(102)/128]",
        ),
        "Qh(11,Bu,7,)": (
            "-sqrt(29393)*C1/512-sqrt(22)*C11/1024-9*sqrt(1615)*C3/512-5*sqrt(13566)*C5/1024-7*sqrt(1330)*C7/1024-9*sqrt(42)*C9/1024",
            "sqrt(1939938)*x*(y-z)*(y+z)*(y**4-4*y**3*z-14*y**2*z**2-4*y*z**3+z**4)*(y**4+4*y**3*z-14*y**2*z**2+4*y*z**3+z**4)/512",
            "[sqrt(11)/1024,0,9*sqrt(21)/1024,0,7*sqrt(665)/1024,0,5*sqrt(6783)/1024,0,9*sqrt(3230)/1024,0,sqrt(58786)/1024,0,-sqrt(58786)/1024,0,-9*sqrt(3230)/1024,0,-5*sqrt(6783)/1024,0,-7*sqrt(665)/1024,0,-9*sqrt(21)/1024,0,-sqrt(11)/1024]",
        ),
        "Qh(7,Bu,8,)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(9,Bu,8,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(11,Bu,8,)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,Bu,9,)": (
            "7*sqrt(22)*C1/64-3*sqrt(21)*C3/32+sqrt(65)*C5/32+sqrt(13)*C7/64-3*sqrt(221)*C9/64",
            "3*sqrt(110)*x*(y-z)*(y+z)*(32*x**6-112*x**4*y**2-112*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-7*y**6-21*y**4*z**2-21*y**2*z**4-7*z**6)/64",
            "[3*sqrt(442)/128,0,-sqrt(26)/128,0,-sqrt(130)/64,0,3*sqrt(42)/64,0,-7*sqrt(11)/64,0,7*sqrt(11)/64,0,-3*sqrt(42)/64,0,sqrt(130)/64,0,sqrt(26)/128,0,-3*sqrt(442)/128]",
        ),
        "Qh(11,Bu,9,)": (
            "-15*sqrt(221)*C1/512-3*sqrt(2926)*C11/1024-sqrt(595)*C3/512+53*sqrt(102)*C5/1024-105*sqrt(10)*C7/1024-61*sqrt(114)*C9/1024",
            "sqrt(14586)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)*(224*x**4-160*x**2*y**2-160*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/512",
            "[3*sqrt(1463)/1024,0,61*sqrt(57)/1024,0,105*sqrt(5)/1024,0,-53*sqrt(51)/1024,0,sqrt(1190)/1024,0,15*sqrt(442)/1024,0,-15*sqrt(442)/1024,0,-sqrt(1190)/1024,0,53*sqrt(51)/1024,0,-105*sqrt(5)/1024,0,-61*sqrt(57)/1024,0,-3*sqrt(1463)/1024]",
        ),
        "Qh(9,Bu,10,)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Bu,10,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,Bu,11,)": (
            "-21*sqrt(130)*C1/512-sqrt(124355)*C11/512+57*sqrt(14)*C3/512-41*sqrt(15)*C5/512+17*sqrt(17)*C7/512+sqrt(4845)*C9/512",
            "sqrt(2145)*x*(y-z)*(y+z)*(128*x**8-768*x**6*y**2-768*x**6*z**2+1008*x**4*y**4+2016*x**4*y**2*z**2+1008*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+21*y**8+84*y**6*z**2+126*y**4*z**4+84*y**2*z**6+21*z**8)/256",
            "[sqrt(248710)/1024,0,-sqrt(9690)/1024,0,-17*sqrt(34)/1024,0,41*sqrt(30)/1024,0,-57*sqrt(7)/512,0,21*sqrt(65)/512,0,-21*sqrt(65)/512,0,57*sqrt(7)/512,0,-41*sqrt(30)/1024,0,17*sqrt(34)/1024,0,sqrt(9690)/1024,0,-sqrt(248710)/1024]",
        ),
        "Qh(11,Bu,12,)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
    },
    "D2": {
        "Qh(0,A,,)": ("C0", "1", "[1]"),
        "Qh(3,A,,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(2,A,1,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(4,A,1,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Qh(5,A,1,)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(6,A,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Qh(7,A,1,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Qh(8,A,1,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Qh(9,A,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Qh(10,A,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Qh(11,A,1,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Qh(2,A,2,)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(4,A,2,)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "-sqrt(15)*(x**4-12*x**2*y**2+6*x**2*z**2+y**4+6*y**2*z**2-2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Qh(5,A,2,)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(6,A,2,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Qh(7,A,2,)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(8,A,2,)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Qh(9,A,2,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Qh(10,A,2,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Qh(11,A,2,)": (
            "S8",
            "-sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(4,A,3,)": ("-C2", "sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Qh(6,A,3,)": (
            "sqrt(14)*C0/4+sqrt(2)*C4/4",
            "-sqrt(14)*(x**6-15*x**4*z**2+15*x**2*z**4+y**6-15*y**4*z**2+15*y**2*z**4-2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Qh(7,A,3,)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "-sqrt(77)*x*y*z*(3*x**4-20*x**2*y**2+10*x**2*z**2+3*y**4+10*y**2*z**2-6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Qh(8,A,3,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,A,3,)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(x-y)*(x+y)*(3*x**4-11*x**2*y**2-7*x**2*z**2+3*y**4-7*y**2*z**2+7*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Qh(10,A,3,)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "-sqrt(420189)*(22*x**10+45*x**8*y**2-1035*x**8*z**2-105*x**6*y**4-630*x**6*y**2*z**2+4935*x**6*z**4-105*x**4*y**6+3150*x**4*y**4*z**2-1575*x**4*y**2*z**4-4830*x**4*z**6+45*x**2*y**8-630*x**2*y**6*z**2-1575*x**2*y**4*z**4+1260*x**2*y**2*z**6+990*x**2*z**8+22*y**10-1035*y**8*z**2+4935*y**6*z**4-4830*y**4*z**6+990*y**2*z**8-44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Qh(11,A,3,)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "-sqrt(230945)*x*y*z*(x**8-6*x**6*y**2-6*x**6*z**2+42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2-84*x**2*y**2*z**4+12*x**2*z**6+y**8-6*y**6*z**2+12*y**2*z**6-2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Qh(6,A,4,)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x-y)*(x+y)*(x**4-9*x**2*y**2-5*x**2*z**2+y**4-5*y**2*z**2+5*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Qh(8,A,4,)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Qh(9,A,4,)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Qh(10,A,4,)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(x-y)*(x+y)*(22*x**8-653*x**6*y**2-315*x**6*z**2+2602*x**4*y**4-945*x**4*y**2*z**2+1575*x**4*z**4-653*x**2*y**6-945*x**2*y**4*z**2+3150*x**2*y**2*z**4-1680*x**2*z**6+22*y**8-315*y**6*z**2+1575*y**4*z**4-1680*y**2*z**6+360*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Qh(11,A,4,)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(8,A,5,)": (
            "C2",
            "-3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(10,A,5,)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "-sqrt(3213210)*(3*x**10-96*x**8*y**2-39*x**8*z**2+224*x**6*y**4+1344*x**6*y**2*z**2-42*x**6*z**4+224*x**4*y**6-6720*x**4*y**4*z**2+3360*x**4*y**2*z**4-182*x**4*z**6-96*x**2*y**8+1344*x**2*y**6*z**2+3360*x**2*y**4*z**4-2688*x**2*y**2*z**6+135*x**2*z**8+3*y**10-39*y**8*z**2-42*y**6*z**4-182*y**4*z**6+135*y**2*z**8-6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Qh(11,A,5,)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "-sqrt(3003)*x*y*z*(5*x**8-150*x**6*y**2+90*x**6*z**2+336*x**4*y**4-70*x**4*y**2*z**2-168*x**4*z**4-150*x**2*y**6-70*x**2*y**4*z**2+140*x**2*y**2*z**4+60*x**2*z**6+5*y**8+90*y**6*z**2-168*y**4*z**4+60*y**2*z**6-10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Qh(10,A,6,)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(x-y)*(x+y)*(9*x**8-165*x**6*y**2-231*x**6*z**2-25*x**4*y**4+3801*x**4*y**2*z**2+406*x**4*z**4-165*x**2*y**6+3801*x**2*y**4*z**2-9674*x**2*y**2*z**4+266*x**2*z**6+9*y**8-231*y**6*z**2+406*y**4*z**4+266*y**2*z**6-57*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Qh(1,B1,,)": ("C0", "z", "[0,1,0]"),
        "Qh(2,B1,,)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Qh(3,B1,1,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(4,B1,1,)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(5,B1,1,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(6,B1,1,)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(7,B1,1,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(8,B1,1,)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(9,B1,1,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,B1,1,)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(11,B1,1,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(3,B1,2,)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(4,B1,2,)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(5,B1,2,)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(6,B1,2,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(7,B1,2,)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(8,B1,2,)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(9,B1,2,)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(10,B1,2,)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(11,B1,2,)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(5,B1,3,)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(6,B1,3,)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(7,B1,3,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(8,B1,3,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(9,B1,3,)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(10,B1,3,)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(11,B1,3,)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(7,B1,4,)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(8,B1,4,)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,B1,4,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(10,B1,4,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(11,B1,4,)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,B1,5,)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,B1,5,)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,B1,5,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,B1,6,)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(1,B2,,)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(2,B2,,)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Qh(3,B2,1,)": (
            "-sqrt(6)*S1/4-sqrt(10)*S3/4",
            "-y*(3*x**2-2*y**2+3*z**2)/2",
            "[-sqrt(5)*I/4,0,-sqrt(3)*I/4,0,-sqrt(3)*I/4,0,-sqrt(5)*I/4]",
        ),
        "Qh(4,B2,1,)": ("sqrt(14)*C1/4-sqrt(2)*C3/4", "-sqrt(35)*x*z*(x-z)*(x+z)/2", "[0,1/4,0,-sqrt(7)/4,0,sqrt(7)/4,0,-1/4,0]"),
        "Qh(5,B2,1,)": (
            "sqrt(15)*S1/8+sqrt(70)*S3/16+3*sqrt(14)*S5/16",
            "y*(15*x**4-40*x**2*y**2+30*x**2*z**2+8*y**4-40*y**2*z**2+15*z**4)/8",
            "[3*sqrt(7)*I/16,0,sqrt(35)*I/16,0,sqrt(30)*I/16,0,sqrt(30)*I/16,0,sqrt(35)*I/16,0,3*sqrt(7)*I/16]",
        ),
        "Qh(6,B2,1,)": (
            "-sqrt(3)*C1/4-sqrt(30)*C3/8+sqrt(22)*C5/8",
            "3*sqrt(7)*x*z*(x-z)*(x+z)*(x**2-10*y**2+z**2)/4",
            "[0,-sqrt(11)/8,0,sqrt(15)/8,0,sqrt(6)/8,0,-sqrt(6)/8,0,-sqrt(15)/8,0,sqrt(11)/8,0]",
        ),
        "Qh(7,B2,1,)": (
            "-5*sqrt(7)*S1/32-3*sqrt(21)*S3/32-sqrt(231)*S5/32-sqrt(429)*S7/32",
            "-y*(35*x**6-210*x**4*y**2+105*x**4*z**2+168*x**2*y**4-420*x**2*y**2*z**2+105*x**2*z**4-16*y**6+168*y**4*z**2-210*y**2*z**4+35*z**6)/16",
            "[-sqrt(858)*I/64,0,-sqrt(462)*I/64,0,-3*sqrt(42)*I/64,0,-5*sqrt(14)*I/64,0,-5*sqrt(14)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(462)*I/64,0,-sqrt(858)*I/64]",
        ),
        "Qh(8,B2,1,)": (
            "sqrt(715)*C1/32-sqrt(273)*C3/32+sqrt(35)*C5/32-C7/32",
            "-3*sqrt(715)*x*z*(x-z)*(x+z)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/16",
            "[0,sqrt(2)/64,0,-sqrt(70)/64,0,sqrt(546)/64,0,-sqrt(1430)/64,0,sqrt(1430)/64,0,-sqrt(546)/64,0,sqrt(70)/64,0,-sqrt(2)/64,0]",
        ),
        "Qh(9,B2,1,)": (
            "21*sqrt(5)*S1/128+sqrt(2310)*S3/128+3*sqrt(286)*S5/128+3*sqrt(1430)*S7/256+sqrt(24310)*S9/256",
            "y*(315*x**8-3360*x**6*y**2+1260*x**6*z**2+6048*x**4*y**4-10080*x**4*y**2*z**2+1890*x**4*z**4-2304*x**2*y**6+12096*x**2*y**4*z**2-10080*x**2*y**2*z**4+1260*x**2*z**6+128*y**8-2304*y**6*z**2+6048*y**4*z**4-3360*y**2*z**6+315*z**8)/128",
            "[sqrt(12155)*I/256,0,3*sqrt(715)*I/256,0,3*sqrt(143)*I/128,0,sqrt(1155)*I/128,0,21*sqrt(10)*I/256,0,21*sqrt(10)*I/256,0,sqrt(1155)*I/128,0,3*sqrt(143)*I/128,0,3*sqrt(715)*I/256,0,sqrt(12155)*I/256]",
        ),
        "Qh(10,B2,1,)": (
            "-sqrt(221)*C1/32-sqrt(102)*C3/32+sqrt(510)*C5/32-11*sqrt(6)*C7/64+sqrt(38)*C9/64",
            "sqrt(12155)*x*z*(x-z)*(x+z)*(x**2-18*y**2+z**2)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/32",
            "[0,-sqrt(19)/64,0,11*sqrt(3)/64,0,-sqrt(255)/32,0,sqrt(51)/32,0,sqrt(442)/64,0,-sqrt(442)/64,0,-sqrt(51)/32,0,sqrt(255)/32,0,-11*sqrt(3)/64,0,sqrt(19)/64,0]",
        ),
        "Qh(11,B2,1,)": (
            "-21*sqrt(66)*S1/512-sqrt(88179)*S11/512-sqrt(30030)*S3/512-15*sqrt(143)*S5/512-sqrt(36465)*S7/512-sqrt(46189)*S9/512",
            "-y*(693*x**10-11550*x**8*y**2+3465*x**8*z**2+36960*x**6*y**4-46200*x**6*y**2*z**2+6930*x**6*z**4-31680*x**4*y**6+110880*x**4*y**4*z**2-69300*x**4*y**2*z**4+6930*x**4*z**6+7040*x**2*y**8-63360*x**2*y**6*z**2+110880*x**2*y**4*z**4-46200*x**2*y**2*z**6+3465*x**2*z**8-256*y**10+7040*y**8*z**2-31680*y**6*z**4+36960*y**4*z**6-11550*y**2*z**8+693*z**10)/256",
            "[-sqrt(176358)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(72930)*I/1024,0,-15*sqrt(286)*I/1024,0,-sqrt(15015)*I/512,0,-21*sqrt(33)*I/512,0,-21*sqrt(33)*I/512,0,-sqrt(15015)*I/512,0,-15*sqrt(286)*I/1024,0,-sqrt(72930)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(176358)*I/1024]",
        ),
        "Qh(3,B2,2,)": (
            "sqrt(10)*S1/4-sqrt(6)*S3/4",
            "-sqrt(15)*y*(x-z)*(x+z)/2",
            "[-sqrt(3)*I/4,0,sqrt(5)*I/4,0,sqrt(5)*I/4,0,-sqrt(3)*I/4]",
        ),
        "Qh(4,B2,2,)": (
            "-sqrt(2)*C1/4-sqrt(14)*C3/4",
            "-sqrt(5)*x*z*(x**2-6*y**2+z**2)/2",
            "[0,sqrt(7)/4,0,1/4,0,-1/4,0,-sqrt(7)/4,0]",
        ),
        "Qh(5,B2,2,)": (
            "sqrt(21)*S1/8-9*sqrt(2)*S3/16+sqrt(10)*S5/16",
            "3*sqrt(35)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/8",
            "[sqrt(5)*I/16,0,-9*I/16,0,sqrt(42)*I/16,0,sqrt(42)*I/16,0,-9*I/16,0,sqrt(5)*I/16]",
        ),
        "Qh(6,B2,2,)": (
            "3*sqrt(22)*C1/16-sqrt(55)*C3/16+sqrt(3)*C5/16",
            "sqrt(462)*x*z*(x**2-3*z**2)*(3*x**2-z**2)/16",
            "[0,-sqrt(6)/32,0,sqrt(110)/32,0,-3*sqrt(11)/16,0,3*sqrt(11)/16,0,-sqrt(110)/32,0,sqrt(6)/32,0]",
        ),
        "Qh(7,B2,2,)": (
            "-3*sqrt(33)*S1/32+sqrt(11)*S3/32+25*S5/32-sqrt(91)*S7/32",
            "-sqrt(231)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(3*x**2-10*y**2+3*z**2)/16",
            "[-sqrt(182)*I/64,0,25*sqrt(2)*I/64,0,sqrt(22)*I/64,0,-3*sqrt(66)*I/64,0,-3*sqrt(66)*I/64,0,sqrt(22)*I/64,0,25*sqrt(2)*I/64,0,-sqrt(182)*I/64]",
        ),
        "Qh(8,B2,2,)": (
            "sqrt(77)*C1/32+5*sqrt(15)*C3/32+3*sqrt(13)*C5/32-sqrt(455)*C7/32",
            "-3*sqrt(77)*x*z*(x-z)*(x+z)*(x**4-24*x**2*y**2+2*x**2*z**2+40*y**4-24*y**2*z**2+z**4)/16",
            "[0,sqrt(910)/64,0,-3*sqrt(26)/64,0,-5*sqrt(30)/64,0,-sqrt(154)/64,0,sqrt(154)/64,0,5*sqrt(30)/64,0,3*sqrt(26)/64,0,-sqrt(910)/64,0]",
        ),
        "Qh(9,B2,2,)": (
            "sqrt(2431)*S1/128-sqrt(9282)*S3/128+5*sqrt(170)*S5/128-7*sqrt(34)*S7/256+3*sqrt(2)*S9/256",
            "3*sqrt(12155)*y*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/128",
            "[3*I/256,0,-7*sqrt(17)*I/256,0,5*sqrt(85)*I/128,0,-sqrt(4641)*I/128,0,sqrt(4862)*I/256,0,sqrt(4862)*I/256,0,-sqrt(4641)*I/128,0,5*sqrt(85)*I/128,0,-7*sqrt(17)*I/256,0,3*I/256]",
        ),
        "Qh(10,B2,2,)": (
            "-sqrt(39)*C1/32-11*sqrt(2)*C3/32-5*sqrt(10)*C5/32-sqrt(34)*C7/64+sqrt(1938)*C9/64",
            "sqrt(2145)*x*z*(x-z)*(x+z)*(x**6-42*x**4*y**2+3*x**4*z**2+168*x**2*y**4-84*x**2*y**2*z**2+3*x**2*z**4-112*y**6+168*y**4*z**2-42*y**2*z**4+z**6)/32",
            "[0,-sqrt(969)/64,0,sqrt(17)/64,0,5*sqrt(5)/32,0,11/32,0,sqrt(78)/64,0,-sqrt(78)/64,0,-11/32,0,-5*sqrt(5)/32,0,-sqrt(17)/64,0,sqrt(969)/64,0]",
        ),
        "Qh(11,B2,2,)": (
            "-sqrt(41990)*S1/512-sqrt(385)*S11/512+3*sqrt(4522)*S3/512+3*sqrt(4845)*S5/512-77*sqrt(19)*S7/512+39*sqrt(15)*S9/512",
            "-sqrt(692835)*y*(x**2-6*y**2+z**2)*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/256",
            "[-sqrt(770)*I/1024,0,39*sqrt(30)*I/1024,0,-77*sqrt(38)*I/1024,0,3*sqrt(9690)*I/1024,0,3*sqrt(2261)*I/512,0,-sqrt(20995)*I/512,0,-sqrt(20995)*I/512,0,3*sqrt(2261)*I/512,0,3*sqrt(9690)*I/1024,0,-77*sqrt(38)*I/1024,0,39*sqrt(30)*I/1024,0,-sqrt(770)*I/1024]",
        ),
        "Qh(5,B2,3,)": (
            "-sqrt(7)*S1/4-sqrt(6)*S3/8+sqrt(30)*S5/8",
            "sqrt(105)*y*(x-z)*(x+z)*(x**2-2*y**2+z**2)/4",
            "[sqrt(15)*I/8,0,-sqrt(3)*I/8,0,-sqrt(14)*I/8,0,-sqrt(14)*I/8,0,-sqrt(3)*I/8,0,sqrt(15)*I/8]",
        ),
        "Qh(6,B2,3,)": (
            "sqrt(10)*C1/16+9*C3/16+sqrt(165)*C5/16",
            "sqrt(210)*x*z*(x**4-16*x**2*y**2+2*x**2*z**2+16*y**4-16*y**2*z**2+z**4)/16",
            "[0,-sqrt(330)/32,0,-9*sqrt(2)/32,0,-sqrt(5)/16,0,sqrt(5)/16,0,9*sqrt(2)/32,0,sqrt(330)/32,0]",
        ),
        "Qh(7,B2,3,)": (
            "sqrt(858)*S1/64-3*sqrt(286)*S3/64+5*sqrt(26)*S5/64-sqrt(14)*S7/64",
            "-sqrt(6006)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)/32",
            "[-sqrt(7)*I/64,0,5*sqrt(13)*I/64,0,-3*sqrt(143)*I/64,0,sqrt(429)*I/64,0,sqrt(429)*I/64,0,-3*sqrt(143)*I/64,0,5*sqrt(13)*I/64,0,-sqrt(7)*I/64]",
        ),
        "Qh(8,B2,3,)": (
            "-sqrt(858)*C1/64-sqrt(910)*C3/64+7*sqrt(42)*C5/64-3*sqrt(30)*C7/64",
            "-sqrt(858)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(x**2-14*y**2+z**2)/32",
            "[0,3*sqrt(15)/64,0,-7*sqrt(21)/64,0,sqrt(455)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-sqrt(455)/64,0,7*sqrt(21)/64,0,-3*sqrt(15)/64,0]",
        ),
        "Qh(9,B2,3,)": (
            "sqrt(1001)*S1/64+sqrt(78)*S3/64-3*sqrt(70)*S5/64-23*sqrt(14)*S7/128+3*sqrt(238)*S9/128",
            "3*sqrt(5005)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(x**4-8*x**2*y**2+2*x**2*z**2+8*y**4-8*y**2*z**2+z**4)/64",
            "[3*sqrt(119)*I/128,0,-23*sqrt(7)*I/128,0,-3*sqrt(35)*I/64,0,sqrt(39)*I/64,0,sqrt(2002)*I/128,0,sqrt(2002)*I/128,0,sqrt(39)*I/64,0,-3*sqrt(35)*I/64,0,-23*sqrt(7)*I/128,0,3*sqrt(119)*I/128]",
        ),
        "Qh(10,B2,3,)": (
            "sqrt(41990)*C1/256-sqrt(4845)*C3/128+sqrt(969)*C5/128-sqrt(285)*C7/256+sqrt(5)*C9/256",
            "sqrt(92378)*x*z*(x**4-10*x**2*z**2+5*z**4)*(5*x**4-10*x**2*z**2+z**4)/256",
            "[0,-sqrt(10)/512,0,sqrt(570)/512,0,-sqrt(1938)/256,0,sqrt(9690)/256,0,-sqrt(20995)/256,0,sqrt(20995)/256,0,-sqrt(9690)/256,0,sqrt(1938)/256,0,-sqrt(570)/512,0,sqrt(10)/512,0]",
        ),
        "Qh(11,B2,3,)": (
            "-5*sqrt(546)*S1/256-sqrt(10659)*S11/256-11*sqrt(30)*S3/256+13*sqrt(7)*S5/256+3*sqrt(1785)*S7/256+3*sqrt(2261)*S9/256",
            "-3*sqrt(1001)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(5*x**6-70*x**4*y**2+15*x**4*z**2+168*x**2*y**4-140*x**2*y**2*z**2+15*x**2*z**4-80*y**6+168*y**4*z**2-70*y**2*z**4+5*z**6)/128",
            "[-sqrt(21318)*I/512,0,3*sqrt(4522)*I/512,0,3*sqrt(3570)*I/512,0,13*sqrt(14)*I/512,0,-11*sqrt(15)*I/256,0,-5*sqrt(273)*I/256,0,-5*sqrt(273)*I/256,0,-11*sqrt(15)*I/256,0,13*sqrt(14)*I/512,0,3*sqrt(3570)*I/512,0,3*sqrt(4522)*I/512,0,-sqrt(21318)*I/512]",
        ),
        "Qh(7,B2,4,)": (
            "15*sqrt(6)*S1/64+19*sqrt(2)*S3/64+sqrt(22)*S5/64-sqrt(2002)*S7/64",
            "-sqrt(42)*y*(x-z)*(x+z)*(15*x**4-80*x**2*y**2+30*x**2*z**2+48*y**4-80*y**2*z**2+15*z**4)/32",
            "[-sqrt(1001)*I/64,0,sqrt(11)*I/64,0,19*I/64,0,15*sqrt(3)*I/64,0,15*sqrt(3)*I/64,0,19*I/64,0,sqrt(11)*I/64,0,-sqrt(1001)*I/64]",
        ),
        "Qh(8,B2,4,)": (
            "-sqrt(70)*C1/64-3*sqrt(66)*C3/64-sqrt(1430)*C5/64-sqrt(2002)*C7/64",
            "-3*sqrt(70)*x*z*(x**6-30*x**4*y**2+3*x**4*z**2+80*x**2*y**4-60*x**2*y**2*z**2+3*x**2*z**4-32*y**6+80*y**4*z**2-30*y**2*z**4+z**6)/32",
            "[0,sqrt(1001)/64,0,sqrt(715)/64,0,3*sqrt(33)/64,0,sqrt(35)/64,0,-sqrt(35)/64,0,-3*sqrt(33)/64,0,-sqrt(715)/64,0,-sqrt(1001)/64,0]",
        ),
        "Qh(9,B2,4,)": (
            "-sqrt(858)*S1/64+sqrt(91)*S3/32+5*sqrt(15)*S5/32-21*sqrt(3)*S7/64+sqrt(51)*S9/64",
            "sqrt(4290)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(3*x**2-14*y**2+3*z**2)/64",
            "[sqrt(102)*I/128,0,-21*sqrt(6)*I/128,0,5*sqrt(30)*I/64,0,sqrt(182)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(182)*I/64,0,5*sqrt(30)*I/64,0,-21*sqrt(6)*I/128,0,sqrt(102)*I/128]",
        ),
        "Qh(10,B2,4,)": (
            "9*sqrt(78)*C1/256+69*C3/128-sqrt(5)*C5/128-43*sqrt(17)*C7/256+3*sqrt(969)*C9/256",
            "sqrt(4290)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(3*x**4-96*x**2*y**2+6*x**2*z**2+224*y**4-96*y**2*z**2+3*z**4)/256",
            "[0,-3*sqrt(1938)/512,0,43*sqrt(34)/512,0,sqrt(10)/256,0,-69*sqrt(2)/256,0,-9*sqrt(39)/256,0,9*sqrt(39)/256,0,69*sqrt(2)/256,0,-sqrt(10)/256,0,-43*sqrt(34)/512,0,3*sqrt(1938)/512,0]",
        ),
        "Qh(11,B2,4,)": (
            "sqrt(29393)*S1/512-sqrt(22)*S11/1024-9*sqrt(1615)*S3/512+5*sqrt(13566)*S5/1024-7*sqrt(1330)*S7/1024+9*sqrt(42)*S9/1024",
            "-sqrt(1939938)*y*(x-z)*(x+z)*(x**4-4*x**3*z-14*x**2*z**2-4*x*z**3+z**4)*(x**4+4*x**3*z-14*x**2*z**2+4*x*z**3+z**4)/512",
            "[-sqrt(11)*I/1024,0,9*sqrt(21)*I/1024,0,-7*sqrt(665)*I/1024,0,5*sqrt(6783)*I/1024,0,-9*sqrt(3230)*I/1024,0,sqrt(58786)*I/1024,0,sqrt(58786)*I/1024,0,-9*sqrt(3230)*I/1024,0,5*sqrt(6783)*I/1024,0,-7*sqrt(665)*I/1024,0,9*sqrt(21)*I/1024,0,-sqrt(11)*I/1024]",
        ),
        "Qh(9,B2,5,)": (
            "-7*sqrt(22)*S1/64-3*sqrt(21)*S3/32-sqrt(65)*S5/32+sqrt(13)*S7/64+3*sqrt(221)*S9/64",
            "3*sqrt(110)*y*(x-z)*(x+z)*(7*x**6-70*x**4*y**2+21*x**4*z**2+112*x**2*y**4-140*x**2*y**2*z**2+21*x**2*z**4-32*y**6+112*y**4*z**2-70*y**2*z**4+7*z**6)/64",
            "[3*sqrt(442)*I/128,0,sqrt(26)*I/128,0,-sqrt(130)*I/64,0,-3*sqrt(42)*I/64,0,-7*sqrt(11)*I/64,0,-7*sqrt(11)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(130)*I/64,0,sqrt(26)*I/128,0,3*sqrt(442)*I/128]",
        ),
        "Qh(10,B2,5,)": (
            "7*sqrt(3)*C1/128+7*sqrt(26)*C3/128+5*sqrt(130)*C5/128+7*sqrt(442)*C7/256+sqrt(25194)*C9/256",
            "sqrt(165)*x*z*(7*x**8-336*x**6*y**2+28*x**6*z**2+1680*x**4*y**4-1008*x**4*y**2*z**2+42*x**4*z**4-1792*x**2*y**6+3360*x**2*y**4*z**2-1008*x**2*y**2*z**4+28*x**2*z**6+384*y**8-1792*y**6*z**2+1680*y**4*z**4-336*y**2*z**6+7*z**8)/128",
            "[0,-sqrt(12597)/256,0,-7*sqrt(221)/256,0,-5*sqrt(65)/128,0,-7*sqrt(13)/128,0,-7*sqrt(6)/256,0,7*sqrt(6)/256,0,7*sqrt(13)/128,0,5*sqrt(65)/128,0,7*sqrt(221)/256,0,sqrt(12597)/256,0]",
        ),
        "Qh(11,B2,5,)": (
            "15*sqrt(221)*S1/512-3*sqrt(2926)*S11/1024-sqrt(595)*S3/512-53*sqrt(102)*S5/1024-105*sqrt(10)*S7/1024+61*sqrt(114)*S9/1024",
            "-sqrt(14586)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(15*x**4-160*x**2*y**2+30*x**2*z**2+224*y**4-160*y**2*z**2+15*z**4)/512",
            "[-3*sqrt(1463)*I/1024,0,61*sqrt(57)*I/1024,0,-105*sqrt(5)*I/1024,0,-53*sqrt(51)*I/1024,0,-sqrt(1190)*I/1024,0,15*sqrt(442)*I/1024,0,15*sqrt(442)*I/1024,0,-sqrt(1190)*I/1024,0,-53*sqrt(51)*I/1024,0,-105*sqrt(5)*I/1024,0,61*sqrt(57)*I/1024,0,-3*sqrt(1463)*I/1024]",
        ),
        "Qh(11,B2,6,)": (
            "21*sqrt(130)*S1/512-sqrt(124355)*S11/512+57*sqrt(14)*S3/512+41*sqrt(15)*S5/512+17*sqrt(17)*S7/512-sqrt(4845)*S9/512",
            "-sqrt(2145)*y*(x-z)*(x+z)*(21*x**8-336*x**6*y**2+84*x**6*z**2+1008*x**4*y**4-1008*x**4*y**2*z**2+126*x**4*z**4-768*x**2*y**6+2016*x**2*y**4*z**2-1008*x**2*y**2*z**4+84*x**2*z**6+128*y**8-768*y**6*z**2+1008*y**4*z**4-336*y**2*z**6+21*z**8)/256",
            "[-sqrt(248710)*I/1024,0,-sqrt(9690)*I/1024,0,17*sqrt(34)*I/1024,0,41*sqrt(30)*I/1024,0,57*sqrt(7)*I/512,0,21*sqrt(65)*I/512,0,21*sqrt(65)*I/512,0,57*sqrt(7)*I/512,0,41*sqrt(30)*I/1024,0,17*sqrt(34)*I/1024,0,-sqrt(9690)*I/1024,0,-sqrt(248710)*I/1024]",
        ),
        "Qh(1,B3,,)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(2,B3,,)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(3,B3,1,)": (
            "-sqrt(6)*C1/4+sqrt(10)*C3/4",
            "x*(2*x**2-3*y**2-3*z**2)/2",
            "[-sqrt(5)/4,0,sqrt(3)/4,0,-sqrt(3)/4,0,sqrt(5)/4]",
        ),
        "Qh(4,B3,1,)": (
            "-sqrt(14)*S1/4-sqrt(2)*S3/4",
            "sqrt(35)*y*z*(y-z)*(y+z)/2",
            "[0,-I/4,0,-sqrt(7)*I/4,0,-sqrt(7)*I/4,0,-I/4,0]",
        ),
        "Qh(5,B3,1,)": (
            "sqrt(15)*C1/8-sqrt(70)*C3/16+3*sqrt(14)*C5/16",
            "x*(8*x**4-40*x**2*y**2-40*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/8",
            "[-3*sqrt(7)/16,0,sqrt(35)/16,0,-sqrt(30)/16,0,sqrt(30)/16,0,-sqrt(35)/16,0,3*sqrt(7)/16]",
        ),
        "Qh(6,B3,1,)": (
            "sqrt(3)*S1/4-sqrt(30)*S3/8-sqrt(22)*S5/8",
            "3*sqrt(7)*y*z*(y-z)*(y+z)*(10*x**2-y**2-z**2)/4",
            "[0,-sqrt(11)*I/8,0,-sqrt(15)*I/8,0,sqrt(6)*I/8,0,sqrt(6)*I/8,0,-sqrt(15)*I/8,0,-sqrt(11)*I/8,0]",
        ),
        "Qh(7,B3,1,)": (
            "-5*sqrt(7)*C1/32+3*sqrt(21)*C3/32-sqrt(231)*C5/32+sqrt(429)*C7/32",
            "x*(16*x**6-168*x**4*y**2-168*x**4*z**2+210*x**2*y**4+420*x**2*y**2*z**2+210*x**2*z**4-35*y**6-105*y**4*z**2-105*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)/64,0,sqrt(462)/64,0,-3*sqrt(42)/64,0,5*sqrt(14)/64,0,-5*sqrt(14)/64,0,3*sqrt(42)/64,0,-sqrt(462)/64,0,sqrt(858)/64]",
        ),
        "Qh(8,B3,1,)": (
            "-sqrt(715)*S1/32-sqrt(273)*S3/32-sqrt(35)*S5/32-S7/32",
            "3*sqrt(715)*y*z*(y-z)*(y+z)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[0,-sqrt(2)*I/64,0,-sqrt(70)*I/64,0,-sqrt(546)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(546)*I/64,0,-sqrt(70)*I/64,0,-sqrt(2)*I/64,0]",
        ),
        "Qh(9,B3,1,)": (
            "21*sqrt(5)*C1/128-sqrt(2310)*C3/128+3*sqrt(286)*C5/128-3*sqrt(1430)*C7/256+sqrt(24310)*C9/256",
            "x*(128*x**8-2304*x**6*y**2-2304*x**6*z**2+6048*x**4*y**4+12096*x**4*y**2*z**2+6048*x**4*z**4-3360*x**2*y**6-10080*x**2*y**4*z**2-10080*x**2*y**2*z**4-3360*x**2*z**6+315*y**8+1260*y**6*z**2+1890*y**4*z**4+1260*y**2*z**6+315*z**8)/128",
            "[-sqrt(12155)/256,0,3*sqrt(715)/256,0,-3*sqrt(143)/128,0,sqrt(1155)/128,0,-21*sqrt(10)/256,0,21*sqrt(10)/256,0,-sqrt(1155)/128,0,3*sqrt(143)/128,0,-3*sqrt(715)/256,0,sqrt(12155)/256]",
        ),
        "Qh(10,B3,1,)": (
            "sqrt(221)*S1/32-sqrt(102)*S3/32-sqrt(510)*S5/32-11*sqrt(6)*S7/64-sqrt(38)*S9/64",
            "sqrt(12155)*y*z*(y-z)*(y+z)*(18*x**2-y**2-z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/32",
            "[0,-sqrt(19)*I/64,0,-11*sqrt(3)*I/64,0,-sqrt(255)*I/32,0,-sqrt(51)*I/32,0,sqrt(442)*I/64,0,sqrt(442)*I/64,0,-sqrt(51)*I/32,0,-sqrt(255)*I/32,0,-11*sqrt(3)*I/64,0,-sqrt(19)*I/64,0]",
        ),
        "Qh(11,B3,1,)": (
            "-21*sqrt(66)*C1/512+sqrt(88179)*C11/512+sqrt(30030)*C3/512-15*sqrt(143)*C5/512+sqrt(36465)*C7/512-sqrt(46189)*C9/512",
            "x*(256*x**10-7040*x**8*y**2-7040*x**8*z**2+31680*x**6*y**4+63360*x**6*y**2*z**2+31680*x**6*z**4-36960*x**4*y**6-110880*x**4*y**4*z**2-110880*x**4*y**2*z**4-36960*x**4*z**6+11550*x**2*y**8+46200*x**2*y**6*z**2+69300*x**2*y**4*z**4+46200*x**2*y**2*z**6+11550*x**2*z**8-693*y**10-3465*y**8*z**2-6930*y**6*z**4-6930*y**4*z**6-3465*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)/1024,0,sqrt(92378)/1024,0,-sqrt(72930)/1024,0,15*sqrt(286)/1024,0,-sqrt(15015)/512,0,21*sqrt(33)/512,0,-21*sqrt(33)/512,0,sqrt(15015)/512,0,-15*sqrt(286)/1024,0,sqrt(72930)/1024,0,-sqrt(92378)/1024,0,sqrt(176358)/1024]",
        ),
        "Qh(3,B3,2,)": (
            "-sqrt(10)*C1/4-sqrt(6)*C3/4",
            "sqrt(15)*x*(y-z)*(y+z)/2",
            "[sqrt(3)/4,0,sqrt(5)/4,0,-sqrt(5)/4,0,-sqrt(3)/4]",
        ),
        "Qh(4,B3,2,)": (
            "-sqrt(2)*S1/4+sqrt(14)*S3/4",
            "sqrt(5)*y*z*(6*x**2-y**2-z**2)/2",
            "[0,sqrt(7)*I/4,0,-I/4,0,-I/4,0,sqrt(7)*I/4,0]",
        ),
        "Qh(5,B3,2,)": (
            "sqrt(21)*C1/8+9*sqrt(2)*C3/16+sqrt(10)*C5/16",
            "3*sqrt(35)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/8",
            "[-sqrt(5)/16,0,-9/16,0,-sqrt(42)/16,0,sqrt(42)/16,0,9/16,0,sqrt(5)/16]",
        ),
        "Qh(6,B3,2,)": (
            "3*sqrt(22)*S1/16+sqrt(55)*S3/16+sqrt(3)*S5/16",
            "sqrt(462)*y*z*(y**2-3*z**2)*(3*y**2-z**2)/16",
            "[0,sqrt(6)*I/32,0,sqrt(110)*I/32,0,3*sqrt(11)*I/16,0,3*sqrt(11)*I/16,0,sqrt(110)*I/32,0,sqrt(6)*I/32,0]",
        ),
        "Qh(7,B3,2,)": (
            "-3*sqrt(33)*C1/32-sqrt(11)*C3/32+25*C5/32+sqrt(91)*C7/32",
            "sqrt(231)*x*(10*x**2-3*y**2-3*z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[-sqrt(182)/64,0,-25*sqrt(2)/64,0,sqrt(22)/64,0,3*sqrt(66)/64,0,-3*sqrt(66)/64,0,-sqrt(22)/64,0,25*sqrt(2)/64,0,sqrt(182)/64]",
        ),
        "Qh(8,B3,2,)": (
            "-sqrt(77)*S1/32+5*sqrt(15)*S3/32-3*sqrt(13)*S5/32-sqrt(455)*S7/32",
            "3*sqrt(77)*y*z*(y-z)*(y+z)*(40*x**4-24*x**2*y**2-24*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,-sqrt(910)*I/64,0,-3*sqrt(26)*I/64,0,5*sqrt(30)*I/64,0,-sqrt(154)*I/64,0,-sqrt(154)*I/64,0,5*sqrt(30)*I/64,0,-3*sqrt(26)*I/64,0,-sqrt(910)*I/64,0]",
        ),
        "Qh(9,B3,2,)": (
            "sqrt(2431)*C1/128+sqrt(9282)*C3/128+5*sqrt(170)*C5/128+7*sqrt(34)*C7/256+3*sqrt(2)*C9/256",
            "3*sqrt(12155)*x*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/128",
            "[-3/256,0,-7*sqrt(17)/256,0,-5*sqrt(85)/128,0,-sqrt(4641)/128,0,-sqrt(4862)/256,0,sqrt(4862)/256,0,sqrt(4641)/128,0,5*sqrt(85)/128,0,7*sqrt(17)/256,0,3/256]",
        ),
        "Qh(10,B3,2,)": (
            "sqrt(39)*S1/32-11*sqrt(2)*S3/32+5*sqrt(10)*S5/32-sqrt(34)*S7/64-sqrt(1938)*S9/64",
            "sqrt(2145)*y*z*(y-z)*(y+z)*(112*x**6-168*x**4*y**2-168*x**4*z**2+42*x**2*y**4+84*x**2*y**2*z**2+42*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,-sqrt(969)*I/64,0,-sqrt(17)*I/64,0,5*sqrt(5)*I/32,0,-11*I/32,0,sqrt(78)*I/64,0,sqrt(78)*I/64,0,-11*I/32,0,5*sqrt(5)*I/32,0,-sqrt(17)*I/64,0,-sqrt(969)*I/64,0]",
        ),
        "Qh(11,B3,2,)": (
            "-sqrt(41990)*C1/512+sqrt(385)*C11/512-3*sqrt(4522)*C3/512+3*sqrt(4845)*C5/512+77*sqrt(19)*C7/512+39*sqrt(15)*C9/512",
            "sqrt(692835)*x*(6*x**2-y**2-z**2)*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/256",
            "[-sqrt(770)/1024,0,-39*sqrt(30)/1024,0,-77*sqrt(38)/1024,0,-3*sqrt(9690)/1024,0,3*sqrt(2261)/512,0,sqrt(20995)/512,0,-sqrt(20995)/512,0,-3*sqrt(2261)/512,0,3*sqrt(9690)/1024,0,77*sqrt(38)/1024,0,39*sqrt(30)/1024,0,sqrt(770)/1024]",
        ),
        "Qh(5,B3,3,)": (
            "sqrt(7)*C1/4-sqrt(6)*C3/8-sqrt(30)*C5/8",
            "sqrt(105)*x*(y-z)*(y+z)*(2*x**2-y**2-z**2)/4",
            "[sqrt(15)/8,0,sqrt(3)/8,0,-sqrt(14)/8,0,sqrt(14)/8,0,-sqrt(3)/8,0,-sqrt(15)/8]",
        ),
        "Qh(6,B3,3,)": (
            "sqrt(10)*S1/16-9*S3/16+sqrt(165)*S5/16",
            "sqrt(210)*y*z*(16*x**4-16*x**2*y**2-16*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,sqrt(330)*I/32,0,-9*sqrt(2)*I/32,0,sqrt(5)*I/16,0,sqrt(5)*I/16,0,-9*sqrt(2)*I/32,0,sqrt(330)*I/32,0]",
        ),
        "Qh(7,B3,3,)": (
            "-sqrt(858)*C1/64-3*sqrt(286)*C3/64-5*sqrt(26)*C5/64-sqrt(14)*C7/64",
            "sqrt(6006)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/32",
            "[sqrt(7)/64,0,5*sqrt(13)/64,0,3*sqrt(143)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-3*sqrt(143)/64,0,-5*sqrt(13)/64,0,-sqrt(7)/64]",
        ),
        "Qh(8,B3,3,)": (
            "-sqrt(858)*S1/64+sqrt(910)*S3/64+7*sqrt(42)*S5/64+3*sqrt(30)*S7/64",
            "sqrt(858)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(14*x**2-y**2-z**2)/32",
            "[0,3*sqrt(15)*I/64,0,7*sqrt(21)*I/64,0,sqrt(455)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(455)*I/64,0,7*sqrt(21)*I/64,0,3*sqrt(15)*I/64,0]",
        ),
        "Qh(9,B3,3,)": (
            "sqrt(1001)*C1/64-sqrt(78)*C3/64-3*sqrt(70)*C5/64+23*sqrt(14)*C7/128+3*sqrt(238)*C9/128",
            "3*sqrt(5005)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(8*x**4-8*x**2*y**2-8*x**2*z**2+y**4+2*y**2*z**2+z**4)/64",
            "[-3*sqrt(119)/128,0,-23*sqrt(7)/128,0,3*sqrt(35)/64,0,sqrt(39)/64,0,-sqrt(2002)/128,0,sqrt(2002)/128,0,-sqrt(39)/64,0,-3*sqrt(35)/64,0,23*sqrt(7)/128,0,3*sqrt(119)/128]",
        ),
        "Qh(10,B3,3,)": (
            "sqrt(41990)*S1/256+sqrt(4845)*S3/128+sqrt(969)*S5/128+sqrt(285)*S7/256+sqrt(5)*S9/256",
            "sqrt(92378)*y*z*(y**4-10*y**2*z**2+5*z**4)*(5*y**4-10*y**2*z**2+z**4)/256",
            "[0,sqrt(10)*I/512,0,sqrt(570)*I/512,0,sqrt(1938)*I/256,0,sqrt(9690)*I/256,0,sqrt(20995)*I/256,0,sqrt(20995)*I/256,0,sqrt(9690)*I/256,0,sqrt(1938)*I/256,0,sqrt(570)*I/512,0,sqrt(10)*I/512,0]",
        ),
        "Qh(11,B3,3,)": (
            "-5*sqrt(546)*C1/256+sqrt(10659)*C11/256+11*sqrt(30)*C3/256+13*sqrt(7)*C5/256-3*sqrt(1785)*C7/256+3*sqrt(2261)*C9/256",
            "3*sqrt(1001)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(80*x**6-168*x**4*y**2-168*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-5*y**6-15*y**4*z**2-15*y**2*z**4-5*z**6)/128",
            "[-sqrt(21318)/512,0,-3*sqrt(4522)/512,0,3*sqrt(3570)/512,0,-13*sqrt(14)/512,0,-11*sqrt(15)/256,0,5*sqrt(273)/256,0,-5*sqrt(273)/256,0,11*sqrt(15)/256,0,13*sqrt(14)/512,0,-3*sqrt(3570)/512,0,3*sqrt(4522)/512,0,sqrt(21318)/512]",
        ),
        "Qh(7,B3,4,)": (
            "-15*sqrt(6)*C1/64+19*sqrt(2)*C3/64-sqrt(22)*C5/64-sqrt(2002)*C7/64",
            "sqrt(42)*x*(y-z)*(y+z)*(48*x**4-80*x**2*y**2-80*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/32",
            "[sqrt(1001)/64,0,sqrt(11)/64,0,-19/64,0,15*sqrt(3)/64,0,-15*sqrt(3)/64,0,19/64,0,-sqrt(11)/64,0,-sqrt(1001)/64]",
        ),
        "Qh(8,B3,4,)": (
            "-sqrt(70)*S1/64+3*sqrt(66)*S3/64-sqrt(1430)*S5/64+sqrt(2002)*S7/64",
            "3*sqrt(70)*y*z*(32*x**6-80*x**4*y**2-80*x**4*z**2+30*x**2*y**4+60*x**2*y**2*z**2+30*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,sqrt(1001)*I/64,0,-sqrt(715)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(35)*I/64,0,-sqrt(35)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(715)*I/64,0,sqrt(1001)*I/64,0]",
        ),
        "Qh(9,B3,4,)": (
            "sqrt(858)*C1/64+sqrt(91)*C3/32-5*sqrt(15)*C5/32-21*sqrt(3)*C7/64-sqrt(51)*C9/64",
            "sqrt(4290)*x*(y-z)*(y+z)*(14*x**2-3*y**2-3*z**2)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/64",
            "[sqrt(102)/128,0,21*sqrt(6)/128,0,5*sqrt(30)/64,0,-sqrt(182)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(182)/64,0,-5*sqrt(30)/64,0,-21*sqrt(6)/128,0,-sqrt(102)/128]",
        ),
        "Qh(10,B3,4,)": (
            "9*sqrt(78)*S1/256-69*S3/128-sqrt(5)*S5/128+43*sqrt(17)*S7/256+3*sqrt(969)*S9/256",
            "sqrt(4290)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(224*x**4-96*x**2*y**2-96*x**2*z**2+3*y**4+6*y**2*z**2+3*z**4)/256",
            "[0,3*sqrt(1938)*I/512,0,43*sqrt(34)*I/512,0,-sqrt(10)*I/256,0,-69*sqrt(2)*I/256,0,9*sqrt(39)*I/256,0,9*sqrt(39)*I/256,0,-69*sqrt(2)*I/256,0,-sqrt(10)*I/256,0,43*sqrt(34)*I/512,0,3*sqrt(1938)*I/512,0]",
        ),
        "Qh(11,B3,4,)": (
            "-sqrt(29393)*C1/512-sqrt(22)*C11/1024-9*sqrt(1615)*C3/512-5*sqrt(13566)*C5/1024-7*sqrt(1330)*C7/1024-9*sqrt(42)*C9/1024",
            "sqrt(1939938)*x*(y-z)*(y+z)*(y**4-4*y**3*z-14*y**2*z**2-4*y*z**3+z**4)*(y**4+4*y**3*z-14*y**2*z**2+4*y*z**3+z**4)/512",
            "[sqrt(11)/1024,0,9*sqrt(21)/1024,0,7*sqrt(665)/1024,0,5*sqrt(6783)/1024,0,9*sqrt(3230)/1024,0,sqrt(58786)/1024,0,-sqrt(58786)/1024,0,-9*sqrt(3230)/1024,0,-5*sqrt(6783)/1024,0,-7*sqrt(665)/1024,0,-9*sqrt(21)/1024,0,-sqrt(11)/1024]",
        ),
        "Qh(9,B3,5,)": (
            "7*sqrt(22)*C1/64-3*sqrt(21)*C3/32+sqrt(65)*C5/32+sqrt(13)*C7/64-3*sqrt(221)*C9/64",
            "3*sqrt(110)*x*(y-z)*(y+z)*(32*x**6-112*x**4*y**2-112*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-7*y**6-21*y**4*z**2-21*y**2*z**4-7*z**6)/64",
            "[3*sqrt(442)/128,0,-sqrt(26)/128,0,-sqrt(130)/64,0,3*sqrt(42)/64,0,-7*sqrt(11)/64,0,7*sqrt(11)/64,0,-3*sqrt(42)/64,0,sqrt(130)/64,0,sqrt(26)/128,0,-3*sqrt(442)/128]",
        ),
        "Qh(10,B3,5,)": (
            "7*sqrt(3)*S1/128-7*sqrt(26)*S3/128+5*sqrt(130)*S5/128-7*sqrt(442)*S7/256+sqrt(25194)*S9/256",
            "sqrt(165)*y*z*(384*x**8-1792*x**6*y**2-1792*x**6*z**2+1680*x**4*y**4+3360*x**4*y**2*z**2+1680*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+7*y**8+28*y**6*z**2+42*y**4*z**4+28*y**2*z**6+7*z**8)/128",
            "[0,sqrt(12597)*I/256,0,-7*sqrt(221)*I/256,0,5*sqrt(65)*I/128,0,-7*sqrt(13)*I/128,0,7*sqrt(6)*I/256,0,7*sqrt(6)*I/256,0,-7*sqrt(13)*I/128,0,5*sqrt(65)*I/128,0,-7*sqrt(221)*I/256,0,sqrt(12597)*I/256,0]",
        ),
        "Qh(11,B3,5,)": (
            "-15*sqrt(221)*C1/512-3*sqrt(2926)*C11/1024-sqrt(595)*C3/512+53*sqrt(102)*C5/1024-105*sqrt(10)*C7/1024-61*sqrt(114)*C9/1024",
            "sqrt(14586)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)*(224*x**4-160*x**2*y**2-160*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/512",
            "[3*sqrt(1463)/1024,0,61*sqrt(57)/1024,0,105*sqrt(5)/1024,0,-53*sqrt(51)/1024,0,sqrt(1190)/1024,0,15*sqrt(442)/1024,0,-15*sqrt(442)/1024,0,-sqrt(1190)/1024,0,53*sqrt(51)/1024,0,-105*sqrt(5)/1024,0,-61*sqrt(57)/1024,0,-3*sqrt(1463)/1024]",
        ),
        "Qh(11,B3,6,)": (
            "-21*sqrt(130)*C1/512-sqrt(124355)*C11/512+57*sqrt(14)*C3/512-41*sqrt(15)*C5/512+17*sqrt(17)*C7/512+sqrt(4845)*C9/512",
            "sqrt(2145)*x*(y-z)*(y+z)*(128*x**8-768*x**6*y**2-768*x**6*z**2+1008*x**4*y**4+2016*x**4*y**2*z**2+1008*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+21*y**8+84*y**6*z**2+126*y**4*z**4+84*y**2*z**6+21*z**8)/256",
            "[sqrt(248710)/1024,0,-sqrt(9690)/1024,0,-17*sqrt(34)/1024,0,41*sqrt(30)/1024,0,-57*sqrt(7)/512,0,21*sqrt(65)/512,0,-21*sqrt(65)/512,0,57*sqrt(7)/512,0,-41*sqrt(30)/1024,0,17*sqrt(34)/1024,0,sqrt(9690)/1024,0,-sqrt(248710)/1024]",
        ),
    },
    "C2v": {
        "Qh(0,A1,,)": ("C0", "1", "[1]"),
        "Qh(1,A1,,)": ("C0", "z", "[0,1,0]"),
        "Qh(2,A1,1,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(3,A1,1,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(4,A1,1,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Qh(5,A1,1,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(6,A1,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Qh(7,A1,1,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(8,A1,1,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Qh(9,A1,1,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A1,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Qh(11,A1,1,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(2,A1,2,)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(3,A1,2,)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(4,A1,2,)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "-sqrt(15)*(x**4-12*x**2*y**2+6*x**2*z**2+y**4+6*y**2*z**2-2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Qh(5,A1,2,)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(6,A1,2,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Qh(7,A1,2,)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(8,A1,2,)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Qh(9,A1,2,)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(10,A1,2,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Qh(11,A1,2,)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(4,A1,3,)": ("-C2", "sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Qh(5,A1,3,)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(6,A1,3,)": (
            "sqrt(14)*C0/4+sqrt(2)*C4/4",
            "-sqrt(14)*(x**6-15*x**4*z**2+15*x**2*z**4+y**6-15*y**4*z**2+15*y**2*z**4-2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Qh(7,A1,3,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(8,A1,3,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,A1,3,)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(10,A1,3,)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "-sqrt(420189)*(22*x**10+45*x**8*y**2-1035*x**8*z**2-105*x**6*y**4-630*x**6*y**2*z**2+4935*x**6*z**4-105*x**4*y**6+3150*x**4*y**4*z**2-1575*x**4*y**2*z**4-4830*x**4*z**6+45*x**2*y**8-630*x**2*y**6*z**2-1575*x**2*y**4*z**4+1260*x**2*y**2*z**6+990*x**2*z**8+22*y**10-1035*y**8*z**2+4935*y**6*z**4-4830*y**4*z**6+990*y**2*z**8-44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Qh(11,A1,3,)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(6,A1,4,)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x-y)*(x+y)*(x**4-9*x**2*y**2-5*x**2*z**2+y**4-5*y**2*z**2+5*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Qh(7,A1,4,)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(8,A1,4,)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Qh(9,A1,4,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(10,A1,4,)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(x-y)*(x+y)*(22*x**8-653*x**6*y**2-315*x**6*z**2+2602*x**4*y**4-945*x**4*y**2*z**2+1575*x**4*z**4-653*x**2*y**6-945*x**2*y**4*z**2+3150*x**2*y**2*z**4-1680*x**2*z**6+22*y**8-315*y**6*z**2+1575*y**4*z**4-1680*y**2*z**6+360*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Qh(11,A1,4,)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(8,A1,5,)": (
            "C2",
            "-3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(9,A1,5,)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A1,5,)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "-sqrt(3213210)*(3*x**10-96*x**8*y**2-39*x**8*z**2+224*x**6*y**4+1344*x**6*y**2*z**2-42*x**6*z**4+224*x**4*y**6-6720*x**4*y**4*z**2+3360*x**4*y**2*z**4-182*x**4*z**6-96*x**2*y**8+1344*x**2*y**6*z**2+3360*x**2*y**4*z**4-2688*x**2*y**2*z**6+135*x**2*z**8+3*y**10-39*y**8*z**2-42*y**6*z**4-182*y**4*z**6+135*y**2*z**8-6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Qh(11,A1,5,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(10,A1,6,)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(x-y)*(x+y)*(9*x**8-165*x**6*y**2-231*x**6*z**2-25*x**4*y**4+3801*x**4*y**2*z**2+406*x**4*z**4-165*x**2*y**6+3801*x**2*y**4*z**2-9674*x**2*y**2*z**4+266*x**2*z**6+9*y**8-231*y**6*z**2+406*y**4*z**4+266*y**2*z**6-57*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Qh(11,A1,6,)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(2,A2,,)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Qh(3,A2,,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(4,A2,1,)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(5,A2,1,)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(6,A2,1,)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(7,A2,1,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Qh(8,A2,1,)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(9,A2,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Qh(10,A2,1,)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(11,A2,1,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Qh(4,A2,2,)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(5,A2,2,)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(6,A2,2,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(7,A2,2,)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(8,A2,2,)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(9,A2,2,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Qh(10,A2,2,)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(11,A2,2,)": (
            "S8",
            "-sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(6,A2,3,)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(7,A2,3,)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "-sqrt(77)*x*y*z*(3*x**4-20*x**2*y**2+10*x**2*z**2+3*y**4+10*y**2*z**2-6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Qh(8,A2,3,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(9,A2,3,)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(x-y)*(x+y)*(3*x**4-11*x**2*y**2-7*x**2*z**2+3*y**4-7*y**2*z**2+7*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Qh(10,A2,3,)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(11,A2,3,)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "-sqrt(230945)*x*y*z*(x**8-6*x**6*y**2-6*x**6*z**2+42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2-84*x**2*y**2*z**4+12*x**2*z**6+y**8-6*y**6*z**2+12*y**2*z**6-2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Qh(8,A2,4,)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,A2,4,)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Qh(10,A2,4,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(11,A2,4,)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A2,5,)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A2,5,)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "-sqrt(3003)*x*y*z*(5*x**8-150*x**6*y**2+90*x**6*z**2+336*x**4*y**4-70*x**4*y**2*z**2-168*x**4*z**4-150*x**2*y**6-70*x**2*y**4*z**2+140*x**2*y**2*z**4+60*x**2*z**6+5*y**8+90*y**6*z**2-168*y**4*z**4+60*y**2*z**6-10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Qh(1,B1,,)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(2,B1,,)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Qh(3,B1,1,)": (
            "-sqrt(6)*C1/4+sqrt(10)*C3/4",
            "x*(2*x**2-3*y**2-3*z**2)/2",
            "[-sqrt(5)/4,0,sqrt(3)/4,0,-sqrt(3)/4,0,sqrt(5)/4]",
        ),
        "Qh(4,B1,1,)": ("sqrt(14)*C1/4-sqrt(2)*C3/4", "-sqrt(35)*x*z*(x-z)*(x+z)/2", "[0,1/4,0,-sqrt(7)/4,0,sqrt(7)/4,0,-1/4,0]"),
        "Qh(5,B1,1,)": (
            "sqrt(15)*C1/8-sqrt(70)*C3/16+3*sqrt(14)*C5/16",
            "x*(8*x**4-40*x**2*y**2-40*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/8",
            "[-3*sqrt(7)/16,0,sqrt(35)/16,0,-sqrt(30)/16,0,sqrt(30)/16,0,-sqrt(35)/16,0,3*sqrt(7)/16]",
        ),
        "Qh(6,B1,1,)": (
            "-sqrt(3)*C1/4-sqrt(30)*C3/8+sqrt(22)*C5/8",
            "3*sqrt(7)*x*z*(x-z)*(x+z)*(x**2-10*y**2+z**2)/4",
            "[0,-sqrt(11)/8,0,sqrt(15)/8,0,sqrt(6)/8,0,-sqrt(6)/8,0,-sqrt(15)/8,0,sqrt(11)/8,0]",
        ),
        "Qh(7,B1,1,)": (
            "-5*sqrt(7)*C1/32+3*sqrt(21)*C3/32-sqrt(231)*C5/32+sqrt(429)*C7/32",
            "x*(16*x**6-168*x**4*y**2-168*x**4*z**2+210*x**2*y**4+420*x**2*y**2*z**2+210*x**2*z**4-35*y**6-105*y**4*z**2-105*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)/64,0,sqrt(462)/64,0,-3*sqrt(42)/64,0,5*sqrt(14)/64,0,-5*sqrt(14)/64,0,3*sqrt(42)/64,0,-sqrt(462)/64,0,sqrt(858)/64]",
        ),
        "Qh(8,B1,1,)": (
            "sqrt(715)*C1/32-sqrt(273)*C3/32+sqrt(35)*C5/32-C7/32",
            "-3*sqrt(715)*x*z*(x-z)*(x+z)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/16",
            "[0,sqrt(2)/64,0,-sqrt(70)/64,0,sqrt(546)/64,0,-sqrt(1430)/64,0,sqrt(1430)/64,0,-sqrt(546)/64,0,sqrt(70)/64,0,-sqrt(2)/64,0]",
        ),
        "Qh(9,B1,1,)": (
            "21*sqrt(5)*C1/128-sqrt(2310)*C3/128+3*sqrt(286)*C5/128-3*sqrt(1430)*C7/256+sqrt(24310)*C9/256",
            "x*(128*x**8-2304*x**6*y**2-2304*x**6*z**2+6048*x**4*y**4+12096*x**4*y**2*z**2+6048*x**4*z**4-3360*x**2*y**6-10080*x**2*y**4*z**2-10080*x**2*y**2*z**4-3360*x**2*z**6+315*y**8+1260*y**6*z**2+1890*y**4*z**4+1260*y**2*z**6+315*z**8)/128",
            "[-sqrt(12155)/256,0,3*sqrt(715)/256,0,-3*sqrt(143)/128,0,sqrt(1155)/128,0,-21*sqrt(10)/256,0,21*sqrt(10)/256,0,-sqrt(1155)/128,0,3*sqrt(143)/128,0,-3*sqrt(715)/256,0,sqrt(12155)/256]",
        ),
        "Qh(10,B1,1,)": (
            "-sqrt(221)*C1/32-sqrt(102)*C3/32+sqrt(510)*C5/32-11*sqrt(6)*C7/64+sqrt(38)*C9/64",
            "sqrt(12155)*x*z*(x-z)*(x+z)*(x**2-18*y**2+z**2)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/32",
            "[0,-sqrt(19)/64,0,11*sqrt(3)/64,0,-sqrt(255)/32,0,sqrt(51)/32,0,sqrt(442)/64,0,-sqrt(442)/64,0,-sqrt(51)/32,0,sqrt(255)/32,0,-11*sqrt(3)/64,0,sqrt(19)/64,0]",
        ),
        "Qh(11,B1,1,)": (
            "-21*sqrt(66)*C1/512+sqrt(88179)*C11/512+sqrt(30030)*C3/512-15*sqrt(143)*C5/512+sqrt(36465)*C7/512-sqrt(46189)*C9/512",
            "x*(256*x**10-7040*x**8*y**2-7040*x**8*z**2+31680*x**6*y**4+63360*x**6*y**2*z**2+31680*x**6*z**4-36960*x**4*y**6-110880*x**4*y**4*z**2-110880*x**4*y**2*z**4-36960*x**4*z**6+11550*x**2*y**8+46200*x**2*y**6*z**2+69300*x**2*y**4*z**4+46200*x**2*y**2*z**6+11550*x**2*z**8-693*y**10-3465*y**8*z**2-6930*y**6*z**4-6930*y**4*z**6-3465*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)/1024,0,sqrt(92378)/1024,0,-sqrt(72930)/1024,0,15*sqrt(286)/1024,0,-sqrt(15015)/512,0,21*sqrt(33)/512,0,-21*sqrt(33)/512,0,sqrt(15015)/512,0,-15*sqrt(286)/1024,0,sqrt(72930)/1024,0,-sqrt(92378)/1024,0,sqrt(176358)/1024]",
        ),
        "Qh(3,B1,2,)": (
            "-sqrt(10)*C1/4-sqrt(6)*C3/4",
            "sqrt(15)*x*(y-z)*(y+z)/2",
            "[sqrt(3)/4,0,sqrt(5)/4,0,-sqrt(5)/4,0,-sqrt(3)/4]",
        ),
        "Qh(4,B1,2,)": (
            "-sqrt(2)*C1/4-sqrt(14)*C3/4",
            "-sqrt(5)*x*z*(x**2-6*y**2+z**2)/2",
            "[0,sqrt(7)/4,0,1/4,0,-1/4,0,-sqrt(7)/4,0]",
        ),
        "Qh(5,B1,2,)": (
            "sqrt(21)*C1/8+9*sqrt(2)*C3/16+sqrt(10)*C5/16",
            "3*sqrt(35)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/8",
            "[-sqrt(5)/16,0,-9/16,0,-sqrt(42)/16,0,sqrt(42)/16,0,9/16,0,sqrt(5)/16]",
        ),
        "Qh(6,B1,2,)": (
            "3*sqrt(22)*C1/16-sqrt(55)*C3/16+sqrt(3)*C5/16",
            "sqrt(462)*x*z*(x**2-3*z**2)*(3*x**2-z**2)/16",
            "[0,-sqrt(6)/32,0,sqrt(110)/32,0,-3*sqrt(11)/16,0,3*sqrt(11)/16,0,-sqrt(110)/32,0,sqrt(6)/32,0]",
        ),
        "Qh(7,B1,2,)": (
            "-3*sqrt(33)*C1/32-sqrt(11)*C3/32+25*C5/32+sqrt(91)*C7/32",
            "sqrt(231)*x*(10*x**2-3*y**2-3*z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[-sqrt(182)/64,0,-25*sqrt(2)/64,0,sqrt(22)/64,0,3*sqrt(66)/64,0,-3*sqrt(66)/64,0,-sqrt(22)/64,0,25*sqrt(2)/64,0,sqrt(182)/64]",
        ),
        "Qh(8,B1,2,)": (
            "sqrt(77)*C1/32+5*sqrt(15)*C3/32+3*sqrt(13)*C5/32-sqrt(455)*C7/32",
            "-3*sqrt(77)*x*z*(x-z)*(x+z)*(x**4-24*x**2*y**2+2*x**2*z**2+40*y**4-24*y**2*z**2+z**4)/16",
            "[0,sqrt(910)/64,0,-3*sqrt(26)/64,0,-5*sqrt(30)/64,0,-sqrt(154)/64,0,sqrt(154)/64,0,5*sqrt(30)/64,0,3*sqrt(26)/64,0,-sqrt(910)/64,0]",
        ),
        "Qh(9,B1,2,)": (
            "sqrt(2431)*C1/128+sqrt(9282)*C3/128+5*sqrt(170)*C5/128+7*sqrt(34)*C7/256+3*sqrt(2)*C9/256",
            "3*sqrt(12155)*x*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/128",
            "[-3/256,0,-7*sqrt(17)/256,0,-5*sqrt(85)/128,0,-sqrt(4641)/128,0,-sqrt(4862)/256,0,sqrt(4862)/256,0,sqrt(4641)/128,0,5*sqrt(85)/128,0,7*sqrt(17)/256,0,3/256]",
        ),
        "Qh(10,B1,2,)": (
            "-sqrt(39)*C1/32-11*sqrt(2)*C3/32-5*sqrt(10)*C5/32-sqrt(34)*C7/64+sqrt(1938)*C9/64",
            "sqrt(2145)*x*z*(x-z)*(x+z)*(x**6-42*x**4*y**2+3*x**4*z**2+168*x**2*y**4-84*x**2*y**2*z**2+3*x**2*z**4-112*y**6+168*y**4*z**2-42*y**2*z**4+z**6)/32",
            "[0,-sqrt(969)/64,0,sqrt(17)/64,0,5*sqrt(5)/32,0,11/32,0,sqrt(78)/64,0,-sqrt(78)/64,0,-11/32,0,-5*sqrt(5)/32,0,-sqrt(17)/64,0,sqrt(969)/64,0]",
        ),
        "Qh(11,B1,2,)": (
            "-sqrt(41990)*C1/512+sqrt(385)*C11/512-3*sqrt(4522)*C3/512+3*sqrt(4845)*C5/512+77*sqrt(19)*C7/512+39*sqrt(15)*C9/512",
            "sqrt(692835)*x*(6*x**2-y**2-z**2)*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/256",
            "[-sqrt(770)/1024,0,-39*sqrt(30)/1024,0,-77*sqrt(38)/1024,0,-3*sqrt(9690)/1024,0,3*sqrt(2261)/512,0,sqrt(20995)/512,0,-sqrt(20995)/512,0,-3*sqrt(2261)/512,0,3*sqrt(9690)/1024,0,77*sqrt(38)/1024,0,39*sqrt(30)/1024,0,sqrt(770)/1024]",
        ),
        "Qh(5,B1,3,)": (
            "sqrt(7)*C1/4-sqrt(6)*C3/8-sqrt(30)*C5/8",
            "sqrt(105)*x*(y-z)*(y+z)*(2*x**2-y**2-z**2)/4",
            "[sqrt(15)/8,0,sqrt(3)/8,0,-sqrt(14)/8,0,sqrt(14)/8,0,-sqrt(3)/8,0,-sqrt(15)/8]",
        ),
        "Qh(6,B1,3,)": (
            "sqrt(10)*C1/16+9*C3/16+sqrt(165)*C5/16",
            "sqrt(210)*x*z*(x**4-16*x**2*y**2+2*x**2*z**2+16*y**4-16*y**2*z**2+z**4)/16",
            "[0,-sqrt(330)/32,0,-9*sqrt(2)/32,0,-sqrt(5)/16,0,sqrt(5)/16,0,9*sqrt(2)/32,0,sqrt(330)/32,0]",
        ),
        "Qh(7,B1,3,)": (
            "-sqrt(858)*C1/64-3*sqrt(286)*C3/64-5*sqrt(26)*C5/64-sqrt(14)*C7/64",
            "sqrt(6006)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/32",
            "[sqrt(7)/64,0,5*sqrt(13)/64,0,3*sqrt(143)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-3*sqrt(143)/64,0,-5*sqrt(13)/64,0,-sqrt(7)/64]",
        ),
        "Qh(8,B1,3,)": (
            "-sqrt(858)*C1/64-sqrt(910)*C3/64+7*sqrt(42)*C5/64-3*sqrt(30)*C7/64",
            "-sqrt(858)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(x**2-14*y**2+z**2)/32",
            "[0,3*sqrt(15)/64,0,-7*sqrt(21)/64,0,sqrt(455)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-sqrt(455)/64,0,7*sqrt(21)/64,0,-3*sqrt(15)/64,0]",
        ),
        "Qh(9,B1,3,)": (
            "sqrt(1001)*C1/64-sqrt(78)*C3/64-3*sqrt(70)*C5/64+23*sqrt(14)*C7/128+3*sqrt(238)*C9/128",
            "3*sqrt(5005)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(8*x**4-8*x**2*y**2-8*x**2*z**2+y**4+2*y**2*z**2+z**4)/64",
            "[-3*sqrt(119)/128,0,-23*sqrt(7)/128,0,3*sqrt(35)/64,0,sqrt(39)/64,0,-sqrt(2002)/128,0,sqrt(2002)/128,0,-sqrt(39)/64,0,-3*sqrt(35)/64,0,23*sqrt(7)/128,0,3*sqrt(119)/128]",
        ),
        "Qh(10,B1,3,)": (
            "sqrt(41990)*C1/256-sqrt(4845)*C3/128+sqrt(969)*C5/128-sqrt(285)*C7/256+sqrt(5)*C9/256",
            "sqrt(92378)*x*z*(x**4-10*x**2*z**2+5*z**4)*(5*x**4-10*x**2*z**2+z**4)/256",
            "[0,-sqrt(10)/512,0,sqrt(570)/512,0,-sqrt(1938)/256,0,sqrt(9690)/256,0,-sqrt(20995)/256,0,sqrt(20995)/256,0,-sqrt(9690)/256,0,sqrt(1938)/256,0,-sqrt(570)/512,0,sqrt(10)/512,0]",
        ),
        "Qh(11,B1,3,)": (
            "-5*sqrt(546)*C1/256+sqrt(10659)*C11/256+11*sqrt(30)*C3/256+13*sqrt(7)*C5/256-3*sqrt(1785)*C7/256+3*sqrt(2261)*C9/256",
            "3*sqrt(1001)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(80*x**6-168*x**4*y**2-168*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-5*y**6-15*y**4*z**2-15*y**2*z**4-5*z**6)/128",
            "[-sqrt(21318)/512,0,-3*sqrt(4522)/512,0,3*sqrt(3570)/512,0,-13*sqrt(14)/512,0,-11*sqrt(15)/256,0,5*sqrt(273)/256,0,-5*sqrt(273)/256,0,11*sqrt(15)/256,0,13*sqrt(14)/512,0,-3*sqrt(3570)/512,0,3*sqrt(4522)/512,0,sqrt(21318)/512]",
        ),
        "Qh(7,B1,4,)": (
            "-15*sqrt(6)*C1/64+19*sqrt(2)*C3/64-sqrt(22)*C5/64-sqrt(2002)*C7/64",
            "sqrt(42)*x*(y-z)*(y+z)*(48*x**4-80*x**2*y**2-80*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/32",
            "[sqrt(1001)/64,0,sqrt(11)/64,0,-19/64,0,15*sqrt(3)/64,0,-15*sqrt(3)/64,0,19/64,0,-sqrt(11)/64,0,-sqrt(1001)/64]",
        ),
        "Qh(8,B1,4,)": (
            "-sqrt(70)*C1/64-3*sqrt(66)*C3/64-sqrt(1430)*C5/64-sqrt(2002)*C7/64",
            "-3*sqrt(70)*x*z*(x**6-30*x**4*y**2+3*x**4*z**2+80*x**2*y**4-60*x**2*y**2*z**2+3*x**2*z**4-32*y**6+80*y**4*z**2-30*y**2*z**4+z**6)/32",
            "[0,sqrt(1001)/64,0,sqrt(715)/64,0,3*sqrt(33)/64,0,sqrt(35)/64,0,-sqrt(35)/64,0,-3*sqrt(33)/64,0,-sqrt(715)/64,0,-sqrt(1001)/64,0]",
        ),
        "Qh(9,B1,4,)": (
            "sqrt(858)*C1/64+sqrt(91)*C3/32-5*sqrt(15)*C5/32-21*sqrt(3)*C7/64-sqrt(51)*C9/64",
            "sqrt(4290)*x*(y-z)*(y+z)*(14*x**2-3*y**2-3*z**2)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/64",
            "[sqrt(102)/128,0,21*sqrt(6)/128,0,5*sqrt(30)/64,0,-sqrt(182)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(182)/64,0,-5*sqrt(30)/64,0,-21*sqrt(6)/128,0,-sqrt(102)/128]",
        ),
        "Qh(10,B1,4,)": (
            "9*sqrt(78)*C1/256+69*C3/128-sqrt(5)*C5/128-43*sqrt(17)*C7/256+3*sqrt(969)*C9/256",
            "sqrt(4290)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(3*x**4-96*x**2*y**2+6*x**2*z**2+224*y**4-96*y**2*z**2+3*z**4)/256",
            "[0,-3*sqrt(1938)/512,0,43*sqrt(34)/512,0,sqrt(10)/256,0,-69*sqrt(2)/256,0,-9*sqrt(39)/256,0,9*sqrt(39)/256,0,69*sqrt(2)/256,0,-sqrt(10)/256,0,-43*sqrt(34)/512,0,3*sqrt(1938)/512,0]",
        ),
        "Qh(11,B1,4,)": (
            "-sqrt(29393)*C1/512-sqrt(22)*C11/1024-9*sqrt(1615)*C3/512-5*sqrt(13566)*C5/1024-7*sqrt(1330)*C7/1024-9*sqrt(42)*C9/1024",
            "sqrt(1939938)*x*(y-z)*(y+z)*(y**4-4*y**3*z-14*y**2*z**2-4*y*z**3+z**4)*(y**4+4*y**3*z-14*y**2*z**2+4*y*z**3+z**4)/512",
            "[sqrt(11)/1024,0,9*sqrt(21)/1024,0,7*sqrt(665)/1024,0,5*sqrt(6783)/1024,0,9*sqrt(3230)/1024,0,sqrt(58786)/1024,0,-sqrt(58786)/1024,0,-9*sqrt(3230)/1024,0,-5*sqrt(6783)/1024,0,-7*sqrt(665)/1024,0,-9*sqrt(21)/1024,0,-sqrt(11)/1024]",
        ),
        "Qh(9,B1,5,)": (
            "7*sqrt(22)*C1/64-3*sqrt(21)*C3/32+sqrt(65)*C5/32+sqrt(13)*C7/64-3*sqrt(221)*C9/64",
            "3*sqrt(110)*x*(y-z)*(y+z)*(32*x**6-112*x**4*y**2-112*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-7*y**6-21*y**4*z**2-21*y**2*z**4-7*z**6)/64",
            "[3*sqrt(442)/128,0,-sqrt(26)/128,0,-sqrt(130)/64,0,3*sqrt(42)/64,0,-7*sqrt(11)/64,0,7*sqrt(11)/64,0,-3*sqrt(42)/64,0,sqrt(130)/64,0,sqrt(26)/128,0,-3*sqrt(442)/128]",
        ),
        "Qh(10,B1,5,)": (
            "7*sqrt(3)*C1/128+7*sqrt(26)*C3/128+5*sqrt(130)*C5/128+7*sqrt(442)*C7/256+sqrt(25194)*C9/256",
            "sqrt(165)*x*z*(7*x**8-336*x**6*y**2+28*x**6*z**2+1680*x**4*y**4-1008*x**4*y**2*z**2+42*x**4*z**4-1792*x**2*y**6+3360*x**2*y**4*z**2-1008*x**2*y**2*z**4+28*x**2*z**6+384*y**8-1792*y**6*z**2+1680*y**4*z**4-336*y**2*z**6+7*z**8)/128",
            "[0,-sqrt(12597)/256,0,-7*sqrt(221)/256,0,-5*sqrt(65)/128,0,-7*sqrt(13)/128,0,-7*sqrt(6)/256,0,7*sqrt(6)/256,0,7*sqrt(13)/128,0,5*sqrt(65)/128,0,7*sqrt(221)/256,0,sqrt(12597)/256,0]",
        ),
        "Qh(11,B1,5,)": (
            "-15*sqrt(221)*C1/512-3*sqrt(2926)*C11/1024-sqrt(595)*C3/512+53*sqrt(102)*C5/1024-105*sqrt(10)*C7/1024-61*sqrt(114)*C9/1024",
            "sqrt(14586)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)*(224*x**4-160*x**2*y**2-160*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/512",
            "[3*sqrt(1463)/1024,0,61*sqrt(57)/1024,0,105*sqrt(5)/1024,0,-53*sqrt(51)/1024,0,sqrt(1190)/1024,0,15*sqrt(442)/1024,0,-15*sqrt(442)/1024,0,-sqrt(1190)/1024,0,53*sqrt(51)/1024,0,-105*sqrt(5)/1024,0,-61*sqrt(57)/1024,0,-3*sqrt(1463)/1024]",
        ),
        "Qh(11,B1,6,)": (
            "-21*sqrt(130)*C1/512-sqrt(124355)*C11/512+57*sqrt(14)*C3/512-41*sqrt(15)*C5/512+17*sqrt(17)*C7/512+sqrt(4845)*C9/512",
            "sqrt(2145)*x*(y-z)*(y+z)*(128*x**8-768*x**6*y**2-768*x**6*z**2+1008*x**4*y**4+2016*x**4*y**2*z**2+1008*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+21*y**8+84*y**6*z**2+126*y**4*z**4+84*y**2*z**6+21*z**8)/256",
            "[sqrt(248710)/1024,0,-sqrt(9690)/1024,0,-17*sqrt(34)/1024,0,41*sqrt(30)/1024,0,-57*sqrt(7)/512,0,21*sqrt(65)/512,0,-21*sqrt(65)/512,0,57*sqrt(7)/512,0,-41*sqrt(30)/1024,0,17*sqrt(34)/1024,0,sqrt(9690)/1024,0,-sqrt(248710)/1024]",
        ),
        "Qh(1,B2,,)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(2,B2,,)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(3,B2,1,)": (
            "-sqrt(6)*S1/4-sqrt(10)*S3/4",
            "-y*(3*x**2-2*y**2+3*z**2)/2",
            "[-sqrt(5)*I/4,0,-sqrt(3)*I/4,0,-sqrt(3)*I/4,0,-sqrt(5)*I/4]",
        ),
        "Qh(4,B2,1,)": (
            "-sqrt(14)*S1/4-sqrt(2)*S3/4",
            "sqrt(35)*y*z*(y-z)*(y+z)/2",
            "[0,-I/4,0,-sqrt(7)*I/4,0,-sqrt(7)*I/4,0,-I/4,0]",
        ),
        "Qh(5,B2,1,)": (
            "sqrt(15)*S1/8+sqrt(70)*S3/16+3*sqrt(14)*S5/16",
            "y*(15*x**4-40*x**2*y**2+30*x**2*z**2+8*y**4-40*y**2*z**2+15*z**4)/8",
            "[3*sqrt(7)*I/16,0,sqrt(35)*I/16,0,sqrt(30)*I/16,0,sqrt(30)*I/16,0,sqrt(35)*I/16,0,3*sqrt(7)*I/16]",
        ),
        "Qh(6,B2,1,)": (
            "sqrt(3)*S1/4-sqrt(30)*S3/8-sqrt(22)*S5/8",
            "3*sqrt(7)*y*z*(y-z)*(y+z)*(10*x**2-y**2-z**2)/4",
            "[0,-sqrt(11)*I/8,0,-sqrt(15)*I/8,0,sqrt(6)*I/8,0,sqrt(6)*I/8,0,-sqrt(15)*I/8,0,-sqrt(11)*I/8,0]",
        ),
        "Qh(7,B2,1,)": (
            "-5*sqrt(7)*S1/32-3*sqrt(21)*S3/32-sqrt(231)*S5/32-sqrt(429)*S7/32",
            "-y*(35*x**6-210*x**4*y**2+105*x**4*z**2+168*x**2*y**4-420*x**2*y**2*z**2+105*x**2*z**4-16*y**6+168*y**4*z**2-210*y**2*z**4+35*z**6)/16",
            "[-sqrt(858)*I/64,0,-sqrt(462)*I/64,0,-3*sqrt(42)*I/64,0,-5*sqrt(14)*I/64,0,-5*sqrt(14)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(462)*I/64,0,-sqrt(858)*I/64]",
        ),
        "Qh(8,B2,1,)": (
            "-sqrt(715)*S1/32-sqrt(273)*S3/32-sqrt(35)*S5/32-S7/32",
            "3*sqrt(715)*y*z*(y-z)*(y+z)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[0,-sqrt(2)*I/64,0,-sqrt(70)*I/64,0,-sqrt(546)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(546)*I/64,0,-sqrt(70)*I/64,0,-sqrt(2)*I/64,0]",
        ),
        "Qh(9,B2,1,)": (
            "21*sqrt(5)*S1/128+sqrt(2310)*S3/128+3*sqrt(286)*S5/128+3*sqrt(1430)*S7/256+sqrt(24310)*S9/256",
            "y*(315*x**8-3360*x**6*y**2+1260*x**6*z**2+6048*x**4*y**4-10080*x**4*y**2*z**2+1890*x**4*z**4-2304*x**2*y**6+12096*x**2*y**4*z**2-10080*x**2*y**2*z**4+1260*x**2*z**6+128*y**8-2304*y**6*z**2+6048*y**4*z**4-3360*y**2*z**6+315*z**8)/128",
            "[sqrt(12155)*I/256,0,3*sqrt(715)*I/256,0,3*sqrt(143)*I/128,0,sqrt(1155)*I/128,0,21*sqrt(10)*I/256,0,21*sqrt(10)*I/256,0,sqrt(1155)*I/128,0,3*sqrt(143)*I/128,0,3*sqrt(715)*I/256,0,sqrt(12155)*I/256]",
        ),
        "Qh(10,B2,1,)": (
            "sqrt(221)*S1/32-sqrt(102)*S3/32-sqrt(510)*S5/32-11*sqrt(6)*S7/64-sqrt(38)*S9/64",
            "sqrt(12155)*y*z*(y-z)*(y+z)*(18*x**2-y**2-z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/32",
            "[0,-sqrt(19)*I/64,0,-11*sqrt(3)*I/64,0,-sqrt(255)*I/32,0,-sqrt(51)*I/32,0,sqrt(442)*I/64,0,sqrt(442)*I/64,0,-sqrt(51)*I/32,0,-sqrt(255)*I/32,0,-11*sqrt(3)*I/64,0,-sqrt(19)*I/64,0]",
        ),
        "Qh(11,B2,1,)": (
            "-21*sqrt(66)*S1/512-sqrt(88179)*S11/512-sqrt(30030)*S3/512-15*sqrt(143)*S5/512-sqrt(36465)*S7/512-sqrt(46189)*S9/512",
            "-y*(693*x**10-11550*x**8*y**2+3465*x**8*z**2+36960*x**6*y**4-46200*x**6*y**2*z**2+6930*x**6*z**4-31680*x**4*y**6+110880*x**4*y**4*z**2-69300*x**4*y**2*z**4+6930*x**4*z**6+7040*x**2*y**8-63360*x**2*y**6*z**2+110880*x**2*y**4*z**4-46200*x**2*y**2*z**6+3465*x**2*z**8-256*y**10+7040*y**8*z**2-31680*y**6*z**4+36960*y**4*z**6-11550*y**2*z**8+693*z**10)/256",
            "[-sqrt(176358)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(72930)*I/1024,0,-15*sqrt(286)*I/1024,0,-sqrt(15015)*I/512,0,-21*sqrt(33)*I/512,0,-21*sqrt(33)*I/512,0,-sqrt(15015)*I/512,0,-15*sqrt(286)*I/1024,0,-sqrt(72930)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(176358)*I/1024]",
        ),
        "Qh(3,B2,2,)": (
            "sqrt(10)*S1/4-sqrt(6)*S3/4",
            "-sqrt(15)*y*(x-z)*(x+z)/2",
            "[-sqrt(3)*I/4,0,sqrt(5)*I/4,0,sqrt(5)*I/4,0,-sqrt(3)*I/4]",
        ),
        "Qh(4,B2,2,)": (
            "-sqrt(2)*S1/4+sqrt(14)*S3/4",
            "sqrt(5)*y*z*(6*x**2-y**2-z**2)/2",
            "[0,sqrt(7)*I/4,0,-I/4,0,-I/4,0,sqrt(7)*I/4,0]",
        ),
        "Qh(5,B2,2,)": (
            "sqrt(21)*S1/8-9*sqrt(2)*S3/16+sqrt(10)*S5/16",
            "3*sqrt(35)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/8",
            "[sqrt(5)*I/16,0,-9*I/16,0,sqrt(42)*I/16,0,sqrt(42)*I/16,0,-9*I/16,0,sqrt(5)*I/16]",
        ),
        "Qh(6,B2,2,)": (
            "3*sqrt(22)*S1/16+sqrt(55)*S3/16+sqrt(3)*S5/16",
            "sqrt(462)*y*z*(y**2-3*z**2)*(3*y**2-z**2)/16",
            "[0,sqrt(6)*I/32,0,sqrt(110)*I/32,0,3*sqrt(11)*I/16,0,3*sqrt(11)*I/16,0,sqrt(110)*I/32,0,sqrt(6)*I/32,0]",
        ),
        "Qh(7,B2,2,)": (
            "-3*sqrt(33)*S1/32+sqrt(11)*S3/32+25*S5/32-sqrt(91)*S7/32",
            "-sqrt(231)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(3*x**2-10*y**2+3*z**2)/16",
            "[-sqrt(182)*I/64,0,25*sqrt(2)*I/64,0,sqrt(22)*I/64,0,-3*sqrt(66)*I/64,0,-3*sqrt(66)*I/64,0,sqrt(22)*I/64,0,25*sqrt(2)*I/64,0,-sqrt(182)*I/64]",
        ),
        "Qh(8,B2,2,)": (
            "-sqrt(77)*S1/32+5*sqrt(15)*S3/32-3*sqrt(13)*S5/32-sqrt(455)*S7/32",
            "3*sqrt(77)*y*z*(y-z)*(y+z)*(40*x**4-24*x**2*y**2-24*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,-sqrt(910)*I/64,0,-3*sqrt(26)*I/64,0,5*sqrt(30)*I/64,0,-sqrt(154)*I/64,0,-sqrt(154)*I/64,0,5*sqrt(30)*I/64,0,-3*sqrt(26)*I/64,0,-sqrt(910)*I/64,0]",
        ),
        "Qh(9,B2,2,)": (
            "sqrt(2431)*S1/128-sqrt(9282)*S3/128+5*sqrt(170)*S5/128-7*sqrt(34)*S7/256+3*sqrt(2)*S9/256",
            "3*sqrt(12155)*y*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/128",
            "[3*I/256,0,-7*sqrt(17)*I/256,0,5*sqrt(85)*I/128,0,-sqrt(4641)*I/128,0,sqrt(4862)*I/256,0,sqrt(4862)*I/256,0,-sqrt(4641)*I/128,0,5*sqrt(85)*I/128,0,-7*sqrt(17)*I/256,0,3*I/256]",
        ),
        "Qh(10,B2,2,)": (
            "sqrt(39)*S1/32-11*sqrt(2)*S3/32+5*sqrt(10)*S5/32-sqrt(34)*S7/64-sqrt(1938)*S9/64",
            "sqrt(2145)*y*z*(y-z)*(y+z)*(112*x**6-168*x**4*y**2-168*x**4*z**2+42*x**2*y**4+84*x**2*y**2*z**2+42*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,-sqrt(969)*I/64,0,-sqrt(17)*I/64,0,5*sqrt(5)*I/32,0,-11*I/32,0,sqrt(78)*I/64,0,sqrt(78)*I/64,0,-11*I/32,0,5*sqrt(5)*I/32,0,-sqrt(17)*I/64,0,-sqrt(969)*I/64,0]",
        ),
        "Qh(11,B2,2,)": (
            "-sqrt(41990)*S1/512-sqrt(385)*S11/512+3*sqrt(4522)*S3/512+3*sqrt(4845)*S5/512-77*sqrt(19)*S7/512+39*sqrt(15)*S9/512",
            "-sqrt(692835)*y*(x**2-6*y**2+z**2)*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/256",
            "[-sqrt(770)*I/1024,0,39*sqrt(30)*I/1024,0,-77*sqrt(38)*I/1024,0,3*sqrt(9690)*I/1024,0,3*sqrt(2261)*I/512,0,-sqrt(20995)*I/512,0,-sqrt(20995)*I/512,0,3*sqrt(2261)*I/512,0,3*sqrt(9690)*I/1024,0,-77*sqrt(38)*I/1024,0,39*sqrt(30)*I/1024,0,-sqrt(770)*I/1024]",
        ),
        "Qh(5,B2,3,)": (
            "-sqrt(7)*S1/4-sqrt(6)*S3/8+sqrt(30)*S5/8",
            "sqrt(105)*y*(x-z)*(x+z)*(x**2-2*y**2+z**2)/4",
            "[sqrt(15)*I/8,0,-sqrt(3)*I/8,0,-sqrt(14)*I/8,0,-sqrt(14)*I/8,0,-sqrt(3)*I/8,0,sqrt(15)*I/8]",
        ),
        "Qh(6,B2,3,)": (
            "sqrt(10)*S1/16-9*S3/16+sqrt(165)*S5/16",
            "sqrt(210)*y*z*(16*x**4-16*x**2*y**2-16*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,sqrt(330)*I/32,0,-9*sqrt(2)*I/32,0,sqrt(5)*I/16,0,sqrt(5)*I/16,0,-9*sqrt(2)*I/32,0,sqrt(330)*I/32,0]",
        ),
        "Qh(7,B2,3,)": (
            "sqrt(858)*S1/64-3*sqrt(286)*S3/64+5*sqrt(26)*S5/64-sqrt(14)*S7/64",
            "-sqrt(6006)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)/32",
            "[-sqrt(7)*I/64,0,5*sqrt(13)*I/64,0,-3*sqrt(143)*I/64,0,sqrt(429)*I/64,0,sqrt(429)*I/64,0,-3*sqrt(143)*I/64,0,5*sqrt(13)*I/64,0,-sqrt(7)*I/64]",
        ),
        "Qh(8,B2,3,)": (
            "-sqrt(858)*S1/64+sqrt(910)*S3/64+7*sqrt(42)*S5/64+3*sqrt(30)*S7/64",
            "sqrt(858)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(14*x**2-y**2-z**2)/32",
            "[0,3*sqrt(15)*I/64,0,7*sqrt(21)*I/64,0,sqrt(455)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(455)*I/64,0,7*sqrt(21)*I/64,0,3*sqrt(15)*I/64,0]",
        ),
        "Qh(9,B2,3,)": (
            "sqrt(1001)*S1/64+sqrt(78)*S3/64-3*sqrt(70)*S5/64-23*sqrt(14)*S7/128+3*sqrt(238)*S9/128",
            "3*sqrt(5005)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(x**4-8*x**2*y**2+2*x**2*z**2+8*y**4-8*y**2*z**2+z**4)/64",
            "[3*sqrt(119)*I/128,0,-23*sqrt(7)*I/128,0,-3*sqrt(35)*I/64,0,sqrt(39)*I/64,0,sqrt(2002)*I/128,0,sqrt(2002)*I/128,0,sqrt(39)*I/64,0,-3*sqrt(35)*I/64,0,-23*sqrt(7)*I/128,0,3*sqrt(119)*I/128]",
        ),
        "Qh(10,B2,3,)": (
            "sqrt(41990)*S1/256+sqrt(4845)*S3/128+sqrt(969)*S5/128+sqrt(285)*S7/256+sqrt(5)*S9/256",
            "sqrt(92378)*y*z*(y**4-10*y**2*z**2+5*z**4)*(5*y**4-10*y**2*z**2+z**4)/256",
            "[0,sqrt(10)*I/512,0,sqrt(570)*I/512,0,sqrt(1938)*I/256,0,sqrt(9690)*I/256,0,sqrt(20995)*I/256,0,sqrt(20995)*I/256,0,sqrt(9690)*I/256,0,sqrt(1938)*I/256,0,sqrt(570)*I/512,0,sqrt(10)*I/512,0]",
        ),
        "Qh(11,B2,3,)": (
            "-5*sqrt(546)*S1/256-sqrt(10659)*S11/256-11*sqrt(30)*S3/256+13*sqrt(7)*S5/256+3*sqrt(1785)*S7/256+3*sqrt(2261)*S9/256",
            "-3*sqrt(1001)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(5*x**6-70*x**4*y**2+15*x**4*z**2+168*x**2*y**4-140*x**2*y**2*z**2+15*x**2*z**4-80*y**6+168*y**4*z**2-70*y**2*z**4+5*z**6)/128",
            "[-sqrt(21318)*I/512,0,3*sqrt(4522)*I/512,0,3*sqrt(3570)*I/512,0,13*sqrt(14)*I/512,0,-11*sqrt(15)*I/256,0,-5*sqrt(273)*I/256,0,-5*sqrt(273)*I/256,0,-11*sqrt(15)*I/256,0,13*sqrt(14)*I/512,0,3*sqrt(3570)*I/512,0,3*sqrt(4522)*I/512,0,-sqrt(21318)*I/512]",
        ),
        "Qh(7,B2,4,)": (
            "15*sqrt(6)*S1/64+19*sqrt(2)*S3/64+sqrt(22)*S5/64-sqrt(2002)*S7/64",
            "-sqrt(42)*y*(x-z)*(x+z)*(15*x**4-80*x**2*y**2+30*x**2*z**2+48*y**4-80*y**2*z**2+15*z**4)/32",
            "[-sqrt(1001)*I/64,0,sqrt(11)*I/64,0,19*I/64,0,15*sqrt(3)*I/64,0,15*sqrt(3)*I/64,0,19*I/64,0,sqrt(11)*I/64,0,-sqrt(1001)*I/64]",
        ),
        "Qh(8,B2,4,)": (
            "-sqrt(70)*S1/64+3*sqrt(66)*S3/64-sqrt(1430)*S5/64+sqrt(2002)*S7/64",
            "3*sqrt(70)*y*z*(32*x**6-80*x**4*y**2-80*x**4*z**2+30*x**2*y**4+60*x**2*y**2*z**2+30*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,sqrt(1001)*I/64,0,-sqrt(715)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(35)*I/64,0,-sqrt(35)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(715)*I/64,0,sqrt(1001)*I/64,0]",
        ),
        "Qh(9,B2,4,)": (
            "-sqrt(858)*S1/64+sqrt(91)*S3/32+5*sqrt(15)*S5/32-21*sqrt(3)*S7/64+sqrt(51)*S9/64",
            "sqrt(4290)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(3*x**2-14*y**2+3*z**2)/64",
            "[sqrt(102)*I/128,0,-21*sqrt(6)*I/128,0,5*sqrt(30)*I/64,0,sqrt(182)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(182)*I/64,0,5*sqrt(30)*I/64,0,-21*sqrt(6)*I/128,0,sqrt(102)*I/128]",
        ),
        "Qh(10,B2,4,)": (
            "9*sqrt(78)*S1/256-69*S3/128-sqrt(5)*S5/128+43*sqrt(17)*S7/256+3*sqrt(969)*S9/256",
            "sqrt(4290)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(224*x**4-96*x**2*y**2-96*x**2*z**2+3*y**4+6*y**2*z**2+3*z**4)/256",
            "[0,3*sqrt(1938)*I/512,0,43*sqrt(34)*I/512,0,-sqrt(10)*I/256,0,-69*sqrt(2)*I/256,0,9*sqrt(39)*I/256,0,9*sqrt(39)*I/256,0,-69*sqrt(2)*I/256,0,-sqrt(10)*I/256,0,43*sqrt(34)*I/512,0,3*sqrt(1938)*I/512,0]",
        ),
        "Qh(11,B2,4,)": (
            "sqrt(29393)*S1/512-sqrt(22)*S11/1024-9*sqrt(1615)*S3/512+5*sqrt(13566)*S5/1024-7*sqrt(1330)*S7/1024+9*sqrt(42)*S9/1024",
            "-sqrt(1939938)*y*(x-z)*(x+z)*(x**4-4*x**3*z-14*x**2*z**2-4*x*z**3+z**4)*(x**4+4*x**3*z-14*x**2*z**2+4*x*z**3+z**4)/512",
            "[-sqrt(11)*I/1024,0,9*sqrt(21)*I/1024,0,-7*sqrt(665)*I/1024,0,5*sqrt(6783)*I/1024,0,-9*sqrt(3230)*I/1024,0,sqrt(58786)*I/1024,0,sqrt(58786)*I/1024,0,-9*sqrt(3230)*I/1024,0,5*sqrt(6783)*I/1024,0,-7*sqrt(665)*I/1024,0,9*sqrt(21)*I/1024,0,-sqrt(11)*I/1024]",
        ),
        "Qh(9,B2,5,)": (
            "-7*sqrt(22)*S1/64-3*sqrt(21)*S3/32-sqrt(65)*S5/32+sqrt(13)*S7/64+3*sqrt(221)*S9/64",
            "3*sqrt(110)*y*(x-z)*(x+z)*(7*x**6-70*x**4*y**2+21*x**4*z**2+112*x**2*y**4-140*x**2*y**2*z**2+21*x**2*z**4-32*y**6+112*y**4*z**2-70*y**2*z**4+7*z**6)/64",
            "[3*sqrt(442)*I/128,0,sqrt(26)*I/128,0,-sqrt(130)*I/64,0,-3*sqrt(42)*I/64,0,-7*sqrt(11)*I/64,0,-7*sqrt(11)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(130)*I/64,0,sqrt(26)*I/128,0,3*sqrt(442)*I/128]",
        ),
        "Qh(10,B2,5,)": (
            "7*sqrt(3)*S1/128-7*sqrt(26)*S3/128+5*sqrt(130)*S5/128-7*sqrt(442)*S7/256+sqrt(25194)*S9/256",
            "sqrt(165)*y*z*(384*x**8-1792*x**6*y**2-1792*x**6*z**2+1680*x**4*y**4+3360*x**4*y**2*z**2+1680*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+7*y**8+28*y**6*z**2+42*y**4*z**4+28*y**2*z**6+7*z**8)/128",
            "[0,sqrt(12597)*I/256,0,-7*sqrt(221)*I/256,0,5*sqrt(65)*I/128,0,-7*sqrt(13)*I/128,0,7*sqrt(6)*I/256,0,7*sqrt(6)*I/256,0,-7*sqrt(13)*I/128,0,5*sqrt(65)*I/128,0,-7*sqrt(221)*I/256,0,sqrt(12597)*I/256,0]",
        ),
        "Qh(11,B2,5,)": (
            "15*sqrt(221)*S1/512-3*sqrt(2926)*S11/1024-sqrt(595)*S3/512-53*sqrt(102)*S5/1024-105*sqrt(10)*S7/1024+61*sqrt(114)*S9/1024",
            "-sqrt(14586)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(15*x**4-160*x**2*y**2+30*x**2*z**2+224*y**4-160*y**2*z**2+15*z**4)/512",
            "[-3*sqrt(1463)*I/1024,0,61*sqrt(57)*I/1024,0,-105*sqrt(5)*I/1024,0,-53*sqrt(51)*I/1024,0,-sqrt(1190)*I/1024,0,15*sqrt(442)*I/1024,0,15*sqrt(442)*I/1024,0,-sqrt(1190)*I/1024,0,-53*sqrt(51)*I/1024,0,-105*sqrt(5)*I/1024,0,61*sqrt(57)*I/1024,0,-3*sqrt(1463)*I/1024]",
        ),
        "Qh(11,B2,6,)": (
            "21*sqrt(130)*S1/512-sqrt(124355)*S11/512+57*sqrt(14)*S3/512+41*sqrt(15)*S5/512+17*sqrt(17)*S7/512-sqrt(4845)*S9/512",
            "-sqrt(2145)*y*(x-z)*(x+z)*(21*x**8-336*x**6*y**2+84*x**6*z**2+1008*x**4*y**4-1008*x**4*y**2*z**2+126*x**4*z**4-768*x**2*y**6+2016*x**2*y**4*z**2-1008*x**2*y**2*z**4+84*x**2*z**6+128*y**8-768*y**6*z**2+1008*y**4*z**4-336*y**2*z**6+21*z**8)/256",
            "[-sqrt(248710)*I/1024,0,-sqrt(9690)*I/1024,0,17*sqrt(34)*I/1024,0,41*sqrt(30)*I/1024,0,57*sqrt(7)*I/512,0,21*sqrt(65)*I/512,0,21*sqrt(65)*I/512,0,57*sqrt(7)*I/512,0,41*sqrt(30)*I/1024,0,17*sqrt(34)*I/1024,0,-sqrt(9690)*I/1024,0,-sqrt(248710)*I/1024]",
        ),
    },
    "D2h": {
        "Qh(0,Ag,,)": ("C0", "1", "[1]"),
        "Qh(2,Ag,1,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(4,Ag,1,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Qh(6,Ag,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Qh(8,Ag,1,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Qh(10,Ag,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Qh(2,Ag,2,)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(4,Ag,2,)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "-sqrt(15)*(x**4-12*x**2*y**2+6*x**2*z**2+y**4+6*y**2*z**2-2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Qh(6,Ag,2,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Qh(8,Ag,2,)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Qh(10,Ag,2,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Qh(4,Ag,3,)": ("-C2", "sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Qh(6,Ag,3,)": (
            "sqrt(14)*C0/4+sqrt(2)*C4/4",
            "-sqrt(14)*(x**6-15*x**4*z**2+15*x**2*z**4+y**6-15*y**4*z**2+15*y**2*z**4-2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Qh(8,Ag,3,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(10,Ag,3,)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "-sqrt(420189)*(22*x**10+45*x**8*y**2-1035*x**8*z**2-105*x**6*y**4-630*x**6*y**2*z**2+4935*x**6*z**4-105*x**4*y**6+3150*x**4*y**4*z**2-1575*x**4*y**2*z**4-4830*x**4*z**6+45*x**2*y**8-630*x**2*y**6*z**2-1575*x**2*y**4*z**4+1260*x**2*y**2*z**6+990*x**2*z**8+22*y**10-1035*y**8*z**2+4935*y**6*z**4-4830*y**4*z**6+990*y**2*z**8-44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Qh(6,Ag,4,)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x-y)*(x+y)*(x**4-9*x**2*y**2-5*x**2*z**2+y**4-5*y**2*z**2+5*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Qh(8,Ag,4,)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Qh(10,Ag,4,)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(x-y)*(x+y)*(22*x**8-653*x**6*y**2-315*x**6*z**2+2602*x**4*y**4-945*x**4*y**2*z**2+1575*x**4*z**4-653*x**2*y**6-945*x**2*y**4*z**2+3150*x**2*y**2*z**4-1680*x**2*z**6+22*y**8-315*y**6*z**2+1575*y**4*z**4-1680*y**2*z**6+360*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Qh(8,Ag,5,)": (
            "C2",
            "-3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(10,Ag,5,)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "-sqrt(3213210)*(3*x**10-96*x**8*y**2-39*x**8*z**2+224*x**6*y**4+1344*x**6*y**2*z**2-42*x**6*z**4+224*x**4*y**6-6720*x**4*y**4*z**2+3360*x**4*y**2*z**4-182*x**4*z**6-96*x**2*y**8+1344*x**2*y**6*z**2+3360*x**2*y**4*z**4-2688*x**2*y**2*z**6+135*x**2*z**8+3*y**10-39*y**8*z**2-42*y**6*z**4-182*y**4*z**6+135*y**2*z**8-6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Qh(10,Ag,6,)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(x-y)*(x+y)*(9*x**8-165*x**6*y**2-231*x**6*z**2-25*x**4*y**4+3801*x**4*y**2*z**2+406*x**4*z**4-165*x**2*y**6+3801*x**2*y**4*z**2-9674*x**2*y**2*z**4+266*x**2*z**6+9*y**8-231*y**6*z**2+406*y**4*z**4+266*y**2*z**6-57*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Qh(3,Au,,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(5,Au,1,)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(7,Au,1,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Qh(9,Au,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Qh(11,Au,1,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Qh(5,Au,2,)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(7,Au,2,)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(9,Au,2,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Qh(11,Au,2,)": (
            "S8",
            "-sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(7,Au,3,)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "-sqrt(77)*x*y*z*(3*x**4-20*x**2*y**2+10*x**2*z**2+3*y**4+10*y**2*z**2-6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Qh(9,Au,3,)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(x-y)*(x+y)*(3*x**4-11*x**2*y**2-7*x**2*z**2+3*y**4-7*y**2*z**2+7*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Qh(11,Au,3,)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "-sqrt(230945)*x*y*z*(x**8-6*x**6*y**2-6*x**6*z**2+42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2-84*x**2*y**2*z**4+12*x**2*z**6+y**8-6*y**6*z**2+12*y**2*z**6-2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Qh(9,Au,4,)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Qh(11,Au,4,)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Au,5,)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "-sqrt(3003)*x*y*z*(5*x**8-150*x**6*y**2+90*x**6*z**2+336*x**4*y**4-70*x**4*y**2*z**2-168*x**4*z**4-150*x**2*y**6-70*x**2*y**4*z**2+140*x**2*y**2*z**4+60*x**2*z**6+5*y**8+90*y**6*z**2-168*y**4*z**4+60*y**2*z**6-10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Qh(2,B1g,,)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Qh(4,B1g,1,)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(6,B1g,1,)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(8,B1g,1,)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(10,B1g,1,)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(4,B1g,2,)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(6,B1g,2,)": (
            "S6",
            "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(8,B1g,2,)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,B1g,2,)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(6,B1g,3,)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(8,B1g,3,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(10,B1g,3,)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(8,B1g,4,)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(10,B1g,4,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,B1g,5,)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(1,B1u,,)": ("C0", "z", "[0,1,0]"),
        "Qh(3,B1u,1,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(5,B1u,1,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(7,B1u,1,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(9,B1u,1,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,B1u,1,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(3,B1u,2,)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(5,B1u,2,)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(7,B1u,2,)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,B1u,2,)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(11,B1u,2,)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(5,B1u,3,)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(7,B1u,3,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,B1u,3,)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,B1u,3,)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(7,B1u,4,)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(9,B1u,4,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(11,B1u,4,)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,B1u,5,)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,B1u,5,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,B1u,6,)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(2,B2g,,)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Qh(4,B2g,1,)": (
            "sqrt(14)*C1/4-sqrt(2)*C3/4",
            "-sqrt(35)*x*z*(x-z)*(x+z)/2",
            "[0,1/4,0,-sqrt(7)/4,0,sqrt(7)/4,0,-1/4,0]",
        ),
        "Qh(6,B2g,1,)": (
            "-sqrt(3)*C1/4-sqrt(30)*C3/8+sqrt(22)*C5/8",
            "3*sqrt(7)*x*z*(x-z)*(x+z)*(x**2-10*y**2+z**2)/4",
            "[0,-sqrt(11)/8,0,sqrt(15)/8,0,sqrt(6)/8,0,-sqrt(6)/8,0,-sqrt(15)/8,0,sqrt(11)/8,0]",
        ),
        "Qh(8,B2g,1,)": (
            "sqrt(715)*C1/32-sqrt(273)*C3/32+sqrt(35)*C5/32-C7/32",
            "-3*sqrt(715)*x*z*(x-z)*(x+z)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/16",
            "[0,sqrt(2)/64,0,-sqrt(70)/64,0,sqrt(546)/64,0,-sqrt(1430)/64,0,sqrt(1430)/64,0,-sqrt(546)/64,0,sqrt(70)/64,0,-sqrt(2)/64,0]",
        ),
        "Qh(10,B2g,1,)": (
            "-sqrt(221)*C1/32-sqrt(102)*C3/32+sqrt(510)*C5/32-11*sqrt(6)*C7/64+sqrt(38)*C9/64",
            "sqrt(12155)*x*z*(x-z)*(x+z)*(x**2-18*y**2+z**2)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/32",
            "[0,-sqrt(19)/64,0,11*sqrt(3)/64,0,-sqrt(255)/32,0,sqrt(51)/32,0,sqrt(442)/64,0,-sqrt(442)/64,0,-sqrt(51)/32,0,sqrt(255)/32,0,-11*sqrt(3)/64,0,sqrt(19)/64,0]",
        ),
        "Qh(4,B2g,2,)": (
            "-sqrt(2)*C1/4-sqrt(14)*C3/4",
            "-sqrt(5)*x*z*(x**2-6*y**2+z**2)/2",
            "[0,sqrt(7)/4,0,1/4,0,-1/4,0,-sqrt(7)/4,0]",
        ),
        "Qh(6,B2g,2,)": (
            "3*sqrt(22)*C1/16-sqrt(55)*C3/16+sqrt(3)*C5/16",
            "sqrt(462)*x*z*(x**2-3*z**2)*(3*x**2-z**2)/16",
            "[0,-sqrt(6)/32,0,sqrt(110)/32,0,-3*sqrt(11)/16,0,3*sqrt(11)/16,0,-sqrt(110)/32,0,sqrt(6)/32,0]",
        ),
        "Qh(8,B2g,2,)": (
            "sqrt(77)*C1/32+5*sqrt(15)*C3/32+3*sqrt(13)*C5/32-sqrt(455)*C7/32",
            "-3*sqrt(77)*x*z*(x-z)*(x+z)*(x**4-24*x**2*y**2+2*x**2*z**2+40*y**4-24*y**2*z**2+z**4)/16",
            "[0,sqrt(910)/64,0,-3*sqrt(26)/64,0,-5*sqrt(30)/64,0,-sqrt(154)/64,0,sqrt(154)/64,0,5*sqrt(30)/64,0,3*sqrt(26)/64,0,-sqrt(910)/64,0]",
        ),
        "Qh(10,B2g,2,)": (
            "-sqrt(39)*C1/32-11*sqrt(2)*C3/32-5*sqrt(10)*C5/32-sqrt(34)*C7/64+sqrt(1938)*C9/64",
            "sqrt(2145)*x*z*(x-z)*(x+z)*(x**6-42*x**4*y**2+3*x**4*z**2+168*x**2*y**4-84*x**2*y**2*z**2+3*x**2*z**4-112*y**6+168*y**4*z**2-42*y**2*z**4+z**6)/32",
            "[0,-sqrt(969)/64,0,sqrt(17)/64,0,5*sqrt(5)/32,0,11/32,0,sqrt(78)/64,0,-sqrt(78)/64,0,-11/32,0,-5*sqrt(5)/32,0,-sqrt(17)/64,0,sqrt(969)/64,0]",
        ),
        "Qh(6,B2g,3,)": (
            "sqrt(10)*C1/16+9*C3/16+sqrt(165)*C5/16",
            "sqrt(210)*x*z*(x**4-16*x**2*y**2+2*x**2*z**2+16*y**4-16*y**2*z**2+z**4)/16",
            "[0,-sqrt(330)/32,0,-9*sqrt(2)/32,0,-sqrt(5)/16,0,sqrt(5)/16,0,9*sqrt(2)/32,0,sqrt(330)/32,0]",
        ),
        "Qh(8,B2g,3,)": (
            "-sqrt(858)*C1/64-sqrt(910)*C3/64+7*sqrt(42)*C5/64-3*sqrt(30)*C7/64",
            "-sqrt(858)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(x**2-14*y**2+z**2)/32",
            "[0,3*sqrt(15)/64,0,-7*sqrt(21)/64,0,sqrt(455)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-sqrt(455)/64,0,7*sqrt(21)/64,0,-3*sqrt(15)/64,0]",
        ),
        "Qh(10,B2g,3,)": (
            "sqrt(41990)*C1/256-sqrt(4845)*C3/128+sqrt(969)*C5/128-sqrt(285)*C7/256+sqrt(5)*C9/256",
            "sqrt(92378)*x*z*(x**4-10*x**2*z**2+5*z**4)*(5*x**4-10*x**2*z**2+z**4)/256",
            "[0,-sqrt(10)/512,0,sqrt(570)/512,0,-sqrt(1938)/256,0,sqrt(9690)/256,0,-sqrt(20995)/256,0,sqrt(20995)/256,0,-sqrt(9690)/256,0,sqrt(1938)/256,0,-sqrt(570)/512,0,sqrt(10)/512,0]",
        ),
        "Qh(8,B2g,4,)": (
            "-sqrt(70)*C1/64-3*sqrt(66)*C3/64-sqrt(1430)*C5/64-sqrt(2002)*C7/64",
            "-3*sqrt(70)*x*z*(x**6-30*x**4*y**2+3*x**4*z**2+80*x**2*y**4-60*x**2*y**2*z**2+3*x**2*z**4-32*y**6+80*y**4*z**2-30*y**2*z**4+z**6)/32",
            "[0,sqrt(1001)/64,0,sqrt(715)/64,0,3*sqrt(33)/64,0,sqrt(35)/64,0,-sqrt(35)/64,0,-3*sqrt(33)/64,0,-sqrt(715)/64,0,-sqrt(1001)/64,0]",
        ),
        "Qh(10,B2g,4,)": (
            "9*sqrt(78)*C1/256+69*C3/128-sqrt(5)*C5/128-43*sqrt(17)*C7/256+3*sqrt(969)*C9/256",
            "sqrt(4290)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(3*x**4-96*x**2*y**2+6*x**2*z**2+224*y**4-96*y**2*z**2+3*z**4)/256",
            "[0,-3*sqrt(1938)/512,0,43*sqrt(34)/512,0,sqrt(10)/256,0,-69*sqrt(2)/256,0,-9*sqrt(39)/256,0,9*sqrt(39)/256,0,69*sqrt(2)/256,0,-sqrt(10)/256,0,-43*sqrt(34)/512,0,3*sqrt(1938)/512,0]",
        ),
        "Qh(10,B2g,5,)": (
            "7*sqrt(3)*C1/128+7*sqrt(26)*C3/128+5*sqrt(130)*C5/128+7*sqrt(442)*C7/256+sqrt(25194)*C9/256",
            "sqrt(165)*x*z*(7*x**8-336*x**6*y**2+28*x**6*z**2+1680*x**4*y**4-1008*x**4*y**2*z**2+42*x**4*z**4-1792*x**2*y**6+3360*x**2*y**4*z**2-1008*x**2*y**2*z**4+28*x**2*z**6+384*y**8-1792*y**6*z**2+1680*y**4*z**4-336*y**2*z**6+7*z**8)/128",
            "[0,-sqrt(12597)/256,0,-7*sqrt(221)/256,0,-5*sqrt(65)/128,0,-7*sqrt(13)/128,0,-7*sqrt(6)/256,0,7*sqrt(6)/256,0,7*sqrt(13)/128,0,5*sqrt(65)/128,0,7*sqrt(221)/256,0,sqrt(12597)/256,0]",
        ),
        "Qh(1,B2u,,)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(3,B2u,1,)": (
            "-sqrt(6)*S1/4-sqrt(10)*S3/4",
            "-y*(3*x**2-2*y**2+3*z**2)/2",
            "[-sqrt(5)*I/4,0,-sqrt(3)*I/4,0,-sqrt(3)*I/4,0,-sqrt(5)*I/4]",
        ),
        "Qh(5,B2u,1,)": (
            "sqrt(15)*S1/8+sqrt(70)*S3/16+3*sqrt(14)*S5/16",
            "y*(15*x**4-40*x**2*y**2+30*x**2*z**2+8*y**4-40*y**2*z**2+15*z**4)/8",
            "[3*sqrt(7)*I/16,0,sqrt(35)*I/16,0,sqrt(30)*I/16,0,sqrt(30)*I/16,0,sqrt(35)*I/16,0,3*sqrt(7)*I/16]",
        ),
        "Qh(7,B2u,1,)": (
            "-5*sqrt(7)*S1/32-3*sqrt(21)*S3/32-sqrt(231)*S5/32-sqrt(429)*S7/32",
            "-y*(35*x**6-210*x**4*y**2+105*x**4*z**2+168*x**2*y**4-420*x**2*y**2*z**2+105*x**2*z**4-16*y**6+168*y**4*z**2-210*y**2*z**4+35*z**6)/16",
            "[-sqrt(858)*I/64,0,-sqrt(462)*I/64,0,-3*sqrt(42)*I/64,0,-5*sqrt(14)*I/64,0,-5*sqrt(14)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(462)*I/64,0,-sqrt(858)*I/64]",
        ),
        "Qh(9,B2u,1,)": (
            "21*sqrt(5)*S1/128+sqrt(2310)*S3/128+3*sqrt(286)*S5/128+3*sqrt(1430)*S7/256+sqrt(24310)*S9/256",
            "y*(315*x**8-3360*x**6*y**2+1260*x**6*z**2+6048*x**4*y**4-10080*x**4*y**2*z**2+1890*x**4*z**4-2304*x**2*y**6+12096*x**2*y**4*z**2-10080*x**2*y**2*z**4+1260*x**2*z**6+128*y**8-2304*y**6*z**2+6048*y**4*z**4-3360*y**2*z**6+315*z**8)/128",
            "[sqrt(12155)*I/256,0,3*sqrt(715)*I/256,0,3*sqrt(143)*I/128,0,sqrt(1155)*I/128,0,21*sqrt(10)*I/256,0,21*sqrt(10)*I/256,0,sqrt(1155)*I/128,0,3*sqrt(143)*I/128,0,3*sqrt(715)*I/256,0,sqrt(12155)*I/256]",
        ),
        "Qh(11,B2u,1,)": (
            "-21*sqrt(66)*S1/512-sqrt(88179)*S11/512-sqrt(30030)*S3/512-15*sqrt(143)*S5/512-sqrt(36465)*S7/512-sqrt(46189)*S9/512",
            "-y*(693*x**10-11550*x**8*y**2+3465*x**8*z**2+36960*x**6*y**4-46200*x**6*y**2*z**2+6930*x**6*z**4-31680*x**4*y**6+110880*x**4*y**4*z**2-69300*x**4*y**2*z**4+6930*x**4*z**6+7040*x**2*y**8-63360*x**2*y**6*z**2+110880*x**2*y**4*z**4-46200*x**2*y**2*z**6+3465*x**2*z**8-256*y**10+7040*y**8*z**2-31680*y**6*z**4+36960*y**4*z**6-11550*y**2*z**8+693*z**10)/256",
            "[-sqrt(176358)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(72930)*I/1024,0,-15*sqrt(286)*I/1024,0,-sqrt(15015)*I/512,0,-21*sqrt(33)*I/512,0,-21*sqrt(33)*I/512,0,-sqrt(15015)*I/512,0,-15*sqrt(286)*I/1024,0,-sqrt(72930)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(176358)*I/1024]",
        ),
        "Qh(3,B2u,2,)": (
            "sqrt(10)*S1/4-sqrt(6)*S3/4",
            "-sqrt(15)*y*(x-z)*(x+z)/2",
            "[-sqrt(3)*I/4,0,sqrt(5)*I/4,0,sqrt(5)*I/4,0,-sqrt(3)*I/4]",
        ),
        "Qh(5,B2u,2,)": (
            "sqrt(21)*S1/8-9*sqrt(2)*S3/16+sqrt(10)*S5/16",
            "3*sqrt(35)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/8",
            "[sqrt(5)*I/16,0,-9*I/16,0,sqrt(42)*I/16,0,sqrt(42)*I/16,0,-9*I/16,0,sqrt(5)*I/16]",
        ),
        "Qh(7,B2u,2,)": (
            "-3*sqrt(33)*S1/32+sqrt(11)*S3/32+25*S5/32-sqrt(91)*S7/32",
            "-sqrt(231)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(3*x**2-10*y**2+3*z**2)/16",
            "[-sqrt(182)*I/64,0,25*sqrt(2)*I/64,0,sqrt(22)*I/64,0,-3*sqrt(66)*I/64,0,-3*sqrt(66)*I/64,0,sqrt(22)*I/64,0,25*sqrt(2)*I/64,0,-sqrt(182)*I/64]",
        ),
        "Qh(9,B2u,2,)": (
            "sqrt(2431)*S1/128-sqrt(9282)*S3/128+5*sqrt(170)*S5/128-7*sqrt(34)*S7/256+3*sqrt(2)*S9/256",
            "3*sqrt(12155)*y*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/128",
            "[3*I/256,0,-7*sqrt(17)*I/256,0,5*sqrt(85)*I/128,0,-sqrt(4641)*I/128,0,sqrt(4862)*I/256,0,sqrt(4862)*I/256,0,-sqrt(4641)*I/128,0,5*sqrt(85)*I/128,0,-7*sqrt(17)*I/256,0,3*I/256]",
        ),
        "Qh(11,B2u,2,)": (
            "-sqrt(41990)*S1/512-sqrt(385)*S11/512+3*sqrt(4522)*S3/512+3*sqrt(4845)*S5/512-77*sqrt(19)*S7/512+39*sqrt(15)*S9/512",
            "-sqrt(692835)*y*(x**2-6*y**2+z**2)*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/256",
            "[-sqrt(770)*I/1024,0,39*sqrt(30)*I/1024,0,-77*sqrt(38)*I/1024,0,3*sqrt(9690)*I/1024,0,3*sqrt(2261)*I/512,0,-sqrt(20995)*I/512,0,-sqrt(20995)*I/512,0,3*sqrt(2261)*I/512,0,3*sqrt(9690)*I/1024,0,-77*sqrt(38)*I/1024,0,39*sqrt(30)*I/1024,0,-sqrt(770)*I/1024]",
        ),
        "Qh(5,B2u,3,)": (
            "-sqrt(7)*S1/4-sqrt(6)*S3/8+sqrt(30)*S5/8",
            "sqrt(105)*y*(x-z)*(x+z)*(x**2-2*y**2+z**2)/4",
            "[sqrt(15)*I/8,0,-sqrt(3)*I/8,0,-sqrt(14)*I/8,0,-sqrt(14)*I/8,0,-sqrt(3)*I/8,0,sqrt(15)*I/8]",
        ),
        "Qh(7,B2u,3,)": (
            "sqrt(858)*S1/64-3*sqrt(286)*S3/64+5*sqrt(26)*S5/64-sqrt(14)*S7/64",
            "-sqrt(6006)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)/32",
            "[-sqrt(7)*I/64,0,5*sqrt(13)*I/64,0,-3*sqrt(143)*I/64,0,sqrt(429)*I/64,0,sqrt(429)*I/64,0,-3*sqrt(143)*I/64,0,5*sqrt(13)*I/64,0,-sqrt(7)*I/64]",
        ),
        "Qh(9,B2u,3,)": (
            "sqrt(1001)*S1/64+sqrt(78)*S3/64-3*sqrt(70)*S5/64-23*sqrt(14)*S7/128+3*sqrt(238)*S9/128",
            "3*sqrt(5005)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(x**4-8*x**2*y**2+2*x**2*z**2+8*y**4-8*y**2*z**2+z**4)/64",
            "[3*sqrt(119)*I/128,0,-23*sqrt(7)*I/128,0,-3*sqrt(35)*I/64,0,sqrt(39)*I/64,0,sqrt(2002)*I/128,0,sqrt(2002)*I/128,0,sqrt(39)*I/64,0,-3*sqrt(35)*I/64,0,-23*sqrt(7)*I/128,0,3*sqrt(119)*I/128]",
        ),
        "Qh(11,B2u,3,)": (
            "-5*sqrt(546)*S1/256-sqrt(10659)*S11/256-11*sqrt(30)*S3/256+13*sqrt(7)*S5/256+3*sqrt(1785)*S7/256+3*sqrt(2261)*S9/256",
            "-3*sqrt(1001)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(5*x**6-70*x**4*y**2+15*x**4*z**2+168*x**2*y**4-140*x**2*y**2*z**2+15*x**2*z**4-80*y**6+168*y**4*z**2-70*y**2*z**4+5*z**6)/128",
            "[-sqrt(21318)*I/512,0,3*sqrt(4522)*I/512,0,3*sqrt(3570)*I/512,0,13*sqrt(14)*I/512,0,-11*sqrt(15)*I/256,0,-5*sqrt(273)*I/256,0,-5*sqrt(273)*I/256,0,-11*sqrt(15)*I/256,0,13*sqrt(14)*I/512,0,3*sqrt(3570)*I/512,0,3*sqrt(4522)*I/512,0,-sqrt(21318)*I/512]",
        ),
        "Qh(7,B2u,4,)": (
            "15*sqrt(6)*S1/64+19*sqrt(2)*S3/64+sqrt(22)*S5/64-sqrt(2002)*S7/64",
            "-sqrt(42)*y*(x-z)*(x+z)*(15*x**4-80*x**2*y**2+30*x**2*z**2+48*y**4-80*y**2*z**2+15*z**4)/32",
            "[-sqrt(1001)*I/64,0,sqrt(11)*I/64,0,19*I/64,0,15*sqrt(3)*I/64,0,15*sqrt(3)*I/64,0,19*I/64,0,sqrt(11)*I/64,0,-sqrt(1001)*I/64]",
        ),
        "Qh(9,B2u,4,)": (
            "-sqrt(858)*S1/64+sqrt(91)*S3/32+5*sqrt(15)*S5/32-21*sqrt(3)*S7/64+sqrt(51)*S9/64",
            "sqrt(4290)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(3*x**2-14*y**2+3*z**2)/64",
            "[sqrt(102)*I/128,0,-21*sqrt(6)*I/128,0,5*sqrt(30)*I/64,0,sqrt(182)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(182)*I/64,0,5*sqrt(30)*I/64,0,-21*sqrt(6)*I/128,0,sqrt(102)*I/128]",
        ),
        "Qh(11,B2u,4,)": (
            "sqrt(29393)*S1/512-sqrt(22)*S11/1024-9*sqrt(1615)*S3/512+5*sqrt(13566)*S5/1024-7*sqrt(1330)*S7/1024+9*sqrt(42)*S9/1024",
            "-sqrt(1939938)*y*(x-z)*(x+z)*(x**4-4*x**3*z-14*x**2*z**2-4*x*z**3+z**4)*(x**4+4*x**3*z-14*x**2*z**2+4*x*z**3+z**4)/512",
            "[-sqrt(11)*I/1024,0,9*sqrt(21)*I/1024,0,-7*sqrt(665)*I/1024,0,5*sqrt(6783)*I/1024,0,-9*sqrt(3230)*I/1024,0,sqrt(58786)*I/1024,0,sqrt(58786)*I/1024,0,-9*sqrt(3230)*I/1024,0,5*sqrt(6783)*I/1024,0,-7*sqrt(665)*I/1024,0,9*sqrt(21)*I/1024,0,-sqrt(11)*I/1024]",
        ),
        "Qh(9,B2u,5,)": (
            "-7*sqrt(22)*S1/64-3*sqrt(21)*S3/32-sqrt(65)*S5/32+sqrt(13)*S7/64+3*sqrt(221)*S9/64",
            "3*sqrt(110)*y*(x-z)*(x+z)*(7*x**6-70*x**4*y**2+21*x**4*z**2+112*x**2*y**4-140*x**2*y**2*z**2+21*x**2*z**4-32*y**6+112*y**4*z**2-70*y**2*z**4+7*z**6)/64",
            "[3*sqrt(442)*I/128,0,sqrt(26)*I/128,0,-sqrt(130)*I/64,0,-3*sqrt(42)*I/64,0,-7*sqrt(11)*I/64,0,-7*sqrt(11)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(130)*I/64,0,sqrt(26)*I/128,0,3*sqrt(442)*I/128]",
        ),
        "Qh(11,B2u,5,)": (
            "15*sqrt(221)*S1/512-3*sqrt(2926)*S11/1024-sqrt(595)*S3/512-53*sqrt(102)*S5/1024-105*sqrt(10)*S7/1024+61*sqrt(114)*S9/1024",
            "-sqrt(14586)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(15*x**4-160*x**2*y**2+30*x**2*z**2+224*y**4-160*y**2*z**2+15*z**4)/512",
            "[-3*sqrt(1463)*I/1024,0,61*sqrt(57)*I/1024,0,-105*sqrt(5)*I/1024,0,-53*sqrt(51)*I/1024,0,-sqrt(1190)*I/1024,0,15*sqrt(442)*I/1024,0,15*sqrt(442)*I/1024,0,-sqrt(1190)*I/1024,0,-53*sqrt(51)*I/1024,0,-105*sqrt(5)*I/1024,0,61*sqrt(57)*I/1024,0,-3*sqrt(1463)*I/1024]",
        ),
        "Qh(11,B2u,6,)": (
            "21*sqrt(130)*S1/512-sqrt(124355)*S11/512+57*sqrt(14)*S3/512+41*sqrt(15)*S5/512+17*sqrt(17)*S7/512-sqrt(4845)*S9/512",
            "-sqrt(2145)*y*(x-z)*(x+z)*(21*x**8-336*x**6*y**2+84*x**6*z**2+1008*x**4*y**4-1008*x**4*y**2*z**2+126*x**4*z**4-768*x**2*y**6+2016*x**2*y**4*z**2-1008*x**2*y**2*z**4+84*x**2*z**6+128*y**8-768*y**6*z**2+1008*y**4*z**4-336*y**2*z**6+21*z**8)/256",
            "[-sqrt(248710)*I/1024,0,-sqrt(9690)*I/1024,0,17*sqrt(34)*I/1024,0,41*sqrt(30)*I/1024,0,57*sqrt(7)*I/512,0,21*sqrt(65)*I/512,0,21*sqrt(65)*I/512,0,57*sqrt(7)*I/512,0,41*sqrt(30)*I/1024,0,17*sqrt(34)*I/1024,0,-sqrt(9690)*I/1024,0,-sqrt(248710)*I/1024]",
        ),
        "Qh(2,B3g,,)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(4,B3g,1,)": (
            "-sqrt(14)*S1/4-sqrt(2)*S3/4",
            "sqrt(35)*y*z*(y-z)*(y+z)/2",
            "[0,-I/4,0,-sqrt(7)*I/4,0,-sqrt(7)*I/4,0,-I/4,0]",
        ),
        "Qh(6,B3g,1,)": (
            "sqrt(3)*S1/4-sqrt(30)*S3/8-sqrt(22)*S5/8",
            "3*sqrt(7)*y*z*(y-z)*(y+z)*(10*x**2-y**2-z**2)/4",
            "[0,-sqrt(11)*I/8,0,-sqrt(15)*I/8,0,sqrt(6)*I/8,0,sqrt(6)*I/8,0,-sqrt(15)*I/8,0,-sqrt(11)*I/8,0]",
        ),
        "Qh(8,B3g,1,)": (
            "-sqrt(715)*S1/32-sqrt(273)*S3/32-sqrt(35)*S5/32-S7/32",
            "3*sqrt(715)*y*z*(y-z)*(y+z)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[0,-sqrt(2)*I/64,0,-sqrt(70)*I/64,0,-sqrt(546)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(546)*I/64,0,-sqrt(70)*I/64,0,-sqrt(2)*I/64,0]",
        ),
        "Qh(10,B3g,1,)": (
            "sqrt(221)*S1/32-sqrt(102)*S3/32-sqrt(510)*S5/32-11*sqrt(6)*S7/64-sqrt(38)*S9/64",
            "sqrt(12155)*y*z*(y-z)*(y+z)*(18*x**2-y**2-z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/32",
            "[0,-sqrt(19)*I/64,0,-11*sqrt(3)*I/64,0,-sqrt(255)*I/32,0,-sqrt(51)*I/32,0,sqrt(442)*I/64,0,sqrt(442)*I/64,0,-sqrt(51)*I/32,0,-sqrt(255)*I/32,0,-11*sqrt(3)*I/64,0,-sqrt(19)*I/64,0]",
        ),
        "Qh(4,B3g,2,)": (
            "-sqrt(2)*S1/4+sqrt(14)*S3/4",
            "sqrt(5)*y*z*(6*x**2-y**2-z**2)/2",
            "[0,sqrt(7)*I/4,0,-I/4,0,-I/4,0,sqrt(7)*I/4,0]",
        ),
        "Qh(6,B3g,2,)": (
            "3*sqrt(22)*S1/16+sqrt(55)*S3/16+sqrt(3)*S5/16",
            "sqrt(462)*y*z*(y**2-3*z**2)*(3*y**2-z**2)/16",
            "[0,sqrt(6)*I/32,0,sqrt(110)*I/32,0,3*sqrt(11)*I/16,0,3*sqrt(11)*I/16,0,sqrt(110)*I/32,0,sqrt(6)*I/32,0]",
        ),
        "Qh(8,B3g,2,)": (
            "-sqrt(77)*S1/32+5*sqrt(15)*S3/32-3*sqrt(13)*S5/32-sqrt(455)*S7/32",
            "3*sqrt(77)*y*z*(y-z)*(y+z)*(40*x**4-24*x**2*y**2-24*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,-sqrt(910)*I/64,0,-3*sqrt(26)*I/64,0,5*sqrt(30)*I/64,0,-sqrt(154)*I/64,0,-sqrt(154)*I/64,0,5*sqrt(30)*I/64,0,-3*sqrt(26)*I/64,0,-sqrt(910)*I/64,0]",
        ),
        "Qh(10,B3g,2,)": (
            "sqrt(39)*S1/32-11*sqrt(2)*S3/32+5*sqrt(10)*S5/32-sqrt(34)*S7/64-sqrt(1938)*S9/64",
            "sqrt(2145)*y*z*(y-z)*(y+z)*(112*x**6-168*x**4*y**2-168*x**4*z**2+42*x**2*y**4+84*x**2*y**2*z**2+42*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,-sqrt(969)*I/64,0,-sqrt(17)*I/64,0,5*sqrt(5)*I/32,0,-11*I/32,0,sqrt(78)*I/64,0,sqrt(78)*I/64,0,-11*I/32,0,5*sqrt(5)*I/32,0,-sqrt(17)*I/64,0,-sqrt(969)*I/64,0]",
        ),
        "Qh(6,B3g,3,)": (
            "sqrt(10)*S1/16-9*S3/16+sqrt(165)*S5/16",
            "sqrt(210)*y*z*(16*x**4-16*x**2*y**2-16*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,sqrt(330)*I/32,0,-9*sqrt(2)*I/32,0,sqrt(5)*I/16,0,sqrt(5)*I/16,0,-9*sqrt(2)*I/32,0,sqrt(330)*I/32,0]",
        ),
        "Qh(8,B3g,3,)": (
            "-sqrt(858)*S1/64+sqrt(910)*S3/64+7*sqrt(42)*S5/64+3*sqrt(30)*S7/64",
            "sqrt(858)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(14*x**2-y**2-z**2)/32",
            "[0,3*sqrt(15)*I/64,0,7*sqrt(21)*I/64,0,sqrt(455)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(455)*I/64,0,7*sqrt(21)*I/64,0,3*sqrt(15)*I/64,0]",
        ),
        "Qh(10,B3g,3,)": (
            "sqrt(41990)*S1/256+sqrt(4845)*S3/128+sqrt(969)*S5/128+sqrt(285)*S7/256+sqrt(5)*S9/256",
            "sqrt(92378)*y*z*(y**4-10*y**2*z**2+5*z**4)*(5*y**4-10*y**2*z**2+z**4)/256",
            "[0,sqrt(10)*I/512,0,sqrt(570)*I/512,0,sqrt(1938)*I/256,0,sqrt(9690)*I/256,0,sqrt(20995)*I/256,0,sqrt(20995)*I/256,0,sqrt(9690)*I/256,0,sqrt(1938)*I/256,0,sqrt(570)*I/512,0,sqrt(10)*I/512,0]",
        ),
        "Qh(8,B3g,4,)": (
            "-sqrt(70)*S1/64+3*sqrt(66)*S3/64-sqrt(1430)*S5/64+sqrt(2002)*S7/64",
            "3*sqrt(70)*y*z*(32*x**6-80*x**4*y**2-80*x**4*z**2+30*x**2*y**4+60*x**2*y**2*z**2+30*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,sqrt(1001)*I/64,0,-sqrt(715)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(35)*I/64,0,-sqrt(35)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(715)*I/64,0,sqrt(1001)*I/64,0]",
        ),
        "Qh(10,B3g,4,)": (
            "9*sqrt(78)*S1/256-69*S3/128-sqrt(5)*S5/128+43*sqrt(17)*S7/256+3*sqrt(969)*S9/256",
            "sqrt(4290)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(224*x**4-96*x**2*y**2-96*x**2*z**2+3*y**4+6*y**2*z**2+3*z**4)/256",
            "[0,3*sqrt(1938)*I/512,0,43*sqrt(34)*I/512,0,-sqrt(10)*I/256,0,-69*sqrt(2)*I/256,0,9*sqrt(39)*I/256,0,9*sqrt(39)*I/256,0,-69*sqrt(2)*I/256,0,-sqrt(10)*I/256,0,43*sqrt(34)*I/512,0,3*sqrt(1938)*I/512,0]",
        ),
        "Qh(10,B3g,5,)": (
            "7*sqrt(3)*S1/128-7*sqrt(26)*S3/128+5*sqrt(130)*S5/128-7*sqrt(442)*S7/256+sqrt(25194)*S9/256",
            "sqrt(165)*y*z*(384*x**8-1792*x**6*y**2-1792*x**6*z**2+1680*x**4*y**4+3360*x**4*y**2*z**2+1680*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+7*y**8+28*y**6*z**2+42*y**4*z**4+28*y**2*z**6+7*z**8)/128",
            "[0,sqrt(12597)*I/256,0,-7*sqrt(221)*I/256,0,5*sqrt(65)*I/128,0,-7*sqrt(13)*I/128,0,7*sqrt(6)*I/256,0,7*sqrt(6)*I/256,0,-7*sqrt(13)*I/128,0,5*sqrt(65)*I/128,0,-7*sqrt(221)*I/256,0,sqrt(12597)*I/256,0]",
        ),
        "Qh(1,B3u,,)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(3,B3u,1,)": (
            "-sqrt(6)*C1/4+sqrt(10)*C3/4",
            "x*(2*x**2-3*y**2-3*z**2)/2",
            "[-sqrt(5)/4,0,sqrt(3)/4,0,-sqrt(3)/4,0,sqrt(5)/4]",
        ),
        "Qh(5,B3u,1,)": (
            "sqrt(15)*C1/8-sqrt(70)*C3/16+3*sqrt(14)*C5/16",
            "x*(8*x**4-40*x**2*y**2-40*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/8",
            "[-3*sqrt(7)/16,0,sqrt(35)/16,0,-sqrt(30)/16,0,sqrt(30)/16,0,-sqrt(35)/16,0,3*sqrt(7)/16]",
        ),
        "Qh(7,B3u,1,)": (
            "-5*sqrt(7)*C1/32+3*sqrt(21)*C3/32-sqrt(231)*C5/32+sqrt(429)*C7/32",
            "x*(16*x**6-168*x**4*y**2-168*x**4*z**2+210*x**2*y**4+420*x**2*y**2*z**2+210*x**2*z**4-35*y**6-105*y**4*z**2-105*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)/64,0,sqrt(462)/64,0,-3*sqrt(42)/64,0,5*sqrt(14)/64,0,-5*sqrt(14)/64,0,3*sqrt(42)/64,0,-sqrt(462)/64,0,sqrt(858)/64]",
        ),
        "Qh(9,B3u,1,)": (
            "21*sqrt(5)*C1/128-sqrt(2310)*C3/128+3*sqrt(286)*C5/128-3*sqrt(1430)*C7/256+sqrt(24310)*C9/256",
            "x*(128*x**8-2304*x**6*y**2-2304*x**6*z**2+6048*x**4*y**4+12096*x**4*y**2*z**2+6048*x**4*z**4-3360*x**2*y**6-10080*x**2*y**4*z**2-10080*x**2*y**2*z**4-3360*x**2*z**6+315*y**8+1260*y**6*z**2+1890*y**4*z**4+1260*y**2*z**6+315*z**8)/128",
            "[-sqrt(12155)/256,0,3*sqrt(715)/256,0,-3*sqrt(143)/128,0,sqrt(1155)/128,0,-21*sqrt(10)/256,0,21*sqrt(10)/256,0,-sqrt(1155)/128,0,3*sqrt(143)/128,0,-3*sqrt(715)/256,0,sqrt(12155)/256]",
        ),
        "Qh(11,B3u,1,)": (
            "-21*sqrt(66)*C1/512+sqrt(88179)*C11/512+sqrt(30030)*C3/512-15*sqrt(143)*C5/512+sqrt(36465)*C7/512-sqrt(46189)*C9/512",
            "x*(256*x**10-7040*x**8*y**2-7040*x**8*z**2+31680*x**6*y**4+63360*x**6*y**2*z**2+31680*x**6*z**4-36960*x**4*y**6-110880*x**4*y**4*z**2-110880*x**4*y**2*z**4-36960*x**4*z**6+11550*x**2*y**8+46200*x**2*y**6*z**2+69300*x**2*y**4*z**4+46200*x**2*y**2*z**6+11550*x**2*z**8-693*y**10-3465*y**8*z**2-6930*y**6*z**4-6930*y**4*z**6-3465*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)/1024,0,sqrt(92378)/1024,0,-sqrt(72930)/1024,0,15*sqrt(286)/1024,0,-sqrt(15015)/512,0,21*sqrt(33)/512,0,-21*sqrt(33)/512,0,sqrt(15015)/512,0,-15*sqrt(286)/1024,0,sqrt(72930)/1024,0,-sqrt(92378)/1024,0,sqrt(176358)/1024]",
        ),
        "Qh(3,B3u,2,)": (
            "-sqrt(10)*C1/4-sqrt(6)*C3/4",
            "sqrt(15)*x*(y-z)*(y+z)/2",
            "[sqrt(3)/4,0,sqrt(5)/4,0,-sqrt(5)/4,0,-sqrt(3)/4]",
        ),
        "Qh(5,B3u,2,)": (
            "sqrt(21)*C1/8+9*sqrt(2)*C3/16+sqrt(10)*C5/16",
            "3*sqrt(35)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/8",
            "[-sqrt(5)/16,0,-9/16,0,-sqrt(42)/16,0,sqrt(42)/16,0,9/16,0,sqrt(5)/16]",
        ),
        "Qh(7,B3u,2,)": (
            "-3*sqrt(33)*C1/32-sqrt(11)*C3/32+25*C5/32+sqrt(91)*C7/32",
            "sqrt(231)*x*(10*x**2-3*y**2-3*z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[-sqrt(182)/64,0,-25*sqrt(2)/64,0,sqrt(22)/64,0,3*sqrt(66)/64,0,-3*sqrt(66)/64,0,-sqrt(22)/64,0,25*sqrt(2)/64,0,sqrt(182)/64]",
        ),
        "Qh(9,B3u,2,)": (
            "sqrt(2431)*C1/128+sqrt(9282)*C3/128+5*sqrt(170)*C5/128+7*sqrt(34)*C7/256+3*sqrt(2)*C9/256",
            "3*sqrt(12155)*x*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/128",
            "[-3/256,0,-7*sqrt(17)/256,0,-5*sqrt(85)/128,0,-sqrt(4641)/128,0,-sqrt(4862)/256,0,sqrt(4862)/256,0,sqrt(4641)/128,0,5*sqrt(85)/128,0,7*sqrt(17)/256,0,3/256]",
        ),
        "Qh(11,B3u,2,)": (
            "-sqrt(41990)*C1/512+sqrt(385)*C11/512-3*sqrt(4522)*C3/512+3*sqrt(4845)*C5/512+77*sqrt(19)*C7/512+39*sqrt(15)*C9/512",
            "sqrt(692835)*x*(6*x**2-y**2-z**2)*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/256",
            "[-sqrt(770)/1024,0,-39*sqrt(30)/1024,0,-77*sqrt(38)/1024,0,-3*sqrt(9690)/1024,0,3*sqrt(2261)/512,0,sqrt(20995)/512,0,-sqrt(20995)/512,0,-3*sqrt(2261)/512,0,3*sqrt(9690)/1024,0,77*sqrt(38)/1024,0,39*sqrt(30)/1024,0,sqrt(770)/1024]",
        ),
        "Qh(5,B3u,3,)": (
            "sqrt(7)*C1/4-sqrt(6)*C3/8-sqrt(30)*C5/8",
            "sqrt(105)*x*(y-z)*(y+z)*(2*x**2-y**2-z**2)/4",
            "[sqrt(15)/8,0,sqrt(3)/8,0,-sqrt(14)/8,0,sqrt(14)/8,0,-sqrt(3)/8,0,-sqrt(15)/8]",
        ),
        "Qh(7,B3u,3,)": (
            "-sqrt(858)*C1/64-3*sqrt(286)*C3/64-5*sqrt(26)*C5/64-sqrt(14)*C7/64",
            "sqrt(6006)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/32",
            "[sqrt(7)/64,0,5*sqrt(13)/64,0,3*sqrt(143)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-3*sqrt(143)/64,0,-5*sqrt(13)/64,0,-sqrt(7)/64]",
        ),
        "Qh(9,B3u,3,)": (
            "sqrt(1001)*C1/64-sqrt(78)*C3/64-3*sqrt(70)*C5/64+23*sqrt(14)*C7/128+3*sqrt(238)*C9/128",
            "3*sqrt(5005)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(8*x**4-8*x**2*y**2-8*x**2*z**2+y**4+2*y**2*z**2+z**4)/64",
            "[-3*sqrt(119)/128,0,-23*sqrt(7)/128,0,3*sqrt(35)/64,0,sqrt(39)/64,0,-sqrt(2002)/128,0,sqrt(2002)/128,0,-sqrt(39)/64,0,-3*sqrt(35)/64,0,23*sqrt(7)/128,0,3*sqrt(119)/128]",
        ),
        "Qh(11,B3u,3,)": (
            "-5*sqrt(546)*C1/256+sqrt(10659)*C11/256+11*sqrt(30)*C3/256+13*sqrt(7)*C5/256-3*sqrt(1785)*C7/256+3*sqrt(2261)*C9/256",
            "3*sqrt(1001)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(80*x**6-168*x**4*y**2-168*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-5*y**6-15*y**4*z**2-15*y**2*z**4-5*z**6)/128",
            "[-sqrt(21318)/512,0,-3*sqrt(4522)/512,0,3*sqrt(3570)/512,0,-13*sqrt(14)/512,0,-11*sqrt(15)/256,0,5*sqrt(273)/256,0,-5*sqrt(273)/256,0,11*sqrt(15)/256,0,13*sqrt(14)/512,0,-3*sqrt(3570)/512,0,3*sqrt(4522)/512,0,sqrt(21318)/512]",
        ),
        "Qh(7,B3u,4,)": (
            "-15*sqrt(6)*C1/64+19*sqrt(2)*C3/64-sqrt(22)*C5/64-sqrt(2002)*C7/64",
            "sqrt(42)*x*(y-z)*(y+z)*(48*x**4-80*x**2*y**2-80*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/32",
            "[sqrt(1001)/64,0,sqrt(11)/64,0,-19/64,0,15*sqrt(3)/64,0,-15*sqrt(3)/64,0,19/64,0,-sqrt(11)/64,0,-sqrt(1001)/64]",
        ),
        "Qh(9,B3u,4,)": (
            "sqrt(858)*C1/64+sqrt(91)*C3/32-5*sqrt(15)*C5/32-21*sqrt(3)*C7/64-sqrt(51)*C9/64",
            "sqrt(4290)*x*(y-z)*(y+z)*(14*x**2-3*y**2-3*z**2)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/64",
            "[sqrt(102)/128,0,21*sqrt(6)/128,0,5*sqrt(30)/64,0,-sqrt(182)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(182)/64,0,-5*sqrt(30)/64,0,-21*sqrt(6)/128,0,-sqrt(102)/128]",
        ),
        "Qh(11,B3u,4,)": (
            "-sqrt(29393)*C1/512-sqrt(22)*C11/1024-9*sqrt(1615)*C3/512-5*sqrt(13566)*C5/1024-7*sqrt(1330)*C7/1024-9*sqrt(42)*C9/1024",
            "sqrt(1939938)*x*(y-z)*(y+z)*(y**4-4*y**3*z-14*y**2*z**2-4*y*z**3+z**4)*(y**4+4*y**3*z-14*y**2*z**2+4*y*z**3+z**4)/512",
            "[sqrt(11)/1024,0,9*sqrt(21)/1024,0,7*sqrt(665)/1024,0,5*sqrt(6783)/1024,0,9*sqrt(3230)/1024,0,sqrt(58786)/1024,0,-sqrt(58786)/1024,0,-9*sqrt(3230)/1024,0,-5*sqrt(6783)/1024,0,-7*sqrt(665)/1024,0,-9*sqrt(21)/1024,0,-sqrt(11)/1024]",
        ),
        "Qh(9,B3u,5,)": (
            "7*sqrt(22)*C1/64-3*sqrt(21)*C3/32+sqrt(65)*C5/32+sqrt(13)*C7/64-3*sqrt(221)*C9/64",
            "3*sqrt(110)*x*(y-z)*(y+z)*(32*x**6-112*x**4*y**2-112*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-7*y**6-21*y**4*z**2-21*y**2*z**4-7*z**6)/64",
            "[3*sqrt(442)/128,0,-sqrt(26)/128,0,-sqrt(130)/64,0,3*sqrt(42)/64,0,-7*sqrt(11)/64,0,7*sqrt(11)/64,0,-3*sqrt(42)/64,0,sqrt(130)/64,0,sqrt(26)/128,0,-3*sqrt(442)/128]",
        ),
        "Qh(11,B3u,5,)": (
            "-15*sqrt(221)*C1/512-3*sqrt(2926)*C11/1024-sqrt(595)*C3/512+53*sqrt(102)*C5/1024-105*sqrt(10)*C7/1024-61*sqrt(114)*C9/1024",
            "sqrt(14586)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)*(224*x**4-160*x**2*y**2-160*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/512",
            "[3*sqrt(1463)/1024,0,61*sqrt(57)/1024,0,105*sqrt(5)/1024,0,-53*sqrt(51)/1024,0,sqrt(1190)/1024,0,15*sqrt(442)/1024,0,-15*sqrt(442)/1024,0,-sqrt(1190)/1024,0,53*sqrt(51)/1024,0,-105*sqrt(5)/1024,0,-61*sqrt(57)/1024,0,-3*sqrt(1463)/1024]",
        ),
        "Qh(11,B3u,6,)": (
            "-21*sqrt(130)*C1/512-sqrt(124355)*C11/512+57*sqrt(14)*C3/512-41*sqrt(15)*C5/512+17*sqrt(17)*C7/512+sqrt(4845)*C9/512",
            "sqrt(2145)*x*(y-z)*(y+z)*(128*x**8-768*x**6*y**2-768*x**6*z**2+1008*x**4*y**4+2016*x**4*y**2*z**2+1008*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+21*y**8+84*y**6*z**2+126*y**4*z**4+84*y**2*z**6+21*z**8)/256",
            "[sqrt(248710)/1024,0,-sqrt(9690)/1024,0,-17*sqrt(34)/1024,0,41*sqrt(30)/1024,0,-57*sqrt(7)/512,0,21*sqrt(65)/512,0,-21*sqrt(65)/512,0,57*sqrt(7)/512,0,-41*sqrt(30)/1024,0,17*sqrt(34)/1024,0,sqrt(9690)/1024,0,-sqrt(248710)/1024]",
        ),
    },
    "C4": {
        "Qh(0,A,,)": ("C0", "1", "[1]"),
        "Qh(1,A,,)": ("C0", "z", "[0,1,0]"),
        "Qh(1,Ea,,)": ("sqrt(2)*C1/2+sqrt(2)*I*S1/2", "sqrt(2)*(x+I*y)/2", "[-1,0,0]"),
        "Qh(1,Eb,,)": ("sqrt(2)*C1/2-sqrt(2)*I*S1/2", "sqrt(2)*(x-I*y)/2", "[0,0,1]"),
        "Qh(2,A,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(2,B,1,)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(2,B,2,)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Qh(2,Ea,,)": ("-sqrt(2)*I*C1/2+sqrt(2)*S1/2", "-sqrt(6)*z*(I*x-y)/2", "[0,I,0,0,0]"),
        "Qh(2,Eb,,)": ("sqrt(2)*I*C1/2+sqrt(2)*S1/2", "sqrt(6)*z*(I*x+y)/2", "[0,0,0,I,0]"),
        "Qh(3,A,,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(3,B,1,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(3,B,2,)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(3,Ea,1,)": (
            "-sqrt(3)*C1/4+sqrt(5)*C3/4-sqrt(3)*I*S1/4-sqrt(5)*I*S3/4",
            "sqrt(2)*(2*x**3-3*I*x**2*y-3*x*y**2-3*x*z**2+2*I*y**3-3*I*y*z**2)/4",
            "[0,0,sqrt(6)/4,0,0,0,sqrt(10)/4]",
        ),
        "Qh(3,Ea,2,)": (
            "-sqrt(5)*C1/4-sqrt(3)*C3/4-sqrt(5)*I*S1/4+sqrt(3)*I*S3/4",
            "sqrt(30)*(I*x**2*y+x*y**2-x*z**2-I*y*z**2)/4",
            "[0,0,sqrt(10)/4,0,0,0,-sqrt(6)/4]",
        ),
        "Qh(3,Eb,1,)": (
            "-sqrt(3)*C1/4+sqrt(5)*C3/4+sqrt(3)*I*S1/4+sqrt(5)*I*S3/4",
            "sqrt(2)*(2*x**3+3*I*x**2*y-3*x*y**2-3*x*z**2-2*I*y**3+3*I*y*z**2)/4",
            "[-sqrt(10)/4,0,0,0,-sqrt(6)/4,0,0]",
        ),
        "Qh(3,Eb,2,)": (
            "-sqrt(5)*C1/4-sqrt(3)*C3/4+sqrt(5)*I*S1/4-sqrt(3)*I*S3/4",
            "-sqrt(30)*(I*x**2*y-x*y**2+x*z**2-I*y*z**2)/4",
            "[sqrt(6)/4,0,0,0,-sqrt(10)/4,0,0]",
        ),
        "Qh(4,A,1,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Qh(4,A,2,)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "-sqrt(15)*(x**4-12*x**2*y**2+6*x**2*z**2+y**4+6*y**2*z**2-2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Qh(4,A,3,)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(4,B,1,)": ("-C2", "sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Qh(4,B,2,)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(4,Ea,1,)": (
            "sqrt(7)*I*C1/4-I*C3/4-sqrt(7)*S1/4-S3/4",
            "-sqrt(70)*z*(I*x**3-I*x*z**2-y**3+y*z**2)/4",
            "[0,0,0,-sqrt(14)*I/4,0,0,0,-sqrt(2)*I/4,0]",
        ),
        "Qh(4,Ea,2,)": (
            "I*C1/4+sqrt(7)*I*C3/4-S1/4+sqrt(7)*S3/4",
            "sqrt(10)*z*(I*x**3+6*x**2*y-6*I*x*y**2+I*x*z**2-y**3-y*z**2)/4",
            "[0,0,0,-sqrt(2)*I/4,0,0,0,sqrt(14)*I/4,0]",
        ),
        "Qh(4,Eb,1,)": (
            "-sqrt(7)*I*C1/4+I*C3/4-sqrt(7)*S1/4-S3/4",
            "sqrt(70)*z*(I*x**3-I*x*z**2+y**3-y*z**2)/4",
            "[0,-sqrt(2)*I/4,0,0,0,-sqrt(14)*I/4,0,0,0]",
        ),
        "Qh(4,Eb,2,)": (
            "-I*C1/4-sqrt(7)*I*C3/4-S1/4+sqrt(7)*S3/4",
            "-sqrt(10)*z*(I*x**3-6*x**2*y-6*I*x*y**2+I*x*z**2+y**3+y*z**2)/4",
            "[0,sqrt(14)*I/4,0,0,0,-sqrt(2)*I/4,0,0,0]",
        ),
        "Qh(5,A,1,)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(5,A,2,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(5,A,3,)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(5,B,1,)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(5,B,2,)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(5,Ea,1,)": (
            "sqrt(30)*C1/16-sqrt(35)*C3/16+3*sqrt(7)*C5/16+sqrt(30)*I*S1/16+sqrt(35)*I*S3/16+3*sqrt(7)*I*S5/16",
            "sqrt(2)*(8*x**5+15*I*x**4*y-40*x**3*y**2-40*x**3*z**2-40*I*x**2*y**3+30*I*x**2*y*z**2+15*x*y**4+30*x*y**2*z**2+15*x*z**4+8*I*y**5-40*I*y**3*z**2+15*I*y*z**4)/16",
            "[-3*sqrt(14)/16,0,0,0,-sqrt(15)/8,0,0,0,-sqrt(70)/16,0,0]",
        ),
        "Qh(5,Ea,2,)": (
            "sqrt(42)*C1/16+9*C3/16+sqrt(5)*C5/16+sqrt(42)*I*S1/16-9*I*S3/16+sqrt(5)*I*S5/16",
            "3*sqrt(70)*(I*x**4*y-6*I*x**2*y*z**2+x*y**4-6*x*y**2*z**2+x*z**4+I*y*z**4)/16",
            "[-sqrt(10)/16,0,0,0,-sqrt(21)/8,0,0,0,9*sqrt(2)/16,0,0]",
        ),
        "Qh(5,Ea,3,)": (
            "sqrt(14)*C1/8-sqrt(3)*C3/8-sqrt(15)*C5/8+sqrt(14)*I*S1/8+sqrt(3)*I*S3/8-sqrt(15)*I*S5/8",
            "-sqrt(210)*(I*x**4*y-2*x**3*y**2+2*x**3*z**2-2*I*x**2*y**3+x*y**4-x*z**4+2*I*y**3*z**2-I*y*z**4)/8",
            "[sqrt(30)/8,0,0,0,-sqrt(7)/4,0,0,0,-sqrt(6)/8,0,0]",
        ),
        "Qh(5,Eb,1,)": (
            "sqrt(30)*C1/16-sqrt(35)*C3/16+3*sqrt(7)*C5/16-sqrt(30)*I*S1/16-sqrt(35)*I*S3/16-3*sqrt(7)*I*S5/16",
            "sqrt(2)*(8*x**5-15*I*x**4*y-40*x**3*y**2-40*x**3*z**2+40*I*x**2*y**3-30*I*x**2*y*z**2+15*x*y**4+30*x*y**2*z**2+15*x*z**4-8*I*y**5+40*I*y**3*z**2-15*I*y*z**4)/16",
            "[0,0,sqrt(70)/16,0,0,0,sqrt(15)/8,0,0,0,3*sqrt(14)/16]",
        ),
        "Qh(5,Eb,2,)": (
            "sqrt(42)*C1/16+9*C3/16+sqrt(5)*C5/16-sqrt(42)*I*S1/16+9*I*S3/16-sqrt(5)*I*S5/16",
            "-3*sqrt(70)*(I*x**4*y-6*I*x**2*y*z**2-x*y**4+6*x*y**2*z**2-x*z**4+I*y*z**4)/16",
            "[0,0,-9*sqrt(2)/16,0,0,0,sqrt(21)/8,0,0,0,sqrt(10)/16]",
        ),
        "Qh(5,Eb,3,)": (
            "sqrt(14)*C1/8-sqrt(3)*C3/8-sqrt(15)*C5/8-sqrt(14)*I*S1/8-sqrt(3)*I*S3/8+sqrt(15)*I*S5/8",
            "sqrt(210)*(I*x**4*y+2*x**3*y**2-2*x**3*z**2-2*I*x**2*y**3-x*y**4+x*z**4+2*I*y**3*z**2-I*y*z**4)/8",
            "[0,0,sqrt(6)/8,0,0,0,sqrt(7)/4,0,0,0,-sqrt(30)/8]",
        ),
        "Qh(6,A,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Qh(6,A,2,)": (
            "sqrt(14)*C0/4+sqrt(2)*C4/4",
            "-sqrt(14)*(x**6-15*x**4*z**2+15*x**2*z**4+y**6-15*y**4*z**2+15*y**2*z**4-2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Qh(6,A,3,)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(6,B,1,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Qh(6,B,2,)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x-y)*(x+y)*(x**4-9*x**2*y**2-5*x**2*z**2+y**4-5*y**2*z**2+5*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Qh(6,B,3,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(6,B,4,)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(6,Ea,1,)": (
            "-sqrt(6)*I*C1/8-sqrt(15)*I*C3/8+sqrt(11)*I*C5/8+sqrt(6)*S1/8-sqrt(15)*S3/8-sqrt(11)*S5/8",
            "3*sqrt(14)*z*(I*x**5-10*I*x**3*y**2+10*x**2*y**3-10*x**2*y*z**2+10*I*x*y**2*z**2-I*x*z**4-y**5+y*z**4)/8",
            "[0,-sqrt(22)*I/8,0,0,0,sqrt(3)*I/4,0,0,0,-sqrt(30)*I/8,0,0,0]",
        ),
        "Qh(6,Ea,2,)": (
            "-3*sqrt(11)*I*C1/16+sqrt(110)*I*C3/32-sqrt(6)*I*C5/32+3*sqrt(11)*S1/16+sqrt(110)*S3/32+sqrt(6)*S5/32",
            "-sqrt(231)*z*(3*I*x**5-10*I*x**3*z**2+3*I*x*z**4-3*y**5+10*y**3*z**2-3*y*z**4)/16",
            "[0,sqrt(3)*I/16,0,0,0,3*sqrt(22)*I/16,0,0,0,sqrt(55)*I/16,0,0,0]",
        ),
        "Qh(6,Ea,3,)": (
            "-sqrt(5)*I*C1/16-9*sqrt(2)*I*C3/32-sqrt(330)*I*C5/32+sqrt(5)*S1/16-9*sqrt(2)*S3/32+sqrt(330)*S5/32",
            "-sqrt(105)*z*(I*x**5-16*x**4*y-16*I*x**3*y**2+2*I*x**3*z**2+16*x**2*y**3+16*x**2*y*z**2+16*I*x*y**4-16*I*x*y**2*z**2+I*x*z**4-y**5-2*y**3*z**2-y*z**4)/16",
            "[0,sqrt(165)*I/16,0,0,0,sqrt(10)*I/16,0,0,0,-9*I/16,0,0,0]",
        ),
        "Qh(6,Eb,1,)": (
            "sqrt(6)*I*C1/8+sqrt(15)*I*C3/8-sqrt(11)*I*C5/8+sqrt(6)*S1/8-sqrt(15)*S3/8-sqrt(11)*S5/8",
            "-3*sqrt(14)*z*(I*x**5-10*I*x**3*y**2-10*x**2*y**3+10*x**2*y*z**2+10*I*x*y**2*z**2-I*x*z**4+y**5-y*z**4)/8",
            "[0,0,0,-sqrt(30)*I/8,0,0,0,sqrt(3)*I/4,0,0,0,-sqrt(22)*I/8,0]",
        ),
        "Qh(6,Eb,2,)": (
            "3*sqrt(11)*I*C1/16-sqrt(110)*I*C3/32+sqrt(6)*I*C5/32+3*sqrt(11)*S1/16+sqrt(110)*S3/32+sqrt(6)*S5/32",
            "sqrt(231)*z*(3*I*x**5-10*I*x**3*z**2+3*I*x*z**4+3*y**5-10*y**3*z**2+3*y*z**4)/16",
            "[0,0,0,sqrt(55)*I/16,0,0,0,3*sqrt(22)*I/16,0,0,0,sqrt(3)*I/16,0]",
        ),
        "Qh(6,Eb,3,)": (
            "sqrt(5)*I*C1/16+9*sqrt(2)*I*C3/32+sqrt(330)*I*C5/32+sqrt(5)*S1/16-9*sqrt(2)*S3/32+sqrt(330)*S5/32",
            "sqrt(105)*z*(I*x**5+16*x**4*y-16*I*x**3*y**2+2*I*x**3*z**2-16*x**2*y**3-16*x**2*y*z**2+16*I*x*y**4-16*I*x*y**2*z**2+I*x*z**4+y**5+2*y**3*z**2+y*z**4)/16",
            "[0,0,0,-9*I/16,0,0,0,sqrt(10)*I/16,0,0,0,sqrt(165)*I/16,0]",
        ),
        "Qh(7,A,1,)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(7,A,2,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(7,A,3,)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(7,B,1,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Qh(7,B,2,)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "-sqrt(77)*x*y*z*(3*x**4-20*x**2*y**2+10*x**2*z**2+3*y**4+10*y**2*z**2-6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Qh(7,B,3,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(7,B,4,)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(7,Ea,1,)": (
            "-5*sqrt(14)*C1/64+3*sqrt(42)*C3/64-sqrt(462)*C5/64+sqrt(858)*C7/64-5*sqrt(14)*I*S1/64-3*sqrt(42)*I*S3/64-sqrt(462)*I*S5/64-sqrt(858)*I*S7/64",
            "sqrt(2)*(16*x**7-35*I*x**6*y-168*x**5*y**2-168*x**5*z**2+210*I*x**4*y**3-105*I*x**4*y*z**2+210*x**3*y**4+420*x**3*y**2*z**2+210*x**3*z**4-168*I*x**2*y**5+420*I*x**2*y**3*z**2-105*I*x**2*y*z**4-35*x*y**6-105*x*y**4*z**2-105*x*y**2*z**4-35*x*z**6+16*I*y**7-168*I*y**5*z**2+210*I*y**3*z**4-35*I*y*z**6)/32",
            "[0,0,sqrt(231)/32,0,0,0,5*sqrt(7)/32,0,0,0,3*sqrt(21)/32,0,0,0,sqrt(429)/32]",
        ),
        "Qh(7,Ea,2,)": (
            "-3*sqrt(66)*C1/64-sqrt(22)*C3/64+25*sqrt(2)*C5/64+sqrt(182)*C7/64-3*sqrt(66)*I*S1/64+sqrt(22)*I*S3/64+25*sqrt(2)*I*S5/64-sqrt(182)*I*S7/64",
            "-sqrt(462)*(3*I*x**6*y-10*I*x**4*y**3-15*I*x**4*y*z**2-10*x**3*y**4+60*x**3*y**2*z**2-10*x**3*z**4+60*I*x**2*y**3*z**2-15*I*x**2*y*z**4+3*x*y**6-15*x*y**4*z**2-15*x*y**2*z**4+3*x*z**6-10*I*y**3*z**4+3*I*y*z**6)/32",
            "[0,0,-25/32,0,0,0,3*sqrt(33)/32,0,0,0,-sqrt(11)/32,0,0,0,sqrt(91)/32]",
        ),
        "Qh(7,Ea,3,)": (
            "-sqrt(429)*C1/64-3*sqrt(143)*C3/64-5*sqrt(13)*C5/64-sqrt(7)*C7/64-sqrt(429)*I*S1/64+3*sqrt(143)*I*S3/64-5*sqrt(13)*I*S5/64+sqrt(7)*I*S7/64",
            "sqrt(3003)*(I*x**6*y-15*I*x**4*y*z**2+15*I*x**2*y*z**4+x*y**6-15*x*y**4*z**2+15*x*y**2*z**4-x*z**6-I*y*z**6)/32",
            "[0,0,5*sqrt(26)/64,0,0,0,sqrt(858)/64,0,0,0,-3*sqrt(286)/64,0,0,0,-sqrt(14)/64]",
        ),
        "Qh(7,Ea,4,)": (
            "-15*sqrt(3)*C1/64+19*C3/64-sqrt(11)*C5/64-sqrt(1001)*C7/64-15*sqrt(3)*I*S1/64-19*I*S3/64-sqrt(11)*I*S5/64+sqrt(1001)*I*S7/64",
            "sqrt(21)*(15*I*x**6*y+48*x**5*y**2-48*x**5*z**2-80*I*x**4*y**3+15*I*x**4*y*z**2-80*x**3*y**4+80*x**3*z**4+48*I*x**2*y**5-15*I*x**2*y*z**4+15*x*y**6+15*x*y**4*z**2-15*x*y**2*z**4-15*x*z**6-48*I*y**5*z**2+80*I*y**3*z**4-15*I*y*z**6)/32",
            "[0,0,sqrt(22)/64,0,0,0,15*sqrt(6)/64,0,0,0,19*sqrt(2)/64,0,0,0,-sqrt(2002)/64]",
        ),
        "Qh(7,Eb,1,)": (
            "-5*sqrt(14)*C1/64+3*sqrt(42)*C3/64-sqrt(462)*C5/64+sqrt(858)*C7/64+5*sqrt(14)*I*S1/64+3*sqrt(42)*I*S3/64+sqrt(462)*I*S5/64+sqrt(858)*I*S7/64",
            "sqrt(2)*(16*x**7+35*I*x**6*y-168*x**5*y**2-168*x**5*z**2-210*I*x**4*y**3+105*I*x**4*y*z**2+210*x**3*y**4+420*x**3*y**2*z**2+210*x**3*z**4+168*I*x**2*y**5-420*I*x**2*y**3*z**2+105*I*x**2*y*z**4-35*x*y**6-105*x*y**4*z**2-105*x*y**2*z**4-35*x*z**6-16*I*y**7+168*I*y**5*z**2-210*I*y**3*z**4+35*I*y*z**6)/32",
            "[-sqrt(429)/32,0,0,0,-3*sqrt(21)/32,0,0,0,-5*sqrt(7)/32,0,0,0,-sqrt(231)/32,0,0]",
        ),
        "Qh(7,Eb,2,)": (
            "-3*sqrt(66)*C1/64-sqrt(22)*C3/64+25*sqrt(2)*C5/64+sqrt(182)*C7/64+3*sqrt(66)*I*S1/64-sqrt(22)*I*S3/64-25*sqrt(2)*I*S5/64+sqrt(182)*I*S7/64",
            "sqrt(462)*(3*I*x**6*y-10*I*x**4*y**3-15*I*x**4*y*z**2+10*x**3*y**4-60*x**3*y**2*z**2+10*x**3*z**4+60*I*x**2*y**3*z**2-15*I*x**2*y*z**4-3*x*y**6+15*x*y**4*z**2+15*x*y**2*z**4-3*x*z**6-10*I*y**3*z**4+3*I*y*z**6)/32",
            "[-sqrt(91)/32,0,0,0,sqrt(11)/32,0,0,0,-3*sqrt(33)/32,0,0,0,25/32,0,0]",
        ),
        "Qh(7,Eb,3,)": (
            "-sqrt(429)*C1/64-3*sqrt(143)*C3/64-5*sqrt(13)*C5/64-sqrt(7)*C7/64+sqrt(429)*I*S1/64-3*sqrt(143)*I*S3/64+5*sqrt(13)*I*S5/64-sqrt(7)*I*S7/64",
            "-sqrt(3003)*(I*x**6*y-15*I*x**4*y*z**2+15*I*x**2*y*z**4-x*y**6+15*x*y**4*z**2-15*x*y**2*z**4+x*z**6-I*y*z**6)/32",
            "[sqrt(14)/64,0,0,0,3*sqrt(286)/64,0,0,0,-sqrt(858)/64,0,0,0,-5*sqrt(26)/64,0,0]",
        ),
        "Qh(7,Eb,4,)": (
            "-15*sqrt(3)*C1/64+19*C3/64-sqrt(11)*C5/64-sqrt(1001)*C7/64+15*sqrt(3)*I*S1/64+19*I*S3/64+sqrt(11)*I*S5/64-sqrt(1001)*I*S7/64",
            "-sqrt(21)*(15*I*x**6*y-48*x**5*y**2+48*x**5*z**2-80*I*x**4*y**3+15*I*x**4*y*z**2+80*x**3*y**4-80*x**3*z**4+48*I*x**2*y**5-15*I*x**2*y*z**4-15*x*y**6-15*x*y**4*z**2+15*x*y**2*z**4+15*x*z**6-48*I*y**5*z**2+80*I*y**3*z**4-15*I*y*z**6)/32",
            "[sqrt(2002)/64,0,0,0,-19*sqrt(2)/64,0,0,0,-15*sqrt(6)/64,0,0,0,-sqrt(22)/64,0,0]",
        ),
        "Qh(8,A,1,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Qh(8,A,2,)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Qh(8,A,3,)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Qh(8,A,4,)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(8,A,5,)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(8,B,1,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(8,B,2,)": (
            "C2",
            "-3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(8,B,3,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(8,B,4,)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(8,Ea,1,)": (
            "sqrt(1430)*I*C1/64-sqrt(546)*I*C3/64+sqrt(70)*I*C5/64-sqrt(2)*I*C7/64-sqrt(1430)*S1/64-sqrt(546)*S3/64-sqrt(70)*S5/64-sqrt(2)*S7/64",
            "-3*sqrt(1430)*z*(I*x**7-7*I*x**5*z**2+7*I*x**3*z**4-I*x*z**6-y**7+7*y**5*z**2-7*y**3*z**4+y*z**6)/32",
            "[0,0,0,-sqrt(35)*I/32,0,0,0,-sqrt(715)*I/32,0,0,0,-sqrt(273)*I/32,0,0,0,-I/32,0]",
        ),
        "Qh(8,Ea,2,)": (
            "sqrt(154)*I*C1/64+5*sqrt(30)*I*C3/64+3*sqrt(26)*I*C5/64-sqrt(910)*I*C7/64-sqrt(154)*S1/64+5*sqrt(30)*S3/64-3*sqrt(26)*S5/64-sqrt(910)*S7/64",
            "-3*sqrt(154)*z*(I*x**7-24*I*x**5*y**2+I*x**5*z**2-40*x**4*y**3+40*x**4*y*z**2+40*I*x**3*y**4-I*x**3*z**4+24*x**2*y**5-24*x**2*y*z**4-40*I*x*y**4*z**2+24*I*x*y**2*z**4-I*x*z**6-y**7-y**5*z**2+y**3*z**4+y*z**6)/32",
            "[0,0,0,-3*sqrt(13)*I/32,0,0,0,-sqrt(77)*I/32,0,0,0,5*sqrt(15)*I/32,0,0,0,-sqrt(455)*I/32,0]",
        ),
        "Qh(8,Ea,3,)": (
            "sqrt(429)*I*C1/64+sqrt(455)*I*C3/64-7*sqrt(21)*I*C5/64+3*sqrt(15)*I*C7/64-sqrt(429)*S1/64+sqrt(455)*S3/64+7*sqrt(21)*S5/64+3*sqrt(15)*S7/64",
            "sqrt(429)*z*(3*I*x**7-42*I*x**5*y**2-7*I*x**5*z**2+140*I*x**3*y**2*z**2-7*I*x**3*z**4+42*x**2*y**5-140*x**2*y**3*z**2+42*x**2*y*z**4-42*I*x*y**2*z**4+3*I*x*z**6-3*y**7+7*y**5*z**2+7*y**3*z**4-3*y*z**6)/32",
            "[0,0,0,7*sqrt(42)*I/64,0,0,0,-sqrt(858)*I/64,0,0,0,sqrt(910)*I/64,0,0,0,3*sqrt(30)*I/64,0]",
        ),
        "Qh(8,Ea,4,)": (
            "sqrt(35)*I*C1/64+3*sqrt(33)*I*C3/64+sqrt(715)*I*C5/64+sqrt(1001)*I*C7/64-sqrt(35)*S1/64+3*sqrt(33)*S3/64-sqrt(715)*S5/64+sqrt(1001)*S7/64",
            "3*sqrt(35)*z*(I*x**7+32*x**6*y-30*I*x**5*y**2+3*I*x**5*z**2-80*x**4*y**3-80*x**4*y*z**2+80*I*x**3*y**4-60*I*x**3*y**2*z**2+3*I*x**3*z**4+30*x**2*y**5+60*x**2*y**3*z**2+30*x**2*y*z**4-32*I*x*y**6+80*I*x*y**4*z**2-30*I*x*y**2*z**4+I*x*z**6-y**7-3*y**5*z**2-3*y**3*z**4-y*z**6)/32",
            "[0,0,0,-sqrt(1430)*I/64,0,0,0,-sqrt(70)*I/64,0,0,0,3*sqrt(66)*I/64,0,0,0,sqrt(2002)*I/64,0]",
        ),
        "Qh(8,Eb,1,)": (
            "-sqrt(1430)*I*C1/64+sqrt(546)*I*C3/64-sqrt(70)*I*C5/64+sqrt(2)*I*C7/64-sqrt(1430)*S1/64-sqrt(546)*S3/64-sqrt(70)*S5/64-sqrt(2)*S7/64",
            "3*sqrt(1430)*z*(I*x**7-7*I*x**5*z**2+7*I*x**3*z**4-I*x*z**6+y**7-7*y**5*z**2+7*y**3*z**4-y*z**6)/32",
            "[0,-I/32,0,0,0,-sqrt(273)*I/32,0,0,0,-sqrt(715)*I/32,0,0,0,-sqrt(35)*I/32,0,0,0]",
        ),
        "Qh(8,Eb,2,)": (
            "-sqrt(154)*I*C1/64-5*sqrt(30)*I*C3/64-3*sqrt(26)*I*C5/64+sqrt(910)*I*C7/64-sqrt(154)*S1/64+5*sqrt(30)*S3/64-3*sqrt(26)*S5/64-sqrt(910)*S7/64",
            "3*sqrt(154)*z*(I*x**7-24*I*x**5*y**2+I*x**5*z**2+40*x**4*y**3-40*x**4*y*z**2+40*I*x**3*y**4-I*x**3*z**4-24*x**2*y**5+24*x**2*y*z**4-40*I*x*y**4*z**2+24*I*x*y**2*z**4-I*x*z**6+y**7+y**5*z**2-y**3*z**4-y*z**6)/32",
            "[0,-sqrt(455)*I/32,0,0,0,5*sqrt(15)*I/32,0,0,0,-sqrt(77)*I/32,0,0,0,-3*sqrt(13)*I/32,0,0,0]",
        ),
        "Qh(8,Eb,3,)": (
            "-sqrt(429)*I*C1/64-sqrt(455)*I*C3/64+7*sqrt(21)*I*C5/64-3*sqrt(15)*I*C7/64-sqrt(429)*S1/64+sqrt(455)*S3/64+7*sqrt(21)*S5/64+3*sqrt(15)*S7/64",
            "-sqrt(429)*z*(3*I*x**7-42*I*x**5*y**2-7*I*x**5*z**2+140*I*x**3*y**2*z**2-7*I*x**3*z**4-42*x**2*y**5+140*x**2*y**3*z**2-42*x**2*y*z**4-42*I*x*y**2*z**4+3*I*x*z**6+3*y**7-7*y**5*z**2-7*y**3*z**4+3*y*z**6)/32",
            "[0,3*sqrt(30)*I/64,0,0,0,sqrt(910)*I/64,0,0,0,-sqrt(858)*I/64,0,0,0,7*sqrt(42)*I/64,0,0,0]",
        ),
        "Qh(8,Eb,4,)": (
            "-sqrt(35)*I*C1/64-3*sqrt(33)*I*C3/64-sqrt(715)*I*C5/64-sqrt(1001)*I*C7/64-sqrt(35)*S1/64+3*sqrt(33)*S3/64-sqrt(715)*S5/64+sqrt(1001)*S7/64",
            "-3*sqrt(35)*z*(I*x**7-32*x**6*y-30*I*x**5*y**2+3*I*x**5*z**2+80*x**4*y**3+80*x**4*y*z**2+80*I*x**3*y**4-60*I*x**3*y**2*z**2+3*I*x**3*z**4-30*x**2*y**5-60*x**2*y**3*z**2-30*x**2*y*z**4-32*I*x*y**6+80*I*x*y**4*z**2-30*I*x*y**2*z**4+I*x*z**6+y**7+3*y**5*z**2+3*y**3*z**4+y*z**6)/32",
            "[0,sqrt(2002)*I/64,0,0,0,3*sqrt(66)*I/64,0,0,0,-sqrt(70)*I/64,0,0,0,-sqrt(1430)*I/64,0,0,0]",
        ),
        "Qh(9,A,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Qh(9,A,2,)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(x-y)*(x+y)*(3*x**4-11*x**2*y**2-7*x**2*z**2+3*y**4-7*y**2*z**2+7*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Qh(9,A,3,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,A,4,)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,A,5,)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(9,B,1,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Qh(9,B,2,)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Qh(9,B,3,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,B,4,)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Ea,1,)": (
            "21*sqrt(10)*C1/256-sqrt(1155)*C3/128+3*sqrt(143)*C5/128-3*sqrt(715)*C7/256+sqrt(12155)*C9/256+21*sqrt(10)*I*S1/256+sqrt(1155)*I*S3/128+3*sqrt(143)*I*S5/128+3*sqrt(715)*I*S7/256+sqrt(12155)*I*S9/256",
            "sqrt(2)*(128*x**9+315*I*x**8*y-2304*x**7*y**2-2304*x**7*z**2-3360*I*x**6*y**3+1260*I*x**6*y*z**2+6048*x**5*y**4+12096*x**5*y**2*z**2+6048*x**5*z**4+6048*I*x**4*y**5-10080*I*x**4*y**3*z**2+1890*I*x**4*y*z**4-3360*x**3*y**6-10080*x**3*y**4*z**2-10080*x**3*y**2*z**4-3360*x**3*z**6-2304*I*x**2*y**7+12096*I*x**2*y**5*z**2-10080*I*x**2*y**3*z**4+1260*I*x**2*y*z**6+315*x*y**8+1260*x*y**6*z**2+1890*x*y**4*z**4+1260*x*y**2*z**6+315*x*z**8+128*I*y**9-2304*I*y**7*z**2+6048*I*y**5*z**4-3360*I*y**3*z**6+315*I*y*z**8)/256",
            "[-sqrt(24310)/256,0,0,0,-3*sqrt(286)/128,0,0,0,-21*sqrt(5)/128,0,0,0,-sqrt(2310)/128,0,0,0,-3*sqrt(1430)/256,0,0]",
        ),
        "Qh(9,Ea,2,)": (
            "sqrt(4862)*C1/256+sqrt(4641)*C3/128+5*sqrt(85)*C5/128+7*sqrt(17)*C7/256+3*C9/256+sqrt(4862)*I*S1/256-sqrt(4641)*I*S3/128+5*sqrt(85)*I*S5/128-7*sqrt(17)*I*S7/256+3*I*S9/256",
            "3*sqrt(24310)*(I*x**8*y-28*I*x**6*y*z**2+70*I*x**4*y*z**4-28*I*x**2*y*z**6+x*y**8-28*x*y**6*z**2+70*x*y**4*z**4-28*x*y**2*z**6+x*z**8+I*y*z**8)/256",
            "[-3*sqrt(2)/256,0,0,0,-5*sqrt(170)/128,0,0,0,-sqrt(2431)/128,0,0,0,sqrt(9282)/128,0,0,0,7*sqrt(34)/256,0,0]",
        ),
        "Qh(9,Ea,3,)": (
            "sqrt(2002)*C1/128-sqrt(39)*C3/64-3*sqrt(35)*C5/64+23*sqrt(7)*C7/128+3*sqrt(119)*C9/128+sqrt(2002)*I*S1/128+sqrt(39)*I*S3/64-3*sqrt(35)*I*S5/64-23*sqrt(7)*I*S7/128+3*sqrt(119)*I*S9/128",
            "3*sqrt(10010)*(I*x**8*y-8*I*x**6*y**3-4*I*x**6*y*z**2+8*x**5*y**4-48*x**5*y**2*z**2+8*x**5*z**4+8*I*x**4*y**5+40*I*x**4*y**3*z**2-10*I*x**4*y*z**4-8*x**3*y**6+40*x**3*y**4*z**2+40*x**3*y**2*z**4-8*x**3*z**6-48*I*x**2*y**5*z**2+40*I*x**2*y**3*z**4-4*I*x**2*y*z**6+x*y**8-4*x*y**6*z**2-10*x*y**4*z**4-4*x*y**2*z**6+x*z**8+8*I*y**5*z**4-8*I*y**3*z**6+I*y*z**8)/128",
            "[-3*sqrt(238)/128,0,0,0,3*sqrt(70)/64,0,0,0,-sqrt(1001)/64,0,0,0,-sqrt(78)/64,0,0,0,23*sqrt(14)/128,0,0]",
        ),
        "Qh(9,Ea,4,)": (
            "sqrt(429)*C1/64+sqrt(182)*C3/64-5*sqrt(30)*C5/64-21*sqrt(6)*C7/128-sqrt(102)*C9/128+sqrt(429)*I*S1/64-sqrt(182)*I*S3/64-5*sqrt(30)*I*S5/64+21*sqrt(6)*I*S7/128-sqrt(102)*I*S9/128",
            "-sqrt(2145)*(3*I*x**8*y-14*I*x**6*y**3-42*I*x**6*y*z**2+210*I*x**4*y**3*z**2-14*x**3*y**6+210*x**3*y**4*z**2-210*x**3*y**2*z**4+14*x**3*z**6-210*I*x**2*y**3*z**4+42*I*x**2*y*z**6+3*x*y**8-42*x*y**6*z**2+42*x*y**2*z**6-3*x*z**8+14*I*y**3*z**6-3*I*y*z**8)/64",
            "[sqrt(51)/64,0,0,0,5*sqrt(15)/32,0,0,0,-sqrt(858)/64,0,0,0,sqrt(91)/32,0,0,0,-21*sqrt(3)/64,0,0]",
        ),
        "Qh(9,Ea,5,)": (
            "7*sqrt(11)*C1/64-3*sqrt(42)*C3/64+sqrt(130)*C5/64+sqrt(26)*C7/128-3*sqrt(442)*C9/128+7*sqrt(11)*I*S1/64+3*sqrt(42)*I*S3/64+sqrt(130)*I*S5/64-sqrt(26)*I*S7/128-3*sqrt(442)*I*S9/128",
            "-3*sqrt(55)*(7*I*x**8*y-32*x**7*y**2+32*x**7*z**2-70*I*x**6*y**3+14*I*x**6*y*z**2+112*x**5*y**4-112*x**5*z**4+112*I*x**4*y**5-70*I*x**4*y**3*z**2-70*x**3*y**6-70*x**3*y**4*z**2+70*x**3*y**2*z**4+70*x**3*z**6-32*I*x**2*y**7+70*I*x**2*y**3*z**4-14*I*x**2*y*z**6+7*x*y**8+14*x*y**6*z**2-14*x*y**2*z**6-7*x*z**8+32*I*y**7*z**2-112*I*y**5*z**4+70*I*y**3*z**6-7*I*y*z**8)/64",
            "[3*sqrt(221)/64,0,0,0,-sqrt(65)/32,0,0,0,-7*sqrt(22)/64,0,0,0,-3*sqrt(21)/32,0,0,0,sqrt(13)/64,0,0]",
        ),
        "Qh(9,Eb,1,)": (
            "21*sqrt(10)*C1/256-sqrt(1155)*C3/128+3*sqrt(143)*C5/128-3*sqrt(715)*C7/256+sqrt(12155)*C9/256-21*sqrt(10)*I*S1/256-sqrt(1155)*I*S3/128-3*sqrt(143)*I*S5/128-3*sqrt(715)*I*S7/256-sqrt(12155)*I*S9/256",
            "sqrt(2)*(128*x**9-315*I*x**8*y-2304*x**7*y**2-2304*x**7*z**2+3360*I*x**6*y**3-1260*I*x**6*y*z**2+6048*x**5*y**4+12096*x**5*y**2*z**2+6048*x**5*z**4-6048*I*x**4*y**5+10080*I*x**4*y**3*z**2-1890*I*x**4*y*z**4-3360*x**3*y**6-10080*x**3*y**4*z**2-10080*x**3*y**2*z**4-3360*x**3*z**6+2304*I*x**2*y**7-12096*I*x**2*y**5*z**2+10080*I*x**2*y**3*z**4-1260*I*x**2*y*z**6+315*x*y**8+1260*x*y**6*z**2+1890*x*y**4*z**4+1260*x*y**2*z**6+315*x*z**8-128*I*y**9+2304*I*y**7*z**2-6048*I*y**5*z**4+3360*I*y**3*z**6-315*I*y*z**8)/256",
            "[0,0,3*sqrt(1430)/256,0,0,0,sqrt(2310)/128,0,0,0,21*sqrt(5)/128,0,0,0,3*sqrt(286)/128,0,0,0,sqrt(24310)/256]",
        ),
        "Qh(9,Eb,2,)": (
            "sqrt(4862)*C1/256+sqrt(4641)*C3/128+5*sqrt(85)*C5/128+7*sqrt(17)*C7/256+3*C9/256-sqrt(4862)*I*S1/256+sqrt(4641)*I*S3/128-5*sqrt(85)*I*S5/128+7*sqrt(17)*I*S7/256-3*I*S9/256",
            "-3*sqrt(24310)*(I*x**8*y-28*I*x**6*y*z**2+70*I*x**4*y*z**4-28*I*x**2*y*z**6-x*y**8+28*x*y**6*z**2-70*x*y**4*z**4+28*x*y**2*z**6-x*z**8+I*y*z**8)/256",
            "[0,0,-7*sqrt(34)/256,0,0,0,-sqrt(9282)/128,0,0,0,sqrt(2431)/128,0,0,0,5*sqrt(170)/128,0,0,0,3*sqrt(2)/256]",
        ),
        "Qh(9,Eb,3,)": (
            "sqrt(2002)*C1/128-sqrt(39)*C3/64-3*sqrt(35)*C5/64+23*sqrt(7)*C7/128+3*sqrt(119)*C9/128-sqrt(2002)*I*S1/128-sqrt(39)*I*S3/64+3*sqrt(35)*I*S5/64+23*sqrt(7)*I*S7/128-3*sqrt(119)*I*S9/128",
            "-3*sqrt(10010)*(I*x**8*y-8*I*x**6*y**3-4*I*x**6*y*z**2-8*x**5*y**4+48*x**5*y**2*z**2-8*x**5*z**4+8*I*x**4*y**5+40*I*x**4*y**3*z**2-10*I*x**4*y*z**4+8*x**3*y**6-40*x**3*y**4*z**2-40*x**3*y**2*z**4+8*x**3*z**6-48*I*x**2*y**5*z**2+40*I*x**2*y**3*z**4-4*I*x**2*y*z**6-x*y**8+4*x*y**6*z**2+10*x*y**4*z**4+4*x*y**2*z**6-x*z**8+8*I*y**5*z**4-8*I*y**3*z**6+I*y*z**8)/128",
            "[0,0,-23*sqrt(14)/128,0,0,0,sqrt(78)/64,0,0,0,sqrt(1001)/64,0,0,0,-3*sqrt(70)/64,0,0,0,3*sqrt(238)/128]",
        ),
        "Qh(9,Eb,4,)": (
            "sqrt(429)*C1/64+sqrt(182)*C3/64-5*sqrt(30)*C5/64-21*sqrt(6)*C7/128-sqrt(102)*C9/128-sqrt(429)*I*S1/64+sqrt(182)*I*S3/64+5*sqrt(30)*I*S5/64-21*sqrt(6)*I*S7/128+sqrt(102)*I*S9/128",
            "sqrt(2145)*(3*I*x**8*y-14*I*x**6*y**3-42*I*x**6*y*z**2+210*I*x**4*y**3*z**2+14*x**3*y**6-210*x**3*y**4*z**2+210*x**3*y**2*z**4-14*x**3*z**6-210*I*x**2*y**3*z**4+42*I*x**2*y*z**6-3*x*y**8+42*x*y**6*z**2-42*x*y**2*z**6+3*x*z**8+14*I*y**3*z**6-3*I*y*z**8)/64",
            "[0,0,21*sqrt(3)/64,0,0,0,-sqrt(91)/32,0,0,0,sqrt(858)/64,0,0,0,-5*sqrt(15)/32,0,0,0,-sqrt(51)/64]",
        ),
        "Qh(9,Eb,5,)": (
            "7*sqrt(11)*C1/64-3*sqrt(42)*C3/64+sqrt(130)*C5/64+sqrt(26)*C7/128-3*sqrt(442)*C9/128-7*sqrt(11)*I*S1/64-3*sqrt(42)*I*S3/64-sqrt(130)*I*S5/64+sqrt(26)*I*S7/128+3*sqrt(442)*I*S9/128",
            "3*sqrt(55)*(7*I*x**8*y+32*x**7*y**2-32*x**7*z**2-70*I*x**6*y**3+14*I*x**6*y*z**2-112*x**5*y**4+112*x**5*z**4+112*I*x**4*y**5-70*I*x**4*y**3*z**2+70*x**3*y**6+70*x**3*y**4*z**2-70*x**3*y**2*z**4-70*x**3*z**6-32*I*x**2*y**7+70*I*x**2*y**3*z**4-14*I*x**2*y*z**6-7*x*y**8-14*x*y**6*z**2+14*x*y**2*z**6+7*x*z**8+32*I*y**7*z**2-112*I*y**5*z**4+70*I*y**3*z**6-7*I*y*z**8)/64",
            "[0,0,-sqrt(13)/64,0,0,0,3*sqrt(21)/32,0,0,0,7*sqrt(22)/64,0,0,0,sqrt(65)/32,0,0,0,-3*sqrt(221)/64]",
        ),
        "Qh(10,A,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Qh(10,A,2,)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "-sqrt(420189)*(22*x**10+45*x**8*y**2-1035*x**8*z**2-105*x**6*y**4-630*x**6*y**2*z**2+4935*x**6*z**4-105*x**4*y**6+3150*x**4*y**4*z**2-1575*x**4*y**2*z**4-4830*x**4*z**6+45*x**2*y**8-630*x**2*y**6*z**2-1575*x**2*y**4*z**4+1260*x**2*y**2*z**6+990*x**2*z**8+22*y**10-1035*y**8*z**2+4935*y**6*z**4-4830*y**4*z**6+990*y**2*z**8-44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Qh(10,A,3,)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "-sqrt(3213210)*(3*x**10-96*x**8*y**2-39*x**8*z**2+224*x**6*y**4+1344*x**6*y**2*z**2-42*x**6*z**4+224*x**4*y**6-6720*x**4*y**4*z**2+3360*x**4*y**2*z**4-182*x**4*z**6-96*x**2*y**8+1344*x**2*y**6*z**2+3360*x**2*y**4*z**4-2688*x**2*y**2*z**6+135*x**2*z**8+3*y**10-39*y**8*z**2-42*y**6*z**4-182*y**4*z**6+135*y**2*z**8-6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Qh(10,A,4,)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(10,A,5,)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(10,B,1,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Qh(10,B,2,)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(x-y)*(x+y)*(22*x**8-653*x**6*y**2-315*x**6*z**2+2602*x**4*y**4-945*x**4*y**2*z**2+1575*x**4*z**4-653*x**2*y**6-945*x**2*y**4*z**2+3150*x**2*y**2*z**4-1680*x**2*z**6+22*y**8-315*y**6*z**2+1575*y**4*z**4-1680*y**2*z**6+360*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Qh(10,B,3,)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(x-y)*(x+y)*(9*x**8-165*x**6*y**2-231*x**6*z**2-25*x**4*y**4+3801*x**4*y**2*z**2+406*x**4*z**4-165*x**2*y**6+3801*x**2*y**4*z**2-9674*x**2*y**2*z**4+266*x**2*z**6+9*y**8-231*y**6*z**2+406*y**4*z**4+266*y**2*z**6-57*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Qh(10,B,4,)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(10,B,5,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,B,6,)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Ea,1,)": (
            "-sqrt(442)*I*C1/64-sqrt(51)*I*C3/32+sqrt(255)*I*C5/32-11*sqrt(3)*I*C7/64+sqrt(19)*I*C9/64+sqrt(442)*S1/64-sqrt(51)*S3/32-sqrt(255)*S5/32-11*sqrt(3)*S7/64-sqrt(19)*S9/64",
            "sqrt(24310)*z*(I*x**9-18*I*x**7*y**2-6*I*x**7*z**2+126*I*x**5*y**2*z**2-126*I*x**3*y**2*z**4+6*I*x**3*z**6+18*x**2*y**7-126*x**2*y**5*z**2+126*x**2*y**3*z**4-18*x**2*y*z**6+18*I*x*y**2*z**6-I*x*z**8-y**9+6*y**7*z**2-6*y**3*z**6+y*z**8)/64",
            "[0,-sqrt(38)*I/64,0,0,0,-sqrt(510)*I/32,0,0,0,sqrt(221)*I/32,0,0,0,-sqrt(102)*I/32,0,0,0,-11*sqrt(6)*I/64,0,0,0]",
        ),
        "Qh(10,Ea,2,)": (
            "-sqrt(78)*I*C1/64-11*I*C3/32-5*sqrt(5)*I*C5/32-sqrt(17)*I*C7/64+sqrt(969)*I*C9/64+sqrt(78)*S1/64-11*S3/32+5*sqrt(5)*S5/32-sqrt(17)*S7/64-sqrt(969)*S9/64",
            "sqrt(4290)*z*(I*x**9-42*I*x**7*y**2+2*I*x**7*z**2+112*x**6*y**3-112*x**6*y*z**2+168*I*x**5*y**4-42*I*x**5*y**2*z**2-168*x**4*y**5+168*x**4*y*z**4-112*I*x**3*y**6+42*I*x**3*y**2*z**4-2*I*x**3*z**6+42*x**2*y**7+42*x**2*y**5*z**2-42*x**2*y**3*z**4-42*x**2*y*z**6+112*I*x*y**6*z**2-168*I*x*y**4*z**4+42*I*x*y**2*z**6-I*x*z**8-y**9-2*y**7*z**2+2*y**3*z**6+y*z**8)/64",
            "[0,-sqrt(1938)*I/64,0,0,0,5*sqrt(10)*I/32,0,0,0,sqrt(39)*I/32,0,0,0,-11*sqrt(2)*I/32,0,0,0,-sqrt(34)*I/64,0,0,0]",
        ),
        "Qh(10,Ea,3,)": (
            "-sqrt(20995)*I*C1/256+sqrt(9690)*I*C3/256-sqrt(1938)*I*C5/256+sqrt(570)*I*C7/512-sqrt(10)*I*C9/512+sqrt(20995)*S1/256+sqrt(9690)*S3/256+sqrt(1938)*S5/256+sqrt(570)*S7/512+sqrt(10)*S9/512",
            "-sqrt(46189)*z*(5*I*x**9-60*I*x**7*z**2+126*I*x**5*z**4-60*I*x**3*z**6+5*I*x*z**8-5*y**9+60*y**7*z**2-126*y**5*z**4+60*y**3*z**6-5*y*z**8)/256",
            "[0,sqrt(5)*I/256,0,0,0,sqrt(969)*I/128,0,0,0,sqrt(41990)*I/256,0,0,0,sqrt(4845)*I/128,0,0,0,sqrt(285)*I/256,0,0,0]",
        ),
        "Qh(10,Ea,4,)": (
            "-9*sqrt(39)*I*C1/256-69*sqrt(2)*I*C3/256+sqrt(10)*I*C5/256+43*sqrt(34)*I*C7/512-3*sqrt(1938)*I*C9/512+9*sqrt(39)*S1/256-69*sqrt(2)*S3/256-sqrt(10)*S5/256+43*sqrt(34)*S7/512+3*sqrt(1938)*S9/512",
            "-sqrt(2145)*z*(9*I*x**9-288*I*x**7*y**2-12*I*x**7*z**2+672*I*x**5*y**4+672*I*x**5*y**2*z**2-42*I*x**5*z**4-672*x**4*y**5+2240*x**4*y**3*z**2-672*x**4*y*z**4-2240*I*x**3*y**4*z**2+672*I*x**3*y**2*z**4-12*I*x**3*z**6+288*x**2*y**7-672*x**2*y**5*z**2-672*x**2*y**3*z**4+288*x**2*y*z**6+672*I*x*y**4*z**4-288*I*x*y**2*z**6+9*I*x*z**8-9*y**9+12*y**7*z**2+42*y**5*z**4+12*y**3*z**6-9*y*z**8)/256",
            "[0,3*sqrt(969)*I/256,0,0,0,-sqrt(5)*I/128,0,0,0,9*sqrt(78)*I/256,0,0,0,-69*I/128,0,0,0,43*sqrt(17)*I/256,0,0,0]",
        ),
        "Qh(10,Ea,5,)": (
            "-7*sqrt(6)*I*C1/256-7*sqrt(13)*I*C3/128-5*sqrt(65)*I*C5/128-7*sqrt(221)*I*C7/256-sqrt(12597)*I*C9/256+7*sqrt(6)*S1/256-7*sqrt(13)*S3/128+5*sqrt(65)*S5/128-7*sqrt(221)*S7/256+sqrt(12597)*S9/256",
            "-sqrt(330)*z*(7*I*x**9-384*x**8*y-336*I*x**7*y**2+28*I*x**7*z**2+1792*x**6*y**3+1792*x**6*y*z**2+1680*I*x**5*y**4-1008*I*x**5*y**2*z**2+42*I*x**5*z**4-1680*x**4*y**5-3360*x**4*y**3*z**2-1680*x**4*y*z**4-1792*I*x**3*y**6+3360*I*x**3*y**4*z**2-1008*I*x**3*y**2*z**4+28*I*x**3*z**6+336*x**2*y**7+1008*x**2*y**5*z**2+1008*x**2*y**3*z**4+336*x**2*y*z**6+384*I*x*y**8-1792*I*x*y**6*z**2+1680*I*x*y**4*z**4-336*I*x*y**2*z**6+7*I*x*z**8-7*y**9-28*y**7*z**2-42*y**5*z**4-28*y**3*z**6-7*y*z**8)/256",
            "[0,sqrt(25194)*I/256,0,0,0,5*sqrt(130)*I/128,0,0,0,7*sqrt(3)*I/128,0,0,0,-7*sqrt(26)*I/128,0,0,0,-7*sqrt(442)*I/256,0,0,0]",
        ),
        "Qh(10,Eb,1,)": (
            "sqrt(442)*I*C1/64+sqrt(51)*I*C3/32-sqrt(255)*I*C5/32+11*sqrt(3)*I*C7/64-sqrt(19)*I*C9/64+sqrt(442)*S1/64-sqrt(51)*S3/32-sqrt(255)*S5/32-11*sqrt(3)*S7/64-sqrt(19)*S9/64",
            "-sqrt(24310)*z*(I*x**9-18*I*x**7*y**2-6*I*x**7*z**2+126*I*x**5*y**2*z**2-126*I*x**3*y**2*z**4+6*I*x**3*z**6-18*x**2*y**7+126*x**2*y**5*z**2-126*x**2*y**3*z**4+18*x**2*y*z**6+18*I*x*y**2*z**6-I*x*z**8+y**9-6*y**7*z**2+6*y**3*z**6-y*z**8)/64",
            "[0,0,0,-11*sqrt(6)*I/64,0,0,0,-sqrt(102)*I/32,0,0,0,sqrt(221)*I/32,0,0,0,-sqrt(510)*I/32,0,0,0,-sqrt(38)*I/64,0]",
        ),
        "Qh(10,Eb,2,)": (
            "sqrt(78)*I*C1/64+11*I*C3/32+5*sqrt(5)*I*C5/32+sqrt(17)*I*C7/64-sqrt(969)*I*C9/64+sqrt(78)*S1/64-11*S3/32+5*sqrt(5)*S5/32-sqrt(17)*S7/64-sqrt(969)*S9/64",
            "-sqrt(4290)*z*(I*x**9-42*I*x**7*y**2+2*I*x**7*z**2-112*x**6*y**3+112*x**6*y*z**2+168*I*x**5*y**4-42*I*x**5*y**2*z**2+168*x**4*y**5-168*x**4*y*z**4-112*I*x**3*y**6+42*I*x**3*y**2*z**4-2*I*x**3*z**6-42*x**2*y**7-42*x**2*y**5*z**2+42*x**2*y**3*z**4+42*x**2*y*z**6+112*I*x*y**6*z**2-168*I*x*y**4*z**4+42*I*x*y**2*z**6-I*x*z**8+y**9+2*y**7*z**2-2*y**3*z**6-y*z**8)/64",
            "[0,0,0,-sqrt(34)*I/64,0,0,0,-11*sqrt(2)*I/32,0,0,0,sqrt(39)*I/32,0,0,0,5*sqrt(10)*I/32,0,0,0,-sqrt(1938)*I/64,0]",
        ),
        "Qh(10,Eb,3,)": (
            "sqrt(20995)*I*C1/256-sqrt(9690)*I*C3/256+sqrt(1938)*I*C5/256-sqrt(570)*I*C7/512+sqrt(10)*I*C9/512+sqrt(20995)*S1/256+sqrt(9690)*S3/256+sqrt(1938)*S5/256+sqrt(570)*S7/512+sqrt(10)*S9/512",
            "sqrt(46189)*z*(5*I*x**9-60*I*x**7*z**2+126*I*x**5*z**4-60*I*x**3*z**6+5*I*x*z**8+5*y**9-60*y**7*z**2+126*y**5*z**4-60*y**3*z**6+5*y*z**8)/256",
            "[0,0,0,sqrt(285)*I/256,0,0,0,sqrt(4845)*I/128,0,0,0,sqrt(41990)*I/256,0,0,0,sqrt(969)*I/128,0,0,0,sqrt(5)*I/256,0]",
        ),
        "Qh(10,Eb,4,)": (
            "9*sqrt(39)*I*C1/256+69*sqrt(2)*I*C3/256-sqrt(10)*I*C5/256-43*sqrt(34)*I*C7/512+3*sqrt(1938)*I*C9/512+9*sqrt(39)*S1/256-69*sqrt(2)*S3/256-sqrt(10)*S5/256+43*sqrt(34)*S7/512+3*sqrt(1938)*S9/512",
            "sqrt(2145)*z*(9*I*x**9-288*I*x**7*y**2-12*I*x**7*z**2+672*I*x**5*y**4+672*I*x**5*y**2*z**2-42*I*x**5*z**4+672*x**4*y**5-2240*x**4*y**3*z**2+672*x**4*y*z**4-2240*I*x**3*y**4*z**2+672*I*x**3*y**2*z**4-12*I*x**3*z**6-288*x**2*y**7+672*x**2*y**5*z**2+672*x**2*y**3*z**4-288*x**2*y*z**6+672*I*x*y**4*z**4-288*I*x*y**2*z**6+9*I*x*z**8+9*y**9-12*y**7*z**2-42*y**5*z**4-12*y**3*z**6+9*y*z**8)/256",
            "[0,0,0,43*sqrt(17)*I/256,0,0,0,-69*I/128,0,0,0,9*sqrt(78)*I/256,0,0,0,-sqrt(5)*I/128,0,0,0,3*sqrt(969)*I/256,0]",
        ),
        "Qh(10,Eb,5,)": (
            "7*sqrt(6)*I*C1/256+7*sqrt(13)*I*C3/128+5*sqrt(65)*I*C5/128+7*sqrt(221)*I*C7/256+sqrt(12597)*I*C9/256+7*sqrt(6)*S1/256-7*sqrt(13)*S3/128+5*sqrt(65)*S5/128-7*sqrt(221)*S7/256+sqrt(12597)*S9/256",
            "sqrt(330)*z*(7*I*x**9+384*x**8*y-336*I*x**7*y**2+28*I*x**7*z**2-1792*x**6*y**3-1792*x**6*y*z**2+1680*I*x**5*y**4-1008*I*x**5*y**2*z**2+42*I*x**5*z**4+1680*x**4*y**5+3360*x**4*y**3*z**2+1680*x**4*y*z**4-1792*I*x**3*y**6+3360*I*x**3*y**4*z**2-1008*I*x**3*y**2*z**4+28*I*x**3*z**6-336*x**2*y**7-1008*x**2*y**5*z**2-1008*x**2*y**3*z**4-336*x**2*y*z**6+384*I*x*y**8-1792*I*x*y**6*z**2+1680*I*x*y**4*z**4-336*I*x*y**2*z**6+7*I*x*z**8+7*y**9+28*y**7*z**2+42*y**5*z**4+28*y**3*z**6+7*y*z**8)/256",
            "[0,0,0,-7*sqrt(442)*I/256,0,0,0,-7*sqrt(26)*I/128,0,0,0,7*sqrt(3)*I/128,0,0,0,5*sqrt(130)*I/128,0,0,0,sqrt(25194)*I/256,0]",
        ),
        "Qh(11,A,1,)": (
            "S8",
            "-sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(11,A,2,)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A,3,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A,4,)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(11,A,5,)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,B,1,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Qh(11,B,2,)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "-sqrt(230945)*x*y*z*(x**8-6*x**6*y**2-6*x**6*z**2+42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2-84*x**2*y**2*z**4+12*x**2*z**6+y**8-6*y**6*z**2+12*y**2*z**6-2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Qh(11,B,3,)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "-sqrt(3003)*x*y*z*(5*x**8-150*x**6*y**2+90*x**6*z**2+336*x**4*y**4-70*x**4*y**2*z**2-168*x**4*z**4-150*x**2*y**6-70*x**2*y**4*z**2+140*x**2*y**2*z**4+60*x**2*z**6+5*y**8+90*y**6*z**2-168*y**4*z**4+60*y**2*z**6-10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Qh(11,B,4,)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(11,B,5,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,B,6,)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Ea,1,)": (
            "-21*sqrt(33)*C1/512+sqrt(176358)*C11/1024+sqrt(15015)*C3/512-15*sqrt(286)*C5/1024+sqrt(72930)*C7/1024-sqrt(92378)*C9/1024-21*sqrt(33)*I*S1/512-sqrt(176358)*I*S11/1024-sqrt(15015)*I*S3/512-15*sqrt(286)*I*S5/1024-sqrt(72930)*I*S7/1024-sqrt(92378)*I*S9/1024",
            "sqrt(2)*(256*x**11-693*I*x**10*y-7040*x**9*y**2-7040*x**9*z**2+11550*I*x**8*y**3-3465*I*x**8*y*z**2+31680*x**7*y**4+63360*x**7*y**2*z**2+31680*x**7*z**4-36960*I*x**6*y**5+46200*I*x**6*y**3*z**2-6930*I*x**6*y*z**4-36960*x**5*y**6-110880*x**5*y**4*z**2-110880*x**5*y**2*z**4-36960*x**5*z**6+31680*I*x**4*y**7-110880*I*x**4*y**5*z**2+69300*I*x**4*y**3*z**4-6930*I*x**4*y*z**6+11550*x**3*y**8+46200*x**3*y**6*z**2+69300*x**3*y**4*z**4+46200*x**3*y**2*z**6+11550*x**3*z**8-7040*I*x**2*y**9+63360*I*x**2*y**7*z**2-110880*I*x**2*y**5*z**4+46200*I*x**2*y**3*z**6-3465*I*x**2*y*z**8-693*x*y**10-3465*x*y**8*z**2-6930*x*y**6*z**4-6930*x*y**4*z**6-3465*x*y**2*z**8-693*x*z**10+256*I*y**11-7040*I*y**9*z**2+31680*I*y**7*z**4-36960*I*y**5*z**6+11550*I*y**3*z**8-693*I*y*z**10)/512",
            "[0,0,sqrt(46189)/512,0,0,0,15*sqrt(143)/512,0,0,0,21*sqrt(66)/512,0,0,0,sqrt(30030)/512,0,0,0,sqrt(36465)/512,0,0,0,sqrt(88179)/512]",
        ),
        "Qh(11,Ea,2,)": (
            "-sqrt(20995)*C1/512+sqrt(770)*C11/1024-3*sqrt(2261)*C3/512+3*sqrt(9690)*C5/1024+77*sqrt(38)*C7/1024+39*sqrt(30)*C9/1024-sqrt(20995)*I*S1/512-sqrt(770)*I*S11/1024+3*sqrt(2261)*I*S3/512+3*sqrt(9690)*I*S5/1024-77*sqrt(38)*I*S7/1024+39*sqrt(30)*I*S9/1024",
            "-sqrt(1385670)*(I*x**10*y-6*I*x**8*y**3-27*I*x**8*y*z**2+168*I*x**6*y**3*z**2+42*I*x**6*y*z**4-420*I*x**4*y**3*z**4+42*I*x**4*y*z**6-6*x**3*y**8+168*x**3*y**6*z**2-420*x**3*y**4*z**4+168*x**3*y**2*z**6-6*x**3*z**8+168*I*x**2*y**3*z**6-27*I*x**2*y*z**8+x*y**10-27*x*y**8*z**2+42*x*y**6*z**4+42*x*y**4*z**6-27*x*y**2*z**8+x*z**10-6*I*y**3*z**8+I*y*z**10)/512",
            "[0,0,-39*sqrt(15)/512,0,0,0,-3*sqrt(4845)/512,0,0,0,sqrt(41990)/512,0,0,0,-3*sqrt(4522)/512,0,0,0,77*sqrt(19)/512,0,0,0,sqrt(385)/512]",
        ),
        "Qh(11,Ea,3,)": (
            "-5*sqrt(273)*C1/256+sqrt(21318)*C11/512+11*sqrt(15)*C3/256+13*sqrt(14)*C5/512-3*sqrt(3570)*C7/512+3*sqrt(4522)*C9/512-5*sqrt(273)*I*S1/256-sqrt(21318)*I*S11/512-11*sqrt(15)*I*S3/256+13*sqrt(14)*I*S5/512+3*sqrt(3570)*I*S7/512+3*sqrt(4522)*I*S9/512",
            "-3*sqrt(2002)*(5*I*x**10*y-70*I*x**8*y**3-15*I*x**8*y*z**2-80*x**7*y**4+480*x**7*y**2*z**2-80*x**7*z**4+168*I*x**6*y**5+280*I*x**6*y**3*z**2-70*I*x**6*y*z**4+168*x**5*y**6-840*x**5*y**4*z**2-840*x**5*y**2*z**4+168*x**5*z**6-80*I*x**4*y**7-840*I*x**4*y**5*z**2+700*I*x**4*y**3*z**4-70*I*x**4*y*z**6-70*x**3*y**8+280*x**3*y**6*z**2+700*x**3*y**4*z**4+280*x**3*y**2*z**6-70*x**3*z**8+480*I*x**2*y**7*z**2-840*I*x**2*y**5*z**4+280*I*x**2*y**3*z**6-15*I*x**2*y*z**8+5*x*y**10-15*x*y**8*z**2-70*x*y**6*z**4-70*x*y**4*z**6-15*x*y**2*z**8+5*x*z**10-80*I*y**7*z**4+168*I*y**5*z**6-70*I*y**3*z**8+5*I*y*z**10)/256",
            "[0,0,-3*sqrt(2261)/256,0,0,0,-13*sqrt(7)/256,0,0,0,5*sqrt(546)/256,0,0,0,11*sqrt(30)/256,0,0,0,-3*sqrt(1785)/256,0,0,0,sqrt(10659)/256]",
        ),
        "Qh(11,Ea,4,)": (
            "-sqrt(58786)*C1/1024-sqrt(11)*C11/1024-9*sqrt(3230)*C3/1024-5*sqrt(6783)*C5/1024-7*sqrt(665)*C7/1024-9*sqrt(21)*C9/1024-sqrt(58786)*I*S1/1024+sqrt(11)*I*S11/1024+9*sqrt(3230)*I*S3/1024-5*sqrt(6783)*I*S5/1024+7*sqrt(665)*I*S7/1024-9*sqrt(21)*I*S9/1024",
            "sqrt(969969)*(I*x**10*y-45*I*x**8*y*z**2+210*I*x**6*y*z**4-210*I*x**4*y*z**6+45*I*x**2*y*z**8+x*y**10-45*x*y**8*z**2+210*x*y**6*z**4-210*x*y**4*z**6+45*x*y**2*z**8-x*z**10-I*y*z**10)/512",
            "[0,0,9*sqrt(42)/1024,0,0,0,5*sqrt(13566)/1024,0,0,0,sqrt(29393)/512,0,0,0,-9*sqrt(1615)/512,0,0,0,-7*sqrt(1330)/1024,0,0,0,-sqrt(22)/1024]",
        ),
        "Qh(11,Ea,5,)": (
            "-15*sqrt(442)*C1/1024-3*sqrt(1463)*C11/1024-sqrt(1190)*C3/1024+53*sqrt(51)*C5/1024-105*sqrt(5)*C7/1024-61*sqrt(57)*C9/1024-15*sqrt(442)*I*S1/1024+3*sqrt(1463)*I*S11/1024+sqrt(1190)*I*S3/1024+53*sqrt(51)*I*S5/1024+105*sqrt(5)*I*S7/1024-61*sqrt(57)*I*S9/1024",
            "sqrt(7293)*(15*I*x**10*y-160*I*x**8*y**3-195*I*x**8*y*z**2+224*I*x**6*y**5+2240*I*x**6*y**3*z**2-210*I*x**6*y*z**4+224*x**5*y**6-3360*x**5*y**4*z**2+3360*x**5*y**2*z**4-224*x**5*z**6-3360*I*x**4*y**5*z**2+210*I*x**4*y*z**6-160*x**3*y**8+2240*x**3*y**6*z**2-2240*x**3*y**2*z**6+160*x**3*z**8+3360*I*x**2*y**5*z**4-2240*I*x**2*y**3*z**6+195*I*x**2*y*z**8+15*x*y**10-195*x*y**8*z**2-210*x*y**6*z**4+210*x*y**4*z**6+195*x*y**2*z**8-15*x*z**10-224*I*y**5*z**6+160*I*y**3*z**8-15*I*y*z**10)/512",
            "[0,0,61*sqrt(114)/1024,0,0,0,-53*sqrt(102)/1024,0,0,0,15*sqrt(221)/512,0,0,0,-sqrt(595)/512,0,0,0,-105*sqrt(10)/1024,0,0,0,-3*sqrt(2926)/1024]",
        ),
        "Qh(11,Ea,6,)": (
            "-21*sqrt(65)*C1/512-sqrt(248710)*C11/1024+57*sqrt(7)*C3/512-41*sqrt(30)*C5/1024+17*sqrt(34)*C7/1024+sqrt(9690)*C9/1024-21*sqrt(65)*I*S1/512+sqrt(248710)*I*S11/1024-57*sqrt(7)*I*S3/512-41*sqrt(30)*I*S5/1024-17*sqrt(34)*I*S7/1024+sqrt(9690)*I*S9/1024",
            "sqrt(4290)*(21*I*x**10*y+128*x**9*y**2-128*x**9*z**2-336*I*x**8*y**3+63*I*x**8*y*z**2-768*x**7*y**4+768*x**7*z**4+1008*I*x**6*y**5-672*I*x**6*y**3*z**2+42*I*x**6*y*z**4+1008*x**5*y**6+1008*x**5*y**4*z**2-1008*x**5*y**2*z**4-1008*x**5*z**6-768*I*x**4*y**7+1008*I*x**4*y**5*z**2-42*I*x**4*y*z**6-336*x**3*y**8-672*x**3*y**6*z**2+672*x**3*y**2*z**6+336*x**3*z**8+128*I*x**2*y**9-1008*I*x**2*y**5*z**4+672*I*x**2*y**3*z**6-63*I*x**2*y*z**8+21*x*y**10+63*x*y**8*z**2+42*x*y**6*z**4-42*x*y**4*z**6-63*x*y**2*z**8-21*x*z**10-128*I*y**9*z**2+768*I*y**7*z**4-1008*I*y**5*z**6+336*I*y**3*z**8-21*I*y*z**10)/512",
            "[0,0,-sqrt(4845)/512,0,0,0,41*sqrt(15)/512,0,0,0,21*sqrt(130)/512,0,0,0,57*sqrt(14)/512,0,0,0,17*sqrt(17)/512,0,0,0,-sqrt(124355)/512]",
        ),
        "Qh(11,Eb,1,)": (
            "-21*sqrt(33)*C1/512+sqrt(176358)*C11/1024+sqrt(15015)*C3/512-15*sqrt(286)*C5/1024+sqrt(72930)*C7/1024-sqrt(92378)*C9/1024+21*sqrt(33)*I*S1/512+sqrt(176358)*I*S11/1024+sqrt(15015)*I*S3/512+15*sqrt(286)*I*S5/1024+sqrt(72930)*I*S7/1024+sqrt(92378)*I*S9/1024",
            "sqrt(2)*(256*x**11+693*I*x**10*y-7040*x**9*y**2-7040*x**9*z**2-11550*I*x**8*y**3+3465*I*x**8*y*z**2+31680*x**7*y**4+63360*x**7*y**2*z**2+31680*x**7*z**4+36960*I*x**6*y**5-46200*I*x**6*y**3*z**2+6930*I*x**6*y*z**4-36960*x**5*y**6-110880*x**5*y**4*z**2-110880*x**5*y**2*z**4-36960*x**5*z**6-31680*I*x**4*y**7+110880*I*x**4*y**5*z**2-69300*I*x**4*y**3*z**4+6930*I*x**4*y*z**6+11550*x**3*y**8+46200*x**3*y**6*z**2+69300*x**3*y**4*z**4+46200*x**3*y**2*z**6+11550*x**3*z**8+7040*I*x**2*y**9-63360*I*x**2*y**7*z**2+110880*I*x**2*y**5*z**4-46200*I*x**2*y**3*z**6+3465*I*x**2*y*z**8-693*x*y**10-3465*x*y**8*z**2-6930*x*y**6*z**4-6930*x*y**4*z**6-3465*x*y**2*z**8-693*x*z**10-256*I*y**11+7040*I*y**9*z**2-31680*I*y**7*z**4+36960*I*y**5*z**6-11550*I*y**3*z**8+693*I*y*z**10)/512",
            "[-sqrt(88179)/512,0,0,0,-sqrt(36465)/512,0,0,0,-sqrt(30030)/512,0,0,0,-21*sqrt(66)/512,0,0,0,-15*sqrt(143)/512,0,0,0,-sqrt(46189)/512,0,0]",
        ),
        "Qh(11,Eb,2,)": (
            "-sqrt(20995)*C1/512+sqrt(770)*C11/1024-3*sqrt(2261)*C3/512+3*sqrt(9690)*C5/1024+77*sqrt(38)*C7/1024+39*sqrt(30)*C9/1024+sqrt(20995)*I*S1/512+sqrt(770)*I*S11/1024-3*sqrt(2261)*I*S3/512-3*sqrt(9690)*I*S5/1024+77*sqrt(38)*I*S7/1024-39*sqrt(30)*I*S9/1024",
            "sqrt(1385670)*(I*x**10*y-6*I*x**8*y**3-27*I*x**8*y*z**2+168*I*x**6*y**3*z**2+42*I*x**6*y*z**4-420*I*x**4*y**3*z**4+42*I*x**4*y*z**6+6*x**3*y**8-168*x**3*y**6*z**2+420*x**3*y**4*z**4-168*x**3*y**2*z**6+6*x**3*z**8+168*I*x**2*y**3*z**6-27*I*x**2*y*z**8-x*y**10+27*x*y**8*z**2-42*x*y**6*z**4-42*x*y**4*z**6+27*x*y**2*z**8-x*z**10-6*I*y**3*z**8+I*y*z**10)/512",
            "[-sqrt(385)/512,0,0,0,-77*sqrt(19)/512,0,0,0,3*sqrt(4522)/512,0,0,0,-sqrt(41990)/512,0,0,0,3*sqrt(4845)/512,0,0,0,39*sqrt(15)/512,0,0]",
        ),
        "Qh(11,Eb,3,)": (
            "-5*sqrt(273)*C1/256+sqrt(21318)*C11/512+11*sqrt(15)*C3/256+13*sqrt(14)*C5/512-3*sqrt(3570)*C7/512+3*sqrt(4522)*C9/512+5*sqrt(273)*I*S1/256+sqrt(21318)*I*S11/512+11*sqrt(15)*I*S3/256-13*sqrt(14)*I*S5/512-3*sqrt(3570)*I*S7/512-3*sqrt(4522)*I*S9/512",
            "3*sqrt(2002)*(5*I*x**10*y-70*I*x**8*y**3-15*I*x**8*y*z**2+80*x**7*y**4-480*x**7*y**2*z**2+80*x**7*z**4+168*I*x**6*y**5+280*I*x**6*y**3*z**2-70*I*x**6*y*z**4-168*x**5*y**6+840*x**5*y**4*z**2+840*x**5*y**2*z**4-168*x**5*z**6-80*I*x**4*y**7-840*I*x**4*y**5*z**2+700*I*x**4*y**3*z**4-70*I*x**4*y*z**6+70*x**3*y**8-280*x**3*y**6*z**2-700*x**3*y**4*z**4-280*x**3*y**2*z**6+70*x**3*z**8+480*I*x**2*y**7*z**2-840*I*x**2*y**5*z**4+280*I*x**2*y**3*z**6-15*I*x**2*y*z**8-5*x*y**10+15*x*y**8*z**2+70*x*y**6*z**4+70*x*y**4*z**6+15*x*y**2*z**8-5*x*z**10-80*I*y**7*z**4+168*I*y**5*z**6-70*I*y**3*z**8+5*I*y*z**10)/256",
            "[-sqrt(10659)/256,0,0,0,3*sqrt(1785)/256,0,0,0,-11*sqrt(30)/256,0,0,0,-5*sqrt(546)/256,0,0,0,13*sqrt(7)/256,0,0,0,3*sqrt(2261)/256,0,0]",
        ),
        "Qh(11,Eb,4,)": (
            "-sqrt(58786)*C1/1024-sqrt(11)*C11/1024-9*sqrt(3230)*C3/1024-5*sqrt(6783)*C5/1024-7*sqrt(665)*C7/1024-9*sqrt(21)*C9/1024+sqrt(58786)*I*S1/1024-sqrt(11)*I*S11/1024-9*sqrt(3230)*I*S3/1024+5*sqrt(6783)*I*S5/1024-7*sqrt(665)*I*S7/1024+9*sqrt(21)*I*S9/1024",
            "-sqrt(969969)*(I*x**10*y-45*I*x**8*y*z**2+210*I*x**6*y*z**4-210*I*x**4*y*z**6+45*I*x**2*y*z**8-x*y**10+45*x*y**8*z**2-210*x*y**6*z**4+210*x*y**4*z**6-45*x*y**2*z**8+x*z**10-I*y*z**10)/512",
            "[sqrt(22)/1024,0,0,0,7*sqrt(1330)/1024,0,0,0,9*sqrt(1615)/512,0,0,0,-sqrt(29393)/512,0,0,0,-5*sqrt(13566)/1024,0,0,0,-9*sqrt(42)/1024,0,0]",
        ),
        "Qh(11,Eb,5,)": (
            "-15*sqrt(442)*C1/1024-3*sqrt(1463)*C11/1024-sqrt(1190)*C3/1024+53*sqrt(51)*C5/1024-105*sqrt(5)*C7/1024-61*sqrt(57)*C9/1024+15*sqrt(442)*I*S1/1024-3*sqrt(1463)*I*S11/1024-sqrt(1190)*I*S3/1024-53*sqrt(51)*I*S5/1024-105*sqrt(5)*I*S7/1024+61*sqrt(57)*I*S9/1024",
            "-sqrt(7293)*(15*I*x**10*y-160*I*x**8*y**3-195*I*x**8*y*z**2+224*I*x**6*y**5+2240*I*x**6*y**3*z**2-210*I*x**6*y*z**4-224*x**5*y**6+3360*x**5*y**4*z**2-3360*x**5*y**2*z**4+224*x**5*z**6-3360*I*x**4*y**5*z**2+210*I*x**4*y*z**6+160*x**3*y**8-2240*x**3*y**6*z**2+2240*x**3*y**2*z**6-160*x**3*z**8+3360*I*x**2*y**5*z**4-2240*I*x**2*y**3*z**6+195*I*x**2*y*z**8-15*x*y**10+195*x*y**8*z**2+210*x*y**6*z**4-210*x*y**4*z**6-195*x*y**2*z**8+15*x*z**10-224*I*y**5*z**6+160*I*y**3*z**8-15*I*y*z**10)/512",
            "[3*sqrt(2926)/1024,0,0,0,105*sqrt(10)/1024,0,0,0,sqrt(595)/512,0,0,0,-15*sqrt(221)/512,0,0,0,53*sqrt(102)/1024,0,0,0,-61*sqrt(114)/1024,0,0]",
        ),
        "Qh(11,Eb,6,)": (
            "-21*sqrt(65)*C1/512-sqrt(248710)*C11/1024+57*sqrt(7)*C3/512-41*sqrt(30)*C5/1024+17*sqrt(34)*C7/1024+sqrt(9690)*C9/1024+21*sqrt(65)*I*S1/512-sqrt(248710)*I*S11/1024+57*sqrt(7)*I*S3/512+41*sqrt(30)*I*S5/1024+17*sqrt(34)*I*S7/1024-sqrt(9690)*I*S9/1024",
            "-sqrt(4290)*(21*I*x**10*y-128*x**9*y**2+128*x**9*z**2-336*I*x**8*y**3+63*I*x**8*y*z**2+768*x**7*y**4-768*x**7*z**4+1008*I*x**6*y**5-672*I*x**6*y**3*z**2+42*I*x**6*y*z**4-1008*x**5*y**6-1008*x**5*y**4*z**2+1008*x**5*y**2*z**4+1008*x**5*z**6-768*I*x**4*y**7+1008*I*x**4*y**5*z**2-42*I*x**4*y*z**6+336*x**3*y**8+672*x**3*y**6*z**2-672*x**3*y**2*z**6-336*x**3*z**8+128*I*x**2*y**9-1008*I*x**2*y**5*z**4+672*I*x**2*y**3*z**6-63*I*x**2*y*z**8-21*x*y**10-63*x*y**8*z**2-42*x*y**6*z**4+42*x*y**4*z**6+63*x*y**2*z**8+21*x*z**10-128*I*y**9*z**2+768*I*y**7*z**4-1008*I*y**5*z**6+336*I*y**3*z**8-21*I*y*z**10)/512",
            "[sqrt(124355)/512,0,0,0,-17*sqrt(17)/512,0,0,0,-57*sqrt(14)/512,0,0,0,-21*sqrt(130)/512,0,0,0,-41*sqrt(15)/512,0,0,0,sqrt(4845)/512,0,0]",
        ),
    },
    "S4": {
        "Qh(0,A,,)": ("C0", "1", "[1]"),
        "Qh(1,B,,)": ("C0", "z", "[0,1,0]"),
        "Qh(1,Ea,,)": ("sqrt(2)*C1/2+sqrt(2)*I*S1/2", "sqrt(2)*(x+I*y)/2", "[-1,0,0]"),
        "Qh(1,Eb,,)": ("sqrt(2)*C1/2-sqrt(2)*I*S1/2", "sqrt(2)*(x-I*y)/2", "[0,0,1]"),
        "Qh(2,A,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(2,B,1,)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(2,B,2,)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Qh(2,Ea,,)": ("sqrt(2)*I*C1/2+sqrt(2)*S1/2", "sqrt(6)*z*(I*x+y)/2", "[0,0,0,I,0]"),
        "Qh(2,Eb,,)": ("-sqrt(2)*I*C1/2+sqrt(2)*S1/2", "-sqrt(6)*z*(I*x-y)/2", "[0,I,0,0,0]"),
        "Qh(3,A,1,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(3,A,2,)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(3,B,,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(3,Ea,1,)": (
            "-sqrt(3)*C1/4+sqrt(5)*C3/4-sqrt(3)*I*S1/4-sqrt(5)*I*S3/4",
            "sqrt(2)*(2*x**3-3*I*x**2*y-3*x*y**2-3*x*z**2+2*I*y**3-3*I*y*z**2)/4",
            "[0,0,sqrt(6)/4,0,0,0,sqrt(10)/4]",
        ),
        "Qh(3,Ea,2,)": (
            "-sqrt(5)*C1/4-sqrt(3)*C3/4-sqrt(5)*I*S1/4+sqrt(3)*I*S3/4",
            "sqrt(30)*(I*x**2*y+x*y**2-x*z**2-I*y*z**2)/4",
            "[0,0,sqrt(10)/4,0,0,0,-sqrt(6)/4]",
        ),
        "Qh(3,Eb,1,)": (
            "-sqrt(3)*C1/4+sqrt(5)*C3/4+sqrt(3)*I*S1/4+sqrt(5)*I*S3/4",
            "sqrt(2)*(2*x**3+3*I*x**2*y-3*x*y**2-3*x*z**2-2*I*y**3+3*I*y*z**2)/4",
            "[-sqrt(10)/4,0,0,0,-sqrt(6)/4,0,0]",
        ),
        "Qh(3,Eb,2,)": (
            "-sqrt(5)*C1/4-sqrt(3)*C3/4+sqrt(5)*I*S1/4-sqrt(3)*I*S3/4",
            "-sqrt(30)*(I*x**2*y-x*y**2+x*z**2-I*y*z**2)/4",
            "[sqrt(6)/4,0,0,0,-sqrt(10)/4,0,0]",
        ),
        "Qh(4,A,1,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Qh(4,A,2,)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "-sqrt(15)*(x**4-12*x**2*y**2+6*x**2*z**2+y**4+6*y**2*z**2-2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Qh(4,A,3,)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(4,B,1,)": ("-C2", "sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Qh(4,B,2,)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(4,Ea,1,)": (
            "-sqrt(7)*I*C1/4+I*C3/4-sqrt(7)*S1/4-S3/4",
            "sqrt(70)*z*(I*x**3-I*x*z**2+y**3-y*z**2)/4",
            "[0,-sqrt(2)*I/4,0,0,0,-sqrt(14)*I/4,0,0,0]",
        ),
        "Qh(4,Ea,2,)": (
            "-I*C1/4-sqrt(7)*I*C3/4-S1/4+sqrt(7)*S3/4",
            "-sqrt(10)*z*(I*x**3-6*x**2*y-6*I*x*y**2+I*x*z**2+y**3+y*z**2)/4",
            "[0,sqrt(14)*I/4,0,0,0,-sqrt(2)*I/4,0,0,0]",
        ),
        "Qh(4,Eb,1,)": (
            "sqrt(7)*I*C1/4-I*C3/4-sqrt(7)*S1/4-S3/4",
            "-sqrt(70)*z*(I*x**3-I*x*z**2-y**3+y*z**2)/4",
            "[0,0,0,-sqrt(14)*I/4,0,0,0,-sqrt(2)*I/4,0]",
        ),
        "Qh(4,Eb,2,)": (
            "I*C1/4+sqrt(7)*I*C3/4-S1/4+sqrt(7)*S3/4",
            "sqrt(10)*z*(I*x**3+6*x**2*y-6*I*x*y**2+I*x*z**2-y**3-y*z**2)/4",
            "[0,0,0,-sqrt(2)*I/4,0,0,0,sqrt(14)*I/4,0]",
        ),
        "Qh(5,A,1,)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(5,A,2,)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(5,B,1,)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(5,B,2,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(5,B,3,)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(5,Ea,1,)": (
            "sqrt(30)*C1/16-sqrt(35)*C3/16+3*sqrt(7)*C5/16+sqrt(30)*I*S1/16+sqrt(35)*I*S3/16+3*sqrt(7)*I*S5/16",
            "sqrt(2)*(8*x**5+15*I*x**4*y-40*x**3*y**2-40*x**3*z**2-40*I*x**2*y**3+30*I*x**2*y*z**2+15*x*y**4+30*x*y**2*z**2+15*x*z**4+8*I*y**5-40*I*y**3*z**2+15*I*y*z**4)/16",
            "[-3*sqrt(14)/16,0,0,0,-sqrt(15)/8,0,0,0,-sqrt(70)/16,0,0]",
        ),
        "Qh(5,Ea,2,)": (
            "sqrt(42)*C1/16+9*C3/16+sqrt(5)*C5/16+sqrt(42)*I*S1/16-9*I*S3/16+sqrt(5)*I*S5/16",
            "3*sqrt(70)*(I*x**4*y-6*I*x**2*y*z**2+x*y**4-6*x*y**2*z**2+x*z**4+I*y*z**4)/16",
            "[-sqrt(10)/16,0,0,0,-sqrt(21)/8,0,0,0,9*sqrt(2)/16,0,0]",
        ),
        "Qh(5,Ea,3,)": (
            "sqrt(14)*C1/8-sqrt(3)*C3/8-sqrt(15)*C5/8+sqrt(14)*I*S1/8+sqrt(3)*I*S3/8-sqrt(15)*I*S5/8",
            "-sqrt(210)*(I*x**4*y-2*x**3*y**2+2*x**3*z**2-2*I*x**2*y**3+x*y**4-x*z**4+2*I*y**3*z**2-I*y*z**4)/8",
            "[sqrt(30)/8,0,0,0,-sqrt(7)/4,0,0,0,-sqrt(6)/8,0,0]",
        ),
        "Qh(5,Eb,1,)": (
            "sqrt(30)*C1/16-sqrt(35)*C3/16+3*sqrt(7)*C5/16-sqrt(30)*I*S1/16-sqrt(35)*I*S3/16-3*sqrt(7)*I*S5/16",
            "sqrt(2)*(8*x**5-15*I*x**4*y-40*x**3*y**2-40*x**3*z**2+40*I*x**2*y**3-30*I*x**2*y*z**2+15*x*y**4+30*x*y**2*z**2+15*x*z**4-8*I*y**5+40*I*y**3*z**2-15*I*y*z**4)/16",
            "[0,0,sqrt(70)/16,0,0,0,sqrt(15)/8,0,0,0,3*sqrt(14)/16]",
        ),
        "Qh(5,Eb,2,)": (
            "sqrt(42)*C1/16+9*C3/16+sqrt(5)*C5/16-sqrt(42)*I*S1/16+9*I*S3/16-sqrt(5)*I*S5/16",
            "-3*sqrt(70)*(I*x**4*y-6*I*x**2*y*z**2-x*y**4+6*x*y**2*z**2-x*z**4+I*y*z**4)/16",
            "[0,0,-9*sqrt(2)/16,0,0,0,sqrt(21)/8,0,0,0,sqrt(10)/16]",
        ),
        "Qh(5,Eb,3,)": (
            "sqrt(14)*C1/8-sqrt(3)*C3/8-sqrt(15)*C5/8-sqrt(14)*I*S1/8-sqrt(3)*I*S3/8+sqrt(15)*I*S5/8",
            "sqrt(210)*(I*x**4*y+2*x**3*y**2-2*x**3*z**2-2*I*x**2*y**3-x*y**4+x*z**4+2*I*y**3*z**2-I*y*z**4)/8",
            "[0,0,sqrt(6)/8,0,0,0,sqrt(7)/4,0,0,0,-sqrt(30)/8]",
        ),
        "Qh(6,A,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Qh(6,A,2,)": (
            "sqrt(14)*C0/4+sqrt(2)*C4/4",
            "-sqrt(14)*(x**6-15*x**4*z**2+15*x**2*z**4+y**6-15*y**4*z**2+15*y**2*z**4-2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Qh(6,A,3,)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(6,B,1,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Qh(6,B,2,)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x-y)*(x+y)*(x**4-9*x**2*y**2-5*x**2*z**2+y**4-5*y**2*z**2+5*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Qh(6,B,3,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(6,B,4,)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(6,Ea,1,)": (
            "sqrt(6)*I*C1/8+sqrt(15)*I*C3/8-sqrt(11)*I*C5/8+sqrt(6)*S1/8-sqrt(15)*S3/8-sqrt(11)*S5/8",
            "-3*sqrt(14)*z*(I*x**5-10*I*x**3*y**2-10*x**2*y**3+10*x**2*y*z**2+10*I*x*y**2*z**2-I*x*z**4+y**5-y*z**4)/8",
            "[0,0,0,-sqrt(30)*I/8,0,0,0,sqrt(3)*I/4,0,0,0,-sqrt(22)*I/8,0]",
        ),
        "Qh(6,Ea,2,)": (
            "3*sqrt(11)*I*C1/16-sqrt(110)*I*C3/32+sqrt(6)*I*C5/32+3*sqrt(11)*S1/16+sqrt(110)*S3/32+sqrt(6)*S5/32",
            "sqrt(231)*z*(3*I*x**5-10*I*x**3*z**2+3*I*x*z**4+3*y**5-10*y**3*z**2+3*y*z**4)/16",
            "[0,0,0,sqrt(55)*I/16,0,0,0,3*sqrt(22)*I/16,0,0,0,sqrt(3)*I/16,0]",
        ),
        "Qh(6,Ea,3,)": (
            "sqrt(5)*I*C1/16+9*sqrt(2)*I*C3/32+sqrt(330)*I*C5/32+sqrt(5)*S1/16-9*sqrt(2)*S3/32+sqrt(330)*S5/32",
            "sqrt(105)*z*(I*x**5+16*x**4*y-16*I*x**3*y**2+2*I*x**3*z**2-16*x**2*y**3-16*x**2*y*z**2+16*I*x*y**4-16*I*x*y**2*z**2+I*x*z**4+y**5+2*y**3*z**2+y*z**4)/16",
            "[0,0,0,-9*I/16,0,0,0,sqrt(10)*I/16,0,0,0,sqrt(165)*I/16,0]",
        ),
        "Qh(6,Eb,1,)": (
            "-sqrt(6)*I*C1/8-sqrt(15)*I*C3/8+sqrt(11)*I*C5/8+sqrt(6)*S1/8-sqrt(15)*S3/8-sqrt(11)*S5/8",
            "3*sqrt(14)*z*(I*x**5-10*I*x**3*y**2+10*x**2*y**3-10*x**2*y*z**2+10*I*x*y**2*z**2-I*x*z**4-y**5+y*z**4)/8",
            "[0,-sqrt(22)*I/8,0,0,0,sqrt(3)*I/4,0,0,0,-sqrt(30)*I/8,0,0,0]",
        ),
        "Qh(6,Eb,2,)": (
            "-3*sqrt(11)*I*C1/16+sqrt(110)*I*C3/32-sqrt(6)*I*C5/32+3*sqrt(11)*S1/16+sqrt(110)*S3/32+sqrt(6)*S5/32",
            "-sqrt(231)*z*(3*I*x**5-10*I*x**3*z**2+3*I*x*z**4-3*y**5+10*y**3*z**2-3*y*z**4)/16",
            "[0,sqrt(3)*I/16,0,0,0,3*sqrt(22)*I/16,0,0,0,sqrt(55)*I/16,0,0,0]",
        ),
        "Qh(6,Eb,3,)": (
            "-sqrt(5)*I*C1/16-9*sqrt(2)*I*C3/32-sqrt(330)*I*C5/32+sqrt(5)*S1/16-9*sqrt(2)*S3/32+sqrt(330)*S5/32",
            "-sqrt(105)*z*(I*x**5-16*x**4*y-16*I*x**3*y**2+2*I*x**3*z**2+16*x**2*y**3+16*x**2*y*z**2+16*I*x*y**4-16*I*x*y**2*z**2+I*x*z**4-y**5-2*y**3*z**2-y*z**4)/16",
            "[0,sqrt(165)*I/16,0,0,0,sqrt(10)*I/16,0,0,0,-9*I/16,0,0,0]",
        ),
        "Qh(7,A,1,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Qh(7,A,2,)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "-sqrt(77)*x*y*z*(3*x**4-20*x**2*y**2+10*x**2*z**2+3*y**4+10*y**2*z**2-6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Qh(7,A,3,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(7,A,4,)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(7,B,1,)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(7,B,2,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(7,B,3,)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(7,Ea,1,)": (
            "-5*sqrt(14)*C1/64+3*sqrt(42)*C3/64-sqrt(462)*C5/64+sqrt(858)*C7/64-5*sqrt(14)*I*S1/64-3*sqrt(42)*I*S3/64-sqrt(462)*I*S5/64-sqrt(858)*I*S7/64",
            "sqrt(2)*(16*x**7-35*I*x**6*y-168*x**5*y**2-168*x**5*z**2+210*I*x**4*y**3-105*I*x**4*y*z**2+210*x**3*y**4+420*x**3*y**2*z**2+210*x**3*z**4-168*I*x**2*y**5+420*I*x**2*y**3*z**2-105*I*x**2*y*z**4-35*x*y**6-105*x*y**4*z**2-105*x*y**2*z**4-35*x*z**6+16*I*y**7-168*I*y**5*z**2+210*I*y**3*z**4-35*I*y*z**6)/32",
            "[0,0,sqrt(231)/32,0,0,0,5*sqrt(7)/32,0,0,0,3*sqrt(21)/32,0,0,0,sqrt(429)/32]",
        ),
        "Qh(7,Ea,2,)": (
            "-3*sqrt(66)*C1/64-sqrt(22)*C3/64+25*sqrt(2)*C5/64+sqrt(182)*C7/64-3*sqrt(66)*I*S1/64+sqrt(22)*I*S3/64+25*sqrt(2)*I*S5/64-sqrt(182)*I*S7/64",
            "-sqrt(462)*(3*I*x**6*y-10*I*x**4*y**3-15*I*x**4*y*z**2-10*x**3*y**4+60*x**3*y**2*z**2-10*x**3*z**4+60*I*x**2*y**3*z**2-15*I*x**2*y*z**4+3*x*y**6-15*x*y**4*z**2-15*x*y**2*z**4+3*x*z**6-10*I*y**3*z**4+3*I*y*z**6)/32",
            "[0,0,-25/32,0,0,0,3*sqrt(33)/32,0,0,0,-sqrt(11)/32,0,0,0,sqrt(91)/32]",
        ),
        "Qh(7,Ea,3,)": (
            "-sqrt(429)*C1/64-3*sqrt(143)*C3/64-5*sqrt(13)*C5/64-sqrt(7)*C7/64-sqrt(429)*I*S1/64+3*sqrt(143)*I*S3/64-5*sqrt(13)*I*S5/64+sqrt(7)*I*S7/64",
            "sqrt(3003)*(I*x**6*y-15*I*x**4*y*z**2+15*I*x**2*y*z**4+x*y**6-15*x*y**4*z**2+15*x*y**2*z**4-x*z**6-I*y*z**6)/32",
            "[0,0,5*sqrt(26)/64,0,0,0,sqrt(858)/64,0,0,0,-3*sqrt(286)/64,0,0,0,-sqrt(14)/64]",
        ),
        "Qh(7,Ea,4,)": (
            "-15*sqrt(3)*C1/64+19*C3/64-sqrt(11)*C5/64-sqrt(1001)*C7/64-15*sqrt(3)*I*S1/64-19*I*S3/64-sqrt(11)*I*S5/64+sqrt(1001)*I*S7/64",
            "sqrt(21)*(15*I*x**6*y+48*x**5*y**2-48*x**5*z**2-80*I*x**4*y**3+15*I*x**4*y*z**2-80*x**3*y**4+80*x**3*z**4+48*I*x**2*y**5-15*I*x**2*y*z**4+15*x*y**6+15*x*y**4*z**2-15*x*y**2*z**4-15*x*z**6-48*I*y**5*z**2+80*I*y**3*z**4-15*I*y*z**6)/32",
            "[0,0,sqrt(22)/64,0,0,0,15*sqrt(6)/64,0,0,0,19*sqrt(2)/64,0,0,0,-sqrt(2002)/64]",
        ),
        "Qh(7,Eb,1,)": (
            "-5*sqrt(14)*C1/64+3*sqrt(42)*C3/64-sqrt(462)*C5/64+sqrt(858)*C7/64+5*sqrt(14)*I*S1/64+3*sqrt(42)*I*S3/64+sqrt(462)*I*S5/64+sqrt(858)*I*S7/64",
            "sqrt(2)*(16*x**7+35*I*x**6*y-168*x**5*y**2-168*x**5*z**2-210*I*x**4*y**3+105*I*x**4*y*z**2+210*x**3*y**4+420*x**3*y**2*z**2+210*x**3*z**4+168*I*x**2*y**5-420*I*x**2*y**3*z**2+105*I*x**2*y*z**4-35*x*y**6-105*x*y**4*z**2-105*x*y**2*z**4-35*x*z**6-16*I*y**7+168*I*y**5*z**2-210*I*y**3*z**4+35*I*y*z**6)/32",
            "[-sqrt(429)/32,0,0,0,-3*sqrt(21)/32,0,0,0,-5*sqrt(7)/32,0,0,0,-sqrt(231)/32,0,0]",
        ),
        "Qh(7,Eb,2,)": (
            "-3*sqrt(66)*C1/64-sqrt(22)*C3/64+25*sqrt(2)*C5/64+sqrt(182)*C7/64+3*sqrt(66)*I*S1/64-sqrt(22)*I*S3/64-25*sqrt(2)*I*S5/64+sqrt(182)*I*S7/64",
            "sqrt(462)*(3*I*x**6*y-10*I*x**4*y**3-15*I*x**4*y*z**2+10*x**3*y**4-60*x**3*y**2*z**2+10*x**3*z**4+60*I*x**2*y**3*z**2-15*I*x**2*y*z**4-3*x*y**6+15*x*y**4*z**2+15*x*y**2*z**4-3*x*z**6-10*I*y**3*z**4+3*I*y*z**6)/32",
            "[-sqrt(91)/32,0,0,0,sqrt(11)/32,0,0,0,-3*sqrt(33)/32,0,0,0,25/32,0,0]",
        ),
        "Qh(7,Eb,3,)": (
            "-sqrt(429)*C1/64-3*sqrt(143)*C3/64-5*sqrt(13)*C5/64-sqrt(7)*C7/64+sqrt(429)*I*S1/64-3*sqrt(143)*I*S3/64+5*sqrt(13)*I*S5/64-sqrt(7)*I*S7/64",
            "-sqrt(3003)*(I*x**6*y-15*I*x**4*y*z**2+15*I*x**2*y*z**4-x*y**6+15*x*y**4*z**2-15*x*y**2*z**4+x*z**6-I*y*z**6)/32",
            "[sqrt(14)/64,0,0,0,3*sqrt(286)/64,0,0,0,-sqrt(858)/64,0,0,0,-5*sqrt(26)/64,0,0]",
        ),
        "Qh(7,Eb,4,)": (
            "-15*sqrt(3)*C1/64+19*C3/64-sqrt(11)*C5/64-sqrt(1001)*C7/64+15*sqrt(3)*I*S1/64+19*I*S3/64+sqrt(11)*I*S5/64-sqrt(1001)*I*S7/64",
            "-sqrt(21)*(15*I*x**6*y-48*x**5*y**2+48*x**5*z**2-80*I*x**4*y**3+15*I*x**4*y*z**2+80*x**3*y**4-80*x**3*z**4+48*I*x**2*y**5-15*I*x**2*y*z**4-15*x*y**6-15*x*y**4*z**2+15*x*y**2*z**4+15*x*z**6-48*I*y**5*z**2+80*I*y**3*z**4-15*I*y*z**6)/32",
            "[sqrt(2002)/64,0,0,0,-19*sqrt(2)/64,0,0,0,-15*sqrt(6)/64,0,0,0,-sqrt(22)/64,0,0]",
        ),
        "Qh(8,A,1,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Qh(8,A,2,)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Qh(8,A,3,)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Qh(8,A,4,)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(8,A,5,)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(8,B,1,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(8,B,2,)": (
            "C2",
            "-3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(8,B,3,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(8,B,4,)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(8,Ea,1,)": (
            "-sqrt(1430)*I*C1/64+sqrt(546)*I*C3/64-sqrt(70)*I*C5/64+sqrt(2)*I*C7/64-sqrt(1430)*S1/64-sqrt(546)*S3/64-sqrt(70)*S5/64-sqrt(2)*S7/64",
            "3*sqrt(1430)*z*(I*x**7-7*I*x**5*z**2+7*I*x**3*z**4-I*x*z**6+y**7-7*y**5*z**2+7*y**3*z**4-y*z**6)/32",
            "[0,-I/32,0,0,0,-sqrt(273)*I/32,0,0,0,-sqrt(715)*I/32,0,0,0,-sqrt(35)*I/32,0,0,0]",
        ),
        "Qh(8,Ea,2,)": (
            "-sqrt(154)*I*C1/64-5*sqrt(30)*I*C3/64-3*sqrt(26)*I*C5/64+sqrt(910)*I*C7/64-sqrt(154)*S1/64+5*sqrt(30)*S3/64-3*sqrt(26)*S5/64-sqrt(910)*S7/64",
            "3*sqrt(154)*z*(I*x**7-24*I*x**5*y**2+I*x**5*z**2+40*x**4*y**3-40*x**4*y*z**2+40*I*x**3*y**4-I*x**3*z**4-24*x**2*y**5+24*x**2*y*z**4-40*I*x*y**4*z**2+24*I*x*y**2*z**4-I*x*z**6+y**7+y**5*z**2-y**3*z**4-y*z**6)/32",
            "[0,-sqrt(455)*I/32,0,0,0,5*sqrt(15)*I/32,0,0,0,-sqrt(77)*I/32,0,0,0,-3*sqrt(13)*I/32,0,0,0]",
        ),
        "Qh(8,Ea,3,)": (
            "-sqrt(429)*I*C1/64-sqrt(455)*I*C3/64+7*sqrt(21)*I*C5/64-3*sqrt(15)*I*C7/64-sqrt(429)*S1/64+sqrt(455)*S3/64+7*sqrt(21)*S5/64+3*sqrt(15)*S7/64",
            "-sqrt(429)*z*(3*I*x**7-42*I*x**5*y**2-7*I*x**5*z**2+140*I*x**3*y**2*z**2-7*I*x**3*z**4-42*x**2*y**5+140*x**2*y**3*z**2-42*x**2*y*z**4-42*I*x*y**2*z**4+3*I*x*z**6+3*y**7-7*y**5*z**2-7*y**3*z**4+3*y*z**6)/32",
            "[0,3*sqrt(30)*I/64,0,0,0,sqrt(910)*I/64,0,0,0,-sqrt(858)*I/64,0,0,0,7*sqrt(42)*I/64,0,0,0]",
        ),
        "Qh(8,Ea,4,)": (
            "-sqrt(35)*I*C1/64-3*sqrt(33)*I*C3/64-sqrt(715)*I*C5/64-sqrt(1001)*I*C7/64-sqrt(35)*S1/64+3*sqrt(33)*S3/64-sqrt(715)*S5/64+sqrt(1001)*S7/64",
            "-3*sqrt(35)*z*(I*x**7-32*x**6*y-30*I*x**5*y**2+3*I*x**5*z**2+80*x**4*y**3+80*x**4*y*z**2+80*I*x**3*y**4-60*I*x**3*y**2*z**2+3*I*x**3*z**4-30*x**2*y**5-60*x**2*y**3*z**2-30*x**2*y*z**4-32*I*x*y**6+80*I*x*y**4*z**2-30*I*x*y**2*z**4+I*x*z**6+y**7+3*y**5*z**2+3*y**3*z**4+y*z**6)/32",
            "[0,sqrt(2002)*I/64,0,0,0,3*sqrt(66)*I/64,0,0,0,-sqrt(70)*I/64,0,0,0,-sqrt(1430)*I/64,0,0,0]",
        ),
        "Qh(8,Eb,1,)": (
            "sqrt(1430)*I*C1/64-sqrt(546)*I*C3/64+sqrt(70)*I*C5/64-sqrt(2)*I*C7/64-sqrt(1430)*S1/64-sqrt(546)*S3/64-sqrt(70)*S5/64-sqrt(2)*S7/64",
            "-3*sqrt(1430)*z*(I*x**7-7*I*x**5*z**2+7*I*x**3*z**4-I*x*z**6-y**7+7*y**5*z**2-7*y**3*z**4+y*z**6)/32",
            "[0,0,0,-sqrt(35)*I/32,0,0,0,-sqrt(715)*I/32,0,0,0,-sqrt(273)*I/32,0,0,0,-I/32,0]",
        ),
        "Qh(8,Eb,2,)": (
            "sqrt(154)*I*C1/64+5*sqrt(30)*I*C3/64+3*sqrt(26)*I*C5/64-sqrt(910)*I*C7/64-sqrt(154)*S1/64+5*sqrt(30)*S3/64-3*sqrt(26)*S5/64-sqrt(910)*S7/64",
            "-3*sqrt(154)*z*(I*x**7-24*I*x**5*y**2+I*x**5*z**2-40*x**4*y**3+40*x**4*y*z**2+40*I*x**3*y**4-I*x**3*z**4+24*x**2*y**5-24*x**2*y*z**4-40*I*x*y**4*z**2+24*I*x*y**2*z**4-I*x*z**6-y**7-y**5*z**2+y**3*z**4+y*z**6)/32",
            "[0,0,0,-3*sqrt(13)*I/32,0,0,0,-sqrt(77)*I/32,0,0,0,5*sqrt(15)*I/32,0,0,0,-sqrt(455)*I/32,0]",
        ),
        "Qh(8,Eb,3,)": (
            "sqrt(429)*I*C1/64+sqrt(455)*I*C3/64-7*sqrt(21)*I*C5/64+3*sqrt(15)*I*C7/64-sqrt(429)*S1/64+sqrt(455)*S3/64+7*sqrt(21)*S5/64+3*sqrt(15)*S7/64",
            "sqrt(429)*z*(3*I*x**7-42*I*x**5*y**2-7*I*x**5*z**2+140*I*x**3*y**2*z**2-7*I*x**3*z**4+42*x**2*y**5-140*x**2*y**3*z**2+42*x**2*y*z**4-42*I*x*y**2*z**4+3*I*x*z**6-3*y**7+7*y**5*z**2+7*y**3*z**4-3*y*z**6)/32",
            "[0,0,0,7*sqrt(42)*I/64,0,0,0,-sqrt(858)*I/64,0,0,0,sqrt(910)*I/64,0,0,0,3*sqrt(30)*I/64,0]",
        ),
        "Qh(8,Eb,4,)": (
            "sqrt(35)*I*C1/64+3*sqrt(33)*I*C3/64+sqrt(715)*I*C5/64+sqrt(1001)*I*C7/64-sqrt(35)*S1/64+3*sqrt(33)*S3/64-sqrt(715)*S5/64+sqrt(1001)*S7/64",
            "3*sqrt(35)*z*(I*x**7+32*x**6*y-30*I*x**5*y**2+3*I*x**5*z**2-80*x**4*y**3-80*x**4*y*z**2+80*I*x**3*y**4-60*I*x**3*y**2*z**2+3*I*x**3*z**4+30*x**2*y**5+60*x**2*y**3*z**2+30*x**2*y*z**4-32*I*x*y**6+80*I*x*y**4*z**2-30*I*x*y**2*z**4+I*x*z**6-y**7-3*y**5*z**2-3*y**3*z**4-y*z**6)/32",
            "[0,0,0,-sqrt(1430)*I/64,0,0,0,-sqrt(70)*I/64,0,0,0,3*sqrt(66)*I/64,0,0,0,sqrt(2002)*I/64,0]",
        ),
        "Qh(9,A,1,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Qh(9,A,2,)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Qh(9,A,3,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,A,4,)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(9,B,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Qh(9,B,2,)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(x-y)*(x+y)*(3*x**4-11*x**2*y**2-7*x**2*z**2+3*y**4-7*y**2*z**2+7*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Qh(9,B,3,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,B,4,)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,B,5,)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(9,Ea,1,)": (
            "21*sqrt(10)*C1/256-sqrt(1155)*C3/128+3*sqrt(143)*C5/128-3*sqrt(715)*C7/256+sqrt(12155)*C9/256+21*sqrt(10)*I*S1/256+sqrt(1155)*I*S3/128+3*sqrt(143)*I*S5/128+3*sqrt(715)*I*S7/256+sqrt(12155)*I*S9/256",
            "sqrt(2)*(128*x**9+315*I*x**8*y-2304*x**7*y**2-2304*x**7*z**2-3360*I*x**6*y**3+1260*I*x**6*y*z**2+6048*x**5*y**4+12096*x**5*y**2*z**2+6048*x**5*z**4+6048*I*x**4*y**5-10080*I*x**4*y**3*z**2+1890*I*x**4*y*z**4-3360*x**3*y**6-10080*x**3*y**4*z**2-10080*x**3*y**2*z**4-3360*x**3*z**6-2304*I*x**2*y**7+12096*I*x**2*y**5*z**2-10080*I*x**2*y**3*z**4+1260*I*x**2*y*z**6+315*x*y**8+1260*x*y**6*z**2+1890*x*y**4*z**4+1260*x*y**2*z**6+315*x*z**8+128*I*y**9-2304*I*y**7*z**2+6048*I*y**5*z**4-3360*I*y**3*z**6+315*I*y*z**8)/256",
            "[-sqrt(24310)/256,0,0,0,-3*sqrt(286)/128,0,0,0,-21*sqrt(5)/128,0,0,0,-sqrt(2310)/128,0,0,0,-3*sqrt(1430)/256,0,0]",
        ),
        "Qh(9,Ea,2,)": (
            "sqrt(4862)*C1/256+sqrt(4641)*C3/128+5*sqrt(85)*C5/128+7*sqrt(17)*C7/256+3*C9/256+sqrt(4862)*I*S1/256-sqrt(4641)*I*S3/128+5*sqrt(85)*I*S5/128-7*sqrt(17)*I*S7/256+3*I*S9/256",
            "3*sqrt(24310)*(I*x**8*y-28*I*x**6*y*z**2+70*I*x**4*y*z**4-28*I*x**2*y*z**6+x*y**8-28*x*y**6*z**2+70*x*y**4*z**4-28*x*y**2*z**6+x*z**8+I*y*z**8)/256",
            "[-3*sqrt(2)/256,0,0,0,-5*sqrt(170)/128,0,0,0,-sqrt(2431)/128,0,0,0,sqrt(9282)/128,0,0,0,7*sqrt(34)/256,0,0]",
        ),
        "Qh(9,Ea,3,)": (
            "sqrt(2002)*C1/128-sqrt(39)*C3/64-3*sqrt(35)*C5/64+23*sqrt(7)*C7/128+3*sqrt(119)*C9/128+sqrt(2002)*I*S1/128+sqrt(39)*I*S3/64-3*sqrt(35)*I*S5/64-23*sqrt(7)*I*S7/128+3*sqrt(119)*I*S9/128",
            "3*sqrt(10010)*(I*x**8*y-8*I*x**6*y**3-4*I*x**6*y*z**2+8*x**5*y**4-48*x**5*y**2*z**2+8*x**5*z**4+8*I*x**4*y**5+40*I*x**4*y**3*z**2-10*I*x**4*y*z**4-8*x**3*y**6+40*x**3*y**4*z**2+40*x**3*y**2*z**4-8*x**3*z**6-48*I*x**2*y**5*z**2+40*I*x**2*y**3*z**4-4*I*x**2*y*z**6+x*y**8-4*x*y**6*z**2-10*x*y**4*z**4-4*x*y**2*z**6+x*z**8+8*I*y**5*z**4-8*I*y**3*z**6+I*y*z**8)/128",
            "[-3*sqrt(238)/128,0,0,0,3*sqrt(70)/64,0,0,0,-sqrt(1001)/64,0,0,0,-sqrt(78)/64,0,0,0,23*sqrt(14)/128,0,0]",
        ),
        "Qh(9,Ea,4,)": (
            "sqrt(429)*C1/64+sqrt(182)*C3/64-5*sqrt(30)*C5/64-21*sqrt(6)*C7/128-sqrt(102)*C9/128+sqrt(429)*I*S1/64-sqrt(182)*I*S3/64-5*sqrt(30)*I*S5/64+21*sqrt(6)*I*S7/128-sqrt(102)*I*S9/128",
            "-sqrt(2145)*(3*I*x**8*y-14*I*x**6*y**3-42*I*x**6*y*z**2+210*I*x**4*y**3*z**2-14*x**3*y**6+210*x**3*y**4*z**2-210*x**3*y**2*z**4+14*x**3*z**6-210*I*x**2*y**3*z**4+42*I*x**2*y*z**6+3*x*y**8-42*x*y**6*z**2+42*x*y**2*z**6-3*x*z**8+14*I*y**3*z**6-3*I*y*z**8)/64",
            "[sqrt(51)/64,0,0,0,5*sqrt(15)/32,0,0,0,-sqrt(858)/64,0,0,0,sqrt(91)/32,0,0,0,-21*sqrt(3)/64,0,0]",
        ),
        "Qh(9,Ea,5,)": (
            "7*sqrt(11)*C1/64-3*sqrt(42)*C3/64+sqrt(130)*C5/64+sqrt(26)*C7/128-3*sqrt(442)*C9/128+7*sqrt(11)*I*S1/64+3*sqrt(42)*I*S3/64+sqrt(130)*I*S5/64-sqrt(26)*I*S7/128-3*sqrt(442)*I*S9/128",
            "-3*sqrt(55)*(7*I*x**8*y-32*x**7*y**2+32*x**7*z**2-70*I*x**6*y**3+14*I*x**6*y*z**2+112*x**5*y**4-112*x**5*z**4+112*I*x**4*y**5-70*I*x**4*y**3*z**2-70*x**3*y**6-70*x**3*y**4*z**2+70*x**3*y**2*z**4+70*x**3*z**6-32*I*x**2*y**7+70*I*x**2*y**3*z**4-14*I*x**2*y*z**6+7*x*y**8+14*x*y**6*z**2-14*x*y**2*z**6-7*x*z**8+32*I*y**7*z**2-112*I*y**5*z**4+70*I*y**3*z**6-7*I*y*z**8)/64",
            "[3*sqrt(221)/64,0,0,0,-sqrt(65)/32,0,0,0,-7*sqrt(22)/64,0,0,0,-3*sqrt(21)/32,0,0,0,sqrt(13)/64,0,0]",
        ),
        "Qh(9,Eb,1,)": (
            "21*sqrt(10)*C1/256-sqrt(1155)*C3/128+3*sqrt(143)*C5/128-3*sqrt(715)*C7/256+sqrt(12155)*C9/256-21*sqrt(10)*I*S1/256-sqrt(1155)*I*S3/128-3*sqrt(143)*I*S5/128-3*sqrt(715)*I*S7/256-sqrt(12155)*I*S9/256",
            "sqrt(2)*(128*x**9-315*I*x**8*y-2304*x**7*y**2-2304*x**7*z**2+3360*I*x**6*y**3-1260*I*x**6*y*z**2+6048*x**5*y**4+12096*x**5*y**2*z**2+6048*x**5*z**4-6048*I*x**4*y**5+10080*I*x**4*y**3*z**2-1890*I*x**4*y*z**4-3360*x**3*y**6-10080*x**3*y**4*z**2-10080*x**3*y**2*z**4-3360*x**3*z**6+2304*I*x**2*y**7-12096*I*x**2*y**5*z**2+10080*I*x**2*y**3*z**4-1260*I*x**2*y*z**6+315*x*y**8+1260*x*y**6*z**2+1890*x*y**4*z**4+1260*x*y**2*z**6+315*x*z**8-128*I*y**9+2304*I*y**7*z**2-6048*I*y**5*z**4+3360*I*y**3*z**6-315*I*y*z**8)/256",
            "[0,0,3*sqrt(1430)/256,0,0,0,sqrt(2310)/128,0,0,0,21*sqrt(5)/128,0,0,0,3*sqrt(286)/128,0,0,0,sqrt(24310)/256]",
        ),
        "Qh(9,Eb,2,)": (
            "sqrt(4862)*C1/256+sqrt(4641)*C3/128+5*sqrt(85)*C5/128+7*sqrt(17)*C7/256+3*C9/256-sqrt(4862)*I*S1/256+sqrt(4641)*I*S3/128-5*sqrt(85)*I*S5/128+7*sqrt(17)*I*S7/256-3*I*S9/256",
            "-3*sqrt(24310)*(I*x**8*y-28*I*x**6*y*z**2+70*I*x**4*y*z**4-28*I*x**2*y*z**6-x*y**8+28*x*y**6*z**2-70*x*y**4*z**4+28*x*y**2*z**6-x*z**8+I*y*z**8)/256",
            "[0,0,-7*sqrt(34)/256,0,0,0,-sqrt(9282)/128,0,0,0,sqrt(2431)/128,0,0,0,5*sqrt(170)/128,0,0,0,3*sqrt(2)/256]",
        ),
        "Qh(9,Eb,3,)": (
            "sqrt(2002)*C1/128-sqrt(39)*C3/64-3*sqrt(35)*C5/64+23*sqrt(7)*C7/128+3*sqrt(119)*C9/128-sqrt(2002)*I*S1/128-sqrt(39)*I*S3/64+3*sqrt(35)*I*S5/64+23*sqrt(7)*I*S7/128-3*sqrt(119)*I*S9/128",
            "-3*sqrt(10010)*(I*x**8*y-8*I*x**6*y**3-4*I*x**6*y*z**2-8*x**5*y**4+48*x**5*y**2*z**2-8*x**5*z**4+8*I*x**4*y**5+40*I*x**4*y**3*z**2-10*I*x**4*y*z**4+8*x**3*y**6-40*x**3*y**4*z**2-40*x**3*y**2*z**4+8*x**3*z**6-48*I*x**2*y**5*z**2+40*I*x**2*y**3*z**4-4*I*x**2*y*z**6-x*y**8+4*x*y**6*z**2+10*x*y**4*z**4+4*x*y**2*z**6-x*z**8+8*I*y**5*z**4-8*I*y**3*z**6+I*y*z**8)/128",
            "[0,0,-23*sqrt(14)/128,0,0,0,sqrt(78)/64,0,0,0,sqrt(1001)/64,0,0,0,-3*sqrt(70)/64,0,0,0,3*sqrt(238)/128]",
        ),
        "Qh(9,Eb,4,)": (
            "sqrt(429)*C1/64+sqrt(182)*C3/64-5*sqrt(30)*C5/64-21*sqrt(6)*C7/128-sqrt(102)*C9/128-sqrt(429)*I*S1/64+sqrt(182)*I*S3/64+5*sqrt(30)*I*S5/64-21*sqrt(6)*I*S7/128+sqrt(102)*I*S9/128",
            "sqrt(2145)*(3*I*x**8*y-14*I*x**6*y**3-42*I*x**6*y*z**2+210*I*x**4*y**3*z**2+14*x**3*y**6-210*x**3*y**4*z**2+210*x**3*y**2*z**4-14*x**3*z**6-210*I*x**2*y**3*z**4+42*I*x**2*y*z**6-3*x*y**8+42*x*y**6*z**2-42*x*y**2*z**6+3*x*z**8+14*I*y**3*z**6-3*I*y*z**8)/64",
            "[0,0,21*sqrt(3)/64,0,0,0,-sqrt(91)/32,0,0,0,sqrt(858)/64,0,0,0,-5*sqrt(15)/32,0,0,0,-sqrt(51)/64]",
        ),
        "Qh(9,Eb,5,)": (
            "7*sqrt(11)*C1/64-3*sqrt(42)*C3/64+sqrt(130)*C5/64+sqrt(26)*C7/128-3*sqrt(442)*C9/128-7*sqrt(11)*I*S1/64-3*sqrt(42)*I*S3/64-sqrt(130)*I*S5/64+sqrt(26)*I*S7/128+3*sqrt(442)*I*S9/128",
            "3*sqrt(55)*(7*I*x**8*y+32*x**7*y**2-32*x**7*z**2-70*I*x**6*y**3+14*I*x**6*y*z**2-112*x**5*y**4+112*x**5*z**4+112*I*x**4*y**5-70*I*x**4*y**3*z**2+70*x**3*y**6+70*x**3*y**4*z**2-70*x**3*y**2*z**4-70*x**3*z**6-32*I*x**2*y**7+70*I*x**2*y**3*z**4-14*I*x**2*y*z**6-7*x*y**8-14*x*y**6*z**2+14*x*y**2*z**6+7*x*z**8+32*I*y**7*z**2-112*I*y**5*z**4+70*I*y**3*z**6-7*I*y*z**8)/64",
            "[0,0,-sqrt(13)/64,0,0,0,3*sqrt(21)/32,0,0,0,7*sqrt(22)/64,0,0,0,sqrt(65)/32,0,0,0,-3*sqrt(221)/64]",
        ),
        "Qh(10,A,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Qh(10,A,2,)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "-sqrt(420189)*(22*x**10+45*x**8*y**2-1035*x**8*z**2-105*x**6*y**4-630*x**6*y**2*z**2+4935*x**6*z**4-105*x**4*y**6+3150*x**4*y**4*z**2-1575*x**4*y**2*z**4-4830*x**4*z**6+45*x**2*y**8-630*x**2*y**6*z**2-1575*x**2*y**4*z**4+1260*x**2*y**2*z**6+990*x**2*z**8+22*y**10-1035*y**8*z**2+4935*y**6*z**4-4830*y**4*z**6+990*y**2*z**8-44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Qh(10,A,3,)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "-sqrt(3213210)*(3*x**10-96*x**8*y**2-39*x**8*z**2+224*x**6*y**4+1344*x**6*y**2*z**2-42*x**6*z**4+224*x**4*y**6-6720*x**4*y**4*z**2+3360*x**4*y**2*z**4-182*x**4*z**6-96*x**2*y**8+1344*x**2*y**6*z**2+3360*x**2*y**4*z**4-2688*x**2*y**2*z**6+135*x**2*z**8+3*y**10-39*y**8*z**2-42*y**6*z**4-182*y**4*z**6+135*y**2*z**8-6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Qh(10,A,4,)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(10,A,5,)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(10,B,1,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Qh(10,B,2,)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(x-y)*(x+y)*(22*x**8-653*x**6*y**2-315*x**6*z**2+2602*x**4*y**4-945*x**4*y**2*z**2+1575*x**4*z**4-653*x**2*y**6-945*x**2*y**4*z**2+3150*x**2*y**2*z**4-1680*x**2*z**6+22*y**8-315*y**6*z**2+1575*y**4*z**4-1680*y**2*z**6+360*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Qh(10,B,3,)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(x-y)*(x+y)*(9*x**8-165*x**6*y**2-231*x**6*z**2-25*x**4*y**4+3801*x**4*y**2*z**2+406*x**4*z**4-165*x**2*y**6+3801*x**2*y**4*z**2-9674*x**2*y**2*z**4+266*x**2*z**6+9*y**8-231*y**6*z**2+406*y**4*z**4+266*y**2*z**6-57*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Qh(10,B,4,)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(10,B,5,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,B,6,)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Ea,1,)": (
            "sqrt(442)*I*C1/64+sqrt(51)*I*C3/32-sqrt(255)*I*C5/32+11*sqrt(3)*I*C7/64-sqrt(19)*I*C9/64+sqrt(442)*S1/64-sqrt(51)*S3/32-sqrt(255)*S5/32-11*sqrt(3)*S7/64-sqrt(19)*S9/64",
            "-sqrt(24310)*z*(I*x**9-18*I*x**7*y**2-6*I*x**7*z**2+126*I*x**5*y**2*z**2-126*I*x**3*y**2*z**4+6*I*x**3*z**6-18*x**2*y**7+126*x**2*y**5*z**2-126*x**2*y**3*z**4+18*x**2*y*z**6+18*I*x*y**2*z**6-I*x*z**8+y**9-6*y**7*z**2+6*y**3*z**6-y*z**8)/64",
            "[0,0,0,-11*sqrt(6)*I/64,0,0,0,-sqrt(102)*I/32,0,0,0,sqrt(221)*I/32,0,0,0,-sqrt(510)*I/32,0,0,0,-sqrt(38)*I/64,0]",
        ),
        "Qh(10,Ea,2,)": (
            "sqrt(78)*I*C1/64+11*I*C3/32+5*sqrt(5)*I*C5/32+sqrt(17)*I*C7/64-sqrt(969)*I*C9/64+sqrt(78)*S1/64-11*S3/32+5*sqrt(5)*S5/32-sqrt(17)*S7/64-sqrt(969)*S9/64",
            "-sqrt(4290)*z*(I*x**9-42*I*x**7*y**2+2*I*x**7*z**2-112*x**6*y**3+112*x**6*y*z**2+168*I*x**5*y**4-42*I*x**5*y**2*z**2+168*x**4*y**5-168*x**4*y*z**4-112*I*x**3*y**6+42*I*x**3*y**2*z**4-2*I*x**3*z**6-42*x**2*y**7-42*x**2*y**5*z**2+42*x**2*y**3*z**4+42*x**2*y*z**6+112*I*x*y**6*z**2-168*I*x*y**4*z**4+42*I*x*y**2*z**6-I*x*z**8+y**9+2*y**7*z**2-2*y**3*z**6-y*z**8)/64",
            "[0,0,0,-sqrt(34)*I/64,0,0,0,-11*sqrt(2)*I/32,0,0,0,sqrt(39)*I/32,0,0,0,5*sqrt(10)*I/32,0,0,0,-sqrt(1938)*I/64,0]",
        ),
        "Qh(10,Ea,3,)": (
            "sqrt(20995)*I*C1/256-sqrt(9690)*I*C3/256+sqrt(1938)*I*C5/256-sqrt(570)*I*C7/512+sqrt(10)*I*C9/512+sqrt(20995)*S1/256+sqrt(9690)*S3/256+sqrt(1938)*S5/256+sqrt(570)*S7/512+sqrt(10)*S9/512",
            "sqrt(46189)*z*(5*I*x**9-60*I*x**7*z**2+126*I*x**5*z**4-60*I*x**3*z**6+5*I*x*z**8+5*y**9-60*y**7*z**2+126*y**5*z**4-60*y**3*z**6+5*y*z**8)/256",
            "[0,0,0,sqrt(285)*I/256,0,0,0,sqrt(4845)*I/128,0,0,0,sqrt(41990)*I/256,0,0,0,sqrt(969)*I/128,0,0,0,sqrt(5)*I/256,0]",
        ),
        "Qh(10,Ea,4,)": (
            "9*sqrt(39)*I*C1/256+69*sqrt(2)*I*C3/256-sqrt(10)*I*C5/256-43*sqrt(34)*I*C7/512+3*sqrt(1938)*I*C9/512+9*sqrt(39)*S1/256-69*sqrt(2)*S3/256-sqrt(10)*S5/256+43*sqrt(34)*S7/512+3*sqrt(1938)*S9/512",
            "sqrt(2145)*z*(9*I*x**9-288*I*x**7*y**2-12*I*x**7*z**2+672*I*x**5*y**4+672*I*x**5*y**2*z**2-42*I*x**5*z**4+672*x**4*y**5-2240*x**4*y**3*z**2+672*x**4*y*z**4-2240*I*x**3*y**4*z**2+672*I*x**3*y**2*z**4-12*I*x**3*z**6-288*x**2*y**7+672*x**2*y**5*z**2+672*x**2*y**3*z**4-288*x**2*y*z**6+672*I*x*y**4*z**4-288*I*x*y**2*z**6+9*I*x*z**8+9*y**9-12*y**7*z**2-42*y**5*z**4-12*y**3*z**6+9*y*z**8)/256",
            "[0,0,0,43*sqrt(17)*I/256,0,0,0,-69*I/128,0,0,0,9*sqrt(78)*I/256,0,0,0,-sqrt(5)*I/128,0,0,0,3*sqrt(969)*I/256,0]",
        ),
        "Qh(10,Ea,5,)": (
            "7*sqrt(6)*I*C1/256+7*sqrt(13)*I*C3/128+5*sqrt(65)*I*C5/128+7*sqrt(221)*I*C7/256+sqrt(12597)*I*C9/256+7*sqrt(6)*S1/256-7*sqrt(13)*S3/128+5*sqrt(65)*S5/128-7*sqrt(221)*S7/256+sqrt(12597)*S9/256",
            "sqrt(330)*z*(7*I*x**9+384*x**8*y-336*I*x**7*y**2+28*I*x**7*z**2-1792*x**6*y**3-1792*x**6*y*z**2+1680*I*x**5*y**4-1008*I*x**5*y**2*z**2+42*I*x**5*z**4+1680*x**4*y**5+3360*x**4*y**3*z**2+1680*x**4*y*z**4-1792*I*x**3*y**6+3360*I*x**3*y**4*z**2-1008*I*x**3*y**2*z**4+28*I*x**3*z**6-336*x**2*y**7-1008*x**2*y**5*z**2-1008*x**2*y**3*z**4-336*x**2*y*z**6+384*I*x*y**8-1792*I*x*y**6*z**2+1680*I*x*y**4*z**4-336*I*x*y**2*z**6+7*I*x*z**8+7*y**9+28*y**7*z**2+42*y**5*z**4+28*y**3*z**6+7*y*z**8)/256",
            "[0,0,0,-7*sqrt(442)*I/256,0,0,0,-7*sqrt(26)*I/128,0,0,0,7*sqrt(3)*I/128,0,0,0,5*sqrt(130)*I/128,0,0,0,sqrt(25194)*I/256,0]",
        ),
        "Qh(10,Eb,1,)": (
            "-sqrt(442)*I*C1/64-sqrt(51)*I*C3/32+sqrt(255)*I*C5/32-11*sqrt(3)*I*C7/64+sqrt(19)*I*C9/64+sqrt(442)*S1/64-sqrt(51)*S3/32-sqrt(255)*S5/32-11*sqrt(3)*S7/64-sqrt(19)*S9/64",
            "sqrt(24310)*z*(I*x**9-18*I*x**7*y**2-6*I*x**7*z**2+126*I*x**5*y**2*z**2-126*I*x**3*y**2*z**4+6*I*x**3*z**6+18*x**2*y**7-126*x**2*y**5*z**2+126*x**2*y**3*z**4-18*x**2*y*z**6+18*I*x*y**2*z**6-I*x*z**8-y**9+6*y**7*z**2-6*y**3*z**6+y*z**8)/64",
            "[0,-sqrt(38)*I/64,0,0,0,-sqrt(510)*I/32,0,0,0,sqrt(221)*I/32,0,0,0,-sqrt(102)*I/32,0,0,0,-11*sqrt(6)*I/64,0,0,0]",
        ),
        "Qh(10,Eb,2,)": (
            "-sqrt(78)*I*C1/64-11*I*C3/32-5*sqrt(5)*I*C5/32-sqrt(17)*I*C7/64+sqrt(969)*I*C9/64+sqrt(78)*S1/64-11*S3/32+5*sqrt(5)*S5/32-sqrt(17)*S7/64-sqrt(969)*S9/64",
            "sqrt(4290)*z*(I*x**9-42*I*x**7*y**2+2*I*x**7*z**2+112*x**6*y**3-112*x**6*y*z**2+168*I*x**5*y**4-42*I*x**5*y**2*z**2-168*x**4*y**5+168*x**4*y*z**4-112*I*x**3*y**6+42*I*x**3*y**2*z**4-2*I*x**3*z**6+42*x**2*y**7+42*x**2*y**5*z**2-42*x**2*y**3*z**4-42*x**2*y*z**6+112*I*x*y**6*z**2-168*I*x*y**4*z**4+42*I*x*y**2*z**6-I*x*z**8-y**9-2*y**7*z**2+2*y**3*z**6+y*z**8)/64",
            "[0,-sqrt(1938)*I/64,0,0,0,5*sqrt(10)*I/32,0,0,0,sqrt(39)*I/32,0,0,0,-11*sqrt(2)*I/32,0,0,0,-sqrt(34)*I/64,0,0,0]",
        ),
        "Qh(10,Eb,3,)": (
            "-sqrt(20995)*I*C1/256+sqrt(9690)*I*C3/256-sqrt(1938)*I*C5/256+sqrt(570)*I*C7/512-sqrt(10)*I*C9/512+sqrt(20995)*S1/256+sqrt(9690)*S3/256+sqrt(1938)*S5/256+sqrt(570)*S7/512+sqrt(10)*S9/512",
            "-sqrt(46189)*z*(5*I*x**9-60*I*x**7*z**2+126*I*x**5*z**4-60*I*x**3*z**6+5*I*x*z**8-5*y**9+60*y**7*z**2-126*y**5*z**4+60*y**3*z**6-5*y*z**8)/256",
            "[0,sqrt(5)*I/256,0,0,0,sqrt(969)*I/128,0,0,0,sqrt(41990)*I/256,0,0,0,sqrt(4845)*I/128,0,0,0,sqrt(285)*I/256,0,0,0]",
        ),
        "Qh(10,Eb,4,)": (
            "-9*sqrt(39)*I*C1/256-69*sqrt(2)*I*C3/256+sqrt(10)*I*C5/256+43*sqrt(34)*I*C7/512-3*sqrt(1938)*I*C9/512+9*sqrt(39)*S1/256-69*sqrt(2)*S3/256-sqrt(10)*S5/256+43*sqrt(34)*S7/512+3*sqrt(1938)*S9/512",
            "-sqrt(2145)*z*(9*I*x**9-288*I*x**7*y**2-12*I*x**7*z**2+672*I*x**5*y**4+672*I*x**5*y**2*z**2-42*I*x**5*z**4-672*x**4*y**5+2240*x**4*y**3*z**2-672*x**4*y*z**4-2240*I*x**3*y**4*z**2+672*I*x**3*y**2*z**4-12*I*x**3*z**6+288*x**2*y**7-672*x**2*y**5*z**2-672*x**2*y**3*z**4+288*x**2*y*z**6+672*I*x*y**4*z**4-288*I*x*y**2*z**6+9*I*x*z**8-9*y**9+12*y**7*z**2+42*y**5*z**4+12*y**3*z**6-9*y*z**8)/256",
            "[0,3*sqrt(969)*I/256,0,0,0,-sqrt(5)*I/128,0,0,0,9*sqrt(78)*I/256,0,0,0,-69*I/128,0,0,0,43*sqrt(17)*I/256,0,0,0]",
        ),
        "Qh(10,Eb,5,)": (
            "-7*sqrt(6)*I*C1/256-7*sqrt(13)*I*C3/128-5*sqrt(65)*I*C5/128-7*sqrt(221)*I*C7/256-sqrt(12597)*I*C9/256+7*sqrt(6)*S1/256-7*sqrt(13)*S3/128+5*sqrt(65)*S5/128-7*sqrt(221)*S7/256+sqrt(12597)*S9/256",
            "-sqrt(330)*z*(7*I*x**9-384*x**8*y-336*I*x**7*y**2+28*I*x**7*z**2+1792*x**6*y**3+1792*x**6*y*z**2+1680*I*x**5*y**4-1008*I*x**5*y**2*z**2+42*I*x**5*z**4-1680*x**4*y**5-3360*x**4*y**3*z**2-1680*x**4*y*z**4-1792*I*x**3*y**6+3360*I*x**3*y**4*z**2-1008*I*x**3*y**2*z**4+28*I*x**3*z**6+336*x**2*y**7+1008*x**2*y**5*z**2+1008*x**2*y**3*z**4+336*x**2*y*z**6+384*I*x*y**8-1792*I*x*y**6*z**2+1680*I*x*y**4*z**4-336*I*x*y**2*z**6+7*I*x*z**8-7*y**9-28*y**7*z**2-42*y**5*z**4-28*y**3*z**6-7*y*z**8)/256",
            "[0,sqrt(25194)*I/256,0,0,0,5*sqrt(130)*I/128,0,0,0,7*sqrt(3)*I/128,0,0,0,-7*sqrt(26)*I/128,0,0,0,-7*sqrt(442)*I/256,0,0,0]",
        ),
        "Qh(11,A,1,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Qh(11,A,2,)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "-sqrt(230945)*x*y*z*(x**8-6*x**6*y**2-6*x**6*z**2+42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2-84*x**2*y**2*z**4+12*x**2*z**6+y**8-6*y**6*z**2+12*y**2*z**6-2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Qh(11,A,3,)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "-sqrt(3003)*x*y*z*(5*x**8-150*x**6*y**2+90*x**6*z**2+336*x**4*y**4-70*x**4*y**2*z**2-168*x**4*z**4-150*x**2*y**6-70*x**2*y**4*z**2+140*x**2*y**2*z**4+60*x**2*z**6+5*y**8+90*y**6*z**2-168*y**4*z**4+60*y**2*z**6-10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Qh(11,A,4,)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(11,A,5,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,A,6,)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,B,1,)": (
            "S8",
            "-sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(11,B,2,)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,B,3,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,B,4,)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(11,B,5,)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Ea,1,)": (
            "-21*sqrt(33)*C1/512+sqrt(176358)*C11/1024+sqrt(15015)*C3/512-15*sqrt(286)*C5/1024+sqrt(72930)*C7/1024-sqrt(92378)*C9/1024-21*sqrt(33)*I*S1/512-sqrt(176358)*I*S11/1024-sqrt(15015)*I*S3/512-15*sqrt(286)*I*S5/1024-sqrt(72930)*I*S7/1024-sqrt(92378)*I*S9/1024",
            "sqrt(2)*(256*x**11-693*I*x**10*y-7040*x**9*y**2-7040*x**9*z**2+11550*I*x**8*y**3-3465*I*x**8*y*z**2+31680*x**7*y**4+63360*x**7*y**2*z**2+31680*x**7*z**4-36960*I*x**6*y**5+46200*I*x**6*y**3*z**2-6930*I*x**6*y*z**4-36960*x**5*y**6-110880*x**5*y**4*z**2-110880*x**5*y**2*z**4-36960*x**5*z**6+31680*I*x**4*y**7-110880*I*x**4*y**5*z**2+69300*I*x**4*y**3*z**4-6930*I*x**4*y*z**6+11550*x**3*y**8+46200*x**3*y**6*z**2+69300*x**3*y**4*z**4+46200*x**3*y**2*z**6+11550*x**3*z**8-7040*I*x**2*y**9+63360*I*x**2*y**7*z**2-110880*I*x**2*y**5*z**4+46200*I*x**2*y**3*z**6-3465*I*x**2*y*z**8-693*x*y**10-3465*x*y**8*z**2-6930*x*y**6*z**4-6930*x*y**4*z**6-3465*x*y**2*z**8-693*x*z**10+256*I*y**11-7040*I*y**9*z**2+31680*I*y**7*z**4-36960*I*y**5*z**6+11550*I*y**3*z**8-693*I*y*z**10)/512",
            "[0,0,sqrt(46189)/512,0,0,0,15*sqrt(143)/512,0,0,0,21*sqrt(66)/512,0,0,0,sqrt(30030)/512,0,0,0,sqrt(36465)/512,0,0,0,sqrt(88179)/512]",
        ),
        "Qh(11,Ea,2,)": (
            "-sqrt(20995)*C1/512+sqrt(770)*C11/1024-3*sqrt(2261)*C3/512+3*sqrt(9690)*C5/1024+77*sqrt(38)*C7/1024+39*sqrt(30)*C9/1024-sqrt(20995)*I*S1/512-sqrt(770)*I*S11/1024+3*sqrt(2261)*I*S3/512+3*sqrt(9690)*I*S5/1024-77*sqrt(38)*I*S7/1024+39*sqrt(30)*I*S9/1024",
            "-sqrt(1385670)*(I*x**10*y-6*I*x**8*y**3-27*I*x**8*y*z**2+168*I*x**6*y**3*z**2+42*I*x**6*y*z**4-420*I*x**4*y**3*z**4+42*I*x**4*y*z**6-6*x**3*y**8+168*x**3*y**6*z**2-420*x**3*y**4*z**4+168*x**3*y**2*z**6-6*x**3*z**8+168*I*x**2*y**3*z**6-27*I*x**2*y*z**8+x*y**10-27*x*y**8*z**2+42*x*y**6*z**4+42*x*y**4*z**6-27*x*y**2*z**8+x*z**10-6*I*y**3*z**8+I*y*z**10)/512",
            "[0,0,-39*sqrt(15)/512,0,0,0,-3*sqrt(4845)/512,0,0,0,sqrt(41990)/512,0,0,0,-3*sqrt(4522)/512,0,0,0,77*sqrt(19)/512,0,0,0,sqrt(385)/512]",
        ),
        "Qh(11,Ea,3,)": (
            "-5*sqrt(273)*C1/256+sqrt(21318)*C11/512+11*sqrt(15)*C3/256+13*sqrt(14)*C5/512-3*sqrt(3570)*C7/512+3*sqrt(4522)*C9/512-5*sqrt(273)*I*S1/256-sqrt(21318)*I*S11/512-11*sqrt(15)*I*S3/256+13*sqrt(14)*I*S5/512+3*sqrt(3570)*I*S7/512+3*sqrt(4522)*I*S9/512",
            "-3*sqrt(2002)*(5*I*x**10*y-70*I*x**8*y**3-15*I*x**8*y*z**2-80*x**7*y**4+480*x**7*y**2*z**2-80*x**7*z**4+168*I*x**6*y**5+280*I*x**6*y**3*z**2-70*I*x**6*y*z**4+168*x**5*y**6-840*x**5*y**4*z**2-840*x**5*y**2*z**4+168*x**5*z**6-80*I*x**4*y**7-840*I*x**4*y**5*z**2+700*I*x**4*y**3*z**4-70*I*x**4*y*z**6-70*x**3*y**8+280*x**3*y**6*z**2+700*x**3*y**4*z**4+280*x**3*y**2*z**6-70*x**3*z**8+480*I*x**2*y**7*z**2-840*I*x**2*y**5*z**4+280*I*x**2*y**3*z**6-15*I*x**2*y*z**8+5*x*y**10-15*x*y**8*z**2-70*x*y**6*z**4-70*x*y**4*z**6-15*x*y**2*z**8+5*x*z**10-80*I*y**7*z**4+168*I*y**5*z**6-70*I*y**3*z**8+5*I*y*z**10)/256",
            "[0,0,-3*sqrt(2261)/256,0,0,0,-13*sqrt(7)/256,0,0,0,5*sqrt(546)/256,0,0,0,11*sqrt(30)/256,0,0,0,-3*sqrt(1785)/256,0,0,0,sqrt(10659)/256]",
        ),
        "Qh(11,Ea,4,)": (
            "-sqrt(58786)*C1/1024-sqrt(11)*C11/1024-9*sqrt(3230)*C3/1024-5*sqrt(6783)*C5/1024-7*sqrt(665)*C7/1024-9*sqrt(21)*C9/1024-sqrt(58786)*I*S1/1024+sqrt(11)*I*S11/1024+9*sqrt(3230)*I*S3/1024-5*sqrt(6783)*I*S5/1024+7*sqrt(665)*I*S7/1024-9*sqrt(21)*I*S9/1024",
            "sqrt(969969)*(I*x**10*y-45*I*x**8*y*z**2+210*I*x**6*y*z**4-210*I*x**4*y*z**6+45*I*x**2*y*z**8+x*y**10-45*x*y**8*z**2+210*x*y**6*z**4-210*x*y**4*z**6+45*x*y**2*z**8-x*z**10-I*y*z**10)/512",
            "[0,0,9*sqrt(42)/1024,0,0,0,5*sqrt(13566)/1024,0,0,0,sqrt(29393)/512,0,0,0,-9*sqrt(1615)/512,0,0,0,-7*sqrt(1330)/1024,0,0,0,-sqrt(22)/1024]",
        ),
        "Qh(11,Ea,5,)": (
            "-15*sqrt(442)*C1/1024-3*sqrt(1463)*C11/1024-sqrt(1190)*C3/1024+53*sqrt(51)*C5/1024-105*sqrt(5)*C7/1024-61*sqrt(57)*C9/1024-15*sqrt(442)*I*S1/1024+3*sqrt(1463)*I*S11/1024+sqrt(1190)*I*S3/1024+53*sqrt(51)*I*S5/1024+105*sqrt(5)*I*S7/1024-61*sqrt(57)*I*S9/1024",
            "sqrt(7293)*(15*I*x**10*y-160*I*x**8*y**3-195*I*x**8*y*z**2+224*I*x**6*y**5+2240*I*x**6*y**3*z**2-210*I*x**6*y*z**4+224*x**5*y**6-3360*x**5*y**4*z**2+3360*x**5*y**2*z**4-224*x**5*z**6-3360*I*x**4*y**5*z**2+210*I*x**4*y*z**6-160*x**3*y**8+2240*x**3*y**6*z**2-2240*x**3*y**2*z**6+160*x**3*z**8+3360*I*x**2*y**5*z**4-2240*I*x**2*y**3*z**6+195*I*x**2*y*z**8+15*x*y**10-195*x*y**8*z**2-210*x*y**6*z**4+210*x*y**4*z**6+195*x*y**2*z**8-15*x*z**10-224*I*y**5*z**6+160*I*y**3*z**8-15*I*y*z**10)/512",
            "[0,0,61*sqrt(114)/1024,0,0,0,-53*sqrt(102)/1024,0,0,0,15*sqrt(221)/512,0,0,0,-sqrt(595)/512,0,0,0,-105*sqrt(10)/1024,0,0,0,-3*sqrt(2926)/1024]",
        ),
        "Qh(11,Ea,6,)": (
            "-21*sqrt(65)*C1/512-sqrt(248710)*C11/1024+57*sqrt(7)*C3/512-41*sqrt(30)*C5/1024+17*sqrt(34)*C7/1024+sqrt(9690)*C9/1024-21*sqrt(65)*I*S1/512+sqrt(248710)*I*S11/1024-57*sqrt(7)*I*S3/512-41*sqrt(30)*I*S5/1024-17*sqrt(34)*I*S7/1024+sqrt(9690)*I*S9/1024",
            "sqrt(4290)*(21*I*x**10*y+128*x**9*y**2-128*x**9*z**2-336*I*x**8*y**3+63*I*x**8*y*z**2-768*x**7*y**4+768*x**7*z**4+1008*I*x**6*y**5-672*I*x**6*y**3*z**2+42*I*x**6*y*z**4+1008*x**5*y**6+1008*x**5*y**4*z**2-1008*x**5*y**2*z**4-1008*x**5*z**6-768*I*x**4*y**7+1008*I*x**4*y**5*z**2-42*I*x**4*y*z**6-336*x**3*y**8-672*x**3*y**6*z**2+672*x**3*y**2*z**6+336*x**3*z**8+128*I*x**2*y**9-1008*I*x**2*y**5*z**4+672*I*x**2*y**3*z**6-63*I*x**2*y*z**8+21*x*y**10+63*x*y**8*z**2+42*x*y**6*z**4-42*x*y**4*z**6-63*x*y**2*z**8-21*x*z**10-128*I*y**9*z**2+768*I*y**7*z**4-1008*I*y**5*z**6+336*I*y**3*z**8-21*I*y*z**10)/512",
            "[0,0,-sqrt(4845)/512,0,0,0,41*sqrt(15)/512,0,0,0,21*sqrt(130)/512,0,0,0,57*sqrt(14)/512,0,0,0,17*sqrt(17)/512,0,0,0,-sqrt(124355)/512]",
        ),
        "Qh(11,Eb,1,)": (
            "-21*sqrt(33)*C1/512+sqrt(176358)*C11/1024+sqrt(15015)*C3/512-15*sqrt(286)*C5/1024+sqrt(72930)*C7/1024-sqrt(92378)*C9/1024+21*sqrt(33)*I*S1/512+sqrt(176358)*I*S11/1024+sqrt(15015)*I*S3/512+15*sqrt(286)*I*S5/1024+sqrt(72930)*I*S7/1024+sqrt(92378)*I*S9/1024",
            "sqrt(2)*(256*x**11+693*I*x**10*y-7040*x**9*y**2-7040*x**9*z**2-11550*I*x**8*y**3+3465*I*x**8*y*z**2+31680*x**7*y**4+63360*x**7*y**2*z**2+31680*x**7*z**4+36960*I*x**6*y**5-46200*I*x**6*y**3*z**2+6930*I*x**6*y*z**4-36960*x**5*y**6-110880*x**5*y**4*z**2-110880*x**5*y**2*z**4-36960*x**5*z**6-31680*I*x**4*y**7+110880*I*x**4*y**5*z**2-69300*I*x**4*y**3*z**4+6930*I*x**4*y*z**6+11550*x**3*y**8+46200*x**3*y**6*z**2+69300*x**3*y**4*z**4+46200*x**3*y**2*z**6+11550*x**3*z**8+7040*I*x**2*y**9-63360*I*x**2*y**7*z**2+110880*I*x**2*y**5*z**4-46200*I*x**2*y**3*z**6+3465*I*x**2*y*z**8-693*x*y**10-3465*x*y**8*z**2-6930*x*y**6*z**4-6930*x*y**4*z**6-3465*x*y**2*z**8-693*x*z**10-256*I*y**11+7040*I*y**9*z**2-31680*I*y**7*z**4+36960*I*y**5*z**6-11550*I*y**3*z**8+693*I*y*z**10)/512",
            "[-sqrt(88179)/512,0,0,0,-sqrt(36465)/512,0,0,0,-sqrt(30030)/512,0,0,0,-21*sqrt(66)/512,0,0,0,-15*sqrt(143)/512,0,0,0,-sqrt(46189)/512,0,0]",
        ),
        "Qh(11,Eb,2,)": (
            "-sqrt(20995)*C1/512+sqrt(770)*C11/1024-3*sqrt(2261)*C3/512+3*sqrt(9690)*C5/1024+77*sqrt(38)*C7/1024+39*sqrt(30)*C9/1024+sqrt(20995)*I*S1/512+sqrt(770)*I*S11/1024-3*sqrt(2261)*I*S3/512-3*sqrt(9690)*I*S5/1024+77*sqrt(38)*I*S7/1024-39*sqrt(30)*I*S9/1024",
            "sqrt(1385670)*(I*x**10*y-6*I*x**8*y**3-27*I*x**8*y*z**2+168*I*x**6*y**3*z**2+42*I*x**6*y*z**4-420*I*x**4*y**3*z**4+42*I*x**4*y*z**6+6*x**3*y**8-168*x**3*y**6*z**2+420*x**3*y**4*z**4-168*x**3*y**2*z**6+6*x**3*z**8+168*I*x**2*y**3*z**6-27*I*x**2*y*z**8-x*y**10+27*x*y**8*z**2-42*x*y**6*z**4-42*x*y**4*z**6+27*x*y**2*z**8-x*z**10-6*I*y**3*z**8+I*y*z**10)/512",
            "[-sqrt(385)/512,0,0,0,-77*sqrt(19)/512,0,0,0,3*sqrt(4522)/512,0,0,0,-sqrt(41990)/512,0,0,0,3*sqrt(4845)/512,0,0,0,39*sqrt(15)/512,0,0]",
        ),
        "Qh(11,Eb,3,)": (
            "-5*sqrt(273)*C1/256+sqrt(21318)*C11/512+11*sqrt(15)*C3/256+13*sqrt(14)*C5/512-3*sqrt(3570)*C7/512+3*sqrt(4522)*C9/512+5*sqrt(273)*I*S1/256+sqrt(21318)*I*S11/512+11*sqrt(15)*I*S3/256-13*sqrt(14)*I*S5/512-3*sqrt(3570)*I*S7/512-3*sqrt(4522)*I*S9/512",
            "3*sqrt(2002)*(5*I*x**10*y-70*I*x**8*y**3-15*I*x**8*y*z**2+80*x**7*y**4-480*x**7*y**2*z**2+80*x**7*z**4+168*I*x**6*y**5+280*I*x**6*y**3*z**2-70*I*x**6*y*z**4-168*x**5*y**6+840*x**5*y**4*z**2+840*x**5*y**2*z**4-168*x**5*z**6-80*I*x**4*y**7-840*I*x**4*y**5*z**2+700*I*x**4*y**3*z**4-70*I*x**4*y*z**6+70*x**3*y**8-280*x**3*y**6*z**2-700*x**3*y**4*z**4-280*x**3*y**2*z**6+70*x**3*z**8+480*I*x**2*y**7*z**2-840*I*x**2*y**5*z**4+280*I*x**2*y**3*z**6-15*I*x**2*y*z**8-5*x*y**10+15*x*y**8*z**2+70*x*y**6*z**4+70*x*y**4*z**6+15*x*y**2*z**8-5*x*z**10-80*I*y**7*z**4+168*I*y**5*z**6-70*I*y**3*z**8+5*I*y*z**10)/256",
            "[-sqrt(10659)/256,0,0,0,3*sqrt(1785)/256,0,0,0,-11*sqrt(30)/256,0,0,0,-5*sqrt(546)/256,0,0,0,13*sqrt(7)/256,0,0,0,3*sqrt(2261)/256,0,0]",
        ),
        "Qh(11,Eb,4,)": (
            "-sqrt(58786)*C1/1024-sqrt(11)*C11/1024-9*sqrt(3230)*C3/1024-5*sqrt(6783)*C5/1024-7*sqrt(665)*C7/1024-9*sqrt(21)*C9/1024+sqrt(58786)*I*S1/1024-sqrt(11)*I*S11/1024-9*sqrt(3230)*I*S3/1024+5*sqrt(6783)*I*S5/1024-7*sqrt(665)*I*S7/1024+9*sqrt(21)*I*S9/1024",
            "-sqrt(969969)*(I*x**10*y-45*I*x**8*y*z**2+210*I*x**6*y*z**4-210*I*x**4*y*z**6+45*I*x**2*y*z**8-x*y**10+45*x*y**8*z**2-210*x*y**6*z**4+210*x*y**4*z**6-45*x*y**2*z**8+x*z**10-I*y*z**10)/512",
            "[sqrt(22)/1024,0,0,0,7*sqrt(1330)/1024,0,0,0,9*sqrt(1615)/512,0,0,0,-sqrt(29393)/512,0,0,0,-5*sqrt(13566)/1024,0,0,0,-9*sqrt(42)/1024,0,0]",
        ),
        "Qh(11,Eb,5,)": (
            "-15*sqrt(442)*C1/1024-3*sqrt(1463)*C11/1024-sqrt(1190)*C3/1024+53*sqrt(51)*C5/1024-105*sqrt(5)*C7/1024-61*sqrt(57)*C9/1024+15*sqrt(442)*I*S1/1024-3*sqrt(1463)*I*S11/1024-sqrt(1190)*I*S3/1024-53*sqrt(51)*I*S5/1024-105*sqrt(5)*I*S7/1024+61*sqrt(57)*I*S9/1024",
            "-sqrt(7293)*(15*I*x**10*y-160*I*x**8*y**3-195*I*x**8*y*z**2+224*I*x**6*y**5+2240*I*x**6*y**3*z**2-210*I*x**6*y*z**4-224*x**5*y**6+3360*x**5*y**4*z**2-3360*x**5*y**2*z**4+224*x**5*z**6-3360*I*x**4*y**5*z**2+210*I*x**4*y*z**6+160*x**3*y**8-2240*x**3*y**6*z**2+2240*x**3*y**2*z**6-160*x**3*z**8+3360*I*x**2*y**5*z**4-2240*I*x**2*y**3*z**6+195*I*x**2*y*z**8-15*x*y**10+195*x*y**8*z**2+210*x*y**6*z**4-210*x*y**4*z**6-195*x*y**2*z**8+15*x*z**10-224*I*y**5*z**6+160*I*y**3*z**8-15*I*y*z**10)/512",
            "[3*sqrt(2926)/1024,0,0,0,105*sqrt(10)/1024,0,0,0,sqrt(595)/512,0,0,0,-15*sqrt(221)/512,0,0,0,53*sqrt(102)/1024,0,0,0,-61*sqrt(114)/1024,0,0]",
        ),
        "Qh(11,Eb,6,)": (
            "-21*sqrt(65)*C1/512-sqrt(248710)*C11/1024+57*sqrt(7)*C3/512-41*sqrt(30)*C5/1024+17*sqrt(34)*C7/1024+sqrt(9690)*C9/1024+21*sqrt(65)*I*S1/512-sqrt(248710)*I*S11/1024+57*sqrt(7)*I*S3/512+41*sqrt(30)*I*S5/1024+17*sqrt(34)*I*S7/1024-sqrt(9690)*I*S9/1024",
            "-sqrt(4290)*(21*I*x**10*y-128*x**9*y**2+128*x**9*z**2-336*I*x**8*y**3+63*I*x**8*y*z**2+768*x**7*y**4-768*x**7*z**4+1008*I*x**6*y**5-672*I*x**6*y**3*z**2+42*I*x**6*y*z**4-1008*x**5*y**6-1008*x**5*y**4*z**2+1008*x**5*y**2*z**4+1008*x**5*z**6-768*I*x**4*y**7+1008*I*x**4*y**5*z**2-42*I*x**4*y*z**6+336*x**3*y**8+672*x**3*y**6*z**2-672*x**3*y**2*z**6-336*x**3*z**8+128*I*x**2*y**9-1008*I*x**2*y**5*z**4+672*I*x**2*y**3*z**6-63*I*x**2*y*z**8-21*x*y**10-63*x*y**8*z**2-42*x*y**6*z**4+42*x*y**4*z**6+63*x*y**2*z**8+21*x*z**10-128*I*y**9*z**2+768*I*y**7*z**4-1008*I*y**5*z**6+336*I*y**3*z**8-21*I*y*z**10)/512",
            "[sqrt(124355)/512,0,0,0,-17*sqrt(17)/512,0,0,0,-57*sqrt(14)/512,0,0,0,-21*sqrt(130)/512,0,0,0,-41*sqrt(15)/512,0,0,0,sqrt(4845)/512,0,0]",
        ),
    },
    "C4h": {
        "Qh(0,Ag,,)": ("C0", "1", "[1]"),
        "Qh(1,Au,,)": ("C0", "z", "[0,1,0]"),
        "Qh(1,Eua,,)": ("sqrt(2)*C1/2+sqrt(2)*I*S1/2", "sqrt(2)*(x+I*y)/2", "[-1,0,0]"),
        "Qh(1,Eub,,)": ("sqrt(2)*C1/2-sqrt(2)*I*S1/2", "sqrt(2)*(x-I*y)/2", "[0,0,1]"),
        "Qh(2,Ag,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(2,Bg,1,)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(2,Bg,2,)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Qh(2,Ega,,)": ("-sqrt(2)*I*C1/2+sqrt(2)*S1/2", "-sqrt(6)*z*(I*x-y)/2", "[0,I,0,0,0]"),
        "Qh(2,Egb,,)": ("sqrt(2)*I*C1/2+sqrt(2)*S1/2", "sqrt(6)*z*(I*x+y)/2", "[0,0,0,I,0]"),
        "Qh(3,Au,,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(3,Bu,1,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(3,Bu,2,)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(3,Eua,1,)": (
            "-sqrt(3)*C1/4+sqrt(5)*C3/4-sqrt(3)*I*S1/4-sqrt(5)*I*S3/4",
            "sqrt(2)*(2*x**3-3*I*x**2*y-3*x*y**2-3*x*z**2+2*I*y**3-3*I*y*z**2)/4",
            "[0,0,sqrt(6)/4,0,0,0,sqrt(10)/4]",
        ),
        "Qh(3,Eua,2,)": (
            "-sqrt(5)*C1/4-sqrt(3)*C3/4-sqrt(5)*I*S1/4+sqrt(3)*I*S3/4",
            "sqrt(30)*(I*x**2*y+x*y**2-x*z**2-I*y*z**2)/4",
            "[0,0,sqrt(10)/4,0,0,0,-sqrt(6)/4]",
        ),
        "Qh(3,Eub,1,)": (
            "-sqrt(3)*C1/4+sqrt(5)*C3/4+sqrt(3)*I*S1/4+sqrt(5)*I*S3/4",
            "sqrt(2)*(2*x**3+3*I*x**2*y-3*x*y**2-3*x*z**2-2*I*y**3+3*I*y*z**2)/4",
            "[-sqrt(10)/4,0,0,0,-sqrt(6)/4,0,0]",
        ),
        "Qh(3,Eub,2,)": (
            "-sqrt(5)*C1/4-sqrt(3)*C3/4+sqrt(5)*I*S1/4-sqrt(3)*I*S3/4",
            "-sqrt(30)*(I*x**2*y-x*y**2+x*z**2-I*y*z**2)/4",
            "[sqrt(6)/4,0,0,0,-sqrt(10)/4,0,0]",
        ),
        "Qh(4,Ag,1,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Qh(4,Ag,2,)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "-sqrt(15)*(x**4-12*x**2*y**2+6*x**2*z**2+y**4+6*y**2*z**2-2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Qh(4,Ag,3,)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(4,Bg,1,)": ("-C2", "sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Qh(4,Bg,2,)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(4,Ega,1,)": (
            "sqrt(7)*I*C1/4-I*C3/4-sqrt(7)*S1/4-S3/4",
            "-sqrt(70)*z*(I*x**3-I*x*z**2-y**3+y*z**2)/4",
            "[0,0,0,-sqrt(14)*I/4,0,0,0,-sqrt(2)*I/4,0]",
        ),
        "Qh(4,Ega,2,)": (
            "I*C1/4+sqrt(7)*I*C3/4-S1/4+sqrt(7)*S3/4",
            "sqrt(10)*z*(I*x**3+6*x**2*y-6*I*x*y**2+I*x*z**2-y**3-y*z**2)/4",
            "[0,0,0,-sqrt(2)*I/4,0,0,0,sqrt(14)*I/4,0]",
        ),
        "Qh(4,Egb,1,)": (
            "-sqrt(7)*I*C1/4+I*C3/4-sqrt(7)*S1/4-S3/4",
            "sqrt(70)*z*(I*x**3-I*x*z**2+y**3-y*z**2)/4",
            "[0,-sqrt(2)*I/4,0,0,0,-sqrt(14)*I/4,0,0,0]",
        ),
        "Qh(4,Egb,2,)": (
            "-I*C1/4-sqrt(7)*I*C3/4-S1/4+sqrt(7)*S3/4",
            "-sqrt(10)*z*(I*x**3-6*x**2*y-6*I*x*y**2+I*x*z**2+y**3+y*z**2)/4",
            "[0,sqrt(14)*I/4,0,0,0,-sqrt(2)*I/4,0,0,0]",
        ),
        "Qh(5,Au,1,)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(5,Au,2,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(5,Au,3,)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(5,Bu,1,)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(5,Bu,2,)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(5,Eua,1,)": (
            "sqrt(30)*C1/16-sqrt(35)*C3/16+3*sqrt(7)*C5/16+sqrt(30)*I*S1/16+sqrt(35)*I*S3/16+3*sqrt(7)*I*S5/16",
            "sqrt(2)*(8*x**5+15*I*x**4*y-40*x**3*y**2-40*x**3*z**2-40*I*x**2*y**3+30*I*x**2*y*z**2+15*x*y**4+30*x*y**2*z**2+15*x*z**4+8*I*y**5-40*I*y**3*z**2+15*I*y*z**4)/16",
            "[-3*sqrt(14)/16,0,0,0,-sqrt(15)/8,0,0,0,-sqrt(70)/16,0,0]",
        ),
        "Qh(5,Eua,2,)": (
            "sqrt(42)*C1/16+9*C3/16+sqrt(5)*C5/16+sqrt(42)*I*S1/16-9*I*S3/16+sqrt(5)*I*S5/16",
            "3*sqrt(70)*(I*x**4*y-6*I*x**2*y*z**2+x*y**4-6*x*y**2*z**2+x*z**4+I*y*z**4)/16",
            "[-sqrt(10)/16,0,0,0,-sqrt(21)/8,0,0,0,9*sqrt(2)/16,0,0]",
        ),
        "Qh(5,Eua,3,)": (
            "sqrt(14)*C1/8-sqrt(3)*C3/8-sqrt(15)*C5/8+sqrt(14)*I*S1/8+sqrt(3)*I*S3/8-sqrt(15)*I*S5/8",
            "-sqrt(210)*(I*x**4*y-2*x**3*y**2+2*x**3*z**2-2*I*x**2*y**3+x*y**4-x*z**4+2*I*y**3*z**2-I*y*z**4)/8",
            "[sqrt(30)/8,0,0,0,-sqrt(7)/4,0,0,0,-sqrt(6)/8,0,0]",
        ),
        "Qh(5,Eub,1,)": (
            "sqrt(30)*C1/16-sqrt(35)*C3/16+3*sqrt(7)*C5/16-sqrt(30)*I*S1/16-sqrt(35)*I*S3/16-3*sqrt(7)*I*S5/16",
            "sqrt(2)*(8*x**5-15*I*x**4*y-40*x**3*y**2-40*x**3*z**2+40*I*x**2*y**3-30*I*x**2*y*z**2+15*x*y**4+30*x*y**2*z**2+15*x*z**4-8*I*y**5+40*I*y**3*z**2-15*I*y*z**4)/16",
            "[0,0,sqrt(70)/16,0,0,0,sqrt(15)/8,0,0,0,3*sqrt(14)/16]",
        ),
        "Qh(5,Eub,2,)": (
            "sqrt(42)*C1/16+9*C3/16+sqrt(5)*C5/16-sqrt(42)*I*S1/16+9*I*S3/16-sqrt(5)*I*S5/16",
            "-3*sqrt(70)*(I*x**4*y-6*I*x**2*y*z**2-x*y**4+6*x*y**2*z**2-x*z**4+I*y*z**4)/16",
            "[0,0,-9*sqrt(2)/16,0,0,0,sqrt(21)/8,0,0,0,sqrt(10)/16]",
        ),
        "Qh(5,Eub,3,)": (
            "sqrt(14)*C1/8-sqrt(3)*C3/8-sqrt(15)*C5/8-sqrt(14)*I*S1/8-sqrt(3)*I*S3/8+sqrt(15)*I*S5/8",
            "sqrt(210)*(I*x**4*y+2*x**3*y**2-2*x**3*z**2-2*I*x**2*y**3-x*y**4+x*z**4+2*I*y**3*z**2-I*y*z**4)/8",
            "[0,0,sqrt(6)/8,0,0,0,sqrt(7)/4,0,0,0,-sqrt(30)/8]",
        ),
        "Qh(6,Ag,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Qh(6,Ag,2,)": (
            "sqrt(14)*C0/4+sqrt(2)*C4/4",
            "-sqrt(14)*(x**6-15*x**4*z**2+15*x**2*z**4+y**6-15*y**4*z**2+15*y**2*z**4-2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Qh(6,Ag,3,)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(6,Bg,1,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Qh(6,Bg,2,)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x-y)*(x+y)*(x**4-9*x**2*y**2-5*x**2*z**2+y**4-5*y**2*z**2+5*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Qh(6,Bg,3,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(6,Bg,4,)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(6,Ega,1,)": (
            "-sqrt(6)*I*C1/8-sqrt(15)*I*C3/8+sqrt(11)*I*C5/8+sqrt(6)*S1/8-sqrt(15)*S3/8-sqrt(11)*S5/8",
            "3*sqrt(14)*z*(I*x**5-10*I*x**3*y**2+10*x**2*y**3-10*x**2*y*z**2+10*I*x*y**2*z**2-I*x*z**4-y**5+y*z**4)/8",
            "[0,-sqrt(22)*I/8,0,0,0,sqrt(3)*I/4,0,0,0,-sqrt(30)*I/8,0,0,0]",
        ),
        "Qh(6,Ega,2,)": (
            "-3*sqrt(11)*I*C1/16+sqrt(110)*I*C3/32-sqrt(6)*I*C5/32+3*sqrt(11)*S1/16+sqrt(110)*S3/32+sqrt(6)*S5/32",
            "-sqrt(231)*z*(3*I*x**5-10*I*x**3*z**2+3*I*x*z**4-3*y**5+10*y**3*z**2-3*y*z**4)/16",
            "[0,sqrt(3)*I/16,0,0,0,3*sqrt(22)*I/16,0,0,0,sqrt(55)*I/16,0,0,0]",
        ),
        "Qh(6,Ega,3,)": (
            "-sqrt(5)*I*C1/16-9*sqrt(2)*I*C3/32-sqrt(330)*I*C5/32+sqrt(5)*S1/16-9*sqrt(2)*S3/32+sqrt(330)*S5/32",
            "-sqrt(105)*z*(I*x**5-16*x**4*y-16*I*x**3*y**2+2*I*x**3*z**2+16*x**2*y**3+16*x**2*y*z**2+16*I*x*y**4-16*I*x*y**2*z**2+I*x*z**4-y**5-2*y**3*z**2-y*z**4)/16",
            "[0,sqrt(165)*I/16,0,0,0,sqrt(10)*I/16,0,0,0,-9*I/16,0,0,0]",
        ),
        "Qh(6,Egb,1,)": (
            "sqrt(6)*I*C1/8+sqrt(15)*I*C3/8-sqrt(11)*I*C5/8+sqrt(6)*S1/8-sqrt(15)*S3/8-sqrt(11)*S5/8",
            "-3*sqrt(14)*z*(I*x**5-10*I*x**3*y**2-10*x**2*y**3+10*x**2*y*z**2+10*I*x*y**2*z**2-I*x*z**4+y**5-y*z**4)/8",
            "[0,0,0,-sqrt(30)*I/8,0,0,0,sqrt(3)*I/4,0,0,0,-sqrt(22)*I/8,0]",
        ),
        "Qh(6,Egb,2,)": (
            "3*sqrt(11)*I*C1/16-sqrt(110)*I*C3/32+sqrt(6)*I*C5/32+3*sqrt(11)*S1/16+sqrt(110)*S3/32+sqrt(6)*S5/32",
            "sqrt(231)*z*(3*I*x**5-10*I*x**3*z**2+3*I*x*z**4+3*y**5-10*y**3*z**2+3*y*z**4)/16",
            "[0,0,0,sqrt(55)*I/16,0,0,0,3*sqrt(22)*I/16,0,0,0,sqrt(3)*I/16,0]",
        ),
        "Qh(6,Egb,3,)": (
            "sqrt(5)*I*C1/16+9*sqrt(2)*I*C3/32+sqrt(330)*I*C5/32+sqrt(5)*S1/16-9*sqrt(2)*S3/32+sqrt(330)*S5/32",
            "sqrt(105)*z*(I*x**5+16*x**4*y-16*I*x**3*y**2+2*I*x**3*z**2-16*x**2*y**3-16*x**2*y*z**2+16*I*x*y**4-16*I*x*y**2*z**2+I*x*z**4+y**5+2*y**3*z**2+y*z**4)/16",
            "[0,0,0,-9*I/16,0,0,0,sqrt(10)*I/16,0,0,0,sqrt(165)*I/16,0]",
        ),
        "Qh(7,Au,1,)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(7,Au,2,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(7,Au,3,)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(7,Bu,1,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Qh(7,Bu,2,)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "-sqrt(77)*x*y*z*(3*x**4-20*x**2*y**2+10*x**2*z**2+3*y**4+10*y**2*z**2-6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Qh(7,Bu,3,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(7,Bu,4,)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(7,Eua,1,)": (
            "-5*sqrt(14)*C1/64+3*sqrt(42)*C3/64-sqrt(462)*C5/64+sqrt(858)*C7/64-5*sqrt(14)*I*S1/64-3*sqrt(42)*I*S3/64-sqrt(462)*I*S5/64-sqrt(858)*I*S7/64",
            "sqrt(2)*(16*x**7-35*I*x**6*y-168*x**5*y**2-168*x**5*z**2+210*I*x**4*y**3-105*I*x**4*y*z**2+210*x**3*y**4+420*x**3*y**2*z**2+210*x**3*z**4-168*I*x**2*y**5+420*I*x**2*y**3*z**2-105*I*x**2*y*z**4-35*x*y**6-105*x*y**4*z**2-105*x*y**2*z**4-35*x*z**6+16*I*y**7-168*I*y**5*z**2+210*I*y**3*z**4-35*I*y*z**6)/32",
            "[0,0,sqrt(231)/32,0,0,0,5*sqrt(7)/32,0,0,0,3*sqrt(21)/32,0,0,0,sqrt(429)/32]",
        ),
        "Qh(7,Eua,2,)": (
            "-3*sqrt(66)*C1/64-sqrt(22)*C3/64+25*sqrt(2)*C5/64+sqrt(182)*C7/64-3*sqrt(66)*I*S1/64+sqrt(22)*I*S3/64+25*sqrt(2)*I*S5/64-sqrt(182)*I*S7/64",
            "-sqrt(462)*(3*I*x**6*y-10*I*x**4*y**3-15*I*x**4*y*z**2-10*x**3*y**4+60*x**3*y**2*z**2-10*x**3*z**4+60*I*x**2*y**3*z**2-15*I*x**2*y*z**4+3*x*y**6-15*x*y**4*z**2-15*x*y**2*z**4+3*x*z**6-10*I*y**3*z**4+3*I*y*z**6)/32",
            "[0,0,-25/32,0,0,0,3*sqrt(33)/32,0,0,0,-sqrt(11)/32,0,0,0,sqrt(91)/32]",
        ),
        "Qh(7,Eua,3,)": (
            "-sqrt(429)*C1/64-3*sqrt(143)*C3/64-5*sqrt(13)*C5/64-sqrt(7)*C7/64-sqrt(429)*I*S1/64+3*sqrt(143)*I*S3/64-5*sqrt(13)*I*S5/64+sqrt(7)*I*S7/64",
            "sqrt(3003)*(I*x**6*y-15*I*x**4*y*z**2+15*I*x**2*y*z**4+x*y**6-15*x*y**4*z**2+15*x*y**2*z**4-x*z**6-I*y*z**6)/32",
            "[0,0,5*sqrt(26)/64,0,0,0,sqrt(858)/64,0,0,0,-3*sqrt(286)/64,0,0,0,-sqrt(14)/64]",
        ),
        "Qh(7,Eua,4,)": (
            "-15*sqrt(3)*C1/64+19*C3/64-sqrt(11)*C5/64-sqrt(1001)*C7/64-15*sqrt(3)*I*S1/64-19*I*S3/64-sqrt(11)*I*S5/64+sqrt(1001)*I*S7/64",
            "sqrt(21)*(15*I*x**6*y+48*x**5*y**2-48*x**5*z**2-80*I*x**4*y**3+15*I*x**4*y*z**2-80*x**3*y**4+80*x**3*z**4+48*I*x**2*y**5-15*I*x**2*y*z**4+15*x*y**6+15*x*y**4*z**2-15*x*y**2*z**4-15*x*z**6-48*I*y**5*z**2+80*I*y**3*z**4-15*I*y*z**6)/32",
            "[0,0,sqrt(22)/64,0,0,0,15*sqrt(6)/64,0,0,0,19*sqrt(2)/64,0,0,0,-sqrt(2002)/64]",
        ),
        "Qh(7,Eub,1,)": (
            "-5*sqrt(14)*C1/64+3*sqrt(42)*C3/64-sqrt(462)*C5/64+sqrt(858)*C7/64+5*sqrt(14)*I*S1/64+3*sqrt(42)*I*S3/64+sqrt(462)*I*S5/64+sqrt(858)*I*S7/64",
            "sqrt(2)*(16*x**7+35*I*x**6*y-168*x**5*y**2-168*x**5*z**2-210*I*x**4*y**3+105*I*x**4*y*z**2+210*x**3*y**4+420*x**3*y**2*z**2+210*x**3*z**4+168*I*x**2*y**5-420*I*x**2*y**3*z**2+105*I*x**2*y*z**4-35*x*y**6-105*x*y**4*z**2-105*x*y**2*z**4-35*x*z**6-16*I*y**7+168*I*y**5*z**2-210*I*y**3*z**4+35*I*y*z**6)/32",
            "[-sqrt(429)/32,0,0,0,-3*sqrt(21)/32,0,0,0,-5*sqrt(7)/32,0,0,0,-sqrt(231)/32,0,0]",
        ),
        "Qh(7,Eub,2,)": (
            "-3*sqrt(66)*C1/64-sqrt(22)*C3/64+25*sqrt(2)*C5/64+sqrt(182)*C7/64+3*sqrt(66)*I*S1/64-sqrt(22)*I*S3/64-25*sqrt(2)*I*S5/64+sqrt(182)*I*S7/64",
            "sqrt(462)*(3*I*x**6*y-10*I*x**4*y**3-15*I*x**4*y*z**2+10*x**3*y**4-60*x**3*y**2*z**2+10*x**3*z**4+60*I*x**2*y**3*z**2-15*I*x**2*y*z**4-3*x*y**6+15*x*y**4*z**2+15*x*y**2*z**4-3*x*z**6-10*I*y**3*z**4+3*I*y*z**6)/32",
            "[-sqrt(91)/32,0,0,0,sqrt(11)/32,0,0,0,-3*sqrt(33)/32,0,0,0,25/32,0,0]",
        ),
        "Qh(7,Eub,3,)": (
            "-sqrt(429)*C1/64-3*sqrt(143)*C3/64-5*sqrt(13)*C5/64-sqrt(7)*C7/64+sqrt(429)*I*S1/64-3*sqrt(143)*I*S3/64+5*sqrt(13)*I*S5/64-sqrt(7)*I*S7/64",
            "-sqrt(3003)*(I*x**6*y-15*I*x**4*y*z**2+15*I*x**2*y*z**4-x*y**6+15*x*y**4*z**2-15*x*y**2*z**4+x*z**6-I*y*z**6)/32",
            "[sqrt(14)/64,0,0,0,3*sqrt(286)/64,0,0,0,-sqrt(858)/64,0,0,0,-5*sqrt(26)/64,0,0]",
        ),
        "Qh(7,Eub,4,)": (
            "-15*sqrt(3)*C1/64+19*C3/64-sqrt(11)*C5/64-sqrt(1001)*C7/64+15*sqrt(3)*I*S1/64+19*I*S3/64+sqrt(11)*I*S5/64-sqrt(1001)*I*S7/64",
            "-sqrt(21)*(15*I*x**6*y-48*x**5*y**2+48*x**5*z**2-80*I*x**4*y**3+15*I*x**4*y*z**2+80*x**3*y**4-80*x**3*z**4+48*I*x**2*y**5-15*I*x**2*y*z**4-15*x*y**6-15*x*y**4*z**2+15*x*y**2*z**4+15*x*z**6-48*I*y**5*z**2+80*I*y**3*z**4-15*I*y*z**6)/32",
            "[sqrt(2002)/64,0,0,0,-19*sqrt(2)/64,0,0,0,-15*sqrt(6)/64,0,0,0,-sqrt(22)/64,0,0]",
        ),
        "Qh(8,Ag,1,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Qh(8,Ag,2,)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Qh(8,Ag,3,)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Qh(8,Ag,4,)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(8,Ag,5,)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(8,Bg,1,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(8,Bg,2,)": (
            "C2",
            "-3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(8,Bg,3,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(8,Bg,4,)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(8,Ega,1,)": (
            "sqrt(1430)*I*C1/64-sqrt(546)*I*C3/64+sqrt(70)*I*C5/64-sqrt(2)*I*C7/64-sqrt(1430)*S1/64-sqrt(546)*S3/64-sqrt(70)*S5/64-sqrt(2)*S7/64",
            "-3*sqrt(1430)*z*(I*x**7-7*I*x**5*z**2+7*I*x**3*z**4-I*x*z**6-y**7+7*y**5*z**2-7*y**3*z**4+y*z**6)/32",
            "[0,0,0,-sqrt(35)*I/32,0,0,0,-sqrt(715)*I/32,0,0,0,-sqrt(273)*I/32,0,0,0,-I/32,0]",
        ),
        "Qh(8,Ega,2,)": (
            "sqrt(154)*I*C1/64+5*sqrt(30)*I*C3/64+3*sqrt(26)*I*C5/64-sqrt(910)*I*C7/64-sqrt(154)*S1/64+5*sqrt(30)*S3/64-3*sqrt(26)*S5/64-sqrt(910)*S7/64",
            "-3*sqrt(154)*z*(I*x**7-24*I*x**5*y**2+I*x**5*z**2-40*x**4*y**3+40*x**4*y*z**2+40*I*x**3*y**4-I*x**3*z**4+24*x**2*y**5-24*x**2*y*z**4-40*I*x*y**4*z**2+24*I*x*y**2*z**4-I*x*z**6-y**7-y**5*z**2+y**3*z**4+y*z**6)/32",
            "[0,0,0,-3*sqrt(13)*I/32,0,0,0,-sqrt(77)*I/32,0,0,0,5*sqrt(15)*I/32,0,0,0,-sqrt(455)*I/32,0]",
        ),
        "Qh(8,Ega,3,)": (
            "sqrt(429)*I*C1/64+sqrt(455)*I*C3/64-7*sqrt(21)*I*C5/64+3*sqrt(15)*I*C7/64-sqrt(429)*S1/64+sqrt(455)*S3/64+7*sqrt(21)*S5/64+3*sqrt(15)*S7/64",
            "sqrt(429)*z*(3*I*x**7-42*I*x**5*y**2-7*I*x**5*z**2+140*I*x**3*y**2*z**2-7*I*x**3*z**4+42*x**2*y**5-140*x**2*y**3*z**2+42*x**2*y*z**4-42*I*x*y**2*z**4+3*I*x*z**6-3*y**7+7*y**5*z**2+7*y**3*z**4-3*y*z**6)/32",
            "[0,0,0,7*sqrt(42)*I/64,0,0,0,-sqrt(858)*I/64,0,0,0,sqrt(910)*I/64,0,0,0,3*sqrt(30)*I/64,0]",
        ),
        "Qh(8,Ega,4,)": (
            "sqrt(35)*I*C1/64+3*sqrt(33)*I*C3/64+sqrt(715)*I*C5/64+sqrt(1001)*I*C7/64-sqrt(35)*S1/64+3*sqrt(33)*S3/64-sqrt(715)*S5/64+sqrt(1001)*S7/64",
            "3*sqrt(35)*z*(I*x**7+32*x**6*y-30*I*x**5*y**2+3*I*x**5*z**2-80*x**4*y**3-80*x**4*y*z**2+80*I*x**3*y**4-60*I*x**3*y**2*z**2+3*I*x**3*z**4+30*x**2*y**5+60*x**2*y**3*z**2+30*x**2*y*z**4-32*I*x*y**6+80*I*x*y**4*z**2-30*I*x*y**2*z**4+I*x*z**6-y**7-3*y**5*z**2-3*y**3*z**4-y*z**6)/32",
            "[0,0,0,-sqrt(1430)*I/64,0,0,0,-sqrt(70)*I/64,0,0,0,3*sqrt(66)*I/64,0,0,0,sqrt(2002)*I/64,0]",
        ),
        "Qh(8,Egb,1,)": (
            "-sqrt(1430)*I*C1/64+sqrt(546)*I*C3/64-sqrt(70)*I*C5/64+sqrt(2)*I*C7/64-sqrt(1430)*S1/64-sqrt(546)*S3/64-sqrt(70)*S5/64-sqrt(2)*S7/64",
            "3*sqrt(1430)*z*(I*x**7-7*I*x**5*z**2+7*I*x**3*z**4-I*x*z**6+y**7-7*y**5*z**2+7*y**3*z**4-y*z**6)/32",
            "[0,-I/32,0,0,0,-sqrt(273)*I/32,0,0,0,-sqrt(715)*I/32,0,0,0,-sqrt(35)*I/32,0,0,0]",
        ),
        "Qh(8,Egb,2,)": (
            "-sqrt(154)*I*C1/64-5*sqrt(30)*I*C3/64-3*sqrt(26)*I*C5/64+sqrt(910)*I*C7/64-sqrt(154)*S1/64+5*sqrt(30)*S3/64-3*sqrt(26)*S5/64-sqrt(910)*S7/64",
            "3*sqrt(154)*z*(I*x**7-24*I*x**5*y**2+I*x**5*z**2+40*x**4*y**3-40*x**4*y*z**2+40*I*x**3*y**4-I*x**3*z**4-24*x**2*y**5+24*x**2*y*z**4-40*I*x*y**4*z**2+24*I*x*y**2*z**4-I*x*z**6+y**7+y**5*z**2-y**3*z**4-y*z**6)/32",
            "[0,-sqrt(455)*I/32,0,0,0,5*sqrt(15)*I/32,0,0,0,-sqrt(77)*I/32,0,0,0,-3*sqrt(13)*I/32,0,0,0]",
        ),
        "Qh(8,Egb,3,)": (
            "-sqrt(429)*I*C1/64-sqrt(455)*I*C3/64+7*sqrt(21)*I*C5/64-3*sqrt(15)*I*C7/64-sqrt(429)*S1/64+sqrt(455)*S3/64+7*sqrt(21)*S5/64+3*sqrt(15)*S7/64",
            "-sqrt(429)*z*(3*I*x**7-42*I*x**5*y**2-7*I*x**5*z**2+140*I*x**3*y**2*z**2-7*I*x**3*z**4-42*x**2*y**5+140*x**2*y**3*z**2-42*x**2*y*z**4-42*I*x*y**2*z**4+3*I*x*z**6+3*y**7-7*y**5*z**2-7*y**3*z**4+3*y*z**6)/32",
            "[0,3*sqrt(30)*I/64,0,0,0,sqrt(910)*I/64,0,0,0,-sqrt(858)*I/64,0,0,0,7*sqrt(42)*I/64,0,0,0]",
        ),
        "Qh(8,Egb,4,)": (
            "-sqrt(35)*I*C1/64-3*sqrt(33)*I*C3/64-sqrt(715)*I*C5/64-sqrt(1001)*I*C7/64-sqrt(35)*S1/64+3*sqrt(33)*S3/64-sqrt(715)*S5/64+sqrt(1001)*S7/64",
            "-3*sqrt(35)*z*(I*x**7-32*x**6*y-30*I*x**5*y**2+3*I*x**5*z**2+80*x**4*y**3+80*x**4*y*z**2+80*I*x**3*y**4-60*I*x**3*y**2*z**2+3*I*x**3*z**4-30*x**2*y**5-60*x**2*y**3*z**2-30*x**2*y*z**4-32*I*x*y**6+80*I*x*y**4*z**2-30*I*x*y**2*z**4+I*x*z**6+y**7+3*y**5*z**2+3*y**3*z**4+y*z**6)/32",
            "[0,sqrt(2002)*I/64,0,0,0,3*sqrt(66)*I/64,0,0,0,-sqrt(70)*I/64,0,0,0,-sqrt(1430)*I/64,0,0,0]",
        ),
        "Qh(9,Au,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Qh(9,Au,2,)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(x-y)*(x+y)*(3*x**4-11*x**2*y**2-7*x**2*z**2+3*y**4-7*y**2*z**2+7*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Qh(9,Au,3,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Au,4,)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,Au,5,)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(9,Bu,1,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Qh(9,Bu,2,)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Qh(9,Bu,3,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,Bu,4,)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Eua,1,)": (
            "21*sqrt(10)*C1/256-sqrt(1155)*C3/128+3*sqrt(143)*C5/128-3*sqrt(715)*C7/256+sqrt(12155)*C9/256+21*sqrt(10)*I*S1/256+sqrt(1155)*I*S3/128+3*sqrt(143)*I*S5/128+3*sqrt(715)*I*S7/256+sqrt(12155)*I*S9/256",
            "sqrt(2)*(128*x**9+315*I*x**8*y-2304*x**7*y**2-2304*x**7*z**2-3360*I*x**6*y**3+1260*I*x**6*y*z**2+6048*x**5*y**4+12096*x**5*y**2*z**2+6048*x**5*z**4+6048*I*x**4*y**5-10080*I*x**4*y**3*z**2+1890*I*x**4*y*z**4-3360*x**3*y**6-10080*x**3*y**4*z**2-10080*x**3*y**2*z**4-3360*x**3*z**6-2304*I*x**2*y**7+12096*I*x**2*y**5*z**2-10080*I*x**2*y**3*z**4+1260*I*x**2*y*z**6+315*x*y**8+1260*x*y**6*z**2+1890*x*y**4*z**4+1260*x*y**2*z**6+315*x*z**8+128*I*y**9-2304*I*y**7*z**2+6048*I*y**5*z**4-3360*I*y**3*z**6+315*I*y*z**8)/256",
            "[-sqrt(24310)/256,0,0,0,-3*sqrt(286)/128,0,0,0,-21*sqrt(5)/128,0,0,0,-sqrt(2310)/128,0,0,0,-3*sqrt(1430)/256,0,0]",
        ),
        "Qh(9,Eua,2,)": (
            "sqrt(4862)*C1/256+sqrt(4641)*C3/128+5*sqrt(85)*C5/128+7*sqrt(17)*C7/256+3*C9/256+sqrt(4862)*I*S1/256-sqrt(4641)*I*S3/128+5*sqrt(85)*I*S5/128-7*sqrt(17)*I*S7/256+3*I*S9/256",
            "3*sqrt(24310)*(I*x**8*y-28*I*x**6*y*z**2+70*I*x**4*y*z**4-28*I*x**2*y*z**6+x*y**8-28*x*y**6*z**2+70*x*y**4*z**4-28*x*y**2*z**6+x*z**8+I*y*z**8)/256",
            "[-3*sqrt(2)/256,0,0,0,-5*sqrt(170)/128,0,0,0,-sqrt(2431)/128,0,0,0,sqrt(9282)/128,0,0,0,7*sqrt(34)/256,0,0]",
        ),
        "Qh(9,Eua,3,)": (
            "sqrt(2002)*C1/128-sqrt(39)*C3/64-3*sqrt(35)*C5/64+23*sqrt(7)*C7/128+3*sqrt(119)*C9/128+sqrt(2002)*I*S1/128+sqrt(39)*I*S3/64-3*sqrt(35)*I*S5/64-23*sqrt(7)*I*S7/128+3*sqrt(119)*I*S9/128",
            "3*sqrt(10010)*(I*x**8*y-8*I*x**6*y**3-4*I*x**6*y*z**2+8*x**5*y**4-48*x**5*y**2*z**2+8*x**5*z**4+8*I*x**4*y**5+40*I*x**4*y**3*z**2-10*I*x**4*y*z**4-8*x**3*y**6+40*x**3*y**4*z**2+40*x**3*y**2*z**4-8*x**3*z**6-48*I*x**2*y**5*z**2+40*I*x**2*y**3*z**4-4*I*x**2*y*z**6+x*y**8-4*x*y**6*z**2-10*x*y**4*z**4-4*x*y**2*z**6+x*z**8+8*I*y**5*z**4-8*I*y**3*z**6+I*y*z**8)/128",
            "[-3*sqrt(238)/128,0,0,0,3*sqrt(70)/64,0,0,0,-sqrt(1001)/64,0,0,0,-sqrt(78)/64,0,0,0,23*sqrt(14)/128,0,0]",
        ),
        "Qh(9,Eua,4,)": (
            "sqrt(429)*C1/64+sqrt(182)*C3/64-5*sqrt(30)*C5/64-21*sqrt(6)*C7/128-sqrt(102)*C9/128+sqrt(429)*I*S1/64-sqrt(182)*I*S3/64-5*sqrt(30)*I*S5/64+21*sqrt(6)*I*S7/128-sqrt(102)*I*S9/128",
            "-sqrt(2145)*(3*I*x**8*y-14*I*x**6*y**3-42*I*x**6*y*z**2+210*I*x**4*y**3*z**2-14*x**3*y**6+210*x**3*y**4*z**2-210*x**3*y**2*z**4+14*x**3*z**6-210*I*x**2*y**3*z**4+42*I*x**2*y*z**6+3*x*y**8-42*x*y**6*z**2+42*x*y**2*z**6-3*x*z**8+14*I*y**3*z**6-3*I*y*z**8)/64",
            "[sqrt(51)/64,0,0,0,5*sqrt(15)/32,0,0,0,-sqrt(858)/64,0,0,0,sqrt(91)/32,0,0,0,-21*sqrt(3)/64,0,0]",
        ),
        "Qh(9,Eua,5,)": (
            "7*sqrt(11)*C1/64-3*sqrt(42)*C3/64+sqrt(130)*C5/64+sqrt(26)*C7/128-3*sqrt(442)*C9/128+7*sqrt(11)*I*S1/64+3*sqrt(42)*I*S3/64+sqrt(130)*I*S5/64-sqrt(26)*I*S7/128-3*sqrt(442)*I*S9/128",
            "-3*sqrt(55)*(7*I*x**8*y-32*x**7*y**2+32*x**7*z**2-70*I*x**6*y**3+14*I*x**6*y*z**2+112*x**5*y**4-112*x**5*z**4+112*I*x**4*y**5-70*I*x**4*y**3*z**2-70*x**3*y**6-70*x**3*y**4*z**2+70*x**3*y**2*z**4+70*x**3*z**6-32*I*x**2*y**7+70*I*x**2*y**3*z**4-14*I*x**2*y*z**6+7*x*y**8+14*x*y**6*z**2-14*x*y**2*z**6-7*x*z**8+32*I*y**7*z**2-112*I*y**5*z**4+70*I*y**3*z**6-7*I*y*z**8)/64",
            "[3*sqrt(221)/64,0,0,0,-sqrt(65)/32,0,0,0,-7*sqrt(22)/64,0,0,0,-3*sqrt(21)/32,0,0,0,sqrt(13)/64,0,0]",
        ),
        "Qh(9,Eub,1,)": (
            "21*sqrt(10)*C1/256-sqrt(1155)*C3/128+3*sqrt(143)*C5/128-3*sqrt(715)*C7/256+sqrt(12155)*C9/256-21*sqrt(10)*I*S1/256-sqrt(1155)*I*S3/128-3*sqrt(143)*I*S5/128-3*sqrt(715)*I*S7/256-sqrt(12155)*I*S9/256",
            "sqrt(2)*(128*x**9-315*I*x**8*y-2304*x**7*y**2-2304*x**7*z**2+3360*I*x**6*y**3-1260*I*x**6*y*z**2+6048*x**5*y**4+12096*x**5*y**2*z**2+6048*x**5*z**4-6048*I*x**4*y**5+10080*I*x**4*y**3*z**2-1890*I*x**4*y*z**4-3360*x**3*y**6-10080*x**3*y**4*z**2-10080*x**3*y**2*z**4-3360*x**3*z**6+2304*I*x**2*y**7-12096*I*x**2*y**5*z**2+10080*I*x**2*y**3*z**4-1260*I*x**2*y*z**6+315*x*y**8+1260*x*y**6*z**2+1890*x*y**4*z**4+1260*x*y**2*z**6+315*x*z**8-128*I*y**9+2304*I*y**7*z**2-6048*I*y**5*z**4+3360*I*y**3*z**6-315*I*y*z**8)/256",
            "[0,0,3*sqrt(1430)/256,0,0,0,sqrt(2310)/128,0,0,0,21*sqrt(5)/128,0,0,0,3*sqrt(286)/128,0,0,0,sqrt(24310)/256]",
        ),
        "Qh(9,Eub,2,)": (
            "sqrt(4862)*C1/256+sqrt(4641)*C3/128+5*sqrt(85)*C5/128+7*sqrt(17)*C7/256+3*C9/256-sqrt(4862)*I*S1/256+sqrt(4641)*I*S3/128-5*sqrt(85)*I*S5/128+7*sqrt(17)*I*S7/256-3*I*S9/256",
            "-3*sqrt(24310)*(I*x**8*y-28*I*x**6*y*z**2+70*I*x**4*y*z**4-28*I*x**2*y*z**6-x*y**8+28*x*y**6*z**2-70*x*y**4*z**4+28*x*y**2*z**6-x*z**8+I*y*z**8)/256",
            "[0,0,-7*sqrt(34)/256,0,0,0,-sqrt(9282)/128,0,0,0,sqrt(2431)/128,0,0,0,5*sqrt(170)/128,0,0,0,3*sqrt(2)/256]",
        ),
        "Qh(9,Eub,3,)": (
            "sqrt(2002)*C1/128-sqrt(39)*C3/64-3*sqrt(35)*C5/64+23*sqrt(7)*C7/128+3*sqrt(119)*C9/128-sqrt(2002)*I*S1/128-sqrt(39)*I*S3/64+3*sqrt(35)*I*S5/64+23*sqrt(7)*I*S7/128-3*sqrt(119)*I*S9/128",
            "-3*sqrt(10010)*(I*x**8*y-8*I*x**6*y**3-4*I*x**6*y*z**2-8*x**5*y**4+48*x**5*y**2*z**2-8*x**5*z**4+8*I*x**4*y**5+40*I*x**4*y**3*z**2-10*I*x**4*y*z**4+8*x**3*y**6-40*x**3*y**4*z**2-40*x**3*y**2*z**4+8*x**3*z**6-48*I*x**2*y**5*z**2+40*I*x**2*y**3*z**4-4*I*x**2*y*z**6-x*y**8+4*x*y**6*z**2+10*x*y**4*z**4+4*x*y**2*z**6-x*z**8+8*I*y**5*z**4-8*I*y**3*z**6+I*y*z**8)/128",
            "[0,0,-23*sqrt(14)/128,0,0,0,sqrt(78)/64,0,0,0,sqrt(1001)/64,0,0,0,-3*sqrt(70)/64,0,0,0,3*sqrt(238)/128]",
        ),
        "Qh(9,Eub,4,)": (
            "sqrt(429)*C1/64+sqrt(182)*C3/64-5*sqrt(30)*C5/64-21*sqrt(6)*C7/128-sqrt(102)*C9/128-sqrt(429)*I*S1/64+sqrt(182)*I*S3/64+5*sqrt(30)*I*S5/64-21*sqrt(6)*I*S7/128+sqrt(102)*I*S9/128",
            "sqrt(2145)*(3*I*x**8*y-14*I*x**6*y**3-42*I*x**6*y*z**2+210*I*x**4*y**3*z**2+14*x**3*y**6-210*x**3*y**4*z**2+210*x**3*y**2*z**4-14*x**3*z**6-210*I*x**2*y**3*z**4+42*I*x**2*y*z**6-3*x*y**8+42*x*y**6*z**2-42*x*y**2*z**6+3*x*z**8+14*I*y**3*z**6-3*I*y*z**8)/64",
            "[0,0,21*sqrt(3)/64,0,0,0,-sqrt(91)/32,0,0,0,sqrt(858)/64,0,0,0,-5*sqrt(15)/32,0,0,0,-sqrt(51)/64]",
        ),
        "Qh(9,Eub,5,)": (
            "7*sqrt(11)*C1/64-3*sqrt(42)*C3/64+sqrt(130)*C5/64+sqrt(26)*C7/128-3*sqrt(442)*C9/128-7*sqrt(11)*I*S1/64-3*sqrt(42)*I*S3/64-sqrt(130)*I*S5/64+sqrt(26)*I*S7/128+3*sqrt(442)*I*S9/128",
            "3*sqrt(55)*(7*I*x**8*y+32*x**7*y**2-32*x**7*z**2-70*I*x**6*y**3+14*I*x**6*y*z**2-112*x**5*y**4+112*x**5*z**4+112*I*x**4*y**5-70*I*x**4*y**3*z**2+70*x**3*y**6+70*x**3*y**4*z**2-70*x**3*y**2*z**4-70*x**3*z**6-32*I*x**2*y**7+70*I*x**2*y**3*z**4-14*I*x**2*y*z**6-7*x*y**8-14*x*y**6*z**2+14*x*y**2*z**6+7*x*z**8+32*I*y**7*z**2-112*I*y**5*z**4+70*I*y**3*z**6-7*I*y*z**8)/64",
            "[0,0,-sqrt(13)/64,0,0,0,3*sqrt(21)/32,0,0,0,7*sqrt(22)/64,0,0,0,sqrt(65)/32,0,0,0,-3*sqrt(221)/64]",
        ),
        "Qh(10,Ag,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Qh(10,Ag,2,)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "-sqrt(420189)*(22*x**10+45*x**8*y**2-1035*x**8*z**2-105*x**6*y**4-630*x**6*y**2*z**2+4935*x**6*z**4-105*x**4*y**6+3150*x**4*y**4*z**2-1575*x**4*y**2*z**4-4830*x**4*z**6+45*x**2*y**8-630*x**2*y**6*z**2-1575*x**2*y**4*z**4+1260*x**2*y**2*z**6+990*x**2*z**8+22*y**10-1035*y**8*z**2+4935*y**6*z**4-4830*y**4*z**6+990*y**2*z**8-44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Qh(10,Ag,3,)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "-sqrt(3213210)*(3*x**10-96*x**8*y**2-39*x**8*z**2+224*x**6*y**4+1344*x**6*y**2*z**2-42*x**6*z**4+224*x**4*y**6-6720*x**4*y**4*z**2+3360*x**4*y**2*z**4-182*x**4*z**6-96*x**2*y**8+1344*x**2*y**6*z**2+3360*x**2*y**4*z**4-2688*x**2*y**2*z**6+135*x**2*z**8+3*y**10-39*y**8*z**2-42*y**6*z**4-182*y**4*z**6+135*y**2*z**8-6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Qh(10,Ag,4,)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(10,Ag,5,)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(10,Bg,1,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Qh(10,Bg,2,)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(x-y)*(x+y)*(22*x**8-653*x**6*y**2-315*x**6*z**2+2602*x**4*y**4-945*x**4*y**2*z**2+1575*x**4*z**4-653*x**2*y**6-945*x**2*y**4*z**2+3150*x**2*y**2*z**4-1680*x**2*z**6+22*y**8-315*y**6*z**2+1575*y**4*z**4-1680*y**2*z**6+360*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Qh(10,Bg,3,)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(x-y)*(x+y)*(9*x**8-165*x**6*y**2-231*x**6*z**2-25*x**4*y**4+3801*x**4*y**2*z**2+406*x**4*z**4-165*x**2*y**6+3801*x**2*y**4*z**2-9674*x**2*y**2*z**4+266*x**2*z**6+9*y**8-231*y**6*z**2+406*y**4*z**4+266*y**2*z**6-57*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Qh(10,Bg,4,)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(10,Bg,5,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,Bg,6,)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Ega,1,)": (
            "-sqrt(442)*I*C1/64-sqrt(51)*I*C3/32+sqrt(255)*I*C5/32-11*sqrt(3)*I*C7/64+sqrt(19)*I*C9/64+sqrt(442)*S1/64-sqrt(51)*S3/32-sqrt(255)*S5/32-11*sqrt(3)*S7/64-sqrt(19)*S9/64",
            "sqrt(24310)*z*(I*x**9-18*I*x**7*y**2-6*I*x**7*z**2+126*I*x**5*y**2*z**2-126*I*x**3*y**2*z**4+6*I*x**3*z**6+18*x**2*y**7-126*x**2*y**5*z**2+126*x**2*y**3*z**4-18*x**2*y*z**6+18*I*x*y**2*z**6-I*x*z**8-y**9+6*y**7*z**2-6*y**3*z**6+y*z**8)/64",
            "[0,-sqrt(38)*I/64,0,0,0,-sqrt(510)*I/32,0,0,0,sqrt(221)*I/32,0,0,0,-sqrt(102)*I/32,0,0,0,-11*sqrt(6)*I/64,0,0,0]",
        ),
        "Qh(10,Ega,2,)": (
            "-sqrt(78)*I*C1/64-11*I*C3/32-5*sqrt(5)*I*C5/32-sqrt(17)*I*C7/64+sqrt(969)*I*C9/64+sqrt(78)*S1/64-11*S3/32+5*sqrt(5)*S5/32-sqrt(17)*S7/64-sqrt(969)*S9/64",
            "sqrt(4290)*z*(I*x**9-42*I*x**7*y**2+2*I*x**7*z**2+112*x**6*y**3-112*x**6*y*z**2+168*I*x**5*y**4-42*I*x**5*y**2*z**2-168*x**4*y**5+168*x**4*y*z**4-112*I*x**3*y**6+42*I*x**3*y**2*z**4-2*I*x**3*z**6+42*x**2*y**7+42*x**2*y**5*z**2-42*x**2*y**3*z**4-42*x**2*y*z**6+112*I*x*y**6*z**2-168*I*x*y**4*z**4+42*I*x*y**2*z**6-I*x*z**8-y**9-2*y**7*z**2+2*y**3*z**6+y*z**8)/64",
            "[0,-sqrt(1938)*I/64,0,0,0,5*sqrt(10)*I/32,0,0,0,sqrt(39)*I/32,0,0,0,-11*sqrt(2)*I/32,0,0,0,-sqrt(34)*I/64,0,0,0]",
        ),
        "Qh(10,Ega,3,)": (
            "-sqrt(20995)*I*C1/256+sqrt(9690)*I*C3/256-sqrt(1938)*I*C5/256+sqrt(570)*I*C7/512-sqrt(10)*I*C9/512+sqrt(20995)*S1/256+sqrt(9690)*S3/256+sqrt(1938)*S5/256+sqrt(570)*S7/512+sqrt(10)*S9/512",
            "-sqrt(46189)*z*(5*I*x**9-60*I*x**7*z**2+126*I*x**5*z**4-60*I*x**3*z**6+5*I*x*z**8-5*y**9+60*y**7*z**2-126*y**5*z**4+60*y**3*z**6-5*y*z**8)/256",
            "[0,sqrt(5)*I/256,0,0,0,sqrt(969)*I/128,0,0,0,sqrt(41990)*I/256,0,0,0,sqrt(4845)*I/128,0,0,0,sqrt(285)*I/256,0,0,0]",
        ),
        "Qh(10,Ega,4,)": (
            "-9*sqrt(39)*I*C1/256-69*sqrt(2)*I*C3/256+sqrt(10)*I*C5/256+43*sqrt(34)*I*C7/512-3*sqrt(1938)*I*C9/512+9*sqrt(39)*S1/256-69*sqrt(2)*S3/256-sqrt(10)*S5/256+43*sqrt(34)*S7/512+3*sqrt(1938)*S9/512",
            "-sqrt(2145)*z*(9*I*x**9-288*I*x**7*y**2-12*I*x**7*z**2+672*I*x**5*y**4+672*I*x**5*y**2*z**2-42*I*x**5*z**4-672*x**4*y**5+2240*x**4*y**3*z**2-672*x**4*y*z**4-2240*I*x**3*y**4*z**2+672*I*x**3*y**2*z**4-12*I*x**3*z**6+288*x**2*y**7-672*x**2*y**5*z**2-672*x**2*y**3*z**4+288*x**2*y*z**6+672*I*x*y**4*z**4-288*I*x*y**2*z**6+9*I*x*z**8-9*y**9+12*y**7*z**2+42*y**5*z**4+12*y**3*z**6-9*y*z**8)/256",
            "[0,3*sqrt(969)*I/256,0,0,0,-sqrt(5)*I/128,0,0,0,9*sqrt(78)*I/256,0,0,0,-69*I/128,0,0,0,43*sqrt(17)*I/256,0,0,0]",
        ),
        "Qh(10,Ega,5,)": (
            "-7*sqrt(6)*I*C1/256-7*sqrt(13)*I*C3/128-5*sqrt(65)*I*C5/128-7*sqrt(221)*I*C7/256-sqrt(12597)*I*C9/256+7*sqrt(6)*S1/256-7*sqrt(13)*S3/128+5*sqrt(65)*S5/128-7*sqrt(221)*S7/256+sqrt(12597)*S9/256",
            "-sqrt(330)*z*(7*I*x**9-384*x**8*y-336*I*x**7*y**2+28*I*x**7*z**2+1792*x**6*y**3+1792*x**6*y*z**2+1680*I*x**5*y**4-1008*I*x**5*y**2*z**2+42*I*x**5*z**4-1680*x**4*y**5-3360*x**4*y**3*z**2-1680*x**4*y*z**4-1792*I*x**3*y**6+3360*I*x**3*y**4*z**2-1008*I*x**3*y**2*z**4+28*I*x**3*z**6+336*x**2*y**7+1008*x**2*y**5*z**2+1008*x**2*y**3*z**4+336*x**2*y*z**6+384*I*x*y**8-1792*I*x*y**6*z**2+1680*I*x*y**4*z**4-336*I*x*y**2*z**6+7*I*x*z**8-7*y**9-28*y**7*z**2-42*y**5*z**4-28*y**3*z**6-7*y*z**8)/256",
            "[0,sqrt(25194)*I/256,0,0,0,5*sqrt(130)*I/128,0,0,0,7*sqrt(3)*I/128,0,0,0,-7*sqrt(26)*I/128,0,0,0,-7*sqrt(442)*I/256,0,0,0]",
        ),
        "Qh(10,Egb,1,)": (
            "sqrt(442)*I*C1/64+sqrt(51)*I*C3/32-sqrt(255)*I*C5/32+11*sqrt(3)*I*C7/64-sqrt(19)*I*C9/64+sqrt(442)*S1/64-sqrt(51)*S3/32-sqrt(255)*S5/32-11*sqrt(3)*S7/64-sqrt(19)*S9/64",
            "-sqrt(24310)*z*(I*x**9-18*I*x**7*y**2-6*I*x**7*z**2+126*I*x**5*y**2*z**2-126*I*x**3*y**2*z**4+6*I*x**3*z**6-18*x**2*y**7+126*x**2*y**5*z**2-126*x**2*y**3*z**4+18*x**2*y*z**6+18*I*x*y**2*z**6-I*x*z**8+y**9-6*y**7*z**2+6*y**3*z**6-y*z**8)/64",
            "[0,0,0,-11*sqrt(6)*I/64,0,0,0,-sqrt(102)*I/32,0,0,0,sqrt(221)*I/32,0,0,0,-sqrt(510)*I/32,0,0,0,-sqrt(38)*I/64,0]",
        ),
        "Qh(10,Egb,2,)": (
            "sqrt(78)*I*C1/64+11*I*C3/32+5*sqrt(5)*I*C5/32+sqrt(17)*I*C7/64-sqrt(969)*I*C9/64+sqrt(78)*S1/64-11*S3/32+5*sqrt(5)*S5/32-sqrt(17)*S7/64-sqrt(969)*S9/64",
            "-sqrt(4290)*z*(I*x**9-42*I*x**7*y**2+2*I*x**7*z**2-112*x**6*y**3+112*x**6*y*z**2+168*I*x**5*y**4-42*I*x**5*y**2*z**2+168*x**4*y**5-168*x**4*y*z**4-112*I*x**3*y**6+42*I*x**3*y**2*z**4-2*I*x**3*z**6-42*x**2*y**7-42*x**2*y**5*z**2+42*x**2*y**3*z**4+42*x**2*y*z**6+112*I*x*y**6*z**2-168*I*x*y**4*z**4+42*I*x*y**2*z**6-I*x*z**8+y**9+2*y**7*z**2-2*y**3*z**6-y*z**8)/64",
            "[0,0,0,-sqrt(34)*I/64,0,0,0,-11*sqrt(2)*I/32,0,0,0,sqrt(39)*I/32,0,0,0,5*sqrt(10)*I/32,0,0,0,-sqrt(1938)*I/64,0]",
        ),
        "Qh(10,Egb,3,)": (
            "sqrt(20995)*I*C1/256-sqrt(9690)*I*C3/256+sqrt(1938)*I*C5/256-sqrt(570)*I*C7/512+sqrt(10)*I*C9/512+sqrt(20995)*S1/256+sqrt(9690)*S3/256+sqrt(1938)*S5/256+sqrt(570)*S7/512+sqrt(10)*S9/512",
            "sqrt(46189)*z*(5*I*x**9-60*I*x**7*z**2+126*I*x**5*z**4-60*I*x**3*z**6+5*I*x*z**8+5*y**9-60*y**7*z**2+126*y**5*z**4-60*y**3*z**6+5*y*z**8)/256",
            "[0,0,0,sqrt(285)*I/256,0,0,0,sqrt(4845)*I/128,0,0,0,sqrt(41990)*I/256,0,0,0,sqrt(969)*I/128,0,0,0,sqrt(5)*I/256,0]",
        ),
        "Qh(10,Egb,4,)": (
            "9*sqrt(39)*I*C1/256+69*sqrt(2)*I*C3/256-sqrt(10)*I*C5/256-43*sqrt(34)*I*C7/512+3*sqrt(1938)*I*C9/512+9*sqrt(39)*S1/256-69*sqrt(2)*S3/256-sqrt(10)*S5/256+43*sqrt(34)*S7/512+3*sqrt(1938)*S9/512",
            "sqrt(2145)*z*(9*I*x**9-288*I*x**7*y**2-12*I*x**7*z**2+672*I*x**5*y**4+672*I*x**5*y**2*z**2-42*I*x**5*z**4+672*x**4*y**5-2240*x**4*y**3*z**2+672*x**4*y*z**4-2240*I*x**3*y**4*z**2+672*I*x**3*y**2*z**4-12*I*x**3*z**6-288*x**2*y**7+672*x**2*y**5*z**2+672*x**2*y**3*z**4-288*x**2*y*z**6+672*I*x*y**4*z**4-288*I*x*y**2*z**6+9*I*x*z**8+9*y**9-12*y**7*z**2-42*y**5*z**4-12*y**3*z**6+9*y*z**8)/256",
            "[0,0,0,43*sqrt(17)*I/256,0,0,0,-69*I/128,0,0,0,9*sqrt(78)*I/256,0,0,0,-sqrt(5)*I/128,0,0,0,3*sqrt(969)*I/256,0]",
        ),
        "Qh(10,Egb,5,)": (
            "7*sqrt(6)*I*C1/256+7*sqrt(13)*I*C3/128+5*sqrt(65)*I*C5/128+7*sqrt(221)*I*C7/256+sqrt(12597)*I*C9/256+7*sqrt(6)*S1/256-7*sqrt(13)*S3/128+5*sqrt(65)*S5/128-7*sqrt(221)*S7/256+sqrt(12597)*S9/256",
            "sqrt(330)*z*(7*I*x**9+384*x**8*y-336*I*x**7*y**2+28*I*x**7*z**2-1792*x**6*y**3-1792*x**6*y*z**2+1680*I*x**5*y**4-1008*I*x**5*y**2*z**2+42*I*x**5*z**4+1680*x**4*y**5+3360*x**4*y**3*z**2+1680*x**4*y*z**4-1792*I*x**3*y**6+3360*I*x**3*y**4*z**2-1008*I*x**3*y**2*z**4+28*I*x**3*z**6-336*x**2*y**7-1008*x**2*y**5*z**2-1008*x**2*y**3*z**4-336*x**2*y*z**6+384*I*x*y**8-1792*I*x*y**6*z**2+1680*I*x*y**4*z**4-336*I*x*y**2*z**6+7*I*x*z**8+7*y**9+28*y**7*z**2+42*y**5*z**4+28*y**3*z**6+7*y*z**8)/256",
            "[0,0,0,-7*sqrt(442)*I/256,0,0,0,-7*sqrt(26)*I/128,0,0,0,7*sqrt(3)*I/128,0,0,0,5*sqrt(130)*I/128,0,0,0,sqrt(25194)*I/256,0]",
        ),
        "Qh(11,Au,1,)": (
            "S8",
            "-sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(11,Au,2,)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Au,3,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Au,4,)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(11,Au,5,)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Bu,1,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Qh(11,Bu,2,)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "-sqrt(230945)*x*y*z*(x**8-6*x**6*y**2-6*x**6*z**2+42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2-84*x**2*y**2*z**4+12*x**2*z**6+y**8-6*y**6*z**2+12*y**2*z**6-2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Qh(11,Bu,3,)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "-sqrt(3003)*x*y*z*(5*x**8-150*x**6*y**2+90*x**6*z**2+336*x**4*y**4-70*x**4*y**2*z**2-168*x**4*z**4-150*x**2*y**6-70*x**2*y**4*z**2+140*x**2*y**2*z**4+60*x**2*z**6+5*y**8+90*y**6*z**2-168*y**4*z**4+60*y**2*z**6-10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Qh(11,Bu,4,)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(11,Bu,5,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,Bu,6,)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eua,1,)": (
            "-21*sqrt(33)*C1/512+sqrt(176358)*C11/1024+sqrt(15015)*C3/512-15*sqrt(286)*C5/1024+sqrt(72930)*C7/1024-sqrt(92378)*C9/1024-21*sqrt(33)*I*S1/512-sqrt(176358)*I*S11/1024-sqrt(15015)*I*S3/512-15*sqrt(286)*I*S5/1024-sqrt(72930)*I*S7/1024-sqrt(92378)*I*S9/1024",
            "sqrt(2)*(256*x**11-693*I*x**10*y-7040*x**9*y**2-7040*x**9*z**2+11550*I*x**8*y**3-3465*I*x**8*y*z**2+31680*x**7*y**4+63360*x**7*y**2*z**2+31680*x**7*z**4-36960*I*x**6*y**5+46200*I*x**6*y**3*z**2-6930*I*x**6*y*z**4-36960*x**5*y**6-110880*x**5*y**4*z**2-110880*x**5*y**2*z**4-36960*x**5*z**6+31680*I*x**4*y**7-110880*I*x**4*y**5*z**2+69300*I*x**4*y**3*z**4-6930*I*x**4*y*z**6+11550*x**3*y**8+46200*x**3*y**6*z**2+69300*x**3*y**4*z**4+46200*x**3*y**2*z**6+11550*x**3*z**8-7040*I*x**2*y**9+63360*I*x**2*y**7*z**2-110880*I*x**2*y**5*z**4+46200*I*x**2*y**3*z**6-3465*I*x**2*y*z**8-693*x*y**10-3465*x*y**8*z**2-6930*x*y**6*z**4-6930*x*y**4*z**6-3465*x*y**2*z**8-693*x*z**10+256*I*y**11-7040*I*y**9*z**2+31680*I*y**7*z**4-36960*I*y**5*z**6+11550*I*y**3*z**8-693*I*y*z**10)/512",
            "[0,0,sqrt(46189)/512,0,0,0,15*sqrt(143)/512,0,0,0,21*sqrt(66)/512,0,0,0,sqrt(30030)/512,0,0,0,sqrt(36465)/512,0,0,0,sqrt(88179)/512]",
        ),
        "Qh(11,Eua,2,)": (
            "-sqrt(20995)*C1/512+sqrt(770)*C11/1024-3*sqrt(2261)*C3/512+3*sqrt(9690)*C5/1024+77*sqrt(38)*C7/1024+39*sqrt(30)*C9/1024-sqrt(20995)*I*S1/512-sqrt(770)*I*S11/1024+3*sqrt(2261)*I*S3/512+3*sqrt(9690)*I*S5/1024-77*sqrt(38)*I*S7/1024+39*sqrt(30)*I*S9/1024",
            "-sqrt(1385670)*(I*x**10*y-6*I*x**8*y**3-27*I*x**8*y*z**2+168*I*x**6*y**3*z**2+42*I*x**6*y*z**4-420*I*x**4*y**3*z**4+42*I*x**4*y*z**6-6*x**3*y**8+168*x**3*y**6*z**2-420*x**3*y**4*z**4+168*x**3*y**2*z**6-6*x**3*z**8+168*I*x**2*y**3*z**6-27*I*x**2*y*z**8+x*y**10-27*x*y**8*z**2+42*x*y**6*z**4+42*x*y**4*z**6-27*x*y**2*z**8+x*z**10-6*I*y**3*z**8+I*y*z**10)/512",
            "[0,0,-39*sqrt(15)/512,0,0,0,-3*sqrt(4845)/512,0,0,0,sqrt(41990)/512,0,0,0,-3*sqrt(4522)/512,0,0,0,77*sqrt(19)/512,0,0,0,sqrt(385)/512]",
        ),
        "Qh(11,Eua,3,)": (
            "-5*sqrt(273)*C1/256+sqrt(21318)*C11/512+11*sqrt(15)*C3/256+13*sqrt(14)*C5/512-3*sqrt(3570)*C7/512+3*sqrt(4522)*C9/512-5*sqrt(273)*I*S1/256-sqrt(21318)*I*S11/512-11*sqrt(15)*I*S3/256+13*sqrt(14)*I*S5/512+3*sqrt(3570)*I*S7/512+3*sqrt(4522)*I*S9/512",
            "-3*sqrt(2002)*(5*I*x**10*y-70*I*x**8*y**3-15*I*x**8*y*z**2-80*x**7*y**4+480*x**7*y**2*z**2-80*x**7*z**4+168*I*x**6*y**5+280*I*x**6*y**3*z**2-70*I*x**6*y*z**4+168*x**5*y**6-840*x**5*y**4*z**2-840*x**5*y**2*z**4+168*x**5*z**6-80*I*x**4*y**7-840*I*x**4*y**5*z**2+700*I*x**4*y**3*z**4-70*I*x**4*y*z**6-70*x**3*y**8+280*x**3*y**6*z**2+700*x**3*y**4*z**4+280*x**3*y**2*z**6-70*x**3*z**8+480*I*x**2*y**7*z**2-840*I*x**2*y**5*z**4+280*I*x**2*y**3*z**6-15*I*x**2*y*z**8+5*x*y**10-15*x*y**8*z**2-70*x*y**6*z**4-70*x*y**4*z**6-15*x*y**2*z**8+5*x*z**10-80*I*y**7*z**4+168*I*y**5*z**6-70*I*y**3*z**8+5*I*y*z**10)/256",
            "[0,0,-3*sqrt(2261)/256,0,0,0,-13*sqrt(7)/256,0,0,0,5*sqrt(546)/256,0,0,0,11*sqrt(30)/256,0,0,0,-3*sqrt(1785)/256,0,0,0,sqrt(10659)/256]",
        ),
        "Qh(11,Eua,4,)": (
            "-sqrt(58786)*C1/1024-sqrt(11)*C11/1024-9*sqrt(3230)*C3/1024-5*sqrt(6783)*C5/1024-7*sqrt(665)*C7/1024-9*sqrt(21)*C9/1024-sqrt(58786)*I*S1/1024+sqrt(11)*I*S11/1024+9*sqrt(3230)*I*S3/1024-5*sqrt(6783)*I*S5/1024+7*sqrt(665)*I*S7/1024-9*sqrt(21)*I*S9/1024",
            "sqrt(969969)*(I*x**10*y-45*I*x**8*y*z**2+210*I*x**6*y*z**4-210*I*x**4*y*z**6+45*I*x**2*y*z**8+x*y**10-45*x*y**8*z**2+210*x*y**6*z**4-210*x*y**4*z**6+45*x*y**2*z**8-x*z**10-I*y*z**10)/512",
            "[0,0,9*sqrt(42)/1024,0,0,0,5*sqrt(13566)/1024,0,0,0,sqrt(29393)/512,0,0,0,-9*sqrt(1615)/512,0,0,0,-7*sqrt(1330)/1024,0,0,0,-sqrt(22)/1024]",
        ),
        "Qh(11,Eua,5,)": (
            "-15*sqrt(442)*C1/1024-3*sqrt(1463)*C11/1024-sqrt(1190)*C3/1024+53*sqrt(51)*C5/1024-105*sqrt(5)*C7/1024-61*sqrt(57)*C9/1024-15*sqrt(442)*I*S1/1024+3*sqrt(1463)*I*S11/1024+sqrt(1190)*I*S3/1024+53*sqrt(51)*I*S5/1024+105*sqrt(5)*I*S7/1024-61*sqrt(57)*I*S9/1024",
            "sqrt(7293)*(15*I*x**10*y-160*I*x**8*y**3-195*I*x**8*y*z**2+224*I*x**6*y**5+2240*I*x**6*y**3*z**2-210*I*x**6*y*z**4+224*x**5*y**6-3360*x**5*y**4*z**2+3360*x**5*y**2*z**4-224*x**5*z**6-3360*I*x**4*y**5*z**2+210*I*x**4*y*z**6-160*x**3*y**8+2240*x**3*y**6*z**2-2240*x**3*y**2*z**6+160*x**3*z**8+3360*I*x**2*y**5*z**4-2240*I*x**2*y**3*z**6+195*I*x**2*y*z**8+15*x*y**10-195*x*y**8*z**2-210*x*y**6*z**4+210*x*y**4*z**6+195*x*y**2*z**8-15*x*z**10-224*I*y**5*z**6+160*I*y**3*z**8-15*I*y*z**10)/512",
            "[0,0,61*sqrt(114)/1024,0,0,0,-53*sqrt(102)/1024,0,0,0,15*sqrt(221)/512,0,0,0,-sqrt(595)/512,0,0,0,-105*sqrt(10)/1024,0,0,0,-3*sqrt(2926)/1024]",
        ),
        "Qh(11,Eua,6,)": (
            "-21*sqrt(65)*C1/512-sqrt(248710)*C11/1024+57*sqrt(7)*C3/512-41*sqrt(30)*C5/1024+17*sqrt(34)*C7/1024+sqrt(9690)*C9/1024-21*sqrt(65)*I*S1/512+sqrt(248710)*I*S11/1024-57*sqrt(7)*I*S3/512-41*sqrt(30)*I*S5/1024-17*sqrt(34)*I*S7/1024+sqrt(9690)*I*S9/1024",
            "sqrt(4290)*(21*I*x**10*y+128*x**9*y**2-128*x**9*z**2-336*I*x**8*y**3+63*I*x**8*y*z**2-768*x**7*y**4+768*x**7*z**4+1008*I*x**6*y**5-672*I*x**6*y**3*z**2+42*I*x**6*y*z**4+1008*x**5*y**6+1008*x**5*y**4*z**2-1008*x**5*y**2*z**4-1008*x**5*z**6-768*I*x**4*y**7+1008*I*x**4*y**5*z**2-42*I*x**4*y*z**6-336*x**3*y**8-672*x**3*y**6*z**2+672*x**3*y**2*z**6+336*x**3*z**8+128*I*x**2*y**9-1008*I*x**2*y**5*z**4+672*I*x**2*y**3*z**6-63*I*x**2*y*z**8+21*x*y**10+63*x*y**8*z**2+42*x*y**6*z**4-42*x*y**4*z**6-63*x*y**2*z**8-21*x*z**10-128*I*y**9*z**2+768*I*y**7*z**4-1008*I*y**5*z**6+336*I*y**3*z**8-21*I*y*z**10)/512",
            "[0,0,-sqrt(4845)/512,0,0,0,41*sqrt(15)/512,0,0,0,21*sqrt(130)/512,0,0,0,57*sqrt(14)/512,0,0,0,17*sqrt(17)/512,0,0,0,-sqrt(124355)/512]",
        ),
        "Qh(11,Eub,1,)": (
            "-21*sqrt(33)*C1/512+sqrt(176358)*C11/1024+sqrt(15015)*C3/512-15*sqrt(286)*C5/1024+sqrt(72930)*C7/1024-sqrt(92378)*C9/1024+21*sqrt(33)*I*S1/512+sqrt(176358)*I*S11/1024+sqrt(15015)*I*S3/512+15*sqrt(286)*I*S5/1024+sqrt(72930)*I*S7/1024+sqrt(92378)*I*S9/1024",
            "sqrt(2)*(256*x**11+693*I*x**10*y-7040*x**9*y**2-7040*x**9*z**2-11550*I*x**8*y**3+3465*I*x**8*y*z**2+31680*x**7*y**4+63360*x**7*y**2*z**2+31680*x**7*z**4+36960*I*x**6*y**5-46200*I*x**6*y**3*z**2+6930*I*x**6*y*z**4-36960*x**5*y**6-110880*x**5*y**4*z**2-110880*x**5*y**2*z**4-36960*x**5*z**6-31680*I*x**4*y**7+110880*I*x**4*y**5*z**2-69300*I*x**4*y**3*z**4+6930*I*x**4*y*z**6+11550*x**3*y**8+46200*x**3*y**6*z**2+69300*x**3*y**4*z**4+46200*x**3*y**2*z**6+11550*x**3*z**8+7040*I*x**2*y**9-63360*I*x**2*y**7*z**2+110880*I*x**2*y**5*z**4-46200*I*x**2*y**3*z**6+3465*I*x**2*y*z**8-693*x*y**10-3465*x*y**8*z**2-6930*x*y**6*z**4-6930*x*y**4*z**6-3465*x*y**2*z**8-693*x*z**10-256*I*y**11+7040*I*y**9*z**2-31680*I*y**7*z**4+36960*I*y**5*z**6-11550*I*y**3*z**8+693*I*y*z**10)/512",
            "[-sqrt(88179)/512,0,0,0,-sqrt(36465)/512,0,0,0,-sqrt(30030)/512,0,0,0,-21*sqrt(66)/512,0,0,0,-15*sqrt(143)/512,0,0,0,-sqrt(46189)/512,0,0]",
        ),
        "Qh(11,Eub,2,)": (
            "-sqrt(20995)*C1/512+sqrt(770)*C11/1024-3*sqrt(2261)*C3/512+3*sqrt(9690)*C5/1024+77*sqrt(38)*C7/1024+39*sqrt(30)*C9/1024+sqrt(20995)*I*S1/512+sqrt(770)*I*S11/1024-3*sqrt(2261)*I*S3/512-3*sqrt(9690)*I*S5/1024+77*sqrt(38)*I*S7/1024-39*sqrt(30)*I*S9/1024",
            "sqrt(1385670)*(I*x**10*y-6*I*x**8*y**3-27*I*x**8*y*z**2+168*I*x**6*y**3*z**2+42*I*x**6*y*z**4-420*I*x**4*y**3*z**4+42*I*x**4*y*z**6+6*x**3*y**8-168*x**3*y**6*z**2+420*x**3*y**4*z**4-168*x**3*y**2*z**6+6*x**3*z**8+168*I*x**2*y**3*z**6-27*I*x**2*y*z**8-x*y**10+27*x*y**8*z**2-42*x*y**6*z**4-42*x*y**4*z**6+27*x*y**2*z**8-x*z**10-6*I*y**3*z**8+I*y*z**10)/512",
            "[-sqrt(385)/512,0,0,0,-77*sqrt(19)/512,0,0,0,3*sqrt(4522)/512,0,0,0,-sqrt(41990)/512,0,0,0,3*sqrt(4845)/512,0,0,0,39*sqrt(15)/512,0,0]",
        ),
        "Qh(11,Eub,3,)": (
            "-5*sqrt(273)*C1/256+sqrt(21318)*C11/512+11*sqrt(15)*C3/256+13*sqrt(14)*C5/512-3*sqrt(3570)*C7/512+3*sqrt(4522)*C9/512+5*sqrt(273)*I*S1/256+sqrt(21318)*I*S11/512+11*sqrt(15)*I*S3/256-13*sqrt(14)*I*S5/512-3*sqrt(3570)*I*S7/512-3*sqrt(4522)*I*S9/512",
            "3*sqrt(2002)*(5*I*x**10*y-70*I*x**8*y**3-15*I*x**8*y*z**2+80*x**7*y**4-480*x**7*y**2*z**2+80*x**7*z**4+168*I*x**6*y**5+280*I*x**6*y**3*z**2-70*I*x**6*y*z**4-168*x**5*y**6+840*x**5*y**4*z**2+840*x**5*y**2*z**4-168*x**5*z**6-80*I*x**4*y**7-840*I*x**4*y**5*z**2+700*I*x**4*y**3*z**4-70*I*x**4*y*z**6+70*x**3*y**8-280*x**3*y**6*z**2-700*x**3*y**4*z**4-280*x**3*y**2*z**6+70*x**3*z**8+480*I*x**2*y**7*z**2-840*I*x**2*y**5*z**4+280*I*x**2*y**3*z**6-15*I*x**2*y*z**8-5*x*y**10+15*x*y**8*z**2+70*x*y**6*z**4+70*x*y**4*z**6+15*x*y**2*z**8-5*x*z**10-80*I*y**7*z**4+168*I*y**5*z**6-70*I*y**3*z**8+5*I*y*z**10)/256",
            "[-sqrt(10659)/256,0,0,0,3*sqrt(1785)/256,0,0,0,-11*sqrt(30)/256,0,0,0,-5*sqrt(546)/256,0,0,0,13*sqrt(7)/256,0,0,0,3*sqrt(2261)/256,0,0]",
        ),
        "Qh(11,Eub,4,)": (
            "-sqrt(58786)*C1/1024-sqrt(11)*C11/1024-9*sqrt(3230)*C3/1024-5*sqrt(6783)*C5/1024-7*sqrt(665)*C7/1024-9*sqrt(21)*C9/1024+sqrt(58786)*I*S1/1024-sqrt(11)*I*S11/1024-9*sqrt(3230)*I*S3/1024+5*sqrt(6783)*I*S5/1024-7*sqrt(665)*I*S7/1024+9*sqrt(21)*I*S9/1024",
            "-sqrt(969969)*(I*x**10*y-45*I*x**8*y*z**2+210*I*x**6*y*z**4-210*I*x**4*y*z**6+45*I*x**2*y*z**8-x*y**10+45*x*y**8*z**2-210*x*y**6*z**4+210*x*y**4*z**6-45*x*y**2*z**8+x*z**10-I*y*z**10)/512",
            "[sqrt(22)/1024,0,0,0,7*sqrt(1330)/1024,0,0,0,9*sqrt(1615)/512,0,0,0,-sqrt(29393)/512,0,0,0,-5*sqrt(13566)/1024,0,0,0,-9*sqrt(42)/1024,0,0]",
        ),
        "Qh(11,Eub,5,)": (
            "-15*sqrt(442)*C1/1024-3*sqrt(1463)*C11/1024-sqrt(1190)*C3/1024+53*sqrt(51)*C5/1024-105*sqrt(5)*C7/1024-61*sqrt(57)*C9/1024+15*sqrt(442)*I*S1/1024-3*sqrt(1463)*I*S11/1024-sqrt(1190)*I*S3/1024-53*sqrt(51)*I*S5/1024-105*sqrt(5)*I*S7/1024+61*sqrt(57)*I*S9/1024",
            "-sqrt(7293)*(15*I*x**10*y-160*I*x**8*y**3-195*I*x**8*y*z**2+224*I*x**6*y**5+2240*I*x**6*y**3*z**2-210*I*x**6*y*z**4-224*x**5*y**6+3360*x**5*y**4*z**2-3360*x**5*y**2*z**4+224*x**5*z**6-3360*I*x**4*y**5*z**2+210*I*x**4*y*z**6+160*x**3*y**8-2240*x**3*y**6*z**2+2240*x**3*y**2*z**6-160*x**3*z**8+3360*I*x**2*y**5*z**4-2240*I*x**2*y**3*z**6+195*I*x**2*y*z**8-15*x*y**10+195*x*y**8*z**2+210*x*y**6*z**4-210*x*y**4*z**6-195*x*y**2*z**8+15*x*z**10-224*I*y**5*z**6+160*I*y**3*z**8-15*I*y*z**10)/512",
            "[3*sqrt(2926)/1024,0,0,0,105*sqrt(10)/1024,0,0,0,sqrt(595)/512,0,0,0,-15*sqrt(221)/512,0,0,0,53*sqrt(102)/1024,0,0,0,-61*sqrt(114)/1024,0,0]",
        ),
        "Qh(11,Eub,6,)": (
            "-21*sqrt(65)*C1/512-sqrt(248710)*C11/1024+57*sqrt(7)*C3/512-41*sqrt(30)*C5/1024+17*sqrt(34)*C7/1024+sqrt(9690)*C9/1024+21*sqrt(65)*I*S1/512-sqrt(248710)*I*S11/1024+57*sqrt(7)*I*S3/512+41*sqrt(30)*I*S5/1024+17*sqrt(34)*I*S7/1024-sqrt(9690)*I*S9/1024",
            "-sqrt(4290)*(21*I*x**10*y-128*x**9*y**2+128*x**9*z**2-336*I*x**8*y**3+63*I*x**8*y*z**2+768*x**7*y**4-768*x**7*z**4+1008*I*x**6*y**5-672*I*x**6*y**3*z**2+42*I*x**6*y*z**4-1008*x**5*y**6-1008*x**5*y**4*z**2+1008*x**5*y**2*z**4+1008*x**5*z**6-768*I*x**4*y**7+1008*I*x**4*y**5*z**2-42*I*x**4*y*z**6+336*x**3*y**8+672*x**3*y**6*z**2-672*x**3*y**2*z**6-336*x**3*z**8+128*I*x**2*y**9-1008*I*x**2*y**5*z**4+672*I*x**2*y**3*z**6-63*I*x**2*y*z**8-21*x*y**10-63*x*y**8*z**2-42*x*y**6*z**4+42*x*y**4*z**6+63*x*y**2*z**8+21*x*z**10-128*I*y**9*z**2+768*I*y**7*z**4-1008*I*y**5*z**6+336*I*y**3*z**8-21*I*y*z**10)/512",
            "[sqrt(124355)/512,0,0,0,-17*sqrt(17)/512,0,0,0,-57*sqrt(14)/512,0,0,0,-21*sqrt(130)/512,0,0,0,-41*sqrt(15)/512,0,0,0,sqrt(4845)/512,0,0]",
        ),
    },
    "D4": {
        "Qh(0,A1,,)": ("C0", "1", "[1]"),
        "Qh(2,A1,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(5,A1,,)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(7,A1,,)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(4,A1,1,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Qh(6,A1,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Qh(8,A1,1,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Qh(9,A1,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Qh(10,A1,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Qh(11,A1,1,)": (
            "S8",
            "-sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(4,A1,2,)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "-sqrt(15)*(x**4-12*x**2*y**2+6*x**2*z**2+y**4+6*y**2*z**2-2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Qh(6,A1,2,)": (
            "sqrt(14)*C0/4+sqrt(2)*C4/4",
            "-sqrt(14)*(x**6-15*x**4*z**2+15*x**2*z**4+y**6-15*y**4*z**2+15*y**2*z**4-2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Qh(8,A1,2,)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Qh(9,A1,2,)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(x-y)*(x+y)*(3*x**4-11*x**2*y**2-7*x**2*z**2+3*y**4-7*y**2*z**2+7*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Qh(10,A1,2,)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "-sqrt(420189)*(22*x**10+45*x**8*y**2-1035*x**8*z**2-105*x**6*y**4-630*x**6*y**2*z**2+4935*x**6*z**4-105*x**4*y**6+3150*x**4*y**4*z**2-1575*x**4*y**2*z**4-4830*x**4*z**6+45*x**2*y**8-630*x**2*y**6*z**2-1575*x**2*y**4*z**4+1260*x**2*y**2*z**6+990*x**2*z**8+22*y**10-1035*y**8*z**2+4935*y**6*z**4-4830*y**4*z**6+990*y**2*z**8-44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Qh(11,A1,2,)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(8,A1,3,)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Qh(10,A1,3,)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "-sqrt(3213210)*(3*x**10-96*x**8*y**2-39*x**8*z**2+224*x**6*y**4+1344*x**6*y**2*z**2-42*x**6*z**4+224*x**4*y**6-6720*x**4*y**4*z**2+3360*x**4*y**2*z**4-182*x**4*z**6-96*x**2*y**8+1344*x**2*y**6*z**2+3360*x**2*y**4*z**4-2688*x**2*y**2*z**6+135*x**2*z**8+3*y**10-39*y**8*z**2-42*y**6*z**4-182*y**4*z**6+135*y**2*z**8-6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Qh(1,A2,,)": ("C0", "z", "[0,1,0]"),
        "Qh(3,A2,,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(4,A2,,)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(6,A2,,)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(5,A2,1,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(7,A2,1,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(8,A2,1,)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(9,A2,1,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A2,1,)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(11,A2,1,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(5,A2,2,)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(7,A2,2,)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(8,A2,2,)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(9,A2,2,)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(10,A2,2,)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(11,A2,2,)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,A2,3,)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,A2,3,)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(2,B1,,)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(3,B1,,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(4,B1,,)": ("-C2", "sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Qh(5,B1,,)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(6,B1,1,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Qh(7,B1,1,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Qh(8,B1,1,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,B1,1,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Qh(10,B1,1,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Qh(11,B1,1,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Qh(6,B1,2,)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x-y)*(x+y)*(x**4-9*x**2*y**2-5*x**2*z**2+y**4-5*y**2*z**2+5*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Qh(7,B1,2,)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "-sqrt(77)*x*y*z*(3*x**4-20*x**2*y**2+10*x**2*z**2+3*y**4+10*y**2*z**2-6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Qh(8,B1,2,)": (
            "C2",
            "-3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(9,B1,2,)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Qh(10,B1,2,)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(x-y)*(x+y)*(22*x**8-653*x**6*y**2-315*x**6*z**2+2602*x**4*y**4-945*x**4*y**2*z**2+1575*x**4*z**4-653*x**2*y**6-945*x**2*y**4*z**2+3150*x**2*y**2*z**4-1680*x**2*z**6+22*y**8-315*y**6*z**2+1575*y**4*z**4-1680*y**2*z**6+360*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Qh(11,B1,2,)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "-sqrt(230945)*x*y*z*(x**8-6*x**6*y**2-6*x**6*z**2+42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2-84*x**2*y**2*z**4+12*x**2*z**6+y**8-6*y**6*z**2+12*y**2*z**6-2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Qh(10,B1,3,)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(x-y)*(x+y)*(9*x**8-165*x**6*y**2-231*x**6*z**2-25*x**4*y**4+3801*x**4*y**2*z**2+406*x**4*z**4-165*x**2*y**6+3801*x**2*y**4*z**2-9674*x**2*y**2*z**4+266*x**2*z**6+9*y**8-231*y**6*z**2+406*y**4*z**4+266*y**2*z**6-57*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Qh(11,B1,3,)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "-sqrt(3003)*x*y*z*(5*x**8-150*x**6*y**2+90*x**6*z**2+336*x**4*y**4-70*x**4*y**2*z**2-168*x**4*z**4-150*x**2*y**6-70*x**2*y**4*z**2+140*x**2*y**2*z**4+60*x**2*z**6+5*y**8+90*y**6*z**2-168*y**4*z**4+60*y**2*z**6-10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Qh(2,B2,,)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Qh(3,B2,,)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(4,B2,,)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(5,B2,,)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(6,B2,1,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(7,B2,1,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(8,B2,1,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(9,B2,1,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(10,B2,1,)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(11,B2,1,)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(6,B2,2,)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(7,B2,2,)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(8,B2,2,)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,B2,2,)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,B2,2,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(11,B2,2,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(10,B2,3,)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,B2,3,)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(1,E,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(1,E,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(2,E,,0)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(2,E,,1)": ("-C1", "-sqrt(3)*x*z", "[0,sqrt(2)/2,0,-sqrt(2)/2,0]"),
        "Qh(3,E,1,0)": (
            "-sqrt(6)*C1/4+sqrt(10)*C3/4",
            "x*(2*x**2-3*y**2-3*z**2)/2",
            "[-sqrt(5)/4,0,sqrt(3)/4,0,-sqrt(3)/4,0,sqrt(5)/4]",
        ),
        "Qh(3,E,1,1)": (
            "-sqrt(6)*S1/4-sqrt(10)*S3/4",
            "-y*(3*x**2-2*y**2+3*z**2)/2",
            "[-sqrt(5)*I/4,0,-sqrt(3)*I/4,0,-sqrt(3)*I/4,0,-sqrt(5)*I/4]",
        ),
        "Qh(4,E,1,0)": (
            "-sqrt(14)*S1/4-sqrt(2)*S3/4",
            "sqrt(35)*y*z*(y-z)*(y+z)/2",
            "[0,-I/4,0,-sqrt(7)*I/4,0,-sqrt(7)*I/4,0,-I/4,0]",
        ),
        "Qh(4,E,1,1)": ("sqrt(14)*C1/4-sqrt(2)*C3/4", "-sqrt(35)*x*z*(x-z)*(x+z)/2", "[0,1/4,0,-sqrt(7)/4,0,sqrt(7)/4,0,-1/4,0]"),
        "Qh(5,E,1,0)": (
            "sqrt(15)*C1/8-sqrt(70)*C3/16+3*sqrt(14)*C5/16",
            "x*(8*x**4-40*x**2*y**2-40*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/8",
            "[-3*sqrt(7)/16,0,sqrt(35)/16,0,-sqrt(30)/16,0,sqrt(30)/16,0,-sqrt(35)/16,0,3*sqrt(7)/16]",
        ),
        "Qh(5,E,1,1)": (
            "sqrt(15)*S1/8+sqrt(70)*S3/16+3*sqrt(14)*S5/16",
            "y*(15*x**4-40*x**2*y**2+30*x**2*z**2+8*y**4-40*y**2*z**2+15*z**4)/8",
            "[3*sqrt(7)*I/16,0,sqrt(35)*I/16,0,sqrt(30)*I/16,0,sqrt(30)*I/16,0,sqrt(35)*I/16,0,3*sqrt(7)*I/16]",
        ),
        "Qh(6,E,1,0)": (
            "sqrt(3)*S1/4-sqrt(30)*S3/8-sqrt(22)*S5/8",
            "3*sqrt(7)*y*z*(y-z)*(y+z)*(10*x**2-y**2-z**2)/4",
            "[0,-sqrt(11)*I/8,0,-sqrt(15)*I/8,0,sqrt(6)*I/8,0,sqrt(6)*I/8,0,-sqrt(15)*I/8,0,-sqrt(11)*I/8,0]",
        ),
        "Qh(6,E,1,1)": (
            "-sqrt(3)*C1/4-sqrt(30)*C3/8+sqrt(22)*C5/8",
            "3*sqrt(7)*x*z*(x-z)*(x+z)*(x**2-10*y**2+z**2)/4",
            "[0,-sqrt(11)/8,0,sqrt(15)/8,0,sqrt(6)/8,0,-sqrt(6)/8,0,-sqrt(15)/8,0,sqrt(11)/8,0]",
        ),
        "Qh(7,E,1,0)": (
            "-5*sqrt(7)*C1/32+3*sqrt(21)*C3/32-sqrt(231)*C5/32+sqrt(429)*C7/32",
            "x*(16*x**6-168*x**4*y**2-168*x**4*z**2+210*x**2*y**4+420*x**2*y**2*z**2+210*x**2*z**4-35*y**6-105*y**4*z**2-105*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)/64,0,sqrt(462)/64,0,-3*sqrt(42)/64,0,5*sqrt(14)/64,0,-5*sqrt(14)/64,0,3*sqrt(42)/64,0,-sqrt(462)/64,0,sqrt(858)/64]",
        ),
        "Qh(7,E,1,1)": (
            "-5*sqrt(7)*S1/32-3*sqrt(21)*S3/32-sqrt(231)*S5/32-sqrt(429)*S7/32",
            "-y*(35*x**6-210*x**4*y**2+105*x**4*z**2+168*x**2*y**4-420*x**2*y**2*z**2+105*x**2*z**4-16*y**6+168*y**4*z**2-210*y**2*z**4+35*z**6)/16",
            "[-sqrt(858)*I/64,0,-sqrt(462)*I/64,0,-3*sqrt(42)*I/64,0,-5*sqrt(14)*I/64,0,-5*sqrt(14)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(462)*I/64,0,-sqrt(858)*I/64]",
        ),
        "Qh(8,E,1,0)": (
            "-sqrt(715)*S1/32-sqrt(273)*S3/32-sqrt(35)*S5/32-S7/32",
            "3*sqrt(715)*y*z*(y-z)*(y+z)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[0,-sqrt(2)*I/64,0,-sqrt(70)*I/64,0,-sqrt(546)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(546)*I/64,0,-sqrt(70)*I/64,0,-sqrt(2)*I/64,0]",
        ),
        "Qh(8,E,1,1)": (
            "sqrt(715)*C1/32-sqrt(273)*C3/32+sqrt(35)*C5/32-C7/32",
            "-3*sqrt(715)*x*z*(x-z)*(x+z)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/16",
            "[0,sqrt(2)/64,0,-sqrt(70)/64,0,sqrt(546)/64,0,-sqrt(1430)/64,0,sqrt(1430)/64,0,-sqrt(546)/64,0,sqrt(70)/64,0,-sqrt(2)/64,0]",
        ),
        "Qh(9,E,1,0)": (
            "21*sqrt(5)*C1/128-sqrt(2310)*C3/128+3*sqrt(286)*C5/128-3*sqrt(1430)*C7/256+sqrt(24310)*C9/256",
            "x*(128*x**8-2304*x**6*y**2-2304*x**6*z**2+6048*x**4*y**4+12096*x**4*y**2*z**2+6048*x**4*z**4-3360*x**2*y**6-10080*x**2*y**4*z**2-10080*x**2*y**2*z**4-3360*x**2*z**6+315*y**8+1260*y**6*z**2+1890*y**4*z**4+1260*y**2*z**6+315*z**8)/128",
            "[-sqrt(12155)/256,0,3*sqrt(715)/256,0,-3*sqrt(143)/128,0,sqrt(1155)/128,0,-21*sqrt(10)/256,0,21*sqrt(10)/256,0,-sqrt(1155)/128,0,3*sqrt(143)/128,0,-3*sqrt(715)/256,0,sqrt(12155)/256]",
        ),
        "Qh(9,E,1,1)": (
            "21*sqrt(5)*S1/128+sqrt(2310)*S3/128+3*sqrt(286)*S5/128+3*sqrt(1430)*S7/256+sqrt(24310)*S9/256",
            "y*(315*x**8-3360*x**6*y**2+1260*x**6*z**2+6048*x**4*y**4-10080*x**4*y**2*z**2+1890*x**4*z**4-2304*x**2*y**6+12096*x**2*y**4*z**2-10080*x**2*y**2*z**4+1260*x**2*z**6+128*y**8-2304*y**6*z**2+6048*y**4*z**4-3360*y**2*z**6+315*z**8)/128",
            "[sqrt(12155)*I/256,0,3*sqrt(715)*I/256,0,3*sqrt(143)*I/128,0,sqrt(1155)*I/128,0,21*sqrt(10)*I/256,0,21*sqrt(10)*I/256,0,sqrt(1155)*I/128,0,3*sqrt(143)*I/128,0,3*sqrt(715)*I/256,0,sqrt(12155)*I/256]",
        ),
        "Qh(10,E,1,0)": (
            "sqrt(221)*S1/32-sqrt(102)*S3/32-sqrt(510)*S5/32-11*sqrt(6)*S7/64-sqrt(38)*S9/64",
            "sqrt(12155)*y*z*(y-z)*(y+z)*(18*x**2-y**2-z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/32",
            "[0,-sqrt(19)*I/64,0,-11*sqrt(3)*I/64,0,-sqrt(255)*I/32,0,-sqrt(51)*I/32,0,sqrt(442)*I/64,0,sqrt(442)*I/64,0,-sqrt(51)*I/32,0,-sqrt(255)*I/32,0,-11*sqrt(3)*I/64,0,-sqrt(19)*I/64,0]",
        ),
        "Qh(10,E,1,1)": (
            "-sqrt(221)*C1/32-sqrt(102)*C3/32+sqrt(510)*C5/32-11*sqrt(6)*C7/64+sqrt(38)*C9/64",
            "sqrt(12155)*x*z*(x-z)*(x+z)*(x**2-18*y**2+z**2)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/32",
            "[0,-sqrt(19)/64,0,11*sqrt(3)/64,0,-sqrt(255)/32,0,sqrt(51)/32,0,sqrt(442)/64,0,-sqrt(442)/64,0,-sqrt(51)/32,0,sqrt(255)/32,0,-11*sqrt(3)/64,0,sqrt(19)/64,0]",
        ),
        "Qh(11,E,1,0)": (
            "-21*sqrt(66)*C1/512+sqrt(88179)*C11/512+sqrt(30030)*C3/512-15*sqrt(143)*C5/512+sqrt(36465)*C7/512-sqrt(46189)*C9/512",
            "x*(256*x**10-7040*x**8*y**2-7040*x**8*z**2+31680*x**6*y**4+63360*x**6*y**2*z**2+31680*x**6*z**4-36960*x**4*y**6-110880*x**4*y**4*z**2-110880*x**4*y**2*z**4-36960*x**4*z**6+11550*x**2*y**8+46200*x**2*y**6*z**2+69300*x**2*y**4*z**4+46200*x**2*y**2*z**6+11550*x**2*z**8-693*y**10-3465*y**8*z**2-6930*y**6*z**4-6930*y**4*z**6-3465*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)/1024,0,sqrt(92378)/1024,0,-sqrt(72930)/1024,0,15*sqrt(286)/1024,0,-sqrt(15015)/512,0,21*sqrt(33)/512,0,-21*sqrt(33)/512,0,sqrt(15015)/512,0,-15*sqrt(286)/1024,0,sqrt(72930)/1024,0,-sqrt(92378)/1024,0,sqrt(176358)/1024]",
        ),
        "Qh(11,E,1,1)": (
            "-21*sqrt(66)*S1/512-sqrt(88179)*S11/512-sqrt(30030)*S3/512-15*sqrt(143)*S5/512-sqrt(36465)*S7/512-sqrt(46189)*S9/512",
            "-y*(693*x**10-11550*x**8*y**2+3465*x**8*z**2+36960*x**6*y**4-46200*x**6*y**2*z**2+6930*x**6*z**4-31680*x**4*y**6+110880*x**4*y**4*z**2-69300*x**4*y**2*z**4+6930*x**4*z**6+7040*x**2*y**8-63360*x**2*y**6*z**2+110880*x**2*y**4*z**4-46200*x**2*y**2*z**6+3465*x**2*z**8-256*y**10+7040*y**8*z**2-31680*y**6*z**4+36960*y**4*z**6-11550*y**2*z**8+693*z**10)/256",
            "[-sqrt(176358)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(72930)*I/1024,0,-15*sqrt(286)*I/1024,0,-sqrt(15015)*I/512,0,-21*sqrt(33)*I/512,0,-21*sqrt(33)*I/512,0,-sqrt(15015)*I/512,0,-15*sqrt(286)*I/1024,0,-sqrt(72930)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(176358)*I/1024]",
        ),
        "Qh(3,E,2,0)": (
            "-sqrt(10)*C1/4-sqrt(6)*C3/4",
            "sqrt(15)*x*(y-z)*(y+z)/2",
            "[sqrt(3)/4,0,sqrt(5)/4,0,-sqrt(5)/4,0,-sqrt(3)/4]",
        ),
        "Qh(3,E,2,1)": (
            "-sqrt(10)*S1/4+sqrt(6)*S3/4",
            "sqrt(15)*y*(x-z)*(x+z)/2",
            "[sqrt(3)*I/4,0,-sqrt(5)*I/4,0,-sqrt(5)*I/4,0,sqrt(3)*I/4]",
        ),
        "Qh(4,E,2,0)": (
            "-sqrt(2)*S1/4+sqrt(14)*S3/4",
            "sqrt(5)*y*z*(6*x**2-y**2-z**2)/2",
            "[0,sqrt(7)*I/4,0,-I/4,0,-I/4,0,sqrt(7)*I/4,0]",
        ),
        "Qh(4,E,2,1)": (
            "sqrt(2)*C1/4+sqrt(14)*C3/4",
            "sqrt(5)*x*z*(x**2-6*y**2+z**2)/2",
            "[0,-sqrt(7)/4,0,-1/4,0,1/4,0,sqrt(7)/4,0]",
        ),
        "Qh(5,E,2,0)": (
            "sqrt(21)*C1/8+9*sqrt(2)*C3/16+sqrt(10)*C5/16",
            "3*sqrt(35)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/8",
            "[-sqrt(5)/16,0,-9/16,0,-sqrt(42)/16,0,sqrt(42)/16,0,9/16,0,sqrt(5)/16]",
        ),
        "Qh(5,E,2,1)": (
            "sqrt(21)*S1/8-9*sqrt(2)*S3/16+sqrt(10)*S5/16",
            "3*sqrt(35)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/8",
            "[sqrt(5)*I/16,0,-9*I/16,0,sqrt(42)*I/16,0,sqrt(42)*I/16,0,-9*I/16,0,sqrt(5)*I/16]",
        ),
        "Qh(6,E,2,0)": (
            "3*sqrt(22)*S1/16+sqrt(55)*S3/16+sqrt(3)*S5/16",
            "sqrt(462)*y*z*(y**2-3*z**2)*(3*y**2-z**2)/16",
            "[0,sqrt(6)*I/32,0,sqrt(110)*I/32,0,3*sqrt(11)*I/16,0,3*sqrt(11)*I/16,0,sqrt(110)*I/32,0,sqrt(6)*I/32,0]",
        ),
        "Qh(6,E,2,1)": (
            "-3*sqrt(22)*C1/16+sqrt(55)*C3/16-sqrt(3)*C5/16",
            "-sqrt(462)*x*z*(x**2-3*z**2)*(3*x**2-z**2)/16",
            "[0,sqrt(6)/32,0,-sqrt(110)/32,0,3*sqrt(11)/16,0,-3*sqrt(11)/16,0,sqrt(110)/32,0,-sqrt(6)/32,0]",
        ),
        "Qh(7,E,2,0)": (
            "-3*sqrt(33)*C1/32-sqrt(11)*C3/32+25*C5/32+sqrt(91)*C7/32",
            "sqrt(231)*x*(10*x**2-3*y**2-3*z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[-sqrt(182)/64,0,-25*sqrt(2)/64,0,sqrt(22)/64,0,3*sqrt(66)/64,0,-3*sqrt(66)/64,0,-sqrt(22)/64,0,25*sqrt(2)/64,0,sqrt(182)/64]",
        ),
        "Qh(7,E,2,1)": (
            "-3*sqrt(33)*S1/32+sqrt(11)*S3/32+25*S5/32-sqrt(91)*S7/32",
            "-sqrt(231)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(3*x**2-10*y**2+3*z**2)/16",
            "[-sqrt(182)*I/64,0,25*sqrt(2)*I/64,0,sqrt(22)*I/64,0,-3*sqrt(66)*I/64,0,-3*sqrt(66)*I/64,0,sqrt(22)*I/64,0,25*sqrt(2)*I/64,0,-sqrt(182)*I/64]",
        ),
        "Qh(8,E,2,0)": (
            "-sqrt(77)*S1/32+5*sqrt(15)*S3/32-3*sqrt(13)*S5/32-sqrt(455)*S7/32",
            "3*sqrt(77)*y*z*(y-z)*(y+z)*(40*x**4-24*x**2*y**2-24*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,-sqrt(910)*I/64,0,-3*sqrt(26)*I/64,0,5*sqrt(30)*I/64,0,-sqrt(154)*I/64,0,-sqrt(154)*I/64,0,5*sqrt(30)*I/64,0,-3*sqrt(26)*I/64,0,-sqrt(910)*I/64,0]",
        ),
        "Qh(8,E,2,1)": (
            "sqrt(77)*C1/32+5*sqrt(15)*C3/32+3*sqrt(13)*C5/32-sqrt(455)*C7/32",
            "-3*sqrt(77)*x*z*(x-z)*(x+z)*(x**4-24*x**2*y**2+2*x**2*z**2+40*y**4-24*y**2*z**2+z**4)/16",
            "[0,sqrt(910)/64,0,-3*sqrt(26)/64,0,-5*sqrt(30)/64,0,-sqrt(154)/64,0,sqrt(154)/64,0,5*sqrt(30)/64,0,3*sqrt(26)/64,0,-sqrt(910)/64,0]",
        ),
        "Qh(9,E,2,0)": (
            "sqrt(2431)*C1/128+sqrt(9282)*C3/128+5*sqrt(170)*C5/128+7*sqrt(34)*C7/256+3*sqrt(2)*C9/256",
            "3*sqrt(12155)*x*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/128",
            "[-3/256,0,-7*sqrt(17)/256,0,-5*sqrt(85)/128,0,-sqrt(4641)/128,0,-sqrt(4862)/256,0,sqrt(4862)/256,0,sqrt(4641)/128,0,5*sqrt(85)/128,0,7*sqrt(17)/256,0,3/256]",
        ),
        "Qh(9,E,2,1)": (
            "sqrt(2431)*S1/128-sqrt(9282)*S3/128+5*sqrt(170)*S5/128-7*sqrt(34)*S7/256+3*sqrt(2)*S9/256",
            "3*sqrt(12155)*y*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/128",
            "[3*I/256,0,-7*sqrt(17)*I/256,0,5*sqrt(85)*I/128,0,-sqrt(4641)*I/128,0,sqrt(4862)*I/256,0,sqrt(4862)*I/256,0,-sqrt(4641)*I/128,0,5*sqrt(85)*I/128,0,-7*sqrt(17)*I/256,0,3*I/256]",
        ),
        "Qh(10,E,2,0)": (
            "sqrt(39)*S1/32-11*sqrt(2)*S3/32+5*sqrt(10)*S5/32-sqrt(34)*S7/64-sqrt(1938)*S9/64",
            "sqrt(2145)*y*z*(y-z)*(y+z)*(112*x**6-168*x**4*y**2-168*x**4*z**2+42*x**2*y**4+84*x**2*y**2*z**2+42*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,-sqrt(969)*I/64,0,-sqrt(17)*I/64,0,5*sqrt(5)*I/32,0,-11*I/32,0,sqrt(78)*I/64,0,sqrt(78)*I/64,0,-11*I/32,0,5*sqrt(5)*I/32,0,-sqrt(17)*I/64,0,-sqrt(969)*I/64,0]",
        ),
        "Qh(10,E,2,1)": (
            "-sqrt(39)*C1/32-11*sqrt(2)*C3/32-5*sqrt(10)*C5/32-sqrt(34)*C7/64+sqrt(1938)*C9/64",
            "sqrt(2145)*x*z*(x-z)*(x+z)*(x**6-42*x**4*y**2+3*x**4*z**2+168*x**2*y**4-84*x**2*y**2*z**2+3*x**2*z**4-112*y**6+168*y**4*z**2-42*y**2*z**4+z**6)/32",
            "[0,-sqrt(969)/64,0,sqrt(17)/64,0,5*sqrt(5)/32,0,11/32,0,sqrt(78)/64,0,-sqrt(78)/64,0,-11/32,0,-5*sqrt(5)/32,0,-sqrt(17)/64,0,sqrt(969)/64,0]",
        ),
        "Qh(11,E,2,0)": (
            "-sqrt(41990)*C1/512+sqrt(385)*C11/512-3*sqrt(4522)*C3/512+3*sqrt(4845)*C5/512+77*sqrt(19)*C7/512+39*sqrt(15)*C9/512",
            "sqrt(692835)*x*(6*x**2-y**2-z**2)*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/256",
            "[-sqrt(770)/1024,0,-39*sqrt(30)/1024,0,-77*sqrt(38)/1024,0,-3*sqrt(9690)/1024,0,3*sqrt(2261)/512,0,sqrt(20995)/512,0,-sqrt(20995)/512,0,-3*sqrt(2261)/512,0,3*sqrt(9690)/1024,0,77*sqrt(38)/1024,0,39*sqrt(30)/1024,0,sqrt(770)/1024]",
        ),
        "Qh(11,E,2,1)": (
            "-sqrt(41990)*S1/512-sqrt(385)*S11/512+3*sqrt(4522)*S3/512+3*sqrt(4845)*S5/512-77*sqrt(19)*S7/512+39*sqrt(15)*S9/512",
            "-sqrt(692835)*y*(x**2-6*y**2+z**2)*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/256",
            "[-sqrt(770)*I/1024,0,39*sqrt(30)*I/1024,0,-77*sqrt(38)*I/1024,0,3*sqrt(9690)*I/1024,0,3*sqrt(2261)*I/512,0,-sqrt(20995)*I/512,0,-sqrt(20995)*I/512,0,3*sqrt(2261)*I/512,0,3*sqrt(9690)*I/1024,0,-77*sqrt(38)*I/1024,0,39*sqrt(30)*I/1024,0,-sqrt(770)*I/1024]",
        ),
        "Qh(5,E,3,0)": (
            "sqrt(7)*C1/4-sqrt(6)*C3/8-sqrt(30)*C5/8",
            "sqrt(105)*x*(y-z)*(y+z)*(2*x**2-y**2-z**2)/4",
            "[sqrt(15)/8,0,sqrt(3)/8,0,-sqrt(14)/8,0,sqrt(14)/8,0,-sqrt(3)/8,0,-sqrt(15)/8]",
        ),
        "Qh(5,E,3,1)": (
            "sqrt(7)*S1/4+sqrt(6)*S3/8-sqrt(30)*S5/8",
            "-sqrt(105)*y*(x-z)*(x+z)*(x**2-2*y**2+z**2)/4",
            "[-sqrt(15)*I/8,0,sqrt(3)*I/8,0,sqrt(14)*I/8,0,sqrt(14)*I/8,0,sqrt(3)*I/8,0,-sqrt(15)*I/8]",
        ),
        "Qh(6,E,3,0)": (
            "sqrt(10)*S1/16-9*S3/16+sqrt(165)*S5/16",
            "sqrt(210)*y*z*(16*x**4-16*x**2*y**2-16*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,sqrt(330)*I/32,0,-9*sqrt(2)*I/32,0,sqrt(5)*I/16,0,sqrt(5)*I/16,0,-9*sqrt(2)*I/32,0,sqrt(330)*I/32,0]",
        ),
        "Qh(6,E,3,1)": (
            "-sqrt(10)*C1/16-9*C3/16-sqrt(165)*C5/16",
            "-sqrt(210)*x*z*(x**4-16*x**2*y**2+2*x**2*z**2+16*y**4-16*y**2*z**2+z**4)/16",
            "[0,sqrt(330)/32,0,9*sqrt(2)/32,0,sqrt(5)/16,0,-sqrt(5)/16,0,-9*sqrt(2)/32,0,-sqrt(330)/32,0]",
        ),
        "Qh(7,E,3,0)": (
            "-sqrt(858)*C1/64-3*sqrt(286)*C3/64-5*sqrt(26)*C5/64-sqrt(14)*C7/64",
            "sqrt(6006)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/32",
            "[sqrt(7)/64,0,5*sqrt(13)/64,0,3*sqrt(143)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-3*sqrt(143)/64,0,-5*sqrt(13)/64,0,-sqrt(7)/64]",
        ),
        "Qh(7,E,3,1)": (
            "-sqrt(858)*S1/64+3*sqrt(286)*S3/64-5*sqrt(26)*S5/64+sqrt(14)*S7/64",
            "sqrt(6006)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)/32",
            "[sqrt(7)*I/64,0,-5*sqrt(13)*I/64,0,3*sqrt(143)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,3*sqrt(143)*I/64,0,-5*sqrt(13)*I/64,0,sqrt(7)*I/64]",
        ),
        "Qh(8,E,3,0)": (
            "-sqrt(858)*S1/64+sqrt(910)*S3/64+7*sqrt(42)*S5/64+3*sqrt(30)*S7/64",
            "sqrt(858)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(14*x**2-y**2-z**2)/32",
            "[0,3*sqrt(15)*I/64,0,7*sqrt(21)*I/64,0,sqrt(455)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(455)*I/64,0,7*sqrt(21)*I/64,0,3*sqrt(15)*I/64,0]",
        ),
        "Qh(8,E,3,1)": (
            "sqrt(858)*C1/64+sqrt(910)*C3/64-7*sqrt(42)*C5/64+3*sqrt(30)*C7/64",
            "sqrt(858)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(x**2-14*y**2+z**2)/32",
            "[0,-3*sqrt(15)/64,0,7*sqrt(21)/64,0,-sqrt(455)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(455)/64,0,-7*sqrt(21)/64,0,3*sqrt(15)/64,0]",
        ),
        "Qh(9,E,3,0)": (
            "sqrt(1001)*C1/64-sqrt(78)*C3/64-3*sqrt(70)*C5/64+23*sqrt(14)*C7/128+3*sqrt(238)*C9/128",
            "3*sqrt(5005)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(8*x**4-8*x**2*y**2-8*x**2*z**2+y**4+2*y**2*z**2+z**4)/64",
            "[-3*sqrt(119)/128,0,-23*sqrt(7)/128,0,3*sqrt(35)/64,0,sqrt(39)/64,0,-sqrt(2002)/128,0,sqrt(2002)/128,0,-sqrt(39)/64,0,-3*sqrt(35)/64,0,23*sqrt(7)/128,0,3*sqrt(119)/128]",
        ),
        "Qh(9,E,3,1)": (
            "sqrt(1001)*S1/64+sqrt(78)*S3/64-3*sqrt(70)*S5/64-23*sqrt(14)*S7/128+3*sqrt(238)*S9/128",
            "3*sqrt(5005)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(x**4-8*x**2*y**2+2*x**2*z**2+8*y**4-8*y**2*z**2+z**4)/64",
            "[3*sqrt(119)*I/128,0,-23*sqrt(7)*I/128,0,-3*sqrt(35)*I/64,0,sqrt(39)*I/64,0,sqrt(2002)*I/128,0,sqrt(2002)*I/128,0,sqrt(39)*I/64,0,-3*sqrt(35)*I/64,0,-23*sqrt(7)*I/128,0,3*sqrt(119)*I/128]",
        ),
        "Qh(10,E,3,0)": (
            "sqrt(41990)*S1/256+sqrt(4845)*S3/128+sqrt(969)*S5/128+sqrt(285)*S7/256+sqrt(5)*S9/256",
            "sqrt(92378)*y*z*(y**4-10*y**2*z**2+5*z**4)*(5*y**4-10*y**2*z**2+z**4)/256",
            "[0,sqrt(10)*I/512,0,sqrt(570)*I/512,0,sqrt(1938)*I/256,0,sqrt(9690)*I/256,0,sqrt(20995)*I/256,0,sqrt(20995)*I/256,0,sqrt(9690)*I/256,0,sqrt(1938)*I/256,0,sqrt(570)*I/512,0,sqrt(10)*I/512,0]",
        ),
        "Qh(10,E,3,1)": (
            "-sqrt(41990)*C1/256+sqrt(4845)*C3/128-sqrt(969)*C5/128+sqrt(285)*C7/256-sqrt(5)*C9/256",
            "-sqrt(92378)*x*z*(x**4-10*x**2*z**2+5*z**4)*(5*x**4-10*x**2*z**2+z**4)/256",
            "[0,sqrt(10)/512,0,-sqrt(570)/512,0,sqrt(1938)/256,0,-sqrt(9690)/256,0,sqrt(20995)/256,0,-sqrt(20995)/256,0,sqrt(9690)/256,0,-sqrt(1938)/256,0,sqrt(570)/512,0,-sqrt(10)/512,0]",
        ),
        "Qh(11,E,3,0)": (
            "-5*sqrt(546)*C1/256+sqrt(10659)*C11/256+11*sqrt(30)*C3/256+13*sqrt(7)*C5/256-3*sqrt(1785)*C7/256+3*sqrt(2261)*C9/256",
            "3*sqrt(1001)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(80*x**6-168*x**4*y**2-168*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-5*y**6-15*y**4*z**2-15*y**2*z**4-5*z**6)/128",
            "[-sqrt(21318)/512,0,-3*sqrt(4522)/512,0,3*sqrt(3570)/512,0,-13*sqrt(14)/512,0,-11*sqrt(15)/256,0,5*sqrt(273)/256,0,-5*sqrt(273)/256,0,11*sqrt(15)/256,0,13*sqrt(14)/512,0,-3*sqrt(3570)/512,0,3*sqrt(4522)/512,0,sqrt(21318)/512]",
        ),
        "Qh(11,E,3,1)": (
            "-5*sqrt(546)*S1/256-sqrt(10659)*S11/256-11*sqrt(30)*S3/256+13*sqrt(7)*S5/256+3*sqrt(1785)*S7/256+3*sqrt(2261)*S9/256",
            "-3*sqrt(1001)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(5*x**6-70*x**4*y**2+15*x**4*z**2+168*x**2*y**4-140*x**2*y**2*z**2+15*x**2*z**4-80*y**6+168*y**4*z**2-70*y**2*z**4+5*z**6)/128",
            "[-sqrt(21318)*I/512,0,3*sqrt(4522)*I/512,0,3*sqrt(3570)*I/512,0,13*sqrt(14)*I/512,0,-11*sqrt(15)*I/256,0,-5*sqrt(273)*I/256,0,-5*sqrt(273)*I/256,0,-11*sqrt(15)*I/256,0,13*sqrt(14)*I/512,0,3*sqrt(3570)*I/512,0,3*sqrt(4522)*I/512,0,-sqrt(21318)*I/512]",
        ),
        "Qh(7,E,4,0)": (
            "-15*sqrt(6)*C1/64+19*sqrt(2)*C3/64-sqrt(22)*C5/64-sqrt(2002)*C7/64",
            "sqrt(42)*x*(y-z)*(y+z)*(48*x**4-80*x**2*y**2-80*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/32",
            "[sqrt(1001)/64,0,sqrt(11)/64,0,-19/64,0,15*sqrt(3)/64,0,-15*sqrt(3)/64,0,19/64,0,-sqrt(11)/64,0,-sqrt(1001)/64]",
        ),
        "Qh(7,E,4,1)": (
            "-15*sqrt(6)*S1/64-19*sqrt(2)*S3/64-sqrt(22)*S5/64+sqrt(2002)*S7/64",
            "sqrt(42)*y*(x-z)*(x+z)*(15*x**4-80*x**2*y**2+30*x**2*z**2+48*y**4-80*y**2*z**2+15*z**4)/32",
            "[sqrt(1001)*I/64,0,-sqrt(11)*I/64,0,-19*I/64,0,-15*sqrt(3)*I/64,0,-15*sqrt(3)*I/64,0,-19*I/64,0,-sqrt(11)*I/64,0,sqrt(1001)*I/64]",
        ),
        "Qh(8,E,4,0)": (
            "-sqrt(70)*S1/64+3*sqrt(66)*S3/64-sqrt(1430)*S5/64+sqrt(2002)*S7/64",
            "3*sqrt(70)*y*z*(32*x**6-80*x**4*y**2-80*x**4*z**2+30*x**2*y**4+60*x**2*y**2*z**2+30*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,sqrt(1001)*I/64,0,-sqrt(715)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(35)*I/64,0,-sqrt(35)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(715)*I/64,0,sqrt(1001)*I/64,0]",
        ),
        "Qh(8,E,4,1)": (
            "sqrt(70)*C1/64+3*sqrt(66)*C3/64+sqrt(1430)*C5/64+sqrt(2002)*C7/64",
            "3*sqrt(70)*x*z*(x**6-30*x**4*y**2+3*x**4*z**2+80*x**2*y**4-60*x**2*y**2*z**2+3*x**2*z**4-32*y**6+80*y**4*z**2-30*y**2*z**4+z**6)/32",
            "[0,-sqrt(1001)/64,0,-sqrt(715)/64,0,-3*sqrt(33)/64,0,-sqrt(35)/64,0,sqrt(35)/64,0,3*sqrt(33)/64,0,sqrt(715)/64,0,sqrt(1001)/64,0]",
        ),
        "Qh(9,E,4,0)": (
            "sqrt(858)*C1/64+sqrt(91)*C3/32-5*sqrt(15)*C5/32-21*sqrt(3)*C7/64-sqrt(51)*C9/64",
            "sqrt(4290)*x*(y-z)*(y+z)*(14*x**2-3*y**2-3*z**2)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/64",
            "[sqrt(102)/128,0,21*sqrt(6)/128,0,5*sqrt(30)/64,0,-sqrt(182)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(182)/64,0,-5*sqrt(30)/64,0,-21*sqrt(6)/128,0,-sqrt(102)/128]",
        ),
        "Qh(9,E,4,1)": (
            "sqrt(858)*S1/64-sqrt(91)*S3/32-5*sqrt(15)*S5/32+21*sqrt(3)*S7/64-sqrt(51)*S9/64",
            "-sqrt(4290)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(3*x**2-14*y**2+3*z**2)/64",
            "[-sqrt(102)*I/128,0,21*sqrt(6)*I/128,0,-5*sqrt(30)*I/64,0,-sqrt(182)*I/64,0,sqrt(429)*I/64,0,sqrt(429)*I/64,0,-sqrt(182)*I/64,0,-5*sqrt(30)*I/64,0,21*sqrt(6)*I/128,0,-sqrt(102)*I/128]",
        ),
        "Qh(10,E,4,0)": (
            "9*sqrt(78)*S1/256-69*S3/128-sqrt(5)*S5/128+43*sqrt(17)*S7/256+3*sqrt(969)*S9/256",
            "sqrt(4290)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(224*x**4-96*x**2*y**2-96*x**2*z**2+3*y**4+6*y**2*z**2+3*z**4)/256",
            "[0,3*sqrt(1938)*I/512,0,43*sqrt(34)*I/512,0,-sqrt(10)*I/256,0,-69*sqrt(2)*I/256,0,9*sqrt(39)*I/256,0,9*sqrt(39)*I/256,0,-69*sqrt(2)*I/256,0,-sqrt(10)*I/256,0,43*sqrt(34)*I/512,0,3*sqrt(1938)*I/512,0]",
        ),
        "Qh(10,E,4,1)": (
            "-9*sqrt(78)*C1/256-69*C3/128+sqrt(5)*C5/128+43*sqrt(17)*C7/256-3*sqrt(969)*C9/256",
            "-sqrt(4290)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(3*x**4-96*x**2*y**2+6*x**2*z**2+224*y**4-96*y**2*z**2+3*z**4)/256",
            "[0,3*sqrt(1938)/512,0,-43*sqrt(34)/512,0,-sqrt(10)/256,0,69*sqrt(2)/256,0,9*sqrt(39)/256,0,-9*sqrt(39)/256,0,-69*sqrt(2)/256,0,sqrt(10)/256,0,43*sqrt(34)/512,0,-3*sqrt(1938)/512,0]",
        ),
        "Qh(11,E,4,0)": (
            "-sqrt(29393)*C1/512-sqrt(22)*C11/1024-9*sqrt(1615)*C3/512-5*sqrt(13566)*C5/1024-7*sqrt(1330)*C7/1024-9*sqrt(42)*C9/1024",
            "sqrt(1939938)*x*(y-z)*(y+z)*(y**4-4*y**3*z-14*y**2*z**2-4*y*z**3+z**4)*(y**4+4*y**3*z-14*y**2*z**2+4*y*z**3+z**4)/512",
            "[sqrt(11)/1024,0,9*sqrt(21)/1024,0,7*sqrt(665)/1024,0,5*sqrt(6783)/1024,0,9*sqrt(3230)/1024,0,sqrt(58786)/1024,0,-sqrt(58786)/1024,0,-9*sqrt(3230)/1024,0,-5*sqrt(6783)/1024,0,-7*sqrt(665)/1024,0,-9*sqrt(21)/1024,0,-sqrt(11)/1024]",
        ),
        "Qh(11,E,4,1)": (
            "-sqrt(29393)*S1/512+sqrt(22)*S11/1024+9*sqrt(1615)*S3/512-5*sqrt(13566)*S5/1024+7*sqrt(1330)*S7/1024-9*sqrt(42)*S9/1024",
            "sqrt(1939938)*y*(x-z)*(x+z)*(x**4-4*x**3*z-14*x**2*z**2-4*x*z**3+z**4)*(x**4+4*x**3*z-14*x**2*z**2+4*x*z**3+z**4)/512",
            "[sqrt(11)*I/1024,0,-9*sqrt(21)*I/1024,0,7*sqrt(665)*I/1024,0,-5*sqrt(6783)*I/1024,0,9*sqrt(3230)*I/1024,0,-sqrt(58786)*I/1024,0,-sqrt(58786)*I/1024,0,9*sqrt(3230)*I/1024,0,-5*sqrt(6783)*I/1024,0,7*sqrt(665)*I/1024,0,-9*sqrt(21)*I/1024,0,sqrt(11)*I/1024]",
        ),
        "Qh(9,E,5,0)": (
            "7*sqrt(22)*C1/64-3*sqrt(21)*C3/32+sqrt(65)*C5/32+sqrt(13)*C7/64-3*sqrt(221)*C9/64",
            "3*sqrt(110)*x*(y-z)*(y+z)*(32*x**6-112*x**4*y**2-112*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-7*y**6-21*y**4*z**2-21*y**2*z**4-7*z**6)/64",
            "[3*sqrt(442)/128,0,-sqrt(26)/128,0,-sqrt(130)/64,0,3*sqrt(42)/64,0,-7*sqrt(11)/64,0,7*sqrt(11)/64,0,-3*sqrt(42)/64,0,sqrt(130)/64,0,sqrt(26)/128,0,-3*sqrt(442)/128]",
        ),
        "Qh(9,E,5,1)": (
            "7*sqrt(22)*S1/64+3*sqrt(21)*S3/32+sqrt(65)*S5/32-sqrt(13)*S7/64-3*sqrt(221)*S9/64",
            "-3*sqrt(110)*y*(x-z)*(x+z)*(7*x**6-70*x**4*y**2+21*x**4*z**2+112*x**2*y**4-140*x**2*y**2*z**2+21*x**2*z**4-32*y**6+112*y**4*z**2-70*y**2*z**4+7*z**6)/64",
            "[-3*sqrt(442)*I/128,0,-sqrt(26)*I/128,0,sqrt(130)*I/64,0,3*sqrt(42)*I/64,0,7*sqrt(11)*I/64,0,7*sqrt(11)*I/64,0,3*sqrt(42)*I/64,0,sqrt(130)*I/64,0,-sqrt(26)*I/128,0,-3*sqrt(442)*I/128]",
        ),
        "Qh(10,E,5,0)": (
            "7*sqrt(3)*S1/128-7*sqrt(26)*S3/128+5*sqrt(130)*S5/128-7*sqrt(442)*S7/256+sqrt(25194)*S9/256",
            "sqrt(165)*y*z*(384*x**8-1792*x**6*y**2-1792*x**6*z**2+1680*x**4*y**4+3360*x**4*y**2*z**2+1680*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+7*y**8+28*y**6*z**2+42*y**4*z**4+28*y**2*z**6+7*z**8)/128",
            "[0,sqrt(12597)*I/256,0,-7*sqrt(221)*I/256,0,5*sqrt(65)*I/128,0,-7*sqrt(13)*I/128,0,7*sqrt(6)*I/256,0,7*sqrt(6)*I/256,0,-7*sqrt(13)*I/128,0,5*sqrt(65)*I/128,0,-7*sqrt(221)*I/256,0,sqrt(12597)*I/256,0]",
        ),
        "Qh(10,E,5,1)": (
            "-7*sqrt(3)*C1/128-7*sqrt(26)*C3/128-5*sqrt(130)*C5/128-7*sqrt(442)*C7/256-sqrt(25194)*C9/256",
            "-sqrt(165)*x*z*(7*x**8-336*x**6*y**2+28*x**6*z**2+1680*x**4*y**4-1008*x**4*y**2*z**2+42*x**4*z**4-1792*x**2*y**6+3360*x**2*y**4*z**2-1008*x**2*y**2*z**4+28*x**2*z**6+384*y**8-1792*y**6*z**2+1680*y**4*z**4-336*y**2*z**6+7*z**8)/128",
            "[0,sqrt(12597)/256,0,7*sqrt(221)/256,0,5*sqrt(65)/128,0,7*sqrt(13)/128,0,7*sqrt(6)/256,0,-7*sqrt(6)/256,0,-7*sqrt(13)/128,0,-5*sqrt(65)/128,0,-7*sqrt(221)/256,0,-sqrt(12597)/256,0]",
        ),
        "Qh(11,E,5,0)": (
            "-15*sqrt(221)*C1/512-3*sqrt(2926)*C11/1024-sqrt(595)*C3/512+53*sqrt(102)*C5/1024-105*sqrt(10)*C7/1024-61*sqrt(114)*C9/1024",
            "sqrt(14586)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)*(224*x**4-160*x**2*y**2-160*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/512",
            "[3*sqrt(1463)/1024,0,61*sqrt(57)/1024,0,105*sqrt(5)/1024,0,-53*sqrt(51)/1024,0,sqrt(1190)/1024,0,15*sqrt(442)/1024,0,-15*sqrt(442)/1024,0,-sqrt(1190)/1024,0,53*sqrt(51)/1024,0,-105*sqrt(5)/1024,0,-61*sqrt(57)/1024,0,-3*sqrt(1463)/1024]",
        ),
        "Qh(11,E,5,1)": (
            "-15*sqrt(221)*S1/512+3*sqrt(2926)*S11/1024+sqrt(595)*S3/512+53*sqrt(102)*S5/1024+105*sqrt(10)*S7/1024-61*sqrt(114)*S9/1024",
            "sqrt(14586)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(15*x**4-160*x**2*y**2+30*x**2*z**2+224*y**4-160*y**2*z**2+15*z**4)/512",
            "[3*sqrt(1463)*I/1024,0,-61*sqrt(57)*I/1024,0,105*sqrt(5)*I/1024,0,53*sqrt(51)*I/1024,0,sqrt(1190)*I/1024,0,-15*sqrt(442)*I/1024,0,-15*sqrt(442)*I/1024,0,sqrt(1190)*I/1024,0,53*sqrt(51)*I/1024,0,105*sqrt(5)*I/1024,0,-61*sqrt(57)*I/1024,0,3*sqrt(1463)*I/1024]",
        ),
        "Qh(11,E,6,0)": (
            "-21*sqrt(130)*C1/512-sqrt(124355)*C11/512+57*sqrt(14)*C3/512-41*sqrt(15)*C5/512+17*sqrt(17)*C7/512+sqrt(4845)*C9/512",
            "sqrt(2145)*x*(y-z)*(y+z)*(128*x**8-768*x**6*y**2-768*x**6*z**2+1008*x**4*y**4+2016*x**4*y**2*z**2+1008*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+21*y**8+84*y**6*z**2+126*y**4*z**4+84*y**2*z**6+21*z**8)/256",
            "[sqrt(248710)/1024,0,-sqrt(9690)/1024,0,-17*sqrt(34)/1024,0,41*sqrt(30)/1024,0,-57*sqrt(7)/512,0,21*sqrt(65)/512,0,-21*sqrt(65)/512,0,57*sqrt(7)/512,0,-41*sqrt(30)/1024,0,17*sqrt(34)/1024,0,sqrt(9690)/1024,0,-sqrt(248710)/1024]",
        ),
        "Qh(11,E,6,1)": (
            "-21*sqrt(130)*S1/512+sqrt(124355)*S11/512-57*sqrt(14)*S3/512-41*sqrt(15)*S5/512-17*sqrt(17)*S7/512+sqrt(4845)*S9/512",
            "sqrt(2145)*y*(x-z)*(x+z)*(21*x**8-336*x**6*y**2+84*x**6*z**2+1008*x**4*y**4-1008*x**4*y**2*z**2+126*x**4*z**4-768*x**2*y**6+2016*x**2*y**4*z**2-1008*x**2*y**2*z**4+84*x**2*z**6+128*y**8-768*y**6*z**2+1008*y**4*z**4-336*y**2*z**6+21*z**8)/256",
            "[sqrt(248710)*I/1024,0,sqrt(9690)*I/1024,0,-17*sqrt(34)*I/1024,0,-41*sqrt(30)*I/1024,0,-57*sqrt(7)*I/512,0,-21*sqrt(65)*I/512,0,-21*sqrt(65)*I/512,0,-57*sqrt(7)*I/512,0,-41*sqrt(30)*I/1024,0,-17*sqrt(34)*I/1024,0,sqrt(9690)*I/1024,0,sqrt(248710)*I/1024]",
        ),
    },
    "C4v": {
        "Qh(0,A1,,)": ("C0", "1", "[1]"),
        "Qh(1,A1,,)": ("C0", "z", "[0,1,0]"),
        "Qh(2,A1,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(3,A1,,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(4,A1,1,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Qh(5,A1,1,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(6,A1,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Qh(7,A1,1,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(8,A1,1,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Qh(9,A1,1,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A1,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Qh(11,A1,1,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(4,A1,2,)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "-sqrt(15)*(x**4-12*x**2*y**2+6*x**2*z**2+y**4+6*y**2*z**2-2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Qh(5,A1,2,)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(6,A1,2,)": (
            "sqrt(14)*C0/4+sqrt(2)*C4/4",
            "-sqrt(14)*(x**6-15*x**4*z**2+15*x**2*z**4+y**6-15*y**4*z**2+15*y**2*z**4-2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Qh(7,A1,2,)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(8,A1,2,)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Qh(9,A1,2,)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(10,A1,2,)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "-sqrt(420189)*(22*x**10+45*x**8*y**2-1035*x**8*z**2-105*x**6*y**4-630*x**6*y**2*z**2+4935*x**6*z**4-105*x**4*y**6+3150*x**4*y**4*z**2-1575*x**4*y**2*z**4-4830*x**4*z**6+45*x**2*y**8-630*x**2*y**6*z**2-1575*x**2*y**4*z**4+1260*x**2*y**2*z**6+990*x**2*z**8+22*y**10-1035*y**8*z**2+4935*y**6*z**4-4830*y**4*z**6+990*y**2*z**8-44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Qh(11,A1,2,)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(8,A1,3,)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Qh(9,A1,3,)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(10,A1,3,)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "-sqrt(3213210)*(3*x**10-96*x**8*y**2-39*x**8*z**2+224*x**6*y**4+1344*x**6*y**2*z**2-42*x**6*z**4+224*x**4*y**6-6720*x**4*y**4*z**2+3360*x**4*y**2*z**4-182*x**4*z**6-96*x**2*y**8+1344*x**2*y**6*z**2+3360*x**2*y**4*z**4-2688*x**2*y**2*z**6+135*x**2*z**8+3*y**10-39*y**8*z**2-42*y**6*z**4-182*y**4*z**6+135*y**2*z**8-6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Qh(11,A1,3,)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(4,A2,,)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(5,A2,,)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(6,A2,,)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(7,A2,,)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(8,A2,1,)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(9,A2,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Qh(10,A2,1,)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(11,A2,1,)": (
            "S8",
            "-sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(8,A2,2,)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(9,A2,2,)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(x-y)*(x+y)*(3*x**4-11*x**2*y**2-7*x**2*z**2+3*y**4-7*y**2*z**2+7*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Qh(10,A2,2,)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(11,A2,2,)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(2,B1,,)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(3,B1,,)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(4,B1,,)": ("-C2", "sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Qh(5,B1,,)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(6,B1,1,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Qh(7,B1,1,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(8,B1,1,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,B1,1,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(10,B1,1,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Qh(11,B1,1,)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(6,B1,2,)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x-y)*(x+y)*(x**4-9*x**2*y**2-5*x**2*z**2+y**4-5*y**2*z**2+5*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Qh(7,B1,2,)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(8,B1,2,)": (
            "C2",
            "-3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(9,B1,2,)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,B1,2,)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(x-y)*(x+y)*(22*x**8-653*x**6*y**2-315*x**6*z**2+2602*x**4*y**4-945*x**4*y**2*z**2+1575*x**4*z**4-653*x**2*y**6-945*x**2*y**4*z**2+3150*x**2*y**2*z**4-1680*x**2*z**6+22*y**8-315*y**6*z**2+1575*y**4*z**4-1680*y**2*z**6+360*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Qh(11,B1,2,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(10,B1,3,)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(x-y)*(x+y)*(9*x**8-165*x**6*y**2-231*x**6*z**2-25*x**4*y**4+3801*x**4*y**2*z**2+406*x**4*z**4-165*x**2*y**6+3801*x**2*y**4*z**2-9674*x**2*y**2*z**4+266*x**2*z**6+9*y**8-231*y**6*z**2+406*y**4*z**4+266*y**2*z**6-57*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Qh(11,B1,3,)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(2,B2,,)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Qh(3,B2,,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(4,B2,,)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(5,B2,,)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(6,B2,1,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(7,B2,1,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Qh(8,B2,1,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(9,B2,1,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Qh(10,B2,1,)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(11,B2,1,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Qh(6,B2,2,)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(7,B2,2,)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "-sqrt(77)*x*y*z*(3*x**4-20*x**2*y**2+10*x**2*z**2+3*y**4+10*y**2*z**2-6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Qh(8,B2,2,)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,B2,2,)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Qh(10,B2,2,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(11,B2,2,)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "-sqrt(230945)*x*y*z*(x**8-6*x**6*y**2-6*x**6*z**2+42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2-84*x**2*y**2*z**4+12*x**2*z**6+y**8-6*y**6*z**2+12*y**2*z**6-2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Qh(10,B2,3,)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,B2,3,)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "-sqrt(3003)*x*y*z*(5*x**8-150*x**6*y**2+90*x**6*z**2+336*x**4*y**4-70*x**4*y**2*z**2-168*x**4*z**4-150*x**2*y**6-70*x**2*y**4*z**2+140*x**2*y**2*z**4+60*x**2*z**6+5*y**8+90*y**6*z**2-168*y**4*z**4+60*y**2*z**6-10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Qh(1,E,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(1,E,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(2,E,,0)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Qh(2,E,,1)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(3,E,1,0)": (
            "-sqrt(6)*C1/4+sqrt(10)*C3/4",
            "x*(2*x**2-3*y**2-3*z**2)/2",
            "[-sqrt(5)/4,0,sqrt(3)/4,0,-sqrt(3)/4,0,sqrt(5)/4]",
        ),
        "Qh(3,E,1,1)": (
            "-sqrt(6)*S1/4-sqrt(10)*S3/4",
            "-y*(3*x**2-2*y**2+3*z**2)/2",
            "[-sqrt(5)*I/4,0,-sqrt(3)*I/4,0,-sqrt(3)*I/4,0,-sqrt(5)*I/4]",
        ),
        "Qh(4,E,1,0)": ("sqrt(14)*C1/4-sqrt(2)*C3/4", "-sqrt(35)*x*z*(x-z)*(x+z)/2", "[0,1/4,0,-sqrt(7)/4,0,sqrt(7)/4,0,-1/4,0]"),
        "Qh(4,E,1,1)": (
            "sqrt(14)*S1/4+sqrt(2)*S3/4",
            "-sqrt(35)*y*z*(y-z)*(y+z)/2",
            "[0,I/4,0,sqrt(7)*I/4,0,sqrt(7)*I/4,0,I/4,0]",
        ),
        "Qh(5,E,1,0)": (
            "sqrt(15)*C1/8-sqrt(70)*C3/16+3*sqrt(14)*C5/16",
            "x*(8*x**4-40*x**2*y**2-40*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/8",
            "[-3*sqrt(7)/16,0,sqrt(35)/16,0,-sqrt(30)/16,0,sqrt(30)/16,0,-sqrt(35)/16,0,3*sqrt(7)/16]",
        ),
        "Qh(5,E,1,1)": (
            "sqrt(15)*S1/8+sqrt(70)*S3/16+3*sqrt(14)*S5/16",
            "y*(15*x**4-40*x**2*y**2+30*x**2*z**2+8*y**4-40*y**2*z**2+15*z**4)/8",
            "[3*sqrt(7)*I/16,0,sqrt(35)*I/16,0,sqrt(30)*I/16,0,sqrt(30)*I/16,0,sqrt(35)*I/16,0,3*sqrt(7)*I/16]",
        ),
        "Qh(6,E,1,0)": (
            "-sqrt(3)*C1/4-sqrt(30)*C3/8+sqrt(22)*C5/8",
            "3*sqrt(7)*x*z*(x-z)*(x+z)*(x**2-10*y**2+z**2)/4",
            "[0,-sqrt(11)/8,0,sqrt(15)/8,0,sqrt(6)/8,0,-sqrt(6)/8,0,-sqrt(15)/8,0,sqrt(11)/8,0]",
        ),
        "Qh(6,E,1,1)": (
            "-sqrt(3)*S1/4+sqrt(30)*S3/8+sqrt(22)*S5/8",
            "-3*sqrt(7)*y*z*(y-z)*(y+z)*(10*x**2-y**2-z**2)/4",
            "[0,sqrt(11)*I/8,0,sqrt(15)*I/8,0,-sqrt(6)*I/8,0,-sqrt(6)*I/8,0,sqrt(15)*I/8,0,sqrt(11)*I/8,0]",
        ),
        "Qh(7,E,1,0)": (
            "-5*sqrt(7)*C1/32+3*sqrt(21)*C3/32-sqrt(231)*C5/32+sqrt(429)*C7/32",
            "x*(16*x**6-168*x**4*y**2-168*x**4*z**2+210*x**2*y**4+420*x**2*y**2*z**2+210*x**2*z**4-35*y**6-105*y**4*z**2-105*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)/64,0,sqrt(462)/64,0,-3*sqrt(42)/64,0,5*sqrt(14)/64,0,-5*sqrt(14)/64,0,3*sqrt(42)/64,0,-sqrt(462)/64,0,sqrt(858)/64]",
        ),
        "Qh(7,E,1,1)": (
            "-5*sqrt(7)*S1/32-3*sqrt(21)*S3/32-sqrt(231)*S5/32-sqrt(429)*S7/32",
            "-y*(35*x**6-210*x**4*y**2+105*x**4*z**2+168*x**2*y**4-420*x**2*y**2*z**2+105*x**2*z**4-16*y**6+168*y**4*z**2-210*y**2*z**4+35*z**6)/16",
            "[-sqrt(858)*I/64,0,-sqrt(462)*I/64,0,-3*sqrt(42)*I/64,0,-5*sqrt(14)*I/64,0,-5*sqrt(14)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(462)*I/64,0,-sqrt(858)*I/64]",
        ),
        "Qh(8,E,1,0)": (
            "sqrt(715)*C1/32-sqrt(273)*C3/32+sqrt(35)*C5/32-C7/32",
            "-3*sqrt(715)*x*z*(x-z)*(x+z)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/16",
            "[0,sqrt(2)/64,0,-sqrt(70)/64,0,sqrt(546)/64,0,-sqrt(1430)/64,0,sqrt(1430)/64,0,-sqrt(546)/64,0,sqrt(70)/64,0,-sqrt(2)/64,0]",
        ),
        "Qh(8,E,1,1)": (
            "sqrt(715)*S1/32+sqrt(273)*S3/32+sqrt(35)*S5/32+S7/32",
            "-3*sqrt(715)*y*z*(y-z)*(y+z)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[0,sqrt(2)*I/64,0,sqrt(70)*I/64,0,sqrt(546)*I/64,0,sqrt(1430)*I/64,0,sqrt(1430)*I/64,0,sqrt(546)*I/64,0,sqrt(70)*I/64,0,sqrt(2)*I/64,0]",
        ),
        "Qh(9,E,1,0)": (
            "21*sqrt(5)*C1/128-sqrt(2310)*C3/128+3*sqrt(286)*C5/128-3*sqrt(1430)*C7/256+sqrt(24310)*C9/256",
            "x*(128*x**8-2304*x**6*y**2-2304*x**6*z**2+6048*x**4*y**4+12096*x**4*y**2*z**2+6048*x**4*z**4-3360*x**2*y**6-10080*x**2*y**4*z**2-10080*x**2*y**2*z**4-3360*x**2*z**6+315*y**8+1260*y**6*z**2+1890*y**4*z**4+1260*y**2*z**6+315*z**8)/128",
            "[-sqrt(12155)/256,0,3*sqrt(715)/256,0,-3*sqrt(143)/128,0,sqrt(1155)/128,0,-21*sqrt(10)/256,0,21*sqrt(10)/256,0,-sqrt(1155)/128,0,3*sqrt(143)/128,0,-3*sqrt(715)/256,0,sqrt(12155)/256]",
        ),
        "Qh(9,E,1,1)": (
            "21*sqrt(5)*S1/128+sqrt(2310)*S3/128+3*sqrt(286)*S5/128+3*sqrt(1430)*S7/256+sqrt(24310)*S9/256",
            "y*(315*x**8-3360*x**6*y**2+1260*x**6*z**2+6048*x**4*y**4-10080*x**4*y**2*z**2+1890*x**4*z**4-2304*x**2*y**6+12096*x**2*y**4*z**2-10080*x**2*y**2*z**4+1260*x**2*z**6+128*y**8-2304*y**6*z**2+6048*y**4*z**4-3360*y**2*z**6+315*z**8)/128",
            "[sqrt(12155)*I/256,0,3*sqrt(715)*I/256,0,3*sqrt(143)*I/128,0,sqrt(1155)*I/128,0,21*sqrt(10)*I/256,0,21*sqrt(10)*I/256,0,sqrt(1155)*I/128,0,3*sqrt(143)*I/128,0,3*sqrt(715)*I/256,0,sqrt(12155)*I/256]",
        ),
        "Qh(10,E,1,0)": (
            "-sqrt(221)*C1/32-sqrt(102)*C3/32+sqrt(510)*C5/32-11*sqrt(6)*C7/64+sqrt(38)*C9/64",
            "sqrt(12155)*x*z*(x-z)*(x+z)*(x**2-18*y**2+z**2)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/32",
            "[0,-sqrt(19)/64,0,11*sqrt(3)/64,0,-sqrt(255)/32,0,sqrt(51)/32,0,sqrt(442)/64,0,-sqrt(442)/64,0,-sqrt(51)/32,0,sqrt(255)/32,0,-11*sqrt(3)/64,0,sqrt(19)/64,0]",
        ),
        "Qh(10,E,1,1)": (
            "-sqrt(221)*S1/32+sqrt(102)*S3/32+sqrt(510)*S5/32+11*sqrt(6)*S7/64+sqrt(38)*S9/64",
            "-sqrt(12155)*y*z*(y-z)*(y+z)*(18*x**2-y**2-z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/32",
            "[0,sqrt(19)*I/64,0,11*sqrt(3)*I/64,0,sqrt(255)*I/32,0,sqrt(51)*I/32,0,-sqrt(442)*I/64,0,-sqrt(442)*I/64,0,sqrt(51)*I/32,0,sqrt(255)*I/32,0,11*sqrt(3)*I/64,0,sqrt(19)*I/64,0]",
        ),
        "Qh(11,E,1,0)": (
            "-21*sqrt(66)*C1/512+sqrt(88179)*C11/512+sqrt(30030)*C3/512-15*sqrt(143)*C5/512+sqrt(36465)*C7/512-sqrt(46189)*C9/512",
            "x*(256*x**10-7040*x**8*y**2-7040*x**8*z**2+31680*x**6*y**4+63360*x**6*y**2*z**2+31680*x**6*z**4-36960*x**4*y**6-110880*x**4*y**4*z**2-110880*x**4*y**2*z**4-36960*x**4*z**6+11550*x**2*y**8+46200*x**2*y**6*z**2+69300*x**2*y**4*z**4+46200*x**2*y**2*z**6+11550*x**2*z**8-693*y**10-3465*y**8*z**2-6930*y**6*z**4-6930*y**4*z**6-3465*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)/1024,0,sqrt(92378)/1024,0,-sqrt(72930)/1024,0,15*sqrt(286)/1024,0,-sqrt(15015)/512,0,21*sqrt(33)/512,0,-21*sqrt(33)/512,0,sqrt(15015)/512,0,-15*sqrt(286)/1024,0,sqrt(72930)/1024,0,-sqrt(92378)/1024,0,sqrt(176358)/1024]",
        ),
        "Qh(11,E,1,1)": (
            "-21*sqrt(66)*S1/512-sqrt(88179)*S11/512-sqrt(30030)*S3/512-15*sqrt(143)*S5/512-sqrt(36465)*S7/512-sqrt(46189)*S9/512",
            "-y*(693*x**10-11550*x**8*y**2+3465*x**8*z**2+36960*x**6*y**4-46200*x**6*y**2*z**2+6930*x**6*z**4-31680*x**4*y**6+110880*x**4*y**4*z**2-69300*x**4*y**2*z**4+6930*x**4*z**6+7040*x**2*y**8-63360*x**2*y**6*z**2+110880*x**2*y**4*z**4-46200*x**2*y**2*z**6+3465*x**2*z**8-256*y**10+7040*y**8*z**2-31680*y**6*z**4+36960*y**4*z**6-11550*y**2*z**8+693*z**10)/256",
            "[-sqrt(176358)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(72930)*I/1024,0,-15*sqrt(286)*I/1024,0,-sqrt(15015)*I/512,0,-21*sqrt(33)*I/512,0,-21*sqrt(33)*I/512,0,-sqrt(15015)*I/512,0,-15*sqrt(286)*I/1024,0,-sqrt(72930)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(176358)*I/1024]",
        ),
        "Qh(3,E,2,0)": (
            "-sqrt(10)*C1/4-sqrt(6)*C3/4",
            "sqrt(15)*x*(y-z)*(y+z)/2",
            "[sqrt(3)/4,0,sqrt(5)/4,0,-sqrt(5)/4,0,-sqrt(3)/4]",
        ),
        "Qh(3,E,2,1)": (
            "-sqrt(10)*S1/4+sqrt(6)*S3/4",
            "sqrt(15)*y*(x-z)*(x+z)/2",
            "[sqrt(3)*I/4,0,-sqrt(5)*I/4,0,-sqrt(5)*I/4,0,sqrt(3)*I/4]",
        ),
        "Qh(4,E,2,0)": (
            "-sqrt(2)*C1/4-sqrt(14)*C3/4",
            "-sqrt(5)*x*z*(x**2-6*y**2+z**2)/2",
            "[0,sqrt(7)/4,0,1/4,0,-1/4,0,-sqrt(7)/4,0]",
        ),
        "Qh(4,E,2,1)": (
            "-sqrt(2)*S1/4+sqrt(14)*S3/4",
            "sqrt(5)*y*z*(6*x**2-y**2-z**2)/2",
            "[0,sqrt(7)*I/4,0,-I/4,0,-I/4,0,sqrt(7)*I/4,0]",
        ),
        "Qh(5,E,2,0)": (
            "sqrt(21)*C1/8+9*sqrt(2)*C3/16+sqrt(10)*C5/16",
            "3*sqrt(35)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/8",
            "[-sqrt(5)/16,0,-9/16,0,-sqrt(42)/16,0,sqrt(42)/16,0,9/16,0,sqrt(5)/16]",
        ),
        "Qh(5,E,2,1)": (
            "sqrt(21)*S1/8-9*sqrt(2)*S3/16+sqrt(10)*S5/16",
            "3*sqrt(35)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/8",
            "[sqrt(5)*I/16,0,-9*I/16,0,sqrt(42)*I/16,0,sqrt(42)*I/16,0,-9*I/16,0,sqrt(5)*I/16]",
        ),
        "Qh(6,E,2,0)": (
            "3*sqrt(22)*C1/16-sqrt(55)*C3/16+sqrt(3)*C5/16",
            "sqrt(462)*x*z*(x**2-3*z**2)*(3*x**2-z**2)/16",
            "[0,-sqrt(6)/32,0,sqrt(110)/32,0,-3*sqrt(11)/16,0,3*sqrt(11)/16,0,-sqrt(110)/32,0,sqrt(6)/32,0]",
        ),
        "Qh(6,E,2,1)": (
            "3*sqrt(22)*S1/16+sqrt(55)*S3/16+sqrt(3)*S5/16",
            "sqrt(462)*y*z*(y**2-3*z**2)*(3*y**2-z**2)/16",
            "[0,sqrt(6)*I/32,0,sqrt(110)*I/32,0,3*sqrt(11)*I/16,0,3*sqrt(11)*I/16,0,sqrt(110)*I/32,0,sqrt(6)*I/32,0]",
        ),
        "Qh(7,E,2,0)": (
            "-3*sqrt(33)*C1/32-sqrt(11)*C3/32+25*C5/32+sqrt(91)*C7/32",
            "sqrt(231)*x*(10*x**2-3*y**2-3*z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[-sqrt(182)/64,0,-25*sqrt(2)/64,0,sqrt(22)/64,0,3*sqrt(66)/64,0,-3*sqrt(66)/64,0,-sqrt(22)/64,0,25*sqrt(2)/64,0,sqrt(182)/64]",
        ),
        "Qh(7,E,2,1)": (
            "-3*sqrt(33)*S1/32+sqrt(11)*S3/32+25*S5/32-sqrt(91)*S7/32",
            "-sqrt(231)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(3*x**2-10*y**2+3*z**2)/16",
            "[-sqrt(182)*I/64,0,25*sqrt(2)*I/64,0,sqrt(22)*I/64,0,-3*sqrt(66)*I/64,0,-3*sqrt(66)*I/64,0,sqrt(22)*I/64,0,25*sqrt(2)*I/64,0,-sqrt(182)*I/64]",
        ),
        "Qh(8,E,2,0)": (
            "sqrt(77)*C1/32+5*sqrt(15)*C3/32+3*sqrt(13)*C5/32-sqrt(455)*C7/32",
            "-3*sqrt(77)*x*z*(x-z)*(x+z)*(x**4-24*x**2*y**2+2*x**2*z**2+40*y**4-24*y**2*z**2+z**4)/16",
            "[0,sqrt(910)/64,0,-3*sqrt(26)/64,0,-5*sqrt(30)/64,0,-sqrt(154)/64,0,sqrt(154)/64,0,5*sqrt(30)/64,0,3*sqrt(26)/64,0,-sqrt(910)/64,0]",
        ),
        "Qh(8,E,2,1)": (
            "sqrt(77)*S1/32-5*sqrt(15)*S3/32+3*sqrt(13)*S5/32+sqrt(455)*S7/32",
            "-3*sqrt(77)*y*z*(y-z)*(y+z)*(40*x**4-24*x**2*y**2-24*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,sqrt(910)*I/64,0,3*sqrt(26)*I/64,0,-5*sqrt(30)*I/64,0,sqrt(154)*I/64,0,sqrt(154)*I/64,0,-5*sqrt(30)*I/64,0,3*sqrt(26)*I/64,0,sqrt(910)*I/64,0]",
        ),
        "Qh(9,E,2,0)": (
            "sqrt(2431)*C1/128+sqrt(9282)*C3/128+5*sqrt(170)*C5/128+7*sqrt(34)*C7/256+3*sqrt(2)*C9/256",
            "3*sqrt(12155)*x*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/128",
            "[-3/256,0,-7*sqrt(17)/256,0,-5*sqrt(85)/128,0,-sqrt(4641)/128,0,-sqrt(4862)/256,0,sqrt(4862)/256,0,sqrt(4641)/128,0,5*sqrt(85)/128,0,7*sqrt(17)/256,0,3/256]",
        ),
        "Qh(9,E,2,1)": (
            "sqrt(2431)*S1/128-sqrt(9282)*S3/128+5*sqrt(170)*S5/128-7*sqrt(34)*S7/256+3*sqrt(2)*S9/256",
            "3*sqrt(12155)*y*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/128",
            "[3*I/256,0,-7*sqrt(17)*I/256,0,5*sqrt(85)*I/128,0,-sqrt(4641)*I/128,0,sqrt(4862)*I/256,0,sqrt(4862)*I/256,0,-sqrt(4641)*I/128,0,5*sqrt(85)*I/128,0,-7*sqrt(17)*I/256,0,3*I/256]",
        ),
        "Qh(10,E,2,0)": (
            "-sqrt(39)*C1/32-11*sqrt(2)*C3/32-5*sqrt(10)*C5/32-sqrt(34)*C7/64+sqrt(1938)*C9/64",
            "sqrt(2145)*x*z*(x-z)*(x+z)*(x**6-42*x**4*y**2+3*x**4*z**2+168*x**2*y**4-84*x**2*y**2*z**2+3*x**2*z**4-112*y**6+168*y**4*z**2-42*y**2*z**4+z**6)/32",
            "[0,-sqrt(969)/64,0,sqrt(17)/64,0,5*sqrt(5)/32,0,11/32,0,sqrt(78)/64,0,-sqrt(78)/64,0,-11/32,0,-5*sqrt(5)/32,0,-sqrt(17)/64,0,sqrt(969)/64,0]",
        ),
        "Qh(10,E,2,1)": (
            "-sqrt(39)*S1/32+11*sqrt(2)*S3/32-5*sqrt(10)*S5/32+sqrt(34)*S7/64+sqrt(1938)*S9/64",
            "-sqrt(2145)*y*z*(y-z)*(y+z)*(112*x**6-168*x**4*y**2-168*x**4*z**2+42*x**2*y**4+84*x**2*y**2*z**2+42*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,sqrt(969)*I/64,0,sqrt(17)*I/64,0,-5*sqrt(5)*I/32,0,11*I/32,0,-sqrt(78)*I/64,0,-sqrt(78)*I/64,0,11*I/32,0,-5*sqrt(5)*I/32,0,sqrt(17)*I/64,0,sqrt(969)*I/64,0]",
        ),
        "Qh(11,E,2,0)": (
            "-sqrt(41990)*C1/512+sqrt(385)*C11/512-3*sqrt(4522)*C3/512+3*sqrt(4845)*C5/512+77*sqrt(19)*C7/512+39*sqrt(15)*C9/512",
            "sqrt(692835)*x*(6*x**2-y**2-z**2)*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/256",
            "[-sqrt(770)/1024,0,-39*sqrt(30)/1024,0,-77*sqrt(38)/1024,0,-3*sqrt(9690)/1024,0,3*sqrt(2261)/512,0,sqrt(20995)/512,0,-sqrt(20995)/512,0,-3*sqrt(2261)/512,0,3*sqrt(9690)/1024,0,77*sqrt(38)/1024,0,39*sqrt(30)/1024,0,sqrt(770)/1024]",
        ),
        "Qh(11,E,2,1)": (
            "-sqrt(41990)*S1/512-sqrt(385)*S11/512+3*sqrt(4522)*S3/512+3*sqrt(4845)*S5/512-77*sqrt(19)*S7/512+39*sqrt(15)*S9/512",
            "-sqrt(692835)*y*(x**2-6*y**2+z**2)*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/256",
            "[-sqrt(770)*I/1024,0,39*sqrt(30)*I/1024,0,-77*sqrt(38)*I/1024,0,3*sqrt(9690)*I/1024,0,3*sqrt(2261)*I/512,0,-sqrt(20995)*I/512,0,-sqrt(20995)*I/512,0,3*sqrt(2261)*I/512,0,3*sqrt(9690)*I/1024,0,-77*sqrt(38)*I/1024,0,39*sqrt(30)*I/1024,0,-sqrt(770)*I/1024]",
        ),
        "Qh(5,E,3,0)": (
            "sqrt(7)*C1/4-sqrt(6)*C3/8-sqrt(30)*C5/8",
            "sqrt(105)*x*(y-z)*(y+z)*(2*x**2-y**2-z**2)/4",
            "[sqrt(15)/8,0,sqrt(3)/8,0,-sqrt(14)/8,0,sqrt(14)/8,0,-sqrt(3)/8,0,-sqrt(15)/8]",
        ),
        "Qh(5,E,3,1)": (
            "sqrt(7)*S1/4+sqrt(6)*S3/8-sqrt(30)*S5/8",
            "-sqrt(105)*y*(x-z)*(x+z)*(x**2-2*y**2+z**2)/4",
            "[-sqrt(15)*I/8,0,sqrt(3)*I/8,0,sqrt(14)*I/8,0,sqrt(14)*I/8,0,sqrt(3)*I/8,0,-sqrt(15)*I/8]",
        ),
        "Qh(6,E,3,0)": (
            "sqrt(10)*C1/16+9*C3/16+sqrt(165)*C5/16",
            "sqrt(210)*x*z*(x**4-16*x**2*y**2+2*x**2*z**2+16*y**4-16*y**2*z**2+z**4)/16",
            "[0,-sqrt(330)/32,0,-9*sqrt(2)/32,0,-sqrt(5)/16,0,sqrt(5)/16,0,9*sqrt(2)/32,0,sqrt(330)/32,0]",
        ),
        "Qh(6,E,3,1)": (
            "sqrt(10)*S1/16-9*S3/16+sqrt(165)*S5/16",
            "sqrt(210)*y*z*(16*x**4-16*x**2*y**2-16*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,sqrt(330)*I/32,0,-9*sqrt(2)*I/32,0,sqrt(5)*I/16,0,sqrt(5)*I/16,0,-9*sqrt(2)*I/32,0,sqrt(330)*I/32,0]",
        ),
        "Qh(7,E,3,0)": (
            "-sqrt(858)*C1/64-3*sqrt(286)*C3/64-5*sqrt(26)*C5/64-sqrt(14)*C7/64",
            "sqrt(6006)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/32",
            "[sqrt(7)/64,0,5*sqrt(13)/64,0,3*sqrt(143)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-3*sqrt(143)/64,0,-5*sqrt(13)/64,0,-sqrt(7)/64]",
        ),
        "Qh(7,E,3,1)": (
            "-sqrt(858)*S1/64+3*sqrt(286)*S3/64-5*sqrt(26)*S5/64+sqrt(14)*S7/64",
            "sqrt(6006)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)/32",
            "[sqrt(7)*I/64,0,-5*sqrt(13)*I/64,0,3*sqrt(143)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,3*sqrt(143)*I/64,0,-5*sqrt(13)*I/64,0,sqrt(7)*I/64]",
        ),
        "Qh(8,E,3,0)": (
            "-sqrt(858)*C1/64-sqrt(910)*C3/64+7*sqrt(42)*C5/64-3*sqrt(30)*C7/64",
            "-sqrt(858)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(x**2-14*y**2+z**2)/32",
            "[0,3*sqrt(15)/64,0,-7*sqrt(21)/64,0,sqrt(455)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-sqrt(455)/64,0,7*sqrt(21)/64,0,-3*sqrt(15)/64,0]",
        ),
        "Qh(8,E,3,1)": (
            "-sqrt(858)*S1/64+sqrt(910)*S3/64+7*sqrt(42)*S5/64+3*sqrt(30)*S7/64",
            "sqrt(858)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(14*x**2-y**2-z**2)/32",
            "[0,3*sqrt(15)*I/64,0,7*sqrt(21)*I/64,0,sqrt(455)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(455)*I/64,0,7*sqrt(21)*I/64,0,3*sqrt(15)*I/64,0]",
        ),
        "Qh(9,E,3,0)": (
            "sqrt(1001)*C1/64-sqrt(78)*C3/64-3*sqrt(70)*C5/64+23*sqrt(14)*C7/128+3*sqrt(238)*C9/128",
            "3*sqrt(5005)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(8*x**4-8*x**2*y**2-8*x**2*z**2+y**4+2*y**2*z**2+z**4)/64",
            "[-3*sqrt(119)/128,0,-23*sqrt(7)/128,0,3*sqrt(35)/64,0,sqrt(39)/64,0,-sqrt(2002)/128,0,sqrt(2002)/128,0,-sqrt(39)/64,0,-3*sqrt(35)/64,0,23*sqrt(7)/128,0,3*sqrt(119)/128]",
        ),
        "Qh(9,E,3,1)": (
            "sqrt(1001)*S1/64+sqrt(78)*S3/64-3*sqrt(70)*S5/64-23*sqrt(14)*S7/128+3*sqrt(238)*S9/128",
            "3*sqrt(5005)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(x**4-8*x**2*y**2+2*x**2*z**2+8*y**4-8*y**2*z**2+z**4)/64",
            "[3*sqrt(119)*I/128,0,-23*sqrt(7)*I/128,0,-3*sqrt(35)*I/64,0,sqrt(39)*I/64,0,sqrt(2002)*I/128,0,sqrt(2002)*I/128,0,sqrt(39)*I/64,0,-3*sqrt(35)*I/64,0,-23*sqrt(7)*I/128,0,3*sqrt(119)*I/128]",
        ),
        "Qh(10,E,3,0)": (
            "sqrt(41990)*C1/256-sqrt(4845)*C3/128+sqrt(969)*C5/128-sqrt(285)*C7/256+sqrt(5)*C9/256",
            "sqrt(92378)*x*z*(x**4-10*x**2*z**2+5*z**4)*(5*x**4-10*x**2*z**2+z**4)/256",
            "[0,-sqrt(10)/512,0,sqrt(570)/512,0,-sqrt(1938)/256,0,sqrt(9690)/256,0,-sqrt(20995)/256,0,sqrt(20995)/256,0,-sqrt(9690)/256,0,sqrt(1938)/256,0,-sqrt(570)/512,0,sqrt(10)/512,0]",
        ),
        "Qh(10,E,3,1)": (
            "sqrt(41990)*S1/256+sqrt(4845)*S3/128+sqrt(969)*S5/128+sqrt(285)*S7/256+sqrt(5)*S9/256",
            "sqrt(92378)*y*z*(y**4-10*y**2*z**2+5*z**4)*(5*y**4-10*y**2*z**2+z**4)/256",
            "[0,sqrt(10)*I/512,0,sqrt(570)*I/512,0,sqrt(1938)*I/256,0,sqrt(9690)*I/256,0,sqrt(20995)*I/256,0,sqrt(20995)*I/256,0,sqrt(9690)*I/256,0,sqrt(1938)*I/256,0,sqrt(570)*I/512,0,sqrt(10)*I/512,0]",
        ),
        "Qh(11,E,3,0)": (
            "-5*sqrt(546)*C1/256+sqrt(10659)*C11/256+11*sqrt(30)*C3/256+13*sqrt(7)*C5/256-3*sqrt(1785)*C7/256+3*sqrt(2261)*C9/256",
            "3*sqrt(1001)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(80*x**6-168*x**4*y**2-168*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-5*y**6-15*y**4*z**2-15*y**2*z**4-5*z**6)/128",
            "[-sqrt(21318)/512,0,-3*sqrt(4522)/512,0,3*sqrt(3570)/512,0,-13*sqrt(14)/512,0,-11*sqrt(15)/256,0,5*sqrt(273)/256,0,-5*sqrt(273)/256,0,11*sqrt(15)/256,0,13*sqrt(14)/512,0,-3*sqrt(3570)/512,0,3*sqrt(4522)/512,0,sqrt(21318)/512]",
        ),
        "Qh(11,E,3,1)": (
            "-5*sqrt(546)*S1/256-sqrt(10659)*S11/256-11*sqrt(30)*S3/256+13*sqrt(7)*S5/256+3*sqrt(1785)*S7/256+3*sqrt(2261)*S9/256",
            "-3*sqrt(1001)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(5*x**6-70*x**4*y**2+15*x**4*z**2+168*x**2*y**4-140*x**2*y**2*z**2+15*x**2*z**4-80*y**6+168*y**4*z**2-70*y**2*z**4+5*z**6)/128",
            "[-sqrt(21318)*I/512,0,3*sqrt(4522)*I/512,0,3*sqrt(3570)*I/512,0,13*sqrt(14)*I/512,0,-11*sqrt(15)*I/256,0,-5*sqrt(273)*I/256,0,-5*sqrt(273)*I/256,0,-11*sqrt(15)*I/256,0,13*sqrt(14)*I/512,0,3*sqrt(3570)*I/512,0,3*sqrt(4522)*I/512,0,-sqrt(21318)*I/512]",
        ),
        "Qh(7,E,4,0)": (
            "-15*sqrt(6)*C1/64+19*sqrt(2)*C3/64-sqrt(22)*C5/64-sqrt(2002)*C7/64",
            "sqrt(42)*x*(y-z)*(y+z)*(48*x**4-80*x**2*y**2-80*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/32",
            "[sqrt(1001)/64,0,sqrt(11)/64,0,-19/64,0,15*sqrt(3)/64,0,-15*sqrt(3)/64,0,19/64,0,-sqrt(11)/64,0,-sqrt(1001)/64]",
        ),
        "Qh(7,E,4,1)": (
            "-15*sqrt(6)*S1/64-19*sqrt(2)*S3/64-sqrt(22)*S5/64+sqrt(2002)*S7/64",
            "sqrt(42)*y*(x-z)*(x+z)*(15*x**4-80*x**2*y**2+30*x**2*z**2+48*y**4-80*y**2*z**2+15*z**4)/32",
            "[sqrt(1001)*I/64,0,-sqrt(11)*I/64,0,-19*I/64,0,-15*sqrt(3)*I/64,0,-15*sqrt(3)*I/64,0,-19*I/64,0,-sqrt(11)*I/64,0,sqrt(1001)*I/64]",
        ),
        "Qh(8,E,4,0)": (
            "-sqrt(70)*C1/64-3*sqrt(66)*C3/64-sqrt(1430)*C5/64-sqrt(2002)*C7/64",
            "-3*sqrt(70)*x*z*(x**6-30*x**4*y**2+3*x**4*z**2+80*x**2*y**4-60*x**2*y**2*z**2+3*x**2*z**4-32*y**6+80*y**4*z**2-30*y**2*z**4+z**6)/32",
            "[0,sqrt(1001)/64,0,sqrt(715)/64,0,3*sqrt(33)/64,0,sqrt(35)/64,0,-sqrt(35)/64,0,-3*sqrt(33)/64,0,-sqrt(715)/64,0,-sqrt(1001)/64,0]",
        ),
        "Qh(8,E,4,1)": (
            "-sqrt(70)*S1/64+3*sqrt(66)*S3/64-sqrt(1430)*S5/64+sqrt(2002)*S7/64",
            "3*sqrt(70)*y*z*(32*x**6-80*x**4*y**2-80*x**4*z**2+30*x**2*y**4+60*x**2*y**2*z**2+30*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,sqrt(1001)*I/64,0,-sqrt(715)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(35)*I/64,0,-sqrt(35)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(715)*I/64,0,sqrt(1001)*I/64,0]",
        ),
        "Qh(9,E,4,0)": (
            "sqrt(858)*C1/64+sqrt(91)*C3/32-5*sqrt(15)*C5/32-21*sqrt(3)*C7/64-sqrt(51)*C9/64",
            "sqrt(4290)*x*(y-z)*(y+z)*(14*x**2-3*y**2-3*z**2)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/64",
            "[sqrt(102)/128,0,21*sqrt(6)/128,0,5*sqrt(30)/64,0,-sqrt(182)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(182)/64,0,-5*sqrt(30)/64,0,-21*sqrt(6)/128,0,-sqrt(102)/128]",
        ),
        "Qh(9,E,4,1)": (
            "sqrt(858)*S1/64-sqrt(91)*S3/32-5*sqrt(15)*S5/32+21*sqrt(3)*S7/64-sqrt(51)*S9/64",
            "-sqrt(4290)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(3*x**2-14*y**2+3*z**2)/64",
            "[-sqrt(102)*I/128,0,21*sqrt(6)*I/128,0,-5*sqrt(30)*I/64,0,-sqrt(182)*I/64,0,sqrt(429)*I/64,0,sqrt(429)*I/64,0,-sqrt(182)*I/64,0,-5*sqrt(30)*I/64,0,21*sqrt(6)*I/128,0,-sqrt(102)*I/128]",
        ),
        "Qh(10,E,4,0)": (
            "9*sqrt(78)*C1/256+69*C3/128-sqrt(5)*C5/128-43*sqrt(17)*C7/256+3*sqrt(969)*C9/256",
            "sqrt(4290)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(3*x**4-96*x**2*y**2+6*x**2*z**2+224*y**4-96*y**2*z**2+3*z**4)/256",
            "[0,-3*sqrt(1938)/512,0,43*sqrt(34)/512,0,sqrt(10)/256,0,-69*sqrt(2)/256,0,-9*sqrt(39)/256,0,9*sqrt(39)/256,0,69*sqrt(2)/256,0,-sqrt(10)/256,0,-43*sqrt(34)/512,0,3*sqrt(1938)/512,0]",
        ),
        "Qh(10,E,4,1)": (
            "9*sqrt(78)*S1/256-69*S3/128-sqrt(5)*S5/128+43*sqrt(17)*S7/256+3*sqrt(969)*S9/256",
            "sqrt(4290)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(224*x**4-96*x**2*y**2-96*x**2*z**2+3*y**4+6*y**2*z**2+3*z**4)/256",
            "[0,3*sqrt(1938)*I/512,0,43*sqrt(34)*I/512,0,-sqrt(10)*I/256,0,-69*sqrt(2)*I/256,0,9*sqrt(39)*I/256,0,9*sqrt(39)*I/256,0,-69*sqrt(2)*I/256,0,-sqrt(10)*I/256,0,43*sqrt(34)*I/512,0,3*sqrt(1938)*I/512,0]",
        ),
        "Qh(11,E,4,0)": (
            "-sqrt(29393)*C1/512-sqrt(22)*C11/1024-9*sqrt(1615)*C3/512-5*sqrt(13566)*C5/1024-7*sqrt(1330)*C7/1024-9*sqrt(42)*C9/1024",
            "sqrt(1939938)*x*(y-z)*(y+z)*(y**4-4*y**3*z-14*y**2*z**2-4*y*z**3+z**4)*(y**4+4*y**3*z-14*y**2*z**2+4*y*z**3+z**4)/512",
            "[sqrt(11)/1024,0,9*sqrt(21)/1024,0,7*sqrt(665)/1024,0,5*sqrt(6783)/1024,0,9*sqrt(3230)/1024,0,sqrt(58786)/1024,0,-sqrt(58786)/1024,0,-9*sqrt(3230)/1024,0,-5*sqrt(6783)/1024,0,-7*sqrt(665)/1024,0,-9*sqrt(21)/1024,0,-sqrt(11)/1024]",
        ),
        "Qh(11,E,4,1)": (
            "-sqrt(29393)*S1/512+sqrt(22)*S11/1024+9*sqrt(1615)*S3/512-5*sqrt(13566)*S5/1024+7*sqrt(1330)*S7/1024-9*sqrt(42)*S9/1024",
            "sqrt(1939938)*y*(x-z)*(x+z)*(x**4-4*x**3*z-14*x**2*z**2-4*x*z**3+z**4)*(x**4+4*x**3*z-14*x**2*z**2+4*x*z**3+z**4)/512",
            "[sqrt(11)*I/1024,0,-9*sqrt(21)*I/1024,0,7*sqrt(665)*I/1024,0,-5*sqrt(6783)*I/1024,0,9*sqrt(3230)*I/1024,0,-sqrt(58786)*I/1024,0,-sqrt(58786)*I/1024,0,9*sqrt(3230)*I/1024,0,-5*sqrt(6783)*I/1024,0,7*sqrt(665)*I/1024,0,-9*sqrt(21)*I/1024,0,sqrt(11)*I/1024]",
        ),
        "Qh(9,E,5,0)": (
            "7*sqrt(22)*C1/64-3*sqrt(21)*C3/32+sqrt(65)*C5/32+sqrt(13)*C7/64-3*sqrt(221)*C9/64",
            "3*sqrt(110)*x*(y-z)*(y+z)*(32*x**6-112*x**4*y**2-112*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-7*y**6-21*y**4*z**2-21*y**2*z**4-7*z**6)/64",
            "[3*sqrt(442)/128,0,-sqrt(26)/128,0,-sqrt(130)/64,0,3*sqrt(42)/64,0,-7*sqrt(11)/64,0,7*sqrt(11)/64,0,-3*sqrt(42)/64,0,sqrt(130)/64,0,sqrt(26)/128,0,-3*sqrt(442)/128]",
        ),
        "Qh(9,E,5,1)": (
            "7*sqrt(22)*S1/64+3*sqrt(21)*S3/32+sqrt(65)*S5/32-sqrt(13)*S7/64-3*sqrt(221)*S9/64",
            "-3*sqrt(110)*y*(x-z)*(x+z)*(7*x**6-70*x**4*y**2+21*x**4*z**2+112*x**2*y**4-140*x**2*y**2*z**2+21*x**2*z**4-32*y**6+112*y**4*z**2-70*y**2*z**4+7*z**6)/64",
            "[-3*sqrt(442)*I/128,0,-sqrt(26)*I/128,0,sqrt(130)*I/64,0,3*sqrt(42)*I/64,0,7*sqrt(11)*I/64,0,7*sqrt(11)*I/64,0,3*sqrt(42)*I/64,0,sqrt(130)*I/64,0,-sqrt(26)*I/128,0,-3*sqrt(442)*I/128]",
        ),
        "Qh(10,E,5,0)": (
            "7*sqrt(3)*C1/128+7*sqrt(26)*C3/128+5*sqrt(130)*C5/128+7*sqrt(442)*C7/256+sqrt(25194)*C9/256",
            "sqrt(165)*x*z*(7*x**8-336*x**6*y**2+28*x**6*z**2+1680*x**4*y**4-1008*x**4*y**2*z**2+42*x**4*z**4-1792*x**2*y**6+3360*x**2*y**4*z**2-1008*x**2*y**2*z**4+28*x**2*z**6+384*y**8-1792*y**6*z**2+1680*y**4*z**4-336*y**2*z**6+7*z**8)/128",
            "[0,-sqrt(12597)/256,0,-7*sqrt(221)/256,0,-5*sqrt(65)/128,0,-7*sqrt(13)/128,0,-7*sqrt(6)/256,0,7*sqrt(6)/256,0,7*sqrt(13)/128,0,5*sqrt(65)/128,0,7*sqrt(221)/256,0,sqrt(12597)/256,0]",
        ),
        "Qh(10,E,5,1)": (
            "7*sqrt(3)*S1/128-7*sqrt(26)*S3/128+5*sqrt(130)*S5/128-7*sqrt(442)*S7/256+sqrt(25194)*S9/256",
            "sqrt(165)*y*z*(384*x**8-1792*x**6*y**2-1792*x**6*z**2+1680*x**4*y**4+3360*x**4*y**2*z**2+1680*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+7*y**8+28*y**6*z**2+42*y**4*z**4+28*y**2*z**6+7*z**8)/128",
            "[0,sqrt(12597)*I/256,0,-7*sqrt(221)*I/256,0,5*sqrt(65)*I/128,0,-7*sqrt(13)*I/128,0,7*sqrt(6)*I/256,0,7*sqrt(6)*I/256,0,-7*sqrt(13)*I/128,0,5*sqrt(65)*I/128,0,-7*sqrt(221)*I/256,0,sqrt(12597)*I/256,0]",
        ),
        "Qh(11,E,5,0)": (
            "-15*sqrt(221)*C1/512-3*sqrt(2926)*C11/1024-sqrt(595)*C3/512+53*sqrt(102)*C5/1024-105*sqrt(10)*C7/1024-61*sqrt(114)*C9/1024",
            "sqrt(14586)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)*(224*x**4-160*x**2*y**2-160*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/512",
            "[3*sqrt(1463)/1024,0,61*sqrt(57)/1024,0,105*sqrt(5)/1024,0,-53*sqrt(51)/1024,0,sqrt(1190)/1024,0,15*sqrt(442)/1024,0,-15*sqrt(442)/1024,0,-sqrt(1190)/1024,0,53*sqrt(51)/1024,0,-105*sqrt(5)/1024,0,-61*sqrt(57)/1024,0,-3*sqrt(1463)/1024]",
        ),
        "Qh(11,E,5,1)": (
            "-15*sqrt(221)*S1/512+3*sqrt(2926)*S11/1024+sqrt(595)*S3/512+53*sqrt(102)*S5/1024+105*sqrt(10)*S7/1024-61*sqrt(114)*S9/1024",
            "sqrt(14586)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(15*x**4-160*x**2*y**2+30*x**2*z**2+224*y**4-160*y**2*z**2+15*z**4)/512",
            "[3*sqrt(1463)*I/1024,0,-61*sqrt(57)*I/1024,0,105*sqrt(5)*I/1024,0,53*sqrt(51)*I/1024,0,sqrt(1190)*I/1024,0,-15*sqrt(442)*I/1024,0,-15*sqrt(442)*I/1024,0,sqrt(1190)*I/1024,0,53*sqrt(51)*I/1024,0,105*sqrt(5)*I/1024,0,-61*sqrt(57)*I/1024,0,3*sqrt(1463)*I/1024]",
        ),
        "Qh(11,E,6,0)": (
            "-21*sqrt(130)*C1/512-sqrt(124355)*C11/512+57*sqrt(14)*C3/512-41*sqrt(15)*C5/512+17*sqrt(17)*C7/512+sqrt(4845)*C9/512",
            "sqrt(2145)*x*(y-z)*(y+z)*(128*x**8-768*x**6*y**2-768*x**6*z**2+1008*x**4*y**4+2016*x**4*y**2*z**2+1008*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+21*y**8+84*y**6*z**2+126*y**4*z**4+84*y**2*z**6+21*z**8)/256",
            "[sqrt(248710)/1024,0,-sqrt(9690)/1024,0,-17*sqrt(34)/1024,0,41*sqrt(30)/1024,0,-57*sqrt(7)/512,0,21*sqrt(65)/512,0,-21*sqrt(65)/512,0,57*sqrt(7)/512,0,-41*sqrt(30)/1024,0,17*sqrt(34)/1024,0,sqrt(9690)/1024,0,-sqrt(248710)/1024]",
        ),
        "Qh(11,E,6,1)": (
            "-21*sqrt(130)*S1/512+sqrt(124355)*S11/512-57*sqrt(14)*S3/512-41*sqrt(15)*S5/512-17*sqrt(17)*S7/512+sqrt(4845)*S9/512",
            "sqrt(2145)*y*(x-z)*(x+z)*(21*x**8-336*x**6*y**2+84*x**6*z**2+1008*x**4*y**4-1008*x**4*y**2*z**2+126*x**4*z**4-768*x**2*y**6+2016*x**2*y**4*z**2-1008*x**2*y**2*z**4+84*x**2*z**6+128*y**8-768*y**6*z**2+1008*y**4*z**4-336*y**2*z**6+21*z**8)/256",
            "[sqrt(248710)*I/1024,0,sqrt(9690)*I/1024,0,-17*sqrt(34)*I/1024,0,-41*sqrt(30)*I/1024,0,-57*sqrt(7)*I/512,0,-21*sqrt(65)*I/512,0,-21*sqrt(65)*I/512,0,-57*sqrt(7)*I/512,0,-41*sqrt(30)*I/1024,0,-17*sqrt(34)*I/1024,0,sqrt(9690)*I/1024,0,sqrt(248710)*I/1024]",
        ),
    },
    "D2d": {
        "Qh(0,A1,,)": ("C0", "1", "[1]"),
        "Qh(2,A1,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(3,A1,,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(5,A1,,)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(4,A1,1,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Qh(6,A1,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Qh(7,A1,1,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Qh(8,A1,1,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Qh(9,A1,1,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Qh(10,A1,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Qh(11,A1,1,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Qh(4,A1,2,)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "-sqrt(15)*(x**4-12*x**2*y**2+6*x**2*z**2+y**4+6*y**2*z**2-2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Qh(6,A1,2,)": (
            "sqrt(14)*C0/4+sqrt(2)*C4/4",
            "-sqrt(14)*(x**6-15*x**4*z**2+15*x**2*z**4+y**6-15*y**4*z**2+15*y**2*z**4-2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Qh(7,A1,2,)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "-sqrt(77)*x*y*z*(3*x**4-20*x**2*y**2+10*x**2*z**2+3*y**4+10*y**2*z**2-6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Qh(8,A1,2,)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Qh(9,A1,2,)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Qh(10,A1,2,)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "-sqrt(420189)*(22*x**10+45*x**8*y**2-1035*x**8*z**2-105*x**6*y**4-630*x**6*y**2*z**2+4935*x**6*z**4-105*x**4*y**6+3150*x**4*y**4*z**2-1575*x**4*y**2*z**4-4830*x**4*z**6+45*x**2*y**8-630*x**2*y**6*z**2-1575*x**2*y**4*z**4+1260*x**2*y**2*z**6+990*x**2*z**8+22*y**10-1035*y**8*z**2+4935*y**6*z**4-4830*y**4*z**6+990*y**2*z**8-44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Qh(11,A1,2,)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "-sqrt(230945)*x*y*z*(x**8-6*x**6*y**2-6*x**6*z**2+42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2-84*x**2*y**2*z**4+12*x**2*z**6+y**8-6*y**6*z**2+12*y**2*z**6-2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Qh(8,A1,3,)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Qh(10,A1,3,)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "-sqrt(3213210)*(3*x**10-96*x**8*y**2-39*x**8*z**2+224*x**6*y**4+1344*x**6*y**2*z**2-42*x**6*z**4+224*x**4*y**6-6720*x**4*y**4*z**2+3360*x**4*y**2*z**4-182*x**4*z**6-96*x**2*y**8+1344*x**2*y**6*z**2+3360*x**2*y**4*z**4-2688*x**2*y**2*z**6+135*x**2*z**8+3*y**10-39*y**8*z**2-42*y**6*z**4-182*y**4*z**6+135*y**2*z**8-6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Qh(11,A1,3,)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "-sqrt(3003)*x*y*z*(5*x**8-150*x**6*y**2+90*x**6*z**2+336*x**4*y**4-70*x**4*y**2*z**2-168*x**4*z**4-150*x**2*y**6-70*x**2*y**4*z**2+140*x**2*y**2*z**4+60*x**2*z**6+5*y**8+90*y**6*z**2-168*y**4*z**4+60*y**2*z**6-10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Qh(3,A2,,)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(4,A2,,)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(5,A2,,)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(6,A2,,)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(7,A2,1,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(8,A2,1,)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(9,A2,1,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(10,A2,1,)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(11,A2,1,)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(7,A2,2,)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(8,A2,2,)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(9,A2,2,)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A2,2,)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(11,A2,2,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,A2,3,)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(2,B1,,)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(4,B1,,)": ("-C2", "sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Qh(5,B1,,)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(6,B1,1,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Qh(7,B1,1,)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(8,B1,1,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,B1,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Qh(10,B1,1,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Qh(11,B1,1,)": (
            "S8",
            "-sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(6,B1,2,)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x-y)*(x+y)*(x**4-9*x**2*y**2-5*x**2*z**2+y**4-5*y**2*z**2+5*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Qh(8,B1,2,)": (
            "C2",
            "-3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(9,B1,2,)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(x-y)*(x+y)*(3*x**4-11*x**2*y**2-7*x**2*z**2+3*y**4-7*y**2*z**2+7*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Qh(10,B1,2,)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(x-y)*(x+y)*(22*x**8-653*x**6*y**2-315*x**6*z**2+2602*x**4*y**4-945*x**4*y**2*z**2+1575*x**4*z**4-653*x**2*y**6-945*x**2*y**4*z**2+3150*x**2*y**2*z**4-1680*x**2*z**6+22*y**8-315*y**6*z**2+1575*y**4*z**4-1680*y**2*z**6+360*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Qh(11,B1,2,)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,B1,3,)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(x-y)*(x+y)*(9*x**8-165*x**6*y**2-231*x**6*z**2-25*x**4*y**4+3801*x**4*y**2*z**2+406*x**4*z**4-165*x**2*y**6+3801*x**2*y**4*z**2-9674*x**2*y**2*z**4+266*x**2*z**6+9*y**8-231*y**6*z**2+406*y**4*z**4+266*y**2*z**6-57*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Qh(1,B2,,)": ("C0", "z", "[0,1,0]"),
        "Qh(2,B2,,)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Qh(3,B2,,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(4,B2,,)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(5,B2,1,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(6,B2,1,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(7,B2,1,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(8,B2,1,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(9,B2,1,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,B2,1,)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(11,B2,1,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(5,B2,2,)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(6,B2,2,)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(7,B2,2,)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(8,B2,2,)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,B2,2,)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(10,B2,2,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(11,B2,2,)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,B2,3,)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(10,B2,3,)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,B2,3,)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(1,E,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(1,E,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(2,E,,0)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(2,E,,1)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Qh(3,E,1,0)": (
            "-sqrt(6)*C1/4+sqrt(10)*C3/4",
            "x*(2*x**2-3*y**2-3*z**2)/2",
            "[-sqrt(5)/4,0,sqrt(3)/4,0,-sqrt(3)/4,0,sqrt(5)/4]",
        ),
        "Qh(3,E,1,1)": (
            "-sqrt(6)*S1/4-sqrt(10)*S3/4",
            "-y*(3*x**2-2*y**2+3*z**2)/2",
            "[-sqrt(5)*I/4,0,-sqrt(3)*I/4,0,-sqrt(3)*I/4,0,-sqrt(5)*I/4]",
        ),
        "Qh(4,E,1,0)": (
            "-sqrt(14)*S1/4-sqrt(2)*S3/4",
            "sqrt(35)*y*z*(y-z)*(y+z)/2",
            "[0,-I/4,0,-sqrt(7)*I/4,0,-sqrt(7)*I/4,0,-I/4,0]",
        ),
        "Qh(4,E,1,1)": ("-sqrt(14)*C1/4+sqrt(2)*C3/4", "sqrt(35)*x*z*(x-z)*(x+z)/2", "[0,-1/4,0,sqrt(7)/4,0,-sqrt(7)/4,0,1/4,0]"),
        "Qh(5,E,1,0)": (
            "sqrt(15)*C1/8-sqrt(70)*C3/16+3*sqrt(14)*C5/16",
            "x*(8*x**4-40*x**2*y**2-40*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/8",
            "[-3*sqrt(7)/16,0,sqrt(35)/16,0,-sqrt(30)/16,0,sqrt(30)/16,0,-sqrt(35)/16,0,3*sqrt(7)/16]",
        ),
        "Qh(5,E,1,1)": (
            "sqrt(15)*S1/8+sqrt(70)*S3/16+3*sqrt(14)*S5/16",
            "y*(15*x**4-40*x**2*y**2+30*x**2*z**2+8*y**4-40*y**2*z**2+15*z**4)/8",
            "[3*sqrt(7)*I/16,0,sqrt(35)*I/16,0,sqrt(30)*I/16,0,sqrt(30)*I/16,0,sqrt(35)*I/16,0,3*sqrt(7)*I/16]",
        ),
        "Qh(6,E,1,0)": (
            "sqrt(3)*S1/4-sqrt(30)*S3/8-sqrt(22)*S5/8",
            "3*sqrt(7)*y*z*(y-z)*(y+z)*(10*x**2-y**2-z**2)/4",
            "[0,-sqrt(11)*I/8,0,-sqrt(15)*I/8,0,sqrt(6)*I/8,0,sqrt(6)*I/8,0,-sqrt(15)*I/8,0,-sqrt(11)*I/8,0]",
        ),
        "Qh(6,E,1,1)": (
            "sqrt(3)*C1/4+sqrt(30)*C3/8-sqrt(22)*C5/8",
            "-3*sqrt(7)*x*z*(x-z)*(x+z)*(x**2-10*y**2+z**2)/4",
            "[0,sqrt(11)/8,0,-sqrt(15)/8,0,-sqrt(6)/8,0,sqrt(6)/8,0,sqrt(15)/8,0,-sqrt(11)/8,0]",
        ),
        "Qh(7,E,1,0)": (
            "-5*sqrt(7)*C1/32+3*sqrt(21)*C3/32-sqrt(231)*C5/32+sqrt(429)*C7/32",
            "x*(16*x**6-168*x**4*y**2-168*x**4*z**2+210*x**2*y**4+420*x**2*y**2*z**2+210*x**2*z**4-35*y**6-105*y**4*z**2-105*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)/64,0,sqrt(462)/64,0,-3*sqrt(42)/64,0,5*sqrt(14)/64,0,-5*sqrt(14)/64,0,3*sqrt(42)/64,0,-sqrt(462)/64,0,sqrt(858)/64]",
        ),
        "Qh(7,E,1,1)": (
            "-5*sqrt(7)*S1/32-3*sqrt(21)*S3/32-sqrt(231)*S5/32-sqrt(429)*S7/32",
            "-y*(35*x**6-210*x**4*y**2+105*x**4*z**2+168*x**2*y**4-420*x**2*y**2*z**2+105*x**2*z**4-16*y**6+168*y**4*z**2-210*y**2*z**4+35*z**6)/16",
            "[-sqrt(858)*I/64,0,-sqrt(462)*I/64,0,-3*sqrt(42)*I/64,0,-5*sqrt(14)*I/64,0,-5*sqrt(14)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(462)*I/64,0,-sqrt(858)*I/64]",
        ),
        "Qh(8,E,1,0)": (
            "-sqrt(715)*S1/32-sqrt(273)*S3/32-sqrt(35)*S5/32-S7/32",
            "3*sqrt(715)*y*z*(y-z)*(y+z)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[0,-sqrt(2)*I/64,0,-sqrt(70)*I/64,0,-sqrt(546)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(546)*I/64,0,-sqrt(70)*I/64,0,-sqrt(2)*I/64,0]",
        ),
        "Qh(8,E,1,1)": (
            "-sqrt(715)*C1/32+sqrt(273)*C3/32-sqrt(35)*C5/32+C7/32",
            "3*sqrt(715)*x*z*(x-z)*(x+z)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/16",
            "[0,-sqrt(2)/64,0,sqrt(70)/64,0,-sqrt(546)/64,0,sqrt(1430)/64,0,-sqrt(1430)/64,0,sqrt(546)/64,0,-sqrt(70)/64,0,sqrt(2)/64,0]",
        ),
        "Qh(9,E,1,0)": (
            "21*sqrt(5)*C1/128-sqrt(2310)*C3/128+3*sqrt(286)*C5/128-3*sqrt(1430)*C7/256+sqrt(24310)*C9/256",
            "x*(128*x**8-2304*x**6*y**2-2304*x**6*z**2+6048*x**4*y**4+12096*x**4*y**2*z**2+6048*x**4*z**4-3360*x**2*y**6-10080*x**2*y**4*z**2-10080*x**2*y**2*z**4-3360*x**2*z**6+315*y**8+1260*y**6*z**2+1890*y**4*z**4+1260*y**2*z**6+315*z**8)/128",
            "[-sqrt(12155)/256,0,3*sqrt(715)/256,0,-3*sqrt(143)/128,0,sqrt(1155)/128,0,-21*sqrt(10)/256,0,21*sqrt(10)/256,0,-sqrt(1155)/128,0,3*sqrt(143)/128,0,-3*sqrt(715)/256,0,sqrt(12155)/256]",
        ),
        "Qh(9,E,1,1)": (
            "21*sqrt(5)*S1/128+sqrt(2310)*S3/128+3*sqrt(286)*S5/128+3*sqrt(1430)*S7/256+sqrt(24310)*S9/256",
            "y*(315*x**8-3360*x**6*y**2+1260*x**6*z**2+6048*x**4*y**4-10080*x**4*y**2*z**2+1890*x**4*z**4-2304*x**2*y**6+12096*x**2*y**4*z**2-10080*x**2*y**2*z**4+1260*x**2*z**6+128*y**8-2304*y**6*z**2+6048*y**4*z**4-3360*y**2*z**6+315*z**8)/128",
            "[sqrt(12155)*I/256,0,3*sqrt(715)*I/256,0,3*sqrt(143)*I/128,0,sqrt(1155)*I/128,0,21*sqrt(10)*I/256,0,21*sqrt(10)*I/256,0,sqrt(1155)*I/128,0,3*sqrt(143)*I/128,0,3*sqrt(715)*I/256,0,sqrt(12155)*I/256]",
        ),
        "Qh(10,E,1,0)": (
            "sqrt(221)*S1/32-sqrt(102)*S3/32-sqrt(510)*S5/32-11*sqrt(6)*S7/64-sqrt(38)*S9/64",
            "sqrt(12155)*y*z*(y-z)*(y+z)*(18*x**2-y**2-z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/32",
            "[0,-sqrt(19)*I/64,0,-11*sqrt(3)*I/64,0,-sqrt(255)*I/32,0,-sqrt(51)*I/32,0,sqrt(442)*I/64,0,sqrt(442)*I/64,0,-sqrt(51)*I/32,0,-sqrt(255)*I/32,0,-11*sqrt(3)*I/64,0,-sqrt(19)*I/64,0]",
        ),
        "Qh(10,E,1,1)": (
            "sqrt(221)*C1/32+sqrt(102)*C3/32-sqrt(510)*C5/32+11*sqrt(6)*C7/64-sqrt(38)*C9/64",
            "-sqrt(12155)*x*z*(x-z)*(x+z)*(x**2-18*y**2+z**2)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/32",
            "[0,sqrt(19)/64,0,-11*sqrt(3)/64,0,sqrt(255)/32,0,-sqrt(51)/32,0,-sqrt(442)/64,0,sqrt(442)/64,0,sqrt(51)/32,0,-sqrt(255)/32,0,11*sqrt(3)/64,0,-sqrt(19)/64,0]",
        ),
        "Qh(11,E,1,0)": (
            "-21*sqrt(66)*C1/512+sqrt(88179)*C11/512+sqrt(30030)*C3/512-15*sqrt(143)*C5/512+sqrt(36465)*C7/512-sqrt(46189)*C9/512",
            "x*(256*x**10-7040*x**8*y**2-7040*x**8*z**2+31680*x**6*y**4+63360*x**6*y**2*z**2+31680*x**6*z**4-36960*x**4*y**6-110880*x**4*y**4*z**2-110880*x**4*y**2*z**4-36960*x**4*z**6+11550*x**2*y**8+46200*x**2*y**6*z**2+69300*x**2*y**4*z**4+46200*x**2*y**2*z**6+11550*x**2*z**8-693*y**10-3465*y**8*z**2-6930*y**6*z**4-6930*y**4*z**6-3465*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)/1024,0,sqrt(92378)/1024,0,-sqrt(72930)/1024,0,15*sqrt(286)/1024,0,-sqrt(15015)/512,0,21*sqrt(33)/512,0,-21*sqrt(33)/512,0,sqrt(15015)/512,0,-15*sqrt(286)/1024,0,sqrt(72930)/1024,0,-sqrt(92378)/1024,0,sqrt(176358)/1024]",
        ),
        "Qh(11,E,1,1)": (
            "-21*sqrt(66)*S1/512-sqrt(88179)*S11/512-sqrt(30030)*S3/512-15*sqrt(143)*S5/512-sqrt(36465)*S7/512-sqrt(46189)*S9/512",
            "-y*(693*x**10-11550*x**8*y**2+3465*x**8*z**2+36960*x**6*y**4-46200*x**6*y**2*z**2+6930*x**6*z**4-31680*x**4*y**6+110880*x**4*y**4*z**2-69300*x**4*y**2*z**4+6930*x**4*z**6+7040*x**2*y**8-63360*x**2*y**6*z**2+110880*x**2*y**4*z**4-46200*x**2*y**2*z**6+3465*x**2*z**8-256*y**10+7040*y**8*z**2-31680*y**6*z**4+36960*y**4*z**6-11550*y**2*z**8+693*z**10)/256",
            "[-sqrt(176358)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(72930)*I/1024,0,-15*sqrt(286)*I/1024,0,-sqrt(15015)*I/512,0,-21*sqrt(33)*I/512,0,-21*sqrt(33)*I/512,0,-sqrt(15015)*I/512,0,-15*sqrt(286)*I/1024,0,-sqrt(72930)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(176358)*I/1024]",
        ),
        "Qh(3,E,2,0)": (
            "-sqrt(10)*C1/4-sqrt(6)*C3/4",
            "sqrt(15)*x*(y-z)*(y+z)/2",
            "[sqrt(3)/4,0,sqrt(5)/4,0,-sqrt(5)/4,0,-sqrt(3)/4]",
        ),
        "Qh(3,E,2,1)": (
            "-sqrt(10)*S1/4+sqrt(6)*S3/4",
            "sqrt(15)*y*(x-z)*(x+z)/2",
            "[sqrt(3)*I/4,0,-sqrt(5)*I/4,0,-sqrt(5)*I/4,0,sqrt(3)*I/4]",
        ),
        "Qh(4,E,2,0)": (
            "-sqrt(2)*S1/4+sqrt(14)*S3/4",
            "sqrt(5)*y*z*(6*x**2-y**2-z**2)/2",
            "[0,sqrt(7)*I/4,0,-I/4,0,-I/4,0,sqrt(7)*I/4,0]",
        ),
        "Qh(4,E,2,1)": (
            "-sqrt(2)*C1/4-sqrt(14)*C3/4",
            "-sqrt(5)*x*z*(x**2-6*y**2+z**2)/2",
            "[0,sqrt(7)/4,0,1/4,0,-1/4,0,-sqrt(7)/4,0]",
        ),
        "Qh(5,E,2,0)": (
            "sqrt(21)*C1/8+9*sqrt(2)*C3/16+sqrt(10)*C5/16",
            "3*sqrt(35)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/8",
            "[-sqrt(5)/16,0,-9/16,0,-sqrt(42)/16,0,sqrt(42)/16,0,9/16,0,sqrt(5)/16]",
        ),
        "Qh(5,E,2,1)": (
            "sqrt(21)*S1/8-9*sqrt(2)*S3/16+sqrt(10)*S5/16",
            "3*sqrt(35)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/8",
            "[sqrt(5)*I/16,0,-9*I/16,0,sqrt(42)*I/16,0,sqrt(42)*I/16,0,-9*I/16,0,sqrt(5)*I/16]",
        ),
        "Qh(6,E,2,0)": (
            "3*sqrt(22)*S1/16+sqrt(55)*S3/16+sqrt(3)*S5/16",
            "sqrt(462)*y*z*(y**2-3*z**2)*(3*y**2-z**2)/16",
            "[0,sqrt(6)*I/32,0,sqrt(110)*I/32,0,3*sqrt(11)*I/16,0,3*sqrt(11)*I/16,0,sqrt(110)*I/32,0,sqrt(6)*I/32,0]",
        ),
        "Qh(6,E,2,1)": (
            "3*sqrt(22)*C1/16-sqrt(55)*C3/16+sqrt(3)*C5/16",
            "sqrt(462)*x*z*(x**2-3*z**2)*(3*x**2-z**2)/16",
            "[0,-sqrt(6)/32,0,sqrt(110)/32,0,-3*sqrt(11)/16,0,3*sqrt(11)/16,0,-sqrt(110)/32,0,sqrt(6)/32,0]",
        ),
        "Qh(7,E,2,0)": (
            "-3*sqrt(33)*C1/32-sqrt(11)*C3/32+25*C5/32+sqrt(91)*C7/32",
            "sqrt(231)*x*(10*x**2-3*y**2-3*z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[-sqrt(182)/64,0,-25*sqrt(2)/64,0,sqrt(22)/64,0,3*sqrt(66)/64,0,-3*sqrt(66)/64,0,-sqrt(22)/64,0,25*sqrt(2)/64,0,sqrt(182)/64]",
        ),
        "Qh(7,E,2,1)": (
            "-3*sqrt(33)*S1/32+sqrt(11)*S3/32+25*S5/32-sqrt(91)*S7/32",
            "-sqrt(231)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(3*x**2-10*y**2+3*z**2)/16",
            "[-sqrt(182)*I/64,0,25*sqrt(2)*I/64,0,sqrt(22)*I/64,0,-3*sqrt(66)*I/64,0,-3*sqrt(66)*I/64,0,sqrt(22)*I/64,0,25*sqrt(2)*I/64,0,-sqrt(182)*I/64]",
        ),
        "Qh(8,E,2,0)": (
            "-sqrt(77)*S1/32+5*sqrt(15)*S3/32-3*sqrt(13)*S5/32-sqrt(455)*S7/32",
            "3*sqrt(77)*y*z*(y-z)*(y+z)*(40*x**4-24*x**2*y**2-24*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,-sqrt(910)*I/64,0,-3*sqrt(26)*I/64,0,5*sqrt(30)*I/64,0,-sqrt(154)*I/64,0,-sqrt(154)*I/64,0,5*sqrt(30)*I/64,0,-3*sqrt(26)*I/64,0,-sqrt(910)*I/64,0]",
        ),
        "Qh(8,E,2,1)": (
            "-sqrt(77)*C1/32-5*sqrt(15)*C3/32-3*sqrt(13)*C5/32+sqrt(455)*C7/32",
            "3*sqrt(77)*x*z*(x-z)*(x+z)*(x**4-24*x**2*y**2+2*x**2*z**2+40*y**4-24*y**2*z**2+z**4)/16",
            "[0,-sqrt(910)/64,0,3*sqrt(26)/64,0,5*sqrt(30)/64,0,sqrt(154)/64,0,-sqrt(154)/64,0,-5*sqrt(30)/64,0,-3*sqrt(26)/64,0,sqrt(910)/64,0]",
        ),
        "Qh(9,E,2,0)": (
            "sqrt(2431)*C1/128+sqrt(9282)*C3/128+5*sqrt(170)*C5/128+7*sqrt(34)*C7/256+3*sqrt(2)*C9/256",
            "3*sqrt(12155)*x*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/128",
            "[-3/256,0,-7*sqrt(17)/256,0,-5*sqrt(85)/128,0,-sqrt(4641)/128,0,-sqrt(4862)/256,0,sqrt(4862)/256,0,sqrt(4641)/128,0,5*sqrt(85)/128,0,7*sqrt(17)/256,0,3/256]",
        ),
        "Qh(9,E,2,1)": (
            "sqrt(2431)*S1/128-sqrt(9282)*S3/128+5*sqrt(170)*S5/128-7*sqrt(34)*S7/256+3*sqrt(2)*S9/256",
            "3*sqrt(12155)*y*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/128",
            "[3*I/256,0,-7*sqrt(17)*I/256,0,5*sqrt(85)*I/128,0,-sqrt(4641)*I/128,0,sqrt(4862)*I/256,0,sqrt(4862)*I/256,0,-sqrt(4641)*I/128,0,5*sqrt(85)*I/128,0,-7*sqrt(17)*I/256,0,3*I/256]",
        ),
        "Qh(10,E,2,0)": (
            "sqrt(39)*S1/32-11*sqrt(2)*S3/32+5*sqrt(10)*S5/32-sqrt(34)*S7/64-sqrt(1938)*S9/64",
            "sqrt(2145)*y*z*(y-z)*(y+z)*(112*x**6-168*x**4*y**2-168*x**4*z**2+42*x**2*y**4+84*x**2*y**2*z**2+42*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,-sqrt(969)*I/64,0,-sqrt(17)*I/64,0,5*sqrt(5)*I/32,0,-11*I/32,0,sqrt(78)*I/64,0,sqrt(78)*I/64,0,-11*I/32,0,5*sqrt(5)*I/32,0,-sqrt(17)*I/64,0,-sqrt(969)*I/64,0]",
        ),
        "Qh(10,E,2,1)": (
            "sqrt(39)*C1/32+11*sqrt(2)*C3/32+5*sqrt(10)*C5/32+sqrt(34)*C7/64-sqrt(1938)*C9/64",
            "-sqrt(2145)*x*z*(x-z)*(x+z)*(x**6-42*x**4*y**2+3*x**4*z**2+168*x**2*y**4-84*x**2*y**2*z**2+3*x**2*z**4-112*y**6+168*y**4*z**2-42*y**2*z**4+z**6)/32",
            "[0,sqrt(969)/64,0,-sqrt(17)/64,0,-5*sqrt(5)/32,0,-11/32,0,-sqrt(78)/64,0,sqrt(78)/64,0,11/32,0,5*sqrt(5)/32,0,sqrt(17)/64,0,-sqrt(969)/64,0]",
        ),
        "Qh(11,E,2,0)": (
            "-sqrt(41990)*C1/512+sqrt(385)*C11/512-3*sqrt(4522)*C3/512+3*sqrt(4845)*C5/512+77*sqrt(19)*C7/512+39*sqrt(15)*C9/512",
            "sqrt(692835)*x*(6*x**2-y**2-z**2)*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/256",
            "[-sqrt(770)/1024,0,-39*sqrt(30)/1024,0,-77*sqrt(38)/1024,0,-3*sqrt(9690)/1024,0,3*sqrt(2261)/512,0,sqrt(20995)/512,0,-sqrt(20995)/512,0,-3*sqrt(2261)/512,0,3*sqrt(9690)/1024,0,77*sqrt(38)/1024,0,39*sqrt(30)/1024,0,sqrt(770)/1024]",
        ),
        "Qh(11,E,2,1)": (
            "-sqrt(41990)*S1/512-sqrt(385)*S11/512+3*sqrt(4522)*S3/512+3*sqrt(4845)*S5/512-77*sqrt(19)*S7/512+39*sqrt(15)*S9/512",
            "-sqrt(692835)*y*(x**2-6*y**2+z**2)*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/256",
            "[-sqrt(770)*I/1024,0,39*sqrt(30)*I/1024,0,-77*sqrt(38)*I/1024,0,3*sqrt(9690)*I/1024,0,3*sqrt(2261)*I/512,0,-sqrt(20995)*I/512,0,-sqrt(20995)*I/512,0,3*sqrt(2261)*I/512,0,3*sqrt(9690)*I/1024,0,-77*sqrt(38)*I/1024,0,39*sqrt(30)*I/1024,0,-sqrt(770)*I/1024]",
        ),
        "Qh(5,E,3,0)": (
            "sqrt(7)*C1/4-sqrt(6)*C3/8-sqrt(30)*C5/8",
            "sqrt(105)*x*(y-z)*(y+z)*(2*x**2-y**2-z**2)/4",
            "[sqrt(15)/8,0,sqrt(3)/8,0,-sqrt(14)/8,0,sqrt(14)/8,0,-sqrt(3)/8,0,-sqrt(15)/8]",
        ),
        "Qh(5,E,3,1)": (
            "sqrt(7)*S1/4+sqrt(6)*S3/8-sqrt(30)*S5/8",
            "-sqrt(105)*y*(x-z)*(x+z)*(x**2-2*y**2+z**2)/4",
            "[-sqrt(15)*I/8,0,sqrt(3)*I/8,0,sqrt(14)*I/8,0,sqrt(14)*I/8,0,sqrt(3)*I/8,0,-sqrt(15)*I/8]",
        ),
        "Qh(6,E,3,0)": (
            "sqrt(10)*S1/16-9*S3/16+sqrt(165)*S5/16",
            "sqrt(210)*y*z*(16*x**4-16*x**2*y**2-16*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,sqrt(330)*I/32,0,-9*sqrt(2)*I/32,0,sqrt(5)*I/16,0,sqrt(5)*I/16,0,-9*sqrt(2)*I/32,0,sqrt(330)*I/32,0]",
        ),
        "Qh(6,E,3,1)": (
            "sqrt(10)*C1/16+9*C3/16+sqrt(165)*C5/16",
            "sqrt(210)*x*z*(x**4-16*x**2*y**2+2*x**2*z**2+16*y**4-16*y**2*z**2+z**4)/16",
            "[0,-sqrt(330)/32,0,-9*sqrt(2)/32,0,-sqrt(5)/16,0,sqrt(5)/16,0,9*sqrt(2)/32,0,sqrt(330)/32,0]",
        ),
        "Qh(7,E,3,0)": (
            "-sqrt(858)*C1/64-3*sqrt(286)*C3/64-5*sqrt(26)*C5/64-sqrt(14)*C7/64",
            "sqrt(6006)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/32",
            "[sqrt(7)/64,0,5*sqrt(13)/64,0,3*sqrt(143)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-3*sqrt(143)/64,0,-5*sqrt(13)/64,0,-sqrt(7)/64]",
        ),
        "Qh(7,E,3,1)": (
            "-sqrt(858)*S1/64+3*sqrt(286)*S3/64-5*sqrt(26)*S5/64+sqrt(14)*S7/64",
            "sqrt(6006)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)/32",
            "[sqrt(7)*I/64,0,-5*sqrt(13)*I/64,0,3*sqrt(143)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,3*sqrt(143)*I/64,0,-5*sqrt(13)*I/64,0,sqrt(7)*I/64]",
        ),
        "Qh(8,E,3,0)": (
            "-sqrt(858)*S1/64+sqrt(910)*S3/64+7*sqrt(42)*S5/64+3*sqrt(30)*S7/64",
            "sqrt(858)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(14*x**2-y**2-z**2)/32",
            "[0,3*sqrt(15)*I/64,0,7*sqrt(21)*I/64,0,sqrt(455)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(455)*I/64,0,7*sqrt(21)*I/64,0,3*sqrt(15)*I/64,0]",
        ),
        "Qh(8,E,3,1)": (
            "-sqrt(858)*C1/64-sqrt(910)*C3/64+7*sqrt(42)*C5/64-3*sqrt(30)*C7/64",
            "-sqrt(858)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(x**2-14*y**2+z**2)/32",
            "[0,3*sqrt(15)/64,0,-7*sqrt(21)/64,0,sqrt(455)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-sqrt(455)/64,0,7*sqrt(21)/64,0,-3*sqrt(15)/64,0]",
        ),
        "Qh(9,E,3,0)": (
            "sqrt(1001)*C1/64-sqrt(78)*C3/64-3*sqrt(70)*C5/64+23*sqrt(14)*C7/128+3*sqrt(238)*C9/128",
            "3*sqrt(5005)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(8*x**4-8*x**2*y**2-8*x**2*z**2+y**4+2*y**2*z**2+z**4)/64",
            "[-3*sqrt(119)/128,0,-23*sqrt(7)/128,0,3*sqrt(35)/64,0,sqrt(39)/64,0,-sqrt(2002)/128,0,sqrt(2002)/128,0,-sqrt(39)/64,0,-3*sqrt(35)/64,0,23*sqrt(7)/128,0,3*sqrt(119)/128]",
        ),
        "Qh(9,E,3,1)": (
            "sqrt(1001)*S1/64+sqrt(78)*S3/64-3*sqrt(70)*S5/64-23*sqrt(14)*S7/128+3*sqrt(238)*S9/128",
            "3*sqrt(5005)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(x**4-8*x**2*y**2+2*x**2*z**2+8*y**4-8*y**2*z**2+z**4)/64",
            "[3*sqrt(119)*I/128,0,-23*sqrt(7)*I/128,0,-3*sqrt(35)*I/64,0,sqrt(39)*I/64,0,sqrt(2002)*I/128,0,sqrt(2002)*I/128,0,sqrt(39)*I/64,0,-3*sqrt(35)*I/64,0,-23*sqrt(7)*I/128,0,3*sqrt(119)*I/128]",
        ),
        "Qh(10,E,3,0)": (
            "sqrt(41990)*S1/256+sqrt(4845)*S3/128+sqrt(969)*S5/128+sqrt(285)*S7/256+sqrt(5)*S9/256",
            "sqrt(92378)*y*z*(y**4-10*y**2*z**2+5*z**4)*(5*y**4-10*y**2*z**2+z**4)/256",
            "[0,sqrt(10)*I/512,0,sqrt(570)*I/512,0,sqrt(1938)*I/256,0,sqrt(9690)*I/256,0,sqrt(20995)*I/256,0,sqrt(20995)*I/256,0,sqrt(9690)*I/256,0,sqrt(1938)*I/256,0,sqrt(570)*I/512,0,sqrt(10)*I/512,0]",
        ),
        "Qh(10,E,3,1)": (
            "sqrt(41990)*C1/256-sqrt(4845)*C3/128+sqrt(969)*C5/128-sqrt(285)*C7/256+sqrt(5)*C9/256",
            "sqrt(92378)*x*z*(x**4-10*x**2*z**2+5*z**4)*(5*x**4-10*x**2*z**2+z**4)/256",
            "[0,-sqrt(10)/512,0,sqrt(570)/512,0,-sqrt(1938)/256,0,sqrt(9690)/256,0,-sqrt(20995)/256,0,sqrt(20995)/256,0,-sqrt(9690)/256,0,sqrt(1938)/256,0,-sqrt(570)/512,0,sqrt(10)/512,0]",
        ),
        "Qh(11,E,3,0)": (
            "-5*sqrt(546)*C1/256+sqrt(10659)*C11/256+11*sqrt(30)*C3/256+13*sqrt(7)*C5/256-3*sqrt(1785)*C7/256+3*sqrt(2261)*C9/256",
            "3*sqrt(1001)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(80*x**6-168*x**4*y**2-168*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-5*y**6-15*y**4*z**2-15*y**2*z**4-5*z**6)/128",
            "[-sqrt(21318)/512,0,-3*sqrt(4522)/512,0,3*sqrt(3570)/512,0,-13*sqrt(14)/512,0,-11*sqrt(15)/256,0,5*sqrt(273)/256,0,-5*sqrt(273)/256,0,11*sqrt(15)/256,0,13*sqrt(14)/512,0,-3*sqrt(3570)/512,0,3*sqrt(4522)/512,0,sqrt(21318)/512]",
        ),
        "Qh(11,E,3,1)": (
            "-5*sqrt(546)*S1/256-sqrt(10659)*S11/256-11*sqrt(30)*S3/256+13*sqrt(7)*S5/256+3*sqrt(1785)*S7/256+3*sqrt(2261)*S9/256",
            "-3*sqrt(1001)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(5*x**6-70*x**4*y**2+15*x**4*z**2+168*x**2*y**4-140*x**2*y**2*z**2+15*x**2*z**4-80*y**6+168*y**4*z**2-70*y**2*z**4+5*z**6)/128",
            "[-sqrt(21318)*I/512,0,3*sqrt(4522)*I/512,0,3*sqrt(3570)*I/512,0,13*sqrt(14)*I/512,0,-11*sqrt(15)*I/256,0,-5*sqrt(273)*I/256,0,-5*sqrt(273)*I/256,0,-11*sqrt(15)*I/256,0,13*sqrt(14)*I/512,0,3*sqrt(3570)*I/512,0,3*sqrt(4522)*I/512,0,-sqrt(21318)*I/512]",
        ),
        "Qh(7,E,4,0)": (
            "-15*sqrt(6)*C1/64+19*sqrt(2)*C3/64-sqrt(22)*C5/64-sqrt(2002)*C7/64",
            "sqrt(42)*x*(y-z)*(y+z)*(48*x**4-80*x**2*y**2-80*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/32",
            "[sqrt(1001)/64,0,sqrt(11)/64,0,-19/64,0,15*sqrt(3)/64,0,-15*sqrt(3)/64,0,19/64,0,-sqrt(11)/64,0,-sqrt(1001)/64]",
        ),
        "Qh(7,E,4,1)": (
            "-15*sqrt(6)*S1/64-19*sqrt(2)*S3/64-sqrt(22)*S5/64+sqrt(2002)*S7/64",
            "sqrt(42)*y*(x-z)*(x+z)*(15*x**4-80*x**2*y**2+30*x**2*z**2+48*y**4-80*y**2*z**2+15*z**4)/32",
            "[sqrt(1001)*I/64,0,-sqrt(11)*I/64,0,-19*I/64,0,-15*sqrt(3)*I/64,0,-15*sqrt(3)*I/64,0,-19*I/64,0,-sqrt(11)*I/64,0,sqrt(1001)*I/64]",
        ),
        "Qh(8,E,4,0)": (
            "-sqrt(70)*S1/64+3*sqrt(66)*S3/64-sqrt(1430)*S5/64+sqrt(2002)*S7/64",
            "3*sqrt(70)*y*z*(32*x**6-80*x**4*y**2-80*x**4*z**2+30*x**2*y**4+60*x**2*y**2*z**2+30*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,sqrt(1001)*I/64,0,-sqrt(715)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(35)*I/64,0,-sqrt(35)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(715)*I/64,0,sqrt(1001)*I/64,0]",
        ),
        "Qh(8,E,4,1)": (
            "-sqrt(70)*C1/64-3*sqrt(66)*C3/64-sqrt(1430)*C5/64-sqrt(2002)*C7/64",
            "-3*sqrt(70)*x*z*(x**6-30*x**4*y**2+3*x**4*z**2+80*x**2*y**4-60*x**2*y**2*z**2+3*x**2*z**4-32*y**6+80*y**4*z**2-30*y**2*z**4+z**6)/32",
            "[0,sqrt(1001)/64,0,sqrt(715)/64,0,3*sqrt(33)/64,0,sqrt(35)/64,0,-sqrt(35)/64,0,-3*sqrt(33)/64,0,-sqrt(715)/64,0,-sqrt(1001)/64,0]",
        ),
        "Qh(9,E,4,0)": (
            "sqrt(858)*C1/64+sqrt(91)*C3/32-5*sqrt(15)*C5/32-21*sqrt(3)*C7/64-sqrt(51)*C9/64",
            "sqrt(4290)*x*(y-z)*(y+z)*(14*x**2-3*y**2-3*z**2)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/64",
            "[sqrt(102)/128,0,21*sqrt(6)/128,0,5*sqrt(30)/64,0,-sqrt(182)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(182)/64,0,-5*sqrt(30)/64,0,-21*sqrt(6)/128,0,-sqrt(102)/128]",
        ),
        "Qh(9,E,4,1)": (
            "sqrt(858)*S1/64-sqrt(91)*S3/32-5*sqrt(15)*S5/32+21*sqrt(3)*S7/64-sqrt(51)*S9/64",
            "-sqrt(4290)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(3*x**2-14*y**2+3*z**2)/64",
            "[-sqrt(102)*I/128,0,21*sqrt(6)*I/128,0,-5*sqrt(30)*I/64,0,-sqrt(182)*I/64,0,sqrt(429)*I/64,0,sqrt(429)*I/64,0,-sqrt(182)*I/64,0,-5*sqrt(30)*I/64,0,21*sqrt(6)*I/128,0,-sqrt(102)*I/128]",
        ),
        "Qh(10,E,4,0)": (
            "9*sqrt(78)*S1/256-69*S3/128-sqrt(5)*S5/128+43*sqrt(17)*S7/256+3*sqrt(969)*S9/256",
            "sqrt(4290)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(224*x**4-96*x**2*y**2-96*x**2*z**2+3*y**4+6*y**2*z**2+3*z**4)/256",
            "[0,3*sqrt(1938)*I/512,0,43*sqrt(34)*I/512,0,-sqrt(10)*I/256,0,-69*sqrt(2)*I/256,0,9*sqrt(39)*I/256,0,9*sqrt(39)*I/256,0,-69*sqrt(2)*I/256,0,-sqrt(10)*I/256,0,43*sqrt(34)*I/512,0,3*sqrt(1938)*I/512,0]",
        ),
        "Qh(10,E,4,1)": (
            "9*sqrt(78)*C1/256+69*C3/128-sqrt(5)*C5/128-43*sqrt(17)*C7/256+3*sqrt(969)*C9/256",
            "sqrt(4290)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(3*x**4-96*x**2*y**2+6*x**2*z**2+224*y**4-96*y**2*z**2+3*z**4)/256",
            "[0,-3*sqrt(1938)/512,0,43*sqrt(34)/512,0,sqrt(10)/256,0,-69*sqrt(2)/256,0,-9*sqrt(39)/256,0,9*sqrt(39)/256,0,69*sqrt(2)/256,0,-sqrt(10)/256,0,-43*sqrt(34)/512,0,3*sqrt(1938)/512,0]",
        ),
        "Qh(11,E,4,0)": (
            "-sqrt(29393)*C1/512-sqrt(22)*C11/1024-9*sqrt(1615)*C3/512-5*sqrt(13566)*C5/1024-7*sqrt(1330)*C7/1024-9*sqrt(42)*C9/1024",
            "sqrt(1939938)*x*(y-z)*(y+z)*(y**4-4*y**3*z-14*y**2*z**2-4*y*z**3+z**4)*(y**4+4*y**3*z-14*y**2*z**2+4*y*z**3+z**4)/512",
            "[sqrt(11)/1024,0,9*sqrt(21)/1024,0,7*sqrt(665)/1024,0,5*sqrt(6783)/1024,0,9*sqrt(3230)/1024,0,sqrt(58786)/1024,0,-sqrt(58786)/1024,0,-9*sqrt(3230)/1024,0,-5*sqrt(6783)/1024,0,-7*sqrt(665)/1024,0,-9*sqrt(21)/1024,0,-sqrt(11)/1024]",
        ),
        "Qh(11,E,4,1)": (
            "-sqrt(29393)*S1/512+sqrt(22)*S11/1024+9*sqrt(1615)*S3/512-5*sqrt(13566)*S5/1024+7*sqrt(1330)*S7/1024-9*sqrt(42)*S9/1024",
            "sqrt(1939938)*y*(x-z)*(x+z)*(x**4-4*x**3*z-14*x**2*z**2-4*x*z**3+z**4)*(x**4+4*x**3*z-14*x**2*z**2+4*x*z**3+z**4)/512",
            "[sqrt(11)*I/1024,0,-9*sqrt(21)*I/1024,0,7*sqrt(665)*I/1024,0,-5*sqrt(6783)*I/1024,0,9*sqrt(3230)*I/1024,0,-sqrt(58786)*I/1024,0,-sqrt(58786)*I/1024,0,9*sqrt(3230)*I/1024,0,-5*sqrt(6783)*I/1024,0,7*sqrt(665)*I/1024,0,-9*sqrt(21)*I/1024,0,sqrt(11)*I/1024]",
        ),
        "Qh(9,E,5,0)": (
            "7*sqrt(22)*C1/64-3*sqrt(21)*C3/32+sqrt(65)*C5/32+sqrt(13)*C7/64-3*sqrt(221)*C9/64",
            "3*sqrt(110)*x*(y-z)*(y+z)*(32*x**6-112*x**4*y**2-112*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-7*y**6-21*y**4*z**2-21*y**2*z**4-7*z**6)/64",
            "[3*sqrt(442)/128,0,-sqrt(26)/128,0,-sqrt(130)/64,0,3*sqrt(42)/64,0,-7*sqrt(11)/64,0,7*sqrt(11)/64,0,-3*sqrt(42)/64,0,sqrt(130)/64,0,sqrt(26)/128,0,-3*sqrt(442)/128]",
        ),
        "Qh(9,E,5,1)": (
            "7*sqrt(22)*S1/64+3*sqrt(21)*S3/32+sqrt(65)*S5/32-sqrt(13)*S7/64-3*sqrt(221)*S9/64",
            "-3*sqrt(110)*y*(x-z)*(x+z)*(7*x**6-70*x**4*y**2+21*x**4*z**2+112*x**2*y**4-140*x**2*y**2*z**2+21*x**2*z**4-32*y**6+112*y**4*z**2-70*y**2*z**4+7*z**6)/64",
            "[-3*sqrt(442)*I/128,0,-sqrt(26)*I/128,0,sqrt(130)*I/64,0,3*sqrt(42)*I/64,0,7*sqrt(11)*I/64,0,7*sqrt(11)*I/64,0,3*sqrt(42)*I/64,0,sqrt(130)*I/64,0,-sqrt(26)*I/128,0,-3*sqrt(442)*I/128]",
        ),
        "Qh(10,E,5,0)": (
            "7*sqrt(3)*S1/128-7*sqrt(26)*S3/128+5*sqrt(130)*S5/128-7*sqrt(442)*S7/256+sqrt(25194)*S9/256",
            "sqrt(165)*y*z*(384*x**8-1792*x**6*y**2-1792*x**6*z**2+1680*x**4*y**4+3360*x**4*y**2*z**2+1680*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+7*y**8+28*y**6*z**2+42*y**4*z**4+28*y**2*z**6+7*z**8)/128",
            "[0,sqrt(12597)*I/256,0,-7*sqrt(221)*I/256,0,5*sqrt(65)*I/128,0,-7*sqrt(13)*I/128,0,7*sqrt(6)*I/256,0,7*sqrt(6)*I/256,0,-7*sqrt(13)*I/128,0,5*sqrt(65)*I/128,0,-7*sqrt(221)*I/256,0,sqrt(12597)*I/256,0]",
        ),
        "Qh(10,E,5,1)": (
            "7*sqrt(3)*C1/128+7*sqrt(26)*C3/128+5*sqrt(130)*C5/128+7*sqrt(442)*C7/256+sqrt(25194)*C9/256",
            "sqrt(165)*x*z*(7*x**8-336*x**6*y**2+28*x**6*z**2+1680*x**4*y**4-1008*x**4*y**2*z**2+42*x**4*z**4-1792*x**2*y**6+3360*x**2*y**4*z**2-1008*x**2*y**2*z**4+28*x**2*z**6+384*y**8-1792*y**6*z**2+1680*y**4*z**4-336*y**2*z**6+7*z**8)/128",
            "[0,-sqrt(12597)/256,0,-7*sqrt(221)/256,0,-5*sqrt(65)/128,0,-7*sqrt(13)/128,0,-7*sqrt(6)/256,0,7*sqrt(6)/256,0,7*sqrt(13)/128,0,5*sqrt(65)/128,0,7*sqrt(221)/256,0,sqrt(12597)/256,0]",
        ),
        "Qh(11,E,5,0)": (
            "-15*sqrt(221)*C1/512-3*sqrt(2926)*C11/1024-sqrt(595)*C3/512+53*sqrt(102)*C5/1024-105*sqrt(10)*C7/1024-61*sqrt(114)*C9/1024",
            "sqrt(14586)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)*(224*x**4-160*x**2*y**2-160*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/512",
            "[3*sqrt(1463)/1024,0,61*sqrt(57)/1024,0,105*sqrt(5)/1024,0,-53*sqrt(51)/1024,0,sqrt(1190)/1024,0,15*sqrt(442)/1024,0,-15*sqrt(442)/1024,0,-sqrt(1190)/1024,0,53*sqrt(51)/1024,0,-105*sqrt(5)/1024,0,-61*sqrt(57)/1024,0,-3*sqrt(1463)/1024]",
        ),
        "Qh(11,E,5,1)": (
            "-15*sqrt(221)*S1/512+3*sqrt(2926)*S11/1024+sqrt(595)*S3/512+53*sqrt(102)*S5/1024+105*sqrt(10)*S7/1024-61*sqrt(114)*S9/1024",
            "sqrt(14586)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(15*x**4-160*x**2*y**2+30*x**2*z**2+224*y**4-160*y**2*z**2+15*z**4)/512",
            "[3*sqrt(1463)*I/1024,0,-61*sqrt(57)*I/1024,0,105*sqrt(5)*I/1024,0,53*sqrt(51)*I/1024,0,sqrt(1190)*I/1024,0,-15*sqrt(442)*I/1024,0,-15*sqrt(442)*I/1024,0,sqrt(1190)*I/1024,0,53*sqrt(51)*I/1024,0,105*sqrt(5)*I/1024,0,-61*sqrt(57)*I/1024,0,3*sqrt(1463)*I/1024]",
        ),
        "Qh(11,E,6,0)": (
            "-21*sqrt(130)*C1/512-sqrt(124355)*C11/512+57*sqrt(14)*C3/512-41*sqrt(15)*C5/512+17*sqrt(17)*C7/512+sqrt(4845)*C9/512",
            "sqrt(2145)*x*(y-z)*(y+z)*(128*x**8-768*x**6*y**2-768*x**6*z**2+1008*x**4*y**4+2016*x**4*y**2*z**2+1008*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+21*y**8+84*y**6*z**2+126*y**4*z**4+84*y**2*z**6+21*z**8)/256",
            "[sqrt(248710)/1024,0,-sqrt(9690)/1024,0,-17*sqrt(34)/1024,0,41*sqrt(30)/1024,0,-57*sqrt(7)/512,0,21*sqrt(65)/512,0,-21*sqrt(65)/512,0,57*sqrt(7)/512,0,-41*sqrt(30)/1024,0,17*sqrt(34)/1024,0,sqrt(9690)/1024,0,-sqrt(248710)/1024]",
        ),
        "Qh(11,E,6,1)": (
            "-21*sqrt(130)*S1/512+sqrt(124355)*S11/512-57*sqrt(14)*S3/512-41*sqrt(15)*S5/512-17*sqrt(17)*S7/512+sqrt(4845)*S9/512",
            "sqrt(2145)*y*(x-z)*(x+z)*(21*x**8-336*x**6*y**2+84*x**6*z**2+1008*x**4*y**4-1008*x**4*y**2*z**2+126*x**4*z**4-768*x**2*y**6+2016*x**2*y**4*z**2-1008*x**2*y**2*z**4+84*x**2*z**6+128*y**8-768*y**6*z**2+1008*y**4*z**4-336*y**2*z**6+21*z**8)/256",
            "[sqrt(248710)*I/1024,0,sqrt(9690)*I/1024,0,-17*sqrt(34)*I/1024,0,-41*sqrt(30)*I/1024,0,-57*sqrt(7)*I/512,0,-21*sqrt(65)*I/512,0,-21*sqrt(65)*I/512,0,-57*sqrt(7)*I/512,0,-41*sqrt(30)*I/1024,0,-17*sqrt(34)*I/1024,0,sqrt(9690)*I/1024,0,sqrt(248710)*I/1024]",
        ),
    },
    "D2d-1": {
        "Qh(0,A1,,)": ("C0", "1", "[1]"),
        "Qh(2,A1,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(3,A1,,)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(5,A1,,)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(4,A1,1,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Qh(6,A1,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Qh(7,A1,1,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(8,A1,1,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Qh(9,A1,1,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(10,A1,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Qh(11,A1,1,)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(4,A1,2,)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "-sqrt(15)*(x**4-12*x**2*y**2+6*x**2*z**2+y**4+6*y**2*z**2-2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Qh(6,A1,2,)": (
            "sqrt(14)*C0/4+sqrt(2)*C4/4",
            "-sqrt(14)*(x**6-15*x**4*z**2+15*x**2*z**4+y**6-15*y**4*z**2+15*y**2*z**4-2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Qh(7,A1,2,)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(8,A1,2,)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Qh(9,A1,2,)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A1,2,)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "-sqrt(420189)*(22*x**10+45*x**8*y**2-1035*x**8*z**2-105*x**6*y**4-630*x**6*y**2*z**2+4935*x**6*z**4-105*x**4*y**6+3150*x**4*y**4*z**2-1575*x**4*y**2*z**4-4830*x**4*z**6+45*x**2*y**8-630*x**2*y**6*z**2-1575*x**2*y**4*z**4+1260*x**2*y**2*z**6+990*x**2*z**8+22*y**10-1035*y**8*z**2+4935*y**6*z**4-4830*y**4*z**6+990*y**2*z**8-44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Qh(11,A1,2,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(8,A1,3,)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Qh(10,A1,3,)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "-sqrt(3213210)*(3*x**10-96*x**8*y**2-39*x**8*z**2+224*x**6*y**4+1344*x**6*y**2*z**2-42*x**6*z**4+224*x**4*y**6-6720*x**4*y**4*z**2+3360*x**4*y**2*z**4-182*x**4*z**6-96*x**2*y**8+1344*x**2*y**6*z**2+3360*x**2*y**4*z**4-2688*x**2*y**2*z**6+135*x**2*z**8+3*y**10-39*y**8*z**2-42*y**6*z**4-182*y**4*z**6+135*y**2*z**8-6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Qh(11,A1,3,)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(3,A2,,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(4,A2,,)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(5,A2,,)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(6,A2,,)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(7,A2,1,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Qh(8,A2,1,)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(9,A2,1,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Qh(10,A2,1,)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(11,A2,1,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Qh(7,A2,2,)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "-sqrt(77)*x*y*z*(3*x**4-20*x**2*y**2+10*x**2*z**2+3*y**4+10*y**2*z**2-6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Qh(8,A2,2,)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(9,A2,2,)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Qh(10,A2,2,)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(11,A2,2,)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "-sqrt(230945)*x*y*z*(x**8-6*x**6*y**2-6*x**6*z**2+42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2-84*x**2*y**2*z**4+12*x**2*z**6+y**8-6*y**6*z**2+12*y**2*z**6-2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Qh(11,A2,3,)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "-sqrt(3003)*x*y*z*(5*x**8-150*x**6*y**2+90*x**6*z**2+336*x**4*y**4-70*x**4*y**2*z**2-168*x**4*z**4-150*x**2*y**6-70*x**2*y**4*z**2+140*x**2*y**2*z**4+60*x**2*z**6+5*y**8+90*y**6*z**2-168*y**4*z**4+60*y**2*z**6-10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Qh(2,B1,,)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Qh(4,B1,,)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(5,B1,,)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(7,B1,,)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(6,B1,1,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(8,B1,1,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(9,B1,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Qh(10,B1,1,)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(11,B1,1,)": (
            "S8",
            "-sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(6,B1,2,)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(8,B1,2,)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,B1,2,)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(x-y)*(x+y)*(3*x**4-11*x**2*y**2-7*x**2*z**2+3*y**4-7*y**2*z**2+7*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Qh(10,B1,2,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(11,B1,2,)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,B1,3,)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(1,B2,,)": ("C0", "z", "[0,1,0]"),
        "Qh(2,B2,,)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(3,B2,,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(4,B2,,)": ("-C2", "sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Qh(5,B2,1,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(6,B2,1,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Qh(7,B2,1,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(8,B2,1,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,B2,1,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,B2,1,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Qh(11,B2,1,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(5,B2,2,)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(6,B2,2,)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x-y)*(x+y)*(x**4-9*x**2*y**2-5*x**2*z**2+y**4-5*y**2*z**2+5*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Qh(7,B2,2,)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(8,B2,2,)": (
            "C2",
            "-3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(9,B2,2,)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(10,B2,2,)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(x-y)*(x+y)*(22*x**8-653*x**6*y**2-315*x**6*z**2+2602*x**4*y**4-945*x**4*y**2*z**2+1575*x**4*z**4-653*x**2*y**6-945*x**2*y**4*z**2+3150*x**2*y**2*z**4-1680*x**2*z**6+22*y**8-315*y**6*z**2+1575*y**4*z**4-1680*y**2*z**6+360*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Qh(11,B2,2,)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,B2,3,)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(10,B2,3,)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(x-y)*(x+y)*(9*x**8-165*x**6*y**2-231*x**6*z**2-25*x**4*y**4+3801*x**4*y**2*z**2+406*x**4*z**4-165*x**2*y**6+3801*x**2*y**4*z**2-9674*x**2*y**2*z**4+266*x**2*z**6+9*y**8-231*y**6*z**2+406*y**4*z**4+266*y**2*z**6-57*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Qh(11,B2,3,)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(1,E,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(1,E,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(2,E,,0)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Qh(2,E,,1)": ("-S1", "-sqrt(3)*y*z", "[0,-sqrt(2)*I/2,0,-sqrt(2)*I/2,0]"),
        "Qh(3,E,1,0)": (
            "-sqrt(6)*C1/4+sqrt(10)*C3/4",
            "x*(2*x**2-3*y**2-3*z**2)/2",
            "[-sqrt(5)/4,0,sqrt(3)/4,0,-sqrt(3)/4,0,sqrt(5)/4]",
        ),
        "Qh(3,E,1,1)": (
            "-sqrt(6)*S1/4-sqrt(10)*S3/4",
            "-y*(3*x**2-2*y**2+3*z**2)/2",
            "[-sqrt(5)*I/4,0,-sqrt(3)*I/4,0,-sqrt(3)*I/4,0,-sqrt(5)*I/4]",
        ),
        "Qh(4,E,1,0)": ("sqrt(14)*C1/4-sqrt(2)*C3/4", "-sqrt(35)*x*z*(x-z)*(x+z)/2", "[0,1/4,0,-sqrt(7)/4,0,sqrt(7)/4,0,-1/4,0]"),
        "Qh(4,E,1,1)": (
            "-sqrt(14)*S1/4-sqrt(2)*S3/4",
            "sqrt(35)*y*z*(y-z)*(y+z)/2",
            "[0,-I/4,0,-sqrt(7)*I/4,0,-sqrt(7)*I/4,0,-I/4,0]",
        ),
        "Qh(5,E,1,0)": (
            "sqrt(15)*C1/8-sqrt(70)*C3/16+3*sqrt(14)*C5/16",
            "x*(8*x**4-40*x**2*y**2-40*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/8",
            "[-3*sqrt(7)/16,0,sqrt(35)/16,0,-sqrt(30)/16,0,sqrt(30)/16,0,-sqrt(35)/16,0,3*sqrt(7)/16]",
        ),
        "Qh(5,E,1,1)": (
            "sqrt(15)*S1/8+sqrt(70)*S3/16+3*sqrt(14)*S5/16",
            "y*(15*x**4-40*x**2*y**2+30*x**2*z**2+8*y**4-40*y**2*z**2+15*z**4)/8",
            "[3*sqrt(7)*I/16,0,sqrt(35)*I/16,0,sqrt(30)*I/16,0,sqrt(30)*I/16,0,sqrt(35)*I/16,0,3*sqrt(7)*I/16]",
        ),
        "Qh(6,E,1,0)": (
            "-sqrt(3)*C1/4-sqrt(30)*C3/8+sqrt(22)*C5/8",
            "3*sqrt(7)*x*z*(x-z)*(x+z)*(x**2-10*y**2+z**2)/4",
            "[0,-sqrt(11)/8,0,sqrt(15)/8,0,sqrt(6)/8,0,-sqrt(6)/8,0,-sqrt(15)/8,0,sqrt(11)/8,0]",
        ),
        "Qh(6,E,1,1)": (
            "sqrt(3)*S1/4-sqrt(30)*S3/8-sqrt(22)*S5/8",
            "3*sqrt(7)*y*z*(y-z)*(y+z)*(10*x**2-y**2-z**2)/4",
            "[0,-sqrt(11)*I/8,0,-sqrt(15)*I/8,0,sqrt(6)*I/8,0,sqrt(6)*I/8,0,-sqrt(15)*I/8,0,-sqrt(11)*I/8,0]",
        ),
        "Qh(7,E,1,0)": (
            "-5*sqrt(7)*C1/32+3*sqrt(21)*C3/32-sqrt(231)*C5/32+sqrt(429)*C7/32",
            "x*(16*x**6-168*x**4*y**2-168*x**4*z**2+210*x**2*y**4+420*x**2*y**2*z**2+210*x**2*z**4-35*y**6-105*y**4*z**2-105*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)/64,0,sqrt(462)/64,0,-3*sqrt(42)/64,0,5*sqrt(14)/64,0,-5*sqrt(14)/64,0,3*sqrt(42)/64,0,-sqrt(462)/64,0,sqrt(858)/64]",
        ),
        "Qh(7,E,1,1)": (
            "-5*sqrt(7)*S1/32-3*sqrt(21)*S3/32-sqrt(231)*S5/32-sqrt(429)*S7/32",
            "-y*(35*x**6-210*x**4*y**2+105*x**4*z**2+168*x**2*y**4-420*x**2*y**2*z**2+105*x**2*z**4-16*y**6+168*y**4*z**2-210*y**2*z**4+35*z**6)/16",
            "[-sqrt(858)*I/64,0,-sqrt(462)*I/64,0,-3*sqrt(42)*I/64,0,-5*sqrt(14)*I/64,0,-5*sqrt(14)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(462)*I/64,0,-sqrt(858)*I/64]",
        ),
        "Qh(8,E,1,0)": (
            "sqrt(715)*C1/32-sqrt(273)*C3/32+sqrt(35)*C5/32-C7/32",
            "-3*sqrt(715)*x*z*(x-z)*(x+z)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/16",
            "[0,sqrt(2)/64,0,-sqrt(70)/64,0,sqrt(546)/64,0,-sqrt(1430)/64,0,sqrt(1430)/64,0,-sqrt(546)/64,0,sqrt(70)/64,0,-sqrt(2)/64,0]",
        ),
        "Qh(8,E,1,1)": (
            "-sqrt(715)*S1/32-sqrt(273)*S3/32-sqrt(35)*S5/32-S7/32",
            "3*sqrt(715)*y*z*(y-z)*(y+z)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[0,-sqrt(2)*I/64,0,-sqrt(70)*I/64,0,-sqrt(546)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(546)*I/64,0,-sqrt(70)*I/64,0,-sqrt(2)*I/64,0]",
        ),
        "Qh(9,E,1,0)": (
            "21*sqrt(5)*C1/128-sqrt(2310)*C3/128+3*sqrt(286)*C5/128-3*sqrt(1430)*C7/256+sqrt(24310)*C9/256",
            "x*(128*x**8-2304*x**6*y**2-2304*x**6*z**2+6048*x**4*y**4+12096*x**4*y**2*z**2+6048*x**4*z**4-3360*x**2*y**6-10080*x**2*y**4*z**2-10080*x**2*y**2*z**4-3360*x**2*z**6+315*y**8+1260*y**6*z**2+1890*y**4*z**4+1260*y**2*z**6+315*z**8)/128",
            "[-sqrt(12155)/256,0,3*sqrt(715)/256,0,-3*sqrt(143)/128,0,sqrt(1155)/128,0,-21*sqrt(10)/256,0,21*sqrt(10)/256,0,-sqrt(1155)/128,0,3*sqrt(143)/128,0,-3*sqrt(715)/256,0,sqrt(12155)/256]",
        ),
        "Qh(9,E,1,1)": (
            "21*sqrt(5)*S1/128+sqrt(2310)*S3/128+3*sqrt(286)*S5/128+3*sqrt(1430)*S7/256+sqrt(24310)*S9/256",
            "y*(315*x**8-3360*x**6*y**2+1260*x**6*z**2+6048*x**4*y**4-10080*x**4*y**2*z**2+1890*x**4*z**4-2304*x**2*y**6+12096*x**2*y**4*z**2-10080*x**2*y**2*z**4+1260*x**2*z**6+128*y**8-2304*y**6*z**2+6048*y**4*z**4-3360*y**2*z**6+315*z**8)/128",
            "[sqrt(12155)*I/256,0,3*sqrt(715)*I/256,0,3*sqrt(143)*I/128,0,sqrt(1155)*I/128,0,21*sqrt(10)*I/256,0,21*sqrt(10)*I/256,0,sqrt(1155)*I/128,0,3*sqrt(143)*I/128,0,3*sqrt(715)*I/256,0,sqrt(12155)*I/256]",
        ),
        "Qh(10,E,1,0)": (
            "-sqrt(221)*C1/32-sqrt(102)*C3/32+sqrt(510)*C5/32-11*sqrt(6)*C7/64+sqrt(38)*C9/64",
            "sqrt(12155)*x*z*(x-z)*(x+z)*(x**2-18*y**2+z**2)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/32",
            "[0,-sqrt(19)/64,0,11*sqrt(3)/64,0,-sqrt(255)/32,0,sqrt(51)/32,0,sqrt(442)/64,0,-sqrt(442)/64,0,-sqrt(51)/32,0,sqrt(255)/32,0,-11*sqrt(3)/64,0,sqrt(19)/64,0]",
        ),
        "Qh(10,E,1,1)": (
            "sqrt(221)*S1/32-sqrt(102)*S3/32-sqrt(510)*S5/32-11*sqrt(6)*S7/64-sqrt(38)*S9/64",
            "sqrt(12155)*y*z*(y-z)*(y+z)*(18*x**2-y**2-z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/32",
            "[0,-sqrt(19)*I/64,0,-11*sqrt(3)*I/64,0,-sqrt(255)*I/32,0,-sqrt(51)*I/32,0,sqrt(442)*I/64,0,sqrt(442)*I/64,0,-sqrt(51)*I/32,0,-sqrt(255)*I/32,0,-11*sqrt(3)*I/64,0,-sqrt(19)*I/64,0]",
        ),
        "Qh(11,E,1,0)": (
            "-21*sqrt(66)*C1/512+sqrt(88179)*C11/512+sqrt(30030)*C3/512-15*sqrt(143)*C5/512+sqrt(36465)*C7/512-sqrt(46189)*C9/512",
            "x*(256*x**10-7040*x**8*y**2-7040*x**8*z**2+31680*x**6*y**4+63360*x**6*y**2*z**2+31680*x**6*z**4-36960*x**4*y**6-110880*x**4*y**4*z**2-110880*x**4*y**2*z**4-36960*x**4*z**6+11550*x**2*y**8+46200*x**2*y**6*z**2+69300*x**2*y**4*z**4+46200*x**2*y**2*z**6+11550*x**2*z**8-693*y**10-3465*y**8*z**2-6930*y**6*z**4-6930*y**4*z**6-3465*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)/1024,0,sqrt(92378)/1024,0,-sqrt(72930)/1024,0,15*sqrt(286)/1024,0,-sqrt(15015)/512,0,21*sqrt(33)/512,0,-21*sqrt(33)/512,0,sqrt(15015)/512,0,-15*sqrt(286)/1024,0,sqrt(72930)/1024,0,-sqrt(92378)/1024,0,sqrt(176358)/1024]",
        ),
        "Qh(11,E,1,1)": (
            "-21*sqrt(66)*S1/512-sqrt(88179)*S11/512-sqrt(30030)*S3/512-15*sqrt(143)*S5/512-sqrt(36465)*S7/512-sqrt(46189)*S9/512",
            "-y*(693*x**10-11550*x**8*y**2+3465*x**8*z**2+36960*x**6*y**4-46200*x**6*y**2*z**2+6930*x**6*z**4-31680*x**4*y**6+110880*x**4*y**4*z**2-69300*x**4*y**2*z**4+6930*x**4*z**6+7040*x**2*y**8-63360*x**2*y**6*z**2+110880*x**2*y**4*z**4-46200*x**2*y**2*z**6+3465*x**2*z**8-256*y**10+7040*y**8*z**2-31680*y**6*z**4+36960*y**4*z**6-11550*y**2*z**8+693*z**10)/256",
            "[-sqrt(176358)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(72930)*I/1024,0,-15*sqrt(286)*I/1024,0,-sqrt(15015)*I/512,0,-21*sqrt(33)*I/512,0,-21*sqrt(33)*I/512,0,-sqrt(15015)*I/512,0,-15*sqrt(286)*I/1024,0,-sqrt(72930)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(176358)*I/1024]",
        ),
        "Qh(3,E,2,0)": (
            "-sqrt(10)*C1/4-sqrt(6)*C3/4",
            "sqrt(15)*x*(y-z)*(y+z)/2",
            "[sqrt(3)/4,0,sqrt(5)/4,0,-sqrt(5)/4,0,-sqrt(3)/4]",
        ),
        "Qh(3,E,2,1)": (
            "-sqrt(10)*S1/4+sqrt(6)*S3/4",
            "sqrt(15)*y*(x-z)*(x+z)/2",
            "[sqrt(3)*I/4,0,-sqrt(5)*I/4,0,-sqrt(5)*I/4,0,sqrt(3)*I/4]",
        ),
        "Qh(4,E,2,0)": (
            "-sqrt(2)*C1/4-sqrt(14)*C3/4",
            "-sqrt(5)*x*z*(x**2-6*y**2+z**2)/2",
            "[0,sqrt(7)/4,0,1/4,0,-1/4,0,-sqrt(7)/4,0]",
        ),
        "Qh(4,E,2,1)": (
            "sqrt(2)*S1/4-sqrt(14)*S3/4",
            "-sqrt(5)*y*z*(6*x**2-y**2-z**2)/2",
            "[0,-sqrt(7)*I/4,0,I/4,0,I/4,0,-sqrt(7)*I/4,0]",
        ),
        "Qh(5,E,2,0)": (
            "sqrt(21)*C1/8+9*sqrt(2)*C3/16+sqrt(10)*C5/16",
            "3*sqrt(35)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/8",
            "[-sqrt(5)/16,0,-9/16,0,-sqrt(42)/16,0,sqrt(42)/16,0,9/16,0,sqrt(5)/16]",
        ),
        "Qh(5,E,2,1)": (
            "sqrt(21)*S1/8-9*sqrt(2)*S3/16+sqrt(10)*S5/16",
            "3*sqrt(35)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/8",
            "[sqrt(5)*I/16,0,-9*I/16,0,sqrt(42)*I/16,0,sqrt(42)*I/16,0,-9*I/16,0,sqrt(5)*I/16]",
        ),
        "Qh(6,E,2,0)": (
            "3*sqrt(22)*C1/16-sqrt(55)*C3/16+sqrt(3)*C5/16",
            "sqrt(462)*x*z*(x**2-3*z**2)*(3*x**2-z**2)/16",
            "[0,-sqrt(6)/32,0,sqrt(110)/32,0,-3*sqrt(11)/16,0,3*sqrt(11)/16,0,-sqrt(110)/32,0,sqrt(6)/32,0]",
        ),
        "Qh(6,E,2,1)": (
            "-3*sqrt(22)*S1/16-sqrt(55)*S3/16-sqrt(3)*S5/16",
            "-sqrt(462)*y*z*(y**2-3*z**2)*(3*y**2-z**2)/16",
            "[0,-sqrt(6)*I/32,0,-sqrt(110)*I/32,0,-3*sqrt(11)*I/16,0,-3*sqrt(11)*I/16,0,-sqrt(110)*I/32,0,-sqrt(6)*I/32,0]",
        ),
        "Qh(7,E,2,0)": (
            "-3*sqrt(33)*C1/32-sqrt(11)*C3/32+25*C5/32+sqrt(91)*C7/32",
            "sqrt(231)*x*(10*x**2-3*y**2-3*z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[-sqrt(182)/64,0,-25*sqrt(2)/64,0,sqrt(22)/64,0,3*sqrt(66)/64,0,-3*sqrt(66)/64,0,-sqrt(22)/64,0,25*sqrt(2)/64,0,sqrt(182)/64]",
        ),
        "Qh(7,E,2,1)": (
            "-3*sqrt(33)*S1/32+sqrt(11)*S3/32+25*S5/32-sqrt(91)*S7/32",
            "-sqrt(231)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(3*x**2-10*y**2+3*z**2)/16",
            "[-sqrt(182)*I/64,0,25*sqrt(2)*I/64,0,sqrt(22)*I/64,0,-3*sqrt(66)*I/64,0,-3*sqrt(66)*I/64,0,sqrt(22)*I/64,0,25*sqrt(2)*I/64,0,-sqrt(182)*I/64]",
        ),
        "Qh(8,E,2,0)": (
            "sqrt(77)*C1/32+5*sqrt(15)*C3/32+3*sqrt(13)*C5/32-sqrt(455)*C7/32",
            "-3*sqrt(77)*x*z*(x-z)*(x+z)*(x**4-24*x**2*y**2+2*x**2*z**2+40*y**4-24*y**2*z**2+z**4)/16",
            "[0,sqrt(910)/64,0,-3*sqrt(26)/64,0,-5*sqrt(30)/64,0,-sqrt(154)/64,0,sqrt(154)/64,0,5*sqrt(30)/64,0,3*sqrt(26)/64,0,-sqrt(910)/64,0]",
        ),
        "Qh(8,E,2,1)": (
            "-sqrt(77)*S1/32+5*sqrt(15)*S3/32-3*sqrt(13)*S5/32-sqrt(455)*S7/32",
            "3*sqrt(77)*y*z*(y-z)*(y+z)*(40*x**4-24*x**2*y**2-24*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,-sqrt(910)*I/64,0,-3*sqrt(26)*I/64,0,5*sqrt(30)*I/64,0,-sqrt(154)*I/64,0,-sqrt(154)*I/64,0,5*sqrt(30)*I/64,0,-3*sqrt(26)*I/64,0,-sqrt(910)*I/64,0]",
        ),
        "Qh(9,E,2,0)": (
            "sqrt(2431)*C1/128+sqrt(9282)*C3/128+5*sqrt(170)*C5/128+7*sqrt(34)*C7/256+3*sqrt(2)*C9/256",
            "3*sqrt(12155)*x*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/128",
            "[-3/256,0,-7*sqrt(17)/256,0,-5*sqrt(85)/128,0,-sqrt(4641)/128,0,-sqrt(4862)/256,0,sqrt(4862)/256,0,sqrt(4641)/128,0,5*sqrt(85)/128,0,7*sqrt(17)/256,0,3/256]",
        ),
        "Qh(9,E,2,1)": (
            "sqrt(2431)*S1/128-sqrt(9282)*S3/128+5*sqrt(170)*S5/128-7*sqrt(34)*S7/256+3*sqrt(2)*S9/256",
            "3*sqrt(12155)*y*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/128",
            "[3*I/256,0,-7*sqrt(17)*I/256,0,5*sqrt(85)*I/128,0,-sqrt(4641)*I/128,0,sqrt(4862)*I/256,0,sqrt(4862)*I/256,0,-sqrt(4641)*I/128,0,5*sqrt(85)*I/128,0,-7*sqrt(17)*I/256,0,3*I/256]",
        ),
        "Qh(10,E,2,0)": (
            "-sqrt(39)*C1/32-11*sqrt(2)*C3/32-5*sqrt(10)*C5/32-sqrt(34)*C7/64+sqrt(1938)*C9/64",
            "sqrt(2145)*x*z*(x-z)*(x+z)*(x**6-42*x**4*y**2+3*x**4*z**2+168*x**2*y**4-84*x**2*y**2*z**2+3*x**2*z**4-112*y**6+168*y**4*z**2-42*y**2*z**4+z**6)/32",
            "[0,-sqrt(969)/64,0,sqrt(17)/64,0,5*sqrt(5)/32,0,11/32,0,sqrt(78)/64,0,-sqrt(78)/64,0,-11/32,0,-5*sqrt(5)/32,0,-sqrt(17)/64,0,sqrt(969)/64,0]",
        ),
        "Qh(10,E,2,1)": (
            "sqrt(39)*S1/32-11*sqrt(2)*S3/32+5*sqrt(10)*S5/32-sqrt(34)*S7/64-sqrt(1938)*S9/64",
            "sqrt(2145)*y*z*(y-z)*(y+z)*(112*x**6-168*x**4*y**2-168*x**4*z**2+42*x**2*y**4+84*x**2*y**2*z**2+42*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,-sqrt(969)*I/64,0,-sqrt(17)*I/64,0,5*sqrt(5)*I/32,0,-11*I/32,0,sqrt(78)*I/64,0,sqrt(78)*I/64,0,-11*I/32,0,5*sqrt(5)*I/32,0,-sqrt(17)*I/64,0,-sqrt(969)*I/64,0]",
        ),
        "Qh(11,E,2,0)": (
            "-sqrt(41990)*C1/512+sqrt(385)*C11/512-3*sqrt(4522)*C3/512+3*sqrt(4845)*C5/512+77*sqrt(19)*C7/512+39*sqrt(15)*C9/512",
            "sqrt(692835)*x*(6*x**2-y**2-z**2)*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/256",
            "[-sqrt(770)/1024,0,-39*sqrt(30)/1024,0,-77*sqrt(38)/1024,0,-3*sqrt(9690)/1024,0,3*sqrt(2261)/512,0,sqrt(20995)/512,0,-sqrt(20995)/512,0,-3*sqrt(2261)/512,0,3*sqrt(9690)/1024,0,77*sqrt(38)/1024,0,39*sqrt(30)/1024,0,sqrt(770)/1024]",
        ),
        "Qh(11,E,2,1)": (
            "-sqrt(41990)*S1/512-sqrt(385)*S11/512+3*sqrt(4522)*S3/512+3*sqrt(4845)*S5/512-77*sqrt(19)*S7/512+39*sqrt(15)*S9/512",
            "-sqrt(692835)*y*(x**2-6*y**2+z**2)*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/256",
            "[-sqrt(770)*I/1024,0,39*sqrt(30)*I/1024,0,-77*sqrt(38)*I/1024,0,3*sqrt(9690)*I/1024,0,3*sqrt(2261)*I/512,0,-sqrt(20995)*I/512,0,-sqrt(20995)*I/512,0,3*sqrt(2261)*I/512,0,3*sqrt(9690)*I/1024,0,-77*sqrt(38)*I/1024,0,39*sqrt(30)*I/1024,0,-sqrt(770)*I/1024]",
        ),
        "Qh(5,E,3,0)": (
            "sqrt(7)*C1/4-sqrt(6)*C3/8-sqrt(30)*C5/8",
            "sqrt(105)*x*(y-z)*(y+z)*(2*x**2-y**2-z**2)/4",
            "[sqrt(15)/8,0,sqrt(3)/8,0,-sqrt(14)/8,0,sqrt(14)/8,0,-sqrt(3)/8,0,-sqrt(15)/8]",
        ),
        "Qh(5,E,3,1)": (
            "sqrt(7)*S1/4+sqrt(6)*S3/8-sqrt(30)*S5/8",
            "-sqrt(105)*y*(x-z)*(x+z)*(x**2-2*y**2+z**2)/4",
            "[-sqrt(15)*I/8,0,sqrt(3)*I/8,0,sqrt(14)*I/8,0,sqrt(14)*I/8,0,sqrt(3)*I/8,0,-sqrt(15)*I/8]",
        ),
        "Qh(6,E,3,0)": (
            "sqrt(10)*C1/16+9*C3/16+sqrt(165)*C5/16",
            "sqrt(210)*x*z*(x**4-16*x**2*y**2+2*x**2*z**2+16*y**4-16*y**2*z**2+z**4)/16",
            "[0,-sqrt(330)/32,0,-9*sqrt(2)/32,0,-sqrt(5)/16,0,sqrt(5)/16,0,9*sqrt(2)/32,0,sqrt(330)/32,0]",
        ),
        "Qh(6,E,3,1)": (
            "-sqrt(10)*S1/16+9*S3/16-sqrt(165)*S5/16",
            "-sqrt(210)*y*z*(16*x**4-16*x**2*y**2-16*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,-sqrt(330)*I/32,0,9*sqrt(2)*I/32,0,-sqrt(5)*I/16,0,-sqrt(5)*I/16,0,9*sqrt(2)*I/32,0,-sqrt(330)*I/32,0]",
        ),
        "Qh(7,E,3,0)": (
            "-sqrt(858)*C1/64-3*sqrt(286)*C3/64-5*sqrt(26)*C5/64-sqrt(14)*C7/64",
            "sqrt(6006)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/32",
            "[sqrt(7)/64,0,5*sqrt(13)/64,0,3*sqrt(143)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-3*sqrt(143)/64,0,-5*sqrt(13)/64,0,-sqrt(7)/64]",
        ),
        "Qh(7,E,3,1)": (
            "-sqrt(858)*S1/64+3*sqrt(286)*S3/64-5*sqrt(26)*S5/64+sqrt(14)*S7/64",
            "sqrt(6006)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)/32",
            "[sqrt(7)*I/64,0,-5*sqrt(13)*I/64,0,3*sqrt(143)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,3*sqrt(143)*I/64,0,-5*sqrt(13)*I/64,0,sqrt(7)*I/64]",
        ),
        "Qh(8,E,3,0)": (
            "-sqrt(858)*C1/64-sqrt(910)*C3/64+7*sqrt(42)*C5/64-3*sqrt(30)*C7/64",
            "-sqrt(858)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(x**2-14*y**2+z**2)/32",
            "[0,3*sqrt(15)/64,0,-7*sqrt(21)/64,0,sqrt(455)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-sqrt(455)/64,0,7*sqrt(21)/64,0,-3*sqrt(15)/64,0]",
        ),
        "Qh(8,E,3,1)": (
            "sqrt(858)*S1/64-sqrt(910)*S3/64-7*sqrt(42)*S5/64-3*sqrt(30)*S7/64",
            "-sqrt(858)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(14*x**2-y**2-z**2)/32",
            "[0,-3*sqrt(15)*I/64,0,-7*sqrt(21)*I/64,0,-sqrt(455)*I/64,0,sqrt(429)*I/64,0,sqrt(429)*I/64,0,-sqrt(455)*I/64,0,-7*sqrt(21)*I/64,0,-3*sqrt(15)*I/64,0]",
        ),
        "Qh(9,E,3,0)": (
            "sqrt(1001)*C1/64-sqrt(78)*C3/64-3*sqrt(70)*C5/64+23*sqrt(14)*C7/128+3*sqrt(238)*C9/128",
            "3*sqrt(5005)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(8*x**4-8*x**2*y**2-8*x**2*z**2+y**4+2*y**2*z**2+z**4)/64",
            "[-3*sqrt(119)/128,0,-23*sqrt(7)/128,0,3*sqrt(35)/64,0,sqrt(39)/64,0,-sqrt(2002)/128,0,sqrt(2002)/128,0,-sqrt(39)/64,0,-3*sqrt(35)/64,0,23*sqrt(7)/128,0,3*sqrt(119)/128]",
        ),
        "Qh(9,E,3,1)": (
            "sqrt(1001)*S1/64+sqrt(78)*S3/64-3*sqrt(70)*S5/64-23*sqrt(14)*S7/128+3*sqrt(238)*S9/128",
            "3*sqrt(5005)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(x**4-8*x**2*y**2+2*x**2*z**2+8*y**4-8*y**2*z**2+z**4)/64",
            "[3*sqrt(119)*I/128,0,-23*sqrt(7)*I/128,0,-3*sqrt(35)*I/64,0,sqrt(39)*I/64,0,sqrt(2002)*I/128,0,sqrt(2002)*I/128,0,sqrt(39)*I/64,0,-3*sqrt(35)*I/64,0,-23*sqrt(7)*I/128,0,3*sqrt(119)*I/128]",
        ),
        "Qh(10,E,3,0)": (
            "sqrt(41990)*C1/256-sqrt(4845)*C3/128+sqrt(969)*C5/128-sqrt(285)*C7/256+sqrt(5)*C9/256",
            "sqrt(92378)*x*z*(x**4-10*x**2*z**2+5*z**4)*(5*x**4-10*x**2*z**2+z**4)/256",
            "[0,-sqrt(10)/512,0,sqrt(570)/512,0,-sqrt(1938)/256,0,sqrt(9690)/256,0,-sqrt(20995)/256,0,sqrt(20995)/256,0,-sqrt(9690)/256,0,sqrt(1938)/256,0,-sqrt(570)/512,0,sqrt(10)/512,0]",
        ),
        "Qh(10,E,3,1)": (
            "-sqrt(41990)*S1/256-sqrt(4845)*S3/128-sqrt(969)*S5/128-sqrt(285)*S7/256-sqrt(5)*S9/256",
            "-sqrt(92378)*y*z*(y**4-10*y**2*z**2+5*z**4)*(5*y**4-10*y**2*z**2+z**4)/256",
            "[0,-sqrt(10)*I/512,0,-sqrt(570)*I/512,0,-sqrt(1938)*I/256,0,-sqrt(9690)*I/256,0,-sqrt(20995)*I/256,0,-sqrt(20995)*I/256,0,-sqrt(9690)*I/256,0,-sqrt(1938)*I/256,0,-sqrt(570)*I/512,0,-sqrt(10)*I/512,0]",
        ),
        "Qh(11,E,3,0)": (
            "-5*sqrt(546)*C1/256+sqrt(10659)*C11/256+11*sqrt(30)*C3/256+13*sqrt(7)*C5/256-3*sqrt(1785)*C7/256+3*sqrt(2261)*C9/256",
            "3*sqrt(1001)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(80*x**6-168*x**4*y**2-168*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-5*y**6-15*y**4*z**2-15*y**2*z**4-5*z**6)/128",
            "[-sqrt(21318)/512,0,-3*sqrt(4522)/512,0,3*sqrt(3570)/512,0,-13*sqrt(14)/512,0,-11*sqrt(15)/256,0,5*sqrt(273)/256,0,-5*sqrt(273)/256,0,11*sqrt(15)/256,0,13*sqrt(14)/512,0,-3*sqrt(3570)/512,0,3*sqrt(4522)/512,0,sqrt(21318)/512]",
        ),
        "Qh(11,E,3,1)": (
            "-5*sqrt(546)*S1/256-sqrt(10659)*S11/256-11*sqrt(30)*S3/256+13*sqrt(7)*S5/256+3*sqrt(1785)*S7/256+3*sqrt(2261)*S9/256",
            "-3*sqrt(1001)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(5*x**6-70*x**4*y**2+15*x**4*z**2+168*x**2*y**4-140*x**2*y**2*z**2+15*x**2*z**4-80*y**6+168*y**4*z**2-70*y**2*z**4+5*z**6)/128",
            "[-sqrt(21318)*I/512,0,3*sqrt(4522)*I/512,0,3*sqrt(3570)*I/512,0,13*sqrt(14)*I/512,0,-11*sqrt(15)*I/256,0,-5*sqrt(273)*I/256,0,-5*sqrt(273)*I/256,0,-11*sqrt(15)*I/256,0,13*sqrt(14)*I/512,0,3*sqrt(3570)*I/512,0,3*sqrt(4522)*I/512,0,-sqrt(21318)*I/512]",
        ),
        "Qh(7,E,4,0)": (
            "-15*sqrt(6)*C1/64+19*sqrt(2)*C3/64-sqrt(22)*C5/64-sqrt(2002)*C7/64",
            "sqrt(42)*x*(y-z)*(y+z)*(48*x**4-80*x**2*y**2-80*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/32",
            "[sqrt(1001)/64,0,sqrt(11)/64,0,-19/64,0,15*sqrt(3)/64,0,-15*sqrt(3)/64,0,19/64,0,-sqrt(11)/64,0,-sqrt(1001)/64]",
        ),
        "Qh(7,E,4,1)": (
            "-15*sqrt(6)*S1/64-19*sqrt(2)*S3/64-sqrt(22)*S5/64+sqrt(2002)*S7/64",
            "sqrt(42)*y*(x-z)*(x+z)*(15*x**4-80*x**2*y**2+30*x**2*z**2+48*y**4-80*y**2*z**2+15*z**4)/32",
            "[sqrt(1001)*I/64,0,-sqrt(11)*I/64,0,-19*I/64,0,-15*sqrt(3)*I/64,0,-15*sqrt(3)*I/64,0,-19*I/64,0,-sqrt(11)*I/64,0,sqrt(1001)*I/64]",
        ),
        "Qh(8,E,4,0)": (
            "-sqrt(70)*C1/64-3*sqrt(66)*C3/64-sqrt(1430)*C5/64-sqrt(2002)*C7/64",
            "-3*sqrt(70)*x*z*(x**6-30*x**4*y**2+3*x**4*z**2+80*x**2*y**4-60*x**2*y**2*z**2+3*x**2*z**4-32*y**6+80*y**4*z**2-30*y**2*z**4+z**6)/32",
            "[0,sqrt(1001)/64,0,sqrt(715)/64,0,3*sqrt(33)/64,0,sqrt(35)/64,0,-sqrt(35)/64,0,-3*sqrt(33)/64,0,-sqrt(715)/64,0,-sqrt(1001)/64,0]",
        ),
        "Qh(8,E,4,1)": (
            "sqrt(70)*S1/64-3*sqrt(66)*S3/64+sqrt(1430)*S5/64-sqrt(2002)*S7/64",
            "-3*sqrt(70)*y*z*(32*x**6-80*x**4*y**2-80*x**4*z**2+30*x**2*y**4+60*x**2*y**2*z**2+30*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,-sqrt(1001)*I/64,0,sqrt(715)*I/64,0,-3*sqrt(33)*I/64,0,sqrt(35)*I/64,0,sqrt(35)*I/64,0,-3*sqrt(33)*I/64,0,sqrt(715)*I/64,0,-sqrt(1001)*I/64,0]",
        ),
        "Qh(9,E,4,0)": (
            "sqrt(858)*C1/64+sqrt(91)*C3/32-5*sqrt(15)*C5/32-21*sqrt(3)*C7/64-sqrt(51)*C9/64",
            "sqrt(4290)*x*(y-z)*(y+z)*(14*x**2-3*y**2-3*z**2)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/64",
            "[sqrt(102)/128,0,21*sqrt(6)/128,0,5*sqrt(30)/64,0,-sqrt(182)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(182)/64,0,-5*sqrt(30)/64,0,-21*sqrt(6)/128,0,-sqrt(102)/128]",
        ),
        "Qh(9,E,4,1)": (
            "sqrt(858)*S1/64-sqrt(91)*S3/32-5*sqrt(15)*S5/32+21*sqrt(3)*S7/64-sqrt(51)*S9/64",
            "-sqrt(4290)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(3*x**2-14*y**2+3*z**2)/64",
            "[-sqrt(102)*I/128,0,21*sqrt(6)*I/128,0,-5*sqrt(30)*I/64,0,-sqrt(182)*I/64,0,sqrt(429)*I/64,0,sqrt(429)*I/64,0,-sqrt(182)*I/64,0,-5*sqrt(30)*I/64,0,21*sqrt(6)*I/128,0,-sqrt(102)*I/128]",
        ),
        "Qh(10,E,4,0)": (
            "9*sqrt(78)*C1/256+69*C3/128-sqrt(5)*C5/128-43*sqrt(17)*C7/256+3*sqrt(969)*C9/256",
            "sqrt(4290)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(3*x**4-96*x**2*y**2+6*x**2*z**2+224*y**4-96*y**2*z**2+3*z**4)/256",
            "[0,-3*sqrt(1938)/512,0,43*sqrt(34)/512,0,sqrt(10)/256,0,-69*sqrt(2)/256,0,-9*sqrt(39)/256,0,9*sqrt(39)/256,0,69*sqrt(2)/256,0,-sqrt(10)/256,0,-43*sqrt(34)/512,0,3*sqrt(1938)/512,0]",
        ),
        "Qh(10,E,4,1)": (
            "-9*sqrt(78)*S1/256+69*S3/128+sqrt(5)*S5/128-43*sqrt(17)*S7/256-3*sqrt(969)*S9/256",
            "-sqrt(4290)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(224*x**4-96*x**2*y**2-96*x**2*z**2+3*y**4+6*y**2*z**2+3*z**4)/256",
            "[0,-3*sqrt(1938)*I/512,0,-43*sqrt(34)*I/512,0,sqrt(10)*I/256,0,69*sqrt(2)*I/256,0,-9*sqrt(39)*I/256,0,-9*sqrt(39)*I/256,0,69*sqrt(2)*I/256,0,sqrt(10)*I/256,0,-43*sqrt(34)*I/512,0,-3*sqrt(1938)*I/512,0]",
        ),
        "Qh(11,E,4,0)": (
            "-sqrt(29393)*C1/512-sqrt(22)*C11/1024-9*sqrt(1615)*C3/512-5*sqrt(13566)*C5/1024-7*sqrt(1330)*C7/1024-9*sqrt(42)*C9/1024",
            "sqrt(1939938)*x*(y-z)*(y+z)*(y**4-4*y**3*z-14*y**2*z**2-4*y*z**3+z**4)*(y**4+4*y**3*z-14*y**2*z**2+4*y*z**3+z**4)/512",
            "[sqrt(11)/1024,0,9*sqrt(21)/1024,0,7*sqrt(665)/1024,0,5*sqrt(6783)/1024,0,9*sqrt(3230)/1024,0,sqrt(58786)/1024,0,-sqrt(58786)/1024,0,-9*sqrt(3230)/1024,0,-5*sqrt(6783)/1024,0,-7*sqrt(665)/1024,0,-9*sqrt(21)/1024,0,-sqrt(11)/1024]",
        ),
        "Qh(11,E,4,1)": (
            "-sqrt(29393)*S1/512+sqrt(22)*S11/1024+9*sqrt(1615)*S3/512-5*sqrt(13566)*S5/1024+7*sqrt(1330)*S7/1024-9*sqrt(42)*S9/1024",
            "sqrt(1939938)*y*(x-z)*(x+z)*(x**4-4*x**3*z-14*x**2*z**2-4*x*z**3+z**4)*(x**4+4*x**3*z-14*x**2*z**2+4*x*z**3+z**4)/512",
            "[sqrt(11)*I/1024,0,-9*sqrt(21)*I/1024,0,7*sqrt(665)*I/1024,0,-5*sqrt(6783)*I/1024,0,9*sqrt(3230)*I/1024,0,-sqrt(58786)*I/1024,0,-sqrt(58786)*I/1024,0,9*sqrt(3230)*I/1024,0,-5*sqrt(6783)*I/1024,0,7*sqrt(665)*I/1024,0,-9*sqrt(21)*I/1024,0,sqrt(11)*I/1024]",
        ),
        "Qh(9,E,5,0)": (
            "7*sqrt(22)*C1/64-3*sqrt(21)*C3/32+sqrt(65)*C5/32+sqrt(13)*C7/64-3*sqrt(221)*C9/64",
            "3*sqrt(110)*x*(y-z)*(y+z)*(32*x**6-112*x**4*y**2-112*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-7*y**6-21*y**4*z**2-21*y**2*z**4-7*z**6)/64",
            "[3*sqrt(442)/128,0,-sqrt(26)/128,0,-sqrt(130)/64,0,3*sqrt(42)/64,0,-7*sqrt(11)/64,0,7*sqrt(11)/64,0,-3*sqrt(42)/64,0,sqrt(130)/64,0,sqrt(26)/128,0,-3*sqrt(442)/128]",
        ),
        "Qh(9,E,5,1)": (
            "7*sqrt(22)*S1/64+3*sqrt(21)*S3/32+sqrt(65)*S5/32-sqrt(13)*S7/64-3*sqrt(221)*S9/64",
            "-3*sqrt(110)*y*(x-z)*(x+z)*(7*x**6-70*x**4*y**2+21*x**4*z**2+112*x**2*y**4-140*x**2*y**2*z**2+21*x**2*z**4-32*y**6+112*y**4*z**2-70*y**2*z**4+7*z**6)/64",
            "[-3*sqrt(442)*I/128,0,-sqrt(26)*I/128,0,sqrt(130)*I/64,0,3*sqrt(42)*I/64,0,7*sqrt(11)*I/64,0,7*sqrt(11)*I/64,0,3*sqrt(42)*I/64,0,sqrt(130)*I/64,0,-sqrt(26)*I/128,0,-3*sqrt(442)*I/128]",
        ),
        "Qh(10,E,5,0)": (
            "7*sqrt(3)*C1/128+7*sqrt(26)*C3/128+5*sqrt(130)*C5/128+7*sqrt(442)*C7/256+sqrt(25194)*C9/256",
            "sqrt(165)*x*z*(7*x**8-336*x**6*y**2+28*x**6*z**2+1680*x**4*y**4-1008*x**4*y**2*z**2+42*x**4*z**4-1792*x**2*y**6+3360*x**2*y**4*z**2-1008*x**2*y**2*z**4+28*x**2*z**6+384*y**8-1792*y**6*z**2+1680*y**4*z**4-336*y**2*z**6+7*z**8)/128",
            "[0,-sqrt(12597)/256,0,-7*sqrt(221)/256,0,-5*sqrt(65)/128,0,-7*sqrt(13)/128,0,-7*sqrt(6)/256,0,7*sqrt(6)/256,0,7*sqrt(13)/128,0,5*sqrt(65)/128,0,7*sqrt(221)/256,0,sqrt(12597)/256,0]",
        ),
        "Qh(10,E,5,1)": (
            "-7*sqrt(3)*S1/128+7*sqrt(26)*S3/128-5*sqrt(130)*S5/128+7*sqrt(442)*S7/256-sqrt(25194)*S9/256",
            "-sqrt(165)*y*z*(384*x**8-1792*x**6*y**2-1792*x**6*z**2+1680*x**4*y**4+3360*x**4*y**2*z**2+1680*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+7*y**8+28*y**6*z**2+42*y**4*z**4+28*y**2*z**6+7*z**8)/128",
            "[0,-sqrt(12597)*I/256,0,7*sqrt(221)*I/256,0,-5*sqrt(65)*I/128,0,7*sqrt(13)*I/128,0,-7*sqrt(6)*I/256,0,-7*sqrt(6)*I/256,0,7*sqrt(13)*I/128,0,-5*sqrt(65)*I/128,0,7*sqrt(221)*I/256,0,-sqrt(12597)*I/256,0]",
        ),
        "Qh(11,E,5,0)": (
            "-15*sqrt(221)*C1/512-3*sqrt(2926)*C11/1024-sqrt(595)*C3/512+53*sqrt(102)*C5/1024-105*sqrt(10)*C7/1024-61*sqrt(114)*C9/1024",
            "sqrt(14586)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)*(224*x**4-160*x**2*y**2-160*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/512",
            "[3*sqrt(1463)/1024,0,61*sqrt(57)/1024,0,105*sqrt(5)/1024,0,-53*sqrt(51)/1024,0,sqrt(1190)/1024,0,15*sqrt(442)/1024,0,-15*sqrt(442)/1024,0,-sqrt(1190)/1024,0,53*sqrt(51)/1024,0,-105*sqrt(5)/1024,0,-61*sqrt(57)/1024,0,-3*sqrt(1463)/1024]",
        ),
        "Qh(11,E,5,1)": (
            "-15*sqrt(221)*S1/512+3*sqrt(2926)*S11/1024+sqrt(595)*S3/512+53*sqrt(102)*S5/1024+105*sqrt(10)*S7/1024-61*sqrt(114)*S9/1024",
            "sqrt(14586)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(15*x**4-160*x**2*y**2+30*x**2*z**2+224*y**4-160*y**2*z**2+15*z**4)/512",
            "[3*sqrt(1463)*I/1024,0,-61*sqrt(57)*I/1024,0,105*sqrt(5)*I/1024,0,53*sqrt(51)*I/1024,0,sqrt(1190)*I/1024,0,-15*sqrt(442)*I/1024,0,-15*sqrt(442)*I/1024,0,sqrt(1190)*I/1024,0,53*sqrt(51)*I/1024,0,105*sqrt(5)*I/1024,0,-61*sqrt(57)*I/1024,0,3*sqrt(1463)*I/1024]",
        ),
        "Qh(11,E,6,0)": (
            "-21*sqrt(130)*C1/512-sqrt(124355)*C11/512+57*sqrt(14)*C3/512-41*sqrt(15)*C5/512+17*sqrt(17)*C7/512+sqrt(4845)*C9/512",
            "sqrt(2145)*x*(y-z)*(y+z)*(128*x**8-768*x**6*y**2-768*x**6*z**2+1008*x**4*y**4+2016*x**4*y**2*z**2+1008*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+21*y**8+84*y**6*z**2+126*y**4*z**4+84*y**2*z**6+21*z**8)/256",
            "[sqrt(248710)/1024,0,-sqrt(9690)/1024,0,-17*sqrt(34)/1024,0,41*sqrt(30)/1024,0,-57*sqrt(7)/512,0,21*sqrt(65)/512,0,-21*sqrt(65)/512,0,57*sqrt(7)/512,0,-41*sqrt(30)/1024,0,17*sqrt(34)/1024,0,sqrt(9690)/1024,0,-sqrt(248710)/1024]",
        ),
        "Qh(11,E,6,1)": (
            "-21*sqrt(130)*S1/512+sqrt(124355)*S11/512-57*sqrt(14)*S3/512-41*sqrt(15)*S5/512-17*sqrt(17)*S7/512+sqrt(4845)*S9/512",
            "sqrt(2145)*y*(x-z)*(x+z)*(21*x**8-336*x**6*y**2+84*x**6*z**2+1008*x**4*y**4-1008*x**4*y**2*z**2+126*x**4*z**4-768*x**2*y**6+2016*x**2*y**4*z**2-1008*x**2*y**2*z**4+84*x**2*z**6+128*y**8-768*y**6*z**2+1008*y**4*z**4-336*y**2*z**6+21*z**8)/256",
            "[sqrt(248710)*I/1024,0,sqrt(9690)*I/1024,0,-17*sqrt(34)*I/1024,0,-41*sqrt(30)*I/1024,0,-57*sqrt(7)*I/512,0,-21*sqrt(65)*I/512,0,-21*sqrt(65)*I/512,0,-57*sqrt(7)*I/512,0,-41*sqrt(30)*I/1024,0,-17*sqrt(34)*I/1024,0,sqrt(9690)*I/1024,0,sqrt(248710)*I/1024]",
        ),
    },
    "D4h": {
        "Qh(0,A1g,,)": ("C0", "1", "[1]"),
        "Qh(2,A1g,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(4,A1g,1,)": (
            "sqrt(21)*C0/6+sqrt(15)*C4/6",
            "sqrt(21)*(x**4-3*x**2*y**2-3*x**2*z**2+y**4-3*y**2*z**2+z**4)/6",
            "[sqrt(30)/12,0,0,0,sqrt(21)/6,0,0,0,sqrt(30)/12]",
        ),
        "Qh(6,A1g,1,)": (
            "sqrt(2)*C0/4-sqrt(14)*C4/4",
            "sqrt(2)*(2*x**6-15*x**4*y**2-15*x**4*z**2-15*x**2*y**4+180*x**2*y**2*z**2-15*x**2*z**4+2*y**6-15*y**4*z**2-15*y**2*z**4+2*z**6)/8",
            "[0,0,-sqrt(7)/4,0,0,0,sqrt(2)/4,0,0,0,-sqrt(7)/4,0,0]",
        ),
        "Qh(8,A1g,1,)": (
            "sqrt(33)*C0/8+sqrt(21)*C4/12+sqrt(195)*C8/24",
            "sqrt(33)*(x**8-14*x**6*y**2-14*x**6*z**2+35*x**4*y**4+35*x**4*z**4-14*x**2*y**6-14*x**2*z**6+y**8-14*y**6*z**2+35*y**4*z**4-14*y**2*z**6+z**8)/8",
            "[sqrt(390)/48,0,0,0,sqrt(42)/24,0,0,0,sqrt(33)/8,0,0,0,sqrt(42)/24,0,0,0,sqrt(390)/48]",
        ),
        "Qh(10,A1g,1,)": (
            "sqrt(390)*C0/48-sqrt(22)*C4/8-sqrt(1122)*C8/48",
            "sqrt(390)*(2*x**10-45*x**8*y**2-45*x**8*z**2+42*x**6*y**4+1008*x**6*y**2*z**2+42*x**6*z**4+42*x**4*y**6-1260*x**4*y**4*z**2-1260*x**4*y**2*z**4+42*x**4*z**6-45*x**2*y**8+1008*x**2*y**6*z**2-1260*x**2*y**4*z**4+1008*x**2*y**2*z**6-45*x**2*z**8+2*y**10-45*y**8*z**2+42*y**6*z**4+42*y**4*z**6-45*y**2*z**8+2*z**10)/96",
            "[0,0,-sqrt(561)/48,0,0,0,-sqrt(11)/8,0,0,0,sqrt(390)/48,0,0,0,-sqrt(11)/8,0,0,0,-sqrt(561)/48,0,0]",
        ),
        "Qh(4,A1g,2,)": (
            "sqrt(15)*C0/6-sqrt(21)*C4/6",
            "-sqrt(15)*(x**4-12*x**2*y**2+6*x**2*z**2+y**4+6*y**2*z**2-2*z**4)/12",
            "[-sqrt(42)/12,0,0,0,sqrt(15)/6,0,0,0,-sqrt(42)/12]",
        ),
        "Qh(6,A1g,2,)": (
            "sqrt(14)*C0/4+sqrt(2)*C4/4",
            "-sqrt(14)*(x**6-15*x**4*z**2+15*x**2*z**4+y**6-15*y**4*z**2+15*y**2*z**4-2*z**6)/8",
            "[0,0,1/4,0,0,0,sqrt(14)/4,0,0,0,1/4,0,0]",
        ),
        "Qh(8,A1g,2,)": (
            "-sqrt(286)*C0/32+sqrt(182)*C4/16+sqrt(10)*C8/32",
            "sqrt(286)*(x**8-14*x**6*y**2-14*x**6*z**2+210*x**4*y**2*z**2-14*x**2*y**6+210*x**2*y**4*z**2-420*x**2*y**2*z**4+28*x**2*z**6+y**8-14*y**6*z**2+28*y**2*z**6-2*z**8)/64",
            "[sqrt(5)/32,0,0,0,sqrt(91)/16,0,0,0,-sqrt(286)/32,0,0,0,sqrt(91)/16,0,0,0,sqrt(5)/32]",
        ),
        "Qh(10,A1g,2,)": (
            "11*sqrt(420189)*C0/8988+sqrt(827645)*C4/1498-sqrt(146055)*C8/8988",
            "-sqrt(420189)*(22*x**10+45*x**8*y**2-1035*x**8*z**2-105*x**6*y**4-630*x**6*y**2*z**2+4935*x**6*z**4-105*x**4*y**6+3150*x**4*y**4*z**2-1575*x**4*y**2*z**4-4830*x**4*z**6+45*x**2*y**8-630*x**2*y**6*z**2-1575*x**2*y**4*z**4+1260*x**2*y**2*z**6+990*x**2*z**8+22*y**10-1035*y**8*z**2+4935*y**6*z**4-4830*y**4*z**6+990*y**2*z**8-44*z**10)/35952",
            "[0,0,-sqrt(292110)/17976,0,0,0,sqrt(1655290)/2996,0,0,0,11*sqrt(420189)/8988,0,0,0,sqrt(1655290)/2996,0,0,0,-sqrt(292110)/17976,0,0]",
        ),
        "Qh(8,A1g,3,)": (
            "-sqrt(210)*C0/32-sqrt(330)*C4/48+sqrt(6006)*C8/96",
            "sqrt(210)*(x**8-62*x**6*y**2+34*x**6*z**2+160*x**4*y**4-30*x**4*y**2*z**2-80*x**4*z**4-62*x**2*y**6-30*x**2*y**4*z**2+60*x**2*y**2*z**4+28*x**2*z**6+y**8+34*y**6*z**2-80*y**4*z**4+28*y**2*z**6-2*z**8)/64",
            "[sqrt(3003)/96,0,0,0,-sqrt(165)/48,0,0,0,-sqrt(210)/32,0,0,0,-sqrt(165)/48,0,0,0,sqrt(3003)/96]",
        ),
        "Qh(10,A1g,3,)": (
            "3*sqrt(3213210)*C0/11984-83*sqrt(1498)*C4/5992+31*sqrt(76398)*C8/11984",
            "-sqrt(3213210)*(3*x**10-96*x**8*y**2-39*x**8*z**2+224*x**6*y**4+1344*x**6*y**2*z**2-42*x**6*z**4+224*x**4*y**6-6720*x**4*y**4*z**2+3360*x**4*y**2*z**4-182*x**4*z**6-96*x**2*y**8+1344*x**2*y**6*z**2+3360*x**2*y**4*z**4-2688*x**2*y**2*z**6+135*x**2*z**8+3*y**10-39*y**8*z**2-42*y**6*z**4-182*y**4*z**6+135*y**2*z**8-6*z**10)/23968",
            "[0,0,31*sqrt(38199)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,3*sqrt(3213210)/11984,0,0,0,-83*sqrt(749)/5992,0,0,0,31*sqrt(38199)/11984,0,0]",
        ),
        "Qh(5,A1u,,)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(7,A1u,,)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(9,A1u,1,)": (
            "sqrt(102)*S4/12-sqrt(42)*S8/12",
            "sqrt(510510)*x*y*z*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[0,sqrt(21)*I/12,0,0,0,-sqrt(51)*I/12,0,0,0,0,0,0,0,sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0]",
        ),
        "Qh(11,A1u,1,)": (
            "S8",
            "-sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(9,A1u,2,)": (
            "sqrt(42)*S4/12+sqrt(102)*S8/12",
            "sqrt(4290)*x*y*z*(x-y)*(x+y)*(3*x**4-11*x**2*y**2-7*x**2*z**2+3*y**4-7*y**2*z**2+7*z**4)/8",
            "[0,-sqrt(51)*I/12,0,0,0,-sqrt(21)*I/12,0,0,0,0,0,0,0,sqrt(21)*I/12,0,0,0,sqrt(51)*I/12,0]",
        ),
        "Qh(11,A1u,2,)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(4,A2g,,)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(6,A2g,,)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(8,A2g,1,)": (
            "S8",
            "3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(10,A2g,1,)": (
            "S8",
            "-sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(8,A2g,2,)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,A2g,2,)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(1,A2u,,)": ("C0", "z", "[0,1,0]"),
        "Qh(3,A2u,,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(5,A2u,1,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(7,A2u,1,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(9,A2u,1,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A2u,1,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(5,A2u,2,)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(7,A2u,2,)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,A2u,2,)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(11,A2u,2,)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,A2u,3,)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,A2u,3,)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(2,B1g,,)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(4,B1g,,)": ("-C2", "sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Qh(6,B1g,1,)": (
            "sqrt(11)*C2/4-sqrt(5)*C6/4",
            "sqrt(2310)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)/8",
            "[-sqrt(10)/8,0,0,0,sqrt(22)/8,0,0,0,sqrt(22)/8,0,0,0,-sqrt(10)/8]",
        ),
        "Qh(8,B1g,1,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(10,B1g,1,)": (
            "-sqrt(85)*C10/16+sqrt(1482)*C2/48+sqrt(57)*C6/48",
            "sqrt(27170)*(x-y)*(x+y)*(x-z)*(x+z)*(y-z)*(y+z)*(3*x**4-11*x**2*y**2-11*x**2*z**2+3*y**4-11*y**2*z**2+3*z**4)/32",
            "[-sqrt(170)/32,0,0,0,sqrt(114)/96,0,0,0,sqrt(741)/48,0,0,0,sqrt(741)/48,0,0,0,sqrt(114)/96,0,0,0,-sqrt(170)/32]",
        ),
        "Qh(6,B1g,2,)": (
            "sqrt(5)*C2/4+sqrt(11)*C6/4",
            "sqrt(42)*(x-y)*(x+y)*(x**4-9*x**2*y**2-5*x**2*z**2+y**4-5*y**2*z**2+5*z**4)/8",
            "[sqrt(22)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(10)/8,0,0,0,sqrt(22)/8]",
        ),
        "Qh(8,B1g,2,)": (
            "C2",
            "-3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(10,B1g,2,)": (
            "sqrt(370006)*C10/749+sqrt(190995)*C2/749",
            "sqrt(140063)*(x-y)*(x+y)*(22*x**8-653*x**6*y**2-315*x**6*z**2+2602*x**4*y**4-945*x**4*y**2*z**2+1575*x**4*z**4-653*x**2*y**6-945*x**2*y**4*z**2+3150*x**2*y**2*z**4-1680*x**2*z**6+22*y**8-315*y**6*z**2+1575*y**4*z**4-1680*y**2*z**6+360*z**8)/11984",
            "[sqrt(185003)/749,0,0,0,0,0,0,0,sqrt(381990)/1498,0,0,0,sqrt(381990)/1498,0,0,0,0,0,0,0,sqrt(185003)/749]",
        ),
        "Qh(10,B1g,3,)": (
            "sqrt(1209635)*C10/11984-19*sqrt(58422)*C2/35952+sqrt(2247)*C6/48",
            "sqrt(1071070)*(x-y)*(x+y)*(9*x**8-165*x**6*y**2-231*x**6*z**2-25*x**4*y**4+3801*x**4*y**2*z**2+406*x**4*z**4-165*x**2*y**6+3801*x**2*y**4*z**2-9674*x**2*y**2*z**4+266*x**2*z**6+9*y**8-231*y**6*z**2+406*y**4*z**4+266*y**2*z**6-57*z**8)/23968",
            "[sqrt(2419270)/23968,0,0,0,sqrt(4494)/96,0,0,0,-19*sqrt(29211)/35952,0,0,0,-19*sqrt(29211)/35952,0,0,0,sqrt(4494)/96,0,0,0,sqrt(2419270)/23968]",
        ),
        "Qh(3,B1u,,)": ("S2", "sqrt(15)*x*y*z", "[0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(5,B1u,,)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(7,B1u,1,)": (
            "sqrt(78)*S2/12+sqrt(66)*S6/12",
            "sqrt(91)*x*y*z*(3*x**4-5*x**2*y**2-5*x**2*z**2+3*y**4-5*y**2*z**2+3*z**4)/2",
            "[0,-sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0,0,0,sqrt(39)*I/12,0,0,0,sqrt(33)*I/12,0]",
        ),
        "Qh(9,B1u,1,)": (
            "sqrt(3)*S2/4-sqrt(13)*S6/4",
            "sqrt(330)*x*y*z*(6*x**6-21*x**4*y**2-21*x**4*z**2-21*x**2*y**4+140*x**2*y**2*z**2-21*x**2*z**4+6*y**6-21*y**4*z**2-21*y**2*z**4+6*z**6)/8",
            "[0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0,sqrt(6)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0]",
        ),
        "Qh(11,B1u,1,)": (
            "sqrt(798)*S10/48+sqrt(255)*S2/24+3*sqrt(6)*S6/16",
            "sqrt(2431)*x*y*z*(5*x**8-30*x**6*y**2-30*x**6*z**2+63*x**4*y**4+63*x**4*z**4-30*x**2*y**6-30*x**2*z**6+5*y**8-30*y**6*z**2+63*y**4*z**4-30*y**2*z**6+5*z**8)/8",
            "[0,-sqrt(399)*I/48,0,0,0,-3*sqrt(3)*I/16,0,0,0,-sqrt(510)*I/48,0,0,0,sqrt(510)*I/48,0,0,0,3*sqrt(3)*I/16,0,0,0,sqrt(399)*I/48,0]",
        ),
        "Qh(7,B1u,2,)": (
            "sqrt(66)*S2/12-sqrt(78)*S6/12",
            "-sqrt(77)*x*y*z*(3*x**4-20*x**2*y**2+10*x**2*z**2+3*y**4+10*y**2*z**2-6*z**4)/4",
            "[0,sqrt(39)*I/12,0,0,0,-sqrt(33)*I/12,0,0,0,sqrt(33)*I/12,0,0,0,-sqrt(39)*I/12,0]",
        ),
        "Qh(9,B1u,2,)": (
            "-sqrt(13)*S2/4-sqrt(3)*S6/4",
            "3*sqrt(1430)*x*y*z*(x**6-7*x**4*z**2+7*x**2*z**4+y**6-7*y**4*z**2+7*y**2*z**4-2*z**6)/8",
            "[0,0,0,sqrt(6)*I/8,0,0,0,sqrt(26)*I/8,0,0,0,-sqrt(26)*I/8,0,0,0,-sqrt(6)*I/8,0,0,0]",
        ),
        "Qh(11,B1u,2,)": (
            "-sqrt(210)*S10/96+sqrt(969)*S2/48-sqrt(570)*S6/32",
            "-sqrt(230945)*x*y*z*(x**8-6*x**6*y**2-6*x**6*z**2+42*x**4*y**2*z**2-6*x**2*y**6+42*x**2*y**4*z**2-84*x**2*y**2*z**4+12*x**2*z**6+y**8-6*y**6*z**2+12*y**2*z**6-2*z**8)/32",
            "[0,sqrt(105)*I/96,0,0,0,sqrt(285)*I/32,0,0,0,-sqrt(1938)*I/96,0,0,0,sqrt(1938)*I/96,0,0,0,-sqrt(285)*I/32,0,0,0,-sqrt(105)*I/96,0]",
        ),
        "Qh(11,B1u,3,)": (
            "-sqrt(646)*S10/32+sqrt(35)*S2/16+sqrt(238)*S6/32",
            "-sqrt(3003)*x*y*z*(5*x**8-150*x**6*y**2+90*x**6*z**2+336*x**4*y**4-70*x**4*y**2*z**2-168*x**4*z**4-150*x**2*y**6-70*x**2*y**4*z**2+140*x**2*y**2*z**4+60*x**2*z**6+5*y**8+90*y**6*z**2-168*y**4*z**4+60*y**2*z**6-10*z**8)/32",
            "[0,sqrt(323)*I/32,0,0,0,-sqrt(119)*I/32,0,0,0,-sqrt(70)*I/32,0,0,0,sqrt(70)*I/32,0,0,0,sqrt(119)*I/32,0,0,0,-sqrt(323)*I/32,0]",
        ),
        "Qh(2,B2g,,)": ("S2", "sqrt(3)*x*y", "[-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2]"),
        "Qh(4,B2g,,)": ("S2", "-sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(6,B2g,1,)": (
            "S6",
            "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(8,B2g,1,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(10,B2g,1,)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(6,B2g,2,)": (
            "S2",
            "sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(8,B2g,2,)": (
            "S2",
            "-3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(10,B2g,2,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,B2g,3,)": (
            "S2",
            "sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(3,B2u,,)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(5,B2u,,)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(7,B2u,1,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,B2u,1,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(11,B2u,1,)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(7,B2u,2,)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(9,B2u,2,)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,B2u,2,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,B2u,3,)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(2,Eg,,0)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(2,Eg,,1)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Qh(4,Eg,1,0)": (
            "-sqrt(14)*S1/4-sqrt(2)*S3/4",
            "sqrt(35)*y*z*(y-z)*(y+z)/2",
            "[0,-I/4,0,-sqrt(7)*I/4,0,-sqrt(7)*I/4,0,-I/4,0]",
        ),
        "Qh(4,Eg,1,1)": (
            "-sqrt(14)*C1/4+sqrt(2)*C3/4",
            "sqrt(35)*x*z*(x-z)*(x+z)/2",
            "[0,-1/4,0,sqrt(7)/4,0,-sqrt(7)/4,0,1/4,0]",
        ),
        "Qh(6,Eg,1,0)": (
            "sqrt(3)*S1/4-sqrt(30)*S3/8-sqrt(22)*S5/8",
            "3*sqrt(7)*y*z*(y-z)*(y+z)*(10*x**2-y**2-z**2)/4",
            "[0,-sqrt(11)*I/8,0,-sqrt(15)*I/8,0,sqrt(6)*I/8,0,sqrt(6)*I/8,0,-sqrt(15)*I/8,0,-sqrt(11)*I/8,0]",
        ),
        "Qh(6,Eg,1,1)": (
            "sqrt(3)*C1/4+sqrt(30)*C3/8-sqrt(22)*C5/8",
            "-3*sqrt(7)*x*z*(x-z)*(x+z)*(x**2-10*y**2+z**2)/4",
            "[0,sqrt(11)/8,0,-sqrt(15)/8,0,-sqrt(6)/8,0,sqrt(6)/8,0,sqrt(15)/8,0,-sqrt(11)/8,0]",
        ),
        "Qh(8,Eg,1,0)": (
            "-sqrt(715)*S1/32-sqrt(273)*S3/32-sqrt(35)*S5/32-S7/32",
            "3*sqrt(715)*y*z*(y-z)*(y+z)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[0,-sqrt(2)*I/64,0,-sqrt(70)*I/64,0,-sqrt(546)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(1430)*I/64,0,-sqrt(546)*I/64,0,-sqrt(70)*I/64,0,-sqrt(2)*I/64,0]",
        ),
        "Qh(8,Eg,1,1)": (
            "-sqrt(715)*C1/32+sqrt(273)*C3/32-sqrt(35)*C5/32+C7/32",
            "3*sqrt(715)*x*z*(x-z)*(x+z)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/16",
            "[0,-sqrt(2)/64,0,sqrt(70)/64,0,-sqrt(546)/64,0,sqrt(1430)/64,0,-sqrt(1430)/64,0,sqrt(546)/64,0,-sqrt(70)/64,0,sqrt(2)/64,0]",
        ),
        "Qh(10,Eg,1,0)": (
            "sqrt(221)*S1/32-sqrt(102)*S3/32-sqrt(510)*S5/32-11*sqrt(6)*S7/64-sqrt(38)*S9/64",
            "sqrt(12155)*y*z*(y-z)*(y+z)*(18*x**2-y**2-z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/32",
            "[0,-sqrt(19)*I/64,0,-11*sqrt(3)*I/64,0,-sqrt(255)*I/32,0,-sqrt(51)*I/32,0,sqrt(442)*I/64,0,sqrt(442)*I/64,0,-sqrt(51)*I/32,0,-sqrt(255)*I/32,0,-11*sqrt(3)*I/64,0,-sqrt(19)*I/64,0]",
        ),
        "Qh(10,Eg,1,1)": (
            "sqrt(221)*C1/32+sqrt(102)*C3/32-sqrt(510)*C5/32+11*sqrt(6)*C7/64-sqrt(38)*C9/64",
            "-sqrt(12155)*x*z*(x-z)*(x+z)*(x**2-18*y**2+z**2)*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/32",
            "[0,sqrt(19)/64,0,-11*sqrt(3)/64,0,sqrt(255)/32,0,-sqrt(51)/32,0,-sqrt(442)/64,0,sqrt(442)/64,0,sqrt(51)/32,0,-sqrt(255)/32,0,11*sqrt(3)/64,0,-sqrt(19)/64,0]",
        ),
        "Qh(4,Eg,2,0)": (
            "-sqrt(2)*S1/4+sqrt(14)*S3/4",
            "sqrt(5)*y*z*(6*x**2-y**2-z**2)/2",
            "[0,sqrt(7)*I/4,0,-I/4,0,-I/4,0,sqrt(7)*I/4,0]",
        ),
        "Qh(4,Eg,2,1)": (
            "-sqrt(2)*C1/4-sqrt(14)*C3/4",
            "-sqrt(5)*x*z*(x**2-6*y**2+z**2)/2",
            "[0,sqrt(7)/4,0,1/4,0,-1/4,0,-sqrt(7)/4,0]",
        ),
        "Qh(6,Eg,2,0)": (
            "3*sqrt(22)*S1/16+sqrt(55)*S3/16+sqrt(3)*S5/16",
            "sqrt(462)*y*z*(y**2-3*z**2)*(3*y**2-z**2)/16",
            "[0,sqrt(6)*I/32,0,sqrt(110)*I/32,0,3*sqrt(11)*I/16,0,3*sqrt(11)*I/16,0,sqrt(110)*I/32,0,sqrt(6)*I/32,0]",
        ),
        "Qh(6,Eg,2,1)": (
            "3*sqrt(22)*C1/16-sqrt(55)*C3/16+sqrt(3)*C5/16",
            "sqrt(462)*x*z*(x**2-3*z**2)*(3*x**2-z**2)/16",
            "[0,-sqrt(6)/32,0,sqrt(110)/32,0,-3*sqrt(11)/16,0,3*sqrt(11)/16,0,-sqrt(110)/32,0,sqrt(6)/32,0]",
        ),
        "Qh(8,Eg,2,0)": (
            "-sqrt(77)*S1/32+5*sqrt(15)*S3/32-3*sqrt(13)*S5/32-sqrt(455)*S7/32",
            "3*sqrt(77)*y*z*(y-z)*(y+z)*(40*x**4-24*x**2*y**2-24*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,-sqrt(910)*I/64,0,-3*sqrt(26)*I/64,0,5*sqrt(30)*I/64,0,-sqrt(154)*I/64,0,-sqrt(154)*I/64,0,5*sqrt(30)*I/64,0,-3*sqrt(26)*I/64,0,-sqrt(910)*I/64,0]",
        ),
        "Qh(8,Eg,2,1)": (
            "-sqrt(77)*C1/32-5*sqrt(15)*C3/32-3*sqrt(13)*C5/32+sqrt(455)*C7/32",
            "3*sqrt(77)*x*z*(x-z)*(x+z)*(x**4-24*x**2*y**2+2*x**2*z**2+40*y**4-24*y**2*z**2+z**4)/16",
            "[0,-sqrt(910)/64,0,3*sqrt(26)/64,0,5*sqrt(30)/64,0,sqrt(154)/64,0,-sqrt(154)/64,0,-5*sqrt(30)/64,0,-3*sqrt(26)/64,0,sqrt(910)/64,0]",
        ),
        "Qh(10,Eg,2,0)": (
            "sqrt(39)*S1/32-11*sqrt(2)*S3/32+5*sqrt(10)*S5/32-sqrt(34)*S7/64-sqrt(1938)*S9/64",
            "sqrt(2145)*y*z*(y-z)*(y+z)*(112*x**6-168*x**4*y**2-168*x**4*z**2+42*x**2*y**4+84*x**2*y**2*z**2+42*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,-sqrt(969)*I/64,0,-sqrt(17)*I/64,0,5*sqrt(5)*I/32,0,-11*I/32,0,sqrt(78)*I/64,0,sqrt(78)*I/64,0,-11*I/32,0,5*sqrt(5)*I/32,0,-sqrt(17)*I/64,0,-sqrt(969)*I/64,0]",
        ),
        "Qh(10,Eg,2,1)": (
            "sqrt(39)*C1/32+11*sqrt(2)*C3/32+5*sqrt(10)*C5/32+sqrt(34)*C7/64-sqrt(1938)*C9/64",
            "-sqrt(2145)*x*z*(x-z)*(x+z)*(x**6-42*x**4*y**2+3*x**4*z**2+168*x**2*y**4-84*x**2*y**2*z**2+3*x**2*z**4-112*y**6+168*y**4*z**2-42*y**2*z**4+z**6)/32",
            "[0,sqrt(969)/64,0,-sqrt(17)/64,0,-5*sqrt(5)/32,0,-11/32,0,-sqrt(78)/64,0,sqrt(78)/64,0,11/32,0,5*sqrt(5)/32,0,sqrt(17)/64,0,-sqrt(969)/64,0]",
        ),
        "Qh(6,Eg,3,0)": (
            "sqrt(10)*S1/16-9*S3/16+sqrt(165)*S5/16",
            "sqrt(210)*y*z*(16*x**4-16*x**2*y**2-16*x**2*z**2+y**4+2*y**2*z**2+z**4)/16",
            "[0,sqrt(330)*I/32,0,-9*sqrt(2)*I/32,0,sqrt(5)*I/16,0,sqrt(5)*I/16,0,-9*sqrt(2)*I/32,0,sqrt(330)*I/32,0]",
        ),
        "Qh(6,Eg,3,1)": (
            "sqrt(10)*C1/16+9*C3/16+sqrt(165)*C5/16",
            "sqrt(210)*x*z*(x**4-16*x**2*y**2+2*x**2*z**2+16*y**4-16*y**2*z**2+z**4)/16",
            "[0,-sqrt(330)/32,0,-9*sqrt(2)/32,0,-sqrt(5)/16,0,sqrt(5)/16,0,9*sqrt(2)/32,0,sqrt(330)/32,0]",
        ),
        "Qh(8,Eg,3,0)": (
            "-sqrt(858)*S1/64+sqrt(910)*S3/64+7*sqrt(42)*S5/64+3*sqrt(30)*S7/64",
            "sqrt(858)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(14*x**2-y**2-z**2)/32",
            "[0,3*sqrt(15)*I/64,0,7*sqrt(21)*I/64,0,sqrt(455)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,sqrt(455)*I/64,0,7*sqrt(21)*I/64,0,3*sqrt(15)*I/64,0]",
        ),
        "Qh(8,Eg,3,1)": (
            "-sqrt(858)*C1/64-sqrt(910)*C3/64+7*sqrt(42)*C5/64-3*sqrt(30)*C7/64",
            "-sqrt(858)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(x**2-14*y**2+z**2)/32",
            "[0,3*sqrt(15)/64,0,-7*sqrt(21)/64,0,sqrt(455)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-sqrt(455)/64,0,7*sqrt(21)/64,0,-3*sqrt(15)/64,0]",
        ),
        "Qh(10,Eg,3,0)": (
            "sqrt(41990)*S1/256+sqrt(4845)*S3/128+sqrt(969)*S5/128+sqrt(285)*S7/256+sqrt(5)*S9/256",
            "sqrt(92378)*y*z*(y**4-10*y**2*z**2+5*z**4)*(5*y**4-10*y**2*z**2+z**4)/256",
            "[0,sqrt(10)*I/512,0,sqrt(570)*I/512,0,sqrt(1938)*I/256,0,sqrt(9690)*I/256,0,sqrt(20995)*I/256,0,sqrt(20995)*I/256,0,sqrt(9690)*I/256,0,sqrt(1938)*I/256,0,sqrt(570)*I/512,0,sqrt(10)*I/512,0]",
        ),
        "Qh(10,Eg,3,1)": (
            "sqrt(41990)*C1/256-sqrt(4845)*C3/128+sqrt(969)*C5/128-sqrt(285)*C7/256+sqrt(5)*C9/256",
            "sqrt(92378)*x*z*(x**4-10*x**2*z**2+5*z**4)*(5*x**4-10*x**2*z**2+z**4)/256",
            "[0,-sqrt(10)/512,0,sqrt(570)/512,0,-sqrt(1938)/256,0,sqrt(9690)/256,0,-sqrt(20995)/256,0,sqrt(20995)/256,0,-sqrt(9690)/256,0,sqrt(1938)/256,0,-sqrt(570)/512,0,sqrt(10)/512,0]",
        ),
        "Qh(8,Eg,4,0)": (
            "-sqrt(70)*S1/64+3*sqrt(66)*S3/64-sqrt(1430)*S5/64+sqrt(2002)*S7/64",
            "3*sqrt(70)*y*z*(32*x**6-80*x**4*y**2-80*x**4*z**2+30*x**2*y**4+60*x**2*y**2*z**2+30*x**2*z**4-y**6-3*y**4*z**2-3*y**2*z**4-z**6)/32",
            "[0,sqrt(1001)*I/64,0,-sqrt(715)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(35)*I/64,0,-sqrt(35)*I/64,0,3*sqrt(33)*I/64,0,-sqrt(715)*I/64,0,sqrt(1001)*I/64,0]",
        ),
        "Qh(8,Eg,4,1)": (
            "-sqrt(70)*C1/64-3*sqrt(66)*C3/64-sqrt(1430)*C5/64-sqrt(2002)*C7/64",
            "-3*sqrt(70)*x*z*(x**6-30*x**4*y**2+3*x**4*z**2+80*x**2*y**4-60*x**2*y**2*z**2+3*x**2*z**4-32*y**6+80*y**4*z**2-30*y**2*z**4+z**6)/32",
            "[0,sqrt(1001)/64,0,sqrt(715)/64,0,3*sqrt(33)/64,0,sqrt(35)/64,0,-sqrt(35)/64,0,-3*sqrt(33)/64,0,-sqrt(715)/64,0,-sqrt(1001)/64,0]",
        ),
        "Qh(10,Eg,4,0)": (
            "9*sqrt(78)*S1/256-69*S3/128-sqrt(5)*S5/128+43*sqrt(17)*S7/256+3*sqrt(969)*S9/256",
            "sqrt(4290)*y*z*(y**2-3*z**2)*(3*y**2-z**2)*(224*x**4-96*x**2*y**2-96*x**2*z**2+3*y**4+6*y**2*z**2+3*z**4)/256",
            "[0,3*sqrt(1938)*I/512,0,43*sqrt(34)*I/512,0,-sqrt(10)*I/256,0,-69*sqrt(2)*I/256,0,9*sqrt(39)*I/256,0,9*sqrt(39)*I/256,0,-69*sqrt(2)*I/256,0,-sqrt(10)*I/256,0,43*sqrt(34)*I/512,0,3*sqrt(1938)*I/512,0]",
        ),
        "Qh(10,Eg,4,1)": (
            "9*sqrt(78)*C1/256+69*C3/128-sqrt(5)*C5/128-43*sqrt(17)*C7/256+3*sqrt(969)*C9/256",
            "sqrt(4290)*x*z*(x**2-3*z**2)*(3*x**2-z**2)*(3*x**4-96*x**2*y**2+6*x**2*z**2+224*y**4-96*y**2*z**2+3*z**4)/256",
            "[0,-3*sqrt(1938)/512,0,43*sqrt(34)/512,0,sqrt(10)/256,0,-69*sqrt(2)/256,0,-9*sqrt(39)/256,0,9*sqrt(39)/256,0,69*sqrt(2)/256,0,-sqrt(10)/256,0,-43*sqrt(34)/512,0,3*sqrt(1938)/512,0]",
        ),
        "Qh(10,Eg,5,0)": (
            "7*sqrt(3)*S1/128-7*sqrt(26)*S3/128+5*sqrt(130)*S5/128-7*sqrt(442)*S7/256+sqrt(25194)*S9/256",
            "sqrt(165)*y*z*(384*x**8-1792*x**6*y**2-1792*x**6*z**2+1680*x**4*y**4+3360*x**4*y**2*z**2+1680*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+7*y**8+28*y**6*z**2+42*y**4*z**4+28*y**2*z**6+7*z**8)/128",
            "[0,sqrt(12597)*I/256,0,-7*sqrt(221)*I/256,0,5*sqrt(65)*I/128,0,-7*sqrt(13)*I/128,0,7*sqrt(6)*I/256,0,7*sqrt(6)*I/256,0,-7*sqrt(13)*I/128,0,5*sqrt(65)*I/128,0,-7*sqrt(221)*I/256,0,sqrt(12597)*I/256,0]",
        ),
        "Qh(10,Eg,5,1)": (
            "7*sqrt(3)*C1/128+7*sqrt(26)*C3/128+5*sqrt(130)*C5/128+7*sqrt(442)*C7/256+sqrt(25194)*C9/256",
            "sqrt(165)*x*z*(7*x**8-336*x**6*y**2+28*x**6*z**2+1680*x**4*y**4-1008*x**4*y**2*z**2+42*x**4*z**4-1792*x**2*y**6+3360*x**2*y**4*z**2-1008*x**2*y**2*z**4+28*x**2*z**6+384*y**8-1792*y**6*z**2+1680*y**4*z**4-336*y**2*z**6+7*z**8)/128",
            "[0,-sqrt(12597)/256,0,-7*sqrt(221)/256,0,-5*sqrt(65)/128,0,-7*sqrt(13)/128,0,-7*sqrt(6)/256,0,7*sqrt(6)/256,0,7*sqrt(13)/128,0,5*sqrt(65)/128,0,7*sqrt(221)/256,0,sqrt(12597)/256,0]",
        ),
        "Qh(1,Eu,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(1,Eu,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(3,Eu,1,0)": (
            "-sqrt(6)*C1/4+sqrt(10)*C3/4",
            "x*(2*x**2-3*y**2-3*z**2)/2",
            "[-sqrt(5)/4,0,sqrt(3)/4,0,-sqrt(3)/4,0,sqrt(5)/4]",
        ),
        "Qh(3,Eu,1,1)": (
            "-sqrt(6)*S1/4-sqrt(10)*S3/4",
            "-y*(3*x**2-2*y**2+3*z**2)/2",
            "[-sqrt(5)*I/4,0,-sqrt(3)*I/4,0,-sqrt(3)*I/4,0,-sqrt(5)*I/4]",
        ),
        "Qh(5,Eu,1,0)": (
            "sqrt(15)*C1/8-sqrt(70)*C3/16+3*sqrt(14)*C5/16",
            "x*(8*x**4-40*x**2*y**2-40*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/8",
            "[-3*sqrt(7)/16,0,sqrt(35)/16,0,-sqrt(30)/16,0,sqrt(30)/16,0,-sqrt(35)/16,0,3*sqrt(7)/16]",
        ),
        "Qh(5,Eu,1,1)": (
            "sqrt(15)*S1/8+sqrt(70)*S3/16+3*sqrt(14)*S5/16",
            "y*(15*x**4-40*x**2*y**2+30*x**2*z**2+8*y**4-40*y**2*z**2+15*z**4)/8",
            "[3*sqrt(7)*I/16,0,sqrt(35)*I/16,0,sqrt(30)*I/16,0,sqrt(30)*I/16,0,sqrt(35)*I/16,0,3*sqrt(7)*I/16]",
        ),
        "Qh(7,Eu,1,0)": (
            "-5*sqrt(7)*C1/32+3*sqrt(21)*C3/32-sqrt(231)*C5/32+sqrt(429)*C7/32",
            "x*(16*x**6-168*x**4*y**2-168*x**4*z**2+210*x**2*y**4+420*x**2*y**2*z**2+210*x**2*z**4-35*y**6-105*y**4*z**2-105*y**2*z**4-35*z**6)/16",
            "[-sqrt(858)/64,0,sqrt(462)/64,0,-3*sqrt(42)/64,0,5*sqrt(14)/64,0,-5*sqrt(14)/64,0,3*sqrt(42)/64,0,-sqrt(462)/64,0,sqrt(858)/64]",
        ),
        "Qh(7,Eu,1,1)": (
            "-5*sqrt(7)*S1/32-3*sqrt(21)*S3/32-sqrt(231)*S5/32-sqrt(429)*S7/32",
            "-y*(35*x**6-210*x**4*y**2+105*x**4*z**2+168*x**2*y**4-420*x**2*y**2*z**2+105*x**2*z**4-16*y**6+168*y**4*z**2-210*y**2*z**4+35*z**6)/16",
            "[-sqrt(858)*I/64,0,-sqrt(462)*I/64,0,-3*sqrt(42)*I/64,0,-5*sqrt(14)*I/64,0,-5*sqrt(14)*I/64,0,-3*sqrt(42)*I/64,0,-sqrt(462)*I/64,0,-sqrt(858)*I/64]",
        ),
        "Qh(9,Eu,1,0)": (
            "21*sqrt(5)*C1/128-sqrt(2310)*C3/128+3*sqrt(286)*C5/128-3*sqrt(1430)*C7/256+sqrt(24310)*C9/256",
            "x*(128*x**8-2304*x**6*y**2-2304*x**6*z**2+6048*x**4*y**4+12096*x**4*y**2*z**2+6048*x**4*z**4-3360*x**2*y**6-10080*x**2*y**4*z**2-10080*x**2*y**2*z**4-3360*x**2*z**6+315*y**8+1260*y**6*z**2+1890*y**4*z**4+1260*y**2*z**6+315*z**8)/128",
            "[-sqrt(12155)/256,0,3*sqrt(715)/256,0,-3*sqrt(143)/128,0,sqrt(1155)/128,0,-21*sqrt(10)/256,0,21*sqrt(10)/256,0,-sqrt(1155)/128,0,3*sqrt(143)/128,0,-3*sqrt(715)/256,0,sqrt(12155)/256]",
        ),
        "Qh(9,Eu,1,1)": (
            "21*sqrt(5)*S1/128+sqrt(2310)*S3/128+3*sqrt(286)*S5/128+3*sqrt(1430)*S7/256+sqrt(24310)*S9/256",
            "y*(315*x**8-3360*x**6*y**2+1260*x**6*z**2+6048*x**4*y**4-10080*x**4*y**2*z**2+1890*x**4*z**4-2304*x**2*y**6+12096*x**2*y**4*z**2-10080*x**2*y**2*z**4+1260*x**2*z**6+128*y**8-2304*y**6*z**2+6048*y**4*z**4-3360*y**2*z**6+315*z**8)/128",
            "[sqrt(12155)*I/256,0,3*sqrt(715)*I/256,0,3*sqrt(143)*I/128,0,sqrt(1155)*I/128,0,21*sqrt(10)*I/256,0,21*sqrt(10)*I/256,0,sqrt(1155)*I/128,0,3*sqrt(143)*I/128,0,3*sqrt(715)*I/256,0,sqrt(12155)*I/256]",
        ),
        "Qh(11,Eu,1,0)": (
            "-21*sqrt(66)*C1/512+sqrt(88179)*C11/512+sqrt(30030)*C3/512-15*sqrt(143)*C5/512+sqrt(36465)*C7/512-sqrt(46189)*C9/512",
            "x*(256*x**10-7040*x**8*y**2-7040*x**8*z**2+31680*x**6*y**4+63360*x**6*y**2*z**2+31680*x**6*z**4-36960*x**4*y**6-110880*x**4*y**4*z**2-110880*x**4*y**2*z**4-36960*x**4*z**6+11550*x**2*y**8+46200*x**2*y**6*z**2+69300*x**2*y**4*z**4+46200*x**2*y**2*z**6+11550*x**2*z**8-693*y**10-3465*y**8*z**2-6930*y**6*z**4-6930*y**4*z**6-3465*y**2*z**8-693*z**10)/256",
            "[-sqrt(176358)/1024,0,sqrt(92378)/1024,0,-sqrt(72930)/1024,0,15*sqrt(286)/1024,0,-sqrt(15015)/512,0,21*sqrt(33)/512,0,-21*sqrt(33)/512,0,sqrt(15015)/512,0,-15*sqrt(286)/1024,0,sqrt(72930)/1024,0,-sqrt(92378)/1024,0,sqrt(176358)/1024]",
        ),
        "Qh(11,Eu,1,1)": (
            "-21*sqrt(66)*S1/512-sqrt(88179)*S11/512-sqrt(30030)*S3/512-15*sqrt(143)*S5/512-sqrt(36465)*S7/512-sqrt(46189)*S9/512",
            "-y*(693*x**10-11550*x**8*y**2+3465*x**8*z**2+36960*x**6*y**4-46200*x**6*y**2*z**2+6930*x**6*z**4-31680*x**4*y**6+110880*x**4*y**4*z**2-69300*x**4*y**2*z**4+6930*x**4*z**6+7040*x**2*y**8-63360*x**2*y**6*z**2+110880*x**2*y**4*z**4-46200*x**2*y**2*z**6+3465*x**2*z**8-256*y**10+7040*y**8*z**2-31680*y**6*z**4+36960*y**4*z**6-11550*y**2*z**8+693*z**10)/256",
            "[-sqrt(176358)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(72930)*I/1024,0,-15*sqrt(286)*I/1024,0,-sqrt(15015)*I/512,0,-21*sqrt(33)*I/512,0,-21*sqrt(33)*I/512,0,-sqrt(15015)*I/512,0,-15*sqrt(286)*I/1024,0,-sqrt(72930)*I/1024,0,-sqrt(92378)*I/1024,0,-sqrt(176358)*I/1024]",
        ),
        "Qh(3,Eu,2,0)": (
            "-sqrt(10)*C1/4-sqrt(6)*C3/4",
            "sqrt(15)*x*(y-z)*(y+z)/2",
            "[sqrt(3)/4,0,sqrt(5)/4,0,-sqrt(5)/4,0,-sqrt(3)/4]",
        ),
        "Qh(3,Eu,2,1)": (
            "-sqrt(10)*S1/4+sqrt(6)*S3/4",
            "sqrt(15)*y*(x-z)*(x+z)/2",
            "[sqrt(3)*I/4,0,-sqrt(5)*I/4,0,-sqrt(5)*I/4,0,sqrt(3)*I/4]",
        ),
        "Qh(5,Eu,2,0)": (
            "sqrt(21)*C1/8+9*sqrt(2)*C3/16+sqrt(10)*C5/16",
            "3*sqrt(35)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/8",
            "[-sqrt(5)/16,0,-9/16,0,-sqrt(42)/16,0,sqrt(42)/16,0,9/16,0,sqrt(5)/16]",
        ),
        "Qh(5,Eu,2,1)": (
            "sqrt(21)*S1/8-9*sqrt(2)*S3/16+sqrt(10)*S5/16",
            "3*sqrt(35)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)/8",
            "[sqrt(5)*I/16,0,-9*I/16,0,sqrt(42)*I/16,0,sqrt(42)*I/16,0,-9*I/16,0,sqrt(5)*I/16]",
        ),
        "Qh(7,Eu,2,0)": (
            "-3*sqrt(33)*C1/32-sqrt(11)*C3/32+25*C5/32+sqrt(91)*C7/32",
            "sqrt(231)*x*(10*x**2-3*y**2-3*z**2)*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)/16",
            "[-sqrt(182)/64,0,-25*sqrt(2)/64,0,sqrt(22)/64,0,3*sqrt(66)/64,0,-3*sqrt(66)/64,0,-sqrt(22)/64,0,25*sqrt(2)/64,0,sqrt(182)/64]",
        ),
        "Qh(7,Eu,2,1)": (
            "-3*sqrt(33)*S1/32+sqrt(11)*S3/32+25*S5/32-sqrt(91)*S7/32",
            "-sqrt(231)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(3*x**2-10*y**2+3*z**2)/16",
            "[-sqrt(182)*I/64,0,25*sqrt(2)*I/64,0,sqrt(22)*I/64,0,-3*sqrt(66)*I/64,0,-3*sqrt(66)*I/64,0,sqrt(22)*I/64,0,25*sqrt(2)*I/64,0,-sqrt(182)*I/64]",
        ),
        "Qh(9,Eu,2,0)": (
            "sqrt(2431)*C1/128+sqrt(9282)*C3/128+5*sqrt(170)*C5/128+7*sqrt(34)*C7/256+3*sqrt(2)*C9/256",
            "3*sqrt(12155)*x*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/128",
            "[-3/256,0,-7*sqrt(17)/256,0,-5*sqrt(85)/128,0,-sqrt(4641)/128,0,-sqrt(4862)/256,0,sqrt(4862)/256,0,sqrt(4641)/128,0,5*sqrt(85)/128,0,7*sqrt(17)/256,0,3/256]",
        ),
        "Qh(9,Eu,2,1)": (
            "sqrt(2431)*S1/128-sqrt(9282)*S3/128+5*sqrt(170)*S5/128-7*sqrt(34)*S7/256+3*sqrt(2)*S9/256",
            "3*sqrt(12155)*y*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/128",
            "[3*I/256,0,-7*sqrt(17)*I/256,0,5*sqrt(85)*I/128,0,-sqrt(4641)*I/128,0,sqrt(4862)*I/256,0,sqrt(4862)*I/256,0,-sqrt(4641)*I/128,0,5*sqrt(85)*I/128,0,-7*sqrt(17)*I/256,0,3*I/256]",
        ),
        "Qh(11,Eu,2,0)": (
            "-sqrt(41990)*C1/512+sqrt(385)*C11/512-3*sqrt(4522)*C3/512+3*sqrt(4845)*C5/512+77*sqrt(19)*C7/512+39*sqrt(15)*C9/512",
            "sqrt(692835)*x*(6*x**2-y**2-z**2)*(y**4-4*y**3*z-6*y**2*z**2+4*y*z**3+z**4)*(y**4+4*y**3*z-6*y**2*z**2-4*y*z**3+z**4)/256",
            "[-sqrt(770)/1024,0,-39*sqrt(30)/1024,0,-77*sqrt(38)/1024,0,-3*sqrt(9690)/1024,0,3*sqrt(2261)/512,0,sqrt(20995)/512,0,-sqrt(20995)/512,0,-3*sqrt(2261)/512,0,3*sqrt(9690)/1024,0,77*sqrt(38)/1024,0,39*sqrt(30)/1024,0,sqrt(770)/1024]",
        ),
        "Qh(11,Eu,2,1)": (
            "-sqrt(41990)*S1/512-sqrt(385)*S11/512+3*sqrt(4522)*S3/512+3*sqrt(4845)*S5/512-77*sqrt(19)*S7/512+39*sqrt(15)*S9/512",
            "-sqrt(692835)*y*(x**2-6*y**2+z**2)*(x**4-4*x**3*z-6*x**2*z**2+4*x*z**3+z**4)*(x**4+4*x**3*z-6*x**2*z**2-4*x*z**3+z**4)/256",
            "[-sqrt(770)*I/1024,0,39*sqrt(30)*I/1024,0,-77*sqrt(38)*I/1024,0,3*sqrt(9690)*I/1024,0,3*sqrt(2261)*I/512,0,-sqrt(20995)*I/512,0,-sqrt(20995)*I/512,0,3*sqrt(2261)*I/512,0,3*sqrt(9690)*I/1024,0,-77*sqrt(38)*I/1024,0,39*sqrt(30)*I/1024,0,-sqrt(770)*I/1024]",
        ),
        "Qh(5,Eu,3,0)": (
            "sqrt(7)*C1/4-sqrt(6)*C3/8-sqrt(30)*C5/8",
            "sqrt(105)*x*(y-z)*(y+z)*(2*x**2-y**2-z**2)/4",
            "[sqrt(15)/8,0,sqrt(3)/8,0,-sqrt(14)/8,0,sqrt(14)/8,0,-sqrt(3)/8,0,-sqrt(15)/8]",
        ),
        "Qh(5,Eu,3,1)": (
            "sqrt(7)*S1/4+sqrt(6)*S3/8-sqrt(30)*S5/8",
            "-sqrt(105)*y*(x-z)*(x+z)*(x**2-2*y**2+z**2)/4",
            "[-sqrt(15)*I/8,0,sqrt(3)*I/8,0,sqrt(14)*I/8,0,sqrt(14)*I/8,0,sqrt(3)*I/8,0,-sqrt(15)*I/8]",
        ),
        "Qh(7,Eu,3,0)": (
            "-sqrt(858)*C1/64-3*sqrt(286)*C3/64-5*sqrt(26)*C5/64-sqrt(14)*C7/64",
            "sqrt(6006)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/32",
            "[sqrt(7)/64,0,5*sqrt(13)/64,0,3*sqrt(143)/64,0,sqrt(429)/64,0,-sqrt(429)/64,0,-3*sqrt(143)/64,0,-5*sqrt(13)/64,0,-sqrt(7)/64]",
        ),
        "Qh(7,Eu,3,1)": (
            "-sqrt(858)*S1/64+3*sqrt(286)*S3/64-5*sqrt(26)*S5/64+sqrt(14)*S7/64",
            "sqrt(6006)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)/32",
            "[sqrt(7)*I/64,0,-5*sqrt(13)*I/64,0,3*sqrt(143)*I/64,0,-sqrt(429)*I/64,0,-sqrt(429)*I/64,0,3*sqrt(143)*I/64,0,-5*sqrt(13)*I/64,0,sqrt(7)*I/64]",
        ),
        "Qh(9,Eu,3,0)": (
            "sqrt(1001)*C1/64-sqrt(78)*C3/64-3*sqrt(70)*C5/64+23*sqrt(14)*C7/128+3*sqrt(238)*C9/128",
            "3*sqrt(5005)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(8*x**4-8*x**2*y**2-8*x**2*z**2+y**4+2*y**2*z**2+z**4)/64",
            "[-3*sqrt(119)/128,0,-23*sqrt(7)/128,0,3*sqrt(35)/64,0,sqrt(39)/64,0,-sqrt(2002)/128,0,sqrt(2002)/128,0,-sqrt(39)/64,0,-3*sqrt(35)/64,0,23*sqrt(7)/128,0,3*sqrt(119)/128]",
        ),
        "Qh(9,Eu,3,1)": (
            "sqrt(1001)*S1/64+sqrt(78)*S3/64-3*sqrt(70)*S5/64-23*sqrt(14)*S7/128+3*sqrt(238)*S9/128",
            "3*sqrt(5005)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(x**4-8*x**2*y**2+2*x**2*z**2+8*y**4-8*y**2*z**2+z**4)/64",
            "[3*sqrt(119)*I/128,0,-23*sqrt(7)*I/128,0,-3*sqrt(35)*I/64,0,sqrt(39)*I/64,0,sqrt(2002)*I/128,0,sqrt(2002)*I/128,0,sqrt(39)*I/64,0,-3*sqrt(35)*I/64,0,-23*sqrt(7)*I/128,0,3*sqrt(119)*I/128]",
        ),
        "Qh(11,Eu,3,0)": (
            "-5*sqrt(546)*C1/256+sqrt(10659)*C11/256+11*sqrt(30)*C3/256+13*sqrt(7)*C5/256-3*sqrt(1785)*C7/256+3*sqrt(2261)*C9/256",
            "3*sqrt(1001)*x*(y**2-2*y*z-z**2)*(y**2+2*y*z-z**2)*(80*x**6-168*x**4*y**2-168*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-5*y**6-15*y**4*z**2-15*y**2*z**4-5*z**6)/128",
            "[-sqrt(21318)/512,0,-3*sqrt(4522)/512,0,3*sqrt(3570)/512,0,-13*sqrt(14)/512,0,-11*sqrt(15)/256,0,5*sqrt(273)/256,0,-5*sqrt(273)/256,0,11*sqrt(15)/256,0,13*sqrt(14)/512,0,-3*sqrt(3570)/512,0,3*sqrt(4522)/512,0,sqrt(21318)/512]",
        ),
        "Qh(11,Eu,3,1)": (
            "-5*sqrt(546)*S1/256-sqrt(10659)*S11/256-11*sqrt(30)*S3/256+13*sqrt(7)*S5/256+3*sqrt(1785)*S7/256+3*sqrt(2261)*S9/256",
            "-3*sqrt(1001)*y*(x**2-2*x*z-z**2)*(x**2+2*x*z-z**2)*(5*x**6-70*x**4*y**2+15*x**4*z**2+168*x**2*y**4-140*x**2*y**2*z**2+15*x**2*z**4-80*y**6+168*y**4*z**2-70*y**2*z**4+5*z**6)/128",
            "[-sqrt(21318)*I/512,0,3*sqrt(4522)*I/512,0,3*sqrt(3570)*I/512,0,13*sqrt(14)*I/512,0,-11*sqrt(15)*I/256,0,-5*sqrt(273)*I/256,0,-5*sqrt(273)*I/256,0,-11*sqrt(15)*I/256,0,13*sqrt(14)*I/512,0,3*sqrt(3570)*I/512,0,3*sqrt(4522)*I/512,0,-sqrt(21318)*I/512]",
        ),
        "Qh(7,Eu,4,0)": (
            "-15*sqrt(6)*C1/64+19*sqrt(2)*C3/64-sqrt(22)*C5/64-sqrt(2002)*C7/64",
            "sqrt(42)*x*(y-z)*(y+z)*(48*x**4-80*x**2*y**2-80*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/32",
            "[sqrt(1001)/64,0,sqrt(11)/64,0,-19/64,0,15*sqrt(3)/64,0,-15*sqrt(3)/64,0,19/64,0,-sqrt(11)/64,0,-sqrt(1001)/64]",
        ),
        "Qh(7,Eu,4,1)": (
            "-15*sqrt(6)*S1/64-19*sqrt(2)*S3/64-sqrt(22)*S5/64+sqrt(2002)*S7/64",
            "sqrt(42)*y*(x-z)*(x+z)*(15*x**4-80*x**2*y**2+30*x**2*z**2+48*y**4-80*y**2*z**2+15*z**4)/32",
            "[sqrt(1001)*I/64,0,-sqrt(11)*I/64,0,-19*I/64,0,-15*sqrt(3)*I/64,0,-15*sqrt(3)*I/64,0,-19*I/64,0,-sqrt(11)*I/64,0,sqrt(1001)*I/64]",
        ),
        "Qh(9,Eu,4,0)": (
            "sqrt(858)*C1/64+sqrt(91)*C3/32-5*sqrt(15)*C5/32-21*sqrt(3)*C7/64-sqrt(51)*C9/64",
            "sqrt(4290)*x*(y-z)*(y+z)*(14*x**2-3*y**2-3*z**2)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)/64",
            "[sqrt(102)/128,0,21*sqrt(6)/128,0,5*sqrt(30)/64,0,-sqrt(182)/64,0,-sqrt(429)/64,0,sqrt(429)/64,0,sqrt(182)/64,0,-5*sqrt(30)/64,0,-21*sqrt(6)/128,0,-sqrt(102)/128]",
        ),
        "Qh(9,Eu,4,1)": (
            "sqrt(858)*S1/64-sqrt(91)*S3/32-5*sqrt(15)*S5/32+21*sqrt(3)*S7/64-sqrt(51)*S9/64",
            "-sqrt(4290)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(3*x**2-14*y**2+3*z**2)/64",
            "[-sqrt(102)*I/128,0,21*sqrt(6)*I/128,0,-5*sqrt(30)*I/64,0,-sqrt(182)*I/64,0,sqrt(429)*I/64,0,sqrt(429)*I/64,0,-sqrt(182)*I/64,0,-5*sqrt(30)*I/64,0,21*sqrt(6)*I/128,0,-sqrt(102)*I/128]",
        ),
        "Qh(11,Eu,4,0)": (
            "-sqrt(29393)*C1/512-sqrt(22)*C11/1024-9*sqrt(1615)*C3/512-5*sqrt(13566)*C5/1024-7*sqrt(1330)*C7/1024-9*sqrt(42)*C9/1024",
            "sqrt(1939938)*x*(y-z)*(y+z)*(y**4-4*y**3*z-14*y**2*z**2-4*y*z**3+z**4)*(y**4+4*y**3*z-14*y**2*z**2+4*y*z**3+z**4)/512",
            "[sqrt(11)/1024,0,9*sqrt(21)/1024,0,7*sqrt(665)/1024,0,5*sqrt(6783)/1024,0,9*sqrt(3230)/1024,0,sqrt(58786)/1024,0,-sqrt(58786)/1024,0,-9*sqrt(3230)/1024,0,-5*sqrt(6783)/1024,0,-7*sqrt(665)/1024,0,-9*sqrt(21)/1024,0,-sqrt(11)/1024]",
        ),
        "Qh(11,Eu,4,1)": (
            "-sqrt(29393)*S1/512+sqrt(22)*S11/1024+9*sqrt(1615)*S3/512-5*sqrt(13566)*S5/1024+7*sqrt(1330)*S7/1024-9*sqrt(42)*S9/1024",
            "sqrt(1939938)*y*(x-z)*(x+z)*(x**4-4*x**3*z-14*x**2*z**2-4*x*z**3+z**4)*(x**4+4*x**3*z-14*x**2*z**2+4*x*z**3+z**4)/512",
            "[sqrt(11)*I/1024,0,-9*sqrt(21)*I/1024,0,7*sqrt(665)*I/1024,0,-5*sqrt(6783)*I/1024,0,9*sqrt(3230)*I/1024,0,-sqrt(58786)*I/1024,0,-sqrt(58786)*I/1024,0,9*sqrt(3230)*I/1024,0,-5*sqrt(6783)*I/1024,0,7*sqrt(665)*I/1024,0,-9*sqrt(21)*I/1024,0,sqrt(11)*I/1024]",
        ),
        "Qh(9,Eu,5,0)": (
            "7*sqrt(22)*C1/64-3*sqrt(21)*C3/32+sqrt(65)*C5/32+sqrt(13)*C7/64-3*sqrt(221)*C9/64",
            "3*sqrt(110)*x*(y-z)*(y+z)*(32*x**6-112*x**4*y**2-112*x**4*z**2+70*x**2*y**4+140*x**2*y**2*z**2+70*x**2*z**4-7*y**6-21*y**4*z**2-21*y**2*z**4-7*z**6)/64",
            "[3*sqrt(442)/128,0,-sqrt(26)/128,0,-sqrt(130)/64,0,3*sqrt(42)/64,0,-7*sqrt(11)/64,0,7*sqrt(11)/64,0,-3*sqrt(42)/64,0,sqrt(130)/64,0,sqrt(26)/128,0,-3*sqrt(442)/128]",
        ),
        "Qh(9,Eu,5,1)": (
            "7*sqrt(22)*S1/64+3*sqrt(21)*S3/32+sqrt(65)*S5/32-sqrt(13)*S7/64-3*sqrt(221)*S9/64",
            "-3*sqrt(110)*y*(x-z)*(x+z)*(7*x**6-70*x**4*y**2+21*x**4*z**2+112*x**2*y**4-140*x**2*y**2*z**2+21*x**2*z**4-32*y**6+112*y**4*z**2-70*y**2*z**4+7*z**6)/64",
            "[-3*sqrt(442)*I/128,0,-sqrt(26)*I/128,0,sqrt(130)*I/64,0,3*sqrt(42)*I/64,0,7*sqrt(11)*I/64,0,7*sqrt(11)*I/64,0,3*sqrt(42)*I/64,0,sqrt(130)*I/64,0,-sqrt(26)*I/128,0,-3*sqrt(442)*I/128]",
        ),
        "Qh(11,Eu,5,0)": (
            "-15*sqrt(221)*C1/512-3*sqrt(2926)*C11/1024-sqrt(595)*C3/512+53*sqrt(102)*C5/1024-105*sqrt(10)*C7/1024-61*sqrt(114)*C9/1024",
            "sqrt(14586)*x*(y-z)*(y+z)*(y**2-4*y*z+z**2)*(y**2+4*y*z+z**2)*(224*x**4-160*x**2*y**2-160*x**2*z**2+15*y**4+30*y**2*z**2+15*z**4)/512",
            "[3*sqrt(1463)/1024,0,61*sqrt(57)/1024,0,105*sqrt(5)/1024,0,-53*sqrt(51)/1024,0,sqrt(1190)/1024,0,15*sqrt(442)/1024,0,-15*sqrt(442)/1024,0,-sqrt(1190)/1024,0,53*sqrt(51)/1024,0,-105*sqrt(5)/1024,0,-61*sqrt(57)/1024,0,-3*sqrt(1463)/1024]",
        ),
        "Qh(11,Eu,5,1)": (
            "-15*sqrt(221)*S1/512+3*sqrt(2926)*S11/1024+sqrt(595)*S3/512+53*sqrt(102)*S5/1024+105*sqrt(10)*S7/1024-61*sqrt(114)*S9/1024",
            "sqrt(14586)*y*(x-z)*(x+z)*(x**2-4*x*z+z**2)*(x**2+4*x*z+z**2)*(15*x**4-160*x**2*y**2+30*x**2*z**2+224*y**4-160*y**2*z**2+15*z**4)/512",
            "[3*sqrt(1463)*I/1024,0,-61*sqrt(57)*I/1024,0,105*sqrt(5)*I/1024,0,53*sqrt(51)*I/1024,0,sqrt(1190)*I/1024,0,-15*sqrt(442)*I/1024,0,-15*sqrt(442)*I/1024,0,sqrt(1190)*I/1024,0,53*sqrt(51)*I/1024,0,105*sqrt(5)*I/1024,0,-61*sqrt(57)*I/1024,0,3*sqrt(1463)*I/1024]",
        ),
        "Qh(11,Eu,6,0)": (
            "-21*sqrt(130)*C1/512-sqrt(124355)*C11/512+57*sqrt(14)*C3/512-41*sqrt(15)*C5/512+17*sqrt(17)*C7/512+sqrt(4845)*C9/512",
            "sqrt(2145)*x*(y-z)*(y+z)*(128*x**8-768*x**6*y**2-768*x**6*z**2+1008*x**4*y**4+2016*x**4*y**2*z**2+1008*x**4*z**4-336*x**2*y**6-1008*x**2*y**4*z**2-1008*x**2*y**2*z**4-336*x**2*z**6+21*y**8+84*y**6*z**2+126*y**4*z**4+84*y**2*z**6+21*z**8)/256",
            "[sqrt(248710)/1024,0,-sqrt(9690)/1024,0,-17*sqrt(34)/1024,0,41*sqrt(30)/1024,0,-57*sqrt(7)/512,0,21*sqrt(65)/512,0,-21*sqrt(65)/512,0,57*sqrt(7)/512,0,-41*sqrt(30)/1024,0,17*sqrt(34)/1024,0,sqrt(9690)/1024,0,-sqrt(248710)/1024]",
        ),
        "Qh(11,Eu,6,1)": (
            "-21*sqrt(130)*S1/512+sqrt(124355)*S11/512-57*sqrt(14)*S3/512-41*sqrt(15)*S5/512-17*sqrt(17)*S7/512+sqrt(4845)*S9/512",
            "sqrt(2145)*y*(x-z)*(x+z)*(21*x**8-336*x**6*y**2+84*x**6*z**2+1008*x**4*y**4-1008*x**4*y**2*z**2+126*x**4*z**4-768*x**2*y**6+2016*x**2*y**4*z**2-1008*x**2*y**2*z**4+84*x**2*z**6+128*y**8-768*y**6*z**2+1008*y**4*z**4-336*y**2*z**6+21*z**8)/256",
            "[sqrt(248710)*I/1024,0,sqrt(9690)*I/1024,0,-17*sqrt(34)*I/1024,0,-41*sqrt(30)*I/1024,0,-57*sqrt(7)*I/512,0,-21*sqrt(65)*I/512,0,-21*sqrt(65)*I/512,0,-57*sqrt(7)*I/512,0,-41*sqrt(30)*I/1024,0,-17*sqrt(34)*I/1024,0,sqrt(9690)*I/1024,0,sqrt(248710)*I/1024]",
        ),
    },
    "C3": {
        "Qh(0,A,,)": ("C0", "1", "[1]"),
        "Qh(1,A,,)": ("C0", "z", "[0,1,0]"),
        "Qh(1,Ea,,)": ("sqrt(2)*C1/2+sqrt(2)*I*S1/2", "sqrt(2)*(x+I*y)/2", "[-1,0,0]"),
        "Qh(1,Eb,,)": ("sqrt(2)*C1/2-sqrt(2)*I*S1/2", "sqrt(2)*(x-I*y)/2", "[0,0,1]"),
        "Qh(2,A,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(2,Ea,1,)": ("sqrt(2)*C1/2+sqrt(2)*I*S1/2", "sqrt(6)*z*(x+I*y)/2", "[0,-1,0,0,0]"),
        "Qh(2,Ea,2,)": ("sqrt(2)*C2/2-sqrt(2)*I*S2/2", "sqrt(6)*(x**2-2*I*x*y-y**2)/4", "[0,0,0,0,1]"),
        "Qh(2,Eb,1,)": ("sqrt(2)*C1/2-sqrt(2)*I*S1/2", "sqrt(6)*z*(x-I*y)/2", "[0,0,0,1,0]"),
        "Qh(2,Eb,2,)": ("sqrt(2)*C2/2+sqrt(2)*I*S2/2", "sqrt(6)*(x**2+2*I*x*y-y**2)/4", "[1,0,0,0,0]"),
        "Qh(3,A,1,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(3,A,2,)": ("S3", "sqrt(10)*y*(3*x**2-y**2)/4", "[sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(3,A,3,)": ("C3", "sqrt(10)*x*(x**2-3*y**2)/4", "[-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(3,Ea,1,)": ("sqrt(2)*C1/2+sqrt(2)*I*S1/2", "-sqrt(3)*(x+I*y)*(x**2+y**2-4*z**2)/4", "[0,0,-1,0,0,0,0]"),
        "Qh(3,Ea,2,)": ("sqrt(2)*C2/2-sqrt(2)*I*S2/2", "sqrt(30)*z*(x**2-2*I*x*y-y**2)/4", "[0,0,0,0,0,1,0]"),
        "Qh(3,Eb,1,)": ("sqrt(2)*C1/2-sqrt(2)*I*S1/2", "-sqrt(3)*(x-I*y)*(x**2+y**2-4*z**2)/4", "[0,0,0,0,1,0,0]"),
        "Qh(3,Eb,2,)": ("sqrt(2)*C2/2+sqrt(2)*I*S2/2", "sqrt(30)*z*(x**2+2*I*x*y-y**2)/4", "[0,1,0,0,0,0,0]"),
        "Qh(4,A,1,)": ("C0", "3*x**4/8+3*x**2*y**2/4-3*x**2*z**2+3*y**4/8-3*y**2*z**2+z**4", "[0,0,0,0,1,0,0,0,0]"),
        "Qh(4,A,2,)": ("C3", "sqrt(70)*x*z*(x**2-3*y**2)/4", "[0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(4,A,3,)": ("S3", "sqrt(70)*y*z*(3*x**2-y**2)/4", "[0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(4,Ea,1,)": ("sqrt(2)*C1/2+sqrt(2)*I*S1/2", "-sqrt(5)*z*(x+I*y)*(3*x**2+3*y**2-4*z**2)/4", "[0,0,0,-1,0,0,0,0,0]"),
        "Qh(4,Ea,2,)": (
            "sqrt(2)*C4/2+sqrt(2)*I*S4/2",
            "sqrt(70)*(x**4+4*I*x**3*y-6*x**2*y**2-4*I*x*y**3+y**4)/16",
            "[1,0,0,0,0,0,0,0,0]",
        ),
        "Qh(4,Ea,3,)": (
            "sqrt(2)*C2/2-sqrt(2)*I*S2/2",
            "-sqrt(10)*(x**2+y**2-6*z**2)*(x**2-2*I*x*y-y**2)/8",
            "[0,0,0,0,0,0,1,0,0]",
        ),
        "Qh(4,Eb,1,)": ("sqrt(2)*C1/2-sqrt(2)*I*S1/2", "-sqrt(5)*z*(x-I*y)*(3*x**2+3*y**2-4*z**2)/4", "[0,0,0,0,0,1,0,0,0]"),
        "Qh(4,Eb,2,)": (
            "sqrt(2)*C4/2-sqrt(2)*I*S4/2",
            "sqrt(70)*(x**4-4*I*x**3*y-6*x**2*y**2+4*I*x*y**3+y**4)/16",
            "[0,0,0,0,0,0,0,0,1]",
        ),
        "Qh(4,Eb,3,)": (
            "sqrt(2)*C2/2+sqrt(2)*I*S2/2",
            "-sqrt(10)*(x**2+y**2-6*z**2)*(x**2+2*I*x*y-y**2)/8",
            "[0,0,1,0,0,0,0,0,0]",
        ),
        "Qh(5,A,1,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(5,A,2,)": ("S3", "-sqrt(70)*y*(3*x**2-y**2)*(x**2+y**2-8*z**2)/16", "[0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(5,A,3,)": ("C3", "-sqrt(70)*x*(x**2-3*y**2)*(x**2+y**2-8*z**2)/16", "[0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0]"),
        "Qh(5,Ea,1,)": (
            "sqrt(2)*C5/2-sqrt(2)*I*S5/2",
            "3*sqrt(7)*(x**5-5*I*x**4*y-10*x**3*y**2+10*I*x**2*y**3+5*x*y**4-I*y**5)/16",
            "[0,0,0,0,0,0,0,0,0,0,1]",
        ),
        "Qh(5,Ea,2,)": (
            "sqrt(2)*C1/2+sqrt(2)*I*S1/2",
            "sqrt(30)*(x+I*y)*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/16",
            "[0,0,0,0,-1,0,0,0,0,0,0]",
        ),
        "Qh(5,Ea,3,)": (
            "sqrt(2)*C4/2+sqrt(2)*I*S4/2",
            "3*sqrt(70)*z*(x**4+4*I*x**3*y-6*x**2*y**2-4*I*x*y**3+y**4)/16",
            "[0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(5,Ea,4,)": (
            "sqrt(2)*C2/2-sqrt(2)*I*S2/2",
            "-sqrt(210)*z*(x**2+y**2-2*z**2)*(x**2-2*I*x*y-y**2)/8",
            "[0,0,0,0,0,0,0,1,0,0,0]",
        ),
        "Qh(5,Eb,1,)": (
            "sqrt(2)*C5/2+sqrt(2)*I*S5/2",
            "3*sqrt(7)*(x**5+5*I*x**4*y-10*x**3*y**2-10*I*x**2*y**3+5*x*y**4+I*y**5)/16",
            "[-1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(5,Eb,2,)": (
            "sqrt(2)*C1/2-sqrt(2)*I*S1/2",
            "sqrt(30)*(x-I*y)*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/16",
            "[0,0,0,0,0,0,1,0,0,0,0]",
        ),
        "Qh(5,Eb,3,)": (
            "sqrt(2)*C4/2-sqrt(2)*I*S4/2",
            "3*sqrt(70)*z*(x**4-4*I*x**3*y-6*x**2*y**2+4*I*x*y**3+y**4)/16",
            "[0,0,0,0,0,0,0,0,0,1,0]",
        ),
        "Qh(5,Eb,4,)": (
            "sqrt(2)*C2/2+sqrt(2)*I*S2/2",
            "-sqrt(210)*z*(x**2+y**2-2*z**2)*(x**2+2*I*x*y-y**2)/8",
            "[0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(6,A,1,)": (
            "C0",
            "-5*x**6/16-15*x**4*y**2/16+45*x**4*z**2/8-15*x**2*y**4/16+45*x**2*y**2*z**2/4-15*x**2*z**4/2-5*y**6/16+45*y**4*z**2/8-15*y**2*z**4/2+z**6",
            "[0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Qh(6,A,2,)": (
            "C6",
            "sqrt(462)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(6,A,3,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(6,A,4,)": (
            "C3",
            "-sqrt(210)*x*z*(x**2-3*y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(6,A,5,)": (
            "S3",
            "-sqrt(210)*y*z*(3*x**2-y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(6,Ea,1,)": (
            "sqrt(2)*C5/2-sqrt(2)*I*S5/2",
            "3*sqrt(77)*z*(x**5-5*I*x**4*y-10*x**3*y**2+10*I*x**2*y**3+5*x*y**4-I*y**5)/16",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0]",
        ),
        "Qh(6,Ea,2,)": (
            "sqrt(2)*C1/2+sqrt(2)*I*S1/2",
            "sqrt(42)*z*(x+I*y)*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/16",
            "[0,0,0,0,0,-1,0,0,0,0,0,0,0]",
        ),
        "Qh(6,Ea,3,)": (
            "sqrt(2)*C4/2+sqrt(2)*I*S4/2",
            "-3*sqrt(14)*(x**2+y**2-10*z**2)*(x**4+4*I*x**3*y-6*x**2*y**2-4*I*x*y**3+y**4)/32",
            "[0,0,1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(6,Ea,4,)": (
            "sqrt(2)*C2/2-sqrt(2)*I*S2/2",
            "sqrt(105)*(x**2-2*I*x*y-y**2)*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,0,0,0,1,0,0,0,0]",
        ),
        "Qh(6,Eb,1,)": (
            "sqrt(2)*C5/2+sqrt(2)*I*S5/2",
            "3*sqrt(77)*z*(x**5+5*I*x**4*y-10*x**3*y**2-10*I*x**2*y**3+5*x*y**4+I*y**5)/16",
            "[0,-1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(6,Eb,2,)": (
            "sqrt(2)*C1/2-sqrt(2)*I*S1/2",
            "sqrt(42)*z*(x-I*y)*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0]",
        ),
        "Qh(6,Eb,3,)": (
            "sqrt(2)*C4/2-sqrt(2)*I*S4/2",
            "-3*sqrt(14)*(x**2+y**2-10*z**2)*(x**4-4*I*x**3*y-6*x**2*y**2+4*I*x*y**3+y**4)/32",
            "[0,0,0,0,0,0,0,0,0,0,1,0,0]",
        ),
        "Qh(6,Eb,4,)": (
            "sqrt(2)*C2/2+sqrt(2)*I*S2/2",
            "sqrt(105)*(x**2+2*I*x*y-y**2)*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,1,0,0,0,0,0,0,0,0]",
        ),
        "Qh(7,A,1,)": (
            "S6",
            "sqrt(6006)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(7,A,2,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(7,A,3,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(7,A,4,)": (
            "S3",
            "sqrt(21)*y*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(7,A,5,)": (
            "C3",
            "sqrt(21)*x*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(7,Ea,1,)": (
            "sqrt(2)*C7/2+sqrt(2)*I*S7/2",
            "sqrt(858)*(x**7+7*I*x**6*y-21*x**5*y**2-35*I*x**4*y**3+35*x**3*y**4+21*I*x**2*y**5-7*x*y**6-I*y**7)/64",
            "[-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(7,Ea,2,)": (
            "sqrt(2)*C5/2-sqrt(2)*I*S5/2",
            "-sqrt(462)*(x**2+y**2-12*z**2)*(x**5-5*I*x**4*y-10*x**3*y**2+10*I*x**2*y**3+5*x*y**4-I*y**5)/64",
            "[0,0,0,0,0,0,0,0,0,0,0,0,1,0,0]",
        ),
        "Qh(7,Ea,3,)": (
            "sqrt(2)*C1/2+sqrt(2)*I*S1/2",
            "-sqrt(14)*(x+I*y)*(5*x**6+15*x**4*y**2-120*x**4*z**2+15*x**2*y**4-240*x**2*y**2*z**2+240*x**2*z**4+5*y**6-120*y**4*z**2+240*y**2*z**4-64*z**6)/64",
            "[0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0]",
        ),
        "Qh(7,Ea,4,)": (
            "sqrt(2)*C4/2+sqrt(2)*I*S4/2",
            "-sqrt(462)*z*(3*x**2+3*y**2-10*z**2)*(x**4+4*I*x**3*y-6*x**2*y**2-4*I*x*y**3+y**4)/32",
            "[0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(7,Ea,5,)": (
            "sqrt(2)*C2/2-sqrt(2)*I*S2/2",
            "sqrt(21)*z*(x**2-2*I*x*y-y**2)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0]",
        ),
        "Qh(7,Eb,1,)": (
            "sqrt(2)*C7/2-sqrt(2)*I*S7/2",
            "sqrt(858)*(x**7-7*I*x**6*y-21*x**5*y**2+35*I*x**4*y**3+35*x**3*y**4-21*I*x**2*y**5-7*x*y**6+I*y**7)/64",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,1]",
        ),
        "Qh(7,Eb,2,)": (
            "sqrt(2)*C5/2+sqrt(2)*I*S5/2",
            "-sqrt(462)*(x**2+y**2-12*z**2)*(x**5+5*I*x**4*y-10*x**3*y**2-10*I*x**2*y**3+5*x*y**4+I*y**5)/64",
            "[0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(7,Eb,3,)": (
            "sqrt(2)*C1/2-sqrt(2)*I*S1/2",
            "-sqrt(14)*(x-I*y)*(5*x**6+15*x**4*y**2-120*x**4*z**2+15*x**2*y**4-240*x**2*y**2*z**2+240*x**2*z**4+5*y**6-120*y**4*z**2+240*y**2*z**4-64*z**6)/64",
            "[0,0,0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Qh(7,Eb,4,)": (
            "sqrt(2)*C4/2-sqrt(2)*I*S4/2",
            "-sqrt(462)*z*(3*x**2+3*y**2-10*z**2)*(x**4-4*I*x**3*y-6*x**2*y**2+4*I*x*y**3+y**4)/32",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0]",
        ),
        "Qh(7,Eb,5,)": (
            "sqrt(2)*C2/2+sqrt(2)*I*S2/2",
            "sqrt(21)*z*(x**2+2*I*x*y-y**2)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(8,A,1,)": (
            "C0",
            "35*x**8/128+35*x**6*y**2/32-35*x**6*z**2/4+105*x**4*y**4/64-105*x**4*y**2*z**2/4+105*x**4*z**4/4+35*x**2*y**6/32-105*x**2*y**4*z**2/4+105*x**2*y**2*z**4/2-14*x**2*z**6+35*y**8/128-35*y**6*z**2/4+105*y**4*z**4/4-14*y**2*z**6+z**8",
            "[0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0]",
        ),
        "Qh(8,A,2,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(8,A,3,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(8,A,4,)": (
            "C3",
            "sqrt(1155)*x*z*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(8,A,5,)": (
            "S3",
            "sqrt(1155)*y*z*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(8,Ea,1,)": (
            "sqrt(2)*C7/2+sqrt(2)*I*S7/2",
            "3*sqrt(1430)*z*(x**7+7*I*x**6*y-21*x**5*y**2-35*I*x**4*y**3+35*x**3*y**4+21*I*x**2*y**5-7*x*y**6-I*y**7)/64",
            "[0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(8,Ea,2,)": (
            "sqrt(2)*C5/2-sqrt(2)*I*S5/2",
            "-3*sqrt(2002)*z*(x**2+y**2-4*z**2)*(x**5-5*I*x**4*y-10*x**3*y**2+10*I*x**2*y**3+5*x*y**4-I*y**5)/64",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0]",
        ),
        "Qh(8,Ea,3,)": (
            "sqrt(2)*C1/2+sqrt(2)*I*S1/2",
            "-3*sqrt(2)*z*(x+I*y)*(35*x**6+105*x**4*y**2-280*x**4*z**2+105*x**2*y**4-560*x**2*y**2*z**2+336*x**2*z**4+35*y**6-280*y**4*z**2+336*y**2*z**4-64*z**6)/64",
            "[0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(8,Ea,4,)": (
            "sqrt(2)*C8/2-sqrt(2)*I*S8/2",
            "3*sqrt(1430)*(x**8-8*I*x**7*y-28*x**6*y**2+56*I*x**5*y**3+70*x**4*y**4-56*I*x**3*y**5-28*x**2*y**6+8*I*x*y**7+y**8)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1]",
        ),
        "Qh(8,Ea,5,)": (
            "sqrt(2)*C4/2+sqrt(2)*I*S4/2",
            "3*sqrt(154)*(x**4+4*I*x**3*y-6*x**2*y**2-4*I*x*y**3+y**4)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/128",
            "[0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(8,Ea,6,)": (
            "sqrt(2)*C2/2-sqrt(2)*I*S2/2",
            "-3*sqrt(35)*(x**2-2*I*x*y-y**2)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Qh(8,Eb,1,)": (
            "sqrt(2)*C7/2-sqrt(2)*I*S7/2",
            "3*sqrt(1430)*z*(x**7-7*I*x**6*y-21*x**5*y**2+35*I*x**4*y**3+35*x**3*y**4-21*I*x**2*y**5-7*x*y**6+I*y**7)/64",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0]",
        ),
        "Qh(8,Eb,2,)": (
            "sqrt(2)*C5/2+sqrt(2)*I*S5/2",
            "-3*sqrt(2002)*z*(x**2+y**2-4*z**2)*(x**5+5*I*x**4*y-10*x**3*y**2-10*I*x**2*y**3+5*x*y**4+I*y**5)/64",
            "[0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(8,Eb,3,)": (
            "sqrt(2)*C1/2-sqrt(2)*I*S1/2",
            "-3*sqrt(2)*z*(x-I*y)*(35*x**6+105*x**4*y**2-280*x**4*z**2+105*x**2*y**4-560*x**2*y**2*z**2+336*x**2*z**4+35*y**6-280*y**4*z**2+336*y**2*z**4-64*z**6)/64",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(8,Eb,4,)": (
            "sqrt(2)*C8/2+sqrt(2)*I*S8/2",
            "3*sqrt(1430)*(x**8+8*I*x**7*y-28*x**6*y**2-56*I*x**5*y**3+70*x**4*y**4+56*I*x**3*y**5-28*x**2*y**6-8*I*x*y**7+y**8)/256",
            "[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(8,Eb,5,)": (
            "sqrt(2)*C4/2-sqrt(2)*I*S4/2",
            "3*sqrt(154)*(x**4-4*I*x**3*y-6*x**2*y**2+4*I*x*y**3+y**4)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/128",
            "[0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0]",
        ),
        "Qh(8,Eb,6,)": (
            "sqrt(2)*C2/2+sqrt(2)*I*S2/2",
            "-3*sqrt(35)*(x**2+2*I*x*y-y**2)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,A,1,)": (
            "S6",
            "-sqrt(4290)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**2+3*y**2-14*z**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(9,A,2,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,A,3,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,A,4,)": (
            "S9",
            "sqrt(24310)*y*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(9,A,5,)": (
            "S3",
            "-sqrt(2310)*y*(3*x**2-y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,A,6,)": (
            "C9",
            "sqrt(24310)*x*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(9,A,7,)": (
            "C3",
            "-sqrt(2310)*x*(x**2-3*y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(9,Ea,1,)": (
            "sqrt(2)*C7/2+sqrt(2)*I*S7/2",
            "-3*sqrt(715)*(x**2+y**2-16*z**2)*(x**7+7*I*x**6*y-21*x**5*y**2-35*I*x**4*y**3+35*x**3*y**4+21*I*x**2*y**5-7*x*y**6-I*y**7)/256",
            "[0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Ea,2,)": (
            "sqrt(2)*C5/2-sqrt(2)*I*S5/2",
            "3*sqrt(143)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)*(x**5-5*I*x**4*y-10*x**3*y**2+10*I*x**2*y**3+5*x*y**4-I*y**5)/128",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0]",
        ),
        "Qh(9,Ea,3,)": (
            "sqrt(2)*C1/2+sqrt(2)*I*S1/2",
            "3*sqrt(10)*(x+I*y)*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Ea,4,)": (
            "sqrt(2)*C8/2-sqrt(2)*I*S8/2",
            "3*sqrt(24310)*z*(x**8-8*I*x**7*y-28*x**6*y**2+56*I*x**5*y**3+70*x**4*y**4-56*I*x**3*y**5-28*x**2*y**6+8*I*x*y**7+y**8)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0]",
        ),
        "Qh(9,Ea,5,)": (
            "sqrt(2)*C4/2+sqrt(2)*I*S4/2",
            "3*sqrt(10010)*z*(x**4+4*I*x**3*y-6*x**2*y**2-4*I*x*y**3+y**4)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/128",
            "[0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Ea,6,)": (
            "sqrt(2)*C2/2-sqrt(2)*I*S2/2",
            "-3*sqrt(55)*z*(x**2-2*I*x*y-y**2)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Eb,1,)": (
            "sqrt(2)*C7/2-sqrt(2)*I*S7/2",
            "-3*sqrt(715)*(x**2+y**2-16*z**2)*(x**7-7*I*x**6*y-21*x**5*y**2+35*I*x**4*y**3+35*x**3*y**4-21*I*x**2*y**5-7*x*y**6+I*y**7)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0]",
        ),
        "Qh(9,Eb,2,)": (
            "sqrt(2)*C5/2+sqrt(2)*I*S5/2",
            "3*sqrt(143)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)*(x**5+5*I*x**4*y-10*x**3*y**2-10*I*x**2*y**3+5*x*y**4+I*y**5)/128",
            "[0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Eb,3,)": (
            "sqrt(2)*C1/2-sqrt(2)*I*S1/2",
            "3*sqrt(10)*(x-I*y)*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Eb,4,)": (
            "sqrt(2)*C8/2+sqrt(2)*I*S8/2",
            "3*sqrt(24310)*z*(x**8+8*I*x**7*y-28*x**6*y**2-56*I*x**5*y**3+70*x**4*y**4+56*I*x**3*y**5-28*x**2*y**6-8*I*x*y**7+y**8)/256",
            "[0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Eb,5,)": (
            "sqrt(2)*C4/2-sqrt(2)*I*S4/2",
            "3*sqrt(10010)*z*(x**4-4*I*x**3*y-6*x**2*y**2+4*I*x*y**3+y**4)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/128",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0]",
        ),
        "Qh(9,Eb,6,)": (
            "sqrt(2)*C2/2+sqrt(2)*I*S2/2",
            "-3*sqrt(55)*z*(x**2+2*I*x*y-y**2)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A,1,)": (
            "C0",
            "-63*x**10/256-315*x**8*y**2/256+1575*x**8*z**2/128-315*x**6*y**4/128+1575*x**6*y**2*z**2/32-525*x**6*z**4/8-315*x**4*y**6/128+4725*x**4*y**4*z**2/64-1575*x**4*y**2*z**4/8+315*x**4*z**6/4-315*x**2*y**8/256+1575*x**2*y**6*z**2/32-1575*x**2*y**4*z**4/8+315*x**2*y**2*z**6/2-45*x**2*z**8/2-63*y**10/256+1575*y**8*z**2/128-525*y**6*z**4/8+315*y**4*z**6/4-45*y**2*z**8/2+z**10",
            "[0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A,2,)": (
            "C6",
            "sqrt(4290)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(10,A,3,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,A,4,)": (
            "C9",
            "sqrt(461890)*x*z*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(10,A,5,)": (
            "C3",
            "-sqrt(4290)*x*z*(x**2-3*y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A,6,)": (
            "S9",
            "sqrt(461890)*y*z*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(10,A,7,)": (
            "S3",
            "-sqrt(4290)*y*z*(3*x**2-y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Ea,1,)": (
            "sqrt(2)*C7/2+sqrt(2)*I*S7/2",
            "-sqrt(36465)*z*(3*x**2+3*y**2-16*z**2)*(x**7+7*I*x**6*y-21*x**5*y**2-35*I*x**4*y**3+35*x**3*y**4+21*I*x**2*y**5-7*x*y**6-I*y**7)/256",
            "[0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Ea,2,)": (
            "sqrt(2)*C5/2-sqrt(2)*I*S5/2",
            "sqrt(429)*z*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)*(x**5-5*I*x**4*y-10*x**3*y**2+10*I*x**2*y**3+5*x*y**4-I*y**5)/128",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0]",
        ),
        "Qh(10,Ea,3,)": (
            "sqrt(2)*C1/2+sqrt(2)*I*S1/2",
            "sqrt(110)*z*(x+I*y)*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Ea,4,)": (
            "sqrt(2)*C10/2+sqrt(2)*I*S10/2",
            "sqrt(46189)*(x**10+10*I*x**9*y-45*x**8*y**2-120*I*x**7*y**3+210*x**6*y**4+252*I*x**5*y**5-210*x**4*y**6-120*I*x**3*y**7+45*x**2*y**8+10*I*x*y**9-y**10)/512",
            "[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Ea,5,)": (
            "sqrt(2)*C8/2-sqrt(2)*I*S8/2",
            "-sqrt(24310)*(x**2+y**2-18*z**2)*(x**8-8*I*x**7*y-28*x**6*y**2+56*I*x**5*y**3+70*x**4*y**4-56*I*x**3*y**5-28*x**2*y**6+8*I*x*y**7+y**8)/512",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0]",
        ),
        "Qh(10,Ea,6,)": (
            "sqrt(2)*C4/2+sqrt(2)*I*S4/2",
            "-sqrt(4290)*(x**4+4*I*x**3*y-6*x**2*y**2-4*I*x*y**3+y**4)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/256",
            "[0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Ea,7,)": (
            "sqrt(2)*C2/2-sqrt(2)*I*S2/2",
            "sqrt(330)*(x**2-2*I*x*y-y**2)*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/512",
            "[0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Eb,1,)": (
            "sqrt(2)*C7/2-sqrt(2)*I*S7/2",
            "-sqrt(36465)*z*(3*x**2+3*y**2-16*z**2)*(x**7-7*I*x**6*y-21*x**5*y**2+35*I*x**4*y**3+35*x**3*y**4-21*I*x**2*y**5-7*x*y**6+I*y**7)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0]",
        ),
        "Qh(10,Eb,2,)": (
            "sqrt(2)*C5/2+sqrt(2)*I*S5/2",
            "sqrt(429)*z*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)*(x**5+5*I*x**4*y-10*x**3*y**2-10*I*x**2*y**3+5*x*y**4+I*y**5)/128",
            "[0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Eb,3,)": (
            "sqrt(2)*C1/2-sqrt(2)*I*S1/2",
            "sqrt(110)*z*(x-I*y)*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Eb,4,)": (
            "sqrt(2)*C10/2-sqrt(2)*I*S10/2",
            "sqrt(46189)*(x**10-10*I*x**9*y-45*x**8*y**2+120*I*x**7*y**3+210*x**6*y**4-252*I*x**5*y**5-210*x**4*y**6+120*I*x**3*y**7+45*x**2*y**8-10*I*x*y**9-y**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1]",
        ),
        "Qh(10,Eb,5,)": (
            "sqrt(2)*C8/2+sqrt(2)*I*S8/2",
            "-sqrt(24310)*(x**2+y**2-18*z**2)*(x**8+8*I*x**7*y-28*x**6*y**2-56*I*x**5*y**3+70*x**4*y**4+56*I*x**3*y**5-28*x**2*y**6-8*I*x*y**7+y**8)/512",
            "[0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Eb,6,)": (
            "sqrt(2)*C4/2-sqrt(2)*I*S4/2",
            "-sqrt(4290)*(x**4-4*I*x**3*y-6*x**2*y**2+4*I*x*y**3+y**4)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Qh(10,Eb,7,)": (
            "sqrt(2)*C2/2+sqrt(2)*I*S2/2",
            "sqrt(330)*(x**2+2*I*x*y-y**2)*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/512",
            "[0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A,1,)": (
            "S6",
            "sqrt(14586)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(11,A,2,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A,3,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,A,4,)": (
            "S9",
            "-sqrt(46189)*y*(3*x**2-y**2)*(x**2+y**2-20*z**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/512",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(11,A,5,)": (
            "S3",
            "sqrt(30030)*y*(3*x**2-y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A,6,)": (
            "C9",
            "-sqrt(46189)*x*(x**2-3*y**2)*(x**2+y**2-20*z**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/512",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(11,A,7,)": (
            "C3",
            "sqrt(30030)*x*(x**2-3*y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Ea,1,)": (
            "sqrt(2)*C11/2-sqrt(2)*I*S11/2",
            "sqrt(176358)*(x**11-11*I*x**10*y-55*x**9*y**2+165*I*x**8*y**3+330*x**7*y**4-462*I*x**6*y**5-462*x**5*y**6+330*I*x**4*y**7+165*x**3*y**8-55*I*x**2*y**9-11*x*y**10+I*y**11)/1024",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1]",
        ),
        "Qh(11,Ea,2,)": (
            "sqrt(2)*C7/2+sqrt(2)*I*S7/2",
            "sqrt(72930)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)*(x**7+7*I*x**6*y-21*x**5*y**2-35*I*x**4*y**3+35*x**3*y**4+21*I*x**2*y**5-7*x*y**6-I*y**7)/1024",
            "[0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Ea,3,)": (
            "sqrt(2)*C5/2-sqrt(2)*I*S5/2",
            "-3*sqrt(286)*(x**5-5*I*x**4*y-10*x**3*y**2+10*I*x**2*y**3+5*x*y**4-I*y**5)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/1024",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Qh(11,Ea,4,)": (
            "sqrt(2)*C1/2+sqrt(2)*I*S1/2",
            "-sqrt(33)*(x+I*y)*(21*x**10+105*x**8*y**2-1260*x**8*z**2+210*x**6*y**4-5040*x**6*y**2*z**2+8400*x**6*z**4+210*x**4*y**6-7560*x**4*y**4*z**2+25200*x**4*y**2*z**4-13440*x**4*z**6+105*x**2*y**8-5040*x**2*y**6*z**2+25200*x**2*y**4*z**4-26880*x**2*y**2*z**6+5760*x**2*z**8+21*y**10-1260*y**8*z**2+8400*y**6*z**4-13440*y**4*z**6+5760*y**2*z**8-512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Ea,5,)": (
            "sqrt(2)*C10/2+sqrt(2)*I*S10/2",
            "sqrt(969969)*z*(x**10+10*I*x**9*y-45*x**8*y**2-120*I*x**7*y**3+210*x**6*y**4+252*I*x**5*y**5-210*x**4*y**6-120*I*x**3*y**7+45*x**2*y**8+10*I*x*y**9-y**10)/512",
            "[0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Ea,6,)": (
            "sqrt(2)*C8/2-sqrt(2)*I*S8/2",
            "-sqrt(1385670)*z*(x**2+y**2-6*z**2)*(x**8-8*I*x**7*y-28*x**6*y**2+56*I*x**5*y**3+70*x**4*y**4-56*I*x**3*y**5-28*x**2*y**6+8*I*x*y**7+y**8)/512",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0]",
        ),
        "Qh(11,Ea,7,)": (
            "sqrt(2)*C4/2+sqrt(2)*I*S4/2",
            "-3*sqrt(2002)*z*(x**4+4*I*x**3*y-6*x**2*y**2-4*I*x*y**3+y**4)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/256",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Ea,8,)": (
            "sqrt(2)*C2/2-sqrt(2)*I*S2/2",
            "sqrt(4290)*z*(x**2-2*I*x*y-y**2)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eb,1,)": (
            "sqrt(2)*C11/2+sqrt(2)*I*S11/2",
            "sqrt(176358)*(x**11+11*I*x**10*y-55*x**9*y**2-165*I*x**8*y**3+330*x**7*y**4+462*I*x**6*y**5-462*x**5*y**6-330*I*x**4*y**7+165*x**3*y**8+55*I*x**2*y**9-11*x*y**10-I*y**11)/1024",
            "[-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eb,2,)": (
            "sqrt(2)*C7/2-sqrt(2)*I*S7/2",
            "sqrt(72930)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)*(x**7-7*I*x**6*y-21*x**5*y**2+35*I*x**4*y**3+35*x**3*y**4-21*I*x**2*y**5-7*x*y**6+I*y**7)/1024",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0]",
        ),
        "Qh(11,Eb,3,)": (
            "sqrt(2)*C5/2+sqrt(2)*I*S5/2",
            "-3*sqrt(286)*(x**5+5*I*x**4*y-10*x**3*y**2-10*I*x**2*y**3+5*x*y**4+I*y**5)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/1024",
            "[0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eb,4,)": (
            "sqrt(2)*C1/2-sqrt(2)*I*S1/2",
            "-sqrt(33)*(x-I*y)*(21*x**10+105*x**8*y**2-1260*x**8*z**2+210*x**6*y**4-5040*x**6*y**2*z**2+8400*x**6*z**4+210*x**4*y**6-7560*x**4*y**4*z**2+25200*x**4*y**2*z**4-13440*x**4*z**6+105*x**2*y**8-5040*x**2*y**6*z**2+25200*x**2*y**4*z**4-26880*x**2*y**2*z**6+5760*x**2*z**8+21*y**10-1260*y**8*z**2+8400*y**6*z**4-13440*y**4*z**6+5760*y**2*z**8-512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eb,5,)": (
            "sqrt(2)*C10/2-sqrt(2)*I*S10/2",
            "sqrt(969969)*z*(x**10-10*I*x**9*y-45*x**8*y**2+120*I*x**7*y**3+210*x**6*y**4-252*I*x**5*y**5-210*x**4*y**6+120*I*x**3*y**7+45*x**2*y**8-10*I*x*y**9-y**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0]",
        ),
        "Qh(11,Eb,6,)": (
            "sqrt(2)*C8/2+sqrt(2)*I*S8/2",
            "-sqrt(1385670)*z*(x**2+y**2-6*z**2)*(x**8+8*I*x**7*y-28*x**6*y**2-56*I*x**5*y**3+70*x**4*y**4+56*I*x**3*y**5-28*x**2*y**6-8*I*x*y**7+y**8)/512",
            "[0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eb,7,)": (
            "sqrt(2)*C4/2-sqrt(2)*I*S4/2",
            "-3*sqrt(2002)*z*(x**4-4*I*x**3*y-6*x**2*y**2+4*I*x*y**3+y**4)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eb,8,)": (
            "sqrt(2)*C2/2+sqrt(2)*I*S2/2",
            "sqrt(4290)*z*(x**2+2*I*x*y-y**2)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
    },
    "C3i": {
        "Qh(0,Ag,,)": ("C0", "1", "[1]"),
        "Qh(1,Au,,)": ("C0", "z", "[0,1,0]"),
        "Qh(1,Eua,,)": ("sqrt(2)*C1/2+sqrt(2)*I*S1/2", "sqrt(2)*(x+I*y)/2", "[-1,0,0]"),
        "Qh(1,Eub,,)": ("sqrt(2)*C1/2-sqrt(2)*I*S1/2", "sqrt(2)*(x-I*y)/2", "[0,0,1]"),
        "Qh(2,Ag,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(2,Ega,1,)": ("sqrt(2)*C1/2+sqrt(2)*I*S1/2", "sqrt(6)*z*(x+I*y)/2", "[0,-1,0,0,0]"),
        "Qh(2,Ega,2,)": ("sqrt(2)*C2/2-sqrt(2)*I*S2/2", "sqrt(6)*(x**2-2*I*x*y-y**2)/4", "[0,0,0,0,1]"),
        "Qh(2,Egb,1,)": ("sqrt(2)*C1/2-sqrt(2)*I*S1/2", "sqrt(6)*z*(x-I*y)/2", "[0,0,0,1,0]"),
        "Qh(2,Egb,2,)": ("sqrt(2)*C2/2+sqrt(2)*I*S2/2", "sqrt(6)*(x**2+2*I*x*y-y**2)/4", "[1,0,0,0,0]"),
        "Qh(3,Au,1,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(3,Au,2,)": ("S3", "sqrt(10)*y*(3*x**2-y**2)/4", "[sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(3,Au,3,)": ("C3", "sqrt(10)*x*(x**2-3*y**2)/4", "[-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(3,Eua,1,)": ("sqrt(2)*C1/2+sqrt(2)*I*S1/2", "-sqrt(3)*(x+I*y)*(x**2+y**2-4*z**2)/4", "[0,0,-1,0,0,0,0]"),
        "Qh(3,Eua,2,)": ("sqrt(2)*C2/2-sqrt(2)*I*S2/2", "sqrt(30)*z*(x**2-2*I*x*y-y**2)/4", "[0,0,0,0,0,1,0]"),
        "Qh(3,Eub,1,)": ("sqrt(2)*C1/2-sqrt(2)*I*S1/2", "-sqrt(3)*(x-I*y)*(x**2+y**2-4*z**2)/4", "[0,0,0,0,1,0,0]"),
        "Qh(3,Eub,2,)": ("sqrt(2)*C2/2+sqrt(2)*I*S2/2", "sqrt(30)*z*(x**2+2*I*x*y-y**2)/4", "[0,1,0,0,0,0,0]"),
        "Qh(4,Ag,1,)": ("C0", "3*x**4/8+3*x**2*y**2/4-3*x**2*z**2+3*y**4/8-3*y**2*z**2+z**4", "[0,0,0,0,1,0,0,0,0]"),
        "Qh(4,Ag,2,)": ("C3", "sqrt(70)*x*z*(x**2-3*y**2)/4", "[0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(4,Ag,3,)": ("S3", "sqrt(70)*y*z*(3*x**2-y**2)/4", "[0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(4,Ega,1,)": ("sqrt(2)*C1/2+sqrt(2)*I*S1/2", "-sqrt(5)*z*(x+I*y)*(3*x**2+3*y**2-4*z**2)/4", "[0,0,0,-1,0,0,0,0,0]"),
        "Qh(4,Ega,2,)": (
            "sqrt(2)*C4/2+sqrt(2)*I*S4/2",
            "sqrt(70)*(x**4+4*I*x**3*y-6*x**2*y**2-4*I*x*y**3+y**4)/16",
            "[1,0,0,0,0,0,0,0,0]",
        ),
        "Qh(4,Ega,3,)": (
            "sqrt(2)*C2/2-sqrt(2)*I*S2/2",
            "-sqrt(10)*(x**2+y**2-6*z**2)*(x**2-2*I*x*y-y**2)/8",
            "[0,0,0,0,0,0,1,0,0]",
        ),
        "Qh(4,Egb,1,)": ("sqrt(2)*C1/2-sqrt(2)*I*S1/2", "-sqrt(5)*z*(x-I*y)*(3*x**2+3*y**2-4*z**2)/4", "[0,0,0,0,0,1,0,0,0]"),
        "Qh(4,Egb,2,)": (
            "sqrt(2)*C4/2-sqrt(2)*I*S4/2",
            "sqrt(70)*(x**4-4*I*x**3*y-6*x**2*y**2+4*I*x*y**3+y**4)/16",
            "[0,0,0,0,0,0,0,0,1]",
        ),
        "Qh(4,Egb,3,)": (
            "sqrt(2)*C2/2+sqrt(2)*I*S2/2",
            "-sqrt(10)*(x**2+y**2-6*z**2)*(x**2+2*I*x*y-y**2)/8",
            "[0,0,1,0,0,0,0,0,0]",
        ),
        "Qh(5,Au,1,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(5,Au,2,)": ("S3", "-sqrt(70)*y*(3*x**2-y**2)*(x**2+y**2-8*z**2)/16", "[0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(5,Au,3,)": ("C3", "-sqrt(70)*x*(x**2-3*y**2)*(x**2+y**2-8*z**2)/16", "[0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0]"),
        "Qh(5,Eua,1,)": (
            "sqrt(2)*C5/2-sqrt(2)*I*S5/2",
            "3*sqrt(7)*(x**5-5*I*x**4*y-10*x**3*y**2+10*I*x**2*y**3+5*x*y**4-I*y**5)/16",
            "[0,0,0,0,0,0,0,0,0,0,1]",
        ),
        "Qh(5,Eua,2,)": (
            "sqrt(2)*C1/2+sqrt(2)*I*S1/2",
            "sqrt(30)*(x+I*y)*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/16",
            "[0,0,0,0,-1,0,0,0,0,0,0]",
        ),
        "Qh(5,Eua,3,)": (
            "sqrt(2)*C4/2+sqrt(2)*I*S4/2",
            "3*sqrt(70)*z*(x**4+4*I*x**3*y-6*x**2*y**2-4*I*x*y**3+y**4)/16",
            "[0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(5,Eua,4,)": (
            "sqrt(2)*C2/2-sqrt(2)*I*S2/2",
            "-sqrt(210)*z*(x**2+y**2-2*z**2)*(x**2-2*I*x*y-y**2)/8",
            "[0,0,0,0,0,0,0,1,0,0,0]",
        ),
        "Qh(5,Eub,1,)": (
            "sqrt(2)*C5/2+sqrt(2)*I*S5/2",
            "3*sqrt(7)*(x**5+5*I*x**4*y-10*x**3*y**2-10*I*x**2*y**3+5*x*y**4+I*y**5)/16",
            "[-1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(5,Eub,2,)": (
            "sqrt(2)*C1/2-sqrt(2)*I*S1/2",
            "sqrt(30)*(x-I*y)*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/16",
            "[0,0,0,0,0,0,1,0,0,0,0]",
        ),
        "Qh(5,Eub,3,)": (
            "sqrt(2)*C4/2-sqrt(2)*I*S4/2",
            "3*sqrt(70)*z*(x**4-4*I*x**3*y-6*x**2*y**2+4*I*x*y**3+y**4)/16",
            "[0,0,0,0,0,0,0,0,0,1,0]",
        ),
        "Qh(5,Eub,4,)": (
            "sqrt(2)*C2/2+sqrt(2)*I*S2/2",
            "-sqrt(210)*z*(x**2+y**2-2*z**2)*(x**2+2*I*x*y-y**2)/8",
            "[0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(6,Ag,1,)": (
            "C0",
            "-5*x**6/16-15*x**4*y**2/16+45*x**4*z**2/8-15*x**2*y**4/16+45*x**2*y**2*z**2/4-15*x**2*z**4/2-5*y**6/16+45*y**4*z**2/8-15*y**2*z**4/2+z**6",
            "[0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Qh(6,Ag,2,)": (
            "C6",
            "sqrt(462)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(6,Ag,3,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(6,Ag,4,)": (
            "C3",
            "-sqrt(210)*x*z*(x**2-3*y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(6,Ag,5,)": (
            "S3",
            "-sqrt(210)*y*z*(3*x**2-y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(6,Ega,1,)": (
            "sqrt(2)*C5/2-sqrt(2)*I*S5/2",
            "3*sqrt(77)*z*(x**5-5*I*x**4*y-10*x**3*y**2+10*I*x**2*y**3+5*x*y**4-I*y**5)/16",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0]",
        ),
        "Qh(6,Ega,2,)": (
            "sqrt(2)*C1/2+sqrt(2)*I*S1/2",
            "sqrt(42)*z*(x+I*y)*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/16",
            "[0,0,0,0,0,-1,0,0,0,0,0,0,0]",
        ),
        "Qh(6,Ega,3,)": (
            "sqrt(2)*C4/2+sqrt(2)*I*S4/2",
            "-3*sqrt(14)*(x**2+y**2-10*z**2)*(x**4+4*I*x**3*y-6*x**2*y**2-4*I*x*y**3+y**4)/32",
            "[0,0,1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(6,Ega,4,)": (
            "sqrt(2)*C2/2-sqrt(2)*I*S2/2",
            "sqrt(105)*(x**2-2*I*x*y-y**2)*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,0,0,0,1,0,0,0,0]",
        ),
        "Qh(6,Egb,1,)": (
            "sqrt(2)*C5/2+sqrt(2)*I*S5/2",
            "3*sqrt(77)*z*(x**5+5*I*x**4*y-10*x**3*y**2-10*I*x**2*y**3+5*x*y**4+I*y**5)/16",
            "[0,-1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(6,Egb,2,)": (
            "sqrt(2)*C1/2-sqrt(2)*I*S1/2",
            "sqrt(42)*z*(x-I*y)*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0]",
        ),
        "Qh(6,Egb,3,)": (
            "sqrt(2)*C4/2-sqrt(2)*I*S4/2",
            "-3*sqrt(14)*(x**2+y**2-10*z**2)*(x**4-4*I*x**3*y-6*x**2*y**2+4*I*x*y**3+y**4)/32",
            "[0,0,0,0,0,0,0,0,0,0,1,0,0]",
        ),
        "Qh(6,Egb,4,)": (
            "sqrt(2)*C2/2+sqrt(2)*I*S2/2",
            "sqrt(105)*(x**2+2*I*x*y-y**2)*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,1,0,0,0,0,0,0,0,0]",
        ),
        "Qh(7,Au,1,)": (
            "S6",
            "sqrt(6006)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(7,Au,2,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(7,Au,3,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(7,Au,4,)": (
            "S3",
            "sqrt(21)*y*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(7,Au,5,)": (
            "C3",
            "sqrt(21)*x*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(7,Eua,1,)": (
            "sqrt(2)*C7/2+sqrt(2)*I*S7/2",
            "sqrt(858)*(x**7+7*I*x**6*y-21*x**5*y**2-35*I*x**4*y**3+35*x**3*y**4+21*I*x**2*y**5-7*x*y**6-I*y**7)/64",
            "[-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(7,Eua,2,)": (
            "sqrt(2)*C5/2-sqrt(2)*I*S5/2",
            "-sqrt(462)*(x**2+y**2-12*z**2)*(x**5-5*I*x**4*y-10*x**3*y**2+10*I*x**2*y**3+5*x*y**4-I*y**5)/64",
            "[0,0,0,0,0,0,0,0,0,0,0,0,1,0,0]",
        ),
        "Qh(7,Eua,3,)": (
            "sqrt(2)*C1/2+sqrt(2)*I*S1/2",
            "-sqrt(14)*(x+I*y)*(5*x**6+15*x**4*y**2-120*x**4*z**2+15*x**2*y**4-240*x**2*y**2*z**2+240*x**2*z**4+5*y**6-120*y**4*z**2+240*y**2*z**4-64*z**6)/64",
            "[0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0]",
        ),
        "Qh(7,Eua,4,)": (
            "sqrt(2)*C4/2+sqrt(2)*I*S4/2",
            "-sqrt(462)*z*(3*x**2+3*y**2-10*z**2)*(x**4+4*I*x**3*y-6*x**2*y**2-4*I*x*y**3+y**4)/32",
            "[0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(7,Eua,5,)": (
            "sqrt(2)*C2/2-sqrt(2)*I*S2/2",
            "sqrt(21)*z*(x**2-2*I*x*y-y**2)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0]",
        ),
        "Qh(7,Eub,1,)": (
            "sqrt(2)*C7/2-sqrt(2)*I*S7/2",
            "sqrt(858)*(x**7-7*I*x**6*y-21*x**5*y**2+35*I*x**4*y**3+35*x**3*y**4-21*I*x**2*y**5-7*x*y**6+I*y**7)/64",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,1]",
        ),
        "Qh(7,Eub,2,)": (
            "sqrt(2)*C5/2+sqrt(2)*I*S5/2",
            "-sqrt(462)*(x**2+y**2-12*z**2)*(x**5+5*I*x**4*y-10*x**3*y**2-10*I*x**2*y**3+5*x*y**4+I*y**5)/64",
            "[0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(7,Eub,3,)": (
            "sqrt(2)*C1/2-sqrt(2)*I*S1/2",
            "-sqrt(14)*(x-I*y)*(5*x**6+15*x**4*y**2-120*x**4*z**2+15*x**2*y**4-240*x**2*y**2*z**2+240*x**2*z**4+5*y**6-120*y**4*z**2+240*y**2*z**4-64*z**6)/64",
            "[0,0,0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Qh(7,Eub,4,)": (
            "sqrt(2)*C4/2-sqrt(2)*I*S4/2",
            "-sqrt(462)*z*(3*x**2+3*y**2-10*z**2)*(x**4-4*I*x**3*y-6*x**2*y**2+4*I*x*y**3+y**4)/32",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0]",
        ),
        "Qh(7,Eub,5,)": (
            "sqrt(2)*C2/2+sqrt(2)*I*S2/2",
            "sqrt(21)*z*(x**2+2*I*x*y-y**2)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(8,Ag,1,)": (
            "C0",
            "35*x**8/128+35*x**6*y**2/32-35*x**6*z**2/4+105*x**4*y**4/64-105*x**4*y**2*z**2/4+105*x**4*z**4/4+35*x**2*y**6/32-105*x**2*y**4*z**2/4+105*x**2*y**2*z**4/2-14*x**2*z**6+35*y**8/128-35*y**6*z**2/4+105*y**4*z**4/4-14*y**2*z**6+z**8",
            "[0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0]",
        ),
        "Qh(8,Ag,2,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(8,Ag,3,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(8,Ag,4,)": (
            "C3",
            "sqrt(1155)*x*z*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(8,Ag,5,)": (
            "S3",
            "sqrt(1155)*y*z*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(8,Ega,1,)": (
            "sqrt(2)*C7/2+sqrt(2)*I*S7/2",
            "3*sqrt(1430)*z*(x**7+7*I*x**6*y-21*x**5*y**2-35*I*x**4*y**3+35*x**3*y**4+21*I*x**2*y**5-7*x*y**6-I*y**7)/64",
            "[0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(8,Ega,2,)": (
            "sqrt(2)*C5/2-sqrt(2)*I*S5/2",
            "-3*sqrt(2002)*z*(x**2+y**2-4*z**2)*(x**5-5*I*x**4*y-10*x**3*y**2+10*I*x**2*y**3+5*x*y**4-I*y**5)/64",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0]",
        ),
        "Qh(8,Ega,3,)": (
            "sqrt(2)*C1/2+sqrt(2)*I*S1/2",
            "-3*sqrt(2)*z*(x+I*y)*(35*x**6+105*x**4*y**2-280*x**4*z**2+105*x**2*y**4-560*x**2*y**2*z**2+336*x**2*z**4+35*y**6-280*y**4*z**2+336*y**2*z**4-64*z**6)/64",
            "[0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(8,Ega,4,)": (
            "sqrt(2)*C8/2-sqrt(2)*I*S8/2",
            "3*sqrt(1430)*(x**8-8*I*x**7*y-28*x**6*y**2+56*I*x**5*y**3+70*x**4*y**4-56*I*x**3*y**5-28*x**2*y**6+8*I*x*y**7+y**8)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1]",
        ),
        "Qh(8,Ega,5,)": (
            "sqrt(2)*C4/2+sqrt(2)*I*S4/2",
            "3*sqrt(154)*(x**4+4*I*x**3*y-6*x**2*y**2-4*I*x*y**3+y**4)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/128",
            "[0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(8,Ega,6,)": (
            "sqrt(2)*C2/2-sqrt(2)*I*S2/2",
            "-3*sqrt(35)*(x**2-2*I*x*y-y**2)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Qh(8,Egb,1,)": (
            "sqrt(2)*C7/2-sqrt(2)*I*S7/2",
            "3*sqrt(1430)*z*(x**7-7*I*x**6*y-21*x**5*y**2+35*I*x**4*y**3+35*x**3*y**4-21*I*x**2*y**5-7*x*y**6+I*y**7)/64",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0]",
        ),
        "Qh(8,Egb,2,)": (
            "sqrt(2)*C5/2+sqrt(2)*I*S5/2",
            "-3*sqrt(2002)*z*(x**2+y**2-4*z**2)*(x**5+5*I*x**4*y-10*x**3*y**2-10*I*x**2*y**3+5*x*y**4+I*y**5)/64",
            "[0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(8,Egb,3,)": (
            "sqrt(2)*C1/2-sqrt(2)*I*S1/2",
            "-3*sqrt(2)*z*(x-I*y)*(35*x**6+105*x**4*y**2-280*x**4*z**2+105*x**2*y**4-560*x**2*y**2*z**2+336*x**2*z**4+35*y**6-280*y**4*z**2+336*y**2*z**4-64*z**6)/64",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(8,Egb,4,)": (
            "sqrt(2)*C8/2+sqrt(2)*I*S8/2",
            "3*sqrt(1430)*(x**8+8*I*x**7*y-28*x**6*y**2-56*I*x**5*y**3+70*x**4*y**4+56*I*x**3*y**5-28*x**2*y**6-8*I*x*y**7+y**8)/256",
            "[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(8,Egb,5,)": (
            "sqrt(2)*C4/2-sqrt(2)*I*S4/2",
            "3*sqrt(154)*(x**4-4*I*x**3*y-6*x**2*y**2+4*I*x*y**3+y**4)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/128",
            "[0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0]",
        ),
        "Qh(8,Egb,6,)": (
            "sqrt(2)*C2/2+sqrt(2)*I*S2/2",
            "-3*sqrt(35)*(x**2+2*I*x*y-y**2)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Au,1,)": (
            "S6",
            "-sqrt(4290)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**2+3*y**2-14*z**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(9,Au,2,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Au,3,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,Au,4,)": (
            "S9",
            "sqrt(24310)*y*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(9,Au,5,)": (
            "S3",
            "-sqrt(2310)*y*(3*x**2-y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,Au,6,)": (
            "C9",
            "sqrt(24310)*x*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(9,Au,7,)": (
            "C3",
            "-sqrt(2310)*x*(x**2-3*y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(9,Eua,1,)": (
            "sqrt(2)*C7/2+sqrt(2)*I*S7/2",
            "-3*sqrt(715)*(x**2+y**2-16*z**2)*(x**7+7*I*x**6*y-21*x**5*y**2-35*I*x**4*y**3+35*x**3*y**4+21*I*x**2*y**5-7*x*y**6-I*y**7)/256",
            "[0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Eua,2,)": (
            "sqrt(2)*C5/2-sqrt(2)*I*S5/2",
            "3*sqrt(143)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)*(x**5-5*I*x**4*y-10*x**3*y**2+10*I*x**2*y**3+5*x*y**4-I*y**5)/128",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0]",
        ),
        "Qh(9,Eua,3,)": (
            "sqrt(2)*C1/2+sqrt(2)*I*S1/2",
            "3*sqrt(10)*(x+I*y)*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Eua,4,)": (
            "sqrt(2)*C8/2-sqrt(2)*I*S8/2",
            "3*sqrt(24310)*z*(x**8-8*I*x**7*y-28*x**6*y**2+56*I*x**5*y**3+70*x**4*y**4-56*I*x**3*y**5-28*x**2*y**6+8*I*x*y**7+y**8)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0]",
        ),
        "Qh(9,Eua,5,)": (
            "sqrt(2)*C4/2+sqrt(2)*I*S4/2",
            "3*sqrt(10010)*z*(x**4+4*I*x**3*y-6*x**2*y**2-4*I*x*y**3+y**4)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/128",
            "[0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Eua,6,)": (
            "sqrt(2)*C2/2-sqrt(2)*I*S2/2",
            "-3*sqrt(55)*z*(x**2-2*I*x*y-y**2)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Eub,1,)": (
            "sqrt(2)*C7/2-sqrt(2)*I*S7/2",
            "-3*sqrt(715)*(x**2+y**2-16*z**2)*(x**7-7*I*x**6*y-21*x**5*y**2+35*I*x**4*y**3+35*x**3*y**4-21*I*x**2*y**5-7*x*y**6+I*y**7)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0]",
        ),
        "Qh(9,Eub,2,)": (
            "sqrt(2)*C5/2+sqrt(2)*I*S5/2",
            "3*sqrt(143)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)*(x**5+5*I*x**4*y-10*x**3*y**2-10*I*x**2*y**3+5*x*y**4+I*y**5)/128",
            "[0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Eub,3,)": (
            "sqrt(2)*C1/2-sqrt(2)*I*S1/2",
            "3*sqrt(10)*(x-I*y)*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Eub,4,)": (
            "sqrt(2)*C8/2+sqrt(2)*I*S8/2",
            "3*sqrt(24310)*z*(x**8+8*I*x**7*y-28*x**6*y**2-56*I*x**5*y**3+70*x**4*y**4+56*I*x**3*y**5-28*x**2*y**6-8*I*x*y**7+y**8)/256",
            "[0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,Eub,5,)": (
            "sqrt(2)*C4/2-sqrt(2)*I*S4/2",
            "3*sqrt(10010)*z*(x**4-4*I*x**3*y-6*x**2*y**2+4*I*x*y**3+y**4)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/128",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0]",
        ),
        "Qh(9,Eub,6,)": (
            "sqrt(2)*C2/2+sqrt(2)*I*S2/2",
            "-3*sqrt(55)*z*(x**2+2*I*x*y-y**2)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Ag,1,)": (
            "C0",
            "-63*x**10/256-315*x**8*y**2/256+1575*x**8*z**2/128-315*x**6*y**4/128+1575*x**6*y**2*z**2/32-525*x**6*z**4/8-315*x**4*y**6/128+4725*x**4*y**4*z**2/64-1575*x**4*y**2*z**4/8+315*x**4*z**6/4-315*x**2*y**8/256+1575*x**2*y**6*z**2/32-1575*x**2*y**4*z**4/8+315*x**2*y**2*z**6/2-45*x**2*z**8/2-63*y**10/256+1575*y**8*z**2/128-525*y**6*z**4/8+315*y**4*z**6/4-45*y**2*z**8/2+z**10",
            "[0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Ag,2,)": (
            "C6",
            "sqrt(4290)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(10,Ag,3,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,Ag,4,)": (
            "C9",
            "sqrt(461890)*x*z*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(10,Ag,5,)": (
            "C3",
            "-sqrt(4290)*x*z*(x**2-3*y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Ag,6,)": (
            "S9",
            "sqrt(461890)*y*z*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(10,Ag,7,)": (
            "S3",
            "-sqrt(4290)*y*z*(3*x**2-y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Ega,1,)": (
            "sqrt(2)*C7/2+sqrt(2)*I*S7/2",
            "-sqrt(36465)*z*(3*x**2+3*y**2-16*z**2)*(x**7+7*I*x**6*y-21*x**5*y**2-35*I*x**4*y**3+35*x**3*y**4+21*I*x**2*y**5-7*x*y**6-I*y**7)/256",
            "[0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Ega,2,)": (
            "sqrt(2)*C5/2-sqrt(2)*I*S5/2",
            "sqrt(429)*z*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)*(x**5-5*I*x**4*y-10*x**3*y**2+10*I*x**2*y**3+5*x*y**4-I*y**5)/128",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0]",
        ),
        "Qh(10,Ega,3,)": (
            "sqrt(2)*C1/2+sqrt(2)*I*S1/2",
            "sqrt(110)*z*(x+I*y)*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Ega,4,)": (
            "sqrt(2)*C10/2+sqrt(2)*I*S10/2",
            "sqrt(46189)*(x**10+10*I*x**9*y-45*x**8*y**2-120*I*x**7*y**3+210*x**6*y**4+252*I*x**5*y**5-210*x**4*y**6-120*I*x**3*y**7+45*x**2*y**8+10*I*x*y**9-y**10)/512",
            "[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Ega,5,)": (
            "sqrt(2)*C8/2-sqrt(2)*I*S8/2",
            "-sqrt(24310)*(x**2+y**2-18*z**2)*(x**8-8*I*x**7*y-28*x**6*y**2+56*I*x**5*y**3+70*x**4*y**4-56*I*x**3*y**5-28*x**2*y**6+8*I*x*y**7+y**8)/512",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0]",
        ),
        "Qh(10,Ega,6,)": (
            "sqrt(2)*C4/2+sqrt(2)*I*S4/2",
            "-sqrt(4290)*(x**4+4*I*x**3*y-6*x**2*y**2-4*I*x*y**3+y**4)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/256",
            "[0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Ega,7,)": (
            "sqrt(2)*C2/2-sqrt(2)*I*S2/2",
            "sqrt(330)*(x**2-2*I*x*y-y**2)*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/512",
            "[0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Egb,1,)": (
            "sqrt(2)*C7/2-sqrt(2)*I*S7/2",
            "-sqrt(36465)*z*(3*x**2+3*y**2-16*z**2)*(x**7-7*I*x**6*y-21*x**5*y**2+35*I*x**4*y**3+35*x**3*y**4-21*I*x**2*y**5-7*x*y**6+I*y**7)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0]",
        ),
        "Qh(10,Egb,2,)": (
            "sqrt(2)*C5/2+sqrt(2)*I*S5/2",
            "sqrt(429)*z*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)*(x**5+5*I*x**4*y-10*x**3*y**2-10*I*x**2*y**3+5*x*y**4+I*y**5)/128",
            "[0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Egb,3,)": (
            "sqrt(2)*C1/2-sqrt(2)*I*S1/2",
            "sqrt(110)*z*(x-I*y)*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Egb,4,)": (
            "sqrt(2)*C10/2-sqrt(2)*I*S10/2",
            "sqrt(46189)*(x**10-10*I*x**9*y-45*x**8*y**2+120*I*x**7*y**3+210*x**6*y**4-252*I*x**5*y**5-210*x**4*y**6+120*I*x**3*y**7+45*x**2*y**8-10*I*x*y**9-y**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1]",
        ),
        "Qh(10,Egb,5,)": (
            "sqrt(2)*C8/2+sqrt(2)*I*S8/2",
            "-sqrt(24310)*(x**2+y**2-18*z**2)*(x**8+8*I*x**7*y-28*x**6*y**2-56*I*x**5*y**3+70*x**4*y**4+56*I*x**3*y**5-28*x**2*y**6-8*I*x*y**7+y**8)/512",
            "[0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,Egb,6,)": (
            "sqrt(2)*C4/2-sqrt(2)*I*S4/2",
            "-sqrt(4290)*(x**4-4*I*x**3*y-6*x**2*y**2+4*I*x*y**3+y**4)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Qh(10,Egb,7,)": (
            "sqrt(2)*C2/2+sqrt(2)*I*S2/2",
            "sqrt(330)*(x**2+2*I*x*y-y**2)*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/512",
            "[0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Au,1,)": (
            "S6",
            "sqrt(14586)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(11,Au,2,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Au,3,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,Au,4,)": (
            "S9",
            "-sqrt(46189)*y*(3*x**2-y**2)*(x**2+y**2-20*z**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/512",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(11,Au,5,)": (
            "S3",
            "sqrt(30030)*y*(3*x**2-y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Au,6,)": (
            "C9",
            "-sqrt(46189)*x*(x**2-3*y**2)*(x**2+y**2-20*z**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/512",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(11,Au,7,)": (
            "C3",
            "sqrt(30030)*x*(x**2-3*y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eua,1,)": (
            "sqrt(2)*C11/2-sqrt(2)*I*S11/2",
            "sqrt(176358)*(x**11-11*I*x**10*y-55*x**9*y**2+165*I*x**8*y**3+330*x**7*y**4-462*I*x**6*y**5-462*x**5*y**6+330*I*x**4*y**7+165*x**3*y**8-55*I*x**2*y**9-11*x*y**10+I*y**11)/1024",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1]",
        ),
        "Qh(11,Eua,2,)": (
            "sqrt(2)*C7/2+sqrt(2)*I*S7/2",
            "sqrt(72930)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)*(x**7+7*I*x**6*y-21*x**5*y**2-35*I*x**4*y**3+35*x**3*y**4+21*I*x**2*y**5-7*x*y**6-I*y**7)/1024",
            "[0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eua,3,)": (
            "sqrt(2)*C5/2-sqrt(2)*I*S5/2",
            "-3*sqrt(286)*(x**5-5*I*x**4*y-10*x**3*y**2+10*I*x**2*y**3+5*x*y**4-I*y**5)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/1024",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Qh(11,Eua,4,)": (
            "sqrt(2)*C1/2+sqrt(2)*I*S1/2",
            "-sqrt(33)*(x+I*y)*(21*x**10+105*x**8*y**2-1260*x**8*z**2+210*x**6*y**4-5040*x**6*y**2*z**2+8400*x**6*z**4+210*x**4*y**6-7560*x**4*y**4*z**2+25200*x**4*y**2*z**4-13440*x**4*z**6+105*x**2*y**8-5040*x**2*y**6*z**2+25200*x**2*y**4*z**4-26880*x**2*y**2*z**6+5760*x**2*z**8+21*y**10-1260*y**8*z**2+8400*y**6*z**4-13440*y**4*z**6+5760*y**2*z**8-512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eua,5,)": (
            "sqrt(2)*C10/2+sqrt(2)*I*S10/2",
            "sqrt(969969)*z*(x**10+10*I*x**9*y-45*x**8*y**2-120*I*x**7*y**3+210*x**6*y**4+252*I*x**5*y**5-210*x**4*y**6-120*I*x**3*y**7+45*x**2*y**8+10*I*x*y**9-y**10)/512",
            "[0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eua,6,)": (
            "sqrt(2)*C8/2-sqrt(2)*I*S8/2",
            "-sqrt(1385670)*z*(x**2+y**2-6*z**2)*(x**8-8*I*x**7*y-28*x**6*y**2+56*I*x**5*y**3+70*x**4*y**4-56*I*x**3*y**5-28*x**2*y**6+8*I*x*y**7+y**8)/512",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0]",
        ),
        "Qh(11,Eua,7,)": (
            "sqrt(2)*C4/2+sqrt(2)*I*S4/2",
            "-3*sqrt(2002)*z*(x**4+4*I*x**3*y-6*x**2*y**2-4*I*x*y**3+y**4)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/256",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eua,8,)": (
            "sqrt(2)*C2/2-sqrt(2)*I*S2/2",
            "sqrt(4290)*z*(x**2-2*I*x*y-y**2)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eub,1,)": (
            "sqrt(2)*C11/2+sqrt(2)*I*S11/2",
            "sqrt(176358)*(x**11+11*I*x**10*y-55*x**9*y**2-165*I*x**8*y**3+330*x**7*y**4+462*I*x**6*y**5-462*x**5*y**6-330*I*x**4*y**7+165*x**3*y**8+55*I*x**2*y**9-11*x*y**10-I*y**11)/1024",
            "[-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eub,2,)": (
            "sqrt(2)*C7/2-sqrt(2)*I*S7/2",
            "sqrt(72930)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)*(x**7-7*I*x**6*y-21*x**5*y**2+35*I*x**4*y**3+35*x**3*y**4-21*I*x**2*y**5-7*x*y**6+I*y**7)/1024",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0]",
        ),
        "Qh(11,Eub,3,)": (
            "sqrt(2)*C5/2+sqrt(2)*I*S5/2",
            "-3*sqrt(286)*(x**5+5*I*x**4*y-10*x**3*y**2-10*I*x**2*y**3+5*x*y**4+I*y**5)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/1024",
            "[0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eub,4,)": (
            "sqrt(2)*C1/2-sqrt(2)*I*S1/2",
            "-sqrt(33)*(x-I*y)*(21*x**10+105*x**8*y**2-1260*x**8*z**2+210*x**6*y**4-5040*x**6*y**2*z**2+8400*x**6*z**4+210*x**4*y**6-7560*x**4*y**4*z**2+25200*x**4*y**2*z**4-13440*x**4*z**6+105*x**2*y**8-5040*x**2*y**6*z**2+25200*x**2*y**4*z**4-26880*x**2*y**2*z**6+5760*x**2*z**8+21*y**10-1260*y**8*z**2+8400*y**6*z**4-13440*y**4*z**6+5760*y**2*z**8-512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eub,5,)": (
            "sqrt(2)*C10/2-sqrt(2)*I*S10/2",
            "sqrt(969969)*z*(x**10-10*I*x**9*y-45*x**8*y**2+120*I*x**7*y**3+210*x**6*y**4-252*I*x**5*y**5-210*x**4*y**6+120*I*x**3*y**7+45*x**2*y**8-10*I*x*y**9-y**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0]",
        ),
        "Qh(11,Eub,6,)": (
            "sqrt(2)*C8/2+sqrt(2)*I*S8/2",
            "-sqrt(1385670)*z*(x**2+y**2-6*z**2)*(x**8+8*I*x**7*y-28*x**6*y**2-56*I*x**5*y**3+70*x**4*y**4+56*I*x**3*y**5-28*x**2*y**6-8*I*x*y**7+y**8)/512",
            "[0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eub,7,)": (
            "sqrt(2)*C4/2-sqrt(2)*I*S4/2",
            "-3*sqrt(2002)*z*(x**4-4*I*x**3*y-6*x**2*y**2+4*I*x*y**3+y**4)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(11,Eub,8,)": (
            "sqrt(2)*C2/2+sqrt(2)*I*S2/2",
            "sqrt(4290)*z*(x**2+2*I*x*y-y**2)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0]",
        ),
    },
    "D3": {
        "Qh(0,A1,,)": ("C0", "1", "[1]"),
        "Qh(2,A1,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(3,A1,,)": ("S3", "sqrt(10)*y*(3*x**2-y**2)/4", "[sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(5,A1,,)": ("S3", "-sqrt(70)*y*(3*x**2-y**2)*(x**2+y**2-8*z**2)/16", "[0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(4,A1,1,)": ("C0", "3*x**4/8+3*x**2*y**2/4-3*x**2*z**2+3*y**4/8-3*y**2*z**2+z**4", "[0,0,0,0,1,0,0,0,0]"),
        "Qh(6,A1,1,)": (
            "C0",
            "-5*x**6/16-15*x**4*y**2/16+45*x**4*z**2/8-15*x**2*y**4/16+45*x**2*y**2*z**2/4-15*x**2*z**4/2-5*y**6/16+45*y**4*z**2/8-15*y**2*z**4/2+z**6",
            "[0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Qh(7,A1,1,)": (
            "S6",
            "sqrt(6006)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(8,A1,1,)": (
            "C0",
            "35*x**8/128+35*x**6*y**2/32-35*x**6*z**2/4+105*x**4*y**4/64-105*x**4*y**2*z**2/4+105*x**4*z**4/4+35*x**2*y**6/32-105*x**2*y**4*z**2/4+105*x**2*y**2*z**4/2-14*x**2*z**6+35*y**8/128-35*y**6*z**2/4+105*y**4*z**4/4-14*y**2*z**6+z**8",
            "[0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,A1,1,)": (
            "S6",
            "-sqrt(4290)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**2+3*y**2-14*z**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(10,A1,1,)": (
            "C0",
            "-63*x**10/256-315*x**8*y**2/256+1575*x**8*z**2/128-315*x**6*y**4/128+1575*x**6*y**2*z**2/32-525*x**6*z**4/8-315*x**4*y**6/128+4725*x**4*y**4*z**2/64-1575*x**4*y**2*z**4/8+315*x**4*z**6/4-315*x**2*y**8/256+1575*x**2*y**6*z**2/32-1575*x**2*y**4*z**4/8+315*x**2*y**2*z**6/2-45*x**2*z**8/2-63*y**10/256+1575*y**8*z**2/128-525*y**6*z**4/8+315*y**4*z**6/4-45*y**2*z**8/2+z**10",
            "[0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A1,1,)": (
            "S6",
            "sqrt(14586)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(4,A1,2,)": ("C3", "sqrt(70)*x*z*(x**2-3*y**2)/4", "[0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(6,A1,2,)": (
            "C6",
            "sqrt(462)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(7,A1,2,)": (
            "S3",
            "sqrt(21)*y*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(8,A1,2,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,A1,2,)": (
            "S9",
            "sqrt(24310)*y*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(10,A1,2,)": (
            "C6",
            "sqrt(4290)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(11,A1,2,)": (
            "S9",
            "-sqrt(46189)*y*(3*x**2-y**2)*(x**2+y**2-20*z**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/512",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(6,A1,3,)": (
            "C3",
            "-sqrt(210)*x*z*(x**2-3*y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(8,A1,3,)": (
            "C3",
            "sqrt(1155)*x*z*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(9,A1,3,)": (
            "S3",
            "-sqrt(2310)*y*(3*x**2-y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(10,A1,3,)": (
            "C9",
            "sqrt(461890)*x*z*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(11,A1,3,)": (
            "S3",
            "sqrt(30030)*y*(3*x**2-y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A1,4,)": (
            "C3",
            "-sqrt(4290)*x*z*(x**2-3*y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(1,A2,,)": ("C0", "z", "[0,1,0]"),
        "Qh(4,A2,,)": ("S3", "sqrt(70)*y*z*(3*x**2-y**2)/4", "[0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(3,A2,1,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(5,A2,1,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(6,A2,1,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(7,A2,1,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(8,A2,1,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(9,A2,1,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A2,1,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(11,A2,1,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(3,A2,2,)": ("C3", "sqrt(10)*x*(x**2-3*y**2)/4", "[-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(5,A2,2,)": ("C3", "-sqrt(70)*x*(x**2-3*y**2)*(x**2+y**2-8*z**2)/16", "[0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0]"),
        "Qh(6,A2,2,)": (
            "S3",
            "-sqrt(210)*y*z*(3*x**2-y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(7,A2,2,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(8,A2,2,)": (
            "S3",
            "sqrt(1155)*y*z*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(9,A2,2,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(10,A2,2,)": (
            "S9",
            "sqrt(461890)*y*z*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(11,A2,2,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(7,A2,3,)": (
            "C3",
            "sqrt(21)*x*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(9,A2,3,)": (
            "C9",
            "sqrt(24310)*x*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(10,A2,3,)": (
            "S3",
            "-sqrt(4290)*y*z*(3*x**2-y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A2,3,)": (
            "C9",
            "-sqrt(46189)*x*(x**2-3*y**2)*(x**2+y**2-20*z**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/512",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,A2,4,)": (
            "C3",
            "-sqrt(2310)*x*(x**2-3*y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(11,A2,4,)": (
            "C3",
            "sqrt(30030)*x*(x**2-3*y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(1,E,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(1,E,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(2,E,1,0)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(2,E,1,1)": ("-C1", "-sqrt(3)*x*z", "[0,sqrt(2)/2,0,-sqrt(2)/2,0]"),
        "Qh(3,E,1,0)": ("C1", "-sqrt(6)*x*(x**2+y**2-4*z**2)/4", "[0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0]"),
        "Qh(3,E,1,1)": ("S1", "-sqrt(6)*y*(x**2+y**2-4*z**2)/4", "[0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0]"),
        "Qh(4,E,1,0)": ("S1", "-sqrt(10)*y*z*(3*x**2+3*y**2-4*z**2)/4", "[0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0]"),
        "Qh(4,E,1,1)": ("-C1", "sqrt(10)*x*z*(3*x**2+3*y**2-4*z**2)/4", "[0,0,0,sqrt(2)/2,0,-sqrt(2)/2,0,0,0]"),
        "Qh(5,E,1,0)": ("C5", "3*sqrt(14)*x*(x**4-10*x**2*y**2+5*y**4)/16", "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(5,E,1,1)": ("-S5", "-3*sqrt(14)*y*(5*x**4-10*x**2*y**2+y**4)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]"),
        "Qh(6,E,1,0)": (
            "-S5",
            "-3*sqrt(154)*y*z*(5*x**4-10*x**2*y**2+y**4)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Qh(6,E,1,1)": ("-C5", "-3*sqrt(154)*x*z*(x**4-10*x**2*y**2+5*y**4)/16", "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0]"),
        "Qh(7,E,1,0)": (
            "C7",
            "sqrt(429)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(7,E,1,1)": (
            "S7",
            "sqrt(429)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(8,E,1,0)": (
            "S7",
            "3*sqrt(715)*y*z*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(8,E,1,1)": (
            "-C7",
            "-3*sqrt(715)*x*z*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0]",
        ),
        "Qh(9,E,1,0)": (
            "C7",
            "-3*sqrt(1430)*x*(x**2+y**2-16*z**2)*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/256",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,E,1,1)": (
            "S7",
            "-3*sqrt(1430)*y*(x**2+y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(10,E,1,0)": (
            "S7",
            "-sqrt(72930)*y*z*(3*x**2+3*y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(10,E,1,1)": (
            "-C7",
            "sqrt(72930)*x*z*(3*x**2+3*y**2-16*z**2)*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0]",
        ),
        "Qh(11,E,1,0)": (
            "C11",
            "sqrt(88179)*x*(x**10-55*x**8*y**2+330*x**6*y**4-462*x**4*y**6+165*x**2*y**8-11*y**10)/512",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(11,E,1,1)": (
            "-S11",
            "-sqrt(88179)*y*(11*x**10-165*x**8*y**2+462*x**6*y**4-330*x**4*y**6+55*x**2*y**8-y**10)/512",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Qh(2,E,2,0)": ("-S2", "-sqrt(3)*x*y", "[sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2]"),
        "Qh(2,E,2,1)": ("-C2", "-sqrt(3)*(x-y)*(x+y)/2", "[-sqrt(2)/2,0,0,0,-sqrt(2)/2]"),
        "Qh(3,E,2,0)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(3,E,2,1)": ("-S2", "-sqrt(15)*x*y*z", "[0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0]"),
        "Qh(4,E,2,0)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(4,E,2,1)": ("-C4", "-sqrt(35)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[-sqrt(2)/2,0,0,0,0,0,0,0,-sqrt(2)/2]"),
        "Qh(5,E,2,0)": (
            "C1",
            "sqrt(15)*x*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(5,E,2,1)": (
            "S1",
            "sqrt(15)*y*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(6,E,2,0)": (
            "S1",
            "sqrt(21)*y*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(6,E,2,1)": (
            "-C1",
            "-sqrt(21)*x*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,sqrt(2)/2,0,-sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(7,E,2,0)": (
            "C5",
            "-sqrt(231)*x*(x**2+y**2-12*z**2)*(x**4-10*x**2*y**2+5*y**4)/32",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(7,E,2,1)": (
            "-S5",
            "sqrt(231)*y*(x**2+y**2-12*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Qh(8,E,2,0)": (
            "-S5",
            "3*sqrt(1001)*y*z*(x**2+y**2-4*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(8,E,2,1)": (
            "-C5",
            "3*sqrt(1001)*x*z*(x**2+y**2-4*z**2)*(x**4-10*x**2*y**2+5*y**4)/32",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,E,2,0)": (
            "C5",
            "3*sqrt(286)*x*(x**4-10*x**2*y**2+5*y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(9,E,2,1)": (
            "-S5",
            "-3*sqrt(286)*y*(5*x**4-10*x**2*y**2+y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,E,2,0)": (
            "-S5",
            "-sqrt(858)*y*z*(5*x**4-10*x**2*y**2+y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(10,E,2,1)": (
            "-C5",
            "-sqrt(858)*x*z*(x**4-10*x**2*y**2+5*y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,E,2,0)": (
            "C7",
            "sqrt(36465)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(11,E,2,1)": (
            "S7",
            "sqrt(36465)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(4,E,3,0)": ("-S2", "sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0]"),
        "Qh(4,E,3,1)": ("-C2", "sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Qh(5,E,3,0)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(5,E,3,1)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(6,E,3,0)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(6,E,3,1)": (
            "-C4",
            "3*sqrt(7)*(x**2+y**2-10*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,-sqrt(2)/2,0,0]",
        ),
        "Qh(7,E,3,0)": (
            "C1",
            "-sqrt(7)*x*(5*x**6+15*x**4*y**2-120*x**4*z**2+15*x**2*y**4-240*x**2*y**2*z**2+240*x**2*z**4+5*y**6-120*y**4*z**2+240*y**2*z**4-64*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(7,E,3,1)": (
            "S1",
            "-sqrt(7)*y*(5*x**6+15*x**4*y**2-120*x**4*z**2+15*x**2*y**4-240*x**2*y**2*z**2+240*x**2*z**4+5*y**6-120*y**4*z**2+240*y**2*z**4-64*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(8,E,3,0)": (
            "S1",
            "-3*y*z*(35*x**6+105*x**4*y**2-280*x**4*z**2+105*x**2*y**4-560*x**2*y**2*z**2+336*x**2*z**4+35*y**6-280*y**4*z**2+336*y**2*z**4-64*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(8,E,3,1)": (
            "-C1",
            "3*x*z*(35*x**6+105*x**4*y**2-280*x**4*z**2+105*x**2*y**4-560*x**2*y**2*z**2+336*x**2*z**4+35*y**6-280*y**4*z**2+336*y**2*z**4-64*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,-sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E,3,0)": (
            "C1",
            "3*sqrt(5)*x*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E,3,1)": (
            "S1",
            "3*sqrt(5)*y*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E,3,0)": (
            "S1",
            "sqrt(55)*y*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E,3,1)": (
            "-C1",
            "-sqrt(55)*x*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,3,0)": (
            "C5",
            "-3*sqrt(143)*x*(x**4-10*x**2*y**2+5*y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(11,E,3,1)": (
            "-S5",
            "3*sqrt(143)*y*(5*x**4-10*x**2*y**2+y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(5,E,4,0)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(5,E,4,1)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(6,E,4,0)": (
            "-S2",
            "-sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(6,E,4,1)": (
            "-C2",
            "-sqrt(210)*(x-y)*(x+y)*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(7,E,4,0)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(7,E,4,1)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(8,E,4,0)": (
            "-S8",
            "-3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Qh(8,E,4,1)": (
            "-C8",
            "-3*sqrt(715)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2]",
        ),
        "Qh(9,E,4,0)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,E,4,1)": (
            "-S8",
            "-3*sqrt(12155)*x*y*z*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Qh(10,E,4,0)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(10,E,4,1)": (
            "-C10",
            "-sqrt(92378)*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2]",
        ),
        "Qh(11,E,4,0)": (
            "C1",
            "-sqrt(66)*x*(21*x**10+105*x**8*y**2-1260*x**8*z**2+210*x**6*y**4-5040*x**6*y**2*z**2+8400*x**6*z**4+210*x**4*y**6-7560*x**4*y**4*z**2+25200*x**4*y**2*z**4-13440*x**4*z**6+105*x**2*y**8-5040*x**2*y**6*z**2+25200*x**2*y**4*z**4-26880*x**2*y**2*z**6+5760*x**2*z**8+21*y**10-1260*y**8*z**2+8400*y**6*z**4-13440*y**4*z**6+5760*y**2*z**8-512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,4,1)": (
            "S1",
            "-sqrt(66)*y*(21*x**10+105*x**8*y**2-1260*x**8*z**2+210*x**6*y**4-5040*x**6*y**2*z**2+8400*x**6*z**4+210*x**4*y**6-7560*x**4*y**4*z**2+25200*x**4*y**2*z**4-13440*x**4*z**6+105*x**2*y**8-5040*x**2*y**6*z**2+25200*x**2*y**4*z**4-26880*x**2*y**2*z**6+5760*x**2*z**8+21*y**10-1260*y**8*z**2+8400*y**6*z**4-13440*y**4*z**6+5760*y**2*z**8-512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(7,E,5,0)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(7,E,5,1)": (
            "-S2",
            "-sqrt(42)*x*y*z*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/16",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(8,E,5,0)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(8,E,5,1)": (
            "-C4",
            "-3*sqrt(77)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/64",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(9,E,5,0)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(9,E,5,1)": (
            "S4",
            "3*sqrt(5005)*x*y*z*(x-y)*(x+y)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/16",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(10,E,5,0)": (
            "-S8",
            "sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Qh(10,E,5,1)": (
            "-C8",
            "sqrt(12155)*(x**2+y**2-18*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0]",
        ),
        "Qh(11,E,5,0)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(11,E,5,1)": (
            "S10",
            "sqrt(1939938)*x*y*z*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(8,E,6,0)": (
            "-S2",
            "3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(8,E,6,1)": (
            "-C2",
            "3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(9,E,6,0)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E,6,1)": (
            "-S2",
            "3*sqrt(110)*x*y*z*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E,6,0)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(10,E,6,1)": (
            "-C4",
            "sqrt(2145)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/128",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(11,E,6,0)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(11,E,6,1)": (
            "-S8",
            "sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(10,E,7,0)": (
            "-S2",
            "-sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E,7,1)": (
            "-C2",
            "-sqrt(165)*(x-y)*(x+y)*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/256",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,7,0)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,7,1)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,8,0)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,8,1)": (
            "-S2",
            "-sqrt(2145)*x*y*z*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
    },
    "D3-1": {
        "Qh(0,A1,,)": ("C0", "1", "[1]"),
        "Qh(2,A1,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(3,A1,,)": ("C3", "sqrt(10)*x*(x**2-3*y**2)/4", "[-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(5,A1,,)": ("C3", "-sqrt(70)*x*(x**2-3*y**2)*(x**2+y**2-8*z**2)/16", "[0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0]"),
        "Qh(4,A1,1,)": ("C0", "3*x**4/8+3*x**2*y**2/4-3*x**2*z**2+3*y**4/8-3*y**2*z**2+z**4", "[0,0,0,0,1,0,0,0,0]"),
        "Qh(6,A1,1,)": (
            "C0",
            "-5*x**6/16-15*x**4*y**2/16+45*x**4*z**2/8-15*x**2*y**4/16+45*x**2*y**2*z**2/4-15*x**2*z**4/2-5*y**6/16+45*y**4*z**2/8-15*y**2*z**4/2+z**6",
            "[0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Qh(7,A1,1,)": (
            "S6",
            "sqrt(6006)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(8,A1,1,)": (
            "C0",
            "35*x**8/128+35*x**6*y**2/32-35*x**6*z**2/4+105*x**4*y**4/64-105*x**4*y**2*z**2/4+105*x**4*z**4/4+35*x**2*y**6/32-105*x**2*y**4*z**2/4+105*x**2*y**2*z**4/2-14*x**2*z**6+35*y**8/128-35*y**6*z**2/4+105*y**4*z**4/4-14*y**2*z**6+z**8",
            "[0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,A1,1,)": (
            "S6",
            "-sqrt(4290)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**2+3*y**2-14*z**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(10,A1,1,)": (
            "C0",
            "-63*x**10/256-315*x**8*y**2/256+1575*x**8*z**2/128-315*x**6*y**4/128+1575*x**6*y**2*z**2/32-525*x**6*z**4/8-315*x**4*y**6/128+4725*x**4*y**4*z**2/64-1575*x**4*y**2*z**4/8+315*x**4*z**6/4-315*x**2*y**8/256+1575*x**2*y**6*z**2/32-1575*x**2*y**4*z**4/8+315*x**2*y**2*z**6/2-45*x**2*z**8/2-63*y**10/256+1575*y**8*z**2/128-525*y**6*z**4/8+315*y**4*z**6/4-45*y**2*z**8/2+z**10",
            "[0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A1,1,)": (
            "S6",
            "sqrt(14586)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(4,A1,2,)": ("S3", "sqrt(70)*y*z*(3*x**2-y**2)/4", "[0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(6,A1,2,)": (
            "C6",
            "sqrt(462)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(7,A1,2,)": (
            "C3",
            "sqrt(21)*x*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(8,A1,2,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,A1,2,)": (
            "C9",
            "sqrt(24310)*x*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(10,A1,2,)": (
            "C6",
            "sqrt(4290)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(11,A1,2,)": (
            "C9",
            "-sqrt(46189)*x*(x**2-3*y**2)*(x**2+y**2-20*z**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/512",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(6,A1,3,)": (
            "S3",
            "-sqrt(210)*y*z*(3*x**2-y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(8,A1,3,)": (
            "S3",
            "sqrt(1155)*y*z*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(9,A1,3,)": (
            "C3",
            "-sqrt(2310)*x*(x**2-3*y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(10,A1,3,)": (
            "S9",
            "sqrt(461890)*y*z*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(11,A1,3,)": (
            "C3",
            "sqrt(30030)*x*(x**2-3*y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A1,4,)": (
            "S3",
            "-sqrt(4290)*y*z*(3*x**2-y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(1,A2,,)": ("C0", "z", "[0,1,0]"),
        "Qh(4,A2,,)": ("C3", "sqrt(70)*x*z*(x**2-3*y**2)/4", "[0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(3,A2,1,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(5,A2,1,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(6,A2,1,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(7,A2,1,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(8,A2,1,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(9,A2,1,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A2,1,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(11,A2,1,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(3,A2,2,)": ("S3", "sqrt(10)*y*(3*x**2-y**2)/4", "[sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(5,A2,2,)": ("S3", "-sqrt(70)*y*(3*x**2-y**2)*(x**2+y**2-8*z**2)/16", "[0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(6,A2,2,)": (
            "C3",
            "-sqrt(210)*x*z*(x**2-3*y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(7,A2,2,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(8,A2,2,)": (
            "C3",
            "sqrt(1155)*x*z*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(9,A2,2,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(10,A2,2,)": (
            "C9",
            "sqrt(461890)*x*z*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(11,A2,2,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(7,A2,3,)": (
            "S3",
            "sqrt(21)*y*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(9,A2,3,)": (
            "S9",
            "sqrt(24310)*y*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(10,A2,3,)": (
            "C3",
            "-sqrt(4290)*x*z*(x**2-3*y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A2,3,)": (
            "S9",
            "-sqrt(46189)*y*(3*x**2-y**2)*(x**2+y**2-20*z**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/512",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(9,A2,4,)": (
            "S3",
            "-sqrt(2310)*y*(3*x**2-y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(11,A2,4,)": (
            "S3",
            "sqrt(30030)*y*(3*x**2-y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(1,E,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(1,E,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(2,E,1,0)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(2,E,1,1)": ("-C1", "-sqrt(3)*x*z", "[0,sqrt(2)/2,0,-sqrt(2)/2,0]"),
        "Qh(3,E,1,0)": ("C1", "-sqrt(6)*x*(x**2+y**2-4*z**2)/4", "[0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0]"),
        "Qh(3,E,1,1)": ("S1", "-sqrt(6)*y*(x**2+y**2-4*z**2)/4", "[0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0]"),
        "Qh(4,E,1,0)": ("S1", "-sqrt(10)*y*z*(3*x**2+3*y**2-4*z**2)/4", "[0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0]"),
        "Qh(4,E,1,1)": ("-C1", "sqrt(10)*x*z*(3*x**2+3*y**2-4*z**2)/4", "[0,0,0,sqrt(2)/2,0,-sqrt(2)/2,0,0,0]"),
        "Qh(5,E,1,0)": ("C5", "3*sqrt(14)*x*(x**4-10*x**2*y**2+5*y**4)/16", "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(5,E,1,1)": ("-S5", "-3*sqrt(14)*y*(5*x**4-10*x**2*y**2+y**4)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]"),
        "Qh(6,E,1,0)": (
            "-S5",
            "-3*sqrt(154)*y*z*(5*x**4-10*x**2*y**2+y**4)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Qh(6,E,1,1)": ("-C5", "-3*sqrt(154)*x*z*(x**4-10*x**2*y**2+5*y**4)/16", "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0]"),
        "Qh(7,E,1,0)": (
            "C7",
            "sqrt(429)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(7,E,1,1)": (
            "S7",
            "sqrt(429)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(8,E,1,0)": (
            "S7",
            "3*sqrt(715)*y*z*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(8,E,1,1)": (
            "-C7",
            "-3*sqrt(715)*x*z*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0]",
        ),
        "Qh(9,E,1,0)": (
            "C7",
            "-3*sqrt(1430)*x*(x**2+y**2-16*z**2)*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/256",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,E,1,1)": (
            "S7",
            "-3*sqrt(1430)*y*(x**2+y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(10,E,1,0)": (
            "S7",
            "-sqrt(72930)*y*z*(3*x**2+3*y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(10,E,1,1)": (
            "-C7",
            "sqrt(72930)*x*z*(3*x**2+3*y**2-16*z**2)*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0]",
        ),
        "Qh(11,E,1,0)": (
            "C11",
            "sqrt(88179)*x*(x**10-55*x**8*y**2+330*x**6*y**4-462*x**4*y**6+165*x**2*y**8-11*y**10)/512",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(11,E,1,1)": (
            "-S11",
            "-sqrt(88179)*y*(11*x**10-165*x**8*y**2+462*x**6*y**4-330*x**4*y**6+55*x**2*y**8-y**10)/512",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Qh(2,E,2,0)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(2,E,2,1)": ("-S2", "-sqrt(3)*x*y", "[sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2]"),
        "Qh(3,E,2,0)": ("-S2", "-sqrt(15)*x*y*z", "[0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0]"),
        "Qh(3,E,2,1)": ("-C2", "-sqrt(15)*z*(x-y)*(x+y)/2", "[0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0]"),
        "Qh(4,E,2,0)": ("C4", "sqrt(35)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(4,E,2,1)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(5,E,2,0)": (
            "C1",
            "sqrt(15)*x*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(5,E,2,1)": (
            "S1",
            "sqrt(15)*y*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(6,E,2,0)": (
            "S1",
            "sqrt(21)*y*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(6,E,2,1)": (
            "-C1",
            "-sqrt(21)*x*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,sqrt(2)/2,0,-sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(7,E,2,0)": (
            "C5",
            "-sqrt(231)*x*(x**2+y**2-12*z**2)*(x**4-10*x**2*y**2+5*y**4)/32",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(7,E,2,1)": (
            "-S5",
            "sqrt(231)*y*(x**2+y**2-12*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Qh(8,E,2,0)": (
            "-S5",
            "3*sqrt(1001)*y*z*(x**2+y**2-4*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(8,E,2,1)": (
            "-C5",
            "3*sqrt(1001)*x*z*(x**2+y**2-4*z**2)*(x**4-10*x**2*y**2+5*y**4)/32",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0]",
        ),
        "Qh(9,E,2,0)": (
            "C5",
            "3*sqrt(286)*x*(x**4-10*x**2*y**2+5*y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(9,E,2,1)": (
            "-S5",
            "-3*sqrt(286)*y*(5*x**4-10*x**2*y**2+y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,E,2,0)": (
            "-S5",
            "-sqrt(858)*y*z*(5*x**4-10*x**2*y**2+y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(10,E,2,1)": (
            "-C5",
            "-sqrt(858)*x*z*(x**4-10*x**2*y**2+5*y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(11,E,2,0)": (
            "C7",
            "sqrt(36465)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(11,E,2,1)": (
            "S7",
            "sqrt(36465)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(4,E,3,0)": ("C2", "-sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0]"),
        "Qh(4,E,3,1)": ("-S2", "sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0]"),
        "Qh(5,E,3,0)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(5,E,3,1)": (
            "-C4",
            "-3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,-sqrt(2)/2,0]",
        ),
        "Qh(6,E,3,0)": (
            "C4",
            "-3*sqrt(7)*(x**2+y**2-10*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(6,E,3,1)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(7,E,3,0)": (
            "C1",
            "-sqrt(7)*x*(5*x**6+15*x**4*y**2-120*x**4*z**2+15*x**2*y**4-240*x**2*y**2*z**2+240*x**2*z**4+5*y**6-120*y**4*z**2+240*y**2*z**4-64*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(7,E,3,1)": (
            "S1",
            "-sqrt(7)*y*(5*x**6+15*x**4*y**2-120*x**4*z**2+15*x**2*y**4-240*x**2*y**2*z**2+240*x**2*z**4+5*y**6-120*y**4*z**2+240*y**2*z**4-64*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(8,E,3,0)": (
            "S1",
            "-3*y*z*(35*x**6+105*x**4*y**2-280*x**4*z**2+105*x**2*y**4-560*x**2*y**2*z**2+336*x**2*z**4+35*y**6-280*y**4*z**2+336*y**2*z**4-64*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(8,E,3,1)": (
            "-C1",
            "3*x*z*(35*x**6+105*x**4*y**2-280*x**4*z**2+105*x**2*y**4-560*x**2*y**2*z**2+336*x**2*z**4+35*y**6-280*y**4*z**2+336*y**2*z**4-64*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,-sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E,3,0)": (
            "C1",
            "3*sqrt(5)*x*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E,3,1)": (
            "S1",
            "3*sqrt(5)*y*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E,3,0)": (
            "S1",
            "sqrt(55)*y*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E,3,1)": (
            "-C1",
            "-sqrt(55)*x*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,3,0)": (
            "C5",
            "-3*sqrt(143)*x*(x**4-10*x**2*y**2+5*y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(11,E,3,1)": (
            "-S5",
            "3*sqrt(143)*y*(5*x**4-10*x**2*y**2+y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(5,E,4,0)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(5,E,4,1)": ("-C2", "sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0,0]"),
        "Qh(6,E,4,0)": (
            "C2",
            "sqrt(210)*(x-y)*(x+y)*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(6,E,4,1)": (
            "-S2",
            "-sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(7,E,4,0)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(7,E,4,1)": (
            "-C4",
            "sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0]",
        ),
        "Qh(8,E,4,0)": (
            "C8",
            "3*sqrt(715)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(8,E,4,1)": (
            "-S8",
            "-3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Qh(9,E,4,0)": (
            "-S8",
            "-3*sqrt(12155)*x*y*z*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Qh(9,E,4,1)": (
            "-C8",
            "-3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0]",
        ),
        "Qh(10,E,4,0)": (
            "C10",
            "sqrt(92378)*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(10,E,4,1)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(11,E,4,0)": (
            "C1",
            "-sqrt(66)*x*(21*x**10+105*x**8*y**2-1260*x**8*z**2+210*x**6*y**4-5040*x**6*y**2*z**2+8400*x**6*z**4+210*x**4*y**6-7560*x**4*y**4*z**2+25200*x**4*y**2*z**4-13440*x**4*z**6+105*x**2*y**8-5040*x**2*y**6*z**2+25200*x**2*y**4*z**4-26880*x**2*y**2*z**6+5760*x**2*z**8+21*y**10-1260*y**8*z**2+8400*y**6*z**4-13440*y**4*z**6+5760*y**2*z**8-512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,4,1)": (
            "S1",
            "-sqrt(66)*y*(21*x**10+105*x**8*y**2-1260*x**8*z**2+210*x**6*y**4-5040*x**6*y**2*z**2+8400*x**6*z**4+210*x**4*y**6-7560*x**4*y**4*z**2+25200*x**4*y**2*z**4-13440*x**4*z**6+105*x**2*y**8-5040*x**2*y**6*z**2+25200*x**2*y**4*z**4-26880*x**2*y**2*z**6+5760*x**2*z**8+21*y**10-1260*y**8*z**2+8400*y**6*z**4-13440*y**4*z**6+5760*y**2*z**8-512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(7,E,5,0)": (
            "-S2",
            "-sqrt(42)*x*y*z*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/16",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(7,E,5,1)": (
            "-C2",
            "-sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(8,E,5,0)": (
            "C4",
            "3*sqrt(77)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/64",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(8,E,5,1)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(9,E,5,0)": (
            "S4",
            "3*sqrt(5005)*x*y*z*(x-y)*(x+y)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/16",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(9,E,5,1)": (
            "-C4",
            "-3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(10,E,5,0)": (
            "C8",
            "-sqrt(12155)*(x**2+y**2-18*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(10,E,5,1)": (
            "-S8",
            "sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Qh(11,E,5,0)": (
            "S10",
            "sqrt(1939938)*x*y*z*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(11,E,5,1)": (
            "-C10",
            "-sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0]",
        ),
        "Qh(8,E,6,0)": (
            "C2",
            "-3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(8,E,6,1)": (
            "-S2",
            "3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,E,6,0)": (
            "-S2",
            "3*sqrt(110)*x*y*z*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E,6,1)": (
            "-C2",
            "3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E,6,0)": (
            "C4",
            "-sqrt(2145)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(10,E,6,1)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(11,E,6,0)": (
            "-S8",
            "sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(11,E,6,1)": (
            "-C8",
            "sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0]",
        ),
        "Qh(10,E,7,0)": (
            "C2",
            "sqrt(165)*(x-y)*(x+y)*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/256",
            "[0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E,7,1)": (
            "-S2",
            "-sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,7,0)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,7,1)": (
            "-C4",
            "3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,8,0)": (
            "-S2",
            "-sqrt(2145)*x*y*z*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,8,1)": (
            "-C2",
            "-sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
    },
    "C3v": {
        "Qh(0,A1,,)": ("C0", "1", "[1]"),
        "Qh(1,A1,,)": ("C0", "z", "[0,1,0]"),
        "Qh(2,A1,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(3,A1,1,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(4,A1,1,)": ("C0", "3*x**4/8+3*x**2*y**2/4-3*x**2*z**2+3*y**4/8-3*y**2*z**2+z**4", "[0,0,0,0,1,0,0,0,0]"),
        "Qh(5,A1,1,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(6,A1,1,)": (
            "C0",
            "-5*x**6/16-15*x**4*y**2/16+45*x**4*z**2/8-15*x**2*y**4/16+45*x**2*y**2*z**2/4-15*x**2*z**4/2-5*y**6/16+45*y**4*z**2/8-15*y**2*z**4/2+z**6",
            "[0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Qh(7,A1,1,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(8,A1,1,)": (
            "C0",
            "35*x**8/128+35*x**6*y**2/32-35*x**6*z**2/4+105*x**4*y**4/64-105*x**4*y**2*z**2/4+105*x**4*z**4/4+35*x**2*y**6/32-105*x**2*y**4*z**2/4+105*x**2*y**2*z**4/2-14*x**2*z**6+35*y**8/128-35*y**6*z**2/4+105*y**4*z**4/4-14*y**2*z**6+z**8",
            "[0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,A1,1,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A1,1,)": (
            "C0",
            "-63*x**10/256-315*x**8*y**2/256+1575*x**8*z**2/128-315*x**6*y**4/128+1575*x**6*y**2*z**2/32-525*x**6*z**4/8-315*x**4*y**6/128+4725*x**4*y**4*z**2/64-1575*x**4*y**2*z**4/8+315*x**4*z**6/4-315*x**2*y**8/256+1575*x**2*y**6*z**2/32-1575*x**2*y**4*z**4/8+315*x**2*y**2*z**6/2-45*x**2*z**8/2-63*y**10/256+1575*y**8*z**2/128-525*y**6*z**4/8+315*y**4*z**6/4-45*y**2*z**8/2+z**10",
            "[0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A1,1,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(3,A1,2,)": ("S3", "sqrt(10)*y*(3*x**2-y**2)/4", "[sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(4,A1,2,)": ("S3", "sqrt(70)*y*z*(3*x**2-y**2)/4", "[0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(5,A1,2,)": ("S3", "-sqrt(70)*y*(3*x**2-y**2)*(x**2+y**2-8*z**2)/16", "[0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(6,A1,2,)": (
            "C6",
            "sqrt(462)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(7,A1,2,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(8,A1,2,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,A1,2,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(10,A1,2,)": (
            "C6",
            "sqrt(4290)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(11,A1,2,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(6,A1,3,)": (
            "S3",
            "-sqrt(210)*y*z*(3*x**2-y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(7,A1,3,)": (
            "S3",
            "sqrt(21)*y*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(8,A1,3,)": (
            "S3",
            "sqrt(1155)*y*z*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(9,A1,3,)": (
            "S9",
            "sqrt(24310)*y*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(10,A1,3,)": (
            "S9",
            "sqrt(461890)*y*z*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(11,A1,3,)": (
            "S9",
            "-sqrt(46189)*y*(3*x**2-y**2)*(x**2+y**2-20*z**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/512",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(9,A1,4,)": (
            "S3",
            "-sqrt(2310)*y*(3*x**2-y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(10,A1,4,)": (
            "S3",
            "-sqrt(4290)*y*z*(3*x**2-y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A1,4,)": (
            "S3",
            "sqrt(30030)*y*(3*x**2-y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(3,A2,,)": ("C3", "sqrt(10)*x*(x**2-3*y**2)/4", "[-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(4,A2,,)": ("C3", "sqrt(70)*x*z*(x**2-3*y**2)/4", "[0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(5,A2,,)": ("C3", "-sqrt(70)*x*(x**2-3*y**2)*(x**2+y**2-8*z**2)/16", "[0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0]"),
        "Qh(6,A2,1,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(7,A2,1,)": (
            "S6",
            "sqrt(6006)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(8,A2,1,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(9,A2,1,)": (
            "S6",
            "-sqrt(4290)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**2+3*y**2-14*z**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(10,A2,1,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(11,A2,1,)": (
            "S6",
            "sqrt(14586)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(6,A2,2,)": (
            "C3",
            "-sqrt(210)*x*z*(x**2-3*y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(7,A2,2,)": (
            "C3",
            "sqrt(21)*x*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(8,A2,2,)": (
            "C3",
            "sqrt(1155)*x*z*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(9,A2,2,)": (
            "C9",
            "sqrt(24310)*x*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(10,A2,2,)": (
            "C9",
            "sqrt(461890)*x*z*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(11,A2,2,)": (
            "C9",
            "-sqrt(46189)*x*(x**2-3*y**2)*(x**2+y**2-20*z**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/512",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,A2,3,)": (
            "C3",
            "-sqrt(2310)*x*(x**2-3*y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(10,A2,3,)": (
            "C3",
            "-sqrt(4290)*x*z*(x**2-3*y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A2,3,)": (
            "C3",
            "sqrt(30030)*x*(x**2-3*y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(1,E,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(1,E,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(2,E,1,0)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Qh(2,E,1,1)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(3,E,1,0)": ("C1", "-sqrt(6)*x*(x**2+y**2-4*z**2)/4", "[0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0]"),
        "Qh(3,E,1,1)": ("S1", "-sqrt(6)*y*(x**2+y**2-4*z**2)/4", "[0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0]"),
        "Qh(4,E,1,0)": ("C1", "-sqrt(10)*x*z*(3*x**2+3*y**2-4*z**2)/4", "[0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0]"),
        "Qh(4,E,1,1)": ("S1", "-sqrt(10)*y*z*(3*x**2+3*y**2-4*z**2)/4", "[0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0]"),
        "Qh(5,E,1,0)": ("C5", "3*sqrt(14)*x*(x**4-10*x**2*y**2+5*y**4)/16", "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(5,E,1,1)": ("-S5", "-3*sqrt(14)*y*(5*x**4-10*x**2*y**2+y**4)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]"),
        "Qh(6,E,1,0)": ("C5", "3*sqrt(154)*x*z*(x**4-10*x**2*y**2+5*y**4)/16", "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(6,E,1,1)": (
            "-S5",
            "-3*sqrt(154)*y*z*(5*x**4-10*x**2*y**2+y**4)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Qh(7,E,1,0)": (
            "C7",
            "sqrt(429)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(7,E,1,1)": (
            "S7",
            "sqrt(429)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(8,E,1,0)": (
            "C7",
            "3*sqrt(715)*x*z*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(8,E,1,1)": (
            "S7",
            "3*sqrt(715)*y*z*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(9,E,1,0)": (
            "C7",
            "-3*sqrt(1430)*x*(x**2+y**2-16*z**2)*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/256",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,E,1,1)": (
            "S7",
            "-3*sqrt(1430)*y*(x**2+y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(10,E,1,0)": (
            "C7",
            "-sqrt(72930)*x*z*(3*x**2+3*y**2-16*z**2)*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/256",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(10,E,1,1)": (
            "S7",
            "-sqrt(72930)*y*z*(3*x**2+3*y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(11,E,1,0)": (
            "C11",
            "sqrt(88179)*x*(x**10-55*x**8*y**2+330*x**6*y**4-462*x**4*y**6+165*x**2*y**8-11*y**10)/512",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(11,E,1,1)": (
            "-S11",
            "-sqrt(88179)*y*(11*x**10-165*x**8*y**2+462*x**6*y**4-330*x**4*y**6+55*x**2*y**8-y**10)/512",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Qh(2,E,2,0)": ("-S2", "-sqrt(3)*x*y", "[sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2]"),
        "Qh(2,E,2,1)": ("-C2", "-sqrt(3)*(x-y)*(x+y)/2", "[-sqrt(2)/2,0,0,0,-sqrt(2)/2]"),
        "Qh(3,E,2,0)": ("-S2", "-sqrt(15)*x*y*z", "[0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0]"),
        "Qh(3,E,2,1)": ("-C2", "-sqrt(15)*z*(x-y)*(x+y)/2", "[0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0]"),
        "Qh(4,E,2,0)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(4,E,2,1)": ("-C4", "-sqrt(35)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[-sqrt(2)/2,0,0,0,0,0,0,0,-sqrt(2)/2]"),
        "Qh(5,E,2,0)": (
            "C1",
            "sqrt(15)*x*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(5,E,2,1)": (
            "S1",
            "sqrt(15)*y*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(6,E,2,0)": (
            "C1",
            "sqrt(21)*x*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(6,E,2,1)": (
            "S1",
            "sqrt(21)*y*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(7,E,2,0)": (
            "C5",
            "-sqrt(231)*x*(x**2+y**2-12*z**2)*(x**4-10*x**2*y**2+5*y**4)/32",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(7,E,2,1)": (
            "-S5",
            "sqrt(231)*y*(x**2+y**2-12*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Qh(8,E,2,0)": (
            "C5",
            "-3*sqrt(1001)*x*z*(x**2+y**2-4*z**2)*(x**4-10*x**2*y**2+5*y**4)/32",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(8,E,2,1)": (
            "-S5",
            "3*sqrt(1001)*y*z*(x**2+y**2-4*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(9,E,2,0)": (
            "C5",
            "3*sqrt(286)*x*(x**4-10*x**2*y**2+5*y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(9,E,2,1)": (
            "-S5",
            "-3*sqrt(286)*y*(5*x**4-10*x**2*y**2+y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,E,2,0)": (
            "C5",
            "sqrt(858)*x*z*(x**4-10*x**2*y**2+5*y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(10,E,2,1)": (
            "-S5",
            "-sqrt(858)*y*z*(5*x**4-10*x**2*y**2+y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(11,E,2,0)": (
            "C7",
            "sqrt(36465)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(11,E,2,1)": (
            "S7",
            "sqrt(36465)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(4,E,3,0)": ("-S2", "sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0]"),
        "Qh(4,E,3,1)": ("-C2", "sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0]"),
        "Qh(5,E,3,0)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(5,E,3,1)": (
            "-C4",
            "-3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,-sqrt(2)/2,0]",
        ),
        "Qh(6,E,3,0)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(6,E,3,1)": (
            "-C4",
            "3*sqrt(7)*(x**2+y**2-10*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,-sqrt(2)/2,0,0]",
        ),
        "Qh(7,E,3,0)": (
            "C1",
            "-sqrt(7)*x*(5*x**6+15*x**4*y**2-120*x**4*z**2+15*x**2*y**4-240*x**2*y**2*z**2+240*x**2*z**4+5*y**6-120*y**4*z**2+240*y**2*z**4-64*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(7,E,3,1)": (
            "S1",
            "-sqrt(7)*y*(5*x**6+15*x**4*y**2-120*x**4*z**2+15*x**2*y**4-240*x**2*y**2*z**2+240*x**2*z**4+5*y**6-120*y**4*z**2+240*y**2*z**4-64*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(8,E,3,0)": (
            "C1",
            "-3*x*z*(35*x**6+105*x**4*y**2-280*x**4*z**2+105*x**2*y**4-560*x**2*y**2*z**2+336*x**2*z**4+35*y**6-280*y**4*z**2+336*y**2*z**4-64*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(8,E,3,1)": (
            "S1",
            "-3*y*z*(35*x**6+105*x**4*y**2-280*x**4*z**2+105*x**2*y**4-560*x**2*y**2*z**2+336*x**2*z**4+35*y**6-280*y**4*z**2+336*y**2*z**4-64*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E,3,0)": (
            "C1",
            "3*sqrt(5)*x*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E,3,1)": (
            "S1",
            "3*sqrt(5)*y*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E,3,0)": (
            "C1",
            "sqrt(55)*x*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E,3,1)": (
            "S1",
            "sqrt(55)*y*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,3,0)": (
            "C5",
            "-3*sqrt(143)*x*(x**4-10*x**2*y**2+5*y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(11,E,3,1)": (
            "-S5",
            "3*sqrt(143)*y*(5*x**4-10*x**2*y**2+y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(5,E,4,0)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(5,E,4,1)": ("-C2", "sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0,0]"),
        "Qh(6,E,4,0)": (
            "-S2",
            "-sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(6,E,4,1)": (
            "-C2",
            "-sqrt(210)*(x-y)*(x+y)*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(7,E,4,0)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(7,E,4,1)": (
            "-C4",
            "sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0]",
        ),
        "Qh(8,E,4,0)": (
            "-S8",
            "-3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Qh(8,E,4,1)": (
            "-C8",
            "-3*sqrt(715)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2]",
        ),
        "Qh(9,E,4,0)": (
            "-S8",
            "-3*sqrt(12155)*x*y*z*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Qh(9,E,4,1)": (
            "-C8",
            "-3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0]",
        ),
        "Qh(10,E,4,0)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(10,E,4,1)": (
            "-C10",
            "-sqrt(92378)*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2]",
        ),
        "Qh(11,E,4,0)": (
            "C1",
            "-sqrt(66)*x*(21*x**10+105*x**8*y**2-1260*x**8*z**2+210*x**6*y**4-5040*x**6*y**2*z**2+8400*x**6*z**4+210*x**4*y**6-7560*x**4*y**4*z**2+25200*x**4*y**2*z**4-13440*x**4*z**6+105*x**2*y**8-5040*x**2*y**6*z**2+25200*x**2*y**4*z**4-26880*x**2*y**2*z**6+5760*x**2*z**8+21*y**10-1260*y**8*z**2+8400*y**6*z**4-13440*y**4*z**6+5760*y**2*z**8-512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,4,1)": (
            "S1",
            "-sqrt(66)*y*(21*x**10+105*x**8*y**2-1260*x**8*z**2+210*x**6*y**4-5040*x**6*y**2*z**2+8400*x**6*z**4+210*x**4*y**6-7560*x**4*y**4*z**2+25200*x**4*y**2*z**4-13440*x**4*z**6+105*x**2*y**8-5040*x**2*y**6*z**2+25200*x**2*y**4*z**4-26880*x**2*y**2*z**6+5760*x**2*z**8+21*y**10-1260*y**8*z**2+8400*y**6*z**4-13440*y**4*z**6+5760*y**2*z**8-512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(7,E,5,0)": (
            "-S2",
            "-sqrt(42)*x*y*z*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/16",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(7,E,5,1)": (
            "-C2",
            "-sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(8,E,5,0)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(8,E,5,1)": (
            "-C4",
            "-3*sqrt(77)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/64",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(9,E,5,0)": (
            "S4",
            "3*sqrt(5005)*x*y*z*(x-y)*(x+y)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/16",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(9,E,5,1)": (
            "-C4",
            "-3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(10,E,5,0)": (
            "-S8",
            "sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Qh(10,E,5,1)": (
            "-C8",
            "sqrt(12155)*(x**2+y**2-18*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0]",
        ),
        "Qh(11,E,5,0)": (
            "S10",
            "sqrt(1939938)*x*y*z*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(11,E,5,1)": (
            "-C10",
            "-sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0]",
        ),
        "Qh(8,E,6,0)": (
            "-S2",
            "3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(8,E,6,1)": (
            "-C2",
            "3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(9,E,6,0)": (
            "-S2",
            "3*sqrt(110)*x*y*z*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E,6,1)": (
            "-C2",
            "3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E,6,0)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(10,E,6,1)": (
            "-C4",
            "sqrt(2145)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/128",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(11,E,6,0)": (
            "-S8",
            "sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(11,E,6,1)": (
            "-C8",
            "sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0]",
        ),
        "Qh(10,E,7,0)": (
            "-S2",
            "-sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E,7,1)": (
            "-C2",
            "-sqrt(165)*(x-y)*(x+y)*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/256",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,7,0)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,7,1)": (
            "-C4",
            "3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,8,0)": (
            "-S2",
            "-sqrt(2145)*x*y*z*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,8,1)": (
            "-C2",
            "-sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
    },
    "C3v-1": {
        "Qh(0,A1,,)": ("C0", "1", "[1]"),
        "Qh(1,A1,,)": ("C0", "z", "[0,1,0]"),
        "Qh(2,A1,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(3,A1,1,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(4,A1,1,)": ("C0", "3*x**4/8+3*x**2*y**2/4-3*x**2*z**2+3*y**4/8-3*y**2*z**2+z**4", "[0,0,0,0,1,0,0,0,0]"),
        "Qh(5,A1,1,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(6,A1,1,)": (
            "C0",
            "-5*x**6/16-15*x**4*y**2/16+45*x**4*z**2/8-15*x**2*y**4/16+45*x**2*y**2*z**2/4-15*x**2*z**4/2-5*y**6/16+45*y**4*z**2/8-15*y**2*z**4/2+z**6",
            "[0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Qh(7,A1,1,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(8,A1,1,)": (
            "C0",
            "35*x**8/128+35*x**6*y**2/32-35*x**6*z**2/4+105*x**4*y**4/64-105*x**4*y**2*z**2/4+105*x**4*z**4/4+35*x**2*y**6/32-105*x**2*y**4*z**2/4+105*x**2*y**2*z**4/2-14*x**2*z**6+35*y**8/128-35*y**6*z**2/4+105*y**4*z**4/4-14*y**2*z**6+z**8",
            "[0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,A1,1,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A1,1,)": (
            "C0",
            "-63*x**10/256-315*x**8*y**2/256+1575*x**8*z**2/128-315*x**6*y**4/128+1575*x**6*y**2*z**2/32-525*x**6*z**4/8-315*x**4*y**6/128+4725*x**4*y**4*z**2/64-1575*x**4*y**2*z**4/8+315*x**4*z**6/4-315*x**2*y**8/256+1575*x**2*y**6*z**2/32-1575*x**2*y**4*z**4/8+315*x**2*y**2*z**6/2-45*x**2*z**8/2-63*y**10/256+1575*y**8*z**2/128-525*y**6*z**4/8+315*y**4*z**6/4-45*y**2*z**8/2+z**10",
            "[0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A1,1,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(3,A1,2,)": ("C3", "sqrt(10)*x*(x**2-3*y**2)/4", "[-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(4,A1,2,)": ("C3", "sqrt(70)*x*z*(x**2-3*y**2)/4", "[0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(5,A1,2,)": ("C3", "-sqrt(70)*x*(x**2-3*y**2)*(x**2+y**2-8*z**2)/16", "[0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0]"),
        "Qh(6,A1,2,)": (
            "C6",
            "sqrt(462)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(7,A1,2,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(8,A1,2,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,A1,2,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(10,A1,2,)": (
            "C6",
            "sqrt(4290)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(11,A1,2,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(6,A1,3,)": (
            "C3",
            "-sqrt(210)*x*z*(x**2-3*y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(7,A1,3,)": (
            "C3",
            "sqrt(21)*x*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(8,A1,3,)": (
            "C3",
            "sqrt(1155)*x*z*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(9,A1,3,)": (
            "C9",
            "sqrt(24310)*x*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(10,A1,3,)": (
            "C9",
            "sqrt(461890)*x*z*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(11,A1,3,)": (
            "C9",
            "-sqrt(46189)*x*(x**2-3*y**2)*(x**2+y**2-20*z**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/512",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,A1,4,)": (
            "C3",
            "-sqrt(2310)*x*(x**2-3*y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(10,A1,4,)": (
            "C3",
            "-sqrt(4290)*x*z*(x**2-3*y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A1,4,)": (
            "C3",
            "sqrt(30030)*x*(x**2-3*y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(3,A2,,)": ("S3", "sqrt(10)*y*(3*x**2-y**2)/4", "[sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(4,A2,,)": ("S3", "sqrt(70)*y*z*(3*x**2-y**2)/4", "[0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(5,A2,,)": ("S3", "-sqrt(70)*y*(3*x**2-y**2)*(x**2+y**2-8*z**2)/16", "[0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(6,A2,1,)": ("S6", "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(7,A2,1,)": (
            "S6",
            "sqrt(6006)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(8,A2,1,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(9,A2,1,)": (
            "S6",
            "-sqrt(4290)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**2+3*y**2-14*z**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(10,A2,1,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(11,A2,1,)": (
            "S6",
            "sqrt(14586)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(6,A2,2,)": (
            "S3",
            "-sqrt(210)*y*z*(3*x**2-y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(7,A2,2,)": (
            "S3",
            "sqrt(21)*y*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(8,A2,2,)": (
            "S3",
            "sqrt(1155)*y*z*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(9,A2,2,)": (
            "S9",
            "sqrt(24310)*y*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(10,A2,2,)": (
            "S9",
            "sqrt(461890)*y*z*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(11,A2,2,)": (
            "S9",
            "-sqrt(46189)*y*(3*x**2-y**2)*(x**2+y**2-20*z**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/512",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(9,A2,3,)": (
            "S3",
            "-sqrt(2310)*y*(3*x**2-y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(10,A2,3,)": (
            "S3",
            "-sqrt(4290)*y*z*(3*x**2-y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A2,3,)": (
            "S3",
            "sqrt(30030)*y*(3*x**2-y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(1,E,,0)": ("C1", "x", "[-sqrt(2)/2,0,sqrt(2)/2]"),
        "Qh(1,E,,1)": ("S1", "y", "[sqrt(2)*I/2,0,sqrt(2)*I/2]"),
        "Qh(2,E,1,0)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Qh(2,E,1,1)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(3,E,1,0)": ("C1", "-sqrt(6)*x*(x**2+y**2-4*z**2)/4", "[0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0]"),
        "Qh(3,E,1,1)": ("S1", "-sqrt(6)*y*(x**2+y**2-4*z**2)/4", "[0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0]"),
        "Qh(4,E,1,0)": ("C1", "-sqrt(10)*x*z*(3*x**2+3*y**2-4*z**2)/4", "[0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0]"),
        "Qh(4,E,1,1)": ("S1", "-sqrt(10)*y*z*(3*x**2+3*y**2-4*z**2)/4", "[0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0]"),
        "Qh(5,E,1,0)": ("C5", "3*sqrt(14)*x*(x**4-10*x**2*y**2+5*y**4)/16", "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(5,E,1,1)": ("-S5", "-3*sqrt(14)*y*(5*x**4-10*x**2*y**2+y**4)/16", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]"),
        "Qh(6,E,1,0)": ("C5", "3*sqrt(154)*x*z*(x**4-10*x**2*y**2+5*y**4)/16", "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(6,E,1,1)": (
            "-S5",
            "-3*sqrt(154)*y*z*(5*x**4-10*x**2*y**2+y**4)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Qh(7,E,1,0)": (
            "C7",
            "sqrt(429)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(7,E,1,1)": (
            "S7",
            "sqrt(429)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(8,E,1,0)": (
            "C7",
            "3*sqrt(715)*x*z*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(8,E,1,1)": (
            "S7",
            "3*sqrt(715)*y*z*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(9,E,1,0)": (
            "C7",
            "-3*sqrt(1430)*x*(x**2+y**2-16*z**2)*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/256",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,E,1,1)": (
            "S7",
            "-3*sqrt(1430)*y*(x**2+y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(10,E,1,0)": (
            "C7",
            "-sqrt(72930)*x*z*(3*x**2+3*y**2-16*z**2)*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/256",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(10,E,1,1)": (
            "S7",
            "-sqrt(72930)*y*z*(3*x**2+3*y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(11,E,1,0)": (
            "C11",
            "sqrt(88179)*x*(x**10-55*x**8*y**2+330*x**6*y**4-462*x**4*y**6+165*x**2*y**8-11*y**10)/512",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(11,E,1,1)": (
            "-S11",
            "-sqrt(88179)*y*(11*x**10-165*x**8*y**2+462*x**6*y**4-330*x**4*y**6+55*x**2*y**8-y**10)/512",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Qh(2,E,2,0)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(2,E,2,1)": ("-S2", "-sqrt(3)*x*y", "[sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2]"),
        "Qh(3,E,2,0)": ("C2", "sqrt(15)*z*(x-y)*(x+y)/2", "[0,sqrt(2)/2,0,0,0,sqrt(2)/2,0]"),
        "Qh(3,E,2,1)": ("-S2", "-sqrt(15)*x*y*z", "[0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0]"),
        "Qh(4,E,2,0)": ("C4", "sqrt(35)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(4,E,2,1)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(5,E,2,0)": (
            "C1",
            "sqrt(15)*x*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(5,E,2,1)": (
            "S1",
            "sqrt(15)*y*(x**4+2*x**2*y**2-12*x**2*z**2+y**4-12*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(6,E,2,0)": (
            "C1",
            "sqrt(21)*x*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(6,E,2,1)": (
            "S1",
            "sqrt(21)*y*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(7,E,2,0)": (
            "C5",
            "-sqrt(231)*x*(x**2+y**2-12*z**2)*(x**4-10*x**2*y**2+5*y**4)/32",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(7,E,2,1)": (
            "-S5",
            "sqrt(231)*y*(x**2+y**2-12*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Qh(8,E,2,0)": (
            "C5",
            "-3*sqrt(1001)*x*z*(x**2+y**2-4*z**2)*(x**4-10*x**2*y**2+5*y**4)/32",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(8,E,2,1)": (
            "-S5",
            "3*sqrt(1001)*y*z*(x**2+y**2-4*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(9,E,2,0)": (
            "C5",
            "3*sqrt(286)*x*(x**4-10*x**2*y**2+5*y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(9,E,2,1)": (
            "-S5",
            "-3*sqrt(286)*y*(5*x**4-10*x**2*y**2+y**4)*(x**4+2*x**2*y**2-28*x**2*z**2+y**4-28*y**2*z**2+56*z**4)/128",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(10,E,2,0)": (
            "C5",
            "sqrt(858)*x*z*(x**4-10*x**2*y**2+5*y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(10,E,2,1)": (
            "-S5",
            "-sqrt(858)*y*z*(5*x**4-10*x**2*y**2+y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(11,E,2,0)": (
            "C7",
            "sqrt(36465)*x*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(11,E,2,1)": (
            "S7",
            "sqrt(36465)*y*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)*(x**4+2*x**2*y**2-36*x**2*z**2+y**4-36*y**2*z**2+96*z**4)/512",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(4,E,3,0)": ("C2", "-sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0]"),
        "Qh(4,E,3,1)": ("-S2", "sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0]"),
        "Qh(5,E,3,0)": ("C4", "3*sqrt(35)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(5,E,3,1)": ("S4", "3*sqrt(35)*x*y*z*(x-y)*(x+y)/2", "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(6,E,3,0)": (
            "C4",
            "-3*sqrt(7)*(x**2+y**2-10*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(6,E,3,1)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+y)*(x**2+y**2-10*z**2)/4",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(7,E,3,0)": (
            "C1",
            "-sqrt(7)*x*(5*x**6+15*x**4*y**2-120*x**4*z**2+15*x**2*y**4-240*x**2*y**2*z**2+240*x**2*z**4+5*y**6-120*y**4*z**2+240*y**2*z**4-64*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(7,E,3,1)": (
            "S1",
            "-sqrt(7)*y*(5*x**6+15*x**4*y**2-120*x**4*z**2+15*x**2*y**4-240*x**2*y**2*z**2+240*x**2*z**4+5*y**6-120*y**4*z**2+240*y**2*z**4-64*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(8,E,3,0)": (
            "C1",
            "-3*x*z*(35*x**6+105*x**4*y**2-280*x**4*z**2+105*x**2*y**4-560*x**2*y**2*z**2+336*x**2*z**4+35*y**6-280*y**4*z**2+336*y**2*z**4-64*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(8,E,3,1)": (
            "S1",
            "-3*y*z*(35*x**6+105*x**4*y**2-280*x**4*z**2+105*x**2*y**4-560*x**2*y**2*z**2+336*x**2*z**4+35*y**6-280*y**4*z**2+336*y**2*z**4-64*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E,3,0)": (
            "C1",
            "3*sqrt(5)*x*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E,3,1)": (
            "S1",
            "3*sqrt(5)*y*(7*x**8+28*x**6*y**2-280*x**6*z**2+42*x**4*y**4-840*x**4*y**2*z**2+1120*x**4*z**4+28*x**2*y**6-840*x**2*y**4*z**2+2240*x**2*y**2*z**4-896*x**2*z**6+7*y**8-280*y**6*z**2+1120*y**4*z**4-896*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E,3,0)": (
            "C1",
            "sqrt(55)*x*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E,3,1)": (
            "S1",
            "sqrt(55)*y*z*(63*x**8+252*x**6*y**2-840*x**6*z**2+378*x**4*y**4-2520*x**4*y**2*z**2+2016*x**4*z**4+252*x**2*y**6-2520*x**2*y**4*z**2+4032*x**2*y**2*z**4-1152*x**2*z**6+63*y**8-840*y**6*z**2+2016*y**4*z**4-1152*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,3,0)": (
            "C5",
            "-3*sqrt(143)*x*(x**4-10*x**2*y**2+5*y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(11,E,3,1)": (
            "-S5",
            "3*sqrt(143)*y*(5*x**4-10*x**2*y**2+y**4)*(5*x**6+15*x**4*y**2-240*x**4*z**2+15*x**2*y**4-480*x**2*y**2*z**2+1120*x**2*z**4+5*y**6-240*y**4*z**2+1120*y**2*z**4-896*z**6)/512",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(5,E,4,0)": ("C2", "-sqrt(105)*z*(x-y)*(x+y)*(x**2+y**2-2*z**2)/4", "[0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0]"),
        "Qh(5,E,4,1)": ("-S2", "sqrt(105)*x*y*z*(x**2+y**2-2*z**2)/2", "[0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0]"),
        "Qh(6,E,4,0)": (
            "C2",
            "sqrt(210)*(x-y)*(x+y)*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(6,E,4,1)": (
            "-S2",
            "-sqrt(210)*x*y*(x**4+2*x**2*y**2-16*x**2*z**2+y**4-16*y**2*z**2+16*z**4)/16",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(7,E,4,0)": (
            "C4",
            "-sqrt(231)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(3*x**2+3*y**2-10*z**2)/16",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(7,E,4,1)": (
            "S4",
            "-sqrt(231)*x*y*z*(x-y)*(x+y)*(3*x**2+3*y**2-10*z**2)/4",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(8,E,4,0)": (
            "C8",
            "3*sqrt(715)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(8,E,4,1)": (
            "-S8",
            "-3*sqrt(715)*x*y*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2]",
        ),
        "Qh(9,E,4,0)": (
            "C8",
            "3*sqrt(12155)*z*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/128",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,E,4,1)": (
            "-S8",
            "-3*sqrt(12155)*x*y*z*(x-y)*(x+y)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Qh(10,E,4,0)": (
            "C10",
            "sqrt(92378)*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(10,E,4,1)": (
            "S10",
            "sqrt(92378)*x*y*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(11,E,4,0)": (
            "C1",
            "-sqrt(66)*x*(21*x**10+105*x**8*y**2-1260*x**8*z**2+210*x**6*y**4-5040*x**6*y**2*z**2+8400*x**6*z**4+210*x**4*y**6-7560*x**4*y**4*z**2+25200*x**4*y**2*z**4-13440*x**4*z**6+105*x**2*y**8-5040*x**2*y**6*z**2+25200*x**2*y**4*z**4-26880*x**2*y**2*z**6+5760*x**2*z**8+21*y**10-1260*y**8*z**2+8400*y**6*z**4-13440*y**4*z**6+5760*y**2*z**8-512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,4,1)": (
            "S1",
            "-sqrt(66)*y*(21*x**10+105*x**8*y**2-1260*x**8*z**2+210*x**6*y**4-5040*x**6*y**2*z**2+8400*x**6*z**4+210*x**4*y**6-7560*x**4*y**4*z**2+25200*x**4*y**2*z**4-13440*x**4*z**6+105*x**2*y**8-5040*x**2*y**6*z**2+25200*x**2*y**4*z**4-26880*x**2*y**2*z**6+5760*x**2*z**8+21*y**10-1260*y**8*z**2+8400*y**6*z**4-13440*y**4*z**6+5760*y**2*z**8-512*z**10)/512",
            "[0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(7,E,5,0)": (
            "C2",
            "sqrt(42)*z*(x-y)*(x+y)*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/32",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(7,E,5,1)": (
            "-S2",
            "-sqrt(42)*x*y*z*(15*x**4+30*x**2*y**2-80*x**2*z**2+15*y**4-80*y**2*z**2+48*z**4)/16",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(8,E,5,0)": (
            "C4",
            "3*sqrt(77)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/64",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(8,E,5,1)": (
            "S4",
            "3*sqrt(77)*x*y*(x-y)*(x+y)*(x**4+2*x**2*y**2-24*x**2*z**2+y**4-24*y**2*z**2+40*z**4)/16",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(9,E,5,0)": (
            "C4",
            "3*sqrt(5005)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/64",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(9,E,5,1)": (
            "S4",
            "3*sqrt(5005)*x*y*z*(x-y)*(x+y)*(x**4+2*x**2*y**2-8*x**2*z**2+y**4-8*y**2*z**2+8*z**4)/16",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(10,E,5,0)": (
            "C8",
            "-sqrt(12155)*(x**2+y**2-18*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(10,E,5,1)": (
            "-S8",
            "sqrt(12155)*x*y*(x-y)*(x+y)*(x**2+y**2-18*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0]",
        ),
        "Qh(11,E,5,0)": (
            "C10",
            "sqrt(1939938)*z*(x-y)*(x+y)*(x**4-4*x**3*y-14*x**2*y**2-4*x*y**3+y**4)*(x**4+4*x**3*y-14*x**2*y**2+4*x*y**3+y**4)/512",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(11,E,5,1)": (
            "S10",
            "sqrt(1939938)*x*y*z*(x**4-10*x**2*y**2+5*y**4)*(5*x**4-10*x**2*y**2+y**4)/256",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(8,E,6,0)": (
            "C2",
            "-3*sqrt(70)*(x-y)*(x+y)*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(8,E,6,1)": (
            "-S2",
            "3*sqrt(70)*x*y*(x**6+3*x**4*y**2-30*x**4*z**2+3*x**2*y**4-60*x**2*y**2*z**2+80*x**2*z**4+y**6-30*y**4*z**2+80*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(9,E,6,0)": (
            "C2",
            "-3*sqrt(110)*z*(x-y)*(x+y)*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/64",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(9,E,6,1)": (
            "-S2",
            "3*sqrt(110)*x*y*z*(7*x**6+21*x**4*y**2-70*x**4*z**2+21*x**2*y**4-140*x**2*y**2*z**2+112*x**2*z**4+7*y**6-70*y**4*z**2+112*y**2*z**4-32*z**6)/32",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E,6,0)": (
            "C4",
            "-sqrt(2145)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(10,E,6,1)": (
            "S4",
            "-sqrt(2145)*x*y*(x-y)*(x+y)*(x**6+3*x**4*y**2-42*x**4*z**2+3*x**2*y**4-84*x**2*y**2*z**2+168*x**2*z**4+y**6-42*y**4*z**2+168*y**2*z**4-112*z**6)/32",
            "[0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(11,E,6,0)": (
            "C8",
            "-sqrt(692835)*z*(x**2+y**2-6*z**2)*(x**4-4*x**3*y-6*x**2*y**2+4*x*y**3+y**4)*(x**4+4*x**3*y-6*x**2*y**2-4*x*y**3+y**4)/256",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(11,E,6,1)": (
            "-S8",
            "sqrt(692835)*x*y*z*(x-y)*(x+y)*(x**2+y**2-6*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/32",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(10,E,7,0)": (
            "C2",
            "sqrt(165)*(x-y)*(x+y)*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/256",
            "[0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,E,7,1)": (
            "-S2",
            "-sqrt(165)*x*y*(7*x**8+28*x**6*y**2-336*x**6*z**2+42*x**4*y**4-1008*x**4*y**2*z**2+1680*x**4*z**4+28*x**2*y**6-1008*x**2*y**4*z**2+3360*x**2*y**2*z**4-1792*x**2*z**6+7*y**8-336*y**6*z**2+1680*y**4*z**4-1792*y**2*z**6+384*z**8)/128",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,7,0)": (
            "C4",
            "-3*sqrt(1001)*z*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,7,1)": (
            "S4",
            "-3*sqrt(1001)*x*y*z*(x-y)*(x+y)*(5*x**6+15*x**4*y**2-70*x**4*z**2+15*x**2*y**4-140*x**2*y**2*z**2+168*x**2*z**4+5*y**6-70*y**4*z**2+168*y**2*z**4-80*z**6)/32",
            "[0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,8,0)": (
            "C2",
            "sqrt(2145)*z*(x-y)*(x+y)*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/256",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,E,8,1)": (
            "-S2",
            "-sqrt(2145)*x*y*z*(21*x**8+84*x**6*y**2-336*x**6*z**2+126*x**4*y**4-1008*x**4*y**2*z**2+1008*x**4*z**4+84*x**2*y**6-1008*x**2*y**4*z**2+2016*x**2*y**2*z**4-768*x**2*z**6+21*y**8-336*y**6*z**2+1008*y**4*z**4-768*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0]",
        ),
    },
    "D3d": {
        "Qh(0,A1g,,)": ("C0", "1", "[1]"),
        "Qh(2,A1g,,)": ("C0", "-x**2/2-y**2/2+z**2", "[0,0,1,0,0]"),
        "Qh(4,A1g,1,)": ("C0", "3*x**4/8+3*x**2*y**2/4-3*x**2*z**2+3*y**4/8-3*y**2*z**2+z**4", "[0,0,0,0,1,0,0,0,0]"),
        "Qh(6,A1g,1,)": (
            "C0",
            "-5*x**6/16-15*x**4*y**2/16+45*x**4*z**2/8-15*x**2*y**4/16+45*x**2*y**2*z**2/4-15*x**2*z**4/2-5*y**6/16+45*y**4*z**2/8-15*y**2*z**4/2+z**6",
            "[0,0,0,0,0,0,1,0,0,0,0,0,0]",
        ),
        "Qh(8,A1g,1,)": (
            "C0",
            "35*x**8/128+35*x**6*y**2/32-35*x**6*z**2/4+105*x**4*y**4/64-105*x**4*y**2*z**2/4+105*x**4*z**4/4+35*x**2*y**6/32-105*x**2*y**4*z**2/4+105*x**2*y**2*z**4/2-14*x**2*z**6+35*y**8/128-35*y**6*z**2/4+105*y**4*z**4/4-14*y**2*z**6+z**8",
            "[0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0]",
        ),
        "Qh(10,A1g,1,)": (
            "C0",
            "-63*x**10/256-315*x**8*y**2/256+1575*x**8*z**2/128-315*x**6*y**4/128+1575*x**6*y**2*z**2/32-525*x**6*z**4/8-315*x**4*y**6/128+4725*x**4*y**4*z**2/64-1575*x**4*y**2*z**4/8+315*x**4*z**6/4-315*x**2*y**8/256+1575*x**2*y**6*z**2/32-1575*x**2*y**4*z**4/8+315*x**2*y**2*z**6/2-45*x**2*z**8/2-63*y**10/256+1575*y**8*z**2/128-525*y**6*z**4/8+315*y**4*z**6/4-45*y**2*z**8/2+z**10",
            "[0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(4,A1g,2,)": ("C3", "sqrt(70)*x*z*(x**2-3*y**2)/4", "[0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(6,A1g,2,)": (
            "C6",
            "sqrt(462)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(8,A1g,2,)": (
            "C6",
            "-sqrt(858)*(x-y)*(x+y)*(x**2+y**2-14*z**2)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/64",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(10,A1g,2,)": (
            "C6",
            "sqrt(4290)*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(6,A1g,3,)": (
            "C3",
            "-sqrt(210)*x*z*(x**2-3*y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(8,A1g,3,)": (
            "C3",
            "sqrt(1155)*x*z*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(10,A1g,3,)": (
            "C9",
            "sqrt(461890)*x*z*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(10,A1g,4,)": (
            "C3",
            "-sqrt(4290)*x*z*(x**2-3*y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0]",
        ),
        "Qh(3,A1u,,)": ("S3", "sqrt(10)*y*(3*x**2-y**2)/4", "[sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(5,A1u,,)": ("S3", "-sqrt(70)*y*(3*x**2-y**2)*(x**2+y**2-8*z**2)/16", "[0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0]"),
        "Qh(7,A1u,1,)": (
            "S6",
            "sqrt(6006)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(9,A1u,1,)": (
            "S6",
            "-sqrt(4290)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**2+3*y**2-14*z**2)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(11,A1u,1,)": (
            "S6",
            "sqrt(14586)*x*y*z*(x**2-3*y**2)*(3*x**2-y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(7,A1u,2,)": (
            "S3",
            "sqrt(21)*y*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(9,A1u,2,)": (
            "S9",
            "sqrt(24310)*y*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(11,A1u,2,)": (
            "S9",
            "-sqrt(46189)*y*(3*x**2-y**2)*(x**2+y**2-20*z**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/512",
            "[0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(9,A1u,3,)": (
            "S3",
            "-sqrt(2310)*y*(3*x**2-y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0]",
        ),
        "Qh(11,A1u,3,)": (
            "S3",
            "sqrt(30030)*y*(3*x**2-y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(4,A2g,,)": ("S3", "sqrt(70)*y*z*(3*x**2-y**2)/4", "[0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0]"),
        "Qh(6,A2g,1,)": (
            "S6",
            "sqrt(462)*x*y*(x**2-3*y**2)*(3*x**2-y**2)/16",
            "[-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2]",
        ),
        "Qh(8,A2g,1,)": (
            "S6",
            "-sqrt(858)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(x**2+y**2-14*z**2)/32",
            "[0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0]",
        ),
        "Qh(10,A2g,1,)": (
            "S6",
            "sqrt(4290)*x*y*(x**2-3*y**2)*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-96*x**2*z**2+3*y**4-96*y**2*z**2+224*z**4)/256",
            "[0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0]",
        ),
        "Qh(6,A2g,2,)": (
            "S3",
            "-sqrt(210)*y*z*(3*x**2-y**2)*(3*x**2+3*y**2-8*z**2)/16",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(8,A2g,2,)": (
            "S3",
            "sqrt(1155)*y*z*(3*x**2-y**2)*(3*x**4+6*x**2*y**2-20*x**2*z**2+3*y**4-20*y**2*z**2+16*z**4)/32",
            "[0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(10,A2g,2,)": (
            "S9",
            "sqrt(461890)*y*z*(3*x**2-y**2)*(3*x**6-27*x**4*y**2+33*x**2*y**4-y**6)/256",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(10,A2g,3,)": (
            "S3",
            "-sqrt(4290)*y*z*(3*x**2-y**2)*(7*x**6+21*x**4*y**2-84*x**4*z**2+21*x**2*y**4-168*x**2*y**2*z**2+168*x**2*z**4+7*y**6-84*y**4*z**2+168*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0]",
        ),
        "Qh(1,A2u,,)": ("C0", "z", "[0,1,0]"),
        "Qh(3,A2u,1,)": ("C0", "-z*(3*x**2+3*y**2-2*z**2)/2", "[0,0,0,1,0,0,0]"),
        "Qh(5,A2u,1,)": ("C0", "z*(15*x**4+30*x**2*y**2-40*x**2*z**2+15*y**4-40*y**2*z**2+8*z**4)/8", "[0,0,0,0,0,1,0,0,0,0,0]"),
        "Qh(7,A2u,1,)": (
            "C0",
            "-z*(35*x**6+105*x**4*y**2-210*x**4*z**2+105*x**2*y**4-420*x**2*y**2*z**2+168*x**2*z**4+35*y**6-210*y**4*z**2+168*y**2*z**4-16*z**6)/16",
            "[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]",
        ),
        "Qh(9,A2u,1,)": (
            "C0",
            "z*(315*x**8+1260*x**6*y**2-3360*x**6*z**2+1890*x**4*y**4-10080*x**4*y**2*z**2+6048*x**4*z**4+1260*x**2*y**6-10080*x**2*y**4*z**2+12096*x**2*y**2*z**4-2304*x**2*z**6+315*y**8-3360*y**6*z**2+6048*y**4*z**4-2304*y**2*z**6+128*z**8)/128",
            "[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(11,A2u,1,)": (
            "C0",
            "-z*(693*x**10+3465*x**8*y**2-11550*x**8*z**2+6930*x**6*y**4-46200*x**6*y**2*z**2+36960*x**6*z**4+6930*x**4*y**6-69300*x**4*y**4*z**2+110880*x**4*y**2*z**4-31680*x**4*z**6+3465*x**2*y**8-46200*x**2*y**6*z**2+110880*x**2*y**4*z**4-63360*x**2*y**2*z**6+7040*x**2*z**8+693*y**10-11550*y**8*z**2+36960*y**6*z**4-31680*y**4*z**6+7040*y**2*z**8-256*z**10)/256",
            "[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0]",
        ),
        "Qh(3,A2u,2,)": ("C3", "sqrt(10)*x*(x**2-3*y**2)/4", "[-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(5,A2u,2,)": ("C3", "-sqrt(70)*x*(x**2-3*y**2)*(x**2+y**2-8*z**2)/16", "[0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0]"),
        "Qh(7,A2u,2,)": (
            "C6",
            "sqrt(6006)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)/32",
            "[0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(9,A2u,2,)": (
            "C6",
            "-sqrt(4290)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(3*x**2+3*y**2-14*z**2)/64",
            "[0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(11,A2u,2,)": (
            "C6",
            "sqrt(14586)*z*(x-y)*(x+y)*(x**2-4*x*y+y**2)*(x**2+4*x*y+y**2)*(15*x**4+30*x**2*y**2-160*x**2*z**2+15*y**4-160*y**2*z**2+224*z**4)/512",
            "[0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(7,A2u,3,)": (
            "C3",
            "sqrt(21)*x*(x**2-3*y**2)*(3*x**4+6*x**2*y**2-60*x**2*z**2+3*y**4-60*y**2*z**2+80*z**4)/32",
            "[0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0]",
        ),
        "Qh(9,A2u,3,)": (
            "C9",
            "sqrt(24310)*x*(x**2-3*y**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/256",
            "[-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2]",
        ),
        "Qh(11,A2u,3,)": (
            "C9",
            "-sqrt(46189)*x*(x**2-3*y**2)*(x**2+y**2-20*z**2)*(x**6-33*x**4*y**2+27*x**2*y**4-3*y**6)/512",
            "[0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(9,A2u,4,)": (
            "C3",
            "-sqrt(2310)*x*(x**2-3*y**2)*(x**6+3*x**4*y**2-36*x**4*z**2+3*x**2*y**4-72*x**2*y**2*z**2+120*x**2*z**4+y**6-36*y**4*z**2+120*y**2*z**4-64*z**6)/128",
            "[0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0]",
        ),
        "Qh(11,A2u,4,)": (
            "C3",
            "sqrt(30030)*x*(x**2-3*y**2)*(x**8+4*x**6*y**2-56*x**6*z**2+6*x**4*y**4-168*x**4*y**2*z**2+336*x**4*z**4+4*x**2*y**6-168*x**2*y**4*z**2+672*x**2*y**2*z**4-448*x**2*z**6+y**8-56*y**6*z**2+336*y**4*z**4-448*y**2*z**6+128*z**8)/512",
            "[0,0,0,0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0,0,0,0]",
        ),
        "Qh(2,Eg,1,0)": ("C1", "sqrt(3)*x*z", "[0,-sqrt(2)/2,0,sqrt(2)/2,0]"),
        "Qh(2,Eg,1,1)": ("S1", "sqrt(3)*y*z", "[0,sqrt(2)*I/2,0,sqrt(2)*I/2,0]"),
        "Qh(4,Eg,1,0)": ("C1", "-sqrt(10)*x*z*(3*x**2+3*y**2-4*z**2)/4", "[0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0]"),
        "Qh(4,Eg,1,1)": ("S1", "-sqrt(10)*y*z*(3*x**2+3*y**2-4*z**2)/4", "[0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0]"),
        "Qh(6,Eg,1,0)": ("C5", "3*sqrt(154)*x*z*(x**4-10*x**2*y**2+5*y**4)/16", "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]"),
        "Qh(6,Eg,1,1)": (
            "-S5",
            "-3*sqrt(154)*y*z*(5*x**4-10*x**2*y**2+y**4)/16",
            "[0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0]",
        ),
        "Qh(8,Eg,1,0)": (
            "C7",
            "3*sqrt(715)*x*z*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/32",
            "[0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0]",
        ),
        "Qh(8,Eg,1,1)": (
            "S7",
            "3*sqrt(715)*y*z*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/32",
            "[0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0]",
        ),
        "Qh(10,Eg,1,0)": (
            "C7",
            "-sqrt(72930)*x*z*(3*x**2+3*y**2-16*z**2)*(x**6-21*x**4*y**2+35*x**2*y**4-7*y**6)/256",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(10,Eg,1,1)": (
            "S7",
            "-sqrt(72930)*y*z*(3*x**2+3*y**2-16*z**2)*(7*x**6-35*x**4*y**2+21*x**2*y**4-y**6)/256",
            "[0,0,0,sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,0,0,0,0,sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(2,Eg,2,0)": ("C2", "sqrt(3)*(x-y)*(x+y)/2", "[sqrt(2)/2,0,0,0,sqrt(2)/2]"),
        "Qh(2,Eg,2,1)": ("-S2", "-sqrt(3)*x*y", "[sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2]"),
        "Qh(4,Eg,2,0)": ("C4", "sqrt(35)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/8", "[sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2]"),
        "Qh(4,Eg,2,1)": ("S4", "sqrt(35)*x*y*(x-y)*(x+y)/2", "[-sqrt(2)*I/2,0,0,0,0,0,0,0,sqrt(2)*I/2]"),
        "Qh(6,Eg,2,0)": (
            "C1",
            "sqrt(21)*x*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,-sqrt(2)/2,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(6,Eg,2,1)": (
            "S1",
            "sqrt(21)*y*z*(5*x**4+10*x**2*y**2-20*x**2*z**2+5*y**4-20*y**2*z**2+8*z**4)/8",
            "[0,0,0,0,0,sqrt(2)*I/2,0,sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(8,Eg,2,0)": (
            "C5",
            "-3*sqrt(1001)*x*z*(x**2+y**2-4*z**2)*(x**4-10*x**2*y**2+5*y**4)/32",
            "[0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0]",
        ),
        "Qh(8,Eg,2,1)": (
            "-S5",
            "3*sqrt(1001)*y*z*(x**2+y**2-4*z**2)*(5*x**4-10*x**2*y**2+y**4)/32",
            "[0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0]",
        ),
        "Qh(10,Eg,2,0)": (
            "C5",
            "sqrt(858)*x*z*(x**4-10*x**2*y**2+5*y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)/2,0,0,0,0,0,0,0,0,0,sqrt(2)/2,0,0,0,0,0]",
        ),
        "Qh(10,Eg,2,1)": (
            "-S5",
            "-sqrt(858)*y*z*(5*x**4-10*x**2*y**2+y**4)*(15*x**4+30*x**2*y**2-140*x**2*z**2+15*y**4-140*y**2*z**2+168*z**4)/128",
            "[0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0,0,0,0,0,-sqrt(2)*I/2,0,0,0,0,0]",
        ),
        "Qh(4,Eg,3,0)": ("C2", "-sqrt(5)*(x-y)*(x+y)*(x**2+y**2-6*z**2)/4", "[0,0,sqrt(2)/2,0,0,0,sqrt(2)/2,0,0]"),
        "Qh(4,Eg,3,1)": ("-S2", "sqrt(5)*x*y*(x**2+y**2-6*z**2)/2", "[0,0,sqrt(2)*I/2,0,0,0,-sqrt(2)*I/2,0,0]"),
        "Qh(6,Eg,3,0)": (
            "C4",
            "-3*sqrt(7)*(x**2+y**2-10*z**2)*(x**2-2*x*y-y**2)*(x**2+2*x*y-y**2)/16",
            "[0,0,sqrt(2)/2,0,0,0,0,0,0,0,sqrt(2)/2,0,0]",
        ),
        "Qh(6,Eg,3,1)": (
            "S4",
            "-3*sqrt(7)*x*y*(x-y)*(x+