"""
character table for all point groups.
    { pg_tag : ( [symmetry operations (conjugacy class)] [#SO], { irrep: [character] } ) }

    complex character
        wp = exp(+2pi i/3), wm = exp(-2pi i/3)
"""
_data_character = {
    "C1": (["1"], [1], {"A": "[1]"}),
    "Ci": (["1", "-1"], [1, 1], {"Ag": "[1, 1]", "Au": "[1, -1]"}),
    "C2": (["1", "2[010]"], [1, 1], {"A": "[1, 1]", "B": "[1, -1]"}),
    "Cs": (["1", "m[010]"], [1, 1], {"A'": "[1, 1]", "A''": "[1, -1]"}),
    "C2h": (
        ["1", "2[010]", "-1", "m[010]"],
        [1, 1, 1, 1],
        {"Ag": "[1, 1, 1, 1]", "Bg": "[1, -1, 1, -1]", "Au": "[1, 1, -1, -1]", "Bu": "[1, -1, -1, 1]"},
    ),
    "D2": (
        ["1", "2[001]", "2[010]", "2[100]"],
        [1, 1, 1, 1],
        {"A": "[1, 1, 1, 1]", "B1": "[1, 1, -1, -1]", "B2": "[1, -1, 1, -1]", "B3": "[1, -1, -1, 1]"},
    ),
    "C2v": (
        ["1", "2[001]", "m[010]", "m[100]"],
        [1, 1, 1, 1],
        {"A1": "[1, 1, 1, 1]", "A2": "[1, 1, -1, -1]", "B1": "[1, -1, 1, -1]", "B2": "[1, -1, -1, 1]"},
    ),
    "D2h": (
        ["1", "2[001]", "2[010]", "2[100]", "-1", "m[001]", "m[010]", "m[100]"],
        [1, 1, 1, 1, 1, 1, 1, 1],
        {
            "Ag": "[1, 1, 1, 1, 1, 1, 1, 1]",
            "B1g": "[1, 1, -1, -1, 1, 1, -1, -1]",
            "B2g": "[1, -1, 1, -1, 1, -1, 1, -1]",
            "B3g": "[1, -1, -1, 1, 1, -1, -1, 1]",
            "Au": "[1, 1, 1, 1, -1, -1, -1, -1]",
            "B1u": "[1, 1, -1, -1, -1, -1, 1, 1]",
            "B2u": "[1, -1, 1, -1, -1, 1, -1, 1]",
            "B3u": "[1, -1, -1, 1, -1, 1, 1, -1]",
        },
    ),
    "C4": (
        ["1", "2[001]", "4+[001]", "4-[001]"],
        [1, 1, 1, 1],
        {"A": "[1, 1, 1, 1]", "B": "[1, 1, -1, -1]", "Ea": "[1, -1, -I, I]", "Eb": "[1, -1, I, -I]"},
    ),
    "S4": (
        ["1", "2[001]", "-4+[001]", "-4-[001]"],
        [1, 1, 1, 1],
        {"A": "[1, 1, 1, 1]", "B": "[1, 1, -1, -1]", "Ea": "[1, -1, I, -I]", "Eb": "[1, -1, -I, I]"},
    ),
    "C4h": (
        ["1", "2[001]", "4+[001]", "4-[001]", "-1", "m[001]", "-4+[001]", "-4-[001]"],
        [1, 1, 1, 1, 1, 1, 1, 1],
        {
            "Ag": "[1, 1, 1, 1, 1, 1, 1, 1]",
            "Bg": "[1, 1, -1, -1, 1, 1, -1, -1]",
            "Ega": "[1, -1, -I, I, 1, -1, -I, I]",
            "Egb": "[1, -1, I, -I, 1, -1, I, -I]",
            "Au": "[1, 1, 1, 1, -1, -1, -1, -1]",
            "Bu": "[1, 1, -1, -1, -1, -1, 1, 1]",
            "Eua": "[1, -1, -I, I, -1, 1, I, -I]",
            "Eub": "[1, -1, I, -I, -1, 1, -I, I]",
        },
    ),
    "D4": (
        ["1", "2[001]", "2[100]", "2[110]", "4+[001]"],
        [1, 1, 2, 2, 2],
        {
            "A1": "[1, 1, 1, 1, 1]",
            "A2": "[1, 1, -1, -1, 1]",
            "B1": "[1, 1, 1, -1, -1]",
            "B2": "[1, 1, -1, 1, -1]",
            "E": "[2, -2, 0, 0, 0]",
        },
    ),
    "C4v": (
        ["1", "2[001]", "4+[001]", "m[100]", "m[110]"],
        [1, 1, 2, 2, 2],
        {
            "A1": "[1, 1, 1, 1, 1]",
            "A2": "[1, 1, 1, -1, -1]",
            "B1": "[1, 1, -1, 1, -1]",
            "B2": "[1, 1, -1, -1, 1]",
            "E": "[2, -2, 0, 0, 0]",
        },
    ),
    "D2d": (
        ["1", "2[001]", "2[100]", "m[110]", "-4+[001]"],
        [1, 1, 2, 2, 2],
        {
            "A1": "[1, 1, 1, 1, 1]",
            "A2": "[1, 1, -1, -1, 1]",
            "B1": "[1, 1, 1, -1, -1]",
            "B2": "[1, 1, -1, 1, -1]",
            "E": "[2, -2, 0, 0, 0]",
        },
    ),
    "D2d-1": (
        ["1", "2[001]", "2[110]", "m[100]", "-4+[001]"],
        [1, 1, 2, 2, 2],
        {
            "A1": "[1, 1, 1, 1, 1]",
            "A2": "[1, 1, -1, -1, 1]",
            "B1": "[1, 1, 1, -1, -1]",
            "B2": "[1, 1, -1, 1, -1]",
            "E": "[2, -2, 0, 0, 0]",
        },
    ),
    "D4h": (
        ["1", "2[001]", "2[100]", "2[110]", "4+[001]", "-1", "m[001]", "m[100]", "m[110]", "-4+[001]"],
        [1, 1, 2, 2, 2, 1, 1, 2, 2, 2],
        {
            "A1g": "[1, 1, 1, 1, 1, 1, 1, 1, 1, 1]",
            "A2g": "[1, 1, -1, -1, 1, 1, 1, -1, -1, 1]",
            "B1g": "[1, 1, 1, -1, -1, 1, 1, 1, -1, -1]",
            "B2g": "[1, 1, -1, 1, -1, 1, 1, -1, 1, -1]",
            "Eg": "[2, -2, 0, 0, 0, 2, -2, 0, 0, 0]",
            "A1u": "[1, 1, 1, 1, 1, -1, -1, -1, -1, -1]",
            "A2u": "[1, 1, -1, -1, 1, -1, -1, 1, 1, -1]",
            "B1u": "[1, 1, 1, -1, -1, -1, -1, -1, 1, 1]",
            "B2u": "[1, 1, -1, 1, -1, -1, -1, 1, -1, 1]",
            "Eu": "[2, -2, 0, 0, 0, -2, 2, 0, 0, 0]",
        },
    ),
    "C3": (["1", "3+[001]", "3-[001]"], [1, 1, 1], {"A": "[1, 1, 1]", "Ea": "[1, wm, wp]", "Eb": "[1, wp, wm]"}),
    "C3i": (
        ["1", "3+[001]", "3-[001]", "-1", "-3+[001]", "-3-[001]"],
        [1, 1, 1, 1, 1, 1],
        {
            "Ag": "[1, 1, 1, 1, 1, 1]",
            "Ega": "[1, wm, wp, 1, wm, wp]",
            "Egb": "[1, wp, wm, 1, wp, wm]",
            "Au": "[1, 1, 1, -1, -1, -1]",
            "Eua": "[1, wm, wp, -1, -wm, -wp]",
            "Eub": "[1, wp, wm, -1, -wp, -wm]",
        },
    ),
    "D3": (["1", "2[120]", "3+[001]"], [1, 3, 2], {"A1": "[1, 1, 1]", "A2": "[1, -1, 1]", "E": "[2, 0, -1]"}),
    "D3-1": (["1", "2[100]", "3+[001]"], [1, 3, 2], {"A1": "[1, 1, 1]", "A2": "[1, -1, 1]", "E": "[2, 0, -1]"}),
    "C3v": (["1", "3+[001]", "m[100]"], [1, 2, 3], {"A1": "[1, 1, 1]", "A2": "[1, 1, -1]", "E": "[2, -1, 0]"}),
    "C3v-1": (["1", "3+[001]", "m[120]"], [1, 2, 3], {"A1": "[1, 1, 1]", "A2": "[1, 1, -1]", "E": "[2, -1, 0]"}),
    "D3d": (
        ["1", "2[120]", "3+[001]", "-1", "m[120]", "-3+[001]"],
        [1, 3, 2, 1, 3, 2],
        {
            "A1g": "[1, 1, 1, 1, 1, 1]",
            "A2g": "[1, -1, 1, 1, -1, 1]",
            "Eg": "[2, 0, -1, 2, 0, -1]",
            "A1u": "[1, 1, 1, -1, -1, -1]",
            "A2u": "[1, -1, 1, -1, 1, -1]",
            "Eu": "[2, 0, -1, -2, 0, 1]",
        },
    ),
    "D3d-1": (
        ["1", "2[100]", "3+[001]", "-1", "m[100]", "-3+[001]"],
        [1, 3, 2, 1, 3, 2],
        {
            "A1g": "[1, 1, 1, 1, 1, 1]",
            "A2g": "[1, -1, 1, 1, -1, 1]",
            "Eg": "[2, 0, -1, 2, 0, -1]",
            "A1u": "[1, 1, 1, -1, -1, -1]",
            "A2u": "[1, -1, 1, -1, 1, -1]",
            "Eu": "[2, 0, -1, -2, 0, 1]",
        },
    ),
    "C6": (
        ["1", "2[001]", "3+[001]", "3-[001]", "6+[001]", "6-[001]"],
        [1, 1, 1, 1, 1, 1],
        {
            "A": "[1, 1, 1, 1, 1, 1]",
            "B": "[1, -1, 1, 1, -1, -1]",
            "E1a": "[1, -1, wm, wp, -wp, -wm]",
            "E1b": "[1, -1, wp, wm, -wm, -wp]",
            "E2a": "[1, 1, wm, wp, wp, wm]",
            "E2b": "[1, 1, wp, wm, wm, wp]",
        },
    ),
    "C3h": (
        ["1", "3+[001]", "3-[001]", "m[001]", "-6+[001]", "-6-[001]"],
        [1, 1, 1, 1, 1, 1],
        {
            "A'": "[1, 1, 1, 1, 1, 1]",
            "A''": "[1, 1, 1, -1, -1, -1]",
            "Ea'": "[1, wm, wp, 1, wp, wm]",
            "Eb'": "[1, wp, wm, 1, wm, wp]",
            "Ea''": "[1, wm, wp, -1, -wp, -wm]",
            "Eb''": "[1, wp, wm, -1, -wm, -wp]",
        },
    ),
    "C6h": (
        [
            "1",
            "2[001]",
            "3+[001]",
            "3-[001]",
            "6+[001]",
            "6-[001]",
            "-1",
            "m[001]",
            "-3+[001]",
            "-3-[001]",
            "-6+[001]",
            "-6-[001]",
        ],
        [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
        {
            "Ag": "[1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]",
            "Bg": "[1, -1, 1, 1, -1, -1, 1, -1, 1, 1, -1, -1]",
            "E1ga": "[1, -1, wm, wp, -wp, -wm, 1, -1, wm, wp, -wp, -wm]",
            "E1gb": "[1, -1, wp, wm, -wm, -wp, 1, -1, wp, wm, -wm, -wp]",
            "E2ga": "[1, 1, wm, wp, wp, wm, 1, 1, wm, wp, wp, wm]",
            "E2gb": "[1, 1, wp, wm, wm, wp, 1, 1, wp, wm, wm, wp]",
            "Au": "[1, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, -1]",
            "Bu": "[1, -1, 1, 1, -1, -1, -1, 1, -1, -1, 1, 1]",
            "E1ua": "[1, -1, wm, wp, -wp, -wm, -1, 1, -wm, -wp, wp, wm]",
            "E1ub": "[1, -1, wp, wm, -wm, -wp, -1, 1, -wp, -wm, wm, wp]",
            "E2ua": "[1, 1, wm, wp, wp, wm, -1, -1, -wm, -wp, -wp, -wm]",
            "E2ub": "[1, 1, wp, wm, wm, wp, -1, -1, -wp, -wm, -wm, -wp]",
        },
    ),
    "D6": (
        ["1", "2[001]", "2[100]", "2[120]", "3+[001]", "6+[001]"],
        [1, 1, 3, 3, 2, 2],
        {
            "A1": "[1, 1, 1, 1, 1, 1]",
            "A2": "[1, 1, -1, -1, 1, 1]",
            "B1": "[1, -1, -1, 1, 1, -1]",
            "B2": "[1, -1, 1, -1, 1, -1]",
            "E1": "[2, -2, 0, 0, -1, 1]",
            "E2": "[2, 2, 0, 0, -1, -1]",
        },
    ),
    "C6v": (
        ["1", "2[001]", "3+[001]", "6+[001]", "m[100]", "m[120]"],
        [1, 1, 2, 2, 3, 3],
        {
            "A1": "[1, 1, 1, 1, 1, 1]",
            "A2": "[1, 1, 1, 1, -1, -1]",
            "B1": "[1, -1, 1, -1, 1, -1]",
            "B2": "[1, -1, 1, -1, -1, 1]",
            "E1": "[2, -2, -1, 1, 0, 0]",
            "E2": "[2, 2, -1, -1, 0, 0]",
        },
    ),
    "D3h": (
        ["1", "2[120]", "3+[001]", "m[100]", "m[001]", "-6+[001]"],
        [1, 3, 2, 3, 1, 2],
        {
            "A1'": "[1, 1, 1, 1, 1, 1]",
            "A2'": "[1, -1, 1, -1, 1, 1]",
            "A1''": "[1, 1, 1, -1, -1, -1]",
            "A2''": "[1, -1, 1, 1, -1, -1]",
            "E'": "[2, 0, -1, 0, 2, -1]",
            "E''": "[2, 0, -1, 0, -2, 1]",
        },
    ),
    "D3h-1": (
        ["1", "2[100]", "3+[001]", "m[001]", "m[120]", "-6+[001]"],
        [1, 3, 2, 1, 3, 2],
        {
            "A1'": "[1, 1, 1, 1, 1, 1]",
            "A2'": "[1, -1, 1, 1, -1, 1]",
            "A1''": "[1, 1, 1, -1, -1, -1]",
            "A2''": "[1, -1, 1, -1, 1, -1]",
            "E'": "[2, 0, -1, 2, 0, -1]",
            "E''": "[2, 0, -1, -2, 0, 1]",
        },
    ),
    "D6h": (
        ["1", "2[001]", "2[100]", "2[120]", "3+[001]", "6+[001]", "-1", "m[100]", "m[001]", "m[120]", "-3+[001]", "-6+[001]"],
        [1, 1, 3, 3, 2, 2, 1, 3, 1, 3, 2, 2],
        {
            "A1g": "[1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]",
            "A2g": "[1, 1, -1, -1, 1, 1, 1, -1, 1, -1, 1, 1]",
            "B1g": "[1, -1, -1, 1, 1, -1, 1, -1, -1, 1, 1, -1]",
            "B2g": "[1, -1, 1, -1, 1, -1, 1, 1, -1, -1, 1, -1]",
            "E1g": "[2, -2, 0, 0, -1, 1, 2, 0, -2, 0, -1, 1]",
            "E2g": "[2, 2, 0, 0, -1, -1, 2, 0, 2, 0, -1, -1]",
            "A1u": "[1, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, -1]",
            "A2u": "[1, 1, -1, -1, 1, 1, -1, 1, -1, 1, -1, -1]",
            "B1u": "[1, -1, -1, 1, 1, -1, -1, 1, 1, -1, -1, 1]",
            "B2u": "[1, -1, 1, -1, 1, -1, -1, -1, 1, 1, -1, 1]",
            "E1u": "[2, -2, 0, 0, -1, 1, -2, 0, 2, 0, 1, -1]",
            "E2u": "[2, 2, 0, 0, -1, -1, -2, 0, -2, 0, 1, 1]",
        },
    ),
    "T": (
        ["1", "2[001]", "3+[111]", "3-[111]"],
        [1, 3, 4, 4],
        {"A": "[1, 1, 1, 1]", "Ea": "[1, 1, wm, wp]", "Eb": "[1, 1, wp, wm]", "T": "[3, -1, 0, 0]"},
    ),
    "Th": (
        ["1", "2[001]", "3+[111]", "3-[111]", "-1", "m[001]", "-3+[111]", "-3-[111]"],
        [1, 3, 4, 4, 1, 3, 4, 4],
        {
            "Ag": "[1, 1, 1, 1, 1, 1, 1, 1]",
            "Ega": "[1, 1, wm, wp, 1, 1, wm, wp]",
            "Egb": "[1, 1, wp, wm, 1, 1, wp, wm]",
            "Tg": "[3, -1, 0, 0, 3, -1, 0, 0]",
            "Au": "[1, 1, 1, 1, -1, -1, -1, -1]",
            "Eua": "[1, 1, wm, wp, -1, -1, -wm, -wp]",
            "Eub": "[1, 1, wp, wm, -1, -1, -wp, -wm]",
            "Tu": "[3, -1, 0, 0, -3, 1, 0, 0]",
        },
    ),
    "O": (
        ["1", "2[001]", "2[110]", "3+[111]", "4+[001]"],
        [1, 3, 6, 8, 6],
        {
            "A1": "[1, 1, 1, 1, 1]",
            "A2": "[1, 1, -1, 1, -1]",
            "E": "[2, 2, 0, -1, 0]",
            "T1": "[3, -1, -1, 0, 1]",
            "T2": "[3, -1, 1, 0, -1]",
        },
    ),
    "Td": (
        ["1", "2[001]", "3+[111]", "m[110]", "-4+[001]"],
        [1, 3, 8, 6, 6],
        {
            "A1": "[1, 1, 1, 1, 1]",
            "A2": "[1, 1, 1, -1, -1]",
            "E": "[2, 2, -1, 0, 0]",
            "T1": "[3, -1, 0, -1, 1]",
            "T2": "[3, -1, 0, 1, -1]",
        },
    ),
    "Oh": (
        ["1", "2[001]", "2[110]", "3+[111]", "4+[001]", "-1", "m[001]", "m[110]", "-3+[111]", "-4+[001]"],
        [1, 3, 6, 8, 6, 1, 3, 6, 8, 6],
        {
            "A1g": "[1, 1, 1, 1, 1, 1, 1, 1, 1, 1]",
            "A2g": "[1, 1, -1, 1, -1, 1, 1, -1, 1, -1]",
            "Eg": "[2, 2, 0, -1, 0, 2, 2, 0, -1, 0]",
            "T1g": "[3, -1, -1, 0, 1, 3, -1, -1, 0, 1]",
            "T2g": "[3, -1, 1, 0, -1, 3, -1, 1, 0, -1]",
            "A1u": "[1, 1, 1, 1, 1, -1, -1, -1, -1, -1]",
            "A2u": "[1, 1, -1, 1, -1, -1, -1, 1, -1, 1]",
            "Eu": "[2, 2, 0, -1, 0, -2, -2, 0, 1, 0]",
            "T1u": "[3, -1, -1, 0, 1, -3, 1, 1, 0, -1]",
            "T2u": "[3, -1, 1, 0, -1, -3, 1, -1, 0, 1]",
        },
    ),
}
