# MultiPie

A Python library for crystallographic symmetry operations and Symmetry-Adapted Multipole Basis (SAMB).
Molecular or crystal structures are best drawn by using [QtDraw](https://github.com/CMT-MU/QtDraw).

## Installation

MultiPie can be installed from PyPI using pip on Python >= 3.9:
```
pip install multipie
```
You can also visit
[PyPI](https://pypi.org/project/multipie/) or [GitHub](https://github.com/CMT-MU/MultiPie) to download the source.

## Authors
Hiroaki Kusunose and Rikuto Oiwa

## Citing MultiPie and QtDraw

If you are using MultiPie and/or QtDraw in your scientific research, please help our scientific visibility by citing our work:

> Hiroaki Kusunose, Rikuto Oiwa, and Satoru Hayami, _Symmetry-adapted modeling for molecules and crystals_, Phys. Rev. B <b>107</b>, 195118 (2023).
>
> DOI: [https://doi.org/10.1103/PhysRevB.107.195118](https://doi.org/10.1103/PhysRevB.107.195118)

BibTex:
```
@article{PhysRevB.107.195118,
title = {Symmetry-adapted modeling for molecules and crystals},
author = {Kusunose, Hiroaki and Oiwa, Rikuto and Hayami, Satoru},
journal = {Phys. Rev. B},
volume = {107},
issue = {19},
pages = {195118},
numpages = {14},
year = {2023},
month = {May},
publisher = {American Physical Society},
doi = {10.1103/PhysRevB.107.195118},
url = {https://link.aps.org/doi/10.1103/PhysRevB.107.195118}
}
```

## Requirements
- This library optionally requires [TeXLive](https://www.tug.org/texlive/) environment to create LaTeX and PDF files.
- Molecular or crystal structure files are optionally generated by [QtDraw](https://github.com/CMT-MU/QtDraw).

## Documentation

Refer to the [documentation](https://cmt-mu.github.io/MultiPie/) for detailed installation and usage.
See also, [Manual](https://github.com/CMT-MU/QtDraw/blob/main/docs/manual.pdf).
