# generated by datamodel-codegen:
#   filename:  monoid_protocol.json
#   timestamp: 2022-11-28T06:45:50+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel


class MonoidQueryIdentifier(BaseModel):
    schema_name: str
    schema_group: Optional[str] = None
    identifier: str
    identifier_query: Union[str, int]
    json_schema: Dict[str, Any]


class RecordType(Enum):
    RECORD = 'RECORD'
    FILE = 'FILE'


class MonoidRecord(BaseModel):
    record_type: Optional[RecordType] = None
    schema_name: str
    schema_group: Optional[str] = None
    data: Optional[Dict[str, Any]] = None
    file: Optional[str] = None


class MonoidSchema(BaseModel):
    name: str
    group: Optional[str] = None
    json_schema: Dict[str, Any]


class MonoidSiloSpec(BaseModel):
    name: Optional[str] = None
    spec: Dict[str, Any]


class MonoidSchemasMessage(BaseModel):
    schemas: List[MonoidSchema]


class Status(Enum):
    SUCCESS = 'SUCCESS'
    FAILURE = 'FAILURE'


class MonoidValidateMessage(BaseModel):
    status: Status
    message: Optional[str] = None


class MonoidLogMessage(BaseModel):
    message: str


class MonoidPersistenceConfig(BaseModel):
    temp_store: str


class RequestStatus(Enum):
    PROGRESS = 'PROGRESS'
    COMPLETE = 'COMPLETE'
    FAILED = 'FAILED'


class DataType(Enum):
    RECORDS = 'RECORDS'
    FILE = 'FILE'
    NONE = 'NONE'


class MonoidRequestStatus(BaseModel):
    schema_group: Optional[str] = None
    schema_name: str
    request_status: RequestStatus
    data_type: Optional[DataType] = None


class RequestType(Enum):
    QUERY = 'QUERY'
    DELETE = 'DELETE'


class MonoidRequestHandle(BaseModel):
    schema_group: Optional[str] = None
    schema_name: str
    data: Optional[Dict[str, Any]] = None
    request_type: RequestType


class MonoidRequestsMessage(BaseModel):
    handles: List[MonoidRequestHandle]


class Type(Enum):
    SCHEMA = 'SCHEMA'
    RECORD = 'RECORD'
    SPEC = 'SPEC'
    REQUEST_RESULT = 'REQUEST_RESULT'
    REQUEST_STATUS = 'REQUEST_STATUS'
    VALIDATE = 'VALIDATE'
    LOG = 'LOG'


class MonoidQuery(BaseModel):
    identifiers: List[MonoidQueryIdentifier]


class MonoidRequestResult(BaseModel):
    status: MonoidRequestStatus
    handle: MonoidRequestHandle


class MonoidMessage(BaseModel):
    type: Type
    record: Optional[MonoidRecord] = None
    schema_msg: Optional[MonoidSchemasMessage] = None
    spec: Optional[MonoidSiloSpec] = None
    validate_msg: Optional[MonoidValidateMessage] = None
    log: Optional[MonoidLogMessage] = None
    request: Optional[MonoidRequestResult] = None
    request_status: Optional[MonoidRequestStatus] = None


class MonoidProtocol(BaseModel):
    MonoidMessage: Optional[MonoidMessage] = None
