"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.singletonActionRole = void 0;
const iam = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Obtain the Role for the TopicRule
 *
 * If a role already exists, it will be returned. This ensures that if a rule have multiple
 * actions, they will share a role.
 * @internal
 */
function singletonActionRole(scope) {
    const id = 'TopicRuleActionRole';
    const existing = scope.node.tryFindChild(id);
    if (existing) {
        return existing;
    }
    ;
    const role = new iam.Role(scope, id, {
        roleName: aws_cdk_lib_1.PhysicalName.GENERATE_IF_NEEDED,
        assumedBy: new iam.ServicePrincipal('iot.amazonaws.com'),
    });
    return role;
}
exports.singletonActionRole = singletonActionRole;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicm9sZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInJvbGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsMkNBQTJDO0FBQzNDLDZDQUEyQztBQUczQzs7Ozs7O0dBTUc7QUFDSCxTQUFnQixtQkFBbUIsQ0FBQyxLQUFpQjtJQUNuRCxNQUFNLEVBQUUsR0FBRyxxQkFBcUIsQ0FBQztJQUNqQyxNQUFNLFFBQVEsR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxFQUFFLENBQWMsQ0FBQztJQUMxRCxJQUFJLFFBQVEsRUFBRTtRQUNaLE9BQU8sUUFBUSxDQUFDO0tBQ2pCO0lBQUEsQ0FBQztJQUVGLE1BQU0sSUFBSSxHQUFHLElBQUksR0FBRyxDQUFDLElBQUksQ0FBQyxLQUFrQixFQUFFLEVBQUUsRUFBRTtRQUNoRCxRQUFRLEVBQUUsMEJBQVksQ0FBQyxrQkFBa0I7UUFDekMsU0FBUyxFQUFFLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG1CQUFtQixDQUFDO0tBQ3pELENBQUMsQ0FBQztJQUNILE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQVpELGtEQVlDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgaWFtIGZyb20gJ2F3cy1jZGstbGliL2F3cy1pYW0nO1xuaW1wb3J0IHsgUGh5c2ljYWxOYW1lIH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgQ29uc3RydWN0LCBJQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbi8qKlxuICogT2J0YWluIHRoZSBSb2xlIGZvciB0aGUgVG9waWNSdWxlXG4gKlxuICogSWYgYSByb2xlIGFscmVhZHkgZXhpc3RzLCBpdCB3aWxsIGJlIHJldHVybmVkLiBUaGlzIGVuc3VyZXMgdGhhdCBpZiBhIHJ1bGUgaGF2ZSBtdWx0aXBsZVxuICogYWN0aW9ucywgdGhleSB3aWxsIHNoYXJlIGEgcm9sZS5cbiAqIEBpbnRlcm5hbFxuICovXG5leHBvcnQgZnVuY3Rpb24gc2luZ2xldG9uQWN0aW9uUm9sZShzY29wZTogSUNvbnN0cnVjdCk6IGlhbS5JUm9sZSB7XG4gIGNvbnN0IGlkID0gJ1RvcGljUnVsZUFjdGlvblJvbGUnO1xuICBjb25zdCBleGlzdGluZyA9IHNjb3BlLm5vZGUudHJ5RmluZENoaWxkKGlkKSBhcyBpYW0uSVJvbGU7XG4gIGlmIChleGlzdGluZykge1xuICAgIHJldHVybiBleGlzdGluZztcbiAgfTtcblxuICBjb25zdCByb2xlID0gbmV3IGlhbS5Sb2xlKHNjb3BlIGFzIENvbnN0cnVjdCwgaWQsIHtcbiAgICByb2xlTmFtZTogUGh5c2ljYWxOYW1lLkdFTkVSQVRFX0lGX05FRURFRCxcbiAgICBhc3N1bWVkQnk6IG5ldyBpYW0uU2VydmljZVByaW5jaXBhbCgnaW90LmFtYXpvbmF3cy5jb20nKSxcbiAgfSk7XG4gIHJldHVybiByb2xlO1xufVxuIl19