"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotEventsPutMessageAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const role_1 = require("./private/role");
/**
 * The action to put the message from an MQTT message to the IoT Events input.
 */
class IotEventsPutMessageAction {
    /**
     * @param input The IoT Events input to put messages.
     * @param props Optional properties to not use default
     */
    constructor(input, props = {}) {
        this.input = input;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_IotEventsPutMessageActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IotEventsPutMessageAction);
            }
            throw error;
        }
        this.batchMode = props.batchMode;
        this.messageId = props.messageId;
        this.role = props.role;
        if (this.batchMode && this.messageId) {
            throw new Error('messageId is not allowed when batchMode is true');
        }
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.role ?? role_1.singletonActionRole(rule);
        this.input.grantWrite(role);
        return {
            configuration: {
                iotEvents: {
                    batchMode: this.batchMode,
                    inputName: this.input.inputName,
                    messageId: this.messageId,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.IotEventsPutMessageAction = IotEventsPutMessageAction;
_a = JSII_RTTI_SYMBOL_1;
IotEventsPutMessageAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.IotEventsPutMessageAction", version: "2.71.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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