"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoDBv2PutItemAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const role_1 = require("./private/role");
/**
 * The action to put the record from an MQTT message to the DynamoDB table.
 */
class DynamoDBv2PutItemAction {
    /**
     * @param table the DynamoDB table in which to put the items.
     * @param props Optional properties to not use default
     */
    constructor(table, props = {}) {
        this.table = table;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_DynamoDBv2PutItemActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DynamoDBv2PutItemAction);
            }
            throw error;
        }
        this.role = props.role;
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.role ?? role_1.singletonActionRole(rule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['dynamodb:PutItem'],
            resources: [this.table.tableArn],
        }));
        return {
            configuration: {
                dynamoDBv2: {
                    putItem: {
                        tableName: this.table.tableName,
                    },
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.DynamoDBv2PutItemAction = DynamoDBv2PutItemAction;
_a = JSII_RTTI_SYMBOL_1;
DynamoDBv2PutItemAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.DynamoDBv2PutItemAction", version: "2.71.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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