import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * An example resource schema demonstrating some basic constructs and validation rules.
 *
 * @schema CfnProjectIpAccessListProps
 */
export interface CfnProjectIpAccessListProps {
    /**
     * @schema CfnProjectIpAccessListProps#AccessList
     */
    readonly accessList: AccessListDefinition[];
    /**
     * @schema CfnProjectIpAccessListProps#ApiKeys
     */
    readonly apiKeys: ApiKeyDefinition;
    /**
     * The unique identifier for the project to which you want to add one or more ip access list entries.
     *
     * @schema CfnProjectIpAccessListProps#ProjectId
     */
    readonly projectId: string;
}
/**
 * Converts an object of type 'CfnProjectIpAccessListProps' to JSON representation.
 */
export declare function toJson_CfnProjectIpAccessListProps(obj: CfnProjectIpAccessListProps | undefined): Record<string, any> | undefined;
/**
 * @schema accessListDefinition
 */
export interface AccessListDefinition {
    /**
     * ID of the AWS security group to allow access. Mutually exclusive with CIDRBlock and IPAddress.
     *
     * @schema accessListDefinition#AwsSecurityGroup
     */
    readonly awsSecurityGroup?: string;
    /**
     * Accessable entry in Classless Inter-Domain Routing (CIDR) notation. Mutually exclusive with ipAddress and AwsSecurityGroup.
     *
     * @schema accessListDefinition#CIDRBlock
     */
    readonly cidrBlock?: string;
    /**
     * Comment associated with the ip access list entry.
     *
     * @schema accessListDefinition#Comment
     */
    readonly comment?: string;
    /**
     * Accessable IP address. Mutually exclusive with CIDRBlock and AwsSecurityGroup.
     *
     * @schema accessListDefinition#IPAddress
     */
    readonly ipAddress?: string;
    /**
     * The unique identifier for the project to which you want to add one or more ip access list entries.
     *
     * @schema accessListDefinition#ProjectId
     */
    readonly projectId?: string;
}
/**
 * Converts an object of type 'AccessListDefinition' to JSON representation.
 */
export declare function toJson_AccessListDefinition(obj: AccessListDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema apiKeyDefinition
 */
export interface ApiKeyDefinition {
    /**
     * @schema apiKeyDefinition#PrivateKey
     */
    readonly privateKey?: string;
    /**
     * @schema apiKeyDefinition#PublicKey
     */
    readonly publicKey?: string;
}
/**
 * Converts an object of type 'ApiKeyDefinition' to JSON representation.
 */
export declare function toJson_ApiKeyDefinition(obj: ApiKeyDefinition | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `MongoDB::Atlas::ProjectIpAccessList`
 *
 * @cloudformationResource MongoDB::Atlas::ProjectIpAccessList
 * @stability external
 * @link https://github.com/aws-cloudformation/aws-cloudformation-rpdk.git
 */
export declare class CfnProjectIpAccessList extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "MongoDB::Atlas::ProjectIpAccessList";
    /**
     * Resource props.
     */
    readonly props: CfnProjectIpAccessListProps;
    /**
     * Attribute `MongoDB::Atlas::ProjectIpAccessList.Id`
     * @link https://github.com/aws-cloudformation/aws-cloudformation-rpdk.git
     */
    readonly attrId: string;
    /**
     * Attribute `MongoDB::Atlas::ProjectIpAccessList.TotalCount`
     * @link https://github.com/aws-cloudformation/aws-cloudformation-rpdk.git
     */
    readonly attrTotalCount: number;
    /**
     * Create a new `MongoDB::Atlas::ProjectIpAccessList`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnProjectIpAccessListProps);
}
