# AUTOGENERATED! DO NOT EDIT! File to edit: ../00_core.ipynb.

# %% auto 0
__all__ = ['colab_gee_setup']

# %% ../00_core.ipynb 5
def colab_gee_setup():
  """Setup Colab so it can use the earthengine-jupyter package.
  
  * Install earthengine-jupyter package.
  * Authenticate, if needed."""
  
  import ee
  import os

  print('Verifying environment is setup for earthengine-jupyter...')
    
  try:
    import ee_jupyter
    print('\N{check mark} The package earthengine-jupyter is already installed.')
  except ModuleNotFoundError:
    print('\N{check mark} Installing earthengine-jupyter...')
    result = os.system('pip -q install earthengine-jupyter')
  
  if os.path.exists(ee.oauth.get_credentials_path()):
    print('\N{check mark} Authentication credentials were found.')
  else:
    ee.Authenticate()

  print('\N{check mark} Done.')
