import * as cdk from '@aws-cdk/core';
/**
 * CloudFormation equivalent of ad_computer.
 *
 * @schema CfnComputerProps
 */
export interface CfnComputerProps {
    /**
     * @schema CfnComputerProps#Container
     */
    readonly container?: string;
    /**
     * @schema CfnComputerProps#Description
     */
    readonly description?: string;
    /**
     * @schema CfnComputerProps#Name
     */
    readonly name: string;
    /**
     * @schema CfnComputerProps#Pre2kname
     */
    readonly pre2Kname?: string;
}
/**
 * Converts an object of type 'CfnComputerProps' to JSON representation.
 */
export declare function toJson_CfnComputerProps(obj: CfnComputerProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `TF::AD::Computer`.
 *
 * @external
 * @cloudformationResource TF::AD::Computer
 * @link https://github.com/iann0036/cfn-tf-custom-types.git
 */
export declare class CfnComputer extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "TF::AD::Computer";
    /**
     * Resource props.
     *
     * @external
     */
    readonly props: CfnComputerProps;
    /**
     * Attribute `TF::AD::Computer.tfcfnid`.
     *
     * @external
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrTfcfnid: string;
    /**
     * Attribute `TF::AD::Computer.Dn`.
     *
     * @external
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrDn: string;
    /**
     * Attribute `TF::AD::Computer.Guid`.
     *
     * @external
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrGuid: string;
    /**
     * Attribute `TF::AD::Computer.Id`.
     *
     * @external
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrId: string;
    /**
     * Attribute `TF::AD::Computer.Sid`.
     *
     * @external
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrSid: string;
    /**
     * Create a new `TF::AD::Computer`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnComputerProps);
}
