"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2WithEfs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class Ec2WithEfs extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.configureConnection) {
            props.fileSystem.connections.allowDefaultPortFrom(props.instance.connections);
        }
        const mountPoint = props.mountPoint ?? '/mnt/efs/fs1';
        props.instance.userData.addCommands('yum check-update -y', 'yum upgrade -y', 'yum install -y amazon-efs-utils', 'yum install -y nfs-utils', 'file_system_id_1=' + props.fileSystem.fileSystemId, `efs_mount_point_1=${mountPoint}`, 'mkdir -p "${efs_mount_point_1}"', 'test -f "/sbin/mount.efs" && echo "${file_system_id_1}:/ ${efs_mount_point_1} efs defaults,_netdev" >> /etc/fstab || ' +
            'echo "${file_system_id_1}.efs.' +
            aws_cdk_lib_1.Stack.of(this).region +
            '.amazonaws.com:/ ${efs_mount_point_1} nfs4 nfsvers=4.1,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2,noresvport,_netdev 0 0" >> /etc/fstab', 'mount -a -t efs,nfs4 defaults');
    }
}
exports.Ec2WithEfs = Ec2WithEfs;
_a = JSII_RTTI_SYMBOL_1;
Ec2WithEfs[_a] = { fqn: "cdk-aws-ec2-efs.Ec2WithEfs", version: "0.0.2" };
//# sourceMappingURL=data:application/json;base64,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