import * as ec2 from 'aws-cdk-lib/aws-ec2';
import * as efs from 'aws-cdk-lib/aws-efs';
import { Construct } from 'constructs';
export interface Ec2WithEfsProps {
    /** The instance to mount file system it must have yum.
     * Amazo Linux 2 is recommended.
     * **/
    readonly instance: ec2.Instance;
    /** The file system to mount **/
    readonly fileSystem: efs.FileSystem;
    /** To configure the efs to allow connection to default port from ec2.
     * Defaults too false.
     * If you set it to true then it's not needed to allow connections manually.
     * **/
    readonly configureConnection?: boolean;
    /** Direcrory to mount the file system on the ec2 instance.
     * Defaults to /mnt/efs/fs1
     * **/
    readonly mountPoint?: string;
}
export declare class Ec2WithEfs extends Construct {
    constructor(scope: Construct, id: string, props: Ec2WithEfsProps);
}
