#  (C) Copyright IBM Corp. 2021.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import unittest

import ibm_boto3
from ibm_watson_machine_learning.experiment import AutoAI
from ibm_watson_machine_learning.helpers.connections import DataConnection, ContainerLocation
from ibm_watson_machine_learning.tests.utils import is_cp4d, save_data_to_container
from ibm_watson_machine_learning.tests.autoai.abstract_tests_classes import AbstractTestAutoAISyncNotebookFlow

from ibm_watson_machine_learning.utils.autoai.enums import PredictionType, Metrics, RegressionAlgorithms


@unittest.skip("Not ready yet")
class TestAutoAIRemote(AbstractTestAutoAISyncNotebookFlow, unittest.TestCase):
    """
    The test can be run only on CLOUD - it uses container data type
    """

    cos_resource = None
    data_location = './autoai/data/marvel-wikia-colon-delimiter.csv'
    csv_delimeter = ':'

    data_cos_path = 'data/marvel-wikia-colon-delimiter.csv'

    SPACE_ONLY = True

    OPTIMIZER_NAME = "Insurance test sdk"

    target_space_id = None

    experiment_info = dict(
        name=OPTIMIZER_NAME,
        prediction_type=PredictionType.REGRESSION,
        prediction_column='charges',
        scoring=Metrics.R2_SCORE,
        include_only_estimators=[RegressionAlgorithms.LGBM, RegressionAlgorithms.XGB],
        max_number_of_estimators=2,
    )

    def test_00b_write_data_to_container(self):
        if self.SPACE_ONLY:
            self.wml_client.set.default_space(self.space_id)
        else:
            self.wml_client.set.default_project(self.project_id)

        save_data_to_container(self.data_location, self.data_cos_path, self.wml_client)

    def test_02_data_reference_setup(self):
        TestAutoAIRemote.data_connection = DataConnection(
            location=ContainerLocation(path=self.data_cos_path
                                       ))
        TestAutoAIRemote.results_connection = DataConnection(
            location=ContainerLocation(path=self.results_cos_path
                                       ))

        self.assertIsNotNone(obj=TestAutoAIRemote.data_connection)
        self.assertIsNotNone(obj=TestAutoAIRemote.results_connection)

    def test_02b_experiment_metadata_setup(self):
        pass  # TODO


if __name__ == '__main__':
    unittest.main()
