from __future__ import annotations
from kiota_abstractions.serialization import AdditionalDataHolder, Parsable, ParseNode, SerializationWriter
from typing import Any, Callable, Dict, List, Optional, TYPE_CHECKING, Union

class MalwareState(AdditionalDataHolder, Parsable):
    def __init__(self,) -> None:
        """
        Instantiates a new malwareState and sets the default values.
        """
        # Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        self._additional_data: Dict[str, Any] = {}

        # Provider-generated malware category (for example, trojan, ransomware, etc.).
        self._category: Optional[str] = None
        # Provider-generated malware family (for example, 'wannacry', 'notpetya', etc.).
        self._family: Optional[str] = None
        # Provider-generated malware variant name (for example, Trojan:Win32/Powessere.H).
        self._name: Optional[str] = None
        # The OdataType property
        self._odata_type: Optional[str] = None
        # Provider-determined severity of this malware.
        self._severity: Optional[str] = None
        # Indicates whether the detected file (malware/vulnerability) was running at the time of detection or was detected at rest on the disk.
        self._was_running: Optional[bool] = None
    
    @property
    def additional_data(self,) -> Dict[str, Any]:
        """
        Gets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Returns: Dict[str, Any]
        """
        return self._additional_data
    
    @additional_data.setter
    def additional_data(self,value: Dict[str, Any]) -> None:
        """
        Sets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Args:
            value: Value to set for the AdditionalData property.
        """
        self._additional_data = value
    
    @property
    def category(self,) -> Optional[str]:
        """
        Gets the category property value. Provider-generated malware category (for example, trojan, ransomware, etc.).
        Returns: Optional[str]
        """
        return self._category
    
    @category.setter
    def category(self,value: Optional[str] = None) -> None:
        """
        Sets the category property value. Provider-generated malware category (for example, trojan, ransomware, etc.).
        Args:
            value: Value to set for the category property.
        """
        self._category = value
    
    @staticmethod
    def create_from_discriminator_value(parse_node: Optional[ParseNode] = None) -> MalwareState:
        """
        Creates a new instance of the appropriate class based on discriminator value
        Args:
            parseNode: The parse node to use to read the discriminator value and create the object
        Returns: MalwareState
        """
        if parse_node is None:
            raise Exception("parse_node cannot be undefined")
        return MalwareState()
    
    @property
    def family(self,) -> Optional[str]:
        """
        Gets the family property value. Provider-generated malware family (for example, 'wannacry', 'notpetya', etc.).
        Returns: Optional[str]
        """
        return self._family
    
    @family.setter
    def family(self,value: Optional[str] = None) -> None:
        """
        Sets the family property value. Provider-generated malware family (for example, 'wannacry', 'notpetya', etc.).
        Args:
            value: Value to set for the family property.
        """
        self._family = value
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        fields: Dict[str, Callable[[Any], None]] = {
            "category": lambda n : setattr(self, 'category', n.get_str_value()),
            "family": lambda n : setattr(self, 'family', n.get_str_value()),
            "name": lambda n : setattr(self, 'name', n.get_str_value()),
            "@odata.type": lambda n : setattr(self, 'odata_type', n.get_str_value()),
            "severity": lambda n : setattr(self, 'severity', n.get_str_value()),
            "wasRunning": lambda n : setattr(self, 'was_running', n.get_bool_value()),
        }
        return fields
    
    @property
    def name(self,) -> Optional[str]:
        """
        Gets the name property value. Provider-generated malware variant name (for example, Trojan:Win32/Powessere.H).
        Returns: Optional[str]
        """
        return self._name
    
    @name.setter
    def name(self,value: Optional[str] = None) -> None:
        """
        Sets the name property value. Provider-generated malware variant name (for example, Trojan:Win32/Powessere.H).
        Args:
            value: Value to set for the name property.
        """
        self._name = value
    
    @property
    def odata_type(self,) -> Optional[str]:
        """
        Gets the @odata.type property value. The OdataType property
        Returns: Optional[str]
        """
        return self._odata_type
    
    @odata_type.setter
    def odata_type(self,value: Optional[str] = None) -> None:
        """
        Sets the @odata.type property value. The OdataType property
        Args:
            value: Value to set for the odata_type property.
        """
        self._odata_type = value
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        Args:
            writer: Serialization writer to use to serialize this model
        """
        if writer is None:
            raise Exception("writer cannot be undefined")
        writer.write_str_value("category", self.category)
        writer.write_str_value("family", self.family)
        writer.write_str_value("name", self.name)
        writer.write_str_value("@odata.type", self.odata_type)
        writer.write_str_value("severity", self.severity)
        writer.write_bool_value("wasRunning", self.was_running)
        writer.write_additional_data_value(self.additional_data)
    
    @property
    def severity(self,) -> Optional[str]:
        """
        Gets the severity property value. Provider-determined severity of this malware.
        Returns: Optional[str]
        """
        return self._severity
    
    @severity.setter
    def severity(self,value: Optional[str] = None) -> None:
        """
        Sets the severity property value. Provider-determined severity of this malware.
        Args:
            value: Value to set for the severity property.
        """
        self._severity = value
    
    @property
    def was_running(self,) -> Optional[bool]:
        """
        Gets the wasRunning property value. Indicates whether the detected file (malware/vulnerability) was running at the time of detection or was detected at rest on the disk.
        Returns: Optional[bool]
        """
        return self._was_running
    
    @was_running.setter
    def was_running(self,value: Optional[bool] = None) -> None:
        """
        Sets the wasRunning property value. Indicates whether the detected file (malware/vulnerability) was running at the time of detection or was detected at rest on the disk.
        Args:
            value: Value to set for the was_running property.
        """
        self._was_running = value
    

