/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wbs;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.api.ThemeStyle;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.style.NoStyleAvailableException;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.wbs.Fork;
import net.sourceforge.plantuml.wbs.WElement;

public class WBSDiagram
extends UmlDiagram {
    public static final Pattern2 patternStereotype = MyPattern.cmpile("^\\s*(.*?)(?:\\s*\\<\\<\\s*(.*)\\s*\\>\\>)\\s*$");
    private WElement root;
    private WElement last;
    private String first;

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("Work Breakdown Structure");
    }

    public WBSDiagram(ThemeStyle style, UmlSource source) {
        super(style, source, UmlDiagramType.WBS);
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this.getTextBlock()).write(os);
    }

    private TextBlockBackcolored getTextBlock() {
        return new TextBlockBackcolored(){

            @Override
            public void drawU(UGraphic ug) {
                WBSDiagram.this.drawMe(ug);
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return null;
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return WBSDiagram.this.getDrawingElement().calculateDimension(stringBounder);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                throw new UnsupportedOperationException();
            }

            @Override
            public HColor getBackcolor() {
                return null;
            }
        };
    }

    private void drawMe(UGraphic ug) {
        this.getDrawingElement().drawU(ug);
    }

    private TextBlock getDrawingElement() {
        return new Fork(this.getSkinParam(), this.root);
    }

    public CommandExecutionResult addIdea(HColor backColor, int level, String label, Direction direction, IdeaShape shape) {
        Matcher2 m = patternStereotype.matcher(label);
        String stereotype = null;
        if (m.matches()) {
            label = m.group(1);
            stereotype = m.group(2);
        }
        Display display = Display.getWithNewlines(label);
        return this.addIdea(backColor, level, display, stereotype, direction, shape);
    }

    public CommandExecutionResult addIdea(HColor backColor, int level, Display display, String stereotype, Direction direction, IdeaShape shape) {
        try {
            if (level == 0) {
                if (this.root != null) {
                    return CommandExecutionResult.error("Error 44");
                }
                this.initRoot(backColor, display, stereotype, shape);
                return CommandExecutionResult.ok();
            }
            return this.add(backColor, level, display, stereotype, direction, shape);
        }
        catch (NoStyleAvailableException e) {
            return CommandExecutionResult.error("General failure: no style available.");
        }
    }

    private void initRoot(HColor backColor, Display display, String stereotype, IdeaShape shape) {
        this.last = this.root = new WElement(backColor, display, stereotype, this.getSkinParam().getCurrentStyleBuilder(), shape);
    }

    private WElement getParentOfLast(int nb) {
        WElement result = this.last;
        for (int i = 0; i < nb; ++i) {
            result = result.getParent();
        }
        return result;
    }

    public int getSmartLevel(String type) {
        if (this.root == null) {
            assert (this.first == null);
            this.first = type;
            return 0;
        }
        if (!(type = type.replace('\t', ' ')).contains(" ")) {
            return type.length() - 1;
        }
        if (type.endsWith(this.first)) {
            return type.length() - this.first.length();
        }
        if (type.trim().length() == 1) {
            return type.length() - 1;
        }
        if (type.startsWith(this.first)) {
            return type.length() - this.first.length();
        }
        throw new UnsupportedOperationException("type=<" + type + ">[" + this.first + "]");
    }

    private CommandExecutionResult add(HColor backColor, int level, Display display, String stereotype, Direction direction, IdeaShape shape) {
        try {
            if (level == this.last.getLevel() + 1) {
                WElement newIdea;
                this.last = newIdea = this.last.createElement(backColor, level, display, stereotype, direction, shape, this.getSkinParam().getCurrentStyleBuilder());
                return CommandExecutionResult.ok();
            }
            if (level <= this.last.getLevel()) {
                WElement newIdea;
                int diff = this.last.getLevel() - level + 1;
                this.last = newIdea = this.getParentOfLast(diff).createElement(backColor, level, display, stereotype, direction, shape, this.getSkinParam().getCurrentStyleBuilder());
                return CommandExecutionResult.ok();
            }
            return CommandExecutionResult.error("Bad tree structure");
        }
        catch (NoStyleAvailableException e) {
            return CommandExecutionResult.error("General failure: no style available.");
        }
    }
}

