/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.color;

import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.api.ThemeStyle;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorAutomatic;
import net.sourceforge.plantuml.ugraphic.color.HColorAutomaticLegacy;
import net.sourceforge.plantuml.ugraphic.color.HColorBackground;
import net.sourceforge.plantuml.ugraphic.color.HColorGradient;
import net.sourceforge.plantuml.ugraphic.color.HColorSimple;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class HColorSet {
    private static final HColorSet singleton = new HColorSet();
    private final Map<String, String> htmlNames = new HashMap<String, String>();
    private final Set<String> names = new TreeSet<String>();

    public static HColorSet instance() {
        return singleton;
    }

    public Collection<String> names() {
        return Collections.unmodifiableSet(this.names);
    }

    private HColorSet() {
        this.register("AliceBlue", "#F0F8FF");
        this.register("AntiqueWhite", "#FAEBD7");
        this.register("Aqua", "#00FFFF");
        this.register("Aquamarine", "#7FFFD4");
        this.register("Azure", "#F0FFFF");
        this.register("Beige", "#F5F5DC");
        this.register("Bisque", "#FFE4C4");
        this.register("Black", "#000000");
        this.register("BlanchedAlmond", "#FFEBCD");
        this.register("Blue", "#0000FF");
        this.register("BlueViolet", "#8A2BE2");
        this.register("Brown", "#A52A2A");
        this.register("BurlyWood", "#DEB887");
        this.register("CadetBlue", "#5F9EA0");
        this.register("Chartreuse", "#7FFF00");
        this.register("Chocolate", "#D2691E");
        this.register("Coral", "#FF7F50");
        this.register("CornflowerBlue", "#6495ED");
        this.register("Cornsilk", "#FFF8DC");
        this.register("Crimson", "#DC143C");
        this.register("Cyan", "#00FFFF");
        this.register("DarkBlue", "#00008B");
        this.register("DarkCyan", "#008B8B");
        this.register("DarkGoldenRod", "#B8860B");
        this.register("DarkGray", "#A9A9A9");
        this.register("DarkGrey", "#A9A9A9");
        this.register("DarkGreen", "#006400");
        this.register("DarkKhaki", "#BDB76B");
        this.register("DarkMagenta", "#8B008B");
        this.register("DarkOliveGreen", "#556B2F");
        this.register("Darkorange", "#FF8C00");
        this.register("DarkOrchid", "#9932CC");
        this.register("DarkRed", "#8B0000");
        this.register("DarkSalmon", "#E9967A");
        this.register("DarkSeaGreen", "#8FBC8F");
        this.register("DarkSlateBlue", "#483D8B");
        this.register("DarkSlateGray", "#2F4F4F");
        this.register("DarkSlateGrey", "#2F4F4F");
        this.register("DarkTurquoise", "#00CED1");
        this.register("DarkViolet", "#9400D3");
        this.register("DeepPink", "#FF1493");
        this.register("DeepSkyBlue", "#00BFFF");
        this.register("DimGray", "#696969");
        this.register("DimGrey", "#696969");
        this.register("DodgerBlue", "#1E90FF");
        this.register("FireBrick", "#B22222");
        this.register("FloralWhite", "#FFFAF0");
        this.register("ForestGreen", "#228B22");
        this.register("Fuchsia", "#FF00FF");
        this.register("Gainsboro", "#DCDCDC");
        this.register("GhostWhite", "#F8F8FF");
        this.register("Gold", "#FFD700");
        this.register("GoldenRod", "#DAA520");
        this.register("Gray", "#808080");
        this.register("Grey", "#808080");
        this.register("Green", "#008000");
        this.register("GreenYellow", "#ADFF2F");
        this.register("HoneyDew", "#F0FFF0");
        this.register("HotPink", "#FF69B4");
        this.register("IndianRed", "#CD5C5C");
        this.register("Indigo", "#4B0082");
        this.register("Ivory", "#FFFFF0");
        this.register("Khaki", "#F0E68C");
        this.register("Lavender", "#E6E6FA");
        this.register("LavenderBlush", "#FFF0F5");
        this.register("LawnGreen", "#7CFC00");
        this.register("LemonChiffon", "#FFFACD");
        this.register("LightBlue", "#ADD8E6");
        this.register("LightCoral", "#F08080");
        this.register("LightCyan", "#E0FFFF");
        this.register("LightGoldenRodYellow", "#FAFAD2");
        this.register("LightGray", "#D3D3D3");
        this.register("LightGrey", "#D3D3D3");
        this.register("LightGreen", "#90EE90");
        this.register("LightPink", "#FFB6C1");
        this.register("LightSalmon", "#FFA07A");
        this.register("LightSeaGreen", "#20B2AA");
        this.register("LightSkyBlue", "#87CEFA");
        this.register("LightSlateGray", "#778899");
        this.register("LightSlateGrey", "#778899");
        this.register("LightSteelBlue", "#B0C4DE");
        this.register("LightYellow", "#FFFFE0");
        this.register("Lime", "#00FF00");
        this.register("LimeGreen", "#32CD32");
        this.register("Linen", "#FAF0E6");
        this.register("Magenta", "#FF00FF");
        this.register("Maroon", "#800000");
        this.register("MediumAquaMarine", "#66CDAA");
        this.register("MediumBlue", "#0000CD");
        this.register("MediumOrchid", "#BA55D3");
        this.register("MediumPurple", "#9370D8");
        this.register("MediumSeaGreen", "#3CB371");
        this.register("MediumSlateBlue", "#7B68EE");
        this.register("MediumSpringGreen", "#00FA9A");
        this.register("MediumTurquoise", "#48D1CC");
        this.register("MediumVioletRed", "#C71585");
        this.register("MidnightBlue", "#191970");
        this.register("MintCream", "#F5FFFA");
        this.register("MistyRose", "#FFE4E1");
        this.register("Moccasin", "#FFE4B5");
        this.register("NavajoWhite", "#FFDEAD");
        this.register("Navy", "#000080");
        this.register("OldLace", "#FDF5E6");
        this.register("Olive", "#808000");
        this.register("OliveDrab", "#6B8E23");
        this.register("Orange", "#FFA500");
        this.register("OrangeRed", "#FF4500");
        this.register("Orchid", "#DA70D6");
        this.register("PaleGoldenRod", "#EEE8AA");
        this.register("PaleGreen", "#98FB98");
        this.register("PaleTurquoise", "#AFEEEE");
        this.register("PaleVioletRed", "#D87093");
        this.register("PapayaWhip", "#FFEFD5");
        this.register("PeachPuff", "#FFDAB9");
        this.register("Peru", "#CD853F");
        this.register("Pink", "#FFC0CB");
        this.register("Plum", "#DDA0DD");
        this.register("PowderBlue", "#B0E0E6");
        this.register("Purple", "#800080");
        this.register("Red", "#FF0000");
        this.register("RosyBrown", "#BC8F8F");
        this.register("RoyalBlue", "#4169E1");
        this.register("SaddleBrown", "#8B4513");
        this.register("Salmon", "#FA8072");
        this.register("SandyBrown", "#F4A460");
        this.register("SeaGreen", "#2E8B57");
        this.register("SeaShell", "#FFF5EE");
        this.register("Sienna", "#A0522D");
        this.register("Silver", "#C0C0C0");
        this.register("SkyBlue", "#87CEEB");
        this.register("SlateBlue", "#6A5ACD");
        this.register("SlateGray", "#708090");
        this.register("SlateGrey", "#708090");
        this.register("Snow", "#FFFAFA");
        this.register("SpringGreen", "#00FF7F");
        this.register("SteelBlue", "#4682B4");
        this.register("Tan", "#D2B48C");
        this.register("Teal", "#008080");
        this.register("Thistle", "#D8BFD8");
        this.register("Tomato", "#FF6347");
        this.register("Turquoise", "#40E0D0");
        this.register("Violet", "#EE82EE");
        this.register("Wheat", "#F5DEB3");
        this.register("White", "#FFFFFF");
        this.register("WhiteSmoke", "#F5F5F5");
        this.register("Yellow", "#FFFF00");
        this.register("YellowGreen", "#9ACD32");
        this.register("BUSINESS", "#FFFFCC");
        this.register("APPLICATION", "#C2F0FF");
        this.register("MOTIVATION", "#EFEFFF");
        this.register("STRATEGY", "#F8E7C0");
        this.register("TECHNOLOGY", "#C9FFC9");
        this.register("PHYSICAL", "#97FF97");
        this.register("IMPLEMENTATION", "#FFE0E0");
    }

    private void register(String s, String color) {
        this.htmlNames.put(StringUtils.goLowerCase(s), color);
        this.names.add(s);
    }

    private Gradient gradientFromString(String s) {
        Matcher2 m = MyPattern.cmpile("[-\\\\|/]").matcher(s);
        if (m.find()) {
            char sep = m.group(0).charAt(0);
            int idx = s.indexOf(sep);
            String s1 = s.substring(0, idx);
            String s2 = s.substring(idx + 1);
            return new Gradient(s1, sep, s2);
        }
        return null;
    }

    private Automatic automaticFromString(String s) {
        if (s.startsWith("#")) {
            s = s.substring(1);
        }
        if (!s.startsWith("?")) {
            return null;
        }
        int idx = s.indexOf(58);
        if (idx != -1) {
            return new Automatic(s.substring(1).split(":"));
        }
        return null;
    }

    public HColor getColorOrWhite(String s) {
        return this.getColorOrWhite(null, s, null);
    }

    public HColor getColorOrWhite(ThemeStyle UNUSED, String s) {
        return this.getColorOrWhite(null, s, null);
    }

    public HColor getColorOrWhite(ThemeStyle UNUSED, String s, HColor background) {
        if (!this.isColorValid(Objects.requireNonNull(s))) {
            return HColorUtils.WHITE;
        }
        try {
            return this.getColor(null, s, background);
        }
        catch (NoSuchColorException e) {
            assert (false);
            return HColorUtils.WHITE;
        }
    }

    public HColor getColor(ThemeStyle UNUSED, String s) throws NoSuchColorException {
        return this.getColor(null, s, null);
    }

    public HColor getColorLEGACY(String s) throws NoSuchColorException {
        return this.getColor(null, s, null);
    }

    public HColor getColor(ThemeStyle UNUSED, String s, HColor background) throws NoSuchColorException {
        if (!this.isColorValid(Objects.requireNonNull(s))) {
            throw new NoSuchColorException();
        }
        Automatic automatic = this.automaticFromString(s);
        if (automatic != null) {
            return automatic.buildInternal(background);
        }
        Gradient gradient = this.gradientFromString(s);
        if (gradient != null) {
            return gradient.buildInternal(background);
        }
        if (background == null && (s.equalsIgnoreCase("#transparent") || s.equalsIgnoreCase("transparent"))) {
            s = "#00000000";
        }
        return this.build(s, background);
    }

    private boolean isColorValid(String s) {
        Automatic automatic = this.automaticFromString(s = this.removeFirstDieseAndgoLowerCase(s));
        if (automatic != null) {
            return automatic.isValid();
        }
        Gradient gradient = this.gradientFromString(s);
        if (gradient != null) {
            return gradient.isValid();
        }
        if (s.matches("[0-9A-Fa-f]|[0-9A-Fa-f]{3}|[0-9A-Fa-f]{6}|[0-9A-Fa-f]{8}|automatic|transparent")) {
            return true;
        }
        return this.htmlNames.containsKey(s);
    }

    private HColor build(String s, HColor background) {
        Color color;
        if ((s = this.removeFirstDieseAndgoLowerCase(s)).equalsIgnoreCase("transparent") || s.equalsIgnoreCase("background")) {
            return new HColorBackground(background);
        }
        if (s.equalsIgnoreCase("automatic")) {
            return new HColorAutomaticLegacy();
        }
        if (s.matches("[0-9A-Fa-f]")) {
            s = "" + s.charAt(0) + s.charAt(0) + s.charAt(0) + s.charAt(0) + s.charAt(0) + s.charAt(0);
            color = new Color(Integer.parseInt(s, 16));
        } else if (s.matches("[0-9A-Fa-f]{3}")) {
            s = "" + s.charAt(0) + s.charAt(0) + s.charAt(1) + s.charAt(1) + s.charAt(2) + s.charAt(2);
            color = new Color(Integer.parseInt(s, 16));
        } else if (s.matches("[0-9A-Fa-f]{6}")) {
            color = new Color(Integer.parseInt(s, 16));
        } else if (s.matches("[0-9A-Fa-f]{8}")) {
            color = this.fromRGBa(s);
        } else {
            String value = Objects.requireNonNull(this.htmlNames.get(s));
            color = new Color(Integer.parseInt(value.substring(1), 16));
        }
        return new HColorSimple(color, false);
    }

    private Color fromRGBa(String s) {
        if (s.length() != 8) {
            throw new IllegalArgumentException();
        }
        int red = Integer.parseInt(s.substring(0, 2), 16);
        int green = Integer.parseInt(s.substring(2, 4), 16);
        int blue = Integer.parseInt(s.substring(4, 6), 16);
        int alpha = Integer.parseInt(s.substring(6, 8), 16);
        return new Color(red, green, blue, alpha);
    }

    private String removeFirstDieseAndgoLowerCase(String s) {
        if ((s = StringUtils.goLowerCase(s)).startsWith("#")) {
            s = s.substring(1);
        }
        return s;
    }

    class Automatic {
        private final String[] colors;

        public Automatic(String[] colors) {
            this.colors = colors;
        }

        boolean isValid() {
            for (String color : this.colors) {
                if (HColorSet.this.isColorValid(color)) continue;
                return false;
            }
            return true;
        }

        HColorAutomatic buildInternal(HColor background) {
            if (this.colors.length == 2) {
                return new HColorAutomatic(HColorSet.this.build(this.colors[0], background), HColorSet.this.build(this.colors[1], background), null);
            }
            return new HColorAutomatic(HColorSet.this.build(this.colors[0], background), HColorSet.this.build(this.colors[1], background), HColorSet.this.build(this.colors[2], background));
        }
    }

    class Gradient {
        private final String s1;
        private final char sep;
        private final String s2;

        Gradient(String s1, char sep, String s2) {
            this.s1 = s1;
            this.sep = sep;
            this.s2 = s2;
        }

        boolean isValid() {
            return HColorSet.this.isColorValid(this.s1) && HColorSet.this.isColorValid(this.s2);
        }

        HColorGradient buildInternal(HColor background) {
            return new HColorGradient(HColorSet.this.build(this.s1, background), HColorSet.this.build(this.s2, background), this.sep);
        }
    }
}

