/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorNone;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class Highlight {
    private final TimeTick tickFrom;
    private final TimeTick tickTo;
    private final Display caption;
    private final Colors colors;
    private final ISkinParam skinParam;

    public Highlight(ISkinParam skinParam, TimeTick tickFrom, TimeTick tickTo, Display caption, Colors colors) {
        this.tickFrom = tickFrom;
        this.tickTo = tickTo;
        this.caption = caption;
        this.colors = colors;
        this.skinParam = skinParam;
    }

    private StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.timingDiagram, SName.highlight);
    }

    private Style getStyle() {
        return this.getStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
    }

    private HColor getBackColor() {
        HColor result = this.colors.getColor(ColorType.BACK);
        if (result == null) {
            if (!UseStyle.useBetaStyle()) {
                return HColorUtils.COL_A9DCDF;
            }
            return this.getStyle().value(PName.BackGroundColor).asColor(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
        }
        return result;
    }

    private HColor getLineColor() {
        HColor result = this.colors.getColor(ColorType.LINE);
        if (result == null) {
            if (!UseStyle.useBetaStyle()) {
                return HColorUtils.BLACK;
            }
            return this.getStyle().value(PName.LineColor).asColor(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
        }
        return result;
    }

    private UStroke getUStroke() {
        if (!UseStyle.useBetaStyle()) {
            return new UStroke(4.0, 4.0, 2.0);
        }
        return this.getStyle().getStroke();
    }

    public final TimeTick getTickFrom() {
        return this.tickFrom;
    }

    public final TimeTick getTickTo() {
        return this.tickTo;
    }

    public final Display getCaption() {
        return this.caption;
    }

    public TextBlock getCaption(ISkinParam skinParam) {
        FontConfiguration fc = new FontConfiguration(skinParam, FontParam.TIMING, null);
        return this.caption.create(fc, HorizontalAlignment.LEFT, skinParam);
    }

    public void drawHighlightsBack(UGraphic ug, TimingRuler ruler, double height) {
        ug = ug.apply(new HColorNone()).apply(this.getBackColor().bg());
        double start = ruler.getPosInPixel(this.getTickFrom());
        double end = ruler.getPosInPixel(this.getTickTo());
        URectangle rect = new URectangle(end - start, height);
        ug.apply(UTranslate.dx(start)).draw(rect);
    }

    public void drawHighlightsLines(UGraphic ug, TimingRuler ruler, double height) {
        ug = ug.apply(this.getUStroke());
        ug = ug.apply(this.getLineColor());
        ULine line = ULine.vline(height);
        double start = ruler.getPosInPixel(this.getTickFrom());
        double end = ruler.getPosInPixel(this.getTickTo());
        ug.apply(UTranslate.dx(start)).draw(line);
        ug.apply(UTranslate.dx(end)).draw(line);
    }
}

