/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.util.Collections;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.image.EntityImageStateCommon;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGroupType;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageState
extends EntityImageStateCommon {
    private final TextBlock fields;
    private static final int MIN_WIDTH = 50;
    private static final int MIN_HEIGHT = 50;
    private final boolean withSymbol;
    private static final double smallRadius = 3.0;
    private static final double smallLine = 3.0;
    private static final double smallMarginX = 7.0;
    private static final double smallMarginY = 4.0;

    public EntityImageState(IEntity entity, ISkinParam skinParam) {
        super(entity, skinParam);
        Stereotype stereotype = entity.getStereotype();
        this.withSymbol = stereotype != null && stereotype.isWithOOSymbol();
        Display list = Display.create(entity.getBodier().getRawBody());
        FontConfiguration fontConfiguration = UseStyle.useBetaStyle() ? this.getStyleState().getFontConfiguration(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet()) : new FontConfiguration(this.getSkinParam(), FontParam.STATE_ATTRIBUTE, stereotype);
        this.fields = list.create8(fontConfiguration, HorizontalAlignment.LEFT, skinParam, CreoleMode.FULL, skinParam.wrapWidth());
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dim = Dimension2DDouble.mergeTB(this.desc.calculateDimension(stringBounder), this.fields.calculateDimension(stringBounder));
        double heightSymbol = 0.0;
        if (this.withSymbol) {
            heightSymbol += 10.0;
        }
        Dimension2D result = Dimension2DDouble.delta(dim, 20.0 + heightSymbol);
        return Dimension2DDouble.atLeast(result, 50.0, 50.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        ug.startGroup(Collections.singletonMap(UGroupType.ID, this.getEntity().getIdent().toString(".")));
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimTotal = this.calculateDimension(stringBounder);
        Dimension2D dimDesc = this.desc.calculateDimension(stringBounder);
        UStroke stroke = UseStyle.useBetaStyle() ? this.getStyleState().getStroke() : new UStroke();
        ug = this.applyColorAndStroke(ug);
        ug = ug.apply(stroke);
        ug.draw(this.getShape(dimTotal));
        double yLine = 5.0 + dimDesc.getHeight() + 5.0;
        ug.apply(UTranslate.dy(yLine)).draw(ULine.hline(dimTotal.getWidth()));
        if (this.withSymbol) {
            double xSymbol = dimTotal.getWidth();
            double ySymbol = dimTotal.getHeight();
            EntityImageState.drawSymbol(ug, xSymbol, ySymbol);
        }
        double xDesc = (dimTotal.getWidth() - dimDesc.getWidth()) / 2.0;
        double yDesc = 5.0;
        this.desc.drawU(ug.apply(new UTranslate(xDesc, 5.0)));
        double xFields = 5.0;
        double yFields = yLine + 5.0;
        this.fields.drawU(ug.apply(new UTranslate(5.0, yFields)));
        if (this.url != null) {
            ug.closeUrl();
        }
        ug.closeGroup();
    }

    public static void drawSymbol(UGraphic ug, double xSymbol, double ySymbol) {
        UEllipse small = new UEllipse(6.0, 6.0);
        ug.apply(new UTranslate(xSymbol -= 22.0, ySymbol -= 10.0)).draw(small);
        ug.apply(new UTranslate(xSymbol + 3.0 + 6.0, ySymbol)).draw(small);
        ug.apply(new UTranslate(xSymbol + 6.0, ySymbol + 3.0)).draw(ULine.hline(3.0));
    }
}

