/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.util.EnumMap;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGroupType;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageLollipopInterface
extends AbstractEntityImage {
    private static final int SIZE = 10;
    private final TextBlock desc;
    private final SName sname;
    private final Url url;
    private double angle;

    public StyleSignatureBasic getSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, this.sname, SName.circle);
    }

    private UStroke getUStroke() {
        return new UStroke(1.5);
    }

    public EntityImageLollipopInterface(ILeaf entity, ISkinParam skinParam, SName sname) {
        super(entity, skinParam);
        this.sname = sname;
        Stereotype stereotype = entity.getStereotype();
        FontConfiguration fc = UseStyle.useBetaStyle() ? new FontConfiguration(this.getSkinParam(), this.getSignature().getMergedStyle(skinParam.getCurrentStyleBuilder())) : new FontConfiguration(this.getSkinParam(), FontParam.CLASS, stereotype);
        this.desc = entity.getDisplay().create(fc, HorizontalAlignment.CENTER, skinParam);
        this.url = entity.getUrl99();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(10.0, 10.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        UEllipse circle;
        HColor borderColor;
        HColor backgroundColor;
        double shadow = 4.0;
        if (UseStyle.useBetaStyle()) {
            Style style = this.getSignature().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
            backgroundColor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
            borderColor = style.value(PName.LineColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
            shadow = style.value(PName.Shadowing).asDouble();
        } else {
            backgroundColor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.classBackground);
            borderColor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.classBorder);
        }
        if (this.getEntity().getLeafType() == LeafType.LOLLIPOP_HALF) {
            circle = new UEllipse(10.0, 10.0, this.angle - 90.0, 180.0);
        } else {
            circle = new UEllipse(10.0, 10.0);
            if (this.getSkinParam().shadowing(this.getEntity().getStereotype())) {
                circle.setDeltaShadow(shadow);
            }
        }
        ug = ug.apply(backgroundColor.bg()).apply(borderColor);
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        EnumMap<UGroupType, String> typeIDent = new EnumMap<UGroupType, String>(UGroupType.class);
        typeIDent.put(UGroupType.CLASS, "elem " + this.getEntity().getCode() + " selected");
        typeIDent.put(UGroupType.ID, "elem_" + this.getEntity().getCode());
        ug.startGroup(typeIDent);
        ug.apply(this.getUStroke()).draw(circle);
        ug.closeGroup();
        Dimension2D dimDesc = this.desc.calculateDimension(ug.getStringBounder());
        double widthDesc = dimDesc.getWidth();
        double x = 5.0 - widthDesc / 2.0;
        double y = 10.0;
        this.desc.drawU(ug.apply(new UTranslate(x, 10.0)));
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.CIRCLE_IN_RECT;
    }

    public void addImpact(double angle) {
        this.angle = 180.0 - angle * 180.0 / Math.PI;
    }
}

