/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.Guillemet;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.CircledCharacter;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockGeneric;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.HeaderLayout;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageClassHeader
extends AbstractEntityImage {
    private final HeaderLayout headerLayout;

    public EntityImageClassHeader(ILeaf entity, ISkinParam skinParam, PortionShower portionShower) {
        super(entity, skinParam);
        TextBlock genericBlock;
        FontConfiguration fontConfigurationName;
        String generic;
        boolean italic = entity.getLeafType() == LeafType.ABSTRACT_CLASS || entity.getLeafType() == LeafType.INTERFACE;
        Stereotype stereotype = entity.getStereotype();
        boolean displayGenericWithOldFashion = skinParam.displayGenericWithOldFashion();
        String string = generic = displayGenericWithOldFashion ? null : entity.getGeneric();
        if (UseStyle.useBetaStyle()) {
            Style style = StyleSignatureBasic.of(SName.root, SName.element, SName.classDiagram, SName.class_, SName.header).withTOBECHANGED(stereotype).with(entity.getStereostyles()).getMergedStyle(skinParam.getCurrentStyleBuilder());
            fontConfigurationName = new FontConfiguration(skinParam, style);
        } else {
            fontConfigurationName = new FontConfiguration(this.getSkinParam(), FontParam.CLASS, stereotype);
        }
        if (italic) {
            fontConfigurationName = fontConfigurationName.italic();
        }
        Display display = entity.getDisplay();
        if (displayGenericWithOldFashion && entity.getGeneric() != null) {
            display = display.addGeneric(entity.getGeneric());
        }
        TextBlock name = display.createWithNiceCreoleMode(fontConfigurationName, HorizontalAlignment.CENTER, skinParam);
        VisibilityModifier modifier = entity.getVisibilityModifier();
        if (modifier == null) {
            name = TextBlockUtils.withMargin(name, 3.0, 3.0, 0.0, 0.0);
        } else {
            Rose rose = new Rose();
            HColor back = rose.getHtmlColor(skinParam, modifier.getBackground());
            HColor fore = rose.getHtmlColor(skinParam, modifier.getForeground());
            TextBlock uBlock = modifier.getUBlock(skinParam.classAttributeIconSize(), fore, back, false);
            name = TextBlockUtils.mergeLR(uBlock, name, VerticalAlignment.CENTER);
            name = TextBlockUtils.withMargin(name, 3.0, 3.0, 0.0, 0.0);
        }
        TextBlock stereo = stereotype == null || stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) == null || !portionShower.showPortion(EntityPortion.STEREOTYPE, entity) ? null : TextBlockUtils.withMargin(Display.create(stereotype.getLabels(skinParam.guillemet())).create(new FontConfiguration(this.getSkinParam(), FontParam.CLASS_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, skinParam), 1.0, 0.0);
        if (generic == null) {
            genericBlock = null;
        } else {
            genericBlock = Display.getWithNewlines(generic).create(new FontConfiguration(this.getSkinParam(), FontParam.CLASS_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, skinParam);
            genericBlock = TextBlockUtils.withMargin(genericBlock, 1.0, 1.0);
            HColor classBackground = SkinParamUtils.getColor(this.getSkinParam(), stereotype, ColorParam.background);
            HColor classBorder = SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CLASS_STEREOTYPE, stereotype);
            genericBlock = new TextBlockGeneric(genericBlock, classBackground, classBorder);
            genericBlock = TextBlockUtils.withMargin(genericBlock, 1.0, 1.0);
        }
        TextBlock circledCharacter = portionShower.showPortion(EntityPortion.CIRCLED_CHARACTER, (ILeaf)this.getEntity()) ? TextBlockUtils.withMargin(this.getCircledCharacter(entity, skinParam), 4.0, 0.0, 5.0, 5.0) : null;
        this.headerLayout = new HeaderLayout(circledCharacter, stereo, name, genericBlock);
    }

    private TextBlock getCircledCharacter(ILeaf entity, ISkinParam skinParam) {
        HColor fontColor;
        HColor classBorder;
        HColor spotBackColor;
        HColor spotBorder;
        Stereotype stereotype = entity.getStereotype();
        if (stereotype != null && stereotype.getSprite(skinParam) != null) {
            return stereotype.getSprite(skinParam);
        }
        UFont font = SkinParamUtils.getFont(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null);
        LeafType leafType = entity.getLeafType();
        if (UseStyle.useBetaStyle()) {
            Style style = this.spotStyleSignature(leafType).getMergedStyle(skinParam.getCurrentStyleBuilder());
            spotBorder = style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
            spotBackColor = style.value(PName.BackGroundColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
            classBorder = SkinParamUtils.getColor(this.getSkinParam(), stereotype, ColorParam.classBorder);
            fontColor = style.value(PName.FontColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
        } else {
            spotBackColor = SkinParamUtils.getColor(this.getSkinParam(), stereotype, this.spotBackground(leafType));
            spotBorder = SkinParamUtils.getColor(this.getSkinParam(), stereotype, this.spotBorder(leafType));
            classBorder = SkinParamUtils.getColor(this.getSkinParam(), stereotype, ColorParam.classBorder);
            fontColor = SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null);
        }
        if (stereotype != null && stereotype.getCharacter() != '\u0000') {
            return new CircledCharacter(stereotype.getCharacter(), this.getSkinParam().getCircledCharacterRadius(), font, stereotype.getHtmlColor(), classBorder, fontColor);
        }
        if (spotBorder == null) {
            spotBorder = classBorder;
        }
        char circledChar = '\u0000';
        if (stereotype != null) {
            circledChar = this.getSkinParam().getCircledCharacter(stereotype);
        }
        if (circledChar == '\u0000') {
            circledChar = this.getCircledChar(leafType);
        }
        return new CircledCharacter(circledChar, this.getSkinParam().getCircledCharacterRadius(), font, spotBackColor, spotBorder, fontColor);
    }

    private StyleSignatureBasic spotStyleSignature(LeafType leafType) {
        switch (leafType) {
            case ANNOTATION: {
                return StyleSignatureBasic.of(SName.root, SName.element, SName.spot, SName.spotAnnotation);
            }
            case ABSTRACT_CLASS: {
                return StyleSignatureBasic.of(SName.root, SName.element, SName.spot, SName.spotAbstractClass);
            }
            case CLASS: {
                return StyleSignatureBasic.of(SName.root, SName.element, SName.spot, SName.spotClass);
            }
            case INTERFACE: {
                return StyleSignatureBasic.of(SName.root, SName.element, SName.spot, SName.spotInterface);
            }
            case ENUM: {
                return StyleSignatureBasic.of(SName.root, SName.element, SName.spot, SName.spotEnum);
            }
            case ENTITY: {
                return StyleSignatureBasic.of(SName.root, SName.element, SName.spot, SName.spotEntity);
            }
        }
        throw new IllegalStateException();
    }

    private ColorParam spotBackground(LeafType leafType) {
        switch (leafType) {
            case ANNOTATION: {
                return ColorParam.stereotypeNBackground;
            }
            case ABSTRACT_CLASS: {
                return ColorParam.stereotypeABackground;
            }
            case CLASS: {
                return ColorParam.stereotypeCBackground;
            }
            case INTERFACE: {
                return ColorParam.stereotypeIBackground;
            }
            case ENUM: {
                return ColorParam.stereotypeEBackground;
            }
            case ENTITY: {
                return ColorParam.stereotypeCBackground;
            }
        }
        assert (false);
        return null;
    }

    private ColorParam spotBorder(LeafType leafType) {
        switch (leafType) {
            case ANNOTATION: {
                return ColorParam.stereotypeNBorder;
            }
            case ABSTRACT_CLASS: {
                return ColorParam.stereotypeABorder;
            }
            case CLASS: {
                return ColorParam.stereotypeCBorder;
            }
            case INTERFACE: {
                return ColorParam.stereotypeIBorder;
            }
            case ENUM: {
                return ColorParam.stereotypeEBorder;
            }
            case ENTITY: {
                return ColorParam.stereotypeCBorder;
            }
        }
        assert (false);
        return null;
    }

    private char getCircledChar(LeafType leafType) {
        switch (leafType) {
            case ANNOTATION: {
                return '@';
            }
            case ABSTRACT_CLASS: {
                return 'A';
            }
            case CLASS: {
                return 'C';
            }
            case INTERFACE: {
                return 'I';
            }
            case ENUM: {
                return 'E';
            }
            case ENTITY: {
                return 'E';
            }
        }
        assert (false);
        return '?';
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.headerLayout.getDimension(stringBounder);
    }

    @Override
    public final void drawU(UGraphic ug) {
        throw new UnsupportedOperationException();
    }

    public void drawU(UGraphic ug, double width, double height) {
        this.headerLayout.drawU(ug, width, height);
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }
}

