/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.ugraphic.Shadowable;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageActivity
extends AbstractEntityImage {
    private double shadowing = 0.0;
    public static final int CORNER = 25;
    private final TextBlock desc;
    private static final int MARGIN = 10;
    private final Url url;
    private final Bibliotekon bibliotekon;

    public EntityImageActivity(ILeaf entity, ISkinParam skinParam, Bibliotekon bibliotekon) {
        super(entity, skinParam);
        HorizontalAlignment horizontalAlignment;
        FontConfiguration fontConfiguration;
        this.bibliotekon = bibliotekon;
        Stereotype stereotype = entity.getStereotype();
        if (UseStyle.useBetaStyle()) {
            Style style = this.getDefaultStyleDefinition().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
            fontConfiguration = style.getFontConfiguration(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
            horizontalAlignment = style.getHorizontalAlignment();
            this.shadowing = style.value(PName.Shadowing).asDouble();
        } else {
            fontConfiguration = new FontConfiguration(this.getSkinParam(), FontParam.ACTIVITY, stereotype);
            horizontalAlignment = HorizontalAlignment.CENTER;
            if (this.getSkinParam().shadowing(this.getEntity().getStereotype())) {
                this.shadowing = 4.0;
            }
        }
        this.desc = entity.getDisplay().create(fontConfiguration, horizontalAlignment, skinParam);
        this.url = entity.getUrl99();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dim = this.desc.calculateDimension(stringBounder);
        return Dimension2DDouble.delta(dim, 20.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        if (this.getShapeType() == ShapeType.ROUND_RECTANGLE) {
            ug = this.drawNormal(ug);
        } else if (this.getShapeType() == ShapeType.OCTAGON) {
            ug = this.drawOctagon(ug);
        } else {
            throw new UnsupportedOperationException();
        }
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    private UGraphic drawOctagon(UGraphic ug) {
        SvekNode node = this.bibliotekon.getNode(this.getEntity());
        Shadowable octagon = node.getPolygon();
        if (octagon == null) {
            return this.drawNormal(ug);
        }
        octagon.setDeltaShadow(this.shadowing);
        ug = this.applyColors(ug);
        ug.apply(new UStroke(1.5)).draw(octagon);
        this.desc.drawU(ug.apply(new UTranslate(10.0, 10.0)));
        return ug;
    }

    private UGraphic drawNormal(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimTotal = this.calculateDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        URectangle rect = new URectangle(widthTotal, heightTotal).rounded(25.0);
        rect.setDeltaShadow(this.shadowing);
        ug = this.applyColors(ug);
        UStroke stroke = new UStroke(1.5);
        if (UseStyle.useBetaStyle()) {
            Style style = this.getDefaultStyleDefinition().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
            stroke = style.getStroke();
        }
        ug.apply(stroke).draw(rect);
        this.desc.drawU(ug.apply(new UTranslate(10.0, 10.0)));
        return ug;
    }

    public StyleSignature getDefaultStyleDefinition() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity).withTOBECHANGED(this.getStereo());
    }

    private UGraphic applyColors(UGraphic ug) {
        HColor borderColor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.activityBorder);
        HColor backcolor = this.getEntity().getColors().getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.activityBackground);
        }
        if (UseStyle.useBetaStyle()) {
            Style style = this.getDefaultStyleDefinition().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
            borderColor = style.value(PName.LineColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
            backcolor = this.getEntity().getColors().getColor(ColorType.BACK);
            if (backcolor == null) {
                backcolor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
            }
        }
        ug = ug.apply(borderColor);
        ug = ug.apply(backcolor.bg());
        return ug;
    }

    @Override
    public ShapeType getShapeType() {
        Stereotype stereotype = this.getStereo();
        if (this.getSkinParam().useOctagonForActivity(stereotype)) {
            return ShapeType.OCTAGON;
        }
        return ShapeType.ROUND_RECTANGLE;
    }
}

