/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Divider;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class DividerTile
extends AbstractTile
implements Tile {
    private final Rose skin;
    private final ISkinParam skinParam;
    private final Divider divider;
    private final Real origin;
    private final TileArguments tileArguments;

    @Override
    public Event getEvent() {
        return this.divider;
    }

    public DividerTile(Divider divider, TileArguments tileArguments) {
        super(tileArguments.getStringBounder());
        this.tileArguments = tileArguments;
        this.divider = divider;
        this.skin = tileArguments.getSkin();
        this.skinParam = tileArguments.getSkinParam();
        this.origin = tileArguments.getOrigin();
    }

    private Component getComponent(StringBounder stringBounder) {
        Component comp = this.skin.createComponent(this.divider.getUsedStyles(), ComponentType.DIVIDER, null, this.skinParam, this.divider.getText());
        return comp;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Component comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        Area area = new Area(this.tileArguments.getBorder2() - this.tileArguments.getBorder1() - this.origin.getCurrentValue(), dim.getHeight());
        ug = ug.apply(UTranslate.dx(this.tileArguments.getBorder1()));
        comp.drawU(ug, area, (Context2D)((Object)ug));
    }

    @Override
    public double getPreferredHeight() {
        Component comp = this.getComponent(this.getStringBounder());
        Dimension2D dim = comp.getPreferredDimension(this.getStringBounder());
        return dim.getHeight();
    }

    @Override
    public void addConstraints() {
    }

    @Override
    public Real getMinX() {
        return this.origin;
    }

    @Override
    public Real getMaxX() {
        Component comp = this.getComponent(this.getStringBounder());
        Dimension2D dim = comp.getPreferredDimension(this.getStringBounder());
        return this.origin.addFixed(dim.getWidth());
    }
}

