/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class CommunicationTileNoteLeft
extends AbstractTile {
    private final Tile tile;
    private final AbstractMessage message;
    private final Rose skin;
    private final ISkinParam skinParam;
    private final LivingSpace livingSpace;
    private final Note noteOnMessage;

    @Override
    public Event getEvent() {
        return this.message;
    }

    @Override
    public double getContactPointRelative() {
        return this.tile.getContactPointRelative();
    }

    public CommunicationTileNoteLeft(Tile tile, AbstractMessage message, Rose skin, ISkinParam skinParam, LivingSpace livingSpace, Note noteOnMessage) {
        super(((AbstractTile)tile).getStringBounder());
        this.tile = tile;
        this.message = message;
        this.skin = skin;
        this.skinParam = skinParam;
        this.noteOnMessage = noteOnMessage;
        this.livingSpace = livingSpace;
    }

    @Override
    protected final void callbackY_internal(double y) {
        this.tile.callbackY(y);
    }

    private Component getComponent(StringBounder stringBounder) {
        Component comp = this.skin.createComponentNote(this.noteOnMessage.getUsedStyles(), ComponentType.NOTE, this.noteOnMessage.getSkinParamBackcolored(this.skinParam), this.noteOnMessage.getStrings());
        return comp;
    }

    private Real getNotePosition(StringBounder stringBounder) {
        Component comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        return this.livingSpace.getPosC(stringBounder).addFixed(-dim.getWidth());
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Component comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        Area area = new Area(dim.getWidth(), dim.getHeight());
        ((UDrawable)((Object)this.tile)).drawU(ug);
        Real p = this.getNotePosition(stringBounder);
        comp.drawU(ug.apply(UTranslate.dx(p.getCurrentValue())), area, (Context2D)((Object)ug));
    }

    @Override
    public double getPreferredHeight() {
        Component comp = this.getComponent(this.getStringBounder());
        Dimension2D dim = comp.getPreferredDimension(this.getStringBounder());
        return Math.max(this.tile.getPreferredHeight(), dim.getHeight());
    }

    @Override
    public void addConstraints() {
        this.tile.addConstraints();
    }

    @Override
    public Real getMinX() {
        return this.getNotePosition(this.getStringBounder());
    }

    @Override
    public Real getMaxX() {
        return this.tile.getMaxX();
    }
}

