/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.sequencediagram.teoz.CommonTile;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class LinkAnchor {
    private final String anchor1;
    private final String anchor2;
    private final String message;

    public LinkAnchor(String anchor1, String anchor2, String message) {
        this.anchor1 = anchor1;
        this.anchor2 = anchor2;
        this.message = message;
    }

    public String toString() {
        return this.anchor1 + "<->" + this.anchor2 + " " + this.message;
    }

    public final String getAnchor1() {
        return this.anchor1;
    }

    public final String getAnchor2() {
        return this.anchor2;
    }

    public final String getMessage() {
        return this.message;
    }

    public void drawAnchor(UGraphic ug, CommonTile tile1, CommonTile tile2, ISkinParam skinParam) {
        FontConfiguration fontConfiguration;
        HColor color;
        double y1 = tile1.getY() + tile1.getContactPointRelative();
        double y2 = tile2.getY() + tile2.getContactPointRelative();
        double xx1 = tile1.getMiddleX();
        double xx2 = tile2.getMiddleX();
        double x = (xx1 + xx2) / 2.0;
        double ymin = Math.min(y1, y2);
        double ymax = Math.max(y1, y2);
        if (UseStyle.useBetaStyle()) {
            StyleSignatureBasic signature = StyleSignatureBasic.of(SName.root, SName.element, SName.sequenceDiagram, SName.arrow);
            Style style = signature.getMergedStyle(skinParam.getCurrentStyleBuilder());
            color = style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
            fontConfiguration = new FontConfiguration(skinParam, style);
        } else {
            color = new Rose().getHtmlColor(skinParam, ColorParam.arrow);
            fontConfiguration = new FontConfiguration(skinParam, FontParam.ARROW, null);
        }
        Rainbow rainbow = Rainbow.fromColor(color, null);
        Display display = Display.getWithNewlines(this.message);
        TextBlock title = display.create(fontConfiguration, HorizontalAlignment.CENTER, skinParam);
        Snake snake = Snake.create(skinParam, Arrows.asToUp(), rainbow, Arrows.asToDown()).withLabel(title, HorizontalAlignment.CENTER);
        snake.addPoint(x, ymin + 2.0);
        snake.addPoint(x, ymax - 2.0);
        snake.drawInternal(ug);
    }
}

