/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sdot;

import gen.lib.cgraph.attr__c;
import gen.lib.cgraph.edge__c;
import gen.lib.cgraph.graph__c;
import gen.lib.cgraph.node__c;
import gen.lib.cgraph.subg__c;
import gen.lib.gvc.gvc__c;
import gen.lib.gvc.gvlayout__c;
import h.ST_Agedge_s;
import h.ST_Agnode_s;
import h.ST_Agnodeinfo_t;
import h.ST_Agraph_s;
import h.ST_Agraphinfo_t;
import h.ST_Agrec_s;
import h.ST_GVC_s;
import h.ST_boxf;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.entity.EntityFactory;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.QuoteUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.sdot.SmetanaPath;
import net.sourceforge.plantuml.sdot.YMirror;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.DotStringFactory;
import net.sourceforge.plantuml.svek.GeneralImageBuilder;
import net.sourceforge.plantuml.svek.GraphvizCrash;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import smetana.core.CString;
import smetana.core.JUtils;
import smetana.core.Macro;
import smetana.core.Z;
import smetana.core.debug.SmetanaDebug;

public class CucaDiagramFileMakerSmetana
implements CucaDiagramFileMaker {
    private final CucaDiagram diagram;
    private final StringBounder stringBounder;
    private final Map<ILeaf, ST_Agnode_s> nodes = new LinkedHashMap<ILeaf, ST_Agnode_s>();
    private final Map<Link, ST_Agedge_s> edges = new LinkedHashMap<Link, ST_Agedge_s>();
    private final Map<IGroup, ST_Agraph_s> clusters = new LinkedHashMap<IGroup, ST_Agraph_s>();
    private final DotStringFactory dotStringFactory;
    private static final Lock lock = new ReentrantLock();

    public CucaDiagramFileMakerSmetana(CucaDiagram diagram, StringBounder stringBounder) {
        this.diagram = diagram;
        this.stringBounder = stringBounder;
        this.dotStringFactory = new DotStringFactory(stringBounder, diagram);
        this.printAllSubgroups(diagram.getRootGroup());
        this.printEntities(this.getUnpackagedEntities());
    }

    public void drawGroup(UGraphic ug, YMirror ymirror, IGroup group, ST_Agraph_s gr) {
        JUtils.LOG2("drawGroup");
        try {
            ST_Agrec_s tmp1 = Macro.AGDATA(gr);
            ST_Agraphinfo_t data = (ST_Agraphinfo_t)tmp1;
            ST_boxf bb = data.bb;
            double llx = bb.LL.x;
            double lly = bb.LL.y;
            double urx = bb.UR.x;
            double ury = bb.UR.y;
            if (ymirror != null) {
                double tmpUry = ury;
                ury = ymirror.getMirrored(lly);
                lly = ymirror.getMirrored(tmpUry);
            }
            Cluster cluster = this.dotStringFactory.getBibliotekon().getCluster(group);
            cluster.setPosition(llx, lly, urx, ury);
            JUtils.LOG2("cluster=" + cluster);
            cluster.drawU(ug, this.diagram.getUmlDiagramType(), this.diagram.getSkinParam());
        }
        catch (Exception e) {
            System.err.println("CANNOT DRAW GROUP");
        }
    }

    private void printAllSubgroups(IGroup parent) {
        for (IGroup g : this.diagram.getChildrenGroups(parent)) {
            if (g.isRemoved()) continue;
            if (this.diagram.isEmpty(g) && g.getGroupType() == GroupType.PACKAGE) {
                ISkinParam skinParam = this.diagram.getSkinParam();
                EntityFactory entityFactory = this.diagram.getEntityFactory();
                ILeaf folder = entityFactory.createLeafForEmptyGroup(g, skinParam);
                this.printEntityNew(folder);
                continue;
            }
            this.printSingleGroup(g);
        }
    }

    private void printSingleGroup(IGroup g) {
        if (g.getGroupType() == GroupType.CONCURRENT_STATE) {
            return;
        }
        int titleAndAttributeWidth = 0;
        int titleAndAttributeHeight = 0;
        TextBlock title = this.getTitleBlock(g);
        TextBlock stereo = this.getStereoBlock(g);
        TextBlock stereoAndTitle = TextBlockUtils.mergeTB(stereo, title, HorizontalAlignment.CENTER);
        Dimension2D dimLabel = stereoAndTitle.calculateDimension(this.stringBounder);
        if (dimLabel.getWidth() > 0.0) {
            TextBlock attribute = GeneralImageBuilder.stateHeader(g, null, this.diagram.getSkinParam());
            Dimension2D dimAttribute = attribute.calculateDimension(this.stringBounder);
            double attributeHeight = dimAttribute.getHeight();
            double attributeWidth = dimAttribute.getWidth();
            double marginForFields = attributeHeight > 0.0 ? 5.0 : 0.0;
            USymbol uSymbol = g.getUSymbol();
            int suppHeightBecauseOfShape = uSymbol == null ? 0 : uSymbol.suppHeightBecauseOfShape();
            int suppWidthBecauseOfShape = uSymbol == null ? 0 : uSymbol.suppWidthBecauseOfShape();
            titleAndAttributeWidth = (int)Math.max(dimLabel.getWidth(), attributeWidth) + suppWidthBecauseOfShape;
            titleAndAttributeHeight = (int)(dimLabel.getHeight() + attributeHeight + marginForFields + (double)suppHeightBecauseOfShape);
        }
        this.dotStringFactory.openCluster(titleAndAttributeWidth, titleAndAttributeHeight, title, stereo, g);
        this.printEntities(g.getLeafsDirect());
        this.printAllSubgroups(g);
        this.dotStringFactory.closeCluster();
    }

    private Style getStyle(FontParam fontParam) {
        return fontParam.getStyleDefinition(SName.stateDiagram).getMergedStyle(this.diagram.getSkinParam().getCurrentStyleBuilder());
    }

    private void printEntities(Collection<ILeaf> entities) {
        for (ILeaf ent : entities) {
            if (ent.isRemoved()) continue;
            this.printEntity(ent);
        }
    }

    private void exportEntities(ST_Agraph_s g, Collection<ILeaf> entities) {
        for (ILeaf ent : entities) {
            if (ent.isRemoved()) continue;
            this.exportEntity(g, ent);
        }
    }

    private void exportEntity(ST_Agraph_s g, ILeaf leaf) {
        SvekNode node = this.dotStringFactory.getBibliotekon().getNode(leaf);
        if (node == null) {
            System.err.println("CANNOT FIND NODE");
            return;
        }
        ST_Agnode_s agnode = node__c.agnode(g, new CString(node.getUid()), true);
        attr__c.agsafeset(agnode, new CString("shape"), new CString("box"), new CString(""));
        String width = "" + node.getWidth() / 72.0;
        String height = "" + node.getHeight() / 72.0;
        attr__c.agsafeset(agnode, new CString("width"), new CString(width), new CString(""));
        attr__c.agsafeset(agnode, new CString("height"), new CString(height), new CString(""));
        this.nodes.put(leaf, agnode);
    }

    private void printEntity(ILeaf ent) {
        if (ent.isRemoved()) {
            throw new IllegalStateException();
        }
        IEntityImage image = this.printEntityInternal(ent);
        SvekNode node = this.getBibliotekon().createNode(ent, image, this.dotStringFactory.getColorSequence(), this.stringBounder);
        this.dotStringFactory.addNode(node);
    }

    private TextBlock getTitleBlock(IGroup g) {
        Display label = g.getDisplay();
        if (label == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        ISkinParam skinParam = this.diagram.getSkinParam();
        FontConfiguration fontConfiguration = g.getFontConfigurationForTitle(skinParam);
        return label.create(fontConfiguration, HorizontalAlignment.CENTER, skinParam);
    }

    private TextBlock getStereoBlock(IGroup g) {
        Stereotype stereotype = g.getStereotype();
        if (stereotype == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        TextBlock tmp = stereotype.getSprite(this.diagram.getSkinParam());
        if (tmp != null) {
            return tmp;
        }
        List<String> stereos = stereotype.getLabels(this.diagram.getSkinParam().guillemet());
        if (stereos == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        boolean show = this.diagram.showPortion(EntityPortion.STEREOTYPE, g);
        if (!show) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        FontParam fontParam = FontParam.PACKAGE_STEREOTYPE;
        return Display.create(stereos).create(new FontConfiguration(this.diagram.getSkinParam(), fontParam, stereotype), HorizontalAlignment.CENTER, this.diagram.getSkinParam());
    }

    private Collection<ILeaf> getUnpackagedEntities() {
        ArrayList<ILeaf> result = new ArrayList<ILeaf>();
        for (ILeaf ent : this.diagram.getLeafsvalues()) {
            if (this.diagram.getEntityFactory().getRootGroup() != ent.getParentContainer()) continue;
            result.add(ent);
        }
        return result;
    }

    private void printCluster(ST_Agraph_s g, Cluster cluster) {
        for (SvekNode node : cluster.getNodes()) {
            ST_Agnode_s agnode = node__c.agnode(g, new CString(node.getUid()), true);
            attr__c.agsafeset(agnode, new CString("shape"), new CString("box"), new CString(""));
            String width = "" + node.getWidth() / 72.0;
            String height = "" + node.getHeight() / 72.0;
            attr__c.agsafeset(agnode, new CString("width"), new CString(width), new CString(""));
            attr__c.agsafeset(agnode, new CString("height"), new CString(height), new CString(""));
            ILeaf leaf = this.dotStringFactory.getBibliotekon().getLeaf(node);
            this.nodes.put(leaf, agnode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageData createFile(OutputStream os, List<String> dotStrings, FileFormatOption fileFormatOption) throws IOException {
        lock.lock();
        try {
            ImageData imageData = this.createFileLocked(os, dotStrings, fileFormatOption);
            return imageData;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageData createFileLocked(OutputStream os, List<String> dotStrings, FileFormatOption fileFormatOption) throws IOException {
        for (ILeaf imageData : this.diagram.getLeafsvalues()) {
            this.printEntityNew(imageData);
        }
        Z.open();
        try {
            ST_Agraph_s g = graph__c.agopen(new CString("g"), Z.z().Agdirected, null);
            this.exportEntities(g, this.getUnpackagedEntities());
            this.exportGroups(g, this.diagram.getEntityFactory().getRootGroup());
            for (Link link : this.diagram.getLinks()) {
                ST_Agedge_s e = this.createEdge(g, link);
                if (e == null) continue;
                this.edges.put(link, e);
            }
            ST_GVC_s sT_GVC_s = gvc__c.gvContext(new Object[0]);
            SmetanaDebug.reset();
            gvlayout__c.gvLayoutJobs(sT_GVC_s, g);
            SmetanaDebug.printMe();
            MinMax minMax = TextBlockUtils.getMinMax(new Drawing(null, null), this.stringBounder, false);
            Drawing drawable = new Drawing(new YMirror(minMax.getMaxY()), minMax);
            ImageData imageData = this.diagram.createImageBuilder(fileFormatOption).drawable(drawable).write(os);
            return imageData;
        }
        catch (Throwable e) {
            SmetanaDebug.printMe();
            UmlDiagram.exportDiagramError(os, e, fileFormatOption, this.diagram.seed(), this.diagram.getMetadata(), this.diagram.getFlashData(), CucaDiagramFileMakerSmetana.getFailureText3(e));
            ImageData imageData = ImageDataSimple.error();
            return imageData;
        }
        finally {
            Z.close();
        }
    }

    private void exportGroups(ST_Agraph_s graph, IGroup parent) {
        for (IGroup g : this.diagram.getChildrenGroups(parent)) {
            if (g.isRemoved()) continue;
            if (this.diagram.isEmpty(g) && g.getGroupType() == GroupType.PACKAGE) {
                EntityFactory entityFactory = this.diagram.getEntityFactory();
                ILeaf folder = entityFactory.getLeafForEmptyGroup(g);
                this.exportEntity(graph, folder);
                continue;
            }
            this.exportGroup(graph, g);
        }
    }

    private void exportGroup(ST_Agraph_s graph, IGroup group) {
        Cluster cluster = this.getBibliotekon().getCluster(group);
        if (cluster == null) {
            System.err.println("CucaDiagramFileMakerJDot::exportGroup issue");
            return;
        }
        JUtils.LOG2("cluster = " + cluster.getClusterId());
        ST_Agraph_s cluster1 = subg__c.agsubg(graph, new CString(cluster.getClusterId()), true);
        if (cluster.isLabel()) {
            double width = cluster.getTitleAndAttributeWidth();
            double height = cluster.getTitleAndAttributeHeight() - 5;
            attr__c.agsafeset(cluster1, new CString("label"), Macro.createHackInitDimensionFromLabel((int)width, (int)height), new CString(""));
        }
        this.exportEntities(cluster1, group.getLeafsDirect());
        this.clusters.put(group, cluster1);
        this.exportGroups(cluster1, group);
    }

    private TextBlock getLabel(Link link) {
        double marginLabel = 1.0;
        ISkinParam skinParam = this.diagram.getSkinParam();
        FontConfiguration labelFont = new FontConfiguration(skinParam, FontParam.ARROW, null);
        TextBlock label = link.getLabel().create(labelFont, skinParam.getDefaultTextAlignment(HorizontalAlignment.CENTER), skinParam);
        if (TextBlockUtils.isEmpty(label, this.stringBounder)) {
            return label;
        }
        return TextBlockUtils.withMargin(label, 1.0, 1.0);
    }

    private TextBlock getQualifier(Link link, int n) {
        String tmp;
        String string = tmp = n == 1 ? link.getQualifier1() : link.getQualifier2();
        if (tmp == null) {
            return null;
        }
        double marginLabel = 1.0;
        ISkinParam skinParam = this.diagram.getSkinParam();
        FontConfiguration labelFont = new FontConfiguration(skinParam, FontParam.ARROW, null);
        TextBlock label = Display.getWithNewlines(tmp).create(labelFont, skinParam.getDefaultTextAlignment(HorizontalAlignment.CENTER), skinParam);
        if (TextBlockUtils.isEmpty(label, this.stringBounder)) {
            return label;
        }
        return TextBlockUtils.withMargin(label, 1.0, 1.0);
    }

    private ST_Agnode_s getAgnodeFromLeaf(IEntity entity) {
        ST_Agnode_s n = this.nodes.get(entity);
        if (n != null) {
            return n;
        }
        try {
            String id = this.getBibliotekon().getNodeUid((ILeaf)entity);
            for (Map.Entry<ILeaf, ST_Agnode_s> ent : this.nodes.entrySet()) {
                if (!id.equals(this.getBibliotekon().getNodeUid(ent.getKey()))) continue;
                return ent.getValue();
            }
        }
        catch (IllegalStateException e) {
            System.err.println("UNKNOWN ENTITY");
        }
        return null;
    }

    private ST_Agedge_s createEdge(ST_Agraph_s g, Link link) {
        TextBlock q2;
        TextBlock q1;
        ST_Agnode_s n = this.getAgnodeFromLeaf(link.getEntity1());
        ST_Agnode_s m = this.getAgnodeFromLeaf(link.getEntity2());
        if (n == null) {
            return null;
        }
        if (m == null) {
            return null;
        }
        ST_Agedge_s e = edge__c.agedge(g, n, m, null, true);
        attr__c.agsafeset(e, new CString("arrowtail"), new CString("none"), new CString(""));
        attr__c.agsafeset(e, new CString("arrowhead"), new CString("none"), new CString(""));
        int length = link.getLength();
        attr__c.agsafeset(e, new CString("minlen"), new CString("" + (length - 1)), new CString(""));
        TextBlock label = this.getLabel(link);
        if (!TextBlockUtils.isEmpty(label, this.stringBounder)) {
            Dimension2D dimLabel = label.calculateDimension(this.stringBounder);
            CString hackDim = Macro.createHackInitDimensionFromLabel((int)dimLabel.getWidth(), (int)dimLabel.getHeight());
            attr__c.agsafeset(e, new CString("label"), hackDim, new CString(""));
        }
        if ((q1 = this.getQualifier(link, 1)) != null) {
            Dimension2D dimLabel = q1.calculateDimension(this.stringBounder);
            CString hackDim = Macro.createHackInitDimensionFromLabel((int)dimLabel.getWidth(), (int)dimLabel.getHeight());
            attr__c.agsafeset(e, new CString("taillabel"), hackDim, new CString(""));
        }
        if ((q2 = this.getQualifier(link, 2)) != null) {
            Dimension2D dimLabel = q2.calculateDimension(this.stringBounder);
            CString hackDim = Macro.createHackInitDimensionFromLabel((int)dimLabel.getWidth(), (int)dimLabel.getHeight());
            attr__c.agsafeset(e, new CString("headlabel"), hackDim, new CString(""));
        }
        return e;
    }

    private static List<String> getFailureText3(Throwable exception) {
        exception.printStackTrace();
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("An error has occured : " + exception);
        String quote = StringUtils.rot(QuoteUtils.getSomeQuote());
        strings.add("<i>" + quote);
        strings.add(" ");
        GraphvizCrash.addProperties(strings);
        strings.add(" ");
        strings.add("Sorry, the subproject Smetana is not finished yet...");
        strings.add(" ");
        strings.add("You should send this diagram and this image to <b>plantuml@gmail.com</b> or");
        strings.add("post to <b>http://plantuml.com/qa</b> to solve this issue.");
        strings.add(" ");
        return strings;
    }

    private void printEntityNew(ILeaf ent) {
        if (ent.isRemoved()) {
            System.err.println("Jdot STRANGE: entity is removed");
            return;
        }
        IEntityImage image = this.printEntityInternal(ent);
        SvekNode shape = this.getBibliotekon().createNode(ent, image, this.dotStringFactory.getColorSequence(), this.stringBounder);
    }

    private Bibliotekon getBibliotekon() {
        return this.dotStringFactory.getBibliotekon();
    }

    private IEntityImage printEntityInternal(ILeaf ent) {
        if (ent.isRemoved()) {
            throw new IllegalStateException();
        }
        if (ent.getSvekImage() == null) {
            ISkinParam skinParam = this.diagram.getSkinParam();
            if (skinParam.sameClassWidth()) {
                System.err.println("NOT YET IMPLEMENED");
            }
            return GeneralImageBuilder.createEntityImageBlock(ent, skinParam, this.diagram.isHideEmptyDescriptionForState(), this.diagram, this.getBibliotekon(), null, this.diagram.getUmlDiagramType(), this.diagram.getLinks());
        }
        return ent.getSvekImage();
    }

    class Drawing
    extends AbstractTextBlock
    implements TextBlockBackcolored {
        private final YMirror ymirror;
        private final MinMax minMax;

        public Drawing(YMirror ymirror, MinMax minMax) {
            this.ymirror = ymirror;
            this.minMax = minMax;
        }

        @Override
        public void drawU(UGraphic ug) {
            if (this.minMax != null) {
                ug = ug.apply(new UTranslate(6.0 - this.minMax.getMinX(), 6.0));
            }
            for (Map.Entry ent : CucaDiagramFileMakerSmetana.this.clusters.entrySet()) {
                CucaDiagramFileMakerSmetana.this.drawGroup(ug, this.ymirror, (IGroup)ent.getKey(), (ST_Agraph_s)ent.getValue());
            }
            for (Map.Entry ent : CucaDiagramFileMakerSmetana.this.nodes.entrySet()) {
                ILeaf leaf = (ILeaf)ent.getKey();
                ST_Agnode_s agnode = (ST_Agnode_s)ent.getValue();
                Point2D corner = this.getCorner(agnode);
                SvekNode node = CucaDiagramFileMakerSmetana.this.dotStringFactory.getBibliotekon().getNode(leaf);
                IEntityImage image = node.getImage();
                image.drawU(ug.apply(new UTranslate(corner)));
            }
            for (Map.Entry ent : CucaDiagramFileMakerSmetana.this.edges.entrySet()) {
                Link link = (Link)ent.getKey();
                if (link.isInvis()) continue;
                ST_Agedge_s edge = (ST_Agedge_s)ent.getValue();
                new SmetanaPath(link, edge, this.ymirror, CucaDiagramFileMakerSmetana.this.diagram, CucaDiagramFileMakerSmetana.this.getLabel(link), CucaDiagramFileMakerSmetana.this.getQualifier(link, 1), CucaDiagramFileMakerSmetana.this.getQualifier(link, 2)).drawU(ug);
            }
        }

        @Override
        public Dimension2D calculateDimension(StringBounder stringBounder) {
            if (this.minMax == null) {
                throw new UnsupportedOperationException();
            }
            return this.minMax.getDimension();
        }

        private Point2D getCorner(ST_Agnode_s n) {
            ST_Agnodeinfo_t data = (ST_Agnodeinfo_t)Macro.AGDATA(n);
            double width = data.width * 72.0;
            double height = data.height * 72.0;
            double x = data.coord.x;
            double y = data.coord.y;
            if (this.ymirror == null) {
                return new Point2D.Double(x - width / 2.0, y - height / 2.0);
            }
            return this.ymirror.getMirrored(new Point2D.Double(x - width / 2.0, y + height / 2.0));
        }

        @Override
        public HColor getBackcolor() {
            return null;
        }
    }
}

