/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag.core;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.ComponentStyle;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.USymbols;
import net.sourceforge.plantuml.nwdiag.core.Network;
import net.sourceforge.plantuml.nwdiag.next.LinkedElement;
import net.sourceforge.plantuml.nwdiag.next.NBar;
import net.sourceforge.plantuml.skin.ActorStyle;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.PackageStyle;

public class NServer {
    private final Map<Network, String> connections = new LinkedHashMap<Network, String>();
    private USymbol shape = USymbols.RECTANGLE;
    private final String name;
    private String description;
    private final NBar bar;
    private boolean printFirstLink = true;

    public void doNotPrintFirstLink() {
        this.printFirstLink = false;
    }

    public final boolean printFirstLink() {
        return this.printFirstLink;
    }

    public Network getMainNetworkNext() {
        return this.connections.keySet().iterator().next();
    }

    public String getAdress(Network network) {
        return this.connections.get(network);
    }

    private TextBlock toTextBlock(String s, ISkinParam skinParam, SName sname) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        s = s.replace(", ", "\\n");
        return Display.getWithNewlines(s).create(this.getFontConfiguration(skinParam, sname), HorizontalAlignment.LEFT, skinParam);
    }

    private StyleSignatureBasic getStyleDefinition(SName sname) {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.nwdiagDiagram, sname);
    }

    private FontConfiguration getFontConfiguration(ISkinParam skinParam, SName sname) {
        StyleBuilder styleBuilder = skinParam.getCurrentStyleBuilder();
        Style style = this.getStyleDefinition(sname).getMergedStyle(styleBuilder);
        return style.getFontConfiguration(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
    }

    public LinkedElement getLinkedElement(double topMargin, Map<Network, String> conns, List<Network> networks, ISkinParam skinParam) {
        StyleBuilder styleBuilder = skinParam.getCurrentStyleBuilder();
        SymbolContext symbolContext = this.getStyleDefinition(SName.server).getMergedStyle(styleBuilder).getSymbolContext(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
        LinkedHashMap<Network, TextBlock> conns2 = new LinkedHashMap<Network, TextBlock>();
        for (Map.Entry<Network, String> ent : conns.entrySet()) {
            conns2.put(ent.getKey(), this.toTextBlock(ent.getValue(), skinParam, SName.arrow));
        }
        TextBlock desc = this.toTextBlock(this.getDescription(), skinParam, SName.server);
        TextBlock box = this.getShape().asSmall(TextBlockUtils.empty(0.0, 0.0), desc, TextBlockUtils.empty(0.0, 0.0), symbolContext, HorizontalAlignment.CENTER);
        return new LinkedElement(topMargin, this, box, conns2, networks);
    }

    public void connectTo(Network network) {
        this.connectTo(network, "");
    }

    public void connectTo(Network network, String address) {
        if (address == null) {
            address = "";
        }
        if (address.length() == 0 && this.connections.containsKey(network)) {
            return;
        }
        this.connections.put(network, address);
        if (this.bar.getStart() == null) {
            this.bar.addStage(network.getNstage());
        } else if (this.getMainNetworkNext() != network) {
            this.bar.addStage(network.getUp());
        }
    }

    public void updateProperties(Map<String, String> props) {
        String shape;
        String description = props.get("description");
        if (description != null) {
            this.setDescription(description);
        }
        if ((shape = props.get("shape")) != null) {
            this.setShape(shape);
        }
    }

    public final String toString() {
        return this.name;
    }

    public NServer(String name) {
        this(name, new NBar());
    }

    public NServer(String name, NBar bar) {
        this.description = name;
        this.name = name;
        this.bar = bar;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final String getName() {
        return this.name;
    }

    public final void setShape(String shapeName) {
        USymbol shapeFromString = USymbols.fromString(shapeName, ActorStyle.STICKMAN, ComponentStyle.RECTANGLE, PackageStyle.RECTANGLE);
        if (shapeFromString != null) {
            this.shape = shapeFromString;
        }
    }

    public final USymbol getShape() {
        return this.shape;
    }

    public final NBar getBar() {
        return this.bar;
    }
}

