/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram.command;

import java.util.List;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.descdiagram.command.CommandCreateElementFull;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.USymbols;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandCreateElementMultilines
extends CommandMultilines2<AbstractEntityDiagram> {
    private final int type;

    public CommandCreateElementMultilines(int type) {
        super(CommandCreateElementMultilines.getRegexConcat(type), MultilinesStrategy.REMOVE_STARTING_QUOTE);
        this.type = type;
    }

    @Override
    public String getPatternEnd() {
        if (this.type == 0) {
            return "^(.*)[%g]$";
        }
        if (this.type == 1) {
            return "^([^\\[\\]]*)\\]$";
        }
        throw new IllegalArgumentException();
    }

    private static RegexConcat getRegexConcat(int type) {
        if (type == 0) {
            return RegexConcat.build(CommandCreateElementMultilines.class.getName() + type, RegexLeaf.start(), new RegexLeaf("TYPE", "(person|artifact|actor/|actor|folder|card|file|package|rectangle|hexagon|label|node|frame|cloud|database|queue|stack|storage|agent|usecase/|usecase|component|boundary|control|entity|interface|circle|collections|port|portin|portout)[%s]+"), new RegexLeaf("CODE", "([%pLN_.]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<\\<.+\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("as"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("[%g]"), new RegexLeaf("DESC", "([^%g]*)"), RegexLeaf.end());
        }
        if (type == 1) {
            return RegexConcat.build(CommandCreateElementMultilines.class.getName() + type, RegexLeaf.start(), new RegexLeaf("TYPE", "(person|artifact|actor/|actor|folder|card|file|package|rectangle|hexagon|label|node|frame|cloud|database|queue|stack|storage|agent|usecase/|usecase|component|boundary|control|entity|interface|circle|collections|port|portin|portout)[%s]+"), new RegexLeaf("CODE", "([%pLN_.]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<\\<.+\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\["), new RegexLeaf("DESC", "(.*)"), RegexLeaf.end());
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected CommandExecutionResult executeNow(AbstractEntityDiagram diagram, BlocLines lines) throws NoSuchColorException {
        String urlString;
        Ident code;
        USymbol usymbol;
        LeafType type;
        lines = lines.trimSmart(1);
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        String symbol = StringUtils.goUpperCase(line0.get("TYPE", 0));
        if (symbol.equalsIgnoreCase("usecase")) {
            type = LeafType.USECASE;
            usymbol = null;
        } else {
            usymbol = USymbols.fromString(symbol, diagram.getSkinParam().actorStyle(), diagram.getSkinParam().componentStyle(), diagram.getSkinParam().packageStyle());
            if (usymbol == null) {
                throw new IllegalStateException();
            }
            type = LeafType.DESCRIPTION;
        }
        String idShort = line0.get("CODE", 0);
        List<String> lineLast = StringUtils.getSplit(MyPattern.cmpile(this.getPatternEnd()), lines.getLast().getTrimmed().getString());
        lines = lines.subExtract(1, 1);
        Display display = lines.toDisplay();
        String descStart = line0.get("DESC", 0);
        if (StringUtils.isNotEmpty(descStart)) {
            display = display.addFirst(descStart);
        }
        if (StringUtils.isNotEmpty(lineLast.get(0))) {
            display = display.add(lineLast.get(0));
        }
        String stereotype = line0.get("STEREO", 0);
        Ident ident = diagram.buildLeafIdent(idShort);
        Code code2 = code = diagram.V1972() ? ident : diagram.buildCode(idShort);
        if (CommandCreateElementFull.existsWithBadType3(diagram, code, ident, type, usymbol)) {
            return CommandExecutionResult.error("This element (" + code.getName() + ") is already defined");
        }
        ILeaf result = diagram.createLeaf(ident, code, display, type, usymbol);
        if (result == null) {
            return CommandExecutionResult.error("This element (" + code.getName() + ") is already defined");
        }
        result.setUSymbol(usymbol);
        if (stereotype != null) {
            result.setStereotype(Stereotype.build(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        if ((urlString = line0.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            result.addUrl(url);
        }
        Colors colors = CommandCreateElementMultilines.color().getColor(diagram.getSkinParam().getThemeStyle(), line0, diagram.getSkinParam().getIHtmlColorSet());
        result.setColors(colors);
        return CommandExecutionResult.ok();
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    static enum Mode {
        EXTENDS,
        IMPLEMENTS;

    }
}

