/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.command;

import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.command.Command;
import net.sourceforge.plantuml.creole.legacy.StripeSimple;

public class CommandCreoleUrl
implements Command {
    private static final Pattern2 pattern = MyPattern.cmpile("^(" + UrlBuilder.getRegexp() + ")");

    @Override
    public String startingChars() {
        return "[";
    }

    public static Command create() {
        return new CommandCreoleUrl();
    }

    private CommandCreoleUrl() {
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m = pattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m = pattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        UrlBuilder urlBuilder = new UrlBuilder(stripe.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
        Url url = urlBuilder.getUrl(m.group(1));
        stripe.addUrl(url);
        return line.substring(m.group(1).length());
    }
}

