/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.gtile.AbstractGtile;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorNone;

public class GtileCircleStart
extends AbstractGtile {
    private static final int SIZE = 20;
    private final HColor backColor;
    private double shadowing;

    private StyleSignatureBasic getDefaultStyleDefinitionCircle() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.circle);
    }

    public GtileCircleStart(StringBounder stringBounder, ISkinParam skinParam, HColor backColor, Swimlane swimlane) {
        super(stringBounder, skinParam, swimlane);
        this.backColor = backColor;
        if (UseStyle.useBetaStyle()) {
            Style style = this.getDefaultStyleDefinitionCircle().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
            this.shadowing = style.value(PName.Shadowing).asDouble();
        } else if (this.skinParam().shadowing(null)) {
            this.shadowing = 3.0;
        }
    }

    @Override
    protected void drawUInternal(UGraphic ug) {
        UEllipse circle = new UEllipse(20.0, 20.0);
        circle.setDeltaShadow(this.shadowing);
        ug.apply(new HColorNone()).apply(this.backColor.bg()).draw(circle);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(20.0, 20.0);
    }
}

